#ifndef INCLUDED_VSD_
#define INCLUDED_VSD_

#include <iosfwd>

#include "../enums/enums.h"
#include "../spread/spread.h"

class VSD: public Spread
{
    friend std::istream &operator>>(std::istream &in, VSD &vsd);

    double d_configValue = 0;
    double d_value = 0;
    
    double d_spread = 0;
    uint16_t d_dist = NO_DIST;          // only recognizes Normal

    public:
        void refresh();
        
        double value() const;
        double spread() const;
        uint16_t dist() const;

    private:
};

inline void VSD::refresh()
{
    d_value = Spread::refresh(d_configValue, d_spread, d_dist);
}

inline double VSD::value() const
{
    return d_value;
}

inline double VSD::spread() const
{
    return d_spread;
}
    
inline uint16_t VSD::dist() const
{
    return d_dist;
}
        
std::istream &operator>>(std::istream &in, VSD &vsd);

#endif

