//#define XERR
#include "analysis.ih"

void Analysis::alterOptions(Parser::OptionsVect const &specs)
{
    auto &options = Options::instance();

    for (auto const &spec: specs)
    {
        bool changed = false;

        for (auto const *ptr = g_longOpts; ptr != g_longEnd; ++ptr)
        {
            string const &name = ptr->longName();
    
            if (name == spec.name)                  // found the name
            {
                options.alter(ptr->optionChar(), spec.value);
                changed = true;
                break;                              // done with this option
            }
        }

        if (not changed)
            wmsg << "ignored analysis option specification " << spec.name <<
                    " (line " << spec.lineNr << ')' << endl;
    }

    options.inspect();
}

