#ifndef INCLUDED_MAMMO_
#define INCLUDED_MAMMO_

#include "../enums/enums.h"
#include "../modbase/modbase.h"
#include "../specificity/specificity.h"

//Modalities:
//
//  Mammo:
//      costs:          64   
//
//      #      bi-rad:  a       b       c       d             
//      dose:           3       3       3       3  
//
//      #             ageGroup
//      specificity:  0 - 40:  .961     40 - *: .965
//
//      #       1       2       3        4       m
//      beta:  -4.38    .49     -1.34    -7.18   .136
//
//      systematicError:  0.1


class Tumor;

class Mammo: public ModBase
{
    Tumor const &d_tumor;

    StringVect d_base;

    double d_dose[N_BIRADS];
    SpecificityVect d_specVect;

    double d_beta[5];               // 5th value is m
    double d_sysErr;

    public:
        Mammo(Tumor const &tumor);
        ~Mammo() override;

    private:
        void doseHandler();
        void betaHandler();
        void setSystematicError();

        void insertBeta(std::ostream &out, size_t begin, size_t end) const;

        double const *vDose() const override;               // 1
        double vDose(uint16_t) const override;              // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;

};

#endif
