"""
    gestion.urls, un module pour SLM
    - définitions des URLs

    Copyright (C) 2023 Georges Khaznadar <georgesk@debian.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from django.urls import path, re_path
from . import views
from . import views_download
from. import odfviews
from . import views_stats
from . import ajaxviews

urlpatterns = [
    path('', views.index, name='index'),
    path('index', views.index, name='index'),
    path('jsi18n', views.jsi18n, name='index'),
    path('prets', views.prets, name='prets'),
    path('prets_go', ajaxviews.prets_go, name='prets_go'),
    path('prete_livre', ajaxviews.prete_livre, name='prete_livre'),
    path('tableau_prets', ajaxviews.tableau_prets, name='tableau_prets'),
    path('tableau_retours', ajaxviews.tableau_retours, name='tableau_retours'),
    path('prets_mkPDF', views_download.prets_mkPDF, name='prets_mkPDF'),
    path('avenant_mkPDF', views_download.avenant_mkPDF, name='avenant_mkPDF'),
    path('correspondance_nom', ajaxviews.correspondance_nom,
         name='correspondance_nom'),
    path('correspondance_classe', ajaxviews.correspondance_classe,
         name='correspondance_classe'),
    path('correspondance_livre', ajaxviews.correspondance_livre,
         name='correspondance_livre'),
    path('stats', views.stats, name='stats'),
    path('classe', ajaxviews.classe, name='classe'),
    path('liste_manuels', ajaxviews.liste_manuels, name='liste_manuels'),
    path('achats_inventaire', views.achats_inventaire,
         name='achats_inventaire'),
    path('inventaire', views.inventaire, name='inventaire'),
    path('inventaire_non_pretes_premiers', ajaxviews.inventaire_non_pretes_premiers,
         name='inventaire_non_pretes_premiers'),
    path('inventaire_pretes_premiers', ajaxviews.inventaire_pretes_premiers,
         name='inventaire_pretes_premiers'),
    path('inventaire_non_pretes_suivants', ajaxviews.inventaire_non_pretes_suivants,
         name='inventaire_non_pretes_suivants'),
     path('inventaire_pretes_suivants', ajaxviews.inventaire_pretes_suivants,
          name='inventaire_pretes_suivants'),
    path('aqui', ajaxviews.aqui, name='aqui'),
    path('parametres', views.parametres, name='parametres'),
    path('inventaire', views.inventaire, name='inventaire'),
    path('apropos', views.apropos, name='apropos'),
    path('assistance', views.assistance, name='assistance'),
    path('constantes', views.constantes, name='constantes'),
    path('constantes_del', ajaxviews.constantes_del, name='constantes_del'),
    path('constantes_modif', views.constantes_modif,
         name='constantes_modif'),
    path('catalogue', views.catalogue, name='catalogue'),
    path('catalogue_del', ajaxviews.catalogue_del, name='catalogue_del'),
    path('catalogue_modif', views.catalogue_modif, name='catalogue_modif'),
    path('catalogue_print', views_download.catalogue_print,
         name='catalogue_print'),
    path('purger_prets', views.purger_prets, name='purger_prets'),
    path('purger_prets_premiers', ajaxviews.purger_prets_premiers,
         name='purger_prets_premiers'),
    path('purger_prets_suivants', ajaxviews.purger_prets_suivants,
         name='purger_prets_suivants'),
    path('purger_prets_go', ajaxviews.purger_prets_go, name='purger_prets_go'),
    path('siecle', views.siecle, name='siecle'),
    path('eleves', views.eleves, name='eleves'),
    path('cartes', views.cartes, name='cartes'),
    path('bon_de_commande', views.bon_de_commande, name='bon_de_commande'),
    path('tarif', views.tarif, name='tarif'),
    path('codes_barres', views.codes_barres, name='codes_barres'),
    path('codes_barres_print', views.codes_barres_print,
         name='codes_barres_print'),
    path('codes_barres_print_go', ajaxviews.codes_barres_print_go,
         name='codes_barres_print_go'),
    path('codes_barres_preview', ajaxviews.codes_barres_preview,
         name='codes_barres_preview'),
    path('cartes_membres_print', views.cartes_membres_print,
         name='cartes_membres_print'),
    path('cartes_membres_print_go', ajaxviews.cartes_membres_print_go,
         name='cartes_membres_print_go'),
    path('cartes_membres_print_verso', views.cartes_membres_print_verso,
         name='cartes_membres_print_verso'),
    path('cartes_membres_print_verso_go', ajaxviews.cartes_membres_print_verso_go,
         name='cartes_membres_print_verso_go'),
    path('fiches_suivi_print_go', ajaxviews.fiches_suivi_print_go,
         name='fiches_suivi_print_go'),
    path('retours', views.retours, name='retours'),
    path('rend_livre', ajaxviews.rend_livre, name='rend_livre'),
    path('annule_retour', ajaxviews.annule_retour, name='annule_retour'),
    path('change_etat_manuel_rendu', ajaxviews.change_etat_manuel_rendu,
         name='change_etat_manuel_rendu'),
    path('traite_perte', ajaxviews.traite_perte, name='traite_perte'),
    path('sauvegarde', views.sauvegarde, name='sauvegarde'),
    path('saveDB', views_download.saveDB, name='saveDB'),
    path('eleves_pretes_premiers', ajaxviews.eleves_pretes_premiers,
         name='eleves_pretes_premiers'),
    path('eleves_pretes_suivants', ajaxviews.eleves_pretes_suivants,
         name='eleves_pretes_suivants'),
    path('eleves_sans_prets_premiers', ajaxviews.eleves_sans_prets_premiers,
         name='eleves_sans_prets_premiers'),
    path('eleves_sans_prets_suivants', ajaxviews.eleves_sans_prets_suivants,
         name='eleves_sans_prets_suivants'),
    path('messages_modif', views.messages_modif, name='messages_modif'),
    path('messages_del', ajaxviews.messages_del, name='messages_del'),
    path('donnees_utilisateur', views.donnees_utilisateur,
         name='donnees_utilisateur'),
    path('importeFromGemaSCO', views.importeFromGemaSCO,
         name='importeFromGemaSCO'),
    path('RAZmodele', ajaxviews.RAZmodele, name='RAZmodele'),
    path('importeCSV', ajaxviews.importeCSV, name='importeCSV'),
    path('imprime_restitution', views_download.imprime_restitution,
         name='imprime_restitution'),
    path('imprime_memoire', views_download.imprime_memoire,
         name='imprime_memoire'),
    path('inscription_provisoire', views.inscription_provisoire,
         name='inscription_provisoire'),
    path('invite_inscription_provisoire', views.invite_inscription_provisoire,
         name='invite_inscription_provisoire'),
    path('doublonsSLM', ajaxviews.doublonsSLM, name='doublonsSLM'),
    path('effaceEleve', ajaxviews.effaceEleve, name='effaceEleve'),
    path('sortieParSiecle', ajaxviews.sortieParSiecle,
         name='sortieParSiecle'),
    path('sortieParSiecle_msg', ajaxviews.sortieParSiecle_msg,
         name='sortieParSiecle_msg'),
    path('importeSiecle', ajaxviews.importeSiecle, name='importeSiecle'),
    path('nouveaux_sortants_modifier', ajaxviews.nouveaux_sortants_modifier,
         name='nouveaux_sortants_modifier'),
    path('tableauSortantsPasAjour', odfviews.tableauSortantsPasAjour,
         name='tableauSortantsPasAjour'),
    path('modificationParSiecle', ajaxviews.modificationParSiecle,
         name='modificationParSiecle'),
    path('modificationParSiecle_msg', ajaxviews.modificationParSiecle_msg,
         name='modificationParSiecle_msg'),
    path('entreeParSiecle', ajaxviews.entreeParSiecle, name='entreeParSiecle'),
    path('entreeParSiecle_msg', ajaxviews.entreeParSiecle_msg,
         name='entreeParSiecle_msg'),
    path('cahier_cautions', views_download.cahier_cautions, name='cahier_cautions'),
    path('print_etat_classe', views.print_etat_classe,
         name='print_etat_classe'),
    path('livres_pour', views.livres_pour, name='livres_pour'),
    path('listes_eleves', views_download.listes_eleves, name='listes_eleves'),
    path('classe_pour_prets', ajaxviews.classe_pour_prets,
         name='classe_pour_prets'),
    path('classe_pour_retours', ajaxviews.classe_pour_retours,
         name='classe_pour_retours'),
    path('nouvelle_caution', ajaxviews.nouvelle_caution,
         name='nouvelle_caution'),
    path('ancienne_caution', ajaxviews.ancienne_caution,
         name='ancienne_caution'),
    path('ancienne_caution_msg', ajaxviews.ancienne_caution_msg,
         name='ancienne_caution_msg'),
    path('fin_caution', ajaxviews.fin_caution, name='fin_caution'),
    path('annule_caution', ajaxviews.annule_caution, name='annule_caution'),
    path('annule_caution_msg', ajaxviews.annule_caution_msg,
         name='annule_caution_msg'),
    path('commente_caution', ajaxviews.commente_caution,
         name='commente_caution'),
    path('cautions', views.cautions, name='cautions'),
    path('affiche_caution_eleve', ajaxviews.affiche_caution_eleve,
         name='affiche_caution_eleve'),
    path('cautions_classe', ajaxviews.cautions_classe, name='cautions_classe'),
    path('maj_caution', ajaxviews.maj_caution, name='maj_caution'),
    path('print_eleves_sans_livres', odfviews.print_eleves_sans_livres,
         name='print_eleves_sans_livres'),
    path('print_eleves_avec_livres', odfviews.print_eleves_avec_livres,
         name='print_eleves_avec_livres'),
    path('unifier_siecle', ajaxviews.unifier_siecle, name='unifier_siecle'),
    path('revue_du_stock', views.revue_du_stock, name='revue_du_stock'),
    path('revue', ajaxviews.revue, name='revue'),
    path('au_pilon', ajaxviews.au_pilon, name='au_pilon'),
    path('au_pilon_msg', ajaxviews.au_pilon_msg, name='au_pilon_msg'),
    path('eleve_scan', views.eleve_scan, name='eleve_scan'),
    path('eleve_invite', views.eleve_invite, name='eleve_invite'),
    path('boutique', views.boutique, name='boutique'),
    path('jeton_perime', views.jeton_perime, name='jeton_perime'),
    path('moisson', views.moisson, name='moisson'),
    path('mes_livres_en_boutique', ajaxviews.mes_livres_en_boutique,
         name='mes_livres_en_boutique'),
    path('correlation', views.correlation, name='correlation'),
    path('correlation_code', views.correlation_code, name='correlation_code'),
    path('correlation_options_livres', views_stats.correlation_options_livres,
         name='correlation_options_livres'),
    path('qr_boutique_print_go', ajaxviews.qr_boutique_print_go,
         name='qr_boutique_print_go'),
    path('qr_boutique', views.qr_boutique, name='qr_boutique'),
    path('prof_livre_invite', views.prof_livre_invite,
         name='prof_livre_invite'),
    path('livre_supplement', views.livre_supplement, name='livre_supplement'),
    path('plus_livre_supplement', ajaxviews.plus_livre_supplement,
         name='plus_livre_supplement'),
    path('plus_nomprenom_supplement', ajaxviews.plus_nomprenom_supplement,
         name='plus_nomprenom_supplement'),
    path('livre_supplement_go', views.livre_supplement_go,
         name='livre_supplement_go'),
    path('findLivreSupplement', ajaxviews.findLivreSupplement,
         name='findLivreSupplement'),
    path('valide_livre_supplement_go', ajaxviews.valide_livre_supplement_go,
         name='valide_livre_supplement_go'),
    path('plus_classe_supplement', ajaxviews.plus_classe_supplement,
         name='plus_classe_supplement'),
    path('plus_classe_supplement_go', ajaxviews.plus_classe_supplement_go,
         name='plus_classe_supplement_go'),
    path('rend_caution', ajaxviews.rend_caution,
         name='rend_caution'),
    re_path(r"^verif_plan/(?P<filename>.*)", views.verif_plan,),
    re_path(r"^une_etiquette/(?P<numero>.*)", views.une_etiquette,),
    re_path(
        r"^une_etiquette_go/(?P<numero>[^/]*)/(?P<lig>[^/]*)/(?P<col>[^/]*)",
        ajaxviews.une_etiquette_go,),
    re_path(r"^eleves_plus_n/(?P<niveau>[^/]*)/(?P<nombre>.*)",
            views.eleves_plus_n,),
    re_path(r"^abreges/(?P<svgfile>.*)/(?P<multiplicateur>.*)", views.abreges,),
    path('langs', ajaxviews.langs, name='langs'),
    path('change_language', ajaxviews.change_language, name='change_language'),
    path('dropSiecle', ajaxviews.dropSiecle, name='dropSiecle'),
    path('message_nouveaux_sortants', ajaxviews.message_nouveaux_sortants,
         name='message_nouveaux_sortants'),
    path('montre_quasi_homonymes', ajaxviews.montre_quasi_homonymes,
         name='montre_quasi_homonymes'),
    path('prendre_un_livre_msg', ajaxviews.prendre_un_livre_msg,
         name='prendre_un_livre_msg'),
    path('repondre_abrege', ajaxviews.repondre_abrege, name='repondre_abrege'),
    path('nouveaux_livres_caption', ajaxviews.nouveaux_livres_caption,
         name='nouveaux_livres_caption'),
    path('pret_multiple_msg', ajaxviews.pret_multiple_msg,
         name='pret_multiple_msg'),
    path('button_codes_barres', ajaxviews.button_codes_barres,
         name='button_codes_barres'),
    path('notifSaveSuccess', ajaxviews.notifSaveSuccess,
         name='notifSaveSuccess'),
    path('makeImmobile_msg', ajaxviews.makeImmobile_msg,
         name='makeImmobile_msg'),
    path('commente_caution_msg', ajaxviews.commente_caution_msg,
         name='commente_caution_msg'),
]
