/*
 * Mimic the behaviour of xtprocadmin(8) without arguments.
 */
#include "basil_alps.h"

int main(int ac, char **av)
{
	enum basil_version version  = get_basil_version();
	struct basil_inventory *inv = get_full_inventory(version);
	struct basil_node *node;
	/* State/role names as used by xtprocadmin */
	const char *nodestate[BNS_MAX] = {
		[BNS_NONE]	= "UNDEFINED",
		[BNS_UP]	= "up",
		[BNS_DOWN]	= "down",
		[BNS_UNAVAIL]	= "unavail",
		[BNS_ROUTE]	= "route",
		[BNS_SUSPECT]	= "suspect",
		[BNS_ADMINDOWN]	= "admindown",
		[BNS_UNKNOWN]	= "UNKNOWN"
	};
	const char *noderole[BNR_MAX] = {
		[BNR_NONE]	= "UNDEFINED",
		[BNR_INTER]	= "interactive",
		[BNR_BATCH]	= "batch",
		[BNR_UNKNOWN]	= "UNKNOWN"
	};

	if (inv == NULL)
		err(1, "allocation of inventory data failed");

	printf("   NID    (HEX)    NODENAME     TYPE    STATUS        MODE\n");
	for (node = inv->f->node_head; node; node = node->next) {

		/* NB: Assuming that INVENTORY lists compute-nodes only */
		printf("%6u %#8x %11s %8s %9s %11s\n",
			node->node_id, node->node_id, node->name,
			"compute" ,
			nodestate[node->state], noderole[node->role]);
	}

	free_inv(inv);

	return EXIT_SUCCESS;
}
