(set! (*s7* 'heap-size) 1024000)
;(set! (*s7* 'gc-stats) 6)
;heap ca 30*size!

(define (reader)
  (let ((port (open-input-file "/home/bil/test/scheme/bench/src/bib"))
	(new-pos 0)
	(counts (make-hash-table)))
    (do ((line (read-line port) (read-line port)))
	((eof-object? line))
      (set! new-pos 0)
      (do ((pos (char-position #\space line) (char-position #\space line (+ pos 1))))
	  ((not pos))
	(unless (= pos new-pos)
	  (let* ((start (do ((k new-pos (+ k 1))) ; char-position here is slower!
			    ((or (char-alphabetic? (string-ref line k))
				 (= k pos))
			     k)))
		 (end (do ((k (- pos 1) (- k 1)))
			  ((or (char-alphabetic? (string-ref line k))
			       (= k start))
			   (+ k 1)))))
	    (when (> end start)
	      (let ((word (string->symbol (substring line start end))))
		(let ((refs (or (hash-table-ref counts word) 0)))
		  (hash-table-set! counts word (+ refs 1)))))))
	(set! new-pos (+ pos 1))))
    
    (close-input-port port)
    (sort! (copy counts (make-vector (hash-table-entries counts)))
	   (lambda (a b) (> (cdr a) (cdr b))))))

(format *stderr* "reader ")

(let ((counts (reader)))
  (if (not (and (eq? (car (counts 0)) 'the)
		(= (cdr (counts 0)) 62063)))
      (do ((i 0 (+ i 1))) 
	  ((= i 40)) 
	(format *stderr* "~A: ~A~%" (car (counts i)) (cdr (counts i))))))

;;; ----------------------------------------

(define symbols (make-vector 1))
(define strings (make-vector 1))

(define (test1 size)
  (let ((int-hash (make-hash-table size))
	(p (cons #f #f)))
    (do ((i 0 (+ i 1))) 
	((= i size))
      (hash-table-set! int-hash i i))
    (do ((i 0 (+ i 1)))	
	((= i size))
      (if (not (= (hash-table-ref int-hash i) i))
	  (display "oops")))
    (for-each (lambda (key&value)
		(if (not (= (car key&value) (cdr key&value)))
		    (display "oops"))) ;(format *stderr* "hash iter ~A~%" key&value)))
	      (make-iterator int-hash p))
    (set! int-hash #f)))

(define (test2 size)
  (let ((int-hash (make-hash-table size =)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (hash-table-set! int-hash i i))
    (do ((i 0 (+ i 1)))	
	((= i size))
      (if (not (= (hash-table-ref int-hash i) i))
	  (display "oops")))))

(define (test3 size)
  (let ((flt-hash (make-hash-table size)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (hash-table-set! flt-hash (* i 2.0) i))
    (do ((i 0 (+ i 1)))	
	((= i size))
      (if (not (= (hash-table-ref flt-hash (* 2.0 i)) i))
	  (display "oops")))))

(define (test4 size)
  (let ((sym-hash (make-hash-table size)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (hash-table-set! sym-hash (vector-set! symbols i (string->symbol (vector-set! strings i (number->string i)))) i))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (if (not (= (hash-table-ref sym-hash (vector-ref symbols i)) i)) 
	  (display "oops")))))

(define (test5 size)
  (let ((str-hash (make-hash-table size eq?)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (hash-table-set! str-hash (vector-ref strings i) i))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (if (not (= (hash-table-ref str-hash (vector-ref strings i)) i)) 
	  (display "oops")))))

(define (test6 size)
  (let ((sym-hash (make-hash-table size eq?)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (hash-table-set! sym-hash (vector-ref symbols i) i))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (if (not (= (hash-table-ref sym-hash (vector-ref symbols i)) i)) 
	  (display "oops")))))

(define (test7 size)
  (let ((chr-hash (make-hash-table 256)))
    (do ((i 0 (+ i 1))) 
	((= i 256)) 
      (hash-table-set! chr-hash (integer->char i) i))
    (do ((i 0 (+ i 1))) 
	((= i 256)) 
      (if (not (= (hash-table-ref chr-hash (integer->char i)) i))
	  (display "oops")))))

(define (test8 size)
  (let ((any-hash (make-hash-table size eq?)))
    (if (= size 1)
	(hash-table-set! any-hash (vector-set! strings 0 (list 0)) 0)
	(do ((i 0 (+ i 2))
	     (j 1 (+ j 2)))
	    ((= i size))
	  (hash-table-set! any-hash (vector-set! strings i (list i)) i)
	  (hash-table-set! any-hash (vector-set! strings j (int-vector j)) j)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (if (not (= i (hash-table-ref any-hash (vector-ref strings i))))
	  (display "oops")))))

(define (test9 size)
  (let ((any-hash1 (make-hash-table size eq?)))
    (if (= size 1)
	(hash-table-set! any-hash1 (vector-set! strings 0 (inlet 'a 0)) 0)
	(do ((i 0 (+ i 2))
	     (j 1 (+ j 2))
	     (x 0.0 (+ x 2.0)))
	    ((= i size))
	  (hash-table-set! any-hash1 (vector-set! strings i (inlet 'a i)) i)
	  (hash-table-set! any-hash1 (vector-set! strings j (float-vector x)) j)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (if (not (= i (hash-table-ref any-hash1 (vector-ref strings i))))
	  (display "oops")))
    (vector-fill! strings #f)))

(define (test10 size)
  (let ((cmp-hash (make-hash-table size)))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (hash-table-set! cmp-hash (complex i i) i))
    (do ((i 0 (+ i 1))) 
	((= i size)) 
      (if (not (= (hash-table-ref cmp-hash (complex i i)) i)) 
	  (display "oops")))))

(define (test-hash size)
  (format *stderr* "~D " size)
  (set! symbols (make-vector size))
  (set! strings (make-vector size))
  (test1 size)
  (test2 size)
  (test3 size)
  (test4 size)
  (test5 size)
  (test6 size)
  (test7 size)
  (test8 size)
  (test9 size)
  (test10 size))

(for-each test-hash (list 1 10 100 1000 10000 100000 1000000))
(newline)
;(gc)

#|
(load "write.scm")
(for-each (lambda (func)
	    (let ((source (procedure-source func)))
	      (let walker ((tree source))
		(when (pair? tree)
		  (if (symbol? (car tree))
		      (if (local-symbol? tree)
			  (set-car! tree (symbol "[" (symbol->string (car tree)) "]")))
		      (walker (car tree)))
		  (walker (cdr tree))))
	      (pretty-print source))
	    (newline))
	  (list reader test1 test2 test3 test4 test5 test6 test7 test8 test9 test10))
|#

(s7-version)
(exit)
