(define size 1000000)
(set! (*s7* 'safety) -1)
(set! (*s7* 'heap-size) (* 4 1024000))

(define symbols (make-vector size 'a symbol?))
(define e (inlet))

(define (make-symbols)
  (do ((i 0 (+ i 1)))
      ((= i size))
    (vector-set! symbols i (symbol "a-" (number->string i)))
    (varlet e (vector-ref symbols i) i)))
(make-symbols)

(define (add)
  (let ((sum 0))
    (do ((i 0 (+ i 1)))
	((= i size))
      (set! sum (+ sum (let-ref e (vector-ref symbols i)))))
    sum))

(define (subtract)
  (let ((sum 0))
    (do ((i (- size 1) (- i 1)))
	((= i 0))
      (set! sum (- sum (let-ref e (vector-ref symbols i)))))
    sum))

(define (whatever)
  (let ((sum 0))
    (do ((i 0 (+ i 1)))
	((= i size))
      (set! sum (+ sum (let-ref e (vector-ref symbols (random i))))))
    sum))

(format *stderr* "~A ~A ~A ~A~%" (/ (- (* size size) size) 2) (add) (subtract) (whatever))

(define (in-e)
  (with-let (sublet e :symbols symbols)
    (let ((sum1 0.0)
	  (sum2 0.0)
	  (sum3 0.0))
      (do ((i 0 (+ i 1)))
	  ((= i size))
	(set! sum1 (+ sum1 (symbol->value (vector-ref symbols i))))
	(set! sum2 (- sum2 (symbol->value (vector-ref symbols i))))
	(set! sum3 (+ sum3 (symbol->value (vector-ref symbols (random i))))))
      (format *stderr* "~A ~A ~A ~A~%" (/ (- (* size size) size) 2) sum1 sum2 sum3))))
(in-e)
