1.1 Kodowanie na żywo

# Kodowanie na żywo

Jednym z najbardziej ekscytujących aspektów Sonic Pi jest to, że pozwala Ci na 
pisanie i *modyfikację kodu na żywo* aby tworzyć muzykę w czasie rzeczywistym, 
tak samo jak w momencie gdy grasz na żywo na gitarze. Oznacza to, że dzięki odpowiednim 
ćwiczeniom możesz wykorzytać Sonic Pi do koncertów przed publicznością na żywo.

## Uwolnij swój umysł

Zanim przejdziemy do dalszej części samouczka i zaczniemy zgłębiać szczegóły 
tego w jaki sposób działa Sonic Pi, chciałbym abyś mógł przez chwilę poczuć 
czym jest Live Coding (kodowanie na żywo). Nie przejmuj się, jeśli nic nie zrozumiesz 
z tego co zobaczysz i zrobisz za chwilę. Po prostu usiądź wygodnie, zapnij pasy 
i poczuj radość...

## Żywa Pętla

Zacznijmy od skopiowania następującego kawałka kodu do pustego buforu powyżej: 

```
live_loop :flibble do
  sample :bd_haus, rate: 1
  sleep 0.5
end
```

Teraz nacisnij przycisk `Run` a usłyszysz fajne i szybkie 
uderzenia bębna. W każdym momencie możesz zatrzymać dźwięk naciskając 
przycisk `Stop `. Aczkolwiek nie rób tego jeszcze... Zamiast tego wykonaj 
następujące kroki: 

1. Upewnij się, że wciąż słyszysz dźwięk uderzającego bębna.
2. Zmień wartość znajdującą się przy poleceniu `sleep` z wartości `0.5' na 
większą, np. 1.
3. Ponownie naciśnij przycisk `Run`
4. Zauważ jak zmieniła się szybkość uderzeń bębna.
5. *Zapamiętaj ten moment*, gdyż jest to twój pierwszy raz (i prawdopobnie 
  nie ostatni), kiedy kodujesz na żywo używając Sonic Pi...

OK, to było dosyć łatwe. Dodajmy do naszego miksu coś innego. Powyżej 
linii `sample :bd_haus` dodaj linijkę `sample :ambi_choir, rate: 0.3`. Twój kod 
powinien teraz wyglądać następująco:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
  sample :bd_haus, rate: 1
  sleep 1
end
```

A teraz czas na zabawę. Zacznij zmieniać liczby - co się stanie gdy użyjesz 
dużych wartości, co się stanie gdy użyjesz małych lub ujemnych liczb? 
Spróbuj zobaczyć co się stanie gdy zmienisz wartość parametru `rate:` dla 
sampla `:ambi_choir` tylko odrobinę (np. na 0.29). Co się stanie jeśli 
wybierzesz naprawdę małą wartość dla parametru `sleep`? Zobacz, czy uda Ci się 
uruchomić powyższą pętlę tak szybko, że twój komputer zatrzyma się z powodu błedu, 
gdyż nie będzie w stanie nadążyć (jeśli to się zdarzy, po prostu wybierz 
większa wartość dla parametru `sleep` i ponownie naciśnij przycisk `Run`).

Spróbuj zrobić komentarz w jednej z linii zawierających `sample` dodając na 
początku linii znak `#`, np.:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
  sleep 1
end

```

Zauważ, że dodanie znaku `#` na początku linii mówi komputerowi aby zignorował 
daną linię, dzięki czemu jej nie słyszymy. Taką linijkę nazywamy komentarzem. 
W Sonic Pi możemy używać komentarzy do usuwania i dodawania różnych rzeczy do 
naszej muzyki.

Na koniec pozwól, że pozostawię Ci do zabawy coś fajnego. Spójrz na kod poniżej 
i skopiuj go do wolnego i pustego bufora. Teraz, nie próbuj 
zrozumieć nic więcej niż to, że w tym kodzie są dwie pętle (`live_loop`). Oznacza to, 
że w tym samym czasie dzieją się dwie rzeczy. Teraz, rób to co umiesz najlepiej 
- eksperymentuj i baw się próbując zmieniać ten kod. Oto kilka sugestii 
co możesz zrobić:

* Spróbuj zmienić wartości niebieskich wskaźników `rate:` aby usłyszeć zmianę 
  w dźwiękach poszczególnych sampli.
* Spróbuj zminiać wartości parametrów `sleep` dzięki czemu usłyszysz, że obie 
  pętle mogą kręcić się z różną szybkością.
* Spróbuj odkomentować linijkę z samplem (usuń znak `#`) a usłyszysz dźwięk 
  gitary granej od tyłu.
* Spróbuj zmieniać niebieską liczbę znajdującą się przy parametrze `mix:` 
  na wartości pomiędzy `0` (brak dźwięku w naszym utworze) a `1` (brzmienie 
  o normalnej głośności).

Pamiętaj aby wcisnąć przycisk `Run`. Dzięki temu usłyszysz zmianę przy kolejnym 
przebiegu pętli. Jeśli coś pójdzie nie tak i zacznie się kakofonia nie przejmuj 
się tym. Wystarczy, że naciśniesz przycisk `Stop`, usuniesz cały kod w buforze, 
wkleisz świeżą kopię poniższego kodu i jesteś znowu gotowy do improwizacji. Pamiętaj, 
człowiek najszybciej uczy się na błędach...

```
live_loop :guit do
  with_fx :echo, mix: 0.3, phase: 0.25 do
    sample :guit_em9, rate: 0.5
  end
#  sample :guit_em9, rate: -0.5
  sleep 8
end

live_loop :boom do
  with_fx :reverb, room: 1 do
    sample :bd_boom, amp: 10, rate: 1
  end
  sleep 8
end
```

Baw się i eksperymentuj tym kawałkiem kodu do momentu, w którym twoja ciekawość 
sprawi, że zaczniesz zastanawiać się jak to wszystko właściwie działa 
oraz co innego można jeszcze wyczarować za pomocą Sonic Pi. Jeśli ten moment 
już nastąpił to jesteś gotów aby przejść do dalszej części samouczka.

Więc na co czekasz...
