.\" Man page for willie
.TH Willie 1 "2013-15-01" "Linux" "Willie IRC Bot"

.SH NAME
willie - A highly customizable Internet Relay Chat bot

.SH SYNOPSIS
.\" Options to actually run / quit
.B willie
.RB [ \-q | \--quit ]
.RB [ \-k | \--kill ]
.RB [ \-d | \--fork ]
.RB [ \--quiet ]
.RB [ -c
.IR filename
.RB |  \--config=
.IR filename ]
.\" Options to configure or get help
.br
.B willie
.RB [ \-h | \--help ]
.br
.B willie
.RB [ \-m | \--migrate ]
.br
.B willie
.RB [ \-w | \--configure-all ]
.RB [ \--configure-modules ]
.RB [ \--configure-database ]

.SH DESCRIPTION
.B willie
runs a bot that provides some useful (and some useless) commands in one or more
Internet Relay Chat channels. It reads configuration options, such as the
network to connect to, channels to join, and more from a config file specified
by the 
.B -c
option. If no config file is specified,
.B ~/.willie/default.cfg
is used. If the configuration file being used does not exist, a brief
configuration wizard will be run to set up the basic options, and optionally set
up a database for user data and any modules that may need configuration.
.P
In most cases, simply running 
.B willie
will be sufficient; the bot will start after initial configuration, and will run
until it is told to quit through IRC.

.SH OPTIONS
.TP 5
\-h or --help
Show a brief summary of these options.
.TP
\-c
.IR filename
or --config=
.IR filename
.br
Run Willie with the configuration options from the specified file. An absolute
pathname can be given, or the name of a file within the configuration directory
may also be given.
.B ~/.willie
is the preferred location, but this and 
.B -c
will also look in 
.B ~/.jenni
and 
.B ~/.phenny
for legacy reasons. When the suffix of the file is
.B .cfg
, it may be omitted.
.TP
\-d or --fork
Run Willie in the background. The bot will safely run in the background, and can
later be killed with 
.B -q
or 
.B -d
\.
.TP
\-q or --quit
Gracefully quit a daemonized instance of Willie. This option determines the 
instance to quit by the name of the config file given by the 
.B -c
option, if used, so the same argument must be given with 
.B -c
when using 
.B -q.
.TP
\-k or --kill
Terminates a daemonized instance of Willie. This option determines the instance
to kill by the name of the config file given by the 
.B -c
option, if used, so the same argument must be given with 
.B -c
when using 
.B -k.
.TP
\-l or --list
List all config files found in the usual configuration file directories:
.B ~/.willie ~/.jenni
and 
.B ~/.phenny
.TP
\-m or --migrate
Attempt to migrate a configuration file for an older version of the bot to the 
new format. Versions prior to 3.1 used a configuration file written in Python,
which can be converted with this tool.
.TP
\--quiet
Suppress all output from the bot to the terminal.
.TP
\-w or --configure-all
Run the initial configuration wizard. This can be run with
.B -c
to configure a specified file, or without it to work on the default file.
.TP
\--configure-modules
Check for modules with configuration options, and allow the user to modify those
options. Changes will be added to the default file, or the file given to
.B -c
if used.
.TP
\--configure-database
Run a wizard for configuring the user information database options. Changes
will be added to the default file, or the file given to
.B -c
if used.
