/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_22 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4469, "epsg", 4469,
        "RGM04", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Mayotte_2004", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGM04\",DATUM[\"Reseau Geodesique de Mayotte 2");
    add_srs_wkt (p, 1,
        "004\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Mayotte");
    add_srs_wkt (p, 9,
        "\"],BBOX[-14.49,43.68,-11.33,46.7]],ID[\"EPSG\",4469]]");
    p = add_epsg_def_ex (filter, first, last, 4470, "epsg", 4470,
        "RGM04", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Mayotte_2004", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGM04\",DATUM[\"Reseau_Geodesique_de_Mayotte_20");
    add_srs_wkt (p, 1,
        "04\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1036\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4470\"]]");
    p = add_epsg_def_ex (filter, first, last, 4471, "epsg", 4471,
        "RGM04 / UTM zone 38S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Mayotte_2004", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGM04 / UTM zone 38S\",GEOGCS[\"RGM04\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_de_Mayotte_2004\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1036\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"44");
    add_srs_wkt (p, 6,
        "70\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",45");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4471\"]]");
    p = add_epsg_def_ex (filter, first, last, 4472, "epsg", 4472,
        "Cadastre 1997", 1, 1,
        "International 1924", "Greenwich",
        "Cadastre_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-381.788,-57.501,-256");
    add_proj4text (p, 1,
        ".673,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Cadastre 1997\",DATUM[\"Cadastre 1997\",ELLIPS");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,LENGTHUNIT[\"metr");
    add_srs_wkt (p, 2,
        "e\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 3,
        "174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic lati");
    add_srs_wkt (p, 4,
        "tude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433]],AXIS[\"geodetic longitude (Lon)\",east,ORD");
    add_srs_wkt (p, 6,
        "ER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"e");
    add_srs_wkt (p, 7,
        "llipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Mayotte - onshore\"");
    add_srs_wkt (p, 9,
        "],BBOX[-13.05,44.98,-12.61,45.35]],ID[\"EPSG\",4472]]");
    p = add_epsg_def_ex (filter, first, last, 4474, "epsg", 4474,
        "Cadastre 1997 / UTM zone 38S", 0, 0,
        "International 1924", "Greenwich",
        "Cadastre_1997", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,");
    add_proj4text (p, 1,
        "-262,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cadastre 1997 / UTM zone 38S\",GEOGCS[\"Cadastr");
    add_srs_wkt (p, 1,
        "e 1997\",DATUM[\"Cadastre_1997\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1037\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4475");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",45],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",500000],PARAMETER[\"false_northing\",10000000],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"5879\"]]");
    p = add_epsg_def_ex (filter, first, last, 4475, "epsg", 4475,
        "Cadastre 1997", 1, 1,
        "International 1924", "Greenwich",
        "Cadastre_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-381.788,-57.501,-256");
    add_proj4text (p, 1,
        ".673,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cadastre 1997\",DATUM[\"Cadastre_1997\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"1037\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4475\"]]");
    p = add_epsg_def_ex (filter, first, last, 4480, "epsg", 4480,
        "China Geodetic Coordinate System 2000", 1, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"China Geodetic Coordinate System 2000\",DATUM[");
    add_srs_wkt (p, 1,
        "\"China 2000\",ELLIPSOID[\"CGCS2000\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[");
    add_srs_wkt (p, 9,
        "\"China\"],BBOX[16.7,73.62,53.56,134.77]],ID[\"EPSG\",44");
    add_srs_wkt (p, 10,
        "80]]");
    p = add_epsg_def_ex (filter, first, last, 4482, "epsg", 4482,
        "Mexico ITRF92", 1, 1,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Mexico ITRF92\",DATUM[\"Mexico ITRF92\",ELLIPS");
    add_srs_wkt (p, 1,
        "OID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metr");
    add_srs_wkt (p, 2,
        "e\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 3,
        "174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic lati");
    add_srs_wkt (p, 4,
        "tude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433]],AXIS[\"geodetic longitude (Lon)\",east,ORD");
    add_srs_wkt (p, 6,
        "ER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"e");
    add_srs_wkt (p, 7,
        "llipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Mexico\"],BBOX[12.1");
    add_srs_wkt (p, 9,
        ",-122.19,32.72,-84.64]],ID[\"EPSG\",4482]]");
    p = add_epsg_def_ex (filter, first, last, 4483, "epsg", 4483,
        "Mexico ITRF92", 1, 1,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mexico ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4483\"]]");
    p = add_epsg_def_ex (filter, first, last, 4484, "epsg", 4484,
        "Mexico ITRF92 / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / UTM zone 11N\",GEOGCS[\"Mexico ");
    add_srs_wkt (p, 1,
        "ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4483");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-117");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"448");
    add_srs_wkt (p, 12,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 4485, "epsg", 4485,
        "Mexico ITRF92 / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / UTM zone 12N\",GEOGCS[\"Mexico ");
    add_srs_wkt (p, 1,
        "ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4483");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"448");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 4486, "epsg", 4486,
        "Mexico ITRF92 / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / UTM zone 13N\",GEOGCS[\"Mexico ");
    add_srs_wkt (p, 1,
        "ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4483");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-105");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"448");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 4487, "epsg", 4487,
        "Mexico ITRF92 / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / UTM zone 14N\",GEOGCS[\"Mexico ");
    add_srs_wkt (p, 1,
        "ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4483");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-99]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4487");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4488, "epsg", 4488,
        "Mexico ITRF92 / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / UTM zone 15N\",GEOGCS[\"Mexico ");
    add_srs_wkt (p, 1,
        "ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4483");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-93]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4488");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4489, "epsg", 4489,
        "Mexico ITRF92 / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / UTM zone 16N\",GEOGCS[\"Mexico ");
    add_srs_wkt (p, 1,
        "ITRF92\",DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4483");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-87]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4489");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4490, "epsg", 4490,
        "China Geodetic Coordinate System 2000", 1, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"China Geodetic Coordinate System 2000\",DATUM[\"");
    add_srs_wkt (p, 1,
        "China_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4490\"]]");
    p = add_epsg_def_ex (filter, first, last, 4491, "epsg", 4491,
        "CGCS2000 / Gauss-Kruger zone 13", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 13\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",75],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",13500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4491\"]]");
    p = add_epsg_def_ex (filter, first, last, 4492, "epsg", 4492,
        "CGCS2000 / Gauss-Kruger zone 14", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 14\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",81],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",14500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4492\"]]");
    p = add_epsg_def_ex (filter, first, last, 4493, "epsg", 4493,
        "CGCS2000 / Gauss-Kruger zone 15", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 15\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",87],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",15500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4493\"]]");
    p = add_epsg_def_ex (filter, first, last, 4494, "epsg", 4494,
        "CGCS2000 / Gauss-Kruger zone 16", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 16\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",93],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",16500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4494\"]]");
    p = add_epsg_def_ex (filter, first, last, 4495, "epsg", 4495,
        "CGCS2000 / Gauss-Kruger zone 17", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 17\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",99],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",17500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4495\"]]");
    p = add_epsg_def_ex (filter, first, last, 4496, "epsg", 4496,
        "CGCS2000 / Gauss-Kruger zone 18", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 18\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",105],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",18500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"4496\"]]");
    p = add_epsg_def_ex (filter, first, last, 4497, "epsg", 4497,
        "CGCS2000 / Gauss-Kruger zone 19", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 19\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",111],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",19500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"4497\"]]");
    p = add_epsg_def_ex (filter, first, last, 4498, "epsg", 4498,
        "CGCS2000 / Gauss-Kruger zone 20", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 20\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",117],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",20500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"4498\"]]");
    p = add_epsg_def_ex (filter, first, last, 4499, "epsg", 4499,
        "CGCS2000 / Gauss-Kruger zone 21", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 21\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",123],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",21500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"4499\"]]");
    p = add_epsg_def_ex (filter, first, last, 4500, "epsg", 4500,
        "CGCS2000 / Gauss-Kruger zone 22", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 22\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",129],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",22500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"4500\"]]");
    p = add_epsg_def_ex (filter, first, last, 4501, "epsg", 4501,
        "CGCS2000 / Gauss-Kruger zone 23", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger zone 23\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",135],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",23500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"4501\"]]");
    p = add_epsg_def_ex (filter, first, last, 4502, "epsg", 4502,
        "CGCS2000 / Gauss-Kruger CM 75E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 75E\",GEOGCS[\"China");
    add_srs_wkt (p, 1,
        " Geodetic Coordinate System 2000\",DATUM[\"China_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",75],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"4502\"]]");
    p = add_epsg_def_ex (filter, first, last, 4503, "epsg", 4503,
        "CGCS2000 / Gauss-Kruger CM 81E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 81E\",GEOGCS[\"China");
    add_srs_wkt (p, 1,
        " Geodetic Coordinate System 2000\",DATUM[\"China_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",81],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"4503\"]]");
    p = add_epsg_def_ex (filter, first, last, 4504, "epsg", 4504,
        "CGCS2000 / Gauss-Kruger CM 87E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 87E\",GEOGCS[\"China");
    add_srs_wkt (p, 1,
        " Geodetic Coordinate System 2000\",DATUM[\"China_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",87],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"4504\"]]");
    p = add_epsg_def_ex (filter, first, last, 4505, "epsg", 4505,
        "CGCS2000 / Gauss-Kruger CM 93E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 93E\",GEOGCS[\"China");
    add_srs_wkt (p, 1,
        " Geodetic Coordinate System 2000\",DATUM[\"China_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",93],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"4505\"]]");
    p = add_epsg_def_ex (filter, first, last, 4506, "epsg", 4506,
        "CGCS2000 / Gauss-Kruger CM 99E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 99E\",GEOGCS[\"China");
    add_srs_wkt (p, 1,
        " Geodetic Coordinate System 2000\",DATUM[\"China_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",99],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"4506\"]]");
    p = add_epsg_def_ex (filter, first, last, 4507, "epsg", 4507,
        "CGCS2000 / Gauss-Kruger CM 105E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 105E\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",105],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4507\"]]");
    p = add_epsg_def_ex (filter, first, last, 4508, "epsg", 4508,
        "CGCS2000 / Gauss-Kruger CM 111E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 111E\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",111],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4508\"]]");
    p = add_epsg_def_ex (filter, first, last, 4509, "epsg", 4509,
        "CGCS2000 / Gauss-Kruger CM 117E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 117E\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",117],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4509\"]]");
    p = add_epsg_def_ex (filter, first, last, 4510, "epsg", 4510,
        "CGCS2000 / Gauss-Kruger CM 123E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 123E\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",123],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4510\"]]");
    p = add_epsg_def_ex (filter, first, last, 4511, "epsg", 4511,
        "CGCS2000 / Gauss-Kruger CM 129E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 129E\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",129],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4511\"]]");
    p = add_epsg_def_ex (filter, first, last, 4512, "epsg", 4512,
        "CGCS2000 / Gauss-Kruger CM 135E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / Gauss-Kruger CM 135E\",GEOGCS[\"Chin");
    add_srs_wkt (p, 1,
        "a Geodetic Coordinate System 2000\",DATUM[\"China_2000\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",135],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4512\"]]");
    p = add_epsg_def_ex (filter, first, last, 4513, "epsg", 4513,
        "CGCS2000 / 3-degree Gauss-Kruger zone 25", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 25\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",75],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",25500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4513\"]]");
    p = add_epsg_def_ex (filter, first, last, 4514, "epsg", 4514,
        "CGCS2000 / 3-degree Gauss-Kruger zone 26", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 26\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",78],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",26500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4514\"]]");
    p = add_epsg_def_ex (filter, first, last, 4515, "epsg", 4515,
        "CGCS2000 / 3-degree Gauss-Kruger zone 27", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 27\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",81],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",27500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4515\"]]");
    p = add_epsg_def_ex (filter, first, last, 4516, "epsg", 4516,
        "CGCS2000 / 3-degree Gauss-Kruger zone 28", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 28\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",84],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",28500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4516\"]]");
    p = add_epsg_def_ex (filter, first, last, 4517, "epsg", 4517,
        "CGCS2000 / 3-degree Gauss-Kruger zone 29", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 29\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",87],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",29500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4517\"]]");
    p = add_epsg_def_ex (filter, first, last, 4518, "epsg", 4518,
        "CGCS2000 / 3-degree Gauss-Kruger zone 30", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 30\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",90],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",30500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4518\"]]");
    p = add_epsg_def_ex (filter, first, last, 4519, "epsg", 4519,
        "CGCS2000 / 3-degree Gauss-Kruger zone 31", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 31\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",93],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",31500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4519\"]]");
    p = add_epsg_def_ex (filter, first, last, 4520, "epsg", 4520,
        "CGCS2000 / 3-degree Gauss-Kruger zone 32", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 32\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",96],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",32500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4520\"]]");
    p = add_epsg_def_ex (filter, first, last, 4521, "epsg", 4521,
        "CGCS2000 / 3-degree Gauss-Kruger zone 33", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 33\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",99],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",33500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4521\"]]");
    p = add_epsg_def_ex (filter, first, last, 4522, "epsg", 4522,
        "CGCS2000 / 3-degree Gauss-Kruger zone 34", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 34\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",102],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",34500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4522\"]]");
    p = add_epsg_def_ex (filter, first, last, 4523, "epsg", 4523,
        "CGCS2000 / 3-degree Gauss-Kruger zone 35", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 35\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",35500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4523\"]]");
    p = add_epsg_def_ex (filter, first, last, 4524, "epsg", 4524,
        "CGCS2000 / 3-degree Gauss-Kruger zone 36", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 36\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",108],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",36500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4524\"]]");
    p = add_epsg_def_ex (filter, first, last, 4525, "epsg", 4525,
        "CGCS2000 / 3-degree Gauss-Kruger zone 37", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 37\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",111],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",37500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4525\"]]");
    p = add_epsg_def_ex (filter, first, last, 4526, "epsg", 4526,
        "CGCS2000 / 3-degree Gauss-Kruger zone 38", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 38\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",114],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",38500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4526\"]]");
    p = add_epsg_def_ex (filter, first, last, 4527, "epsg", 4527,
        "CGCS2000 / 3-degree Gauss-Kruger zone 39", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 39\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",117],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",39500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4527\"]]");
    p = add_epsg_def_ex (filter, first, last, 4528, "epsg", 4528,
        "CGCS2000 / 3-degree Gauss-Kruger zone 40", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 40\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",120],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",40500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4528\"]]");
    p = add_epsg_def_ex (filter, first, last, 4529, "epsg", 4529,
        "CGCS2000 / 3-degree Gauss-Kruger zone 41", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 41\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",123],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",41500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4529\"]]");
    p = add_epsg_def_ex (filter, first, last, 4530, "epsg", 4530,
        "CGCS2000 / 3-degree Gauss-Kruger zone 42", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 42\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",126],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",42500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4530\"]]");
    p = add_epsg_def_ex (filter, first, last, 4531, "epsg", 4531,
        "CGCS2000 / 3-degree Gauss-Kruger zone 43", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 43\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",129],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",43500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4531\"]]");
    p = add_epsg_def_ex (filter, first, last, 4532, "epsg", 4532,
        "CGCS2000 / 3-degree Gauss-Kruger zone 44", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 44\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",132],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",44500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4532\"]]");
    p = add_epsg_def_ex (filter, first, last, 4533, "epsg", 4533,
        "CGCS2000 / 3-degree Gauss-Kruger zone 45", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 45\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",135],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",45500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"4533\"]]");
    p = add_epsg_def_ex (filter, first, last, 4534, "epsg", 4534,
        "CGCS2000 / 3-degree Gauss-Kruger CM 75E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 75E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4534\"]]");
    p = add_epsg_def_ex (filter, first, last, 4535, "epsg", 4535,
        "CGCS2000 / 3-degree Gauss-Kruger CM 78E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 78E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",78],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4535\"]]");
    p = add_epsg_def_ex (filter, first, last, 4536, "epsg", 4536,
        "CGCS2000 / 3-degree Gauss-Kruger CM 81E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 81E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",81],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4536\"]]");
    p = add_epsg_def_ex (filter, first, last, 4537, "epsg", 4537,
        "CGCS2000 / 3-degree Gauss-Kruger CM 84E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 84E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",84],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4537\"]]");
    p = add_epsg_def_ex (filter, first, last, 4538, "epsg", 4538,
        "CGCS2000 / 3-degree Gauss-Kruger CM 87E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 87E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",87],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4538\"]]");
    p = add_epsg_def_ex (filter, first, last, 4539, "epsg", 4539,
        "CGCS2000 / 3-degree Gauss-Kruger CM 90E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 90E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",90],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4539\"]]");
    p = add_epsg_def_ex (filter, first, last, 4540, "epsg", 4540,
        "CGCS2000 / 3-degree Gauss-Kruger CM 93E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 93E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",93],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4540\"]]");
    p = add_epsg_def_ex (filter, first, last, 4541, "epsg", 4541,
        "CGCS2000 / 3-degree Gauss-Kruger CM 96E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 96E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",96],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4541\"]]");
    p = add_epsg_def_ex (filter, first, last, 4542, "epsg", 4542,
        "CGCS2000 / 3-degree Gauss-Kruger CM 99E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 99E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",99],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4542\"]]");
    p = add_epsg_def_ex (filter, first, last, 4543, "epsg", 4543,
        "CGCS2000 / 3-degree Gauss-Kruger CM 102E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 102E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",102],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4543\"]]");
    p = add_epsg_def_ex (filter, first, last, 4544, "epsg", 4544,
        "CGCS2000 / 3-degree Gauss-Kruger CM 105E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 105E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4544\"]]");
    p = add_epsg_def_ex (filter, first, last, 4545, "epsg", 4545,
        "CGCS2000 / 3-degree Gauss-Kruger CM 108E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 108E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",108],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4545\"]]");
    p = add_epsg_def_ex (filter, first, last, 4546, "epsg", 4546,
        "CGCS2000 / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 111E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",111],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4546\"]]");
    p = add_epsg_def_ex (filter, first, last, 4547, "epsg", 4547,
        "CGCS2000 / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 114E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",114],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4547\"]]");
    p = add_epsg_def_ex (filter, first, last, 4548, "epsg", 4548,
        "CGCS2000 / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 117E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",117],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4548\"]]");
    p = add_epsg_def_ex (filter, first, last, 4549, "epsg", 4549,
        "CGCS2000 / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 120E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",120],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4549\"]]");
    p = add_epsg_def_ex (filter, first, last, 4550, "epsg", 4550,
        "CGCS2000 / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 123E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",123],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4550\"]]");
    p = add_epsg_def_ex (filter, first, last, 4551, "epsg", 4551,
        "CGCS2000 / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 126E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",126],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4551\"]]");
    p = add_epsg_def_ex (filter, first, last, 4552, "epsg", 4552,
        "CGCS2000 / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 129E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",129],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4552\"]]");
    p = add_epsg_def_ex (filter, first, last, 4553, "epsg", 4553,
        "CGCS2000 / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 132E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",132],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4553\"]]");
    p = add_epsg_def_ex (filter, first, last, 4554, "epsg", 4554,
        "CGCS2000 / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 135E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",135],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"4554\"]]");
    p = add_epsg_def_ex (filter, first, last, 4555, "epsg", 4555,
        "New Beijing", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 2,
        "4\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4555\"]]");
    p = add_epsg_def_ex (filter, first, last, 4557, "epsg", 4557,
        "RRAF 1991", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RRAF 1991\",DATUM[\"Reseau de Reference des An");
    add_srs_wkt (p, 1,
        "tilles Francaises 1991\",ELLIPSOID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 3,
        "ch\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[elli");
    add_srs_wkt (p, 4,
        "psoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[");
    add_srs_wkt (p, 5,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geod");
    add_srs_wkt (p, 6,
        "etic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 9,
        "\"],AREA[\"Caribbean - French Antilles\"],BBOX[14.08,-63");
    add_srs_wkt (p, 10,
        ".66,18.54,-57.52]],ID[\"EPSG\",4557]]");
    p = add_epsg_def_ex (filter, first, last, 4558, "epsg", 4558,
        "RRAF 1991", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RRAF 1991\",DATUM[\"Reseau_de_Reference_des_Ant");
    add_srs_wkt (p, 1,
        "illes_Francaises_1991\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4558\"]]");
    p = add_epsg_def_ex (filter, first, last, 4559, "epsg", 4559,
        "RRAF 1991 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RRAF 1991 / UTM zone 20N\",GEOGCS[\"RRAF 1991\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_de_Reference_des_Antilles_Francaises_199");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1047\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4558\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-63],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4559\"]]");
    p = add_epsg_def_ex (filter, first, last, 4568, "epsg", 4568,
        "New Beijing / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 13\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",75]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4568\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4569, "epsg", 4569,
        "New Beijing / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 14\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",81]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4569\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4570, "epsg", 4570,
        "New Beijing / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 15\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",87]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4570\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4571, "epsg", 4571,
        "New Beijing / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 16\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",93]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4571\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4572, "epsg", 4572,
        "New Beijing / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 17\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",99]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4572\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4573, "epsg", 4573,
        "New Beijing / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 18\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",105");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4573\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4574, "epsg", 4574,
        "New Beijing / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 19\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4574\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4575, "epsg", 4575,
        "New Beijing / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 20\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",117");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4575\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4576, "epsg", 4576,
        "New Beijing / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 21\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",123");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4576\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4577, "epsg", 4577,
        "New Beijing / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 22\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",129");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4577\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4578, "epsg", 4578,
        "New Beijing / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 23\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",135");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4578\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4579, "epsg", 4579,
        "New Beijing / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 75E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",75],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4579\"]]");
    p = add_epsg_def_ex (filter, first, last, 4580, "epsg", 4580,
        "New Beijing / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 81E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",81],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4580\"]]");
    p = add_epsg_def_ex (filter, first, last, 4581, "epsg", 4581,
        "New Beijing / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 87E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",87],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4581\"]]");
    p = add_epsg_def_ex (filter, first, last, 4582, "epsg", 4582,
        "New Beijing / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 93E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",93],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4582\"]]");
    p = add_epsg_def_ex (filter, first, last, 4583, "epsg", 4583,
        "New Beijing / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 99E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",99],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4583\"]]");
    p = add_epsg_def_ex (filter, first, last, 4584, "epsg", 4584,
        "New Beijing / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 105E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",105");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4584\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

