/* StarPU --- Runtime system for heterogeneous multicore architectures.
 *
 * Copyright (C) 2010  Université de Bordeaux 1
 *
 * StarPU is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * StarPU is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License in COPYING.LGPL for more details.
 */
/*
 * Copyright 1993-2009 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and 
 * proprietary rights in and to this software and related documentation and 
 * any modifications thereto.  Any use, reproduction, disclosure, or distribution 
 * of this software and related documentation without an express license 
 * agreement from NVIDIA Corporation is strictly prohibited.
 * 
 */
 
 /*
 * Portions Copyright (c) 1993-2009 NVIDIA Corporation.  All rights reserved.
 * Portions Copyright (c) 2009 Mike Giles, Oxford University.  All rights reserved.
 * Portions Copyright (c) 2008 Frances Y. Kuo and Stephen Joe.  All rights reserved.
 *
 * Sobol Quasi-random Number Generator example
 *
 * Based on CUDA code submitted by Mike Giles, Oxford University, United Kingdom
 * http://people.maths.ox.ac.uk/~gilesm/
 *
 * and C code developed by Stephen Joe, University of Waikato, New Zealand
 * and Frances Kuo, University of New South Wales, Australia
 * http://web.maths.unsw.edu.au/~fkuo/sobol/
 *
 * For theoretical background see:
 *
 * P. Bratley and B.L. Fox.
 * Implementing Sobol's quasirandom sequence generator
 * http://portal.acm.org/citation.cfm?id=42288
 * ACM Trans. on Math. Software, 14(1):88-100, 1988
 *
 * S. Joe and F. Kuo.
 * Remark on algorithm 659: implementing Sobol's quasirandom sequence generator.
 * http://portal.acm.org/citation.cfm?id=641879
 * ACM Trans. on Math. Software, 29(1):49-57, 2003
 *
 */

#include "sobol_primitives.h"

/* Each primitive is stored as a struct where
   dimension is the dimension number of the polynomial (unused)
   degree is the degree of the polynomial
   a is a binary word representing the coefficients 
   m is the array of m values

   The primitives are based on those generated by Stephen Joe and
   Frances Kuo in the joe-kuo-6.10200 set.
   c.f. http://web.maths.unsw.edu.au/~fkuo/sobol/index.html */
const struct primitive sobol_primitives[] =
{
    /* First dimension is a special case so this entry is actually ignored */
    {1, 0, 0, {}},
    {2, 1, 0, {1}},
    {3, 2, 1, {1, 3}},
    {4, 3, 1, {1, 3, 1}},
    {5, 3, 2, {1, 1, 1}},
    {6, 4, 1, {1, 1, 3, 3}},
    {7, 4, 4, {1, 3, 5, 13}},
    {8, 5, 2, {1, 1, 5, 5, 17}},
    {9, 5, 4, {1, 1, 5, 5, 5}},
    {10, 5, 7, {1, 1, 7, 11, 19}},
    {11, 5, 11, {1, 1, 5, 1, 1}},
    {12, 5, 13, {1, 1, 1, 3, 11}},
    {13, 5, 14, {1, 3, 5, 5, 31}},
    {14, 6, 1, {1, 3, 3, 9, 7, 49}},
    {15, 6, 13, {1, 1, 1, 15, 21, 21}},
    {16, 6, 16, {1, 3, 1, 13, 27, 49}},
    {17, 6, 19, {1, 1, 1, 15, 7, 5}},
    {18, 6, 22, {1, 3, 1, 15, 13, 25}},
    {19, 6, 25, {1, 1, 5, 5, 19, 61}},
    {20, 7, 1, {1, 3, 7, 11, 23, 15, 103}},
    {21, 7, 4, {1, 3, 7, 13, 13, 15, 69}},
    {22, 7, 7, {1, 1, 3, 13, 7, 35, 63}},
    {23, 7, 8, {1, 3, 5, 9, 1, 25, 53}},
    {24, 7, 14, {1, 3, 1, 13, 9, 35, 107}},
    {25, 7, 19, {1, 3, 1, 5, 27, 61, 31}},
    {26, 7, 21, {1, 1, 5, 11, 19, 41, 61}},
    {27, 7, 28, {1, 3, 5, 3, 3, 13, 69}},
    {28, 7, 31, {1, 1, 7, 13, 1, 19, 1}},
    {29, 7, 32, {1, 3, 7, 5, 13, 19, 59}},
    {30, 7, 37, {1, 1, 3, 9, 25, 29, 41}},
    {31, 7, 41, {1, 3, 5, 13, 23, 1, 55}},
    {32, 7, 42, {1, 3, 7, 3, 13, 59, 17}},
    {33, 7, 50, {1, 3, 1, 3, 5, 53, 69}},
    {34, 7, 55, {1, 1, 5, 5, 23, 33, 13}},
    {35, 7, 56, {1, 1, 7, 7, 1, 61, 123}},
    {36, 7, 59, {1, 1, 7, 9, 13, 61, 49}},
    {37, 7, 62, {1, 3, 3, 5, 3, 55, 33}},
    {38, 8, 14, {1, 3, 1, 15, 31, 13, 49, 245}},
    {39, 8, 21, {1, 3, 5, 15, 31, 59, 63, 97}},
    {40, 8, 22, {1, 3, 1, 11, 11, 11, 77, 249}},
    {41, 8, 38, {1, 3, 1, 11, 27, 43, 71, 9}},
    {42, 8, 47, {1, 1, 7, 15, 21, 11, 81, 45}},
    {43, 8, 49, {1, 3, 7, 3, 25, 31, 65, 79}},
    {44, 8, 50, {1, 3, 1, 1, 19, 11, 3, 205}},
    {45, 8, 52, {1, 1, 5, 9, 19, 21, 29, 157}},
    {46, 8, 56, {1, 3, 7, 11, 1, 33, 89, 185}},
    {47, 8, 67, {1, 3, 3, 3, 15, 9, 79, 71}},
    {48, 8, 70, {1, 3, 7, 11, 15, 39, 119, 27}},
    {49, 8, 84, {1, 1, 3, 1, 11, 31, 97, 225}},
    {50, 8, 97, {1, 1, 1, 3, 23, 43, 57, 177}},
    {51, 8, 103, {1, 3, 7, 7, 17, 17, 37, 71}},
    {52, 8, 115, {1, 3, 1, 5, 27, 63, 123, 213}},
    {53, 8, 122, {1, 1, 3, 5, 11, 43, 53, 133}},
    {54, 9, 8, {1, 3, 5, 5, 29, 17, 47, 173, 479}},
    {55, 9, 13, {1, 3, 3, 11, 3, 1, 109, 9, 69}},
    {56, 9, 16, {1, 1, 1, 5, 17, 39, 23, 5, 343}},
    {57, 9, 22, {1, 3, 1, 5, 25, 15, 31, 103, 499}},
    {58, 9, 25, {1, 1, 1, 11, 11, 17, 63, 105, 183}},
    {59, 9, 44, {1, 1, 5, 11, 9, 29, 97, 231, 363}},
    {60, 9, 47, {1, 1, 5, 15, 19, 45, 41, 7, 383}},
    {61, 9, 52, {1, 3, 7, 7, 31, 19, 83, 137, 221}},
    {62, 9, 55, {1, 1, 1, 3, 23, 15, 111, 223, 83}},
    {63, 9, 59, {1, 1, 5, 13, 31, 15, 55, 25, 161}},
    {64, 9, 62, {1, 1, 3, 13, 25, 47, 39, 87, 257}},
    {65, 9, 67, {1, 1, 1, 11, 21, 53, 125, 249, 293}},
    {66, 9, 74, {1, 1, 7, 11, 11, 7, 57, 79, 323}},
    {67, 9, 81, {1, 1, 5, 5, 17, 13, 81, 3, 131}},
    {68, 9, 82, {1, 1, 7, 13, 23, 7, 65, 251, 475}},
    {69, 9, 87, {1, 3, 5, 1, 9, 43, 3, 149, 11}},
    {70, 9, 91, {1, 1, 3, 13, 31, 13, 13, 255, 487}},
    {71, 9, 94, {1, 3, 3, 1, 5, 63, 89, 91, 127}},
    {72, 9, 103, {1, 1, 3, 3, 1, 19, 123, 127, 237}},
    {73, 9, 104, {1, 1, 5, 7, 23, 31, 37, 243, 289}},
    {74, 9, 109, {1, 1, 5, 11, 17, 53, 117, 183, 491}},
    {75, 9, 122, {1, 1, 1, 5, 1, 13, 13, 209, 345}},
    {76, 9, 124, {1, 1, 3, 15, 1, 57, 115, 7, 33}},
    {77, 9, 137, {1, 3, 1, 11, 7, 43, 81, 207, 175}},
    {78, 9, 138, {1, 3, 1, 1, 15, 27, 63, 255, 49}},
    {79, 9, 143, {1, 3, 5, 3, 27, 61, 105, 171, 305}},
    {80, 9, 145, {1, 1, 5, 3, 1, 3, 57, 249, 149}},
    {81, 9, 152, {1, 1, 3, 5, 5, 57, 15, 13, 159}},
    {82, 9, 157, {1, 1, 1, 11, 7, 11, 105, 141, 225}},
    {83, 9, 167, {1, 3, 3, 5, 27, 59, 121, 101, 271}},
    {84, 9, 173, {1, 3, 5, 9, 11, 49, 51, 59, 115}},
    {85, 9, 176, {1, 1, 7, 1, 23, 45, 125, 71, 419}},
    {86, 9, 181, {1, 1, 3, 5, 23, 5, 105, 109, 75}},
    {87, 9, 182, {1, 1, 7, 15, 7, 11, 67, 121, 453}},
    {88, 9, 185, {1, 3, 7, 3, 9, 13, 31, 27, 449}},
    {89, 9, 191, {1, 3, 1, 15, 19, 39, 39, 89, 15}},
    {90, 9, 194, {1, 1, 1, 1, 1, 33, 73, 145, 379}},
    {91, 9, 199, {1, 3, 1, 15, 15, 43, 29, 13, 483}},
    {92, 9, 218, {1, 1, 7, 3, 19, 27, 85, 131, 431}},
    {93, 9, 220, {1, 3, 3, 3, 5, 35, 23, 195, 349}},
    {94, 9, 227, {1, 3, 3, 7, 9, 27, 39, 59, 297}},
    {95, 9, 229, {1, 1, 3, 9, 11, 17, 13, 241, 157}},
    {96, 9, 230, {1, 3, 7, 15, 25, 57, 33, 189, 213}},
    {97, 9, 234, {1, 1, 7, 1, 9, 55, 73, 83, 217}},
    {98, 9, 236, {1, 3, 3, 13, 19, 27, 23, 113, 249}},
    {99, 9, 241, {1, 3, 5, 3, 23, 43, 3, 253, 479}},
    {100, 9, 244, {1, 1, 5, 5, 11, 5, 45, 117, 217}},
    {101, 9, 253, {1, 3, 3, 7, 29, 37, 33, 123, 147}},
    {102, 10, 4, {1, 3, 1, 15, 5, 5, 37, 227, 223, 459}},
    {103, 10, 13, {1, 1, 7, 5, 5, 39, 63, 255, 135, 487}},
    {104, 10, 19, {1, 3, 1, 7, 9, 7, 87, 249, 217, 599}},
    {105, 10, 22, {1, 1, 3, 13, 9, 47, 7, 225, 363, 247}},
    {106, 10, 50, {1, 3, 7, 13, 19, 13, 9, 67, 9, 737}},
    {107, 10, 55, {1, 3, 5, 5, 19, 59, 7, 41, 319, 677}},
    {108, 10, 64, {1, 1, 5, 3, 31, 63, 15, 43, 207, 789}},
    {109, 10, 69, {1, 1, 7, 9, 13, 39, 3, 47, 497, 169}},
    {110, 10, 98, {1, 3, 1, 7, 21, 17, 97, 19, 415, 905}},
    {111, 10, 107, {1, 3, 7, 1, 3, 31, 71, 111, 165, 127}},
    {112, 10, 115, {1, 1, 5, 11, 1, 61, 83, 119, 203, 847}},
    {113, 10, 121, {1, 3, 3, 13, 9, 61, 19, 97, 47, 35}},
    {114, 10, 127, {1, 1, 7, 7, 15, 29, 63, 95, 417, 469}},
    {115, 10, 134, {1, 3, 1, 9, 25, 9, 71, 57, 213, 385}},
    {116, 10, 140, {1, 3, 5, 13, 31, 47, 101, 57, 39, 341}},
    {117, 10, 145, {1, 1, 3, 3, 31, 57, 125, 173, 365, 551}},
    {118, 10, 152, {1, 3, 7, 1, 13, 57, 67, 157, 451, 707}},
    {119, 10, 158, {1, 1, 1, 7, 21, 13, 105, 89, 429, 965}},
    {120, 10, 161, {1, 1, 5, 9, 17, 51, 45, 119, 157, 141}},
    {121, 10, 171, {1, 3, 7, 7, 13, 45, 91, 9, 129, 741}},
    {122, 10, 181, {1, 3, 7, 1, 23, 57, 67, 141, 151, 571}},
    {123, 10, 194, {1, 1, 3, 11, 17, 47, 93, 107, 375, 157}},
    {124, 10, 199, {1, 3, 3, 5, 11, 21, 43, 51, 169, 915}},
    {125, 10, 203, {1, 1, 5, 3, 15, 55, 101, 67, 455, 625}},
    {126, 10, 208, {1, 3, 5, 9, 1, 23, 29, 47, 345, 595}},
    {127, 10, 227, {1, 3, 7, 7, 5, 49, 29, 155, 323, 589}},
    {128, 10, 242, {1, 3, 3, 7, 5, 41, 127, 61, 261, 717}},
    {129, 10, 251, {1, 3, 7, 7, 17, 23, 117, 67, 129, 1009}},
    {130, 10, 253, {1, 1, 3, 13, 11, 39, 21, 207, 123, 305}},
    {131, 10, 265, {1, 1, 3, 9, 29, 3, 95, 47, 231, 73}},
    {132, 10, 266, {1, 3, 1, 9, 1, 29, 117, 21, 441, 259}},
    {133, 10, 274, {1, 3, 1, 13, 21, 39, 125, 211, 439, 723}},
    {134, 10, 283, {1, 1, 7, 3, 17, 63, 115, 89, 49, 773}},
    {135, 10, 289, {1, 3, 7, 13, 11, 33, 101, 107, 63, 73}},
    {136, 10, 295, {1, 1, 5, 5, 13, 57, 63, 135, 437, 177}},
    {137, 10, 301, {1, 1, 3, 7, 27, 63, 93, 47, 417, 483}},
    {138, 10, 316, {1, 1, 3, 1, 23, 29, 1, 191, 49, 23}},
    {139, 10, 319, {1, 1, 3, 15, 25, 55, 9, 101, 219, 607}},
    {140, 10, 324, {1, 3, 1, 7, 7, 19, 51, 251, 393, 307}},
    {141, 10, 346, {1, 3, 3, 3, 25, 55, 17, 75, 337, 3}},
    {142, 10, 352, {1, 1, 1, 13, 25, 17, 65, 45, 479, 413}},
    {143, 10, 361, {1, 1, 7, 7, 27, 49, 99, 161, 213, 727}},
    {144, 10, 367, {1, 3, 5, 1, 23, 5, 43, 41, 251, 857}},
    {145, 10, 382, {1, 3, 3, 7, 11, 61, 39, 87, 383, 835}},
    {146, 10, 395, {1, 1, 3, 15, 13, 7, 29, 7, 505, 923}},
    {147, 10, 398, {1, 3, 7, 1, 5, 31, 47, 157, 445, 501}},
    {148, 10, 400, {1, 1, 3, 7, 1, 43, 9, 147, 115, 605}},
    {149, 10, 412, {1, 3, 3, 13, 5, 1, 119, 211, 455, 1001}},
    {150, 10, 419, {1, 1, 3, 5, 13, 19, 3, 243, 75, 843}},
    {151, 10, 422, {1, 3, 7, 7, 1, 19, 91, 249, 357, 589}},
    {152, 10, 426, {1, 1, 1, 9, 1, 25, 109, 197, 279, 411}},
    {153, 10, 428, {1, 3, 1, 15, 23, 57, 59, 135, 191, 75}},
    {154, 10, 433, {1, 1, 5, 15, 29, 21, 39, 253, 383, 349}},
    {155, 10, 446, {1, 3, 3, 5, 19, 45, 61, 151, 199, 981}},
    {156, 10, 454, {1, 3, 5, 13, 9, 61, 107, 141, 141, 1}},
    {157, 10, 457, {1, 3, 1, 11, 27, 25, 85, 105, 309, 979}},
    {158, 10, 472, {1, 3, 3, 11, 19, 7, 115, 223, 349, 43}},
    {159, 10, 493, {1, 1, 7, 9, 21, 39, 123, 21, 275, 927}},
    {160, 10, 505, {1, 1, 7, 13, 15, 41, 47, 243, 303, 437}},
    {161, 10, 508, {1, 1, 1, 7, 7, 3, 15, 99, 409, 719}},
    {162, 11, 2, {1, 3, 3, 15, 27, 49, 113, 123, 113, 67, 469}},
    {163, 11, 11, {1, 3, 7, 11, 3, 23, 87, 169, 119, 483, 199}},
    {164, 11, 21, {1, 1, 5, 15, 7, 17, 109, 229, 179, 213, 741}},
    {165, 11, 22, {1, 1, 5, 13, 11, 17, 25, 135, 403, 557, 1433}},
    {166, 11, 35, {1, 3, 1, 1, 1, 61, 67, 215, 189, 945, 1243}},
    {167, 11, 49, {1, 1, 7, 13, 17, 33, 9, 221, 429, 217, 1679}},
    {168, 11, 50, {1, 1, 3, 11, 27, 3, 15, 93, 93, 865, 1049}},
    {169, 11, 56, {1, 3, 7, 7, 25, 41, 121, 35, 373, 379, 1547}},
    {170, 11, 61, {1, 3, 3, 9, 11, 35, 45, 205, 241, 9, 59}},
    {171, 11, 70, {1, 3, 1, 7, 3, 51, 7, 177, 53, 975, 89}},
    {172, 11, 74, {1, 1, 3, 5, 27, 1, 113, 231, 299, 759, 861}},
    {173, 11, 79, {1, 3, 3, 15, 25, 29, 5, 255, 139, 891, 2031}},
    {174, 11, 84, {1, 3, 1, 1, 13, 9, 109, 193, 419, 95, 17}},
    {175, 11, 88, {1, 1, 7, 9, 3, 7, 29, 41, 135, 839, 867}},
    {176, 11, 103, {1, 1, 7, 9, 25, 49, 123, 217, 113, 909, 215}},
    {177, 11, 104, {1, 1, 7, 3, 23, 15, 43, 133, 217, 327, 901}},
    {178, 11, 112, {1, 1, 3, 3, 13, 53, 63, 123, 477, 711, 1387}},
    {179, 11, 115, {1, 1, 3, 15, 7, 29, 75, 119, 181, 957, 247}},
    {180, 11, 117, {1, 1, 1, 11, 27, 25, 109, 151, 267, 99, 1461}},
    {181, 11, 122, {1, 3, 7, 15, 5, 5, 53, 145, 11, 725, 1501}},
    {182, 11, 134, {1, 3, 7, 1, 9, 43, 71, 229, 157, 607, 1835}},
    {183, 11, 137, {1, 3, 3, 13, 25, 1, 5, 27, 471, 349, 127}},
    {184, 11, 146, {1, 1, 1, 1, 23, 37, 9, 221, 269, 897, 1685}},
    {185, 11, 148, {1, 1, 3, 3, 31, 29, 51, 19, 311, 553, 1969}},
    {186, 11, 157, {1, 3, 7, 5, 5, 55, 17, 39, 475, 671, 1529}},
    {187, 11, 158, {1, 1, 7, 1, 1, 35, 47, 27, 437, 395, 1635}},
    {188, 11, 162, {1, 1, 7, 3, 13, 23, 43, 135, 327, 139, 389}},
    {189, 11, 164, {1, 3, 7, 3, 9, 25, 91, 25, 429, 219, 513}},
    {190, 11, 168, {1, 1, 3, 5, 13, 29, 119, 201, 277, 157, 2043}},
    {191, 11, 173, {1, 3, 5, 3, 29, 57, 13, 17, 167, 739, 1031}},
    {192, 11, 185, {1, 3, 3, 5, 29, 21, 95, 27, 255, 679, 1531}},
    {193, 11, 186, {1, 3, 7, 15, 9, 5, 21, 71, 61, 961, 1201}},
    {194, 11, 191, {1, 3, 5, 13, 15, 57, 33, 93, 459, 867, 223}},
    {195, 11, 193, {1, 1, 1, 15, 17, 43, 127, 191, 67, 177, 1073}},
    {196, 11, 199, {1, 1, 1, 15, 23, 7, 21, 199, 75, 293, 1611}},
    {197, 11, 213, {1, 3, 7, 13, 15, 39, 21, 149, 65, 741, 319}},
    {198, 11, 214, {1, 3, 7, 11, 23, 13, 101, 89, 277, 519, 711}},
    {199, 11, 220, {1, 3, 7, 15, 19, 27, 85, 203, 441, 97, 1895}},
    {200, 11, 227, {1, 3, 1, 3, 29, 25, 21, 155, 11, 191, 197}},
    {201, 11, 236, {1, 1, 7, 5, 27, 11, 81, 101, 457, 675, 1687}},
    {202, 11, 242, {1, 3, 1, 5, 25, 5, 65, 193, 41, 567, 781}},
    {203, 11, 251, {1, 3, 1, 5, 11, 15, 113, 77, 411, 695, 1111}},
    {204, 11, 256, {1, 1, 3, 9, 11, 53, 119, 171, 55, 297, 509}},
    {205, 11, 259, {1, 1, 1, 1, 11, 39, 113, 139, 165, 347, 595}},
    {206, 11, 265, {1, 3, 7, 11, 9, 17, 101, 13, 81, 325, 1733}},
    {207, 11, 266, {1, 3, 1, 1, 21, 43, 115, 9, 113, 907, 645}},
    {208, 11, 276, {1, 1, 7, 3, 9, 25, 117, 197, 159, 471, 475}},
    {209, 11, 292, {1, 3, 1, 9, 11, 21, 57, 207, 485, 613, 1661}},
    {210, 11, 304, {1, 1, 7, 7, 27, 55, 49, 223, 89, 85, 1523}},
    {211, 11, 310, {1, 1, 5, 3, 19, 41, 45, 51, 447, 299, 1355}},
    {212, 11, 316, {1, 3, 1, 15, 1, 35, 119, 135, 427, 93, 1311}},
    {213, 11, 319, {1, 3, 1, 15, 31, 39, 121, 145, 129, 903, 333}},
    {214, 11, 322, {1, 1, 5, 3, 29, 7, 9, 11, 395, 119, 873}},
    {215, 11, 328, {1, 3, 5, 11, 27, 29, 5, 117, 469, 31, 1811}},
    {216, 11, 334, {1, 1, 7, 15, 21, 25, 71, 15, 89, 1021, 679}},
    {217, 11, 339, {1, 3, 7, 9, 21, 39, 51, 111, 327, 809, 845}},
    {218, 11, 341, {1, 3, 3, 13, 3, 33, 79, 17, 183, 599, 1859}},
    {219, 11, 345, {1, 1, 7, 9, 31, 9, 1, 5, 353, 395, 833}},
    {220, 11, 346, {1, 3, 5, 7, 3, 53, 81, 133, 155, 355, 1559}},
    {221, 11, 362, {1, 3, 5, 5, 31, 13, 89, 195, 357, 769, 889}},
    {222, 11, 367, {1, 1, 7, 1, 9, 21, 77, 31, 269, 857, 923}},
    {223, 11, 372, {1, 1, 1, 11, 11, 27, 61, 185, 329, 685, 325}},
    {224, 11, 375, {1, 1, 1, 5, 11, 31, 71, 79, 293, 29, 17}},
    {225, 11, 376, {1, 1, 7, 7, 7, 41, 65, 167, 67, 153, 1305}},
    {226, 11, 381, {1, 3, 3, 5, 23, 45, 109, 205, 191, 649, 749}},
    {227, 11, 385, {1, 1, 7, 7, 17, 1, 73, 211, 19, 797, 1009}},
    {228, 11, 388, {1, 1, 5, 9, 23, 15, 117, 213, 183, 477, 1301}},
    {229, 11, 392, {1, 1, 5, 13, 23, 35, 55, 151, 267, 883, 1479}},
    {230, 11, 409, {1, 1, 1, 7, 5, 43, 77, 11, 149, 297, 329}},
    {231, 11, 415, {1, 1, 7, 15, 3, 41, 55, 123, 219, 499, 377}},
    {232, 11, 416, {1, 3, 3, 1, 27, 7, 113, 141, 173, 379, 1087}},
    {233, 11, 421, {1, 3, 1, 9, 7, 25, 45, 49, 415, 329, 483}},
    {234, 11, 428, {1, 1, 7, 7, 7, 15, 75, 191, 305, 757, 813}},
    {235, 11, 431, {1, 3, 7, 5, 31, 15, 21, 247, 29, 297, 1015}},
    {236, 11, 434, {1, 3, 1, 13, 3, 41, 69, 235, 431, 515, 1889}},
    {237, 11, 439, {1, 1, 5, 7, 31, 5, 69, 193, 229, 439, 1043}},
    {238, 11, 446, {1, 3, 5, 13, 31, 33, 45, 159, 477, 707, 1605}},
    {239, 11, 451, {1, 1, 1, 7, 23, 49, 107, 223, 7, 429, 2047}},
    {240, 11, 453, {1, 3, 5, 1, 31, 17, 117, 133, 331, 97, 833}},
    {241, 11, 457, {1, 3, 1, 11, 7, 31, 103, 5, 299, 601, 981}},
    {242, 11, 458, {1, 3, 5, 5, 15, 57, 87, 39, 217, 155, 361}},
    {243, 11, 471, {1, 1, 7, 15, 29, 19, 125, 131, 37, 635, 1429}},
    {244, 11, 475, {1, 3, 1, 9, 29, 3, 59, 107, 341, 809, 101}},
    {245, 11, 478, {1, 1, 5, 15, 9, 37, 113, 225, 139, 165, 393}},
    {246, 11, 484, {1, 3, 3, 13, 27, 21, 35, 255, 189, 45, 103}},
    {247, 11, 493, {1, 1, 7, 5, 7, 59, 39, 87, 319, 723, 955}},
    {248, 11, 494, {1, 3, 1, 1, 9, 23, 83, 47, 413, 445, 787}},
    {249, 11, 499, {1, 3, 3, 3, 9, 27, 113, 135, 279, 915, 1221}},
    {250, 11, 502, {1, 3, 7, 15, 3, 49, 99, 67, 11, 1017, 891}},
    {251, 11, 517, {1, 3, 1, 9, 31, 41, 9, 205, 39, 993, 105}},
    {252, 11, 518, {1, 3, 3, 7, 11, 45, 67, 123, 303, 87, 1943}},
    {253, 11, 524, {1, 1, 1, 9, 1, 51, 101, 253, 499, 879, 833}},
    {254, 11, 527, {1, 3, 7, 15, 19, 51, 97, 13, 499, 231, 829}},
    {255, 11, 555, {1, 3, 5, 3, 25, 49, 29, 165, 43, 95, 779}},
    {256, 11, 560, {1, 3, 5, 11, 13, 63, 1, 133, 207, 349, 221}},
    {257, 11, 565, {1, 3, 7, 11, 23, 37, 51, 123, 399, 295, 1057}},
    {258, 11, 569, {1, 1, 5, 11, 11, 43, 97, 163, 477, 777, 1217}},
    {259, 11, 578, {1, 1, 7, 13, 3, 33, 65, 191, 25, 993, 291}},
    {260, 11, 580, {1, 3, 5, 9, 25, 55, 101, 231, 219, 215, 517}},
    {261, 11, 587, {1, 3, 1, 7, 17, 31, 87, 1, 475, 371, 771}},
    {262, 11, 589, {1, 1, 1, 7, 3, 25, 35, 255, 211, 67, 447}},
    {263, 11, 590, {1, 1, 1, 13, 9, 33, 103, 17, 369, 455, 265}},
    {264, 11, 601, {1, 3, 5, 5, 29, 61, 61, 207, 345, 87, 1035}},
    {265, 11, 607, {1, 3, 1, 7, 19, 21, 117, 49, 191, 133, 1889}},
    {266, 11, 611, {1, 3, 3, 13, 5, 37, 63, 229, 53, 891, 1939}},
    {267, 11, 614, {1, 1, 3, 5, 1, 43, 7, 1, 427, 155, 1587}},
    {268, 11, 617, {1, 1, 7, 15, 15, 33, 33, 233, 481, 709, 905}},
    {269, 11, 618, {1, 1, 7, 13, 7, 11, 125, 77, 39, 55, 1745}},
    {270, 11, 625, {1, 3, 3, 3, 7, 49, 35, 123, 267, 229, 1873}},
    {271, 11, 628, {1, 1, 7, 3, 17, 11, 35, 217, 215, 577, 1467}},
    {272, 11, 635, {1, 3, 3, 5, 7, 11, 51, 27, 277, 113, 767}},
    {273, 11, 641, {1, 3, 3, 3, 17, 1, 61, 151, 227, 841, 1421}},
    {274, 11, 647, {1, 3, 7, 7, 7, 29, 95, 219, 407, 257, 417}},
    {275, 11, 654, {1, 3, 5, 13, 5, 39, 63, 67, 467, 99, 457}},
    {276, 11, 659, {1, 3, 3, 9, 15, 19, 107, 217, 371, 411, 867}},
    {277, 11, 662, {1, 3, 3, 13, 13, 1, 101, 81, 69, 371, 415}},
    {278, 11, 672, {1, 3, 1, 1, 5, 31, 103, 125, 147, 85, 1357}},
    {279, 11, 675, {1, 3, 1, 5, 25, 61, 9, 83, 371, 691, 1189}},
    {280, 11, 682, {1, 1, 5, 3, 3, 9, 1, 123, 333, 741, 961}},
    {281, 11, 684, {1, 1, 3, 1, 7, 37, 73, 39, 101, 1005, 1361}},
    {282, 11, 689, {1, 1, 3, 15, 11, 51, 29, 159, 361, 685, 1643}},
    {283, 11, 695, {1, 1, 3, 3, 17, 51, 79, 143, 373, 425, 703}},
    {284, 11, 696, {1, 1, 3, 15, 17, 21, 63, 97, 335, 591, 1697}},
    {285, 11, 713, {1, 1, 7, 7, 1, 57, 21, 253, 199, 661, 77}},
    {286, 11, 719, {1, 1, 3, 13, 27, 13, 101, 247, 497, 535, 273}},
    {287, 11, 724, {1, 1, 1, 7, 25, 5, 83, 27, 107, 549, 1885}},
    {288, 11, 733, {1, 1, 7, 5, 29, 45, 107, 159, 59, 303, 1941}},
    {289, 11, 734, {1, 1, 7, 9, 5, 43, 85, 89, 151, 39, 221}},
    {290, 11, 740, {1, 1, 3, 5, 5, 47, 65, 205, 141, 777, 1873}},
    {291, 11, 747, {1, 1, 5, 15, 25, 41, 121, 133, 41, 171, 521}},
    {292, 11, 749, {1, 3, 3, 9, 19, 25, 15, 161, 339, 155, 413}},
    {293, 11, 752, {1, 3, 7, 1, 7, 1, 67, 23, 453, 625, 1375}},
    {294, 11, 755, {1, 1, 1, 15, 5, 9, 87, 89, 209, 361, 1711}},
    {295, 11, 762, {1, 3, 7, 11, 21, 39, 87, 21, 23, 727, 15}},
    {296, 11, 770, {1, 3, 5, 13, 15, 15, 9, 247, 73, 9, 319}},
    {297, 11, 782, {1, 1, 5, 7, 29, 21, 13, 121, 359, 679, 1659}},
    {298, 11, 784, {1, 1, 7, 13, 19, 63, 79, 99, 107, 13, 137}},
    {299, 11, 787, {1, 1, 7, 15, 1, 43, 117, 79, 305, 285, 1151}},
    {300, 11, 789, {1, 1, 7, 9, 23, 9, 53, 105, 205, 121, 1451}},
    {301, 11, 793, {1, 1, 7, 3, 3, 63, 99, 71, 495, 233, 1633}},
    {302, 11, 796, {1, 3, 7, 11, 17, 5, 99, 211, 409, 911, 1743}},
    {303, 11, 803, {1, 1, 3, 3, 1, 61, 81, 107, 493, 625, 847}},
    {304, 11, 805, {1, 1, 3, 13, 15, 29, 13, 57, 305, 409, 1267}},
    {305, 11, 810, {1, 3, 5, 13, 11, 3, 121, 253, 161, 891, 1463}},
    {306, 11, 815, {1, 1, 7, 13, 23, 1, 125, 7, 273, 221, 2001}},
    {307, 11, 824, {1, 3, 3, 5, 3, 49, 115, 205, 11, 45, 1563}},
    {308, 11, 829, {1, 3, 7, 5, 21, 59, 81, 191, 31, 485, 743}},
    {309, 11, 830, {1, 1, 5, 13, 9, 9, 21, 77, 487, 615, 423}},
    {310, 11, 832, {1, 1, 1, 3, 27, 43, 53, 53, 345, 605, 949}},
    {311, 11, 841, {1, 3, 1, 7, 31, 49, 97, 39, 279, 597, 189}},
    {312, 11, 847, {1, 3, 5, 3, 17, 23, 87, 89, 457, 103, 1969}},
    {313, 11, 849, {1, 1, 7, 3, 21, 45, 19, 127, 49, 231, 273}},
    {314, 11, 861, {1, 3, 5, 11, 13, 15, 127, 83, 185, 553, 537}},
    {315, 11, 871, {1, 3, 7, 11, 19, 45, 77, 123, 471, 731, 605}},
    {316, 11, 878, {1, 1, 7, 5, 11, 25, 123, 25, 51, 501, 2025}},
    {317, 11, 889, {1, 3, 3, 9, 15, 17, 67, 173, 93, 217, 1507}},
    {318, 11, 892, {1, 3, 5, 1, 29, 7, 29, 211, 369, 983, 1331}},
    {319, 11, 901, {1, 1, 5, 7, 17, 63, 1, 9, 493, 1009, 1275}},
    {320, 11, 908, {1, 1, 1, 7, 31, 37, 51, 255, 253, 387, 591}},
    {321, 11, 920, {1, 1, 7, 1, 11, 25, 41, 245, 215, 329, 1877}},
    {322, 11, 923, {1, 1, 5, 7, 17, 21, 115, 63, 31, 435, 39}},
    {323, 11, 942, {1, 1, 7, 9, 1, 17, 95, 139, 505, 365, 825}},
    {324, 11, 949, {1, 3, 7, 7, 13, 31, 105, 167, 203, 337, 813}},
    {325, 11, 950, {1, 3, 5, 11, 3, 7, 111, 91, 491, 93, 1473}},
    {326, 11, 954, {1, 1, 3, 7, 29, 55, 103, 193, 219, 693, 1241}},
    {327, 11, 961, {1, 3, 7, 9, 27, 7, 37, 135, 455, 87, 257}},
    {328, 11, 968, {1, 1, 3, 5, 23, 19, 23, 33, 417, 263, 1693}},
    {329, 11, 971, {1, 3, 3, 7, 29, 39, 127, 221, 305, 717, 989}},
    {330, 11, 973, {1, 3, 3, 1, 27, 21, 49, 51, 355, 241, 1853}},
    {331, 11, 979, {1, 1, 1, 15, 21, 3, 51, 137, 257, 431, 1641}},
    {332, 11, 982, {1, 3, 7, 13, 25, 3, 69, 111, 163, 955, 459}},
    {333, 11, 986, {1, 3, 7, 5, 5, 43, 111, 53, 463, 177, 605}},
    {334, 11, 998, {1, 1, 3, 11, 23, 11, 79, 105, 419, 645, 423}},
    {335, 11, 1001, {1, 1, 3, 3, 15, 5, 105, 31, 117, 961, 325}},
    {336, 11, 1010, {1, 3, 5, 15, 21, 55, 81, 199, 231, 973, 373}},
    {337, 11, 1012, {1, 3, 3, 15, 23, 17, 71, 63, 59, 719, 405}},
    {338, 12, 41, {1, 3, 5, 3, 9, 37, 45, 205, 267, 261, 1173, 3681}},
    {339, 12, 52, {1, 3, 7, 11, 1, 53, 91, 207, 487, 593, 1397, 1255}},
    {340, 12, 61, {1, 1, 3, 7, 17, 3, 111, 145, 237, 667, 1199, 3793}},
    {341, 12, 62, {1, 3, 7, 3, 15, 59, 69, 223, 509, 211, 1431, 2455}},
    {342, 12, 76, {1, 3, 7, 1, 27, 47, 75, 123, 455, 553, 1153, 1675}},
    {343, 12, 104, {1, 1, 7, 13, 17, 3, 85, 103, 205, 443, 1093, 4083}},
    {344, 12, 117, {1, 3, 7, 13, 13, 63, 13, 103, 223, 473, 1125, 1565}},
    {345, 12, 131, {1, 1, 1, 13, 21, 55, 21, 39, 385, 809, 457, 1991}},
    {346, 12, 143, {1, 1, 3, 5, 29, 57, 81, 1, 165, 181, 57, 1463}},
    {347, 12, 145, {1, 3, 7, 7, 21, 29, 59, 127, 393, 981, 577, 2707}},
    {348, 12, 157, {1, 1, 3, 11, 17, 47, 123, 149, 273, 825, 1843, 479}},
    {349, 12, 167, {1, 1, 5, 7, 1, 33, 91, 251, 371, 655, 383, 3123}},
    {350, 12, 171, {1, 3, 1, 7, 3, 55, 15, 195, 345, 1017, 385, 1869}},
    {351, 12, 176, {1, 1, 3, 7, 15, 25, 25, 67, 223, 935, 905, 923}},
    {352, 12, 181, {1, 1, 1, 13, 29, 5, 23, 81, 227, 175, 1025, 355}},
    {353, 12, 194, {1, 1, 7, 9, 25, 27, 43, 85, 401, 955, 989, 3117}},
    {354, 12, 217, {1, 1, 7, 13, 27, 31, 27, 235, 99, 539, 1093, 2821}},
    {355, 12, 236, {1, 3, 5, 7, 13, 19, 45, 231, 203, 489, 1929, 3615}},
    {356, 12, 239, {1, 3, 1, 3, 3, 15, 3, 191, 181, 463, 1247, 2229}},
    {357, 12, 262, {1, 3, 7, 3, 1, 37, 1, 59, 29, 283, 679, 429}},
    {358, 12, 283, {1, 3, 1, 15, 17, 25, 5, 113, 191, 505, 365, 3943}},
    {359, 12, 286, {1, 1, 3, 3, 13, 31, 95, 141, 29, 353, 661, 3637}},
    {360, 12, 307, {1, 3, 1, 1, 5, 53, 19, 9, 81, 497, 1915, 2997}},
    {361, 12, 313, {1, 3, 7, 15, 5, 13, 35, 163, 293, 309, 503, 2387}},
    {362, 12, 319, {1, 1, 5, 3, 11, 25, 127, 27, 435, 247, 1485, 3917}},
    {363, 12, 348, {1, 1, 7, 5, 21, 7, 15, 213, 355, 209, 1107, 1317}},
    {364, 12, 352, {1, 3, 3, 11, 25, 29, 73, 203, 445, 849, 291, 1567}},
    {365, 12, 357, {1, 3, 3, 15, 15, 31, 5, 15, 19, 345, 635, 1815}},
    {366, 12, 391, {1, 1, 3, 3, 19, 21, 15, 95, 111, 167, 1051, 479}},
    {367, 12, 398, {1, 3, 1, 13, 15, 61, 125, 237, 11, 789, 1681, 437}},
    {368, 12, 400, {1, 3, 3, 15, 21, 23, 105, 145, 145, 453, 917, 1727}},
    {369, 12, 412, {1, 1, 7, 11, 9, 37, 27, 91, 199, 561, 1705, 3849}},
    {370, 12, 415, {1, 1, 3, 5, 11, 53, 1, 21, 63, 879, 629, 3219}},
    {371, 12, 422, {1, 1, 3, 13, 3, 5, 121, 17, 511, 809, 627, 2627}},
    {372, 12, 440, {1, 3, 5, 3, 27, 21, 115, 117, 193, 185, 1855, 2473}},
    {373, 12, 460, {1, 3, 1, 9, 11, 37, 79, 123, 391, 715, 573, 699}},
    {374, 12, 465, {1, 3, 1, 9, 5, 35, 105, 5, 55, 347, 1217, 3483}},
    {375, 12, 468, {1, 3, 1, 11, 19, 59, 21, 221, 329, 873, 943, 3679}},
    {376, 12, 515, {1, 3, 1, 13, 21, 57, 119, 33, 111, 581, 1133, 131}},
    {377, 12, 536, {1, 3, 3, 7, 13, 31, 67, 205, 211, 143, 1117, 4067}},
    {378, 12, 539, {1, 3, 7, 9, 9, 53, 71, 251, 41, 875, 691, 3681}},
    {379, 12, 551, {1, 3, 1, 9, 23, 55, 57, 29, 123, 453, 523, 3237}},
    {380, 12, 558, {1, 1, 5, 11, 15, 19, 91, 105, 221, 1005, 169, 461}},
    {381, 12, 563, {1, 1, 1, 11, 7, 61, 49, 41, 337, 739, 699, 2379}},
    {382, 12, 570, {1, 1, 3, 13, 21, 31, 103, 247, 87, 537, 757, 785}},
    {383, 12, 595, {1, 1, 5, 9, 7, 49, 127, 149, 277, 87, 475, 127}},
    {384, 12, 598, {1, 3, 5, 15, 5, 25, 95, 229, 389, 121, 95, 2787}},
    {385, 12, 617, {1, 1, 1, 5, 9, 27, 29, 23, 419, 371, 127, 961}},
    {386, 12, 647, {1, 1, 1, 15, 25, 19, 123, 35, 41, 785, 605, 711}},
    {387, 12, 654, {1, 1, 7, 3, 1, 13, 69, 161, 449, 225, 1795, 2083}},
    {388, 12, 678, {1, 1, 3, 5, 21, 1, 19, 211, 191, 697, 89, 177}},
    {389, 12, 713, {1, 1, 3, 3, 19, 29, 49, 151, 365, 541, 1681, 1943}},
    {390, 12, 738, {1, 3, 7, 7, 9, 5, 75, 109, 243, 769, 755, 2733}},
    {391, 12, 747, {1, 3, 1, 11, 11, 41, 7, 87, 363, 893, 1799, 1303}},
    {392, 12, 750, {1, 1, 1, 9, 11, 5, 19, 101, 41, 401, 1863, 965}},
    {393, 12, 757, {1, 1, 3, 11, 13, 15, 71, 249, 511, 625, 1101, 2615}},
    {394, 12, 772, {1, 3, 3, 9, 31, 35, 85, 107, 383, 201, 1163, 981}},
    {395, 12, 803, {1, 3, 5, 9, 21, 13, 33, 9, 243, 93, 461, 741}},
    {396, 12, 810, {1, 1, 1, 9, 1, 55, 85, 179, 321, 163, 1807, 339}},
    {397, 12, 812, {1, 3, 7, 11, 29, 7, 57, 133, 245, 87, 917, 109}},
    {398, 12, 850, {1, 1, 7, 9, 11, 13, 93, 81, 361, 343, 647, 1113}},
    {399, 12, 862, {1, 3, 7, 5, 23, 57, 117, 105, 221, 697, 1159, 1307}},
    {400, 12, 906, {1, 3, 1, 7, 27, 55, 15, 235, 279, 941, 655, 3975}},
    {401, 12, 908, {1, 3, 1, 9, 27, 47, 45, 41, 361, 135, 379, 2121}},
    {402, 12, 929, {1, 1, 7, 15, 19, 51, 31, 39, 187, 573, 273, 383}},
    {403, 12, 930, {1, 1, 7, 11, 9, 47, 107, 29, 435, 989, 1315, 2815}},
    {404, 12, 954, {1, 3, 1, 3, 21, 31, 7, 41, 45, 115, 1639, 1861}},
    {405, 12, 964, {1, 1, 1, 15, 1, 21, 57, 233, 51, 149, 1251, 1809}},
    {406, 12, 982, {1, 1, 3, 11, 1, 53, 111, 35, 447, 657, 1557, 349}},
    {407, 12, 985, {1, 1, 7, 11, 25, 33, 39, 209, 127, 913, 659, 177}},
    {408, 12, 991, {1, 3, 5, 9, 13, 53, 25, 191, 373, 997, 1413, 2859}},
    {409, 12, 992, {1, 1, 7, 3, 31, 51, 17, 253, 149, 719, 1681, 2713}},
    {410, 12, 1067, {1, 1, 7, 1, 23, 49, 9, 211, 381, 321, 2033, 361}},
    {411, 12, 1070, {1, 3, 1, 15, 31, 3, 121, 21, 465, 417, 1023, 3921}},
    {412, 12, 1096, {1, 1, 7, 1, 17, 49, 101, 37, 429, 877, 505, 821}},
    {413, 12, 1099, {1, 3, 1, 7, 23, 59, 33, 127, 43, 987, 1065, 2675}},
    {414, 12, 1116, {1, 3, 1, 9, 7, 19, 45, 157, 475, 53, 1223, 523}},
    {415, 12, 1143, {1, 3, 7, 9, 23, 61, 31, 133, 85, 623, 871, 965}},
    {416, 12, 1165, {1, 3, 1, 7, 3, 17, 21, 197, 377, 819, 661, 1803}},
    {417, 12, 1178, {1, 1, 7, 3, 11, 37, 1, 135, 509, 927, 23, 1657}},
    {418, 12, 1184, {1, 1, 3, 5, 15, 57, 55, 179, 317, 31, 611, 4057}},
    {419, 12, 1202, {1, 1, 5, 5, 29, 57, 93, 105, 103, 157, 701, 249}},
    {420, 12, 1213, {1, 1, 3, 13, 27, 41, 23, 213, 363, 911, 85, 2733}},
    {421, 12, 1221, {1, 1, 5, 15, 15, 15, 93, 203, 61, 759, 1735, 459}},
    {422, 12, 1240, {1, 1, 5, 13, 1, 59, 27, 203, 165, 87, 835, 3647}},
    {423, 12, 1246, {1, 3, 3, 5, 25, 57, 43, 209, 71, 35, 1985, 1521}},
    {424, 12, 1252, {1, 1, 7, 5, 15, 19, 49, 103, 195, 17, 2041, 1267}},
    {425, 12, 1255, {1, 1, 5, 5, 5, 19, 91, 131, 157, 625, 1851, 3691}},
    {426, 12, 1267, {1, 1, 1, 9, 9, 47, 3, 195, 25, 1003, 533, 833}},
    {427, 12, 1293, {1, 1, 1, 15, 21, 33, 27, 193, 65, 545, 261, 3095}},
    {428, 12, 1301, {1, 3, 7, 5, 7, 39, 35, 9, 387, 241, 1015, 1557}},
    {429, 12, 1305, {1, 3, 7, 7, 13, 29, 43, 101, 457, 363, 115, 915}},
    {430, 12, 1332, {1, 1, 3, 13, 17, 57, 79, 11, 155, 39, 215, 157}},
    {431, 12, 1349, {1, 3, 7, 9, 23, 33, 69, 189, 59, 823, 1941, 423}},
    {432, 12, 1384, {1, 3, 5, 11, 9, 39, 79, 43, 431, 227, 163, 2653}},
    {433, 12, 1392, {1, 3, 1, 3, 5, 63, 55, 141, 207, 349, 1873, 773}},
    {434, 12, 1402, {1, 1, 5, 7, 21, 59, 89, 111, 53, 217, 1897, 1619}},
    {435, 12, 1413, {1, 1, 5, 9, 7, 27, 127, 247, 183, 925, 989, 1059}},
    {436, 12, 1417, {1, 3, 5, 3, 21, 47, 39, 71, 343, 285, 1053, 3007}},
    {437, 12, 1423, {1, 1, 3, 11, 1, 7, 27, 109, 19, 325, 157, 2779}},
    {438, 12, 1451, {1, 3, 5, 9, 23, 27, 63, 115, 415, 1005, 1159, 3699}},
    {439, 12, 1480, {1, 1, 5, 13, 27, 27, 5, 245, 95, 1021, 641, 3875}},
    {440, 12, 1491, {1, 3, 5, 9, 5, 9, 53, 183, 379, 251, 1747, 969}},
    {441, 12, 1503, {1, 1, 5, 13, 7, 23, 53, 195, 353, 225, 1871, 2131}},
    {442, 12, 1504, {1, 3, 7, 3, 21, 5, 25, 253, 59, 821, 1699, 1911}},
    {443, 12, 1513, {1, 3, 3, 7, 9, 53, 121, 155, 281, 969, 1943, 2291}},
    {444, 12, 1538, {1, 1, 1, 1, 27, 25, 65, 111, 295, 213, 81, 415}},
    {445, 12, 1544, {1, 1, 7, 7, 29, 51, 39, 201, 133, 987, 243, 3369}},
    {446, 12, 1547, {1, 1, 1, 7, 27, 5, 57, 205, 395, 813, 125, 1293}},
    {447, 12, 1555, {1, 1, 7, 13, 15, 19, 57, 11, 151, 405, 2013, 2607}},
    {448, 12, 1574, {1, 3, 1, 1, 9, 53, 17, 25, 7, 483, 525, 967}},
    {449, 12, 1603, {1, 3, 7, 13, 11, 31, 111, 253, 439, 689, 919, 3563}},
    {450, 12, 1615, {1, 1, 5, 9, 13, 59, 123, 69, 339, 17, 297, 2511}},
    {451, 12, 1618, {1, 1, 7, 5, 13, 1, 85, 113, 45, 107, 565, 795}},
    {452, 12, 1629, {1, 3, 1, 11, 15, 5, 109, 163, 73, 103, 195, 639}},
    {453, 12, 1634, {1, 1, 5, 9, 21, 11, 93, 23, 217, 275, 139, 1159}},
    {454, 12, 1636, {1, 1, 1, 3, 31, 63, 73, 61, 63, 923, 1237, 3887}},
    {455, 12, 1639, {1, 3, 5, 9, 27, 45, 5, 93, 3, 303, 357, 2973}},
    {456, 12, 1657, {1, 1, 1, 11, 7, 51, 41, 27, 83, 357, 1679, 2015}},
    {457, 12, 1667, {1, 3, 3, 13, 9, 53, 1, 193, 343, 59, 451, 1579}},
    {458, 12, 1681, {1, 3, 5, 3, 9, 37, 37, 131, 207, 29, 2027, 733}},
    {459, 12, 1697, {1, 1, 5, 7, 3, 61, 51, 221, 71, 659, 1955, 1289}},
    {460, 12, 1704, {1, 3, 1, 15, 5, 19, 3, 205, 319, 155, 325, 2643}},
    {461, 12, 1709, {1, 1, 5, 9, 3, 15, 1, 247, 323, 143, 37, 2069}},
    {462, 12, 1722, {1, 1, 5, 15, 23, 43, 35, 59, 285, 779, 605, 1739}},
    {463, 12, 1730, {1, 3, 3, 5, 29, 31, 57, 225, 417, 521, 1337, 3051}},
    {464, 12, 1732, {1, 3, 1, 7, 23, 57, 41, 165, 437, 669, 1087, 1275}},
    {465, 12, 1802, {1, 1, 3, 5, 1, 51, 25, 233, 449, 503, 1237, 1303}},
    {466, 12, 1804, {1, 1, 1, 11, 9, 45, 79, 149, 229, 991, 1725, 395}},
    {467, 12, 1815, {1, 1, 5, 11, 31, 37, 13, 117, 19, 939, 1347, 2251}},
    {468, 12, 1826, {1, 1, 5, 5, 1, 29, 25, 251, 493, 793, 649, 1197}},
    {469, 12, 1832, {1, 3, 3, 11, 5, 53, 49, 33, 37, 937, 497, 361}},
    {470, 12, 1843, {1, 1, 1, 1, 5, 57, 19, 141, 115, 371, 1341, 3335}},
    {471, 12, 1849, {1, 3, 5, 5, 23, 47, 77, 31, 225, 589, 551, 2625}},
    {472, 12, 1863, {1, 1, 3, 1, 25, 37, 29, 213, 283, 207, 385, 2019}},
    {473, 12, 1905, {1, 3, 5, 11, 5, 17, 21, 37, 167, 49, 1595, 1647}},
    {474, 12, 1928, {1, 1, 3, 15, 29, 15, 79, 203, 329, 627, 1799, 895}},
    {475, 12, 1933, {1, 1, 5, 7, 23, 53, 69, 45, 271, 661, 1437, 2429}},
    {476, 12, 1939, {1, 3, 1, 1, 21, 7, 115, 233, 267, 873, 2023, 3431}},
    {477, 12, 1976, {1, 1, 5, 5, 7, 63, 7, 125, 129, 815, 771, 1233}},
    {478, 12, 1996, {1, 3, 5, 9, 5, 29, 121, 203, 373, 137, 1181, 3773}},
    {479, 12, 2013, {1, 1, 5, 1, 15, 47, 25, 137, 329, 531, 1957, 1933}},
    {480, 12, 2014, {1, 3, 1, 11, 23, 37, 67, 123, 181, 567, 893, 2307}},
    {481, 12, 2020, {1, 3, 5, 3, 5, 23, 41, 227, 9, 213, 821, 1689}},
    {482, 13, 13, {1, 1, 1, 13, 29, 33, 23, 241, 199, 753, 1759, 833, 5261}},
    {483, 13, 19, {1, 3, 5, 15, 31, 7, 61, 225, 209, 117, 1983, 395, 3583}},
    {484, 13, 26, {1, 1, 7, 5, 27, 49, 7, 125, 365, 513, 1001, 283, 627}},
    {485, 13, 41, {1, 3, 1, 3, 7, 53, 99, 123, 493, 481, 173, 1483, 805}},
    {486, 13, 50, {1, 1, 5, 7, 15, 1, 57, 19, 391, 847, 1641, 3497, 2807}},
    {487, 13, 55, {1, 1, 7, 11, 19, 49, 77, 139, 275, 115, 1401, 2541, 7239}},
    {488, 13, 69, {1, 1, 1, 15, 11, 13, 13, 211, 119, 317, 271, 1867, 4299}},
    {489, 13, 70, {1, 1, 1, 13, 15, 37, 121, 197, 485, 605, 1025, 3235, 6205}},
    {490, 13, 79, {1, 3, 5, 7, 25, 39, 31, 3, 465, 33, 625, 1069, 6043}},
    {491, 13, 82, {1, 1, 3, 9, 7, 37, 115, 169, 27, 967, 505, 1493, 4333}},
    {492, 13, 87, {1, 1, 3, 13, 1, 51, 19, 117, 365, 587, 1597, 279, 99}},
    {493, 13, 93, {1, 3, 5, 9, 15, 57, 89, 153, 495, 535, 775, 4063, 6049}},
    {494, 13, 94, {1, 1, 3, 1, 9, 7, 111, 43, 225, 677, 1379, 481, 5003}},
    {495, 13, 97, {1, 1, 1, 15, 11, 47, 63, 37, 41, 833, 467, 3795, 5643}},
    {496, 13, 100, {1, 3, 3, 7, 25, 49, 21, 91, 191, 579, 507, 3001, 6549}},
    {497, 13, 112, {1, 3, 5, 9, 25, 17, 17, 153, 467, 359, 1523, 3175, 7307}},
    {498, 13, 121, {1, 3, 7, 7, 29, 57, 51, 145, 71, 515, 495, 1091, 7911}},
    {499, 13, 134, {1, 3, 1, 7, 31, 31, 53, 149, 303, 969, 383, 939, 2659}},
    {500, 13, 138, {1, 1, 7, 9, 1, 21, 15, 145, 9, 199, 695, 2967, 1179}},
    {501, 13, 148, {1, 3, 1, 3, 23, 33, 89, 23, 387, 591, 1543, 3941, 7021}},
    {502, 13, 151, {1, 1, 3, 7, 27, 17, 25, 71, 43, 761, 803, 833, 1023}},
    {503, 13, 157, {1, 1, 1, 3, 11, 25, 3, 171, 377, 843, 1147, 1469, 1773}},
    {504, 13, 161, {1, 1, 3, 15, 1, 13, 65, 197, 381, 683, 895, 2181, 1973}},
    {505, 13, 179, {1, 1, 5, 7, 19, 25, 109, 49, 451, 277, 1417, 2965, 7677}},
    {506, 13, 181, {1, 3, 3, 7, 25, 51, 115, 43, 175, 317, 953, 81, 2533}},
    {507, 13, 188, {1, 3, 7, 15, 27, 57, 5, 181, 489, 369, 1339, 3643, 7911}},
    {508, 13, 196, {1, 3, 1, 5, 21, 11, 87, 81, 85, 5, 867, 3541, 3071}},
    {509, 13, 203, {1, 1, 3, 3, 19, 37, 111, 43, 27, 549, 367, 3021, 6563}},
    {510, 13, 206, {1, 1, 1, 13, 3, 63, 83, 107, 327, 599, 425, 3941, 4319}},
    {511, 13, 223, {1, 3, 7, 15, 5, 37, 127, 169, 117, 987, 1821, 997, 63}},
    {512, 13, 224, {1, 1, 7, 15, 17, 41, 103, 129, 449, 373, 733, 55, 5987}},
    {513, 13, 227, {1, 1, 1, 15, 13, 61, 15, 117, 249, 149, 885, 3723, 5525}},
    {514, 13, 230, {1, 1, 1, 1, 7, 3, 39, 47, 367, 355, 1943, 1035, 2367}},
    {515, 13, 239, {1, 1, 7, 11, 19, 49, 21, 239, 403, 921, 693, 2123, 7387}},
    {516, 13, 241, {1, 3, 5, 5, 23, 45, 13, 81, 105, 91, 1173, 3059, 5969}},
    {517, 13, 248, {1, 1, 1, 5, 1, 31, 73, 253, 395, 941, 1949, 455, 453}},
    {518, 13, 253, {1, 1, 3, 15, 27, 57, 115, 17, 269, 819, 145, 1219, 6471}},
    {519, 13, 268, {1, 3, 3, 7, 29, 19, 9, 67, 501, 87, 883, 1985, 4859}},
    {520, 13, 274, {1, 1, 1, 3, 29, 3, 55, 107, 79, 941, 1437, 3607, 6221}},
    {521, 13, 283, {1, 3, 3, 15, 9, 63, 59, 113, 319, 825, 641, 491, 4015}},
    {522, 13, 286, {1, 1, 1, 3, 21, 59, 55, 107, 215, 167, 315, 81, 3491}},
    {523, 13, 289, {1, 3, 7, 11, 15, 7, 71, 145, 481, 843, 1437, 3809, 7729}},
    {524, 13, 301, {1, 3, 1, 11, 23, 59, 65, 45, 397, 117, 325, 2933, 541}},
    {525, 13, 302, {1, 3, 3, 15, 15, 47, 77, 35, 143, 327, 965, 3409, 1817}},
    {526, 13, 316, {1, 1, 1, 9, 31, 7, 31, 57, 331, 615, 645, 605, 2185}},
    {527, 13, 319, {1, 1, 5, 1, 15, 53, 109, 135, 259, 591, 1419, 3349, 5541}},
    {528, 13, 324, {1, 1, 5, 13, 21, 23, 87, 115, 211, 737, 1433, 3247, 6899}},
    {529, 13, 331, {1, 3, 3, 7, 23, 5, 43, 43, 253, 753, 1305, 2179, 1375}},
    {530, 13, 333, {1, 3, 3, 7, 21, 49, 127, 129, 229, 415, 1593, 2315, 3273}},
    {531, 13, 345, {1, 3, 5, 9, 15, 61, 97, 101, 199, 651, 1421, 2471, 6109}},
    {532, 13, 351, {1, 3, 1, 11, 13, 27, 19, 243, 185, 707, 559, 1687, 981}},
    {533, 13, 358, {1, 3, 7, 3, 5, 9, 101, 55, 39, 811, 1491, 3725, 6691}},
    {534, 13, 375, {1, 1, 5, 9, 27, 33, 41, 61, 271, 695, 1563, 547, 1569}},
    {535, 13, 379, {1, 3, 5, 1, 29, 21, 9, 83, 131, 287, 1505, 2711, 1617}},
    {536, 13, 381, {1, 1, 1, 7, 29, 57, 19, 99, 303, 609, 1397, 3241, 3463}},
    {537, 13, 386, {1, 3, 1, 9, 13, 33, 45, 101, 195, 615, 2017, 2473, 1251}},
    {538, 13, 403, {1, 1, 3, 7, 31, 7, 121, 67, 275, 153, 1189, 2343, 5593}},
    {539, 13, 405, {1, 1, 3, 15, 19, 37, 79, 207, 473, 927, 915, 1971, 8033}},
    {540, 13, 419, {1, 3, 3, 13, 7, 55, 123, 163, 47, 599, 209, 2235, 7643}},
    {541, 13, 426, {1, 1, 3, 11, 31, 3, 31, 69, 61, 257, 11, 845, 2659}},
    {542, 13, 428, {1, 3, 5, 9, 27, 15, 73, 237, 79, 517, 1905, 1595, 6337}},
    {543, 13, 439, {1, 1, 5, 15, 11, 19, 95, 213, 321, 303, 1957, 2291, 5991}},
    {544, 13, 440, {1, 1, 1, 11, 15, 17, 85, 45, 143, 425, 55, 3595, 685}},
    {545, 13, 446, {1, 1, 7, 3, 25, 5, 25, 203, 353, 537, 1921, 1885, 1157}},
    {546, 13, 451, {1, 1, 1, 7, 29, 23, 117, 141, 257, 81, 25, 3237, 7223}},
    {547, 13, 454, {1, 3, 5, 11, 27, 23, 47, 29, 143, 341, 1855, 3973, 5977}},
    {548, 13, 458, {1, 3, 5, 7, 7, 45, 11, 95, 135, 261, 1475, 3723, 6999}},
    {549, 13, 465, {1, 1, 3, 13, 19, 39, 89, 93, 187, 1011, 1319, 67, 399}},
    {550, 13, 468, {1, 1, 5, 5, 17, 1, 91, 69, 405, 815, 225, 2469, 6287}},
    {551, 13, 472, {1, 1, 7, 7, 3, 19, 41, 37, 125, 221, 1011, 3603, 4881}},
    {552, 13, 475, {1, 3, 5, 11, 15, 13, 45, 235, 141, 17, 1991, 2581, 4965}},
    {553, 13, 477, {1, 3, 3, 13, 5, 41, 117, 143, 261, 717, 111, 395, 4381}},
    {554, 13, 496, {1, 3, 7, 5, 15, 47, 117, 197, 147, 117, 295, 2005, 4081}},
    {555, 13, 502, {1, 3, 5, 3, 29, 61, 93, 245, 59, 119, 1121, 2549, 6471}},
    {556, 13, 508, {1, 3, 1, 5, 13, 43, 93, 133, 313, 923, 295, 1239, 6355}},
    {557, 13, 517, {1, 3, 3, 11, 5, 47, 99, 115, 107, 585, 671, 2077, 7005}},
    {558, 13, 521, {1, 1, 1, 9, 13, 31, 79, 253, 245, 597, 1071, 2273, 2481}},
    {559, 13, 527, {1, 1, 7, 1, 25, 3, 39, 47, 201, 187, 419, 3881, 4031}},
    {560, 13, 530, {1, 3, 1, 11, 17, 47, 119, 243, 217, 321, 727, 3227, 6041}},
    {561, 13, 532, {1, 1, 5, 11, 9, 3, 85, 121, 161, 663, 2035, 4073, 7401}},
    {562, 13, 542, {1, 1, 3, 5, 11, 45, 51, 99, 431, 307, 157, 2941, 1645}},
    {563, 13, 552, {1, 3, 3, 7, 7, 43, 77, 19, 169, 535, 1797, 2907, 531}},
    {564, 13, 555, {1, 1, 7, 9, 19, 11, 45, 51, 169, 175, 995, 2231, 147}},
    {565, 13, 560, {1, 1, 5, 1, 3, 25, 123, 11, 387, 757, 1067, 1359, 2227}},
    {566, 13, 566, {1, 1, 5, 15, 13, 41, 45, 135, 49, 391, 1551, 1729, 4799}},
    {567, 13, 575, {1, 1, 7, 9, 3, 11, 109, 59, 217, 507, 47, 1609, 7145}},
    {568, 13, 577, {1, 1, 5, 15, 13, 35, 7, 213, 495, 811, 1403, 3423, 8139}},
    {569, 13, 589, {1, 3, 5, 15, 3, 55, 107, 47, 337, 305, 1869, 943, 7533}},
    {570, 13, 590, {1, 1, 7, 15, 15, 51, 9, 209, 477, 173, 1921, 3295, 4283}},
    {571, 13, 602, {1, 3, 7, 13, 17, 31, 111, 73, 143, 773, 1499, 651, 6659}},
    {572, 13, 607, {1, 1, 1, 1, 17, 5, 1, 95, 347, 613, 49, 7, 2373}},
    {573, 13, 608, {1, 1, 7, 13, 5, 21, 33, 227, 375, 635, 149, 1585, 6159}},
    {574, 13, 611, {1, 3, 7, 5, 25, 7, 121, 185, 129, 1021, 167, 873, 949}},
    {575, 13, 613, {1, 1, 3, 11, 29, 23, 25, 219, 203, 651, 629, 155, 5385}},
    {576, 13, 625, {1, 3, 5, 9, 25, 1, 91, 213, 87, 807, 599, 2527, 6971}},
    {577, 13, 644, {1, 3, 1, 11, 19, 13, 91, 11, 73, 617, 1721, 1803, 3005}},
    {578, 13, 651, {1, 1, 5, 9, 25, 33, 19, 167, 195, 861, 1209, 1887, 3165}},
    {579, 13, 654, {1, 1, 5, 1, 5, 21, 57, 253, 325, 907, 1237, 1037, 3639}},
    {580, 13, 656, {1, 3, 1, 1, 5, 17, 35, 65, 193, 57, 1045, 2117, 7433}},
    {581, 13, 662, {1, 3, 5, 1, 3, 23, 89, 157, 379, 831, 479, 3285, 5107}},
    {582, 13, 668, {1, 3, 3, 1, 5, 35, 57, 107, 465, 81, 387, 1035, 7231}},
    {583, 13, 681, {1, 3, 3, 9, 13, 25, 23, 39, 439, 89, 1651, 781, 6167}},
    {584, 13, 682, {1, 1, 3, 1, 19, 33, 103, 139, 259, 201, 1569, 3453, 5143}},
    {585, 13, 689, {1, 3, 1, 1, 5, 51, 33, 199, 509, 593, 1671, 243, 3455}},
    {586, 13, 696, {1, 1, 5, 15, 31, 15, 81, 173, 357, 447, 595, 1177, 2435}},
    {587, 13, 699, {1, 3, 5, 1, 9, 35, 53, 111, 277, 143, 1837, 385, 7057}},
    {588, 13, 707, {1, 3, 3, 1, 7, 25, 115, 117, 1, 97, 51, 3459, 3057}},
    {589, 13, 709, {1, 1, 3, 5, 11, 63, 85, 69, 1, 943, 279, 4091, 7753}},
    {590, 13, 714, {1, 3, 7, 9, 7, 59, 19, 17, 435, 779, 1049, 2125, 3295}},
    {591, 13, 716, {1, 1, 7, 13, 29, 45, 95, 37, 179, 463, 1503, 417, 1959}},
    {592, 13, 719, {1, 3, 1, 9, 21, 27, 27, 53, 359, 781, 1387, 997, 2123}},
    {593, 13, 727, {1, 3, 3, 13, 17, 39, 103, 175, 131, 973, 1055, 2935, 5671}},
    {594, 13, 734, {1, 1, 3, 9, 7, 41, 55, 133, 223, 1019, 1341, 2559, 4225}},
    {595, 13, 738, {1, 3, 5, 9, 13, 7, 85, 101, 161, 461, 227, 2073, 6483}},
    {596, 13, 743, {1, 3, 3, 1, 11, 27, 67, 125, 287, 229, 1945, 2461, 7111}},
    {597, 13, 747, {1, 1, 7, 3, 23, 59, 39, 137, 421, 245, 955, 1941, 3743}},
    {598, 13, 757, {1, 1, 1, 9, 19, 55, 45, 93, 101, 777, 729, 867, 7123}},
    {599, 13, 769, {1, 1, 5, 5, 21, 27, 49, 125, 245, 271, 1643, 3995, 1845}},
    {600, 13, 770, {1, 1, 3, 15, 21, 63, 113, 157, 123, 347, 333, 2445, 3401}},
    {601, 13, 776, {1, 3, 5, 5, 25, 7, 113, 13, 167, 935, 329, 3483, 4237}},
    {602, 13, 790, {1, 1, 3, 9, 25, 43, 101, 115, 439, 633, 2001, 283, 4415}},
    {603, 13, 799, {1, 3, 1, 7, 7, 39, 41, 201, 423, 351, 563, 653, 6769}},
    {604, 13, 805, {1, 3, 7, 11, 3, 55, 29, 75, 17, 283, 837, 1303, 7917}},
    {605, 13, 809, {1, 3, 1, 11, 9, 17, 47, 39, 399, 645, 575, 805, 5751}},
    {606, 13, 812, {1, 3, 1, 11, 7, 9, 99, 239, 503, 995, 1265, 1651, 2095}},
    {607, 13, 820, {1, 1, 3, 15, 17, 13, 107, 165, 341, 337, 51, 1619, 7801}},
    {608, 13, 827, {1, 3, 1, 3, 19, 55, 73, 105, 97, 557, 1701, 799, 5591}},
    {609, 13, 829, {1, 1, 5, 13, 15, 21, 35, 39, 215, 357, 171, 161, 4527}},
    {610, 13, 835, {1, 3, 3, 15, 19, 7, 27, 153, 399, 415, 2031, 627, 8169}},
    {611, 13, 841, {1, 3, 1, 11, 27, 37, 21, 217, 413, 787, 1637, 1199, 1735}},
    {612, 13, 844, {1, 1, 7, 7, 25, 21, 95, 13, 159, 195, 1493, 1395, 7453}},
    {613, 13, 856, {1, 3, 5, 1, 3, 17, 47, 95, 327, 493, 1501, 2857, 7215}},
    {614, 13, 859, {1, 3, 1, 3, 19, 25, 67, 89, 243, 913, 815, 2471, 6537}},
    {615, 13, 862, {1, 1, 3, 1, 29, 53, 13, 21, 131, 893, 1113, 525, 6723}},
    {616, 13, 865, {1, 1, 5, 1, 25, 45, 97, 167, 465, 65, 1923, 3971, 6365}},
    {617, 13, 885, {1, 1, 7, 7, 3, 7, 113, 85, 371, 143, 201, 1023, 2827}},
    {618, 13, 890, {1, 3, 3, 1, 5, 31, 5, 37, 57, 203, 241, 2473, 593}},
    {619, 13, 905, {1, 3, 1, 5, 25, 59, 87, 207, 227, 103, 491, 1299, 4173}},
    {620, 13, 916, {1, 1, 7, 9, 15, 61, 75, 171, 421, 651, 375, 511, 2723}},
    {621, 13, 925, {1, 3, 7, 11, 9, 19, 55, 5, 365, 7, 1401, 3049, 6669}},
    {622, 13, 935, {1, 1, 1, 5, 31, 37, 97, 105, 343, 999, 1641, 1951, 1395}},
    {623, 13, 939, {1, 3, 5, 1, 5, 13, 83, 189, 395, 335, 1767, 887, 3431}},
    {624, 13, 942, {1, 1, 1, 13, 17, 45, 71, 227, 171, 831, 617, 1203, 6477}},
    {625, 13, 949, {1, 1, 7, 13, 15, 49, 91, 61, 155, 951, 1031, 1153, 5201}},
    {626, 13, 953, {1, 1, 1, 13, 23, 51, 75, 89, 359, 257, 1695, 1739, 5439}},
    {627, 13, 956, {1, 3, 3, 13, 9, 47, 31, 225, 191, 787, 355, 2013, 5897}},
    {628, 13, 961, {1, 1, 7, 3, 7, 41, 91, 83, 9, 643, 1589, 3491, 135}},
    {629, 13, 968, {1, 3, 5, 9, 5, 29, 29, 249, 181, 641, 17, 3187, 6767}},
    {630, 13, 976, {1, 1, 7, 13, 25, 17, 91, 187, 61, 305, 199, 2397, 2287}},
    {631, 13, 988, {1, 1, 7, 1, 25, 45, 85, 35, 361, 353, 631, 1113, 135}},
    {632, 13, 995, {1, 3, 7, 9, 13, 11, 107, 67, 127, 523, 1129, 81, 7627}},
    {633, 13, 997, {1, 3, 1, 7, 17, 43, 89, 225, 45, 597, 1683, 943, 3801}},
    {634, 13, 1007, {1, 3, 7, 1, 31, 47, 37, 31, 269, 731, 1817, 3977, 7107}},
    {635, 13, 1015, {1, 1, 5, 5, 21, 37, 93, 219, 117, 369, 561, 4031, 365}},
    {636, 13, 1016, {1, 1, 5, 13, 31, 21, 65, 237, 157, 775, 843, 1725, 583}},
    {637, 13, 1027, {1, 1, 1, 11, 11, 31, 15, 217, 377, 395, 1633, 3841, 4417}},
    {638, 13, 1036, {1, 3, 7, 9, 23, 23, 93, 109, 265, 379, 1341, 1857, 5567}},
    {639, 13, 1039, {1, 1, 7, 1, 13, 37, 109, 121, 7, 157, 1639, 483, 1433}},
    {640, 13, 1041, {1, 1, 1, 3, 5, 37, 29, 107, 77, 771, 1631, 3051, 8097}},
    {641, 13, 1048, {1, 3, 7, 13, 27, 5, 59, 89, 401, 223, 1013, 1089, 3407}},
    {642, 13, 1053, {1, 1, 5, 5, 11, 47, 113, 237, 69, 833, 845, 179, 3687}},
    {643, 13, 1054, {1, 3, 7, 3, 19, 43, 117, 223, 373, 145, 463, 1719, 3621}},
    {644, 13, 1058, {1, 1, 3, 7, 5, 53, 5, 53, 385, 723, 809, 1785, 6495}},
    {645, 13, 1075, {1, 3, 7, 5, 3, 63, 125, 63, 275, 575, 1461, 821, 5607}},
    {646, 13, 1082, {1, 1, 5, 9, 17, 33, 71, 145, 215, 741, 1843, 1987, 4263}},
    {647, 13, 1090, {1, 3, 5, 3, 31, 63, 29, 233, 441, 447, 853, 3937, 4747}},
    {648, 13, 1109, {1, 3, 3, 15, 21, 35, 15, 221, 63, 481, 403, 2795, 5533}},
    {649, 13, 1110, {1, 3, 7, 9, 1, 47, 123, 129, 365, 23, 1975, 1179, 7957}},
    {650, 13, 1119, {1, 3, 1, 3, 11, 23, 119, 229, 141, 687, 1639, 2105, 319}},
    {651, 13, 1126, {1, 3, 1, 11, 17, 49, 3, 113, 297, 727, 1135, 2657, 187}},
    {652, 13, 1130, {1, 3, 7, 5, 5, 31, 83, 173, 159, 389, 1373, 3049, 827}},
    {653, 13, 1135, {1, 1, 1, 15, 27, 51, 107, 97, 119, 831, 247, 2613, 7125}},
    {654, 13, 1137, {1, 1, 3, 7, 23, 53, 35, 181, 81, 213, 1135, 2901, 1555}},
    {655, 13, 1140, {1, 3, 5, 7, 9, 45, 25, 137, 399, 345, 339, 1869, 3469}},
    {656, 13, 1149, {1, 1, 3, 5, 25, 49, 71, 139, 473, 883, 677, 1229, 6661}},
    {657, 13, 1156, {1, 3, 5, 13, 1, 55, 31, 67, 321, 221, 1425, 1335, 3805}},
    {658, 13, 1159, {1, 1, 5, 9, 7, 31, 53, 169, 67, 509, 1155, 1739, 615}},
    {659, 13, 1160, {1, 3, 7, 9, 1, 13, 49, 39, 263, 215, 767, 2881, 1517}},
    {660, 13, 1165, {1, 1, 5, 5, 27, 41, 15, 5, 203, 539, 463, 1983, 1949}},
    {661, 13, 1173, {1, 3, 3, 1, 21, 3, 101, 225, 255, 805, 1035, 813, 8125}},
    {662, 13, 1178, {1, 3, 1, 1, 17, 59, 55, 107, 117, 489, 541, 689, 581}},
    {663, 13, 1183, {1, 3, 7, 15, 17, 57, 75, 135, 295, 11, 1415, 1843, 7079}},
    {664, 13, 1184, {1, 1, 5, 5, 17, 49, 49, 91, 227, 295, 1501, 3723, 5879}},
    {665, 13, 1189, {1, 3, 5, 9, 27, 17, 63, 127, 503, 869, 53, 627, 5085}},
    {666, 13, 1194, {1, 3, 7, 3, 25, 25, 1, 83, 461, 1019, 1737, 1901, 2611}},
    {667, 13, 1211, {1, 3, 1, 11, 23, 59, 59, 235, 33, 747, 1141, 2429, 3833}},
    {668, 13, 1214, {1, 1, 7, 9, 29, 55, 85, 179, 385, 645, 1009, 1193, 5643}},
    {669, 13, 1216, {1, 1, 5, 15, 29, 11, 77, 147, 453, 655, 469, 2727, 6205}},
    {670, 13, 1225, {1, 3, 5, 3, 5, 13, 103, 115, 445, 87, 1803, 601, 5159}},
    {671, 13, 1231, {1, 1, 7, 5, 1, 37, 55, 129, 5, 387, 51, 3585, 6771}},
    {672, 13, 1239, {1, 3, 3, 15, 15, 15, 21, 13, 67, 391, 1745, 1137, 7039}},
    {673, 13, 1243, {1, 3, 7, 9, 25, 1, 83, 135, 275, 11, 339, 269, 6121}},
    {674, 13, 1246, {1, 1, 5, 3, 27, 11, 109, 15, 499, 489, 615, 1713, 7713}},
    {675, 13, 1249, {1, 3, 7, 15, 25, 53, 1, 169, 275, 623, 411, 195, 6331}},
    {676, 13, 1259, {1, 1, 3, 7, 3, 5, 73, 97, 407, 687, 311, 2141, 6687}},
    {677, 13, 1273, {1, 3, 5, 3, 27, 43, 123, 143, 99, 963, 2029, 3759, 1483}},
    {678, 13, 1274, {1, 1, 5, 3, 5, 43, 11, 51, 423, 111, 875, 3605, 4023}},
    {679, 13, 1281, {1, 1, 1, 15, 25, 11, 89, 21, 425, 585, 1983, 3481, 7329}},
    {680, 13, 1287, {1, 3, 7, 3, 1, 5, 107, 29, 285, 929, 663, 319, 3139}},
    {681, 13, 1294, {1, 3, 3, 7, 7, 37, 21, 51, 385, 539, 59, 1595, 9}},
    {682, 13, 1296, {1, 3, 3, 1, 9, 21, 87, 149, 21, 211, 787, 351, 5597}},
    {683, 13, 1305, {1, 3, 1, 11, 1, 41, 21, 65, 7, 83, 693, 1905, 5935}},
    {684, 13, 1306, {1, 3, 3, 11, 17, 3, 55, 205, 461, 897, 273, 2849, 1685}},
    {685, 13, 1318, {1, 3, 7, 5, 23, 15, 121, 129, 387, 967, 1131, 3451, 3545}},
    {686, 13, 1332, {1, 1, 7, 11, 5, 29, 59, 69, 27, 699, 1639, 2137, 6305}},
    {687, 13, 1335, {1, 3, 7, 7, 23, 23, 69, 205, 399, 661, 1187, 1639, 5099}},
    {688, 13, 1336, {1, 3, 5, 5, 31, 17, 37, 173, 371, 649, 449, 243, 3665}},
    {689, 13, 1341, {1, 3, 5, 1, 21, 5, 51, 105, 173, 699, 475, 3489, 7411}},
    {690, 13, 1342, {1, 1, 3, 13, 17, 41, 55, 131, 359, 461, 1885, 4045, 3615}},
    {691, 13, 1362, {1, 3, 7, 11, 27, 33, 79, 127, 227, 293, 607, 1713, 167}},
    {692, 13, 1364, {1, 3, 3, 1, 5, 9, 13, 59, 425, 319, 1813, 2905, 4647}},
    {693, 13, 1368, {1, 3, 5, 5, 13, 59, 69, 95, 379, 119, 1175, 1853, 7573}},
    {694, 13, 1378, {1, 3, 5, 3, 3, 47, 51, 203, 395, 623, 13, 3369, 663}},
    {695, 13, 1387, {1, 1, 5, 3, 3, 39, 107, 203, 125, 627, 1817, 1101, 935}},
    {696, 13, 1389, {1, 1, 1, 5, 7, 31, 71, 141, 507, 101, 913, 567, 753}},
    {697, 13, 1397, {1, 3, 5, 11, 1, 25, 81, 211, 79, 277, 1445, 783, 5}},
    {698, 13, 1401, {1, 1, 7, 3, 7, 9, 63, 87, 335, 413, 1595, 2313, 5883}},
    {699, 13, 1408, {1, 1, 1, 11, 21, 61, 87, 119, 155, 259, 1629, 2565, 5975}},
    {700, 13, 1418, {1, 3, 1, 3, 29, 59, 57, 205, 65, 779, 1433, 2845, 1311}},
    {701, 13, 1425, {1, 3, 3, 3, 29, 59, 1, 125, 493, 25, 315, 1171, 4837}},
    {702, 13, 1426, {1, 1, 1, 11, 1, 47, 119, 141, 95, 87, 1497, 3613, 5009}},
    {703, 13, 1431, {1, 3, 5, 5, 7, 19, 61, 233, 321, 585, 547, 179, 6787}},
    {704, 13, 1435, {1, 3, 1, 7, 15, 29, 51, 177, 189, 435, 89, 2507, 4975}},
    {705, 13, 1441, {1, 3, 7, 5, 19, 49, 125, 145, 329, 975, 717, 161, 1099}},
    {706, 13, 1444, {1, 3, 3, 13, 1, 21, 81, 63, 263, 597, 1713, 1759, 1745}},
    {707, 13, 1462, {1, 1, 3, 9, 17, 61, 19, 119, 229, 25, 1759, 343, 7925}},
    {708, 13, 1471, {1, 1, 1, 9, 27, 49, 51, 149, 453, 717, 1791, 2529, 331}},
    {709, 13, 1474, {1, 3, 1, 7, 11, 15, 125, 237, 291, 111, 1051, 3739, 3805}},
    {710, 13, 1483, {1, 1, 7, 9, 7, 63, 49, 73, 53, 429, 1167, 2019, 911}},
    {711, 13, 1485, {1, 3, 5, 5, 29, 17, 3, 193, 243, 29, 2007, 1881, 7143}},
    {712, 13, 1494, {1, 3, 3, 3, 5, 19, 127, 149, 57, 601, 1263, 1909, 3835}},
    {713, 13, 1497, {1, 1, 1, 5, 25, 43, 21, 115, 193, 735, 571, 401, 1573}},
    {714, 13, 1516, {1, 3, 5, 9, 25, 41, 53, 165, 5, 575, 1381, 995, 5851}},
    {715, 13, 1522, {1, 1, 5, 15, 21, 43, 25, 125, 49, 207, 345, 2981, 709}},
    {716, 13, 1534, {1, 1, 3, 5, 29, 37, 89, 145, 123, 771, 631, 3259, 1431}},
    {717, 13, 1543, {1, 1, 3, 3, 1, 37, 67, 243, 335, 913, 1927, 3027, 6059}},
    {718, 13, 1552, {1, 1, 5, 15, 11, 31, 61, 59, 511, 543, 1747, 3329, 599}},
    {719, 13, 1557, {1, 1, 7, 13, 17, 31, 9, 143, 381, 713, 135, 1037, 5981}},
    {720, 13, 1558, {1, 1, 7, 11, 25, 7, 79, 3, 403, 979, 1021, 457, 999}},
    {721, 13, 1567, {1, 3, 3, 11, 3, 19, 127, 135, 255, 645, 437, 3793, 5809}},
    {722, 13, 1568, {1, 3, 7, 1, 5, 59, 69, 135, 307, 769, 307, 3225, 2869}},
    {723, 13, 1574, {1, 3, 5, 3, 9, 33, 121, 41, 245, 1009, 2039, 925, 3341}},
    {724, 13, 1592, {1, 3, 3, 15, 19, 23, 55, 155, 389, 817, 475, 1005, 1971}},
    {725, 13, 1605, {1, 3, 5, 7, 11, 17, 7, 113, 249, 241, 1149, 2359, 8037}},
    {726, 13, 1606, {1, 3, 5, 5, 23, 59, 115, 5, 503, 221, 485, 3857, 4399}},
    {727, 13, 1610, {1, 3, 7, 3, 5, 53, 119, 107, 103, 99, 1313, 623, 3073}},
    {728, 13, 1617, {1, 3, 1, 13, 7, 21, 85, 47, 345, 355, 607, 2213, 2489}},
    {729, 13, 1623, {1, 1, 5, 11, 7, 51, 43, 53, 281, 311, 1221, 3919, 4821}},
    {730, 13, 1630, {1, 1, 7, 9, 21, 15, 105, 251, 367, 311, 1247, 2357, 5411}},
    {731, 13, 1634, {1, 3, 5, 5, 17, 21, 1, 213, 505, 97, 603, 4057, 6853}},
    {732, 13, 1640, {1, 3, 7, 5, 21, 3, 105, 61, 5, 39, 461, 351, 4379}},
    {733, 13, 1643, {1, 3, 3, 9, 15, 39, 87, 21, 393, 525, 1699, 2427, 211}},
    {734, 13, 1648, {1, 1, 5, 9, 21, 25, 53, 175, 387, 83, 1155, 1225, 5681}},
    {735, 13, 1651, {1, 3, 1, 15, 7, 49, 43, 127, 257, 499, 79, 33, 2843}},
    {736, 13, 1653, {1, 3, 7, 15, 21, 17, 89, 175, 161, 371, 389, 2289, 7751}},
    {737, 13, 1670, {1, 1, 7, 3, 19, 23, 65, 5, 149, 563, 1237, 3445, 6817}},
    {738, 13, 1676, {1, 3, 5, 11, 23, 21, 65, 11, 329, 323, 551, 3859, 749}},
    {739, 13, 1684, {1, 3, 1, 9, 13, 23, 11, 169, 203, 349, 1733, 2537, 3777}},
    {740, 13, 1687, {1, 3, 7, 7, 5, 19, 47, 81, 215, 677, 1861, 2703, 6373}},
    {741, 13, 1691, {1, 1, 5, 5, 11, 5, 19, 151, 215, 695, 1347, 1359, 1979}},
    {742, 13, 1693, {1, 1, 7, 3, 1, 59, 11, 185, 379, 247, 1885, 1819, 637}},
    {743, 13, 1698, {1, 3, 7, 3, 21, 3, 53, 161, 49, 697, 113, 3561, 95}},
    {744, 13, 1709, {1, 3, 7, 7, 29, 15, 85, 123, 415, 41, 703, 1501, 6939}},
    {745, 13, 1715, {1, 1, 7, 5, 7, 37, 75, 185, 115, 423, 625, 3557, 7851}},
    {746, 13, 1722, {1, 1, 1, 7, 11, 35, 119, 131, 331, 197, 1939, 1951, 7957}},
    {747, 13, 1732, {1, 1, 5, 3, 9, 43, 93, 11, 97, 483, 131, 1095, 601}},
    {748, 13, 1735, {1, 1, 1, 15, 11, 43, 49, 205, 393, 921, 625, 359, 3997}},
    {749, 13, 1747, {1, 1, 3, 7, 31, 21, 27, 231, 159, 67, 1127, 2153, 6291}},
    {750, 13, 1749, {1, 3, 1, 1, 13, 15, 45, 85, 155, 763, 1341, 9, 6229}},
    {751, 13, 1754, {1, 3, 7, 15, 9, 21, 47, 67, 207, 385, 401, 1665, 7849}},
    {752, 13, 1777, {1, 1, 5, 9, 13, 59, 89, 163, 19, 997, 2021, 3301, 2945}},
    {753, 13, 1784, {1, 1, 3, 15, 17, 9, 33, 117, 33, 701, 73, 2955, 1781}},
    {754, 13, 1790, {1, 1, 3, 7, 3, 11, 81, 209, 131, 247, 1927, 3997, 1709}},
    {755, 13, 1795, {1, 1, 3, 5, 21, 47, 85, 163, 247, 273, 545, 3477, 4565}},
    {756, 13, 1801, {1, 1, 1, 15, 3, 5, 55, 171, 501, 149, 121, 2317, 2023}},
    {757, 13, 1802, {1, 1, 5, 1, 25, 31, 25, 171, 471, 149, 49, 3059, 7871}},
    {758, 13, 1812, {1, 3, 3, 1, 3, 39, 91, 75, 183, 115, 869, 4005, 1443}},
    {759, 13, 1828, {1, 1, 1, 13, 31, 37, 3, 23, 443, 177, 219, 1683, 7063}},
    {760, 13, 1831, {1, 1, 1, 11, 17, 51, 111, 157, 455, 415, 1171, 531, 7289}},
    {761, 13, 1837, {1, 1, 7, 13, 3, 45, 103, 185, 63, 299, 1471, 3579, 3751}},
    {762, 13, 1838, {1, 1, 7, 7, 25, 45, 91, 145, 285, 525, 1675, 665, 883}},
    {763, 13, 1840, {1, 3, 7, 5, 23, 23, 33, 47, 271, 65, 1009, 2363, 7231}},
    {764, 13, 1845, {1, 3, 1, 11, 25, 3, 13, 105, 105, 649, 531, 535, 6019}},
    {765, 13, 1863, {1, 3, 3, 5, 9, 1, 9, 15, 131, 793, 1841, 2249, 5775}},
    {766, 13, 1864, {1, 1, 7, 7, 27, 35, 125, 249, 125, 973, 233, 229, 8165}},
    {767, 13, 1867, {1, 3, 1, 7, 19, 1, 39, 239, 159, 627, 601, 1537, 7473}},
    {768, 13, 1870, {1, 1, 3, 3, 1, 45, 99, 149, 205, 277, 1701, 121, 1577}},
    {769, 13, 1877, {1, 3, 7, 15, 9, 43, 7, 139, 331, 995, 647, 2707, 4493}},
    {770, 13, 1881, {1, 3, 3, 13, 19, 31, 67, 213, 355, 85, 1829, 2897, 6799}},
    {771, 13, 1884, {1, 3, 7, 1, 29, 51, 49, 209, 257, 913, 811, 895, 8051}},
    {772, 13, 1903, {1, 1, 3, 3, 31, 33, 19, 37, 297, 473, 1987, 3433, 1981}},
    {773, 13, 1917, {1, 1, 1, 13, 1, 3, 127, 183, 241, 941, 973, 577, 6891}},
    {774, 13, 1918, {1, 1, 7, 15, 31, 21, 125, 193, 23, 731, 493, 3173, 4381}},
    {775, 13, 1922, {1, 3, 3, 13, 23, 31, 65, 59, 63, 285, 1191, 3005, 2211}},
    {776, 13, 1924, {1, 1, 3, 3, 13, 11, 121, 153, 199, 359, 1159, 363, 3477}},
    {777, 13, 1928, {1, 1, 3, 3, 29, 27, 105, 215, 143, 365, 369, 3341, 5017}},
    {778, 13, 1931, {1, 1, 5, 9, 23, 43, 119, 89, 307, 607, 1087, 287, 7305}},
    {779, 13, 1951, {1, 1, 7, 3, 19, 9, 115, 133, 387, 717, 687, 3447, 201}},
    {780, 13, 1952, {1, 3, 1, 1, 23, 7, 81, 77, 483, 725, 1499, 1565, 8073}},
    {781, 13, 1957, {1, 3, 1, 9, 23, 25, 119, 247, 195, 205, 1851, 2463, 6827}},
    {782, 13, 1958, {1, 3, 5, 9, 17, 51, 11, 233, 115, 719, 1333, 3829, 4941}},
    {783, 13, 1964, {1, 1, 3, 13, 25, 17, 103, 241, 133, 237, 1375, 4005, 7853}},
    {784, 13, 1967, {1, 3, 7, 1, 19, 31, 115, 193, 305, 1, 1167, 325, 985}},
    {785, 13, 1970, {1, 1, 3, 15, 13, 11, 33, 27, 453, 941, 293, 2819, 3247}},
    {786, 13, 1972, {1, 3, 3, 3, 11, 27, 37, 95, 371, 441, 1347, 13, 4219}},
    {787, 13, 1994, {1, 3, 1, 11, 31, 39, 17, 63, 323, 1013, 479, 4077, 313}},
    {788, 13, 2002, {1, 3, 7, 15, 3, 59, 121, 19, 43, 351, 285, 2239, 8117}},
    {789, 13, 2007, {1, 1, 3, 3, 7, 7, 13, 31, 403, 925, 789, 275, 6959}},
    {790, 13, 2008, {1, 1, 1, 9, 3, 11, 89, 195, 393, 301, 517, 1675, 963}},
    {791, 13, 2023, {1, 3, 1, 13, 17, 63, 79, 17, 127, 119, 1127, 2121, 7545}},
    {792, 13, 2030, {1, 3, 5, 5, 29, 15, 97, 183, 157, 319, 1047, 895, 7297}},
    {793, 13, 2035, {1, 3, 1, 3, 25, 37, 101, 233, 275, 705, 1147, 1511, 231}},
    {794, 13, 2038, {1, 3, 1, 11, 3, 63, 45, 219, 315, 905, 9, 3105, 785}},
    {795, 13, 2042, {1, 1, 3, 1, 17, 27, 89, 15, 337, 981, 403, 1609, 349}},
    {796, 13, 2047, {1, 3, 1, 5, 27, 21, 39, 209, 461, 211, 71, 1413, 1185}},
    {797, 13, 2051, {1, 1, 3, 1, 11, 9, 19, 229, 403, 323, 1651, 475, 1207}},
    {798, 13, 2058, {1, 3, 7, 5, 31, 13, 39, 9, 365, 857, 1715, 3831, 2467}},
    {799, 13, 2060, {1, 1, 7, 1, 31, 41, 25, 101, 297, 143, 345, 2097, 1679}},
    {800, 13, 2071, {1, 3, 5, 7, 27, 61, 77, 107, 291, 265, 759, 933, 2529}},
    {801, 13, 2084, {1, 3, 7, 11, 15, 51, 31, 191, 39, 469, 1711, 1215, 7603}},
    {802, 13, 2087, {1, 1, 5, 13, 19, 27, 121, 235, 475, 11, 1193, 543, 5689}},
    {803, 13, 2099, {1, 3, 5, 11, 19, 1, 97, 85, 393, 971, 1915, 3487, 7569}},
    {804, 13, 2108, {1, 3, 7, 9, 21, 25, 81, 197, 9, 403, 1305, 2977, 6261}},
    {805, 13, 2111, {1, 3, 3, 15, 5, 3, 5, 91, 133, 957, 437, 3821, 4395}},
    {806, 13, 2120, {1, 3, 7, 7, 23, 47, 85, 139, 511, 389, 461, 2967, 7305}},
    {807, 13, 2128, {1, 3, 5, 5, 13, 3, 33, 171, 391, 109, 197, 2097, 5357}},
    {808, 13, 2138, {1, 3, 7, 15, 31, 61, 7, 61, 175, 455, 1867, 2829, 197}},
    {809, 13, 2143, {1, 3, 7, 13, 21, 33, 119, 97, 297, 69, 1503, 2887, 3785}},
    {810, 13, 2144, {1, 3, 3, 7, 1, 63, 105, 53, 443, 775, 1855, 2635, 4453}},
    {811, 13, 2153, {1, 1, 7, 11, 1, 13, 99, 227, 421, 739, 583, 4011, 2095}},
    {812, 13, 2156, {1, 1, 7, 11, 7, 21, 125, 45, 411, 621, 137, 259, 3401}},
    {813, 13, 2162, {1, 3, 3, 7, 9, 15, 47, 213, 71, 725, 2015, 3119, 3295}},
    {814, 13, 2167, {1, 1, 7, 7, 21, 63, 83, 63, 29, 969, 119, 3535, 989}},
    {815, 13, 2178, {1, 3, 3, 9, 13, 15, 71, 83, 209, 191, 1049, 3423, 5829}},
    {816, 13, 2183, {1, 3, 1, 11, 27, 7, 65, 107, 387, 853, 919, 1257, 719}},
    {817, 13, 2202, {1, 3, 1, 9, 29, 63, 115, 91, 181, 217, 1097, 1023, 3641}},
    {818, 13, 2211, {1, 1, 3, 7, 7, 57, 37, 209, 99, 959, 693, 1573, 3407}},
    {819, 13, 2214, {1, 3, 7, 7, 9, 51, 51, 127, 153, 977, 1565, 1329, 4603}},
    {820, 13, 2223, {1, 3, 5, 3, 9, 57, 7, 225, 139, 515, 1355, 191, 659}},
    {821, 13, 2225, {1, 3, 3, 3, 7, 45, 85, 231, 153, 93, 371, 2753, 5331}},
    {822, 13, 2232, {1, 1, 5, 5, 1, 9, 45, 29, 131, 203, 31, 1219, 1635}},
    {823, 13, 2237, {1, 1, 1, 11, 5, 13, 115, 51, 471, 987, 1937, 3921, 7885}},
    {824, 13, 2257, {1, 1, 7, 3, 1, 23, 49, 183, 495, 427, 1397, 3383, 3459}},
    {825, 13, 2260, {1, 1, 7, 1, 23, 39, 3, 205, 447, 603, 1213, 667, 1039}},
    {826, 13, 2267, {1, 1, 1, 5, 7, 63, 27, 169, 403, 775, 241, 3951, 3411}},
    {827, 13, 2274, {1, 1, 3, 1, 7, 1, 63, 185, 197, 813, 1757, 2687, 7289}},
    {828, 13, 2276, {1, 1, 7, 3, 21, 21, 97, 73, 73, 147, 1905, 2391, 3743}},
    {829, 13, 2285, {1, 3, 7, 1, 29, 45, 27, 93, 71, 749, 337, 7, 3959}},
    {830, 13, 2288, {1, 3, 3, 9, 25, 13, 61, 131, 183, 409, 1547, 1261, 5541}},
    {831, 13, 2293, {1, 1, 7, 9, 9, 13, 13, 115, 87, 587, 1561, 1845, 2383}},
    {832, 13, 2294, {1, 3, 3, 3, 13, 19, 99, 75, 435, 815, 251, 1639, 2157}},
    {833, 13, 2297, {1, 1, 7, 9, 19, 61, 49, 237, 325, 429, 1019, 2649, 6671}},
    {834, 13, 2303, {1, 3, 3, 11, 1, 59, 71, 143, 37, 445, 1289, 2089, 5693}},
    {835, 13, 2308, {1, 3, 3, 7, 13, 13, 119, 83, 111, 497, 739, 863, 2009}},
    {836, 13, 2311, {1, 3, 5, 1, 3, 21, 89, 27, 171, 121, 1453, 3273, 2891}},
    {837, 13, 2318, {1, 3, 5, 5, 29, 19, 79, 77, 343, 969, 1759, 1921, 4189}},
    {838, 13, 2323, {1, 1, 1, 3, 21, 55, 99, 49, 435, 697, 559, 3475, 6905}},
    {839, 13, 2332, {1, 3, 1, 5, 9, 37, 83, 79, 171, 935, 751, 3293, 299}},
    {840, 13, 2341, {1, 1, 3, 13, 13, 45, 35, 159, 283, 451, 495, 3239, 4429}},
    {841, 13, 2345, {1, 1, 3, 1, 13, 43, 107, 189, 475, 679, 1843, 33, 6895}},
    {842, 13, 2348, {1, 3, 5, 9, 17, 13, 107, 245, 415, 531, 265, 3165, 3189}},
    {843, 13, 2354, {1, 3, 1, 3, 31, 29, 103, 233, 31, 445, 649, 3377, 3207}},
    {844, 13, 2368, {1, 1, 3, 9, 19, 3, 1, 75, 423, 445, 1351, 2889, 5785}},
    {845, 13, 2377, {1, 1, 3, 3, 21, 19, 113, 35, 173, 871, 275, 1901, 6725}},
    {846, 13, 2380, {1, 1, 3, 7, 27, 45, 41, 93, 463, 209, 1721, 1863, 7893}},
    {847, 13, 2383, {1, 1, 1, 13, 25, 63, 17, 171, 403, 645, 1669, 1663, 4335}},
    {848, 13, 2388, {1, 3, 3, 7, 17, 15, 103, 5, 375, 7, 1117, 3851, 651}},
    {849, 13, 2395, {1, 1, 1, 15, 29, 43, 13, 241, 403, 349, 685, 987, 4177}},
    {850, 13, 2397, {1, 3, 5, 15, 31, 37, 111, 91, 391, 513, 1701, 2861, 4713}},
    {851, 13, 2401, {1, 1, 5, 9, 23, 59, 125, 117, 375, 461, 1697, 1283, 7395}},
    {852, 13, 2411, {1, 1, 3, 7, 21, 35, 101, 131, 129, 757, 199, 1881, 737}},
    {853, 13, 2413, {1, 1, 7, 3, 31, 15, 121, 143, 67, 593, 1143, 3761, 3441}},
    {854, 13, 2419, {1, 1, 3, 9, 11, 43, 7, 159, 25, 725, 1169, 1757, 3499}},
    {855, 13, 2435, {1, 1, 3, 9, 5, 55, 77, 85, 309, 113, 1419, 1255, 4777}},
    {856, 13, 2442, {1, 3, 3, 15, 19, 41, 75, 163, 51, 511, 1785, 4033, 7791}},
    {857, 13, 2455, {1, 3, 7, 15, 29, 45, 81, 189, 401, 71, 1597, 3671, 2133}},
    {858, 13, 2472, {1, 1, 3, 1, 3, 17, 119, 55, 217, 485, 1217, 1475, 5791}},
    {859, 13, 2478, {1, 1, 7, 9, 21, 61, 71, 175, 205, 413, 1645, 2375, 89}},
    {860, 13, 2490, {1, 3, 3, 7, 25, 35, 23, 49, 395, 675, 341, 959, 4665}},
    {861, 13, 2507, {1, 3, 5, 15, 21, 37, 99, 151, 197, 145, 2043, 755, 2523}},
    {862, 13, 2509, {1, 1, 1, 7, 1, 61, 75, 131, 65, 891, 349, 2767, 3855}},
    {863, 13, 2517, {1, 3, 5, 9, 29, 57, 61, 79, 303, 997, 1053, 1973, 1547}},
    {864, 13, 2524, {1, 1, 3, 7, 19, 9, 57, 197, 253, 597, 1971, 1831, 8097}},
    {865, 13, 2528, {1, 3, 1, 9, 3, 13, 29, 169, 25, 957, 1575, 2955, 3549}},
    {866, 13, 2531, {1, 1, 5, 11, 17, 37, 79, 91, 11, 687, 1511, 1065, 1539}},
    {867, 13, 2538, {1, 1, 1, 7, 1, 59, 1, 49, 23, 73, 881, 1661, 3841}},
    {868, 13, 2545, {1, 1, 1, 1, 13, 57, 111, 67, 511, 833, 1095, 15, 569}},
    {869, 13, 2546, {1, 3, 1, 5, 17, 33, 1, 161, 311, 29, 685, 729, 5981}},
    {870, 13, 2555, {1, 1, 7, 1, 7, 13, 49, 55, 251, 825, 709, 445, 7439}},
    {871, 13, 2557, {1, 3, 1, 5, 13, 55, 101, 89, 239, 907, 1559, 1421, 87}},
    {872, 13, 2564, {1, 1, 3, 9, 23, 27, 41, 189, 35, 155, 683, 2491, 7495}},
    {873, 13, 2573, {1, 3, 5, 3, 5, 47, 39, 161, 279, 945, 365, 15, 4643}},
    {874, 13, 2579, {1, 1, 1, 11, 21, 7, 125, 195, 23, 635, 1949, 2237, 1885}},
    {875, 13, 2592, {1, 1, 3, 7, 13, 25, 105, 145, 203, 701, 1525, 1391, 1637}},
    {876, 13, 2598, {1, 3, 3, 13, 7, 43, 13, 39, 301, 507, 405, 2333, 2405}},
    {877, 13, 2607, {1, 1, 5, 15, 25, 19, 31, 67, 81, 781, 1541, 3743, 2787}},
    {878, 13, 2612, {1, 1, 1, 11, 15, 7, 87, 129, 151, 225, 655, 1569, 5299}},
    {879, 13, 2619, {1, 1, 5, 3, 3, 33, 97, 255, 9, 667, 787, 3557, 5273}},
    {880, 13, 2621, {1, 1, 3, 3, 1, 7, 13, 31, 31, 1021, 1863, 2897, 6389}},
    {881, 13, 2627, {1, 3, 1, 15, 13, 29, 93, 27, 229, 599, 521, 1631, 3683}},
    {882, 13, 2633, {1, 1, 7, 9, 11, 27, 43, 95, 149, 159, 495, 2711, 2189}},
    {883, 13, 2636, {1, 1, 7, 9, 11, 51, 43, 121, 299, 73, 1991, 561, 6781}},
    {884, 13, 2642, {1, 1, 3, 3, 7, 61, 125, 13, 415, 11, 15, 2463, 385}},
    {885, 13, 2654, {1, 3, 5, 1, 27, 23, 1, 47, 149, 371, 1599, 341, 1595}},
    {886, 13, 2660, {1, 1, 1, 15, 3, 39, 65, 5, 33, 713, 399, 2935, 3825}},
    {887, 13, 2669, {1, 1, 7, 7, 17, 39, 3, 235, 227, 231, 323, 2869, 4747}},
    {888, 13, 2675, {1, 1, 5, 9, 13, 11, 41, 155, 393, 701, 909, 2999, 5053}},
    {889, 13, 2684, {1, 1, 3, 7, 5, 41, 105, 13, 123, 429, 1455, 2501, 1065}},
    {890, 13, 2694, {1, 1, 1, 7, 17, 21, 95, 141, 305, 951, 1305, 3639, 3797}},
    {891, 13, 2703, {1, 3, 5, 9, 7, 59, 29, 129, 265, 889, 993, 1411, 2069}},
    {892, 13, 2706, {1, 1, 1, 11, 3, 51, 9, 35, 355, 131, 1307, 1547, 701}},
    {893, 13, 2712, {1, 1, 7, 3, 17, 57, 113, 197, 483, 831, 1741, 3897, 3649}},
    {894, 13, 2715, {1, 1, 5, 11, 1, 33, 7, 243, 95, 905, 1933, 2123, 7381}},
    {895, 13, 2722, {1, 3, 3, 15, 5, 37, 1, 235, 77, 375, 1231, 1029, 1839}},
    {896, 13, 2727, {1, 1, 5, 3, 31, 11, 103, 245, 373, 103, 25, 1283, 6155}},
    {897, 13, 2734, {1, 3, 5, 1, 25, 25, 51, 159, 381, 97, 799, 565, 5165}},
    {898, 13, 2742, {1, 1, 7, 13, 25, 21, 109, 3, 253, 459, 623, 2817, 7815}},
    {899, 13, 2745, {1, 3, 5, 1, 23, 5, 127, 157, 187, 187, 1383, 2777, 2413}},
    {900, 13, 2751, {1, 1, 5, 3, 29, 47, 97, 197, 215, 725, 445, 2111, 1701}},
    {901, 13, 2766, {1, 3, 1, 9, 27, 25, 105, 59, 333, 79, 1099, 3695, 5725}},
    {902, 13, 2768, {1, 1, 7, 3, 11, 15, 127, 151, 163, 967, 665, 733, 509}},
    {903, 13, 2780, {1, 3, 3, 3, 15, 5, 51, 17, 409, 679, 229, 1037, 353}},
    {904, 13, 2790, {1, 3, 7, 15, 7, 9, 17, 115, 205, 105, 597, 2913, 1941}},
    {905, 13, 2794, {1, 1, 5, 11, 31, 1, 99, 213, 33, 319, 617, 1493, 7287}},
    {906, 13, 2796, {1, 3, 5, 5, 21, 31, 115, 43, 309, 217, 1, 3363, 6673}},
    {907, 13, 2801, {1, 3, 7, 7, 11, 29, 125, 75, 209, 217, 1749, 1565, 4431}},
    {908, 13, 2804, {1, 3, 5, 1, 5, 37, 103, 237, 19, 763, 915, 753, 7479}},
    {909, 13, 2807, {1, 3, 3, 9, 11, 59, 9, 133, 455, 683, 251, 963, 3743}},
    {910, 13, 2816, {1, 3, 5, 9, 7, 41, 97, 185, 117, 367, 2045, 3013, 6249}},
    {911, 13, 2821, {1, 1, 1, 5, 29, 51, 53, 147, 379, 769, 865, 2273, 1755}},
    {912, 13, 2831, {1, 3, 1, 7, 13, 61, 125, 153, 297, 385, 1981, 2221, 4209}},
    {913, 13, 2834, {1, 1, 7, 15, 7, 33, 41, 43, 201, 819, 129, 757, 4087}},
    {914, 13, 2839, {1, 1, 5, 7, 31, 15, 19, 15, 197, 921, 1967, 491, 4911}},
    {915, 13, 2845, {1, 1, 1, 13, 21, 25, 119, 123, 255, 155, 1765, 2895, 4201}},
    {916, 13, 2852, {1, 3, 5, 9, 1, 63, 57, 193, 327, 455, 1729, 1259, 7483}},
    {917, 13, 2856, {1, 3, 5, 1, 5, 19, 71, 255, 257, 477, 1799, 3855, 955}},
    {918, 13, 2861, {1, 1, 3, 1, 29, 27, 7, 151, 327, 311, 235, 3599, 6165}},
    {919, 13, 2873, {1, 3, 3, 3, 7, 29, 113, 87, 339, 271, 1141, 1111, 7971}},
    {920, 13, 2874, {1, 3, 5, 15, 23, 51, 57, 233, 179, 397, 1059, 123, 697}},
    {921, 13, 2888, {1, 3, 3, 13, 17, 11, 15, 189, 437, 449, 1533, 2209, 1849}},
    {922, 13, 2893, {1, 3, 5, 9, 9, 19, 53, 165, 279, 875, 1223, 1585, 6647}},
    {923, 13, 2894, {1, 1, 7, 5, 5, 49, 119, 31, 273, 919, 413, 1531, 6233}},
    {924, 13, 2902, {1, 3, 5, 5, 1, 19, 27, 213, 413, 271, 223, 299, 5635}},
    {925, 13, 2917, {1, 1, 7, 3, 11, 55, 25, 43, 147, 53, 95, 1849, 7701}},
    {926, 13, 2921, {1, 3, 5, 11, 17, 35, 9, 3, 117, 729, 21, 3379, 5963}},
    {927, 13, 2922, {1, 3, 1, 7, 23, 25, 45, 103, 181, 677, 1155, 205, 1967}},
    {928, 13, 2929, {1, 1, 3, 9, 19, 53, 41, 243, 97, 199, 407, 3299, 5309}},
    {929, 13, 2935, {1, 3, 5, 11, 27, 27, 59, 153, 501, 855, 1235, 2295, 5535}},
    {930, 13, 2946, {1, 1, 3, 7, 11, 37, 1, 179, 289, 895, 511, 697, 5067}},
    {931, 13, 2951, {1, 3, 7, 15, 25, 27, 33, 37, 351, 351, 813, 2239, 1561}},
    {932, 13, 2957, {1, 3, 1, 7, 25, 51, 79, 65, 427, 293, 1031, 685, 533}},
    {933, 13, 2960, {1, 3, 3, 15, 21, 21, 77, 31, 299, 643, 161, 2991, 7911}},
    {934, 13, 2966, {1, 3, 3, 7, 7, 61, 99, 19, 43, 35, 687, 1449, 5211}},
    {935, 13, 2972, {1, 3, 1, 5, 5, 59, 101, 175, 149, 799, 439, 19, 7565}},
    {936, 13, 2976, {1, 3, 7, 9, 31, 13, 75, 227, 337, 207, 609, 2119, 3539}},
    {937, 13, 2979, {1, 1, 1, 11, 3, 59, 1, 139, 425, 583, 263, 2687, 4445}},
    {938, 13, 2985, {1, 1, 5, 7, 21, 31, 55, 117, 377, 469, 1907, 3091, 3221}},
    {939, 13, 3000, {1, 1, 5, 1, 7, 63, 89, 197, 271, 425, 1493, 2337, 6397}},
    {940, 13, 3003, {1, 1, 1, 7, 9, 35, 17, 237, 215, 211, 523, 3095, 1771}},
    {941, 13, 3013, {1, 1, 5, 5, 19, 23, 119, 31, 331, 533, 71, 319, 7567}},
    {942, 13, 3018, {1, 1, 5, 7, 1, 33, 41, 9, 421, 789, 1305, 3775, 6545}},
    {943, 13, 3020, {1, 3, 1, 11, 17, 9, 47, 237, 227, 859, 113, 429, 5399}},
    {944, 13, 3025, {1, 3, 5, 11, 25, 29, 15, 1, 73, 1015, 2023, 367, 1523}},
    {945, 13, 3042, {1, 1, 5, 11, 19, 31, 121, 243, 411, 717, 671, 1329, 2669}},
    {946, 13, 3047, {1, 1, 1, 11, 27, 41, 23, 13, 353, 533, 1627, 1625, 3705}},
    {947, 13, 3048, {1, 1, 7, 11, 31, 41, 17, 3, 163, 207, 407, 1475, 5911}},
    {948, 13, 3051, {1, 1, 7, 3, 3, 19, 87, 199, 77, 207, 1957, 1691, 5045}},
    {949, 13, 3054, {1, 1, 1, 3, 19, 57, 107, 37, 419, 943, 133, 519, 4391}},
    {950, 13, 3056, {1, 3, 5, 11, 7, 5, 85, 1, 265, 801, 2025, 2655, 4635}},
    {951, 13, 3065, {1, 3, 3, 3, 7, 13, 15, 155, 283, 97, 1311, 607, 2879}},
    {952, 13, 3073, {1, 1, 5, 9, 21, 31, 3, 237, 323, 749, 1879, 611, 6763}},
    {953, 13, 3074, {1, 3, 5, 9, 19, 51, 25, 39, 7, 973, 837, 105, 1987}},
    {954, 13, 3083, {1, 1, 5, 13, 9, 63, 39, 233, 391, 93, 1741, 425, 901}},
    {955, 13, 3086, {1, 3, 7, 13, 13, 23, 95, 195, 263, 71, 255, 1839, 4301}},
    {956, 13, 3091, {1, 3, 1, 3, 29, 35, 123, 145, 377, 1021, 1361, 2319, 1487}},
    {957, 13, 3097, {1, 3, 7, 15, 9, 27, 61, 85, 81, 371, 1803, 3683, 4771}},
    {958, 13, 3109, {1, 3, 7, 15, 9, 35, 51, 137, 3, 721, 1269, 2667, 7293}},
    {959, 13, 3116, {1, 1, 3, 15, 3, 53, 121, 227, 55, 937, 1623, 2691, 2353}},
    {960, 13, 3124, {1, 3, 1, 5, 7, 53, 53, 121, 299, 633, 263, 3651, 3187}},
    {961, 13, 3128, {1, 3, 1, 9, 31, 59, 73, 5, 475, 763, 115, 2263, 2475}},
    {962, 13, 3153, {1, 3, 3, 7, 13, 15, 49, 227, 285, 41, 1817, 2573, 4991}},
    {963, 13, 3160, {1, 3, 5, 3, 17, 7, 29, 93, 253, 527, 657, 1859, 763}},
    {964, 13, 3165, {1, 1, 5, 11, 9, 11, 75, 47, 469, 119, 1505, 3807, 2769}},
    {965, 13, 3172, {1, 1, 3, 11, 1, 37, 65, 135, 345, 307, 305, 1167, 1767}},
    {966, 13, 3175, {1, 3, 3, 13, 5, 33, 9, 245, 271, 123, 1865, 2215, 2791}},
    {967, 13, 3184, {1, 1, 3, 1, 9, 23, 3, 21, 149, 923, 1335, 1015, 45}},
    {968, 13, 3193, {1, 3, 1, 15, 11, 3, 65, 219, 233, 353, 771, 3961, 1515}},
    {969, 13, 3196, {1, 3, 1, 5, 15, 41, 87, 141, 19, 905, 449, 3727, 1875}},
    {970, 13, 3200, {1, 1, 7, 9, 11, 15, 53, 151, 243, 279, 1695, 2317, 6661}},
    {971, 13, 3203, {1, 3, 3, 7, 19, 51, 31, 157, 79, 399, 465, 661, 1029}},
    {972, 13, 3205, {1, 3, 5, 1, 5, 41, 3, 33, 157, 385, 1943, 1851, 3121}},
    {973, 13, 3209, {1, 3, 1, 11, 25, 59, 105, 191, 151, 285, 801, 201, 6871}},
    {974, 13, 3224, {1, 3, 1, 15, 27, 35, 17, 195, 387, 907, 1905, 2177, 2597}},
    {975, 13, 3239, {1, 3, 1, 9, 31, 43, 71, 185, 469, 809, 541, 571, 107}},
    {976, 13, 3251, {1, 3, 7, 13, 5, 15, 55, 211, 305, 645, 1317, 2751, 603}},
    {977, 13, 3254, {1, 1, 3, 15, 19, 59, 45, 147, 165, 223, 259, 1205, 431}},
    {978, 13, 3265, {1, 1, 5, 13, 5, 53, 115, 57, 203, 151, 1039, 871, 3881}},
    {979, 13, 3266, {1, 3, 5, 15, 1, 29, 115, 249, 79, 957, 143, 3425, 5769}},
    {980, 13, 3275, {1, 1, 7, 15, 15, 15, 117, 181, 363, 17, 1871, 1049, 2997}},
    {981, 13, 3280, {1, 1, 3, 7, 23, 11, 77, 123, 149, 1019, 93, 3637, 6975}},
    {982, 13, 3283, {1, 1, 1, 7, 5, 51, 77, 89, 121, 155, 1839, 1301, 2771}},
    {983, 13, 3286, {1, 3, 7, 7, 7, 39, 33, 69, 169, 535, 1699, 2117, 3233}},
    {984, 13, 3301, {1, 3, 5, 7, 3, 59, 81, 113, 261, 627, 79, 227, 7623}},
    {985, 13, 3302, {1, 3, 5, 5, 13, 57, 121, 41, 11, 111, 1055, 3313, 3371}},
    {986, 13, 3305, {1, 1, 3, 13, 13, 9, 47, 197, 303, 987, 1125, 2461, 5007}},
    {987, 13, 3319, {1, 3, 1, 5, 1, 59, 109, 49, 453, 673, 2017, 205, 4673}},
    {988, 13, 3323, {1, 3, 1, 13, 19, 43, 95, 247, 475, 193, 1513, 885, 5391}},
    {989, 13, 3326, {1, 1, 1, 11, 29, 57, 77, 101, 433, 537, 1681, 2463, 6623}},
    {990, 13, 3331, {1, 3, 7, 13, 3, 61, 29, 53, 29, 673, 1037, 3877, 7421}},
    {991, 13, 3348, {1, 3, 3, 11, 5, 59, 61, 91, 13, 949, 1093, 1291, 7395}},
    {992, 13, 3351, {1, 3, 3, 13, 21, 27, 49, 37, 429, 877, 1247, 2375, 737}},
    {993, 13, 3358, {1, 3, 5, 3, 25, 19, 75, 187, 239, 971, 859, 2519, 7323}},
    {994, 13, 3368, {1, 3, 3, 7, 25, 19, 11, 223, 75, 801, 313, 2875, 6857}},
    {995, 13, 3374, {1, 1, 7, 3, 13, 63, 49, 125, 65, 1005, 1757, 3685, 4385}},
    {996, 13, 3376, {1, 3, 1, 15, 5, 41, 95, 231, 505, 907, 751, 3207, 4115}},
    {997, 13, 3379, {1, 1, 7, 11, 31, 7, 29, 51, 449, 151, 1821, 3317, 931}},
    {998, 13, 3385, {1, 3, 1, 11, 19, 11, 19, 47, 111, 637, 37, 3707, 2599}},
    {999, 13, 3386, {1, 3, 7, 5, 23, 27, 65, 217, 491, 129, 1715, 2479, 2015}},
    {1000, 13, 3396, {1, 1, 5, 3, 5, 51, 43, 253, 495, 105, 1183, 3409, 1469}},
    {1001, 13, 3420, {1, 3, 7, 9, 21, 5, 87, 67, 481, 405, 1967, 2837, 5161}},
    {1002, 13, 3423, {1, 1, 7, 3, 29, 25, 15, 211, 233, 301, 1037, 3853, 7115}},
    {1003, 13, 3430, {1, 3, 5, 9, 3, 15, 85, 81, 141, 395, 845, 17, 7485}},
    {1004, 13, 3433, {1, 3, 5, 3, 21, 37, 39, 93, 461, 615, 1725, 1745, 5137}},
    {1005, 13, 3434, {1, 1, 3, 1, 1, 21, 21, 207, 271, 447, 1415, 2507, 3291}},
    {1006, 13, 3439, {1, 3, 7, 11, 23, 3, 115, 191, 257, 1015, 463, 1501, 7439}},
    {1007, 13, 3442, {1, 1, 7, 11, 3, 53, 101, 221, 9, 225, 1799, 1701, 5669}},
    {1008, 13, 3444, {1, 1, 7, 13, 17, 27, 7, 115, 67, 645, 1283, 75, 1881}},
    {1009, 13, 3453, {1, 1, 3, 15, 7, 39, 75, 85, 127, 379, 1509, 2215, 5697}},
    {1010, 13, 3464, {1, 1, 7, 1, 19, 31, 11, 67, 263, 877, 337, 1655, 1855}},
    {1011, 13, 3477, {1, 3, 5, 9, 11, 47, 125, 89, 235, 331, 159, 685, 999}},
    {1012, 13, 3478, {1, 3, 7, 3, 23, 39, 59, 69, 221, 291, 725, 2831, 4743}},
    {1013, 13, 3482, {1, 3, 7, 11, 1, 43, 127, 235, 143, 329, 1823, 21, 73}},
    {1014, 13, 3487, {1, 3, 1, 3, 27, 23, 33, 29, 493, 775, 1873, 1005, 2869}},
    {1015, 13, 3497, {1, 3, 3, 9, 3, 31, 63, 249, 353, 849, 5, 2787, 4759}},
    {1016, 13, 3500, {1, 3, 3, 11, 15, 15, 73, 159, 433, 35, 1203, 2541, 6713}},
    {1017, 13, 3505, {1, 1, 5, 1, 13, 17, 107, 101, 411, 861, 1075, 2161, 3923}},
    {1018, 13, 3506, {1, 1, 3, 5, 29, 29, 55, 205, 235, 685, 1445, 2413, 6837}},
    {1019, 13, 3511, {1, 1, 1, 13, 13, 1, 125, 37, 331, 33, 47, 2761, 3449}},
    {1020, 13, 3512, {1, 1, 7, 3, 17, 21, 21, 93, 145, 423, 1057, 997, 6117}},
    {1021, 13, 3515, {1, 3, 3, 13, 25, 47, 13, 159, 41, 907, 1543, 1919, 5547}},
    {1022, 13, 3525, {1, 1, 3, 9, 29, 53, 83, 45, 133, 453, 183, 2939, 4945}},
    {1023, 13, 3532, {1, 1, 1, 7, 9, 7, 89, 71, 315, 983, 1471, 2475, 7077}},
    {1024, 13, 3538, {1, 1, 3, 3, 31, 21, 55, 37, 337, 63, 299, 2415, 153}},
    {1025, 13, 3540, {1, 1, 7, 3, 27, 59, 85, 109, 405, 337, 393, 2291, 5423}},
    {1026, 13, 3547, {1, 1, 1, 1, 5, 31, 33, 43, 141, 9, 1271, 1749, 6281}},
    {1027, 13, 3549, {1, 1, 3, 9, 23, 35, 25, 17, 49, 119, 883, 2907, 3573}},
    {1028, 13, 3560, {1, 3, 1, 15, 25, 61, 89, 15, 315, 1015, 563, 1895, 4123}},
    {1029, 13, 3571, {1, 3, 3, 7, 15, 53, 61, 225, 381, 217, 163, 4005, 7269}},
    {1030, 13, 3577, {1, 3, 7, 5, 1, 59, 13, 201, 53, 629, 1917, 3105, 3047}},
    {1031, 13, 3583, {1, 3, 1, 1, 19, 45, 71, 11, 15, 365, 1223, 3861, 5005}},
    {1032, 13, 3590, {1, 1, 5, 11, 15, 15, 31, 245, 105, 609, 1051, 1911, 7531}},
    {1033, 13, 3593, {1, 3, 7, 11, 27, 5, 79, 31, 201, 347, 1295, 2589, 5179}},
    {1034, 13, 3594, {1, 1, 3, 1, 31, 23, 65, 203, 359, 591, 1459, 1941, 2307}},
    {1035, 13, 3599, {1, 1, 5, 5, 3, 55, 79, 179, 147, 223, 1011, 1437, 3715}},
    {1036, 13, 3601, {1, 1, 5, 11, 23, 19, 57, 241, 363, 729, 1647, 2395, 3237}},
    {1037, 13, 3602, {1, 3, 7, 7, 7, 63, 115, 53, 485, 965, 551, 3945, 1535}},
    {1038, 13, 3613, {1, 1, 1, 15, 5, 61, 33, 213, 451, 363, 95, 1185, 3633}},
    {1039, 13, 3623, {1, 3, 5, 1, 17, 49, 39, 159, 327, 1021, 289, 3375, 8055}},
    {1040, 13, 3630, {1, 3, 3, 5, 11, 1, 73, 3, 121, 561, 209, 1913, 4549}},
    {1041, 13, 3638, {1, 3, 1, 3, 23, 39, 101, 231, 317, 397, 693, 1579, 3585}},
    {1042, 13, 3649, {1, 1, 1, 1, 1, 5, 81, 209, 373, 689, 259, 3167, 1665}},
    {1043, 13, 3655, {1, 1, 1, 11, 21, 19, 83, 201, 7, 573, 1563, 1649, 5827}},
    {1044, 13, 3662, {1, 3, 5, 1, 31, 35, 53, 149, 185, 925, 701, 3727, 4425}},
    {1045, 13, 3667, {1, 1, 5, 7, 19, 11, 67, 47, 19, 789, 1855, 293, 7569}},
    {1046, 13, 3669, {1, 1, 5, 13, 25, 55, 25, 187, 405, 1013, 493, 1645, 6753}},
    {1047, 13, 3676, {1, 1, 3, 11, 13, 23, 35, 219, 247, 723, 1079, 1523, 7383}},
    {1048, 13, 3683, {1, 1, 3, 13, 5, 1, 27, 151, 61, 889, 1911, 3859, 4661}},
    {1049, 13, 3700, {1, 3, 1, 7, 15, 59, 57, 157, 333, 367, 245, 3043, 1683}},
    {1050, 13, 3709, {1, 3, 7, 11, 15, 53, 107, 81, 287, 637, 557, 315, 4361}},
    {1051, 13, 3710, {1, 1, 5, 11, 11, 21, 35, 59, 429, 459, 1439, 639, 6907}},
    {1052, 13, 3713, {1, 3, 3, 11, 13, 51, 101, 121, 437, 9, 889, 1907, 5217}},
    {1053, 13, 3723, {1, 1, 7, 13, 7, 5, 99, 161, 207, 237, 1547, 403, 2269}},
    {1054, 13, 3725, {1, 1, 5, 9, 23, 17, 43, 113, 119, 213, 977, 1197, 1039}},
    {1055, 13, 3728, {1, 3, 3, 9, 25, 51, 79, 5, 355, 279, 875, 1947, 1261}},
    {1056, 13, 3734, {1, 1, 7, 3, 5, 15, 85, 137, 361, 509, 959, 3227, 3755}},
    {1057, 13, 3737, {1, 1, 7, 3, 29, 31, 45, 139, 143, 891, 877, 2195, 4405}},
    {1058, 13, 3738, {1, 1, 1, 7, 17, 7, 81, 19, 469, 713, 57, 3559, 4925}},
    {1059, 13, 3744, {1, 1, 1, 9, 13, 43, 69, 77, 225, 497, 1263, 1153, 7375}},
    {1060, 13, 3750, {1, 1, 5, 7, 15, 19, 67, 75, 207, 851, 1827, 3523, 2159}},
    {1061, 13, 3762, {1, 3, 7, 3, 25, 63, 71, 157, 509, 219, 1529, 2513, 1697}},
    {1062, 13, 3764, {1, 3, 1, 5, 9, 9, 13, 147, 363, 561, 1707, 2991, 1671}},
    {1063, 13, 3774, {1, 3, 1, 15, 13, 55, 77, 27, 427, 277, 725, 2861, 4841}},
    {1064, 13, 3776, {1, 1, 5, 15, 25, 55, 21, 135, 221, 965, 1723, 2097, 1277}},
    {1065, 13, 3786, {1, 1, 5, 3, 1, 11, 45, 179, 503, 283, 1075, 1283, 7603}},
    {1066, 13, 3800, {1, 3, 1, 1, 1, 39, 61, 107, 183, 817, 1577, 1143, 783}},
    {1067, 13, 3803, {1, 1, 5, 13, 9, 59, 51, 89, 397, 705, 1081, 3053, 4001}},
    {1068, 13, 3809, {1, 3, 3, 11, 25, 53, 3, 125, 419, 827, 1907, 903, 3169}},
    {1069, 13, 3816, {1, 3, 5, 9, 1, 3, 119, 153, 353, 315, 1555, 1273, 6605}},
    {1070, 13, 3821, {1, 1, 3, 13, 13, 39, 117, 59, 225, 735, 1297, 1281, 8049}},
    {1071, 13, 3827, {1, 3, 1, 3, 27, 53, 57, 95, 303, 803, 343, 4021, 5047}},
    {1072, 13, 3829, {1, 3, 1, 11, 25, 1, 91, 107, 181, 839, 1691, 3859, 2363}},
    {1073, 13, 3836, {1, 1, 7, 1, 19, 45, 23, 37, 345, 675, 5, 3731, 2961}},
    {1074, 13, 3842, {1, 3, 1, 11, 13, 47, 19, 43, 221, 1007, 1021, 2967, 6931}},
    {1075, 13, 3844, {1, 3, 7, 5, 27, 21, 19, 57, 59, 485, 967, 983, 4989}},
    {1076, 13, 3847, {1, 3, 7, 3, 11, 23, 1, 221, 223, 535, 155, 2805, 661}},
    {1077, 13, 3853, {1, 1, 7, 5, 3, 49, 127, 75, 215, 517, 1391, 589, 493}},
    {1078, 13, 3861, {1, 1, 7, 5, 23, 29, 79, 171, 319, 811, 191, 1131, 7689}},
    {1079, 13, 3871, {1, 1, 1, 7, 21, 9, 23, 21, 171, 631, 299, 2295, 5691}},
    {1080, 13, 3872, {1, 1, 3, 7, 17, 59, 47, 205, 39, 407, 1107, 1323, 6769}},
    {1081, 13, 3881, {1, 3, 7, 1, 9, 33, 117, 249, 167, 631, 717, 3901, 6125}},
    {1082, 13, 3890, {1, 3, 7, 9, 31, 11, 75, 125, 417, 803, 1117, 1609, 3263}},
    {1083, 13, 3892, {1, 3, 1, 3, 15, 33, 35, 205, 477, 939, 1891, 2579, 2035}},
    {1084, 13, 3909, {1, 3, 5, 1, 5, 21, 5, 221, 105, 103, 587, 2111, 5891}},
    {1085, 13, 3921, {1, 3, 1, 11, 3, 45, 91, 113, 311, 617, 1629, 1677, 2349}},
    {1086, 13, 3934, {1, 1, 7, 13, 27, 17, 69, 11, 75, 545, 1245, 785, 645}},
    {1087, 13, 3938, {1, 3, 3, 5, 23, 13, 87, 193, 407, 445, 1299, 81, 2679}},
    {1088, 13, 3947, {1, 1, 7, 15, 17, 43, 13, 233, 255, 51, 1277, 965, 1615}},
    {1089, 13, 3950, {1, 3, 7, 1, 31, 49, 21, 61, 269, 265, 25, 3141, 7687}},
    {1090, 13, 3952, {1, 3, 3, 13, 27, 39, 65, 69, 453, 203, 461, 1585, 5681}},
    {1091, 13, 3964, {1, 1, 3, 3, 23, 19, 63, 97, 339, 83, 671, 433, 5285}},
    {1092, 13, 3974, {1, 3, 7, 11, 9, 3, 119, 157, 385, 847, 1159, 1389, 5833}},
    {1093, 13, 3980, {1, 1, 5, 5, 31, 51, 39, 247, 71, 815, 1807, 1973, 1841}},
    {1094, 13, 3983, {1, 1, 3, 3, 31, 39, 121, 75, 343, 25, 59, 575, 3503}},
    {1095, 13, 3986, {1, 1, 5, 11, 23, 17, 35, 33, 437, 1001, 1941, 351, 2949}},
    {1096, 13, 3995, {1, 1, 3, 7, 9, 51, 125, 3, 279, 373, 157, 1537, 5547}},
    {1097, 13, 3998, {1, 3, 1, 11, 11, 23, 63, 91, 139, 911, 463, 1831, 7325}},
    {1098, 13, 4001, {1, 3, 7, 1, 9, 11, 33, 125, 471, 583, 881, 2533, 7173}},
    {1099, 13, 4002, {1, 1, 5, 1, 15, 41, 53, 77, 43, 237, 787, 3299, 5131}},
    {1100, 13, 4004, {1, 1, 7, 7, 17, 19, 115, 145, 231, 555, 1279, 605, 2977}},
    {1101, 13, 4008, {1, 1, 3, 7, 21, 47, 61, 171, 337, 441, 1961, 2815, 4565}},
    {1102, 13, 4011, {1, 1, 7, 9, 25, 25, 3, 199, 85, 129, 1853, 3293, 71}},
    {1103, 13, 4016, {1, 1, 3, 1, 25, 25, 113, 9, 453, 353, 1955, 1443, 7027}},
    {1104, 13, 4033, {1, 3, 3, 11, 9, 35, 89, 149, 335, 485, 37, 1519, 7341}},
    {1105, 13, 4036, {1, 3, 7, 15, 27, 1, 119, 175, 181, 353, 1667, 2023, 3239}},
    {1106, 13, 4040, {1, 1, 1, 5, 27, 11, 39, 255, 283, 101, 603, 541, 2429}},
    {1107, 13, 4053, {1, 1, 7, 11, 27, 51, 87, 187, 183, 1013, 1207, 3431, 3321}},
    {1108, 13, 4058, {1, 1, 5, 3, 5, 15, 107, 171, 139, 919, 235, 3047, 3401}},
    {1109, 13, 4081, {1, 3, 3, 1, 17, 49, 35, 37, 59, 61, 227, 3175, 4093}},
    {1110, 13, 4091, {1, 1, 3, 1, 23, 51, 43, 143, 389, 559, 349, 1933, 6149}},
    {1111, 13, 4094, {1, 3, 5, 13, 9, 19, 111, 233, 373, 883, 1653, 1591, 2971}},
    {1112, 14, 21, {1, 3, 3, 13, 7, 63, 95, 29, 173, 175, 355, 877, 5819, 15873}},
    {1113, 14, 28, {1, 1, 1, 7, 1, 63, 23, 73, 469, 893, 773, 3647, 1191, 8731}},
    {1114, 14, 41, {1, 3, 3, 9, 17, 9, 85, 137, 53, 793, 439, 2097, 4257, 8439}},
    {1115, 14, 47, {1, 1, 7, 15, 3, 57, 83, 83, 123, 399, 1659, 2621, 3355, 255}},
    {1116, 14, 61, {1, 1, 5, 13, 9, 55, 21, 55, 391, 765, 2023, 1211, 1265, 5391}},
    {1117, 14, 84, {1, 1, 1, 11, 31, 63, 43, 153, 423, 969, 931, 531, 1635, 4695}},
    {1118, 14, 87, {1, 1, 5, 11, 19, 11, 115, 213, 473, 13, 853, 3771, 7841, 1249}},
    {1119, 14, 93, {1, 1, 1, 5, 31, 51, 121, 97, 483, 511, 299, 3307, 3363, 12639}},
    {1120, 14, 94, {1, 3, 3, 1, 31, 31, 89, 221, 451, 253, 1371, 2457, 573, 4359}},
    {1121, 14, 103, {1, 1, 7, 5, 5, 21, 59, 151, 275, 937, 1603, 3337, 3157, 15289}},
    {1122, 14, 117, {1, 3, 1, 3, 19, 11, 27, 5, 405, 899, 1315, 3299, 945, 1421}},
    {1123, 14, 121, {1, 3, 7, 3, 31, 55, 85, 49, 303, 859, 469, 723, 2221, 4099}},
    {1124, 14, 134, {1, 1, 5, 13, 31, 27, 57, 37, 493, 883, 1781, 2915, 6435, 6905}},
    {1125, 14, 137, {1, 1, 1, 7, 21, 49, 111, 69, 221, 845, 219, 1257, 7909, 15225}},
    {1126, 14, 157, {1, 3, 1, 3, 3, 1, 89, 143, 359, 717, 327, 1063, 3845, 8963}},
    {1127, 14, 161, {1, 1, 3, 7, 31, 3, 5, 79, 241, 877, 309, 3735, 1409, 11947}},
    {1128, 14, 205, {1, 1, 1, 7, 13, 63, 89, 69, 417, 809, 1251, 3213, 1107, 9143}},
    {1129, 14, 206, {1, 3, 7, 9, 21, 3, 17, 231, 273, 545, 1385, 1367, 5491, 7497}},
    {1130, 14, 211, {1, 1, 7, 1, 31, 35, 117, 31, 173, 711, 555, 1551, 443, 10469}},
    {1131, 14, 214, {1, 1, 5, 9, 3, 61, 55, 31, 321, 517, 47, 1379, 4329, 2305}},
    {1132, 14, 218, {1, 1, 5, 15, 15, 13, 23, 153, 209, 115, 913, 2013, 841, 2015}},
    {1133, 14, 234, {1, 3, 1, 5, 15, 43, 31, 103, 55, 489, 1003, 2723, 2613, 15743}},
    {1134, 14, 236, {1, 3, 5, 3, 31, 45, 21, 37, 453, 99, 1047, 235, 1133, 11199}},
    {1135, 14, 248, {1, 1, 1, 9, 13, 25, 109, 129, 25, 291, 445, 2775, 1011, 4645}},
    {1136, 14, 262, {1, 1, 3, 9, 9, 45, 7, 161, 217, 645, 421, 3429, 2941, 5319}},
    {1137, 14, 299, {1, 1, 3, 15, 13, 57, 13, 63, 89, 739, 1989, 1679, 2031, 265}},
    {1138, 14, 304, {1, 3, 7, 9, 21, 63, 117, 21, 345, 19, 1357, 611, 6591, 8075}},
    {1139, 14, 319, {1, 1, 7, 13, 29, 37, 37, 219, 81, 143, 1505, 2921, 1497, 4359}},
    {1140, 14, 322, {1, 3, 5, 9, 25, 23, 39, 145, 121, 877, 1491, 2687, 865, 3417}},
    {1141, 14, 334, {1, 1, 1, 13, 25, 7, 45, 143, 61, 591, 455, 3039, 4147, 1695}},
    {1142, 14, 355, {1, 1, 1, 9, 27, 7, 61, 139, 509, 843, 1175, 3787, 4695, 13851}},
    {1143, 14, 357, {1, 3, 1, 5, 15, 19, 73, 109, 263, 791, 455, 3503, 1203, 4993}},
    {1144, 14, 358, {1, 1, 1, 11, 21, 59, 51, 101, 407, 25, 355, 2817, 3323, 14641}},
    {1145, 14, 369, {1, 3, 1, 13, 3, 45, 73, 241, 511, 763, 189, 2913, 489, 10441}},
    {1146, 14, 372, {1, 1, 7, 9, 15, 9, 113, 103, 375, 773, 621, 3035, 4359, 13259}},
    {1147, 14, 375, {1, 3, 1, 1, 17, 13, 81, 207, 493, 737, 427, 2895, 539, 4125}},
    {1148, 14, 388, {1, 1, 1, 11, 9, 5, 89, 209, 175, 105, 293, 3337, 7235, 6481}},
    {1149, 14, 400, {1, 3, 1, 13, 5, 19, 3, 245, 25, 733, 885, 3747, 3997, 7945}},
    {1150, 14, 415, {1, 3, 3, 11, 13, 7, 29, 169, 239, 205, 1399, 1447, 5211, 11789}},
    {1151, 14, 446, {1, 3, 1, 15, 7, 19, 65, 23, 183, 547, 671, 2873, 5101, 4187}},
    {1152, 14, 451, {1, 3, 5, 13, 15, 35, 119, 75, 53, 773, 1769, 1945, 7781, 11349}},
    {1153, 14, 458, {1, 3, 7, 9, 31, 37, 39, 55, 333, 567, 1095, 3707, 4265, 117}},
    {1154, 14, 471, {1, 3, 1, 3, 1, 61, 9, 7, 253, 737, 1441, 2591, 2807, 13685}},
    {1155, 14, 484, {1, 1, 3, 11, 21, 41, 81, 61, 497, 827, 783, 3799, 4803, 141}},
    {1156, 14, 501, {1, 3, 7, 13, 11, 15, 3, 165, 401, 747, 1961, 3265, 8123, 2151}},
    {1157, 14, 502, {1, 3, 3, 15, 21, 39, 47, 135, 61, 803, 1447, 1763, 2033, 12907}},
    {1158, 14, 517, {1, 1, 1, 9, 25, 21, 15, 233, 493, 115, 921, 2047, 3715, 9089}},
    {1159, 14, 545, {1, 3, 5, 5, 11, 17, 43, 49, 249, 873, 771, 47, 5357, 12459}},
    {1160, 14, 569, {1, 3, 3, 13, 31, 39, 85, 97, 241, 529, 65, 1995, 2411, 761}},
    {1161, 14, 617, {1, 3, 5, 15, 3, 1, 63, 229, 11, 733, 901, 63, 3585, 10273}},
    {1162, 14, 618, {1, 1, 1, 13, 23, 39, 123, 187, 27, 893, 1127, 2781, 5977, 13797}},
    {1163, 14, 623, {1, 1, 5, 13, 15, 35, 97, 29, 345, 447, 897, 793, 5155, 15939}},
    {1164, 14, 625, {1, 1, 3, 3, 1, 15, 19, 189, 183, 137, 1059, 2135, 6891, 10319}},
    {1165, 14, 637, {1, 1, 1, 11, 29, 27, 83, 111, 113, 225, 1527, 1071, 635, 3471}},
    {1166, 14, 661, {1, 3, 1, 3, 27, 9, 43, 19, 409, 579, 1983, 811, 5477, 559}},
    {1167, 14, 668, {1, 3, 7, 9, 1, 39, 121, 249, 355, 677, 899, 729, 2611, 9463}},
    {1168, 14, 684, {1, 1, 1, 11, 31, 43, 47, 157, 309, 529, 787, 1935, 5679, 1553}},
    {1169, 14, 695, {1, 1, 5, 15, 19, 53, 63, 71, 371, 455, 1943, 477, 6227, 1033}},
    {1170, 14, 716, {1, 1, 3, 15, 9, 55, 45, 247, 189, 57, 1573, 591, 2831, 14273}},
    {1171, 14, 719, {1, 3, 5, 7, 3, 37, 33, 219, 13, 163, 763, 3921, 7617, 15439}},
    {1172, 14, 722, {1, 3, 1, 13, 21, 41, 85, 151, 117, 587, 1513, 17, 7695, 4135}},
    {1173, 14, 731, {1, 3, 1, 5, 21, 51, 107, 209, 107, 459, 243, 3043, 473, 1357}},
    {1174, 14, 738, {1, 3, 1, 1, 5, 49, 87, 203, 261, 935, 765, 2879, 7677, 607}},
    {1175, 14, 747, {1, 3, 7, 15, 25, 31, 7, 53, 391, 569, 187, 2761, 1369, 8871}},
    {1176, 14, 755, {1, 1, 1, 15, 9, 25, 31, 59, 485, 253, 381, 1239, 4797, 4691}},
    {1177, 14, 761, {1, 3, 5, 9, 13, 17, 35, 97, 339, 47, 1053, 293, 8103, 8489}},
    {1178, 14, 767, {1, 1, 1, 11, 13, 7, 43, 33, 187, 135, 277, 1011, 297, 8443}},
    {1179, 14, 775, {1, 3, 5, 1, 13, 45, 125, 185, 369, 643, 791, 119, 7205, 6785}},
    {1180, 14, 782, {1, 1, 3, 15, 15, 39, 89, 33, 47, 801, 1451, 2583, 445, 14029}},
    {1181, 14, 787, {1, 3, 1, 13, 27, 53, 113, 159, 395, 835, 655, 3503, 3733, 1547}},
    {1182, 14, 794, {1, 1, 7, 5, 29, 61, 43, 181, 127, 839, 755, 579, 6805, 4591}},
    {1183, 14, 803, {1, 3, 1, 1, 29, 63, 71, 145, 149, 571, 1129, 2503, 5761, 6251}},
    {1184, 14, 812, {1, 3, 5, 7, 7, 21, 73, 101, 29, 517, 235, 195, 3561, 15347}},
    {1185, 14, 817, {1, 3, 5, 9, 11, 11, 109, 81, 483, 183, 753, 1635, 3763, 8141}},
    {1186, 14, 824, {1, 3, 5, 1, 21, 35, 111, 251, 255, 605, 1613, 283, 3035, 11681}},
    {1187, 14, 829, {1, 3, 7, 3, 29, 49, 43, 255, 217, 791, 1281, 2327, 5115, 10261}},
    {1188, 14, 850, {1, 3, 7, 9, 19, 23, 93, 105, 69, 429, 1729, 3547, 217, 15075}},
    {1189, 14, 866, {1, 3, 1, 9, 7, 21, 13, 81, 395, 997, 399, 3925, 7277, 1733}},
    {1190, 14, 871, {1, 3, 7, 13, 11, 51, 65, 29, 489, 489, 1639, 3949, 6271, 2015}},
    {1191, 14, 877, {1, 1, 7, 1, 15, 39, 23, 67, 121, 617, 1689, 1887, 3485, 7913}},
    {1192, 14, 920, {1, 3, 7, 3, 25, 23, 81, 59, 87, 457, 937, 3229, 2731, 5003}},
    {1193, 14, 935, {1, 1, 5, 11, 29, 41, 21, 67, 475, 127, 1113, 1693, 3705, 1051}},
    {1194, 14, 959, {1, 3, 7, 3, 13, 7, 33, 95, 123, 65, 2039, 1011, 5175, 10459}},
    {1195, 14, 979, {1, 1, 7, 9, 29, 53, 113, 57, 323, 309, 501, 3971, 5999, 16335}},
    {1196, 14, 992, {1, 1, 1, 13, 29, 9, 17, 49, 173, 473, 555, 3753, 7471, 10099}},
    {1197, 14, 1010, {1, 3, 3, 3, 23, 3, 101, 199, 351, 435, 1919, 1175, 8037, 2259}},
    {1198, 14, 1012, {1, 3, 1, 7, 29, 27, 23, 61, 197, 883, 153, 683, 2109, 14991}},
    {1199, 14, 1015, {1, 1, 5, 11, 15, 21, 23, 9, 341, 391, 1537, 3483, 4641, 12489}},
    {1200, 14, 1033, {1, 3, 7, 1, 1, 9, 3, 7, 485, 377, 597, 2277, 7811, 1303}},
    {1201, 14, 1036, {1, 3, 3, 9, 13, 23, 13, 1, 353, 517, 1787, 2095, 3095, 4999}},
    {1202, 14, 1053, {1, 3, 5, 13, 17, 13, 55, 165, 487, 387, 839, 2867, 3939, 7945}},
    {1203, 14, 1057, {1, 3, 5, 3, 15, 25, 103, 225, 275, 571, 441, 567, 4759, 12965}},
    {1204, 14, 1069, {1, 1, 3, 5, 19, 31, 121, 109, 89, 315, 1517, 187, 1645, 2331}},
    {1205, 14, 1072, {1, 1, 7, 3, 17, 49, 87, 241, 491, 99, 1559, 843, 5627, 2383}},
    {1206, 14, 1075, {1, 3, 7, 7, 21, 55, 69, 27, 461, 663, 1609, 4059, 4097, 2299}},
    {1207, 14, 1087, {1, 1, 1, 13, 1, 27, 35, 63, 125, 293, 721, 1433, 4813, 15439}},
    {1208, 14, 1089, {1, 1, 1, 15, 19, 13, 65, 55, 101, 981, 989, 3501, 8125, 8849}},
    {1209, 14, 1137, {1, 1, 5, 13, 25, 45, 23, 157, 165, 581, 1613, 3721, 7569, 9347}},
    {1210, 14, 1166, {1, 1, 1, 5, 29, 47, 51, 43, 221, 809, 469, 2089, 2721, 3799}},
    {1211, 14, 1174, {1, 3, 7, 9, 11, 63, 107, 33, 433, 381, 819, 739, 7861, 12219}},
    {1212, 14, 1180, {1, 3, 5, 7, 29, 27, 105, 219, 227, 851, 1287, 1825, 1861, 8171}},
    {1213, 14, 1204, {1, 3, 1, 11, 1, 31, 77, 183, 81, 781, 541, 1663, 3, 12533}},
    {1214, 14, 1211, {1, 3, 3, 1, 7, 59, 107, 49, 147, 625, 593, 729, 4335, 12651}},
    {1215, 14, 1219, {1, 3, 1, 11, 25, 45, 55, 117, 247, 499, 1403, 3321, 6769, 15183}},
    {1216, 14, 1236, {1, 1, 3, 13, 15, 51, 41, 111, 297, 283, 1943, 2741, 5087, 12203}},
    {1217, 14, 1255, {1, 3, 1, 13, 19, 37, 59, 149, 481, 211, 69, 1253, 8019, 10607}},
    {1218, 14, 1264, {1, 3, 1, 1, 21, 61, 103, 93, 75, 91, 1695, 3683, 679, 14789}},
    {1219, 14, 1306, {1, 3, 1, 3, 27, 19, 101, 215, 165, 887, 1647, 4033, 7709, 15581}},
    {1220, 14, 1330, {1, 1, 1, 9, 17, 9, 15, 231, 335, 227, 661, 2505, 6525, 15019}},
    {1221, 14, 1341, {1, 3, 3, 13, 15, 63, 81, 221, 117, 893, 875, 485, 7323, 11105}},
    {1222, 14, 1344, {1, 3, 1, 3, 7, 57, 115, 159, 457, 235, 1245, 973, 7801, 4753}},
    {1223, 14, 1347, {1, 3, 5, 7, 7, 21, 3, 49, 455, 733, 323, 261, 7809, 4699}},
    {1224, 14, 1349, {1, 1, 7, 3, 17, 31, 15, 105, 81, 901, 1107, 2161, 6631, 14523}},
    {1225, 14, 1361, {1, 1, 7, 15, 21, 51, 125, 227, 321, 665, 13, 3203, 6117, 15401}},
    {1226, 14, 1380, {1, 1, 5, 11, 23, 23, 27, 31, 489, 625, 1973, 2005, 7097, 11557}},
    {1227, 14, 1390, {1, 1, 7, 11, 27, 37, 41, 79, 373, 207, 1399, 2629, 953, 8649}},
    {1228, 14, 1404, {1, 1, 5, 5, 27, 15, 73, 37, 277, 301, 207, 2283, 2787, 8475}},
    {1229, 14, 1435, {1, 3, 5, 11, 7, 47, 3, 169, 201, 573, 1953, 915, 4509, 7767}},
    {1230, 14, 1444, {1, 3, 3, 7, 21, 21, 97, 69, 501, 491, 1471, 657, 5661, 2315}},
    {1231, 14, 1453, {1, 1, 1, 1, 21, 17, 127, 207, 255, 357, 59, 1035, 4497, 7397}},
    {1232, 14, 1461, {1, 3, 7, 1, 17, 55, 71, 35, 85, 5, 507, 1445, 2201, 14137}},
    {1233, 14, 1462, {1, 1, 1, 9, 23, 11, 21, 67, 347, 845, 443, 2461, 2767, 1603}},
    {1234, 14, 1465, {1, 3, 3, 11, 25, 11, 97, 225, 301, 111, 1163, 1783, 7879, 15191}},
    {1235, 14, 1468, {1, 3, 5, 11, 29, 55, 9, 137, 233, 51, 1957, 3807, 2631, 2255}},
    {1236, 14, 1474, {1, 1, 7, 1, 19, 41, 83, 121, 283, 839, 179, 3307, 4679, 1163}},
    {1237, 14, 1483, {1, 1, 3, 9, 17, 1, 11, 47, 295, 189, 1863, 1145, 367, 41}},
    {1238, 14, 1488, {1, 3, 1, 5, 7, 29, 85, 169, 479, 27, 1681, 917, 3983, 5041}},
    {1239, 14, 1493, {1, 1, 7, 15, 13, 29, 39, 131, 491, 361, 565, 271, 6255, 10815}},
    {1240, 14, 1500, {1, 1, 3, 3, 5, 63, 23, 201, 377, 593, 825, 339, 1065, 8989}},
    {1241, 14, 1509, {1, 3, 1, 1, 19, 33, 103, 187, 327, 85, 55, 2561, 6833, 3889}},
    {1242, 14, 1510, {1, 1, 5, 5, 5, 7, 85, 103, 463, 279, 47, 2479, 2149, 1421}},
    {1243, 14, 1514, {1, 1, 3, 13, 17, 31, 61, 247, 59, 869, 1513, 2405, 2129, 15647}},
    {1244, 14, 1519, {1, 1, 3, 13, 7, 31, 99, 63, 289, 123, 617, 3263, 6445, 14101}},
    {1245, 14, 1528, {1, 3, 7, 5, 13, 23, 107, 73, 19, 595, 1623, 1583, 15, 10907}},
    {1246, 14, 1533, {1, 1, 5, 15, 19, 33, 113, 45, 435, 99, 1909, 3317, 1733, 3629}},
    {1247, 14, 1540, {1, 1, 7, 13, 3, 9, 107, 59, 69, 781, 1861, 393, 7143, 4465}},
    {1248, 14, 1550, {1, 3, 5, 3, 23, 49, 3, 173, 483, 353, 783, 717, 2903, 11101}},
    {1249, 14, 1567, {1, 3, 7, 15, 27, 25, 105, 47, 387, 103, 323, 455, 1607, 3673}},
    {1250, 14, 1571, {1, 1, 7, 5, 19, 49, 59, 159, 5, 595, 75, 1963, 313, 5593}},
    {1251, 14, 1573, {1, 3, 3, 15, 27, 35, 51, 135, 347, 375, 493, 589, 507, 4661}},
    {1252, 14, 1578, {1, 1, 1, 5, 5, 59, 103, 249, 473, 503, 1401, 3219, 4337, 3607}},
    {1253, 14, 1598, {1, 3, 1, 15, 29, 15, 123, 165, 55, 515, 1009, 3231, 3567, 7871}},
    {1254, 14, 1606, {1, 3, 5, 7, 5, 11, 45, 87, 67, 359, 43, 457, 6483, 5165}},
    {1255, 14, 1618, {1, 1, 1, 15, 13, 55, 85, 51, 127, 937, 1505, 1445, 889, 789}},
    {1256, 14, 1630, {1, 1, 5, 1, 31, 27, 5, 225, 209, 291, 1047, 3417, 2899, 9691}},
    {1257, 14, 1634, {1, 1, 1, 5, 23, 9, 83, 201, 511, 805, 1341, 2791, 4803, 13523}},
    {1258, 14, 1640, {1, 3, 5, 7, 29, 29, 31, 239, 175, 1005, 1443, 2543, 6235, 15409}},
    {1259, 14, 1643, {1, 3, 5, 5, 31, 7, 17, 195, 15, 65, 1297, 2707, 3097, 2281}},
    {1260, 14, 1654, {1, 1, 3, 1, 25, 43, 57, 219, 419, 9, 1121, 593, 4403, 147}},
    {1261, 14, 1679, {1, 1, 3, 7, 5, 31, 27, 43, 343, 95, 1917, 2425, 4939, 2937}},
    {1262, 14, 1688, {1, 3, 1, 1, 31, 35, 19, 151, 339, 411, 77, 3881, 7401, 927}},
    {1263, 14, 1698, {1, 3, 1, 7, 3, 61, 37, 135, 159, 81, 157, 2945, 6371, 3583}},
    {1264, 14, 1703, {1, 1, 7, 1, 15, 27, 113, 213, 127, 141, 1431, 2163, 2527, 4027}},
    {1265, 14, 1704, {1, 3, 1, 13, 1, 39, 103, 187, 395, 283, 907, 3977, 5901, 6043}},
    {1266, 14, 1722, {1, 3, 7, 1, 31, 47, 45, 95, 53, 165, 357, 3893, 1555, 2263}},
    {1267, 14, 1735, {1, 1, 1, 7, 1, 57, 39, 39, 365, 193, 887, 815, 7309, 15089}},
    {1268, 14, 1750, {1, 1, 3, 11, 25, 61, 21, 139, 241, 167, 843, 299, 7737, 4625}},
    {1269, 14, 1753, {1, 3, 5, 3, 29, 49, 115, 55, 185, 157, 515, 1985, 5891, 11189}},
    {1270, 14, 1760, {1, 1, 1, 1, 1, 9, 41, 227, 267, 581, 5, 2677, 1231, 6989}},
    {1271, 14, 1789, {1, 1, 3, 5, 13, 57, 33, 211, 333, 277, 1387, 2673, 5923, 15623}},
    {1272, 14, 1792, {1, 1, 1, 9, 5, 57, 123, 93, 387, 975, 251, 677, 2843, 2237}},
    {1273, 14, 1802, {1, 1, 7, 1, 5, 15, 19, 241, 171, 713, 1761, 3363, 2707, 7629}},
    {1274, 14, 1819, {1, 1, 1, 13, 13, 25, 125, 233, 377, 1005, 1591, 1327, 7661, 15701}},
    {1275, 14, 1825, {1, 1, 5, 15, 23, 39, 77, 121, 255, 105, 1739, 3511, 2369, 2209}},
    {1276, 14, 1828, {1, 3, 5, 11, 5, 23, 11, 29, 501, 753, 1317, 1927, 2127, 7753}},
    {1277, 14, 1832, {1, 3, 1, 1, 31, 25, 45, 197, 483, 787, 721, 2227, 4237, 1985}},
    {1278, 14, 1845, {1, 3, 7, 7, 1, 53, 51, 235, 255, 517, 1389, 2381, 7845, 8707}},
    {1279, 14, 1846, {1, 1, 1, 5, 27, 9, 19, 251, 29, 211, 1665, 1181, 983, 16139}},
    {1280, 14, 1857, {1, 1, 5, 11, 21, 35, 39, 47, 445, 685, 773, 3563, 3339, 14855}},
    {1281, 14, 1869, {1, 3, 7, 7, 29, 61, 89, 203, 239, 11, 1407, 1529, 3581, 11443}},
    {1282, 14, 1897, {1, 3, 3, 5, 19, 21, 3, 253, 437, 755, 1409, 1449, 623, 10533}},
    {1283, 14, 1906, {1, 3, 3, 15, 13, 25, 65, 123, 273, 611, 1305, 2751, 5123, 1515}},
    {1284, 14, 1908, {1, 1, 3, 5, 13, 63, 79, 139, 253, 917, 19, 1129, 7801, 14215}},
    {1285, 14, 1911, {1, 1, 5, 9, 5, 21, 29, 179, 79, 803, 1163, 2481, 3537, 11015}},
    {1286, 14, 1934, {1, 3, 5, 1, 9, 51, 35, 241, 473, 291, 147, 3021, 2147, 4437}},
    {1287, 14, 1962, {1, 1, 7, 15, 7, 19, 81, 215, 205, 19, 1713, 1347, 7519, 9851}},
    {1288, 14, 1967, {1, 1, 7, 1, 9, 49, 35, 219, 73, 479, 559, 1619, 7891, 1221}},
    {1289, 14, 1972, {1, 1, 3, 1, 9, 39, 17, 67, 139, 287, 703, 3797, 4263, 10847}},
    {1290, 14, 1975, {1, 3, 7, 9, 23, 23, 17, 221, 185, 209, 1827, 3117, 8183, 15405}},
    {1291, 14, 1999, {1, 3, 5, 9, 9, 9, 95, 1, 225, 727, 1577, 3947, 7995, 2587}},
    {1292, 14, 2004, {1, 1, 5, 7, 5, 29, 89, 193, 427, 1009, 1123, 717, 3191, 14381}},
    {1293, 14, 2011, {1, 3, 1, 9, 7, 53, 57, 147, 511, 887, 501, 431, 7537, 363}},
    {1294, 14, 2013, {1, 1, 3, 7, 3, 21, 127, 157, 45, 773, 1973, 2577, 6057, 8153}},
    {1295, 14, 2037, {1, 3, 3, 9, 31, 63, 23, 47, 365, 369, 97, 1627, 831, 12769}},
    {1296, 14, 2051, {1, 3, 5, 9, 5, 61, 53, 131, 447, 281, 1115, 2523, 3789, 11581}},
    {1297, 14, 2063, {1, 1, 3, 5, 19, 39, 95, 243, 95, 601, 1385, 2523, 2973, 2759}},
    {1298, 14, 2066, {1, 3, 1, 15, 25, 15, 19, 133, 1, 197, 1259, 2501, 2513, 9417}},
    {1299, 14, 2094, {1, 1, 7, 1, 13, 49, 47, 61, 167, 971, 835, 2259, 3747, 13077}},
    {1300, 14, 2128, {1, 1, 5, 9, 17, 35, 33, 223, 173, 691, 855, 2743, 5383, 2017}},
    {1301, 14, 2154, {1, 3, 1, 5, 11, 35, 19, 255, 201, 801, 1921, 2511, 2497, 13317}},
    {1302, 14, 2164, {1, 1, 7, 9, 17, 1, 47, 187, 63, 641, 1395, 1591, 6145, 4549}},
    {1303, 14, 2198, {1, 1, 1, 1, 11, 35, 55, 167, 75, 801, 257, 2531, 1821, 11325}},
    {1304, 14, 2217, {1, 1, 1, 11, 21, 27, 117, 131, 167, 461, 1459, 1, 4847, 4347}},
    {1305, 14, 2220, {1, 1, 5, 15, 7, 19, 103, 233, 509, 397, 1147, 1325, 6173, 9643}},
    {1306, 14, 2223, {1, 3, 1, 11, 31, 37, 51, 43, 173, 575, 7, 3595, 5865, 7539}},
    {1307, 14, 2238, {1, 1, 5, 15, 17, 63, 109, 29, 325, 57, 889, 1197, 7839, 13931}},
    {1308, 14, 2245, {1, 1, 5, 15, 3, 19, 105, 251, 447, 451, 925, 1857, 4343, 14273}},
    {1309, 14, 2252, {1, 3, 1, 9, 27, 29, 97, 113, 155, 591, 1435, 2175, 4197, 10661}},
    {1310, 14, 2258, {1, 3, 1, 3, 9, 11, 33, 107, 187, 463, 1479, 1127, 6699, 2183}},
    {1311, 14, 2264, {1, 3, 3, 1, 5, 15, 73, 231, 73, 161, 525, 2265, 619, 8085}},
    {1312, 14, 2280, {1, 1, 1, 1, 1, 43, 7, 137, 163, 953, 775, 3839, 7377, 12321}},
    {1313, 14, 2285, {1, 1, 3, 3, 27, 57, 11, 131, 407, 41, 173, 2595, 5179, 1455}},
    {1314, 14, 2293, {1, 3, 5, 3, 31, 9, 93, 233, 61, 149, 1973, 3493, 5535, 9595}},
    {1315, 14, 2294, {1, 1, 5, 9, 1, 37, 13, 71, 451, 645, 51, 3663, 1917, 10641}},
    {1316, 14, 2298, {1, 3, 1, 11, 13, 53, 111, 71, 61, 539, 319, 1951, 6763, 751}},
    {1317, 14, 2303, {1, 1, 7, 1, 27, 27, 53, 189, 39, 29, 1645, 235, 7643, 15621}},
    {1318, 14, 2306, {1, 1, 7, 1, 13, 13, 115, 125, 109, 377, 463, 3819, 7397, 5205}},
    {1319, 14, 2311, {1, 1, 3, 9, 29, 59, 61, 145, 187, 875, 1571, 4035, 2861, 10897}},
    {1320, 14, 2326, {1, 1, 7, 1, 11, 5, 9, 19, 477, 201, 1061, 1483, 7597, 7161}},
    {1321, 14, 2354, {1, 3, 1, 13, 17, 35, 55, 211, 285, 161, 385, 4093, 3685, 3635}},
    {1322, 14, 2373, {1, 3, 1, 9, 19, 43, 95, 253, 453, 829, 857, 3913, 4949, 9057}},
    {1323, 14, 2380, {1, 1, 1, 13, 3, 45, 57, 185, 7, 457, 1805, 3947, 1515, 4863}},
    {1324, 14, 2385, {1, 1, 5, 1, 9, 27, 75, 243, 401, 593, 1669, 3315, 3023, 14677}},
    {1325, 14, 2392, {1, 1, 3, 13, 29, 57, 37, 11, 153, 255, 1039, 2067, 2033, 7927}},
    {1326, 14, 2401, {1, 3, 3, 13, 27, 63, 23, 73, 355, 913, 327, 43, 2095, 433}},
    {1327, 14, 2402, {1, 3, 3, 7, 13, 1, 61, 193, 73, 465, 1483, 1359, 7459, 6855}},
    {1328, 14, 2408, {1, 1, 7, 3, 15, 39, 85, 165, 285, 713, 1455, 403, 7723, 6595}},
    {1329, 14, 2419, {1, 1, 3, 9, 11, 39, 67, 43, 47, 85, 1831, 1387, 1423, 12473}},
    {1330, 14, 2450, {1, 3, 5, 3, 23, 11, 49, 195, 207, 403, 1761, 3633, 8069, 12455}},
    {1331, 14, 2452, {1, 1, 3, 7, 19, 11, 27, 131, 123, 685, 931, 2433, 7133, 1997}},
    {1332, 14, 2477, {1, 3, 3, 7, 27, 3, 69, 77, 227, 227, 213, 1277, 6597, 8343}},
    {1333, 14, 2509, {1, 3, 7, 5, 13, 61, 69, 63, 59, 949, 2019, 2723, 451, 9641}},
    {1334, 14, 2510, {1, 1, 7, 11, 19, 29, 75, 149, 481, 583, 861, 1353, 7525, 115}},
    {1335, 14, 2515, {1, 3, 5, 13, 19, 3, 27, 155, 81, 907, 683, 1997, 189, 12139}},
    {1336, 14, 2524, {1, 1, 5, 9, 19, 1, 61, 97, 433, 289, 1191, 2347, 5533, 14327}},
    {1337, 14, 2527, {1, 3, 1, 5, 13, 9, 7, 91, 49, 75, 1839, 415, 795, 9127}},
    {1338, 14, 2531, {1, 1, 1, 11, 13, 11, 123, 31, 261, 159, 681, 231, 117, 14923}},
    {1339, 14, 2552, {1, 1, 7, 1, 21, 35, 93, 17, 251, 229, 553, 3413, 7717, 891}},
    {1340, 14, 2561, {1, 3, 5, 3, 7, 47, 85, 155, 63, 785, 939, 3135, 3319, 1997}},
    {1341, 14, 2567, {1, 3, 7, 1, 21, 19, 7, 69, 505, 327, 1015, 1821, 2583, 15031}},
    {1342, 14, 2571, {1, 3, 5, 15, 3, 55, 87, 111, 499, 845, 375, 2735, 6895, 291}},
    {1343, 14, 2586, {1, 1, 3, 3, 15, 5, 51, 105, 369, 91, 945, 3633, 7847, 13811}},
    {1344, 14, 2588, {1, 1, 1, 5, 21, 57, 79, 213, 225, 71, 881, 391, 4329, 2481}},
    {1345, 14, 2595, {1, 1, 7, 11, 19, 49, 39, 193, 271, 463, 1009, 137, 3751, 8439}},
    {1346, 14, 2607, {1, 3, 1, 3, 17, 37, 51, 211, 103, 929, 1323, 1175, 5465, 12229}},
    {1347, 14, 2621, {1, 1, 3, 9, 21, 9, 123, 221, 201, 769, 723, 2627, 2367, 13169}},
    {1348, 14, 2630, {1, 1, 1, 11, 31, 23, 93, 103, 257, 263, 1771, 801, 4735, 13557}},
    {1349, 14, 2639, {1, 3, 1, 9, 21, 29, 67, 225, 367, 909, 1333, 655, 7691, 1251}},
    {1350, 14, 2653, {1, 1, 3, 7, 19, 11, 75, 175, 383, 121, 1917, 2371, 4191, 16111}},
    {1351, 14, 2670, {1, 1, 3, 13, 17, 5, 103, 53, 173, 981, 1185, 3071, 179, 9197}},
    {1352, 14, 2672, {1, 1, 3, 9, 5, 41, 25, 219, 211, 291, 1735, 397, 6317, 11209}},
    {1353, 14, 2700, {1, 3, 7, 5, 5, 1, 11, 125, 405, 583, 773, 1711, 757, 5187}},
    {1354, 14, 2711, {1, 1, 1, 7, 1, 45, 127, 11, 157, 255, 1167, 3315, 5059, 8219}},
    {1355, 14, 2715, {1, 1, 1, 5, 15, 55, 49, 81, 451, 887, 309, 2321, 5759, 4673}},
    {1356, 14, 2748, {1, 1, 3, 3, 29, 51, 15, 113, 245, 77, 109, 2813, 225, 5479}},
    {1357, 14, 2751, {1, 1, 3, 13, 13, 43, 5, 99, 89, 559, 903, 1003, 5401, 1839}},
    {1358, 14, 2753, {1, 1, 1, 5, 25, 11, 3, 225, 341, 439, 521, 545, 5529, 5365}},
    {1359, 14, 2754, {1, 1, 7, 7, 13, 41, 41, 183, 319, 593, 1961, 2211, 7155, 1683}},
    {1360, 14, 2760, {1, 1, 3, 1, 9, 27, 115, 119, 289, 935, 1173, 1783, 7151, 7157}},
    {1361, 14, 2774, {1, 3, 3, 7, 17, 33, 31, 109, 245, 785, 1563, 999, 7989, 3493}},
    {1362, 14, 2784, {1, 1, 7, 7, 9, 3, 85, 91, 21, 831, 1669, 1857, 1737, 12513}},
    {1363, 14, 2793, {1, 3, 3, 5, 17, 51, 37, 175, 325, 581, 1809, 2669, 6179, 2187}},
    {1364, 14, 2804, {1, 3, 5, 9, 9, 39, 53, 87, 47, 677, 1081, 171, 4885, 2311}},
    {1365, 14, 2811, {1, 1, 5, 9, 29, 3, 79, 13, 433, 891, 131, 3559, 797, 3405}},
    {1366, 14, 2822, {1, 3, 7, 11, 25, 5, 73, 189, 251, 927, 2001, 3179, 859, 15931}},
    {1367, 14, 2826, {1, 1, 1, 7, 15, 61, 67, 149, 99, 795, 53, 2417, 4943, 7367}},
    {1368, 14, 2836, {1, 3, 1, 3, 25, 61, 79, 145, 283, 161, 887, 137, 6027, 12585}},
    {1369, 14, 2839, {1, 3, 3, 3, 31, 5, 117, 33, 21, 883, 117, 1609, 7219, 2511}},
    {1370, 14, 2840, {1, 3, 3, 13, 1, 59, 29, 177, 419, 287, 973, 3649, 3333, 9779}},
    {1371, 14, 2893, {1, 3, 5, 5, 11, 51, 11, 125, 237, 305, 37, 3137, 7645, 6317}},
    {1372, 14, 2901, {1, 1, 3, 3, 29, 39, 127, 43, 113, 437, 1501, 13, 1915, 7561}},
    {1373, 14, 2902, {1, 3, 5, 13, 9, 55, 7, 209, 381, 725, 1867, 637, 6335, 6057}},
    {1374, 14, 2905, {1, 3, 3, 5, 1, 57, 57, 45, 247, 23, 1663, 489, 2503, 9033}},
    {1375, 14, 2912, {1, 3, 1, 3, 23, 7, 57, 157, 291, 523, 313, 2501, 1197, 3353}},
    {1376, 14, 2915, {1, 3, 5, 11, 31, 13, 35, 253, 349, 393, 1531, 159, 5311, 9225}},
    {1377, 14, 2918, {1, 1, 7, 1, 1, 47, 75, 187, 41, 713, 1933, 2139, 2211, 7425}},
    {1378, 14, 2939, {1, 1, 3, 5, 7, 21, 67, 27, 303, 617, 1943, 3173, 3081, 10977}},
    {1379, 14, 2965, {1, 1, 7, 7, 27, 57, 103, 65, 195, 267, 1347, 3831, 5335, 435}},
    {1380, 14, 2966, {1, 1, 7, 13, 11, 35, 83, 21, 273, 227, 1523, 3565, 7221, 3105}},
    {1381, 14, 2975, {1, 1, 5, 15, 7, 29, 123, 207, 63, 535, 1355, 2751, 4791, 10285}},
    {1382, 14, 2988, {1, 1, 3, 5, 3, 19, 79, 91, 481, 205, 1741, 319, 4651, 12631}},
    {1383, 14, 2993, {1, 3, 3, 7, 25, 61, 39, 181, 377, 243, 593, 1383, 1427, 11865}},
    {1384, 14, 3006, {1, 1, 3, 9, 13, 13, 97, 27, 335, 973, 1857, 425, 2729, 12013}},
    {1385, 14, 3017, {1, 1, 5, 7, 23, 57, 99, 37, 117, 337, 751, 2471, 1105, 1415}},
    {1386, 14, 3031, {1, 3, 5, 1, 17, 33, 117, 87, 211, 899, 825, 1043, 4273, 9093}},
    {1387, 14, 3038, {1, 1, 3, 13, 11, 7, 81, 251, 421, 643, 1931, 1205, 1033, 8741}},
    {1388, 14, 3041, {1, 3, 7, 5, 17, 27, 113, 43, 63, 819, 503, 1427, 5787, 1133}},
    {1389, 14, 3042, {1, 1, 1, 13, 7, 31, 85, 123, 17, 243, 749, 1447, 6045, 729}},
    {1390, 14, 3051, {1, 1, 1, 3, 19, 15, 97, 49, 101, 37, 1123, 1565, 6957, 1209}},
    {1391, 14, 3073, {1, 3, 1, 5, 1, 39, 23, 47, 387, 727, 81, 4023, 7635, 8691}},
    {1392, 14, 3088, {1, 3, 7, 11, 19, 27, 71, 37, 281, 981, 1777, 1751, 7387, 8391}},
    {1393, 14, 3097, {1, 3, 7, 11, 21, 55, 55, 35, 205, 277, 1573, 327, 7643, 4901}},
    {1394, 14, 3098, {1, 1, 5, 11, 15, 45, 91, 157, 339, 489, 1871, 2841, 6839, 4067}},
    {1395, 14, 3103, {1, 1, 7, 3, 11, 13, 57, 193, 499, 729, 603, 2235, 6323, 16307}},
    {1396, 14, 3104, {1, 1, 5, 9, 13, 41, 127, 117, 115, 159, 1335, 1473, 6509, 8165}},
    {1397, 14, 3146, {1, 3, 7, 15, 29, 39, 57, 161, 71, 97, 1201, 649, 5863, 4765}},
    {1398, 14, 3148, {1, 3, 1, 1, 21, 3, 3, 129, 421, 575, 1693, 337, 7313, 4801}},
    {1399, 14, 3153, {1, 3, 3, 15, 27, 51, 105, 91, 51, 683, 795, 603, 7759, 251}},
    {1400, 14, 3159, {1, 1, 5, 7, 9, 45, 55, 199, 83, 575, 521, 2169, 5741, 1579}},
    {1401, 14, 3182, {1, 3, 1, 7, 13, 47, 125, 227, 45, 355, 127, 1841, 727, 8555}},
    {1402, 14, 3187, {1, 3, 7, 11, 27, 9, 57, 133, 393, 315, 1411, 453, 3787, 7651}},
    {1403, 14, 3189, {1, 1, 1, 15, 11, 35, 77, 15, 223, 1009, 291, 2645, 4585, 5839}},
    {1404, 14, 3199, {1, 3, 1, 7, 7, 61, 89, 55, 399, 651, 1847, 1901, 1887, 5841}},
    {1405, 14, 3239, {1, 3, 3, 3, 17, 29, 41, 19, 353, 475, 1193, 949, 3351, 5073}},
    {1406, 14, 3263, {1, 1, 1, 5, 29, 45, 37, 39, 343, 661, 1405, 229, 493, 471}},
    {1407, 14, 3271, {1, 3, 5, 5, 25, 27, 37, 33, 33, 139, 1537, 1125, 4331, 253}},
    {1408, 14, 3275, {1, 3, 3, 7, 19, 31, 111, 243, 201, 563, 1913, 2153, 749, 3521}},
    {1409, 14, 3278, {1, 3, 5, 1, 9, 41, 19, 163, 185, 435, 1997, 3383, 1721, 11137}},
    {1410, 14, 3280, {1, 3, 3, 15, 25, 1, 67, 231, 11, 197, 1431, 1697, 3337, 8791}},
    {1411, 14, 3283, {1, 1, 1, 1, 13, 59, 11, 199, 243, 105, 751, 811, 345, 8183}},
    {1412, 14, 3290, {1, 1, 3, 1, 29, 35, 123, 187, 411, 523, 989, 2545, 4969, 14489}},
    {1413, 14, 3311, {1, 3, 7, 5, 29, 23, 51, 83, 335, 769, 171, 1631, 1651, 10549}},
    {1414, 14, 3316, {1, 1, 3, 9, 13, 29, 57, 167, 113, 703, 1027, 163, 1327, 5649}},
    {1415, 14, 3343, {1, 3, 5, 11, 1, 47, 101, 251, 377, 421, 1825, 3153, 3425, 10447}},
    {1416, 14, 3346, {1, 3, 1, 1, 11, 49, 17, 215, 261, 899, 811, 3451, 3955, 791}},
    {1417, 14, 3357, {1, 1, 1, 11, 19, 23, 41, 239, 203, 321, 993, 1201, 5073, 8329}},
    {1418, 14, 3358, {1, 3, 3, 7, 23, 55, 81, 227, 379, 571, 1869, 2159, 8181, 12901}},
    {1419, 14, 3361, {1, 1, 7, 3, 31, 55, 13, 57, 413, 927, 873, 3649, 7167, 3985}},
    {1420, 14, 3362, {1, 1, 7, 1, 9, 49, 7, 41, 461, 959, 1477, 4037, 1119, 3525}},
    {1421, 14, 3364, {1, 3, 5, 9, 9, 31, 67, 245, 57, 395, 1035, 3005, 4211, 7155}},
    {1422, 14, 3386, {1, 1, 7, 9, 5, 59, 55, 7, 97, 707, 1755, 1921, 6239, 233}},
    {1423, 14, 3418, {1, 1, 7, 5, 11, 11, 47, 195, 197, 37, 501, 2013, 6579, 15115}},
    {1424, 14, 3424, {1, 1, 3, 15, 23, 61, 27, 199, 41, 479, 871, 2365, 1589, 13}},
    {1425, 14, 3433, {1, 1, 3, 3, 11, 9, 1, 225, 295, 403, 1065, 3039, 6025, 963}},
    {1426, 14, 3434, {1, 3, 7, 13, 9, 61, 29, 253, 371, 527, 1697, 571, 2865, 15967}},
    {1427, 14, 3436, {1, 1, 3, 1, 13, 33, 55, 67, 441, 451, 379, 1365, 2111, 6169}},
    {1428, 14, 3463, {1, 1, 7, 1, 23, 39, 127, 43, 205, 391, 1463, 2227, 6877, 11483}},
    {1429, 14, 3467, {1, 3, 3, 9, 31, 41, 5, 65, 245, 405, 633, 1379, 4111, 13129}},
    {1430, 14, 3477, {1, 3, 5, 1, 1, 3, 57, 179, 23, 615, 761, 2339, 8191, 1995}},
    {1431, 14, 3484, {1, 3, 3, 5, 11, 53, 67, 119, 169, 313, 873, 531, 63, 10827}},
    {1432, 14, 3505, {1, 1, 5, 7, 31, 3, 53, 139, 33, 639, 855, 43, 7895, 495}},
    {1433, 14, 3508, {1, 3, 3, 15, 15, 15, 13, 237, 427, 257, 1973, 2287, 7597, 13397}},
    {1434, 14, 3515, {1, 1, 3, 11, 31, 5, 29, 97, 99, 1003, 333, 773, 4457, 8629}},
    {1435, 14, 3532, {1, 1, 5, 9, 11, 55, 59, 201, 25, 559, 1647, 485, 7041, 4965}},
    {1436, 14, 3553, {1, 1, 3, 5, 7, 37, 117, 159, 319, 431, 341, 2497, 755, 5363}},
    {1437, 14, 3554, {1, 3, 5, 15, 25, 29, 99, 61, 5, 643, 1605, 2273, 3189, 5505}},
    {1438, 14, 3568, {1, 1, 1, 1, 29, 47, 79, 177, 473, 361, 1337, 1199, 2395, 1079}},
    {1439, 14, 3573, {1, 3, 5, 3, 7, 31, 101, 189, 223, 719, 1815, 1383, 7233, 11693}},
    {1440, 14, 3587, {1, 1, 1, 5, 29, 39, 109, 211, 485, 659, 683, 3331, 4277, 809}},
    {1441, 14, 3589, {1, 1, 3, 7, 23, 49, 37, 163, 127, 389, 367, 2223, 1175, 12717}},
    {1442, 14, 3596, {1, 3, 3, 7, 27, 27, 51, 57, 115, 941, 243, 2741, 245, 341}},
    {1443, 14, 3608, {1, 1, 5, 5, 15, 33, 113, 3, 267, 343, 563, 1769, 4095, 11557}},
    {1444, 14, 3620, {1, 3, 3, 13, 13, 11, 105, 161, 145, 125, 1509, 1459, 843, 4553}},
    {1445, 14, 3630, {1, 1, 1, 3, 11, 7, 67, 205, 335, 595, 1553, 2319, 6565, 14473}},
    {1446, 14, 3644, {1, 3, 5, 15, 23, 13, 119, 117, 263, 463, 1919, 2089, 2809, 9957}},
    {1447, 14, 3649, {1, 3, 7, 1, 27, 41, 5, 155, 31, 261, 1383, 1271, 2557, 6041}},
    {1448, 14, 3664, {1, 3, 3, 13, 13, 43, 89, 45, 443, 13, 465, 703, 3405, 6471}},
    {1449, 14, 3679, {1, 3, 1, 7, 31, 49, 49, 57, 97, 987, 187, 141, 7537, 11021}},
    {1450, 14, 3680, {1, 1, 5, 15, 29, 43, 103, 89, 113, 729, 1523, 2893, 1143, 9049}},
    {1451, 14, 3685, {1, 1, 3, 3, 29, 49, 43, 255, 371, 903, 661, 3355, 5981, 861}},
    {1452, 14, 3686, {1, 3, 7, 11, 29, 13, 75, 5, 239, 983, 733, 2949, 4635, 6789}},
    {1453, 14, 3698, {1, 1, 5, 3, 17, 51, 17, 49, 349, 73, 111, 897, 2757, 9817}},
    {1454, 14, 3714, {1, 1, 1, 9, 17, 31, 73, 125, 207, 951, 681, 3685, 893, 13725}},
    {1455, 14, 3726, {1, 1, 3, 1, 29, 13, 51, 181, 27, 807, 59, 3781, 263, 13865}},
    {1456, 14, 3737, {1, 1, 7, 5, 15, 29, 55, 159, 341, 365, 1101, 3139, 4795, 4305}},
    {1457, 14, 3767, {1, 3, 7, 15, 19, 35, 99, 251, 241, 115, 1197, 1167, 4663, 5523}},
    {1458, 14, 3782, {1, 1, 7, 5, 13, 43, 59, 251, 455, 601, 891, 2279, 3447, 7787}},
    {1459, 14, 3786, {1, 3, 3, 9, 31, 17, 97, 27, 373, 183, 7, 1729, 4513, 9763}},
    {1460, 14, 3793, {1, 1, 3, 15, 29, 15, 57, 75, 211, 551, 141, 811, 27, 15107}},
    {1461, 14, 3796, {1, 3, 1, 15, 31, 9, 57, 73, 431, 375, 1269, 2589, 1567, 9293}},
    {1462, 14, 3805, {1, 1, 3, 13, 21, 13, 41, 211, 301, 177, 1667, 3957, 6261, 3275}},
    {1463, 14, 3815, {1, 1, 5, 5, 15, 3, 33, 101, 119, 345, 1853, 2807, 337, 10163}},
    {1464, 14, 3841, {1, 3, 3, 5, 27, 61, 11, 161, 25, 159, 1775, 3039, 3807, 9373}},
    {1465, 14, 3847, {1, 1, 1, 15, 19, 35, 15, 191, 87, 735, 1079, 2373, 7087, 7505}},
    {1466, 14, 3853, {1, 1, 5, 15, 29, 37, 43, 25, 161, 925, 259, 3281, 2643, 2359}},
    {1467, 14, 3862, {1, 3, 1, 11, 3, 21, 13, 169, 17, 637, 1711, 1877, 6081, 5115}},
    {1468, 14, 3875, {1, 3, 5, 1, 25, 5, 125, 103, 277, 533, 1485, 3263, 4899, 11851}},
    {1469, 14, 3902, {1, 3, 7, 9, 23, 13, 61, 59, 405, 73, 817, 3831, 5059, 7671}},
    {1470, 14, 3904, {1, 1, 7, 3, 1, 53, 113, 135, 481, 861, 1041, 931, 2973, 7957}},
    {1471, 14, 3916, {1, 1, 7, 11, 9, 9, 123, 175, 65, 447, 1709, 4083, 6089, 7869}},
    {1472, 14, 3947, {1, 3, 7, 7, 5, 11, 43, 59, 439, 539, 283, 3221, 2631, 13025}},
    {1473, 14, 3949, {1, 3, 7, 7, 27, 1, 93, 51, 361, 441, 2005, 127, 6763, 12699}},
    {1474, 14, 3955, {1, 3, 5, 15, 27, 29, 49, 49, 115, 167, 445, 2811, 1809, 11141}},
    {1475, 14, 3962, {1, 1, 7, 5, 1, 57, 69, 49, 197, 459, 1613, 2891, 4437, 1621}},
    {1476, 14, 3971, {1, 1, 1, 5, 25, 51, 33, 47, 115, 349, 1373, 1985, 5339, 4331}},
    {1477, 14, 3980, {1, 3, 7, 11, 21, 55, 113, 183, 91, 955, 835, 2277, 5989, 1383}},
    {1478, 14, 3985, {1, 3, 5, 1, 1, 11, 113, 121, 207, 897, 125, 393, 6281, 15003}},
    {1479, 14, 3998, {1, 3, 7, 15, 13, 37, 89, 169, 437, 787, 1253, 2835, 4923, 15271}},
    {1480, 14, 4001, {1, 3, 5, 9, 23, 37, 65, 135, 271, 381, 551, 3819, 5683, 3689}},
    {1481, 14, 4002, {1, 1, 1, 9, 27, 29, 61, 147, 347, 745, 1793, 611, 7415, 4927}},
    {1482, 14, 4016, {1, 1, 3, 5, 23, 59, 35, 5, 179, 247, 1265, 2503, 1705, 10011}},
    {1483, 14, 4021, {1, 3, 5, 7, 11, 19, 57, 175, 93, 777, 353, 371, 6655, 10271}},
    {1484, 14, 4026, {1, 3, 7, 13, 15, 51, 29, 213, 113, 143, 2011, 2223, 2099, 4103}},
    {1485, 14, 4043, {1, 1, 7, 13, 19, 31, 75, 99, 89, 219, 2019, 1739, 3813, 5619}},
    {1486, 14, 4079, {1, 1, 3, 7, 27, 53, 69, 215, 299, 401, 719, 3123, 3463, 13967}},
    {1487, 14, 4102, {1, 3, 5, 3, 29, 63, 5, 247, 21, 651, 879, 3033, 117, 11511}},
    {1488, 14, 4106, {1, 1, 5, 1, 5, 47, 63, 45, 145, 905, 885, 2367, 6721, 3869}},
    {1489, 14, 4119, {1, 1, 3, 3, 25, 13, 117, 17, 367, 425, 367, 2863, 3087, 9115}},
    {1490, 14, 4126, {1, 3, 5, 1, 1, 31, 13, 65, 255, 873, 831, 3439, 7459, 7713}},
    {1491, 14, 4147, {1, 1, 7, 11, 19, 53, 93, 33, 505, 1007, 1331, 2317, 2817, 2549}},
    {1492, 14, 4149, {1, 1, 1, 11, 9, 1, 67, 109, 397, 831, 1371, 3277, 151, 6523}},
    {1493, 14, 4164, {1, 3, 1, 3, 25, 11, 35, 233, 231, 89, 1029, 1053, 6579, 455}},
    {1494, 14, 4174, {1, 1, 5, 13, 11, 7, 117, 203, 125, 863, 1927, 2081, 1229, 6373}},
    {1495, 14, 4181, {1, 1, 1, 7, 23, 53, 27, 207, 189, 287, 635, 3483, 4551, 15085}},
    {1496, 14, 4185, {1, 1, 3, 3, 23, 45, 99, 177, 59, 835, 1123, 3397, 4237, 11895}},
    {1497, 14, 4188, {1, 1, 7, 3, 31, 59, 37, 7, 387, 849, 1857, 3469, 3663, 1465}},
    {1498, 14, 4202, {1, 1, 5, 9, 13, 7, 73, 211, 83, 831, 1069, 3103, 2355, 8817}},
    {1499, 14, 4228, {1, 3, 7, 1, 1, 7, 63, 195, 69, 945, 39, 1417, 879, 9223}},
    {1500, 14, 4232, {1, 1, 7, 9, 3, 53, 111, 41, 29, 597, 1667, 3903, 7401, 6939}},
    {1501, 14, 4246, {1, 3, 5, 7, 9, 35, 55, 61, 509, 729, 25, 2357, 3607, 2215}},
    {1502, 14, 4252, {1, 3, 7, 7, 19, 49, 47, 241, 79, 363, 1987, 3269, 5161, 1379}},
    {1503, 14, 4256, {1, 3, 5, 5, 1, 33, 21, 249, 321, 281, 2025, 425, 4955, 5799}},
    {1504, 14, 4286, {1, 1, 7, 5, 19, 21, 93, 69, 487, 619, 839, 1359, 3219, 8303}},
    {1505, 14, 4303, {1, 3, 5, 15, 27, 33, 3, 55, 149, 361, 887, 1341, 1219, 4769}},
    {1506, 14, 4306, {1, 1, 1, 15, 5, 13, 65, 53, 181, 923, 1643, 3853, 3067, 4281}},
    {1507, 14, 4311, {1, 1, 1, 1, 13, 5, 23, 27, 211, 377, 1421, 3085, 509, 509}},
    {1508, 14, 4317, {1, 1, 7, 9, 21, 13, 3, 193, 19, 497, 1989, 885, 1157, 7213}},
    {1509, 14, 4342, {1, 3, 7, 11, 1, 5, 105, 57, 245, 25, 153, 795, 3781, 11735}},
    {1510, 14, 4346, {1, 1, 1, 13, 5, 7, 87, 63, 81, 491, 971, 805, 2349, 15627}},
    {1511, 14, 4377, {1, 1, 5, 1, 27, 41, 31, 165, 383, 85, 1713, 2427, 5329, 15169}},
    {1512, 14, 4401, {1, 1, 5, 7, 9, 47, 75, 51, 329, 651, 481, 2469, 1761, 1367}},
    {1513, 14, 4407, {1, 1, 1, 11, 13, 51, 89, 163, 431, 117, 1909, 2685, 7197, 1537}},
    {1514, 14, 4414, {1, 1, 1, 15, 29, 47, 19, 231, 35, 597, 997, 105, 7701, 899}},
    {1515, 14, 4422, {1, 3, 7, 15, 5, 19, 63, 87, 49, 685, 525, 3709, 4461, 15697}},
    {1516, 14, 4431, {1, 3, 1, 13, 31, 63, 65, 91, 169, 857, 1143, 2831, 7307, 11755}},
    {1517, 14, 4434, {1, 3, 1, 13, 27, 61, 105, 191, 325, 71, 1155, 2291, 8023, 1281}},
    {1518, 14, 4436, {1, 1, 3, 11, 21, 45, 45, 19, 453, 527, 75, 3489, 3011, 12687}},
    {1519, 14, 4443, {1, 1, 5, 7, 23, 15, 27, 105, 335, 549, 737, 3671, 5071, 10957}},
    {1520, 14, 4459, {1, 1, 7, 9, 9, 13, 121, 169, 87, 871, 917, 3071, 7817, 14493}},
    {1521, 14, 4461, {1, 1, 3, 9, 3, 1, 63, 195, 67, 123, 175, 3779, 2681, 15967}},
    {1522, 14, 4462, {1, 3, 7, 9, 11, 31, 111, 147, 203, 205, 1591, 3003, 631, 15567}},
    {1523, 14, 4473, {1, 1, 3, 5, 23, 11, 43, 117, 37, 413, 1657, 4061, 5491, 10329}},
    {1524, 14, 4497, {1, 1, 1, 11, 31, 35, 107, 105, 107, 117, 2041, 1415, 2153, 9063}},
    {1525, 14, 4504, {1, 3, 5, 13, 9, 35, 77, 1, 343, 341, 1841, 2963, 1105, 4103}},
    {1526, 14, 4507, {1, 1, 7, 3, 25, 21, 45, 63, 429, 843, 585, 741, 6641, 6327}},
    {1527, 14, 4525, {1, 1, 1, 5, 19, 23, 3, 63, 273, 1009, 131, 3541, 3769, 13045}},
    {1528, 14, 4534, {1, 3, 5, 15, 11, 41, 127, 139, 105, 15, 1311, 2995, 3151, 12913}},
    {1529, 14, 4538, {1, 3, 1, 3, 1, 37, 71, 55, 17, 155, 397, 121, 2917, 3943}},
    {1530, 14, 4548, {1, 3, 7, 11, 5, 1, 23, 29, 233, 947, 893, 269, 6487, 13831}},
    {1531, 14, 4552, {1, 3, 1, 5, 7, 17, 63, 177, 153, 595, 1217, 2225, 5973, 15853}},
    {1532, 14, 4560, {1, 3, 7, 9, 19, 9, 45, 197, 285, 85, 1533, 673, 5969, 501}},
    {1533, 14, 4575, {1, 3, 5, 15, 15, 23, 123, 151, 49, 583, 385, 3671, 3617, 16285}},
    {1534, 14, 4599, {1, 3, 7, 13, 11, 55, 111, 57, 51, 249, 13, 1929, 4711, 9847}},
    {1535, 14, 4612, {1, 1, 1, 3, 17, 13, 101, 117, 433, 327, 151, 2137, 4885, 12775}},
    {1536, 14, 4619, {1, 3, 3, 11, 13, 39, 113, 35, 99, 985, 765, 1239, 1311, 4591}},
    {1537, 14, 4640, {1, 1, 1, 11, 11, 31, 41, 205, 339, 773, 1291, 1665, 4345, 4139}},
    {1538, 14, 4643, {1, 1, 1, 1, 27, 41, 27, 139, 109, 555, 691, 2263, 5321, 12865}},
    {1539, 14, 4677, {1, 1, 3, 11, 23, 13, 41, 73, 253, 481, 1345, 3339, 1121, 665}},
    {1540, 14, 4687, {1, 1, 7, 7, 23, 57, 109, 161, 35, 911, 411, 3117, 5997, 6843}},
    {1541, 14, 4723, {1, 3, 7, 13, 3, 39, 97, 85, 399, 733, 43, 2437, 2755, 10693}},
    {1542, 14, 4730, {1, 3, 5, 15, 15, 47, 121, 157, 379, 805, 1483, 4013, 79, 10943}},
    {1543, 14, 4736, {1, 1, 3, 3, 23, 51, 39, 61, 157, 139, 273, 2385, 2451, 12437}},
    {1544, 14, 4741, {1, 1, 5, 1, 21, 7, 77, 197, 469, 391, 1665, 1241, 1847, 14129}},
    {1545, 14, 4763, {1, 1, 5, 5, 27, 23, 83, 245, 319, 247, 1345, 1229, 1119, 5749}},
    {1546, 14, 4765, {1, 1, 5, 3, 31, 63, 121, 245, 371, 359, 1929, 817, 2603, 5135}},
    {1547, 14, 4770, {1, 3, 1, 15, 21, 17, 15, 11, 425, 115, 1773, 1491, 2295, 11883}},
    {1548, 14, 4781, {1, 1, 5, 1, 7, 21, 91, 203, 435, 119, 819, 707, 3567, 517}},
    {1549, 14, 4808, {1, 1, 5, 3, 7, 7, 101, 41, 475, 539, 1059, 2245, 6731, 6635}},
    {1550, 14, 4822, {1, 3, 5, 1, 11, 25, 91, 89, 193, 463, 1667, 661, 801, 7087}},
    {1551, 14, 4828, {1, 3, 7, 15, 1, 43, 17, 97, 129, 843, 1319, 723, 2725, 10743}},
    {1552, 14, 4831, {1, 1, 3, 11, 19, 27, 119, 113, 85, 385, 1841, 2821, 2867, 6199}},
    {1553, 14, 4842, {1, 1, 7, 1, 23, 27, 95, 175, 99, 839, 1039, 735, 6355, 1651}},
    {1554, 14, 4855, {1, 3, 3, 1, 11, 13, 71, 91, 7, 959, 979, 2571, 117, 11479}},
    {1555, 14, 4859, {1, 1, 7, 11, 21, 45, 113, 205, 107, 881, 2039, 3181, 4125, 13801}},
    {1556, 14, 4867, {1, 1, 1, 13, 3, 63, 123, 53, 427, 469, 685, 3685, 1019, 7069}},
    {1557, 14, 4870, {1, 1, 1, 13, 31, 33, 39, 155, 19, 975, 659, 11, 6873, 10105}},
    {1558, 14, 4881, {1, 3, 5, 3, 31, 33, 91, 3, 207, 63, 559, 3745, 637, 6869}},
    {1559, 14, 4893, {1, 3, 1, 11, 1, 11, 41, 51, 439, 273, 1977, 2987, 5265, 11779}},
    {1560, 14, 4910, {1, 1, 5, 7, 13, 63, 111, 125, 65, 1003, 2045, 1823, 6799, 2847}},
    {1561, 14, 4917, {1, 1, 1, 1, 11, 9, 59, 187, 431, 773, 1817, 2891, 2927, 1145}},
    {1562, 14, 4929, {1, 1, 1, 15, 25, 19, 101, 231, 371, 857, 261, 1901, 2165, 7275}},
    {1563, 14, 4939, {1, 3, 1, 15, 31, 57, 125, 77, 447, 417, 1503, 3003, 7229, 14275}},
    {1564, 14, 4947, {1, 1, 1, 11, 23, 63, 17, 251, 237, 755, 641, 1875, 1537, 2465}},
    {1565, 14, 4949, {1, 3, 7, 3, 25, 59, 45, 97, 173, 179, 421, 1269, 2933, 337}},
    {1566, 14, 4954, {1, 3, 5, 5, 15, 25, 81, 191, 475, 723, 107, 277, 681, 15147}},
    {1567, 14, 4972, {1, 1, 5, 15, 3, 17, 65, 39, 281, 831, 85, 1445, 4779, 5559}},
    {1568, 14, 4975, {1, 3, 1, 13, 21, 1, 7, 5, 141, 65, 745, 1389, 1935, 9317}},
    {1569, 14, 5000, {1, 1, 5, 11, 27, 31, 33, 27, 185, 625, 1723, 3499, 6225, 7993}},
    {1570, 14, 5005, {1, 1, 5, 7, 5, 51, 19, 27, 301, 845, 949, 1963, 7201, 5399}},
    {1571, 14, 5029, {1, 3, 3, 9, 1, 59, 113, 87, 237, 83, 815, 161, 1685, 1155}},
    {1572, 14, 5039, {1, 3, 3, 15, 3, 47, 105, 77, 343, 997, 647, 3051, 4877, 11519}},
    {1573, 14, 5044, {1, 1, 5, 7, 15, 13, 123, 253, 343, 701, 1231, 3997, 3203, 7411}},
    {1574, 14, 5051, {1, 3, 3, 7, 21, 53, 103, 49, 511, 535, 1159, 747, 4859, 2733}},
    {1575, 14, 5056, {1, 3, 3, 13, 19, 13, 113, 93, 61, 1007, 219, 3817, 4819, 9959}},
    {1576, 14, 5073, {1, 3, 1, 7, 1, 57, 45, 167, 209, 757, 1861, 1863, 3495, 4295}},
    {1577, 14, 5096, {1, 1, 3, 13, 25, 53, 63, 187, 27, 663, 1697, 2477, 1685, 6609}},
    {1578, 14, 5128, {1, 3, 7, 1, 19, 51, 91, 125, 275, 737, 61, 685, 5739, 12795}},
    {1579, 14, 5134, {1, 1, 7, 15, 1, 63, 21, 253, 247, 399, 1207, 3357, 1029, 4719}},
    {1580, 14, 5161, {1, 1, 5, 13, 21, 1, 45, 223, 511, 963, 1099, 2913, 7385, 13903}},
    {1581, 14, 5179, {1, 3, 7, 7, 1, 33, 123, 81, 431, 947, 1821, 3763, 1679, 2391}},
    {1582, 14, 5193, {1, 1, 5, 1, 9, 9, 9, 55, 425, 539, 221, 409, 4967, 8239}},
    {1583, 14, 5199, {1, 3, 7, 11, 19, 5, 97, 77, 95, 955, 705, 3627, 3743, 8687}},
    {1584, 14, 5202, {1, 3, 1, 11, 27, 51, 37, 177, 109, 343, 35, 1361, 1557, 13487}},
    {1585, 14, 5204, {1, 1, 1, 11, 19, 25, 93, 155, 421, 765, 1529, 2685, 2729, 4763}},
    {1586, 14, 5218, {1, 3, 3, 11, 7, 21, 99, 179, 205, 473, 1435, 711, 6975, 10497}},
    {1587, 14, 5247, {1, 1, 5, 3, 1, 55, 29, 113, 201, 123, 201, 2749, 75, 5839}},
    {1588, 14, 5260, {1, 3, 1, 9, 13, 9, 19, 55, 57, 99, 811, 3143, 5143, 5149}},
    {1589, 14, 5271, {1, 3, 5, 1, 5, 49, 89, 229, 351, 93, 951, 3587, 6819, 119}},
    {1590, 14, 5301, {1, 1, 5, 5, 17, 1, 95, 129, 79, 165, 209, 2859, 4269, 7613}},
    {1591, 14, 5305, {1, 3, 5, 11, 3, 1, 115, 215, 215, 449, 1365, 3429, 5711, 10053}},
    {1592, 14, 5319, {1, 1, 1, 9, 17, 59, 11, 121, 229, 37, 781, 421, 145, 1359}},
    {1593, 14, 5326, {1, 1, 3, 9, 31, 31, 73, 255, 451, 337, 617, 3169, 7275, 4783}},
    {1594, 14, 5328, {1, 1, 7, 15, 3, 31, 17, 163, 243, 695, 1073, 2625, 6237, 4011}},
    {1595, 14, 5333, {1, 1, 5, 5, 27, 17, 45, 167, 363, 741, 1873, 3699, 7577, 7389}},
    {1596, 14, 5364, {1, 1, 7, 9, 5, 61, 43, 99, 175, 645, 1351, 1405, 2443, 15481}},
    {1597, 14, 5376, {1, 3, 7, 11, 7, 19, 11, 27, 481, 271, 881, 143, 1087, 7443}},
    {1598, 14, 5399, {1, 1, 3, 15, 11, 59, 47, 165, 421, 211, 451, 3957, 1715, 5045}},
    {1599, 14, 5416, {1, 1, 1, 3, 1, 55, 121, 71, 483, 79, 61, 3107, 6367, 8787}},
    {1600, 14, 5421, {1, 1, 5, 11, 5, 35, 7, 197, 269, 437, 1529, 1757, 8165, 10897}},
    {1601, 14, 5427, {1, 1, 3, 13, 25, 41, 121, 115, 177, 435, 839, 2701, 2813, 5055}},
    {1602, 14, 5429, {1, 1, 3, 15, 5, 57, 17, 99, 31, 415, 1391, 3077, 4317, 12963}},
    {1603, 14, 5430, {1, 3, 1, 7, 31, 45, 95, 97, 43, 601, 2033, 2967, 3985, 10845}},
    {1604, 14, 5434, {1, 3, 1, 15, 19, 55, 99, 125, 391, 339, 1277, 2669, 359, 3983}},
    {1605, 14, 5441, {1, 3, 7, 11, 11, 47, 79, 197, 157, 959, 777, 133, 337, 14891}},
    {1606, 14, 5451, {1, 1, 5, 7, 9, 3, 95, 77, 217, 399, 1269, 2505, 1055, 5483}},
    {1607, 14, 5465, {1, 1, 5, 3, 27, 5, 3, 109, 481, 169, 1787, 725, 2827, 13599}},
    {1608, 14, 5466, {1, 3, 1, 5, 7, 11, 127, 119, 141, 999, 295, 2727, 7329, 11371}},
    {1609, 14, 5471, {1, 3, 3, 7, 31, 17, 105, 139, 287, 333, 1149, 3373, 5165, 9555}},
    {1610, 14, 5477, {1, 3, 5, 5, 5, 13, 53, 25, 125, 953, 511, 3695, 7935, 10901}},
    {1611, 14, 5492, {1, 1, 5, 15, 5, 37, 73, 29, 471, 423, 2025, 3759, 4271, 9589}},
    {1612, 14, 5495, {1, 1, 1, 5, 9, 35, 105, 207, 245, 935, 801, 2115, 7935, 11439}},
    {1613, 14, 5505, {1, 3, 7, 15, 23, 39, 67, 187, 333, 823, 1015, 1463, 6445, 5079}},
    {1614, 14, 5515, {1, 1, 7, 7, 15, 43, 41, 243, 493, 703, 3, 3585, 6775, 2169}},
    {1615, 14, 5525, {1, 3, 7, 9, 7, 53, 29, 225, 399, 885, 1051, 665, 1447, 5913}},
    {1616, 14, 5529, {1, 1, 1, 7, 3, 19, 47, 219, 203, 903, 1399, 1793, 5949, 4311}},
    {1617, 14, 5532, {1, 1, 1, 5, 9, 9, 117, 207, 107, 651, 1155, 2047, 7489, 5959}},
    {1618, 14, 5539, {1, 3, 7, 9, 31, 59, 105, 73, 251, 209, 515, 3467, 721, 13423}},
    {1619, 14, 5541, {1, 1, 7, 13, 13, 45, 75, 171, 61, 249, 1641, 289, 201, 6185}},
    {1620, 14, 5556, {1, 1, 1, 11, 13, 37, 91, 225, 241, 899, 1471, 3553, 6741, 11623}},
    {1621, 14, 5566, {1, 3, 7, 15, 19, 61, 79, 81, 75, 343, 145, 3975, 4807, 4887}},
    {1622, 14, 5568, {1, 1, 3, 9, 17, 15, 29, 1, 331, 649, 1455, 2365, 6309, 6701}},
    {1623, 14, 5574, {1, 1, 1, 1, 15, 19, 37, 5, 417, 933, 269, 2391, 8063, 14231}},
    {1624, 14, 5595, {1, 1, 7, 3, 17, 49, 21, 41, 127, 507, 1927, 1971, 7057, 12047}},
    {1625, 14, 5602, {1, 1, 7, 15, 31, 53, 33, 225, 105, 907, 775, 3699, 439, 10087}},
    {1626, 14, 5611, {1, 1, 5, 3, 23, 5, 3, 19, 387, 811, 865, 2817, 3757, 12849}},
    {1627, 14, 5616, {1, 3, 5, 3, 3, 23, 51, 239, 489, 667, 301, 3879, 4141, 1131}},
    {1628, 14, 5622, {1, 3, 3, 1, 21, 59, 115, 89, 235, 1009, 1371, 2141, 2489, 763}},
    {1629, 14, 5628, {1, 1, 7, 1, 5, 7, 75, 83, 491, 233, 1027, 1421, 5111, 445}},
    {1630, 14, 5655, {1, 3, 3, 3, 19, 27, 1, 181, 193, 949, 69, 2689, 3421, 13921}},
    {1631, 14, 5662, {1, 3, 7, 3, 9, 35, 109, 203, 123, 217, 225, 3355, 2331, 11853}},
    {1632, 14, 5675, {1, 1, 5, 13, 1, 55, 41, 225, 425, 801, 353, 2851, 4403, 7885}},
    {1633, 14, 5689, {1, 3, 5, 11, 19, 47, 83, 17, 91, 875, 1739, 971, 8157, 11047}},
    {1634, 14, 5722, {1, 3, 1, 15, 29, 47, 123, 209, 183, 473, 1019, 537, 1035, 4473}},
    {1635, 14, 5724, {1, 3, 7, 7, 25, 9, 5, 115, 297, 411, 563, 883, 3509, 1637}},
    {1636, 14, 5728, {1, 1, 1, 15, 3, 17, 55, 31, 123, 931, 1239, 2137, 3673, 10325}},
    {1637, 14, 5731, {1, 1, 5, 1, 31, 49, 35, 51, 223, 65, 925, 2133, 3849, 2243}},
    {1638, 14, 5746, {1, 1, 5, 15, 1, 27, 73, 111, 237, 877, 13, 3147, 7115, 13467}},
    {1639, 14, 5764, {1, 3, 5, 7, 9, 53, 123, 189, 459, 383, 1259, 297, 3307, 3305}},
    {1640, 14, 5771, {1, 3, 5, 15, 27, 45, 65, 175, 417, 377, 195, 1419, 1013, 8419}},
    {1641, 14, 5781, {1, 3, 7, 3, 29, 13, 19, 37, 339, 515, 981, 335, 3965, 7577}},
    {1642, 14, 5801, {1, 1, 1, 5, 27, 37, 85, 217, 463, 173, 1723, 493, 6847, 12253}},
    {1643, 14, 5809, {1, 1, 3, 9, 19, 35, 53, 123, 365, 771, 961, 2545, 3191, 7891}},
    {1644, 14, 5810, {1, 3, 7, 3, 27, 47, 81, 243, 89, 79, 13, 1733, 965, 39}},
    {1645, 14, 5812, {1, 3, 1, 7, 21, 1, 57, 137, 211, 491, 1071, 2425, 5225, 16141}},
    {1646, 14, 5841, {1, 3, 7, 1, 5, 23, 57, 117, 45, 373, 831, 3047, 5829, 3205}},
    {1647, 14, 5848, {1, 3, 1, 7, 3, 59, 17, 171, 263, 723, 535, 3791, 4969, 4325}},
    {1648, 14, 5853, {1, 1, 5, 7, 19, 5, 75, 169, 231, 25, 1925, 161, 8051, 13051}},
    {1649, 14, 5854, {1, 1, 1, 9, 29, 5, 5, 197, 135, 713, 1895, 533, 6703, 9307}},
    {1650, 14, 5858, {1, 3, 7, 3, 1, 47, 69, 247, 49, 15, 1533, 3051, 8097, 4881}},
    {1651, 14, 5892, {1, 3, 1, 3, 21, 29, 81, 147, 123, 983, 1925, 3959, 3803, 13461}},
    {1652, 14, 5907, {1, 1, 5, 11, 25, 59, 99, 253, 85, 37, 1821, 93, 1813, 6001}},
    {1653, 14, 5910, {1, 1, 1, 15, 7, 53, 69, 129, 273, 5, 837, 441, 7573, 1803}},
    {1654, 14, 5913, {1, 1, 5, 15, 25, 13, 125, 113, 405, 41, 1151, 3659, 3947, 12983}},
    {1655, 14, 5920, {1, 1, 3, 15, 19, 1, 63, 223, 343, 523, 1857, 1273, 5251, 13665}},
    {1656, 14, 5929, {1, 3, 1, 9, 3, 39, 45, 161, 483, 421, 159, 3257, 7749, 4481}},
    {1657, 14, 5949, {1, 1, 5, 15, 13, 53, 25, 213, 179, 753, 1195, 343, 5803, 15289}},
    {1658, 14, 5952, {1, 1, 3, 3, 21, 41, 67, 149, 225, 103, 1567, 2681, 3731, 9779}},
    {1659, 14, 5955, {1, 3, 7, 3, 1, 25, 9, 185, 373, 851, 1245, 1635, 2255, 8411}},
    {1660, 14, 5962, {1, 1, 7, 9, 1, 39, 99, 193, 115, 763, 1079, 1923, 6111, 2327}},
    {1661, 14, 5975, {1, 1, 5, 13, 29, 51, 73, 91, 427, 959, 1321, 3105, 5093, 8935}},
    {1662, 14, 5985, {1, 3, 3, 7, 3, 37, 19, 187, 341, 907, 119, 2177, 7459, 14047}},
    {1663, 14, 5997, {1, 1, 7, 11, 29, 39, 95, 29, 17, 833, 1657, 2867, 4945, 6435}},
    {1664, 14, 5998, {1, 3, 7, 9, 15, 51, 123, 201, 161, 239, 1937, 627, 7529, 15029}},
    {1665, 14, 6012, {1, 1, 1, 1, 11, 57, 95, 155, 459, 157, 477, 1751, 4569, 13395}},
    {1666, 14, 6016, {1, 1, 1, 13, 13, 51, 1, 33, 47, 781, 1527, 2471, 7245, 8565}},
    {1667, 14, 6026, {1, 1, 3, 15, 1, 51, 81, 113, 317, 323, 1255, 2387, 6913, 2587}},
    {1668, 14, 6036, {1, 1, 5, 3, 25, 9, 73, 163, 31, 367, 477, 3427, 7957, 12235}},
    {1669, 14, 6040, {1, 1, 5, 15, 19, 31, 31, 93, 307, 371, 961, 3967, 4205, 12459}},
    {1670, 14, 6045, {1, 1, 7, 3, 7, 13, 29, 75, 31, 583, 923, 2993, 5707, 715}},
    {1671, 14, 6055, {1, 1, 1, 13, 21, 1, 103, 171, 469, 373, 415, 3031, 1411, 14589}},
    {1672, 14, 6059, {1, 1, 7, 3, 17, 11, 57, 89, 441, 709, 1339, 47, 759, 8273}},
    {1673, 14, 6088, {1, 3, 1, 11, 13, 61, 73, 31, 503, 619, 371, 3533, 4173, 5011}},
    {1674, 14, 6115, {1, 1, 3, 11, 23, 1, 79, 7, 363, 919, 495, 15, 2595, 2691}},
    {1675, 14, 6124, {1, 3, 1, 11, 25, 5, 57, 241, 23, 907, 43, 2895, 3697, 11003}},
    {1676, 14, 6127, {1, 3, 3, 1, 3, 7, 57, 133, 491, 365, 1793, 3765, 3623, 11377}},
    {1677, 14, 6132, {1, 3, 1, 13, 7, 37, 101, 133, 29, 689, 1997, 3011, 2321, 3139}},
    {1678, 14, 6146, {1, 1, 5, 13, 17, 21, 119, 253, 323, 469, 1959, 537, 675, 4933}},
    {1679, 14, 6158, {1, 1, 7, 11, 19, 19, 29, 7, 451, 111, 1743, 379, 5223, 3477}},
    {1680, 14, 6169, {1, 1, 5, 15, 31, 35, 71, 217, 185, 599, 1233, 2079, 7127, 4785}},
    {1681, 14, 6206, {1, 1, 7, 11, 1, 33, 41, 239, 429, 987, 1453, 81, 705, 6347}},
    {1682, 14, 6228, {1, 3, 7, 13, 29, 49, 107, 217, 295, 797, 563, 1917, 537, 4355}},
    {1683, 14, 6237, {1, 3, 1, 13, 17, 49, 27, 67, 5, 239, 53, 1759, 3235, 1321}},
    {1684, 14, 6244, {1, 1, 7, 13, 11, 33, 85, 47, 285, 669, 341, 3011, 287, 9693}},
    {1685, 14, 6247, {1, 3, 7, 7, 19, 57, 99, 97, 249, 567, 1709, 2053, 7603, 4011}},
    {1686, 14, 6256, {1, 1, 3, 1, 3, 55, 105, 245, 167, 785, 1409, 3395, 6503, 14809}},
    {1687, 14, 6281, {1, 3, 5, 13, 9, 63, 91, 49, 125, 123, 861, 1327, 5517, 3319}},
    {1688, 14, 6282, {1, 3, 5, 7, 3, 63, 101, 167, 403, 43, 1767, 1365, 4577, 15423}},
    {1689, 14, 6284, {1, 3, 3, 1, 3, 31, 81, 189, 273, 935, 1195, 3075, 4703, 7855}},
    {1690, 14, 6296, {1, 1, 7, 9, 11, 21, 57, 69, 405, 865, 281, 3813, 2543, 4281}},
    {1691, 14, 6299, {1, 3, 7, 11, 19, 49, 117, 21, 507, 481, 1961, 2893, 6627, 13545}},
    {1692, 14, 6302, {1, 1, 1, 5, 7, 41, 57, 39, 233, 85, 35, 539, 8009, 7223}},
    {1693, 14, 6325, {1, 1, 3, 11, 17, 51, 47, 219, 319, 141, 1993, 1473, 2403, 13697}},
    {1694, 14, 6349, {1, 1, 5, 1, 5, 61, 69, 251, 499, 813, 123, 925, 2093, 3253}},
    {1695, 14, 6352, {1, 1, 3, 11, 23, 19, 97, 19, 345, 127, 1571, 27, 2915, 1497}},
    {1696, 14, 6362, {1, 3, 5, 7, 25, 23, 41, 41, 75, 571, 527, 517, 7057, 2737}},
    {1697, 14, 6383, {1, 3, 7, 3, 1, 59, 27, 177, 253, 21, 2023, 3393, 3195, 879}},
    {1698, 14, 6386, {1, 3, 3, 9, 7, 37, 1, 185, 381, 211, 2033, 1415, 3275, 15281}},
    {1699, 14, 6395, {1, 1, 1, 15, 3, 49, 101, 89, 495, 683, 1945, 3017, 5209, 9879}},
    {1700, 14, 6397, {1, 3, 3, 7, 17, 63, 55, 243, 215, 289, 1119, 4087, 3513, 2961}},
    {1701, 14, 6415, {1, 1, 7, 13, 11, 49, 17, 103, 151, 725, 1433, 967, 4127, 14955}},
    {1702, 14, 6424, {1, 3, 5, 9, 11, 5, 69, 179, 163, 565, 245, 2013, 699, 7109}},
    {1703, 14, 6429, {1, 3, 7, 15, 29, 23, 39, 93, 211, 1017, 1677, 3883, 6157, 11339}},
    {1704, 14, 6439, {1, 1, 7, 9, 7, 15, 27, 109, 449, 165, 1785, 1945, 2095, 14831}},
    {1705, 14, 6451, {1, 1, 5, 13, 17, 43, 71, 49, 9, 305, 561, 2309, 6409, 2097}},
    {1706, 14, 6489, {1, 1, 7, 5, 9, 63, 77, 149, 119, 727, 1781, 3429, 141, 13329}},
    {1707, 14, 6496, {1, 1, 1, 7, 23, 27, 111, 193, 97, 727, 425, 2665, 2217, 7463}},
    {1708, 14, 6502, {1, 3, 3, 5, 15, 45, 85, 237, 207, 759, 1007, 2545, 7897, 10953}},
    {1709, 14, 6511, {1, 1, 1, 3, 7, 47, 81, 57, 369, 777, 155, 1341, 6679, 5877}},
    {1710, 14, 6514, {1, 1, 3, 9, 9, 31, 47, 135, 31, 275, 1779, 2537, 2157, 7347}},
    {1711, 14, 6520, {1, 1, 5, 9, 23, 51, 59, 107, 43, 639, 1893, 1713, 2409, 6301}},
    {1712, 14, 6523, {1, 3, 5, 13, 9, 13, 13, 231, 419, 373, 1071, 2903, 3565, 15075}},
    {1713, 14, 6529, {1, 3, 5, 5, 1, 3, 33, 123, 53, 273, 731, 2049, 4617, 12341}},
    {1714, 14, 6532, {1, 3, 1, 1, 17, 49, 75, 141, 499, 863, 635, 2967, 3483, 5087}},
    {1715, 14, 6547, {1, 3, 1, 9, 17, 7, 33, 247, 143, 73, 551, 65, 1261, 10177}},
    {1716, 14, 6549, {1, 3, 7, 3, 11, 13, 123, 137, 29, 175, 1353, 627, 1223, 191}},
    {1717, 14, 6598, {1, 3, 5, 15, 29, 23, 89, 183, 427, 629, 1747, 141, 95, 8319}},
    {1718, 14, 6601, {1, 1, 1, 5, 17, 45, 53, 95, 433, 523, 1175, 1227, 6893, 2081}},
    {1719, 14, 6610, {1, 3, 3, 15, 29, 21, 107, 117, 407, 937, 301, 1443, 6841, 5673}},
    {1720, 14, 6622, {1, 3, 5, 11, 15, 13, 81, 213, 259, 619, 375, 1777, 455, 8185}},
    {1721, 14, 6632, {1, 1, 5, 7, 13, 25, 113, 175, 31, 265, 1901, 1779, 1787, 14551}},
    {1722, 14, 6655, {1, 3, 1, 9, 17, 59, 41, 183, 405, 477, 133, 3993, 7217, 9373}},
    {1723, 14, 6665, {1, 1, 1, 13, 7, 27, 85, 133, 165, 1023, 443, 2549, 1923, 6561}},
    {1724, 14, 6666, {1, 3, 7, 3, 15, 51, 11, 167, 321, 37, 1299, 1953, 5365, 8423}},
    {1725, 14, 6695, {1, 1, 3, 1, 7, 45, 41, 219, 149, 355, 1975, 1711, 1643, 13669}},
    {1726, 14, 6701, {1, 1, 7, 7, 11, 9, 105, 221, 275, 845, 1651, 483, 7463, 7729}},
    {1727, 14, 6709, {1, 3, 3, 9, 7, 29, 81, 141, 503, 321, 2039, 405, 7503, 3751}},
    {1728, 14, 6710, {1, 1, 1, 7, 21, 31, 19, 71, 299, 301, 1101, 2821, 6005, 5361}},
    {1729, 14, 6741, {1, 1, 7, 15, 11, 61, 37, 67, 151, 175, 1815, 2779, 5507, 153}},
    {1730, 14, 6745, {1, 1, 5, 11, 9, 41, 83, 225, 109, 23, 563, 1021, 3523, 14027}},
    {1731, 14, 6758, {1, 3, 3, 7, 3, 19, 33, 251, 337, 925, 1309, 1895, 4113, 14017}},
    {1732, 14, 6767, {1, 3, 7, 9, 15, 57, 15, 121, 311, 929, 1697, 1877, 803, 3361}},
    {1733, 14, 6772, {1, 3, 5, 1, 11, 29, 19, 173, 497, 879, 249, 3111, 4227, 14681}},
    {1734, 14, 6782, {1, 3, 7, 13, 13, 41, 51, 99, 137, 867, 1207, 3343, 613, 15047}},
    {1735, 14, 6797, {1, 3, 3, 15, 11, 41, 57, 7, 203, 569, 669, 3185, 1233, 527}},
    {1736, 14, 6800, {1, 3, 5, 5, 27, 45, 83, 49, 335, 747, 1075, 2639, 3057, 4137}},
    {1737, 14, 6843, {1, 3, 7, 15, 3, 11, 9, 177, 153, 401, 61, 3689, 3853, 15605}},
    {1738, 14, 6845, {1, 3, 3, 7, 27, 13, 79, 51, 213, 465, 1917, 3353, 3553, 14853}},
    {1739, 14, 6860, {1, 3, 1, 9, 25, 27, 67, 253, 29, 635, 239, 679, 3653, 15435}},
    {1740, 14, 6865, {1, 1, 1, 7, 23, 9, 77, 167, 373, 295, 1423, 1895, 1541, 14563}},
    {1741, 14, 6878, {1, 3, 3, 1, 9, 37, 117, 223, 109, 969, 149, 1611, 3511, 11357}},
    {1742, 14, 6887, {1, 3, 5, 11, 19, 61, 105, 137, 113, 443, 359, 1705, 6893, 11371}},
    {1743, 14, 6888, {1, 3, 1, 13, 21, 11, 65, 3, 275, 311, 1157, 87, 4841, 2995}},
    {1744, 14, 6901, {1, 1, 7, 3, 17, 41, 15, 203, 249, 353, 861, 2519, 537, 15203}},
    {1745, 14, 6906, {1, 3, 3, 13, 29, 7, 87, 121, 69, 733, 1035, 2731, 8079, 7243}},
    {1746, 14, 6940, {1, 1, 1, 3, 13, 3, 109, 47, 161, 313, 1641, 2621, 7629, 13713}},
    {1747, 14, 6947, {1, 1, 3, 1, 5, 5, 85, 99, 463, 1005, 89, 1209, 8013, 14393}},
    {1748, 14, 6953, {1, 1, 3, 1, 27, 1, 127, 185, 193, 275, 891, 763, 3775, 2569}},
    {1749, 14, 6954, {1, 3, 7, 1, 7, 43, 123, 3, 131, 441, 771, 3413, 6641, 2363}},
    {1750, 14, 6959, {1, 3, 3, 9, 21, 39, 81, 243, 179, 765, 181, 417, 8027, 1025}},
    {1751, 14, 6961, {1, 1, 3, 11, 11, 37, 23, 167, 257, 103, 305, 1097, 6099, 11321}},
    {1752, 14, 6964, {1, 3, 1, 7, 27, 29, 71, 207, 83, 367, 1575, 3171, 759, 10981}},
    {1753, 14, 6991, {1, 1, 7, 1, 23, 29, 93, 89, 41, 577, 1657, 415, 655, 2501}},
    {1754, 14, 6993, {1, 1, 1, 11, 27, 39, 111, 139, 425, 513, 1341, 2059, 2187, 6047}},
    {1755, 14, 6999, {1, 1, 1, 13, 25, 55, 63, 193, 183, 429, 611, 2119, 2495, 15361}},
    {1756, 14, 7016, {1, 1, 1, 3, 9, 31, 15, 185, 139, 603, 1159, 2065, 1159, 14869}},
    {1757, 14, 7029, {1, 1, 3, 5, 21, 5, 117, 191, 357, 61, 1517, 2075, 2041, 14485}},
    {1758, 14, 7036, {1, 1, 3, 15, 21, 59, 13, 67, 393, 809, 1539, 3631, 5437, 7787}},
    {1759, 14, 7045, {1, 3, 1, 5, 23, 19, 53, 237, 123, 123, 351, 1797, 3415, 4721}},
    {1760, 14, 7076, {1, 1, 3, 1, 13, 39, 75, 41, 425, 557, 985, 1485, 7613, 11109}},
    {1761, 14, 7083, {1, 3, 1, 11, 25, 29, 23, 117, 411, 721, 21, 1707, 7685, 11979}},
    {1762, 14, 7094, {1, 3, 1, 5, 25, 55, 1, 221, 339, 705, 641, 515, 5883, 10709}},
    {1763, 14, 7097, {1, 1, 3, 9, 13, 63, 69, 121, 371, 643, 597, 1977, 1295, 10941}},
    {1764, 14, 7123, {1, 3, 5, 5, 21, 49, 91, 37, 53, 549, 905, 1707, 7371, 7539}},
    {1765, 14, 7130, {1, 1, 5, 9, 9, 43, 45, 205, 49, 1001, 1617, 2307, 3359, 5871}},
    {1766, 14, 7139, {1, 3, 5, 7, 7, 43, 73, 129, 381, 97, 529, 607, 2505, 5171}},
    {1767, 14, 7145, {1, 1, 5, 9, 3, 31, 81, 63, 185, 443, 1215, 3123, 7973, 8457}},
    {1768, 14, 7146, {1, 1, 5, 5, 13, 31, 59, 141, 93, 509, 149, 3039, 6011, 11489}},
    {1769, 14, 7178, {1, 1, 5, 5, 17, 13, 93, 221, 23, 325, 415, 829, 7611, 2183}},
    {1770, 14, 7186, {1, 3, 3, 3, 13, 55, 47, 77, 375, 41, 1821, 2599, 843, 13411}},
    {1771, 14, 7192, {1, 3, 1, 15, 17, 15, 101, 225, 47, 217, 137, 2637, 895, 10679}},
    {1772, 14, 7198, {1, 1, 7, 3, 27, 37, 123, 173, 83, 119, 599, 17, 89, 15621}},
    {1773, 14, 7222, {1, 3, 7, 11, 25, 41, 105, 43, 247, 841, 1331, 2323, 3499, 5443}},
    {1774, 14, 7269, {1, 1, 1, 7, 23, 49, 101, 179, 233, 463, 443, 2825, 3431, 12585}},
    {1775, 14, 7270, {1, 3, 7, 13, 31, 49, 115, 173, 193, 615, 663, 2167, 5655, 15331}},
    {1776, 14, 7276, {1, 3, 7, 1, 1, 55, 73, 145, 345, 475, 871, 3809, 5329, 15785}},
    {1777, 14, 7287, {1, 1, 1, 3, 7, 7, 45, 3, 9, 753, 703, 3381, 4831, 5145}},
    {1778, 14, 7307, {1, 3, 1, 15, 21, 51, 93, 181, 275, 127, 1743, 509, 2231, 13423}},
    {1779, 14, 7315, {1, 1, 3, 11, 31, 29, 33, 49, 495, 645, 49, 3139, 5281, 12193}},
    {1780, 14, 7334, {1, 3, 3, 3, 3, 49, 41, 31, 101, 681, 1331, 1001, 6679, 4525}},
    {1781, 14, 7340, {1, 3, 5, 11, 7, 51, 49, 197, 43, 419, 965, 3105, 1325, 3137}},
    {1782, 14, 7351, {1, 1, 5, 3, 15, 31, 73, 147, 1, 471, 1569, 3647, 7251, 6261}},
    {1783, 14, 7352, {1, 3, 3, 1, 5, 43, 41, 215, 161, 521, 1349, 1627, 1177, 11719}},
    {1784, 14, 7357, {1, 1, 3, 11, 31, 5, 125, 79, 199, 581, 1153, 2937, 7875, 16361}},
    {1785, 14, 7360, {1, 1, 5, 1, 1, 31, 7, 7, 475, 807, 1249, 811, 6865, 13897}},
    {1786, 14, 7363, {1, 3, 1, 9, 5, 7, 11, 203, 215, 669, 1963, 1255, 4785, 11215}},
    {1787, 14, 7384, {1, 1, 5, 13, 19, 57, 89, 133, 287, 469, 191, 3177, 1425, 14149}},
    {1788, 14, 7396, {1, 3, 5, 15, 9, 9, 13, 229, 477, 261, 1015, 1669, 7685, 3337}},
    {1789, 14, 7403, {1, 1, 1, 13, 21, 7, 117, 35, 233, 347, 1347, 2171, 2419, 11555}},
    {1790, 14, 7406, {1, 3, 7, 5, 17, 55, 37, 243, 159, 605, 1079, 111, 3149, 3973}},
    {1791, 14, 7425, {1, 3, 5, 7, 29, 29, 111, 49, 445, 241, 875, 3895, 3915, 6337}},
    {1792, 14, 7437, {1, 3, 1, 3, 13, 7, 21, 185, 121, 319, 1391, 1303, 3123, 7699}},
    {1793, 14, 7445, {1, 1, 5, 5, 3, 9, 69, 205, 423, 189, 687, 1453, 2427, 11231}},
    {1794, 14, 7450, {1, 3, 3, 7, 5, 31, 91, 235, 287, 185, 1439, 2011, 7429, 4313}},
    {1795, 14, 7455, {1, 1, 7, 1, 3, 57, 11, 11, 377, 699, 883, 221, 4849, 11373}},
    {1796, 14, 7461, {1, 1, 1, 11, 3, 15, 51, 79, 83, 915, 1429, 811, 2651, 829}},
    {1797, 14, 7466, {1, 1, 1, 5, 21, 17, 5, 227, 379, 383, 745, 2761, 323, 753}},
    {1798, 14, 7488, {1, 1, 3, 9, 11, 33, 123, 59, 241, 829, 879, 3339, 5315, 10777}},
    {1799, 14, 7494, {1, 3, 7, 13, 25, 27, 117, 5, 11, 793, 243, 2571, 369, 1371}},
    {1800, 14, 7515, {1, 1, 1, 3, 21, 31, 95, 217, 175, 837, 583, 1149, 8073, 12751}},
    {1801, 14, 7517, {1, 1, 7, 3, 1, 45, 83, 143, 429, 581, 283, 1085, 6315, 1347}},
    {1802, 14, 7521, {1, 3, 7, 9, 7, 17, 75, 187, 453, 431, 649, 1813, 3539, 5033}},
    {1803, 14, 7536, {1, 1, 1, 11, 23, 21, 107, 67, 495, 253, 1323, 3751, 3035, 5771}},
    {1804, 14, 7546, {1, 3, 5, 13, 19, 31, 31, 201, 89, 211, 163, 3989, 431, 13195}},
    {1805, 14, 7569, {1, 3, 1, 13, 31, 63, 71, 145, 181, 105, 1215, 3635, 3717, 4413}},
    {1806, 14, 7591, {1, 3, 1, 9, 15, 61, 61, 61, 227, 755, 1083, 825, 3905, 5519}},
    {1807, 14, 7592, {1, 3, 1, 3, 23, 25, 47, 43, 151, 337, 1869, 2273, 1155, 445}},
    {1808, 14, 7598, {1, 1, 1, 7, 31, 29, 97, 49, 9, 963, 1709, 4079, 2733, 3901}},
    {1809, 14, 7612, {1, 3, 7, 3, 29, 43, 85, 139, 237, 439, 2023, 1959, 5363, 12539}},
    {1810, 14, 7623, {1, 1, 7, 5, 27, 61, 117, 225, 293, 125, 1045, 355, 1919, 10157}},
    {1811, 14, 7632, {1, 3, 3, 7, 1, 43, 51, 133, 237, 257, 127, 1425, 6015, 6993}},
    {1812, 14, 7637, {1, 3, 5, 7, 17, 39, 9, 15, 139, 3, 375, 1465, 821, 11713}},
    {1813, 14, 7644, {1, 1, 3, 7, 1, 57, 113, 149, 473, 385, 61, 781, 559, 385}},
    {1814, 14, 7657, {1, 1, 5, 5, 17, 51, 43, 141, 371, 99, 443, 3157, 6779, 14637}},
    {1815, 14, 7665, {1, 1, 1, 5, 21, 37, 83, 183, 273, 225, 1975, 1871, 4859, 4079}},
    {1816, 14, 7672, {1, 1, 5, 13, 1, 59, 91, 87, 11, 623, 1381, 3119, 337, 6137}},
    {1817, 14, 7682, {1, 3, 1, 7, 31, 45, 103, 93, 293, 209, 1903, 2617, 5179, 13287}},
    {1818, 14, 7699, {1, 3, 3, 5, 25, 57, 31, 11, 449, 607, 1797, 3683, 5321, 14237}},
    {1819, 14, 7702, {1, 1, 5, 13, 13, 33, 113, 111, 123, 417, 439, 3713, 6791, 12299}},
    {1820, 14, 7724, {1, 1, 5, 1, 23, 61, 101, 125, 153, 275, 833, 3597, 6939, 8497}},
    {1821, 14, 7749, {1, 1, 3, 13, 7, 5, 117, 85, 493, 797, 465, 647, 5749, 1679}},
    {1822, 14, 7753, {1, 3, 1, 7, 11, 43, 71, 201, 127, 337, 559, 2503, 291, 4363}},
    {1823, 14, 7754, {1, 1, 3, 7, 13, 23, 67, 125, 73, 47, 1419, 2171, 1887, 13923}},
    {1824, 14, 7761, {1, 3, 3, 13, 27, 45, 67, 145, 85, 947, 341, 1281, 1667, 6283}},
    {1825, 14, 7771, {1, 3, 7, 15, 23, 35, 89, 57, 399, 993, 1797, 1845, 417, 11871}},
    {1826, 14, 7777, {1, 1, 7, 1, 21, 49, 69, 33, 187, 903, 1011, 4013, 6933, 12101}},
    {1827, 14, 7784, {1, 1, 5, 1, 11, 59, 39, 201, 195, 769, 1633, 2377, 4469, 14031}},
    {1828, 14, 7804, {1, 1, 3, 13, 15, 53, 63, 205, 379, 807, 1579, 3487, 1057, 15145}},
    {1829, 14, 7807, {1, 3, 7, 15, 17, 57, 73, 73, 359, 197, 449, 1201, 6781, 6875}},
    {1830, 14, 7808, {1, 3, 1, 15, 11, 31, 11, 237, 353, 833, 831, 1293, 4505, 14743}},
    {1831, 14, 7818, {1, 1, 3, 3, 9, 31, 127, 45, 43, 255, 1525, 3645, 6419, 8085}},
    {1832, 14, 7835, {1, 3, 7, 1, 25, 27, 25, 143, 247, 485, 55, 3473, 7503, 1615}},
    {1833, 14, 7842, {1, 3, 3, 1, 15, 11, 13, 71, 301, 361, 249, 2701, 5199, 3321}},
    {1834, 14, 7865, {1, 1, 3, 7, 7, 17, 63, 181, 191, 247, 91, 3403, 7027, 10373}},
    {1835, 14, 7868, {1, 1, 7, 11, 7, 47, 19, 53, 33, 761, 561, 3481, 5131, 16257}},
    {1836, 14, 7880, {1, 3, 1, 5, 1, 33, 5, 147, 187, 207, 1387, 3893, 3479, 9371}},
    {1837, 14, 7883, {1, 3, 3, 7, 21, 39, 75, 117, 313, 489, 1087, 3701, 6105, 11821}},
    {1838, 14, 7891, {1, 3, 3, 7, 15, 23, 5, 53, 61, 881, 1093, 2169, 273, 12635}},
    {1839, 14, 7897, {1, 3, 1, 11, 27, 19, 111, 203, 277, 537, 133, 2957, 5223, 15395}},
    {1840, 14, 7907, {1, 1, 3, 13, 1, 31, 125, 187, 495, 1009, 1589, 1243, 3461, 5883}},
    {1841, 14, 7910, {1, 1, 5, 5, 19, 53, 63, 209, 57, 15, 1221, 2793, 4777, 15433}},
    {1842, 14, 7924, {1, 3, 1, 13, 1, 27, 71, 11, 507, 175, 455, 63, 3847, 6667}},
    {1843, 14, 7933, {1, 1, 3, 1, 27, 57, 115, 127, 205, 195, 1447, 2193, 6383, 5011}},
    {1844, 14, 7934, {1, 1, 1, 13, 23, 29, 91, 7, 331, 661, 615, 195, 4445, 2875}},
    {1845, 14, 7942, {1, 1, 5, 9, 27, 27, 1, 47, 461, 565, 627, 1643, 645, 6841}},
    {1846, 14, 7948, {1, 1, 5, 13, 21, 39, 81, 145, 267, 491, 701, 3197, 1157, 6509}},
    {1847, 14, 7959, {1, 1, 7, 3, 1, 11, 49, 27, 29, 91, 885, 545, 6215, 15321}},
    {1848, 14, 7984, {1, 1, 5, 11, 19, 29, 121, 97, 285, 935, 745, 2223, 159, 15429}},
    {1849, 14, 7994, {1, 3, 7, 1, 23, 47, 73, 39, 15, 721, 1627, 3999, 5075, 13243}},
    {1850, 14, 7999, {1, 3, 5, 1, 5, 29, 27, 27, 73, 899, 1467, 1215, 6627, 13961}},
    {1851, 14, 8014, {1, 3, 7, 3, 13, 59, 11, 131, 175, 397, 765, 1195, 7157, 14991}},
    {1852, 14, 8021, {1, 1, 1, 15, 23, 63, 1, 51, 295, 835, 445, 3385, 7321, 8469}},
    {1853, 14, 8041, {1, 1, 5, 7, 15, 27, 9, 133, 119, 1009, 1469, 2467, 7249, 4631}},
    {1854, 14, 8049, {1, 1, 1, 13, 21, 17, 117, 179, 321, 805, 167, 849, 793, 8557}},
    {1855, 14, 8050, {1, 3, 7, 11, 13, 5, 107, 93, 453, 835, 1791, 1955, 5463, 2033}},
    {1856, 14, 8068, {1, 1, 3, 9, 17, 55, 111, 217, 331, 983, 15, 3731, 3275, 5001}},
    {1857, 14, 8080, {1, 1, 1, 5, 15, 15, 57, 103, 197, 193, 1693, 2283, 6317, 14743}},
    {1858, 14, 8095, {1, 3, 3, 1, 21, 25, 119, 133, 183, 205, 13, 551, 2163, 8153}},
    {1859, 14, 8102, {1, 1, 3, 7, 21, 23, 59, 149, 353, 651, 831, 2861, 675, 8349}},
    {1860, 14, 8106, {1, 1, 5, 13, 25, 29, 71, 29, 9, 477, 1371, 1555, 7487, 2597}},
    {1861, 14, 8120, {1, 3, 1, 7, 25, 45, 7, 91, 199, 539, 125, 1819, 5241, 7353}},
    {1862, 14, 8133, {1, 3, 3, 15, 27, 53, 83, 137, 191, 277, 1883, 469, 4261, 9741}},
    {1863, 14, 8134, {1, 1, 3, 9, 31, 9, 83, 73, 417, 587, 1041, 853, 5107, 8391}},
    {1864, 14, 8143, {1, 3, 5, 5, 11, 53, 41, 77, 499, 983, 541, 2957, 7133, 14069}},
    {1865, 14, 8162, {1, 3, 7, 15, 7, 1, 123, 201, 3, 141, 73, 1911, 5373, 12321}},
    {1866, 14, 8168, {1, 1, 3, 1, 5, 23, 19, 243, 83, 869, 1221, 1261, 1363, 1875}},
    {1867, 14, 8179, {1, 1, 1, 9, 1, 51, 33, 145, 489, 545, 825, 873, 8057, 11797}},
    {1868, 15, 1, {1, 1, 3, 13, 19, 13, 83, 121, 297, 295, 1429, 3443, 1571, 15843, 28767}},
    {1869, 15, 8, {1, 1, 1, 15, 27, 53, 25, 233, 437, 485, 641, 4011, 7405, 6323, 1697}},
    {1870, 15, 11, {1, 3, 1, 11, 15, 33, 15, 227, 69, 79, 1043, 2159, 1041, 649, 25043}},
    {1871, 15, 22, {1, 3, 5, 11, 19, 3, 1, 39, 77, 323, 407, 2575, 6855, 6927, 11705}},
    {1872, 15, 26, {1, 1, 1, 1, 11, 15, 69, 91, 109, 885, 675, 193, 989, 1061, 6133}},
    {1873, 15, 47, {1, 1, 3, 3, 15, 37, 23, 31, 169, 321, 25, 3637, 1129, 12461, 4741}},
    {1874, 15, 59, {1, 3, 3, 11, 5, 63, 57, 55, 65, 715, 307, 2315, 3725, 13937, 29497}},
    {1875, 15, 64, {1, 1, 7, 5, 7, 41, 53, 115, 391, 1011, 201, 1069, 7425, 9775, 25067}},
    {1876, 15, 67, {1, 1, 7, 7, 3, 39, 87, 139, 253, 405, 2007, 3489, 395, 10591, 21825}},
    {1877, 15, 73, {1, 1, 3, 9, 23, 55, 51, 193, 91, 617, 943, 81, 1249, 14799, 24349}},
    {1878, 15, 82, {1, 3, 7, 7, 17, 35, 27, 173, 169, 867, 1833, 905, 8095, 12045, 21097}},
    {1879, 15, 97, {1, 1, 1, 7, 5, 45, 17, 73, 389, 335, 1481, 2339, 1403, 13291, 1967}},
    {1880, 15, 103, {1, 3, 1, 5, 19, 13, 123, 63, 321, 259, 581, 1475, 7995, 6321, 30781}},
    {1881, 15, 110, {1, 1, 7, 3, 9, 21, 69, 13, 151, 611, 1129, 1743, 5423, 16339, 12699}},
    {1882, 15, 115, {1, 1, 3, 3, 13, 33, 23, 243, 293, 793, 213, 2909, 5681, 16143, 24717}},
    {1883, 15, 122, {1, 3, 1, 13, 17, 19, 95, 33, 371, 207, 633, 43, 5313, 5585, 10767}},
    {1884, 15, 128, {1, 1, 5, 13, 17, 11, 123, 19, 45, 855, 243, 1267, 2115, 3255, 28091}},
    {1885, 15, 138, {1, 3, 7, 15, 21, 45, 7, 13, 481, 29, 969, 1415, 7941, 4409, 17327}},
    {1886, 15, 146, {1, 1, 5, 11, 7, 43, 83, 175, 127, 41, 1561, 471, 3949, 9773, 27339}},
    {1887, 15, 171, {1, 1, 7, 11, 31, 47, 95, 183, 137, 27, 1743, 2983, 5123, 8705, 10745}},
    {1888, 15, 174, {1, 1, 5, 5, 5, 39, 9, 89, 363, 957, 1251, 2731, 3991, 13595, 21205}},
    {1889, 15, 176, {1, 1, 1, 9, 3, 43, 103, 29, 205, 323, 1843, 13, 3943, 5819, 12421}},
    {1890, 15, 182, {1, 1, 7, 9, 19, 47, 53, 85, 225, 651, 799, 2593, 7241, 14981, 20391}},
    {1891, 15, 194, {1, 1, 5, 15, 29, 45, 65, 211, 337, 273, 1761, 1875, 1123, 12069, 3169}},
    {1892, 15, 208, {1, 3, 1, 11, 21, 45, 1, 41, 339, 441, 1799, 1271, 6161, 13081, 24991}},
    {1893, 15, 211, {1, 3, 3, 3, 21, 47, 87, 207, 465, 899, 1555, 1591, 7855, 10701, 26791}},
    {1894, 15, 220, {1, 1, 1, 5, 1, 5, 33, 77, 477, 747, 201, 3095, 555, 7685, 6129}},
    {1895, 15, 229, {1, 3, 1, 11, 13, 7, 65, 87, 391, 699, 913, 3799, 5441, 14025, 26153}},
    {1896, 15, 230, {1, 1, 5, 7, 27, 17, 101, 149, 233, 711, 1761, 1257, 8081, 12103, 10781}},
    {1897, 15, 239, {1, 1, 3, 1, 27, 3, 63, 189, 309, 513, 1757, 3311, 4761, 57, 6305}},
    {1898, 15, 254, {1, 3, 3, 1, 13, 55, 49, 171, 5, 61, 39, 723, 7835, 15009, 3845}},
    {1899, 15, 265, {1, 1, 1, 11, 1, 7, 123, 145, 307, 873, 739, 1491, 8141, 11489, 9165}},
    {1900, 15, 285, {1, 3, 3, 5, 9, 5, 123, 57, 31, 289, 1735, 1255, 411, 15865, 5527}},
    {1901, 15, 290, {1, 1, 5, 9, 3, 37, 125, 245, 355, 433, 1791, 3793, 6867, 15237, 5821}},
    {1902, 15, 319, {1, 3, 3, 1, 9, 35, 115, 117, 331, 41, 1489, 3919, 8101, 14171, 9519}},
    {1903, 15, 324, {1, 3, 1, 15, 27, 27, 45, 99, 21, 333, 1017, 791, 5641, 7839, 23597}},
    {1904, 15, 327, {1, 1, 7, 9, 5, 45, 85, 239, 333, 959, 519, 3655, 2597, 155, 24489}},
    {1905, 15, 333, {1, 1, 5, 7, 27, 11, 1, 103, 251, 967, 1625, 1029, 3833, 12345, 11181}},
    {1906, 15, 357, {1, 1, 5, 13, 5, 33, 101, 163, 27, 669, 17, 873, 1025, 4237, 24849}},
    {1907, 15, 364, {1, 1, 3, 3, 7, 25, 125, 17, 361, 57, 625, 2183, 4861, 8631, 16519}},
    {1908, 15, 395, {1, 3, 7, 15, 25, 43, 125, 23, 297, 277, 717, 1927, 5833, 13949, 27595}},
    {1909, 15, 397, {1, 3, 5, 13, 3, 7, 69, 43, 387, 69, 1851, 3639, 4755, 15749, 2291}},
    {1910, 15, 405, {1, 3, 1, 11, 13, 3, 39, 201, 143, 973, 1827, 2861, 5561, 539, 18273}},
    {1911, 15, 409, {1, 3, 5, 11, 27, 23, 77, 95, 507, 175, 967, 515, 3341, 15073, 1631}},
    {1912, 15, 419, {1, 3, 5, 1, 13, 31, 83, 241, 225, 123, 1369, 1565, 4933, 13565, 29297}},
    {1913, 15, 422, {1, 3, 1, 13, 19, 51, 53, 41, 37, 135, 811, 1239, 897, 11643, 389}},
    {1914, 15, 431, {1, 3, 3, 13, 23, 27, 87, 23, 67, 325, 2025, 521, 6699, 2343, 13291}},
    {1915, 15, 433, {1, 1, 1, 7, 11, 9, 19, 231, 339, 37, 1615, 3715, 7081, 8959, 25735}},
    {1916, 15, 436, {1, 3, 5, 9, 15, 57, 15, 75, 135, 507, 1723, 3053, 4565, 10735, 5229}},
    {1917, 15, 440, {1, 3, 3, 7, 21, 57, 27, 157, 351, 633, 639, 1755, 7903, 4655, 29409}},
    {1918, 15, 453, {1, 1, 7, 3, 1, 41, 7, 209, 227, 1003, 1089, 3655, 2055, 6321, 14603}},
    {1919, 15, 460, {1, 1, 3, 5, 17, 41, 13, 229, 231, 277, 15, 3337, 4697, 7249, 21153}},
    {1920, 15, 471, {1, 3, 3, 1, 15, 57, 21, 21, 359, 821, 149, 2155, 5725, 2833, 29503}},
    {1921, 15, 478, {1, 3, 7, 7, 11, 29, 37, 103, 201, 453, 2033, 3273, 3369, 15017, 27613}},
    {1922, 15, 482, {1, 3, 3, 15, 19, 19, 119, 139, 475, 673, 1061, 849, 1885, 6431, 7261}},
    {1923, 15, 488, {1, 3, 7, 13, 15, 29, 63, 89, 207, 461, 25, 551, 3227, 491, 20345}},
    {1924, 15, 524, {1, 1, 7, 15, 31, 29, 31, 193, 181, 533, 1083, 837, 97, 4903, 26167}},
    {1925, 15, 529, {1, 3, 5, 15, 13, 13, 53, 197, 73, 49, 373, 3933, 195, 2979, 29091}},
    {1926, 15, 535, {1, 1, 5, 5, 23, 33, 35, 69, 115, 203, 141, 3627, 7265, 11755, 31243}},
    {1927, 15, 536, {1, 1, 5, 11, 13, 19, 9, 205, 31, 69, 1711, 3183, 2149, 3137, 13631}},
    {1928, 15, 539, {1, 3, 7, 5, 25, 1, 105, 47, 93, 781, 277, 1717, 6543, 14741, 25523}},
    {1929, 15, 563, {1, 1, 1, 3, 27, 45, 25, 229, 215, 897, 115, 863, 7575, 14219, 22019}},
    {1930, 15, 566, {1, 3, 5, 1, 3, 31, 107, 161, 303, 43, 1839, 2139, 6697, 12223, 1923}},
    {1931, 15, 572, {1, 3, 3, 3, 1, 45, 11, 51, 145, 233, 517, 2927, 5821, 2931, 20693}},
    {1932, 15, 577, {1, 1, 1, 3, 23, 63, 73, 99, 27, 161, 507, 2865, 3613, 9359, 9027}},
    {1933, 15, 587, {1, 1, 5, 9, 29, 55, 127, 101, 17, 795, 1713, 1749, 5195, 8609, 24111}},
    {1934, 15, 592, {1, 3, 1, 1, 3, 29, 33, 25, 69, 715, 1847, 2283, 1225, 1131, 30285}},
    {1935, 15, 602, {1, 3, 5, 5, 3, 11, 37, 189, 381, 879, 1565, 2163, 1327, 9945, 28539}},
    {1936, 15, 623, {1, 1, 5, 11, 3, 55, 3, 51, 25, 777, 1749, 75, 409, 6485, 27585}},
    {1937, 15, 635, {1, 3, 3, 9, 19, 53, 43, 199, 207, 207, 825, 1867, 4947, 8507, 30483}},
    {1938, 15, 638, {1, 1, 1, 1, 9, 31, 29, 65, 413, 37, 187, 2373, 321, 7199, 14443}},
    {1939, 15, 654, {1, 3, 3, 11, 31, 27, 47, 7, 325, 333, 271, 3689, 1897, 12775, 25993}},
    {1940, 15, 656, {1, 1, 5, 5, 5, 39, 119, 117, 329, 475, 331, 2429, 1803, 4849, 915}},
    {1941, 15, 659, {1, 1, 7, 5, 19, 35, 45, 107, 327, 489, 1235, 1693, 6463, 603, 31655}},
    {1942, 15, 665, {1, 3, 7, 9, 17, 37, 89, 187, 57, 201, 999, 797, 5317, 3609, 13877}},
    {1943, 15, 675, {1, 1, 1, 11, 19, 21, 15, 131, 47, 5, 187, 2353, 3739, 11951, 22283}},
    {1944, 15, 677, {1, 1, 1, 7, 7, 1, 41, 213, 205, 333, 2029, 1983, 7039, 6241, 16941}},
    {1945, 15, 687, {1, 3, 1, 5, 7, 37, 83, 115, 199, 125, 509, 2535, 7441, 8157, 8921}},
    {1946, 15, 696, {1, 3, 5, 13, 29, 35, 13, 221, 457, 707, 1001, 3585, 2301, 10283, 26081}},
    {1947, 15, 701, {1, 1, 3, 3, 11, 1, 103, 93, 153, 277, 1705, 1403, 2877, 741, 22913}},
    {1948, 15, 704, {1, 3, 7, 3, 3, 47, 35, 251, 309, 323, 1159, 895, 3407, 6507, 4677}},
    {1949, 15, 710, {1, 3, 7, 15, 11, 13, 45, 51, 53, 833, 137, 1409, 7043, 4067, 13939}},
    {1950, 15, 721, {1, 1, 3, 11, 21, 39, 71, 25, 197, 645, 501, 3119, 1053, 7855, 30873}},
    {1951, 15, 728, {1, 3, 5, 15, 29, 51, 93, 31, 387, 785, 167, 3815, 5477, 4255, 17975}},
    {1952, 15, 738, {1, 1, 1, 3, 1, 33, 93, 9, 49, 389, 2009, 4095, 6299, 4451, 18043}},
    {1953, 15, 740, {1, 3, 5, 15, 13, 43, 43, 167, 361, 445, 1685, 3677, 3901, 5693, 18901}},
    {1954, 15, 749, {1, 1, 3, 9, 1, 11, 55, 61, 65, 515, 1723, 1235, 1613, 15083, 9529}},
    {1955, 15, 758, {1, 1, 3, 5, 31, 23, 107, 169, 109, 1005, 195, 3509, 4879, 15767, 23089}},
    {1956, 15, 761, {1, 3, 7, 11, 3, 35, 61, 117, 99, 311, 1909, 2329, 3499, 8701, 27507}},
    {1957, 15, 772, {1, 3, 7, 11, 1, 21, 27, 167, 77, 469, 2045, 873, 3441, 7377, 6225}},
    {1958, 15, 776, {1, 1, 5, 3, 19, 17, 97, 55, 43, 17, 577, 765, 4027, 9511, 28643}},
    {1959, 15, 782, {1, 3, 5, 7, 31, 47, 71, 41, 109, 441, 815, 1483, 6881, 595, 7263}},
    {1960, 15, 789, {1, 1, 3, 9, 21, 63, 109, 231, 303, 381, 1701, 2877, 6899, 967, 30047}},
    {1961, 15, 810, {1, 3, 5, 1, 19, 31, 21, 201, 167, 649, 823, 715, 2289, 5081, 14869}},
    {1962, 15, 812, {1, 1, 7, 13, 23, 23, 59, 217, 263, 213, 1495, 2915, 2237, 1669, 14415}},
    {1963, 15, 818, {1, 1, 3, 7, 29, 53, 109, 57, 429, 55, 573, 3529, 7687, 13853, 27299}},
    {1964, 15, 830, {1, 3, 5, 3, 23, 13, 107, 99, 81, 483, 411, 223, 2907, 5095, 28383}},
    {1965, 15, 832, {1, 1, 1, 5, 25, 29, 125, 233, 107, 381, 291, 3781, 1127, 5987, 11707}},
    {1966, 15, 852, {1, 3, 7, 13, 29, 49, 17, 209, 379, 89, 1939, 1981, 129, 10907, 21123}},
    {1967, 15, 855, {1, 3, 5, 15, 25, 37, 93, 81, 359, 675, 2039, 685, 2405, 6439, 22425}},
    {1968, 15, 859, {1, 3, 3, 7, 3, 25, 43, 179, 233, 167, 1969, 537, 2781, 9605, 2411}},
    {1969, 15, 865, {1, 3, 7, 13, 9, 49, 81, 195, 213, 593, 163, 707, 3887, 4557, 1051}},
    {1970, 15, 877, {1, 3, 5, 13, 3, 47, 5, 197, 341, 1015, 1699, 35, 6907, 11365, 15213}},
    {1971, 15, 895, {1, 3, 3, 11, 27, 13, 109, 127, 13, 895, 687, 2719, 7805, 1939, 16615}},
    {1972, 15, 901, {1, 3, 7, 11, 11, 63, 35, 131, 269, 419, 1531, 535, 87, 1667, 2889}},
    {1973, 15, 902, {1, 3, 7, 15, 31, 51, 13, 75, 411, 943, 1753, 797, 5287, 10133, 19235}},
    {1974, 15, 906, {1, 3, 5, 15, 7, 37, 113, 169, 103, 305, 1059, 1769, 4801, 1743, 25455}},
    {1975, 15, 916, {1, 1, 3, 5, 1, 33, 53, 203, 247, 697, 851, 3927, 6737, 5455, 1709}},
    {1976, 15, 920, {1, 1, 7, 9, 7, 5, 9, 201, 321, 613, 1567, 859, 3543, 2357, 11377}},
    {1977, 15, 949, {1, 1, 3, 11, 29, 11, 105, 217, 99, 971, 19, 3007, 6573, 3381, 22739}},
    {1978, 15, 962, {1, 3, 5, 1, 1, 11, 83, 215, 15, 217, 731, 873, 1275, 11457, 26937}},
    {1979, 15, 964, {1, 1, 7, 15, 19, 29, 11, 235, 193, 713, 629, 1205, 6655, 1669, 3465}},
    {1980, 15, 967, {1, 1, 7, 1, 13, 49, 89, 73, 39, 45, 301, 3723, 4603, 12853, 13695}},
    {1981, 15, 981, {1, 3, 3, 11, 27, 1, 51, 223, 495, 153, 835, 3565, 465, 9497, 8303}},
    {1982, 15, 982, {1, 1, 1, 5, 11, 25, 7, 99, 141, 247, 1335, 2307, 4639, 375, 16841}},
    {1983, 15, 985, {1, 1, 7, 11, 21, 11, 81, 123, 485, 363, 217, 2165, 4819, 11045, 9853}},
    {1984, 15, 991, {1, 3, 5, 7, 15, 43, 17, 19, 377, 601, 849, 1157, 7821, 5623, 29901}},
    {1985, 15, 1007, {1, 3, 3, 13, 15, 29, 93, 87, 445, 565, 561, 4025, 79, 12369, 30383}},
    {1986, 15, 1016, {1, 1, 3, 11, 11, 13, 31, 239, 485, 417, 1785, 1843, 2807, 1539, 15727}},
    {1987, 15, 1024, {1, 3, 1, 9, 17, 17, 7, 109, 239, 243, 53, 575, 77, 4887, 8023}},
    {1988, 15, 1051, {1, 3, 3, 7, 29, 57, 85, 161, 155, 667, 243, 581, 6307, 1947, 7165}},
    {1989, 15, 1060, {1, 3, 5, 13, 11, 37, 83, 231, 255, 899, 1795, 3049, 7169, 11451, 31227}},
    {1990, 15, 1070, {1, 1, 3, 5, 29, 7, 19, 143, 53, 191, 1525, 2685, 1377, 6229, 25141}},
    {1991, 15, 1072, {1, 3, 1, 15, 1, 31, 77, 207, 445, 217, 337, 1355, 7057, 6147, 24061}},
    {1992, 15, 1084, {1, 1, 7, 5, 3, 19, 39, 25, 23, 49, 85, 781, 6347, 1137, 30013}},
    {1993, 15, 1089, {1, 1, 7, 13, 25, 57, 51, 111, 201, 73, 983, 931, 1085, 8227, 21791}},
    {1994, 15, 1095, {1, 1, 7, 13, 31, 41, 15, 223, 371, 117, 103, 589, 7819, 7991, 19903}},
    {1995, 15, 1114, {1, 1, 1, 3, 29, 15, 119, 229, 163, 825, 1299, 339, 5861, 13927, 9923}},
    {1996, 15, 1123, {1, 3, 1, 3, 7, 63, 31, 69, 181, 445, 1501, 663, 4915, 7387, 22065}},
    {1997, 15, 1132, {1, 1, 5, 15, 25, 19, 69, 147, 233, 713, 1697, 1685, 2705, 6261, 1805}},
    {1998, 15, 1154, {1, 3, 3, 11, 5, 21, 1, 235, 481, 349, 749, 853, 7893, 10075, 26307}},
    {1999, 15, 1156, {1, 3, 5, 11, 7, 61, 115, 133, 227, 69, 1741, 4011, 1911, 4579, 7941}},
    {2000, 15, 1163, {1, 3, 7, 13, 15, 45, 51, 127, 467, 353, 1947, 2129, 2969, 3185, 24177}},
    {2001, 15, 1171, {1, 1, 5, 11, 25, 19, 29, 105, 483, 795, 1015, 975, 7037, 11439, 7217}},
    {2002, 15, 1202, {1, 3, 7, 9, 17, 61, 121, 143, 133, 281, 1101, 3033, 1081, 5371, 13073}},
    {2003, 15, 1228, {1, 1, 7, 9, 11, 19, 7, 61, 147, 1011, 1315, 2641, 4065, 13461, 19589}},
    {2004, 15, 1239, {1, 3, 5, 3, 7, 1, 111, 123, 51, 345, 1033, 3863, 5135, 4907, 12509}},
    {2005, 15, 1255, {1, 3, 3, 7, 3, 57, 45, 207, 487, 751, 145, 3037, 1467, 8917, 20379}},
    {2006, 15, 1256, {1, 3, 3, 11, 15, 43, 123, 195, 15, 233, 1997, 2095, 2755, 16347, 3809}},
    {2007, 15, 1262, {1, 1, 7, 3, 21, 5, 17, 253, 153, 25, 563, 139, 2611, 12733, 17505}},
    {2008, 15, 1270, {1, 3, 1, 7, 27, 43, 33, 33, 489, 441, 1845, 3507, 5089, 1173, 14689}},
    {2009, 15, 1279, {1, 1, 3, 7, 19, 43, 73, 165, 159, 873, 625, 1621, 5327, 8421, 14479}},
    {2010, 15, 1308, {1, 3, 5, 7, 31, 37, 35, 195, 373, 257, 1791, 2679, 1517, 1649, 13101}},
    {2011, 15, 1322, {1, 3, 1, 15, 11, 25, 127, 105, 65, 169, 931, 2445, 2953, 11405, 12267}},
    {2012, 15, 1329, {1, 3, 7, 9, 25, 49, 1, 25, 273, 405, 1401, 265, 1449, 8641, 31469}},
    {2013, 15, 1330, {1, 3, 3, 9, 23, 3, 5, 99, 439, 521, 317, 1397, 6933, 14937, 15165}},
    {2014, 15, 1336, {1, 1, 1, 5, 1, 25, 9, 137, 173, 1003, 625, 2783, 4179, 6203, 29619}},
    {2015, 15, 1341, {1, 3, 7, 1, 7, 31, 49, 251, 269, 107, 659, 1091, 3833, 2803, 11677}},
    {2016, 15, 1347, {1, 1, 7, 5, 1, 25, 79, 255, 335, 585, 457, 2331, 3371, 12899, 8727}},
    {2017, 15, 1349, {1, 1, 1, 9, 21, 37, 35, 115, 197, 587, 81, 2641, 3343, 10733, 17601}},
    {2018, 15, 1359, {1, 1, 5, 1, 21, 9, 39, 95, 47, 289, 355, 183, 5063, 7409, 11539}},
    {2019, 15, 1367, {1, 3, 1, 3, 23, 23, 11, 165, 65, 51, 597, 1657, 4625, 6489, 21539}},
    {2020, 15, 1368, {1, 1, 5, 1, 27, 25, 83, 201, 445, 659, 703, 2129, 5537, 8669, 10197}},
    {2021, 15, 1390, {1, 1, 7, 11, 29, 17, 27, 205, 321, 117, 1519, 3543, 1025, 9761, 3193}},
    {2022, 15, 1413, {1, 3, 1, 13, 7, 17, 109, 3, 243, 495, 1541, 2153, 3391, 10359, 31065}},
    {2023, 15, 1414, {1, 1, 7, 7, 19, 35, 79, 229, 413, 967, 1917, 1363, 5967, 8581, 6219}},
    {2024, 15, 1437, {1, 3, 5, 7, 9, 25, 23, 187, 445, 879, 773, 3335, 7989, 16287, 20037}},
    {2025, 15, 1441, {1, 3, 3, 15, 3, 1, 43, 99, 189, 567, 49, 3215, 3375, 1523, 7707}},
    {2026, 15, 1462, {1, 3, 5, 5, 19, 37, 109, 173, 301, 35, 1231, 1891, 7891, 4673, 8549}},
    {2027, 15, 1465, {1, 3, 3, 3, 9, 25, 115, 35, 63, 773, 289, 3361, 7127, 3485, 23359}},
    {2028, 15, 1480, {1, 3, 5, 13, 21, 23, 113, 187, 59, 103, 1339, 3811, 3527, 1267, 26137}},
    {2029, 15, 1486, {1, 1, 3, 15, 1, 61, 33, 173, 439, 607, 613, 3923, 2389, 3019, 30907}},
    {2030, 15, 1504, {1, 3, 7, 15, 11, 55, 35, 51, 387, 585, 1919, 753, 6919, 10933, 11737}},
    {2031, 15, 1509, {1, 3, 5, 15, 13, 9, 71, 125, 385, 679, 1887, 1205, 2873, 2691, 15301}},
    {2032, 15, 1514, {1, 1, 1, 9, 15, 31, 89, 57, 149, 275, 261, 1777, 4015, 1333, 6515}},
    {2033, 15, 1522, {1, 1, 5, 11, 17, 49, 15, 179, 201, 423, 1725, 2143, 5743, 7745, 14967}},
    {2034, 15, 1528, {1, 1, 5, 5, 11, 31, 63, 127, 273, 549, 181, 273, 581, 3167, 13969}},
    {2035, 15, 1552, {1, 1, 1, 9, 19, 13, 123, 155, 363, 935, 1491, 3609, 7755, 9943, 3}},
    {2036, 15, 1555, {1, 1, 5, 7, 31, 27, 11, 191, 297, 431, 765, 3895, 3075, 15521, 11637}},
    {2037, 15, 1571, {1, 3, 3, 9, 21, 63, 41, 231, 201, 49, 423, 1573, 7411, 5305, 24253}},
    {2038, 15, 1578, {1, 1, 1, 5, 31, 13, 29, 17, 347, 809, 1247, 3027, 3523, 8503, 17913}},
    {2039, 15, 1585, {1, 3, 3, 1, 25, 61, 31, 27, 325, 919, 1979, 2235, 1277, 15285, 5387}},
    {2040, 15, 1588, {1, 1, 5, 15, 5, 3, 91, 25, 477, 399, 319, 3321, 515, 5445, 24811}},
    {2041, 15, 1603, {1, 3, 7, 13, 31, 27, 17, 137, 503, 143, 1485, 703, 179, 13787, 5227}},
    {2042, 15, 1609, {1, 1, 1, 5, 23, 47, 73, 97, 297, 481, 347, 1215, 4213, 10945, 22725}},
    {2043, 15, 1617, {1, 1, 5, 3, 9, 41, 107, 221, 273, 667, 1933, 139, 1005, 14787, 6387}},
    {2044, 15, 1620, {1, 3, 1, 3, 25, 15, 61, 51, 5, 41, 1563, 2719, 5695, 4625, 22765}},
    {2045, 15, 1629, {1, 3, 5, 15, 23, 33, 13, 17, 385, 153, 107, 1935, 5465, 12201, 7447}},
    {2046, 15, 1636, {1, 3, 3, 7, 31, 13, 81, 55, 499, 639, 1455, 3983, 7, 11453, 5179}},
    {2047, 15, 1648, {1, 3, 5, 5, 1, 15, 15, 129, 441, 825, 1985, 3811, 149, 7375, 8407}},
    {2048, 15, 1667, {1, 3, 1, 1, 15, 13, 89, 205, 303, 657, 971, 349, 5033, 6879, 12917}},
    {2049, 15, 1669, {1, 3, 7, 9, 29, 13, 39, 15, 417, 943, 1477, 1053, 6305, 9087, 29601}},
    {2050, 15, 1682, {1, 3, 5, 9, 7, 1, 45, 253, 305, 379, 501, 1873, 7507, 11075, 23027}},
    {2051, 15, 1697, {1, 1, 3, 1, 17, 61, 25, 199, 207, 331, 819, 3617, 365, 4233, 1639}},
    {2052, 15, 1704, {1, 3, 1, 15, 25, 17, 25, 145, 189, 599, 891, 3475, 563, 3197, 7873}},
    {2053, 15, 1709, {1, 1, 5, 7, 19, 59, 5, 35, 207, 425, 767, 3217, 7583, 4351, 11627}},
    {2054, 15, 1727, {1, 1, 5, 11, 3, 43, 105, 197, 455, 315, 1601, 1125, 1823, 1515, 2179}},
    {2055, 15, 1730, {1, 3, 5, 3, 25, 7, 97, 69, 487, 407, 1599, 1087, 3083, 7445, 1369}},
    {2056, 15, 1732, {1, 1, 7, 11, 13, 47, 25, 115, 225, 11, 311, 3037, 2607, 1015, 15603}},
    {2057, 15, 1741, {1, 1, 5, 3, 19, 49, 7, 59, 469, 431, 387, 1909, 983, 1751, 30221}},
    {2058, 15, 1744, {1, 3, 5, 3, 23, 51, 65, 19, 221, 665, 155, 1323, 1497, 10815, 20521}},
    {2059, 15, 1759, {1, 3, 1, 1, 3, 51, 67, 149, 373, 165, 1923, 1043, 3819, 7405, 6115}},
    {2060, 15, 1765, {1, 3, 3, 1, 3, 25, 47, 137, 261, 1001, 1809, 3297, 6119, 6947, 29055}},
    {2061, 15, 1766, {1, 1, 3, 5, 1, 29, 43, 111, 423, 411, 1119, 2719, 4063, 8179, 6727}},
    {2062, 15, 1778, {1, 1, 7, 13, 15, 43, 57, 249, 503, 41, 1533, 1657, 7715, 1761, 24099}},
    {2063, 15, 1780, {1, 1, 1, 11, 27, 23, 51, 131, 479, 495, 1843, 2099, 1551, 957, 14961}},
    {2064, 15, 1783, {1, 3, 7, 15, 7, 47, 63, 51, 433, 429, 27, 3511, 4209, 3735, 21843}},
    {2065, 15, 1797, {1, 3, 3, 3, 19, 9, 39, 207, 191, 77, 1449, 3817, 2389, 5971, 763}},
    {2066, 15, 1807, {1, 3, 3, 3, 13, 9, 123, 253, 279, 515, 1099, 2511, 1233, 12429, 24569}},
    {2067, 15, 1821, {1, 1, 3, 1, 27, 11, 17, 167, 385, 125, 253, 2869, 3583, 16219, 26881}},
    {2068, 15, 1832, {1, 3, 3, 3, 25, 35, 89, 131, 61, 941, 33, 267, 1399, 8411, 1321}},
    {2069, 15, 1835, {1, 3, 5, 15, 3, 1, 109, 61, 499, 81, 1085, 3787, 139, 9827, 12999}},
    {2070, 15, 1849, {1, 3, 3, 1, 23, 61, 35, 145, 325, 865, 699, 33, 2391, 3707, 14153}},
    {2071, 15, 1850, {1, 1, 5, 13, 7, 61, 101, 47, 303, 477, 375, 87, 3689, 1803, 18173}},
    {2072, 15, 1863, {1, 3, 5, 5, 9, 61, 51, 171, 21, 285, 345, 2801, 1113, 7593, 16085}},
    {2073, 15, 1867, {1, 3, 1, 15, 27, 25, 121, 235, 505, 575, 1595, 747, 3295, 10725, 11769}},
    {2074, 15, 1869, {1, 1, 7, 9, 1, 25, 91, 231, 257, 539, 831, 3109, 7933, 2539, 30833}},
    {2075, 15, 1872, {1, 1, 1, 13, 25, 5, 51, 137, 145, 705, 1533, 647, 3539, 12305, 6663}},
    {2076, 15, 1887, {1, 3, 3, 7, 9, 47, 119, 109, 351, 167, 375, 3671, 1655, 3971, 7261}},
    {2077, 15, 1888, {1, 3, 1, 11, 19, 39, 69, 135, 159, 1007, 749, 879, 1923, 1993, 16949}},
    {2078, 15, 1897, {1, 3, 1, 11, 7, 37, 119, 237, 327, 57, 785, 1013, 3801, 14421, 21685}},
    {2079, 15, 1906, {1, 3, 5, 15, 11, 53, 27, 199, 137, 981, 511, 897, 7467, 6827, 28783}},
    {2080, 15, 1917, {1, 3, 7, 3, 17, 47, 9, 145, 153, 105, 1661, 1145, 2671, 15261, 6579}},
    {2081, 15, 1927, {1, 3, 5, 9, 7, 59, 101, 151, 51, 907, 1201, 2359, 6907, 4039, 26507}},
    {2082, 15, 1939, {1, 3, 7, 9, 27, 39, 89, 249, 165, 655, 847, 2321, 7287, 15655, 21707}},
    {2083, 15, 1941, {1, 3, 3, 3, 27, 37, 113, 121, 379, 763, 1955, 1329, 6435, 10091, 8779}},
    {2084, 15, 1948, {1, 1, 7, 9, 27, 43, 17, 37, 313, 663, 801, 2685, 6249, 10353, 31151}},
    {2085, 15, 1970, {1, 1, 7, 3, 25, 7, 5, 207, 71, 427, 1739, 463, 6785, 4159, 1809}},
    {2086, 15, 1979, {1, 1, 7, 13, 7, 41, 125, 27, 357, 343, 1093, 2569, 2991, 395, 18383}},
    {2087, 15, 1982, {1, 3, 1, 3, 29, 17, 87, 73, 85, 273, 1175, 2825, 4727, 10575, 315}},
    {2088, 15, 2002, {1, 3, 3, 7, 31, 35, 87, 27, 11, 423, 1817, 723, 6049, 4513, 17499}},
    {2089, 15, 2020, {1, 1, 5, 7, 23, 31, 123, 195, 453, 581, 371, 195, 1417, 10659, 28837}},
    {2090, 15, 2024, {1, 1, 5, 9, 1, 29, 77, 21, 291, 999, 203, 795, 4563, 15141, 5313}},
    {2091, 15, 2032, {1, 3, 1, 5, 15, 25, 119, 211, 289, 255, 1183, 3261, 7841, 1729, 16521}},
    {2092, 15, 2053, {1, 1, 5, 3, 27, 9, 67, 157, 7, 141, 187, 1031, 7535, 8651, 31595}},
    {2093, 15, 2060, {1, 3, 7, 11, 11, 63, 111, 73, 453, 259, 1963, 2845, 2971, 10815, 12389}},
    {2094, 15, 2063, {1, 3, 3, 7, 9, 51, 91, 231, 455, 379, 1445, 1985, 2209, 16327, 16303}},
    {2095, 15, 2066, {1, 3, 3, 7, 21, 1, 29, 231, 405, 263, 847, 3885, 3487, 11779, 30607}},
    {2096, 15, 2075, {1, 1, 5, 11, 29, 33, 81, 139, 119, 43, 1257, 2759, 4491, 14777, 25007}},
    {2097, 15, 2078, {1, 1, 1, 15, 1, 45, 87, 15, 363, 571, 2025, 3707, 4701, 6465, 24497}},
    {2098, 15, 2081, {1, 1, 7, 7, 29, 15, 115, 29, 35, 227, 1669, 2409, 4889, 6825, 31695}},
    {2099, 15, 2091, {1, 3, 5, 1, 11, 17, 1, 17, 47, 737, 1417, 855, 4697, 2555, 5721}},
    {2100, 15, 2096, {1, 3, 3, 1, 21, 59, 29, 5, 387, 173, 147, 2845, 2289, 299, 6867}},
    {2101, 15, 2102, {1, 3, 5, 7, 3, 41, 87, 97, 135, 995, 1227, 3527, 5611, 7537, 27221}},
    {2102, 15, 2106, {1, 3, 5, 3, 29, 63, 9, 83, 13, 289, 1009, 3281, 2809, 11533, 12153}},
    {2103, 15, 2116, {1, 3, 5, 15, 9, 63, 99, 219, 289, 731, 1345, 3883, 179, 6209, 20605}},
    {2104, 15, 2120, {1, 3, 5, 1, 31, 29, 59, 197, 511, 719, 361, 2235, 1429, 14139, 26365}},
    {2105, 15, 2125, {1, 3, 5, 11, 13, 3, 17, 1, 377, 955, 1331, 2059, 2177, 15579, 4899}},
    {2106, 15, 2134, {1, 3, 7, 11, 25, 19, 93, 9, 173, 167, 1721, 517, 8053, 5459, 16839}},
    {2107, 15, 2178, {1, 3, 1, 3, 21, 21, 7, 237, 135, 173, 235, 101, 7101, 9351, 30381}},
    {2108, 15, 2180, {1, 1, 7, 9, 27, 39, 87, 17, 27, 9, 1829, 3031, 4807, 1241, 7225}},
    {2109, 15, 2187, {1, 1, 1, 7, 15, 27, 125, 229, 279, 795, 901, 777, 2739, 4913, 30471}},
    {2110, 15, 2189, {1, 1, 7, 3, 7, 39, 31, 239, 195, 641, 711, 3109, 587, 9745, 15467}},
    {2111, 15, 2190, {1, 3, 7, 3, 19, 63, 101, 179, 393, 501, 1297, 1761, 4251, 7963, 32109}},
    {2112, 15, 2208, {1, 3, 7, 13, 31, 43, 87, 167, 167, 865, 1953, 3801, 4015, 13931, 11403}},
    {2113, 15, 2214, {1, 1, 7, 5, 25, 63, 17, 213, 323, 563, 1951, 1079, 5741, 6085, 23939}},
    {2114, 15, 2237, {1, 1, 3, 1, 27, 29, 15, 67, 511, 437, 1821, 2073, 1511, 291, 32149}},
    {2115, 15, 2252, {1, 1, 3, 5, 27, 45, 61, 221, 25, 741, 429, 1703, 109, 2733, 3081}},
    {2116, 15, 2257, {1, 3, 1, 15, 27, 35, 1, 111, 467, 383, 1603, 1485, 6121, 14623, 3403}},
    {2117, 15, 2260, {1, 3, 3, 7, 17, 29, 55, 89, 177, 927, 1543, 115, 5189, 4881, 9443}},
    {2118, 15, 2264, {1, 3, 5, 5, 29, 7, 3, 39, 363, 515, 187, 1657, 5975, 13621, 20045}},
    {2119, 15, 2270, {1, 1, 7, 3, 13, 41, 13, 89, 25, 817, 763, 3175, 2981, 3175, 23087}},
    {2120, 15, 2279, {1, 1, 5, 1, 1, 41, 85, 41, 305, 163, 55, 1283, 527, 325, 529}},
    {2121, 15, 2288, {1, 3, 3, 13, 19, 63, 13, 21, 313, 401, 1871, 3763, 1663, 8395, 17873}},
    {2122, 15, 2305, {1, 1, 3, 9, 3, 21, 3, 119, 481, 115, 1221, 1771, 5683, 14329, 8973}},
    {2123, 15, 2312, {1, 3, 5, 5, 5, 17, 117, 143, 65, 475, 1483, 363, 1827, 12091, 489}},
    {2124, 15, 2317, {1, 3, 5, 13, 21, 51, 35, 17, 391, 133, 291, 2625, 6355, 15173, 30837}},
    {2125, 15, 2323, {1, 1, 1, 13, 23, 7, 95, 7, 503, 965, 427, 349, 6847, 3371, 17469}},
    {2126, 15, 2329, {1, 1, 3, 11, 19, 11, 51, 79, 307, 495, 1411, 2025, 921, 8977, 11803}},
    {2127, 15, 2335, {1, 1, 5, 7, 31, 19, 71, 5, 189, 335, 1677, 3355, 5933, 1949, 15723}},
    {2128, 15, 2342, {1, 1, 7, 1, 25, 3, 49, 43, 331, 225, 983, 3249, 7263, 7519, 19271}},
    {2129, 15, 2345, {1, 1, 7, 1, 9, 9, 117, 111, 117, 925, 1339, 1933, 2809, 6951, 30905}},
    {2130, 15, 2365, {1, 3, 3, 3, 11, 31, 87, 233, 409, 9, 899, 4009, 3099, 9757, 1927}},
    {2131, 15, 2371, {1, 1, 3, 9, 23, 17, 79, 123, 221, 579, 299, 3319, 1785, 2703, 3761}},
    {2132, 15, 2378, {1, 3, 3, 9, 19, 33, 127, 85, 269, 977, 701, 523, 3611, 10055, 8135}},
    {2133, 15, 2385, {1, 3, 7, 1, 15, 5, 47, 77, 85, 475, 769, 3473, 3837, 11149, 23787}},
    {2134, 15, 2395, {1, 1, 7, 9, 3, 3, 65, 233, 29, 267, 1119, 2761, 5773, 14011, 1823}},
    {2135, 15, 2404, {1, 3, 5, 15, 15, 45, 23, 255, 185, 239, 1063, 1605, 2807, 5405, 21977}},
    {2136, 15, 2414, {1, 3, 7, 13, 1, 29, 13, 105, 145, 131, 211, 2749, 8127, 12945, 17625}},
    {2137, 15, 2426, {1, 1, 5, 13, 1, 25, 23, 197, 385, 745, 1231, 19, 5267, 2283, 6453}},
    {2138, 15, 2428, {1, 3, 1, 5, 27, 63, 107, 179, 87, 351, 1731, 5, 3213, 11093, 24429}},
    {2139, 15, 2441, {1, 3, 3, 7, 27, 59, 33, 149, 253, 641, 1295, 2099, 4745, 9815, 24131}},
    {2140, 15, 2456, {1, 1, 1, 7, 9, 39, 85, 127, 19, 123, 381, 3053, 6499, 4645, 171}},
    {2141, 15, 2466, {1, 1, 3, 15, 23, 11, 39, 61, 279, 255, 1905, 2395, 4037, 15149, 17017}},
    {2142, 15, 2468, {1, 3, 3, 5, 7, 21, 45, 41, 5, 81, 1801, 881, 7059, 12367, 15935}},
    {2143, 15, 2475, {1, 1, 7, 11, 27, 61, 121, 45, 427, 875, 1907, 3459, 1007, 9257, 13895}},
    {2144, 15, 2489, {1, 3, 1, 7, 27, 51, 69, 57, 113, 801, 183, 429, 6317, 7533, 5747}},
    {2145, 15, 2495, {1, 1, 3, 13, 3, 11, 67, 121, 397, 1015, 523, 203, 6397, 10349, 26601}},
    {2146, 15, 2497, {1, 1, 3, 11, 29, 25, 101, 19, 355, 363, 1053, 3849, 621, 4427, 6575}},
    {2147, 15, 2510, {1, 1, 5, 13, 19, 19, 55, 227, 135, 159, 1809, 285, 1715, 10267, 20663}},
    {2148, 15, 2512, {1, 3, 5, 13, 25, 13, 3, 47, 279, 171, 1383, 2249, 5739, 5977, 20331}},
    {2149, 15, 2522, {1, 1, 3, 5, 1, 37, 45, 241, 479, 675, 767, 2263, 7707, 5597, 13041}},
    {2150, 15, 2533, {1, 1, 3, 5, 23, 43, 95, 63, 353, 539, 1043, 2641, 2715, 371, 19919}},
    {2151, 15, 2543, {1, 1, 7, 9, 3, 35, 125, 231, 293, 497, 929, 3951, 3207, 6519, 10595}},
    {2152, 15, 2551, {1, 3, 3, 9, 9, 61, 51, 139, 207, 493, 1359, 503, 7543, 13317, 32609}},
    {2153, 15, 2552, {1, 1, 7, 9, 25, 11, 67, 23, 183, 887, 1819, 1303, 5409, 11631, 7443}},
    {2154, 15, 2557, {1, 3, 7, 9, 3, 41, 99, 131, 131, 383, 1005, 2905, 217, 7495, 449}},
    {2155, 15, 2567, {1, 3, 1, 9, 7, 45, 9, 77, 393, 699, 1287, 2317, 305, 1057, 4775}},
    {2156, 15, 2581, {1, 1, 1, 5, 29, 53, 35, 19, 367, 691, 799, 2543, 3115, 13583, 917}},
    {2157, 15, 2586, {1, 1, 3, 7, 23, 63, 11, 13, 59, 785, 1421, 2539, 6407, 1369, 19581}},
    {2158, 15, 2597, {1, 1, 5, 7, 21, 1, 23, 17, 311, 77, 1369, 3525, 6233, 9609, 16307}},
    {2159, 15, 2601, {1, 3, 1, 13, 27, 33, 113, 199, 291, 409, 913, 1273, 4239, 9415, 28659}},
    {2160, 15, 2622, {1, 3, 1, 1, 5, 43, 107, 57, 77, 339, 715, 2699, 6605, 13813, 10187}},
    {2161, 15, 2633, {1, 3, 5, 13, 27, 41, 91, 41, 383, 601, 1277, 1255, 775, 337, 11381}},
    {2162, 15, 2636, {1, 1, 1, 11, 21, 13, 35, 227, 281, 127, 1297, 3391, 5819, 9537, 16989}},
    {2163, 15, 2642, {1, 1, 1, 11, 27, 55, 27, 199, 353, 93, 77, 3859, 7829, 7347, 27481}},
    {2164, 15, 2644, {1, 3, 7, 5, 9, 51, 41, 103, 493, 451, 1647, 3715, 7359, 3425, 11765}},
    {2165, 15, 2653, {1, 3, 1, 3, 19, 51, 103, 81, 77, 69, 25, 3713, 1949, 11609, 32421}},
    {2166, 15, 2667, {1, 1, 5, 3, 9, 63, 15, 61, 333, 567, 1339, 1247, 4309, 12267, 27323}},
    {2167, 15, 2669, {1, 1, 3, 1, 13, 29, 89, 23, 291, 729, 1569, 1543, 7807, 10893, 9159}},
    {2168, 15, 2672, {1, 1, 7, 9, 11, 23, 73, 91, 383, 511, 769, 3163, 4983, 973, 5971}},
    {2169, 15, 2675, {1, 1, 3, 1, 17, 21, 7, 111, 339, 901, 133, 4071, 7993, 373, 7589}},
    {2170, 15, 2682, {1, 3, 5, 5, 15, 27, 15, 139, 15, 353, 1323, 1391, 6753, 7553, 11967}},
    {2171, 15, 2687, {1, 3, 7, 13, 29, 51, 123, 25, 493, 101, 1521, 3749, 5957, 8173, 31397}},
    {2172, 15, 2691, {1, 3, 3, 9, 11, 41, 85, 107, 149, 45, 1655, 675, 2941, 9877, 8321}},
    {2173, 15, 2698, {1, 1, 1, 11, 3, 9, 97, 139, 423, 29, 775, 2511, 881, 5813, 22099}},
    {2174, 15, 2708, {1, 3, 1, 1, 13, 57, 93, 247, 139, 363, 637, 1065, 691, 6193, 6429}},
    {2175, 15, 2712, {1, 3, 7, 15, 5, 27, 29, 107, 155, 473, 341, 909, 657, 2129, 4151}},
    {2176, 15, 2718, {1, 3, 3, 9, 15, 59, 33, 21, 141, 475, 571, 3207, 4595, 15357, 1775}},
    {2177, 15, 2722, {1, 1, 1, 15, 11, 13, 113, 107, 449, 1019, 1007, 931, 665, 9021, 11681}},
    {2178, 15, 2736, {1, 1, 3, 7, 5, 47, 53, 231, 87, 185, 573, 2605, 7887, 14035, 32133}},
    {2179, 15, 2741, {1, 3, 7, 9, 5, 31, 9, 47, 427, 489, 877, 1389, 7889, 12147, 16867}},
    {2180, 15, 2756, {1, 3, 3, 3, 7, 5, 49, 33, 107, 819, 1651, 3177, 2437, 9161, 15927}},
    {2181, 15, 2765, {1, 3, 1, 15, 15, 13, 85, 127, 355, 759, 771, 2661, 2067, 875, 21119}},
    {2182, 15, 2774, {1, 3, 7, 15, 29, 5, 49, 191, 191, 203, 127, 2587, 5197, 3769, 1287}},
    {2183, 15, 2799, {1, 3, 3, 1, 23, 19, 11, 121, 187, 815, 621, 2167, 3667, 16293, 18321}},
    {2184, 15, 2804, {1, 1, 7, 13, 25, 1, 119, 55, 375, 323, 1533, 3535, 5201, 4953, 213}},
    {2185, 15, 2825, {1, 3, 5, 5, 23, 25, 81, 19, 437, 249, 761, 2313, 3343, 11535, 2621}},
    {2186, 15, 2826, {1, 3, 1, 7, 27, 11, 43, 173, 131, 457, 495, 987, 617, 13057, 30305}},
    {2187, 15, 2840, {1, 3, 3, 9, 25, 39, 25, 89, 115, 701, 43, 1437, 6819, 10883, 31141}},
    {2188, 15, 2843, {1, 3, 7, 11, 31, 37, 43, 23, 289, 961, 401, 561, 7551, 15507, 13675}},
    {2189, 15, 2846, {1, 3, 7, 7, 17, 19, 105, 179, 469, 357, 1885, 2831, 5917, 657, 11487}},
    {2190, 15, 2849, {1, 3, 7, 1, 23, 31, 5, 217, 457, 757, 523, 2547, 1041, 14741, 6299}},
    {2191, 15, 2867, {1, 1, 3, 9, 17, 45, 77, 207, 465, 395, 1413, 4033, 5541, 12569, 9149}},
    {2192, 15, 2876, {1, 3, 5, 13, 29, 11, 67, 113, 365, 933, 269, 2895, 6441, 7145, 3531}},
    {2193, 15, 2891, {1, 1, 5, 15, 23, 17, 127, 157, 255, 81, 87, 1371, 2031, 2927, 28695}},
    {2194, 15, 2902, {1, 1, 5, 5, 13, 15, 51, 229, 349, 547, 1009, 3511, 6623, 1851, 29375}},
    {2195, 15, 2912, {1, 3, 7, 15, 5, 21, 19, 135, 287, 295, 1869, 3163, 8069, 10333, 2713}},
    {2196, 15, 2917, {1, 3, 1, 3, 25, 41, 125, 89, 55, 349, 351, 3909, 491, 12613, 11015}},
    {2197, 15, 2927, {1, 1, 5, 1, 7, 43, 19, 179, 91, 433, 93, 1717, 1973, 921, 26861}},
    {2198, 15, 2941, {1, 3, 3, 5, 9, 9, 87, 39, 79, 341, 873, 769, 5615, 12515, 31365}},
    {2199, 15, 2965, {1, 3, 5, 7, 27, 37, 31, 223, 49, 945, 1623, 1839, 7, 13165, 30863}},
    {2200, 15, 2970, {1, 3, 5, 11, 31, 11, 107, 25, 253, 645, 915, 2581, 821, 457, 249}},
    {2201, 15, 2982, {1, 1, 3, 11, 7, 59, 7, 187, 381, 891, 79, 529, 5915, 5615, 18025}},
    {2202, 15, 2993, {1, 1, 1, 11, 9, 11, 99, 217, 143, 859, 741, 1363, 2067, 9603, 7407}},
    {2203, 15, 3018, {1, 1, 7, 3, 27, 7, 99, 179, 441, 247, 1613, 2087, 7873, 6977, 10789}},
    {2204, 15, 3023, {1, 3, 7, 11, 25, 51, 15, 195, 489, 179, 1585, 1381, 2073, 5149, 27021}},
    {2205, 15, 3025, {1, 1, 7, 1, 1, 31, 9, 231, 211, 165, 1327, 2903, 155, 15149, 2281}},
    {2206, 15, 3026, {1, 1, 1, 5, 23, 63, 121, 183, 505, 409, 811, 3119, 6529, 12453, 26125}},
    {2207, 15, 3028, {1, 1, 3, 13, 5, 19, 81, 93, 81, 753, 1717, 311, 3791, 15861, 4961}},
    {2208, 15, 3032, {1, 1, 3, 5, 1, 3, 109, 77, 213, 965, 51, 425, 3601, 13603, 14093}},
    {2209, 15, 3053, {1, 1, 3, 15, 31, 11, 25, 23, 53, 793, 1579, 329, 4759, 9653, 14505}},
    {2210, 15, 3054, {1, 3, 5, 15, 11, 49, 57, 151, 339, 755, 1901, 1243, 6407, 11581, 27249}},
    {2211, 15, 3065, {1, 3, 5, 15, 13, 53, 7, 151, 13, 815, 399, 5, 5621, 4835, 12579}},
    {2212, 15, 3071, {1, 1, 1, 9, 3, 25, 119, 25, 441, 129, 803, 1429, 6345, 12487, 24607}},
    {2213, 15, 3076, {1, 3, 3, 11, 5, 61, 53, 41, 455, 363, 795, 3635, 8077, 4051, 27729}},
    {2214, 15, 3088, {1, 1, 1, 9, 9, 17, 103, 125, 209, 575, 2031, 3925, 7047, 483, 19555}},
    {2215, 15, 3107, {1, 3, 7, 5, 27, 53, 21, 191, 407, 497, 1587, 2417, 1533, 11267, 12129}},
    {2216, 15, 3146, {1, 3, 3, 11, 17, 25, 79, 241, 481, 487, 1897, 2237, 1957, 9261, 24415}},
    {2217, 15, 3148, {1, 3, 1, 7, 17, 13, 25, 19, 71, 827, 67, 3257, 4397, 14667, 24259}},
    {2218, 15, 3159, {1, 3, 7, 11, 31, 25, 123, 211, 345, 845, 569, 3103, 5991, 6573, 30489}},
    {2219, 15, 3165, {1, 1, 3, 7, 13, 63, 101, 209, 261, 107, 855, 4073, 1125, 9281, 1899}},
    {2220, 15, 3170, {1, 3, 7, 13, 15, 9, 109, 187, 373, 795, 955, 1187, 7481, 5309, 20491}},
    {2221, 15, 3179, {1, 1, 5, 15, 25, 23, 37, 85, 171, 389, 1441, 1689, 7323, 10369, 25225}},
    {2222, 15, 3182, {1, 3, 5, 7, 21, 59, 109, 217, 493, 257, 1803, 401, 4335, 9149, 10871}},
    {2223, 15, 3205, {1, 3, 1, 11, 9, 11, 33, 203, 269, 943, 495, 311, 4577, 8367, 32133}},
    {2224, 15, 3212, {1, 3, 5, 7, 17, 11, 93, 251, 349, 315, 1393, 2853, 4479, 109, 18185}},
    {2225, 15, 3218, {1, 3, 1, 11, 5, 41, 125, 219, 319, 129, 171, 433, 3383, 14177, 14725}},
    {2226, 15, 3220, {1, 1, 1, 11, 25, 5, 69, 119, 403, 823, 1139, 1055, 6535, 475, 24599}},
    {2227, 15, 3223, {1, 1, 5, 13, 27, 55, 85, 215, 81, 359, 913, 227, 7353, 5557, 7669}},
    {2228, 15, 3227, {1, 1, 3, 1, 15, 49, 63, 45, 313, 295, 1193, 3087, 6629, 7275, 6451}},
    {2229, 15, 3233, {1, 3, 1, 13, 7, 31, 63, 51, 153, 799, 591, 3243, 3671, 11857, 6403}},
    {2230, 15, 3234, {1, 3, 3, 3, 5, 29, 103, 229, 267, 849, 573, 1497, 5953, 1743, 23929}},
    {2231, 15, 3254, {1, 1, 7, 5, 29, 43, 95, 161, 203, 77, 1711, 85, 6651, 12567, 19111}},
    {2232, 15, 3263, {1, 3, 3, 3, 15, 17, 127, 25, 417, 841, 1529, 3313, 537, 5865, 6855}},
    {2233, 15, 3268, {1, 1, 3, 5, 17, 29, 5, 41, 345, 327, 581, 23, 2163, 13735, 26141}},
    {2234, 15, 3272, {1, 3, 7, 5, 25, 33, 61, 153, 409, 97, 1401, 3745, 7195, 7363, 3745}},
    {2235, 15, 3277, {1, 3, 7, 11, 27, 21, 47, 197, 231, 537, 715, 2629, 7197, 715, 23711}},
    {2236, 15, 3292, {1, 3, 1, 5, 27, 13, 35, 217, 9, 539, 27, 2339, 3415, 2695, 18879}},
    {2237, 15, 3295, {1, 1, 1, 5, 29, 17, 81, 195, 221, 649, 1337, 527, 1945, 9995, 6475}},
    {2238, 15, 3296, {1, 1, 7, 1, 3, 31, 127, 75, 361, 679, 109, 3975, 689, 12455, 19263}},
    {2239, 15, 3301, {1, 1, 1, 5, 27, 1, 21, 141, 331, 941, 1931, 4009, 6353, 9257, 3825}},
    {2240, 15, 3306, {1, 1, 3, 15, 25, 7, 61, 175, 423, 199, 1835, 2115, 1849, 13689, 8067}},
    {2241, 15, 3313, {1, 1, 3, 3, 17, 59, 107, 97, 433, 321, 643, 3351, 7675, 14579, 7453}},
    {2242, 15, 3346, {1, 3, 3, 3, 25, 5, 43, 253, 199, 395, 1047, 3207, 1129, 3889, 21363}},
    {2243, 15, 3367, {1, 3, 7, 15, 13, 19, 15, 249, 21, 281, 909, 3703, 7821, 6277, 18821}},
    {2244, 15, 3371, {1, 3, 3, 3, 7, 27, 13, 215, 395, 531, 1293, 2509, 6605, 8095, 1857}},
    {2245, 15, 3373, {1, 3, 3, 11, 9, 45, 49, 69, 37, 755, 1311, 1165, 2025, 575, 28285}},
    {2246, 15, 3374, {1, 3, 3, 3, 23, 47, 123, 231, 419, 621, 317, 3347, 3803, 12195, 4203}},
    {2247, 15, 3376, {1, 3, 7, 7, 9, 17, 71, 33, 349, 453, 41, 1513, 1619, 2241, 3075}},
    {2248, 15, 3382, {1, 3, 1, 1, 23, 53, 65, 21, 23, 951, 287, 1323, 1035, 8835, 7127}},
    {2249, 15, 3388, {1, 3, 5, 9, 25, 23, 79, 223, 233, 471, 589, 1895, 2945, 13677, 23993}},
    {2250, 15, 3391, {1, 1, 5, 7, 25, 57, 27, 67, 149, 801, 905, 3659, 2203, 9015, 29095}},
    {2251, 15, 3403, {1, 1, 7, 11, 25, 27, 11, 121, 391, 599, 133, 2047, 2421, 1753, 28793}},
    {2252, 15, 3406, {1, 1, 7, 13, 25, 29, 45, 15, 285, 909, 371, 67, 6625, 2903, 18987}},
    {2253, 15, 3413, {1, 3, 1, 3, 11, 35, 121, 235, 197, 203, 1781, 3425, 7471, 9365, 18031}},
    {2254, 15, 3420, {1, 1, 3, 7, 23, 27, 115, 255, 15, 789, 103, 3041, 3955, 9227, 26675}},
    {2255, 15, 3427, {1, 1, 3, 11, 21, 51, 67, 221, 37, 939, 809, 3573, 3567, 5785, 6085}},
    {2256, 15, 3441, {1, 3, 1, 5, 21, 23, 107, 203, 271, 107, 1431, 783, 6891, 9743, 22505}},
    {2257, 15, 3453, {1, 3, 1, 11, 23, 47, 83, 155, 467, 19, 1227, 2037, 1079, 5913, 7417}},
    {2258, 15, 3464, {1, 1, 5, 9, 19, 11, 81, 171, 69, 325, 1083, 3155, 7267, 2547, 245}},
    {2259, 15, 3469, {1, 3, 5, 13, 13, 25, 83, 55, 479, 225, 399, 3621, 3615, 7861, 16797}},
    {2260, 15, 3481, {1, 3, 7, 9, 15, 31, 77, 23, 109, 695, 259, 3267, 7813, 6807, 15939}},
    {2261, 15, 3488, {1, 3, 3, 1, 13, 39, 49, 161, 175, 947, 647, 3175, 1487, 1871, 25871}},
    {2262, 15, 3497, {1, 1, 1, 15, 5, 61, 49, 17, 463, 93, 1881, 759, 5327, 7619, 24717}},
    {2263, 15, 3503, {1, 1, 7, 9, 31, 27, 83, 125, 209, 715, 1097, 1213, 5383, 9819, 31105}},
    {2264, 15, 3511, {1, 3, 1, 1, 7, 61, 39, 249, 243, 69, 1175, 3943, 4367, 9649, 26473}},
    {2265, 15, 3515, {1, 1, 3, 5, 27, 1, 71, 113, 443, 21, 1019, 3431, 257, 343, 23867}},
    {2266, 15, 3525, {1, 1, 3, 7, 21, 37, 63, 13, 509, 519, 969, 3343, 8125, 2687, 3303}},
    {2267, 15, 3529, {1, 3, 5, 11, 23, 13, 65, 253, 385, 29, 1071, 939, 2789, 333, 9049}},
    {2268, 15, 3547, {1, 1, 3, 9, 7, 61, 61, 205, 477, 799, 1493, 2583, 2029, 1169, 21331}},
    {2269, 15, 3550, {1, 3, 7, 15, 31, 39, 113, 85, 337, 899, 1825, 4073, 791, 715, 31203}},
    {2270, 15, 3573, {1, 3, 1, 13, 5, 7, 3, 177, 309, 537, 823, 727, 5917, 6559, 2065}},
    {2271, 15, 3583, {1, 3, 3, 13, 11, 23, 31, 5, 151, 895, 597, 195, 999, 2139, 22993}},
    {2272, 15, 3594, {1, 1, 3, 15, 31, 21, 99, 17, 391, 819, 879, 1927, 4229, 8953, 19137}},
    {2273, 15, 3607, {1, 3, 1, 1, 13, 17, 17, 223, 269, 689, 1309, 1009, 6765, 4835, 18995}},
    {2274, 15, 3613, {1, 3, 5, 13, 31, 43, 49, 63, 183, 143, 249, 669, 6353, 7535, 7205}},
    {2275, 15, 3624, {1, 1, 5, 13, 27, 55, 27, 41, 209, 155, 231, 1609, 493, 8971, 6367}},
    {2276, 15, 3630, {1, 1, 7, 11, 17, 63, 121, 233, 215, 383, 165, 555, 1153, 1643, 11435}},
    {2277, 15, 3635, {1, 3, 1, 9, 29, 11, 89, 117, 195, 639, 2043, 3955, 5201, 5237, 11103}},
    {2278, 15, 3642, {1, 1, 5, 5, 13, 25, 11, 135, 175, 629, 1119, 2679, 1439, 9913, 15695}},
    {2279, 15, 3644, {1, 3, 3, 1, 7, 45, 5, 7, 257, 5, 539, 2987, 1145, 10463, 16613}},
    {2280, 15, 3650, {1, 3, 1, 7, 31, 47, 37, 45, 331, 289, 535, 725, 309, 3525, 24977}},
    {2281, 15, 3679, {1, 3, 7, 7, 7, 17, 81, 147, 117, 277, 1779, 1081, 6353, 2403, 28879}},
    {2282, 15, 3690, {1, 1, 1, 13, 7, 31, 85, 187, 151, 933, 1033, 1321, 4575, 6695, 65}},
    {2283, 15, 3698, {1, 3, 7, 11, 3, 31, 5, 39, 335, 875, 1985, 2327, 2599, 9837, 31029}},
    {2284, 15, 3704, {1, 3, 7, 1, 3, 43, 73, 93, 73, 47, 413, 2979, 2273, 3665, 2021}},
    {2285, 15, 3707, {1, 3, 5, 1, 1, 53, 71, 225, 29, 677, 1883, 2355, 2527, 8833, 865}},
    {2286, 15, 3713, {1, 1, 1, 7, 3, 15, 59, 189, 59, 1003, 1673, 3513, 3415, 3225, 21543}},
    {2287, 15, 3754, {1, 1, 7, 11, 13, 35, 101, 197, 251, 719, 931, 211, 7769, 4413, 24727}},
    {2288, 15, 3756, {1, 3, 5, 13, 17, 45, 125, 229, 173, 953, 211, 2873, 791, 6495, 32535}},
    {2289, 15, 3761, {1, 1, 5, 13, 13, 21, 109, 5, 185, 595, 1889, 285, 3809, 6639, 5181}},
    {2290, 15, 3776, {1, 1, 3, 13, 21, 27, 41, 35, 421, 191, 1339, 3751, 859, 7007, 31025}},
    {2291, 15, 3781, {1, 1, 7, 7, 13, 11, 27, 127, 93, 355, 1777, 3387, 1113, 4109, 17545}},
    {2292, 15, 3788, {1, 1, 3, 3, 9, 41, 27, 57, 461, 585, 1253, 3859, 1515, 10417, 27231}},
    {2293, 15, 3791, {1, 1, 5, 11, 1, 61, 73, 227, 81, 553, 375, 1631, 3341, 1567, 16235}},
    {2294, 15, 3794, {1, 3, 1, 1, 5, 27, 115, 181, 281, 57, 321, 3781, 6751, 8719, 32643}},
    {2295, 15, 3806, {1, 1, 7, 1, 5, 13, 117, 187, 271, 901, 465, 4075, 3081, 15291, 22375}},
    {2296, 15, 3841, {1, 1, 3, 13, 27, 29, 35, 129, 73, 413, 897, 1283, 6709, 4103, 2981}},
    {2297, 15, 3848, {1, 1, 7, 15, 5, 13, 41, 133, 389, 495, 365, 1181, 1953, 15717, 30501}},
    {2298, 15, 3851, {1, 1, 5, 11, 27, 33, 65, 211, 335, 605, 617, 3247, 1813, 2103, 19375}},
    {2299, 15, 3856, {1, 3, 1, 13, 11, 57, 51, 185, 41, 535, 185, 2389, 7377, 743, 20245}},
    {2300, 15, 3868, {1, 1, 7, 1, 25, 15, 39, 175, 83, 593, 1877, 2023, 7365, 13705, 22907}},
    {2301, 15, 3875, {1, 1, 1, 11, 29, 13, 77, 189, 329, 733, 2033, 3941, 2291, 15771, 19409}},
    {2302, 15, 3882, {1, 1, 1, 5, 23, 23, 21, 209, 55, 473, 33, 2555, 2969, 1981, 24815}},
    {2303, 15, 3884, {1, 3, 1, 5, 21, 13, 125, 109, 413, 375, 1343, 1471, 7965, 10361, 1609}},
    {2304, 15, 3889, {1, 1, 1, 1, 21, 13, 43, 55, 283, 131, 189, 653, 417, 14951, 17467}},
    {2305, 15, 3892, {1, 1, 3, 9, 31, 43, 71, 251, 119, 481, 133, 1845, 737, 10235, 11895}},
    {2306, 15, 3919, {1, 1, 1, 5, 31, 5, 75, 49, 51, 865, 1927, 3603, 1601, 10513, 15143}},
    {2307, 15, 3921, {1, 1, 3, 5, 27, 35, 95, 185, 475, 219, 787, 2791, 5549, 13909, 1275}},
    {2308, 15, 3958, {1, 1, 7, 3, 15, 9, 105, 39, 163, 869, 1723, 1007, 7407, 7783, 21879}},
    {2309, 15, 3961, {1, 3, 7, 7, 3, 5, 107, 233, 37, 703, 1025, 3431, 7529, 14831, 25505}},
    {2310, 15, 3973, {1, 1, 3, 5, 27, 61, 55, 89, 207, 709, 1345, 2691, 7175, 13519, 14579}},
    {2311, 15, 3977, {1, 1, 1, 11, 1, 37, 33, 33, 227, 641, 1895, 3555, 5127, 6421, 27655}},
    {2312, 15, 3985, {1, 1, 7, 5, 5, 23, 85, 39, 463, 735, 671, 4015, 4855, 14013, 17789}},
    {2313, 15, 3991, {1, 1, 1, 13, 19, 47, 53, 183, 421, 113, 1243, 687, 2977, 905, 11453}},
    {2314, 15, 4004, {1, 1, 5, 1, 29, 19, 27, 145, 29, 173, 1167, 3213, 3163, 3371, 16947}},
    {2315, 15, 4007, {1, 3, 1, 11, 13, 25, 41, 193, 9, 491, 1619, 789, 583, 2245, 20649}},
    {2316, 15, 4019, {1, 3, 1, 7, 29, 43, 125, 209, 33, 171, 1413, 373, 1643, 4529, 20005}},
    {2317, 15, 4045, {1, 1, 3, 13, 1, 3, 103, 223, 345, 631, 535, 1547, 7083, 14595, 28911}},
    {2318, 15, 4054, {1, 1, 1, 11, 13, 11, 75, 179, 391, 21, 1889, 533, 8149, 4293, 32349}},
    {2319, 15, 4057, {1, 3, 5, 15, 25, 5, 21, 211, 353, 247, 861, 3955, 7537, 4693, 16489}},
    {2320, 15, 4058, {1, 1, 5, 5, 25, 63, 35, 147, 13, 371, 1875, 3827, 7215, 6953, 5121}},
    {2321, 15, 4070, {1, 3, 7, 7, 13, 55, 65, 237, 227, 3, 37, 3289, 1443, 601, 30269}},
    {2322, 15, 4101, {1, 1, 5, 13, 19, 55, 119, 97, 51, 229, 1923, 3621, 4537, 11079, 3965}},
    {2323, 15, 4113, {1, 1, 3, 3, 21, 11, 59, 183, 367, 713, 321, 2351, 4297, 10835, 30623}},
    {2324, 15, 4114, {1, 1, 3, 5, 7, 59, 15, 15, 23, 741, 1631, 277, 2857, 1221, 15723}},
    {2325, 15, 4119, {1, 1, 7, 13, 21, 45, 61, 13, 27, 653, 313, 2491, 6003, 7411, 3921}},
    {2326, 15, 4129, {1, 3, 1, 5, 1, 39, 49, 109, 505, 225, 1551, 4049, 943, 16023, 24481}},
    {2327, 15, 4141, {1, 1, 7, 15, 3, 9, 61, 229, 63, 939, 1945, 633, 655, 13981, 25869}},
    {2328, 15, 4142, {1, 3, 1, 7, 1, 43, 109, 101, 457, 269, 21, 2183, 6437, 15405, 2187}},
    {2329, 15, 4147, {1, 3, 5, 9, 23, 9, 83, 23, 465, 391, 929, 3163, 7801, 4123, 27129}},
    {2330, 15, 4149, {1, 3, 7, 3, 23, 11, 87, 19, 5, 103, 1323, 1897, 7467, 12963, 21555}},
    {2331, 15, 4150, {1, 1, 3, 5, 13, 39, 29, 109, 105, 95, 791, 3963, 4035, 13983, 31559}},
    {2332, 15, 4164, {1, 1, 7, 3, 31, 39, 61, 149, 111, 635, 1399, 675, 7385, 16193, 4685}},
    {2333, 15, 4168, {1, 1, 7, 3, 23, 61, 127, 113, 173, 781, 309, 2515, 5463, 6655, 15393}},
    {2334, 15, 4186, {1, 3, 7, 11, 13, 29, 91, 107, 59, 949, 715, 2497, 2753, 13119, 14359}},
    {2335, 15, 4198, {1, 1, 3, 7, 13, 33, 51, 137, 93, 661, 975, 1579, 6291, 1157, 9557}},
    {2336, 15, 4207, {1, 1, 3, 1, 27, 55, 27, 159, 405, 871, 1465, 411, 6151, 4629, 20059}},
    {2337, 15, 4221, {1, 1, 1, 1, 29, 39, 85, 155, 203, 439, 1963, 3451, 7443, 1527, 7217}},
    {2338, 15, 4225, {1, 1, 1, 1, 19, 17, 107, 51, 311, 651, 515, 399, 4233, 8039, 29689}},
    {2339, 15, 4231, {1, 3, 1, 1, 23, 7, 127, 69, 67, 829, 1261, 3193, 4729, 13755, 32699}},
    {2340, 15, 4238, {1, 1, 1, 3, 27, 3, 29, 139, 353, 633, 503, 3779, 435, 6783, 19547}},
    {2341, 15, 4243, {1, 1, 7, 3, 5, 9, 73, 249, 307, 421, 1461, 849, 4957, 13027, 1267}},
    {2342, 15, 4249, {1, 1, 3, 13, 19, 33, 85, 151, 97, 925, 801, 2119, 1733, 471, 27635}},
    {2343, 15, 4250, {1, 3, 7, 11, 15, 21, 21, 205, 293, 995, 1121, 261, 347, 5427, 9773}},
    {2344, 15, 4252, {1, 1, 5, 1, 7, 3, 53, 117, 477, 747, 1589, 447, 6163, 8809, 25665}},
    {2345, 15, 4259, {1, 3, 5, 3, 23, 39, 53, 195, 291, 647, 19, 581, 93, 10317, 9777}},
    {2346, 15, 4279, {1, 3, 1, 9, 13, 53, 103, 81, 33, 83, 1503, 659, 7273, 14095, 12205}},
    {2347, 15, 4285, {1, 1, 1, 11, 7, 59, 9, 159, 203, 475, 1557, 3475, 7949, 739, 7035}},
    {2348, 15, 4288, {1, 3, 1, 9, 27, 27, 101, 5, 107, 827, 127, 3893, 1359, 11491, 23433}},
    {2349, 15, 4303, {1, 1, 5, 5, 19, 11, 35, 133, 201, 935, 307, 2849, 3881, 8655, 13439}},
    {2350, 15, 4312, {1, 3, 1, 1, 25, 23, 1, 227, 311, 349, 837, 2407, 2859, 8167, 16257}},
    {2351, 15, 4322, {1, 3, 3, 1, 5, 45, 1, 45, 51, 153, 1877, 1609, 1901, 3953, 19837}},
    {2352, 15, 4327, {1, 3, 7, 3, 25, 49, 59, 19, 207, 203, 1349, 75, 2017, 7647, 20791}},
    {2353, 15, 4336, {1, 1, 7, 1, 7, 23, 77, 251, 49, 79, 1983, 4019, 3145, 10193, 31969}},
    {2354, 15, 4359, {1, 3, 1, 13, 29, 21, 53, 107, 173, 199, 2001, 3211, 2041, 11079, 9877}},
    {2355, 15, 4384, {1, 1, 1, 13, 17, 39, 1, 87, 43, 473, 253, 3939, 4245, 13215, 4371}},
    {2356, 15, 4387, {1, 3, 5, 15, 7, 37, 17, 249, 503, 529, 523, 3939, 2223, 6959, 9305}},
    {2357, 15, 4401, {1, 1, 7, 1, 19, 39, 107, 241, 489, 331, 623, 3035, 3137, 5811, 13683}},
    {2358, 15, 4407, {1, 1, 5, 13, 23, 41, 59, 47, 327, 433, 1077, 2901, 5387, 3643, 15179}},
    {2359, 15, 4428, {1, 3, 1, 5, 7, 1, 35, 107, 27, 55, 1875, 261, 5821, 11079, 17467}},
    {2360, 15, 4436, {1, 3, 7, 13, 31, 49, 47, 155, 101, 453, 1795, 1327, 7009, 13031, 4975}},
    {2361, 15, 4450, {1, 3, 5, 11, 19, 39, 125, 121, 39, 829, 427, 773, 5845, 12599, 9755}},
    {2362, 15, 4452, {1, 3, 7, 15, 7, 47, 59, 55, 383, 981, 199, 2129, 4675, 6009, 16433}},
    {2363, 15, 4459, {1, 1, 7, 11, 7, 17, 99, 143, 5, 219, 423, 3475, 7253, 991, 13893}},
    {2364, 15, 4461, {1, 1, 5, 11, 13, 27, 25, 17, 63, 603, 695, 349, 6767, 843, 17777}},
    {2365, 15, 4470, {1, 1, 1, 9, 11, 37, 5, 145, 321, 71, 635, 1955, 5851, 13129, 31783}},
    {2366, 15, 4483, {1, 1, 1, 15, 17, 1, 45, 177, 39, 237, 693, 3021, 2613, 13997, 1327}},
    {2367, 15, 4485, {1, 1, 1, 9, 5, 57, 99, 171, 339, 997, 119, 2987, 779, 5779, 12743}},
    {2368, 15, 4486, {1, 1, 7, 1, 17, 5, 81, 103, 11, 117, 511, 1805, 4953, 2195, 6733}},
    {2369, 15, 4492, {1, 1, 5, 13, 9, 13, 39, 195, 133, 817, 1843, 3321, 6357, 10029, 1505}},
    {2370, 15, 4497, {1, 3, 7, 5, 13, 27, 77, 67, 21, 177, 1141, 2805, 7487, 12091, 29059}},
    {2371, 15, 4514, {1, 3, 5, 5, 19, 63, 69, 29, 317, 273, 415, 337, 5797, 5713, 24627}},
    {2372, 15, 4533, {1, 3, 3, 11, 7, 5, 55, 149, 43, 59, 241, 1233, 1967, 9969, 18457}},
    {2373, 15, 4537, {1, 1, 3, 1, 31, 13, 59, 241, 159, 71, 1513, 2673, 1217, 10305, 22059}},
    {2374, 15, 4546, {1, 3, 5, 1, 31, 17, 69, 47, 111, 85, 1759, 1933, 155, 15685, 1611}},
    {2375, 15, 4551, {1, 1, 5, 11, 5, 19, 15, 109, 197, 475, 1811, 105, 2857, 9243, 26723}},
    {2376, 15, 4555, {1, 3, 7, 11, 25, 43, 75, 69, 15, 573, 1749, 2595, 2971, 11635, 1081}},
    {2377, 15, 4560, {1, 3, 7, 7, 11, 39, 63, 23, 487, 41, 203, 2325, 2805, 8481, 23247}},
    {2378, 15, 4569, {1, 1, 5, 13, 19, 33, 11, 191, 279, 155, 559, 335, 6031, 10235, 19165}},
    {2379, 15, 4576, {1, 1, 7, 13, 3, 61, 53, 163, 15, 105, 195, 293, 575, 11179, 7247}},
    {2380, 15, 4582, {1, 1, 1, 3, 25, 57, 15, 91, 245, 23, 1469, 3169, 3683, 4239, 28389}},
    {2381, 15, 4586, {1, 1, 3, 3, 23, 61, 45, 203, 171, 993, 409, 653, 4141, 193, 30909}},
    {2382, 15, 4609, {1, 1, 3, 13, 5, 51, 99, 233, 435, 655, 1971, 159, 3941, 15665, 18685}},
    {2383, 15, 4610, {1, 1, 3, 1, 1, 21, 95, 173, 119, 303, 1875, 1941, 7979, 6597, 2661}},
    {2384, 15, 4612, {1, 1, 5, 15, 3, 31, 49, 49, 57, 845, 721, 2037, 6137, 14463, 1081}},
    {2385, 15, 4649, {1, 3, 7, 1, 17, 13, 63, 205, 61, 609, 451, 1319, 1131, 12413, 20267}},
    {2386, 15, 4652, {1, 3, 5, 1, 19, 3, 113, 87, 479, 647, 1775, 2199, 2053, 6503, 15347}},
    {2387, 15, 4672, {1, 1, 5, 15, 3, 23, 115, 35, 205, 435, 109, 3807, 2231, 8899, 30131}},
    {2388, 15, 4677, {1, 1, 1, 5, 3, 37, 13, 83, 193, 385, 787, 3825, 179, 7049, 27619}},
    {2389, 15, 4684, {1, 3, 7, 1, 29, 55, 13, 191, 447, 393, 1029, 3475, 7459, 4591, 20763}},
    {2390, 15, 4690, {1, 1, 3, 5, 27, 47, 1, 151, 111, 543, 503, 3215, 6703, 15, 10511}},
    {2391, 15, 4695, {1, 3, 7, 5, 7, 5, 99, 235, 251, 715, 1285, 427, 5101, 113, 18083}},
    {2392, 15, 4696, {1, 1, 5, 11, 5, 57, 13, 25, 377, 881, 365, 3915, 527, 6999, 17737}},
    {2393, 15, 4702, {1, 1, 3, 7, 31, 1, 125, 55, 219, 801, 1031, 2993, 5245, 2647, 3863}},
    {2394, 15, 4705, {1, 1, 1, 3, 9, 45, 77, 201, 189, 227, 1743, 3241, 6349, 16265, 20763}},
    {2395, 15, 4717, {1, 1, 5, 1, 7, 7, 17, 207, 255, 919, 1513, 2159, 6751, 4757, 32075}},
    {2396, 15, 4726, {1, 3, 7, 3, 19, 33, 59, 131, 429, 719, 109, 4031, 1511, 3365, 28871}},
    {2397, 15, 4736, {1, 3, 1, 11, 19, 43, 53, 225, 219, 177, 2039, 1617, 4713, 4165, 24107}},
    {2398, 15, 4753, {1, 3, 7, 3, 13, 37, 83, 129, 489, 847, 833, 1145, 3511, 4847, 30335}},
    {2399, 15, 4754, {1, 3, 3, 1, 11, 51, 89, 73, 471, 431, 1099, 2455, 1313, 3749, 17483}},
    {2400, 15, 4756, {1, 1, 1, 11, 9, 9, 117, 197, 297, 893, 1659, 1691, 4111, 7707, 14983}},
    {2401, 15, 4775, {1, 1, 3, 3, 31, 19, 95, 79, 61, 795, 263, 3611, 1467, 6053, 30359}},
    {2402, 15, 4801, {1, 1, 1, 15, 15, 3, 37, 51, 261, 931, 305, 2667, 6657, 10233, 27079}},
    {2403, 15, 4819, {1, 1, 5, 3, 19, 19, 67, 55, 421, 445, 393, 3995, 2443, 3219, 15803}},
    {2404, 15, 4828, {1, 3, 1, 3, 27, 45, 93, 109, 25, 31, 971, 3309, 3605, 1071, 21733}},
    {2405, 15, 4838, {1, 1, 3, 1, 13, 47, 23, 59, 11, 837, 547, 453, 239, 1399, 19293}},
    {2406, 15, 4852, {1, 3, 3, 15, 19, 19, 105, 99, 169, 619, 531, 2875, 4611, 4813, 3649}},
    {2407, 15, 4856, {1, 1, 5, 1, 5, 35, 31, 55, 407, 543, 525, 5, 747, 2609, 32107}},
    {2408, 15, 4873, {1, 3, 3, 9, 11, 61, 49, 151, 15, 625, 905, 2931, 5565, 16335, 27339}},
    {2409, 15, 4887, {1, 1, 7, 9, 9, 43, 111, 69, 213, 17, 1189, 2881, 5035, 15665, 4223}},
    {2410, 15, 4891, {1, 1, 7, 5, 29, 43, 57, 239, 149, 93, 1143, 2069, 843, 4203, 5909}},
    {2411, 15, 4904, {1, 3, 1, 1, 19, 23, 55, 193, 405, 651, 1289, 139, 7109, 8397, 11187}},
    {2412, 15, 4912, {1, 1, 3, 5, 17, 13, 77, 53, 365, 819, 605, 1903, 4393, 16273, 23233}},
    {2413, 15, 4921, {1, 3, 5, 11, 23, 25, 37, 175, 29, 355, 747, 2765, 6529, 3287, 32157}},
    {2414, 15, 4936, {1, 3, 5, 13, 11, 13, 119, 25, 191, 665, 457, 3247, 7873, 6853, 31785}},
    {2415, 15, 4941, {1, 3, 3, 11, 5, 7, 5, 187, 173, 189, 2023, 3171, 5241, 8535, 24049}},
    {2416, 15, 4942, {1, 1, 7, 11, 27, 3, 33, 113, 51, 249, 599, 1541, 6763, 591, 3189}},
    {2417, 15, 4963, {1, 1, 3, 11, 3, 39, 61, 115, 191, 337, 1013, 1237, 7511, 12011, 29899}},
    {2418, 15, 4984, {1, 1, 7, 13, 7, 17, 107, 183, 447, 659, 119, 2559, 7267, 855, 9935}},
    {2419, 15, 4990, {1, 1, 3, 15, 25, 33, 109, 11, 119, 109, 1307, 1959, 297, 5767, 23767}},
    {2420, 15, 5005, {1, 3, 7, 9, 13, 21, 19, 55, 83, 861, 115, 3443, 5507, 5277, 18891}},
    {2421, 15, 5013, {1, 1, 5, 11, 27, 33, 69, 231, 5, 999, 607, 507, 513, 2295, 23985}},
    {2422, 15, 5020, {1, 1, 5, 11, 25, 31, 91, 49, 239, 913, 757, 309, 1459, 15481, 22423}},
    {2423, 15, 5039, {1, 3, 7, 1, 15, 39, 21, 59, 207, 665, 1417, 1323, 3671, 5481, 29159}},
    {2424, 15, 5048, {1, 1, 1, 15, 21, 23, 25, 151, 181, 99, 1601, 213, 3145, 221, 29417}},
    {2425, 15, 5062, {1, 3, 7, 3, 13, 5, 39, 39, 341, 819, 301, 2507, 2737, 4079, 20259}},
    {2426, 15, 5080, {1, 3, 1, 3, 29, 17, 65, 111, 483, 341, 79, 1553, 6295, 15311, 21729}},
    {2427, 15, 5085, {1, 1, 3, 7, 15, 31, 105, 151, 101, 459, 835, 1997, 979, 6607, 26765}},
    {2428, 15, 5086, {1, 3, 5, 1, 19, 13, 123, 241, 303, 779, 1591, 2475, 5301, 3481, 2483}},
    {2429, 15, 5095, {1, 3, 3, 11, 5, 53, 73, 135, 367, 885, 1273, 1287, 461, 10361, 11775}},
    {2430, 15, 5096, {1, 3, 3, 11, 3, 29, 5, 151, 193, 399, 1499, 1515, 215, 1475, 16229}},
    {2431, 15, 5102, {1, 1, 5, 13, 5, 5, 13, 95, 461, 1007, 2033, 467, 105, 6275, 6167}},
    {2432, 15, 5107, {1, 1, 3, 11, 7, 5, 121, 213, 153, 949, 1413, 1329, 1261, 13809, 10987}},
    {2433, 15, 5141, {1, 1, 5, 15, 15, 51, 57, 107, 53, 917, 173, 2817, 5401, 9787, 25451}},
    {2434, 15, 5145, {1, 3, 7, 11, 5, 19, 67, 15, 443, 773, 1257, 977, 821, 14949, 15205}},
    {2435, 15, 5148, {1, 1, 1, 1, 1, 43, 3, 201, 15, 425, 1767, 273, 481, 2583, 25451}},
    {2436, 15, 5157, {1, 1, 3, 7, 1, 33, 103, 197, 307, 833, 1693, 1863, 2489, 11273, 18617}},
    {2437, 15, 5158, {1, 3, 7, 11, 9, 59, 67, 175, 195, 695, 129, 1279, 329, 877, 23273}},
    {2438, 15, 5162, {1, 1, 5, 1, 23, 41, 69, 113, 511, 283, 381, 3315, 1331, 12645, 18391}},
    {2439, 15, 5172, {1, 1, 5, 3, 11, 57, 43, 5, 221, 455, 603, 1365, 3139, 2221, 24561}},
    {2440, 15, 5182, {1, 1, 1, 3, 1, 55, 61, 229, 69, 909, 1335, 2889, 5923, 7399, 13483}},
    {2441, 15, 5184, {1, 1, 7, 5, 7, 1, 33, 63, 481, 841, 177, 449, 1059, 673, 31165}},
    {2442, 15, 5193, {1, 1, 3, 5, 11, 43, 93, 119, 173, 509, 1163, 2029, 7819, 1925, 8679}},
    {2443, 15, 5199, {1, 3, 5, 15, 17, 7, 23, 241, 147, 377, 1857, 2715, 7575, 187, 27307}},
    {2444, 15, 5201, {1, 3, 5, 7, 25, 53, 93, 175, 129, 463, 1591, 1151, 5863, 7191, 14249}},
    {2445, 15, 5204, {1, 1, 5, 15, 13, 37, 111, 143, 473, 509, 825, 2263, 3875, 3541, 32451}},
    {2446, 15, 5211, {1, 3, 1, 3, 9, 61, 47, 77, 421, 439, 913, 3641, 3239, 3669, 4051}},
    {2447, 15, 5223, {1, 3, 5, 9, 31, 5, 69, 221, 201, 63, 921, 1087, 5431, 8511, 22761}},
    {2448, 15, 5230, {1, 3, 3, 1, 29, 49, 75, 125, 473, 383, 1913, 2277, 8151, 2709, 14969}},
    {2449, 15, 5232, {1, 1, 3, 1, 17, 3, 93, 37, 395, 225, 1593, 1351, 117, 14963, 14193}},
    {2450, 15, 5253, {1, 3, 1, 3, 29, 53, 77, 221, 135, 959, 613, 623, 4113, 3151, 25159}},
    {2451, 15, 5257, {1, 3, 1, 11, 13, 45, 9, 171, 447, 565, 183, 3745, 5193, 5017, 19907}},
    {2452, 15, 5260, {1, 1, 3, 13, 23, 33, 53, 249, 135, 355, 457, 1221, 7703, 11705, 23775}},
    {2453, 15, 5284, {1, 1, 7, 15, 9, 35, 69, 73, 267, 917, 1799, 451, 6375, 9107, 26855}},
    {2454, 15, 5306, {1, 3, 1, 13, 31, 55, 19, 229, 29, 495, 291, 143, 1775, 1803, 12349}},
    {2455, 15, 5331, {1, 3, 1, 13, 25, 57, 79, 89, 469, 929, 663, 3529, 5409, 6099, 21355}},
    {2456, 15, 5334, {1, 3, 1, 7, 19, 23, 125, 37, 307, 397, 199, 1175, 2683, 12757, 32463}},
    {2457, 15, 5364, {1, 3, 7, 3, 17, 31, 103, 25, 365, 807, 1129, 3501, 389, 15175, 17861}},
    {2458, 15, 5367, {1, 1, 5, 5, 13, 9, 5, 213, 383, 235, 441, 311, 2161, 11303, 15691}},
    {2459, 15, 5371, {1, 3, 7, 13, 29, 43, 39, 33, 289, 473, 1115, 567, 5655, 10047, 17705}},
    {2460, 15, 5382, {1, 1, 3, 1, 1, 29, 83, 173, 183, 609, 1199, 409, 5277, 12187, 10399}},
    {2461, 15, 5386, {1, 3, 5, 7, 27, 5, 1, 205, 325, 39, 75, 1531, 1281, 12729, 28109}},
    {2462, 15, 5399, {1, 3, 7, 3, 29, 45, 107, 97, 287, 783, 531, 2163, 6367, 2805, 32597}},
    {2463, 15, 5400, {1, 1, 1, 15, 19, 15, 19, 123, 453, 929, 1209, 3089, 3833, 2299, 18427}},
    {2464, 15, 5409, {1, 1, 1, 11, 27, 9, 57, 213, 111, 269, 327, 1281, 2101, 6141, 12805}},
    {2465, 15, 5415, {1, 1, 3, 5, 11, 53, 9, 249, 23, 1007, 2041, 2965, 3943, 1217, 21459}},
    {2466, 15, 5416, {1, 3, 3, 7, 29, 45, 121, 191, 399, 41, 989, 1291, 5103, 5895, 1259}},
    {2467, 15, 5424, {1, 1, 7, 7, 21, 17, 81, 27, 89, 729, 1339, 1865, 3089, 1877, 3905}},
    {2468, 15, 5436, {1, 3, 3, 9, 25, 29, 71, 255, 177, 405, 1221, 3747, 3855, 6153, 31769}},
    {2469, 15, 5454, {1, 3, 1, 7, 13, 31, 69, 95, 479, 547, 1265, 3251, 4029, 5065, 26327}},
    {2470, 15, 5462, {1, 3, 7, 7, 29, 25, 9, 149, 267, 1023, 1153, 1831, 2557, 2479, 12071}},
    {2471, 15, 5468, {1, 1, 1, 15, 25, 7, 71, 121, 389, 89, 1025, 2407, 2891, 10003, 15447}},
    {2472, 15, 5481, {1, 3, 7, 1, 21, 25, 105, 249, 441, 895, 563, 3701, 3551, 7241, 5181}},
    {2473, 15, 5505, {1, 1, 3, 15, 15, 39, 7, 235, 305, 761, 1515, 2057, 813, 14611, 9087}},
    {2474, 15, 5511, {1, 3, 3, 1, 15, 51, 17, 77, 343, 767, 581, 2417, 7239, 4987, 15907}},
    {2475, 15, 5518, {1, 1, 7, 11, 17, 37, 97, 227, 439, 939, 577, 2381, 6385, 4297, 31509}},
    {2476, 15, 5530, {1, 1, 7, 7, 21, 9, 125, 73, 459, 263, 951, 3519, 3671, 7037, 20597}},
    {2477, 15, 5532, {1, 3, 3, 3, 25, 25, 69, 155, 385, 695, 451, 481, 5163, 14467, 25371}},
    {2478, 15, 5539, {1, 1, 3, 5, 23, 55, 105, 179, 429, 347, 1313, 797, 7925, 5267, 19177}},
    {2479, 15, 5553, {1, 3, 5, 5, 9, 13, 27, 223, 109, 889, 145, 3731, 7831, 9305, 26293}},
    {2480, 15, 5573, {1, 3, 5, 13, 21, 23, 37, 35, 417, 445, 257, 4077, 7493, 12661, 11971}},
    {2481, 15, 5580, {1, 1, 1, 11, 15, 63, 101, 217, 255, 231, 1325, 3097, 1115, 10899, 21013}},
    {2482, 15, 5597, {1, 1, 5, 1, 11, 15, 115, 101, 411, 109, 1489, 435, 1537, 10867, 14305}},
    {2483, 15, 5602, {1, 1, 3, 13, 25, 31, 9, 151, 497, 505, 1991, 2495, 3141, 6115, 16713}},
    {2484, 15, 5608, {1, 1, 5, 13, 3, 47, 25, 5, 243, 447, 221, 2741, 5241, 11247, 23703}},
    {2485, 15, 5611, {1, 1, 3, 11, 3, 51, 111, 185, 71, 685, 901, 4071, 5775, 5161, 14373}},
    {2486, 15, 5613, {1, 3, 7, 3, 13, 35, 65, 253, 29, 969, 349, 2531, 419, 15073, 16513}},
    {2487, 15, 5625, {1, 1, 7, 5, 9, 1, 21, 143, 97, 485, 69, 3475, 3607, 1047, 4391}},
    {2488, 15, 5632, {1, 3, 3, 13, 3, 37, 9, 41, 473, 479, 1553, 1019, 4183, 13657, 2279}},
    {2489, 15, 5635, {1, 3, 5, 7, 13, 17, 61, 25, 53, 191, 625, 217, 2269, 5441, 30643}},
    {2490, 15, 5638, {1, 1, 5, 13, 21, 25, 41, 207, 95, 425, 1693, 305, 8103, 6599, 30325}},
    {2491, 15, 5652, {1, 1, 1, 11, 7, 37, 119, 89, 313, 379, 1209, 29, 2889, 7145, 23843}},
    {2492, 15, 5659, {1, 3, 3, 15, 13, 39, 95, 177, 387, 345, 1281, 2429, 5477, 10421, 23271}},
    {2493, 15, 5677, {1, 3, 3, 15, 1, 5, 39, 121, 429, 741, 1289, 3647, 2305, 14307, 8571}},
    {2494, 15, 5686, {1, 3, 1, 11, 11, 43, 5, 211, 159, 109, 307, 4095, 3431, 7663, 3703}},
    {2495, 15, 5689, {1, 3, 5, 3, 23, 47, 53, 167, 191, 847, 333, 2883, 3603, 3355, 30727}},
    {2496, 15, 5698, {1, 3, 5, 9, 31, 59, 49, 235, 291, 313, 1515, 549, 2623, 1355, 1671}},
    {2497, 15, 5703, {1, 1, 1, 5, 27, 9, 103, 155, 405, 619, 1619, 4065, 5343, 7709, 22805}},
    {2498, 15, 5707, {1, 3, 7, 9, 31, 13, 47, 139, 311, 85, 181, 2189, 7167, 3851, 9221}},
    {2499, 15, 5731, {1, 3, 5, 1, 27, 9, 49, 57, 3, 369, 139, 3323, 2157, 3691, 15933}},
    {2500, 15, 5738, {1, 1, 1, 1, 23, 9, 65, 247, 257, 37, 1041, 2557, 5441, 2177, 29441}},
    {2501, 15, 5743, {1, 1, 1, 11, 5, 39, 23, 83, 417, 801, 1451, 3101, 6529, 2907, 7871}},
    {2502, 15, 5748, {1, 1, 5, 9, 25, 31, 39, 29, 209, 511, 1423, 1021, 499, 10743, 14913}},
    {2503, 15, 5758, {1, 3, 3, 11, 23, 43, 119, 117, 139, 701, 1527, 3277, 55, 133, 7453}},
    {2504, 15, 5762, {1, 3, 3, 5, 19, 21, 65, 145, 217, 421, 65, 1697, 4929, 14697, 1271}},
    {2505, 15, 5768, {1, 1, 7, 3, 1, 9, 21, 27, 469, 135, 1775, 3343, 3627, 2899, 4801}},
    {2506, 15, 5773, {1, 3, 3, 9, 11, 1, 123, 7, 249, 819, 83, 3841, 2311, 109, 25997}},
    {2507, 15, 5776, {1, 3, 3, 5, 21, 7, 35, 235, 387, 659, 609, 2789, 437, 8561, 24251}},
    {2508, 15, 5815, {1, 1, 7, 1, 25, 13, 69, 147, 147, 413, 1065, 1711, 2329, 13375, 11487}},
    {2509, 15, 5841, {1, 3, 3, 11, 29, 57, 37, 139, 437, 239, 639, 575, 3157, 13491, 8687}},
    {2510, 15, 5847, {1, 3, 5, 11, 7, 31, 63, 249, 153, 535, 965, 1359, 4987, 149, 10437}},
    {2511, 15, 5860, {1, 1, 7, 15, 27, 39, 89, 97, 407, 619, 223, 771, 6851, 8831, 8751}},
    {2512, 15, 5870, {1, 3, 3, 9, 25, 49, 119, 211, 365, 883, 709, 3921, 4577, 1917, 11375}},
    {2513, 15, 5875, {1, 1, 1, 9, 23, 51, 117, 225, 129, 891, 725, 1495, 2105, 13979, 8053}},
    {2514, 15, 5877, {1, 1, 1, 7, 5, 21, 65, 149, 231, 501, 253, 15, 1933, 6125, 29985}},
    {2515, 15, 5884, {1, 3, 3, 9, 5, 57, 13, 59, 45, 473, 803, 2797, 6307, 1475, 11213}},
    {2516, 15, 5892, {1, 1, 7, 15, 23, 3, 17, 147, 19, 469, 1383, 485, 1479, 13455, 4833}},
    {2517, 15, 5902, {1, 1, 5, 13, 1, 49, 81, 205, 257, 569, 1921, 2839, 2127, 14997, 30573}},
    {2518, 15, 5910, {1, 3, 7, 15, 31, 55, 41, 241, 185, 509, 1945, 1071, 5651, 10287, 16651}},
    {2519, 15, 5916, {1, 3, 1, 9, 29, 35, 21, 75, 355, 1013, 739, 4079, 4343, 5287, 27125}},
    {2520, 15, 5919, {1, 1, 5, 15, 1, 5, 49, 181, 171, 65, 1805, 2759, 3253, 10683, 21393}},
    {2521, 15, 5935, {1, 1, 7, 9, 11, 55, 59, 99, 205, 753, 1357, 293, 1437, 2841, 6009}},
    {2522, 15, 5937, {1, 3, 5, 11, 13, 9, 115, 63, 371, 89, 555, 2799, 579, 2111, 11017}},
    {2523, 15, 5944, {1, 3, 1, 11, 15, 61, 19, 5, 437, 389, 205, 21, 5879, 11201, 12993}},
    {2524, 15, 5947, {1, 1, 3, 5, 1, 41, 119, 21, 289, 75, 141, 2959, 7513, 7743, 9901}},
    {2525, 15, 5958, {1, 1, 3, 15, 1, 51, 1, 61, 459, 847, 97, 567, 3093, 5463, 965}},
    {2526, 15, 5962, {1, 3, 7, 5, 31, 19, 67, 37, 75, 931, 1371, 2573, 7419, 6397, 1129}},
    {2527, 15, 5969, {1, 1, 3, 1, 1, 31, 27, 67, 23, 89, 1449, 2249, 3277, 12757, 16877}},
    {2528, 15, 5981, {1, 1, 5, 11, 3, 51, 71, 183, 3, 629, 925, 1281, 1787, 11665, 31633}},
    {2529, 15, 5995, {1, 3, 3, 7, 5, 25, 49, 47, 485, 159, 749, 3547, 3123, 10617, 19767}},
    {2530, 15, 5998, {1, 1, 5, 7, 25, 17, 69, 221, 51, 775, 1103, 3543, 5155, 979, 23967}},
    {2531, 15, 6003, {1, 1, 3, 13, 25, 19, 7, 213, 67, 381, 611, 781, 2289, 619, 4591}},
    {2532, 15, 6010, {1, 1, 7, 1, 31, 43, 5, 93, 51, 773, 329, 3767, 1389, 223, 1075}},
    {2533, 15, 6016, {1, 3, 1, 1, 7, 27, 89, 95, 293, 953, 841, 43, 7823, 16059, 5921}},
    {2534, 15, 6025, {1, 3, 7, 9, 13, 5, 111, 217, 73, 387, 969, 1143, 1863, 14937, 2633}},
    {2535, 15, 6031, {1, 3, 1, 13, 25, 37, 125, 187, 295, 395, 93, 2939, 4189, 5049, 29841}},
    {2536, 15, 6036, {1, 1, 3, 5, 21, 27, 65, 9, 437, 431, 1843, 877, 1053, 4117, 23131}},
    {2537, 15, 6039, {1, 3, 5, 11, 3, 43, 61, 25, 257, 113, 1217, 3125, 4067, 4775, 2359}},
    {2538, 15, 6045, {1, 3, 7, 9, 19, 1, 21, 141, 121, 371, 31, 2449, 3877, 11541, 21871}},
    {2539, 15, 6049, {1, 1, 1, 13, 15, 45, 85, 179, 45, 467, 945, 1963, 1785, 12387, 8063}},
    {2540, 15, 6052, {1, 3, 3, 3, 3, 43, 89, 165, 271, 35, 1353, 3081, 207, 6021, 11913}},
    {2541, 15, 6067, {1, 3, 3, 15, 7, 21, 115, 17, 173, 19, 1527, 1883, 1887, 4999, 10299}},
    {2542, 15, 6074, {1, 1, 7, 13, 15, 51, 61, 153, 361, 839, 1513, 293, 7307, 14477, 12499}},
    {2543, 15, 6087, {1, 1, 1, 11, 19, 25, 103, 159, 379, 799, 2007, 2499, 4595, 12471, 17771}},
    {2544, 15, 6101, {1, 3, 7, 11, 29, 19, 13, 93, 253, 739, 1373, 1527, 7571, 6991, 12555}},
    {2545, 15, 6121, {1, 3, 5, 1, 9, 61, 127, 183, 219, 231, 1605, 2731, 3305, 9073, 27243}},
    {2546, 15, 6129, {1, 1, 3, 15, 7, 47, 5, 169, 99, 1011, 1413, 377, 5015, 15655, 32119}},
    {2547, 15, 6142, {1, 1, 7, 5, 31, 59, 39, 145, 235, 453, 1417, 4011, 3509, 3235, 24463}},
    {2548, 15, 6151, {1, 3, 5, 9, 31, 45, 105, 81, 45, 809, 1415, 3593, 1251, 8665, 3971}},
    {2549, 15, 6157, {1, 1, 7, 7, 29, 25, 111, 65, 403, 543, 15, 659, 1357, 4299, 27179}},
    {2550, 15, 6166, {1, 1, 1, 11, 13, 55, 125, 225, 309, 605, 891, 3599, 2229, 275, 6629}},
    {2551, 15, 6170, {1, 1, 3, 7, 1, 45, 85, 131, 453, 1005, 1169, 849, 11, 3675, 13023}},
    {2552, 15, 6175, {1, 3, 1, 5, 13, 45, 103, 205, 243, 839, 1927, 1317, 3151, 14227, 29131}},
    {2553, 15, 6186, {1, 1, 7, 3, 25, 25, 15, 13, 241, 103, 1271, 1649, 3879, 9623, 18053}},
    {2554, 15, 6203, {1, 1, 7, 1, 27, 43, 123, 111, 219, 899, 525, 3705, 5507, 15143, 9883}},
    {2555, 15, 6217, {1, 1, 5, 13, 13, 21, 107, 121, 45, 15, 1383, 3669, 1093, 3619, 14029}},
    {2556, 15, 6231, {1, 1, 3, 13, 21, 5, 19, 81, 261, 1011, 1459, 3737, 3633, 10027, 17689}},
    {2557, 15, 6241, {1, 3, 3, 5, 25, 41, 55, 91, 231, 645, 2001, 1593, 7335, 9587, 367}},
    {2558, 15, 6242, {1, 3, 5, 15, 25, 57, 71, 247, 139, 177, 1437, 3155, 5243, 8333, 31095}},
    {2559, 15, 6248, {1, 1, 3, 15, 25, 7, 39, 13, 141, 241, 1301, 2853, 4295, 13221, 22321}},
    {2560, 15, 6256, {1, 1, 7, 5, 23, 9, 109, 133, 273, 565, 649, 2609, 6287, 1279, 29791}},
    {2561, 15, 6265, {1, 3, 7, 9, 29, 57, 125, 157, 331, 939, 791, 3177, 431, 8831, 32627}},
    {2562, 15, 6275, {1, 1, 1, 15, 1, 39, 7, 145, 31, 355, 1775, 723, 6203, 6169, 11029}},
    {2563, 15, 6277, {1, 3, 7, 13, 27, 61, 115, 157, 253, 447, 455, 75, 3873, 16119, 17783}},
    {2564, 15, 6302, {1, 3, 5, 1, 23, 63, 121, 69, 381, 661, 1771, 2511, 2977, 10119, 4293}},
    {2565, 15, 6315, {1, 1, 1, 3, 1, 39, 65, 197, 275, 695, 1589, 551, 2849, 5885, 16919}},
    {2566, 15, 6318, {1, 1, 3, 5, 11, 1, 73, 13, 287, 73, 1183, 497, 8181, 8109, 17339}},
    {2567, 15, 6330, {1, 3, 7, 3, 27, 29, 91, 73, 219, 75, 1671, 1599, 7627, 4781, 5395}},
    {2568, 15, 6343, {1, 3, 3, 5, 21, 41, 69, 243, 473, 649, 343, 2639, 8185, 14791, 4047}},
    {2569, 15, 6347, {1, 1, 5, 3, 19, 47, 27, 217, 225, 477, 413, 617, 6249, 7189, 14659}},
    {2570, 15, 6350, {1, 1, 5, 5, 25, 39, 105, 229, 445, 33, 505, 1039, 2329, 8835, 30281}},
    {2571, 15, 6352, {1, 3, 3, 5, 29, 51, 97, 161, 425, 823, 819, 3233, 5823, 8931, 31459}},
    {2572, 15, 6371, {1, 3, 1, 13, 19, 1, 61, 191, 293, 177, 793, 3505, 7695, 9595, 31377}},
    {2573, 15, 6383, {1, 1, 7, 11, 19, 21, 21, 233, 401, 27, 1207, 2239, 3363, 1089, 26521}},
    {2574, 15, 6386, {1, 3, 1, 11, 29, 31, 69, 73, 211, 823, 409, 3433, 2299, 3249, 28335}},
    {2575, 15, 6405, {1, 1, 3, 1, 11, 17, 15, 229, 203, 113, 1077, 2411, 379, 11423, 16605}},
    {2576, 15, 6409, {1, 1, 5, 5, 13, 53, 9, 107, 399, 161, 657, 1575, 1649, 233, 13443}},
    {2577, 15, 6410, {1, 3, 1, 1, 17, 11, 91, 11, 11, 941, 525, 913, 6221, 10285, 14253}},
    {2578, 15, 6433, {1, 1, 1, 13, 11, 25, 7, 225, 323, 443, 1449, 1867, 1175, 15611, 30721}},
    {2579, 15, 6436, {1, 1, 5, 3, 15, 7, 117, 105, 385, 129, 621, 3219, 7713, 14773, 21715}},
    {2580, 15, 6439, {1, 1, 5, 5, 29, 1, 107, 71, 349, 129, 339, 1905, 1951, 2933, 22541}},
    {2581, 15, 6463, {1, 3, 3, 9, 13, 5, 15, 3, 433, 455, 1481, 2449, 6813, 867, 4923}},
    {2582, 15, 6468, {1, 3, 3, 5, 7, 3, 7, 191, 465, 969, 45, 3395, 3967, 3823, 23097}},
    {2583, 15, 6477, {1, 3, 3, 11, 21, 29, 127, 187, 125, 439, 427, 2461, 6713, 7503, 16693}},
    {2584, 15, 6496, {1, 3, 7, 3, 25, 45, 119, 223, 181, 377, 1941, 663, 5549, 2331, 21879}},
    {2585, 15, 6511, {1, 3, 3, 13, 5, 17, 91, 97, 199, 505, 943, 2881, 625, 645, 14153}},
    {2586, 15, 6516, {1, 1, 1, 1, 15, 23, 39, 105, 79, 109, 1781, 2185, 6917, 10343, 5553}},
    {2587, 15, 6519, {1, 1, 5, 3, 23, 49, 91, 213, 89, 489, 31, 1647, 39, 16379, 12511}},
    {2588, 15, 6523, {1, 1, 1, 7, 1, 27, 61, 167, 445, 755, 681, 3159, 6669, 13629, 2289}},
    {2589, 15, 6530, {1, 3, 1, 11, 25, 51, 121, 123, 291, 123, 2043, 2655, 3313, 8559, 8103}},
    {2590, 15, 6539, {1, 1, 7, 7, 21, 51, 45, 89, 125, 155, 277, 2489, 3601, 15637, 23239}},
    {2591, 15, 6547, {1, 3, 7, 5, 7, 45, 49, 31, 509, 965, 465, 1695, 7471, 3749, 1055}},
    {2592, 15, 6589, {1, 1, 1, 7, 29, 29, 7, 111, 101, 255, 439, 1321, 1651, 5207, 6907}},
    {2593, 15, 6592, {1, 1, 1, 5, 15, 37, 29, 249, 201, 379, 375, 2591, 6061, 14439, 1443}},
    {2594, 15, 6601, {1, 1, 5, 9, 9, 47, 103, 81, 429, 785, 295, 97, 1787, 10903, 16361}},
    {2595, 15, 6610, {1, 1, 5, 1, 31, 13, 31, 219, 193, 621, 1031, 1, 1729, 10229, 18707}},
    {2596, 15, 6616, {1, 3, 1, 9, 27, 1, 73, 145, 13, 415, 1991, 2335, 2501, 11411, 31623}},
    {2597, 15, 6619, {1, 1, 7, 9, 21, 33, 23, 31, 81, 699, 1733, 621, 271, 11707, 15729}},
    {2598, 15, 6626, {1, 1, 7, 11, 1, 39, 127, 191, 443, 855, 201, 3819, 6169, 10507, 957}},
    {2599, 15, 6635, {1, 3, 5, 1, 29, 39, 71, 201, 51, 645, 1139, 2801, 5319, 8657, 6219}},
    {2600, 15, 6637, {1, 1, 5, 11, 29, 33, 81, 175, 35, 445, 769, 993, 4647, 5253, 31043}},
    {2601, 15, 6638, {1, 3, 1, 11, 23, 45, 123, 55, 77, 403, 1551, 3109, 355, 5331, 2949}},
    {2602, 15, 6652, {1, 1, 7, 13, 23, 19, 95, 125, 291, 563, 29, 1053, 6709, 15689, 14249}},
    {2603, 15, 6656, {1, 3, 1, 11, 27, 7, 63, 57, 429, 707, 411, 1515, 3777, 15509, 4935}},
    {2604, 15, 6662, {1, 1, 5, 7, 23, 51, 35, 203, 165, 753, 1813, 553, 5569, 12319, 20667}},
    {2605, 15, 6689, {1, 1, 1, 9, 13, 19, 45, 211, 23, 1011, 1435, 1379, 2585, 8609, 11397}},
    {2606, 15, 6699, {1, 1, 1, 7, 9, 33, 101, 239, 179, 451, 357, 685, 7935, 6433, 14433}},
    {2607, 15, 6710, {1, 1, 3, 9, 31, 21, 57, 203, 469, 79, 707, 3137, 1731, 1553, 21561}},
    {2608, 15, 6714, {1, 3, 5, 1, 15, 7, 103, 133, 477, 923, 1299, 3127, 1687, 2689, 29155}},
    {2609, 15, 6719, {1, 1, 3, 11, 7, 23, 21, 53, 417, 581, 1955, 747, 3039, 6305, 5821}},
    {2610, 15, 6739, {1, 1, 3, 5, 7, 23, 35, 163, 177, 87, 615, 3505, 2029, 4553, 9055}},
    {2611, 15, 6751, {1, 1, 1, 5, 25, 43, 75, 235, 189, 135, 137, 3803, 835, 3467, 16135}},
    {2612, 15, 6775, {1, 1, 5, 3, 21, 51, 119, 159, 461, 331, 5, 3077, 7603, 3425, 23741}},
    {2613, 15, 6779, {1, 1, 7, 5, 17, 21, 91, 1, 287, 443, 1213, 1491, 1113, 10077, 20563}},
    {2614, 15, 6788, {1, 3, 3, 9, 19, 51, 103, 27, 273, 723, 919, 2769, 6137, 13253, 16543}},
    {2615, 15, 6798, {1, 3, 7, 3, 9, 25, 97, 87, 305, 67, 471, 453, 883, 11505, 6017}},
    {2616, 15, 6815, {1, 1, 7, 1, 7, 19, 11, 109, 171, 483, 145, 151, 6853, 3717, 4285}},
    {2617, 15, 6819, {1, 1, 7, 11, 31, 45, 43, 207, 59, 249, 1343, 59, 7009, 5669, 19961}},
    {2618, 15, 6825, {1, 3, 5, 13, 13, 35, 13, 219, 161, 555, 445, 1471, 3307, 7127, 29509}},
    {2619, 15, 6826, {1, 3, 1, 3, 9, 61, 75, 65, 385, 357, 1771, 3539, 729, 4425, 9871}},
    {2620, 15, 6836, {1, 1, 1, 13, 7, 9, 71, 127, 35, 219, 1643, 695, 3477, 12969, 26933}},
    {2621, 15, 6843, {1, 1, 1, 11, 19, 57, 13, 31, 483, 973, 1155, 3085, 5311, 11989, 21711}},
    {2622, 15, 6845, {1, 3, 1, 13, 3, 27, 27, 115, 443, 609, 1633, 157, 4245, 1253, 12337}},
    {2623, 15, 6858, {1, 1, 1, 11, 5, 39, 117, 33, 225, 847, 793, 483, 7733, 15557, 31539}},
    {2624, 15, 6868, {1, 3, 1, 9, 5, 43, 101, 149, 491, 525, 2015, 1863, 4725, 16297, 3481}},
    {2625, 15, 6877, {1, 3, 3, 5, 5, 43, 97, 149, 457, 461, 1855, 599, 241, 11119, 18427}},
    {2626, 15, 6881, {1, 1, 3, 15, 15, 41, 123, 203, 185, 503, 589, 1875, 2603, 3901, 2371}},
    {2627, 15, 6891, {1, 1, 3, 15, 13, 25, 17, 173, 439, 195, 1843, 947, 3489, 6595, 28849}},
    {2628, 15, 6896, {1, 1, 5, 1, 1, 17, 73, 231, 183, 889, 1459, 1411, 3989, 8137, 19805}},
    {2629, 15, 6899, {1, 1, 5, 15, 17, 63, 97, 55, 253, 511, 91, 3365, 4727, 15429, 6157}},
    {2630, 15, 6901, {1, 3, 3, 5, 19, 49, 89, 147, 245, 305, 431, 2389, 4069, 9461, 17889}},
    {2631, 15, 6908, {1, 1, 1, 5, 25, 61, 123, 41, 471, 619, 615, 2185, 3501, 1931, 26307}},
    {2632, 15, 6914, {1, 1, 3, 5, 7, 7, 55, 139, 505, 187, 1061, 1925, 7813, 11685, 10485}},
    {2633, 15, 6916, {1, 3, 1, 5, 11, 5, 103, 97, 311, 347, 1663, 599, 3903, 10133, 31213}},
    {2634, 15, 6923, {1, 1, 7, 11, 13, 57, 43, 51, 195, 765, 1799, 453, 729, 6121, 3925}},
    {2635, 15, 6925, {1, 1, 5, 1, 31, 27, 45, 119, 31, 137, 1085, 653, 3267, 8755, 13295}},
    {2636, 15, 6928, {1, 3, 1, 3, 7, 61, 95, 51, 429, 315, 155, 2207, 5141, 15887, 9681}},
    {2637, 15, 6931, {1, 3, 3, 13, 9, 47, 37, 147, 179, 117, 545, 2441, 117, 5541, 11409}},
    {2638, 15, 6934, {1, 3, 3, 15, 31, 51, 55, 59, 219, 97, 1123, 987, 4807, 2871, 1843}},
    {2639, 15, 6937, {1, 3, 3, 9, 5, 33, 29, 89, 223, 133, 1403, 3131, 173, 11157, 25617}},
    {2640, 15, 6938, {1, 3, 3, 13, 5, 19, 125, 197, 337, 301, 1105, 3771, 1027, 12029, 10855}},
    {2641, 15, 6949, {1, 3, 5, 3, 15, 31, 101, 61, 189, 237, 1257, 3707, 7335, 1131, 27425}},
    {2642, 15, 6956, {1, 1, 3, 7, 3, 63, 75, 173, 73, 109, 599, 881, 3877, 2807, 15803}},
    {2643, 15, 6973, {1, 1, 1, 11, 21, 39, 63, 147, 435, 293, 987, 2031, 3443, 6887, 8629}},
    {2644, 15, 6976, {1, 3, 1, 5, 1, 19, 3, 67, 503, 201, 937, 2357, 5639, 10277, 2057}},
    {2645, 15, 6981, {1, 3, 3, 9, 21, 7, 113, 147, 509, 327, 1947, 2797, 3617, 9649, 8519}},
    {2646, 15, 6988, {1, 3, 3, 9, 27, 45, 47, 13, 61, 701, 1927, 2071, 6589, 1147, 18599}},
    {2647, 15, 6999, {1, 1, 3, 5, 3, 17, 39, 21, 447, 267, 1003, 2599, 1753, 10823, 1371}},
    {2648, 15, 7016, {1, 3, 5, 1, 19, 57, 55, 213, 15, 597, 1953, 2781, 6205, 1829, 21921}},
    {2649, 15, 7027, {1, 3, 5, 1, 7, 57, 55, 137, 73, 93, 409, 4053, 1251, 3435, 16485}},
    {2650, 15, 7029, {1, 3, 3, 1, 9, 35, 43, 9, 269, 161, 1193, 3407, 981, 7989, 13799}},
    {2651, 15, 7055, {1, 3, 3, 9, 21, 21, 39, 111, 239, 427, 475, 631, 7365, 14781, 32627}},
    {2652, 15, 7058, {1, 1, 3, 13, 29, 25, 99, 105, 235, 345, 955, 3057, 4459, 8165, 26115}},
    {2653, 15, 7074, {1, 1, 1, 15, 5, 63, 47, 31, 233, 237, 1337, 3857, 7857, 3201, 26285}},
    {2654, 15, 7083, {1, 1, 1, 3, 11, 3, 17, 91, 33, 617, 1773, 3601, 1413, 7399, 25349}},
    {2655, 15, 7093, {1, 1, 1, 15, 23, 51, 59, 119, 53, 131, 1301, 719, 311, 12199, 30551}},
    {2656, 15, 7100, {1, 1, 7, 9, 11, 21, 65, 115, 323, 785, 543, 2943, 2805, 5489, 16197}},
    {2657, 15, 7105, {1, 1, 5, 9, 29, 7, 121, 23, 281, 347, 1707, 3355, 3955, 7863, 17861}},
    {2658, 15, 7112, {1, 1, 1, 7, 15, 29, 23, 219, 355, 983, 407, 473, 5353, 10915, 12807}},
    {2659, 15, 7118, {1, 3, 5, 11, 13, 55, 47, 5, 115, 583, 1533, 487, 6163, 9005, 29917}},
    {2660, 15, 7120, {1, 3, 3, 15, 29, 21, 61, 247, 83, 809, 143, 2487, 291, 1005, 30623}},
    {2661, 15, 7129, {1, 1, 1, 13, 7, 21, 121, 199, 9, 527, 451, 121, 1341, 4859, 25785}},
    {2662, 15, 7166, {1, 3, 3, 13, 19, 27, 93, 169, 473, 397, 1995, 2895, 1323, 13581, 5213}},
    {2663, 15, 7207, {1, 3, 3, 5, 19, 51, 81, 7, 455, 797, 591, 3795, 3109, 7883, 18289}},
    {2664, 15, 7216, {1, 3, 3, 7, 11, 61, 41, 65, 185, 239, 877, 2865, 6119, 15939, 4969}},
    {2665, 15, 7226, {1, 3, 1, 13, 9, 25, 121, 117, 405, 227, 31, 2667, 4547, 8791, 16951}},
    {2666, 15, 7234, {1, 1, 3, 11, 27, 21, 127, 17, 269, 581, 1939, 2437, 3641, 3957, 30151}},
    {2667, 15, 7236, {1, 1, 5, 7, 17, 23, 101, 115, 203, 101, 647, 735, 259, 4247, 32163}},
    {2668, 15, 7246, {1, 1, 3, 7, 27, 49, 109, 101, 315, 313, 1955, 607, 4379, 15061, 3021}},
    {2669, 15, 7248, {1, 1, 5, 9, 23, 29, 97, 21, 5, 525, 99, 23, 3315, 11389, 21707}},
    {2670, 15, 7254, {1, 1, 5, 1, 27, 53, 33, 87, 1, 197, 1021, 3175, 7287, 3101, 27129}},
    {2671, 15, 7263, {1, 1, 1, 9, 23, 25, 69, 115, 267, 315, 1553, 183, 6703, 741, 10171}},
    {2672, 15, 7273, {1, 1, 3, 11, 23, 1, 37, 245, 79, 235, 1469, 1653, 6267, 13961, 29587}},
    {2673, 15, 7274, {1, 3, 1, 15, 3, 53, 45, 219, 59, 175, 1709, 709, 7761, 15433, 14229}},
    {2674, 15, 7293, {1, 3, 5, 1, 11, 31, 91, 37, 355, 123, 75, 1951, 2085, 16347, 20899}},
    {2675, 15, 7297, {1, 3, 3, 11, 7, 7, 25, 235, 345, 437, 617, 1273, 3415, 2045, 16567}},
    {2676, 15, 7310, {1, 3, 5, 13, 23, 49, 87, 79, 319, 87, 205, 91, 2227, 13271, 22889}},
    {2677, 15, 7315, {1, 1, 3, 11, 15, 25, 95, 249, 419, 393, 1163, 1483, 6963, 493, 32661}},
    {2678, 15, 7317, {1, 3, 5, 9, 17, 5, 109, 191, 161, 655, 1365, 3965, 3039, 6113, 10093}},
    {2679, 15, 7331, {1, 1, 1, 5, 21, 19, 23, 225, 263, 559, 1331, 2971, 5251, 8333, 31931}},
    {2680, 15, 7338, {1, 1, 3, 7, 1, 7, 9, 63, 437, 1005, 1217, 537, 7495, 6233, 7931}},
    {2681, 15, 7340, {1, 3, 5, 11, 3, 47, 83, 73, 237, 737, 93, 2857, 3861, 10039, 511}},
    {2682, 15, 7346, {1, 1, 1, 1, 5, 33, 117, 75, 161, 805, 681, 817, 4749, 1249, 13955}},
    {2683, 15, 7355, {1, 3, 5, 3, 5, 27, 27, 203, 247, 703, 555, 3425, 6919, 8207, 21785}},
    {2684, 15, 7366, {1, 3, 5, 3, 19, 11, 49, 157, 79, 111, 867, 3971, 797, 7247, 19975}},
    {2685, 15, 7383, {1, 1, 1, 7, 9, 17, 115, 185, 237, 501, 707, 1529, 2363, 5985, 15471}},
    {2686, 15, 7389, {1, 3, 7, 5, 11, 39, 119, 239, 11, 957, 1767, 3419, 2773, 12201, 29771}},
    {2687, 15, 7393, {1, 1, 7, 3, 11, 61, 91, 87, 301, 257, 1657, 1793, 3419, 14107, 4935}},
    {2688, 15, 7396, {1, 1, 3, 1, 5, 23, 119, 29, 337, 989, 559, 2021, 4325, 2075, 19971}},
    {2689, 15, 7400, {1, 1, 7, 7, 17, 19, 25, 193, 401, 351, 1063, 2747, 1809, 8825, 247}},
    {2690, 15, 7414, {1, 3, 3, 1, 17, 49, 105, 137, 65, 881, 289, 513, 5279, 1213, 29891}},
    {2691, 15, 7417, {1, 1, 3, 3, 7, 13, 67, 235, 489, 935, 295, 1737, 7337, 4471, 14717}},
    {2692, 15, 7426, {1, 3, 7, 15, 29, 31, 65, 61, 9, 155, 1041, 767, 4395, 4685, 6685}},
    {2693, 15, 7432, {1, 3, 3, 15, 3, 7, 67, 33, 509, 425, 261, 2757, 4727, 15783, 22019}},
    {2694, 15, 7452, {1, 3, 5, 3, 3, 23, 125, 195, 119, 215, 795, 1961, 7651, 6257, 7809}},
    {2695, 15, 7468, {1, 3, 1, 13, 3, 25, 15, 197, 175, 909, 1089, 2829, 4133, 6571, 6323}},
    {2696, 15, 7488, {1, 3, 7, 1, 21, 7, 97, 123, 367, 47, 1463, 1739, 6379, 7649, 23281}},
    {2697, 15, 7491, {1, 1, 7, 1, 15, 45, 9, 69, 417, 823, 1857, 455, 5207, 7439, 28105}},
    {2698, 15, 7494, {1, 1, 5, 1, 23, 27, 17, 137, 405, 1023, 1671, 2999, 6081, 15153, 28193}},
    {2699, 15, 7497, {1, 1, 7, 13, 27, 57, 21, 133, 329, 263, 159, 1765, 4553, 15077, 12865}},
    {2700, 15, 7515, {1, 1, 7, 11, 21, 39, 113, 101, 19, 589, 1435, 429, 6881, 8667, 4425}},
    {2701, 15, 7531, {1, 1, 3, 1, 21, 51, 17, 101, 107, 683, 129, 893, 4713, 9385, 13829}},
    {2702, 15, 7552, {1, 3, 7, 7, 21, 7, 79, 67, 225, 359, 1847, 1181, 7527, 13141, 23169}},
    {2703, 15, 7562, {1, 1, 5, 11, 25, 3, 103, 7, 311, 313, 1909, 3183, 7663, 439, 29379}},
    {2704, 15, 7564, {1, 1, 7, 15, 17, 35, 67, 253, 191, 15, 469, 1171, 5519, 3359, 9387}},
    {2705, 15, 7569, {1, 3, 5, 7, 25, 5, 59, 221, 385, 483, 491, 3219, 3387, 12793, 8595}},
    {2706, 15, 7582, {1, 3, 1, 3, 11, 9, 61, 3, 265, 915, 7, 2485, 2497, 2107, 31453}},
    {2707, 15, 7585, {1, 3, 3, 5, 19, 41, 11, 3, 399, 555, 1497, 2593, 3771, 5131, 31147}},
    {2708, 15, 7588, {1, 3, 3, 3, 29, 13, 11, 171, 369, 853, 979, 3443, 449, 15709, 18513}},
    {2709, 15, 7592, {1, 3, 3, 5, 5, 3, 41, 183, 233, 525, 1921, 347, 8053, 3207, 8599}},
    {2710, 15, 7597, {1, 3, 5, 15, 11, 51, 43, 67, 103, 435, 1827, 2193, 5195, 14259, 23797}},
    {2711, 15, 7603, {1, 3, 1, 13, 27, 21, 123, 247, 441, 811, 803, 4077, 1465, 15527, 7313}},
    {2712, 15, 7610, {1, 3, 3, 9, 17, 1, 61, 97, 257, 263, 565, 2455, 8171, 4493, 319}},
    {2713, 15, 7624, {1, 1, 1, 11, 23, 41, 21, 247, 389, 245, 1757, 573, 2613, 6961, 5013}},
    {2714, 15, 7642, {1, 3, 7, 3, 11, 61, 121, 57, 65, 1019, 1205, 609, 6825, 3185, 9485}},
    {2715, 15, 7647, {1, 3, 7, 3, 11, 17, 127, 225, 169, 769, 1291, 3609, 2399, 13459, 20851}},
    {2716, 15, 7653, {1, 3, 1, 13, 29, 55, 21, 95, 347, 357, 397, 1617, 7639, 915, 22195}},
    {2717, 15, 7654, {1, 1, 1, 7, 27, 17, 71, 7, 35, 867, 1519, 3503, 1099, 5249, 1419}},
    {2718, 15, 7666, {1, 3, 5, 11, 27, 3, 43, 171, 229, 273, 97, 2599, 2805, 6035, 26747}},
    {2719, 15, 7668, {1, 3, 7, 9, 15, 57, 57, 205, 457, 39, 1125, 433, 3057, 7217, 17085}},
    {2720, 15, 7684, {1, 1, 5, 15, 5, 19, 17, 57, 121, 691, 107, 571, 4129, 15407, 29407}},
    {2721, 15, 7705, {1, 3, 7, 13, 19, 55, 5, 69, 361, 511, 623, 2343, 5335, 7805, 20903}},
    {2722, 15, 7732, {1, 1, 5, 3, 7, 15, 41, 29, 485, 589, 265, 357, 4679, 1825, 19933}},
    {2723, 15, 7741, {1, 3, 3, 13, 13, 29, 109, 127, 185, 129, 1679, 843, 1111, 579, 20605}},
    {2724, 15, 7749, {1, 1, 7, 5, 3, 63, 73, 129, 279, 931, 1025, 679, 3423, 14939, 21227}},
    {2725, 15, 7750, {1, 1, 1, 5, 17, 53, 49, 129, 321, 81, 909, 2805, 5491, 8555, 20433}},
    {2726, 15, 7759, {1, 1, 5, 13, 23, 59, 13, 19, 115, 601, 1269, 2007, 7823, 7681, 26203}},
    {2727, 15, 7764, {1, 3, 7, 3, 9, 1, 63, 37, 327, 605, 413, 1103, 2877, 15805, 8591}},
    {2728, 15, 7777, {1, 3, 1, 7, 31, 21, 75, 13, 1, 867, 543, 1995, 5109, 11169, 24929}},
    {2729, 15, 7790, {1, 1, 3, 13, 11, 21, 29, 85, 473, 7, 773, 3621, 6257, 15303, 2189}},
    {2730, 15, 7817, {1, 3, 3, 13, 5, 19, 17, 31, 371, 727, 1849, 289, 5341, 2191, 8857}},
    {2731, 15, 7826, {1, 1, 1, 1, 23, 51, 13, 39, 433, 999, 1653, 1937, 9, 14711, 26777}},
    {2732, 15, 7831, {1, 1, 3, 13, 31, 1, 123, 235, 395, 719, 1709, 2577, 11, 14799, 25325}},
    {2733, 15, 7859, {1, 1, 7, 1, 13, 3, 111, 27, 387, 321, 1699, 1245, 7707, 13739, 5103}},
    {2734, 15, 7871, {1, 1, 5, 9, 25, 55, 11, 153, 257, 383, 1929, 3587, 5937, 1131, 10965}},
    {2735, 15, 7873, {1, 3, 5, 9, 15, 23, 27, 243, 495, 725, 1315, 2171, 7379, 14211, 10223}},
    {2736, 15, 7876, {1, 1, 7, 7, 13, 57, 3, 49, 319, 449, 1517, 2255, 5839, 4847, 7303}},
    {2737, 15, 7900, {1, 3, 1, 9, 31, 13, 119, 227, 295, 1005, 395, 2743, 8085, 15715, 26915}},
    {2738, 15, 7904, {1, 3, 1, 3, 3, 47, 67, 189, 83, 185, 1511, 3951, 5179, 7289, 7087}},
    {2739, 15, 7913, {1, 3, 3, 13, 1, 63, 105, 235, 125, 809, 625, 1371, 2805, 14979, 6859}},
    {2740, 15, 7916, {1, 3, 5, 3, 29, 3, 81, 117, 457, 491, 153, 2975, 1057, 13665, 24157}},
    {2741, 15, 7922, {1, 3, 5, 3, 29, 9, 111, 239, 267, 401, 117, 2095, 3255, 1991, 2285}},
    {2742, 15, 7946, {1, 1, 3, 13, 23, 61, 117, 67, 495, 687, 1487, 2381, 57, 6639, 19417}},
    {2743, 15, 7953, {1, 1, 5, 13, 9, 27, 47, 77, 11, 1017, 391, 1349, 491, 13729, 25071}},
    {2744, 15, 7956, {1, 3, 1, 3, 1, 17, 17, 31, 331, 437, 71, 2631, 6929, 1501, 28517}},
    {2745, 15, 7963, {1, 3, 5, 9, 27, 51, 25, 137, 35, 653, 371, 3433, 4139, 679, 16905}},
    {2746, 15, 7979, {1, 3, 3, 15, 31, 63, 113, 209, 403, 289, 1573, 2355, 6845, 15063, 15659}},
    {2747, 15, 7981, {1, 1, 7, 7, 25, 19, 77, 135, 369, 757, 939, 2647, 4349, 14371, 17779}},
    {2748, 15, 7984, {1, 1, 3, 15, 13, 37, 69, 79, 429, 149, 1381, 1337, 687, 10415, 30127}},
    {2749, 15, 7989, {1, 1, 1, 1, 1, 49, 5, 119, 95, 17, 991, 2337, 1779, 1899, 13007}},
    {2750, 15, 7999, {1, 1, 5, 9, 9, 1, 15, 249, 483, 159, 1605, 1027, 2641, 9503, 15141}},
    {2751, 15, 8001, {1, 3, 3, 13, 23, 31, 15, 15, 419, 331, 901, 3073, 3965, 705, 1113}},
    {2752, 15, 8021, {1, 1, 1, 3, 29, 43, 89, 189, 469, 695, 1655, 2985, 3009, 10213, 3349}},
    {2753, 15, 8056, {1, 3, 7, 15, 19, 51, 57, 27, 215, 441, 203, 2003, 4131, 12361, 4551}},
    {2754, 15, 8080, {1, 1, 1, 1, 17, 29, 5, 157, 261, 497, 217, 673, 4591, 8837, 29127}},
    {2755, 15, 8083, {1, 3, 5, 1, 23, 11, 87, 73, 13, 93, 655, 3629, 7861, 9267, 11531}},
    {2756, 15, 8089, {1, 1, 7, 1, 11, 53, 29, 117, 331, 715, 1765, 203, 4705, 2359, 25739}},
    {2757, 15, 8090, {1, 1, 7, 9, 9, 63, 87, 235, 73, 651, 1571, 3495, 4449, 14557, 6781}},
    {2758, 15, 8114, {1, 1, 5, 3, 25, 19, 125, 89, 221, 163, 403, 1267, 6589, 15559, 18163}},
    {2759, 15, 8128, {1, 3, 3, 15, 15, 49, 15, 13, 19, 371, 397, 2885, 2499, 4125, 7461}},
    {2760, 15, 8133, {1, 3, 1, 7, 31, 13, 37, 23, 425, 379, 261, 2809, 397, 5793, 24967}},
    {2761, 15, 8145, {1, 1, 5, 3, 29, 23, 51, 29, 237, 871, 1811, 1537, 1625, 7029, 1017}},
    {2762, 15, 8155, {1, 3, 7, 5, 11, 63, 27, 45, 217, 239, 929, 2169, 7589, 14561, 213}},
    {2763, 15, 8161, {1, 3, 1, 9, 9, 51, 93, 121, 137, 727, 1393, 557, 6665, 15477, 11899}},
    {2764, 15, 8182, {1, 3, 1, 1, 5, 11, 81, 115, 339, 245, 191, 1883, 3461, 12585, 19503}},
    {2765, 15, 8186, {1, 1, 5, 7, 11, 29, 95, 237, 447, 695, 297, 2665, 5635, 4495, 885}},
    {2766, 15, 8191, {1, 3, 1, 3, 11, 5, 9, 73, 79, 679, 503, 3751, 5675, 15913, 24037}},
    {2767, 15, 8192, {1, 3, 1, 13, 21, 43, 127, 137, 477, 113, 777, 2371, 3927, 15413, 15879}},
    {2768, 15, 8195, {1, 1, 3, 7, 19, 59, 73, 55, 197, 653, 205, 1595, 1023, 10165, 16363}},
    {2769, 15, 8201, {1, 3, 1, 5, 1, 37, 127, 151, 109, 305, 1263, 2355, 887, 8761, 6803}},
    {2770, 15, 8207, {1, 1, 5, 13, 13, 49, 103, 157, 259, 319, 1081, 1959, 3627, 14687, 32105}},
    {2771, 15, 8210, {1, 3, 5, 7, 19, 25, 81, 41, 289, 553, 1931, 1955, 1201, 9129, 29497}},
    {2772, 15, 8228, {1, 1, 3, 5, 15, 21, 83, 105, 341, 299, 495, 3379, 5299, 3723, 7677}},
    {2773, 15, 8249, {1, 3, 3, 7, 21, 27, 43, 175, 303, 337, 311, 1039, 7683, 15567, 13811}},
    {2774, 15, 8252, {1, 3, 7, 13, 5, 63, 99, 3, 69, 903, 685, 3651, 1739, 13757, 285}},
    {2775, 15, 8258, {1, 1, 7, 5, 17, 5, 63, 13, 75, 653, 1271, 2863, 5315, 6221, 14643}},
    {2776, 15, 8267, {1, 3, 7, 7, 25, 43, 101, 73, 489, 499, 1741, 3851, 2655, 10053, 11605}},
    {2777, 15, 8270, {1, 1, 7, 11, 31, 17, 103, 159, 115, 471, 1041, 2727, 4609, 5595, 16971}},
    {2778, 15, 8275, {1, 3, 5, 13, 23, 23, 109, 173, 347, 947, 1469, 1137, 4609, 8017, 32293}},
    {2779, 15, 8284, {1, 3, 5, 7, 9, 21, 75, 101, 337, 87, 1855, 2479, 285, 10731, 10267}},
    {2780, 15, 8293, {1, 1, 5, 5, 3, 19, 105, 245, 269, 479, 1751, 751, 6551, 7533, 28701}},
    {2781, 15, 8298, {1, 3, 1, 7, 7, 19, 125, 17, 379, 995, 1843, 3453, 5431, 9773, 25025}},
    {2782, 15, 8305, {1, 3, 3, 11, 11, 57, 25, 13, 99, 201, 1511, 3367, 5653, 16205, 28133}},
    {2783, 15, 8317, {1, 3, 3, 7, 13, 59, 127, 139, 141, 265, 427, 1915, 1797, 2375, 13067}},
    {2784, 15, 8328, {1, 1, 5, 15, 23, 55, 77, 31, 219, 529, 1639, 3719, 7985, 13971, 16875}},
    {2785, 15, 8336, {1, 3, 7, 15, 21, 23, 71, 1, 167, 199, 1693, 167, 2309, 6045, 7759}},
    {2786, 15, 8345, {1, 1, 5, 7, 31, 61, 71, 129, 57, 13, 2015, 1319, 2003, 9287, 25527}},
    {2787, 15, 8351, {1, 3, 1, 15, 21, 49, 41, 243, 187, 965, 333, 1919, 6069, 447, 10469}},
    {2788, 15, 8367, {1, 1, 7, 11, 27, 7, 65, 13, 293, 519, 987, 489, 6687, 3057, 29309}},
    {2789, 15, 8379, {1, 3, 5, 1, 15, 23, 113, 181, 219, 915, 1479, 651, 1341, 6883, 25765}},
    {2790, 15, 8381, {1, 3, 7, 1, 17, 15, 107, 85, 173, 405, 1623, 1343, 2491, 6723, 5181}},
    {2791, 15, 8382, {1, 1, 7, 13, 13, 49, 91, 155, 65, 37, 1753, 913, 991, 13663, 3495}},
    {2792, 15, 8393, {1, 3, 5, 7, 27, 19, 83, 121, 243, 141, 1345, 2007, 899, 3023, 21571}},
    {2793, 15, 8402, {1, 1, 7, 13, 5, 41, 5, 169, 291, 513, 483, 3229, 3335, 7245, 26623}},
    {2794, 15, 8414, {1, 1, 1, 1, 25, 37, 107, 87, 105, 135, 1609, 3711, 7161, 3469, 4033}},
    {2795, 15, 8417, {1, 1, 1, 5, 3, 25, 55, 137, 37, 129, 727, 2955, 1981, 13675, 2053}},
    {2796, 15, 8420, {1, 1, 3, 11, 15, 31, 89, 35, 83, 117, 1503, 601, 1613, 11897, 2733}},
    {2797, 15, 8429, {1, 3, 1, 13, 17, 1, 71, 209, 37, 19, 1129, 1219, 5599, 12801, 16663}},
    {2798, 15, 8435, {1, 3, 1, 15, 21, 13, 95, 35, 93, 233, 1075, 101, 5503, 11945, 21861}},
    {2799, 15, 8438, {1, 3, 3, 13, 29, 7, 49, 217, 189, 955, 1847, 911, 4747, 15155, 12781}},
    {2800, 15, 8450, {1, 3, 1, 5, 1, 23, 105, 213, 481, 127, 981, 2767, 1301, 8103, 25427}},
    {2801, 15, 8452, {1, 3, 1, 11, 11, 11, 109, 21, 427, 557, 1057, 1413, 7621, 12423, 24125}},
    {2802, 15, 8459, {1, 3, 3, 5, 19, 55, 111, 141, 503, 877, 685, 3055, 5435, 6371, 16873}},
    {2803, 15, 8470, {1, 3, 1, 13, 9, 7, 77, 139, 423, 605, 939, 903, 4257, 3209, 22189}},
    {2804, 15, 8486, {1, 3, 5, 11, 21, 33, 25, 49, 303, 821, 1225, 1957, 7145, 171, 29235}},
    {2805, 15, 8490, {1, 1, 7, 1, 1, 41, 57, 121, 397, 493, 1393, 4051, 1549, 10067, 28871}},
    {2806, 15, 8500, {1, 3, 3, 3, 31, 41, 105, 49, 165, 209, 231, 3957, 567, 4943, 4847}},
    {2807, 15, 8524, {1, 3, 3, 5, 11, 63, 5, 91, 511, 85, 1181, 3117, 6693, 15615, 19361}},
    {2808, 15, 8536, {1, 1, 1, 13, 7, 17, 33, 5, 439, 723, 947, 2957, 4347, 10847, 12163}},
    {2809, 15, 8552, {1, 1, 3, 11, 13, 17, 57, 145, 265, 1, 1951, 1653, 4563, 3115, 16405}},
    {2810, 15, 8558, {1, 1, 1, 3, 15, 29, 41, 43, 399, 597, 865, 1341, 367, 7713, 8565}},
    {2811, 15, 8570, {1, 1, 3, 5, 31, 19, 57, 39, 339, 779, 2031, 3403, 5137, 15539, 6105}},
    {2812, 15, 8576, {1, 3, 3, 15, 27, 33, 11, 95, 425, 509, 927, 677, 8139, 3645, 13271}},
    {2813, 15, 8582, {1, 1, 1, 13, 9, 39, 123, 219, 27, 561, 219, 2193, 4173, 14883, 22311}},
    {2814, 15, 8594, {1, 3, 1, 9, 9, 47, 25, 81, 429, 847, 397, 3237, 7913, 15875, 17125}},
    {2815, 15, 8606, {1, 1, 1, 11, 19, 7, 21, 215, 135, 337, 671, 3295, 2975, 3971, 10205}},
    {2816, 15, 8619, {1, 3, 5, 1, 13, 33, 119, 131, 169, 751, 227, 2211, 817, 11245, 25583}},
    {2817, 15, 8621, {1, 1, 1, 1, 1, 49, 59, 143, 255, 399, 77, 4075, 5859, 12601, 15443}},
    {2818, 15, 8624, {1, 3, 5, 1, 17, 39, 27, 233, 329, 777, 135, 391, 2447, 1025, 23865}},
    {2819, 15, 8633, {1, 3, 1, 7, 1, 3, 85, 253, 479, 907, 1291, 3607, 443, 3587, 20951}},
    {2820, 15, 8641, {1, 1, 1, 7, 15, 53, 77, 73, 461, 525, 1637, 1331, 5491, 4991, 13517}},
    {2821, 15, 8653, {1, 1, 1, 11, 7, 59, 95, 91, 437, 885, 1871, 2309, 7783, 6373, 11083}},
    {2822, 15, 8654, {1, 1, 7, 3, 9, 5, 95, 113, 293, 319, 455, 2085, 5445, 10863, 32005}},
    {2823, 15, 8662, {1, 3, 3, 3, 3, 33, 119, 175, 167, 347, 609, 2019, 5753, 7243, 14383}},
    {2824, 15, 8675, {1, 1, 7, 9, 7, 3, 31, 91, 287, 731, 1677, 1811, 2743, 13463, 17543}},
    {2825, 15, 8689, {1, 3, 3, 3, 17, 15, 51, 145, 161, 519, 1851, 689, 4263, 12509, 24663}},
    {2826, 15, 8695, {1, 1, 1, 7, 13, 23, 33, 125, 165, 681, 253, 3215, 4717, 11237, 17685}},
    {2827, 15, 8702, {1, 3, 7, 15, 21, 15, 71, 103, 67, 899, 175, 2085, 5471, 14545, 11245}},
    {2828, 15, 8706, {1, 1, 5, 13, 21, 3, 43, 85, 441, 561, 549, 1077, 4139, 257, 20919}},
    {2829, 15, 8720, {1, 1, 7, 13, 31, 23, 27, 185, 57, 905, 1169, 1647, 5035, 16371, 29307}},
    {2830, 15, 8729, {1, 1, 1, 3, 17, 49, 3, 235, 147, 623, 251, 991, 4317, 11147, 7727}},
    {2831, 15, 8739, {1, 3, 1, 9, 1, 7, 77, 171, 293, 313, 979, 1335, 3035, 853, 27371}},
    {2832, 15, 8741, {1, 1, 1, 1, 21, 7, 69, 97, 315, 511, 727, 2871, 5575, 7683, 3033}},
    {2833, 15, 8751, {1, 3, 5, 15, 1, 27, 1, 173, 471, 955, 1555, 4033, 4635, 12753, 10443}},
    {2834, 15, 8759, {1, 3, 3, 1, 9, 11, 15, 149, 119, 1017, 1249, 3373, 6827, 599, 4905}},
    {2835, 15, 8766, {1, 1, 5, 15, 11, 39, 101, 121, 461, 941, 1595, 1413, 5801, 6377, 31805}},
    {2836, 15, 8777, {1, 1, 3, 3, 3, 61, 23, 107, 21, 441, 581, 2101, 315, 4641, 28421}},
    {2837, 15, 8783, {1, 3, 5, 11, 11, 59, 127, 245, 61, 725, 1591, 3203, 4955, 13601, 12859}},
    {2838, 15, 8786, {1, 3, 1, 15, 11, 21, 9, 17, 185, 253, 1549, 2031, 3567, 5395, 23073}},
    {2839, 15, 8795, {1, 1, 7, 11, 31, 15, 23, 97, 305, 731, 1, 481, 7755, 14323, 30407}},
    {2840, 15, 8802, {1, 3, 5, 7, 11, 19, 101, 69, 201, 585, 957, 203, 779, 4823, 29605}},
    {2841, 15, 8814, {1, 1, 5, 7, 27, 27, 101, 125, 259, 771, 1501, 2485, 4079, 8503, 2003}},
    {2842, 15, 8821, {1, 1, 1, 11, 9, 43, 13, 155, 347, 705, 1035, 2361, 7259, 4847, 23449}},
    {2843, 15, 8828, {1, 3, 1, 1, 17, 11, 127, 87, 333, 55, 1177, 1707, 4009, 10677, 32527}},
    {2844, 15, 8831, {1, 3, 7, 3, 9, 45, 33, 203, 79, 53, 205, 2869, 347, 2489, 25781}},
    {2845, 15, 8837, {1, 1, 7, 13, 15, 27, 45, 155, 463, 73, 1389, 503, 2559, 15135, 12021}},
    {2846, 15, 8842, {1, 1, 1, 15, 3, 7, 115, 223, 345, 623, 945, 1617, 1321, 2607, 10149}},
    {2847, 15, 8855, {1, 3, 7, 5, 13, 47, 67, 101, 207, 755, 1929, 2599, 1919, 509, 27751}},
    {2848, 15, 8856, {1, 3, 5, 7, 31, 45, 81, 81, 269, 861, 957, 3597, 7515, 6075, 9915}},
    {2849, 15, 8868, {1, 1, 3, 7, 25, 23, 75, 75, 399, 281, 1487, 889, 2697, 13007, 31949}},
    {2850, 15, 8877, {1, 1, 5, 13, 29, 57, 103, 193, 249, 257, 669, 1621, 6309, 4159, 12425}},
    {2851, 15, 8890, {1, 3, 3, 5, 19, 55, 107, 237, 285, 957, 2047, 3699, 5741, 4151, 2917}},
    {2852, 15, 8892, {1, 1, 5, 3, 3, 41, 79, 239, 183, 665, 1675, 1749, 5471, 8997, 27553}},
    {2853, 15, 8900, {1, 1, 1, 11, 23, 57, 81, 241, 241, 463, 1033, 2273, 3901, 5265, 13843}},
    {2854, 15, 8909, {1, 3, 7, 11, 3, 53, 51, 183, 285, 67, 1897, 2229, 7523, 4115, 30429}},
    {2855, 15, 8912, {1, 1, 1, 13, 3, 19, 95, 23, 53, 25, 881, 629, 7913, 15277, 22915}},
    {2856, 15, 8921, {1, 1, 3, 7, 15, 13, 111, 97, 211, 779, 451, 621, 269, 3925, 28105}},
    {2857, 15, 8922, {1, 1, 7, 11, 21, 23, 45, 151, 135, 973, 395, 627, 5277, 11943, 32087}},
    {2858, 15, 8927, {1, 1, 7, 9, 1, 23, 25, 11, 73, 907, 83, 63, 6887, 3613, 15881}},
    {2859, 15, 8943, {1, 3, 5, 7, 21, 15, 125, 213, 387, 279, 1707, 637, 4467, 7249, 25501}},
    {2860, 15, 8948, {1, 1, 1, 15, 21, 55, 11, 205, 383, 5, 573, 373, 3947, 14939, 23741}},
    {2861, 15, 8951, {1, 1, 5, 1, 17, 31, 51, 225, 365, 417, 1871, 2783, 2887, 6765, 27115}},
    {2862, 15, 8958, {1, 1, 7, 1, 3, 3, 79, 49, 49, 901, 1395, 925, 7935, 2443, 14863}},
    {2863, 15, 8984, {1, 3, 5, 15, 3, 61, 75, 117, 241, 113, 2033, 1747, 5805, 10075, 27097}},
    {2864, 15, 8994, {1, 1, 7, 9, 23, 29, 1, 101, 45, 199, 393, 245, 7131, 5953, 20361}},
    {2865, 15, 9000, {1, 1, 3, 3, 17, 13, 87, 25, 45, 819, 1939, 2779, 7833, 9625, 21693}},
    {2866, 15, 9013, {1, 3, 7, 1, 21, 43, 121, 233, 97, 595, 1489, 3361, 7655, 8293, 2035}},
    {2867, 15, 9018, {1, 1, 5, 11, 5, 47, 39, 43, 457, 1015, 237, 2679, 1523, 339, 13949}},
    {2868, 15, 9020, {1, 1, 7, 9, 27, 43, 73, 71, 117, 897, 1095, 2649, 5593, 15095, 30415}},
    {2869, 15, 9031, {1, 3, 1, 13, 27, 37, 29, 225, 475, 49, 369, 2547, 6183, 4867, 21459}},
    {2870, 15, 9035, {1, 3, 3, 5, 9, 33, 51, 91, 207, 99, 819, 3565, 4347, 13195, 20667}},
    {2871, 15, 9045, {1, 3, 3, 5, 27, 25, 75, 35, 193, 1019, 1537, 3795, 503, 16055, 4675}},
    {2872, 15, 9052, {1, 1, 5, 15, 29, 49, 127, 11, 61, 971, 1193, 2655, 6279, 16037, 25363}},
    {2873, 15, 9056, {1, 3, 5, 3, 13, 45, 109, 209, 213, 673, 829, 1545, 2407, 9533, 1605}},
    {2874, 15, 9059, {1, 1, 7, 11, 5, 37, 11, 151, 173, 317, 455, 1557, 3077, 10045, 21029}},
    {2875, 15, 9066, {1, 1, 7, 1, 7, 7, 103, 175, 175, 131, 55, 1087, 2133, 10501, 7561}},
    {2876, 15, 9076, {1, 1, 5, 9, 13, 41, 115, 89, 167, 17, 1697, 3419, 6509, 7075, 6411}},
    {2877, 15, 9089, {1, 3, 3, 15, 5, 7, 115, 197, 487, 641, 911, 779, 6645, 11843, 24585}},
    {2878, 15, 9129, {1, 3, 5, 5, 9, 39, 47, 123, 467, 603, 1209, 3389, 359, 2513, 11269}},
    {2879, 15, 9132, {1, 3, 3, 13, 23, 3, 105, 71, 343, 679, 281, 3509, 845, 4059, 20983}},
    {2880, 15, 9147, {1, 3, 7, 3, 29, 29, 111, 211, 27, 209, 1059, 537, 2129, 1261, 11809}},
    {2881, 15, 9164, {1, 1, 5, 5, 31, 19, 83, 155, 253, 369, 1889, 847, 5519, 2091, 28329}},
    {2882, 15, 9167, {1, 3, 7, 13, 13, 29, 37, 125, 37, 15, 1909, 4061, 3029, 6645, 30269}},
    {2883, 15, 9185, {1, 1, 3, 5, 3, 3, 121, 161, 497, 93, 1407, 1317, 4425, 9157, 7305}},
    {2884, 15, 9195, {1, 3, 3, 5, 23, 43, 95, 217, 459, 645, 693, 4031, 5531, 7615, 25953}},
    {2885, 15, 9197, {1, 3, 5, 1, 9, 5, 75, 57, 499, 69, 805, 1369, 7667, 2407, 3819}},
    {2886, 15, 9210, {1, 1, 7, 13, 15, 17, 61, 143, 31, 533, 1843, 569, 1765, 9217, 17143}},
    {2887, 15, 9217, {1, 3, 5, 3, 25, 39, 101, 215, 253, 869, 1851, 1149, 4991, 2911, 26055}},
    {2888, 15, 9229, {1, 1, 1, 15, 3, 11, 93, 171, 191, 1011, 965, 1019, 4059, 6471, 3449}},
    {2889, 15, 9248, {1, 3, 3, 15, 7, 17, 97, 213, 401, 235, 1867, 1843, 6299, 10611, 21925}},
    {2890, 15, 9254, {1, 1, 1, 3, 9, 13, 59, 223, 223, 193, 1093, 3379, 1921, 9877, 4289}},
    {2891, 15, 9263, {1, 3, 5, 3, 19, 15, 35, 53, 139, 499, 1419, 1229, 4765, 9743, 17807}},
    {2892, 15, 9266, {1, 1, 5, 11, 11, 45, 103, 235, 77, 395, 181, 595, 2133, 11487, 19765}},
    {2893, 15, 9268, {1, 3, 7, 9, 11, 55, 101, 27, 189, 861, 509, 3833, 2165, 113, 543}},
    {2894, 15, 9290, {1, 3, 5, 5, 29, 59, 21, 239, 245, 491, 1361, 4009, 6443, 12229, 22079}},
    {2895, 15, 9310, {1, 1, 3, 5, 27, 29, 87, 219, 125, 553, 1913, 1503, 5133, 4211, 30767}},
    {2896, 15, 9316, {1, 1, 1, 15, 1, 21, 33, 107, 11, 327, 1615, 3349, 3527, 719, 11517}},
    {2897, 15, 9338, {1, 3, 1, 7, 13, 19, 55, 199, 495, 603, 2013, 1131, 6367, 6843, 16829}},
    {2898, 15, 9340, {1, 1, 3, 5, 9, 45, 113, 215, 159, 407, 1347, 3139, 6119, 12823, 21289}},
    {2899, 15, 9343, {1, 3, 7, 9, 29, 39, 107, 107, 449, 633, 1385, 717, 1411, 3479, 4047}},
    {2900, 15, 9344, {1, 3, 7, 15, 9, 53, 29, 165, 211, 217, 1513, 2205, 1809, 13191, 19511}},
    {2901, 15, 9350, {1, 1, 5, 15, 21, 21, 79, 51, 165, 275, 1843, 1417, 4979, 14879, 15851}},
    {2902, 15, 9354, {1, 3, 3, 5, 5, 39, 19, 89, 93, 339, 173, 3973, 7125, 8897, 6153}},
    {2903, 15, 9359, {1, 1, 7, 1, 19, 25, 13, 249, 97, 1009, 779, 1231, 7667, 12283, 3107}},
    {2904, 15, 9361, {1, 3, 5, 9, 3, 49, 31, 27, 229, 857, 1741, 3091, 1915, 57, 3511}},
    {2905, 15, 9364, {1, 3, 5, 15, 1, 15, 17, 247, 223, 699, 1679, 1003, 4533, 12501, 21441}},
    {2906, 15, 9368, {1, 3, 5, 11, 7, 29, 71, 33, 231, 517, 401, 3439, 5147, 7933, 29319}},
    {2907, 15, 9371, {1, 1, 7, 1, 7, 53, 17, 251, 419, 697, 1765, 2115, 7843, 9445, 16401}},
    {2908, 15, 9373, {1, 3, 5, 13, 11, 53, 29, 43, 445, 629, 1673, 929, 7631, 11299, 22387}},
    {2909, 15, 9389, {1, 1, 3, 1, 31, 53, 79, 25, 57, 877, 1637, 187, 5047, 14641, 24125}},
    {2910, 15, 9390, {1, 1, 7, 1, 17, 1, 95, 153, 427, 117, 1489, 2493, 6989, 3525, 23479}},
    {2911, 15, 9409, {1, 1, 7, 3, 17, 3, 127, 93, 295, 707, 1893, 2901, 4345, 14793, 13387}},
    {2912, 15, 9443, {1, 1, 3, 13, 25, 49, 83, 229, 329, 823, 641, 3549, 1647, 409, 1781}},
    {2913, 15, 9445, {1, 3, 3, 7, 25, 47, 111, 185, 155, 865, 201, 1551, 103, 3501, 25643}},
    {2914, 15, 9446, {1, 3, 1, 5, 3, 29, 51, 79, 361, 917, 207, 1107, 5433, 363, 20639}},
    {2915, 15, 9452, {1, 3, 7, 11, 1, 7, 13, 181, 467, 367, 827, 1841, 6635, 9581, 12379}},
    {2916, 15, 9490, {1, 1, 7, 7, 15, 59, 43, 249, 109, 491, 917, 779, 3557, 1085, 18693}},
    {2917, 15, 9492, {1, 3, 3, 1, 3, 15, 27, 137, 271, 997, 1383, 133, 7775, 6291, 18733}},
    {2918, 15, 9495, {1, 1, 7, 7, 19, 55, 91, 157, 439, 257, 545, 3645, 1, 769, 8103}},
    {2919, 15, 9508, {1, 1, 1, 11, 23, 61, 3, 81, 73, 153, 1787, 3057, 855, 8417, 21523}},
    {2920, 15, 9523, {1, 1, 5, 7, 13, 23, 47, 117, 313, 351, 233, 3135, 2649, 4875, 24457}},
    {2921, 15, 9543, {1, 3, 5, 7, 1, 23, 13, 177, 313, 235, 1679, 2211, 6071, 14905, 29467}},
    {2922, 15, 9558, {1, 1, 7, 5, 29, 49, 47, 201, 15, 727, 1715, 481, 4559, 12301, 21931}},
    {2923, 15, 9567, {1, 1, 7, 5, 17, 49, 81, 203, 167, 399, 1047, 1395, 2263, 6303, 12113}},
    {2924, 15, 9580, {1, 1, 3, 5, 5, 35, 3, 171, 5, 867, 1357, 3205, 1057, 365, 10249}},
    {2925, 15, 9585, {1, 3, 5, 15, 29, 39, 17, 65, 343, 341, 459, 1243, 6107, 10277, 23171}},
    {2926, 15, 9591, {1, 1, 5, 7, 11, 45, 65, 151, 181, 277, 21, 3837, 3571, 11415, 15987}},
    {2927, 15, 9611, {1, 3, 7, 9, 5, 27, 49, 185, 135, 611, 1815, 1771, 2293, 1509, 15729}},
    {2928, 15, 9613, {1, 3, 5, 3, 19, 25, 81, 35, 349, 915, 1687, 621, 257, 8631, 6119}},
    {2929, 15, 9614, {1, 1, 3, 15, 27, 1, 127, 167, 41, 531, 697, 4031, 5421, 5097, 529}},
    {2930, 15, 9621, {1, 3, 7, 15, 21, 37, 73, 15, 393, 173, 1461, 1437, 2367, 7171, 15123}},
    {2931, 15, 9631, {1, 1, 1, 11, 25, 35, 79, 161, 317, 919, 593, 2987, 443, 3321, 5219}},
    {2932, 15, 9642, {1, 3, 5, 7, 3, 61, 31, 93, 357, 457, 743, 3219, 5287, 13979, 16823}},
    {2933, 15, 9656, {1, 3, 5, 1, 27, 27, 17, 37, 167, 749, 1937, 3951, 2473, 14303, 22467}},
    {2934, 15, 9661, {1, 3, 3, 5, 29, 31, 89, 35, 305, 37, 479, 395, 2091, 14017, 5381}},
    {2935, 15, 9667, {1, 3, 1, 7, 5, 49, 123, 215, 297, 835, 1825, 63, 6409, 8097, 30807}},
    {2936, 15, 9694, {1, 1, 5, 11, 11, 21, 19, 179, 19, 353, 1859, 2161, 2203, 1241, 25329}},
    {2937, 15, 9715, {1, 3, 5, 9, 19, 57, 91, 131, 245, 343, 939, 1187, 1969, 6631, 24179}},
    {2938, 15, 9722, {1, 1, 1, 9, 9, 21, 7, 101, 135, 219, 1307, 2683, 1605, 3519, 8873}},
    {2939, 15, 9738, {1, 1, 3, 3, 31, 15, 107, 93, 375, 699, 435, 3301, 1363, 2541, 4493}},
    {2940, 15, 9745, {1, 1, 5, 11, 19, 3, 21, 213, 261, 799, 1765, 1171, 2739, 9957, 20087}},
    {2941, 15, 9758, {1, 1, 3, 3, 17, 33, 87, 201, 53, 669, 1357, 3701, 4711, 6085, 1371}},
    {2942, 15, 9764, {1, 3, 5, 9, 9, 63, 115, 85, 193, 601, 219, 2385, 1863, 5805, 11045}},
    {2943, 15, 9782, {1, 1, 7, 11, 31, 11, 121, 183, 365, 899, 301, 1263, 6857, 8633, 28013}},
    {2944, 15, 9791, {1, 3, 5, 9, 9, 25, 71, 153, 501, 747, 313, 839, 3115, 13747, 20307}},
    {2945, 15, 9793, {1, 1, 1, 15, 17, 41, 125, 183, 91, 133, 1551, 2865, 5829, 10851, 3953}},
    {2946, 15, 9794, {1, 3, 7, 1, 21, 39, 37, 47, 129, 683, 763, 1395, 6977, 10253, 30429}},
    {2947, 15, 9805, {1, 1, 1, 5, 7, 11, 125, 249, 97, 373, 331, 1917, 7283, 1935, 15737}},
    {2948, 15, 9808, {1, 1, 7, 7, 31, 29, 99, 149, 131, 27, 1315, 1619, 7759, 14873, 5361}},
    {2949, 15, 9811, {1, 1, 1, 7, 7, 37, 115, 101, 27, 595, 481, 1741, 7705, 5875, 1895}},
    {2950, 15, 9817, {1, 1, 7, 5, 31, 29, 59, 161, 73, 55, 1743, 1685, 6943, 3457, 21085}},
    {2951, 15, 9824, {1, 1, 1, 1, 25, 1, 25, 101, 345, 815, 1273, 2445, 2097, 5367, 19829}},
    {2952, 15, 9836, {1, 1, 3, 7, 13, 61, 115, 175, 445, 61, 1675, 2053, 5027, 10929, 6067}},
    {2953, 15, 9851, {1, 3, 5, 9, 7, 33, 59, 11, 309, 635, 29, 3321, 4709, 10249, 4399}},
    {2954, 15, 9853, {1, 1, 7, 15, 13, 21, 11, 189, 63, 15, 363, 1951, 5751, 5797, 22123}},
    {2955, 15, 9854, {1, 1, 1, 1, 15, 57, 71, 19, 481, 795, 1535, 1635, 7575, 14749, 25255}},
    {2956, 15, 9877, {1, 3, 7, 5, 9, 53, 43, 11, 329, 799, 1291, 3021, 4733, 5087, 18129}},
    {2957, 15, 9881, {1, 1, 3, 13, 1, 63, 1, 129, 123, 59, 1185, 3479, 7483, 7125, 20087}},
    {2958, 15, 9923, {1, 1, 1, 9, 9, 63, 101, 63, 493, 31, 1067, 83, 3777, 9347, 6347}},
    {2959, 15, 9935, {1, 3, 3, 11, 23, 47, 17, 59, 189, 841, 233, 3453, 2949, 11863, 1499}},
    {2960, 15, 9937, {1, 3, 3, 3, 11, 49, 9, 195, 201, 453, 477, 3929, 7017, 8613, 5581}},
    {2961, 15, 9954, {1, 3, 7, 5, 23, 13, 15, 217, 435, 511, 887, 111, 3259, 12773, 28673}},
    {2962, 15, 9959, {1, 3, 7, 9, 9, 29, 101, 233, 423, 891, 171, 1703, 2055, 5413, 24149}},
    {2963, 15, 9963, {1, 1, 1, 3, 9, 1, 115, 21, 411, 47, 1473, 2773, 5259, 3239, 11473}},
    {2964, 15, 9968, {1, 3, 3, 5, 17, 7, 57, 131, 457, 513, 701, 2743, 3035, 15821, 8755}},
    {2965, 15, 9973, {1, 3, 3, 5, 15, 37, 9, 223, 233, 937, 1003, 3215, 2975, 4021, 9961}},
    {2966, 15, 9974, {1, 3, 3, 5, 5, 37, 69, 137, 37, 337, 1603, 3595, 7369, 11833, 9665}},
    {2967, 15, 9980, {1, 3, 3, 7, 17, 57, 93, 245, 39, 201, 841, 629, 3651, 8149, 29897}},
    {2968, 15, 9983, {1, 1, 7, 13, 5, 5, 83, 185, 501, 889, 755, 1833, 1027, 2467, 13919}},
    {2969, 15, 9985, {1, 3, 3, 1, 21, 35, 67, 137, 381, 1021, 695, 3749, 7629, 5235, 10457}},
    {2970, 15, 10003, {1, 1, 3, 1, 29, 25, 119, 185, 203, 733, 781, 3275, 4525, 6015, 23669}},
    {2971, 15, 10010, {1, 1, 7, 11, 29, 55, 73, 175, 257, 375, 221, 2377, 159, 3449, 31883}},
    {2972, 15, 10034, {1, 1, 7, 11, 9, 13, 23, 57, 89, 117, 1691, 1797, 183, 5021, 2327}},
    {2973, 15, 10040, {1, 3, 1, 7, 23, 19, 49, 179, 349, 863, 1951, 1687, 3149, 2849, 20305}},
    {2974, 15, 10063, {1, 3, 3, 7, 23, 9, 31, 37, 177, 841, 1095, 957, 5089, 3927, 28871}},
    {2975, 15, 10077, {1, 3, 3, 15, 7, 43, 91, 161, 53, 747, 1639, 3917, 3023, 12969, 2173}},
    {2976, 15, 10081, {1, 3, 1, 15, 13, 53, 109, 157, 341, 269, 1913, 3391, 5905, 4935, 32237}},
    {2977, 15, 10082, {1, 3, 5, 1, 21, 25, 99, 201, 417, 483, 79, 2459, 2019, 3733, 21343}},
    {2978, 15, 10084, {1, 1, 7, 13, 13, 25, 47, 11, 299, 289, 1739, 931, 1995, 7047, 16137}},
    {2979, 15, 10088, {1, 1, 1, 11, 11, 61, 89, 233, 61, 1023, 337, 3443, 8065, 5179, 30343}},
    {2980, 15, 10091, {1, 1, 3, 5, 23, 23, 75, 87, 321, 1021, 509, 1847, 7281, 8303, 26079}},
    {2981, 15, 10105, {1, 3, 1, 7, 29, 31, 19, 159, 251, 697, 1979, 417, 6957, 9649, 11029}},
    {2982, 15, 10111, {1, 1, 7, 5, 9, 7, 101, 47, 277, 797, 101, 2665, 6797, 1465, 6043}},
    {2983, 15, 10118, {1, 3, 7, 3, 23, 15, 47, 217, 313, 369, 995, 479, 2501, 2283, 6803}},
    {2984, 15, 10127, {1, 3, 7, 13, 29, 19, 107, 99, 363, 757, 613, 2489, 4187, 4401, 23633}},
    {2985, 15, 10135, {1, 3, 7, 13, 3, 59, 5, 67, 507, 791, 1105, 177, 6713, 16055, 25575}},
    {2986, 15, 10169, {1, 1, 7, 9, 11, 11, 19, 29, 407, 647, 1231, 3425, 6195, 9783, 16933}},
    {2987, 15, 10172, {1, 1, 7, 5, 19, 63, 61, 215, 161, 507, 981, 1653, 5281, 11427, 6735}},
    {2988, 15, 10183, {1, 3, 1, 1, 5, 49, 27, 41, 57, 873, 2023, 1293, 4213, 14737, 19125}},
    {2989, 15, 10190, {1, 3, 5, 5, 17, 43, 105, 183, 135, 817, 451, 3429, 883, 7015, 9823}},
    {2990, 15, 10192, {1, 3, 3, 11, 21, 37, 87, 85, 47, 1007, 351, 1257, 8057, 12771, 6535}},
    {2991, 15, 10211, {1, 1, 3, 7, 29, 3, 73, 255, 63, 1005, 699, 2609, 3639, 8307, 23205}},
    {2992, 15, 10218, {1, 1, 1, 13, 1, 47, 37, 243, 359, 281, 1479, 43, 291, 4925, 27253}},
    {2993, 15, 10228, {1, 3, 5, 5, 19, 11, 59, 103, 281, 833, 473, 525, 5669, 7631, 25613}},
    {2994, 15, 10235, {1, 3, 3, 7, 25, 25, 71, 235, 383, 399, 1699, 833, 5495, 10835, 3865}},
    {2995, 15, 10242, {1, 3, 7, 7, 9, 9, 103, 49, 391, 515, 1343, 4079, 5061, 1111, 13401}},
    {2996, 15, 10244, {1, 3, 5, 3, 27, 25, 61, 163, 3, 493, 473, 3189, 5657, 13679, 17521}},
    {2997, 15, 10271, {1, 3, 1, 3, 21, 13, 97, 9, 139, 493, 1719, 2915, 383, 1441, 10859}},
    {2998, 15, 10278, {1, 3, 1, 7, 5, 9, 57, 113, 99, 493, 251, 1499, 4451, 10395, 3627}},
    {2999, 15, 10296, {1, 1, 5, 3, 5, 15, 61, 255, 205, 95, 1413, 2635, 1233, 15753, 28945}},
    {3000, 15, 10299, {1, 1, 1, 3, 23, 15, 55, 109, 33, 665, 161, 2195, 3773, 1009, 29597}},
    {3001, 15, 10307, {1, 1, 3, 5, 19, 39, 29, 171, 5, 469, 21, 3755, 2687, 1619, 27543}},
    {3002, 15, 10309, {1, 3, 1, 15, 25, 39, 13, 103, 361, 329, 1299, 3235, 1853, 2903, 5609}},
    {3003, 15, 10310, {1, 1, 7, 13, 31, 15, 61, 205, 415, 927, 237, 3467, 5249, 5813, 21161}},
    {3004, 15, 10314, {1, 3, 3, 7, 11, 31, 123, 217, 161, 789, 1203, 1317, 6511, 8337, 30579}},
    {3005, 15, 10316, {1, 3, 5, 1, 11, 29, 77, 7, 23, 671, 1503, 839, 537, 845, 16819}},
    {3006, 15, 10321, {1, 1, 3, 15, 9, 47, 23, 229, 311, 875, 1213, 3391, 7039, 6659, 1383}},
    {3007, 15, 10328, {1, 3, 7, 11, 27, 35, 9, 237, 57, 929, 49, 3947, 2497, 6077, 31135}},
    {3008, 15, 10338, {1, 3, 7, 15, 23, 49, 109, 87, 105, 933, 601, 1745, 3463, 10523, 7757}},
    {3009, 15, 10343, {1, 1, 3, 15, 3, 25, 107, 9, 167, 987, 1835, 449, 1931, 11557, 2375}},
    {3010, 15, 10344, {1, 3, 5, 9, 25, 13, 75, 253, 481, 27, 1551, 305, 43, 14017, 11429}},
    {3011, 15, 10347, {1, 3, 7, 11, 27, 13, 99, 219, 109, 61, 409, 1153, 4091, 10905, 14017}},
    {3012, 15, 10352, {1, 1, 3, 1, 1, 19, 9, 53, 47, 607, 955, 3159, 6943, 11493, 7583}},
    {3013, 15, 10364, {1, 3, 3, 1, 5, 21, 127, 233, 391, 895, 1565, 2599, 4565, 10985, 993}},
    {3014, 15, 10373, {1, 1, 3, 5, 5, 51, 29, 87, 481, 539, 1485, 3903, 3577, 8573, 20257}},
    {3015, 15, 10386, {1, 1, 1, 13, 5, 47, 3, 15, 31, 893, 1331, 3781, 7555, 1459, 1407}},
    {3016, 15, 10391, {1, 3, 1, 7, 11, 3, 53, 117, 361, 225, 139, 2995, 3125, 133, 11791}},
    {3017, 15, 10398, {1, 1, 3, 7, 15, 23, 25, 155, 127, 47, 1329, 4069, 1165, 15035, 10343}},
    {3018, 15, 10408, {1, 1, 1, 13, 21, 31, 21, 109, 219, 407, 1305, 2447, 8071, 11261, 1303}},
    {3019, 15, 10413, {1, 1, 1, 3, 23, 55, 49, 121, 21, 911, 75, 2039, 5879, 3775, 25719}},
    {3020, 15, 10422, {1, 1, 1, 1, 19, 43, 127, 107, 95, 797, 865, 1285, 3019, 13137, 24677}},
    {3021, 15, 10445, {1, 1, 7, 13, 5, 45, 101, 173, 119, 405, 235, 1119, 6279, 1801, 21005}},
    {3022, 15, 10460, {1, 1, 5, 3, 7, 39, 87, 115, 355, 489, 233, 2587, 3237, 12011, 11103}},
    {3023, 15, 10463, {1, 3, 1, 13, 31, 45, 73, 141, 385, 561, 845, 3707, 5805, 87, 2049}},
    {3024, 15, 10464, {1, 1, 5, 5, 27, 63, 5, 35, 469, 425, 1267, 1877, 303, 10793, 6637}},
    {3025, 15, 10474, {1, 3, 3, 9, 11, 45, 113, 81, 339, 855, 1259, 2401, 5081, 7429, 21703}},
    {3026, 15, 10476, {1, 3, 1, 1, 27, 23, 39, 87, 415, 849, 1391, 2991, 5581, 9565, 20703}},
    {3027, 15, 10487, {1, 3, 3, 1, 21, 1, 99, 121, 305, 773, 199, 2635, 5791, 8661, 32631}},
    {3028, 15, 10494, {1, 1, 3, 15, 29, 33, 11, 99, 3, 563, 1029, 2125, 5617, 12755, 20505}},
    {3029, 15, 10499, {1, 1, 1, 7, 13, 17, 17, 97, 445, 579, 909, 3457, 2169, 3027, 27257}},
    {3030, 15, 10506, {1, 3, 7, 11, 3, 43, 9, 27, 351, 981, 1845, 207, 6675, 10041, 18627}},
    {3031, 15, 10513, {1, 3, 3, 13, 23, 55, 45, 237, 267, 1003, 879, 731, 7753, 6157, 7935}},
    {3032, 15, 10516, {1, 1, 7, 7, 9, 51, 7, 231, 289, 605, 687, 3523, 3581, 10475, 22381}},
    {3033, 15, 10523, {1, 1, 7, 15, 17, 37, 127, 171, 95, 81, 1833, 3795, 5501, 1343, 16207}},
    {3034, 15, 10539, {1, 1, 1, 5, 9, 25, 29, 89, 389, 517, 1249, 513, 3373, 8099, 21371}},
    {3035, 15, 10549, {1, 3, 5, 13, 19, 3, 125, 247, 491, 53, 709, 849, 2629, 6639, 24691}},
    {3036, 15, 10550, {1, 3, 5, 3, 5, 21, 65, 159, 245, 163, 1633, 1921, 5001, 2491, 29311}},
    {3037, 15, 10567, {1, 1, 5, 13, 9, 61, 81, 119, 121, 85, 125, 2645, 183, 10005, 22169}},
    {3038, 15, 10576, {1, 3, 1, 9, 27, 5, 9, 171, 499, 823, 329, 173, 7831, 5057, 7245}},
    {3039, 15, 10625, {1, 1, 7, 3, 11, 37, 43, 253, 267, 185, 397, 4021, 1251, 505, 18181}},
    {3040, 15, 10635, {1, 1, 3, 9, 15, 27, 47, 187, 427, 95, 391, 3929, 5093, 6341, 8585}},
    {3041, 15, 10643, {1, 1, 1, 3, 13, 21, 11, 97, 141, 815, 171, 2195, 4495, 9197, 13671}},
    {3042, 15, 10656, {1, 3, 1, 7, 31, 19, 35, 163, 9, 647, 1165, 1225, 5111, 7341, 9717}},
    {3043, 15, 10671, {1, 1, 3, 1, 3, 31, 33, 75, 327, 251, 355, 2291, 5825, 3729, 22575}},
    {3044, 15, 10676, {1, 1, 3, 5, 7, 25, 51, 11, 79, 997, 209, 3077, 7947, 6609, 15999}},
    {3045, 15, 10683, {1, 3, 1, 15, 19, 23, 107, 175, 371, 465, 1595, 341, 4953, 1867, 2897}},
    {3046, 15, 10685, {1, 1, 1, 15, 5, 11, 27, 69, 385, 377, 1881, 1121, 7765, 8933, 28017}},
    {3047, 15, 10688, {1, 3, 5, 9, 21, 1, 13, 81, 7, 725, 739, 3339, 1077, 2473, 29093}},
    {3048, 15, 10697, {1, 1, 7, 1, 21, 61, 69, 165, 455, 325, 33, 2341, 2945, 2503, 25903}},
    {3049, 15, 10700, {1, 1, 5, 11, 25, 19, 53, 55, 181, 743, 1849, 1423, 7391, 3061, 28945}},
    {3050, 15, 10712, {1, 1, 1, 1, 21, 61, 3, 149, 465, 839, 1265, 343, 4693, 529, 24249}},
    {3051, 15, 10724, {1, 3, 5, 15, 29, 7, 103, 97, 193, 675, 1703, 2539, 1997, 10677, 19427}},
    {3052, 15, 10728, {1, 3, 3, 1, 5, 9, 27, 87, 303, 363, 415, 2121, 2509, 1221, 22495}},
    {3053, 15, 10734, {1, 1, 7, 3, 27, 35, 93, 157, 263, 7, 663, 2129, 745, 2237, 885}},
    {3054, 15, 10739, {1, 3, 7, 1, 29, 37, 83, 219, 211, 373, 657, 1783, 7873, 7399, 22667}},
    {3055, 15, 10762, {1, 1, 5, 1, 5, 37, 45, 19, 495, 837, 1659, 1687, 8085, 4725, 5289}},
    {3056, 15, 10772, {1, 3, 3, 13, 23, 47, 107, 95, 13, 127, 1429, 1205, 7855, 7747, 15371}},
    {3057, 15, 10781, {1, 3, 1, 1, 31, 9, 41, 159, 101, 959, 355, 873, 2621, 15401, 18823}},
    {3058, 15, 10800, {1, 3, 1, 11, 23, 55, 61, 11, 225, 745, 73, 3037, 6273, 14811, 24237}},
    {3059, 15, 10805, {1, 3, 3, 11, 13, 57, 107, 159, 99, 951, 1621, 3567, 2839, 9575, 25825}},
    {3060, 15, 10827, {1, 3, 3, 9, 1, 53, 121, 155, 411, 243, 479, 2987, 5263, 9887, 27675}},
    {3061, 15, 10830, {1, 1, 3, 1, 9, 51, 123, 11, 243, 929, 1073, 1431, 6903, 11473, 17169}},
    {3062, 15, 10837, {1, 1, 7, 9, 7, 59, 5, 239, 51, 511, 779, 279, 1035, 16071, 30395}},
    {3063, 15, 10841, {1, 1, 1, 13, 7, 35, 93, 107, 21, 707, 349, 2927, 6891, 14027, 1753}},
    {3064, 15, 10847, {1, 1, 1, 5, 15, 47, 117, 191, 193, 175, 221, 1571, 3797, 14653, 26145}},
    {3065, 15, 10848, {1, 3, 5, 9, 15, 47, 29, 217, 89, 325, 1119, 2795, 1785, 15089, 23123}},
    {3066, 15, 10857, {1, 1, 5, 9, 17, 49, 5, 137, 361, 913, 2011, 2273, 3211, 12659, 4191}},
    {3067, 15, 10866, {1, 3, 5, 15, 25, 31, 35, 13, 19, 91, 781, 2173, 6723, 463, 23275}},
    {3068, 15, 10868, {1, 1, 5, 9, 9, 21, 87, 1, 449, 485, 881, 3861, 2877, 13327, 13029}},
    {3069, 15, 10872, {1, 3, 7, 9, 11, 53, 89, 215, 31, 939, 441, 1081, 181, 6435, 23269}},
    {3070, 15, 10887, {1, 3, 5, 7, 29, 45, 3, 229, 433, 327, 1851, 3083, 4827, 5715, 29967}},
    {3071, 15, 10899, {1, 3, 7, 5, 15, 21, 95, 109, 327, 419, 697, 1889, 7763, 7397, 16681}},
    {3072, 15, 10901, {1, 3, 3, 7, 7, 51, 63, 101, 239, 787, 1435, 2251, 6617, 5399, 16423}},
    {3073, 15, 10915, {1, 3, 7, 7, 7, 59, 15, 39, 449, 921, 1205, 3119, 777, 6531, 19895}},
    {3074, 15, 10924, {1, 1, 7, 7, 23, 59, 95, 23, 69, 931, 415, 355, 6541, 15713, 13659}},
    {3075, 15, 10929, {1, 3, 5, 7, 3, 53, 37, 251, 71, 233, 225, 1211, 6489, 9103, 9143}},
    {3076, 15, 10942, {1, 3, 7, 3, 9, 21, 3, 141, 9, 1015, 813, 1451, 7231, 5867, 16145}},
    {3077, 15, 10971, {1, 1, 3, 3, 31, 23, 119, 137, 317, 447, 587, 545, 4365, 12207, 23405}},
    {3078, 15, 10992, {1, 1, 1, 11, 31, 23, 105, 29, 219, 283, 1723, 911, 5559, 13529, 28589}},
    {3079, 15, 10995, {1, 1, 7, 3, 21, 1, 123, 155, 277, 675, 1347, 3805, 5049, 6511, 16185}},
    {3080, 15, 11002, {1, 3, 1, 15, 17, 15, 5, 75, 201, 883, 717, 1035, 4075, 9583, 26623}},
    {3081, 15, 11010, {1, 3, 1, 11, 9, 53, 119, 245, 477, 771, 1223, 1787, 1383, 15509, 25615}},
    {3082, 15, 11027, {1, 1, 5, 11, 5, 39, 25, 165, 409, 21, 1565, 1343, 5063, 7805, 1673}},
    {3083, 15, 11029, {1, 1, 3, 15, 23, 5, 19, 47, 15, 797, 193, 2707, 7957, 1689, 8925}},
    {3084, 15, 11045, {1, 3, 1, 13, 5, 19, 59, 171, 453, 691, 89, 2003, 987, 3445, 15791}},
    {3085, 15, 11057, {1, 3, 7, 15, 15, 25, 17, 31, 489, 741, 93, 1721, 2167, 5181, 26323}},
    {3086, 15, 11070, {1, 3, 1, 9, 21, 17, 111, 19, 481, 57, 1637, 1949, 6781, 13743, 11443}},
    {3087, 15, 11092, {1, 3, 1, 15, 19, 15, 63, 31, 379, 681, 259, 1827, 7019, 455, 16427}},
    {3088, 15, 11099, {1, 3, 5, 9, 11, 41, 5, 131, 377, 695, 1355, 1811, 6323, 14061, 27833}},
    {3089, 15, 11106, {1, 3, 3, 5, 29, 11, 95, 219, 11, 255, 1971, 2835, 4103, 15483, 1497}},
    {3090, 15, 11115, {1, 3, 5, 11, 29, 49, 89, 185, 359, 979, 473, 2967, 85, 12519, 28119}},
    {3091, 15, 11120, {1, 1, 7, 13, 11, 3, 43, 135, 103, 199, 1929, 3725, 825, 1697, 26481}},
    {3092, 15, 11126, {1, 3, 3, 11, 3, 53, 111, 231, 339, 1005, 1715, 1731, 7363, 8165, 2197}},
    {3093, 15, 11153, {1, 1, 5, 1, 5, 5, 1, 53, 183, 839, 941, 1537, 1749, 16251, 28267}},
    {3094, 15, 11190, {1, 1, 5, 1, 19, 3, 89, 157, 145, 63, 1361, 1663, 2257, 3471, 907}},
    {3095, 15, 11199, {1, 3, 3, 3, 27, 49, 85, 133, 65, 213, 2047, 1325, 1379, 7137, 14427}},
    {3096, 15, 11222, {1, 3, 7, 13, 9, 35, 61, 3, 171, 647, 427, 1389, 1971, 11765, 32401}},
    {3097, 15, 11225, {1, 3, 1, 5, 3, 15, 9, 45, 491, 359, 217, 3115, 2835, 861, 30025}},
    {3098, 15, 11226, {1, 1, 3, 7, 27, 27, 93, 103, 409, 75, 1889, 1017, 3601, 11499, 24243}},
    {3099, 15, 11231, {1, 3, 3, 11, 29, 57, 105, 31, 165, 313, 189, 159, 1447, 12259, 20873}},
    {3100, 15, 11244, {1, 1, 7, 7, 23, 45, 49, 67, 213, 999, 859, 3339, 6591, 7113, 1201}},
    {3101, 15, 11259, {1, 3, 7, 13, 1, 19, 29, 45, 183, 813, 887, 3063, 3037, 10313, 26127}},
    {3102, 15, 11261, {1, 3, 5, 7, 21, 23, 109, 125, 431, 605, 1311, 3079, 2575, 13659, 29771}},
    {3103, 15, 11270, {1, 3, 1, 13, 19, 29, 119, 117, 73, 239, 1877, 2579, 5861, 15913, 30149}},
    {3104, 15, 11273, {1, 3, 5, 7, 31, 27, 105, 31, 337, 657, 1833, 811, 2759, 5997, 29545}},
    {3105, 15, 11300, {1, 3, 5, 1, 1, 49, 105, 39, 471, 37, 323, 3643, 2399, 6699, 32643}},
    {3106, 15, 11307, {1, 1, 7, 5, 31, 61, 121, 205, 173, 347, 1683, 1723, 399, 9805, 3339}},
    {3107, 15, 11318, {1, 1, 1, 11, 29, 13, 65, 123, 211, 611, 1573, 3117, 1819, 2467, 21615}},
    {3108, 15, 11332, {1, 3, 3, 9, 31, 57, 23, 171, 75, 579, 195, 1407, 1, 5793, 11961}},
    {3109, 15, 11335, {1, 3, 3, 9, 23, 51, 69, 165, 465, 59, 1033, 2091, 4671, 8629, 20885}},
    {3110, 15, 11341, {1, 1, 3, 3, 19, 27, 17, 113, 321, 411, 1251, 3229, 837, 10995, 10067}},
    {3111, 15, 11347, {1, 3, 3, 13, 31, 23, 53, 189, 113, 93, 29, 1609, 5257, 1695, 23151}},
    {3112, 15, 11354, {1, 3, 5, 13, 5, 17, 3, 135, 349, 799, 1311, 643, 2505, 9495, 31373}},
    {3113, 15, 11360, {1, 3, 5, 3, 3, 23, 117, 163, 315, 961, 1611, 2439, 1499, 1115, 21465}},
    {3114, 15, 11369, {1, 1, 1, 3, 5, 31, 73, 101, 345, 169, 2017, 3703, 7615, 573, 29703}},
    {3115, 15, 11372, {1, 3, 1, 5, 17, 31, 7, 139, 11, 571, 593, 3859, 1193, 3827, 14365}},
    {3116, 15, 11378, {1, 1, 7, 11, 17, 33, 1, 47, 207, 703, 1941, 1847, 747, 11485, 22565}},
    {3117, 15, 11396, {1, 1, 5, 15, 15, 25, 19, 219, 323, 887, 453, 3361, 255, 5823, 26139}},
    {3118, 15, 11405, {1, 3, 3, 9, 19, 33, 21, 243, 125, 455, 721, 861, 4567, 155, 14707}},
    {3119, 15, 11417, {1, 1, 3, 9, 27, 59, 11, 73, 243, 843, 475, 2101, 2341, 2615, 28053}},
    {3120, 15, 11424, {1, 3, 5, 1, 29, 47, 71, 75, 93, 611, 1719, 4077, 51, 9883, 31419}},
    {3121, 15, 11427, {1, 3, 1, 9, 25, 33, 113, 159, 347, 375, 671, 2253, 4243, 7069, 29511}},
    {3122, 15, 11430, {1, 1, 5, 15, 11, 49, 125, 235, 435, 683, 1873, 3569, 4621, 6741, 23639}},
    {3123, 15, 11439, {1, 3, 7, 11, 13, 17, 39, 197, 89, 37, 881, 4047, 5165, 4709, 8327}},
    {3124, 15, 11442, {1, 1, 1, 15, 11, 7, 57, 253, 483, 757, 965, 2459, 4103, 5483, 32049}},
    {3125, 15, 11448, {1, 3, 1, 11, 9, 59, 109, 77, 403, 101, 823, 1625, 2405, 14773, 6229}},
    {3126, 15, 11461, {1, 1, 3, 5, 23, 47, 29, 215, 257, 829, 113, 1697, 1991, 5543, 7593}},
    {3127, 15, 11468, {1, 1, 3, 15, 25, 25, 37, 243, 299, 243, 979, 4019, 219, 7643, 17097}},
    {3128, 15, 11471, {1, 1, 3, 13, 21, 61, 73, 131, 89, 411, 321, 337, 2093, 1711, 24851}},
    {3129, 15, 11473, {1, 3, 7, 11, 17, 35, 7, 149, 409, 861, 1925, 1761, 8191, 15211, 25633}},
    {3130, 15, 11476, {1, 3, 5, 15, 9, 39, 99, 177, 15, 901, 655, 485, 5247, 1299, 19489}},
    {3131, 15, 11480, {1, 3, 3, 15, 11, 7, 27, 59, 133, 785, 509, 2927, 3863, 8301, 21301}},
    {3132, 15, 11489, {1, 1, 7, 5, 31, 37, 111, 33, 489, 395, 353, 4091, 3795, 10331, 29117}},
    {3133, 15, 11499, {1, 3, 5, 1, 29, 13, 71, 119, 185, 279, 1673, 265, 5381, 14353, 6941}},
    {3134, 15, 11516, {1, 3, 1, 13, 23, 33, 13, 47, 389, 229, 1863, 1521, 7053, 3923, 3357}},
    {3135, 15, 11522, {1, 3, 3, 5, 15, 7, 73, 173, 373, 273, 839, 2823, 7599, 16295, 4847}},
    {3136, 15, 11531, {1, 1, 7, 3, 25, 41, 43, 255, 387, 559, 1727, 3627, 3445, 15727, 195}},
    {3137, 15, 11539, {1, 3, 1, 5, 5, 53, 83, 79, 329, 171, 1263, 3861, 3755, 12539, 29081}},
    {3138, 15, 11546, {1, 1, 7, 13, 25, 13, 125, 83, 295, 451, 1675, 3637, 7139, 15561, 26095}},
    {3139, 15, 11551, {1, 3, 5, 13, 7, 53, 39, 185, 73, 497, 1579, 2607, 1115, 11197, 12947}},
    {3140, 15, 11564, {1, 1, 7, 7, 13, 7, 109, 251, 149, 391, 1491, 4037, 5057, 6153, 8413}},
    {3141, 15, 11582, {1, 3, 3, 11, 7, 13, 121, 7, 299, 679, 1829, 1987, 7837, 4739, 23499}},
    {3142, 15, 11589, {1, 1, 7, 7, 15, 19, 93, 231, 455, 951, 903, 3225, 6339, 13559, 27455}},
    {3143, 15, 11593, {1, 1, 3, 9, 13, 37, 119, 167, 37, 217, 307, 735, 513, 9571, 17535}},
    {3144, 15, 11601, {1, 3, 7, 13, 15, 45, 81, 109, 167, 607, 91, 2919, 3207, 12099, 3545}},
    {3145, 15, 11608, {1, 3, 1, 3, 31, 37, 81, 17, 7, 509, 1967, 437, 5651, 3843, 10079}},
    {3146, 15, 11617, {1, 1, 3, 11, 1, 15, 1, 67, 489, 279, 171, 1865, 5417, 14801, 32727}},
    {3147, 15, 11630, {1, 3, 5, 7, 9, 9, 123, 41, 391, 545, 1867, 4011, 6039, 8767, 14657}},
    {3148, 15, 11663, {1, 3, 5, 9, 21, 23, 25, 7, 335, 335, 1435, 2189, 7949, 9113, 22863}},
    {3149, 15, 11666, {1, 3, 3, 7, 3, 31, 59, 63, 345, 81, 1095, 271, 3417, 3719, 24845}},
    {3150, 15, 11668, {1, 1, 7, 5, 15, 41, 111, 3, 279, 735, 1015, 1139, 2275, 4511, 30147}},
    {3151, 15, 11677, {1, 1, 1, 7, 29, 13, 25, 225, 411, 171, 851, 1287, 4195, 14391, 3687}},
    {3152, 15, 11682, {1, 3, 1, 5, 11, 17, 3, 253, 113, 577, 1507, 1717, 6649, 6573, 10855}},
    {3153, 15, 11687, {1, 3, 7, 5, 3, 9, 121, 223, 151, 567, 1789, 4045, 4275, 11515, 563}},
    {3154, 15, 11696, {1, 1, 1, 13, 15, 5, 103, 247, 67, 861, 571, 4067, 4167, 10851, 25017}},
    {3155, 15, 11713, {1, 3, 5, 1, 17, 9, 49, 211, 259, 849, 865, 1885, 5441, 10727, 16049}},
    {3156, 15, 11728, {1, 1, 3, 15, 11, 29, 35, 39, 321, 785, 1111, 1799, 455, 9353, 7375}},
    {3157, 15, 11747, {1, 3, 7, 1, 27, 19, 1, 157, 301, 149, 163, 3755, 2031, 5329, 4443}},
    {3158, 15, 11750, {1, 1, 7, 3, 13, 39, 53, 243, 123, 1023, 595, 3527, 1749, 14113, 22533}},
    {3159, 15, 11754, {1, 1, 7, 5, 13, 37, 115, 241, 371, 17, 1603, 2851, 3451, 12883, 10171}},
    {3160, 15, 11759, {1, 1, 3, 1, 5, 13, 85, 237, 219, 539, 1731, 2373, 7467, 12153, 22473}},
    {3161, 15, 11761, {1, 3, 5, 3, 7, 43, 115, 79, 209, 41, 199, 2979, 5311, 11683, 3491}},
    {3162, 15, 11764, {1, 1, 5, 5, 31, 11, 5, 93, 293, 595, 1475, 1971, 6285, 3779, 22685}},
    {3163, 15, 11767, {1, 1, 5, 1, 5, 15, 43, 27, 379, 223, 1747, 3223, 1337, 14481, 24419}},
    {3164, 15, 11797, {1, 3, 1, 5, 19, 39, 21, 229, 53, 621, 1557, 4049, 4637, 1957, 5317}},
    {3165, 15, 11804, {1, 1, 3, 1, 7, 49, 29, 129, 93, 691, 841, 3997, 2843, 2261, 4681}},
    {3166, 15, 11808, {1, 3, 7, 3, 1, 63, 75, 209, 127, 965, 15, 367, 283, 3037, 24089}},
    {3167, 15, 11831, {1, 1, 7, 9, 7, 47, 37, 143, 207, 97, 75, 2009, 5, 14229, 1251}},
    {3168, 15, 11832, {1, 1, 1, 11, 7, 37, 13, 185, 191, 13, 101, 2403, 7659, 13153, 27547}},
    {3169, 15, 11849, {1, 1, 5, 13, 27, 5, 57, 179, 487, 555, 199, 2235, 5799, 7949, 30227}},
    {3170, 15, 11855, {1, 1, 7, 9, 13, 59, 63, 147, 99, 425, 819, 1175, 1779, 517, 30623}},
    {3171, 15, 11863, {1, 3, 5, 13, 9, 39, 39, 35, 453, 631, 343, 3839, 1553, 4179, 6547}},
    {3172, 15, 11880, {1, 1, 3, 11, 31, 53, 29, 57, 447, 555, 1801, 2075, 7103, 15525, 14255}},
    {3173, 15, 11883, {1, 1, 7, 7, 19, 41, 101, 245, 121, 317, 1357, 1213, 5871, 14163, 26787}},
    {3174, 15, 11885, {1, 3, 1, 13, 25, 31, 105, 41, 447, 409, 1273, 913, 4329, 16053, 7309}},
    {3175, 15, 11898, {1, 3, 1, 5, 3, 35, 105, 217, 161, 713, 1723, 937, 3043, 12469, 1901}},
    {3176, 15, 11916, {1, 3, 7, 1, 27, 35, 123, 245, 321, 389, 1869, 1637, 185, 1517, 10149}},
    {3177, 15, 11924, {1, 3, 1, 7, 7, 17, 3, 85, 149, 581, 883, 2837, 1467, 2871, 8077}},
    {3178, 15, 11928, {1, 1, 5, 3, 19, 1, 85, 253, 429, 1, 789, 3875, 3313, 13159, 3603}},
    {3179, 15, 11947, {1, 3, 1, 11, 29, 57, 83, 107, 93, 447, 1663, 789, 7553, 10023, 25589}},
    {3180, 15, 11955, {1, 3, 3, 15, 19, 41, 61, 255, 365, 235, 179, 2047, 1633, 16193, 25703}},
    {3181, 15, 11961, {1, 1, 1, 5, 15, 27, 67, 69, 491, 503, 1639, 1097, 5595, 7907, 14273}},
    {3182, 15, 11962, {1, 1, 1, 9, 7, 51, 99, 133, 103, 19, 383, 1401, 2143, 15153, 27949}},
    {3183, 15, 11982, {1, 1, 5, 13, 25, 3, 35, 171, 47, 521, 213, 1033, 3477, 4475, 4461}},
    {3184, 15, 11990, {1, 1, 5, 11, 19, 51, 59, 197, 301, 917, 689, 795, 1977, 5119, 32349}},
    {3185, 15, 12010, {1, 1, 3, 11, 3, 9, 119, 205, 493, 435, 1813, 701, 2647, 14021, 21791}},
    {3186, 15, 12018, {1, 3, 5, 9, 29, 43, 83, 23, 287, 17, 1935, 1739, 3195, 189, 7553}},
    {3187, 15, 12027, {1, 1, 1, 5, 9, 5, 43, 147, 183, 967, 499, 3089, 4747, 11893, 16607}},
    {3188, 15, 12029, {1, 1, 7, 13, 23, 41, 21, 93, 425, 381, 2029, 857, 7633, 10503, 16899}},
    {3189, 15, 12035, {1, 1, 7, 9, 31, 51, 59, 201, 389, 729, 1701, 2227, 4405, 11159, 5193}},
    {3190, 15, 12055, {1, 3, 7, 3, 1, 39, 101, 123, 315, 63, 1645, 2759, 4995, 10457, 23843}},
    {3191, 15, 12062, {1, 3, 7, 3, 27, 27, 105, 131, 53, 1023, 855, 2489, 1545, 3319, 23031}},
    {3192, 15, 12068, {1, 1, 7, 15, 9, 7, 59, 241, 345, 95, 773, 703, 937, 16041, 8069}},
    {3193, 15, 12071, {1, 1, 3, 13, 23, 3, 37, 255, 341, 83, 379, 2543, 3623, 4499, 31907}},
    {3194, 15, 12072, {1, 3, 5, 9, 9, 41, 99, 103, 409, 1013, 185, 3289, 2971, 3071, 5437}},
    {3195, 15, 12086, {1, 1, 3, 5, 3, 63, 75, 49, 403, 915, 1771, 1165, 7997, 5037, 303}},
    {3196, 15, 12097, {1, 3, 7, 3, 15, 49, 93, 225, 41, 391, 1589, 3605, 1757, 4637, 28377}},
    {3197, 15, 12098, {1, 3, 3, 3, 15, 63, 73, 237, 421, 119, 1767, 3051, 1273, 15717, 5321}},
    {3198, 15, 12100, {1, 3, 1, 5, 17, 63, 29, 65, 53, 823, 937, 1045, 2539, 7209, 30975}},
    {3199, 15, 12112, {1, 1, 7, 11, 23, 19, 119, 251, 217, 983, 915, 3255, 437, 2695, 9569}},
    {3200, 15, 12118, {1, 1, 7, 9, 23, 27, 51, 211, 229, 967, 1083, 1011, 655, 7289, 893}},
    {3201, 15, 12133, {1, 3, 5, 1, 15, 25, 107, 81, 357, 823, 2031, 2367, 2033, 9393, 18097}},
    {3202, 15, 12134, {1, 3, 5, 5, 23, 9, 35, 123, 379, 191, 941, 2103, 373, 12029, 26465}},
    {3203, 15, 12137, {1, 3, 5, 11, 3, 51, 97, 105, 79, 659, 731, 3115, 873, 16015, 25319}},
    {3204, 15, 12161, {1, 3, 3, 1, 27, 27, 87, 111, 469, 679, 411, 4037, 2351, 12297, 29383}},
    {3205, 15, 12162, {1, 3, 3, 13, 5, 63, 71, 231, 391, 873, 1783, 413, 7445, 14945, 13487}},
    {3206, 15, 12171, {1, 1, 1, 15, 3, 15, 11, 51, 411, 881, 1581, 1429, 4827, 4611, 6655}},
    {3207, 15, 12174, {1, 1, 5, 11, 31, 23, 29, 69, 371, 493, 1717, 2015, 7951, 14357, 32219}},
    {3208, 15, 12185, {1, 3, 3, 1, 5, 33, 117, 147, 115, 827, 1981, 1789, 117, 12293, 16383}},
    {3209, 15, 12204, {1, 3, 5, 7, 1, 33, 5, 125, 419, 189, 31, 3597, 4819, 8351, 5305}},
    {3210, 15, 12212, {1, 1, 3, 13, 9, 3, 53, 207, 211, 137, 733, 3777, 1421, 4939, 24115}},
    {3211, 15, 12215, {1, 3, 1, 5, 15, 41, 19, 199, 63, 909, 1847, 565, 4631, 9191, 12187}},
    {3212, 15, 12216, {1, 3, 5, 15, 11, 41, 115, 179, 403, 625, 791, 1973, 5097, 7827, 3667}},
    {3213, 15, 12253, {1, 3, 1, 15, 11, 51, 67, 177, 281, 169, 463, 2523, 6009, 14493, 32565}},
    {3214, 15, 12260, {1, 3, 1, 9, 15, 17, 67, 77, 423, 475, 951, 2187, 6137, 16365, 7699}},
    {3215, 15, 12277, {1, 1, 5, 3, 27, 9, 97, 31, 205, 475, 771, 1747, 421, 543, 547}},
    {3216, 15, 12289, {1, 3, 5, 15, 23, 27, 5, 13, 141, 93, 1415, 573, 6099, 6545, 1071}},
    {3217, 15, 12295, {1, 1, 5, 3, 11, 59, 73, 253, 249, 29, 1625, 3243, 1613, 5139, 26645}},
    {3218, 15, 12314, {1, 1, 7, 1, 15, 49, 81, 111, 267, 433, 1871, 415, 2727, 7819, 7965}},
    {3219, 15, 12323, {1, 1, 1, 1, 21, 7, 77, 219, 451, 319, 869, 2001, 6485, 1677, 14625}},
    {3220, 15, 12325, {1, 1, 7, 1, 29, 41, 63, 13, 351, 925, 2029, 2599, 5227, 12727, 18115}},
    {3221, 15, 12335, {1, 3, 3, 13, 3, 63, 11, 209, 459, 407, 1527, 375, 5349, 733, 16111}},
    {3222, 15, 12349, {1, 3, 7, 15, 19, 63, 91, 7, 45, 701, 2043, 1359, 1893, 10327, 32215}},
    {3223, 15, 12358, {1, 3, 7, 7, 5, 19, 75, 5, 437, 89, 1579, 2523, 2237, 14619, 8297}},
    {3224, 15, 12372, {1, 1, 7, 7, 17, 33, 17, 161, 11, 459, 1565, 3465, 293, 13099, 13997}},
    {3225, 15, 12376, {1, 1, 3, 11, 15, 7, 121, 51, 67, 391, 1553, 1817, 6503, 2907, 3611}},
    {3226, 15, 12379, {1, 3, 1, 5, 13, 13, 7, 233, 381, 945, 853, 3879, 2283, 9903, 26929}},
    {3227, 15, 12386, {1, 3, 5, 5, 23, 17, 107, 107, 361, 453, 1609, 1523, 3839, 8615, 30509}},
    {3228, 15, 12395, {1, 3, 7, 5, 5, 43, 79, 3, 169, 357, 649, 2083, 2733, 15785, 20213}},
    {3229, 15, 12416, {1, 1, 1, 9, 9, 19, 85, 71, 247, 3, 1167, 363, 1791, 8337, 15775}},
    {3230, 15, 12421, {1, 3, 1, 5, 5, 27, 11, 73, 75, 967, 969, 3377, 7113, 169, 22723}},
    {3231, 15, 12440, {1, 3, 1, 3, 21, 7, 71, 17, 15, 533, 1311, 3029, 4701, 15521, 26097}},
    {3232, 15, 12452, {1, 1, 1, 1, 29, 3, 71, 243, 255, 535, 501, 2877, 2395, 3635, 31309}},
    {3233, 15, 12455, {1, 3, 3, 3, 21, 11, 9, 65, 311, 323, 1757, 419, 295, 11763, 1827}},
    {3234, 15, 12456, {1, 3, 7, 5, 17, 3, 35, 225, 267, 799, 965, 1259, 4175, 7459, 12461}},
    {3235, 15, 12462, {1, 1, 5, 11, 5, 33, 83, 55, 111, 967, 165, 387, 6433, 2691, 7881}},
    {3236, 15, 12467, {1, 3, 1, 3, 13, 35, 113, 149, 443, 237, 1853, 1895, 3059, 7317, 22209}},
    {3237, 15, 12479, {1, 1, 1, 9, 9, 57, 71, 133, 249, 593, 15, 3655, 4969, 13633, 9537}},
    {3238, 15, 12505, {1, 3, 1, 7, 17, 21, 127, 87, 333, 389, 439, 191, 2749, 6265, 121}},
    {3239, 15, 12521, {1, 3, 3, 5, 23, 15, 123, 45, 421, 751, 1847, 651, 1899, 1063, 2067}},
    {3240, 15, 12535, {1, 3, 5, 15, 25, 31, 3, 9, 51, 397, 1365, 1547, 8095, 7327, 29095}},
    {3241, 15, 12547, {1, 3, 3, 7, 13, 3, 11, 107, 145, 561, 1921, 379, 955, 933, 7799}},
    {3242, 15, 12556, {1, 1, 1, 13, 5, 23, 63, 25, 509, 117, 2023, 163, 6321, 9559, 21613}},
    {3243, 15, 12561, {1, 3, 7, 7, 17, 59, 83, 103, 419, 781, 1635, 2525, 4523, 13621, 321}},
    {3244, 15, 12568, {1, 1, 5, 9, 15, 57, 107, 243, 459, 877, 177, 3691, 133, 8959, 27397}},
    {3245, 15, 12578, {1, 1, 1, 5, 13, 25, 73, 83, 85, 951, 1221, 2759, 2391, 2949, 10257}},
    {3246, 15, 12583, {1, 3, 1, 9, 29, 55, 39, 237, 313, 29, 657, 1705, 681, 15451, 16635}},
    {3247, 15, 12595, {1, 1, 5, 3, 5, 13, 47, 71, 509, 491, 1241, 3857, 417, 14591, 15405}},
    {3248, 15, 12604, {1, 3, 7, 5, 1, 17, 109, 87, 313, 901, 1847, 2461, 4355, 12703, 17329}},
    {3249, 15, 12610, {1, 3, 5, 1, 19, 29, 91, 73, 181, 119, 1025, 591, 3939, 7407, 22871}},
    {3250, 15, 12621, {1, 3, 7, 13, 3, 9, 127, 21, 89, 867, 1979, 2419, 6637, 9295, 20947}},
    {3251, 15, 12622, {1, 3, 1, 7, 11, 37, 7, 15, 371, 201, 2013, 2253, 7371, 1829, 25957}},
    {3252, 15, 12624, {1, 3, 3, 15, 29, 57, 27, 49, 477, 585, 1273, 553, 4493, 15137, 16673}},
    {3253, 15, 12629, {1, 1, 5, 1, 23, 37, 81, 169, 447, 285, 719, 153, 1991, 13285, 29811}},
    {3254, 15, 12630, {1, 3, 3, 11, 19, 39, 25, 93, 197, 929, 11, 2259, 1033, 4255, 6847}},
    {3255, 15, 12639, {1, 3, 7, 11, 25, 23, 5, 237, 37, 619, 805, 2435, 5659, 13465, 30715}},
    {3256, 15, 12640, {1, 3, 3, 13, 23, 51, 39, 253, 289, 821, 311, 115, 5583, 5739, 11041}},
    {3257, 15, 12650, {1, 1, 3, 7, 11, 39, 117, 235, 395, 247, 577, 429, 6543, 965, 30909}},
    {3258, 15, 12679, {1, 3, 7, 13, 25, 15, 121, 117, 239, 179, 1931, 1799, 4205, 4723, 12437}},
    {3259, 15, 12680, {1, 1, 1, 11, 11, 61, 65, 229, 189, 149, 361, 1457, 5585, 5727, 975}},
    {3260, 15, 12698, {1, 1, 5, 9, 5, 17, 87, 201, 431, 745, 771, 1133, 1873, 11177, 8367}},
    {3261, 15, 12716, {1, 3, 1, 7, 1, 57, 105, 75, 381, 207, 429, 2893, 6771, 11917, 24129}},
    {3262, 15, 12721, {1, 1, 7, 7, 1, 37, 95, 161, 7, 125, 1721, 2501, 7051, 6693, 31665}},
    {3263, 15, 12722, {1, 1, 5, 15, 5, 23, 81, 125, 161, 51, 1911, 3947, 3901, 3877, 18771}},
    {3264, 15, 12731, {1, 3, 5, 5, 17, 1, 25, 89, 477, 299, 583, 3005, 939, 9131, 21113}},
    {3265, 15, 12742, {1, 1, 3, 5, 11, 43, 29, 81, 71, 531, 277, 837, 4115, 79, 26265}},
    {3266, 15, 12745, {1, 3, 1, 15, 1, 7, 57, 189, 191, 251, 1767, 477, 1483, 12471, 23667}},
    {3267, 15, 12751, {1, 3, 5, 13, 29, 17, 11, 209, 27, 163, 519, 2275, 7617, 11903, 3699}},
    {3268, 15, 12759, {1, 3, 5, 3, 21, 13, 55, 201, 121, 629, 1461, 3689, 5069, 5293, 13665}},
    {3269, 15, 12763, {1, 3, 3, 3, 19, 55, 61, 23, 329, 259, 245, 1385, 1719, 13145, 26991}},
    {3270, 15, 12769, {1, 1, 5, 3, 1, 61, 85, 169, 425, 151, 1523, 787, 3107, 1, 16381}},
    {3271, 15, 12781, {1, 3, 5, 9, 25, 7, 7, 47, 25, 869, 1517, 2893, 6913, 2401, 17313}},
    {3272, 15, 12793, {1, 1, 5, 5, 11, 61, 9, 165, 361, 113, 449, 2267, 7955, 14419, 5089}},
    {3273, 15, 12799, {1, 3, 7, 9, 5, 3, 79, 23, 283, 67, 23, 3295, 7399, 4747, 24471}},
    {3274, 15, 12815, {1, 1, 5, 3, 25, 29, 25, 179, 47, 173, 41, 753, 4417, 5671, 7691}},
    {3275, 15, 12824, {1, 3, 5, 3, 3, 17, 81, 101, 423, 49, 1873, 361, 2431, 3485, 26039}},
    {3276, 15, 12836, {1, 1, 3, 7, 19, 55, 105, 89, 267, 589, 777, 3117, 2917, 16285, 9789}},
    {3277, 15, 12845, {1, 1, 3, 15, 13, 41, 71, 125, 509, 489, 1453, 963, 3259, 2619, 13277}},
    {3278, 15, 12853, {1, 3, 7, 7, 25, 23, 125, 63, 341, 115, 1693, 549, 675, 5179, 28313}},
    {3279, 15, 12854, {1, 1, 1, 5, 3, 47, 73, 171, 75, 113, 1663, 2135, 5327, 13717, 10291}},
    {3280, 15, 12857, {1, 3, 7, 1, 7, 29, 49, 5, 435, 771, 335, 1435, 8115, 16043, 23303}},
    {3281, 15, 12866, {1, 3, 3, 13, 7, 15, 37, 51, 429, 507, 441, 2935, 4951, 1833, 31475}},
    {3282, 15, 12872, {1, 1, 3, 3, 29, 27, 27, 91, 321, 547, 729, 3335, 943, 1659, 21671}},
    {3283, 15, 12875, {1, 1, 1, 9, 21, 3, 77, 161, 143, 475, 1049, 4073, 3179, 6173, 27811}},
    {3284, 15, 12878, {1, 3, 7, 5, 11, 39, 65, 55, 63, 159, 1733, 1493, 7803, 13123, 19947}},
    {3285, 15, 12880, {1, 3, 7, 7, 29, 15, 71, 151, 375, 9, 1631, 2759, 5599, 5595, 21751}},
    {3286, 15, 12885, {1, 3, 5, 15, 3, 9, 65, 223, 105, 981, 1443, 1849, 5189, 2761, 6457}},
    {3287, 15, 12901, {1, 1, 5, 11, 3, 49, 111, 247, 317, 33, 1605, 3961, 6185, 14955, 32335}},
    {3288, 15, 12902, {1, 1, 3, 7, 21, 17, 127, 247, 105, 839, 331, 1593, 5063, 9053, 16417}},
    {3289, 15, 12920, {1, 3, 5, 5, 19, 37, 27, 167, 337, 991, 1695, 1823, 799, 11055, 11847}},
    {3290, 15, 12926, {1, 1, 7, 3, 3, 27, 85, 83, 215, 67, 1577, 2221, 7557, 3663, 31023}},
    {3291, 15, 12929, {1, 1, 7, 7, 31, 29, 51, 175, 367, 17, 469, 2263, 3399, 2093, 19563}},
    {3292, 15, 12939, {1, 3, 5, 15, 29, 57, 81, 131, 35, 219, 1717, 3267, 5047, 14411, 11669}},
    {3293, 15, 12941, {1, 1, 3, 3, 17, 25, 83, 197, 91, 771, 2037, 1677, 6515, 6719, 7525}},
    {3294, 15, 12950, {1, 3, 3, 13, 19, 11, 3, 153, 93, 307, 1119, 635, 2591, 14055, 25677}},
    {3295, 15, 12953, {1, 3, 7, 3, 19, 11, 69, 157, 367, 145, 399, 3891, 5913, 11603, 11107}},
    {3296, 15, 12992, {1, 1, 3, 9, 11, 9, 75, 53, 7, 427, 1077, 1569, 4323, 8151, 14233}},
    {3297, 15, 13002, {1, 1, 3, 1, 5, 45, 79, 201, 43, 131, 1631, 477, 5081, 5691, 8841}},
    {3298, 15, 13010, {1, 1, 5, 13, 13, 5, 85, 251, 279, 1011, 783, 201, 923, 8059, 30235}},
    {3299, 15, 13058, {1, 3, 3, 9, 1, 11, 35, 249, 449, 433, 1731, 2853, 6177, 2805, 28223}},
    {3300, 15, 13072, {1, 3, 5, 15, 7, 47, 13, 1, 35, 239, 1361, 2209, 919, 11293, 2079}},
    {3301, 15, 13084, {1, 1, 7, 5, 7, 15, 79, 111, 431, 461, 1715, 1589, 1121, 7171, 11911}},
    {3302, 15, 13087, {1, 3, 3, 1, 3, 11, 29, 231, 429, 645, 179, 2971, 2113, 6939, 24373}},
    {3303, 15, 13091, {1, 1, 5, 13, 3, 61, 119, 199, 93, 567, 1147, 3919, 4697, 7325, 14761}},
    {3304, 15, 13097, {1, 1, 3, 9, 31, 35, 49, 249, 435, 837, 1817, 3597, 6925, 13485, 2175}},
    {3305, 15, 13108, {1, 3, 7, 15, 27, 31, 31, 19, 469, 331, 857, 3889, 4373, 13127, 2763}},
    {3306, 15, 13123, {1, 3, 7, 3, 31, 37, 33, 225, 53, 597, 1305, 893, 6751, 14411, 125}},
    {3307, 15, 13149, {1, 3, 5, 15, 29, 25, 105, 7, 223, 275, 1635, 615, 847, 2801, 26627}},
    {3308, 15, 13150, {1, 1, 1, 3, 11, 33, 109, 67, 331, 933, 343, 1353, 4139, 9423, 21705}},
    {3309, 15, 13163, {1, 3, 5, 11, 23, 3, 127, 31, 287, 97, 1713, 1823, 1067, 5567, 6913}},
    {3310, 15, 13166, {1, 1, 1, 7, 21, 21, 21, 115, 211, 451, 711, 2725, 337, 15149, 19467}},
    {3311, 15, 13178, {1, 3, 3, 11, 19, 63, 59, 219, 29, 657, 179, 977, 5579, 9809, 12723}},
    {3312, 15, 13180, {1, 3, 3, 9, 17, 1, 73, 55, 309, 381, 1541, 1833, 6855, 10505, 8667}},
    {3313, 15, 13184, {1, 3, 5, 3, 3, 51, 91, 29, 223, 707, 1413, 3255, 6101, 9241, 30331}},
    {3314, 15, 13204, {1, 1, 7, 15, 11, 23, 61, 37, 201, 281, 1869, 813, 161, 835, 18705}},
    {3315, 15, 13238, {1, 3, 3, 15, 31, 41, 67, 67, 417, 645, 765, 1807, 409, 9727, 27081}},
    {3316, 15, 13242, {1, 1, 5, 1, 9, 47, 75, 229, 83, 987, 1695, 399, 5147, 9055, 13813}},
    {3317, 15, 13249, {1, 1, 7, 13, 17, 63, 87, 243, 207, 127, 775, 1529, 4387, 10987, 25747}},
    {3318, 15, 13255, {1, 1, 1, 11, 25, 5, 93, 219, 55, 239, 2013, 1499, 703, 13953, 3663}},
    {3319, 15, 13269, {1, 3, 7, 15, 11, 55, 29, 129, 23, 341, 1567, 731, 3035, 3897, 143}},
    {3320, 15, 13270, {1, 3, 7, 1, 19, 15, 39, 171, 345, 277, 23, 473, 3921, 4431, 25213}},
    {3321, 15, 13274, {1, 1, 7, 3, 3, 61, 127, 203, 477, 173, 1147, 3089, 3379, 11171, 2817}},
    {3322, 15, 13285, {1, 1, 7, 9, 3, 57, 15, 255, 461, 365, 1795, 1781, 7569, 2561, 751}},
    {3323, 15, 13289, {1, 1, 1, 3, 7, 23, 65, 41, 21, 483, 1649, 2619, 7313, 12331, 22669}},
    {3324, 15, 13298, {1, 3, 3, 13, 11, 43, 13, 131, 17, 477, 83, 3427, 903, 9273, 13495}},
    {3325, 15, 13307, {1, 3, 3, 5, 27, 55, 41, 5, 305, 203, 1659, 2433, 511, 191, 30321}},
    {3326, 15, 13312, {1, 3, 1, 7, 23, 17, 79, 91, 451, 555, 1653, 709, 3371, 1091, 16391}},
    {3327, 15, 13335, {1, 1, 3, 7, 3, 55, 23, 167, 421, 327, 557, 707, 4785, 55, 19421}},
    {3328, 15, 13345, {1, 1, 1, 5, 5, 53, 117, 59, 221, 991, 1143, 643, 5477, 7115, 3109}},
    {3329, 15, 13357, {1, 1, 7, 13, 15, 5, 9, 73, 21, 79, 443, 3565, 7917, 4227, 32683}},
    {3330, 15, 13366, {1, 1, 1, 5, 9, 57, 75, 47, 99, 775, 1631, 109, 1345, 13907, 14963}},
    {3331, 15, 13372, {1, 3, 5, 15, 13, 45, 111, 249, 367, 611, 487, 207, 5323, 6541, 22181}},
    {3332, 15, 13380, {1, 1, 1, 11, 1, 23, 3, 229, 485, 127, 19, 2963, 7585, 4011, 23575}},
    {3333, 15, 13384, {1, 1, 3, 7, 23, 33, 99, 5, 387, 455, 1619, 765, 2491, 10037, 6341}},
    {3334, 15, 13395, {1, 3, 3, 11, 23, 47, 127, 145, 93, 827, 839, 1685, 5769, 13907, 21405}},
    {3335, 15, 13407, {1, 1, 3, 3, 31, 35, 101, 103, 233, 383, 443, 2865, 3947, 5799, 9987}},
    {3336, 15, 13408, {1, 3, 5, 15, 17, 63, 45, 213, 113, 601, 1743, 871, 547, 12265, 19687}},
    {3337, 15, 13413, {1, 1, 3, 3, 31, 55, 15, 205, 139, 621, 249, 2435, 7675, 5541, 32711}},
    {3338, 15, 13414, {1, 1, 5, 3, 19, 57, 27, 25, 41, 871, 1017, 3549, 179, 8057, 29273}},
    {3339, 15, 13417, {1, 1, 1, 7, 7, 17, 59, 177, 193, 503, 43, 3635, 1715, 1149, 29723}},
    {3340, 15, 13437, {1, 3, 3, 15, 9, 63, 49, 189, 39, 993, 1237, 3787, 4845, 5799, 30549}},
    {3341, 15, 13441, {1, 3, 1, 5, 29, 35, 9, 217, 211, 703, 2033, 3475, 6067, 14239, 13375}},
    {3342, 15, 13447, {1, 3, 5, 7, 5, 5, 35, 115, 181, 1015, 623, 201, 6101, 343, 14465}},
    {3343, 15, 13456, {1, 1, 7, 7, 27, 25, 117, 199, 349, 377, 497, 2877, 2523, 14011, 31365}},
    {3344, 15, 13459, {1, 1, 3, 11, 27, 9, 15, 17, 441, 823, 1657, 3727, 6159, 1003, 22695}},
    {3345, 15, 13461, {1, 1, 7, 9, 13, 15, 87, 255, 367, 467, 1651, 875, 5425, 1241, 1807}},
    {3346, 15, 13466, {1, 3, 1, 15, 13, 29, 71, 101, 127, 245, 901, 2937, 7947, 9347, 3461}},
    {3347, 15, 13484, {1, 3, 3, 1, 11, 35, 123, 163, 181, 505, 1723, 2671, 7247, 3725, 11847}},
    {3348, 15, 13487, {1, 1, 3, 1, 19, 1, 39, 17, 507, 949, 275, 2499, 6349, 4885, 21875}},
    {3349, 15, 13489, {1, 3, 3, 15, 3, 9, 117, 177, 257, 627, 1699, 2071, 593, 16135, 3281}},
    {3350, 15, 13492, {1, 3, 5, 5, 17, 39, 99, 121, 237, 405, 221, 3155, 8109, 6655, 10499}},
    {3351, 15, 13496, {1, 1, 7, 1, 15, 25, 21, 83, 75, 737, 2011, 1213, 4051, 14691, 9403}},
    {3352, 15, 13510, {1, 3, 5, 1, 21, 9, 51, 29, 5, 847, 1729, 2787, 977, 15331, 4959}},
    {3353, 15, 13531, {1, 3, 3, 15, 15, 33, 61, 113, 403, 123, 1575, 685, 3845, 15863, 11419}},
    {3354, 15, 13538, {1, 3, 1, 13, 7, 47, 109, 195, 325, 77, 1441, 2683, 6215, 4829, 20495}},
    {3355, 15, 13543, {1, 1, 3, 1, 1, 11, 7, 149, 69, 327, 519, 3929, 7765, 6403, 1859}},
    {3356, 15, 13547, {1, 1, 3, 5, 11, 49, 95, 49, 31, 411, 1731, 1777, 4199, 183, 10801}},
    {3357, 15, 13572, {1, 1, 3, 9, 1, 27, 113, 119, 97, 621, 741, 2897, 6071, 8735, 3097}},
    {3358, 15, 13581, {1, 1, 3, 3, 7, 45, 13, 199, 329, 57, 189, 639, 7403, 14895, 4249}},
    {3359, 15, 13590, {1, 3, 7, 3, 17, 55, 109, 21, 227, 65, 793, 2107, 1427, 14685, 10911}},
    {3360, 15, 13605, {1, 1, 1, 1, 13, 3, 125, 105, 39, 355, 1307, 1081, 1737, 141, 4061}},
    {3361, 15, 13612, {1, 3, 1, 9, 17, 61, 51, 139, 117, 205, 701, 799, 7, 4789, 16503}},
    {3362, 15, 13624, {1, 1, 1, 5, 13, 61, 125, 175, 357, 821, 1181, 3717, 325, 8059, 20915}},
    {3363, 15, 13630, {1, 3, 5, 7, 3, 43, 61, 195, 315, 895, 1149, 239, 3107, 8031, 25841}},
    {3364, 15, 13632, {1, 3, 1, 5, 15, 7, 67, 65, 461, 615, 1963, 3221, 6483, 10805, 19077}},
    {3365, 15, 13638, {1, 1, 1, 7, 19, 13, 121, 171, 131, 891, 137, 2945, 2627, 9259, 15471}},
    {3366, 15, 13661, {1, 3, 3, 13, 5, 47, 115, 135, 267, 655, 1151, 1577, 957, 2011, 12981}},
    {3367, 15, 13665, {1, 1, 7, 5, 27, 63, 51, 109, 85, 1009, 379, 2205, 7199, 313, 26741}},
    {3368, 15, 13668, {1, 3, 3, 11, 1, 43, 93, 255, 295, 327, 1609, 2113, 5291, 6073, 5895}},
    {3369, 15, 13686, {1, 3, 1, 9, 17, 57, 57, 163, 431, 773, 561, 1131, 6675, 775, 2341}},
    {3370, 15, 13699, {1, 3, 5, 3, 9, 25, 119, 241, 185, 101, 575, 2013, 5259, 1085, 24403}},
    {3371, 15, 13701, {1, 3, 1, 15, 27, 1, 23, 157, 131, 569, 183, 3593, 3265, 12391, 1329}},
    {3372, 15, 13708, {1, 1, 3, 1, 1, 47, 63, 179, 467, 481, 365, 579, 4687, 4857, 32269}},
    {3373, 15, 13716, {1, 3, 1, 13, 15, 5, 101, 81, 93, 639, 25, 809, 5695, 15821, 10685}},
    {3374, 15, 13725, {1, 1, 3, 15, 5, 57, 59, 203, 345, 617, 1111, 4011, 5139, 13409, 11797}},
    {3375, 15, 13730, {1, 1, 7, 7, 11, 33, 93, 75, 381, 245, 225, 3041, 3837, 12707, 20347}},
    {3376, 15, 13742, {1, 1, 7, 3, 1, 53, 109, 205, 199, 285, 1155, 3559, 1383, 809, 4117}},
    {3377, 15, 13747, {1, 3, 3, 15, 13, 7, 9, 211, 93, 305, 1303, 957, 3923, 12599, 30465}},
    {3378, 15, 13749, {1, 3, 3, 1, 17, 29, 69, 251, 17, 245, 1793, 2639, 3839, 487, 2601}},
    {3379, 15, 13753, {1, 1, 7, 15, 11, 55, 125, 129, 405, 777, 1129, 2223, 715, 15821, 29349}},
    {3380, 15, 13754, {1, 3, 7, 1, 21, 13, 115, 103, 303, 775, 1989, 3909, 171, 7265, 17043}},
    {3381, 15, 13771, {1, 3, 7, 13, 11, 3, 9, 197, 9, 303, 861, 2413, 7931, 14345, 28495}},
    {3382, 15, 13773, {1, 1, 3, 15, 15, 37, 113, 159, 395, 797, 1101, 597, 1479, 4747, 12999}},
    {3383, 15, 13782, {1, 3, 5, 7, 23, 27, 19, 71, 259, 577, 1811, 2519, 7673, 10947, 20763}},
    {3384, 15, 13785, {1, 1, 1, 11, 9, 13, 19, 179, 113, 771, 1539, 2407, 199, 8577, 2551}},
    {3385, 15, 13798, {1, 3, 1, 7, 13, 23, 17, 15, 481, 821, 851, 841, 7353, 14837, 29761}},
    {3386, 15, 13802, {1, 3, 3, 9, 9, 61, 29, 143, 491, 593, 613, 3133, 8005, 297, 2081}},
    {3387, 15, 13809, {1, 1, 3, 5, 25, 53, 79, 241, 445, 847, 1305, 2823, 1135, 12673, 18695}},
    {3388, 15, 13828, {1, 3, 5, 11, 17, 53, 105, 159, 375, 587, 369, 3105, 5379, 11481, 5503}},
    {3389, 15, 13832, {1, 1, 1, 11, 31, 37, 109, 253, 331, 859, 1715, 3773, 1367, 155, 15617}},
    {3390, 15, 13840, {1, 3, 1, 3, 31, 57, 27, 197, 479, 787, 799, 19, 5143, 3781, 11817}},
    {3391, 15, 13850, {1, 3, 7, 15, 27, 31, 39, 179, 135, 877, 611, 3383, 7531, 4343, 12355}},
    {3392, 15, 13861, {1, 1, 1, 9, 19, 11, 65, 241, 299, 419, 1209, 2847, 593, 3529, 16393}},
    {3393, 15, 13874, {1, 1, 3, 5, 13, 5, 99, 61, 27, 95, 1309, 3667, 6691, 8369, 25361}},
    {3394, 15, 13876, {1, 1, 1, 3, 25, 37, 127, 237, 115, 671, 1237, 2537, 7795, 743, 21043}},
    {3395, 15, 13886, {1, 1, 7, 11, 23, 19, 83, 221, 145, 713, 1395, 1739, 879, 15355, 11015}},
    {3396, 15, 13897, {1, 1, 7, 15, 21, 27, 49, 225, 183, 107, 1347, 2269, 6757, 7913, 2575}},
    {3397, 15, 13900, {1, 1, 7, 15, 3, 55, 79, 51, 389, 729, 143, 435, 5183, 7689, 31051}},
    {3398, 15, 13915, {1, 1, 1, 7, 17, 15, 11, 197, 345, 939, 1481, 3887, 6917, 5299, 28123}},
    {3399, 15, 13927, {1, 1, 7, 5, 29, 11, 45, 125, 341, 21, 477, 3339, 5439, 12841, 31639}},
    {3400, 15, 13951, {1, 1, 1, 3, 31, 37, 21, 37, 479, 981, 765, 2301, 8011, 10839, 505}},
    {3401, 15, 13955, {1, 3, 7, 15, 15, 13, 3, 29, 399, 617, 1165, 3509, 7757, 5769, 13463}},
    {3402, 15, 13962, {1, 3, 1, 11, 25, 63, 83, 23, 19, 387, 595, 283, 807, 133, 20305}},
    {3403, 15, 13969, {1, 1, 7, 9, 3, 63, 125, 47, 23, 539, 459, 467, 6873, 5995, 8887}},
    {3404, 15, 13979, {1, 1, 1, 13, 13, 13, 69, 157, 183, 709, 427, 2545, 8065, 3, 6493}},
    {3405, 15, 13988, {1, 1, 5, 11, 11, 57, 123, 73, 187, 393, 1291, 4061, 5655, 4347, 10671}},
    {3406, 15, 13998, {1, 1, 5, 13, 17, 63, 59, 153, 483, 415, 1033, 3757, 6029, 1627, 19327}},
    {3407, 15, 14000, {1, 1, 3, 1, 21, 49, 53, 41, 239, 499, 933, 3775, 7423, 11755, 14931}},
    {3408, 15, 14005, {1, 3, 3, 15, 9, 11, 3, 169, 465, 359, 395, 629, 3503, 2017, 693}},
    {3409, 15, 14027, {1, 3, 3, 1, 3, 23, 7, 23, 55, 23, 223, 2855, 8047, 7375, 9341}},
    {3410, 15, 14037, {1, 3, 7, 9, 7, 11, 79, 251, 89, 843, 483, 1951, 323, 10829, 32603}},
    {3411, 15, 14051, {1, 3, 7, 11, 15, 13, 29, 77, 283, 825, 1469, 1413, 2955, 13037, 16485}},
    {3412, 15, 14054, {1, 3, 1, 13, 7, 43, 43, 33, 367, 505, 809, 789, 7395, 331, 23435}},
    {3413, 15, 14060, {1, 1, 3, 1, 13, 43, 61, 237, 369, 129, 1903, 2495, 6187, 2245, 6687}},
    {3414, 15, 14063, {1, 1, 3, 15, 27, 33, 41, 187, 401, 807, 1699, 2395, 6263, 8571, 25521}},
    {3415, 15, 14071, {1, 1, 1, 13, 19, 5, 113, 147, 347, 61, 1579, 3249, 137, 13465, 19903}},
    {3416, 15, 14078, {1, 1, 7, 7, 17, 53, 33, 49, 399, 669, 1541, 2267, 4705, 3983, 21867}},
    {3417, 15, 14080, {1, 3, 7, 1, 21, 55, 123, 77, 421, 111, 363, 2703, 3253, 1263, 5161}},
    {3418, 15, 14085, {1, 1, 7, 9, 25, 37, 39, 159, 437, 1, 1831, 3263, 2697, 5103, 10565}},
    {3419, 15, 14086, {1, 1, 3, 1, 1, 39, 51, 91, 435, 89, 1683, 3205, 5219, 12709, 25915}},
    {3420, 15, 14095, {1, 3, 5, 1, 3, 7, 55, 245, 251, 63, 1243, 2005, 359, 1499, 21551}},
    {3421, 15, 14138, {1, 1, 1, 5, 3, 35, 53, 121, 69, 179, 987, 5, 5429, 14145, 16103}},
    {3422, 15, 14145, {1, 3, 3, 11, 11, 61, 105, 99, 181, 657, 1737, 945, 529, 1063, 11681}},
    {3423, 15, 14158, {1, 1, 5, 3, 29, 35, 23, 11, 29, 769, 489, 3927, 3583, 7221, 19567}},
    {3424, 15, 14166, {1, 3, 1, 9, 31, 19, 125, 211, 457, 725, 1049, 1483, 6621, 13843, 27293}},
    {3425, 15, 14179, {1, 3, 1, 15, 3, 45, 61, 101, 29, 99, 259, 1817, 2401, 7515, 5025}},
    {3426, 15, 14181, {1, 3, 1, 5, 17, 51, 37, 29, 259, 133, 1745, 2203, 2059, 443, 7129}},
    {3427, 15, 14188, {1, 1, 3, 3, 29, 35, 99, 189, 249, 693, 1721, 3979, 5459, 3067, 4537}},
    {3428, 15, 14193, {1, 1, 5, 7, 15, 39, 71, 121, 213, 153, 501, 2275, 3011, 3935, 23501}},
    {3429, 15, 14200, {1, 1, 1, 13, 11, 57, 103, 37, 375, 253, 1605, 117, 2597, 6523, 20585}},
    {3430, 15, 14203, {1, 3, 3, 13, 27, 17, 87, 23, 389, 875, 193, 1813, 5437, 12251, 6443}},
    {3431, 15, 14215, {1, 3, 3, 9, 29, 27, 127, 183, 339, 149, 1161, 3519, 3381, 13363, 10591}},
    {3432, 15, 14224, {1, 1, 3, 7, 5, 11, 79, 225, 229, 711, 1971, 1223, 5995, 14821, 1565}},
    {3433, 15, 14230, {1, 1, 5, 3, 17, 13, 121, 225, 213, 141, 1621, 1795, 4763, 4601, 22821}},
    {3434, 15, 14233, {1, 1, 3, 11, 1, 19, 93, 127, 147, 237, 265, 1671, 6495, 12897, 27597}},
    {3435, 15, 14236, {1, 1, 7, 5, 15, 5, 79, 113, 205, 371, 193, 3165, 2861, 875, 18481}},
    {3436, 15, 14246, {1, 3, 5, 11, 3, 29, 5, 111, 89, 953, 1979, 3063, 5971, 3959, 5527}},
    {3437, 15, 14267, {1, 1, 5, 3, 3, 49, 85, 19, 211, 239, 267, 1977, 7895, 13759, 3611}},
    {3438, 15, 14282, {1, 1, 7, 13, 31, 9, 25, 161, 481, 225, 1217, 311, 3737, 10713, 6065}},
    {3439, 15, 14287, {1, 1, 1, 9, 7, 53, 119, 65, 315, 427, 279, 3497, 7599, 12671, 11727}},
    {3440, 15, 14301, {1, 1, 1, 13, 13, 13, 99, 11, 199, 709, 837, 3277, 1679, 3857, 19113}},
    {3441, 15, 14323, {1, 1, 1, 1, 11, 51, 83, 3, 65, 223, 735, 3021, 1293, 14661, 8479}},
    {3442, 15, 14325, {1, 3, 3, 7, 21, 23, 109, 27, 41, 441, 1393, 3253, 7767, 15249, 21309}},
    {3443, 15, 14329, {1, 3, 1, 9, 21, 17, 3, 65, 361, 863, 981, 1741, 4727, 7333, 969}},
    {3444, 15, 14339, {1, 3, 5, 15, 15, 3, 115, 237, 17, 235, 679, 871, 2985, 253, 22335}},
    {3445, 15, 14342, {1, 3, 5, 1, 9, 11, 113, 111, 297, 587, 2037, 3759, 3755, 9355, 16709}},
    {3446, 15, 14351, {1, 3, 7, 15, 15, 47, 111, 53, 501, 961, 835, 2213, 675, 4283, 16025}},
    {3447, 15, 14356, {1, 3, 3, 13, 25, 61, 117, 241, 25, 165, 1343, 2893, 717, 12993, 323}},
    {3448, 15, 14359, {1, 1, 5, 9, 21, 29, 59, 59, 13, 219, 693, 297, 6417, 6409, 25461}},
    {3449, 15, 14370, {1, 1, 7, 9, 27, 11, 93, 243, 243, 321, 369, 1161, 1021, 15509, 28845}},
    {3450, 15, 14402, {1, 3, 1, 3, 1, 39, 113, 199, 291, 897, 1519, 1341, 5259, 15907, 26243}},
    {3451, 15, 14411, {1, 1, 3, 15, 31, 5, 37, 103, 387, 765, 2035, 2081, 443, 6349, 16465}},
    {3452, 15, 14421, {1, 3, 3, 1, 1, 17, 37, 39, 165, 521, 853, 3887, 4697, 3069, 3763}},
    {3453, 15, 14431, {1, 3, 1, 11, 27, 43, 81, 211, 219, 797, 67, 1635, 1753, 14023, 20965}},
    {3454, 15, 14435, {1, 3, 5, 13, 3, 23, 77, 59, 21, 173, 1725, 4017, 3731, 6921, 6827}},
    {3455, 15, 14442, {1, 3, 1, 1, 9, 55, 99, 93, 331, 221, 1505, 3173, 629, 9779, 21331}},
    {3456, 15, 14447, {1, 3, 7, 15, 31, 41, 115, 245, 69, 835, 433, 2477, 345, 6949, 14347}},
    {3457, 15, 14456, {1, 3, 3, 15, 19, 39, 87, 187, 379, 263, 1789, 3659, 4251, 12437, 19869}},
    {3458, 15, 14459, {1, 3, 7, 15, 11, 23, 127, 169, 105, 987, 1453, 663, 3691, 12293, 17701}},
    {3459, 15, 14472, {1, 3, 7, 1, 31, 35, 43, 205, 417, 323, 1849, 2417, 981, 653, 26025}},
    {3460, 15, 14477, {1, 3, 1, 13, 1, 33, 47, 25, 225, 441, 871, 2863, 827, 3163, 2121}},
    {3461, 15, 14490, {1, 1, 3, 5, 11, 3, 105, 227, 487, 403, 107, 3755, 4529, 809, 21961}},
    {3462, 15, 14496, {1, 3, 3, 13, 31, 9, 115, 107, 271, 909, 1603, 2507, 7559, 15459, 9161}},
    {3463, 15, 14501, {1, 3, 7, 9, 25, 15, 63, 239, 109, 109, 1559, 3515, 349, 337, 25627}},
    {3464, 15, 14505, {1, 3, 1, 15, 17, 53, 41, 105, 163, 885, 527, 3745, 2217, 1221, 16231}},
    {3465, 15, 14513, {1, 3, 3, 3, 15, 21, 7, 211, 363, 301, 1553, 485, 6139, 9201, 21753}},
    {3466, 15, 14520, {1, 3, 3, 1, 31, 39, 31, 167, 287, 479, 245, 1897, 1537, 3541, 26763}},
    {3467, 15, 14534, {1, 3, 7, 13, 5, 35, 115, 59, 459, 825, 463, 3307, 2935, 423, 31627}},
    {3468, 15, 14562, {1, 1, 1, 1, 13, 17, 101, 175, 49, 441, 1491, 1857, 7761, 9541, 16583}},
    {3469, 15, 14576, {1, 3, 7, 13, 7, 15, 47, 195, 125, 355, 1515, 647, 1077, 8997, 3929}},
    {3470, 15, 14579, {1, 3, 1, 7, 17, 7, 5, 57, 459, 803, 1483, 505, 8055, 15151, 30565}},
    {3471, 15, 14585, {1, 3, 7, 15, 23, 27, 87, 51, 505, 521, 481, 2173, 7117, 2441, 17279}},
    {3472, 15, 14586, {1, 1, 5, 15, 5, 25, 91, 175, 241, 57, 1519, 2965, 2637, 8793, 10739}},
    {3473, 15, 14606, {1, 1, 5, 11, 27, 31, 113, 207, 179, 351, 293, 753, 1713, 16041, 24945}},
    {3474, 15, 14627, {1, 1, 7, 5, 29, 57, 53, 171, 327, 627, 1749, 1445, 7637, 8827, 11975}},
    {3475, 15, 14630, {1, 1, 1, 9, 21, 15, 93, 139, 179, 923, 1135, 2443, 6297, 8311, 6603}},
    {3476, 15, 14634, {1, 1, 7, 5, 19, 49, 19, 121, 479, 673, 2025, 3749, 6519, 6835, 8215}},
    {3477, 15, 14636, {1, 3, 7, 3, 21, 47, 41, 197, 1, 67, 1627, 2231, 5047, 8441, 26437}},
    {3478, 15, 14647, {1, 3, 3, 5, 27, 61, 33, 193, 431, 233, 1001, 2499, 689, 13103, 21993}},
    {3479, 15, 14653, {1, 3, 5, 15, 25, 13, 3, 185, 23, 181, 1953, 3329, 6161, 1133, 14353}},
    {3480, 15, 14659, {1, 3, 1, 1, 1, 31, 105, 33, 417, 583, 1167, 2217, 4767, 1315, 8237}},
    {3481, 15, 14671, {1, 3, 1, 1, 5, 3, 93, 5, 331, 875, 503, 1273, 8129, 1359, 23567}},
    {3482, 15, 14674, {1, 3, 1, 11, 19, 57, 25, 195, 255, 383, 1743, 1979, 3769, 10647, 25661}},
    {3483, 15, 14701, {1, 3, 3, 15, 21, 23, 49, 249, 95, 981, 1501, 1995, 6409, 14993, 26607}},
    {3484, 15, 14716, {1, 3, 1, 7, 9, 41, 105, 223, 163, 37, 829, 3635, 3757, 6623, 23397}},
    {3485, 15, 14719, {1, 3, 5, 3, 1, 45, 123, 21, 335, 207, 1531, 2433, 6883, 9487, 29581}},
    {3486, 15, 14720, {1, 3, 7, 7, 29, 33, 119, 237, 241, 931, 1229, 2777, 6457, 1895, 16029}},
    {3487, 15, 14725, {1, 3, 5, 9, 11, 27, 115, 213, 91, 753, 883, 435, 3905, 13909, 2317}},
    {3488, 15, 14730, {1, 3, 3, 13, 1, 9, 31, 31, 435, 805, 1299, 1933, 5151, 6259, 31221}},
    {3489, 15, 14743, {1, 3, 3, 9, 23, 55, 25, 243, 57, 513, 137, 1445, 393, 10399, 13401}},
    {3490, 15, 14747, {1, 3, 5, 5, 9, 53, 13, 1, 395, 973, 1763, 3011, 1169, 1161, 4949}},
    {3491, 15, 14786, {1, 1, 7, 13, 29, 61, 63, 159, 397, 249, 1297, 2251, 4185, 5353, 10237}},
    {3492, 15, 14788, {1, 3, 1, 13, 25, 57, 7, 187, 65, 405, 403, 1491, 1967, 4455, 26325}},
    {3493, 15, 14792, {1, 3, 5, 3, 29, 23, 19, 221, 109, 121, 563, 3209, 189, 6769, 1461}},
    {3494, 15, 14795, {1, 1, 7, 11, 13, 33, 49, 103, 315, 377, 977, 3931, 2661, 11451, 15235}},
    {3495, 15, 14809, {1, 1, 5, 9, 23, 61, 125, 93, 507, 709, 727, 1331, 2495, 9357, 15559}},
    {3496, 15, 14831, {1, 3, 5, 1, 17, 63, 99, 225, 9, 645, 37, 4035, 883, 7547, 9331}},
    {3497, 15, 14834, {1, 1, 7, 11, 9, 21, 45, 243, 383, 601, 1369, 1137, 6971, 11069, 5451}},
    {3498, 15, 14850, {1, 3, 3, 7, 13, 21, 73, 195, 307, 983, 417, 2809, 5427, 10907, 24397}},
    {3499, 15, 14855, {1, 1, 3, 1, 31, 61, 45, 87, 427, 517, 651, 2153, 4159, 13213, 15289}},
    {3500, 15, 14859, {1, 3, 7, 1, 11, 51, 11, 203, 67, 603, 1425, 399, 4509, 16015, 3149}},
    {3501, 15, 14864, {1, 3, 5, 5, 11, 59, 73, 175, 165, 893, 863, 1295, 1757, 6737, 20641}},
    {3502, 15, 14876, {1, 1, 1, 15, 19, 29, 45, 69, 177, 533, 1107, 1627, 1075, 1379, 18667}},
    {3503, 15, 14889, {1, 3, 7, 7, 3, 35, 59, 101, 129, 683, 1457, 1995, 2773, 14995, 1295}},
    {3504, 15, 14890, {1, 3, 1, 7, 21, 9, 101, 51, 229, 437, 917, 1947, 4557, 6371, 20199}},
    {3505, 15, 14898, {1, 3, 1, 3, 31, 5, 29, 121, 361, 465, 1393, 1291, 3947, 13431, 13381}},
    {3506, 15, 14909, {1, 1, 5, 11, 27, 17, 11, 25, 441, 757, 1307, 2655, 6093, 11051, 21047}},
    {3507, 15, 14917, {1, 3, 5, 1, 29, 45, 27, 19, 27, 825, 695, 1967, 4113, 1449, 8597}},
    {3508, 15, 14924, {1, 3, 5, 1, 5, 25, 113, 203, 15, 271, 1009, 1199, 5703, 1951, 18585}},
    {3509, 15, 14929, {1, 3, 5, 15, 29, 47, 75, 39, 123, 1007, 197, 1537, 689, 1121, 5403}},
    {3510, 15, 14942, {1, 3, 5, 11, 13, 11, 93, 95, 421, 91, 79, 3417, 4925, 7553, 20893}},
    {3511, 15, 14951, {1, 3, 1, 9, 9, 31, 43, 65, 41, 723, 381, 2743, 3615, 16213, 4891}},
    {3512, 15, 14969, {1, 1, 5, 1, 21, 37, 79, 39, 183, 803, 1273, 3039, 3569, 611, 23567}},
    {3513, 15, 14970, {1, 1, 1, 3, 7, 55, 47, 207, 171, 125, 1433, 1973, 1153, 13117, 13375}},
    {3514, 15, 14972, {1, 1, 5, 3, 1, 1, 37, 73, 461, 333, 1521, 1641, 1931, 15495, 17923}},
    {3515, 15, 14982, {1, 1, 3, 13, 27, 39, 125, 247, 17, 403, 303, 1893, 6589, 12609, 7423}},
    {3516, 15, 14988, {1, 3, 1, 15, 19, 57, 55, 165, 317, 179, 643, 2021, 5423, 7157, 8021}},
    {3517, 15, 14994, {1, 3, 1, 5, 15, 47, 55, 119, 439, 179, 1353, 3785, 4815, 4943, 695}},
    {3518, 15, 15005, {1, 1, 5, 5, 15, 57, 77, 31, 281, 85, 1063, 1101, 4349, 79, 22409}},
    {3519, 15, 15016, {1, 3, 5, 5, 27, 23, 69, 35, 223, 803, 1839, 3671, 923, 10443, 21985}},
    {3520, 15, 15024, {1, 1, 1, 3, 23, 13, 57, 215, 309, 723, 1239, 3673, 1531, 6015, 4361}},
    {3521, 15, 15030, {1, 3, 1, 11, 7, 53, 57, 231, 191, 347, 147, 2097, 6635, 7683, 26733}},
    {3522, 15, 15048, {1, 3, 7, 3, 1, 19, 111, 185, 453, 565, 237, 1305, 2229, 6951, 30553}},
    {3523, 15, 15054, {1, 3, 1, 1, 31, 31, 57, 69, 279, 645, 1745, 3999, 5593, 5073, 16047}},
    {3524, 15, 15066, {1, 3, 5, 5, 25, 57, 119, 175, 161, 289, 655, 1893, 7223, 4595, 19437}},
    {3525, 15, 15071, {1, 1, 7, 13, 9, 61, 21, 47, 301, 975, 1415, 1955, 769, 11167, 2981}},
    {3526, 15, 15072, {1, 1, 7, 13, 7, 11, 7, 131, 125, 899, 1423, 2759, 613, 6271, 16505}},
    {3527, 15, 15075, {1, 1, 5, 7, 25, 63, 67, 171, 441, 119, 249, 781, 6519, 8037, 16059}},
    {3528, 15, 15119, {1, 3, 5, 11, 21, 53, 105, 163, 21, 379, 1345, 31, 6999, 12697, 32135}},
    {3529, 15, 15121, {1, 1, 7, 13, 21, 53, 75, 69, 69, 465, 677, 2797, 7579, 11737, 17113}},
    {3530, 15, 15133, {1, 1, 7, 9, 27, 53, 61, 227, 195, 609, 479, 2841, 1815, 13237, 20347}},
    {3531, 15, 15138, {1, 3, 5, 11, 27, 39, 53, 17, 447, 829, 1655, 2005, 7619, 6933, 13427}},
    {3532, 15, 15143, {1, 1, 5, 11, 17, 33, 53, 155, 387, 743, 1389, 2577, 4413, 15139, 19311}},
    {3533, 15, 15170, {1, 3, 3, 1, 29, 9, 39, 97, 133, 369, 515, 1279, 2061, 5785, 29799}},
    {3534, 15, 15194, {1, 3, 7, 1, 29, 29, 71, 21, 477, 167, 11, 2479, 2929, 10365, 16863}},
    {3535, 15, 15212, {1, 3, 7, 3, 27, 1, 43, 237, 105, 477, 1143, 605, 497, 3951, 31879}},
    {3536, 15, 15223, {1, 1, 7, 5, 29, 3, 61, 249, 491, 57, 105, 2221, 957, 11211, 19225}},
    {3537, 15, 15229, {1, 1, 3, 9, 7, 49, 89, 119, 313, 99, 93, 2095, 2781, 9413, 18099}},
    {3538, 15, 15254, {1, 1, 7, 5, 25, 13, 115, 243, 323, 445, 1679, 317, 7549, 7873, 8481}},
    {3539, 15, 15263, {1, 1, 7, 9, 29, 49, 121, 27, 321, 65, 1753, 3575, 1101, 11531, 14575}},
    {3540, 15, 15270, {1, 3, 3, 9, 23, 39, 113, 179, 455, 207, 827, 389, 6713, 11543, 11881}},
    {3541, 15, 15273, {1, 1, 5, 3, 19, 53, 73, 117, 321, 281, 637, 349, 5093, 3395, 31627}},
    {3542, 15, 15287, {1, 1, 7, 9, 13, 53, 115, 149, 123, 419, 909, 33, 2681, 9385, 21971}},
    {3543, 15, 15299, {1, 3, 7, 7, 23, 37, 119, 19, 251, 509, 339, 3909, 3303, 9243, 9855}},
    {3544, 15, 15301, {1, 3, 7, 7, 21, 5, 101, 109, 287, 121, 627, 3207, 593, 12123, 31063}},
    {3545, 15, 15306, {1, 3, 1, 11, 3, 41, 59, 17, 215, 373, 105, 3201, 4321, 9189, 7679}},
    {3546, 15, 15313, {1, 1, 1, 11, 3, 57, 85, 241, 501, 1009, 371, 2201, 7677, 12093, 22487}},
    {3547, 15, 15320, {1, 1, 7, 9, 31, 61, 123, 157, 153, 127, 1931, 2555, 4733, 4201, 10027}},
    {3548, 15, 15323, {1, 3, 5, 5, 23, 7, 23, 81, 45, 399, 33, 3509, 3537, 12897, 11031}},
    {3549, 15, 15329, {1, 3, 3, 15, 7, 41, 41, 37, 291, 565, 693, 2907, 6183, 12739, 26051}},
    {3550, 15, 15332, {1, 1, 3, 13, 23, 27, 87, 215, 149, 591, 1653, 3547, 4219, 12081, 26283}},
    {3551, 15, 15341, {1, 3, 7, 11, 27, 7, 95, 167, 275, 567, 729, 3151, 7477, 8107, 12595}},
    {3552, 15, 15359, {1, 1, 5, 5, 19, 37, 73, 47, 45, 1003, 995, 3483, 4637, 1007, 17655}},
    {3553, 15, 15361, {1, 1, 1, 11, 3, 7, 101, 147, 169, 991, 773, 3303, 7701, 13359, 9173}},
    {3554, 15, 15364, {1, 1, 1, 15, 5, 23, 17, 205, 67, 783, 1003, 3503, 4573, 4219, 25547}},
    {3555, 15, 15367, {1, 3, 5, 5, 29, 15, 77, 237, 385, 261, 581, 2099, 6263, 8769, 9615}},
    {3556, 15, 15379, {1, 3, 7, 7, 25, 53, 25, 35, 205, 791, 1709, 201, 3319, 1737, 21981}},
    {3557, 15, 15391, {1, 1, 3, 13, 23, 9, 87, 43, 175, 453, 1119, 2797, 703, 11589, 14553}},
    {3558, 15, 15415, {1, 3, 5, 13, 31, 45, 19, 209, 423, 575, 1085, 413, 5491, 1249, 4483}},
    {3559, 15, 15416, {1, 1, 3, 13, 13, 23, 111, 115, 509, 543, 409, 649, 4549, 12679, 14977}},
    {3560, 15, 15419, {1, 3, 7, 11, 17, 23, 35, 107, 455, 471, 145, 2457, 5221, 16363, 4957}},
    {3561, 15, 15433, {1, 3, 1, 13, 15, 25, 49, 163, 173, 191, 1251, 3853, 6859, 1001, 4195}},
    {3562, 15, 15469, {1, 1, 5, 9, 9, 63, 109, 199, 145, 247, 857, 1611, 1569, 6265, 21575}},
    {3563, 15, 15478, {1, 1, 5, 3, 13, 31, 23, 85, 17, 919, 585, 371, 327, 9933, 17605}},
    {3564, 15, 15481, {1, 1, 3, 13, 11, 47, 35, 75, 83, 625, 1543, 3549, 6431, 8275, 2239}},
    {3565, 15, 15482, {1, 1, 1, 5, 13, 1, 59, 19, 289, 999, 1517, 293, 2537, 4591, 31235}},
    {3566, 15, 15498, {1, 3, 3, 5, 27, 35, 89, 109, 107, 379, 1487, 2235, 2857, 33, 7033}},
    {3567, 15, 15505, {1, 1, 3, 11, 31, 13, 9, 223, 483, 1, 1147, 3057, 3569, 9153, 32307}},
    {3568, 15, 15517, {1, 3, 3, 7, 7, 3, 113, 159, 383, 581, 463, 3257, 6435, 9673, 4515}},
    {3569, 15, 15518, {1, 1, 3, 5, 27, 53, 37, 233, 291, 735, 1741, 1765, 1411, 10617, 14863}},
    {3570, 15, 15527, {1, 3, 5, 3, 9, 5, 47, 199, 407, 437, 1919, 3351, 7811, 11959, 30203}},
    {3571, 15, 15528, {1, 1, 1, 13, 31, 49, 59, 47, 83, 117, 1483, 2389, 2497, 13905, 15323}},
    {3572, 15, 15545, {1, 3, 7, 13, 31, 27, 39, 107, 231, 181, 147, 2315, 7747, 13979, 27767}},
    {3573, 15, 15548, {1, 3, 3, 11, 1, 13, 67, 37, 273, 417, 725, 3693, 7791, 10531, 8485}},
    {3574, 15, 15554, {1, 1, 1, 7, 21, 17, 71, 169, 137, 935, 109, 797, 7603, 15007, 24305}},
    {3575, 15, 15565, {1, 1, 3, 3, 17, 17, 121, 123, 469, 665, 1295, 2015, 4335, 14753, 8779}},
    {3576, 15, 15577, {1, 3, 7, 3, 13, 13, 69, 105, 407, 149, 883, 1649, 3273, 10873, 30781}},
    {3577, 15, 15580, {1, 3, 5, 13, 3, 63, 105, 85, 61, 263, 1449, 1603, 2519, 10215, 9897}},
    {3578, 15, 15587, {1, 3, 5, 5, 23, 41, 103, 139, 393, 529, 103, 3643, 6743, 9839, 6655}},
    {3579, 15, 15601, {1, 1, 5, 3, 5, 47, 57, 205, 231, 149, 1645, 3393, 4009, 10165, 1941}},
    {3580, 15, 15604, {1, 3, 1, 5, 19, 29, 69, 133, 25, 923, 1513, 1837, 3077, 6377, 9563}},
    {3581, 15, 15611, {1, 3, 1, 15, 7, 1, 83, 17, 121, 187, 1679, 3245, 725, 5149, 29131}},
    {3582, 15, 15616, {1, 1, 3, 7, 13, 51, 33, 5, 31, 965, 939, 31, 3723, 13935, 2733}},
    {3583, 15, 15619, {1, 1, 5, 1, 13, 19, 99, 41, 409, 797, 9, 3545, 2739, 7031, 32047}},
    {3584, 15, 15625, {1, 3, 7, 15, 1, 9, 105, 73, 463, 369, 1631, 3043, 1585, 13249, 28763}},
    {3585, 15, 15633, {1, 1, 1, 3, 17, 9, 31, 67, 475, 899, 615, 3869, 3177, 2725, 16217}},
    {3586, 15, 15674, {1, 1, 7, 11, 11, 13, 55, 43, 327, 609, 1983, 19, 1483, 13451, 23069}},
    {3587, 15, 15681, {1, 1, 3, 9, 31, 11, 59, 109, 187, 653, 499, 3549, 7341, 6741, 11791}},
    {3588, 15, 15691, {1, 3, 3, 9, 23, 57, 51, 115, 323, 89, 1807, 2371, 3927, 4457, 4183}},
    {3589, 15, 15693, {1, 1, 1, 3, 3, 29, 77, 79, 481, 417, 1793, 2883, 6417, 3881, 28753}},
    {3590, 15, 15696, {1, 3, 7, 13, 9, 47, 45, 139, 345, 315, 1891, 597, 617, 101, 30377}},
    {3591, 15, 15712, {1, 1, 1, 13, 31, 7, 47, 195, 133, 469, 1119, 589, 3631, 3201, 6783}},
    {3592, 15, 15717, {1, 3, 7, 13, 11, 1, 5, 23, 153, 723, 369, 3225, 5595, 1229, 9433}},
    {3593, 15, 15724, {1, 3, 7, 7, 11, 45, 69, 45, 73, 731, 2017, 2073, 6271, 7559, 7639}},
    {3594, 15, 15727, {1, 1, 3, 5, 23, 51, 81, 7, 425, 533, 1189, 3149, 1157, 10421, 31657}},
    {3595, 15, 15730, {1, 3, 3, 9, 3, 17, 39, 75, 45, 641, 1571, 1287, 859, 11139, 18357}},
    {3596, 15, 15746, {1, 1, 7, 13, 3, 27, 21, 173, 371, 827, 1889, 1231, 6647, 719, 22591}},
    {3597, 15, 15751, {1, 3, 3, 7, 11, 15, 87, 21, 391, 587, 2033, 2433, 6089, 9397, 521}},
    {3598, 15, 15760, {1, 3, 3, 13, 21, 1, 111, 133, 275, 943, 1119, 1283, 1419, 1761, 25575}},
    {3599, 15, 15770, {1, 1, 1, 11, 9, 33, 67, 191, 411, 227, 1329, 3201, 7255, 13157, 32467}},
    {3600, 15, 15782, {1, 1, 5, 1, 23, 9, 21, 161, 199, 185, 799, 2025, 8139, 35, 3539}},
    {3601, 15, 15791, {1, 3, 1, 1, 21, 3, 43, 105, 403, 787, 1831, 2649, 6883, 14225, 13229}},
    {3602, 15, 15796, {1, 1, 7, 11, 11, 49, 65, 63, 171, 763, 1673, 3181, 1121, 6643, 12243}},
    {3603, 15, 15808, {1, 1, 1, 13, 27, 35, 123, 197, 141, 239, 307, 3767, 6089, 2089, 7683}},
    {3604, 15, 15814, {1, 1, 5, 13, 17, 37, 87, 171, 143, 881, 659, 781, 4393, 4383, 21175}},
    {3605, 15, 15825, {1, 3, 1, 9, 31, 25, 13, 203, 253, 789, 931, 3511, 6439, 7719, 12983}},
    {3606, 15, 15828, {1, 1, 7, 5, 25, 57, 13, 219, 219, 775, 581, 409, 739, 8777, 16671}},
    {3607, 15, 15835, {1, 3, 1, 15, 9, 13, 3, 173, 111, 103, 555, 1197, 1761, 13219, 20855}},
    {3608, 15, 15844, {1, 1, 3, 1, 17, 27, 59, 211, 493, 177, 639, 1395, 5585, 15509, 14725}},
    {3609, 15, 15847, {1, 1, 1, 11, 7, 31, 77, 159, 73, 835, 987, 2067, 4731, 13949, 17591}},
    {3610, 15, 15853, {1, 3, 7, 1, 11, 11, 55, 185, 319, 55, 437, 343, 1971, 6729, 27961}},
    {3611, 15, 15856, {1, 1, 3, 5, 13, 63, 71, 117, 209, 955, 1175, 317, 4261, 2341, 29819}},
    {3612, 15, 15877, {1, 1, 5, 1, 7, 21, 95, 95, 505, 131, 1237, 867, 3877, 15383, 29881}},
    {3613, 15, 15878, {1, 1, 5, 3, 1, 15, 115, 123, 273, 103, 1041, 703, 4085, 3985, 1265}},
    {3614, 15, 15887, {1, 3, 7, 3, 3, 59, 97, 165, 111, 613, 1411, 3033, 833, 10871, 25151}},
    {3615, 15, 15908, {1, 1, 5, 3, 25, 25, 33, 135, 213, 689, 1713, 1531, 7847, 1065, 26951}},
    {3616, 15, 15917, {1, 3, 1, 9, 5, 33, 9, 205, 153, 563, 2041, 2287, 1799, 11279, 29295}},
    {3617, 15, 15923, {1, 3, 1, 3, 31, 45, 95, 161, 369, 1005, 273, 3409, 6703, 13005, 9107}},
    {3618, 15, 15930, {1, 3, 5, 13, 25, 29, 127, 53, 97, 815, 1221, 2501, 5581, 8559, 10459}},
    {3619, 15, 15937, {1, 3, 1, 13, 25, 31, 41, 171, 113, 637, 1035, 801, 5767, 13511, 20217}},
    {3620, 15, 15958, {1, 1, 5, 3, 1, 19, 43, 41, 509, 495, 1575, 551, 4769, 10259, 11227}},
    {3621, 15, 15977, {1, 3, 3, 13, 9, 39, 23, 117, 339, 503, 225, 2413, 6533, 6037, 7977}},
    {3622, 15, 15991, {1, 1, 5, 7, 17, 31, 121, 139, 281, 155, 495, 79, 1557, 795, 9897}},
    {3623, 15, 16007, {1, 1, 5, 7, 23, 43, 43, 185, 245, 509, 573, 3519, 3491, 689, 20123}},
    {3624, 15, 16011, {1, 3, 1, 5, 5, 37, 95, 139, 273, 349, 1673, 4051, 723, 9075, 15697}},
    {3625, 15, 16014, {1, 1, 5, 11, 15, 43, 13, 227, 325, 981, 1689, 743, 1159, 6623, 24429}},
    {3626, 15, 16021, {1, 1, 3, 7, 9, 29, 117, 73, 105, 725, 1611, 3683, 3989, 12529, 22195}},
    {3627, 15, 16022, {1, 3, 7, 3, 11, 45, 105, 83, 91, 907, 355, 2759, 7939, 9901, 28761}},
    {3628, 15, 16028, {1, 3, 7, 13, 21, 49, 35, 37, 35, 113, 669, 1551, 6817, 8479, 22397}},
    {3629, 15, 16035, {1, 1, 3, 13, 7, 51, 117, 17, 371, 35, 1105, 1179, 2491, 4385, 3099}},
    {3630, 15, 16041, {1, 1, 3, 5, 21, 31, 9, 77, 319, 981, 1575, 2231, 5431, 7695, 13035}},
    {3631, 15, 16056, {1, 3, 3, 5, 7, 3, 5, 177, 93, 173, 123, 2003, 7755, 9499, 18751}},
    {3632, 15, 16069, {1, 1, 5, 11, 15, 47, 99, 25, 119, 197, 323, 3211, 1405, 11587, 30093}},
    {3633, 15, 16076, {1, 1, 7, 9, 15, 31, 17, 85, 179, 311, 1183, 981, 2567, 8611, 19719}},
    {3634, 15, 16081, {1, 1, 7, 15, 11, 1, 95, 113, 399, 591, 599, 1145, 7881, 8877, 32397}},
    {3635, 15, 16087, {1, 1, 7, 9, 13, 59, 105, 61, 73, 365, 1529, 1453, 6101, 9165, 11809}},
    {3636, 15, 16088, {1, 3, 7, 15, 25, 23, 77, 7, 425, 565, 1531, 3255, 919, 9345, 5455}},
    {3637, 15, 16110, {1, 1, 7, 11, 29, 35, 85, 187, 419, 535, 97, 657, 479, 7051, 2091}},
    {3638, 15, 16112, {1, 1, 3, 3, 27, 3, 93, 25, 321, 329, 1957, 1809, 3841, 2231, 3867}},
    {3639, 15, 16117, {1, 1, 1, 1, 17, 41, 53, 225, 501, 705, 1963, 151, 7203, 12403, 30815}},
    {3640, 15, 16150, {1, 3, 3, 9, 17, 5, 115, 239, 355, 487, 499, 59, 5747, 5249, 10407}},
    {3641, 15, 16153, {1, 1, 7, 3, 29, 29, 53, 99, 471, 641, 1907, 1639, 7985, 1491, 18991}},
    {3642, 15, 16160, {1, 3, 1, 13, 25, 47, 63, 59, 435, 513, 1661, 631, 7161, 2299, 13185}},
    {3643, 15, 16166, {1, 3, 1, 15, 9, 17, 99, 93, 287, 551, 451, 3645, 1961, 14515, 7055}},
    {3644, 15, 16172, {1, 1, 7, 9, 9, 41, 29, 11, 453, 89, 1979, 787, 655, 8083, 6425}},
    {3645, 15, 16190, {1, 1, 7, 7, 5, 57, 71, 31, 465, 761, 1995, 2071, 2085, 5671, 14597}},
    {3646, 15, 16195, {1, 1, 1, 7, 31, 31, 91, 225, 113, 229, 111, 45, 103, 16159, 8761}},
    {3647, 15, 16204, {1, 3, 1, 7, 21, 17, 81, 163, 269, 739, 713, 1519, 4619, 6415, 5837}},
    {3648, 15, 16216, {1, 1, 1, 15, 29, 15, 103, 35, 443, 325, 1901, 2371, 4319, 6531, 19725}},
    {3649, 15, 16222, {1, 1, 3, 3, 5, 45, 33, 81, 475, 703, 1193, 2265, 6145, 3577, 4519}},
    {3650, 15, 16228, {1, 3, 5, 1, 3, 25, 83, 21, 493, 261, 1261, 3079, 2051, 7403, 849}},
    {3651, 15, 16245, {1, 1, 5, 13, 21, 31, 11, 197, 113, 105, 1683, 1419, 4427, 14763, 9085}},
    {3652, 15, 16255, {1, 1, 5, 15, 31, 9, 47, 123, 41, 821, 1117, 1241, 4917, 677, 689}},
    {3653, 15, 16265, {1, 1, 7, 9, 9, 19, 55, 179, 37, 747, 1089, 3037, 3597, 5967, 27369}},
    {3654, 15, 16273, {1, 3, 7, 11, 9, 9, 25, 7, 95, 595, 699, 3837, 7391, 1257, 555}},
    {3655, 15, 16276, {1, 1, 7, 5, 7, 21, 29, 95, 395, 257, 1479, 1891, 4265, 10609, 999}},
    {3656, 15, 16283, {1, 1, 7, 11, 17, 9, 89, 147, 205, 421, 951, 1581, 2299, 9273, 8189}},
    {3657, 15, 16295, {1, 3, 7, 3, 21, 47, 93, 101, 465, 741, 793, 2821, 5309, 1381, 26833}},
    {3658, 15, 16304, {1, 3, 7, 5, 3, 33, 83, 75, 63, 739, 1057, 3121, 6925, 4623, 12259}},
    {3659, 15, 16313, {1, 3, 5, 7, 13, 61, 107, 233, 47, 225, 1719, 2995, 4433, 11001, 30209}},
    {3660, 15, 16319, {1, 3, 3, 3, 5, 19, 49, 153, 345, 403, 839, 3525, 7623, 14669, 15203}},
    {3661, 15, 16328, {1, 1, 7, 7, 25, 7, 5, 105, 133, 911, 1995, 2253, 1481, 14593, 121}},
    {3662, 15, 16345, {1, 1, 3, 5, 31, 61, 99, 233, 205, 109, 1843, 2789, 5519, 9933, 21575}},
    {3663, 15, 16355, {1, 3, 5, 5, 3, 39, 25, 103, 453, 883, 1117, 2529, 2837, 8325, 18645}},
    {3664, 15, 16364, {1, 1, 1, 1, 3, 37, 63, 41, 321, 797, 1855, 2085, 5263, 2491, 25541}},
    {3665, 15, 16372, {1, 3, 7, 9, 11, 45, 93, 15, 253, 813, 533, 2347, 4245, 13365, 15903}},
    {3666, 15, 16375, {1, 3, 7, 3, 13, 31, 93, 241, 485, 853, 1335, 3089, 6757, 12813, 1471}},
    {3667, 15, 16382, {1, 3, 5, 15, 17, 31, 7, 15, 267, 415, 1609, 2573, 825, 1025, 13529}},
    {3668, 16, 22, {1, 3, 1, 13, 7, 57, 71, 31, 443, 231, 357, 2955, 625, 2147, 21665, 11695}},
    {3669, 16, 28, {1, 1, 7, 5, 25, 7, 57, 107, 123, 775, 1615, 1017, 741, 10843, 16815, 61867}},
    {3670, 16, 31, {1, 1, 5, 11, 21, 33, 55, 99, 431, 385, 1585, 2349, 7033, 12339, 5903, 58661}},
    {3671, 16, 41, {1, 1, 1, 15, 13, 33, 91, 117, 151, 833, 1771, 2831, 3869, 4741, 1797, 8191}},
    {3672, 16, 94, {1, 3, 3, 11, 25, 37, 85, 179, 465, 807, 1779, 3873, 6113, 15039, 20699, 38227}},
    {3673, 16, 107, {1, 3, 1, 7, 27, 57, 17, 63, 333, 471, 1665, 3731, 7349, 15351, 9049, 8573}},
    {3674, 16, 151, {1, 1, 5, 1, 23, 33, 91, 89, 459, 837, 335, 4039, 1117, 7319, 4985, 1303}},
    {3675, 16, 158, {1, 1, 7, 11, 29, 59, 67, 201, 229, 833, 1035, 1979, 2067, 10545, 3035, 62377}},
    {3676, 16, 167, {1, 1, 3, 1, 25, 29, 55, 193, 153, 633, 619, 4021, 4823, 13201, 11473, 7079}},
    {3677, 16, 174, {1, 3, 5, 1, 3, 5, 105, 111, 217, 1017, 1123, 2801, 1421, 3061, 24077, 24541}},
    {3678, 16, 203, {1, 1, 3, 1, 13, 15, 25, 91, 201, 317, 1751, 3169, 4895, 2793, 6583, 50549}},
    {3679, 16, 208, {1, 1, 5, 3, 31, 61, 75, 119, 357, 477, 1695, 637, 7195, 7665, 27141, 25819}},
    {3680, 16, 214, {1, 1, 3, 5, 1, 25, 7, 221, 33, 527, 213, 2909, 8135, 7725, 8991, 44437}},
    {3681, 16, 223, {1, 1, 1, 7, 9, 43, 63, 167, 171, 771, 215, 3977, 2739, 431, 27679, 45169}},
    {3682, 16, 227, {1, 3, 7, 15, 13, 25, 55, 215, 43, 139, 1013, 3317, 335, 2203, 3937, 5581}},
    {3683, 16, 266, {1, 3, 5, 5, 13, 53, 39, 97, 277, 821, 1775, 2877, 1651, 10353, 8953, 17603}},
    {3684, 16, 268, {1, 1, 1, 3, 9, 7, 73, 71, 291, 467, 381, 2653, 6603, 6571, 14737, 33327}},
    {3685, 16, 274, {1, 1, 3, 11, 1, 11, 115, 251, 45, 337, 441, 2165, 4017, 15601, 22419, 39407}},
    {3686, 16, 279, {1, 3, 1, 9, 13, 37, 1, 159, 127, 987, 1561, 2661, 3709, 3367, 17643, 18841}},
    {3687, 16, 302, {1, 3, 5, 13, 7, 7, 123, 153, 225, 311, 171, 1337, 1653, 7695, 22933, 38629}},
    {3688, 16, 310, {1, 3, 5, 15, 25, 13, 31, 63, 173, 623, 1445, 2999, 4865, 16097, 6513, 35009}},
    {3689, 16, 322, {1, 1, 1, 7, 13, 63, 119, 149, 111, 727, 1723, 3123, 5931, 4947, 6675, 45685}},
    {3690, 16, 328, {1, 3, 5, 11, 19, 33, 105, 51, 511, 533, 583, 2317, 5, 9211, 29525, 28361}},
    {3691, 16, 336, {1, 1, 1, 13, 31, 3, 7, 121, 195, 683, 1281, 1505, 5723, 3419, 13893, 59031}},
    {3692, 16, 370, {1, 3, 7, 11, 11, 51, 15, 87, 327, 643, 1031, 749, 1677, 9691, 7897, 45409}},
    {3693, 16, 398, {1, 3, 1, 7, 23, 39, 55, 233, 167, 953, 861, 383, 6273, 4171, 1983, 9373}},
    {3694, 16, 421, {1, 3, 5, 7, 13, 5, 87, 107, 201, 523, 1527, 1259, 1947, 1903, 31613, 58793}},
    {3695, 16, 436, {1, 3, 7, 9, 27, 13, 21, 101, 77, 673, 2023, 2559, 6863, 8863, 10557, 53589}},
    {3696, 16, 440, {1, 3, 7, 3, 9, 45, 55, 53, 305, 769, 1179, 3941, 5351, 13617, 20571, 48881}},
    {3697, 16, 451, {1, 1, 1, 15, 1, 55, 49, 231, 101, 81, 675, 2895, 4723, 11185, 31275, 60341}},
    {3698, 16, 454, {1, 1, 1, 9, 31, 19, 1, 111, 23, 629, 597, 3579, 6407, 7697, 16159, 279}},
    {3699, 16, 463, {1, 1, 1, 13, 13, 1, 73, 19, 369, 697, 429, 1113, 2343, 16139, 31537, 56473}},
    {3700, 16, 465, {1, 3, 5, 1, 27, 43, 93, 111, 347, 265, 1535, 2861, 7721, 6773, 555, 29173}},
    {3701, 16, 494, {1, 3, 5, 7, 31, 45, 17, 213, 177, 271, 937, 3901, 4283, 515, 4349, 4901}},
    {3702, 16, 508, {1, 3, 1, 15, 3, 59, 41, 157, 115, 833, 769, 2643, 7513, 3955, 30925, 8447}},
    {3703, 16, 532, {1, 3, 7, 1, 19, 31, 71, 131, 317, 497, 1619, 3697, 7277, 13673, 4091, 11309}},
    {3704, 16, 555, {1, 3, 1, 9, 19, 33, 65, 137, 491, 377, 141, 2323, 6751, 11575, 14185, 14177}},
    {3705, 16, 563, {1, 1, 7, 9, 29, 47, 89, 179, 227, 743, 785, 909, 7755, 10573, 1435, 24981}},
    {3706, 16, 577, {1, 3, 5, 1, 5, 49, 63, 89, 321, 665, 1851, 2859, 1365, 5771, 27759, 7971}},
    {3707, 16, 580, {1, 3, 3, 11, 27, 3, 79, 117, 217, 513, 955, 3981, 7445, 7643, 777, 15223}},
    {3708, 16, 584, {1, 3, 1, 11, 31, 63, 63, 21, 345, 319, 891, 605, 4183, 1583, 10209, 26247}},
    {3709, 16, 607, {1, 3, 5, 3, 31, 15, 53, 117, 267, 929, 569, 933, 5833, 4669, 16305, 543}},
    {3710, 16, 608, {1, 3, 5, 7, 13, 1, 51, 87, 51, 613, 623, 3965, 1903, 13551, 10899, 43347}},
    {3711, 16, 665, {1, 3, 7, 9, 19, 57, 79, 21, 31, 315, 259, 1443, 6021, 8805, 9793, 51625}},
    {3712, 16, 675, {1, 1, 5, 1, 9, 33, 81, 85, 241, 145, 2007, 2693, 4903, 9625, 20713, 56907}},
    {3713, 16, 692, {1, 3, 3, 3, 7, 1, 121, 33, 475, 751, 1937, 3863, 2805, 12077, 12095, 32377}},
    {3714, 16, 707, {1, 3, 5, 7, 31, 13, 75, 211, 85, 391, 1017, 2117, 6831, 10221, 11415, 36815}},
    {3715, 16, 737, {1, 1, 3, 9, 23, 59, 109, 175, 507, 145, 1643, 1537, 1265, 8579, 15687, 5969}},
    {3716, 16, 750, {1, 3, 3, 1, 19, 9, 29, 139, 1, 937, 1245, 1895, 3719, 8369, 30543, 51063}},
    {3717, 16, 757, {1, 1, 1, 3, 11, 21, 119, 127, 173, 629, 1797, 3833, 3805, 11613, 20991, 31009}},
    {3718, 16, 800, {1, 3, 1, 5, 19, 15, 7, 199, 169, 855, 109, 647, 3579, 15949, 24381, 31827}},
    {3719, 16, 805, {1, 1, 5, 1, 23, 1, 35, 27, 453, 357, 1481, 2271, 4715, 11223, 11187, 21663}},
    {3720, 16, 809, {1, 3, 5, 9, 27, 1, 57, 1, 19, 901, 425, 2523, 4615, 8487, 5469, 25609}},
    {3721, 16, 837, {1, 3, 5, 1, 9, 39, 125, 213, 325, 579, 359, 381, 2649, 4505, 12653, 36961}},
    {3722, 16, 865, {1, 3, 7, 13, 25, 1, 117, 41, 363, 325, 1091, 3365, 287, 2427, 14359, 63897}},
    {3723, 16, 949, {1, 3, 7, 5, 13, 13, 99, 175, 343, 313, 537, 2265, 5963, 15317, 7723, 42555}},
    {3724, 16, 950, {1, 1, 3, 11, 11, 51, 95, 35, 441, 51, 1347, 535, 3421, 14881, 7895, 36899}},
    {3725, 16, 956, {1, 1, 1, 13, 27, 5, 11, 201, 197, 429, 495, 687, 2103, 1937, 19725, 1935}},
    {3726, 16, 961, {1, 3, 1, 3, 21, 57, 41, 83, 69, 335, 1683, 2399, 4569, 4745, 27955, 2861}},
    {3727, 16, 1016, {1, 3, 5, 3, 7, 57, 17, 79, 391, 521, 919, 1991, 5301, 5219, 19, 42447}},
    {3728, 16, 1030, {1, 1, 3, 1, 13, 49, 5, 47, 437, 295, 1727, 2791, 2959, 13945, 27935, 55339}},
    {3729, 16, 1072, {1, 1, 7, 3, 31, 25, 121, 239, 361, 505, 1463, 2573, 6893, 12299, 11635, 17265}},
    {3730, 16, 1119, {1, 1, 3, 1, 25, 33, 35, 241, 307, 743, 1541, 1251, 3523, 14327, 26703, 11811}},
    {3731, 16, 1130, {1, 3, 5, 15, 5, 17, 17, 81, 217, 233, 159, 2029, 447, 15719, 23937, 21757}},
    {3732, 16, 1135, {1, 1, 7, 7, 31, 57, 59, 71, 433, 11, 133, 749, 2637, 4331, 11745, 25593}},
    {3733, 16, 1137, {1, 1, 5, 9, 17, 55, 69, 115, 421, 399, 929, 2331, 4531, 4459, 28317, 65417}},
    {3734, 16, 1144, {1, 1, 3, 1, 29, 5, 95, 71, 119, 455, 1045, 1991, 3281, 12667, 31289, 59601}},
    {3735, 16, 1149, {1, 1, 7, 11, 29, 61, 111, 207, 377, 841, 91, 3167, 6667, 3993, 6511, 31059}},
    {3736, 16, 1180, {1, 3, 1, 9, 17, 47, 31, 191, 217, 337, 1037, 1147, 3593, 10913, 5919, 44155}},
    {3737, 16, 1214, {1, 1, 1, 5, 9, 3, 71, 17, 343, 573, 795, 2377, 3741, 11731, 29951, 3689}},
    {3738, 16, 1221, {1, 1, 7, 5, 3, 55, 119, 173, 73, 417, 23, 225, 5721, 16089, 11723, 27871}},
    {3739, 16, 1234, {1, 1, 3, 1, 9, 49, 73, 219, 285, 507, 1207, 1255, 2763, 8655, 32241, 18323}},
    {3740, 16, 1239, {1, 1, 3, 13, 19, 31, 7, 9, 103, 33, 19, 2071, 2809, 4047, 21265, 26109}},
    {3741, 16, 1249, {1, 1, 3, 11, 3, 55, 121, 35, 215, 387, 1971, 3341, 1777, 15247, 28283, 2645}},
    {3742, 16, 1250, {1, 1, 3, 3, 5, 19, 87, 211, 373, 179, 119, 507, 7663, 12105, 2425, 57429}},
    {3743, 16, 1267, {1, 3, 5, 3, 1, 13, 59, 153, 15, 187, 1421, 1129, 2531, 15769, 28885, 22181}},
    {3744, 16, 1273, {1, 3, 3, 3, 17, 51, 35, 185, 255, 683, 1643, 3413, 5995, 3985, 13331, 47295}},
    {3745, 16, 1342, {1, 1, 7, 7, 9, 53, 101, 171, 425, 809, 729, 1517, 5967, 3389, 12953, 36245}},
    {3746, 16, 1344, {1, 3, 5, 11, 25, 41, 61, 23, 143, 257, 747, 395, 6153, 10913, 32169, 1773}},
    {3747, 16, 1373, {1, 3, 3, 11, 17, 7, 41, 107, 87, 267, 1009, 1431, 2431, 4511, 21333, 53045}},
    {3748, 16, 1378, {1, 1, 7, 13, 7, 47, 51, 73, 169, 489, 585, 2999, 7019, 4003, 10467, 30761}},
    {3749, 16, 1408, {1, 1, 5, 5, 25, 21, 19, 247, 337, 313, 73, 2737, 2125, 1275, 7467, 23329}},
    {3750, 16, 1417, {1, 3, 1, 7, 11, 57, 115, 209, 155, 213, 429, 3389, 2515, 3417, 18977, 64093}},
    {3751, 16, 1418, {1, 1, 1, 5, 15, 11, 65, 183, 237, 881, 1477, 2813, 6811, 10221, 27925, 22237}},
    {3752, 16, 1448, {1, 3, 7, 1, 31, 25, 121, 119, 421, 749, 1111, 957, 3653, 5533, 9641, 52361}},
    {3753, 16, 1454, {1, 3, 7, 1, 9, 41, 109, 93, 207, 867, 1623, 1881, 5957, 4681, 22859, 9281}},
    {3754, 16, 1510, {1, 1, 5, 13, 21, 37, 49, 129, 223, 663, 291, 3249, 2989, 2223, 6137, 46983}},
    {3755, 16, 1513, {1, 1, 3, 11, 9, 23, 19, 7, 205, 513, 361, 1645, 2923, 7431, 1709, 27369}},
    {3756, 16, 1522, {1, 1, 5, 5, 9, 57, 1, 145, 83, 801, 1887, 2625, 1665, 661, 21583, 4993}},
    {3757, 16, 1543, {1, 3, 7, 7, 17, 51, 79, 21, 233, 503, 449, 2017, 1191, 423, 18337, 11563}},
    {3758, 16, 1550, {1, 3, 3, 3, 19, 63, 3, 173, 263, 971, 323, 1271, 6621, 1657, 16033, 65277}},
    {3759, 16, 1552, {1, 3, 3, 11, 27, 25, 115, 53, 277, 167, 2011, 325, 7619, 15773, 24117, 29673}},
    {3760, 16, 1588, {1, 3, 3, 13, 23, 23, 89, 117, 429, 697, 1357, 2765, 4215, 5549, 31717, 14153}},
    {3761, 16, 1592, {1, 3, 7, 7, 3, 57, 39, 57, 313, 475, 951, 3129, 7785, 13841, 13843, 52877}},
    {3762, 16, 1597, {1, 3, 7, 7, 17, 35, 37, 141, 309, 891, 795, 1801, 2745, 14445, 19959, 52463}},
    {3763, 16, 1606, {1, 3, 3, 13, 29, 29, 1, 189, 239, 101, 879, 159, 5701, 8951, 31959, 31199}},
    {3764, 16, 1610, {1, 3, 5, 1, 13, 45, 85, 37, 67, 427, 695, 3439, 6439, 7553, 30291, 62995}},
    {3765, 16, 1617, {1, 1, 5, 1, 17, 39, 81, 3, 187, 831, 383, 2731, 6759, 547, 18097, 54649}},
    {3766, 16, 1623, {1, 1, 7, 1, 19, 19, 121, 33, 353, 781, 1891, 2189, 4409, 1477, 177, 51451}},
    {3767, 16, 1657, {1, 1, 1, 13, 23, 57, 15, 139, 129, 649, 177, 439, 3561, 3425, 27521, 41125}},
    {3768, 16, 1697, {1, 3, 3, 3, 25, 1, 13, 221, 391, 733, 467, 3811, 7093, 8403, 2307, 31595}},
    {3769, 16, 1729, {1, 3, 7, 3, 13, 61, 69, 203, 439, 887, 51, 687, 3751, 11559, 14335, 25139}},
    {3770, 16, 1735, {1, 3, 7, 7, 5, 39, 77, 85, 385, 317, 1193, 1147, 585, 11463, 17149, 34765}},
    {3771, 16, 1769, {1, 1, 5, 15, 25, 3, 1, 157, 221, 757, 313, 503, 353, 8271, 24639, 52329}},
    {3772, 16, 1778, {1, 3, 5, 15, 21, 45, 49, 23, 195, 297, 1825, 3661, 5223, 5513, 23141, 5349}},
    {3773, 16, 1826, {1, 3, 5, 1, 11, 51, 9, 9, 341, 1003, 1363, 2417, 8143, 9727, 30663, 47279}},
    {3774, 16, 1858, {1, 1, 5, 5, 5, 59, 97, 217, 87, 839, 1217, 861, 7911, 14805, 9203, 59609}},
    {3775, 16, 1870, {1, 1, 5, 5, 21, 3, 93, 73, 435, 151, 1727, 1415, 3299, 4253, 24473, 4747}},
    {3776, 16, 1875, {1, 3, 7, 1, 7, 5, 95, 31, 379, 389, 1435, 1367, 3001, 4675, 28839, 50175}},
    {3777, 16, 1922, {1, 3, 5, 9, 1, 33, 103, 127, 197, 171, 1709, 223, 7285, 177, 957, 58883}},
    {3778, 16, 1924, {1, 3, 1, 3, 5, 9, 51, 193, 419, 861, 1543, 1417, 7969, 6107, 7909, 27085}},
    {3779, 16, 1933, {1, 3, 5, 7, 3, 9, 51, 115, 191, 29, 877, 353, 3153, 15753, 7231, 8693}},
    {3780, 16, 1972, {1, 3, 3, 11, 7, 47, 5, 179, 177, 653, 39, 2259, 4151, 10835, 15081, 11257}},
    {3781, 16, 1979, {1, 1, 1, 9, 15, 19, 89, 143, 305, 121, 1217, 807, 5003, 13847, 29431, 38693}},
    {3782, 16, 1987, {1, 3, 1, 9, 9, 21, 123, 215, 459, 867, 153, 991, 7607, 6575, 27859, 44375}},
    {3783, 16, 1994, {1, 1, 7, 9, 7, 15, 17, 121, 27, 851, 425, 1523, 5753, 7593, 8301, 58393}},
    {3784, 16, 2008, {1, 1, 5, 15, 25, 23, 65, 47, 235, 835, 447, 815, 6993, 8279, 8839, 50621}},
    {3785, 16, 2023, {1, 1, 3, 1, 15, 21, 13, 215, 163, 907, 1093, 3797, 3555, 4067, 30629, 31297}},
    {3786, 16, 2029, {1, 1, 5, 13, 31, 17, 65, 81, 265, 53, 1713, 2473, 6407, 14567, 22473, 6435}},
    {3787, 16, 2053, {1, 3, 3, 13, 25, 3, 11, 35, 323, 123, 293, 2501, 3583, 13451, 6023, 25993}},
    {3788, 16, 2081, {1, 3, 1, 7, 19, 17, 41, 185, 393, 559, 1265, 969, 4335, 9769, 13803, 8845}},
    {3789, 16, 2087, {1, 1, 1, 7, 9, 9, 19, 61, 333, 537, 1399, 1147, 2255, 5475, 5913, 23019}},
    {3790, 16, 2094, {1, 1, 3, 1, 25, 39, 35, 237, 269, 957, 237, 451, 3159, 71, 707, 11075}},
    {3791, 16, 2111, {1, 1, 5, 15, 19, 7, 89, 27, 461, 663, 1375, 2903, 7419, 11613, 18231, 12931}},
    {3792, 16, 2113, {1, 3, 7, 7, 27, 5, 53, 113, 423, 679, 159, 1481, 6223, 2085, 29055, 64591}},
    {3793, 16, 2114, {1, 3, 5, 3, 11, 61, 57, 223, 103, 745, 1975, 1295, 4213, 7461, 29611, 59559}},
    {3794, 16, 2123, {1, 1, 3, 9, 31, 11, 69, 87, 427, 493, 669, 409, 2119, 6609, 13869, 133}},
    {3795, 16, 2190, {1, 1, 5, 9, 3, 17, 43, 47, 431, 115, 1439, 1797, 721, 11451, 26415, 55891}},
    {3796, 16, 2231, {1, 1, 5, 13, 9, 3, 61, 59, 371, 759, 1059, 4087, 7071, 5731, 15303, 49299}},
    {3797, 16, 2276, {1, 3, 1, 11, 19, 13, 115, 13, 377, 717, 613, 3821, 221, 2295, 30647, 17753}},
    {3798, 16, 2285, {1, 3, 3, 13, 31, 57, 7, 43, 179, 181, 1727, 3791, 2541, 12581, 32569, 2937}},
    {3799, 16, 2297, {1, 1, 3, 3, 19, 11, 65, 201, 373, 79, 1739, 3491, 7141, 3729, 8083, 58177}},
    {3800, 16, 2336, {1, 3, 1, 9, 31, 11, 21, 61, 469, 151, 459, 3581, 7655, 805, 18125, 32365}},
    {3801, 16, 2345, {1, 1, 1, 13, 9, 1, 61, 219, 173, 33, 1977, 2495, 649, 13167, 18239, 54977}},
    {3802, 16, 2353, {1, 3, 1, 3, 25, 1, 5, 65, 19, 445, 721, 3915, 1049, 4105, 18041, 187}},
    {3803, 16, 2363, {1, 1, 3, 3, 27, 39, 49, 43, 163, 959, 1847, 3493, 4643, 6819, 5839, 33745}},
    {3804, 16, 2368, {1, 1, 1, 9, 23, 15, 103, 229, 133, 189, 1973, 3173, 1837, 6673, 19465, 56221}},
    {3805, 16, 2373, {1, 1, 1, 9, 21, 39, 89, 161, 341, 685, 925, 3811, 4369, 15983, 1455, 25917}},
    {3806, 16, 2391, {1, 1, 7, 1, 17, 3, 53, 165, 129, 229, 1441, 3201, 2297, 5043, 11963, 42061}},
    {3807, 16, 2402, {1, 1, 7, 5, 3, 7, 99, 219, 167, 209, 979, 543, 3879, 7845, 29143, 44087}},
    {3808, 16, 2413, {1, 1, 1, 13, 27, 33, 43, 223, 405, 447, 1673, 2417, 5719, 9283, 12409, 33335}},
    {3809, 16, 2422, {1, 3, 1, 1, 11, 19, 115, 77, 449, 553, 1823, 4041, 4583, 4891, 403, 20889}},
    {3810, 16, 2425, {1, 3, 5, 11, 25, 3, 99, 33, 459, 3, 169, 4043, 6455, 15625, 11351, 61701}},
    {3811, 16, 2461, {1, 3, 1, 3, 5, 37, 31, 155, 187, 175, 1677, 2373, 2655, 5185, 20481, 40353}},
    {3812, 16, 2462, {1, 3, 3, 15, 25, 61, 27, 35, 379, 699, 1757, 573, 5715, 319, 9675, 37765}},
    {3813, 16, 2490, {1, 1, 5, 3, 9, 49, 37, 33, 399, 491, 191, 2589, 7203, 16007, 21961, 44521}},
    {3814, 16, 2492, {1, 3, 1, 3, 17, 43, 81, 205, 125, 1015, 1113, 2263, 7331, 12023, 5193, 42997}},
    {3815, 16, 2510, {1, 3, 3, 1, 3, 57, 15, 51, 299, 51, 1263, 2051, 2461, 6041, 26909, 45677}},
    {3816, 16, 2564, {1, 1, 5, 1, 17, 41, 23, 199, 317, 869, 1963, 1641, 6813, 1871, 115, 46297}},
    {3817, 16, 2573, {1, 1, 5, 7, 29, 43, 31, 7, 323, 945, 1969, 2325, 4937, 8813, 25569, 57651}},
    {3818, 16, 2598, {1, 1, 5, 9, 23, 43, 49, 91, 191, 1015, 1723, 1283, 4185, 9355, 23321, 28163}},
    {3819, 16, 2627, {1, 1, 3, 1, 17, 29, 1, 43, 407, 535, 807, 4089, 6145, 16221, 1113, 56149}},
    {3820, 16, 2633, {1, 1, 3, 11, 25, 23, 85, 19, 61, 133, 161, 3995, 4713, 515, 3663, 37901}},
    {3821, 16, 2647, {1, 3, 7, 15, 13, 29, 77, 115, 229, 721, 1339, 2615, 6269, 8455, 27439, 15993}},
    {3822, 16, 2660, {1, 3, 5, 15, 9, 31, 89, 131, 349, 959, 1691, 951, 575, 11351, 13971, 15063}},
    {3823, 16, 2664, {1, 3, 7, 1, 5, 11, 49, 167, 229, 737, 105, 747, 5575, 7645, 24091, 41237}},
    {3824, 16, 2678, {1, 3, 7, 3, 31, 31, 97, 59, 271, 935, 1445, 3467, 97, 13773, 7565, 59711}},
    {3825, 16, 2684, {1, 1, 5, 13, 31, 19, 99, 73, 489, 277, 2021, 3945, 7477, 1895, 17653, 47231}},
    {3826, 16, 2691, {1, 3, 5, 13, 11, 57, 25, 123, 481, 369, 1103, 443, 4605, 14691, 17263, 4451}},
    {3827, 16, 2759, {1, 3, 7, 9, 15, 33, 121, 113, 1, 929, 807, 3101, 2195, 4321, 22071, 48199}},
    {3828, 16, 2768, {1, 3, 3, 13, 1, 35, 119, 39, 197, 75, 603, 507, 1083, 5243, 22525, 43441}},
    {3829, 16, 2773, {1, 1, 5, 9, 23, 53, 19, 5, 91, 973, 903, 3361, 7025, 5127, 25143, 17689}},
    {3830, 16, 2794, {1, 3, 3, 7, 11, 23, 79, 195, 259, 819, 1057, 3423, 1113, 1251, 12989, 34599}},
    {3831, 16, 2813, {1, 3, 5, 13, 23, 45, 5, 211, 147, 93, 765, 533, 5927, 11115, 24587, 10721}},
    {3832, 16, 2831, {1, 1, 3, 3, 29, 9, 13, 163, 371, 637, 575, 2195, 303, 1575, 10153, 29383}},
    {3833, 16, 2843, {1, 1, 7, 5, 25, 57, 107, 217, 333, 451, 615, 905, 1553, 14645, 13293, 36507}},
    {3834, 16, 2846, {1, 3, 7, 13, 23, 1, 31, 137, 259, 727, 1681, 1323, 2959, 12631, 31771, 33627}},
    {3835, 16, 2849, {1, 1, 5, 3, 29, 27, 65, 69, 423, 959, 1379, 3199, 4475, 11597, 16011, 21193}},
    {3836, 16, 2856, {1, 3, 7, 13, 5, 27, 43, 227, 461, 557, 1667, 617, 765, 14101, 21207, 3165}},
    {3837, 16, 2893, {1, 3, 5, 3, 7, 35, 69, 115, 217, 31, 609, 2975, 1473, 1, 31445, 35195}},
    {3838, 16, 2901, {1, 1, 5, 7, 29, 41, 9, 235, 231, 439, 1863, 2653, 1971, 12031, 16305, 54117}},
    {3839, 16, 2924, {1, 1, 5, 5, 21, 55, 47, 35, 239, 913, 1151, 2771, 1159, 2857, 31009, 47041}},
    {3840, 16, 2942, {1, 1, 1, 5, 7, 39, 75, 229, 439, 653, 1799, 3175, 1629, 15777, 29405, 189}},
    {3841, 16, 2975, {1, 1, 1, 5, 5, 63, 91, 159, 259, 49, 1993, 117, 3909, 11299, 25555, 42053}},
    {3842, 16, 2979, {1, 3, 1, 7, 19, 43, 43, 247, 443, 189, 725, 1717, 2529, 4625, 13645, 2221}},
    {3843, 16, 2985, {1, 3, 5, 15, 17, 29, 121, 237, 163, 467, 1305, 3409, 2293, 3683, 23, 16437}},
    {3844, 16, 3020, {1, 1, 7, 9, 21, 55, 103, 201, 495, 531, 509, 3609, 5797, 8087, 533, 40947}},
    {3845, 16, 3025, {1, 1, 1, 3, 31, 41, 51, 37, 71, 557, 467, 605, 6695, 9913, 11321, 1719}},
    {3846, 16, 3028, {1, 1, 1, 1, 1, 35, 19, 49, 39, 967, 751, 845, 3319, 15269, 32613, 16769}},
    {3847, 16, 3051, {1, 1, 3, 5, 3, 31, 101, 95, 109, 743, 1579, 3479, 1967, 5591, 15217, 61387}},
    {3848, 16, 3127, {1, 3, 3, 3, 15, 7, 29, 39, 495, 5, 755, 2363, 2243, 15563, 1121, 39087}},
    {3849, 16, 3142, {1, 1, 5, 13, 29, 3, 47, 87, 57, 37, 1405, 1547, 1995, 2363, 12159, 28287}},
    {3850, 16, 3145, {1, 3, 3, 9, 5, 59, 45, 19, 493, 221, 919, 1063, 7679, 8749, 31583, 21935}},
    {3851, 16, 3156, {1, 3, 7, 15, 15, 49, 61, 91, 119, 53, 609, 3001, 7379, 2223, 14715, 56317}},
    {3852, 16, 3165, {1, 1, 7, 7, 29, 27, 69, 141, 187, 123, 1981, 1689, 4707, 3107, 21729, 51457}},
    {3853, 16, 3196, {1, 3, 3, 15, 27, 59, 93, 215, 3, 331, 309, 779, 2141, 7747, 21157, 39315}},
    {3854, 16, 3199, {1, 1, 7, 11, 3, 21, 31, 61, 401, 113, 669, 2027, 1581, 12957, 25963, 30311}},
    {3855, 16, 3217, {1, 3, 3, 13, 1, 29, 21, 157, 257, 1015, 1957, 1731, 273, 5037, 7443, 6737}},
    {3856, 16, 3218, {1, 1, 7, 3, 29, 51, 43, 135, 193, 767, 279, 665, 4201, 15081, 19827, 18567}},
    {3857, 16, 3253, {1, 1, 7, 7, 27, 5, 77, 247, 19, 123, 1735, 357, 8079, 3219, 10695, 6255}},
    {3858, 16, 3258, {1, 1, 5, 7, 17, 57, 99, 7, 323, 7, 571, 1693, 8105, 15073, 20287, 4751}},
    {3859, 16, 3260, {1, 1, 3, 11, 29, 1, 109, 151, 351, 753, 309, 669, 4267, 895, 2021, 13997}},
    {3860, 16, 3289, {1, 1, 3, 13, 5, 11, 29, 173, 461, 593, 891, 3115, 2737, 5451, 12365, 30615}},
    {3861, 16, 3314, {1, 3, 5, 5, 25, 17, 91, 85, 69, 393, 1581, 259, 1163, 6085, 17461, 25833}},
    {3862, 16, 3326, {1, 1, 5, 13, 23, 49, 7, 239, 267, 227, 127, 2473, 1013, 16359, 6097, 26481}},
    {3863, 16, 3331, {1, 3, 7, 5, 15, 33, 91, 97, 225, 927, 441, 2171, 6655, 11223, 31835, 18075}},
    {3864, 16, 3371, {1, 3, 1, 3, 13, 51, 37, 65, 331, 321, 277, 3349, 2835, 9687, 963, 31167}},
    {3865, 16, 3381, {1, 3, 3, 1, 5, 9, 39, 167, 475, 833, 1959, 49, 7667, 1245, 29087, 35207}},
    {3866, 16, 3396, {1, 3, 7, 1, 11, 1, 79, 35, 141, 85, 327, 2097, 3723, 13457, 5087, 6279}},
    {3867, 16, 3441, {1, 3, 7, 9, 29, 23, 51, 109, 351, 421, 1025, 3031, 5931, 13903, 17465, 20155}},
    {3868, 16, 3442, {1, 3, 1, 3, 9, 5, 41, 101, 367, 959, 1681, 1475, 7467, 11221, 2651, 1433}},
    {3869, 16, 3460, {1, 1, 5, 3, 21, 17, 81, 137, 399, 315, 655, 857, 1327, 2071, 30785, 44713}},
    {3870, 16, 3477, {1, 3, 5, 1, 11, 47, 15, 161, 349, 397, 1537, 1137, 529, 9789, 10481, 44409}},
    {3871, 16, 3491, {1, 1, 3, 3, 3, 21, 63, 117, 497, 27, 1789, 3789, 3677, 15033, 1679, 52413}},
    {3872, 16, 3493, {1, 3, 3, 15, 15, 29, 3, 211, 439, 781, 1267, 1923, 4179, 7105, 8985, 37461}},
    {3873, 16, 3543, {1, 1, 7, 15, 19, 59, 77, 113, 505, 749, 1255, 329, 1461, 1907, 2905, 26565}},
    {3874, 16, 3549, {1, 3, 7, 5, 3, 55, 73, 113, 217, 961, 1077, 501, 5417, 3411, 27507, 56793}},
    {3875, 16, 3550, {1, 3, 7, 15, 17, 35, 123, 103, 143, 481, 715, 1965, 6703, 3391, 21569, 7953}},
    {3876, 16, 3553, {1, 1, 1, 1, 3, 15, 93, 51, 163, 843, 263, 613, 2507, 4823, 17867, 47249}},
    {3877, 16, 3563, {1, 1, 3, 11, 5, 27, 119, 195, 461, 125, 851, 3477, 4013, 10513, 29609, 55407}},
    {3878, 16, 3568, {1, 3, 1, 15, 5, 47, 27, 27, 31, 561, 1927, 1079, 459, 5971, 16539, 58725}},
    {3879, 16, 3604, {1, 3, 5, 5, 21, 31, 77, 239, 95, 951, 1579, 2511, 2423, 16263, 25351, 8415}},
    {3880, 16, 3632, {1, 3, 7, 13, 7, 17, 51, 159, 291, 601, 1323, 1475, 2857, 1769, 15929, 25649}},
    {3881, 16, 3650, {1, 3, 3, 15, 17, 9, 45, 121, 451, 633, 605, 1835, 3561, 14149, 9967, 20999}},
    {3882, 16, 3662, {1, 1, 1, 13, 27, 3, 33, 107, 41, 535, 1793, 1755, 5417, 14953, 28345, 46707}},
    {3883, 16, 3674, {1, 3, 7, 15, 27, 27, 11, 197, 489, 253, 141, 2685, 485, 9347, 13309, 56093}},
    {3884, 16, 3685, {1, 1, 3, 7, 3, 61, 19, 171, 387, 413, 551, 655, 6953, 2721, 28639, 53525}},
    {3885, 16, 3686, {1, 3, 1, 9, 17, 1, 11, 115, 407, 287, 5, 3157, 4553, 1961, 22309, 59481}},
    {3886, 16, 3700, {1, 3, 5, 13, 29, 39, 33, 189, 303, 395, 799, 703, 3039, 9453, 24119, 17515}},
    {3887, 16, 3703, {1, 3, 7, 3, 15, 1, 57, 169, 499, 19, 1475, 2931, 5239, 7921, 30899, 65}},
    {3888, 16, 3704, {1, 1, 1, 1, 31, 53, 11, 243, 5, 655, 481, 1051, 5073, 7329, 4229, 64009}},
    {3889, 16, 3723, {1, 3, 3, 11, 21, 55, 27, 49, 339, 99, 1159, 1923, 7325, 5573, 11099, 861}},
    {3890, 16, 3743, {1, 3, 5, 5, 31, 33, 73, 181, 495, 383, 291, 1977, 4913, 4253, 15871, 54637}},
    {3891, 16, 3753, {1, 1, 3, 15, 9, 11, 53, 129, 311, 367, 333, 3673, 7371, 3155, 411, 47955}},
    {3892, 16, 3756, {1, 1, 3, 3, 1, 31, 9, 127, 489, 49, 1849, 2825, 6907, 12641, 30425, 57769}},
    {3893, 16, 3759, {1, 3, 3, 3, 23, 37, 35, 165, 47, 967, 501, 15, 3523, 16243, 11379, 45959}},
    {3894, 16, 3762, {1, 3, 1, 11, 29, 51, 81, 149, 459, 65, 125, 3329, 7201, 327, 31013, 1733}},
    {3895, 16, 3771, {1, 3, 7, 9, 5, 61, 47, 159, 63, 255, 1021, 3405, 1, 15251, 13405, 65469}},
    {3896, 16, 3776, {1, 3, 5, 13, 9, 55, 127, 163, 131, 149, 149, 3585, 4687, 5197, 27677, 8801}},
    {3897, 16, 3779, {1, 1, 1, 15, 3, 13, 97, 161, 183, 735, 763, 2055, 6005, 14039, 22869, 65023}},
    {3898, 16, 3839, {1, 3, 7, 11, 21, 37, 113, 221, 261, 275, 1759, 39, 2935, 12303, 7325, 18303}},
    {3899, 16, 3856, {1, 3, 1, 3, 3, 31, 15, 19, 125, 157, 1233, 4075, 2261, 11071, 1017, 5343}},
    {3900, 16, 3871, {1, 1, 1, 5, 29, 37, 127, 143, 259, 813, 935, 977, 2521, 12441, 21167, 23071}},
    {3901, 16, 3887, {1, 3, 1, 13, 1, 43, 1, 241, 401, 793, 847, 2689, 6413, 9693, 24855, 10309}},
    {3902, 16, 3896, {1, 3, 7, 13, 17, 63, 25, 169, 71, 991, 2021, 1985, 797, 13325, 2033, 30737}},
    {3903, 16, 3901, {1, 3, 3, 3, 23, 47, 27, 61, 473, 415, 671, 97, 3843, 11673, 29667, 9485}},
    {3904, 16, 3916, {1, 3, 7, 7, 17, 55, 95, 241, 23, 727, 927, 2819, 607, 16247, 13101, 50595}},
    {3905, 16, 3919, {1, 1, 3, 1, 17, 27, 79, 73, 3, 233, 1475, 2363, 1817, 13717, 23457, 23031}},
    {3906, 16, 3937, {1, 1, 1, 11, 9, 3, 3, 167, 407, 269, 845, 4057, 5221, 5305, 20291, 18865}},
    {3907, 16, 3943, {1, 1, 5, 13, 3, 27, 15, 17, 165, 961, 1775, 509, 5373, 2135, 1805, 63203}},
    {3908, 16, 3955, {1, 3, 3, 5, 1, 11, 29, 167, 149, 277, 891, 4011, 3695, 9815, 32139, 4303}},
    {3909, 16, 3961, {1, 1, 1, 3, 19, 57, 41, 29, 489, 169, 1567, 2117, 4759, 5259, 3983, 61915}},
    {3910, 16, 3988, {1, 1, 7, 11, 19, 57, 5, 5, 111, 367, 647, 2475, 4671, 8327, 20025, 30997}},
    {3911, 16, 3997, {1, 3, 3, 7, 15, 43, 25, 155, 173, 337, 855, 3411, 405, 14955, 10053, 11955}},
    {3912, 16, 4011, {1, 3, 5, 11, 17, 63, 53, 183, 165, 951, 937, 3313, 4825, 2209, 30631, 46053}},
    {3913, 16, 4026, {1, 3, 7, 7, 1, 39, 47, 255, 177, 779, 115, 2751, 6435, 6899, 24645, 36947}},
    {3914, 16, 4033, {1, 1, 1, 3, 11, 53, 127, 253, 69, 695, 81, 1673, 5161, 1553, 22275, 3611}},
    {3915, 16, 4045, {1, 3, 1, 11, 17, 17, 93, 131, 393, 105, 329, 699, 1085, 7661, 12097, 47737}},
    {3916, 16, 4060, {1, 1, 1, 3, 29, 15, 115, 227, 371, 443, 1725, 3389, 923, 13349, 7119, 55873}},
    {3917, 16, 4063, {1, 1, 3, 9, 29, 39, 59, 117, 119, 801, 967, 1935, 2393, 8261, 21025, 22075}},
    {3918, 16, 4064, {1, 1, 7, 9, 21, 37, 63, 141, 335, 549, 1883, 2189, 5135, 15735, 1285, 25083}},
    {3919, 16, 4126, {1, 3, 5, 7, 5, 33, 67, 211, 507, 715, 789, 1375, 2681, 9915, 29475, 24639}},
    {3920, 16, 4136, {1, 3, 7, 9, 9, 29, 53, 217, 201, 745, 1243, 1917, 3047, 8303, 3243, 9831}},
    {3921, 16, 4167, {1, 1, 1, 9, 23, 41, 21, 23, 201, 701, 1665, 3305, 2105, 2013, 2479, 17291}},
    {3922, 16, 4173, {1, 3, 7, 9, 17, 3, 77, 71, 39, 95, 1109, 997, 1593, 1989, 13795, 61139}},
    {3923, 16, 4188, {1, 1, 7, 5, 27, 31, 39, 207, 437, 989, 891, 1811, 11, 3549, 23183, 38393}},
    {3924, 16, 4195, {1, 1, 1, 13, 21, 27, 49, 107, 35, 623, 1361, 449, 4321, 12627, 16471, 41415}},
    {3925, 16, 4226, {1, 1, 7, 7, 11, 15, 33, 193, 127, 217, 1107, 3647, 1321, 13733, 8465, 19391}},
    {3926, 16, 4291, {1, 3, 7, 9, 11, 11, 65, 59, 395, 687, 1237, 17, 3233, 1567, 31213, 34805}},
    {3927, 16, 4298, {1, 3, 7, 13, 9, 51, 61, 67, 385, 733, 113, 3193, 867, 5365, 16501, 53257}},
    {3928, 16, 4308, {1, 3, 5, 1, 23, 15, 63, 137, 147, 505, 1519, 2087, 5223, 2757, 15057, 37899}},
    {3929, 16, 4312, {1, 1, 1, 3, 27, 13, 1, 155, 41, 221, 1731, 469, 1403, 5045, 22393, 14741}},
    {3930, 16, 4336, {1, 3, 1, 3, 11, 41, 49, 221, 135, 525, 1609, 2647, 119, 2781, 30615, 20417}},
    {3931, 16, 4371, {1, 3, 5, 9, 13, 57, 1, 47, 495, 229, 483, 3085, 1427, 10913, 8169, 2995}},
    {3932, 16, 4378, {1, 3, 5, 1, 23, 11, 67, 145, 119, 853, 1949, 1563, 7167, 4219, 2489, 60747}},
    {3933, 16, 4384, {1, 1, 5, 11, 13, 21, 107, 203, 161, 179, 837, 3209, 7437, 10897, 8607, 22471}},
    {3934, 16, 4393, {1, 3, 3, 5, 17, 5, 41, 79, 389, 121, 1437, 1049, 3361, 14371, 6189, 21075}},
    {3935, 16, 4421, {1, 3, 1, 7, 27, 17, 73, 145, 113, 969, 879, 1483, 973, 14671, 3287, 45215}},
    {3936, 16, 4425, {1, 1, 1, 7, 11, 5, 43, 101, 271, 919, 609, 1247, 1293, 8065, 5961, 13699}},
    {3937, 16, 4439, {1, 1, 1, 7, 25, 19, 47, 209, 389, 305, 729, 7, 5857, 13589, 15765, 55861}},
    {3938, 16, 4440, {1, 1, 3, 15, 31, 23, 51, 103, 295, 195, 1101, 2645, 943, 12257, 15835, 40481}},
    {3939, 16, 4500, {1, 3, 5, 7, 1, 37, 13, 57, 313, 785, 255, 1339, 5041, 11341, 24613, 10615}},
    {3940, 16, 4514, {1, 3, 1, 15, 27, 1, 9, 55, 403, 961, 835, 1079, 5935, 6113, 16243, 14989}},
    {3941, 16, 4523, {1, 3, 7, 13, 21, 55, 13, 161, 247, 697, 893, 3109, 6279, 16209, 20385, 18159}},
    {3942, 16, 4534, {1, 1, 5, 13, 3, 63, 65, 53, 137, 695, 371, 879, 2055, 15753, 23635, 59453}},
    {3943, 16, 4593, {1, 3, 1, 11, 13, 29, 113, 43, 477, 733, 1209, 851, 6361, 7343, 14029, 543}},
    {3944, 16, 4615, {1, 1, 3, 3, 5, 25, 39, 215, 249, 875, 1453, 443, 2597, 4533, 16955, 14309}},
    {3945, 16, 4630, {1, 3, 3, 9, 15, 61, 97, 195, 175, 267, 983, 2073, 529, 7763, 7721, 1057}},
    {3946, 16, 4636, {1, 1, 1, 11, 15, 57, 105, 173, 47, 775, 1857, 3919, 6565, 2571, 12611, 59801}},
    {3947, 16, 4645, {1, 1, 5, 7, 29, 3, 121, 105, 391, 807, 1419, 3351, 2751, 6751, 30911, 7701}},
    {3948, 16, 4684, {1, 3, 7, 3, 23, 17, 19, 77, 493, 699, 1461, 2603, 4879, 14629, 25545, 16799}},
    {3949, 16, 4687, {1, 3, 5, 1, 15, 23, 9, 209, 31, 653, 947, 175, 5723, 6645, 7633, 20563}},
    {3950, 16, 4723, {1, 1, 1, 11, 11, 45, 81, 41, 53, 31, 1799, 2757, 3851, 10701, 27519, 37757}},
    {3951, 16, 4735, {1, 3, 5, 5, 19, 5, 21, 55, 419, 513, 1735, 3075, 5451, 12643, 2307, 27365}},
    {3952, 16, 4746, {1, 3, 1, 11, 7, 43, 19, 29, 5, 173, 151, 3183, 19, 5343, 4507, 6573}},
    {3953, 16, 4779, {1, 1, 3, 11, 11, 63, 13, 143, 127, 857, 173, 3027, 4323, 13783, 2161, 49955}},
    {3954, 16, 4782, {1, 1, 5, 11, 5, 23, 107, 13, 27, 837, 1339, 1697, 2257, 12411, 16453, 17773}},
    {3955, 16, 4793, {1, 3, 1, 15, 21, 45, 25, 121, 67, 1011, 691, 3893, 1847, 7033, 15663, 41825}},
    {3956, 16, 4796, {1, 1, 3, 7, 3, 61, 65, 167, 113, 775, 797, 809, 7817, 2511, 16007, 54513}},
    {3957, 16, 4813, {1, 3, 7, 15, 15, 47, 19, 229, 319, 975, 1075, 129, 6833, 12001, 18717, 40899}},
    {3958, 16, 4850, {1, 1, 3, 15, 21, 41, 63, 181, 339, 951, 1903, 2695, 7905, 883, 22977, 50501}},
    {3959, 16, 4867, {1, 1, 1, 9, 15, 61, 49, 111, 161, 447, 569, 1401, 7761, 15987, 8317, 13815}},
    {3960, 16, 4874, {1, 1, 1, 5, 13, 55, 105, 57, 151, 569, 1403, 177, 7185, 4601, 8697, 64255}},
    {3961, 16, 4881, {1, 3, 3, 13, 21, 51, 49, 81, 11, 913, 327, 2957, 4457, 15425, 24179, 37385}},
    {3962, 16, 4894, {1, 1, 1, 7, 19, 25, 43, 21, 407, 477, 1757, 4051, 3647, 3131, 18369, 8681}},
    {3963, 16, 4904, {1, 1, 5, 1, 19, 19, 67, 243, 33, 73, 305, 1241, 6035, 11151, 6455, 50339}},
    {3964, 16, 4927, {1, 1, 3, 13, 31, 35, 119, 97, 483, 329, 1219, 2553, 6119, 3243, 12011, 12133}},
    {3965, 16, 4929, {1, 1, 3, 1, 11, 15, 127, 243, 473, 735, 281, 725, 7705, 5237, 1243, 20857}},
    {3966, 16, 4989, {1, 1, 3, 3, 13, 47, 9, 87, 165, 163, 757, 1123, 5155, 7317, 9087, 21531}},
    {3967, 16, 5000, {1, 3, 1, 15, 19, 23, 1, 103, 103, 17, 1067, 787, 1985, 14621, 6683, 65001}},
    {3968, 16, 5020, {1, 1, 5, 1, 17, 19, 101, 237, 129, 529, 1321, 2623, 7357, 2257, 12341, 31413}},
    {3969, 16, 5036, {1, 3, 5, 9, 21, 39, 81, 45, 407, 231, 1563, 2699, 4689, 14029, 27467, 36115}},
    {3970, 16, 5041, {1, 1, 7, 13, 31, 15, 87, 117, 119, 471, 1283, 593, 2241, 8425, 24045, 49897}},
    {3971, 16, 5059, {1, 1, 5, 7, 15, 1, 119, 91, 389, 375, 1573, 921, 4375, 14349, 1779, 22705}},
    {3972, 16, 5074, {1, 1, 3, 1, 23, 37, 95, 213, 11, 143, 1015, 235, 6383, 13747, 4633, 20679}},
    {3973, 16, 5090, {1, 1, 5, 9, 9, 7, 15, 159, 411, 989, 917, 2593, 2049, 6859, 23241, 42477}},
    {3974, 16, 5110, {1, 1, 1, 11, 17, 5, 81, 39, 275, 615, 1819, 2387, 3225, 3043, 22349, 11985}},
    {3975, 16, 5134, {1, 3, 3, 9, 21, 15, 121, 139, 455, 329, 111, 1597, 6463, 185, 5817, 16655}},
    {3976, 16, 5152, {1, 3, 5, 13, 23, 25, 53, 115, 443, 107, 793, 1397, 6951, 6583, 7715, 1949}},
    {3977, 16, 5176, {1, 1, 3, 5, 21, 23, 115, 127, 367, 671, 27, 949, 5101, 11439, 15003, 6835}},
    {3978, 16, 5181, {1, 1, 7, 15, 5, 49, 11, 219, 431, 529, 897, 2681, 7309, 13151, 23701, 27009}},
    {3979, 16, 5204, {1, 1, 1, 5, 27, 53, 17, 219, 451, 429, 1443, 661, 1283, 7317, 6285, 15555}},
    {3980, 16, 5218, {1, 1, 5, 11, 17, 49, 33, 167, 237, 335, 1737, 1333, 2545, 6535, 29601, 7671}},
    {3981, 16, 5242, {1, 1, 5, 11, 29, 11, 29, 133, 421, 785, 697, 3737, 7123, 1291, 32603, 60095}},
    {3982, 16, 5253, {1, 3, 1, 11, 27, 41, 103, 115, 3, 955, 1793, 3553, 2031, 5187, 29345, 14017}},
    {3983, 16, 5260, {1, 1, 5, 13, 27, 43, 73, 233, 297, 757, 259, 3085, 3347, 211, 25197, 11909}},
    {3984, 16, 5281, {1, 3, 7, 1, 29, 23, 43, 61, 465, 991, 497, 635, 4113, 4701, 10819, 58767}},
    {3985, 16, 5282, {1, 1, 3, 15, 7, 19, 43, 93, 429, 823, 457, 63, 1845, 10477, 28347, 26949}},
    {3986, 16, 5313, {1, 1, 1, 5, 3, 43, 61, 77, 429, 891, 1477, 3767, 3951, 13955, 8411, 55267}},
    {3987, 16, 5316, {1, 1, 1, 15, 19, 45, 3, 249, 419, 697, 1167, 4057, 6609, 3539, 25411, 23685}},
    {3988, 16, 5326, {1, 3, 5, 5, 29, 29, 55, 111, 431, 567, 1877, 3335, 4235, 12305, 3873, 30621}},
    {3989, 16, 5340, {1, 3, 3, 13, 17, 29, 123, 201, 41, 61, 371, 4073, 1673, 7567, 11895, 31645}},
    {3990, 16, 5347, {1, 1, 3, 5, 23, 43, 109, 115, 481, 175, 1355, 1937, 6649, 2853, 7705, 19427}},
    {3991, 16, 5354, {1, 3, 7, 1, 7, 15, 97, 37, 499, 791, 1987, 3497, 5025, 15051, 19477, 18553}},
    {3992, 16, 5368, {1, 3, 7, 1, 31, 11, 21, 47, 109, 195, 1993, 1585, 6581, 12543, 24031, 465}},
    {3993, 16, 5394, {1, 1, 1, 15, 13, 45, 13, 149, 271, 359, 1377, 471, 5663, 3805, 2033, 8283}},
    {3994, 16, 5396, {1, 1, 7, 11, 23, 37, 93, 255, 449, 843, 471, 845, 681, 11283, 18975, 17675}},
    {3995, 16, 5400, {1, 1, 7, 13, 13, 45, 1, 163, 471, 795, 829, 4095, 6265, 13239, 3875, 52395}},
    {3996, 16, 5405, {1, 3, 3, 1, 25, 59, 1, 221, 73, 735, 393, 1335, 2157, 12985, 3711, 62507}},
    {3997, 16, 5439, {1, 3, 3, 15, 21, 57, 51, 45, 291, 771, 837, 2085, 7463, 12151, 271, 37433}},
    {3998, 16, 5442, {1, 1, 3, 5, 7, 23, 5, 19, 153, 971, 1377, 533, 4515, 1977, 24347, 6399}},
    {3999, 16, 5459, {1, 3, 5, 5, 27, 35, 47, 61, 103, 895, 699, 661, 4151, 4809, 16673, 14463}},
    {4000, 16, 5478, {1, 3, 5, 5, 7, 59, 1, 125, 425, 855, 1859, 3983, 5593, 2371, 28199, 13255}},
    {4001, 16, 5484, {1, 3, 5, 7, 23, 37, 11, 31, 19, 533, 833, 1893, 6591, 4409, 12929, 22893}},
    {4002, 16, 5508, {1, 3, 7, 3, 9, 59, 59, 225, 353, 851, 1371, 1395, 781, 5919, 25033, 7523}},
    {4003, 16, 5523, {1, 1, 1, 1, 31, 61, 107, 57, 469, 769, 9, 3509, 2121, 3219, 25279, 18233}},
    {4004, 16, 5545, {1, 1, 5, 7, 9, 55, 31, 153, 277, 725, 1837, 2343, 4073, 1303, 15773, 50657}},
    {4005, 16, 5565, {1, 3, 3, 1, 29, 51, 31, 99, 115, 405, 447, 1313, 6235, 13403, 12701, 58657}},
    {4006, 16, 5566, {1, 1, 5, 1, 5, 53, 49, 143, 143, 115, 995, 51, 973, 6151, 25663, 28389}},
    {4007, 16, 5580, {1, 1, 1, 9, 27, 29, 55, 127, 493, 621, 1369, 3497, 1279, 11087, 8135, 36363}},
    {4008, 16, 5608, {1, 1, 3, 7, 19, 21, 95, 217, 65, 367, 763, 1777, 1119, 11941, 12943, 50751}},
    {4009, 16, 5613, {1, 3, 7, 3, 29, 9, 3, 171, 73, 695, 1457, 3503, 5739, 4239, 17155, 6401}},
    {4010, 16, 5647, {1, 3, 1, 3, 23, 19, 125, 243, 67, 547, 129, 115, 2463, 11647, 5629, 9045}},
    {4011, 16, 5661, {1, 1, 7, 1, 23, 17, 115, 203, 461, 517, 349, 3981, 5865, 13891, 29507, 62307}},
    {4012, 16, 5671, {1, 3, 1, 11, 7, 57, 15, 253, 23, 635, 245, 3995, 6411, 10083, 9157, 29551}},
    {4013, 16, 5678, {1, 1, 7, 7, 7, 49, 127, 33, 325, 361, 1319, 1377, 7889, 4989, 14087, 13145}},
    {4014, 16, 5680, {1, 3, 7, 3, 31, 37, 97, 197, 435, 247, 1413, 3, 271, 6519, 31231, 45937}},
    {4015, 16, 5685, {1, 3, 3, 11, 3, 37, 57, 157, 473, 251, 1631, 1773, 3751, 2231, 9493, 6857}},
    {4016, 16, 5689, {1, 1, 7, 13, 25, 35, 25, 123, 3, 967, 373, 2149, 4743, 9769, 16215, 44015}},
    {4017, 16, 5692, {1, 1, 3, 9, 11, 1, 97, 121, 133, 411, 1509, 1711, 3285, 15145, 19289, 29803}},
    {4018, 16, 5724, {1, 1, 7, 9, 19, 5, 61, 179, 367, 207, 127, 3849, 3791, 6807, 5715, 50685}},
    {4019, 16, 5745, {1, 3, 3, 15, 11, 23, 19, 17, 341, 787, 1933, 2899, 1939, 9881, 26433, 22823}},
    {4020, 16, 5755, {1, 3, 5, 3, 31, 55, 85, 189, 343, 553, 223, 3737, 2271, 9693, 8689, 6131}},
    {4021, 16, 5757, {1, 1, 7, 11, 17, 37, 75, 63, 121, 259, 781, 2567, 3987, 1055, 31777, 10587}},
    {4022, 16, 5786, {1, 1, 1, 5, 11, 27, 1, 117, 69, 757, 743, 3849, 6315, 11773, 27147, 42411}},
    {4023, 16, 5792, {1, 1, 1, 5, 7, 21, 87, 157, 205, 375, 325, 1935, 2977, 8647, 897, 30549}},
    {4024, 16, 5810, {1, 1, 1, 3, 1, 17, 103, 217, 469, 65, 1995, 701, 3113, 9135, 7161, 22355}},
    {4025, 16, 5824, {1, 3, 5, 3, 3, 33, 41, 199, 29, 425, 895, 3981, 4399, 3709, 3851, 39539}},
    {4026, 16, 5869, {1, 1, 5, 7, 3, 61, 49, 25, 359, 9, 1525, 4087, 4321, 9859, 1275, 45847}},
    {4027, 16, 5872, {1, 3, 5, 11, 31, 31, 3, 91, 501, 431, 55, 2085, 7645, 13753, 26381, 28181}},
    {4028, 16, 5895, {1, 3, 1, 15, 17, 33, 25, 175, 65, 17, 211, 551, 6975, 85, 5049, 11477}},
    {4029, 16, 5923, {1, 3, 7, 3, 17, 29, 43, 125, 487, 829, 1175, 2167, 6745, 8511, 549, 46497}},
    {4030, 16, 5925, {1, 1, 1, 3, 9, 13, 87, 109, 173, 493, 43, 3997, 4739, 14033, 21867, 8565}},
    {4031, 16, 5926, {1, 1, 5, 15, 11, 51, 73, 241, 365, 711, 671, 1799, 7701, 11089, 13119, 62149}},
    {4032, 16, 5944, {1, 3, 7, 9, 17, 39, 3, 195, 329, 741, 183, 3355, 3499, 14759, 10863, 3573}},
    {4033, 16, 5986, {1, 1, 1, 13, 13, 33, 121, 35, 173, 377, 423, 4053, 6957, 2097, 13439, 52653}},
    {4034, 16, 6012, {1, 3, 3, 9, 5, 23, 85, 35, 307, 863, 1615, 3905, 4293, 14853, 20321, 12143}},
    {4035, 16, 6015, {1, 3, 3, 7, 17, 49, 51, 115, 129, 101, 1849, 4013, 3845, 3101, 10345, 40319}},
    {4036, 16, 6046, {1, 3, 7, 11, 13, 23, 51, 217, 51, 583, 1403, 1103, 1025, 8067, 7571, 34767}},
    {4037, 16, 6049, {1, 3, 1, 5, 17, 3, 7, 9, 479, 235, 1063, 599, 7525, 12901, 17315, 12317}},
    {4038, 16, 6061, {1, 3, 3, 11, 3, 21, 57, 175, 123, 413, 223, 1953, 4015, 10893, 10451, 62973}},
    {4039, 16, 6067, {1, 1, 1, 13, 9, 51, 15, 9, 485, 827, 1851, 1213, 5063, 14543, 12429, 59007}},
    {4040, 16, 6099, {1, 1, 5, 13, 1, 53, 55, 105, 339, 99, 1311, 1965, 2389, 4299, 4533, 43827}},
    {4041, 16, 6121, {1, 1, 7, 3, 21, 1, 51, 165, 93, 569, 597, 571, 7667, 13391, 22169, 13985}},
    {4042, 16, 6155, {1, 3, 3, 11, 19, 43, 9, 153, 105, 297, 1425, 1671, 3673, 4009, 14891, 2051}},
    {4043, 16, 6163, {1, 1, 7, 15, 17, 3, 31, 99, 325, 71, 1983, 3585, 7381, 1479, 29643, 22189}},
    {4044, 16, 6203, {1, 1, 3, 3, 29, 41, 83, 9, 377, 661, 1219, 2823, 91, 5561, 30499, 46969}},
    {4045, 16, 6208, {1, 1, 3, 9, 5, 13, 123, 243, 107, 901, 271, 905, 2201, 6475, 32705, 27207}},
    {4046, 16, 6231, {1, 1, 5, 1, 27, 7, 65, 129, 159, 103, 1895, 1661, 8111, 1155, 10031, 49601}},
    {4047, 16, 6241, {1, 1, 7, 1, 21, 3, 127, 63, 1, 799, 1087, 2727, 291, 13083, 709, 35011}},
    {4048, 16, 6254, {1, 1, 5, 1, 27, 1, 81, 49, 41, 447, 1417, 819, 471, 2025, 12401, 30201}},
    {4049, 16, 6262, {1, 3, 1, 9, 19, 21, 95, 73, 47, 153, 1427, 1665, 3643, 12365, 7173, 9965}},
    {4050, 16, 6266, {1, 3, 5, 3, 19, 55, 13, 125, 133, 627, 403, 905, 5821, 6651, 11243, 50425}},
    {4051, 16, 6275, {1, 1, 7, 11, 13, 45, 41, 199, 435, 753, 455, 2879, 6553, 3505, 335, 35537}},
    {4052, 16, 6278, {1, 1, 7, 13, 27, 41, 73, 147, 167, 507, 911, 903, 4169, 3413, 21623, 30795}},
    {4053, 16, 6292, {1, 1, 1, 13, 11, 33, 79, 177, 73, 141, 373, 1197, 5627, 5439, 16475, 17891}},
    {4054, 16, 6329, {1, 3, 7, 3, 17, 31, 49, 101, 219, 733, 1383, 3399, 2887, 13169, 17301, 3393}},
    {4055, 16, 6355, {1, 3, 7, 1, 1, 43, 117, 225, 503, 691, 687, 3957, 6517, 2195, 27653, 34683}},
    {4056, 16, 6357, {1, 1, 5, 9, 1, 53, 71, 63, 341, 959, 825, 1717, 437, 7317, 13353, 2851}},
    {4057, 16, 6374, {1, 3, 5, 13, 27, 59, 45, 35, 301, 289, 615, 3847, 2603, 15989, 2003, 47675}},
    {4058, 16, 6380, {1, 1, 1, 7, 11, 29, 71, 133, 425, 53, 2015, 177, 5331, 4599, 12153, 56001}},
    {4059, 16, 6423, {1, 3, 1, 7, 7, 31, 85, 151, 449, 505, 1019, 4029, 7393, 11287, 3953, 23405}},
    {4060, 16, 6427, {1, 3, 5, 1, 31, 45, 107, 253, 41, 711, 1605, 2669, 4483, 4893, 4047, 48887}},
    {4061, 16, 6430, {1, 3, 1, 7, 27, 57, 89, 105, 159, 619, 1879, 69, 2453, 841, 29337, 64633}},
    {4062, 16, 6436, {1, 3, 5, 13, 31, 9, 69, 201, 313, 155, 213, 271, 1565, 9143, 21277, 4485}},
    {4063, 16, 6443, {1, 3, 5, 5, 23, 1, 1, 41, 245, 601, 573, 3465, 3829, 4567, 3437, 64757}},
    {4064, 16, 6445, {1, 1, 5, 13, 3, 11, 19, 173, 207, 441, 751, 2033, 6385, 6633, 16769, 42267}},
    {4065, 16, 6458, {1, 3, 7, 11, 11, 13, 53, 35, 501, 723, 93, 199, 4365, 11077, 12879, 40415}},
    {4066, 16, 6478, {1, 3, 3, 5, 13, 15, 33, 237, 441, 5, 1775, 3011, 1179, 8755, 3913, 52925}},
    {4067, 16, 6490, {1, 1, 7, 15, 31, 3, 35, 49, 159, 921, 691, 1853, 8167, 1999, 17103, 26019}},
    {4068, 16, 6508, {1, 1, 1, 1, 9, 31, 21, 203, 121, 839, 1729, 2403, 3475, 11175, 8367, 39153}},
    {4069, 16, 6519, {1, 1, 3, 11, 17, 41, 19, 213, 361, 383, 945, 1479, 2503, 11141, 23431, 64125}},
    {4070, 16, 6520, {1, 3, 5, 9, 1, 23, 117, 161, 31, 203, 647, 1589, 5805, 15527, 19855, 15649}},
    {4071, 16, 6530, {1, 1, 7, 13, 7, 19, 41, 163, 267, 983, 1097, 1363, 5021, 8101, 23395, 8239}},
    {4072, 16, 6541, {1, 3, 1, 3, 21, 43, 61, 225, 153, 757, 1899, 283, 751, 1413, 23319, 52487}},
    {4073, 16, 6556, {1, 3, 7, 13, 11, 7, 3, 29, 441, 945, 793, 171, 2017, 8993, 30331, 28525}},
    {4074, 16, 6607, {1, 1, 7, 13, 27, 61, 121, 215, 3, 639, 741, 1115, 253, 1603, 16849, 38843}},
    {4075, 16, 6612, {1, 1, 3, 9, 7, 17, 101, 205, 465, 1019, 1323, 1297, 7847, 3201, 12533, 61817}},
    {4076, 16, 6626, {1, 1, 1, 15, 15, 33, 57, 131, 41, 235, 1655, 3599, 7507, 4619, 6627, 13525}},
    {4077, 16, 6632, {1, 3, 7, 11, 31, 57, 13, 35, 355, 9, 1361, 263, 7593, 3959, 2129, 8567}},
    {4078, 16, 6649, {1, 1, 5, 3, 25, 45, 57, 123, 401, 977, 1247, 2603, 2893, 12661, 29937, 47537}},
    {4079, 16, 6666, {1, 3, 7, 5, 23, 51, 13, 25, 269, 987, 1559, 3891, 1625, 6433, 2421, 25167}},
    {4080, 16, 6674, {1, 1, 3, 11, 13, 35, 59, 107, 155, 87, 269, 1397, 5649, 6559, 27001, 47695}},
    {4081, 16, 6733, {1, 3, 5, 13, 7, 7, 9, 191, 181, 777, 639, 1433, 7959, 1341, 24185, 33789}},
    {4082, 16, 6782, {1, 3, 5, 1, 7, 41, 19, 169, 383, 431, 1467, 815, 5259, 15749, 14687, 15859}},
    {4083, 16, 6786, {1, 1, 5, 3, 1, 9, 31, 165, 151, 651, 1263, 9, 5979, 5861, 13137, 63577}},
    {4084, 16, 6798, {1, 3, 7, 13, 27, 19, 1, 49, 15, 45, 595, 4005, 4873, 8935, 21661, 45767}},
    {4085, 16, 6821, {1, 1, 3, 9, 13, 43, 59, 19, 137, 77, 529, 597, 6781, 2765, 24465, 61973}},
    {4086, 16, 6840, {1, 1, 1, 5, 17, 29, 1, 135, 299, 775, 47, 2217, 4817, 13725, 23361, 62091}},
    {4087, 16, 6846, {1, 1, 1, 9, 25, 21, 11, 39, 395, 999, 629, 3057, 6751, 1625, 19483, 28297}},
    {4088, 16, 6865, {1, 1, 1, 7, 27, 43, 23, 181, 223, 519, 789, 393, 1583, 10657, 21683, 54499}},
    {4089, 16, 6884, {1, 1, 3, 13, 3, 39, 5, 113, 213, 965, 1633, 645, 8181, 13713, 2871, 56669}},
    {4090, 16, 6891, {1, 3, 7, 7, 3, 33, 5, 113, 331, 375, 1395, 3477, 4475, 139, 24123, 20203}},
    {4091, 16, 6925, {1, 1, 5, 11, 19, 47, 85, 231, 3, 53, 2027, 1413, 3207, 2475, 25549, 8009}},
    {4092, 16, 6938, {1, 1, 7, 11, 17, 3, 39, 143, 407, 739, 1227, 1245, 3449, 9163, 2551, 22153}},
    {4093, 16, 6967, {1, 3, 1, 1, 7, 27, 83, 45, 179, 875, 181, 1053, 463, 99, 24781, 20647}},
    {4094, 16, 6988, {1, 3, 5, 15, 21, 43, 91, 77, 211, 119, 279, 2301, 2869, 14239, 26879, 51913}},
    {4095, 16, 6996, {1, 1, 7, 13, 25, 39, 61, 185, 297, 603, 141, 1847, 1535, 7555, 31489, 21659}},
    {4096, 16, 7009, {1, 1, 1, 13, 1, 3, 27, 251, 293, 611, 653, 3541, 3483, 2463, 2761, 687}},
    {4097, 16, 7016, {1, 3, 3, 15, 3, 53, 89, 251, 51, 51, 1875, 2649, 2197, 5871, 14099, 39487}},
    {4098, 16, 7030, {1, 3, 7, 5, 17, 3, 65, 91, 125, 285, 1035, 47, 3697, 9429, 17629, 25369}},
    {4099, 16, 7043, {1, 3, 5, 3, 9, 41, 27, 67, 405, 719, 1541, 3315, 7589, 14853, 23895, 51645}},
    {4100, 16, 7045, {1, 1, 5, 11, 15, 21, 87, 29, 479, 313, 1641, 1663, 6171, 10425, 2317, 42375}},
    {4101, 16, 7052, {1, 1, 1, 11, 17, 27, 83, 131, 483, 283, 703, 3115, 3535, 8545, 29313, 52427}},
    {4102, 16, 7073, {1, 3, 1, 3, 13, 1, 79, 213, 389, 601, 179, 831, 3133, 7461, 10185, 25087}},
    {4103, 16, 7142, {1, 3, 1, 1, 27, 55, 23, 3, 55, 733, 1429, 207, 5635, 14317, 31559, 1053}},
    {4104, 16, 7153, {1, 1, 5, 5, 25, 11, 31, 241, 275, 365, 305, 1643, 5279, 12893, 13431, 25959}},
    {4105, 16, 7168, {1, 3, 7, 1, 13, 61, 125, 73, 111, 517, 1473, 3643, 6143, 1401, 6953, 40643}},
    {4106, 16, 7174, {1, 1, 1, 7, 27, 47, 99, 147, 29, 181, 781, 3899, 1783, 5591, 32309, 12759}},
    {4107, 16, 7183, {1, 1, 7, 9, 11, 7, 103, 199, 65, 201, 351, 3085, 7011, 10889, 1093, 6073}},
    {4108, 16, 7195, {1, 1, 1, 3, 5, 49, 103, 157, 235, 131, 845, 619, 4381, 571, 31059, 5111}},
    {4109, 16, 7204, {1, 1, 7, 7, 3, 59, 117, 35, 261, 3, 1171, 649, 1971, 689, 27689, 3253}},
    {4110, 16, 7214, {1, 3, 5, 3, 11, 61, 103, 189, 509, 903, 1157, 2197, 4355, 16337, 17087, 48829}},
    {4111, 16, 7222, {1, 3, 5, 15, 17, 57, 43, 5, 311, 997, 755, 67, 5631, 8897, 20695, 54907}},
    {4112, 16, 7267, {1, 1, 5, 9, 13, 57, 121, 51, 37, 927, 1519, 1785, 2957, 753, 28481, 139}},
    {4113, 16, 7269, {1, 3, 5, 1, 11, 19, 115, 251, 319, 155, 381, 3617, 6943, 15407, 3989, 41107}},
    {4114, 16, 7279, {1, 3, 1, 11, 15, 53, 27, 17, 9, 187, 1913, 3487, 5915, 15401, 27355, 40511}},
    {4115, 16, 7293, {1, 3, 1, 5, 7, 29, 105, 75, 479, 945, 861, 879, 6043, 15359, 29801, 28817}},
    {4116, 16, 7312, {1, 3, 3, 13, 9, 15, 25, 61, 341, 429, 1943, 1051, 3991, 10309, 11983, 14485}},
    {4117, 16, 7327, {1, 1, 7, 11, 17, 13, 125, 117, 487, 469, 1493, 3239, 4645, 7519, 14105, 33837}},
    {4118, 16, 7334, {1, 1, 1, 15, 7, 11, 27, 167, 57, 535, 759, 2827, 5741, 16331, 20703, 49377}},
    {4119, 16, 7337, {1, 3, 1, 7, 9, 45, 27, 181, 13, 555, 1551, 3675, 1599, 5743, 31699, 13639}},
    {4120, 16, 7343, {1, 1, 1, 3, 13, 11, 47, 141, 327, 79, 1001, 2441, 7799, 6731, 16497, 54777}},
    {4121, 16, 7346, {1, 3, 7, 15, 1, 61, 55, 231, 39, 375, 27, 3939, 1951, 3725, 4233, 1165}},
    {4122, 16, 7372, {1, 3, 7, 5, 25, 15, 127, 185, 325, 229, 477, 4033, 3095, 4815, 467, 61035}},
    {4123, 16, 7387, {1, 1, 5, 5, 11, 23, 87, 3, 117, 577, 1379, 4031, 4945, 8945, 15779, 41357}},
    {4124, 16, 7390, {1, 1, 5, 7, 21, 25, 55, 139, 139, 809, 1245, 1371, 5843, 2225, 13709, 48895}},
    {4125, 16, 7396, {1, 3, 1, 11, 15, 39, 107, 239, 495, 167, 221, 2769, 4941, 9827, 10835, 11099}},
    {4126, 16, 7423, {1, 3, 7, 15, 23, 59, 25, 125, 137, 473, 351, 1837, 4655, 10977, 26267, 6091}},
    {4127, 16, 7428, {1, 3, 1, 1, 21, 23, 27, 201, 443, 897, 1095, 617, 1627, 263, 29627, 10263}},
    {4128, 16, 7437, {1, 1, 3, 9, 27, 47, 73, 95, 241, 735, 1275, 2125, 3705, 4009, 25103, 44207}},
    {4129, 16, 7466, {1, 3, 3, 3, 13, 19, 51, 69, 133, 573, 1669, 3587, 1787, 14187, 10065, 63165}},
    {4130, 16, 7474, {1, 3, 5, 3, 15, 27, 57, 19, 77, 235, 285, 3431, 4035, 8889, 18973, 56527}},
    {4131, 16, 7476, {1, 3, 5, 9, 7, 3, 85, 23, 225, 91, 1759, 2237, 2017, 11685, 23309, 31477}},
    {4132, 16, 7483, {1, 1, 5, 15, 19, 47, 67, 247, 199, 975, 1877, 1925, 161, 4223, 105, 25371}},
    {4133, 16, 7518, {1, 1, 7, 5, 27, 5, 61, 113, 207, 683, 1065, 1387, 4001, 3751, 857, 45961}},
    {4134, 16, 7527, {1, 1, 1, 1, 25, 35, 111, 141, 93, 319, 1739, 3179, 7163, 10219, 24725, 27321}},
    {4135, 16, 7545, {1, 1, 5, 3, 31, 23, 89, 25, 39, 793, 1359, 2743, 1609, 5547, 22733, 20353}},
    {4136, 16, 7572, {1, 3, 1, 15, 9, 39, 47, 191, 253, 485, 883, 2637, 7221, 11659, 28729, 4977}},
    {4137, 16, 7586, {1, 1, 1, 13, 13, 49, 37, 249, 97, 645, 1475, 1197, 5385, 13985, 25463, 38309}},
    {4138, 16, 7597, {1, 3, 5, 5, 17, 55, 105, 163, 437, 101, 367, 1625, 5617, 13273, 5409, 4203}},
    {4139, 16, 7630, {1, 3, 1, 3, 19, 49, 61, 73, 455, 429, 2009, 2837, 3727, 7613, 22359, 64589}},
    {4140, 16, 7653, {1, 1, 3, 5, 25, 27, 71, 91, 71, 179, 1539, 2241, 2785, 13483, 31203, 1233}},
    {4141, 16, 7657, {1, 1, 5, 7, 31, 51, 35, 45, 297, 35, 759, 1623, 2689, 387, 83, 20899}},
    {4142, 16, 7671, {1, 3, 1, 9, 31, 11, 19, 85, 215, 95, 1499, 2891, 6431, 11605, 27243, 50411}},
    {4143, 16, 7672, {1, 3, 5, 3, 3, 5, 121, 175, 355, 869, 1161, 3199, 1793, 9859, 17085, 9719}},
    {4144, 16, 7715, {1, 1, 5, 1, 17, 33, 95, 135, 223, 341, 157, 1217, 4763, 201, 12855, 18359}},
    {4145, 16, 7717, {1, 1, 3, 11, 21, 55, 5, 65, 483, 451, 689, 2193, 7943, 6591, 4143, 35605}},
    {4146, 16, 7732, {1, 1, 7, 5, 5, 35, 123, 89, 511, 1019, 1561, 2467, 455, 15645, 4939, 33251}},
    {4147, 16, 7735, {1, 1, 7, 3, 29, 49, 1, 177, 371, 681, 1571, 1583, 6249, 4947, 24861, 55565}},
    {4148, 16, 7753, {1, 1, 3, 3, 29, 29, 25, 27, 161, 197, 495, 4075, 2301, 12637, 20687, 51913}},
    {4149, 16, 7811, {1, 1, 7, 1, 29, 29, 93, 231, 377, 203, 313, 3697, 865, 12901, 6981, 63515}},
    {4150, 16, 7817, {1, 3, 5, 9, 31, 49, 21, 249, 185, 137, 515, 1235, 6825, 11027, 32505, 54115}},
    {4151, 16, 7825, {1, 1, 5, 13, 29, 51, 27, 57, 111, 269, 257, 2793, 5189, 11891, 5781, 29305}},
    {4152, 16, 7832, {1, 3, 7, 3, 23, 23, 21, 139, 75, 767, 123, 631, 959, 9203, 16591, 38935}},
    {4153, 16, 7838, {1, 1, 1, 5, 5, 57, 111, 65, 71, 449, 297, 2587, 1167, 10451, 18393, 1769}},
    {4154, 16, 7841, {1, 1, 5, 7, 27, 35, 11, 195, 217, 987, 1993, 1155, 5495, 14145, 28709, 44057}},
    {4155, 16, 7844, {1, 3, 7, 7, 11, 15, 119, 53, 347, 365, 229, 1253, 6589, 10575, 19701, 947}},
    {4156, 16, 7859, {1, 1, 5, 7, 25, 25, 33, 35, 27, 983, 1771, 2793, 981, 15517, 15877, 35705}},
    {4157, 16, 7861, {1, 1, 5, 15, 5, 49, 29, 9, 249, 99, 915, 2263, 7459, 2361, 129, 47895}},
    {4158, 16, 7873, {1, 3, 7, 13, 7, 31, 13, 3, 387, 689, 1089, 1259, 327, 14369, 26065, 2145}},
    {4159, 16, 7880, {1, 1, 7, 7, 17, 37, 15, 37, 15, 69, 857, 2511, 7749, 11219, 11453, 39823}},
    {4160, 16, 7897, {1, 1, 1, 13, 3, 37, 93, 1, 483, 329, 1983, 1851, 169, 10619, 19229, 19293}},
    {4161, 16, 7904, {1, 1, 1, 9, 9, 11, 35, 143, 441, 161, 179, 2321, 6239, 4303, 5671, 62963}},
    {4162, 16, 7910, {1, 3, 5, 1, 23, 5, 111, 101, 209, 731, 271, 1309, 2433, 14463, 27031, 32777}},
    {4163, 16, 7960, {1, 1, 1, 9, 29, 45, 83, 33, 431, 411, 621, 2295, 2145, 6427, 30235, 43961}},
    {4164, 16, 7969, {1, 3, 1, 1, 13, 9, 11, 247, 487, 729, 75, 2079, 8141, 1965, 32209, 63151}},
    {4165, 16, 7970, {1, 1, 1, 5, 19, 35, 27, 127, 507, 973, 1921, 787, 6769, 14331, 26825, 23897}},
    {4166, 16, 7976, {1, 3, 1, 9, 27, 11, 29, 103, 227, 801, 391, 619, 2083, 12813, 1067, 35363}},
    {4167, 16, 7979, {1, 3, 7, 3, 13, 47, 19, 51, 363, 811, 1835, 2197, 1691, 833, 27187, 50889}},
    {4168, 16, 8007, {1, 1, 5, 11, 9, 17, 77, 47, 353, 491, 169, 3479, 6405, 12299, 12947, 29427}},
    {4169, 16, 8041, {1, 1, 5, 13, 25, 3, 17, 249, 17, 863, 303, 1455, 471, 29, 12265, 38097}},
    {4170, 16, 8047, {1, 1, 5, 13, 7, 57, 53, 239, 495, 249, 1671, 1659, 4099, 10357, 8937, 10525}},
    {4171, 16, 8052, {1, 3, 5, 13, 9, 47, 105, 161, 461, 279, 1549, 575, 961, 2839, 21507, 50579}},
    {4172, 16, 8061, {1, 3, 7, 7, 3, 31, 65, 239, 267, 177, 193, 2961, 1929, 6145, 25367, 40921}},
    {4173, 16, 8078, {1, 3, 3, 5, 27, 3, 1, 25, 293, 941, 1443, 2569, 1721, 16001, 2179, 27409}},
    {4174, 16, 8128, {1, 3, 3, 13, 27, 9, 47, 155, 213, 461, 359, 305, 4785, 10583, 16697, 29109}},
    {4175, 16, 8146, {1, 1, 3, 15, 25, 43, 23, 239, 5, 117, 175, 3081, 763, 15555, 12293, 28583}},
    {4176, 16, 8162, {1, 1, 1, 1, 9, 45, 83, 161, 467, 559, 1875, 3193, 3089, 10157, 17015, 13013}},
    {4177, 16, 8250, {1, 1, 5, 9, 15, 9, 115, 131, 435, 385, 461, 423, 5273, 1461, 17863, 27067}},
    {4178, 16, 8270, {1, 1, 5, 7, 23, 25, 109, 179, 311, 179, 711, 1089, 1499, 12957, 27995, 57487}},
    {4179, 16, 8294, {1, 1, 1, 5, 1, 49, 75, 17, 217, 23, 103, 2807, 6483, 633, 26431, 47911}},
    {4180, 16, 8324, {1, 1, 1, 1, 3, 49, 45, 131, 251, 137, 1587, 531, 1367, 9261, 7575, 42709}},
    {4181, 16, 8351, {1, 3, 7, 3, 21, 43, 95, 11, 301, 709, 1843, 3045, 3155, 6797, 28595, 33901}},
    {4182, 16, 8357, {1, 3, 7, 9, 25, 41, 93, 245, 121, 339, 385, 461, 2919, 14233, 21345, 52777}},
    {4183, 16, 8361, {1, 1, 5, 7, 1, 51, 73, 117, 413, 599, 5, 1309, 421, 15573, 25721, 34551}},
    {4184, 16, 8364, {1, 3, 5, 1, 25, 63, 75, 231, 177, 115, 377, 1791, 7153, 8913, 32695, 57569}},
    {4185, 16, 8393, {1, 1, 1, 15, 25, 31, 41, 13, 7, 517, 1507, 1443, 4199, 5259, 1247, 37727}},
    {4186, 16, 8396, {1, 1, 5, 15, 11, 21, 29, 23, 435, 569, 1845, 2173, 5409, 10083, 29863, 12559}},
    {4187, 16, 8407, {1, 1, 1, 11, 1, 39, 53, 205, 265, 569, 85, 2855, 551, 13431, 19089, 14025}},
    {4188, 16, 8413, {1, 3, 1, 1, 11, 33, 1, 237, 211, 859, 1017, 2365, 75, 8803, 20159, 48079}},
    {4189, 16, 8414, {1, 1, 1, 7, 31, 63, 119, 187, 397, 815, 73, 1829, 4073, 16073, 30945, 64831}},
    {4190, 16, 8432, {1, 3, 1, 15, 29, 53, 35, 243, 115, 1013, 1487, 2109, 6785, 2285, 11463, 63869}},
    {4191, 16, 8435, {1, 3, 5, 1, 21, 1, 117, 39, 25, 1019, 953, 179, 1769, 9707, 4825, 23985}},
    {4192, 16, 8441, {1, 1, 7, 11, 17, 33, 45, 253, 461, 525, 1971, 2219, 4167, 15357, 13101, 64659}},
    {4193, 16, 8447, {1, 1, 3, 7, 13, 37, 103, 201, 39, 433, 1443, 3543, 8047, 5513, 299, 56161}},
    {4194, 16, 8449, {1, 3, 7, 7, 19, 55, 1, 245, 9, 131, 1967, 1737, 5241, 9719, 30861, 61079}},
    {4195, 16, 8456, {1, 3, 5, 1, 5, 59, 23, 43, 475, 593, 491, 2309, 6631, 6119, 25477, 28431}},
    {4196, 16, 8485, {1, 3, 5, 13, 7, 45, 89, 141, 413, 529, 251, 403, 7429, 5361, 20347, 43477}},
    {4197, 16, 8504, {1, 1, 3, 11, 9, 51, 63, 115, 487, 961, 1603, 2807, 4129, 4837, 15021, 56935}},
    {4198, 16, 8512, {1, 1, 1, 9, 17, 41, 27, 25, 175, 709, 1325, 3539, 6053, 1759, 30327, 56559}},
    {4199, 16, 8532, {1, 1, 1, 15, 19, 61, 117, 51, 473, 757, 1413, 2729, 2427, 3753, 8549, 743}},
    {4200, 16, 8551, {1, 3, 5, 7, 9, 63, 31, 111, 257, 875, 1761, 2163, 1195, 915, 25837, 61591}},
    {4201, 16, 8560, {1, 1, 7, 13, 17, 1, 77, 173, 495, 731, 615, 1765, 7649, 15289, 29035, 29705}},
    {4202, 16, 8566, {1, 3, 7, 13, 7, 3, 95, 1, 183, 483, 1789, 3215, 833, 13189, 26023, 32667}},
    {4203, 16, 8581, {1, 3, 1, 5, 23, 11, 25, 245, 365, 623, 925, 3495, 7961, 13097, 20905, 65359}},
    {4204, 16, 8609, {1, 3, 3, 13, 27, 51, 37, 79, 121, 647, 1975, 3985, 7449, 4035, 9213, 4315}},
    {4205, 16, 8639, {1, 3, 7, 15, 27, 25, 23, 225, 393, 401, 517, 2797, 1107, 8437, 10847, 41187}},
    {4206, 16, 8641, {1, 3, 3, 5, 15, 7, 115, 193, 433, 453, 567, 4043, 3381, 8137, 16917, 57445}},
    {4207, 16, 8671, {1, 3, 7, 15, 15, 15, 53, 81, 263, 465, 939, 853, 5817, 2097, 1975, 16309}},
    {4208, 16, 8695, {1, 3, 1, 3, 17, 29, 97, 199, 349, 873, 33, 1337, 7819, 13891, 113, 65177}},
    {4209, 16, 8701, {1, 3, 1, 13, 19, 33, 5, 209, 115, 125, 441, 2495, 3269, 7539, 29141, 59037}},
    {4210, 16, 8711, {1, 3, 1, 15, 9, 61, 21, 29, 321, 959, 197, 2687, 1103, 1677, 16039, 50101}},
    {4211, 16, 8739, {1, 1, 1, 5, 31, 57, 77, 187, 185, 203, 1739, 2563, 225, 8929, 7495, 17259}},
    {4212, 16, 8763, {1, 3, 7, 13, 15, 7, 119, 139, 471, 1015, 137, 383, 897, 10535, 20755, 58825}},
    {4213, 16, 8778, {1, 3, 7, 1, 5, 1, 5, 167, 197, 609, 567, 71, 6133, 6703, 17069, 42625}},
    {4214, 16, 8783, {1, 3, 3, 1, 29, 47, 3, 229, 75, 861, 1971, 2419, 6073, 5727, 28071, 17721}},
    {4215, 16, 8785, {1, 1, 7, 9, 9, 3, 127, 231, 43, 291, 259, 2149, 3567, 4835, 27385, 30571}},
    {4216, 16, 8797, {1, 1, 3, 13, 25, 45, 85, 203, 31, 517, 1353, 555, 5127, 9277, 17527, 19585}},
    {4217, 16, 8802, {1, 1, 5, 5, 15, 11, 127, 77, 309, 591, 119, 3067, 3411, 1159, 29213, 36391}},
    {4218, 16, 8816, {1, 3, 3, 7, 19, 7, 47, 165, 371, 971, 485, 2387, 5315, 11081, 9167, 51183}},
    {4219, 16, 8828, {1, 3, 1, 13, 9, 43, 27, 151, 241, 1023, 1721, 2729, 1153, 1905, 20301, 57731}},
    {4220, 16, 8837, {1, 1, 1, 5, 31, 63, 49, 127, 125, 595, 2047, 1085, 1521, 16119, 6415, 17389}},
    {4221, 16, 8852, {1, 3, 7, 15, 25, 23, 37, 203, 61, 615, 1297, 381, 3553, 5029, 3701, 28769}},
    {4222, 16, 8859, {1, 1, 5, 11, 11, 7, 31, 109, 447, 917, 1043, 593, 3003, 1993, 13711, 45139}},
    {4223, 16, 8889, {1, 3, 5, 15, 7, 31, 49, 227, 307, 433, 1187, 3927, 4219, 13377, 20165, 313}},
    {4224, 16, 8900, {1, 1, 1, 9, 23, 7, 35, 131, 351, 575, 1315, 1393, 959, 12109, 24587, 16615}},
    {4225, 16, 8903, {1, 1, 1, 11, 5, 61, 85, 69, 3, 273, 511, 3867, 6559, 6709, 41, 53041}},
    {4226, 16, 8909, {1, 1, 1, 3, 25, 59, 61, 145, 139, 575, 1849, 535, 2193, 15513, 19161, 54139}},
    {4227, 16, 8910, {1, 1, 1, 15, 1, 29, 55, 201, 41, 781, 683, 2207, 3139, 10151, 17987, 2737}},
    {4228, 16, 8922, {1, 3, 1, 15, 25, 13, 115, 53, 401, 499, 297, 695, 1047, 1907, 7245, 24055}},
    {4229, 16, 8924, {1, 3, 1, 7, 13, 35, 29, 213, 45, 9, 1255, 2865, 6379, 2661, 25031, 52057}},
    {4230, 16, 8955, {1, 1, 1, 3, 3, 53, 41, 79, 141, 953, 1291, 2401, 2085, 9091, 14573, 27947}},
    {4231, 16, 8958, {1, 1, 5, 7, 11, 41, 101, 73, 399, 349, 1307, 1769, 6141, 1399, 23045, 39065}},
    {4232, 16, 8980, {1, 3, 5, 5, 21, 37, 77, 13, 63, 889, 585, 251, 1717, 9565, 391, 48601}},
    {4233, 16, 8994, {1, 1, 1, 5, 11, 11, 55, 157, 185, 899, 1863, 1831, 383, 1501, 16643, 5133}},
    {4234, 16, 9006, {1, 3, 7, 3, 17, 17, 91, 233, 405, 745, 881, 2517, 5729, 14217, 21487, 43697}},
    {4235, 16, 9017, {1, 1, 3, 3, 7, 53, 93, 223, 241, 151, 755, 857, 1683, 6371, 3573, 51125}},
    {4236, 16, 9032, {1, 1, 5, 11, 3, 19, 75, 85, 109, 123, 1965, 2945, 1731, 2729, 5333, 20159}},
    {4237, 16, 9040, {1, 3, 5, 3, 15, 53, 51, 135, 341, 273, 1019, 1463, 4211, 7095, 8685, 23261}},
    {4238, 16, 9061, {1, 1, 1, 7, 3, 17, 83, 59, 477, 891, 985, 3707, 269, 1049, 25613, 48577}},
    {4239, 16, 9066, {1, 1, 1, 13, 1, 7, 125, 79, 331, 429, 769, 1555, 7999, 11059, 19377, 21861}},
    {4240, 16, 9071, {1, 3, 1, 9, 1, 33, 47, 229, 41, 577, 47, 2297, 7169, 14813, 28171, 33347}},
    {4241, 16, 9076, {1, 3, 5, 1, 11, 49, 103, 7, 251, 361, 543, 3049, 7811, 13063, 7447, 3511}},
    {4242, 16, 9086, {1, 3, 5, 9, 15, 19, 105, 135, 313, 739, 237, 213, 7079, 3305, 4097, 39387}},
    {4243, 16, 9104, {1, 3, 5, 11, 5, 3, 45, 87, 311, 1005, 1173, 2177, 2525, 3673, 12281, 40773}},
    {4244, 16, 9150, {1, 1, 3, 1, 21, 23, 47, 51, 437, 131, 237, 1315, 3393, 8755, 13345, 12455}},
    {4245, 16, 9161, {1, 3, 1, 15, 5, 49, 91, 177, 185, 753, 797, 1475, 3885, 8911, 8391, 20145}},
    {4246, 16, 9164, {1, 1, 1, 1, 1, 41, 101, 15, 105, 387, 381, 2609, 7273, 7835, 21603, 60083}},
    {4247, 16, 9185, {1, 3, 3, 5, 9, 45, 13, 61, 355, 105, 1707, 3631, 7747, 3835, 27209, 60585}},
    {4248, 16, 9188, {1, 1, 7, 11, 19, 21, 97, 153, 29, 971, 1757, 833, 2869, 15529, 8951, 26277}},
    {4249, 16, 9212, {1, 3, 5, 9, 31, 17, 47, 133, 289, 211, 1429, 363, 2113, 10159, 25219, 8773}},
    {4250, 16, 9230, {1, 3, 7, 1, 31, 11, 51, 107, 295, 235, 569, 2009, 7377, 2053, 29187, 899}},
    {4251, 16, 9242, {1, 3, 5, 13, 13, 31, 63, 51, 421, 935, 697, 405, 4995, 6807, 7553, 25789}},
    {4252, 16, 9247, {1, 3, 5, 7, 31, 17, 75, 213, 119, 683, 1259, 3963, 3067, 10369, 7915, 22357}},
    {4253, 16, 9260, {1, 3, 1, 11, 13, 7, 43, 17, 181, 81, 1063, 393, 3951, 2497, 29687, 4123}},
    {4254, 16, 9280, {1, 1, 5, 3, 1, 45, 3, 175, 261, 493, 723, 3673, 7561, 11699, 27549, 22949}},
    {4255, 16, 9300, {1, 1, 7, 11, 7, 53, 125, 249, 257, 15, 1807, 267, 7919, 1975, 7129, 7255}},
    {4256, 16, 9313, {1, 3, 1, 3, 31, 51, 53, 223, 199, 517, 1013, 1643, 4779, 15809, 4417, 32651}},
    {4257, 16, 9325, {1, 3, 7, 15, 9, 47, 3, 45, 493, 273, 233, 2565, 3167, 8239, 3911, 9089}},
    {4258, 16, 9343, {1, 3, 5, 13, 15, 35, 89, 239, 337, 413, 2047, 1097, 1269, 5803, 8805, 42663}},
    {4259, 16, 9349, {1, 1, 5, 5, 25, 49, 105, 251, 129, 783, 1785, 3065, 7469, 2683, 6017, 14637}},
    {4260, 16, 9354, {1, 3, 5, 15, 5, 63, 7, 193, 207, 185, 1811, 275, 3021, 13101, 21479, 43831}},
    {4261, 16, 9367, {1, 3, 5, 15, 5, 37, 33, 205, 11, 803, 115, 201, 5097, 4089, 2145, 49089}},
    {4262, 16, 9368, {1, 3, 7, 1, 17, 31, 37, 71, 467, 661, 223, 203, 4701, 13577, 12001, 53241}},
    {4263, 16, 9455, {1, 3, 5, 3, 17, 21, 69, 255, 191, 557, 1377, 2631, 3539, 15297, 6819, 37223}},
    {4264, 16, 9458, {1, 3, 3, 15, 11, 37, 93, 35, 81, 869, 1417, 637, 429, 13603, 29079, 9145}},
    {4265, 16, 9469, {1, 1, 1, 7, 25, 33, 111, 67, 457, 493, 1883, 635, 7693, 12411, 14651, 39051}},
    {4266, 16, 9481, {1, 3, 5, 9, 25, 21, 57, 17, 211, 611, 1307, 2241, 927, 4371, 7505, 51159}},
    {4267, 16, 9482, {1, 1, 1, 5, 29, 63, 89, 41, 203, 347, 1785, 1733, 325, 12151, 8895, 31259}},
    {4268, 16, 9495, {1, 1, 1, 15, 15, 9, 119, 193, 371, 803, 1145, 1079, 647, 2631, 4451, 14581}},
    {4269, 16, 9526, {1, 1, 3, 7, 31, 23, 37, 87, 483, 827, 1775, 2105, 6911, 8775, 31027, 65463}},
    {4270, 16, 9530, {1, 1, 5, 3, 21, 53, 57, 33, 155, 403, 1983, 3213, 1899, 11287, 8923, 39851}},
    {4271, 16, 9558, {1, 3, 7, 7, 15, 45, 99, 235, 477, 841, 1107, 2097, 3363, 3307, 26323, 23889}},
    {4272, 16, 9562, {1, 1, 5, 1, 31, 37, 105, 73, 369, 473, 1811, 747, 2823, 5437, 13113, 42131}},
    {4273, 16, 9573, {1, 3, 7, 11, 13, 61, 3, 225, 163, 247, 889, 2149, 6179, 12571, 31743, 3269}},
    {4274, 16, 9583, {1, 3, 1, 5, 3, 57, 73, 127, 213, 523, 781, 29, 7559, 8019, 11745, 21905}},
    {4275, 16, 9595, {1, 1, 5, 3, 19, 37, 47, 107, 99, 997, 629, 3843, 4453, 1539, 23413, 16291}},
    {4276, 16, 9597, {1, 3, 1, 5, 1, 7, 5, 63, 401, 11, 745, 3379, 5571, 13035, 13177, 46527}},
    {4277, 16, 9616, {1, 1, 7, 15, 11, 21, 3, 145, 467, 491, 137, 679, 909, 7875, 30495, 33573}},
    {4278, 16, 9638, {1, 1, 1, 1, 23, 35, 29, 15, 29, 341, 1193, 4033, 3545, 3379, 21735, 24101}},
    {4279, 16, 9649, {1, 1, 3, 5, 29, 11, 37, 73, 439, 135, 1971, 2105, 6709, 3333, 7829, 15683}},
    {4280, 16, 9662, {1, 1, 1, 7, 23, 33, 79, 199, 293, 781, 879, 1487, 3365, 7617, 21671, 60781}},
    {4281, 16, 9691, {1, 1, 5, 13, 13, 15, 65, 169, 411, 801, 2001, 475, 171, 10009, 7451, 29111}},
    {4282, 16, 9700, {1, 3, 5, 3, 15, 63, 41, 147, 29, 165, 217, 1587, 2795, 1209, 26295, 14805}},
    {4283, 16, 9703, {1, 3, 3, 11, 13, 17, 33, 23, 509, 765, 157, 917, 1595, 1557, 31597, 15391}},
    {4284, 16, 9710, {1, 3, 3, 5, 23, 11, 123, 159, 413, 567, 959, 851, 4949, 5895, 17599, 63825}},
    {4285, 16, 9721, {1, 3, 7, 3, 13, 23, 93, 163, 357, 651, 1191, 2559, 3607, 31, 3479, 62571}},
    {4286, 16, 9724, {1, 3, 3, 7, 7, 49, 109, 191, 261, 615, 1573, 257, 7731, 4289, 2317, 6947}},
    {4287, 16, 9727, {1, 1, 1, 1, 5, 45, 95, 233, 209, 323, 1553, 2777, 3063, 2189, 11445, 40565}},
    {4288, 16, 9743, {1, 3, 7, 15, 11, 19, 47, 209, 367, 899, 1445, 143, 1015, 1465, 17781, 23537}},
    {4289, 16, 9779, {1, 3, 7, 9, 15, 1, 61, 69, 379, 995, 857, 1841, 2527, 13247, 15471, 12693}},
    {4290, 16, 9785, {1, 1, 7, 7, 17, 61, 107, 45, 83, 287, 303, 2285, 807, 14841, 23155, 4541}},
    {4291, 16, 9811, {1, 3, 5, 3, 23, 3, 25, 37, 391, 131, 9, 2143, 3623, 2395, 20705, 12235}},
    {4292, 16, 9820, {1, 3, 7, 9, 17, 61, 117, 177, 343, 325, 43, 3141, 6141, 10161, 15377, 25863}},
    {4293, 16, 9827, {1, 3, 7, 15, 21, 11, 107, 97, 121, 651, 723, 3281, 5173, 11687, 10953, 55775}},
    {4294, 16, 9851, {1, 3, 5, 3, 13, 13, 17, 167, 315, 695, 1671, 827, 3865, 5473, 17269, 30487}},
    {4295, 16, 9854, {1, 3, 3, 7, 19, 13, 43, 181, 181, 915, 465, 1535, 3569, 9699, 23999, 26627}},
    {4296, 16, 9863, {1, 3, 5, 1, 1, 41, 83, 165, 375, 371, 1851, 1655, 3575, 10527, 28541, 18877}},
    {4297, 16, 9884, {1, 1, 1, 1, 11, 57, 31, 191, 5, 735, 71, 3525, 3051, 353, 6841, 30861}},
    {4298, 16, 9894, {1, 3, 5, 5, 29, 5, 55, 3, 269, 579, 109, 1165, 6587, 14809, 2799, 17313}},
    {4299, 16, 9903, {1, 3, 5, 5, 31, 51, 89, 15, 63, 57, 439, 3295, 3471, 11557, 913, 55551}},
    {4300, 16, 9908, {1, 3, 3, 5, 23, 9, 9, 179, 135, 335, 661, 1227, 6647, 16093, 1927, 55253}},
    {4301, 16, 9912, {1, 3, 3, 9, 15, 15, 63, 39, 195, 977, 693, 1151, 3071, 4231, 30333, 64027}},
    {4302, 16, 9925, {1, 3, 5, 5, 1, 33, 127, 1, 485, 677, 1311, 2417, 2317, 12291, 32051, 42195}},
    {4303, 16, 9926, {1, 1, 3, 5, 9, 21, 89, 107, 437, 643, 691, 1853, 6177, 10719, 561, 28439}},
    {4304, 16, 9971, {1, 3, 1, 11, 5, 33, 117, 31, 389, 443, 937, 817, 2451, 15717, 5417, 6235}},
    {4305, 16, 9973, {1, 3, 3, 7, 13, 15, 11, 61, 411, 481, 983, 3833, 4237, 3055, 31263, 53549}},
    {4306, 16, 9977, {1, 1, 1, 3, 29, 45, 15, 37, 101, 9, 1539, 245, 5707, 8803, 31743, 3565}},
    {4307, 16, 10021, {1, 3, 5, 13, 29, 15, 23, 87, 207, 389, 1095, 1475, 2103, 5907, 22015, 35369}},
    {4308, 16, 10039, {1, 1, 7, 13, 1, 31, 123, 217, 27, 223, 1515, 2641, 3711, 10449, 12049, 51695}},
    {4309, 16, 10048, {1, 1, 1, 5, 31, 19, 29, 229, 345, 679, 1631, 3921, 4521, 12261, 28741, 15897}},
    {4310, 16, 10051, {1, 3, 1, 13, 11, 1, 39, 215, 249, 33, 959, 1613, 7949, 9713, 9347, 5033}},
    {4311, 16, 10065, {1, 1, 1, 1, 9, 27, 1, 63, 217, 647, 1361, 881, 4333, 4439, 5077, 19695}},
    {4312, 16, 10071, {1, 3, 1, 13, 9, 55, 63, 139, 329, 591, 835, 2995, 6769, 14043, 10423, 51311}},
    {4313, 16, 10072, {1, 3, 7, 9, 23, 11, 45, 181, 63, 175, 1433, 3791, 1951, 7321, 14685, 52457}},
    {4314, 16, 10101, {1, 3, 5, 7, 25, 25, 83, 165, 157, 453, 979, 3683, 6129, 10015, 10451, 35129}},
    {4315, 16, 10106, {1, 3, 1, 3, 5, 41, 1, 243, 143, 309, 1499, 2057, 7999, 7959, 6263, 2311}},
    {4316, 16, 10130, {1, 1, 1, 9, 21, 29, 49, 55, 235, 897, 1107, 1459, 6907, 1653, 26195, 36315}},
    {4317, 16, 10136, {1, 3, 3, 11, 13, 15, 123, 169, 419, 103, 1001, 1969, 3925, 1021, 10123, 949}},
    {4318, 16, 10148, {1, 1, 7, 1, 31, 5, 45, 125, 169, 59, 1785, 277, 451, 7041, 2307, 40221}},
    {4319, 16, 10155, {1, 1, 7, 13, 27, 11, 45, 23, 209, 655, 1517, 2793, 6219, 10829, 26189, 47349}},
    {4320, 16, 10157, {1, 3, 5, 13, 17, 35, 81, 95, 191, 753, 309, 1687, 135, 9311, 399, 2641}},
    {4321, 16, 10160, {1, 3, 5, 7, 17, 61, 17, 105, 119, 561, 1133, 401, 1547, 5745, 3681, 4799}},
    {4322, 16, 10166, {1, 1, 3, 13, 11, 37, 67, 187, 245, 75, 1219, 3537, 1787, 9637, 11715, 8291}},
    {4323, 16, 10183, {1, 3, 5, 9, 3, 5, 97, 39, 27, 483, 1367, 3051, 1861, 10965, 25381, 55827}},
    {4324, 16, 10192, {1, 3, 7, 7, 9, 35, 63, 57, 495, 75, 203, 3839, 6013, 15703, 26001, 25665}},
    {4325, 16, 10225, {1, 1, 7, 7, 7, 63, 17, 61, 427, 291, 595, 3857, 4253, 14899, 12341, 51339}},
    {4326, 16, 10241, {1, 3, 3, 13, 1, 21, 77, 49, 143, 425, 931, 3501, 5747, 9737, 4053, 48089}},
    {4327, 16, 10247, {1, 1, 5, 1, 3, 19, 43, 87, 339, 19, 573, 4029, 3549, 7, 22143, 4803}},
    {4328, 16, 10284, {1, 1, 1, 15, 3, 15, 11, 51, 411, 881, 1581, 1429, 4827, 4611, 6655, 13629}},
    {4329, 16, 10304, {1, 3, 5, 11, 15, 55, 111, 161, 357, 175, 1557, 1651, 3047, 911, 10843, 53659}},
    {4330, 16, 10322, {1, 1, 5, 7, 7, 29, 77, 103, 161, 267, 1555, 2553, 7167, 4335, 29287, 6067}},
    {4331, 16, 10331, {1, 1, 5, 5, 5, 45, 33, 51, 1, 61, 361, 1193, 1961, 14349, 15097, 3071}},
    {4332, 16, 10333, {1, 1, 1, 5, 3, 19, 41, 59, 343, 587, 361, 3749, 3131, 13175, 31183, 32889}},
    {4333, 16, 10340, {1, 1, 5, 3, 15, 1, 83, 85, 167, 39, 1283, 4073, 7101, 13203, 22203, 8859}},
    {4334, 16, 10347, {1, 3, 1, 9, 23, 33, 45, 237, 45, 3, 1863, 203, 5351, 1185, 10985, 281}},
    {4335, 16, 10357, {1, 1, 3, 15, 23, 53, 109, 3, 511, 667, 1671, 1977, 1925, 15925, 28261, 19483}},
    {4336, 16, 10371, {1, 1, 7, 7, 7, 33, 29, 179, 113, 877, 643, 3729, 1147, 1375, 31115, 51205}},
    {4337, 16, 10386, {1, 3, 3, 9, 1, 61, 103, 7, 189, 215, 1725, 1247, 361, 8919, 13467, 23255}},
    {4338, 16, 10404, {1, 1, 5, 15, 13, 15, 121, 43, 157, 969, 1521, 1679, 7445, 9705, 17509, 27107}},
    {4339, 16, 10414, {1, 3, 3, 15, 21, 19, 63, 31, 37, 479, 2011, 217, 4687, 4187, 9199, 34747}},
    {4340, 16, 10422, {1, 1, 1, 11, 25, 41, 127, 161, 99, 417, 1161, 2743, 4129, 15921, 1915, 19325}},
    {4341, 16, 10448, {1, 3, 5, 13, 29, 3, 13, 81, 351, 345, 1891, 3523, 7191, 9817, 18979, 7055}},
    {4342, 16, 10451, {1, 3, 1, 9, 17, 51, 19, 7, 41, 555, 809, 1013, 4555, 11639, 11995, 29837}},
    {4343, 16, 10473, {1, 1, 5, 13, 17, 11, 63, 195, 295, 443, 815, 2727, 6019, 13387, 20271, 3869}},
    {4344, 16, 10479, {1, 3, 5, 3, 27, 59, 13, 31, 145, 619, 1055, 831, 5101, 11371, 17255, 53759}},
    {4345, 16, 10501, {1, 3, 5, 5, 7, 59, 81, 113, 167, 595, 85, 2641, 1901, 13103, 28563, 5715}},
    {4346, 16, 10530, {1, 1, 3, 5, 19, 31, 9, 41, 303, 841, 1485, 3873, 1483, 12689, 4285, 63137}},
    {4347, 16, 10542, {1, 3, 3, 3, 21, 55, 67, 57, 163, 685, 323, 627, 1449, 7537, 15173, 44077}},
    {4348, 16, 10544, {1, 1, 1, 11, 23, 17, 13, 235, 141, 45, 1153, 253, 2759, 4999, 14955, 12169}},
    {4349, 16, 10571, {1, 1, 1, 5, 1, 37, 3, 39, 161, 237, 301, 587, 4441, 8501, 5145, 15941}},
    {4350, 16, 10628, {1, 1, 7, 9, 29, 39, 81, 227, 449, 7, 147, 3187, 4607, 11873, 11191, 7051}},
    {4351, 16, 10643, {1, 3, 1, 13, 1, 45, 41, 99, 153, 479, 299, 3259, 8101, 9481, 26843, 44141}},
    {4352, 16, 10673, {1, 1, 7, 9, 27, 17, 7, 223, 85, 161, 1089, 145, 8127, 9955, 9949, 52041}},
    {4353, 16, 10683, {1, 1, 7, 13, 21, 37, 5, 231, 461, 429, 815, 1047, 4231, 14223, 2173, 26221}},
    {4354, 16, 10736, {1, 3, 7, 13, 17, 11, 111, 81, 457, 523, 1151, 967, 5437, 1249, 3763, 22449}},
    {4355, 16, 10795, {1, 3, 5, 9, 25, 45, 33, 35, 165, 341, 909, 357, 4441, 8299, 21357, 20041}},
    {4356, 16, 10797, {1, 3, 3, 3, 31, 23, 117, 141, 201, 35, 1195, 2967, 2111, 6017, 31567, 23185}},
    {4357, 16, 10815, {1, 1, 7, 9, 27, 31, 19, 217, 81, 581, 1287, 1147, 2427, 2211, 12009, 12463}},
    {4358, 16, 10817, {1, 3, 5, 13, 25, 1, 37, 91, 57, 559, 1791, 401, 7883, 6285, 25851, 64255}},
    {4359, 16, 10842, {1, 1, 7, 9, 31, 61, 1, 91, 417, 167, 1507, 3661, 5123, 10107, 30037, 54493}},
    {4360, 16, 10844, {1, 1, 1, 5, 27, 43, 111, 167, 325, 393, 737, 3493, 2641, 5413, 13371, 6441}},
    {4361, 16, 10863, {1, 1, 1, 7, 13, 55, 45, 85, 173, 413, 1471, 1091, 3253, 8171, 16501, 45119}},
    {4362, 16, 10899, {1, 1, 1, 1, 15, 5, 15, 51, 221, 335, 1773, 1503, 513, 2135, 19367, 39459}},
    {4363, 16, 10902, {1, 3, 5, 11, 7, 15, 83, 75, 149, 927, 287, 3053, 3847, 15873, 20151, 63425}},
    {4364, 16, 10917, {1, 1, 3, 7, 17, 23, 67, 243, 281, 375, 889, 327, 5205, 763, 14897, 23681}},
    {4365, 16, 10953, {1, 3, 1, 1, 31, 19, 123, 65, 495, 359, 1405, 3497, 4929, 6593, 30581, 35679}},
    {4366, 16, 10967, {1, 3, 5, 3, 7, 55, 57, 209, 295, 727, 1773, 1007, 3999, 3069, 319, 54663}},
    {4367, 16, 11002, {1, 3, 7, 9, 31, 29, 49, 125, 489, 923, 1803, 167, 6463, 3501, 10455, 53909}},
    {4368, 16, 11024, {1, 1, 1, 13, 15, 37, 85, 15, 507, 967, 2013, 3335, 4287, 621, 9241, 467}},
    {4369, 16, 11029, {1, 3, 3, 9, 15, 35, 121, 57, 227, 819, 485, 859, 5249, 10467, 17765, 61257}},
    {4370, 16, 11030, {1, 1, 7, 13, 1, 25, 1, 79, 505, 563, 329, 2391, 5109, 4985, 9461, 48561}},
    {4371, 16, 11043, {1, 3, 1, 1, 11, 7, 99, 185, 257, 103, 1739, 1865, 3811, 15081, 30551, 57443}},
    {4372, 16, 11087, {1, 3, 1, 3, 7, 9, 15, 45, 313, 447, 1995, 755, 3713, 14519, 32371, 46517}},
    {4373, 16, 11106, {1, 1, 7, 7, 9, 7, 23, 29, 231, 29, 931, 1035, 6447, 15485, 29511, 17797}},
    {4374, 16, 11130, {1, 1, 5, 5, 13, 31, 99, 73, 285, 917, 761, 3233, 2237, 3953, 24127, 7901}},
    {4375, 16, 11156, {1, 3, 5, 3, 3, 31, 71, 209, 153, 149, 1477, 2927, 6985, 9015, 17357, 56747}},
    {4376, 16, 11176, {1, 3, 7, 15, 27, 17, 15, 207, 245, 311, 1801, 3315, 1027, 3599, 6479, 59367}},
    {4377, 16, 11221, {1, 3, 7, 9, 27, 13, 117, 231, 361, 947, 113, 2253, 4961, 8751, 10745, 31105}},
    {4378, 16, 11267, {1, 3, 3, 7, 17, 37, 91, 89, 177, 585, 415, 969, 909, 1885, 31317, 59429}},
    {4379, 16, 11282, {1, 3, 5, 13, 21, 33, 97, 215, 127, 645, 1095, 3583, 3643, 13013, 31459, 11999}},
    {4380, 16, 11294, {1, 3, 3, 1, 27, 23, 107, 91, 85, 741, 1715, 3921, 3343, 12335, 29967, 7129}},
    {4381, 16, 11332, {1, 1, 1, 3, 3, 57, 81, 149, 421, 993, 137, 575, 6303, 8025, 23729, 20637}},
    {4382, 16, 11353, {1, 3, 1, 5, 13, 47, 79, 171, 409, 721, 1745, 1787, 4581, 5427, 25119, 18891}},
    {4383, 16, 11369, {1, 3, 1, 9, 5, 41, 11, 107, 437, 669, 827, 3227, 3479, 14377, 2177, 46915}},
    {4384, 16, 11372, {1, 1, 3, 7, 25, 37, 47, 87, 163, 721, 825, 2593, 651, 9113, 27543, 37351}},
    {4385, 16, 11375, {1, 3, 3, 3, 25, 45, 1, 147, 355, 905, 1219, 3585, 4789, 15521, 6417, 8135}},
    {4386, 16, 11413, {1, 1, 3, 9, 21, 19, 107, 45, 445, 61, 1889, 3513, 9, 331, 3545, 45309}},
    {4387, 16, 11429, {1, 1, 1, 5, 17, 17, 123, 85, 7, 403, 949, 2293, 4369, 625, 5231, 7507}},
    {4388, 16, 11430, {1, 3, 7, 13, 11, 3, 33, 255, 147, 135, 675, 2945, 615, 4155, 13357, 27477}},
    {4389, 16, 11444, {1, 1, 3, 3, 17, 25, 123, 219, 155, 5, 775, 1437, 7751, 11425, 905, 32765}},
    {4390, 16, 11462, {1, 3, 7, 11, 31, 47, 97, 181, 3, 755, 873, 3059, 1903, 7039, 6247, 27501}},
    {4391, 16, 11465, {1, 1, 7, 15, 29, 57, 61, 167, 337, 279, 917, 1281, 2019, 631, 24707, 4315}},
    {4392, 16, 11471, {1, 1, 5, 3, 19, 37, 49, 195, 207, 595, 217, 1167, 743, 9745, 16995, 47731}},
    {4393, 16, 11473, {1, 3, 7, 13, 5, 17, 71, 63, 229, 495, 1225, 3469, 5497, 1597, 26477, 42043}},
    {4394, 16, 11495, {1, 1, 5, 13, 11, 13, 67, 15, 51, 127, 111, 3183, 1835, 9669, 5977, 8711}},
    {4395, 16, 11499, {1, 1, 7, 13, 17, 53, 109, 67, 485, 943, 23, 1909, 4237, 8905, 25369, 53373}},
    {4396, 16, 11519, {1, 3, 7, 7, 5, 15, 81, 9, 69, 987, 1043, 615, 2039, 5579, 17927, 64263}},
    {4397, 16, 11562, {1, 3, 5, 7, 25, 15, 85, 47, 285, 773, 311, 411, 5625, 10573, 4743, 41139}},
    {4398, 16, 11576, {1, 3, 7, 7, 13, 31, 79, 111, 209, 219, 999, 3081, 1231, 15297, 15659, 28229}},
    {4399, 16, 11582, {1, 3, 7, 1, 13, 27, 105, 185, 141, 707, 563, 2213, 6735, 2105, 31173, 40131}},
    {4400, 16, 11596, {1, 3, 1, 3, 1, 49, 49, 147, 451, 449, 1979, 319, 751, 8799, 10773, 53985}},
    {4401, 16, 11602, {1, 3, 1, 9, 31, 15, 117, 55, 241, 217, 1543, 475, 6719, 9339, 20279, 35637}},
    {4402, 16, 11611, {1, 1, 5, 1, 11, 19, 117, 215, 83, 265, 1817, 2215, 3737, 9989, 6387, 60569}},
    {4403, 16, 11627, {1, 3, 7, 15, 19, 7, 79, 183, 443, 951, 515, 2951, 5277, 13433, 25447, 62853}},
    {4404, 16, 11682, {1, 3, 3, 3, 13, 21, 55, 99, 465, 693, 1975, 1191, 1907, 6573, 22239, 1277}},
    {4405, 16, 11687, {1, 3, 3, 9, 11, 1, 63, 87, 375, 393, 1649, 1385, 697, 13341, 23645, 8229}},
    {4406, 16, 11691, {1, 3, 1, 9, 27, 43, 123, 71, 239, 223, 1403, 2551, 2059, 433, 31057, 17251}},
    {4407, 16, 11733, {1, 3, 1, 15, 31, 57, 39, 219, 203, 211, 399, 1621, 4531, 5021, 29357, 58777}},
    {4408, 16, 11747, {1, 3, 1, 13, 17, 45, 61, 197, 503, 655, 501, 887, 1151, 8285, 8733, 36305}},
    {4409, 16, 11759, {1, 1, 3, 9, 29, 47, 101, 33, 443, 337, 563, 3379, 7689, 4349, 24659, 16217}},
    {4410, 16, 11778, {1, 3, 1, 1, 11, 43, 61, 37, 297, 277, 869, 3501, 6473, 453, 11659, 56367}},
    {4411, 16, 11852, {1, 1, 5, 5, 5, 37, 5, 31, 461, 249, 597, 547, 2943, 13689, 687, 33363}},
    {4412, 16, 11857, {1, 3, 7, 13, 1, 13, 77, 41, 231, 263, 1095, 2585, 2299, 15633, 19165, 49491}},
    {4413, 16, 11858, {1, 1, 3, 13, 19, 29, 1, 207, 117, 361, 1097, 1211, 1343, 7047, 4615, 13997}},
    {4414, 16, 11893, {1, 3, 7, 3, 19, 29, 97, 47, 351, 903, 1783, 1815, 2063, 12207, 14043, 5609}},
    {4415, 16, 11907, {1, 1, 7, 3, 25, 55, 93, 61, 317, 1, 433, 115, 5725, 10819, 14533, 57115}},
    {4416, 16, 11928, {1, 1, 7, 5, 31, 61, 5, 223, 291, 975, 1707, 1577, 4669, 14377, 24481, 3085}},
    {4417, 16, 11931, {1, 3, 7, 5, 17, 7, 55, 65, 213, 681, 2015, 2209, 1565, 11203, 16765, 1831}},
    {4418, 16, 11933, {1, 1, 1, 9, 19, 47, 65, 27, 205, 21, 1405, 2555, 3971, 15871, 21799, 64449}},
    {4419, 16, 11967, {1, 1, 3, 11, 3, 25, 11, 105, 191, 221, 197, 225, 7079, 1383, 32211, 18347}},
    {4420, 16, 11976, {1, 1, 1, 5, 9, 37, 43, 127, 459, 423, 1981, 2463, 5475, 14791, 21807, 53879}},
    {4421, 16, 11989, {1, 1, 5, 9, 3, 9, 43, 27, 369, 581, 1371, 607, 911, 13303, 17087, 42621}},
    {4422, 16, 12003, {1, 3, 5, 11, 3, 15, 49, 63, 141, 661, 303, 2367, 3241, 15115, 12883, 49879}},
    {4423, 16, 12024, {1, 1, 3, 1, 1, 1, 121, 119, 233, 571, 1427, 3271, 3153, 9931, 18491, 50225}},
    {4424, 16, 12030, {1, 3, 1, 1, 3, 13, 9, 241, 69, 339, 1187, 1691, 1253, 13425, 27561, 44833}},
    {4425, 16, 12037, {1, 3, 3, 3, 11, 3, 71, 247, 25, 375, 721, 2343, 7635, 14553, 23077, 16221}},
    {4426, 16, 12044, {1, 3, 5, 13, 19, 17, 31, 9, 89, 377, 1565, 499, 1405, 7437, 23407, 38785}},
    {4427, 16, 12052, {1, 1, 1, 1, 23, 51, 3, 171, 227, 617, 1999, 1395, 1391, 11411, 32255, 60221}},
    {4428, 16, 12059, {1, 3, 3, 13, 9, 55, 53, 171, 451, 317, 1841, 1449, 6127, 8451, 26885, 60427}},
    {4429, 16, 12075, {1, 1, 7, 5, 5, 19, 81, 51, 181, 415, 979, 2369, 2891, 5331, 6471, 62681}},
    {4430, 16, 12083, {1, 3, 1, 3, 19, 17, 125, 69, 131, 567, 1739, 3697, 2281, 11047, 15959, 705}},
    {4431, 16, 12117, {1, 3, 3, 15, 21, 27, 99, 207, 447, 329, 679, 163, 5809, 7451, 16737, 29693}},
    {4432, 16, 12138, {1, 3, 5, 3, 17, 21, 45, 81, 421, 661, 317, 1673, 7545, 14325, 12333, 65319}},
    {4433, 16, 12146, {1, 3, 3, 15, 3, 25, 31, 163, 87, 557, 1133, 3595, 4775, 11299, 26583, 35653}},
    {4434, 16, 12202, {1, 3, 3, 13, 19, 49, 43, 83, 137, 607, 1905, 3675, 6961, 14823, 19805, 41937}},
    {4435, 16, 12230, {1, 1, 3, 11, 21, 15, 71, 249, 161, 693, 1695, 3159, 5561, 8791, 2821, 36811}},
    {4436, 16, 12254, {1, 1, 5, 1, 25, 3, 37, 193, 193, 719, 1307, 795, 4047, 701, 5737, 50477}},
    {4437, 16, 12304, {1, 3, 3, 5, 15, 57, 93, 71, 289, 161, 1317, 2541, 7835, 9275, 30381, 48061}},
    {4438, 16, 12316, {1, 3, 7, 13, 5, 41, 49, 149, 91, 181, 1609, 365, 373, 8597, 9301, 28907}},
    {4439, 16, 12337, {1, 1, 7, 7, 9, 27, 73, 119, 305, 535, 255, 3163, 3255, 10539, 5091, 51113}},
    {4440, 16, 12347, {1, 1, 7, 9, 27, 15, 67, 93, 269, 359, 1571, 3883, 6865, 13633, 8033, 2047}},
    {4441, 16, 12367, {1, 3, 7, 13, 5, 39, 51, 137, 85, 41, 739, 2211, 693, 11703, 32413, 60293}},
    {4442, 16, 12398, {1, 3, 7, 11, 31, 31, 33, 131, 243, 519, 1025, 2889, 5169, 12739, 31619, 21073}},
    {4443, 16, 12421, {1, 3, 3, 1, 17, 3, 99, 119, 289, 869, 1043, 2079, 3903, 4949, 28489, 13573}},
    {4444, 16, 12428, {1, 3, 1, 13, 25, 43, 33, 195, 99, 899, 1009, 1335, 5837, 3763, 7217, 18425}},
    {4445, 16, 12446, {1, 3, 3, 3, 13, 57, 25, 23, 311, 879, 507, 457, 8049, 13907, 5257, 59257}},
    {4446, 16, 12449, {1, 1, 5, 13, 19, 25, 35, 201, 459, 209, 1333, 1991, 3879, 8705, 6951, 6071}},
    {4447, 16, 12467, {1, 3, 7, 5, 31, 3, 43, 21, 279, 497, 1233, 2277, 6405, 5197, 15619, 44049}},
    {4448, 16, 12479, {1, 3, 5, 3, 17, 33, 7, 71, 375, 161, 399, 3705, 7505, 1375, 1003, 34077}},
    {4449, 16, 12502, {1, 3, 5, 13, 7, 35, 11, 155, 17, 147, 323, 2759, 6107, 10345, 27897, 63567}},
    {4450, 16, 12521, {1, 1, 1, 7, 19, 5, 103, 145, 127, 857, 179, 3827, 1903, 14585, 32241, 5095}},
    {4451, 16, 12553, {1, 1, 7, 5, 3, 57, 95, 5, 105, 609, 763, 957, 2401, 10179, 11821, 43673}},
    {4452, 16, 12568, {1, 3, 5, 1, 15, 7, 55, 11, 321, 69, 1091, 3491, 541, 4199, 28033, 29865}},
    {4453, 16, 12573, {1, 1, 7, 5, 7, 21, 105, 21, 45, 223, 1199, 2327, 5103, 13901, 491, 19821}},
    {4454, 16, 12592, {1, 1, 5, 9, 11, 7, 17, 181, 307, 577, 1685, 1963, 2569, 6103, 23113, 26223}},
    {4455, 16, 12597, {1, 3, 1, 3, 13, 27, 9, 171, 267, 637, 1795, 3771, 4209, 323, 24097, 52269}},
    {4456, 16, 12601, {1, 3, 1, 7, 5, 19, 23, 243, 273, 911, 905, 3047, 4571, 7597, 6141, 63455}},
    {4457, 16, 12615, {1, 3, 7, 1, 5, 27, 31, 87, 81, 263, 891, 357, 2485, 14931, 25013, 21219}},
    {4458, 16, 12619, {1, 3, 7, 3, 1, 25, 7, 251, 509, 305, 1777, 3121, 1541, 1987, 21641, 11629}},
    {4459, 16, 12694, {1, 3, 3, 11, 5, 33, 35, 229, 29, 591, 1703, 3395, 5265, 2589, 26165, 40465}},
    {4460, 16, 12697, {1, 1, 1, 1, 3, 3, 125, 37, 343, 477, 933, 2365, 417, 5191, 12321, 65161}},
    {4461, 16, 12698, {1, 3, 7, 1, 1, 33, 69, 155, 305, 29, 1967, 9, 5499, 2979, 29353, 13401}},
    {4462, 16, 12713, {1, 3, 3, 13, 1, 23, 113, 247, 331, 613, 2001, 785, 5335, 8297, 10929, 57317}},
    {4463, 16, 12722, {1, 1, 7, 5, 25, 5, 115, 203, 455, 65, 985, 3007, 1771, 12625, 31101, 17829}},
    {4464, 16, 12733, {1, 3, 1, 3, 25, 5, 105, 21, 427, 797, 1997, 2285, 6257, 1113, 14559, 13595}},
    {4465, 16, 12736, {1, 3, 5, 5, 13, 29, 99, 121, 323, 617, 2031, 2745, 5855, 4689, 13775, 6265}},
    {4466, 16, 12790, {1, 3, 7, 15, 3, 21, 105, 21, 373, 767, 1943, 763, 2399, 15357, 7463, 13075}},
    {4467, 16, 12794, {1, 1, 3, 11, 11, 63, 37, 125, 339, 191, 1235, 2533, 2269, 7643, 15739, 29113}},
    {4468, 16, 12803, {1, 3, 7, 11, 19, 59, 79, 121, 209, 869, 1741, 2541, 1029, 10025, 23569, 13627}},
    {4469, 16, 12815, {1, 1, 1, 13, 17, 35, 69, 163, 269, 251, 861, 2087, 1743, 683, 14489, 50027}},
    {4470, 16, 12829, {1, 1, 7, 3, 13, 35, 79, 209, 211, 863, 1671, 2609, 3991, 14337, 9849, 54761}},
    {4471, 16, 12833, {1, 1, 1, 13, 21, 27, 127, 161, 91, 549, 1601, 2051, 4767, 8267, 31013, 23179}},
    {4472, 16, 12840, {1, 3, 1, 13, 21, 19, 11, 51, 121, 525, 435, 1151, 887, 10395, 5781, 5459}},
    {4473, 16, 12875, {1, 1, 7, 15, 25, 27, 73, 47, 137, 925, 517, 1855, 911, 6513, 15309, 52877}},
    {4474, 16, 12877, {1, 1, 5, 11, 19, 51, 13, 189, 231, 285, 557, 1, 3041, 1365, 18687, 57751}},
    {4475, 16, 12916, {1, 3, 1, 9, 11, 35, 85, 127, 99, 519, 1731, 1947, 6075, 14647, 14653, 47611}},
    {4476, 16, 12923, {1, 1, 7, 13, 29, 47, 51, 233, 21, 343, 1501, 1943, 5519, 7555, 2709, 9687}},
    {4477, 16, 12935, {1, 3, 1, 9, 5, 25, 101, 61, 157, 367, 2025, 1293, 3873, 4015, 26773, 845}},
    {4478, 16, 12949, {1, 3, 7, 13, 15, 25, 121, 191, 351, 771, 15, 365, 3271, 7509, 17253, 35949}},
    {4479, 16, 12954, {1, 3, 7, 7, 11, 33, 123, 19, 81, 829, 1131, 3971, 7331, 5687, 15941, 28657}},
    {4480, 16, 12956, {1, 1, 7, 1, 15, 59, 69, 195, 47, 9, 2027, 3695, 7227, 7861, 29727, 939}},
    {4481, 16, 12959, {1, 3, 1, 1, 17, 17, 19, 217, 453, 281, 133, 493, 5939, 2267, 5169, 7525}},
    {4482, 16, 12978, {1, 1, 7, 1, 21, 51, 3, 147, 361, 739, 1075, 3639, 195, 15091, 13677, 54971}},
    {4483, 16, 13001, {1, 1, 3, 1, 21, 31, 101, 247, 79, 295, 313, 1799, 5745, 14635, 6729, 33937}},
    {4484, 16, 13010, {1, 1, 3, 3, 13, 49, 87, 243, 65, 753, 1055, 2357, 6379, 8841, 28085, 53375}},
    {4485, 16, 13043, {1, 1, 5, 13, 19, 49, 121, 25, 487, 55, 1605, 2041, 481, 14869, 27783, 35039}},
    {4486, 16, 13049, {1, 3, 1, 3, 15, 41, 31, 209, 23, 343, 697, 443, 6379, 4737, 25681, 18089}},
    {4487, 16, 13058, {1, 1, 3, 1, 17, 27, 105, 75, 247, 23, 1241, 3719, 949, 9275, 3303, 2717}},
    {4488, 16, 13112, {1, 1, 1, 5, 31, 59, 7, 29, 215, 789, 11, 2345, 1427, 8399, 11005, 62581}},
    {4489, 16, 13140, {1, 3, 1, 3, 27, 17, 57, 175, 335, 429, 1947, 2013, 3563, 15567, 14055, 44005}},
    {4490, 16, 13149, {1, 3, 7, 7, 15, 33, 65, 239, 115, 1007, 1061, 2451, 6617, 9825, 1219, 38765}},
    {4491, 16, 13163, {1, 1, 5, 1, 23, 61, 13, 201, 221, 133, 1857, 3065, 1719, 11961, 17147, 11483}},
    {4492, 16, 13187, {1, 1, 7, 7, 17, 35, 49, 63, 261, 59, 603, 1931, 1633, 7571, 8039, 45441}},
    {4493, 16, 13196, {1, 1, 5, 1, 3, 31, 95, 77, 89, 53, 1837, 3079, 5041, 11649, 16259, 28113}},
    {4494, 16, 13237, {1, 1, 3, 13, 29, 5, 5, 217, 451, 801, 963, 3213, 7685, 4049, 3119, 10061}},
    {4495, 16, 13244, {1, 3, 1, 9, 3, 1, 71, 209, 239, 901, 391, 4017, 955, 8849, 26923, 44785}},
    {4496, 16, 13264, {1, 3, 7, 15, 31, 51, 63, 181, 461, 51, 351, 2031, 2213, 16147, 16959, 36835}},
    {4497, 16, 13279, {1, 3, 3, 7, 21, 55, 41, 223, 159, 583, 1079, 2329, 5757, 3611, 9605, 10583}},
    {4498, 16, 13292, {1, 3, 5, 5, 3, 7, 41, 133, 289, 545, 47, 3101, 7179, 3151, 12703, 51751}},
    {4499, 16, 13295, {1, 1, 3, 3, 7, 61, 119, 181, 333, 853, 891, 1715, 1617, 2359, 6461, 24977}},
    {4500, 16, 13307, {1, 1, 5, 7, 5, 51, 103, 181, 245, 765, 1133, 3505, 7123, 13367, 19217, 49661}},
    {4501, 16, 13312, {1, 1, 3, 13, 29, 37, 87, 247, 209, 927, 1031, 121, 6449, 8519, 30673, 51763}},
    {4502, 16, 13317, {1, 3, 3, 9, 3, 31, 35, 117, 349, 443, 187, 2453, 4613, 1743, 11821, 29977}},
    {4503, 16, 13327, {1, 1, 3, 9, 11, 49, 61, 139, 65, 113, 401, 3999, 4917, 5213, 5949, 5525}},
    {4504, 16, 13348, {1, 3, 1, 3, 27, 35, 123, 131, 393, 173, 1409, 3659, 7505, 7573, 6553, 3897}},
    {4505, 16, 13390, {1, 1, 1, 9, 5, 49, 107, 195, 17, 799, 1247, 3077, 5575, 507, 15681, 47999}},
    {4506, 16, 13413, {1, 3, 1, 3, 5, 37, 39, 11, 271, 9, 973, 2323, 6723, 7757, 8809, 42931}},
    {4507, 16, 13417, {1, 3, 7, 7, 5, 51, 111, 75, 189, 203, 1629, 2225, 8121, 5553, 24715, 42827}},
    {4508, 16, 13418, {1, 1, 5, 11, 27, 3, 87, 235, 151, 501, 727, 1675, 2127, 11409, 30643, 49851}},
    {4509, 16, 13451, {1, 3, 1, 7, 21, 3, 123, 3, 429, 427, 61, 1575, 1889, 13849, 31663, 3417}},
    {4510, 16, 13475, {1, 3, 3, 1, 15, 39, 101, 239, 417, 203, 2003, 1599, 1231, 9947, 5805, 50505}},
    {4511, 16, 13482, {1, 1, 1, 3, 3, 27, 97, 109, 509, 405, 835, 3991, 3125, 11569, 6823, 33951}},
    {4512, 16, 13510, {1, 1, 7, 1, 1, 31, 93, 41, 169, 143, 645, 2889, 1667, 13201, 30277, 47887}},
    {4513, 16, 13527, {1, 1, 3, 7, 19, 59, 85, 235, 329, 143, 1685, 1139, 3725, 12111, 467, 21995}},
    {4514, 16, 13543, {1, 1, 5, 11, 23, 37, 105, 131, 251, 831, 757, 1047, 7367, 9711, 13599, 50059}},
    {4515, 16, 13547, {1, 1, 1, 3, 19, 13, 37, 193, 85, 67, 357, 3895, 5691, 12539, 663, 919}},
    {4516, 16, 13627, {1, 1, 5, 1, 31, 39, 99, 97, 291, 57, 2007, 1705, 6085, 3251, 4519, 7271}},
    {4517, 16, 13650, {1, 1, 1, 1, 7, 61, 119, 7, 27, 609, 1823, 1989, 6611, 1361, 9159, 55487}},
    {4518, 16, 13683, {1, 1, 7, 5, 17, 39, 87, 109, 219, 785, 567, 3869, 5341, 1207, 25551, 5371}},
    {4519, 16, 13696, {1, 1, 3, 11, 19, 43, 83, 171, 137, 105, 263, 1815, 6821, 8397, 29007, 21203}},
    {4520, 16, 13702, {1, 3, 7, 3, 1, 51, 21, 195, 287, 123, 233, 1331, 7395, 13159, 3875, 30023}},
    {4521, 16, 13713, {1, 3, 7, 7, 29, 61, 29, 195, 85, 119, 695, 3965, 3043, 2563, 2657, 44393}},
    {4522, 16, 13739, {1, 3, 7, 15, 25, 11, 81, 1, 363, 697, 1835, 1423, 4777, 6257, 24187, 56631}},
    {4523, 16, 13749, {1, 1, 3, 3, 15, 59, 11, 249, 169, 999, 1087, 3201, 3113, 9587, 17505, 62295}},
    {4524, 16, 13767, {1, 3, 7, 7, 29, 57, 3, 41, 169, 487, 1749, 1091, 3999, 1865, 16159, 22773}},
    {4525, 16, 13774, {1, 1, 5, 5, 29, 21, 35, 191, 457, 945, 1905, 2599, 47, 14297, 1997, 30267}},
    {4526, 16, 13781, {1, 3, 7, 9, 31, 17, 17, 107, 509, 383, 1167, 4089, 2063, 1879, 32163, 25957}},
    {4527, 16, 13795, {1, 1, 1, 9, 11, 45, 37, 25, 307, 837, 2047, 3357, 5641, 4145, 13177, 59409}},
    {4528, 16, 13821, {1, 1, 3, 3, 3, 35, 119, 115, 211, 81, 133, 2531, 4681, 1449, 8545, 16809}},
    {4529, 16, 13825, {1, 1, 1, 15, 31, 29, 95, 171, 45, 453, 1285, 1249, 2139, 16161, 11763, 20819}},
    {4530, 16, 13838, {1, 1, 3, 5, 21, 9, 47, 123, 93, 407, 595, 2547, 507, 15523, 11533, 28787}},
    {4531, 16, 13852, {1, 3, 7, 9, 9, 61, 105, 235, 231, 625, 109, 1121, 3367, 14747, 10483, 59145}},
    {4532, 16, 13879, {1, 1, 7, 1, 7, 61, 89, 237, 493, 287, 1419, 3091, 3107, 8365, 3085, 60623}},
    {4533, 16, 13888, {1, 3, 1, 7, 3, 37, 45, 9, 69, 487, 1535, 935, 5455, 4599, 12903, 22337}},
    {4534, 16, 13897, {1, 1, 3, 5, 13, 15, 81, 189, 369, 645, 775, 1779, 95, 3563, 7785, 46031}},
    {4535, 16, 13906, {1, 1, 1, 13, 21, 33, 57, 123, 399, 387, 1111, 1221, 3593, 7191, 24107, 33813}},
    {4536, 16, 13939, {1, 3, 7, 11, 25, 53, 65, 189, 483, 833, 1019, 3631, 1207, 10473, 20947, 19561}},
    {4537, 16, 13962, {1, 3, 5, 3, 1, 49, 23, 161, 11, 35, 1447, 3105, 7833, 1067, 21001, 9545}},
    {4538, 16, 13981, {1, 3, 3, 5, 13, 15, 35, 65, 461, 963, 333, 7, 7537, 8997, 24855, 42467}},
    {4539, 16, 13985, {1, 3, 1, 15, 29, 33, 117, 239, 273, 475, 659, 2831, 2497, 8267, 5597, 9831}},
    {4540, 16, 14020, {1, 1, 3, 5, 3, 41, 21, 35, 55, 591, 2031, 819, 1231, 1913, 24675, 5091}},
    {4541, 16, 14030, {1, 1, 7, 15, 17, 13, 123, 61, 383, 405, 1617, 3485, 1913, 9105, 2149, 55225}},
    {4542, 16, 14041, {1, 1, 1, 9, 31, 59, 101, 163, 131, 691, 865, 3835, 1979, 113, 16387, 10521}},
    {4543, 16, 14047, {1, 1, 3, 7, 29, 15, 37, 169, 331, 73, 119, 3979, 1733, 10119, 1085, 6675}},
    {4544, 16, 14048, {1, 1, 1, 5, 9, 27, 19, 137, 183, 717, 409, 2615, 5135, 5673, 12889, 21587}},
    {4545, 16, 14066, {1, 1, 1, 15, 19, 23, 55, 111, 439, 755, 1909, 3409, 4457, 14107, 17559, 13231}},
    {4546, 16, 14092, {1, 1, 5, 13, 27, 45, 35, 39, 331, 303, 1771, 2517, 5717, 10247, 5357, 36919}},
    {4547, 16, 14120, {1, 1, 5, 5, 13, 59, 57, 205, 505, 67, 799, 3375, 7659, 12293, 12153, 8423}},
    {4548, 16, 14126, {1, 1, 5, 7, 9, 21, 123, 117, 383, 275, 1735, 1867, 649, 14013, 19581, 63547}},
    {4549, 16, 14131, {1, 3, 3, 5, 15, 5, 21, 43, 367, 517, 1283, 1709, 1455, 13641, 26963, 40419}},
    {4550, 16, 14143, {1, 1, 3, 5, 7, 41, 51, 11, 65, 933, 1739, 151, 3553, 3187, 30047, 29047}},
    {4551, 16, 14146, {1, 1, 7, 7, 23, 55, 19, 111, 399, 107, 1377, 1575, 1761, 11855, 30387, 60669}},
    {4552, 16, 14152, {1, 3, 3, 5, 29, 1, 37, 21, 141, 219, 1929, 3677, 2493, 11041, 9979, 6421}},
    {4553, 16, 14155, {1, 3, 5, 3, 13, 3, 69, 153, 221, 247, 49, 327, 7879, 11037, 32303, 24695}},
    {4554, 16, 14157, {1, 1, 1, 11, 3, 63, 77, 9, 379, 205, 1935, 65, 3317, 10761, 21659, 28521}},
    {4555, 16, 14188, {1, 3, 1, 11, 19, 11, 47, 91, 201, 439, 769, 2001, 1385, 1295, 32727, 6453}},
    {4556, 16, 14206, {1, 1, 5, 13, 23, 37, 113, 13, 363, 623, 491, 2047, 5397, 15923, 16785, 3995}},
    {4557, 16, 14243, {1, 3, 5, 7, 1, 45, 27, 13, 227, 319, 531, 3619, 7459, 8419, 28355, 34327}},
    {4558, 16, 14278, {1, 3, 5, 7, 29, 15, 9, 89, 9, 1019, 1689, 3717, 7913, 5689, 19977, 49691}},
    {4559, 16, 14308, {1, 3, 1, 9, 27, 11, 41, 59, 119, 773, 1739, 2463, 6947, 7963, 22659, 29419}},
    {4560, 16, 14317, {1, 1, 3, 1, 19, 3, 5, 21, 355, 965, 1969, 3105, 7031, 4531, 16519, 18975}},
    {4561, 16, 14335, {1, 3, 1, 9, 21, 61, 31, 127, 457, 667, 627, 3993, 4177, 2117, 13233, 10799}},
    {4562, 16, 14354, {1, 3, 7, 1, 23, 43, 77, 219, 473, 315, 1515, 1897, 5425, 10543, 11527, 64797}},
    {4563, 16, 14356, {1, 3, 7, 11, 15, 21, 49, 23, 271, 865, 1129, 2933, 3975, 6747, 12283, 49885}},
    {4564, 16, 14379, {1, 1, 5, 9, 7, 61, 49, 105, 75, 423, 427, 2905, 4965, 1239, 10421, 32231}},
    {4565, 16, 14381, {1, 1, 3, 15, 21, 35, 75, 213, 337, 503, 1105, 3251, 7913, 7335, 4683, 22357}},
    {4566, 16, 14384, {1, 3, 7, 9, 5, 47, 115, 33, 385, 619, 691, 2513, 5331, 11399, 13995, 15021}},
    {4567, 16, 14389, {1, 3, 5, 13, 29, 27, 1, 41, 431, 623, 1659, 149, 4771, 81, 16931, 53789}},
    {4568, 16, 14390, {1, 3, 1, 1, 11, 39, 103, 53, 229, 709, 323, 493, 7145, 3941, 32529, 63983}},
    {4569, 16, 14414, {1, 1, 3, 7, 21, 33, 121, 17, 477, 41, 1611, 431, 4209, 5759, 17583, 60599}},
    {4570, 16, 14425, {1, 1, 5, 1, 15, 13, 95, 101, 107, 309, 1265, 2931, 6211, 14841, 25661, 32293}},
    {4571, 16, 14462, {1, 3, 1, 1, 17, 11, 75, 97, 109, 705, 1093, 3837, 6283, 4783, 27791, 12775}},
    {4572, 16, 14472, {1, 3, 1, 7, 25, 45, 55, 3, 253, 285, 65, 1561, 7131, 1113, 25809, 15767}},
    {4573, 16, 14508, {1, 3, 3, 13, 7, 33, 75, 209, 439, 47, 1161, 2369, 913, 2879, 21159, 50319}},
    {4574, 16, 14511, {1, 1, 7, 13, 21, 49, 97, 161, 21, 697, 187, 149, 1375, 6963, 1727, 16521}},
    {4575, 16, 14519, {1, 3, 7, 13, 21, 45, 65, 155, 445, 889, 111, 3773, 793, 4655, 15359, 18015}},
    {4576, 16, 14528, {1, 1, 7, 1, 29, 37, 53, 133, 337, 291, 817, 3303, 6943, 8707, 7451, 6099}},
    {4577, 16, 14561, {1, 1, 5, 5, 29, 15, 77, 77, 1, 487, 167, 1489, 3471, 4805, 25103, 845}},
    {4578, 16, 14574, {1, 1, 7, 5, 1, 1, 117, 251, 315, 717, 255, 3949, 1215, 1857, 13209, 16855}},
    {4579, 16, 14588, {1, 3, 1, 3, 3, 49, 123, 25, 187, 787, 505, 3405, 8061, 6315, 3801, 20689}},
    {4580, 16, 14594, {1, 3, 1, 3, 11, 55, 115, 143, 399, 505, 1143, 1525, 2465, 14373, 12503, 56097}},
    {4581, 16, 14606, {1, 1, 7, 7, 3, 39, 69, 181, 13, 957, 111, 957, 5745, 10489, 1987, 31163}},
    {4582, 16, 14614, {1, 3, 3, 9, 3, 53, 81, 27, 205, 983, 1745, 1413, 1545, 10671, 29785, 20607}},
    {4583, 16, 14639, {1, 1, 1, 5, 13, 13, 53, 87, 31, 561, 611, 3401, 6907, 4445, 3309, 5121}},
    {4584, 16, 14641, {1, 1, 1, 13, 3, 43, 87, 225, 387, 807, 229, 2671, 7863, 15393, 28633, 30165}},
    {4585, 16, 14648, {1, 3, 3, 3, 25, 61, 67, 135, 155, 99, 979, 685, 1511, 5837, 30385, 55077}},
    {4586, 16, 14668, {1, 3, 5, 15, 31, 23, 107, 233, 391, 475, 655, 165, 2907, 3531, 28681, 7945}},
    {4587, 16, 14673, {1, 3, 5, 7, 5, 27, 29, 149, 363, 585, 409, 1717, 511, 14281, 28135, 61513}},
    {4588, 16, 14679, {1, 1, 3, 3, 3, 37, 29, 255, 313, 843, 1707, 149, 1227, 3643, 24939, 22191}},
    {4589, 16, 14695, {1, 1, 1, 9, 5, 25, 29, 71, 275, 321, 471, 491, 7435, 8477, 23247, 14799}},
    {4590, 16, 14702, {1, 3, 7, 5, 25, 3, 121, 57, 289, 257, 1793, 1947, 2907, 4233, 16759, 31191}},
    {4591, 16, 14704, {1, 1, 3, 1, 29, 13, 49, 143, 375, 213, 503, 1735, 5385, 11305, 32705, 38881}},
    {4592, 16, 14740, {1, 3, 5, 15, 5, 57, 47, 169, 397, 173, 1643, 2729, 1915, 7983, 10141, 17343}},
    {4593, 16, 14754, {1, 1, 1, 15, 27, 11, 115, 49, 281, 47, 735, 123, 6037, 3375, 245, 23777}},
    {4594, 16, 14774, {1, 1, 5, 5, 23, 47, 101, 163, 135, 873, 1959, 3581, 4385, 8417, 14677, 13763}},
    {4595, 16, 14792, {1, 3, 5, 9, 1, 11, 105, 107, 37, 505, 1513, 2615, 5727, 1225, 23227, 5427}},
    {4596, 16, 14797, {1, 3, 5, 13, 5, 47, 47, 33, 65, 47, 949, 1519, 3325, 12547, 23317, 7133}},
    {4597, 16, 14806, {1, 3, 7, 3, 5, 47, 59, 145, 365, 13, 19, 655, 6157, 13589, 15653, 8507}},
    {4598, 16, 14812, {1, 1, 3, 9, 31, 59, 125, 201, 457, 203, 237, 3369, 5905, 6943, 18437, 59441}},
    {4599, 16, 14856, {1, 3, 1, 9, 29, 35, 57, 69, 455, 473, 771, 1165, 6383, 10157, 13135, 18733}},
    {4600, 16, 14876, {1, 3, 5, 11, 23, 23, 43, 7, 351, 263, 1911, 3417, 2975, 3893, 32339, 41149}},
    {4601, 16, 14900, {1, 1, 3, 1, 25, 63, 67, 193, 507, 933, 1657, 3739, 4833, 10833, 1227, 52525}},
    {4602, 16, 14910, {1, 3, 7, 3, 25, 61, 81, 147, 191, 135, 1977, 1431, 2885, 3691, 28043, 21999}},
    {4603, 16, 14912, {1, 3, 1, 7, 27, 63, 93, 43, 43, 583, 737, 1155, 3391, 3895, 27825, 43075}},
    {4604, 16, 14915, {1, 3, 5, 3, 31, 55, 59, 85, 315, 57, 201, 3943, 3677, 8331, 4603, 12505}},
    {4605, 16, 14922, {1, 3, 7, 3, 3, 33, 95, 55, 205, 561, 545, 3109, 4187, 153, 17787, 2911}},
    {4606, 16, 14939, {1, 1, 5, 1, 29, 59, 63, 249, 449, 493, 529, 407, 6423, 7215, 3961, 46469}},
    {4607, 16, 14946, {1, 1, 1, 11, 17, 59, 81, 171, 311, 755, 1377, 3445, 3479, 783, 1909, 60659}},
    {4608, 16, 14955, {1, 3, 7, 15, 23, 17, 3, 139, 409, 15, 573, 2949, 191, 11321, 29901, 28609}},
    {4609, 16, 14966, {1, 3, 3, 11, 23, 43, 21, 15, 483, 949, 297, 3145, 7069, 14271, 14385, 43999}},
    {4610, 16, 14976, {1, 3, 3, 15, 23, 29, 67, 157, 301, 465, 1505, 561, 7385, 7215, 3047, 4833}},
    {4611, 16, 14986, {1, 3, 5, 15, 25, 33, 7, 161, 403, 991, 1313, 743, 4095, 4083, 30099, 59821}},
    {4612, 16, 14993, {1, 1, 1, 11, 19, 61, 45, 183, 263, 113, 279, 1837, 1721, 7151, 26631, 34399}},
    {4613, 16, 15012, {1, 1, 5, 3, 25, 1, 79, 179, 17, 295, 435, 1925, 7695, 7499, 19791, 45845}},
    {4614, 16, 15041, {1, 3, 7, 9, 25, 29, 63, 109, 473, 105, 1993, 3893, 577, 151, 16635, 31719}},
    {4615, 16, 15053, {1, 1, 3, 3, 11, 11, 101, 33, 69, 565, 1803, 2925, 5485, 3751, 6063, 10653}},
    {4616, 16, 15056, {1, 1, 7, 9, 13, 37, 125, 107, 327, 715, 1703, 1, 5829, 8213, 29977, 25659}},
    {4617, 16, 15059, {1, 3, 1, 11, 9, 27, 21, 239, 457, 337, 197, 889, 1103, 585, 14225, 32715}},
    {4618, 16, 15110, {1, 1, 7, 13, 13, 63, 117, 63, 387, 375, 683, 277, 5129, 279, 23169, 39969}},
    {4619, 16, 15116, {1, 1, 5, 13, 29, 53, 63, 87, 435, 411, 1729, 2733, 7361, 3131, 31703, 42121}},
    {4620, 16, 15133, {1, 1, 3, 7, 29, 59, 123, 151, 139, 355, 345, 653, 5721, 11107, 3783, 13229}},
    {4621, 16, 15134, {1, 1, 3, 3, 7, 1, 125, 127, 423, 691, 875, 3151, 3503, 6551, 32393, 48333}},
    {4622, 16, 15137, {1, 3, 5, 13, 11, 5, 13, 55, 291, 71, 605, 153, 7193, 4537, 1437, 22173}},
    {4623, 16, 15147, {1, 1, 7, 7, 31, 11, 91, 41, 273, 519, 1561, 2693, 2135, 2673, 30439, 37507}},
    {4624, 16, 15182, {1, 1, 1, 1, 9, 21, 7, 57, 185, 851, 813, 2791, 7873, 4761, 9483, 1011}},
    {4625, 16, 15203, {1, 3, 7, 1, 19, 1, 73, 163, 19, 365, 889, 2161, 2721, 14213, 393, 38933}},
    {4626, 16, 15215, {1, 1, 5, 11, 13, 29, 13, 243, 161, 355, 5, 131, 6043, 15531, 27129, 13737}},
    {4627, 16, 15245, {1, 3, 1, 1, 1, 1, 105, 51, 173, 463, 1995, 307, 6607, 13067, 20327, 295}},
    {4628, 16, 15246, {1, 1, 3, 7, 7, 33, 25, 117, 211, 153, 179, 2173, 4435, 115, 24077, 749}},
    {4629, 16, 15264, {1, 3, 3, 5, 19, 21, 71, 249, 53, 837, 257, 1981, 5017, 12101, 6763, 62671}},
    {4630, 16, 15269, {1, 1, 3, 5, 1, 3, 49, 185, 133, 313, 429, 2867, 8049, 955, 26135, 46959}},
    {4631, 16, 15296, {1, 1, 3, 3, 1, 31, 9, 127, 489, 49, 1849, 2825, 6907, 12641, 30425, 57769}},
    {4632, 16, 15314, {1, 3, 1, 11, 21, 57, 23, 245, 143, 29, 1263, 1643, 6459, 1195, 4295, 52259}},
    {4633, 16, 15323, {1, 1, 5, 1, 7, 19, 21, 103, 381, 161, 1843, 3991, 2407, 8961, 4293, 55923}},
    {4634, 16, 15364, {1, 1, 5, 1, 23, 33, 89, 195, 171, 777, 753, 247, 1055, 2563, 29457, 45009}},
    {4635, 16, 15386, {1, 1, 5, 13, 31, 51, 101, 27, 283, 681, 629, 913, 201, 15171, 20583, 44743}},
    {4636, 16, 15391, {1, 1, 5, 9, 29, 1, 99, 115, 83, 27, 1109, 5, 669, 12453, 28945, 14029}},
    {4637, 16, 15436, {1, 3, 1, 9, 21, 45, 37, 189, 57, 61, 109, 1031, 2563, 6613, 11359, 15335}},
    {4638, 16, 15460, {1, 3, 5, 13, 9, 9, 85, 203, 281, 809, 1489, 1737, 461, 9231, 13513, 47523}},
    {4639, 16, 15464, {1, 1, 5, 9, 23, 41, 37, 87, 255, 575, 1691, 827, 7543, 403, 23665, 41941}},
    {4640, 16, 15469, {1, 1, 7, 1, 23, 21, 77, 169, 471, 187, 1309, 1173, 4325, 1289, 1039, 19217}},
    {4641, 16, 15470, {1, 3, 1, 15, 17, 19, 67, 133, 81, 249, 1837, 2169, 3929, 8765, 3875, 63933}},
    {4642, 16, 15477, {1, 1, 1, 1, 7, 55, 69, 69, 177, 433, 509, 2865, 537, 229, 14317, 63853}},
    {4643, 16, 15488, {1, 3, 7, 15, 5, 59, 47, 173, 203, 53, 1053, 153, 2675, 2669, 4955, 60229}},
    {4644, 16, 15494, {1, 3, 3, 5, 5, 15, 5, 167, 161, 1023, 105, 2527, 1845, 123, 4329, 48163}},
    {4645, 16, 15548, {1, 1, 3, 3, 25, 31, 103, 165, 475, 939, 471, 1007, 1209, 203, 28561, 29425}},
    {4646, 16, 15551, {1, 3, 1, 15, 21, 9, 43, 17, 389, 827, 79, 1603, 7823, 13887, 14411, 33343}},
    {4647, 16, 15560, {1, 1, 5, 7, 19, 41, 123, 87, 135, 153, 361, 2235, 5237, 11911, 18361, 55523}},
    {4648, 16, 15563, {1, 1, 1, 15, 5, 23, 1, 11, 103, 527, 977, 1283, 1379, 13705, 13379, 59}},
    {4649, 16, 15604, {1, 1, 1, 1, 29, 39, 43, 119, 247, 917, 239, 405, 7229, 6251, 12925, 36407}},
    {4650, 16, 15607, {1, 1, 5, 11, 31, 11, 67, 21, 415, 1021, 1011, 3775, 7359, 853, 13627, 109}},
    {4651, 16, 15616, {1, 1, 1, 3, 11, 29, 65, 127, 193, 915, 693, 665, 3305, 2615, 18061, 25615}},
    {4652, 16, 15631, {1, 1, 7, 5, 25, 9, 1, 43, 373, 335, 1781, 283, 7971, 8501, 5859, 64415}},
    {4653, 16, 15699, {1, 1, 5, 15, 3, 9, 71, 3, 377, 207, 775, 2797, 6897, 16325, 15339, 36599}},
    {4654, 16, 15701, {1, 3, 3, 1, 1, 31, 103, 101, 51, 583, 269, 3231, 839, 7817, 25979, 53175}},
    {4655, 16, 15708, {1, 3, 3, 9, 23, 25, 63, 153, 229, 605, 1645, 1457, 1639, 4045, 1701, 38523}},
    {4656, 16, 15739, {1, 3, 5, 3, 7, 9, 97, 97, 189, 189, 181, 3053, 6745, 9133, 1593, 41707}},
    {4657, 16, 15746, {1, 3, 3, 15, 17, 43, 117, 169, 501, 245, 1269, 2121, 7853, 12503, 26585, 35179}},
    {4658, 16, 15772, {1, 3, 7, 9, 5, 7, 97, 43, 451, 9, 581, 3781, 5797, 1059, 25183, 27963}},
    {4659, 16, 15793, {1, 1, 3, 3, 23, 11, 39, 127, 489, 533, 843, 2215, 1653, 6051, 21791, 1211}},
    {4660, 16, 15832, {1, 1, 3, 7, 9, 31, 31, 235, 81, 683, 1391, 1509, 2531, 6571, 23071, 40051}},
    {4661, 16, 15837, {1, 3, 5, 3, 31, 59, 63, 251, 39, 627, 965, 4007, 1205, 1231, 18629, 25381}},
    {4662, 16, 15866, {1, 1, 3, 7, 1, 17, 19, 91, 95, 875, 1535, 3175, 2981, 13151, 637, 10145}},
    {4663, 16, 15899, {1, 1, 5, 13, 17, 15, 75, 209, 125, 127, 2023, 2441, 3213, 8797, 20513, 48389}},
    {4664, 16, 15911, {1, 3, 3, 9, 25, 51, 31, 39, 43, 615, 35, 193, 3335, 5951, 16151, 52735}},
    {4665, 16, 15918, {1, 3, 1, 1, 3, 1, 37, 157, 61, 857, 459, 3509, 6359, 3049, 4849, 15411}},
    {4666, 16, 15952, {1, 3, 1, 11, 29, 11, 39, 7, 355, 347, 507, 3659, 1241, 13931, 14297, 53171}},
    {4667, 16, 15962, {1, 3, 3, 1, 1, 51, 41, 11, 171, 409, 395, 2237, 8049, 14807, 21433, 56629}},
    {4668, 16, 15967, {1, 1, 5, 7, 25, 15, 31, 235, 369, 63, 509, 35, 5643, 1955, 11525, 10487}},
    {4669, 16, 15973, {1, 1, 3, 7, 19, 63, 113, 93, 461, 759, 673, 2873, 2573, 13289, 18739, 15007}},
    {4670, 16, 15977, {1, 3, 7, 15, 9, 25, 29, 107, 129, 545, 993, 3203, 2447, 13237, 5951, 18927}},
    {4671, 16, 16016, {1, 3, 7, 3, 27, 29, 95, 229, 245, 851, 827, 2725, 2851, 2219, 24965, 53365}},
    {4672, 16, 16035, {1, 1, 1, 11, 1, 47, 5, 201, 139, 231, 1781, 3769, 837, 15221, 17999, 3875}},
    {4673, 16, 16044, {1, 3, 3, 15, 21, 59, 7, 161, 275, 35, 927, 3529, 8067, 13275, 13281, 4679}},
    {4674, 16, 16067, {1, 1, 1, 5, 9, 53, 67, 45, 57, 923, 515, 1465, 1893, 12457, 18961, 18689}},
    {4675, 16, 16082, {1, 3, 5, 3, 7, 5, 29, 227, 175, 769, 525, 3031, 7415, 13725, 12337, 8925}},
    {4676, 16, 16084, {1, 1, 5, 13, 25, 1, 37, 11, 493, 93, 691, 3001, 3369, 13349, 18979, 56203}},
    {4677, 16, 16098, {1, 3, 3, 11, 19, 29, 3, 169, 461, 31, 561, 2219, 6795, 12707, 1147, 19339}},
    {4678, 16, 16107, {1, 1, 3, 9, 9, 31, 23, 37, 435, 729, 121, 2483, 8009, 14229, 6961, 40681}},
    {4679, 16, 16142, {1, 3, 1, 13, 29, 39, 91, 115, 237, 867, 1455, 3155, 1417, 4943, 21693, 4847}},
    {4680, 16, 16149, {1, 3, 7, 3, 9, 7, 43, 249, 41, 185, 2031, 461, 3885, 1677, 28851, 62231}},
    {4681, 16, 16165, {1, 3, 1, 5, 5, 47, 93, 205, 357, 177, 1829, 305, 1833, 8135, 24659, 16545}},
    {4682, 16, 16172, {1, 1, 7, 9, 25, 15, 47, 113, 261, 633, 629, 1037, 2901, 9727, 26055, 8659}},
    {4683, 16, 16178, {1, 1, 1, 3, 15, 33, 113, 223, 85, 253, 1921, 987, 7567, 4363, 13529, 59621}},
    {4684, 16, 16197, {1, 3, 7, 13, 25, 47, 81, 163, 231, 237, 501, 875, 2485, 12653, 23039, 47081}},
    {4685, 16, 16201, {1, 3, 5, 7, 5, 7, 95, 169, 285, 465, 2005, 2955, 6673, 3557, 6263, 49673}},
    {4686, 16, 16215, {1, 1, 1, 3, 5, 61, 85, 157, 121, 59, 1361, 1937, 4747, 931, 31857, 11253}},
    {4687, 16, 16221, {1, 1, 3, 13, 23, 63, 27, 77, 503, 733, 1475, 2479, 1619, 5809, 27939, 3921}},
    {4688, 16, 16226, {1, 3, 7, 5, 5, 19, 5, 1, 301, 515, 1269, 855, 5705, 15033, 4219, 51449}},
    {4689, 16, 16232, {1, 1, 7, 15, 27, 43, 117, 97, 49, 737, 1869, 1763, 6773, 2267, 10411, 693}},
    {4690, 16, 16246, {1, 1, 1, 1, 29, 47, 1, 137, 429, 891, 219, 1119, 3039, 87, 23381, 53361}},
    {4691, 16, 16261, {1, 1, 3, 11, 13, 3, 45, 7, 329, 895, 1263, 553, 3191, 16353, 20453, 47151}},
    {4692, 16, 16279, {1, 1, 5, 3, 15, 21, 17, 43, 277, 425, 1019, 3611, 3441, 5907, 29671, 62579}},
    {4693, 16, 16280, {1, 1, 5, 7, 29, 55, 37, 43, 241, 259, 1873, 3829, 859, 1069, 8507, 32725}},
    {4694, 16, 16290, {1, 3, 5, 3, 7, 29, 73, 201, 277, 553, 1067, 2211, 6635, 14683, 22745, 34935}},
    {4695, 16, 16314, {1, 1, 3, 13, 9, 21, 85, 245, 235, 401, 1277, 3935, 5203, 12955, 13843, 61711}},
    {4696, 16, 16345, {1, 1, 3, 11, 31, 17, 33, 113, 183, 953, 609, 3009, 5511, 10307, 7879, 43963}},
    {4697, 16, 16355, {1, 3, 1, 1, 27, 55, 91, 175, 177, 145, 177, 1267, 2393, 6011, 5095, 43583}},
    {4698, 16, 16361, {1, 1, 3, 13, 11, 55, 75, 183, 407, 363, 247, 3487, 3361, 16053, 32421, 4779}},
    {4699, 16, 16393, {1, 3, 7, 1, 19, 47, 123, 237, 309, 249, 495, 979, 6565, 13613, 4307, 60427}},
    {4700, 16, 16394, {1, 3, 3, 1, 21, 51, 51, 117, 337, 229, 1551, 2227, 2287, 1627, 6745, 37985}},
    {4701, 16, 16438, {1, 3, 1, 13, 1, 21, 33, 181, 147, 867, 1825, 1901, 5811, 14531, 10153, 52997}},
    {4702, 16, 16450, {1, 3, 5, 1, 9, 1, 95, 63, 367, 905, 1553, 2103, 7823, 2685, 18867, 11729}},
    {4703, 16, 16507, {1, 1, 7, 1, 9, 53, 31, 23, 259, 263, 711, 1249, 875, 13389, 15901, 35519}},
    {4704, 16, 16523, {1, 3, 7, 5, 7, 37, 55, 89, 355, 819, 125, 2091, 7743, 15843, 27149, 8233}},
    {4705, 16, 16533, {1, 3, 5, 9, 7, 53, 95, 209, 195, 11, 851, 3889, 4639, 6213, 8195, 363}},
    {4706, 16, 16603, {1, 1, 5, 11, 3, 23, 31, 197, 245, 839, 169, 2747, 1855, 12021, 3573, 26935}},
    {4707, 16, 16648, {1, 3, 1, 7, 1, 43, 113, 157, 291, 289, 1965, 685, 915, 13277, 30803, 27251}},
    {4708, 16, 16653, {1, 1, 1, 9, 27, 13, 47, 105, 391, 203, 1077, 441, 1315, 9361, 3063, 63855}},
    {4709, 16, 16672, {1, 3, 1, 11, 11, 25, 21, 77, 283, 93, 203, 3091, 529, 11441, 23047, 22201}},
    {4710, 16, 16682, {1, 3, 5, 11, 25, 31, 53, 215, 91, 281, 403, 3507, 2107, 1431, 24033, 1783}},
    {4711, 16, 16709, {1, 1, 1, 7, 25, 51, 17, 211, 279, 899, 547, 1045, 7427, 7621, 1097, 1477}},
    {4712, 16, 16713, {1, 1, 5, 15, 31, 3, 15, 13, 417, 977, 1445, 2185, 4481, 8243, 3555, 52385}},
    {4713, 16, 16719, {1, 3, 3, 15, 19, 17, 107, 79, 41, 371, 313, 1953, 7837, 10395, 7495, 11583}},
    {4714, 16, 16733, {1, 3, 7, 7, 5, 63, 63, 223, 173, 613, 1683, 113, 7273, 11643, 20679, 59751}},
    {4715, 16, 16740, {1, 1, 5, 13, 31, 45, 23, 223, 153, 955, 427, 3287, 3387, 2257, 863, 29387}},
    {4716, 16, 16761, {1, 1, 1, 9, 15, 37, 55, 167, 507, 245, 1541, 635, 493, 4409, 1887, 17923}},
    {4717, 16, 16767, {1, 1, 7, 15, 29, 37, 35, 3, 237, 241, 317, 2333, 5053, 6381, 17011, 48839}},
    {4718, 16, 16771, {1, 3, 1, 3, 29, 39, 75, 235, 397, 613, 445, 3811, 435, 11849, 24387, 56855}},
    {4719, 16, 16788, {1, 3, 3, 15, 5, 43, 45, 155, 309, 157, 619, 2833, 4109, 8273, 20339, 53643}},
    {4720, 16, 16811, {1, 3, 7, 5, 11, 21, 85, 207, 403, 387, 1111, 409, 5821, 11809, 3763, 12997}},
    {4721, 16, 16814, {1, 3, 7, 5, 13, 45, 45, 181, 183, 485, 409, 939, 7989, 6327, 29473, 16945}},
    {4722, 16, 16816, {1, 1, 3, 13, 19, 27, 27, 63, 261, 397, 1943, 2367, 2469, 5717, 6835, 13075}},
    {4723, 16, 16828, {1, 1, 5, 11, 3, 25, 35, 49, 503, 185, 1329, 1435, 1163, 3179, 7427, 33897}},
    {4724, 16, 16834, {1, 3, 7, 3, 1, 21, 109, 189, 55, 763, 1485, 2973, 8165, 7519, 14723, 28241}},
    {4725, 16, 16863, {1, 3, 7, 5, 9, 51, 109, 175, 393, 51, 427, 1605, 2561, 14389, 3663, 33069}},
    {4726, 16, 16864, {1, 1, 5, 7, 31, 23, 89, 177, 469, 381, 735, 4071, 275, 10047, 339, 29641}},
    {4727, 16, 16879, {1, 3, 7, 11, 29, 33, 89, 123, 343, 1015, 403, 2617, 7453, 9651, 28179, 60421}},
    {4728, 16, 16888, {1, 1, 3, 5, 19, 35, 23, 123, 239, 543, 267, 3689, 6841, 11245, 7311, 32995}},
    {4729, 16, 16904, {1, 1, 3, 13, 17, 35, 25, 9, 117, 561, 1085, 2071, 1025, 6641, 2991, 64403}},
    {4730, 16, 16909, {1, 3, 5, 1, 5, 25, 121, 207, 405, 697, 1643, 2055, 7719, 13501, 12383, 49609}},
    {4731, 16, 16921, {1, 3, 3, 1, 27, 27, 105, 15, 491, 749, 745, 3231, 6757, 13141, 3629, 49575}},
    {4732, 16, 16934, {1, 3, 1, 7, 19, 61, 91, 243, 511, 923, 7, 2795, 5895, 7925, 16263, 10765}},
    {4733, 16, 16951, {1, 1, 1, 9, 7, 53, 109, 47, 49, 941, 147, 1139, 891, 11475, 32663, 57267}},
    {4734, 16, 16983, {1, 1, 1, 7, 5, 27, 55, 135, 221, 51, 1971, 2273, 1157, 6689, 7679, 24047}},
    {4735, 16, 16999, {1, 1, 3, 5, 1, 1, 109, 109, 359, 607, 939, 1821, 7915, 3291, 14119, 53007}},
    {4736, 16, 17000, {1, 3, 5, 7, 17, 9, 43, 205, 315, 751, 813, 877, 5687, 11601, 30705, 8523}},
    {4737, 16, 17006, {1, 3, 7, 11, 19, 9, 55, 85, 501, 137, 435, 869, 8145, 3405, 17863, 19235}},
    {4738, 16, 17020, {1, 3, 1, 11, 17, 41, 3, 179, 115, 523, 45, 1429, 679, 14329, 3403, 5305}},
    {4739, 16, 17030, {1, 3, 7, 3, 5, 35, 13, 63, 123, 43, 923, 2673, 831, 13613, 16483, 65473}},
    {4740, 16, 17033, {1, 1, 5, 13, 15, 21, 49, 193, 311, 633, 793, 1087, 3463, 15381, 18719, 6607}},
    {4741, 16, 17044, {1, 1, 5, 1, 17, 23, 115, 235, 335, 515, 873, 1481, 5163, 2247, 1181, 26575}},
    {4742, 16, 17051, {1, 3, 3, 1, 3, 47, 45, 61, 389, 555, 1461, 3481, 4697, 11953, 5499, 58733}},
    {4743, 16, 17072, {1, 1, 3, 5, 27, 13, 41, 223, 407, 951, 665, 3699, 7467, 1633, 11051, 55113}},
    {4744, 16, 17078, {1, 3, 7, 11, 7, 13, 77, 223, 157, 863, 881, 795, 2753, 5253, 30829, 25113}},
    {4745, 16, 17084, {1, 1, 1, 5, 23, 7, 39, 173, 155, 37, 927, 3131, 4879, 13585, 24813, 60507}},
    {4746, 16, 17087, {1, 3, 3, 5, 7, 47, 27, 239, 381, 763, 1159, 1617, 7943, 15379, 9139, 21335}},
    {4747, 16, 17090, {1, 3, 1, 3, 27, 39, 31, 239, 29, 881, 1797, 1685, 1129, 9457, 21905, 38847}},
    {4748, 16, 17123, {1, 3, 7, 11, 9, 55, 51, 133, 239, 879, 243, 495, 2223, 14009, 3321, 46025}},
    {4749, 16, 17132, {1, 3, 5, 11, 1, 9, 79, 197, 311, 57, 673, 843, 645, 1779, 25877, 1529}},
    {4750, 16, 17140, {1, 3, 5, 13, 7, 63, 117, 239, 235, 601, 1983, 2405, 6913, 4465, 5735, 2379}},
    {4751, 16, 17149, {1, 3, 1, 13, 23, 59, 55, 203, 493, 841, 15, 1905, 145, 9979, 31575, 28917}},
    {4752, 16, 17157, {1, 3, 5, 15, 9, 41, 79, 223, 163, 901, 405, 1401, 5783, 165, 31163, 34179}},
    {4753, 16, 17164, {1, 3, 7, 7, 17, 21, 43, 101, 427, 67, 749, 1925, 1547, 1949, 20873, 34539}},
    {4754, 16, 17170, {1, 3, 5, 13, 15, 47, 69, 215, 41, 493, 1775, 2435, 3317, 933, 20287, 28375}},
    {4755, 16, 17179, {1, 3, 5, 3, 1, 15, 59, 125, 199, 175, 943, 1705, 3297, 4517, 19331, 27309}},
    {4756, 16, 17237, {1, 1, 3, 11, 13, 33, 91, 165, 257, 831, 1739, 261, 3647, 1967, 5053, 36015}},
    {4757, 16, 17248, {1, 3, 1, 5, 17, 5, 1, 97, 255, 985, 1859, 289, 7887, 4257, 12027, 61831}},
    {4758, 16, 17260, {1, 1, 3, 15, 19, 61, 31, 249, 445, 519, 1181, 2835, 7443, 3877, 29683, 42319}},
    {4759, 16, 17272, {1, 1, 7, 11, 27, 57, 3, 185, 259, 191, 115, 2099, 635, 11453, 1239, 18389}},
    {4760, 16, 17275, {1, 1, 3, 3, 11, 19, 1, 63, 117, 841, 1375, 7, 5413, 4495, 5927, 32119}},
    {4761, 16, 17287, {1, 1, 5, 11, 3, 23, 45, 211, 229, 243, 1459, 3385, 611, 10413, 15075, 12969}},
    {4762, 16, 17294, {1, 3, 1, 15, 9, 59, 13, 247, 55, 591, 1405, 3927, 7633, 10645, 9611, 51605}},
    {4763, 16, 17296, {1, 1, 3, 7, 7, 25, 101, 75, 161, 183, 861, 3683, 6515, 1823, 28609, 57109}},
    {4764, 16, 17305, {1, 3, 3, 7, 27, 33, 105, 203, 345, 599, 1479, 375, 5003, 12425, 1967, 57145}},
    {4765, 16, 17312, {1, 1, 7, 1, 13, 25, 75, 107, 23, 189, 1409, 3787, 5423, 493, 23899, 9701}},
    {4766, 16, 17321, {1, 1, 3, 7, 31, 61, 15, 25, 275, 873, 429, 2675, 5583, 11575, 11337, 26051}},
    {4767, 16, 17367, {1, 1, 5, 15, 5, 35, 71, 61, 109, 381, 1553, 2627, 1355, 13675, 21013, 43767}},
    {4768, 16, 17368, {1, 3, 3, 15, 11, 25, 65, 251, 95, 85, 559, 2455, 7953, 1989, 20965, 56709}},
    {4769, 16, 17378, {1, 1, 5, 7, 31, 63, 119, 157, 373, 295, 1149, 3027, 2897, 1081, 13815, 57079}},
    {4770, 16, 17433, {1, 1, 3, 1, 3, 45, 127, 21, 249, 661, 1761, 1811, 6187, 7281, 17553, 33845}},
    {4771, 16, 17455, {1, 3, 7, 9, 9, 15, 91, 67, 189, 759, 959, 2733, 4631, 14851, 24831, 17073}},
    {4772, 16, 17457, {1, 3, 7, 15, 31, 57, 25, 143, 279, 139, 1001, 4061, 6329, 13101, 32015, 40529}},
    {4773, 16, 17508, {1, 3, 1, 3, 31, 57, 43, 241, 353, 751, 359, 33, 5873, 12647, 17937, 44619}},
    {4774, 16, 17559, {1, 3, 1, 5, 19, 3, 115, 129, 359, 699, 1121, 955, 785, 6189, 1693, 64349}},
    {4775, 16, 17560, {1, 3, 7, 9, 5, 23, 29, 11, 249, 755, 1039, 2089, 1235, 7891, 23959, 40709}},
    {4776, 16, 17582, {1, 3, 7, 3, 11, 13, 69, 47, 449, 715, 2027, 2751, 4735, 505, 2981, 10717}},
    {4777, 16, 17596, {1, 1, 5, 15, 11, 55, 47, 91, 227, 871, 155, 3307, 2539, 5027, 3843, 63817}},
    {4778, 16, 17599, {1, 1, 5, 9, 25, 49, 19, 105, 263, 379, 55, 987, 425, 15405, 12349, 29247}},
    {4779, 16, 17613, {1, 1, 7, 7, 17, 51, 21, 73, 115, 183, 1187, 3975, 1439, 2871, 3707, 7751}},
    {4780, 16, 17619, {1, 1, 7, 13, 19, 43, 103, 17, 21, 291, 65, 2925, 5329, 15623, 23547, 12627}},
    {4781, 16, 17622, {1, 1, 1, 13, 13, 63, 1, 207, 105, 677, 99, 3407, 6269, 14199, 29347, 58661}},
    {4782, 16, 17655, {1, 1, 1, 9, 31, 59, 5, 105, 487, 769, 2009, 3455, 719, 5435, 14295, 11335}},
    {4783, 16, 17661, {1, 3, 3, 11, 13, 9, 109, 161, 319, 153, 1687, 3973, 3363, 11241, 9405, 27497}},
    {4784, 16, 17698, {1, 3, 3, 1, 21, 21, 123, 205, 307, 139, 1857, 2371, 6747, 5179, 22757, 4829}},
    {4785, 16, 17712, {1, 3, 5, 1, 19, 21, 17, 179, 105, 669, 867, 1685, 5113, 9175, 15067, 43753}},
    {4786, 16, 17715, {1, 1, 5, 3, 15, 25, 29, 37, 79, 337, 839, 3953, 3181, 7003, 21643, 49107}},
    {4787, 16, 17721, {1, 1, 3, 3, 15, 29, 57, 237, 33, 7, 381, 2501, 5199, 4093, 20965, 41213}},
    {4788, 16, 17722, {1, 1, 7, 11, 9, 29, 49, 87, 97, 311, 569, 1547, 289, 9551, 5787, 12115}},
    {4789, 16, 17742, {1, 1, 1, 7, 1, 51, 69, 7, 113, 307, 1007, 2663, 4687, 5063, 19205, 63193}},
    {4790, 16, 17778, {1, 3, 5, 9, 19, 59, 3, 221, 255, 141, 1003, 1897, 7553, 1501, 14613, 62241}},
    {4791, 16, 17818, {1, 3, 1, 5, 25, 53, 117, 5, 153, 533, 1885, 2625, 719, 12281, 25525, 24927}},
    {4792, 16, 17836, {1, 3, 5, 11, 31, 31, 3, 91, 501, 431, 55, 2085, 7645, 13753, 26381, 28181}},
    {4793, 16, 17841, {1, 3, 7, 11, 5, 59, 37, 177, 81, 283, 1159, 1423, 517, 4195, 4413, 45659}},
    {4794, 16, 17856, {1, 1, 7, 3, 21, 35, 127, 161, 439, 305, 1483, 3357, 887, 10647, 19117, 60765}},
    {4795, 16, 17883, {1, 3, 3, 3, 15, 51, 49, 207, 53, 443, 807, 3123, 7505, 9673, 2875, 33}},
    {4796, 16, 17896, {1, 1, 5, 9, 1, 45, 67, 17, 445, 519, 799, 687, 615, 4289, 5879, 10183}},
    {4797, 16, 17901, {1, 3, 1, 1, 25, 13, 89, 243, 405, 929, 25, 1479, 5363, 4561, 27413, 9401}},
    {4798, 16, 17926, {1, 1, 7, 5, 29, 53, 57, 57, 315, 83, 137, 417, 245, 621, 13907, 20207}},
    {4799, 16, 17937, {1, 1, 7, 15, 1, 61, 11, 89, 441, 367, 59, 3801, 241, 8963, 15081, 37291}},
    {4800, 16, 17992, {1, 1, 7, 3, 15, 61, 111, 107, 417, 277, 691, 3125, 1675, 12611, 29919, 17011}},
    {4801, 16, 17995, {1, 3, 3, 1, 25, 19, 23, 211, 299, 759, 833, 2655, 7945, 15529, 25937, 13179}},
    {4802, 16, 17998, {1, 1, 5, 1, 27, 17, 101, 3, 59, 803, 1741, 2295, 705, 8289, 29353, 9363}},
    {4803, 16, 18021, {1, 3, 3, 13, 7, 29, 23, 159, 161, 649, 1695, 553, 5329, 10445, 769, 24649}},
    {4804, 16, 18039, {1, 3, 7, 5, 3, 43, 51, 19, 35, 11, 1317, 2171, 2591, 4763, 2739, 54397}},
    {4805, 16, 18067, {1, 1, 3, 3, 17, 19, 61, 49, 3, 881, 305, 2753, 779, 5257, 25051, 17563}},
    {4806, 16, 18122, {1, 1, 5, 3, 17, 19, 11, 229, 195, 719, 1669, 775, 5065, 3723, 21397, 29613}},
    {4807, 16, 18129, {1, 3, 7, 3, 15, 9, 73, 199, 333, 155, 1189, 1191, 7905, 12917, 21057, 41753}},
    {4808, 16, 18130, {1, 1, 5, 13, 1, 35, 23, 121, 433, 601, 713, 367, 7033, 10339, 11813, 7503}},
    {4809, 16, 18142, {1, 3, 1, 13, 27, 33, 103, 45, 201, 99, 1667, 3793, 3357, 15539, 23979, 11049}},
    {4810, 16, 18148, {1, 3, 1, 1, 17, 63, 91, 39, 473, 555, 921, 2827, 6721, 7423, 14981, 55855}},
    {4811, 16, 18163, {1, 1, 1, 5, 25, 43, 3, 61, 337, 619, 651, 3899, 6659, 453, 30149, 22929}},
    {4812, 16, 18192, {1, 3, 5, 7, 27, 55, 65, 203, 145, 169, 383, 2029, 6093, 11141, 7003, 6499}},
    {4813, 16, 18211, {1, 1, 7, 15, 31, 7, 61, 115, 391, 891, 621, 601, 2635, 11203, 27619, 13073}},
    {4814, 16, 18228, {1, 1, 3, 3, 29, 3, 117, 61, 35, 783, 1853, 3967, 7141, 14815, 2827, 19963}},
    {4815, 16, 18264, {1, 3, 5, 1, 27, 21, 1, 181, 37, 517, 1331, 3783, 8023, 3891, 35, 26231}},
    {4816, 16, 18347, {1, 3, 5, 3, 23, 55, 91, 229, 363, 725, 995, 1665, 5723, 15013, 7811, 22435}},
    {4817, 16, 18372, {1, 1, 1, 13, 1, 27, 9, 5, 333, 35, 401, 1257, 6551, 13933, 21089, 1825}},
    {4818, 16, 18409, {1, 1, 3, 1, 21, 25, 113, 25, 203, 329, 1401, 2871, 2923, 16305, 13979, 63047}},
    {4819, 16, 18412, {1, 1, 5, 7, 27, 29, 9, 97, 1, 559, 1307, 2463, 1773, 4611, 19925, 11257}},
    {4820, 16, 18418, {1, 1, 1, 13, 9, 31, 107, 143, 75, 61, 1785, 3363, 5959, 4595, 28817, 45131}},
    {4821, 16, 18423, {1, 3, 3, 13, 15, 27, 127, 161, 477, 799, 121, 1255, 667, 4829, 26933, 62071}},
    {4822, 16, 18433, {1, 1, 3, 7, 27, 17, 101, 145, 51, 811, 65, 4041, 3411, 3343, 20353, 24307}},
    {4823, 16, 18439, {1, 3, 7, 1, 29, 55, 41, 251, 443, 345, 1349, 3465, 5723, 15533, 23889, 24359}},
    {4824, 16, 18445, {1, 3, 5, 15, 25, 19, 125, 245, 297, 603, 1727, 1315, 1125, 3885, 3529, 18037}},
    {4825, 16, 18451, {1, 1, 5, 1, 23, 55, 97, 69, 349, 395, 953, 125, 6373, 15427, 26339, 48751}},
    {4826, 16, 18467, {1, 1, 1, 9, 11, 27, 99, 99, 257, 719, 1263, 1415, 2411, 5291, 21625, 48855}},
    {4827, 16, 18502, {1, 1, 3, 9, 25, 45, 93, 157, 447, 309, 1929, 175, 3479, 15181, 6189, 17219}},
    {4828, 16, 18514, {1, 1, 7, 9, 19, 33, 19, 35, 151, 543, 1593, 1053, 2587, 13325, 10191, 62257}},
    {4829, 16, 18547, {1, 3, 5, 15, 25, 37, 109, 43, 267, 947, 187, 2609, 1107, 14521, 19961, 16657}},
    {4830, 16, 18575, {1, 1, 1, 9, 1, 57, 83, 145, 155, 105, 1437, 3441, 2557, 3573, 4833, 60051}},
    {4831, 16, 18593, {1, 3, 5, 15, 3, 35, 55, 61, 113, 941, 1463, 1121, 6071, 9295, 24667, 17165}},
    {4832, 16, 18613, {1, 1, 1, 13, 17, 13, 59, 17, 461, 617, 935, 2653, 6287, 5329, 30793, 64599}},
    {4833, 16, 18620, {1, 3, 5, 11, 17, 43, 55, 21, 87, 33, 977, 1763, 4877, 8057, 4625, 38823}},
    {4834, 16, 18637, {1, 3, 5, 9, 11, 59, 63, 59, 171, 37, 457, 2577, 6955, 3113, 7685, 3057}},
    {4835, 16, 18640, {1, 3, 7, 7, 3, 27, 27, 5, 483, 503, 1165, 3429, 879, 10849, 30147, 53885}},
    {4836, 16, 18712, {1, 1, 5, 11, 23, 27, 127, 233, 351, 979, 1627, 3109, 5665, 3675, 10111, 26483}},
    {4837, 16, 18728, {1, 3, 1, 13, 7, 15, 101, 55, 463, 157, 1119, 1553, 5653, 9037, 29069, 59709}},
    {4838, 16, 18742, {1, 3, 5, 15, 13, 17, 11, 87, 287, 123, 337, 369, 6761, 1513, 31605, 38955}},
    {4839, 16, 18748, {1, 1, 3, 3, 31, 5, 29, 175, 173, 217, 509, 2059, 4759, 14355, 883, 17049}},
    {4840, 16, 18753, {1, 1, 1, 9, 21, 45, 77, 253, 13, 169, 133, 777, 5253, 11943, 12325, 37503}},
    {4841, 16, 18756, {1, 1, 1, 15, 3, 29, 89, 133, 79, 813, 1949, 3521, 5143, 1721, 1713, 16937}},
    {4842, 16, 18771, {1, 3, 5, 1, 9, 19, 11, 129, 143, 447, 1415, 1821, 2339, 1443, 31389, 49907}},
    {4843, 16, 18814, {1, 3, 3, 1, 5, 57, 63, 215, 69, 617, 1831, 2387, 2607, 6909, 23391, 15805}},
    {4844, 16, 18818, {1, 1, 3, 13, 15, 19, 21, 71, 177, 107, 1889, 2799, 1249, 12965, 1033, 10101}},
    {4845, 16, 18827, {1, 3, 7, 11, 13, 23, 21, 151, 417, 1005, 1725, 177, 1597, 13949, 31793, 48553}},
    {4846, 16, 18835, {1, 1, 7, 13, 15, 41, 3, 193, 503, 623, 451, 3279, 1601, 6229, 15165, 11793}},
    {4847, 16, 18842, {1, 3, 1, 13, 25, 25, 109, 65, 399, 91, 915, 1083, 6067, 5771, 23757, 52313}},
    {4848, 16, 18854, {1, 3, 3, 15, 3, 47, 29, 113, 15, 441, 1793, 3819, 1129, 5595, 8117, 32663}},
    {4849, 16, 18858, {1, 3, 5, 3, 9, 13, 105, 75, 359, 19, 7, 1813, 789, 6557, 25735, 48733}},
    {4850, 16, 18895, {1, 3, 7, 9, 29, 61, 55, 171, 457, 315, 471, 1753, 761, 15547, 3357, 62847}},
    {4851, 16, 18914, {1, 1, 5, 7, 1, 21, 59, 75, 357, 97, 557, 2567, 2559, 15779, 25625, 5675}},
    {4852, 16, 18925, {1, 3, 1, 11, 9, 1, 13, 137, 411, 715, 487, 641, 8017, 5625, 11857, 16797}},
    {4853, 16, 18933, {1, 1, 5, 11, 3, 5, 69, 229, 79, 493, 447, 2099, 6575, 16337, 19349, 56831}},
    {4854, 16, 18937, {1, 3, 1, 9, 19, 63, 29, 153, 213, 93, 1695, 995, 1603, 1673, 27729, 5965}},
    {4855, 16, 18944, {1, 3, 7, 13, 31, 63, 41, 227, 307, 737, 1069, 1501, 657, 1589, 26595, 41053}},
    {4856, 16, 18973, {1, 1, 3, 15, 3, 5, 79, 135, 129, 575, 1825, 1011, 5783, 12195, 1083, 25821}},
    {4857, 16, 19001, {1, 1, 5, 1, 27, 15, 59, 87, 313, 849, 1271, 565, 7863, 6273, 2555, 61147}},
    {4858, 16, 19012, {1, 1, 5, 3, 1, 9, 31, 165, 151, 651, 1263, 9, 5979, 5861, 13137, 63577}},
    {4859, 16, 19016, {1, 3, 3, 7, 5, 53, 33, 139, 87, 3, 1205, 3117, 6533, 14809, 9305, 9075}},
    {4860, 16, 19027, {1, 1, 3, 5, 29, 45, 23, 171, 157, 731, 1837, 979, 6525, 2157, 2541, 5807}},
    {4861, 16, 19040, {1, 3, 3, 7, 25, 27, 87, 67, 441, 217, 1965, 647, 933, 2115, 25877, 19753}},
    {4862, 16, 19074, {1, 3, 5, 9, 1, 51, 47, 31, 267, 371, 871, 3095, 4159, 11121, 26387, 42165}},
    {4863, 16, 19085, {1, 1, 7, 15, 13, 41, 113, 127, 195, 291, 1569, 489, 5959, 16383, 29997, 5899}},
    {4864, 16, 19093, {1, 1, 7, 11, 31, 53, 75, 217, 85, 99, 1529, 2931, 4259, 4315, 25669, 46707}},
    {4865, 16, 19100, {1, 1, 1, 13, 17, 31, 35, 97, 187, 717, 281, 1735, 6777, 6595, 7677, 54207}},
    {4866, 16, 19107, {1, 1, 5, 1, 29, 7, 127, 37, 57, 289, 41, 1857, 1281, 12317, 265, 57997}},
    {4867, 16, 19128, {1, 1, 1, 5, 5, 59, 123, 245, 479, 257, 1501, 695, 3839, 13341, 20813, 13929}},
    {4868, 16, 19141, {1, 1, 3, 9, 19, 37, 107, 227, 275, 855, 1923, 2603, 2503, 13267, 3635, 13203}},
    {4869, 16, 19142, {1, 3, 5, 5, 23, 19, 91, 27, 285, 667, 1535, 1433, 1545, 11731, 8269, 12681}},
    {4870, 16, 19156, {1, 3, 1, 13, 11, 49, 7, 119, 217, 875, 1901, 495, 3017, 463, 23717, 64051}},
    {4871, 16, 19169, {1, 3, 3, 7, 13, 15, 107, 127, 213, 935, 859, 2257, 1363, 6269, 30521, 14123}},
    {4872, 16, 19176, {1, 3, 1, 15, 17, 59, 81, 35, 1, 615, 557, 1385, 1975, 13361, 25617, 63063}},
    {4873, 16, 19222, {1, 1, 1, 11, 3, 15, 113, 197, 293, 873, 299, 1871, 825, 7825, 16197, 35907}},
    {4874, 16, 19226, {1, 3, 5, 9, 5, 35, 77, 93, 319, 651, 883, 2863, 5191, 14227, 14721, 31483}},
    {4875, 16, 19247, {1, 1, 3, 15, 27, 27, 25, 229, 459, 253, 171, 2889, 7123, 5243, 24761, 54411}},
    {4876, 16, 19259, {1, 1, 7, 11, 7, 7, 17, 159, 399, 61, 95, 35, 143, 9429, 13121, 23357}},
    {4877, 16, 19262, {1, 3, 1, 1, 9, 3, 113, 191, 361, 351, 1633, 617, 3549, 15091, 29049, 14957}},
    {4878, 16, 19291, {1, 3, 7, 9, 29, 25, 83, 203, 211, 593, 213, 3421, 3631, 11705, 13599, 11207}},
    {4879, 16, 19309, {1, 3, 1, 7, 23, 41, 75, 125, 285, 343, 35, 959, 5875, 14781, 16527, 63087}},
    {4880, 16, 19324, {1, 1, 5, 1, 19, 19, 75, 93, 27, 389, 1915, 2815, 4753, 14797, 28473, 2043}},
    {4881, 16, 19334, {1, 1, 1, 11, 17, 27, 83, 131, 483, 283, 703, 3115, 3535, 8545, 29313, 52427}},
    {4882, 16, 19338, {1, 3, 1, 11, 27, 45, 95, 11, 141, 703, 1379, 3485, 2377, 4945, 22463, 9535}},
    {4883, 16, 19343, {1, 1, 3, 15, 11, 11, 71, 49, 479, 981, 773, 2033, 1085, 3291, 12295, 32667}},
    {4884, 16, 19376, {1, 1, 3, 15, 3, 41, 89, 165, 1, 935, 1859, 2881, 4351, 6737, 12361, 27821}},
    {4885, 16, 19408, {1, 3, 7, 13, 23, 63, 53, 215, 97, 563, 1965, 2015, 1813, 9173, 13837, 37135}},
    {4886, 16, 19413, {1, 3, 7, 5, 3, 15, 3, 89, 441, 575, 239, 1509, 901, 15395, 6445, 57909}},
    {4887, 16, 19420, {1, 3, 5, 5, 31, 1, 77, 55, 113, 83, 615, 2067, 6217, 10357, 4001, 47587}},
    {4888, 16, 19441, {1, 3, 1, 7, 29, 53, 39, 39, 21, 381, 211, 253, 4751, 11733, 10167, 34251}},
    {4889, 16, 19444, {1, 3, 5, 7, 25, 29, 41, 185, 337, 899, 945, 2139, 4321, 8945, 1949, 49715}},
    {4890, 16, 19454, {1, 1, 7, 5, 1, 53, 109, 217, 351, 661, 357, 1781, 7669, 9311, 8161, 5345}},
    {4891, 16, 19461, {1, 1, 3, 15, 11, 35, 101, 73, 25, 15, 1605, 877, 2639, 261, 28463, 24915}},
    {4892, 16, 19473, {1, 3, 1, 15, 31, 53, 29, 13, 363, 79, 1427, 1867, 7371, 2081, 12251, 12193}},
    {4893, 16, 19479, {1, 1, 1, 5, 11, 63, 53, 95, 171, 335, 1413, 1957, 5339, 1307, 30869, 45231}},
    {4894, 16, 19489, {1, 1, 3, 7, 23, 63, 15, 195, 165, 527, 1081, 1227, 1617, 14681, 14633, 33305}},
    {4895, 16, 19591, {1, 3, 3, 1, 17, 11, 7, 117, 255, 7, 751, 411, 1661, 7605, 28017, 62795}},
    {4896, 16, 19605, {1, 1, 1, 3, 15, 11, 57, 161, 165, 65, 821, 3609, 5117, 6291, 925, 63923}},
    {4897, 16, 19616, {1, 3, 3, 5, 7, 47, 57, 119, 337, 115, 415, 4021, 5845, 2805, 7095, 29831}},
    {4898, 16, 19619, {1, 3, 7, 5, 9, 15, 107, 213, 371, 257, 1711, 2357, 7659, 9149, 21457, 64987}},
    {4899, 16, 19653, {1, 1, 5, 1, 19, 53, 21, 107, 73, 655, 263, 3623, 3661, 6091, 7707, 62727}},
    {4900, 16, 19654, {1, 3, 7, 9, 27, 29, 83, 211, 309, 837, 1923, 223, 3661, 4033, 17213, 5159}},
    {4901, 16, 19681, {1, 1, 5, 3, 7, 59, 83, 33, 437, 119, 765, 383, 5515, 15383, 27729, 51009}},
    {4902, 16, 19711, {1, 3, 3, 1, 21, 31, 7, 109, 109, 575, 281, 2781, 6729, 8335, 4427, 5861}},
    {4903, 16, 19719, {1, 3, 5, 11, 11, 37, 91, 55, 441, 117, 325, 965, 95, 4677, 23647, 50413}},
    {4904, 16, 19726, {1, 1, 3, 11, 31, 43, 33, 227, 497, 241, 1551, 2715, 6509, 9035, 31583, 39501}},
    {4905, 16, 19738, {1, 3, 5, 15, 17, 3, 83, 43, 165, 943, 1127, 1973, 319, 15353, 2303, 65267}},
    {4906, 16, 19767, {1, 3, 3, 9, 13, 37, 19, 249, 117, 765, 1267, 3815, 3671, 9495, 327, 45907}},
    {4907, 16, 19819, {1, 1, 7, 13, 23, 35, 33, 101, 213, 359, 531, 1813, 2875, 12345, 4067, 44599}},
    {4908, 16, 19864, {1, 3, 7, 1, 11, 21, 51, 53, 223, 131, 1939, 2035, 7605, 5163, 32593, 21155}},
    {4909, 16, 19867, {1, 1, 3, 1, 29, 47, 35, 29, 421, 297, 321, 2873, 6965, 15787, 3311, 41749}},
    {4910, 16, 19885, {1, 1, 1, 15, 23, 35, 13, 89, 69, 839, 1781, 2199, 7147, 7095, 28761, 34819}},
    {4911, 16, 19894, {1, 3, 7, 1, 15, 13, 103, 245, 163, 609, 1635, 1245, 1259, 2233, 6079, 36823}},
    {4912, 16, 19900, {1, 3, 1, 11, 17, 53, 37, 229, 61, 743, 963, 1833, 7691, 11873, 4765, 29603}},
    {4913, 16, 19903, {1, 3, 1, 15, 31, 57, 57, 121, 291, 511, 845, 1363, 5129, 2511, 3643, 52821}},
    {4914, 16, 19941, {1, 1, 3, 3, 27, 3, 61, 227, 377, 999, 339, 3283, 3385, 5055, 15581, 25837}},
    {4915, 16, 19951, {1, 3, 3, 7, 3, 7, 61, 129, 209, 575, 1151, 517, 595, 5193, 14285, 989}},
    {4916, 16, 19959, {1, 3, 1, 1, 9, 7, 113, 79, 507, 795, 1469, 3173, 6599, 9593, 21899, 36121}},
    {4917, 16, 19966, {1, 1, 3, 1, 3, 21, 93, 211, 479, 229, 1709, 1761, 2585, 7347, 59, 50831}},
    {4918, 16, 20009, {1, 3, 7, 7, 7, 53, 113, 13, 417, 1009, 289, 2629, 5695, 9519, 19747, 30917}},
    {4919, 16, 20018, {1, 1, 5, 7, 23, 7, 21, 105, 207, 583, 803, 2083, 4921, 13259, 13589, 11237}},
    {4920, 16, 20020, {1, 3, 1, 3, 23, 45, 87, 121, 311, 191, 1553, 3703, 1575, 4999, 9363, 18915}},
    {4921, 16, 20038, {1, 3, 7, 15, 27, 53, 87, 149, 505, 425, 721, 417, 2009, 10629, 23193, 13251}},
    {4922, 16, 20049, {1, 3, 5, 15, 31, 7, 41, 1, 407, 405, 321, 3893, 4579, 10269, 22267, 63297}},
    {4923, 16, 20066, {1, 3, 7, 13, 9, 51, 105, 177, 149, 637, 321, 917, 5765, 7771, 14417, 14997}},
    {4924, 16, 20108, {1, 1, 1, 1, 11, 17, 113, 193, 191, 11, 597, 1823, 4705, 8701, 14229, 30591}},
    {4925, 16, 20130, {1, 1, 3, 15, 5, 35, 105, 27, 483, 417, 1131, 1443, 2761, 11973, 22261, 51529}},
    {4926, 16, 20132, {1, 3, 7, 11, 3, 1, 105, 87, 169, 79, 1811, 3731, 7773, 1015, 6169, 3661}},
    {4927, 16, 20167, {1, 1, 7, 15, 5, 63, 125, 199, 433, 997, 1117, 2517, 5005, 9167, 14553, 40991}},
    {4928, 16, 20219, {1, 1, 3, 5, 31, 39, 81, 227, 49, 121, 1341, 2899, 135, 6523, 17067, 26343}},
    {4929, 16, 20227, {1, 3, 5, 13, 13, 9, 37, 241, 171, 711, 25, 3437, 255, 10141, 19567, 38951}},
    {4930, 16, 20263, {1, 3, 5, 5, 19, 41, 117, 183, 463, 529, 313, 3339, 8097, 9989, 28421, 14735}},
    {4931, 16, 20267, {1, 1, 3, 1, 9, 51, 123, 11, 243, 929, 1073, 1431, 6903, 11473, 17169, 1115}},
    {4932, 16, 20272, {1, 3, 1, 1, 21, 29, 3, 145, 419, 335, 783, 3097, 2003, 2017, 22859, 62735}},
    {4933, 16, 20289, {1, 3, 5, 7, 11, 61, 119, 51, 229, 791, 137, 3827, 4613, 5253, 9007, 10927}},
    {4934, 16, 20296, {1, 3, 3, 15, 17, 13, 125, 245, 77, 481, 443, 3111, 1769, 447, 14629, 32717}},
    {4935, 16, 20307, {1, 1, 5, 5, 15, 59, 127, 123, 201, 199, 393, 1935, 5921, 9045, 27009, 29147}},
    {4936, 16, 20316, {1, 3, 3, 11, 11, 13, 47, 243, 47, 111, 1459, 2305, 7507, 11467, 7353, 49547}},
    {4937, 16, 20323, {1, 1, 7, 9, 23, 35, 127, 139, 309, 769, 963, 3793, 3521, 6541, 9787, 19795}},
    {4938, 16, 20335, {1, 3, 3, 7, 23, 35, 1, 85, 225, 155, 1811, 3613, 2503, 15633, 11907, 41991}},
    {4939, 16, 20344, {1, 3, 1, 15, 19, 45, 113, 51, 459, 739, 1885, 2959, 159, 9809, 31075, 15023}},
    {4940, 16, 20354, {1, 3, 7, 11, 27, 1, 29, 183, 53, 841, 1757, 3055, 7539, 15921, 23195, 21953}},
    {4941, 16, 20360, {1, 1, 7, 1, 25, 17, 57, 9, 339, 211, 651, 4091, 8003, 9001, 16193, 4537}},
    {4942, 16, 20368, {1, 1, 5, 9, 25, 19, 89, 143, 141, 379, 183, 115, 1847, 2019, 24879, 35531}},
    {4943, 16, 20390, {1, 3, 1, 7, 15, 35, 13, 199, 1, 101, 1927, 4021, 4779, 5559, 29167, 3017}},
    {4944, 16, 20402, {1, 1, 1, 9, 21, 51, 39, 119, 131, 473, 1403, 223, 2611, 475, 3837, 26205}},
    {4945, 16, 20413, {1, 3, 5, 13, 17, 9, 117, 83, 349, 885, 297, 3829, 7003, 4845, 24113, 32553}},
    {4946, 16, 20425, {1, 1, 7, 15, 5, 19, 5, 133, 497, 131, 177, 951, 109, 3751, 2493, 14281}},
    {4947, 16, 20428, {1, 1, 5, 1, 29, 59, 103, 179, 461, 97, 667, 1799, 5097, 1481, 8351, 45155}},
    {4948, 16, 20434, {1, 1, 3, 11, 27, 33, 75, 167, 273, 133, 281, 3099, 6755, 4315, 28941, 62029}},
    {4949, 16, 20443, {1, 3, 5, 7, 11, 21, 83, 213, 33, 211, 1479, 3209, 6947, 4187, 28431, 36005}},
    {4950, 16, 20488, {1, 3, 1, 5, 21, 37, 97, 99, 391, 37, 571, 113, 5263, 2243, 27473, 50481}},
    {4951, 16, 20502, {1, 3, 7, 1, 31, 53, 119, 155, 127, 1015, 1209, 2329, 5507, 45, 3035, 46239}},
    {4952, 16, 20505, {1, 1, 5, 13, 15, 57, 45, 189, 441, 37, 2031, 833, 7015, 851, 16311, 56613}},
    {4953, 16, 20535, {1, 1, 3, 15, 23, 51, 119, 171, 451, 239, 965, 2789, 2055, 5921, 9979, 50341}},
    {4954, 16, 20541, {1, 1, 7, 13, 17, 41, 107, 63, 117, 503, 281, 2629, 5299, 2983, 6609, 5365}},
    {4955, 16, 20554, {1, 3, 1, 1, 13, 9, 11, 247, 487, 729, 75, 2079, 8141, 1965, 32209, 63151}},
    {4956, 16, 20577, {1, 1, 3, 7, 23, 31, 59, 99, 459, 213, 1933, 3505, 1571, 7171, 1691, 31093}},
    {4957, 16, 20583, {1, 3, 7, 15, 25, 45, 21, 81, 339, 341, 917, 4069, 4287, 3253, 25989, 63251}},
    {4958, 16, 20602, {1, 3, 3, 1, 25, 59, 55, 19, 439, 149, 779, 1323, 3283, 7191, 20675, 4363}},
    {4959, 16, 20611, {1, 3, 1, 11, 9, 15, 55, 97, 459, 21, 195, 3895, 3991, 14625, 30519, 32321}},
    {4960, 16, 20614, {1, 1, 7, 15, 25, 45, 19, 105, 139, 943, 307, 3773, 2521, 14285, 6677, 65343}},
    {4961, 16, 20626, {1, 3, 1, 3, 21, 21, 99, 3, 9, 365, 805, 591, 5003, 77, 29979, 26525}},
    {4962, 16, 20628, {1, 1, 7, 15, 27, 23, 79, 197, 141, 267, 1167, 2645, 3519, 2199, 12101, 59641}},
    {4963, 16, 20635, {1, 1, 5, 11, 5, 55, 23, 71, 19, 723, 361, 2653, 6903, 4203, 17491, 5237}},
    {4964, 16, 20642, {1, 3, 5, 11, 27, 39, 119, 113, 275, 741, 433, 2461, 2087, 9369, 28993, 60029}},
    {4965, 16, 20674, {1, 1, 5, 7, 5, 17, 103, 107, 225, 845, 1127, 61, 7307, 7533, 27615, 62829}},
    {4966, 16, 20716, {1, 3, 5, 7, 15, 55, 93, 87, 487, 33, 1355, 1247, 1365, 11329, 8685, 56395}},
    {4967, 16, 20734, {1, 3, 7, 7, 5, 45, 121, 193, 457, 469, 1407, 1569, 7387, 16299, 11945, 29133}},
    {4968, 16, 20765, {1, 1, 5, 3, 15, 37, 71, 151, 313, 209, 1527, 2361, 979, 7685, 2333, 48511}},
    {4969, 16, 20801, {1, 3, 3, 9, 7, 15, 59, 151, 383, 515, 1001, 923, 4517, 8191, 31915, 31645}},
    {4970, 16, 20804, {1, 3, 1, 15, 27, 61, 123, 23, 15, 91, 1425, 959, 5821, 35, 12275, 9141}},
    {4971, 16, 20808, {1, 1, 5, 13, 17, 39, 79, 51, 217, 245, 875, 3455, 7387, 11463, 30583, 53563}},
    {4972, 16, 20831, {1, 1, 1, 1, 29, 29, 113, 115, 25, 569, 1719, 2977, 7379, 10669, 23951, 49533}},
    {4973, 16, 20832, {1, 3, 1, 9, 15, 61, 45, 203, 325, 631, 303, 2061, 7981, 12115, 25193, 28135}},
    {4974, 16, 20862, {1, 1, 5, 1, 11, 7, 119, 117, 423, 405, 1625, 247, 3639, 7527, 5381, 63979}},
    {4975, 16, 20877, {1, 1, 3, 11, 9, 57, 81, 219, 325, 913, 925, 2247, 889, 2127, 7075, 52875}},
    {4976, 16, 20880, {1, 3, 1, 3, 27, 13, 51, 65, 423, 691, 1771, 343, 5669, 10797, 28911, 59969}},
    {4977, 16, 20885, {1, 1, 1, 11, 1, 19, 57, 49, 137, 861, 1207, 2565, 3573, 447, 22927, 3185}},
    {4978, 16, 20889, {1, 1, 5, 3, 3, 1, 101, 115, 241, 985, 1759, 2513, 6787, 12917, 649, 19103}},
    {4979, 16, 20905, {1, 3, 3, 5, 27, 57, 25, 105, 367, 123, 1607, 3887, 5591, 10977, 22177, 4723}},
    {4980, 16, 20914, {1, 1, 5, 3, 27, 49, 5, 93, 77, 625, 213, 1221, 7553, 13325, 17395, 22909}},
    {4981, 16, 20967, {1, 3, 5, 5, 29, 55, 83, 85, 389, 193, 753, 2301, 1917, 397, 11297, 50107}},
    {4982, 16, 21028, {1, 1, 1, 1, 9, 33, 85, 171, 201, 959, 1685, 3689, 5561, 9073, 27231, 1719}},
    {4983, 16, 21031, {1, 3, 7, 13, 25, 29, 61, 149, 229, 275, 1499, 2331, 61, 1193, 7461, 32809}},
    {4984, 16, 21043, {1, 1, 5, 7, 21, 1, 35, 241, 141, 109, 203, 357, 3703, 487, 6019, 9289}},
    {4985, 16, 21052, {1, 1, 7, 3, 5, 23, 31, 143, 153, 211, 1979, 3989, 5599, 12813, 12357, 7801}},
    {4986, 16, 21058, {1, 3, 5, 11, 23, 57, 39, 101, 243, 83, 791, 1293, 3221, 11857, 13959, 24495}},
    {4987, 16, 21087, {1, 1, 7, 9, 1, 13, 115, 141, 195, 49, 897, 2549, 607, 14657, 22215, 54573}},
    {4988, 16, 21088, {1, 3, 7, 7, 29, 41, 109, 157, 311, 477, 1927, 1971, 1655, 1977, 4905, 29999}},
    {4989, 16, 21093, {1, 3, 5, 1, 15, 61, 115, 127, 51, 575, 1553, 3501, 5815, 15421, 6101, 28551}},
    {4990, 16, 21106, {1, 1, 5, 15, 25, 21, 41, 213, 25, 401, 1109, 3679, 6379, 9843, 19883, 61217}},
    {4991, 16, 21108, {1, 1, 3, 13, 31, 55, 1, 13, 289, 297, 893, 1917, 1267, 4657, 30763, 39967}},
    {4992, 16, 21118, {1, 3, 5, 3, 3, 45, 105, 85, 49, 277, 1373, 3531, 6587, 1859, 4095, 10229}},
    {4993, 16, 21122, {1, 3, 7, 3, 1, 11, 125, 179, 445, 983, 1985, 2751, 2153, 7493, 13945, 45793}},
    {4994, 16, 21131, {1, 3, 3, 7, 23, 39, 69, 173, 385, 909, 1911, 73, 4117, 12661, 8231, 38737}},
    {4995, 16, 21139, {1, 1, 7, 11, 21, 27, 35, 73, 77, 823, 415, 1091, 7231, 2275, 16819, 35735}},
    {4996, 16, 21141, {1, 3, 1, 7, 27, 19, 45, 29, 65, 553, 1921, 1539, 6191, 3257, 11949, 46283}},
    {4997, 16, 21146, {1, 1, 1, 5, 27, 61, 57, 37, 93, 245, 1901, 1711, 4365, 9281, 21679, 57535}},
    {4998, 16, 21162, {1, 3, 3, 5, 21, 47, 61, 181, 309, 683, 421, 751, 1967, 15373, 19857, 52621}},
    {4999, 16, 21164, {1, 1, 1, 5, 15, 53, 67, 251, 187, 797, 1479, 3761, 3711, 5613, 16675, 8621}},
    {5000, 16, 21184, {1, 3, 7, 9, 27, 5, 49, 253, 223, 765, 531, 3437, 7217, 10031, 24929, 3955}},
    {5001, 16, 21208, {1, 3, 1, 9, 23, 25, 7, 55, 219, 497, 1793, 1159, 7415, 4537, 9329, 56045}},
    {5002, 16, 21211, {1, 3, 7, 11, 9, 49, 49, 219, 259, 87, 933, 439, 3415, 7163, 15311, 3377}},
    {5003, 16, 21213, {1, 3, 7, 11, 23, 37, 37, 205, 41, 401, 485, 1515, 2345, 2301, 8445, 8375}},
    {5004, 16, 21230, {1, 3, 5, 11, 29, 27, 87, 35, 45, 981, 997, 3515, 4285, 12831, 30169, 49049}},
    {5005, 16, 21270, {1, 1, 3, 7, 5, 43, 91, 249, 391, 201, 1177, 401, 2307, 11121, 25767, 63609}},
    {5006, 16, 21276, {1, 1, 1, 1, 29, 13, 99, 101, 425, 151, 581, 3483, 5223, 6323, 22355, 21855}},
    {5007, 16, 21285, {1, 1, 7, 7, 29, 5, 75, 119, 295, 823, 707, 385, 2165, 2013, 15571, 57889}},
    {5008, 16, 21297, {1, 3, 7, 9, 11, 57, 47, 9, 101, 851, 819, 735, 1465, 6479, 27707, 9519}},
    {5009, 16, 21304, {1, 3, 7, 15, 23, 17, 9, 221, 107, 315, 1525, 2565, 1703, 863, 13139, 35963}},
    {5010, 16, 21310, {1, 1, 1, 3, 19, 63, 17, 243, 411, 707, 1191, 1923, 2855, 9263, 25105, 42487}},
    {5011, 16, 21330, {1, 3, 5, 1, 25, 11, 113, 35, 511, 603, 1917, 3971, 1533, 9241, 11881, 18067}},
    {5012, 16, 21339, {1, 3, 3, 3, 29, 21, 49, 109, 13, 175, 81, 3883, 3567, 2549, 25957, 4021}},
    {5013, 16, 21346, {1, 3, 3, 15, 5, 15, 57, 251, 357, 205, 1113, 4003, 6979, 3871, 14063, 7155}},
    {5014, 16, 21391, {1, 3, 1, 11, 1, 37, 45, 77, 403, 677, 729, 2583, 1165, 8737, 1019, 65003}},
    {5015, 16, 21427, {1, 1, 3, 5, 7, 59, 63, 117, 273, 987, 1449, 2847, 7275, 9201, 15569, 17123}},
    {5016, 16, 21451, {1, 1, 5, 13, 5, 21, 119, 11, 141, 227, 723, 2325, 1503, 10951, 13887, 42003}},
    {5017, 16, 21465, {1, 1, 7, 1, 21, 11, 1, 81, 205, 1009, 1873, 2779, 1037, 8449, 14501, 26059}},
    {5018, 16, 21468, {1, 1, 3, 15, 1, 39, 55, 49, 7, 991, 1353, 2867, 3639, 5443, 3781, 54001}},
    {5019, 16, 21471, {1, 1, 5, 13, 5, 35, 117, 125, 511, 669, 497, 1661, 6241, 7835, 12033, 60969}},
    {5020, 16, 21533, {1, 1, 7, 11, 25, 27, 77, 201, 129, 739, 1843, 987, 3363, 7453, 26165, 26917}},
    {5021, 16, 21610, {1, 1, 3, 7, 19, 1, 1, 105, 393, 955, 761, 2697, 2543, 13179, 15431, 58219}},
    {5022, 16, 21615, {1, 3, 1, 11, 9, 23, 7, 109, 299, 585, 625, 2215, 6643, 15761, 32667, 51429}},
    {5023, 16, 21630, {1, 3, 5, 15, 23, 37, 93, 79, 251, 557, 531, 301, 7607, 11429, 15419, 24717}},
    {5024, 16, 21633, {1, 1, 7, 3, 29, 55, 25, 33, 43, 475, 595, 2591, 5631, 1015, 28459, 4693}},
    {5025, 16, 21657, {1, 1, 1, 11, 1, 27, 101, 31, 91, 515, 769, 3417, 819, 13889, 17169, 42583}},
    {5026, 16, 21658, {1, 3, 3, 3, 27, 61, 107, 93, 67, 253, 1869, 1021, 8181, 3831, 6519, 25613}},
    {5027, 16, 21669, {1, 3, 3, 13, 1, 35, 45, 159, 75, 147, 1511, 4081, 4673, 731, 3299, 31677}},
    {5028, 16, 21670, {1, 3, 7, 11, 13, 13, 97, 227, 485, 987, 809, 2025, 3279, 12657, 29877, 2243}},
    {5029, 16, 21673, {1, 3, 1, 5, 11, 41, 87, 45, 263, 23, 2023, 2383, 5439, 7245, 7273, 22737}},
    {5030, 16, 21701, {1, 1, 5, 1, 21, 55, 35, 175, 163, 483, 1871, 2133, 6911, 1741, 24945, 33953}},
    {5031, 16, 21719, {1, 1, 5, 1, 9, 15, 31, 51, 433, 915, 927, 931, 627, 169, 9299, 20501}},
    {5032, 16, 21720, {1, 3, 3, 11, 11, 29, 11, 227, 351, 285, 1757, 2811, 7697, 8071, 28237, 6277}},
    {5033, 16, 21747, {1, 1, 5, 13, 17, 29, 111, 213, 191, 369, 1113, 2573, 6449, 6155, 23115, 24209}},
    {5034, 16, 21819, {1, 3, 1, 1, 19, 53, 35, 129, 159, 525, 9, 1747, 7739, 11427, 17247, 44943}},
    {5035, 16, 21839, {1, 1, 3, 15, 3, 25, 91, 147, 153, 597, 1311, 1611, 4665, 9945, 5577, 15225}},
    {5036, 16, 21854, {1, 3, 1, 13, 17, 35, 97, 213, 259, 579, 309, 3981, 5981, 6561, 5467, 7655}},
    {5037, 16, 21857, {1, 1, 5, 11, 11, 23, 11, 99, 499, 669, 1967, 683, 4693, 3613, 31245, 6105}},
    {5038, 16, 21864, {1, 1, 5, 13, 1, 61, 9, 185, 137, 545, 1045, 2289, 3439, 5251, 16451, 23493}},
    {5039, 16, 21882, {1, 1, 7, 3, 23, 53, 13, 255, 189, 649, 231, 1063, 965, 9327, 2605, 45787}},
    {5040, 16, 21900, {1, 1, 7, 3, 11, 61, 125, 63, 359, 389, 1459, 1241, 1521, 6697, 23835, 11659}},
    {5041, 16, 21903, {1, 1, 3, 3, 27, 47, 63, 65, 279, 153, 1907, 1279, 2381, 12713, 12317, 24545}},
    {5042, 16, 21928, {1, 3, 5, 5, 31, 39, 65, 237, 511, 33, 1519, 505, 3623, 4587, 7757, 55079}},
    {5043, 16, 21931, {1, 1, 1, 7, 3, 17, 83, 59, 477, 891, 985, 3707, 269, 1049, 25613, 48577}},
    {5044, 16, 21946, {1, 3, 5, 5, 13, 45, 119, 255, 75, 173, 1901, 4089, 6653, 13811, 8735, 46345}},
    {5045, 16, 21971, {1, 3, 7, 11, 25, 35, 17, 229, 377, 655, 1845, 441, 169, 6683, 9975, 11695}},
    {5046, 16, 21974, {1, 3, 3, 15, 21, 41, 55, 73, 251, 985, 1605, 3359, 991, 5689, 28203, 47967}},
    {5047, 16, 21978, {1, 3, 1, 11, 1, 39, 7, 245, 317, 689, 863, 1345, 8067, 11137, 10791, 47367}},
    {5048, 16, 21993, {1, 1, 1, 7, 7, 43, 35, 97, 203, 613, 1007, 489, 1797, 3151, 6109, 54033}},
    {5049, 16, 21994, {1, 3, 7, 1, 17, 53, 35, 157, 127, 717, 853, 2289, 3801, 1937, 21223, 3579}},
    {5050, 16, 22030, {1, 3, 1, 15, 1, 19, 117, 205, 123, 433, 921, 3625, 6387, 1499, 20241, 25573}},
    {5051, 16, 22035, {1, 1, 1, 11, 1, 5, 5, 87, 17, 595, 1653, 511, 671, 361, 14161, 22541}},
    {5052, 16, 22063, {1, 1, 1, 13, 23, 1, 57, 107, 303, 953, 1697, 2351, 3153, 919, 21835, 56989}},
    {5053, 16, 22068, {1, 3, 3, 9, 17, 25, 61, 163, 363, 143, 975, 2147, 609, 12035, 22073, 37005}},
    {5054, 16, 22086, {1, 1, 3, 7, 23, 55, 83, 159, 319, 479, 1865, 1083, 715, 15777, 9239, 45099}},
    {5055, 16, 22104, {1, 1, 7, 9, 29, 51, 79, 195, 91, 855, 419, 381, 879, 3971, 1119, 30551}},
    {5056, 16, 22119, {1, 3, 7, 11, 17, 1, 75, 59, 25, 157, 1623, 3557, 5861, 11617, 19595, 7923}},
    {5057, 16, 22153, {1, 3, 3, 9, 31, 43, 125, 183, 305, 139, 1649, 4071, 5199, 9535, 15051, 60779}},
    {5058, 16, 22168, {1, 1, 5, 1, 31, 9, 113, 113, 345, 945, 1633, 3263, 7437, 5705, 28487, 21605}},
    {5059, 16, 22183, {1, 3, 1, 3, 7, 17, 57, 23, 375, 437, 1469, 1239, 2299, 14029, 23971, 34835}},
    {5060, 16, 22189, {1, 3, 3, 7, 5, 5, 61, 107, 363, 567, 1659, 1981, 3951, 3467, 19323, 12303}},
    {5061, 16, 22204, {1, 3, 1, 1, 27, 11, 11, 235, 461, 517, 1419, 1199, 3379, 1567, 1355, 2797}},
    {5062, 16, 22230, {1, 3, 3, 7, 5, 19, 41, 215, 471, 107, 603, 2605, 4599, 11881, 26109, 46653}},
    {5063, 16, 22240, {1, 1, 3, 15, 31, 59, 71, 39, 175, 421, 953, 3031, 767, 1969, 27837, 46853}},
    {5064, 16, 22246, {1, 3, 1, 1, 31, 29, 71, 159, 357, 949, 1441, 1853, 873, 1201, 511, 33943}},
    {5065, 16, 22269, {1, 3, 5, 11, 27, 57, 9, 155, 195, 439, 923, 395, 7289, 13935, 4129, 17695}},
    {5066, 16, 22282, {1, 3, 3, 13, 1, 59, 87, 109, 141, 629, 1785, 1987, 341, 9785, 12389, 2587}},
    {5067, 16, 22302, {1, 1, 5, 11, 9, 17, 93, 93, 245, 135, 1881, 3085, 2799, 2689, 22975, 26309}},
    {5068, 16, 22330, {1, 1, 5, 5, 21, 37, 73, 115, 37, 791, 975, 1133, 4429, 8427, 3745, 24153}},
    {5069, 16, 22347, {1, 3, 5, 9, 1, 27, 37, 253, 207, 99, 1779, 971, 3941, 12189, 14727, 32759}},
    {5070, 16, 22349, {1, 1, 3, 15, 27, 37, 3, 185, 219, 743, 377, 299, 6727, 13827, 18761, 701}},
    {5071, 16, 22383, {1, 3, 7, 3, 9, 25, 101, 247, 181, 237, 1563, 431, 7013, 5517, 20615, 36917}},
    {5072, 16, 22386, {1, 1, 5, 1, 15, 47, 101, 13, 287, 393, 75, 2977, 4749, 8721, 3467, 57847}},
    {5073, 16, 22432, {1, 3, 5, 3, 3, 15, 61, 167, 7, 287, 1387, 2033, 553, 539, 5835, 22955}},
    {5074, 16, 22450, {1, 3, 5, 15, 5, 51, 43, 7, 283, 257, 1557, 2183, 8151, 9037, 4481, 56239}},
    {5075, 16, 22473, {1, 1, 7, 7, 3, 35, 101, 179, 195, 361, 1819, 2817, 4083, 12041, 3377, 38647}},
    {5076, 16, 22487, {1, 1, 1, 15, 15, 33, 121, 145, 181, 633, 1457, 3597, 5257, 4493, 9309, 11445}},
    {5077, 16, 22527, {1, 1, 1, 3, 21, 57, 59, 187, 163, 261, 829, 3005, 7025, 3937, 9579, 58551}},
    {5078, 16, 22537, {1, 1, 1, 1, 17, 35, 5, 133, 19, 813, 883, 521, 3259, 12845, 23261, 4935}},
    {5079, 16, 22557, {1, 1, 3, 13, 23, 57, 93, 249, 123, 175, 1003, 409, 5139, 11467, 6393, 52789}},
    {5080, 16, 22561, {1, 3, 1, 1, 3, 37, 29, 53, 195, 747, 495, 1585, 4357, 10809, 15583, 23601}},
    {5081, 16, 22568, {1, 3, 1, 11, 23, 43, 115, 253, 47, 587, 1493, 1823, 5361, 15317, 32033, 34005}},
    {5082, 16, 22573, {1, 1, 7, 5, 11, 37, 43, 167, 139, 1009, 741, 3517, 3935, 1869, 5819, 14793}},
    {5083, 16, 22591, {1, 1, 1, 3, 11, 15, 67, 3, 193, 923, 989, 2037, 6027, 15689, 23229, 44611}},
    {5084, 16, 22593, {1, 1, 1, 11, 5, 53, 1, 11, 485, 101, 165, 1633, 807, 9045, 711, 41315}},
    {5085, 16, 22605, {1, 1, 1, 13, 17, 11, 57, 251, 459, 753, 1541, 2359, 6455, 5299, 15435, 40459}},
    {5086, 16, 22620, {1, 3, 1, 5, 3, 45, 65, 81, 303, 333, 175, 2661, 4275, 12187, 19837, 63299}},
    {5087, 16, 22627, {1, 3, 5, 9, 17, 37, 21, 161, 169, 975, 603, 3051, 907, 14629, 16409, 51881}},
    {5088, 16, 22636, {1, 3, 5, 5, 19, 41, 111, 29, 201, 95, 65, 2707, 7433, 7595, 4567, 61885}},
    {5089, 16, 22647, {1, 3, 7, 13, 29, 17, 5, 101, 93, 605, 1749, 191, 7415, 13581, 15577, 58995}},
    {5090, 16, 22697, {1, 1, 5, 15, 25, 37, 99, 57, 401, 647, 847, 255, 4883, 12747, 16327, 50939}},
    {5091, 16, 22715, {1, 3, 3, 13, 17, 3, 69, 129, 227, 153, 1519, 2777, 3373, 13041, 1543, 2707}},
    {5092, 16, 22725, {1, 1, 5, 7, 23, 5, 55, 121, 141, 453, 1535, 3161, 7153, 13685, 18347, 1259}},
    {5093, 16, 22732, {1, 3, 3, 9, 3, 3, 121, 31, 231, 195, 1555, 2115, 841, 3589, 18597, 39441}},
    {5094, 16, 22749, {1, 3, 7, 15, 17, 19, 115, 147, 77, 719, 1143, 3799, 7417, 13795, 15033, 24671}},
    {5095, 16, 22766, {1, 1, 5, 9, 27, 47, 103, 215, 351, 679, 957, 4087, 967, 13981, 14303, 40539}},
    {5096, 16, 22768, {1, 3, 7, 13, 19, 49, 109, 163, 473, 391, 1667, 2023, 1609, 5665, 9379, 21525}},
    {5097, 16, 22771, {1, 1, 5, 13, 11, 57, 85, 33, 169, 447, 1393, 147, 5183, 14953, 21987, 1231}},
    {5098, 16, 22788, {1, 3, 1, 3, 13, 15, 127, 231, 375, 95, 675, 2269, 6733, 12737, 31373, 19569}},
    {5099, 16, 22797, {1, 3, 1, 9, 1, 37, 41, 151, 161, 769, 1283, 3957, 2007, 14583, 12247, 8327}},
    {5100, 16, 22822, {1, 1, 3, 3, 13, 27, 69, 9, 57, 741, 751, 1559, 6085, 14981, 27527, 40575}},
    {5101, 16, 22828, {1, 1, 3, 1, 19, 57, 109, 43, 193, 583, 1461, 1075, 7397, 1217, 22249, 19329}},
    {5102, 16, 22851, {1, 1, 5, 1, 25, 55, 109, 167, 125, 613, 1033, 2459, 6403, 1097, 22251, 1363}},
    {5103, 16, 22888, {1, 3, 7, 3, 13, 41, 111, 45, 495, 457, 99, 2695, 4495, 12473, 22287, 28263}},
    {5104, 16, 22893, {1, 3, 3, 9, 17, 25, 75, 93, 495, 605, 557, 1431, 8147, 16219, 26789, 28919}},
    {5105, 16, 22901, {1, 1, 5, 3, 19, 57, 83, 93, 399, 341, 1217, 1483, 6607, 15935, 2961, 39211}},
    {5106, 16, 22902, {1, 3, 3, 13, 31, 53, 93, 103, 379, 863, 995, 4081, 4125, 3717, 21123, 639}},
    {5107, 16, 22921, {1, 1, 7, 13, 21, 41, 125, 17, 293, 31, 991, 1865, 6421, 3217, 26833, 2603}},
    {5108, 16, 22929, {1, 3, 7, 13, 9, 7, 67, 241, 161, 5, 933, 1415, 1135, 12139, 18883, 16223}},
    {5109, 16, 22946, {1, 3, 3, 13, 9, 49, 37, 189, 245, 1019, 723, 1753, 3505, 4433, 26719, 5225}},
    {5110, 16, 22948, {1, 1, 5, 5, 13, 63, 19, 1, 225, 481, 1603, 2195, 5585, 13783, 16491, 8239}},
    {5111, 16, 22951, {1, 3, 5, 3, 31, 3, 41, 161, 255, 247, 139, 3349, 8081, 16259, 3945, 8921}},
    {5112, 16, 22958, {1, 3, 5, 1, 1, 41, 83, 165, 375, 371, 1851, 1655, 3575, 10527, 28541, 18877}},
    {5113, 16, 22975, {1, 1, 7, 3, 31, 39, 89, 21, 125, 767, 577, 435, 5785, 15215, 26763, 10435}},
    {5114, 16, 22983, {1, 3, 3, 5, 19, 43, 83, 35, 355, 967, 1587, 271, 6579, 13207, 26495, 41307}},
    {5115, 16, 22990, {1, 1, 7, 1, 31, 7, 117, 141, 349, 269, 1723, 3243, 8159, 14665, 12313, 39821}},
    {5116, 16, 23032, {1, 1, 3, 7, 15, 55, 95, 149, 375, 357, 1277, 27, 991, 14443, 24423, 37725}},
    {5117, 16, 23047, {1, 3, 5, 9, 25, 51, 43, 77, 285, 309, 1251, 1267, 2507, 3657, 30761, 49683}},
    {5118, 16, 23053, {1, 3, 5, 3, 25, 61, 61, 171, 283, 221, 1333, 2599, 4335, 6831, 32093, 64741}},
    {5119, 16, 23054, {1, 1, 1, 9, 29, 35, 51, 33, 193, 103, 189, 211, 2159, 9421, 32677, 22941}},
    {5120, 16, 23082, {1, 3, 5, 15, 29, 5, 99, 201, 235, 535, 1679, 955, 2185, 2551, 31501, 51307}},
    {5121, 16, 23095, {1, 3, 7, 3, 25, 3, 113, 147, 449, 115, 467, 2543, 7955, 8057, 2615, 26729}},
    {5122, 16, 23116, {1, 1, 7, 5, 15, 33, 33, 41, 15, 547, 1369, 3797, 97, 10493, 4243, 17671}},
    {5123, 16, 23197, {1, 1, 7, 1, 17, 1, 79, 57, 251, 7, 451, 1785, 4913, 3961, 10419, 34411}},
    {5124, 16, 23221, {1, 3, 3, 9, 1, 7, 85, 163, 341, 787, 131, 943, 7981, 10337, 20097, 21333}},
    {5125, 16, 23257, {1, 1, 1, 1, 15, 3, 79, 41, 293, 85, 649, 4027, 6365, 11557, 6369, 13793}},
    {5126, 16, 23260, {1, 3, 1, 11, 29, 19, 95, 69, 207, 99, 1367, 625, 7657, 13763, 27735, 19343}},
    {5127, 16, 23263, {1, 3, 3, 11, 9, 3, 115, 83, 133, 889, 535, 1363, 6667, 12655, 30161, 28225}},
    {5128, 16, 23267, {1, 1, 1, 11, 5, 11, 41, 31, 3, 847, 743, 1211, 1477, 15657, 31185, 64663}},
    {5129, 16, 23282, {1, 1, 3, 3, 7, 1, 15, 205, 457, 771, 1593, 3179, 435, 13843, 26655, 25397}},
    {5130, 16, 23284, {1, 3, 7, 1, 27, 15, 103, 107, 503, 301, 271, 765, 3253, 4405, 20783, 19167}},
    {5131, 16, 23314, {1, 3, 5, 3, 25, 9, 5, 131, 15, 337, 1065, 3785, 4837, 4685, 8045, 31117}},
    {5132, 16, 23326, {1, 3, 1, 3, 9, 13, 59, 109, 455, 841, 1813, 519, 4595, 7425, 12395, 6215}},
    {5133, 16, 23335, {1, 1, 5, 9, 25, 17, 37, 201, 225, 489, 587, 1539, 1913, 355, 16205, 14205}},
    {5134, 16, 23368, {1, 1, 3, 3, 23, 9, 43, 87, 177, 43, 179, 2469, 1021, 10855, 7813, 23215}},
    {5135, 16, 23373, {1, 3, 7, 13, 15, 51, 79, 171, 429, 563, 871, 785, 6841, 7143, 18023, 45657}},
    {5136, 16, 23401, {1, 3, 7, 7, 1, 33, 37, 211, 285, 811, 1971, 79, 777, 6387, 13281, 7123}},
    {5137, 16, 23415, {1, 3, 3, 13, 11, 57, 41, 117, 489, 163, 1831, 1801, 1825, 11183, 2741, 11811}},
    {5138, 16, 23432, {1, 3, 7, 13, 31, 17, 19, 123, 19, 1007, 15, 2895, 1597, 1245, 28599, 9749}},
    {5139, 16, 23476, {1, 3, 7, 13, 3, 41, 5, 195, 407, 715, 1795, 1691, 6825, 13121, 19531, 47029}},
    {5140, 16, 23479, {1, 1, 1, 11, 19, 35, 81, 113, 71, 877, 1319, 3321, 661, 7187, 30961, 47737}},
    {5141, 16, 23497, {1, 3, 5, 3, 25, 25, 35, 167, 413, 27, 671, 1409, 243, 3861, 3799, 7691}},
    {5142, 16, 23505, {1, 3, 5, 9, 5, 35, 51, 159, 119, 389, 1749, 381, 411, 9707, 7027, 8271}},
    {5143, 16, 23508, {1, 3, 5, 15, 17, 55, 91, 147, 165, 523, 649, 4089, 743, 1071, 15703, 25449}},
    {5144, 16, 23531, {1, 3, 1, 9, 19, 53, 41, 11, 199, 1005, 993, 1249, 7221, 14147, 1587, 30041}},
    {5145, 16, 23536, {1, 3, 3, 5, 27, 1, 105, 171, 439, 33, 1771, 439, 7403, 10981, 18397, 24787}},
    {5146, 16, 23542, {1, 1, 1, 11, 29, 9, 67, 165, 263, 115, 1567, 2905, 4793, 12505, 14157, 36339}},
    {5147, 16, 23565, {1, 1, 1, 1, 13, 59, 71, 191, 225, 851, 1029, 2347, 7811, 4679, 16071, 16265}},
    {5148, 16, 23573, {1, 3, 7, 9, 23, 51, 121, 249, 73, 225, 597, 237, 3399, 273, 8835, 9047}},
    {5149, 16, 23590, {1, 3, 5, 13, 13, 53, 57, 177, 31, 11, 1819, 955, 2801, 13711, 14293, 41893}},
    {5150, 16, 23593, {1, 3, 5, 5, 5, 33, 71, 121, 351, 381, 1085, 1823, 2981, 13487, 23151, 19385}},
    {5151, 16, 23604, {1, 1, 3, 13, 5, 25, 63, 173, 385, 501, 1863, 71, 2263, 9649, 30919, 44377}},
    {5152, 16, 23621, {1, 1, 7, 5, 17, 21, 63, 193, 453, 613, 1841, 345, 4215, 7139, 10277, 6685}},
    {5153, 16, 23622, {1, 3, 1, 3, 25, 11, 7, 51, 345, 935, 1587, 585, 1151, 4751, 3989, 23223}},
    {5154, 16, 23636, {1, 1, 5, 11, 29, 45, 91, 203, 461, 977, 149, 3407, 2575, 2459, 6937, 12675}},
    {5155, 16, 23662, {1, 3, 3, 13, 11, 39, 77, 237, 63, 789, 1239, 2883, 7403, 2689, 18059, 59141}},
    {5156, 16, 23667, {1, 3, 7, 9, 13, 63, 127, 215, 447, 145, 1449, 1121, 553, 8883, 23669, 27341}},
    {5157, 16, 23703, {1, 1, 1, 11, 1, 55, 39, 3, 315, 183, 1341, 201, 6509, 73, 6865, 40263}},
    {5158, 16, 23725, {1, 1, 5, 9, 27, 47, 69, 27, 415, 407, 173, 1387, 5205, 2199, 7, 18671}},
    {5159, 16, 23734, {1, 3, 5, 11, 19, 29, 37, 39, 365, 115, 1729, 2467, 6901, 13749, 24293, 22471}},
    {5160, 16, 23738, {1, 3, 5, 15, 27, 11, 95, 15, 433, 919, 509, 2117, 4407, 15771, 24681, 29857}},
    {5161, 16, 23752, {1, 3, 5, 15, 31, 29, 5, 51, 185, 521, 1879, 3209, 6313, 6819, 21369, 32657}},
    {5162, 16, 23800, {1, 1, 5, 1, 27, 17, 35, 77, 365, 105, 1781, 3339, 8113, 15587, 17035, 58423}},
    {5163, 16, 23803, {1, 1, 1, 5, 23, 55, 113, 57, 189, 93, 1275, 253, 1453, 8549, 29839, 35669}},
    {5164, 16, 23818, {1, 1, 5, 11, 27, 45, 37, 247, 317, 245, 1415, 2907, 4833, 10277, 3191, 19339}},
    {5165, 16, 23832, {1, 3, 7, 7, 15, 47, 95, 69, 103, 913, 1811, 1553, 7893, 1641, 30955, 35657}},
    {5166, 16, 23842, {1, 3, 7, 5, 19, 39, 83, 191, 295, 147, 69, 1221, 6355, 15363, 7003, 16921}},
    {5167, 16, 23851, {1, 1, 7, 13, 25, 45, 89, 249, 37, 53, 239, 649, 1587, 16341, 16885, 19155}},
    {5168, 16, 23873, {1, 3, 5, 1, 9, 35, 67, 149, 163, 949, 435, 1111, 793, 5467, 3647, 40077}},
    {5169, 16, 23883, {1, 1, 5, 13, 3, 19, 63, 173, 45, 365, 47, 537, 5997, 6861, 5903, 6193}},
    {5170, 16, 23888, {1, 3, 5, 9, 5, 23, 31, 243, 373, 701, 953, 1743, 3475, 11289, 17683, 43407}},
    {5171, 16, 23910, {1, 3, 1, 15, 17, 5, 123, 85, 177, 389, 1547, 1747, 1917, 13105, 6009, 20875}},
    {5172, 16, 23934, {1, 3, 1, 13, 5, 17, 33, 199, 239, 355, 1285, 2493, 5229, 2245, 2795, 26811}},
    {5173, 16, 23938, {1, 1, 3, 11, 17, 41, 59, 53, 349, 423, 825, 2465, 6857, 853, 485, 46809}},
    {5174, 16, 23949, {1, 3, 5, 15, 21, 57, 113, 147, 371, 5, 1445, 1589, 65, 9195, 2367, 61575}},
    {5175, 16, 23955, {1, 3, 3, 5, 21, 1, 47, 39, 503, 653, 1761, 2771, 7281, 337, 1623, 45489}},
    {5176, 16, 23967, {1, 1, 1, 5, 23, 49, 89, 229, 117, 429, 383, 1903, 8027, 10295, 11337, 60607}},
    {5177, 16, 23973, {1, 1, 1, 13, 23, 51, 103, 237, 151, 955, 1983, 4087, 2201, 6447, 20899, 51553}},
    {5178, 16, 23991, {1, 1, 1, 5, 13, 13, 43, 231, 341, 173, 1833, 687, 6439, 7761, 13199, 17005}},
    {5179, 16, 24024, {1, 3, 7, 1, 29, 1, 121, 73, 277, 599, 2017, 3673, 3419, 13953, 1035, 32101}},
    {5180, 16, 24030, {1, 3, 3, 3, 13, 33, 3, 235, 499, 355, 221, 409, 1667, 12279, 8829, 59217}},
    {5181, 16, 24039, {1, 3, 5, 9, 1, 21, 51, 179, 451, 881, 1649, 1505, 3161, 3031, 1425, 20277}},
    {5182, 16, 24067, {1, 3, 1, 7, 11, 17, 53, 155, 417, 577, 89, 3453, 6667, 11921, 18227, 30599}},
    {5183, 16, 24069, {1, 3, 1, 7, 27, 39, 21, 101, 165, 273, 1271, 3459, 7599, 10933, 4543, 15393}},
    {5184, 16, 24084, {1, 3, 7, 5, 25, 23, 127, 107, 147, 505, 287, 2271, 1897, 8929, 32225, 61537}},
    {5185, 16, 24112, {1, 1, 3, 15, 29, 29, 39, 131, 333, 763, 1575, 437, 8067, 12679, 27561, 2401}},
    {5186, 16, 24115, {1, 3, 1, 15, 5, 21, 19, 39, 463, 907, 1189, 357, 8171, 3887, 22959, 25605}},
    {5187, 16, 24184, {1, 3, 3, 9, 25, 27, 25, 135, 335, 657, 745, 2039, 7911, 13755, 18719, 36665}},
    {5188, 16, 24187, {1, 3, 3, 11, 23, 61, 87, 41, 63, 555, 1853, 3121, 2733, 1083, 19895, 28905}},
    {5189, 16, 24262, {1, 3, 1, 11, 25, 45, 25, 205, 189, 191, 1207, 1785, 7343, 2403, 10749, 48293}},
    {5190, 16, 24276, {1, 3, 5, 15, 17, 59, 85, 205, 383, 431, 177, 3313, 6161, 14865, 20605, 50891}},
    {5191, 16, 24279, {1, 1, 7, 15, 27, 39, 37, 131, 299, 215, 561, 1369, 5701, 11697, 32403, 43755}},
    {5192, 16, 24313, {1, 1, 5, 9, 5, 43, 93, 23, 3, 623, 705, 569, 2341, 3575, 887, 11173}},
    {5193, 16, 24331, {1, 1, 7, 1, 21, 5, 37, 25, 165, 131, 1685, 3925, 4535, 12265, 30201, 41579}},
    {5194, 16, 24336, {1, 1, 3, 13, 17, 63, 113, 13, 51, 1003, 885, 43, 1827, 6285, 7427, 19769}},
    {5195, 16, 24348, {1, 1, 1, 5, 7, 37, 77, 89, 339, 47, 1321, 2651, 6857, 4565, 20077, 37225}},
    {5196, 16, 24367, {1, 3, 5, 15, 1, 57, 75, 11, 155, 615, 127, 3231, 2523, 10683, 5577, 39591}},
    {5197, 16, 24372, {1, 3, 3, 9, 1, 29, 45, 29, 215, 409, 1991, 3085, 5061, 12009, 4701, 32859}},
    {5198, 16, 24402, {1, 3, 3, 1, 17, 11, 91, 41, 357, 167, 321, 319, 773, 13915, 12041, 47371}},
    {5199, 16, 24420, {1, 3, 7, 3, 25, 41, 3, 117, 57, 721, 599, 1165, 4607, 9579, 28727, 9511}},
    {5200, 16, 24444, {1, 1, 7, 9, 1, 29, 49, 57, 39, 515, 349, 1495, 6199, 737, 15229, 50095}},
    {5201, 16, 24465, {1, 3, 7, 1, 25, 9, 109, 157, 317, 409, 681, 3007, 1027, 5597, 28945, 55589}},
    {5202, 16, 24466, {1, 1, 1, 15, 13, 59, 11, 193, 151, 223, 1687, 2907, 201, 11343, 12917, 37113}},
    {5203, 16, 24471, {1, 1, 7, 3, 29, 61, 33, 203, 441, 285, 59, 2429, 4461, 4337, 19547, 15113}},
    {5204, 16, 24475, {1, 1, 1, 11, 21, 19, 17, 179, 7, 753, 1251, 263, 5905, 8575, 20249, 35105}},
    {5205, 16, 24481, {1, 3, 7, 7, 25, 51, 9, 173, 345, 1, 51, 639, 6499, 13585, 7535, 44681}},
    {5206, 16, 24488, {1, 1, 3, 7, 3, 29, 21, 57, 377, 881, 579, 3935, 2417, 2981, 28623, 14735}},
    {5207, 16, 24501, {1, 3, 3, 7, 7, 61, 89, 237, 9, 327, 41, 701, 7403, 3599, 6427, 14287}},
    {5208, 16, 24514, {1, 1, 7, 5, 17, 11, 43, 57, 35, 935, 1243, 291, 3959, 10927, 24243, 32867}},
    {5209, 16, 24531, {1, 3, 5, 3, 11, 31, 117, 125, 197, 869, 1957, 1207, 2117, 6683, 12479, 13403}},
    {5210, 16, 24534, {1, 1, 7, 9, 17, 63, 55, 121, 395, 371, 1483, 1863, 2259, 9931, 2915, 62211}},
    {5211, 16, 24559, {1, 3, 7, 11, 1, 59, 125, 219, 125, 13, 729, 2159, 1155, 1501, 31691, 15117}},
    {5212, 16, 24602, {1, 3, 3, 5, 13, 27, 105, 247, 129, 401, 835, 2377, 4949, 15925, 12791, 25867}},
    {5213, 16, 24614, {1, 3, 5, 1, 5, 45, 19, 107, 435, 961, 917, 1483, 6145, 1549, 5375, 6891}},
    {5214, 16, 24637, {1, 3, 7, 7, 31, 35, 71, 127, 325, 947, 647, 2929, 6849, 6295, 9303, 53507}},
    {5215, 16, 24664, {1, 1, 1, 1, 19, 35, 65, 69, 187, 307, 1569, 801, 3471, 15545, 7921, 7995}},
    {5216, 16, 24676, {1, 3, 3, 1, 3, 9, 109, 13, 317, 171, 499, 1681, 3861, 359, 29557, 43647}},
    {5217, 16, 24679, {1, 1, 3, 9, 15, 61, 57, 247, 261, 741, 1199, 2089, 8055, 7113, 809, 54997}},
    {5218, 16, 24697, {1, 1, 3, 7, 9, 15, 83, 101, 121, 721, 1797, 3885, 2885, 14217, 21441, 48893}},
    {5219, 16, 24709, {1, 1, 3, 15, 5, 23, 13, 75, 231, 917, 1387, 2811, 3311, 5965, 11139, 38303}},
    {5220, 16, 24714, {1, 1, 1, 13, 25, 9, 99, 197, 425, 877, 517, 277, 4243, 8071, 16043, 2469}},
    {5221, 16, 24716, {1, 1, 1, 5, 29, 15, 65, 83, 69, 395, 1667, 2543, 189, 12253, 2631, 36289}},
    {5222, 16, 24731, {1, 3, 1, 13, 27, 1, 9, 221, 193, 793, 93, 2537, 1815, 11289, 14533, 58623}},
    {5223, 16, 24744, {1, 1, 5, 9, 29, 29, 45, 243, 291, 759, 1951, 987, 509, 11329, 29577, 49183}},
    {5224, 16, 24762, {1, 3, 3, 15, 19, 37, 73, 97, 265, 927, 1793, 2951, 8141, 13221, 19395, 31087}},
    {5225, 16, 24764, {1, 1, 3, 5, 15, 13, 59, 71, 465, 197, 1977, 3181, 7609, 13527, 19849, 34995}},
    {5226, 16, 24769, {1, 1, 3, 13, 1, 51, 91, 241, 69, 481, 455, 1597, 4797, 1729, 169, 35513}},
    {5227, 16, 24806, {1, 1, 7, 3, 5, 11, 87, 115, 365, 425, 1761, 1901, 2223, 8953, 7467, 6363}},
    {5228, 16, 24812, {1, 1, 5, 3, 29, 47, 41, 29, 131, 661, 269, 1257, 6299, 4663, 1911, 15635}},
    {5229, 16, 24872, {1, 3, 7, 1, 7, 53, 41, 15, 283, 623, 1063, 3239, 1045, 14639, 3913, 22721}},
    {5230, 16, 24878, {1, 3, 7, 5, 13, 13, 115, 195, 217, 705, 1595, 1049, 5489, 4413, 23295, 8905}},
    {5231, 16, 24883, {1, 1, 3, 7, 31, 13, 79, 165, 135, 637, 1217, 633, 8013, 5519, 11173, 3013}},
    {5232, 16, 24909, {1, 3, 5, 7, 31, 47, 125, 225, 25, 797, 1685, 1095, 6575, 4797, 25337, 3433}},
    {5233, 16, 24943, {1, 1, 1, 11, 15, 3, 81, 111, 63, 987, 2019, 2845, 7695, 2351, 26695, 2639}},
    {5234, 16, 24946, {1, 1, 1, 13, 23, 31, 105, 105, 383, 241, 379, 315, 5111, 833, 2033, 6817}},
    {5235, 16, 24964, {1, 3, 7, 3, 9, 29, 3, 79, 333, 311, 1941, 3781, 67, 7527, 20149, 33793}},
    {5236, 16, 24992, {1, 1, 5, 3, 11, 31, 71, 139, 497, 639, 1211, 1387, 5635, 10669, 26635, 62361}},
    {5237, 16, 25016, {1, 3, 5, 9, 13, 5, 121, 15, 23, 329, 1263, 2321, 5815, 5531, 3849, 7263}},
    {5238, 16, 25022, {1, 3, 7, 9, 23, 57, 27, 169, 31, 975, 1135, 3941, 2841, 5599, 15281, 10835}},
    {5239, 16, 25024, {1, 3, 5, 13, 3, 3, 3, 165, 109, 21, 1245, 2753, 2061, 2805, 4841, 6403}},
    {5240, 16, 25039, {1, 3, 3, 5, 3, 27, 105, 83, 367, 189, 443, 1405, 5805, 12411, 10153, 21167}},
    {5241, 16, 25051, {1, 1, 3, 3, 15, 3, 109, 109, 325, 613, 737, 3419, 3015, 7509, 28511, 39673}},
    {5242, 16, 25060, {1, 1, 3, 7, 23, 53, 73, 15, 153, 515, 897, 259, 271, 16337, 2991, 48475}},
    {5243, 16, 25072, {1, 3, 3, 11, 31, 61, 91, 75, 291, 713, 695, 1829, 3327, 9803, 24175, 20207}},
    {5244, 16, 25097, {1, 3, 7, 5, 17, 25, 43, 93, 325, 859, 1929, 3465, 6921, 8145, 20215, 55153}},
    {5245, 16, 25122, {1, 3, 3, 5, 23, 57, 65, 131, 51, 347, 1957, 805, 2183, 10919, 3561, 48035}},
    {5246, 16, 25148, {1, 1, 3, 15, 7, 53, 39, 175, 59, 77, 391, 3719, 2779, 15055, 28697, 34373}},
    {5247, 16, 25194, {1, 3, 1, 1, 29, 5, 67, 23, 69, 533, 1547, 4017, 1199, 13135, 15251, 24839}},
    {5248, 16, 25201, {1, 3, 3, 9, 25, 7, 123, 1, 413, 923, 1773, 3227, 6743, 13805, 31195, 11907}},
    {5249, 16, 25204, {1, 3, 7, 15, 5, 31, 9, 105, 235, 367, 1023, 179, 3987, 13733, 19657, 25915}},
    {5250, 16, 25238, {1, 3, 5, 9, 17, 19, 3, 253, 121, 965, 771, 3057, 7841, 10059, 22309, 9959}},
    {5251, 16, 25241, {1, 3, 1, 5, 23, 1, 81, 123, 93, 827, 2041, 2649, 2493, 11881, 8843, 65239}},
    {5252, 16, 25248, {1, 3, 1, 9, 17, 5, 27, 29, 31, 1023, 1789, 2575, 4077, 2393, 12967, 10205}},
    {5253, 16, 25257, {1, 1, 7, 5, 7, 9, 121, 99, 217, 151, 1287, 2361, 5261, 453, 7677, 37919}},
    {5254, 16, 25275, {1, 1, 5, 7, 15, 27, 99, 243, 279, 653, 973, 4063, 5143, 6403, 20859, 46373}},
    {5255, 16, 25278, {1, 1, 7, 5, 31, 61, 5, 223, 291, 975, 1707, 1577, 4669, 14377, 24481, 3085}},
    {5256, 16, 25304, {1, 1, 3, 3, 7, 29, 73, 187, 283, 205, 1717, 13, 4495, 13705, 29505, 61965}},
    {5257, 16, 25307, {1, 3, 1, 7, 5, 61, 57, 157, 167, 409, 1009, 3177, 3171, 11869, 783, 3347}},
    {5258, 16, 25320, {1, 1, 7, 9, 27, 39, 111, 21, 113, 285, 973, 3705, 7421, 15939, 23383, 3457}},
    {5259, 16, 25334, {1, 3, 7, 5, 5, 57, 15, 17, 25, 309, 175, 2621, 1645, 11705, 29673, 21855}},
    {5260, 16, 25348, {1, 1, 7, 7, 27, 31, 53, 23, 431, 211, 137, 3751, 5807, 9555, 9235, 24105}},
    {5261, 16, 25357, {1, 1, 7, 11, 3, 29, 49, 79, 447, 783, 1911, 2769, 4715, 2501, 25295, 41971}},
    {5262, 16, 25372, {1, 3, 5, 5, 15, 43, 97, 205, 73, 113, 1593, 2323, 7745, 12053, 21871, 4239}},
    {5263, 16, 25394, {1, 1, 5, 11, 27, 41, 15, 139, 509, 455, 1471, 3519, 7523, 15571, 7981, 25123}},
    {5264, 16, 25454, {1, 3, 7, 13, 21, 39, 3, 41, 251, 69, 1935, 2889, 7475, 11471, 13015, 19921}},
    {5265, 16, 25465, {1, 3, 1, 1, 7, 55, 3, 191, 137, 509, 1015, 3599, 6055, 11427, 4871, 54353}},
    {5266, 16, 25472, {1, 1, 1, 13, 7, 41, 41, 19, 423, 421, 1595, 2303, 4779, 555, 8825, 5917}},
    {5267, 16, 25492, {1, 1, 1, 11, 15, 37, 71, 45, 287, 59, 127, 3295, 5757, 15535, 13935, 38339}},
    {5268, 16, 25505, {1, 1, 7, 13, 25, 49, 113, 13, 135, 291, 1113, 1197, 7631, 1659, 8747, 14171}},
    {5269, 16, 25517, {1, 1, 3, 7, 15, 27, 5, 247, 423, 75, 849, 2987, 1029, 8745, 19431, 51595}},
    {5270, 16, 25530, {1, 3, 3, 13, 21, 37, 117, 49, 507, 191, 1291, 3801, 3015, 11823, 21199, 49889}},
    {5271, 16, 25558, {1, 3, 1, 9, 27, 23, 57, 141, 329, 67, 577, 2531, 3371, 1499, 30181, 32787}},
    {5272, 16, 25562, {1, 3, 1, 3, 19, 17, 125, 69, 131, 567, 1739, 3697, 2281, 11047, 15959, 705}},
    {5273, 16, 25598, {1, 3, 1, 3, 1, 59, 13, 5, 277, 883, 1369, 3021, 4843, 16367, 22307, 17643}},
    {5274, 16, 25609, {1, 3, 5, 7, 13, 7, 51, 39, 107, 707, 693, 3223, 119, 11679, 31591, 61113}},
    {5275, 16, 25612, {1, 1, 1, 7, 9, 31, 113, 235, 209, 153, 405, 1867, 3245, 13417, 32423, 18337}},
    {5276, 16, 25627, {1, 3, 3, 15, 17, 43, 5, 31, 241, 255, 2029, 1989, 6547, 4539, 8277, 1349}},
    {5277, 16, 25651, {1, 3, 1, 5, 3, 17, 63, 203, 389, 883, 499, 2473, 1515, 9853, 20787, 15503}},
    {5278, 16, 25653, {1, 3, 5, 15, 7, 11, 127, 255, 147, 521, 1291, 317, 7467, 1569, 16407, 50363}},
    {5279, 16, 25668, {1, 1, 7, 9, 31, 43, 71, 15, 257, 753, 1591, 2599, 1113, 12845, 24387, 28581}},
    {5280, 16, 25711, {1, 3, 3, 11, 7, 43, 113, 131, 505, 961, 1647, 585, 6227, 14627, 29151, 56909}},
    {5281, 16, 25765, {1, 3, 5, 5, 3, 21, 61, 181, 351, 959, 983, 3691, 5647, 7479, 1115, 53335}},
    {5282, 16, 25770, {1, 3, 5, 13, 25, 43, 75, 41, 409, 329, 2035, 719, 5, 6681, 29235, 21341}},
    {5283, 16, 25775, {1, 1, 3, 9, 25, 49, 127, 71, 383, 951, 637, 3105, 7593, 12953, 8505, 10775}},
    {5284, 16, 25777, {1, 1, 7, 13, 5, 45, 53, 159, 283, 375, 801, 2335, 1317, 8521, 13751, 61119}},
    {5285, 16, 25783, {1, 1, 1, 15, 15, 21, 87, 165, 315, 309, 2039, 2037, 5251, 1459, 15135, 28867}},
    {5286, 16, 25801, {1, 3, 3, 3, 9, 53, 33, 247, 159, 247, 1257, 2281, 5107, 11765, 3341, 24239}},
    {5287, 16, 25802, {1, 1, 7, 9, 19, 57, 105, 213, 347, 279, 1307, 319, 527, 4411, 15101, 22469}},
    {5288, 16, 25812, {1, 3, 3, 9, 15, 39, 85, 243, 325, 691, 985, 3687, 3249, 4393, 18377, 48245}},
    {5289, 16, 25821, {1, 3, 3, 15, 19, 17, 3, 7, 261, 307, 201, 3757, 7711, 6019, 22861, 38023}},
    {5290, 16, 25897, {1, 3, 3, 1, 3, 61, 31, 199, 393, 243, 1121, 1035, 7049, 6517, 8837, 26423}},
    {5291, 16, 25906, {1, 3, 1, 13, 15, 9, 15, 133, 115, 345, 999, 1243, 5307, 12743, 12637, 56055}},
    {5292, 16, 25929, {1, 1, 7, 13, 31, 9, 63, 41, 101, 459, 1563, 1821, 1703, 15309, 17585, 27485}},
    {5293, 16, 25940, {1, 1, 1, 3, 3, 53, 79, 183, 329, 939, 1789, 3613, 1783, 13269, 8583, 36763}},
    {5294, 16, 25950, {1, 3, 5, 9, 5, 21, 33, 159, 69, 889, 1633, 1815, 261, 13727, 28715, 59933}},
    {5295, 16, 25968, {1, 3, 7, 3, 1, 41, 57, 67, 335, 253, 33, 2431, 5167, 13907, 26941, 297}},
    {5296, 16, 25971, {1, 3, 3, 3, 31, 3, 127, 33, 495, 791, 905, 3689, 7287, 14053, 555, 36903}},
    {5297, 16, 25977, {1, 1, 5, 11, 9, 33, 7, 111, 405, 153, 1101, 115, 625, 7163, 19491, 11345}},
    {5298, 16, 25994, {1, 1, 7, 3, 29, 11, 95, 61, 55, 981, 1949, 1103, 3755, 9865, 10161, 27039}},
    {5299, 16, 25996, {1, 3, 5, 3, 9, 53, 93, 229, 361, 223, 849, 1799, 1757, 13689, 10977, 18897}},
    {5300, 16, 25999, {1, 1, 1, 1, 31, 29, 57, 175, 229, 271, 69, 2109, 5953, 547, 14059, 20923}},
    {5301, 16, 26001, {1, 3, 7, 15, 9, 21, 21, 79, 31, 939, 983, 3269, 1913, 11035, 21063, 62371}},
    {5302, 16, 26030, {1, 1, 1, 15, 13, 9, 57, 145, 461, 215, 1091, 369, 7371, 13995, 18421, 58367}},
    {5303, 16, 26069, {1, 1, 3, 13, 27, 5, 65, 111, 131, 83, 103, 3411, 1277, 14257, 2273, 38347}},
    {5304, 16, 26100, {1, 3, 7, 7, 31, 1, 31, 47, 79, 117, 787, 2515, 85, 4499, 25535, 2269}},
    {5305, 16, 26109, {1, 1, 3, 7, 13, 11, 107, 15, 415, 9, 787, 3109, 3365, 2093, 26105, 41295}},
    {5306, 16, 26131, {1, 1, 7, 11, 13, 1, 111, 217, 363, 875, 1169, 193, 5739, 8815, 25531, 63189}},
    {5307, 16, 26144, {1, 1, 3, 3, 13, 31, 67, 199, 287, 125, 985, 683, 7391, 12071, 6181, 14287}},
    {5308, 16, 26149, {1, 1, 1, 3, 27, 25, 31, 85, 477, 559, 1359, 2269, 6359, 9561, 3069, 39081}},
    {5309, 16, 26162, {1, 1, 3, 15, 29, 61, 69, 247, 365, 929, 1877, 2909, 2913, 11715, 23071, 42937}},
    {5310, 16, 26167, {1, 3, 7, 3, 19, 9, 75, 251, 161, 711, 1939, 3811, 2295, 3913, 8589, 59193}},
    {5311, 16, 26173, {1, 3, 3, 7, 31, 27, 29, 243, 275, 793, 1369, 1967, 5899, 11165, 27527, 28927}},
    {5312, 16, 26179, {1, 3, 1, 15, 19, 63, 13, 189, 201, 791, 2011, 1185, 1435, 1591, 28629, 23847}},
    {5313, 16, 26193, {1, 1, 7, 15, 21, 53, 73, 9, 213, 859, 1181, 489, 4139, 7605, 475, 25537}},
    {5314, 16, 26230, {1, 3, 7, 15, 3, 21, 105, 21, 373, 767, 1943, 763, 2399, 15357, 7463, 13075}},
    {5315, 16, 26234, {1, 1, 5, 9, 9, 13, 109, 249, 187, 321, 721, 3243, 4063, 3487, 21967, 517}},
    {5316, 16, 26246, {1, 1, 5, 13, 13, 35, 103, 183, 459, 243, 1837, 1941, 1729, 5217, 28737, 6703}},
    {5317, 16, 26267, {1, 3, 7, 7, 31, 27, 119, 119, 231, 637, 7, 1325, 695, 15749, 1351, 36805}},
    {5318, 16, 26283, {1, 1, 7, 7, 5, 21, 109, 183, 223, 187, 1171, 1613, 2393, 4945, 29441, 4405}},
    {5319, 16, 26300, {1, 3, 1, 11, 17, 7, 47, 7, 497, 993, 1275, 3237, 909, 2873, 209, 14941}},
    {5320, 16, 26341, {1, 3, 5, 7, 17, 61, 67, 109, 363, 425, 565, 1697, 5489, 5889, 28883, 33087}},
    {5321, 16, 26356, {1, 1, 1, 9, 27, 51, 61, 1, 229, 853, 1781, 2801, 4235, 13303, 20415, 63139}},
    {5322, 16, 26377, {1, 3, 7, 9, 5, 55, 95, 155, 31, 991, 579, 701, 6511, 7623, 27157, 65219}},
    {5323, 16, 26397, {1, 1, 3, 9, 21, 23, 7, 3, 225, 857, 1369, 1671, 6091, 2559, 16661, 37327}},
    {5324, 16, 26404, {1, 1, 3, 15, 13, 53, 51, 159, 139, 469, 1017, 2881, 2523, 9163, 4027, 18915}},
    {5325, 16, 26411, {1, 3, 1, 11, 11, 11, 127, 91, 363, 1015, 205, 2377, 6915, 6183, 715, 27285}},
    {5326, 16, 26422, {1, 1, 1, 13, 7, 17, 111, 237, 47, 619, 73, 3019, 7193, 9649, 12095, 2071}},
    {5327, 16, 26451, {1, 1, 1, 11, 25, 29, 67, 123, 123, 899, 811, 2467, 1673, 1449, 2753, 46181}},
    {5328, 16, 26454, {1, 3, 1, 11, 7, 17, 29, 251, 171, 31, 877, 1887, 7517, 13337, 6371, 26635}},
    {5329, 16, 26463, {1, 1, 7, 3, 15, 35, 91, 101, 267, 415, 1707, 1703, 6867, 1781, 28611, 14037}},
    {5330, 16, 26488, {1, 3, 5, 13, 9, 5, 97, 33, 73, 657, 1589, 3793, 7709, 8411, 2209, 1193}},
    {5331, 16, 26498, {1, 3, 1, 7, 9, 13, 5, 67, 93, 721, 1509, 2265, 2759, 9491, 12879, 49535}},
    {5332, 16, 26509, {1, 3, 1, 11, 29, 45, 25, 227, 295, 493, 827, 3549, 6799, 12667, 6317, 54199}},
    {5333, 16, 26512, {1, 3, 3, 11, 21, 45, 117, 75, 399, 523, 889, 2735, 7497, 16271, 12289, 16001}},
    {5334, 16, 26517, {1, 1, 5, 11, 15, 43, 43, 137, 121, 233, 49, 1503, 745, 5545, 22921, 29343}},
    {5335, 16, 26534, {1, 3, 7, 13, 31, 39, 29, 47, 501, 101, 1809, 789, 2429, 5551, 24089, 23067}},
    {5336, 16, 26545, {1, 3, 7, 3, 27, 25, 47, 255, 409, 745, 1217, 1097, 1923, 3279, 26831, 50135}},
    {5337, 16, 26546, {1, 3, 7, 15, 31, 45, 69, 139, 277, 137, 1689, 1613, 237, 8197, 21257, 25227}},
    {5338, 16, 26636, {1, 1, 7, 13, 7, 57, 81, 59, 401, 813, 69, 3029, 3257, 9495, 30819, 32915}},
    {5339, 16, 26749, {1, 3, 1, 3, 1, 57, 39, 101, 107, 795, 1561, 3087, 7935, 5267, 12867, 35753}},
    {5340, 16, 26753, {1, 3, 1, 11, 11, 61, 53, 81, 115, 543, 1451, 339, 4079, 12521, 17597, 27529}},
    {5341, 16, 26759, {1, 1, 1, 3, 19, 47, 37, 185, 69, 901, 107, 227, 951, 13837, 28891, 43699}},
    {5342, 16, 26774, {1, 1, 3, 1, 15, 21, 123, 83, 235, 697, 359, 2035, 5695, 15071, 21203, 59715}},
    {5343, 16, 26789, {1, 3, 5, 11, 29, 11, 83, 133, 145, 1001, 31, 3765, 2167, 9147, 20765, 58469}},
    {5344, 16, 26808, {1, 3, 1, 7, 9, 19, 125, 91, 367, 821, 1079, 2835, 7371, 2571, 13713, 16689}},
    {5345, 16, 26825, {1, 1, 3, 5, 23, 39, 69, 23, 485, 323, 1541, 161, 1753, 1929, 1545, 46159}},
    {5346, 16, 26831, {1, 3, 1, 3, 5, 3, 15, 209, 69, 561, 1179, 3429, 5451, 2217, 7937, 46837}},
    {5347, 16, 26859, {1, 3, 5, 13, 19, 21, 121, 91, 165, 565, 439, 3417, 1285, 197, 15323, 44471}},
    {5348, 16, 26888, {1, 1, 3, 9, 29, 5, 67, 153, 293, 723, 461, 2027, 6299, 3261, 2757, 33933}},
    {5349, 16, 26918, {1, 3, 7, 13, 19, 13, 117, 241, 499, 853, 875, 3883, 4971, 9311, 23441, 52941}},
    {5350, 16, 26929, {1, 1, 7, 3, 7, 15, 117, 149, 419, 609, 1693, 1037, 6713, 14053, 18051, 52921}},
    {5351, 16, 26950, {1, 3, 3, 15, 29, 19, 17, 183, 353, 1007, 355, 353, 7191, 5291, 18777, 317}},
    {5352, 16, 26954, {1, 1, 5, 9, 11, 51, 87, 121, 277, 347, 1579, 3771, 6045, 9459, 17365, 42853}},
    {5353, 16, 26973, {1, 3, 1, 9, 3, 1, 43, 57, 143, 77, 1299, 2209, 4423, 15439, 17131, 5141}},
    {5354, 16, 26997, {1, 1, 7, 15, 11, 7, 47, 207, 473, 199, 621, 199, 1105, 2905, 29133, 46289}},
    {5355, 16, 26998, {1, 3, 7, 1, 27, 9, 61, 237, 151, 175, 1833, 975, 3705, 13865, 161, 9959}},
    {5356, 16, 27008, {1, 3, 3, 13, 17, 15, 45, 183, 331, 1005, 189, 1807, 6213, 9683, 31043, 26361}},
    {5357, 16, 27038, {1, 3, 7, 9, 11, 51, 109, 93, 19, 195, 1543, 637, 7609, 8265, 3797, 25453}},
    {5358, 16, 27109, {1, 1, 5, 3, 25, 3, 17, 125, 79, 957, 1211, 2319, 2303, 6779, 5053, 44201}},
    {5359, 16, 27127, {1, 1, 3, 1, 1, 5, 37, 1, 511, 839, 1449, 223, 2073, 14151, 26987, 54341}},
    {5360, 16, 27150, {1, 3, 5, 1, 21, 15, 29, 55, 501, 439, 583, 2671, 3865, 3541, 26549, 15433}},
    {5361, 16, 27168, {1, 1, 5, 7, 19, 51, 63, 33, 153, 309, 801, 2139, 2763, 12707, 737, 22715}},
    {5362, 16, 27178, {1, 3, 1, 1, 31, 43, 41, 119, 17, 867, 933, 1037, 1569, 7317, 7829, 46831}},
    {5363, 16, 27212, {1, 1, 3, 7, 31, 23, 99, 65, 411, 607, 859, 2191, 2005, 9635, 20117, 26143}},
    {5364, 16, 27224, {1, 3, 1, 9, 29, 47, 103, 121, 197, 283, 1667, 3819, 2521, 3619, 6767, 65431}},
    {5365, 16, 27229, {1, 1, 7, 7, 5, 63, 85, 47, 227, 655, 645, 1425, 6317, 15699, 10293, 43559}},
    {5366, 16, 27246, {1, 3, 1, 7, 21, 3, 123, 3, 429, 427, 61, 1575, 1889, 13849, 31663, 3417}},
    {5367, 16, 27251, {1, 1, 5, 5, 21, 51, 125, 99, 335, 921, 521, 2643, 369, 927, 6295, 8313}},
    {5368, 16, 27257, {1, 1, 5, 5, 1, 29, 1, 217, 193, 137, 1679, 3059, 2191, 2127, 19575, 65105}},
    {5369, 16, 27258, {1, 3, 1, 9, 25, 15, 125, 153, 487, 495, 539, 1957, 7417, 4637, 20827, 12247}},
    {5370, 16, 27260, {1, 1, 7, 15, 19, 17, 103, 77, 85, 695, 1709, 3801, 2451, 3577, 23223, 7029}},
    {5371, 16, 27287, {1, 3, 3, 11, 7, 11, 75, 59, 297, 187, 1745, 653, 127, 16325, 31505, 58949}},
    {5372, 16, 27300, {1, 1, 5, 3, 7, 11, 123, 97, 71, 661, 1909, 789, 7891, 7869, 20033, 43253}},
    {5373, 16, 27315, {1, 1, 5, 13, 7, 57, 15, 173, 501, 965, 1513, 1017, 6411, 14777, 2169, 55501}},
    {5374, 16, 27329, {1, 1, 5, 7, 11, 51, 105, 49, 373, 33, 241, 3285, 5079, 9671, 9557, 12183}},
    {5375, 16, 27332, {1, 3, 5, 13, 1, 21, 55, 145, 123, 837, 1937, 1835, 409, 14945, 4199, 57005}},
    {5376, 16, 27349, {1, 1, 7, 11, 1, 23, 29, 117, 191, 845, 1591, 2417, 355, 7177, 381, 45235}},
    {5377, 16, 27350, {1, 1, 3, 9, 15, 25, 35, 117, 341, 495, 2025, 1801, 743, 6479, 6837, 28541}},
    {5378, 16, 27354, {1, 1, 5, 3, 7, 35, 41, 31, 87, 183, 501, 293, 149, 7359, 27533, 25371}},
    {5379, 16, 27359, {1, 3, 7, 1, 27, 1, 33, 111, 55, 881, 1647, 3533, 6483, 665, 13391, 56135}},
    {5380, 16, 27377, {1, 3, 5, 7, 21, 1, 123, 61, 183, 711, 1875, 2839, 7649, 11835, 23501, 29957}},
    {5381, 16, 27378, {1, 3, 7, 15, 11, 63, 69, 89, 299, 709, 1393, 3959, 823, 16361, 18711, 52127}},
    {5382, 16, 27383, {1, 1, 5, 11, 11, 61, 7, 147, 481, 617, 569, 2821, 5387, 11185, 14017, 21795}},
    {5383, 16, 27384, {1, 3, 3, 13, 3, 53, 113, 87, 181, 927, 1367, 1211, 3993, 6163, 5295, 58503}},
    {5384, 16, 27387, {1, 1, 7, 3, 13, 49, 115, 159, 127, 891, 1755, 3597, 6977, 1547, 2605, 21623}},
    {5385, 16, 27392, {1, 3, 5, 1, 25, 45, 117, 103, 423, 99, 1547, 3065, 7687, 12377, 2127, 7231}},
    {5386, 16, 27402, {1, 1, 1, 7, 19, 45, 91, 215, 333, 189, 1657, 773, 4041, 10225, 7571, 24789}},
    {5387, 16, 27438, {1, 1, 7, 15, 21, 61, 125, 251, 465, 641, 463, 3417, 3851, 3391, 6727, 56879}},
    {5388, 16, 27481, {1, 1, 1, 5, 7, 41, 73, 59, 335, 647, 1927, 209, 5475, 13285, 8009, 1655}},
    {5389, 16, 27482, {1, 1, 3, 7, 19, 21, 105, 121, 323, 267, 927, 2963, 7641, 5857, 24637, 44767}},
    {5390, 16, 27494, {1, 1, 5, 7, 23, 41, 103, 223, 213, 861, 1967, 3853, 6557, 11519, 15623, 1071}},
    {5391, 16, 27531, {1, 3, 5, 11, 17, 59, 53, 209, 485, 815, 233, 875, 677, 3537, 12363, 34297}},
    {5392, 16, 27542, {1, 1, 1, 3, 31, 15, 127, 95, 27, 77, 141, 2689, 6005, 10793, 20719, 63953}},
    {5393, 16, 27546, {1, 1, 5, 13, 1, 13, 3, 97, 185, 785, 725, 483, 3691, 11083, 12003, 56371}},
    {5394, 16, 27564, {1, 1, 3, 3, 1, 25, 109, 113, 309, 309, 23, 3183, 1085, 14311, 8027, 2261}},
    {5395, 16, 27567, {1, 1, 7, 13, 21, 27, 11, 125, 445, 673, 1421, 699, 2975, 1567, 3409, 32833}},
    {5396, 16, 27582, {1, 3, 3, 5, 5, 7, 51, 21, 155, 583, 1079, 4091, 479, 3419, 10973, 10347}},
    {5397, 16, 27608, {1, 3, 5, 11, 25, 7, 63, 243, 115, 625, 1757, 3711, 3631, 9575, 18933, 45129}},
    {5398, 16, 27611, {1, 3, 7, 11, 25, 53, 65, 189, 483, 833, 1019, 3631, 1207, 10473, 20947, 19561}},
    {5399, 16, 27624, {1, 1, 1, 1, 3, 19, 81, 253, 435, 149, 1547, 1979, 3879, 8279, 23175, 21511}},
    {5400, 16, 27629, {1, 1, 3, 11, 13, 47, 117, 229, 101, 57, 215, 1869, 1289, 6599, 32283, 9879}},
    {5401, 16, 27655, {1, 3, 1, 9, 15, 51, 103, 207, 163, 575, 687, 85, 7427, 4813, 31073, 16597}},
    {5402, 16, 27667, {1, 1, 5, 13, 1, 55, 71, 95, 341, 89, 71, 915, 7367, 3397, 9261, 37135}},
    {5403, 16, 27676, {1, 3, 3, 13, 3, 3, 65, 123, 377, 949, 511, 3353, 867, 9385, 6767, 61799}},
    {5404, 16, 27710, {1, 1, 7, 5, 27, 19, 25, 35, 143, 357, 1877, 603, 2267, 1445, 7623, 42775}},
    {5405, 16, 27724, {1, 1, 5, 7, 1, 39, 35, 101, 425, 921, 2033, 1513, 5715, 14347, 22891, 49569}},
    {5406, 16, 27745, {1, 3, 7, 13, 15, 11, 17, 5, 269, 367, 331, 529, 1141, 8597, 15073, 14317}},
    {5407, 16, 27752, {1, 3, 3, 7, 31, 45, 69, 11, 277, 179, 763, 1621, 6301, 14701, 27523, 14713}},
    {5408, 16, 27770, {1, 1, 5, 5, 13, 23, 31, 159, 27, 31, 1229, 2415, 3197, 12219, 30015, 26621}},
    {5409, 16, 27779, {1, 1, 7, 11, 31, 1, 61, 177, 451, 221, 875, 3165, 1379, 9219, 15263, 26273}},
    {5410, 16, 27781, {1, 3, 1, 1, 7, 63, 73, 59, 489, 107, 1071, 2675, 5509, 229, 22641, 42341}},
    {5411, 16, 27791, {1, 1, 1, 5, 23, 57, 19, 153, 339, 767, 1165, 527, 551, 6075, 12183, 33937}},
    {5412, 16, 27809, {1, 1, 5, 15, 27, 25, 29, 15, 339, 625, 73, 427, 7477, 29, 18315, 63343}},
    {5413, 16, 27810, {1, 1, 1, 13, 19, 13, 101, 59, 247, 351, 789, 2987, 4175, 12371, 30557, 58461}},
    {5414, 16, 27815, {1, 1, 3, 5, 21, 41, 1, 121, 153, 829, 77, 1403, 7291, 10841, 28173, 23893}},
    {5415, 16, 27827, {1, 3, 7, 11, 15, 59, 73, 93, 321, 525, 1869, 4039, 4795, 14901, 8827, 27491}},
    {5416, 16, 27834, {1, 1, 1, 9, 31, 49, 71, 95, 63, 269, 29, 2751, 1819, 14495, 29359, 30249}},
    {5417, 16, 27865, {1, 1, 3, 13, 27, 9, 81, 117, 469, 267, 1273, 411, 6235, 5507, 23285, 27471}},
    {5418, 16, 27899, {1, 1, 7, 13, 11, 51, 29, 225, 501, 175, 1779, 879, 6609, 3103, 21611, 57637}},
    {5419, 16, 27901, {1, 1, 7, 3, 25, 49, 109, 247, 365, 275, 979, 413, 6655, 5725, 14665, 28855}},
    {5420, 16, 27914, {1, 3, 1, 13, 23, 9, 13, 185, 491, 139, 3, 2479, 5091, 6475, 27547, 1077}},
    {5421, 16, 27950, {1, 3, 1, 13, 3, 57, 37, 167, 405, 645, 501, 485, 4667, 11137, 7907, 12699}},
    {5422, 16, 27994, {1, 3, 5, 15, 5, 11, 93, 237, 201, 323, 749, 327, 2285, 1137, 31285, 34699}},
    {5423, 16, 28005, {1, 1, 1, 3, 31, 51, 89, 133, 327, 925, 1985, 3067, 7455, 16383, 31849, 16451}},
    {5424, 16, 28009, {1, 3, 7, 1, 1, 61, 95, 159, 57, 575, 2023, 2399, 1745, 13797, 30395, 35379}},
    {5425, 16, 28033, {1, 1, 7, 3, 13, 39, 99, 99, 103, 233, 1141, 3841, 8001, 12363, 13949, 59697}},
    {5426, 16, 28039, {1, 3, 5, 15, 25, 41, 103, 47, 99, 691, 497, 1303, 2157, 7235, 8069, 49213}},
    {5427, 16, 28060, {1, 3, 7, 3, 21, 23, 21, 79, 85, 591, 1093, 3191, 6843, 3301, 1005, 19375}},
    {5428, 16, 28067, {1, 1, 3, 11, 3, 11, 57, 201, 21, 389, 2005, 3699, 281, 14193, 28183, 63355}},
    {5429, 16, 28069, {1, 1, 1, 5, 9, 53, 109, 239, 17, 553, 961, 535, 7337, 3705, 13005, 22333}},
    {5430, 16, 28099, {1, 1, 3, 1, 11, 29, 109, 131, 235, 411, 921, 277, 5691, 5339, 28939, 22849}},
    {5431, 16, 28113, {1, 1, 7, 3, 21, 57, 79, 85, 445, 9, 1771, 217, 6739, 8089, 24961, 51227}},
    {5432, 16, 28114, {1, 1, 1, 9, 29, 5, 83, 195, 473, 865, 569, 1519, 6873, 4155, 14633, 36077}},
    {5433, 16, 28139, {1, 3, 1, 15, 1, 45, 33, 211, 111, 527, 1891, 2957, 5305, 587, 9271, 12497}},
    {5434, 16, 28142, {1, 3, 3, 3, 1, 47, 105, 99, 109, 715, 91, 2671, 6933, 6135, 31793, 56195}},
    {5435, 16, 28153, {1, 3, 3, 7, 27, 7, 123, 57, 507, 393, 87, 1447, 5501, 12005, 10295, 58865}},
    {5436, 16, 28166, {1, 1, 5, 15, 17, 17, 55, 81, 217, 589, 1433, 1877, 7205, 6869, 791, 12749}},
    {5437, 16, 28172, {1, 3, 3, 11, 23, 49, 21, 203, 219, 779, 1791, 2561, 5327, 15541, 19197, 23433}},
    {5438, 16, 28183, {1, 3, 3, 13, 19, 45, 63, 161, 185, 589, 1985, 3205, 4141, 7347, 15117, 18107}},
    {5439, 16, 28194, {1, 3, 1, 15, 23, 7, 15, 31, 467, 163, 1753, 3605, 3753, 487, 18111, 8565}},
    {5440, 16, 28232, {1, 3, 7, 3, 19, 17, 117, 81, 329, 469, 1929, 49, 513, 3553, 28221, 61753}},
    {5441, 16, 28245, {1, 3, 5, 1, 21, 35, 53, 147, 167, 7, 731, 2809, 7669, 9173, 23349, 61741}},
    {5442, 16, 28246, {1, 1, 3, 1, 23, 49, 113, 209, 329, 521, 1643, 3849, 5367, 14679, 6173, 26895}},
    {5443, 16, 28252, {1, 1, 1, 1, 17, 9, 37, 101, 359, 683, 727, 601, 4529, 3323, 32727, 47417}},
    {5444, 16, 28265, {1, 3, 1, 3, 17, 47, 63, 243, 255, 937, 1125, 3079, 5907, 16141, 845, 62495}},
    {5445, 16, 28301, {1, 3, 3, 5, 1, 11, 61, 123, 129, 765, 579, 3209, 133, 7409, 26807, 52769}},
    {5446, 16, 28323, {1, 3, 1, 15, 11, 9, 31, 209, 199, 523, 1977, 1097, 5463, 13003, 1937, 27565}},
    {5447, 16, 28344, {1, 3, 3, 5, 25, 55, 73, 151, 149, 963, 917, 1143, 1591, 16245, 20251, 30981}},
    {5448, 16, 28362, {1, 3, 1, 7, 7, 63, 27, 171, 367, 739, 1215, 4063, 1009, 477, 23319, 64323}},
    {5449, 16, 28400, {1, 1, 3, 13, 3, 7, 9, 225, 501, 419, 479, 2343, 5837, 311, 3895, 61855}},
    {5450, 16, 28417, {1, 3, 7, 9, 21, 57, 55, 233, 269, 9, 2021, 297, 2759, 9145, 7283, 22317}},
    {5451, 16, 28454, {1, 1, 1, 7, 23, 17, 33, 41, 299, 365, 1197, 2445, 1943, 2281, 6757, 3313}},
    {5452, 16, 28466, {1, 1, 3, 1, 7, 13, 19, 19, 345, 523, 1987, 75, 6831, 2857, 27189, 37743}},
    {5453, 16, 28468, {1, 1, 1, 3, 7, 43, 21, 159, 443, 557, 1295, 329, 2649, 11293, 5009, 53245}},
    {5454, 16, 28477, {1, 3, 7, 15, 3, 59, 127, 99, 413, 449, 1475, 2117, 4181, 9819, 32445, 58813}},
    {5455, 16, 28498, {1, 1, 3, 7, 31, 35, 71, 203, 153, 883, 371, 1583, 6743, 1299, 4555, 3083}},
    {5456, 16, 28510, {1, 3, 7, 9, 25, 19, 127, 161, 285, 209, 1523, 1983, 5047, 5093, 23965, 47829}},
    {5457, 16, 28513, {1, 1, 1, 11, 31, 9, 9, 57, 359, 519, 71, 3977, 4591, 16207, 11395, 46097}},
    {5458, 16, 28571, {1, 1, 7, 5, 25, 23, 105, 91, 343, 137, 593, 1181, 797, 1209, 25509, 59635}},
    {5459, 16, 28573, {1, 3, 7, 13, 17, 59, 65, 107, 357, 451, 1967, 193, 1963, 2475, 31425, 33771}},
    {5460, 16, 28578, {1, 3, 1, 13, 15, 11, 57, 227, 331, 847, 121, 1827, 2829, 8727, 10511, 58809}},
    {5461, 16, 28587, {1, 1, 1, 7, 21, 45, 39, 89, 321, 759, 1639, 831, 4363, 9973, 28739, 6629}},
    {5462, 16, 28601, {1, 3, 1, 15, 1, 13, 121, 123, 161, 159, 979, 2679, 3033, 12985, 17243, 26639}},
    {5463, 16, 28646, {1, 1, 3, 15, 25, 43, 77, 215, 467, 469, 595, 2303, 6749, 11273, 1953, 16923}},
    {5464, 16, 28663, {1, 3, 1, 5, 21, 33, 49, 217, 83, 849, 1337, 4037, 5087, 16075, 14555, 23365}},
    {5465, 16, 28681, {1, 3, 7, 1, 19, 29, 93, 27, 471, 525, 1115, 787, 2305, 7039, 1863, 10685}},
    {5466, 16, 28682, {1, 3, 3, 9, 17, 29, 87, 99, 437, 593, 731, 539, 5541, 15731, 24269, 56035}},
    {5467, 16, 28699, {1, 3, 5, 9, 25, 25, 13, 97, 429, 897, 1823, 593, 7125, 975, 6259, 61583}},
    {5468, 16, 28706, {1, 1, 1, 5, 9, 25, 15, 57, 161, 897, 2015, 107, 7769, 291, 32565, 59715}},
    {5469, 16, 28708, {1, 3, 3, 13, 17, 61, 81, 73, 195, 209, 1999, 2653, 1507, 8165, 3999, 42387}},
    {5470, 16, 28717, {1, 3, 5, 15, 17, 35, 113, 25, 167, 799, 939, 1535, 2521, 12887, 11485, 145}},
    {5471, 16, 28720, {1, 1, 1, 3, 5, 47, 113, 133, 351, 3, 1597, 1553, 2465, 9735, 3873, 20427}},
    {5472, 16, 28735, {1, 3, 3, 9, 9, 55, 11, 49, 273, 111, 1553, 1137, 4707, 9517, 32039, 16171}},
    {5473, 16, 28761, {1, 1, 5, 11, 29, 15, 43, 125, 153, 637, 1653, 3867, 5803, 10763, 29041, 5679}},
    {5474, 16, 28783, {1, 3, 3, 9, 21, 49, 1, 25, 27, 483, 1207, 3033, 1007, 10829, 859, 37823}},
    {5475, 16, 28788, {1, 3, 7, 7, 17, 25, 39, 67, 359, 109, 1693, 3821, 1349, 5643, 12987, 48799}},
    {5476, 16, 28811, {1, 3, 5, 3, 27, 33, 69, 19, 153, 163, 85, 3619, 6655, 8007, 9943, 24351}},
    {5477, 16, 28825, {1, 3, 5, 7, 27, 27, 57, 111, 437, 913, 1723, 3373, 4443, 11349, 30823, 28115}},
    {5478, 16, 28838, {1, 1, 7, 15, 21, 11, 55, 121, 63, 997, 679, 15, 2459, 14887, 1489, 35325}},
    {5479, 16, 28850, {1, 1, 7, 5, 31, 27, 25, 201, 511, 359, 1101, 3287, 449, 11385, 10767, 44679}},
    {5480, 16, 28891, {1, 1, 5, 5, 1, 15, 81, 211, 443, 825, 1587, 1975, 6573, 13705, 20421, 5357}},
    {5481, 16, 28897, {1, 3, 7, 7, 7, 59, 11, 213, 75, 1011, 1991, 1317, 4999, 7449, 6687, 16325}},
    {5482, 16, 28932, {1, 3, 7, 13, 3, 29, 83, 71, 191, 349, 1783, 3563, 2617, 6499, 16321, 16307}},
    {5483, 16, 28975, {1, 3, 7, 3, 29, 31, 85, 233, 321, 481, 1499, 1097, 7089, 11395, 22715, 64877}},
    {5484, 16, 28998, {1, 3, 1, 15, 23, 61, 85, 227, 469, 819, 491, 3257, 4379, 5409, 19945, 16939}},
    {5485, 16, 29052, {1, 3, 3, 5, 3, 3, 7, 109, 329, 301, 113, 2695, 3997, 7733, 6983, 49875}},
    {5486, 16, 29090, {1, 3, 7, 5, 1, 25, 37, 77, 169, 381, 559, 1351, 1769, 11617, 19073, 25129}},
    {5487, 16, 29096, {1, 3, 5, 9, 19, 37, 37, 161, 341, 379, 55, 1555, 5171, 4471, 26809, 3183}},
    {5488, 16, 29104, {1, 3, 3, 3, 15, 27, 99, 65, 37, 321, 1613, 1799, 1751, 1709, 23951, 63135}},
    {5489, 16, 29113, {1, 3, 1, 15, 19, 35, 101, 249, 303, 903, 1219, 2631, 5891, 625, 16695, 24017}},
    {5490, 16, 29133, {1, 3, 1, 15, 11, 49, 47, 211, 447, 573, 1397, 1931, 6493, 15457, 12633, 43613}},
    {5491, 16, 29142, {1, 1, 1, 5, 11, 9, 57, 255, 507, 861, 795, 1393, 4065, 4203, 23899, 61461}},
    {5492, 16, 29170, {1, 3, 7, 13, 25, 3, 31, 19, 111, 917, 1037, 1407, 5541, 7211, 29603, 64445}},
    {5493, 16, 29192, {1, 1, 1, 5, 19, 15, 121, 143, 183, 121, 1493, 3023, 2729, 3689, 5753, 4593}},
    {5494, 16, 29221, {1, 1, 1, 1, 31, 45, 31, 177, 209, 765, 885, 105, 8089, 2689, 11413, 24169}},
    {5495, 16, 29236, {1, 3, 5, 13, 25, 63, 13, 137, 29, 571, 2019, 57, 3739, 12903, 23367, 15197}},
    {5496, 16, 29246, {1, 1, 3, 11, 3, 41, 21, 247, 425, 155, 2025, 1925, 91, 10841, 17613, 22387}},
    {5497, 16, 29293, {1, 1, 5, 9, 31, 25, 43, 39, 103, 623, 1239, 3019, 4501, 9537, 2421, 29805}},
    {5498, 16, 29305, {1, 3, 3, 9, 7, 63, 25, 145, 71, 1001, 185, 2345, 5611, 1487, 22527, 11633}},
    {5499, 16, 29312, {1, 1, 1, 3, 5, 9, 35, 209, 17, 171, 745, 4031, 8039, 3915, 15357, 43335}},
    {5500, 16, 29339, {1, 1, 7, 5, 17, 17, 71, 5, 83, 509, 895, 593, 2579, 7495, 11377, 22487}},
    {5501, 16, 29365, {1, 1, 1, 9, 29, 37, 75, 169, 331, 895, 257, 4083, 7975, 11907, 23631, 32221}},
    {5502, 16, 29389, {1, 1, 1, 9, 21, 9, 59, 191, 317, 161, 577, 1901, 3723, 8029, 2517, 7005}},
    {5503, 16, 29402, {1, 1, 3, 13, 31, 35, 23, 7, 445, 591, 301, 2561, 5527, 9699, 2063, 24845}},
    {5504, 16, 29423, {1, 1, 7, 5, 3, 7, 89, 237, 457, 365, 1927, 675, 4545, 8757, 23297, 15857}},
    {5505, 16, 29443, {1, 3, 5, 11, 3, 25, 35, 95, 341, 215, 85, 4021, 7089, 9401, 22057, 61373}},
    {5506, 16, 29445, {1, 3, 7, 5, 9, 15, 19, 57, 107, 489, 1543, 1387, 6663, 2437, 27261, 21441}},
    {5507, 16, 29463, {1, 3, 1, 5, 9, 5, 119, 215, 41, 519, 1721, 1181, 4427, 6605, 14839, 48613}},
    {5508, 16, 29473, {1, 3, 1, 9, 7, 7, 73, 17, 49, 833, 487, 2091, 4579, 8983, 26833, 37611}},
    {5509, 16, 29493, {1, 1, 7, 3, 25, 23, 101, 11, 23, 259, 1161, 4011, 6833, 9769, 21639, 55529}},
    {5510, 16, 29506, {1, 3, 5, 1, 17, 25, 35, 141, 325, 737, 41, 559, 5255, 3007, 31421, 29803}},
    {5511, 16, 29518, {1, 1, 3, 11, 11, 45, 79, 179, 385, 201, 629, 2491, 2301, 10545, 18341, 28097}},
    {5512, 16, 29532, {1, 3, 3, 7, 9, 29, 61, 193, 265, 609, 341, 3361, 3755, 1747, 4333, 33059}},
    {5513, 16, 29560, {1, 3, 1, 11, 1, 17, 109, 19, 409, 767, 1445, 159, 4841, 12693, 5079, 62337}},
    {5514, 16, 29590, {1, 1, 7, 3, 23, 5, 111, 133, 427, 529, 297, 1939, 1887, 8469, 26853, 9599}},
    {5515, 16, 29594, {1, 3, 3, 7, 13, 25, 99, 55, 301, 917, 805, 2377, 5747, 4395, 11173, 18965}},
    {5516, 16, 29637, {1, 3, 7, 13, 17, 29, 127, 123, 55, 615, 1841, 2645, 5985, 9261, 21767, 43765}},
    {5517, 16, 29647, {1, 3, 7, 7, 27, 9, 3, 153, 329, 895, 1467, 1917, 3819, 10235, 22037, 32593}},
    {5518, 16, 29650, {1, 3, 5, 9, 19, 63, 3, 15, 69, 943, 295, 2995, 4043, 4341, 24435, 24185}},
    {5519, 16, 29655, {1, 3, 1, 15, 15, 11, 51, 233, 181, 401, 1411, 3165, 7473, 14159, 217, 46431}},
    {5520, 16, 29661, {1, 3, 1, 3, 17, 3, 115, 191, 335, 325, 1657, 3851, 5007, 4169, 18955, 44017}},
    {5521, 16, 29680, {1, 3, 1, 7, 5, 61, 15, 195, 81, 761, 917, 2185, 1159, 3899, 4289, 9373}},
    {5522, 16, 29721, {1, 3, 1, 1, 1, 55, 17, 37, 325, 103, 101, 3885, 4775, 1325, 5277, 37879}},
    {5523, 16, 29751, {1, 1, 3, 1, 25, 7, 61, 115, 271, 617, 309, 1927, 6709, 6913, 6463, 57441}},
    {5524, 16, 29755, {1, 3, 7, 9, 3, 19, 33, 19, 27, 533, 291, 1239, 5147, 6989, 26185, 47083}},
    {5525, 16, 29760, {1, 3, 3, 15, 19, 15, 39, 247, 413, 303, 1219, 2411, 4505, 10853, 659, 23361}},
    {5526, 16, 29772, {1, 1, 7, 3, 11, 55, 99, 63, 391, 267, 1201, 737, 617, 12213, 25179, 659}},
    {5527, 16, 29778, {1, 3, 3, 1, 29, 5, 73, 243, 33, 715, 433, 1849, 3537, 15723, 31771, 19661}},
    {5528, 16, 29799, {1, 1, 1, 7, 13, 31, 63, 77, 463, 721, 1243, 1045, 249, 8461, 2991, 41735}},
    {5529, 16, 29824, {1, 1, 7, 3, 17, 7, 27, 81, 347, 113, 1037, 219, 6839, 15935, 12767, 37909}},
    {5530, 16, 29841, {1, 3, 7, 13, 7, 61, 63, 191, 79, 175, 2007, 1111, 57, 7173, 27197, 24867}},
    {5531, 16, 29842, {1, 1, 3, 5, 1, 59, 117, 245, 349, 753, 265, 887, 499, 7383, 15295, 63393}},
    {5532, 16, 29853, {1, 1, 5, 5, 27, 1, 59, 67, 473, 413, 1209, 3423, 5635, 14131, 6593, 5155}},
    {5533, 16, 29867, {1, 3, 1, 15, 7, 3, 25, 17, 463, 525, 1683, 1569, 5379, 7115, 18355, 45063}},
    {5534, 16, 29949, {1, 3, 7, 11, 3, 1, 53, 61, 279, 505, 1787, 735, 8055, 5187, 19063, 60423}},
    {5535, 16, 29950, {1, 3, 5, 5, 31, 49, 85, 49, 357, 195, 1759, 2085, 2971, 13323, 9733, 51119}},
    {5536, 16, 29964, {1, 3, 7, 11, 3, 25, 33, 195, 61, 995, 1777, 1477, 519, 12535, 1827, 31207}},
    {5537, 16, 29967, {1, 1, 1, 11, 25, 41, 29, 73, 435, 143, 233, 1591, 1799, 5731, 19129, 34949}},
    {5538, 16, 29985, {1, 1, 7, 5, 23, 43, 35, 17, 225, 523, 955, 3063, 7637, 1039, 15719, 46721}},
    {5539, 16, 29992, {1, 1, 3, 3, 9, 43, 93, 155, 339, 295, 857, 343, 7887, 6955, 17457, 57095}},
    {5540, 16, 30000, {1, 3, 7, 3, 5, 27, 55, 127, 221, 897, 11, 2711, 2069, 15553, 15981, 55207}},
    {5541, 16, 30020, {1, 3, 3, 1, 3, 61, 79, 187, 461, 103, 1427, 1839, 7905, 11691, 1849, 21867}},
    {5542, 16, 30024, {1, 1, 1, 3, 7, 63, 115, 249, 363, 649, 1453, 2057, 1523, 12111, 8199, 49453}},
    {5543, 16, 30030, {1, 3, 1, 1, 21, 7, 11, 207, 383, 701, 687, 3363, 4719, 15325, 28257, 63617}},
    {5544, 16, 30066, {1, 3, 1, 11, 11, 49, 51, 79, 445, 421, 1063, 555, 177, 2183, 17223, 6487}},
    {5545, 16, 30071, {1, 3, 1, 9, 5, 33, 5, 33, 233, 359, 287, 3633, 6277, 6643, 22911, 41069}},
    {5546, 16, 30078, {1, 3, 3, 13, 27, 61, 111, 71, 133, 475, 1289, 2317, 787, 16117, 32737, 12027}},
    {5547, 16, 30082, {1, 3, 7, 1, 7, 15, 101, 165, 279, 55, 1461, 97, 4159, 10589, 2237, 24315}},
    {5548, 16, 30096, {1, 3, 3, 11, 27, 3, 23, 221, 325, 39, 227, 3445, 3735, 10711, 23805, 7317}},
    {5549, 16, 30101, {1, 1, 3, 3, 3, 47, 117, 165, 439, 127, 1547, 823, 3143, 7149, 45, 37901}},
    {5550, 16, 30102, {1, 3, 5, 5, 27, 23, 105, 191, 79, 821, 1077, 3681, 431, 1887, 11615, 17057}},
    {5551, 16, 30122, {1, 1, 3, 11, 11, 57, 23, 225, 319, 915, 323, 1197, 4109, 4223, 8701, 32135}},
    {5552, 16, 30141, {1, 1, 3, 5, 9, 41, 51, 97, 233, 249, 31, 387, 7103, 4377, 2943, 46655}},
    {5553, 16, 30159, {1, 3, 7, 3, 17, 29, 51, 203, 17, 507, 461, 3617, 7105, 12039, 6037, 16843}},
    {5554, 16, 30168, {1, 3, 3, 5, 11, 43, 33, 239, 43, 465, 1925, 2161, 6819, 7091, 15645, 64149}},
    {5555, 16, 30177, {1, 1, 5, 13, 15, 51, 87, 69, 93, 1015, 451, 687, 7329, 12137, 9643, 36399}},
    {5556, 16, 30183, {1, 1, 1, 5, 3, 25, 19, 99, 365, 563, 299, 2995, 1873, 1203, 21797, 15123}},
    {5557, 16, 30197, {1, 1, 5, 1, 15, 43, 53, 239, 329, 47, 959, 2205, 4401, 10125, 30397, 62145}},
    {5558, 16, 30213, {1, 1, 1, 3, 13, 55, 49, 37, 77, 391, 1729, 1379, 1259, 6619, 27685, 47891}},
    {5559, 16, 30231, {1, 1, 3, 13, 27, 43, 47, 57, 315, 733, 1829, 2887, 5483, 14965, 28131, 7985}},
    {5560, 16, 30232, {1, 3, 3, 5, 15, 43, 85, 135, 453, 373, 1813, 331, 5777, 11649, 14451, 13577}},
    {5561, 16, 30241, {1, 1, 1, 5, 25, 13, 13, 135, 33, 263, 1793, 3713, 2135, 5173, 15033, 61357}},
    {5562, 16, 30253, {1, 1, 1, 7, 7, 47, 71, 167, 45, 681, 775, 1583, 1119, 7503, 7825, 11445}},
    {5563, 16, 30259, {1, 1, 7, 3, 29, 11, 53, 241, 65, 647, 1725, 1385, 1135, 15311, 18961, 28489}},
    {5564, 16, 30262, {1, 1, 5, 7, 13, 57, 23, 67, 179, 499, 719, 735, 2425, 13287, 17109, 57747}},
    {5565, 16, 30268, {1, 3, 5, 9, 5, 43, 125, 57, 491, 57, 13, 841, 5371, 3685, 10289, 56333}},
    {5566, 16, 30297, {1, 1, 5, 3, 17, 7, 15, 177, 87, 297, 923, 733, 997, 3403, 1149, 10573}},
    {5567, 16, 30316, {1, 3, 1, 15, 21, 63, 47, 147, 431, 855, 2021, 3807, 4261, 14871, 31605, 3983}},
    {5568, 16, 30322, {1, 3, 5, 5, 11, 9, 69, 15, 133, 95, 625, 3307, 3209, 5609, 14231, 28975}},
    {5569, 16, 30344, {1, 1, 5, 11, 29, 61, 69, 119, 155, 879, 1041, 3907, 5349, 1739, 9121, 63167}},
    {5570, 16, 30350, {1, 3, 5, 3, 1, 31, 45, 175, 311, 527, 853, 913, 1917, 15379, 30333, 38191}},
    {5571, 16, 30355, {1, 1, 3, 1, 23, 17, 107, 197, 433, 813, 681, 1497, 5035, 2243, 15613, 19345}},
    {5572, 16, 30429, {1, 3, 5, 7, 7, 5, 39, 221, 169, 193, 1115, 579, 4451, 5139, 25461, 1939}},
    {5573, 16, 30445, {1, 3, 5, 1, 17, 9, 17, 99, 253, 551, 1507, 2535, 7753, 2947, 3119, 59079}},
    {5574, 16, 30477, {1, 1, 5, 15, 15, 31, 73, 27, 231, 99, 1673, 3763, 4027, 3831, 10045, 3693}},
    {5575, 16, 30513, {1, 1, 5, 1, 19, 37, 95, 201, 53, 347, 1381, 1769, 5627, 8723, 4169, 3229}},
    {5576, 16, 30520, {1, 1, 5, 1, 13, 5, 17, 11, 281, 699, 191, 333, 4173, 6301, 24145, 16093}},
    {5577, 16, 30540, {1, 1, 5, 3, 19, 33, 15, 97, 319, 177, 1277, 1233, 4567, 15111, 11559, 64953}},
    {5578, 16, 30551, {1, 3, 1, 5, 21, 31, 35, 93, 505, 189, 1343, 801, 6103, 11165, 27139, 49069}},
    {5579, 16, 30573, {1, 1, 5, 15, 31, 61, 79, 87, 15, 217, 907, 2181, 1805, 195, 31807, 2967}},
    {5580, 16, 30609, {1, 3, 7, 1, 19, 5, 73, 185, 71, 51, 1551, 971, 3025, 12465, 26135, 1121}},
    {5581, 16, 30622, {1, 3, 3, 13, 13, 3, 79, 119, 477, 375, 1177, 311, 5739, 10465, 8983, 60543}},
    {5582, 16, 30635, {1, 1, 1, 7, 17, 45, 83, 7, 413, 987, 143, 3213, 2849, 3755, 14555, 35047}},
    {5583, 16, 30658, {1, 1, 3, 5, 15, 9, 39, 137, 425, 899, 1225, 3947, 4391, 3125, 13093, 24931}},
    {5584, 16, 30667, {1, 1, 7, 9, 5, 39, 85, 113, 301, 967, 1045, 1971, 6485, 4245, 2815, 2923}},
    {5585, 16, 30681, {1, 3, 3, 7, 11, 5, 83, 115, 291, 541, 1171, 3481, 7257, 9885, 5951, 24615}},
    {5586, 16, 30684, {1, 3, 3, 9, 25, 41, 111, 249, 169, 273, 1987, 2303, 607, 8503, 32597, 51155}},
    {5587, 16, 30703, {1, 1, 5, 9, 19, 1, 87, 41, 241, 921, 33, 433, 4899, 9887, 23865, 38505}},
    {5588, 16, 30705, {1, 3, 1, 9, 25, 39, 31, 129, 431, 229, 1173, 4079, 3379, 11495, 23861, 23483}},
    {5589, 16, 30715, {1, 1, 5, 13, 21, 27, 35, 129, 239, 797, 957, 977, 3745, 11137, 5611, 58123}},
    {5590, 16, 30742, {1, 1, 1, 5, 3, 53, 21, 49, 91, 855, 1389, 2913, 11, 10961, 26447, 17637}},
    {5591, 16, 30748, {1, 1, 5, 15, 19, 53, 33, 235, 147, 273, 1089, 1607, 1863, 1017, 8831, 65235}},
    {5592, 16, 30758, {1, 3, 1, 15, 5, 11, 59, 131, 101, 219, 1587, 3949, 6555, 12507, 2289, 64497}},
    {5593, 16, 30767, {1, 3, 7, 5, 29, 29, 35, 11, 201, 627, 445, 883, 7523, 12109, 22797, 403}},
    {5594, 16, 30770, {1, 1, 5, 13, 17, 53, 61, 25, 243, 273, 1667, 325, 1537, 6661, 751, 47699}},
    {5595, 16, 30772, {1, 3, 7, 1, 19, 17, 127, 129, 117, 283, 1761, 627, 265, 335, 28215, 10181}},
    {5596, 16, 30807, {1, 3, 7, 1, 23, 33, 15, 137, 91, 165, 1559, 363, 3167, 11087, 30221, 27619}},
    {5597, 16, 30814, {1, 1, 5, 7, 1, 31, 73, 35, 247, 901, 1699, 765, 7149, 2311, 3071, 6601}},
    {5598, 16, 30824, {1, 3, 3, 5, 31, 23, 117, 71, 75, 875, 931, 4041, 423, 10969, 23327, 58455}},
    {5599, 16, 30857, {1, 3, 1, 3, 9, 49, 45, 105, 415, 707, 1023, 2773, 7451, 2333, 8477, 30279}},
    {5600, 16, 30875, {1, 1, 7, 15, 25, 57, 77, 167, 187, 769, 1537, 1477, 1403, 2419, 30729, 40319}},
    {5601, 16, 30931, {1, 3, 3, 13, 5, 39, 77, 209, 463, 257, 1187, 3283, 4541, 7921, 4071, 52337}},
    {5602, 16, 30933, {1, 1, 5, 13, 13, 13, 63, 105, 345, 381, 1341, 209, 3057, 3683, 14739, 62387}},
    {5603, 16, 30949, {1, 3, 1, 11, 19, 15, 125, 127, 377, 561, 1997, 2825, 2791, 4963, 14699, 11521}},
    {5604, 16, 30953, {1, 3, 7, 7, 11, 39, 29, 219, 57, 1003, 1349, 57, 6437, 14001, 7631, 22945}},
    {5605, 16, 30982, {1, 1, 5, 15, 29, 25, 65, 209, 61, 787, 545, 1939, 5669, 3885, 2199, 20569}},
    {5606, 16, 31010, {1, 1, 3, 7, 15, 41, 113, 11, 365, 587, 1005, 1377, 4877, 5657, 30219, 25003}},
    {5607, 16, 31012, {1, 3, 1, 1, 19, 5, 87, 183, 49, 719, 1851, 2583, 5731, 3157, 18709, 50357}},
    {5608, 16, 31039, {1, 1, 3, 13, 17, 29, 117, 85, 63, 221, 801, 2515, 2755, 13347, 7993, 41761}},
    {5609, 16, 31041, {1, 3, 3, 7, 15, 49, 73, 43, 211, 567, 281, 15, 5083, 5899, 5339, 31947}},
    {5610, 16, 31061, {1, 3, 7, 1, 19, 11, 101, 71, 213, 975, 1203, 2519, 2257, 11467, 27027, 58941}},
    {5611, 16, 31082, {1, 1, 3, 7, 1, 1, 53, 1, 129, 207, 1661, 3267, 3819, 10129, 31059, 49825}},
    {5612, 16, 31087, {1, 3, 7, 13, 9, 17, 5, 43, 33, 697, 63, 3241, 11, 5953, 29269, 55901}},
    {5613, 16, 31096, {1, 1, 3, 13, 5, 11, 29, 173, 461, 593, 891, 3115, 2737, 5451, 12365, 30615}},
    {5614, 16, 31115, {1, 3, 3, 1, 17, 63, 123, 119, 391, 387, 1751, 2309, 3879, 5553, 6515, 63275}},
    {5615, 16, 31130, {1, 1, 7, 13, 5, 19, 23, 125, 57, 931, 683, 1799, 1731, 3125, 7413, 46643}},
    {5616, 16, 31168, {1, 3, 5, 3, 11, 43, 37, 25, 113, 305, 65, 4083, 321, 15615, 17865, 21507}},
    {5617, 16, 31171, {1, 3, 3, 3, 19, 19, 1, 57, 147, 241, 1357, 3993, 1321, 5949, 1671, 14605}},
    {5618, 16, 31177, {1, 3, 5, 13, 25, 25, 123, 19, 341, 811, 795, 3689, 6933, 10389, 23443, 45771}},
    {5619, 16, 31180, {1, 3, 3, 3, 29, 43, 43, 119, 11, 977, 1799, 1247, 4447, 9605, 26159, 47563}},
    {5620, 16, 31191, {1, 1, 7, 1, 5, 47, 63, 233, 407, 627, 1835, 3257, 2109, 3259, 6347, 15309}},
    {5621, 16, 31207, {1, 1, 7, 7, 13, 7, 85, 161, 5, 393, 641, 1149, 6653, 7561, 24113, 27877}},
    {5622, 16, 31247, {1, 1, 7, 1, 11, 1, 19, 231, 27, 339, 2045, 3363, 2415, 4555, 4321, 1587}},
    {5623, 16, 31249, {1, 1, 3, 13, 25, 45, 35, 3, 425, 271, 379, 3775, 5313, 1953, 8991, 9227}},
    {5624, 16, 31285, {1, 3, 7, 3, 3, 43, 43, 203, 453, 665, 1581, 1685, 4811, 2657, 3275, 65203}},
    {5625, 16, 31303, {1, 1, 5, 5, 13, 61, 7, 227, 235, 1017, 1315, 2923, 1425, 3809, 31001, 19571}},
    {5626, 16, 31310, {1, 1, 5, 13, 1, 15, 63, 107, 133, 19, 1323, 1921, 401, 14987, 8397, 48011}},
    {5627, 16, 31337, {1, 1, 7, 13, 27, 21, 13, 91, 179, 749, 1555, 1377, 5575, 5487, 15105, 65223}},
    {5628, 16, 31352, {1, 1, 5, 11, 15, 55, 73, 225, 269, 569, 1401, 3461, 3241, 3505, 7437, 32695}},
    {5629, 16, 31357, {1, 3, 1, 1, 5, 11, 73, 13, 423, 631, 627, 487, 6917, 10291, 18853, 16523}},
    {5630, 16, 31374, {1, 1, 7, 13, 17, 49, 73, 75, 171, 535, 1145, 2627, 2023, 233, 32119, 30925}},
    {5631, 16, 31379, {1, 1, 3, 9, 29, 61, 15, 111, 1, 967, 1369, 2253, 8053, 10463, 533, 19539}},
    {5632, 16, 31388, {1, 1, 1, 9, 19, 33, 37, 207, 305, 61, 919, 2231, 7811, 15413, 31991, 38663}},
    {5633, 16, 31410, {1, 3, 7, 13, 17, 41, 39, 175, 385, 217, 533, 3155, 7215, 11553, 25875, 49201}},
    {5634, 16, 31416, {1, 1, 7, 1, 5, 13, 91, 211, 85, 347, 1273, 3501, 1487, 8635, 13411, 57705}},
    {5635, 16, 31467, {1, 1, 3, 15, 23, 43, 47, 89, 447, 883, 637, 2597, 7089, 15249, 3111, 2161}},
    {5636, 16, 31495, {1, 3, 5, 7, 3, 53, 33, 3, 17, 215, 817, 3505, 1605, 10957, 27687, 13403}},
    {5637, 16, 31504, {1, 1, 1, 15, 17, 19, 113, 13, 243, 323, 1807, 1605, 3437, 10159, 6195, 12241}},
    {5638, 16, 31507, {1, 1, 3, 3, 1, 37, 87, 245, 353, 803, 91, 367, 4977, 11779, 8437, 9587}},
    {5639, 16, 31509, {1, 1, 3, 3, 11, 63, 99, 243, 339, 383, 1339, 1717, 2977, 1685, 20603, 3189}},
    {5640, 16, 31514, {1, 3, 3, 13, 15, 9, 47, 49, 483, 749, 867, 1105, 1141, 14733, 475, 33869}},
    {5641, 16, 31516, {1, 1, 5, 3, 29, 11, 41, 121, 491, 627, 1607, 837, 8099, 727, 8317, 60023}},
    {5642, 16, 31530, {1, 1, 7, 5, 23, 13, 99, 115, 25, 943, 873, 3495, 3351, 12773, 29753, 51943}},
    {5643, 16, 31555, {1, 3, 1, 15, 13, 49, 79, 23, 501, 329, 223, 3467, 3547, 849, 21621, 24639}},
    {5644, 16, 31567, {1, 3, 5, 11, 19, 27, 19, 195, 235, 67, 1337, 3347, 4509, 7431, 12165, 19685}},
    {5645, 16, 31570, {1, 3, 7, 9, 21, 39, 127, 69, 41, 29, 1551, 399, 5485, 5631, 11723, 39035}},
    {5646, 16, 31586, {1, 3, 1, 3, 29, 53, 89, 107, 215, 851, 785, 759, 2597, 105, 31185, 24995}},
    {5647, 16, 31598, {1, 3, 1, 11, 23, 21, 101, 207, 401, 77, 1009, 691, 1637, 9385, 27961, 57901}},
    {5648, 16, 31605, {1, 3, 5, 5, 3, 29, 93, 139, 79, 537, 1519, 743, 5735, 1705, 28063, 4935}},
    {5649, 16, 31609, {1, 1, 5, 3, 25, 33, 109, 137, 285, 289, 1475, 253, 7861, 14081, 12275, 60701}},
    {5650, 16, 31612, {1, 1, 1, 11, 3, 7, 9, 117, 469, 903, 303, 3149, 4743, 6593, 30037, 21347}},
    {5651, 16, 31626, {1, 3, 1, 5, 19, 59, 13, 253, 407, 31, 207, 1069, 191, 849, 4849, 58141}},
    {5652, 16, 31634, {1, 1, 7, 5, 17, 15, 21, 73, 41, 333, 231, 1771, 4429, 9365, 24849, 57355}},
    {5653, 16, 31655, {1, 3, 7, 15, 7, 5, 85, 143, 1, 665, 581, 939, 2159, 2377, 17411, 33169}},
    {5654, 16, 31681, {1, 3, 3, 9, 15, 29, 45, 175, 45, 477, 2037, 2031, 3231, 1659, 13641, 25111}},
    {5655, 16, 31705, {1, 1, 3, 13, 15, 45, 65, 209, 269, 353, 603, 2007, 7771, 445, 2277, 54885}},
    {5656, 16, 31706, {1, 3, 3, 13, 15, 25, 67, 73, 175, 265, 187, 3333, 6685, 12551, 1127, 37997}},
    {5657, 16, 31718, {1, 3, 3, 15, 13, 57, 37, 237, 459, 685, 731, 929, 6015, 15279, 31501, 41093}},
    {5658, 16, 31735, {1, 1, 5, 3, 19, 47, 35, 117, 239, 447, 1761, 2097, 3175, 6691, 30291, 36511}},
    {5659, 16, 31741, {1, 3, 7, 1, 11, 17, 27, 241, 133, 899, 509, 1533, 6045, 6695, 24791, 595}},
    {5660, 16, 31744, {1, 1, 5, 9, 31, 7, 65, 125, 267, 847, 667, 133, 4509, 9933, 16619, 10465}},
    {5661, 16, 31762, {1, 3, 7, 13, 1, 5, 73, 189, 443, 659, 993, 621, 3389, 1, 16411, 43659}},
    {5662, 16, 31774, {1, 1, 7, 7, 29, 15, 45, 107, 145, 787, 1991, 2567, 2099, 10629, 11357, 16063}},
    {5663, 16, 31864, {1, 3, 5, 9, 5, 21, 107, 1, 317, 875, 1513, 1663, 2953, 11471, 4875, 13341}},
    {5664, 16, 31874, {1, 3, 7, 7, 13, 55, 61, 185, 315, 103, 1415, 237, 4653, 13089, 8973, 31153}},
    {5665, 16, 31900, {1, 1, 7, 13, 3, 19, 21, 53, 427, 313, 1771, 31, 3425, 6745, 1909, 14501}},
    {5666, 16, 31910, {1, 3, 7, 1, 15, 19, 59, 127, 95, 671, 429, 255, 8075, 2867, 29125, 10237}},
    {5667, 16, 31928, {1, 1, 5, 7, 15, 53, 81, 203, 243, 697, 921, 865, 5407, 4283, 14643, 25287}},
    {5668, 16, 31965, {1, 3, 5, 9, 27, 19, 123, 37, 137, 849, 1567, 2587, 4721, 13519, 7843, 40165}},
    {5669, 16, 31976, {1, 3, 7, 1, 3, 3, 39, 159, 183, 263, 1953, 829, 1897, 533, 6347, 59633}},
    {5670, 16, 32016, {1, 3, 1, 11, 15, 7, 29, 145, 317, 347, 1675, 3841, 4485, 2793, 18229, 44739}},
    {5671, 16, 32032, {1, 3, 3, 11, 21, 43, 17, 113, 11, 225, 1475, 2293, 7167, 5543, 2273, 34681}},
    {5672, 16, 32037, {1, 1, 1, 1, 7, 55, 69, 69, 177, 433, 509, 2865, 537, 229, 14317, 63853}},
    {5673, 16, 32062, {1, 1, 5, 15, 21, 29, 5, 19, 363, 567, 1363, 2623, 6789, 10449, 1717, 60455}},
    {5674, 16, 32069, {1, 3, 7, 3, 25, 45, 47, 73, 293, 749, 877, 1323, 6055, 1111, 4945, 21843}},
    {5675, 16, 32115, {1, 3, 1, 5, 13, 53, 43, 205, 487, 479, 845, 1145, 2037, 213, 16113, 26127}},
    {5676, 16, 32128, {1, 1, 1, 9, 19, 43, 33, 135, 81, 639, 1289, 2165, 6259, 11099, 26387, 58997}},
    {5677, 16, 32171, {1, 1, 7, 5, 19, 27, 41, 205, 47, 903, 931, 3837, 3597, 7431, 22907, 34441}},
    {5678, 16, 32173, {1, 3, 3, 13, 17, 33, 41, 1, 471, 431, 1805, 2647, 1113, 4665, 9899, 39695}},
    {5679, 16, 32182, {1, 1, 1, 3, 11, 45, 55, 115, 495, 711, 1125, 2771, 1909, 13613, 7309, 44131}},
    {5680, 16, 32191, {1, 3, 1, 3, 31, 3, 45, 49, 251, 567, 253, 2787, 7565, 12813, 7949, 64019}},
    {5681, 16, 32193, {1, 1, 1, 1, 3, 11, 105, 195, 71, 403, 1733, 1539, 5113, 751, 4483, 33549}},
    {5682, 16, 32194, {1, 1, 3, 15, 27, 53, 21, 97, 161, 791, 1519, 2513, 2181, 15221, 31391, 6545}},
    {5683, 16, 32229, {1, 3, 1, 13, 7, 63, 53, 135, 405, 495, 1381, 1207, 6653, 279, 28197, 46783}},
    {5684, 16, 32230, {1, 1, 1, 5, 25, 55, 85, 221, 11, 279, 1171, 2581, 611, 7805, 28401, 14741}},
    {5685, 16, 32248, {1, 1, 3, 5, 19, 57, 3, 189, 25, 565, 283, 1951, 1349, 617, 6287, 20609}},
    {5686, 16, 32263, {1, 3, 5, 7, 21, 27, 51, 173, 133, 861, 1853, 2533, 6785, 1451, 24053, 32717}},
    {5687, 16, 32264, {1, 3, 7, 7, 15, 23, 93, 161, 509, 533, 1017, 3959, 3427, 13423, 8207, 59933}},
    {5688, 16, 32269, {1, 3, 3, 13, 9, 19, 9, 179, 101, 559, 1775, 909, 4583, 8925, 12607, 20763}},
    {5689, 16, 32298, {1, 1, 3, 5, 1, 53, 63, 7, 493, 873, 1129, 3849, 141, 12289, 9035, 11341}},
    {5690, 16, 32335, {1, 3, 3, 7, 21, 49, 23, 33, 449, 377, 1665, 3619, 5401, 13183, 5149, 10387}},
    {5691, 16, 32340, {1, 1, 1, 9, 27, 33, 73, 89, 143, 129, 1321, 2997, 891, 13831, 23275, 48177}},
    {5692, 16, 32356, {1, 3, 7, 13, 15, 53, 63, 237, 5, 499, 1693, 387, 2093, 3075, 18431, 2649}},
    {5693, 16, 32374, {1, 1, 1, 15, 5, 49, 107, 171, 453, 917, 1085, 683, 3091, 7169, 6705, 51925}},
    {5694, 16, 32390, {1, 1, 3, 15, 13, 17, 119, 237, 281, 401, 1381, 257, 6997, 1965, 5961, 50879}},
    {5695, 16, 32401, {1, 3, 7, 1, 23, 13, 61, 201, 469, 441, 799, 1409, 3241, 6443, 3955, 24713}},
    {5696, 16, 32414, {1, 1, 3, 15, 25, 3, 59, 187, 355, 953, 1555, 3795, 4685, 1981, 31219, 32335}},
    {5697, 16, 32417, {1, 3, 3, 13, 9, 5, 39, 101, 179, 347, 1189, 175, 843, 9647, 18329, 41379}},
    {5698, 16, 32442, {1, 1, 7, 5, 25, 17, 103, 19, 295, 171, 1993, 2033, 2373, 11357, 25701, 765}},
    {5699, 16, 32450, {1, 1, 3, 7, 17, 7, 121, 213, 153, 359, 587, 47, 3841, 16121, 27205, 46613}},
    {5700, 16, 32461, {1, 3, 7, 7, 17, 49, 71, 111, 319, 777, 1935, 2515, 2969, 13577, 10791, 30889}},
    {5701, 16, 32473, {1, 1, 1, 15, 17, 45, 37, 237, 355, 555, 1945, 1633, 395, 2617, 15449, 33445}},
    {5702, 16, 32479, {1, 1, 7, 13, 19, 57, 33, 67, 129, 859, 311, 3823, 4639, 15183, 1325, 47215}},
    {5703, 16, 32530, {1, 3, 3, 3, 13, 25, 33, 57, 265, 879, 1555, 1589, 7639, 16149, 29711, 11267}},
    {5704, 16, 32536, {1, 3, 7, 9, 29, 37, 43, 201, 87, 707, 1769, 347, 2807, 12197, 32059, 50371}},
    {5705, 16, 32548, {1, 3, 1, 9, 1, 7, 35, 35, 65, 433, 1073, 3239, 2213, 8613, 12339, 1609}},
    {5706, 16, 32577, {1, 3, 1, 3, 3, 55, 125, 93, 105, 317, 963, 3131, 7315, 10555, 911, 45669}},
    {5707, 16, 32628, {1, 3, 7, 15, 9, 25, 29, 107, 129, 545, 993, 3203, 2447, 13237, 5951, 18927}},
    {5708, 16, 32642, {1, 1, 1, 7, 31, 9, 97, 147, 85, 61, 767, 807, 4857, 10567, 4349, 45203}},
    {5709, 16, 32665, {1, 3, 5, 15, 5, 25, 13, 79, 479, 745, 1591, 2871, 1157, 6341, 12733, 45479}},
    {5710, 16, 32666, {1, 1, 3, 5, 7, 61, 25, 161, 333, 605, 967, 949, 3751, 5957, 6329, 22215}},
    {5711, 16, 32668, {1, 3, 3, 11, 19, 5, 1, 245, 11, 265, 1887, 1125, 919, 3091, 13703, 45385}},
    {5712, 16, 32696, {1, 1, 5, 5, 3, 53, 45, 27, 415, 443, 147, 4069, 4673, 15991, 16513, 41027}},
    {5713, 16, 32722, {1, 1, 7, 7, 19, 47, 31, 115, 179, 273, 989, 2903, 3727, 3839, 10029, 57089}},
    {5714, 16, 32757, {1, 3, 7, 1, 27, 57, 19, 187, 41, 901, 1, 3235, 6519, 10875, 7601, 51481}},
    {5715, 16, 32758, {1, 3, 1, 3, 17, 55, 97, 39, 39, 609, 253, 1103, 509, 2663, 15385, 57869}},
    {5716, 17, 4, {1, 1, 5, 7, 31, 7, 49, 197, 335, 339, 1719, 2651, 5211, 3793, 17939, 43427, 99665}},
    {5717, 17, 7, {1, 3, 7, 3, 9, 25, 29, 7, 103, 151, 685, 1317, 1671, 13705, 14059, 48907, 119345}},
    {5718, 17, 16, {1, 3, 3, 11, 21, 35, 17, 185, 11, 261, 89, 3433, 185, 1989, 8803, 34171, 26647}},
    {5719, 17, 22, {1, 1, 5, 1, 31, 63, 109, 235, 75, 267, 333, 3195, 6845, 6441, 67, 36881, 34541}},
    {5720, 17, 25, {1, 3, 7, 11, 25, 23, 21, 57, 377, 77, 593, 2793, 4923, 12655, 27043, 37243, 71243}},
    {5721, 17, 31, {1, 3, 3, 1, 19, 11, 51, 157, 279, 31, 2001, 343, 6387, 13587, 8827, 5023, 122513}},
    {5722, 17, 32, {1, 1, 5, 3, 15, 29, 45, 93, 399, 191, 1837, 743, 4783, 14921, 14735, 48785, 60401}},
    {5723, 17, 42, {1, 3, 1, 5, 25, 29, 53, 229, 203, 803, 1203, 901, 3495, 7383, 3127, 13389, 89145}},
    {5724, 17, 52, {1, 1, 5, 9, 3, 1, 87, 73, 231, 275, 1729, 3031, 6871, 5189, 5087, 46675, 93233}},
    {5725, 17, 61, {1, 1, 3, 7, 15, 3, 27, 143, 99, 801, 941, 3467, 2611, 1209, 17091, 39073, 102197}},
    {5726, 17, 70, {1, 1, 5, 1, 19, 33, 71, 213, 435, 145, 1137, 2301, 1517, 11283, 29041, 43101, 128689}},
    {5727, 17, 76, {1, 1, 7, 15, 25, 61, 123, 205, 241, 919, 1037, 367, 1077, 15581, 32563, 12997, 12137}},
    {5728, 17, 81, {1, 1, 1, 13, 27, 9, 47, 123, 187, 431, 1149, 3565, 7121, 10371, 14839, 10217, 51153}},
    {5729, 17, 87, {1, 3, 1, 7, 27, 17, 61, 215, 1, 937, 333, 1047, 3421, 4385, 16151, 57671, 121971}},
    {5730, 17, 93, {1, 1, 7, 15, 17, 63, 93, 19, 497, 321, 343, 87, 7943, 4687, 10135, 19271, 110847}},
    {5731, 17, 98, {1, 1, 3, 9, 25, 3, 13, 125, 253, 413, 233, 1795, 6823, 14169, 30289, 64121, 97367}},
    {5732, 17, 122, {1, 3, 3, 1, 11, 9, 119, 77, 485, 763, 1021, 3035, 1619, 11961, 25423, 2067, 98645}},
    {5733, 17, 133, {1, 3, 3, 1, 5, 49, 15, 151, 215, 985, 1309, 1075, 6699, 8433, 25507, 25451, 17367}},
    {5734, 17, 134, {1, 3, 3, 3, 9, 23, 67, 175, 353, 795, 41, 2115, 4733, 15835, 6261, 28045, 95769}},
    {5735, 17, 140, {1, 1, 1, 5, 31, 23, 47, 137, 355, 29, 575, 2527, 2053, 5063, 6289, 40985, 50545}},
    {5736, 17, 146, {1, 1, 7, 3, 7, 15, 119, 193, 257, 285, 1511, 1455, 1449, 4673, 32563, 24381, 24975}},
    {5737, 17, 158, {1, 1, 5, 9, 23, 47, 93, 153, 9, 447, 1535, 2945, 4857, 3497, 22851, 50251, 80131}},
    {5738, 17, 171, {1, 3, 1, 9, 1, 21, 81, 95, 393, 373, 2023, 447, 1525, 13055, 26517, 47817, 12903}},
    {5739, 17, 176, {1, 3, 7, 13, 19, 43, 123, 47, 493, 467, 1733, 1961, 2121, 3779, 17757, 44989, 71133}},
    {5740, 17, 179, {1, 3, 7, 3, 23, 17, 19, 77, 493, 699, 1461, 2603, 4879, 14629, 25545, 16799, 112999}},
    {5741, 17, 182, {1, 1, 3, 3, 29, 59, 45, 119, 411, 463, 761, 3483, 1287, 11301, 10449, 47707, 61259}},
    {5742, 17, 191, {1, 3, 1, 13, 21, 13, 125, 249, 313, 745, 845, 3335, 2939, 6429, 11869, 54507, 108293}},
    {5743, 17, 193, {1, 3, 5, 11, 19, 5, 119, 27, 307, 169, 1151, 183, 179, 2751, 30927, 51585, 9315}},
    {5744, 17, 224, {1, 3, 7, 9, 13, 3, 77, 255, 143, 225, 217, 1673, 5963, 1135, 21873, 28719, 6211}},
    {5745, 17, 227, {1, 3, 7, 11, 31, 59, 87, 109, 1, 789, 1691, 2453, 1319, 11967, 28343, 65377, 65569}},
    {5746, 17, 229, {1, 3, 3, 3, 11, 17, 23, 203, 57, 155, 1941, 1387, 3625, 15745, 21665, 55139, 107545}},
    {5747, 17, 236, {1, 1, 1, 1, 23, 49, 57, 17, 165, 485, 1043, 1673, 6827, 9933, 3215, 28389, 92895}},
    {5748, 17, 248, {1, 1, 5, 1, 25, 43, 125, 205, 307, 499, 1375, 3681, 2955, 3885, 6715, 57485, 20257}},
    {5749, 17, 262, {1, 1, 7, 7, 15, 27, 67, 179, 443, 597, 937, 3819, 4561, 11033, 20337, 45943, 23585}},
    {5750, 17, 273, {1, 3, 3, 15, 7, 5, 109, 21, 365, 477, 1387, 143, 7877, 12539, 6861, 15817, 116511}},
    {5751, 17, 276, {1, 3, 3, 3, 9, 13, 77, 203, 511, 251, 83, 3429, 1021, 11067, 25099, 36661, 44163}},
    {5752, 17, 280, {1, 3, 7, 5, 17, 63, 109, 81, 265, 239, 1717, 3041, 5531, 11247, 16293, 63409, 7259}},
    {5753, 17, 283, {1, 3, 1, 1, 13, 3, 99, 73, 33, 479, 1595, 1005, 4321, 15277, 27217, 42023, 7257}},
    {5754, 17, 290, {1, 1, 3, 7, 3, 7, 73, 103, 317, 699, 151, 3691, 2315, 10787, 28907, 48143, 17101}},
    {5755, 17, 309, {1, 1, 7, 5, 11, 21, 101, 245, 323, 379, 1551, 221, 3439, 7879, 31611, 49921, 2745}},
    {5756, 17, 316, {1, 3, 5, 7, 7, 11, 39, 11, 263, 693, 623, 389, 1439, 10029, 17853, 17119, 125195}},
    {5757, 17, 319, {1, 1, 7, 11, 15, 23, 61, 15, 9, 395, 1637, 315, 1035, 5303, 20243, 37037, 77813}},
    {5758, 17, 321, {1, 3, 5, 5, 19, 41, 43, 219, 117, 27, 1425, 1473, 6615, 11607, 29515, 36165, 71553}},
    {5759, 17, 328, {1, 1, 3, 3, 13, 47, 71, 47, 375, 225, 169, 1065, 379, 12205, 3477, 56241, 40681}},
    {5760, 17, 346, {1, 3, 1, 15, 31, 61, 123, 185, 179, 965, 409, 1301, 2567, 16035, 30979, 333, 127263}},
    {5761, 17, 355, {1, 1, 1, 13, 9, 51, 3, 149, 423, 667, 747, 457, 7101, 6759, 8767, 653, 69215}},
    {5762, 17, 367, {1, 1, 7, 5, 23, 43, 55, 51, 405, 665, 1963, 2639, 3689, 16095, 5013, 63361, 27873}},
    {5763, 17, 369, {1, 3, 3, 9, 27, 33, 49, 233, 177, 179, 275, 1847, 287, 15667, 18973, 26011, 34023}},
    {5764, 17, 372, {1, 1, 7, 9, 31, 39, 73, 3, 375, 653, 153, 803, 2625, 9419, 12523, 50621, 80419}},
    {5765, 17, 382, {1, 3, 1, 9, 13, 5, 51, 167, 275, 469, 1753, 2835, 6257, 6609, 32003, 27317, 21553}},
    {5766, 17, 388, {1, 1, 3, 13, 9, 39, 95, 209, 391, 115, 387, 3961, 2589, 15315, 30095, 27961, 121549}},
    {5767, 17, 392, {1, 1, 7, 11, 17, 15, 5, 25, 41, 589, 33, 13, 2953, 1593, 28185, 7605, 80679}},
    {5768, 17, 395, {1, 3, 3, 9, 23, 17, 111, 199, 343, 629, 1869, 2491, 3937, 10727, 9739, 48669, 128935}},
    {5769, 17, 397, {1, 3, 7, 3, 5, 41, 1, 181, 425, 233, 761, 1525, 6037, 6751, 1651, 61179, 100339}},
    {5770, 17, 403, {1, 1, 7, 1, 19, 7, 19, 245, 397, 237, 1507, 3403, 1519, 2209, 32005, 61669, 122091}},
    {5771, 17, 409, {1, 3, 3, 15, 15, 37, 83, 153, 449, 345, 1947, 3059, 2903, 2405, 16461, 24561, 86243}},
    {5772, 17, 410, {1, 3, 3, 1, 7, 59, 25, 171, 287, 525, 2047, 2817, 1027, 813, 30601, 56303, 125803}},
    {5773, 17, 425, {1, 3, 7, 15, 3, 29, 67, 117, 23, 647, 1605, 2217, 5395, 12029, 9433, 16839, 76749}},
    {5774, 17, 443, {1, 1, 3, 9, 3, 19, 9, 149, 59, 965, 675, 3027, 4987, 3635, 26727, 4153, 64733}},
    {5775, 17, 472, {1, 1, 5, 13, 25, 29, 35, 75, 311, 219, 1061, 1957, 5027, 5035, 4799, 44495, 64225}},
    {5776, 17, 475, {1, 3, 5, 7, 23, 37, 33, 143, 335, 943, 1197, 1901, 2197, 16345, 25343, 14207, 105583}},
    {5777, 17, 481, {1, 3, 1, 11, 3, 45, 103, 253, 103, 565, 1491, 3849, 4047, 12119, 2759, 31781, 123365}},
    {5778, 17, 488, {1, 3, 5, 15, 23, 15, 43, 237, 43, 929, 1751, 443, 1177, 7647, 31745, 19313, 120039}},
    {5779, 17, 493, {1, 1, 7, 9, 3, 33, 103, 31, 71, 1007, 993, 623, 1151, 10445, 20627, 9499, 27943}},
    {5780, 17, 501, {1, 1, 3, 1, 11, 53, 3, 11, 435, 967, 1505, 3751, 6367, 9279, 6127, 51239, 5963}},
    {5781, 17, 515, {1, 3, 5, 9, 31, 49, 51, 57, 121, 985, 361, 2913, 3269, 371, 10633, 44539, 114865}},
    {5782, 17, 522, {1, 1, 7, 5, 5, 35, 45, 125, 223, 319, 1745, 3449, 4609, 14369, 17833, 9957, 2233}},
    {5783, 17, 524, {1, 1, 3, 1, 23, 17, 87, 27, 471, 491, 1683, 1965, 699, 10783, 4875, 2641, 67887}},
    {5784, 17, 527, {1, 3, 1, 3, 11, 57, 95, 247, 267, 815, 13, 3801, 6523, 13011, 30321, 23411, 1005}},
    {5785, 17, 535, {1, 1, 7, 5, 31, 55, 23, 71, 507, 519, 1641, 2365, 5005, 8861, 6661, 47657, 77533}},
    {5786, 17, 542, {1, 1, 1, 13, 21, 27, 85, 233, 449, 469, 1217, 3083, 7769, 12109, 10731, 26775, 7621}},
    {5787, 17, 545, {1, 1, 7, 15, 31, 9, 23, 139, 175, 463, 2019, 3559, 4359, 1865, 12467, 65245, 99859}},
    {5788, 17, 555, {1, 1, 3, 3, 11, 33, 71, 151, 223, 53, 553, 1085, 6481, 12553, 22409, 551, 56813}},
    {5789, 17, 558, {1, 1, 1, 13, 31, 57, 123, 175, 131, 345, 1751, 2109, 7307, 4825, 12423, 1995, 10853}},
    {5790, 17, 560, {1, 3, 3, 5, 31, 37, 7, 167, 171, 643, 229, 1543, 1591, 10519, 32477, 42715, 111641}},
    {5791, 17, 563, {1, 1, 3, 13, 19, 59, 119, 63, 293, 873, 531, 3673, 4927, 14809, 18459, 27099, 74063}},
    {5792, 17, 570, {1, 3, 5, 1, 29, 5, 71, 35, 321, 1003, 1341, 3785, 8049, 6131, 19813, 58501, 25611}},
    {5793, 17, 578, {1, 3, 3, 15, 23, 61, 87, 115, 323, 909, 1095, 2367, 1097, 12499, 14117, 47795, 42667}},
    {5794, 17, 583, {1, 3, 5, 5, 31, 33, 55, 235, 65, 809, 839, 65, 1913, 13075, 2723, 4869, 90643}},
    {5795, 17, 590, {1, 3, 1, 5, 7, 53, 77, 221, 359, 953, 123, 3317, 6393, 8519, 25435, 52631, 20815}},
    {5796, 17, 597, {1, 1, 3, 15, 23, 51, 3, 87, 73, 855, 1321, 2189, 2583, 2985, 6755, 57101, 71555}},
    {5797, 17, 604, {1, 1, 7, 7, 11, 53, 65, 63, 421, 113, 661, 3999, 2431, 9391, 15929, 9743, 20409}},
    {5798, 17, 608, {1, 1, 3, 5, 11, 39, 101, 9, 215, 163, 33, 3685, 4253, 5933, 22337, 17915, 125037}},
    {5799, 17, 614, {1, 1, 1, 7, 9, 45, 59, 239, 255, 929, 1913, 2865, 6975, 261, 23325, 14153, 79731}},
    {5800, 17, 635, {1, 1, 5, 3, 1, 47, 125, 123, 237, 601, 1457, 885, 4167, 15761, 15849, 54427, 39599}},
    {5801, 17, 637, {1, 1, 1, 1, 19, 1, 103, 253, 477, 547, 707, 349, 5609, 6101, 10523, 1093, 130345}},
    {5802, 17, 653, {1, 3, 1, 7, 19, 33, 29, 45, 339, 391, 1287, 2443, 2187, 4985, 23343, 50999, 102627}},
    {5803, 17, 654, {1, 1, 1, 1, 13, 31, 13, 145, 117, 257, 1321, 2049, 2069, 6143, 29273, 26955, 51877}},
    {5804, 17, 659, {1, 3, 1, 13, 7, 61, 109, 157, 351, 655, 1697, 1967, 5687, 1607, 29469, 61437, 65371}},
    {5805, 17, 666, {1, 1, 7, 7, 7, 35, 7, 135, 81, 1021, 993, 2303, 1691, 14137, 6323, 28333, 113101}},
    {5806, 17, 671, {1, 3, 7, 1, 25, 47, 21, 33, 315, 887, 435, 1005, 2169, 14985, 11557, 13293, 45815}},
    {5807, 17, 689, {1, 1, 7, 5, 23, 31, 123, 141, 441, 403, 1181, 83, 5061, 4649, 219, 1987, 58135}},
    {5808, 17, 690, {1, 1, 3, 1, 3, 49, 113, 139, 453, 599, 1673, 3683, 999, 9225, 21327, 6531, 115055}},
    {5809, 17, 695, {1, 3, 5, 11, 29, 37, 81, 107, 207, 939, 1383, 365, 7719, 2263, 21819, 30915, 17835}},
    {5810, 17, 713, {1, 3, 3, 11, 13, 47, 75, 55, 199, 993, 1397, 477, 7983, 11653, 21703, 35021, 72615}},
    {5811, 17, 722, {1, 3, 7, 11, 3, 45, 3, 27, 471, 413, 121, 3009, 2483, 15153, 2173, 26533, 88175}},
    {5812, 17, 733, {1, 1, 3, 5, 23, 1, 59, 235, 503, 853, 1009, 3803, 6277, 6279, 15459, 53547, 32279}},
    {5813, 17, 758, {1, 1, 5, 1, 5, 23, 71, 17, 353, 441, 1433, 1235, 5065, 11785, 1093, 12859, 7769}},
    {5814, 17, 770, {1, 1, 5, 3, 9, 33, 127, 47, 99, 85, 1309, 3463, 6519, 12573, 9397, 13785, 118287}},
    {5815, 17, 782, {1, 3, 5, 9, 9, 31, 125, 41, 425, 731, 307, 2877, 3291, 13897, 16527, 45861, 99289}},
    {5816, 17, 784, {1, 3, 1, 15, 15, 47, 45, 155, 427, 1001, 141, 69, 4985, 14991, 28075, 53173, 91855}},
    {5817, 17, 793, {1, 1, 5, 13, 15, 35, 77, 219, 87, 487, 55, 1749, 2823, 4487, 1905, 4931, 69335}},
    {5818, 17, 803, {1, 3, 3, 7, 5, 7, 27, 137, 59, 813, 1133, 3259, 7789, 3401, 2223, 33161, 101427}},
    {5819, 17, 805, {1, 1, 7, 3, 7, 29, 95, 57, 77, 473, 1869, 2695, 6289, 2707, 15123, 37281, 130999}},
    {5820, 17, 812, {1, 1, 3, 15, 29, 25, 19, 61, 85, 491, 225, 2011, 6939, 1959, 1207, 7839, 23233}},
    {5821, 17, 838, {1, 3, 5, 3, 11, 13, 71, 241, 117, 769, 171, 2701, 7145, 13697, 5737, 5941, 19087}},
    {5822, 17, 849, {1, 1, 1, 15, 7, 19, 11, 219, 111, 475, 1277, 2089, 3303, 13735, 26223, 63115, 12873}},
    {5823, 17, 875, {1, 1, 3, 11, 21, 57, 47, 83, 479, 237, 585, 811, 279, 8113, 28011, 33393, 126833}},
    {5824, 17, 877, {1, 3, 7, 11, 1, 61, 119, 221, 307, 603, 607, 225, 7577, 1313, 1067, 53785, 37531}},
    {5825, 17, 880, {1, 1, 1, 3, 17, 53, 13, 127, 451, 719, 1317, 579, 733, 9787, 20175, 27259, 102777}},
    {5826, 17, 892, {1, 1, 3, 7, 19, 25, 79, 83, 355, 41, 963, 3897, 7827, 539, 15975, 37227, 67945}},
    {5827, 17, 895, {1, 3, 5, 7, 29, 21, 33, 39, 481, 965, 485, 1413, 4661, 10493, 139, 17635, 53135}},
    {5828, 17, 899, {1, 3, 7, 9, 31, 61, 79, 219, 17, 687, 11, 3943, 4559, 15347, 21955, 33417, 116165}},
    {5829, 17, 919, {1, 3, 3, 1, 1, 47, 17, 89, 147, 293, 113, 3675, 8077, 5643, 159, 32517, 34961}},
    {5830, 17, 920, {1, 1, 1, 7, 19, 45, 49, 3, 27, 415, 1051, 2873, 307, 3079, 20765, 11023, 65965}},
    {5831, 17, 932, {1, 3, 3, 11, 27, 63, 123, 217, 33, 229, 1113, 1339, 6327, 3661, 8993, 20703, 69067}},
    {5832, 17, 935, {1, 3, 3, 9, 5, 15, 89, 205, 337, 999, 1789, 901, 8117, 3555, 45, 2003, 82651}},
    {5833, 17, 936, {1, 1, 5, 11, 3, 49, 37, 77, 251, 791, 19, 3533, 6489, 489, 19693, 26697, 57739}},
    {5834, 17, 941, {1, 1, 1, 9, 11, 47, 51, 55, 249, 469, 899, 1501, 7507, 2499, 28211, 16295, 10447}},
    {5835, 17, 950, {1, 1, 3, 15, 23, 41, 85, 125, 275, 503, 197, 2357, 5309, 4773, 10349, 56199, 130237}},
    {5836, 17, 961, {1, 1, 5, 7, 11, 49, 5, 123, 153, 23, 307, 359, 2457, 15507, 22469, 62813, 4803}},
    {5837, 17, 962, {1, 1, 1, 11, 1, 59, 3, 207, 47, 151, 1085, 3285, 3803, 15109, 26071, 47391, 3641}},
    {5838, 17, 971, {1, 3, 5, 3, 9, 49, 119, 31, 201, 1009, 419, 3893, 317, 803, 32205, 29081, 108469}},
    {5839, 17, 982, {1, 1, 1, 5, 31, 7, 89, 145, 361, 277, 1797, 151, 2935, 14225, 13637, 52313, 16595}},
    {5840, 17, 986, {1, 3, 1, 3, 21, 13, 45, 195, 431, 471, 433, 2451, 6137, 459, 17965, 51409, 48549}},
    {5841, 17, 1012, {1, 1, 3, 7, 27, 7, 75, 91, 53, 177, 1987, 1125, 7091, 12643, 5157, 60691, 11697}},
    {5842, 17, 1021, {1, 3, 1, 13, 27, 49, 45, 3, 185, 535, 311, 857, 3755, 493, 22261, 16305, 114517}},
    {5843, 17, 1024, {1, 3, 3, 13, 11, 37, 119, 153, 463, 219, 751, 1861, 2663, 5841, 24327, 17469, 46883}},
    {5844, 17, 1029, {1, 3, 3, 13, 31, 41, 11, 209, 83, 521, 247, 1147, 6005, 493, 23039, 42375, 5745}},
    {5845, 17, 1030, {1, 3, 7, 7, 15, 37, 99, 63, 401, 455, 1871, 397, 51, 14463, 9339, 47033, 26417}},
    {5846, 17, 1051, {1, 1, 5, 15, 1, 11, 95, 155, 251, 289, 1563, 515, 3351, 2429, 23177, 5163, 105069}},
    {5847, 17, 1054, {1, 1, 7, 15, 9, 31, 73, 225, 451, 465, 61, 561, 3923, 9665, 3057, 595, 113879}},
    {5848, 17, 1064, {1, 3, 5, 11, 31, 31, 3, 91, 501, 431, 55, 2085, 7645, 13753, 26381, 28181, 71747}},
    {5849, 17, 1067, {1, 3, 3, 13, 29, 21, 43, 35, 247, 155, 363, 525, 7049, 2627, 4333, 20183, 53455}},
    {5850, 17, 1082, {1, 3, 1, 7, 27, 41, 55, 37, 83, 19, 929, 3945, 2473, 15655, 31001, 28775, 88097}},
    {5851, 17, 1096, {1, 3, 3, 7, 13, 37, 115, 61, 371, 135, 1681, 3767, 6009, 10205, 17725, 853, 99761}},
    {5852, 17, 1116, {1, 1, 7, 13, 21, 35, 29, 91, 421, 323, 1551, 1431, 3637, 12919, 21541, 29801, 72445}},
    {5853, 17, 1119, {1, 1, 3, 3, 11, 35, 117, 105, 235, 67, 1775, 1663, 4441, 9145, 16119, 29813, 129905}},
    {5854, 17, 1129, {1, 3, 7, 9, 7, 25, 119, 103, 139, 487, 1693, 3867, 225, 6083, 1899, 11135, 76189}},
    {5855, 17, 1130, {1, 3, 7, 15, 3, 41, 3, 29, 307, 91, 1149, 13, 7927, 5607, 32059, 4589, 96217}},
    {5856, 17, 1132, {1, 3, 3, 9, 31, 21, 27, 151, 75, 757, 967, 183, 3469, 4479, 18237, 47241, 121575}},
    {5857, 17, 1137, {1, 1, 7, 15, 1, 15, 113, 37, 1, 719, 1147, 105, 179, 12541, 18333, 1389, 14267}},
    {5858, 17, 1147, {1, 3, 3, 7, 17, 17, 127, 245, 15, 127, 1449, 2269, 3441, 12827, 22623, 44345, 12751}},
    {5859, 17, 1150, {1, 3, 5, 7, 15, 57, 53, 173, 295, 813, 1487, 1545, 8051, 10309, 20557, 19129, 109405}},
    {5860, 17, 1154, {1, 1, 3, 11, 11, 3, 45, 243, 61, 427, 1385, 3619, 3559, 9333, 13309, 9185, 80711}},
    {5861, 17, 1165, {1, 3, 5, 7, 13, 13, 5, 79, 425, 797, 223, 2655, 4537, 9869, 25093, 8787, 74109}},
    {5862, 17, 1166, {1, 1, 3, 7, 17, 11, 75, 129, 13, 623, 1831, 1969, 7245, 10965, 18209, 20449, 45021}},
    {5863, 17, 1174, {1, 1, 3, 7, 27, 45, 19, 249, 281, 915, 1669, 115, 5445, 15469, 13313, 18185, 6591}},
    {5864, 17, 1177, {1, 1, 5, 3, 9, 29, 57, 27, 137, 155, 413, 2171, 3967, 3539, 26269, 4039, 12327}},
    {5865, 17, 1184, {1, 3, 7, 9, 23, 33, 83, 151, 351, 579, 493, 2579, 817, 11861, 12799, 21967, 26389}},
    {5866, 17, 1194, {1, 1, 5, 7, 27, 43, 17, 131, 77, 147, 775, 2319, 1347, 5883, 16531, 11385, 119917}},
    {5867, 17, 1204, {1, 1, 1, 11, 17, 35, 71, 239, 377, 295, 1405, 2213, 2967, 12619, 4193, 24881, 69177}},
    {5868, 17, 1208, {1, 3, 5, 1, 23, 29, 83, 193, 319, 69, 289, 3691, 4375, 8671, 29431, 62167, 60179}},
    {5869, 17, 1213, {1, 3, 1, 5, 21, 25, 73, 255, 119, 723, 649, 2023, 7717, 15329, 10081, 58301, 8149}},
    {5870, 17, 1219, {1, 1, 7, 5, 9, 59, 43, 193, 483, 205, 809, 2563, 5997, 15779, 25257, 14657, 81729}},
    {5871, 17, 1233, {1, 1, 1, 13, 9, 25, 7, 239, 39, 775, 937, 3269, 2545, 3629, 25925, 42735, 34815}},
    {5872, 17, 1264, {1, 1, 5, 1, 17, 11, 41, 15, 257, 539, 925, 2833, 123, 8783, 13819, 50885, 43317}},
    {5873, 17, 1267, {1, 1, 7, 1, 29, 27, 127, 163, 437, 1001, 1285, 3565, 909, 2359, 873, 63423, 35155}},
    {5874, 17, 1281, {1, 3, 3, 13, 11, 17, 113, 63, 409, 381, 413, 3551, 7579, 4497, 21427, 48229, 78743}},
    {5875, 17, 1312, {1, 1, 3, 9, 3, 31, 117, 75, 75, 509, 837, 1255, 7021, 9033, 28891, 27097, 6839}},
    {5876, 17, 1321, {1, 3, 1, 11, 15, 15, 41, 127, 187, 149, 1821, 2427, 5223, 14383, 14709, 37547, 55225}},
    {5877, 17, 1330, {1, 1, 7, 1, 11, 49, 95, 119, 509, 591, 375, 407, 3471, 5731, 7789, 61595, 68649}},
    {5878, 17, 1332, {1, 1, 3, 5, 23, 23, 75, 149, 83, 193, 627, 1533, 267, 4595, 9097, 62281, 72113}},
    {5879, 17, 1335, {1, 3, 7, 7, 29, 13, 35, 175, 333, 735, 13, 1723, 4953, 1475, 25131, 33783, 57499}},
    {5880, 17, 1341, {1, 3, 7, 11, 23, 3, 113, 87, 99, 219, 1335, 301, 1829, 13407, 27259, 58391, 114237}},
    {5881, 17, 1356, {1, 1, 1, 15, 21, 25, 39, 253, 251, 549, 1847, 2885, 2145, 7339, 9361, 42639, 77347}},
    {5882, 17, 1371, {1, 1, 1, 11, 23, 21, 25, 243, 501, 805, 63, 3061, 1383, 14805, 24903, 64033, 102879}},
    {5883, 17, 1377, {1, 1, 7, 15, 21, 9, 47, 111, 127, 229, 1583, 1311, 3035, 3877, 3525, 62965, 47477}},
    {5884, 17, 1380, {1, 3, 3, 1, 27, 23, 3, 243, 69, 163, 417, 1997, 47, 9707, 19907, 33343, 12411}},
    {5885, 17, 1384, {1, 1, 7, 7, 31, 23, 101, 221, 205, 243, 503, 1391, 7785, 165, 25233, 22971, 104135}},
    {5886, 17, 1395, {1, 3, 5, 15, 19, 11, 15, 255, 113, 165, 1433, 3967, 6915, 5863, 4201, 2077, 123939}},
    {5887, 17, 1397, {1, 1, 5, 13, 5, 11, 25, 43, 79, 969, 181, 185, 2735, 4537, 15929, 44387, 28389}},
    {5888, 17, 1411, {1, 1, 3, 15, 23, 11, 103, 245, 439, 221, 1669, 3515, 157, 15721, 22689, 31237, 127441}},
    {5889, 17, 1414, {1, 1, 3, 15, 11, 13, 93, 247, 379, 819, 1525, 1681, 5023, 3129, 14481, 61753, 52407}},
    {5890, 17, 1426, {1, 1, 5, 11, 1, 57, 1, 67, 17, 997, 439, 2449, 7561, 10751, 23575, 44017, 2755}},
    {5891, 17, 1432, {1, 1, 5, 11, 27, 17, 57, 113, 349, 891, 1727, 1961, 6349, 1471, 687, 32989, 98405}},
    {5892, 17, 1435, {1, 1, 1, 15, 21, 1, 77, 193, 437, 751, 893, 301, 7605, 9467, 12233, 23257, 61159}},
    {5893, 17, 1437, {1, 3, 5, 15, 13, 57, 69, 129, 35, 199, 497, 4027, 3075, 4201, 24597, 34971, 3619}},
    {5894, 17, 1442, {1, 3, 3, 9, 25, 53, 49, 109, 331, 49, 2039, 4057, 1319, 5869, 24987, 34775, 51935}},
    {5895, 17, 1454, {1, 3, 3, 3, 25, 15, 123, 15, 467, 617, 779, 2283, 7073, 2133, 25763, 22453, 89849}},
    {5896, 17, 1468, {1, 3, 5, 15, 29, 39, 87, 47, 151, 801, 807, 1817, 6821, 7685, 481, 12825, 47149}},
    {5897, 17, 1473, {1, 3, 3, 1, 17, 39, 63, 175, 123, 625, 165, 1451, 2221, 2373, 27513, 38781, 69963}},
    {5898, 17, 1488, {1, 1, 3, 15, 1, 13, 75, 101, 199, 177, 1665, 1507, 7075, 2149, 15581, 51869, 125003}},
    {5899, 17, 1491, {1, 1, 5, 7, 11, 57, 93, 65, 65, 205, 1387, 3095, 7861, 12259, 20509, 4933, 22577}},
    {5900, 17, 1509, {1, 3, 7, 7, 17, 45, 65, 35, 65, 83, 825, 3907, 6819, 12901, 31113, 45697, 127409}},
    {5901, 17, 1524, {1, 1, 5, 13, 27, 61, 57, 171, 463, 21, 683, 3211, 45, 11743, 31085, 27249, 27119}},
    {5902, 17, 1533, {1, 3, 7, 7, 19, 11, 127, 159, 225, 431, 1501, 1045, 3019, 1811, 2771, 57457, 10647}},
    {5903, 17, 1555, {1, 1, 1, 11, 31, 3, 41, 7, 317, 601, 689, 2547, 8159, 7925, 26889, 19327, 70885}},
    {5904, 17, 1567, {1, 1, 7, 7, 1, 47, 119, 97, 221, 629, 853, 433, 1473, 9161, 23687, 34161, 93587}},
    {5905, 17, 1571, {1, 3, 3, 13, 3, 49, 3, 203, 83, 897, 1331, 2831, 7445, 13651, 4825, 44093, 123987}},
    {5906, 17, 1586, {1, 1, 1, 1, 19, 11, 41, 53, 381, 645, 739, 2149, 261, 1195, 21585, 58773, 125833}},
    {5907, 17, 1592, {1, 1, 5, 15, 17, 39, 85, 117, 35, 711, 903, 2769, 3613, 6121, 20767, 56659, 108489}},
    {5908, 17, 1595, {1, 1, 3, 5, 27, 61, 41, 153, 301, 553, 1959, 229, 4341, 1547, 26241, 25247, 76963}},
    {5909, 17, 1600, {1, 3, 7, 11, 29, 61, 91, 75, 429, 751, 555, 3541, 3083, 4255, 24691, 52983, 47225}},
    {5910, 17, 1606, {1, 1, 7, 7, 5, 11, 33, 137, 359, 937, 115, 2299, 4615, 2643, 19243, 9749, 98547}},
    {5911, 17, 1627, {1, 1, 1, 5, 17, 19, 65, 195, 41, 659, 759, 3537, 1465, 14815, 18381, 21759, 57669}},
    {5912, 17, 1648, {1, 3, 1, 7, 29, 17, 89, 215, 105, 265, 69, 1285, 6807, 13439, 7443, 41707, 19853}},
    {5913, 17, 1651, {1, 3, 3, 9, 21, 19, 17, 39, 219, 589, 1533, 2317, 1277, 455, 5935, 2065, 65145}},
    {5914, 17, 1654, {1, 3, 7, 3, 31, 3, 77, 63, 5, 217, 2041, 1899, 6843, 15429, 295, 33581, 48777}},
    {5915, 17, 1667, {1, 3, 7, 13, 19, 35, 83, 167, 493, 427, 1143, 1429, 991, 7761, 1519, 8453, 117801}},
    {5916, 17, 1669, {1, 3, 7, 9, 5, 27, 121, 113, 49, 631, 1977, 3609, 6449, 11999, 10275, 23331, 44821}},
    {5917, 17, 1674, {1, 1, 7, 1, 5, 49, 91, 97, 193, 885, 897, 1315, 7201, 10883, 31843, 31457, 89063}},
    {5918, 17, 1687, {1, 1, 5, 15, 19, 21, 5, 125, 35, 31, 509, 3817, 5289, 3519, 13717, 1011, 88583}},
    {5919, 17, 1698, {1, 3, 1, 5, 9, 21, 101, 19, 105, 609, 1215, 1955, 4487, 5591, 27951, 15495, 19331}},
    {5920, 17, 1710, {1, 1, 1, 1, 29, 15, 13, 89, 503, 567, 1115, 4045, 1237, 3815, 31485, 57515, 66569}},
    {5921, 17, 1717, {1, 3, 1, 11, 7, 11, 11, 227, 99, 505, 1637, 2323, 6609, 12971, 26981, 57525, 91679}},
    {5922, 17, 1722, {1, 3, 7, 7, 13, 17, 21, 111, 409, 509, 1239, 2645, 3967, 29, 8473, 41965, 87215}},
    {5923, 17, 1735, {1, 3, 7, 11, 19, 55, 57, 207, 475, 159, 461, 139, 5923, 1717, 20679, 6941, 49337}},
    {5924, 17, 1741, {1, 3, 1, 11, 23, 43, 121, 199, 199, 897, 709, 323, 1029, 15139, 10645, 21333, 58007}},
    {5925, 17, 1749, {1, 1, 3, 1, 21, 47, 119, 109, 141, 315, 211, 2739, 7737, 8265, 14721, 24537, 23567}},
    {5926, 17, 1750, {1, 3, 7, 5, 3, 49, 111, 185, 295, 125, 709, 1141, 4035, 8559, 1245, 22115, 116081}},
    {5927, 17, 1769, {1, 3, 1, 15, 19, 15, 125, 23, 351, 561, 1515, 2277, 2629, 1619, 2589, 49009, 99097}},
    {5928, 17, 1775, {1, 3, 1, 13, 27, 59, 37, 17, 37, 483, 585, 1051, 3613, 14685, 31425, 30091, 82333}},
    {5929, 17, 1777, {1, 3, 7, 3, 27, 19, 77, 115, 441, 801, 1781, 3725, 471, 7811, 19259, 23857, 66903}},
    {5930, 17, 1778, {1, 1, 5, 15, 1, 39, 59, 49, 283, 139, 1313, 2039, 3209, 35, 28025, 1795, 14825}},
    {5931, 17, 1792, {1, 3, 1, 15, 19, 53, 1, 239, 17, 349, 541, 885, 3107, 7187, 25965, 24883, 40749}},
    {5932, 17, 1797, {1, 3, 5, 11, 17, 9, 91, 171, 97, 257, 1595, 1345, 1623, 10357, 4331, 54217, 77053}},
    {5933, 17, 1802, {1, 3, 5, 3, 25, 25, 111, 189, 371, 247, 1203, 3215, 5171, 6821, 21925, 24525, 15973}},
    {5934, 17, 1822, {1, 1, 5, 7, 9, 13, 49, 111, 325, 931, 269, 2031, 2453, 1437, 9895, 19819, 31141}},
    {5935, 17, 1825, {1, 1, 3, 1, 27, 53, 49, 207, 301, 499, 1457, 3193, 2191, 9225, 26789, 42143, 15123}},
    {5936, 17, 1831, {1, 1, 1, 11, 7, 15, 125, 61, 129, 757, 1295, 359, 3085, 14969, 31595, 65509, 114643}},
    {5937, 17, 1838, {1, 1, 1, 5, 19, 19, 31, 249, 201, 117, 1961, 2301, 795, 11445, 4311, 2691, 25319}},
    {5938, 17, 1852, {1, 1, 3, 11, 5, 25, 95, 163, 237, 531, 3, 297, 3939, 1015, 5191, 18211, 94089}},
    {5939, 17, 1855, {1, 3, 7, 15, 7, 49, 49, 77, 413, 643, 907, 3413, 5439, 11633, 16099, 6031, 30165}},
    {5940, 17, 1860, {1, 1, 3, 13, 17, 27, 13, 41, 235, 157, 1643, 3777, 3317, 10145, 26273, 32649, 95775}},
    {5941, 17, 1867, {1, 3, 1, 13, 15, 1, 89, 3, 41, 5, 781, 2081, 1891, 1995, 30739, 44031, 11441}},
    {5942, 17, 1869, {1, 1, 7, 13, 21, 9, 49, 9, 111, 921, 1687, 117, 6057, 2705, 20463, 13305, 4247}},
    {5943, 17, 1875, {1, 3, 3, 7, 17, 43, 21, 169, 133, 919, 1661, 865, 2801, 1719, 22593, 3603, 23371}},
    {5944, 17, 1882, {1, 1, 7, 9, 23, 63, 47, 57, 325, 89, 1413, 2625, 1731, 1253, 16917, 40209, 113827}},
    {5945, 17, 1903, {1, 3, 1, 11, 15, 31, 95, 125, 483, 631, 635, 2893, 6901, 793, 13225, 24849, 81543}},
    {5946, 17, 1908, {1, 1, 7, 9, 9, 37, 117, 139, 305, 127, 1913, 1421, 1743, 9337, 5987, 47431, 95089}},
    {5947, 17, 1917, {1, 1, 7, 9, 19, 33, 33, 35, 319, 603, 1799, 1287, 4393, 13967, 27871, 8337, 99693}},
    {5948, 17, 1927, {1, 1, 7, 13, 9, 15, 19, 181, 265, 65, 519, 585, 6693, 4733, 14557, 23617, 94823}},
    {5949, 17, 1941, {1, 1, 3, 13, 9, 7, 89, 31, 101, 403, 1903, 801, 7551, 6711, 13375, 41739, 102609}},
    {5950, 17, 1945, {1, 1, 1, 15, 15, 7, 61, 73, 413, 693, 1693, 1633, 3811, 9469, 17735, 35407, 121389}},
    {5951, 17, 1948, {1, 3, 3, 3, 5, 15, 3, 157, 331, 717, 117, 3787, 7283, 3005, 7131, 10611, 545}},
    {5952, 17, 1962, {1, 3, 5, 5, 17, 13, 115, 5, 371, 49, 1345, 1959, 1107, 12189, 19951, 13471, 101613}},
    {5953, 17, 1975, {1, 3, 3, 11, 5, 13, 47, 97, 265, 719, 1765, 1009, 7841, 893, 27067, 28465, 5573}},
    {5954, 17, 1976, {1, 1, 7, 1, 7, 29, 121, 209, 283, 495, 1367, 1089, 2519, 6965, 16875, 56481, 110483}},
    {5955, 17, 1987, {1, 1, 3, 13, 11, 61, 7, 179, 295, 715, 579, 2805, 4007, 14819, 12575, 25637, 4871}},
    {5956, 17, 1993, {1, 1, 7, 13, 17, 25, 89, 251, 435, 487, 1581, 3367, 3063, 9529, 807, 46189, 89795}},
    {5957, 17, 2004, {1, 3, 7, 11, 1, 49, 49, 231, 137, 193, 227, 3213, 6825, 12771, 25813, 11861, 62785}},
    {5958, 17, 2020, {1, 1, 7, 7, 15, 55, 117, 105, 151, 149, 637, 1091, 6435, 1371, 8471, 23661, 73767}},
    {5959, 17, 2029, {1, 1, 7, 5, 21, 57, 101, 241, 17, 353, 231, 2513, 5301, 735, 13513, 19083, 105371}},
    {5960, 17, 2030, {1, 3, 1, 5, 3, 53, 127, 139, 29, 399, 2023, 3705, 3381, 545, 26255, 4473, 43667}},
    {5961, 17, 2038, {1, 1, 3, 13, 25, 19, 19, 123, 321, 751, 1499, 4025, 4253, 6219, 25039, 245, 72777}},
    {5962, 17, 2041, {1, 3, 5, 5, 31, 39, 5, 207, 413, 523, 1965, 1875, 6681, 5129, 25525, 44591, 42689}},
    {5963, 17, 2048, {1, 1, 1, 5, 25, 45, 47, 119, 123, 89, 779, 1371, 5151, 16343, 29037, 14395, 114981}},
    {5964, 17, 2054, {1, 3, 3, 5, 29, 31, 1, 237, 313, 123, 257, 2455, 1665, 13821, 2825, 58087, 99261}},
    {5965, 17, 2057, {1, 3, 1, 9, 15, 9, 33, 51, 393, 47, 1079, 3133, 7169, 6991, 10387, 7597, 11961}},
    {5966, 17, 2058, {1, 3, 5, 11, 17, 7, 121, 219, 97, 851, 1755, 2929, 3301, 5989, 20019, 42519, 7873}},
    {5967, 17, 2068, {1, 1, 1, 1, 3, 21, 79, 117, 183, 447, 1559, 703, 1083, 13193, 17299, 58261, 16757}},
    {5968, 17, 2072, {1, 1, 1, 15, 21, 29, 5, 139, 453, 479, 811, 3519, 8117, 2863, 19231, 42567, 103619}},
    {5969, 17, 2075, {1, 1, 1, 13, 1, 51, 83, 103, 379, 183, 1731, 1915, 2889, 2571, 26495, 58535, 9195}},
    {5970, 17, 2077, {1, 3, 1, 15, 17, 11, 63, 155, 491, 469, 643, 2757, 4653, 13487, 3151, 7319, 116595}},
    {5971, 17, 2082, {1, 3, 5, 7, 31, 57, 21, 173, 421, 869, 1923, 855, 1291, 11385, 16641, 33643, 14113}},
    {5972, 17, 2084, {1, 3, 5, 5, 23, 59, 61, 135, 389, 113, 857, 1243, 1917, 7693, 18279, 63449, 19471}},
    {5973, 17, 2087, {1, 1, 3, 3, 3, 1, 67, 55, 407, 167, 95, 2067, 589, 4141, 6139, 61253, 55169}},
    {5974, 17, 2101, {1, 3, 5, 15, 7, 35, 7, 219, 361, 669, 839, 2381, 3277, 4447, 5905, 53231, 23755}},
    {5975, 17, 2111, {1, 3, 7, 11, 31, 7, 77, 121, 469, 29, 651, 2675, 4559, 6279, 27223, 52091, 129843}},
    {5976, 17, 2113, {1, 1, 3, 11, 17, 47, 5, 221, 497, 771, 1399, 4055, 4841, 3929, 7285, 52605, 91391}},
    {5977, 17, 2119, {1, 3, 1, 5, 31, 5, 35, 151, 347, 599, 253, 2187, 1161, 15323, 11149, 34069, 119069}},
    {5978, 17, 2147, {1, 1, 3, 1, 23, 37, 61, 187, 509, 751, 1293, 1131, 4695, 3487, 12339, 11819, 27239}},
    {5979, 17, 2154, {1, 1, 1, 3, 9, 27, 11, 217, 109, 783, 1613, 2073, 3423, 1983, 7251, 56441, 122967}},
    {5980, 17, 2161, {1, 3, 1, 9, 31, 63, 3, 121, 111, 573, 37, 2419, 1725, 12015, 8079, 55003, 33449}},
    {5981, 17, 2164, {1, 1, 7, 11, 25, 3, 15, 129, 323, 427, 1983, 1405, 2305, 7735, 23493, 6865, 71895}},
    {5982, 17, 2177, {1, 3, 1, 13, 21, 5, 61, 241, 235, 737, 667, 3119, 825, 6097, 1729, 5561, 88423}},
    {5983, 17, 2178, {1, 3, 5, 9, 25, 1, 57, 59, 435, 29, 1473, 2789, 103, 7459, 5285, 26615, 36497}},
    {5984, 17, 2184, {1, 1, 3, 9, 11, 47, 123, 63, 309, 505, 1735, 637, 1915, 5729, 26343, 42547, 86783}},
    {5985, 17, 2198, {1, 1, 1, 3, 13, 41, 15, 93, 507, 793, 1635, 3021, 4803, 15761, 13589, 60039, 11647}},
    {5986, 17, 2201, {1, 3, 5, 15, 27, 49, 55, 219, 185, 817, 1959, 3023, 3105, 12443, 30191, 30671, 1601}},
    {5987, 17, 2213, {1, 1, 3, 1, 17, 15, 13, 133, 403, 155, 29, 3587, 229, 8811, 4967, 12633, 31213}},
    {5988, 17, 2217, {1, 3, 1, 3, 15, 11, 41, 177, 191, 523, 541, 3691, 5353, 131, 7261, 17133, 75713}},
    {5989, 17, 2228, {1, 1, 3, 7, 1, 23, 33, 163, 207, 475, 1145, 3811, 7407, 2793, 19647, 49395, 81739}},
    {5990, 17, 2240, {1, 3, 7, 11, 11, 47, 105, 39, 509, 579, 959, 1427, 5533, 10283, 22477, 9159, 35261}},
    {5991, 17, 2245, {1, 3, 1, 13, 23, 33, 35, 193, 297, 675, 899, 1933, 6243, 14213, 8641, 28363, 114883}},
    {5992, 17, 2250, {1, 3, 3, 15, 27, 9, 27, 209, 389, 737, 1479, 4065, 5237, 4207, 12695, 28619, 98073}},
    {5993, 17, 2263, {1, 3, 7, 13, 23, 21, 3, 109, 453, 17, 1097, 2113, 5163, 5535, 2471, 52965, 61345}},
    {5994, 17, 2267, {1, 1, 7, 7, 23, 13, 43, 245, 421, 245, 801, 3853, 2965, 16139, 23697, 15625, 102399}},
    {5995, 17, 2285, {1, 1, 7, 3, 31, 47, 101, 127, 27, 13, 1969, 3203, 2459, 3083, 19227, 58949, 19567}},
    {5996, 17, 2286, {1, 1, 3, 9, 7, 51, 119, 115, 357, 969, 779, 2407, 1669, 4671, 21945, 30755, 12349}},
    {5997, 17, 2291, {1, 1, 3, 1, 25, 11, 85, 193, 205, 285, 1403, 2291, 5183, 7977, 2221, 30865, 127147}},
    {5998, 17, 2298, {1, 3, 1, 1, 9, 19, 69, 79, 431, 97, 1569, 1635, 59, 12493, 22335, 15411, 52065}},
    {5999, 17, 2306, {1, 1, 5, 1, 29, 7, 127, 203, 363, 869, 1731, 2443, 2365, 8073, 30639, 53021, 22479}},
    {6000, 17, 2325, {1, 3, 3, 7, 5, 9, 111, 129, 199, 973, 1167, 2855, 4801, 5451, 32141, 15629, 56017}},
    {6001, 17, 2329, {1, 3, 7, 15, 9, 35, 67, 251, 117, 273, 163, 2527, 1623, 2235, 25237, 46717, 21849}},
    {6002, 17, 2332, {1, 3, 7, 9, 21, 33, 105, 243, 293, 227, 1933, 453, 3677, 6977, 26683, 7629, 31477}},
    {6003, 17, 2335, {1, 3, 3, 7, 11, 3, 43, 69, 83, 529, 1161, 825, 2571, 16043, 29871, 7939, 9967}},
    {6004, 17, 2339, {1, 1, 1, 11, 3, 5, 41, 101, 423, 349, 1477, 1361, 3347, 6567, 13807, 47295, 54747}},
    {6005, 17, 2346, {1, 1, 3, 1, 25, 31, 75, 227, 175, 455, 1029, 3929, 4333, 2931, 10303, 60943, 63049}},
    {6006, 17, 2351, {1, 3, 7, 7, 15, 55, 121, 195, 235, 663, 937, 621, 1165, 16103, 8145, 63691, 7843}},
    {6007, 17, 2353, {1, 1, 1, 1, 7, 1, 99, 79, 253, 53, 567, 3731, 7521, 149, 2807, 43609, 28659}},
    {6008, 17, 2363, {1, 1, 7, 11, 17, 39, 95, 65, 431, 893, 2003, 1117, 3621, 6623, 16605, 7831, 77293}},
    {6009, 17, 2378, {1, 3, 7, 7, 9, 5, 57, 133, 223, 151, 1465, 295, 2397, 10399, 20691, 13059, 64371}},
    {6010, 17, 2383, {1, 1, 3, 15, 9, 39, 97, 19, 217, 69, 923, 3793, 6791, 5815, 32353, 10761, 73787}},
    {6011, 17, 2391, {1, 3, 5, 9, 15, 53, 101, 15, 133, 741, 1179, 935, 8183, 4073, 5089, 51537, 105785}},
    {6012, 17, 2401, {1, 1, 5, 11, 27, 45, 11, 183, 433, 237, 745, 161, 6935, 9285, 4283, 25643, 43061}},
    {6013, 17, 2408, {1, 3, 1, 3, 3, 37, 41, 245, 117, 513, 711, 2555, 223, 6465, 6545, 51501, 66045}},
    {6014, 17, 2414, {1, 3, 7, 9, 1, 27, 5, 37, 227, 591, 1199, 2823, 5027, 7547, 6913, 56871, 49123}},
    {6015, 17, 2419, {1, 1, 1, 5, 3, 53, 95, 137, 75, 399, 1713, 3065, 8137, 9237, 4511, 33563, 775}},
    {6016, 17, 2428, {1, 3, 1, 5, 19, 37, 77, 143, 209, 811, 145, 1573, 263, 309, 7895, 15433, 122667}},
    {6017, 17, 2441, {1, 1, 3, 9, 29, 13, 75, 77, 301, 709, 1847, 2431, 483, 451, 22615, 48123, 73161}},
    {6018, 17, 2444, {1, 1, 1, 3, 9, 29, 113, 247, 233, 949, 753, 1871, 1051, 15753, 10069, 30687, 95793}},
    {6019, 17, 2461, {1, 1, 5, 9, 9, 55, 113, 103, 351, 481, 665, 1631, 3907, 7029, 26039, 45945, 126111}},
    {6020, 17, 2480, {1, 3, 7, 3, 7, 21, 111, 47, 471, 395, 875, 611, 7047, 15751, 28533, 36257, 48969}},
    {6021, 17, 2483, {1, 1, 1, 15, 19, 1, 69, 233, 85, 547, 1073, 461, 3663, 7369, 21425, 15799, 19385}},
    {6022, 17, 2486, {1, 1, 3, 11, 3, 5, 111, 205, 105, 7, 1083, 2863, 4489, 7345, 14971, 11337, 64551}},
    {6023, 17, 2489, {1, 3, 5, 5, 9, 9, 115, 43, 139, 41, 903, 3981, 2445, 3451, 32137, 56409, 42237}},
    {6024, 17, 2490, {1, 1, 5, 1, 5, 27, 55, 87, 353, 299, 1565, 3861, 1355, 3789, 29439, 60481, 29239}},
    {6025, 17, 2518, {1, 3, 7, 13, 29, 19, 97, 85, 251, 799, 1813, 1081, 309, 15483, 12815, 55065, 5761}},
    {6026, 17, 2527, {1, 1, 7, 7, 5, 31, 71, 65, 69, 243, 341, 2219, 267, 1657, 14251, 28923, 73929}},
    {6027, 17, 2540, {1, 1, 1, 5, 23, 21, 115, 137, 413, 545, 1015, 867, 7461, 5001, 1809, 6579, 26067}},
    {6028, 17, 2558, {1, 3, 7, 5, 15, 61, 101, 33, 263, 313, 1647, 2137, 1827, 7541, 29501, 63243, 106235}},
    {6029, 17, 2567, {1, 3, 5, 3, 17, 5, 97, 193, 121, 511, 1397, 523, 1737, 7259, 16865, 25819, 41401}},
    {6030, 17, 2571, {1, 1, 7, 7, 3, 19, 71, 167, 465, 693, 189, 3259, 4765, 9739, 18355, 57063, 73161}},
    {6031, 17, 2574, {1, 1, 5, 3, 25, 61, 11, 61, 153, 511, 819, 3633, 3269, 13205, 17931, 60837, 76087}},
    {6032, 17, 2579, {1, 3, 5, 9, 5, 27, 41, 91, 87, 801, 1431, 2113, 7247, 1489, 10957, 38481, 12269}},
    {6033, 17, 2585, {1, 1, 5, 11, 19, 63, 101, 23, 85, 665, 2005, 1113, 4563, 12109, 11375, 59583, 63257}},
    {6034, 17, 2615, {1, 3, 5, 13, 25, 11, 75, 143, 129, 803, 417, 279, 7963, 10087, 5029, 56367, 60959}},
    {6035, 17, 2639, {1, 1, 3, 7, 3, 17, 91, 215, 109, 857, 703, 549, 1607, 7621, 7323, 44659, 66665}},
    {6036, 17, 2641, {1, 1, 1, 3, 1, 3, 23, 101, 11, 159, 1683, 2811, 5383, 2623, 10179, 45861, 105913}},
    {6037, 17, 2644, {1, 1, 7, 11, 27, 57, 45, 87, 501, 53, 147, 783, 3699, 1281, 15139, 10059, 95459}},
    {6038, 17, 2663, {1, 1, 1, 1, 3, 3, 65, 11, 435, 23, 269, 3879, 3783, 13623, 17023, 62043, 97827}},
    {6039, 17, 2667, {1, 3, 3, 9, 23, 45, 17, 131, 27, 11, 169, 279, 5535, 7741, 31761, 35745, 71653}},
    {6040, 17, 2669, {1, 3, 7, 5, 11, 15, 69, 241, 301, 421, 1053, 3985, 6959, 15769, 24391, 42573, 86653}},
    {6041, 17, 2672, {1, 1, 3, 15, 7, 31, 127, 251, 197, 443, 131, 3201, 3639, 15863, 21813, 21445, 97625}},
    {6042, 17, 2687, {1, 3, 1, 15, 19, 37, 23, 25, 81, 147, 1929, 903, 4373, 2757, 11547, 51917, 117007}},
    {6043, 17, 2700, {1, 3, 7, 3, 15, 51, 55, 213, 463, 117, 1263, 1065, 249, 10965, 20949, 44069, 49957}},
    {6044, 17, 2705, {1, 3, 3, 15, 9, 33, 109, 79, 219, 773, 1391, 21, 299, 2253, 5899, 3979, 26837}},
    {6045, 17, 2724, {1, 1, 5, 7, 9, 11, 113, 229, 25, 489, 1529, 3825, 4079, 14715, 26889, 57637, 96707}},
    {6046, 17, 2728, {1, 3, 5, 7, 25, 35, 71, 141, 173, 979, 1025, 3869, 7183, 9841, 28833, 21061, 62289}},
    {6047, 17, 2733, {1, 3, 3, 11, 29, 53, 31, 157, 31, 637, 149, 2035, 5337, 5965, 22819, 33151, 2001}},
    {6048, 17, 2741, {1, 3, 5, 9, 11, 27, 65, 169, 17, 707, 1275, 1415, 6497, 10383, 28277, 12955, 43823}},
    {6049, 17, 2748, {1, 3, 1, 5, 11, 49, 75, 247, 229, 627, 1237, 1175, 3619, 3345, 3117, 61505, 96411}},
    {6050, 17, 2751, {1, 1, 5, 15, 11, 39, 75, 37, 27, 135, 1421, 1481, 7197, 10357, 29185, 11765, 23181}},
    {6051, 17, 2756, {1, 1, 5, 1, 13, 25, 19, 29, 17, 929, 57, 2243, 2425, 6783, 8523, 55431, 4639}},
    {6052, 17, 2771, {1, 1, 1, 1, 1, 31, 9, 109, 307, 639, 1655, 1359, 3789, 11845, 12803, 19929, 42863}},
    {6053, 17, 2774, {1, 1, 3, 1, 17, 59, 37, 183, 385, 791, 553, 1693, 2167, 7071, 19181, 24915, 79233}},
    {6054, 17, 2793, {1, 3, 7, 15, 21, 39, 75, 111, 385, 267, 2027, 2085, 4275, 5031, 13915, 44159, 37947}},
    {6055, 17, 2796, {1, 1, 5, 11, 19, 27, 99, 59, 41, 217, 1915, 1247, 6199, 15927, 20983, 8803, 53797}},
    {6056, 17, 2804, {1, 1, 7, 15, 29, 5, 57, 175, 79, 133, 1551, 2329, 5959, 9799, 21923, 8045, 34407}},
    {6057, 17, 2814, {1, 1, 7, 3, 13, 63, 99, 241, 191, 625, 1865, 247, 7727, 16371, 7337, 36479, 47065}},
    {6058, 17, 2822, {1, 3, 1, 5, 3, 29, 51, 171, 379, 563, 1659, 873, 7505, 11053, 15899, 46983, 44811}},
    {6059, 17, 2845, {1, 3, 5, 7, 15, 17, 73, 131, 381, 531, 153, 2381, 2179, 14849, 8079, 58143, 43107}},
    {6060, 17, 2846, {1, 3, 7, 9, 11, 11, 25, 213, 431, 161, 511, 2037, 145, 13583, 7709, 42165, 4079}},
    {6061, 17, 2850, {1, 1, 3, 1, 29, 13, 103, 159, 189, 469, 257, 1751, 509, 5171, 10671, 19129, 125333}},
    {6062, 17, 2855, {1, 3, 1, 13, 7, 1, 121, 27, 209, 375, 167, 2421, 6603, 9801, 31523, 3515, 94395}},
    {6063, 17, 2856, {1, 3, 7, 1, 9, 47, 85, 129, 335, 633, 239, 527, 343, 13999, 8593, 29669, 9915}},
    {6064, 17, 2867, {1, 3, 3, 9, 15, 29, 115, 193, 489, 867, 363, 145, 4117, 1277, 7693, 47523, 121581}},
    {6065, 17, 2891, {1, 3, 7, 5, 31, 53, 59, 95, 441, 765, 1949, 769, 795, 205, 30079, 10895, 55099}},
    {6066, 17, 2894, {1, 3, 7, 13, 31, 25, 123, 55, 417, 837, 1375, 711, 8125, 4723, 21291, 46843, 45241}},
    {6067, 17, 2902, {1, 3, 3, 11, 9, 21, 39, 169, 275, 879, 1231, 533, 231, 6621, 19025, 48475, 81839}},
    {6068, 17, 2908, {1, 1, 1, 3, 5, 11, 5, 51, 125, 287, 1439, 1195, 1361, 317, 765, 12923, 9043}},
    {6069, 17, 2951, {1, 1, 5, 3, 17, 41, 75, 185, 209, 171, 711, 611, 7921, 1167, 28123, 56361, 124089}},
    {6070, 17, 2970, {1, 1, 1, 7, 27, 59, 41, 215, 157, 725, 2019, 1631, 7141, 15503, 6727, 779, 99897}},
    {6071, 17, 2972, {1, 3, 7, 5, 17, 7, 17, 85, 377, 881, 1843, 2825, 6803, 4429, 22875, 49001, 83931}},
    {6072, 17, 2975, {1, 3, 3, 13, 9, 63, 33, 47, 431, 803, 887, 2893, 2737, 9795, 15329, 62361, 115259}},
    {6073, 17, 2976, {1, 3, 5, 7, 3, 49, 33, 181, 263, 49, 1951, 889, 263, 6461, 17899, 24269, 37703}},
    {6074, 17, 2981, {1, 1, 5, 9, 3, 5, 45, 223, 121, 905, 679, 3581, 3589, 451, 30911, 40209, 5241}},
    {6075, 17, 2986, {1, 1, 5, 13, 9, 45, 65, 223, 231, 757, 1553, 3657, 6791, 1539, 7423, 19237, 45281}},
    {6076, 17, 2999, {1, 3, 5, 5, 3, 5, 57, 141, 85, 705, 135, 2929, 4159, 10369, 1835, 60231, 23943}},
    {6077, 17, 3000, {1, 1, 5, 7, 21, 29, 109, 219, 505, 7, 427, 1745, 2499, 6859, 25009, 1353, 5113}},
    {6078, 17, 3006, {1, 3, 7, 13, 9, 5, 31, 121, 43, 613, 1225, 2229, 2473, 2203, 18807, 57625, 46063}},
    {6079, 17, 3014, {1, 3, 7, 5, 13, 9, 127, 185, 103, 227, 1151, 2113, 4503, 11041, 19095, 55879, 116887}},
    {6080, 17, 3028, {1, 1, 7, 11, 9, 25, 7, 211, 319, 805, 985, 3107, 1643, 4817, 24003, 63819, 57949}},
    {6081, 17, 3031, {1, 3, 3, 11, 25, 13, 109, 55, 269, 641, 1797, 3357, 5629, 13807, 29805, 16899, 91281}},
    {6082, 17, 3035, {1, 3, 1, 5, 17, 1, 65, 117, 425, 139, 171, 1277, 4677, 5959, 3775, 10249, 30561}},
    {6083, 17, 3037, {1, 3, 3, 7, 3, 53, 107, 235, 435, 93, 1469, 3093, 1509, 357, 16927, 3963, 70413}},
    {6084, 17, 3053, {1, 3, 3, 13, 17, 51, 53, 213, 367, 849, 715, 1909, 3743, 9891, 26905, 17409, 48265}},
    {6085, 17, 3059, {1, 1, 3, 9, 13, 59, 35, 175, 167, 453, 1923, 3889, 2929, 15963, 18387, 863, 12677}},
    {6086, 17, 3065, {1, 1, 7, 15, 1, 1, 81, 19, 177, 205, 125, 2169, 2969, 13895, 15923, 36715, 103473}},
    {6087, 17, 3080, {1, 1, 1, 11, 15, 45, 43, 73, 15, 415, 361, 1543, 4591, 7989, 21731, 42933, 36079}},
    {6088, 17, 3091, {1, 3, 7, 7, 3, 27, 79, 63, 341, 953, 725, 1749, 6357, 5597, 14225, 14037, 71129}},
    {6089, 17, 3094, {1, 1, 1, 13, 11, 63, 9, 155, 259, 165, 1653, 89, 3549, 583, 8657, 21019, 62469}},
    {6090, 17, 3109, {1, 1, 3, 9, 5, 47, 51, 81, 129, 391, 215, 545, 6287, 11043, 17689, 38571, 70795}},
    {6091, 17, 3110, {1, 1, 5, 13, 7, 3, 95, 167, 105, 315, 159, 2619, 2351, 2347, 25035, 7921, 111871}},
    {6092, 17, 3113, {1, 3, 1, 7, 21, 19, 75, 231, 479, 1023, 607, 857, 8001, 1155, 11311, 35471, 58909}},
    {6093, 17, 3116, {1, 3, 1, 9, 29, 7, 21, 107, 135, 577, 153, 499, 2307, 14841, 14529, 52803, 129515}},
    {6094, 17, 3136, {1, 3, 1, 11, 3, 39, 79, 77, 433, 979, 1819, 3805, 7029, 5949, 3789, 2371, 112203}},
    {6095, 17, 3139, {1, 1, 3, 1, 27, 7, 51, 119, 97, 511, 703, 1551, 715, 4441, 2065, 45769, 5665}},
    {6096, 17, 3141, {1, 1, 1, 15, 17, 3, 65, 3, 169, 903, 1101, 331, 371, 10211, 1613, 47261, 2941}},
    {6097, 17, 3154, {1, 3, 5, 7, 11, 51, 75, 49, 199, 575, 1455, 1881, 5037, 4813, 26991, 59029, 105041}},
    {6098, 17, 3160, {1, 1, 7, 3, 11, 59, 97, 213, 7, 823, 865, 3597, 865, 6793, 10237, 32289, 25365}},
    {6099, 17, 3169, {1, 3, 7, 3, 5, 1, 53, 39, 255, 75, 473, 1433, 1539, 41, 29961, 43697, 34437}},
    {6100, 17, 3182, {1, 1, 1, 7, 7, 63, 21, 49, 279, 539, 1249, 3201, 8137, 15427, 1089, 37679, 83853}},
    {6101, 17, 3187, {1, 3, 1, 11, 17, 9, 5, 133, 323, 637, 191, 2877, 6913, 6559, 30615, 46473, 128451}},
    {6102, 17, 3189, {1, 3, 7, 13, 7, 33, 111, 131, 201, 893, 1673, 2249, 7117, 6205, 7777, 54301, 22263}},
    {6103, 17, 3190, {1, 3, 1, 15, 11, 15, 83, 35, 403, 61, 707, 573, 4443, 10771, 2055, 21231, 29181}},
    {6104, 17, 3203, {1, 3, 3, 7, 13, 19, 63, 47, 355, 107, 687, 2241, 6135, 14045, 20395, 40741, 130769}},
    {6105, 17, 3217, {1, 1, 1, 15, 29, 31, 109, 165, 235, 471, 7, 1673, 2057, 13927, 12467, 3729, 17245}},
    {6106, 17, 3229, {1, 1, 3, 5, 19, 15, 109, 67, 23, 989, 2037, 2787, 5545, 6723, 1087, 18821, 97955}},
    {6107, 17, 3236, {1, 1, 1, 15, 17, 39, 59, 231, 263, 197, 1365, 1331, 3629, 11671, 6069, 24087, 110929}},
    {6108, 17, 3248, {1, 3, 5, 5, 17, 23, 105, 253, 281, 375, 1039, 723, 7469, 15037, 4955, 29255, 26265}},
    {6109, 17, 3257, {1, 1, 7, 7, 27, 35, 61, 177, 425, 351, 137, 701, 7455, 14681, 16239, 4141, 117489}},
    {6110, 17, 3278, {1, 1, 5, 15, 13, 19, 23, 237, 95, 95, 735, 1759, 2035, 9317, 23103, 54905, 69891}},
    {6111, 17, 3283, {1, 1, 5, 1, 17, 11, 69, 243, 351, 957, 887, 3945, 7387, 311, 22821, 44351, 84787}},
    {6112, 17, 3289, {1, 1, 1, 5, 27, 25, 113, 91, 99, 379, 845, 3613, 2409, 12713, 6451, 2907, 111621}},
    {6113, 17, 3292, {1, 3, 7, 1, 7, 13, 65, 213, 163, 689, 1183, 283, 5669, 995, 25941, 30451, 66845}},
    {6114, 17, 3302, {1, 1, 7, 9, 9, 45, 107, 155, 21, 267, 41, 1845, 845, 3695, 3979, 5041, 70375}},
    {6115, 17, 3316, {1, 3, 3, 3, 23, 33, 65, 251, 81, 525, 1683, 2975, 6127, 15723, 11549, 21723, 88477}},
    {6116, 17, 3328, {1, 3, 1, 15, 29, 15, 23, 223, 299, 587, 1497, 4067, 5381, 10501, 9013, 4275, 27695}},
    {6117, 17, 3333, {1, 1, 1, 3, 27, 23, 9, 75, 11, 261, 89, 2075, 3217, 10103, 17315, 28117, 14619}},
    {6118, 17, 3337, {1, 3, 5, 7, 25, 33, 11, 83, 69, 1003, 783, 207, 5891, 15197, 10855, 5531, 130273}},
    {6119, 17, 3340, {1, 3, 7, 7, 17, 27, 47, 125, 447, 997, 1497, 3125, 4819, 2575, 27399, 1979, 13951}},
    {6120, 17, 3368, {1, 1, 1, 5, 17, 31, 71, 189, 367, 937, 461, 1029, 2707, 5511, 30415, 5633, 69951}},
    {6121, 17, 3371, {1, 1, 7, 15, 21, 15, 115, 223, 177, 895, 459, 2287, 2955, 733, 20411, 21401, 120283}},
    {6122, 17, 3376, {1, 1, 1, 15, 29, 45, 29, 201, 401, 891, 1561, 3761, 8185, 625, 29869, 6565, 73877}},
    {6123, 17, 3385, {1, 3, 1, 15, 5, 9, 75, 175, 217, 927, 685, 1911, 149, 8127, 31965, 34557, 17561}},
    {6124, 17, 3386, {1, 3, 1, 1, 23, 15, 13, 149, 457, 493, 919, 139, 5697, 3707, 27867, 21489, 124371}},
    {6125, 17, 3393, {1, 1, 3, 15, 21, 13, 11, 61, 195, 99, 1897, 2143, 2733, 9365, 17419, 26177, 101641}},
    {6126, 17, 3399, {1, 3, 1, 1, 5, 57, 55, 239, 483, 865, 69, 2911, 4139, 13297, 29967, 56977, 114909}},
    {6127, 17, 3405, {1, 3, 7, 15, 17, 43, 113, 43, 413, 789, 939, 3545, 1339, 12469, 29797, 2809, 129471}},
    {6128, 17, 3414, {1, 1, 7, 5, 19, 41, 75, 233, 467, 639, 1779, 3827, 8111, 7997, 21243, 28787, 93343}},
    {6129, 17, 3433, {1, 3, 3, 3, 19, 49, 1, 215, 455, 805, 23, 137, 25, 14795, 21055, 63157, 68819}},
    {6130, 17, 3436, {1, 1, 3, 15, 11, 35, 127, 83, 487, 247, 1783, 2419, 5929, 8725, 30147, 55845, 100403}},
    {6131, 17, 3448, {1, 3, 5, 9, 21, 15, 11, 23, 255, 81, 723, 2765, 3573, 3125, 7417, 46833, 128775}},
    {6132, 17, 3467, {1, 3, 5, 9, 5, 37, 45, 221, 113, 311, 2045, 3113, 103, 8205, 31125, 30357, 98457}},
    {6133, 17, 3469, {1, 3, 5, 11, 25, 13, 11, 253, 133, 591, 1103, 2867, 3359, 9507, 29245, 11317, 79077}},
    {6134, 17, 3472, {1, 3, 7, 13, 11, 23, 95, 195, 421, 355, 891, 1409, 3621, 13283, 25607, 65485, 25191}},
    {6135, 17, 3477, {1, 1, 7, 13, 5, 27, 29, 149, 25, 743, 1045, 545, 299, 10533, 22547, 25299, 116655}},
    {6136, 17, 3484, {1, 3, 5, 15, 25, 39, 41, 187, 321, 979, 419, 445, 979, 4543, 13833, 60347, 19925}},
    {6137, 17, 3494, {1, 1, 3, 5, 3, 33, 57, 153, 375, 35, 1405, 3903, 5337, 3847, 26843, 35825, 2911}},
    {6138, 17, 3505, {1, 3, 1, 13, 7, 51, 71, 141, 427, 645, 217, 3983, 2799, 4017, 12537, 2445, 40305}},
    {6139, 17, 3515, {1, 1, 1, 15, 11, 47, 103, 111, 415, 427, 1027, 875, 85, 11001, 11209, 31755, 11983}},
    {6140, 17, 3523, {1, 1, 3, 13, 29, 35, 117, 81, 235, 583, 1915, 2975, 2119, 13693, 26767, 32811, 32817}},
    {6141, 17, 3530, {1, 3, 7, 1, 17, 53, 71, 11, 277, 503, 389, 3811, 2741, 8975, 3815, 53517, 43233}},
    {6142, 17, 3543, {1, 1, 3, 5, 23, 43, 45, 41, 261, 681, 1177, 2007, 5441, 1507, 11579, 54001, 69625}},
    {6143, 17, 3559, {1, 1, 7, 9, 25, 33, 37, 33, 211, 221, 273, 2257, 6565, 15801, 4911, 1781, 60147}},
    {6144, 17, 3568, {1, 3, 3, 11, 1, 27, 109, 79, 179, 469, 1843, 3955, 61, 6181, 27555, 32015, 46623}},
    {6145, 17, 3577, {1, 1, 3, 11, 21, 17, 45, 63, 77, 497, 439, 4077, 4047, 273, 3233, 54695, 22013}},
    {6146, 17, 3578, {1, 1, 1, 5, 29, 45, 47, 209, 325, 67, 345, 3215, 6587, 11135, 10831, 52485, 31981}},
    {6147, 17, 3594, {1, 3, 7, 7, 11, 43, 81, 253, 117, 503, 1401, 3265, 3473, 15407, 16477, 15559, 62065}},
    {6148, 17, 3601, {1, 3, 1, 15, 25, 33, 61, 207, 135, 393, 359, 169, 2497, 1527, 2523, 26407, 22661}},
    {6149, 17, 3607, {1, 1, 5, 15, 25, 17, 9, 163, 389, 349, 1553, 3363, 373, 3949, 23307, 21843, 106055}},
    {6150, 17, 3608, {1, 1, 7, 9, 7, 19, 47, 15, 353, 3, 1345, 2247, 5685, 2093, 7735, 15041, 58191}},
    {6151, 17, 3620, {1, 3, 7, 11, 3, 3, 121, 149, 39, 337, 953, 99, 8069, 2539, 4135, 58257, 50179}},
    {6152, 17, 3629, {1, 3, 1, 3, 1, 33, 23, 233, 333, 325, 1307, 119, 1497, 15787, 17237, 18703, 29127}},
    {6153, 17, 3644, {1, 1, 3, 13, 5, 23, 15, 177, 461, 717, 579, 2441, 3981, 2779, 16263, 44831, 97375}},
    {6154, 17, 3656, {1, 3, 3, 13, 5, 49, 23, 183, 365, 227, 1281, 3709, 7123, 9297, 24413, 19029, 55305}},
    {6155, 17, 3664, {1, 1, 1, 15, 15, 29, 117, 211, 5, 621, 181, 623, 3525, 14943, 31071, 13507, 107313}},
    {6156, 17, 3670, {1, 3, 1, 3, 13, 15, 107, 119, 347, 913, 885, 1361, 7955, 10695, 8343, 54301, 30915}},
    {6157, 17, 3680, {1, 1, 3, 11, 5, 1, 95, 231, 61, 875, 821, 3787, 4275, 1085, 16777, 26363, 16585}},
    {6158, 17, 3685, {1, 3, 1, 7, 15, 61, 101, 131, 13, 87, 1457, 2131, 4267, 13487, 15553, 6283, 118209}},
    {6159, 17, 3686, {1, 1, 1, 7, 5, 53, 45, 33, 175, 101, 495, 301, 4253, 11961, 25325, 45953, 8607}},
    {6160, 17, 3695, {1, 1, 7, 13, 29, 49, 125, 63, 275, 295, 437, 3739, 5099, 5373, 4315, 56861, 57535}},
    {6161, 17, 3698, {1, 3, 5, 7, 7, 45, 101, 219, 87, 703, 1163, 2881, 4333, 11029, 10199, 8605, 2333}},
    {6162, 17, 3703, {1, 1, 7, 9, 31, 45, 39, 249, 483, 71, 391, 1043, 5565, 6015, 9155, 8785, 103357}},
    {6163, 17, 3710, {1, 1, 7, 1, 11, 21, 123, 191, 321, 185, 2043, 355, 8007, 3115, 4303, 40743, 90683}},
    {6164, 17, 3714, {1, 1, 3, 1, 13, 7, 101, 23, 145, 33, 423, 2773, 7923, 10665, 11093, 5381, 108369}},
    {6165, 17, 3726, {1, 1, 7, 7, 25, 55, 121, 7, 333, 195, 151, 1929, 8105, 7777, 19017, 947, 69793}},
    {6166, 17, 3731, {1, 1, 5, 3, 17, 3, 121, 89, 221, 209, 21, 743, 1345, 7961, 18713, 27141, 123963}},
    {6167, 17, 3733, {1, 1, 7, 9, 19, 61, 121, 73, 211, 299, 1773, 3473, 57, 9279, 28757, 45871, 7105}},
    {6168, 17, 3737, {1, 1, 1, 13, 11, 17, 59, 39, 265, 189, 1569, 1193, 2935, 7531, 9739, 6525, 13125}},
    {6169, 17, 3756, {1, 3, 3, 9, 5, 3, 27, 241, 1, 983, 1279, 561, 5853, 11955, 5047, 8253, 47501}},
    {6170, 17, 3759, {1, 3, 7, 7, 5, 11, 9, 173, 461, 99, 1259, 3145, 7671, 15353, 20951, 29321, 93593}},
    {6171, 17, 3767, {1, 1, 7, 1, 13, 17, 15, 135, 143, 319, 605, 2509, 1969, 6165, 14139, 19059, 111175}},
    {6172, 17, 3776, {1, 3, 5, 9, 31, 49, 47, 125, 367, 37, 1163, 585, 2569, 15925, 17521, 31671, 2635}},
    {6173, 17, 3785, {1, 1, 7, 15, 11, 5, 111, 39, 409, 837, 665, 1975, 4173, 11617, 14625, 33743, 91429}},
    {6174, 17, 3793, {1, 3, 7, 1, 21, 19, 95, 15, 375, 499, 1273, 1255, 2765, 9319, 1577, 26229, 81381}},
    {6175, 17, 3812, {1, 3, 1, 3, 31, 31, 85, 171, 115, 173, 2031, 3183, 1887, 7563, 26045, 37387, 129141}},
    {6176, 17, 3815, {1, 1, 1, 9, 5, 31, 23, 225, 95, 1007, 761, 3461, 1523, 6453, 4563, 11563, 17459}},
    {6177, 17, 3824, {1, 3, 5, 11, 31, 41, 47, 219, 61, 603, 677, 3041, 87, 5351, 23291, 10115, 9167}},
    {6178, 17, 3844, {1, 3, 1, 3, 1, 49, 55, 11, 97, 259, 1461, 1751, 2011, 6845, 11725, 43363, 37257}},
    {6179, 17, 3859, {1, 3, 3, 15, 7, 13, 79, 171, 303, 43, 739, 761, 7841, 551, 15731, 34587, 11021}},
    {6180, 17, 3866, {1, 1, 1, 3, 15, 49, 31, 73, 177, 425, 1423, 83, 4487, 11299, 995, 39927, 15383}},
    {6181, 17, 3872, {1, 1, 3, 3, 3, 11, 121, 81, 105, 995, 583, 1205, 2895, 4713, 29353, 25741, 33105}},
    {6182, 17, 3884, {1, 1, 7, 1, 19, 53, 15, 213, 279, 1011, 2045, 3237, 7375, 14437, 4263, 40509, 21463}},
    {6183, 17, 3889, {1, 3, 3, 3, 15, 17, 111, 213, 253, 465, 981, 3881, 5133, 9163, 2101, 10357, 101101}},
    {6184, 17, 3899, {1, 1, 7, 5, 29, 53, 111, 171, 121, 703, 2023, 2751, 3527, 987, 1043, 52973, 60943}},
    {6185, 17, 3902, {1, 3, 7, 11, 9, 17, 67, 7, 445, 15, 201, 1773, 1773, 11503, 28407, 39241, 98557}},
    {6186, 17, 3909, {1, 3, 3, 9, 25, 59, 121, 207, 223, 1001, 549, 347, 265, 11289, 28993, 38411, 85213}},
    {6187, 17, 3913, {1, 1, 7, 15, 5, 35, 19, 231, 299, 43, 595, 2081, 2129, 5685, 27035, 31371, 53043}},
    {6188, 17, 3933, {1, 3, 7, 5, 27, 55, 39, 149, 241, 391, 807, 3769, 5561, 3859, 10373, 2403, 77421}},
    {6189, 17, 3938, {1, 1, 5, 13, 29, 53, 23, 237, 125, 603, 489, 3747, 651, 501, 8297, 45851, 41545}},
    {6190, 17, 3949, {1, 1, 5, 7, 7, 53, 97, 179, 293, 505, 1031, 2733, 3361, 3777, 14535, 37587, 78477}},
    {6191, 17, 3952, {1, 1, 1, 3, 21, 55, 107, 135, 145, 249, 71, 3211, 3175, 6627, 8503, 5547, 82019}},
    {6192, 17, 3980, {1, 1, 1, 11, 23, 5, 99, 137, 199, 647, 1355, 1843, 2877, 3007, 25819, 15095, 69939}},
    {6193, 17, 3991, {1, 1, 1, 1, 11, 23, 21, 211, 49, 185, 1703, 2651, 5597, 5597, 11705, 10131, 41865}},
    {6194, 17, 3992, {1, 3, 1, 11, 25, 47, 53, 155, 125, 7, 1299, 453, 6351, 6697, 23849, 64517, 79913}},
    {6195, 17, 4002, {1, 3, 5, 11, 7, 35, 45, 85, 195, 909, 397, 1023, 3831, 11899, 10931, 64309, 52503}},
    {6196, 17, 4008, {1, 1, 5, 7, 5, 57, 61, 125, 305, 151, 961, 1489, 323, 5653, 32507, 53597, 18219}},
    {6197, 17, 4011, {1, 1, 1, 15, 13, 9, 125, 55, 213, 217, 1745, 1403, 1651, 5939, 3443, 49323, 15735}},
    {6198, 17, 4016, {1, 1, 3, 11, 3, 31, 59, 119, 275, 983, 2033, 1533, 8163, 7581, 24645, 58395, 54215}},
    {6199, 17, 4034, {1, 3, 5, 9, 29, 37, 1, 177, 69, 989, 1481, 1383, 751, 10227, 17117, 2371, 109921}},
    {6200, 17, 4036, {1, 3, 7, 7, 7, 25, 47, 171, 273, 65, 347, 1697, 257, 13439, 30477, 93, 108915}},
    {6201, 17, 4063, {1, 3, 1, 15, 7, 29, 39, 121, 391, 661, 1561, 355, 5829, 4119, 26397, 20313, 27689}},
    {6202, 17, 4067, {1, 1, 1, 11, 23, 29, 45, 125, 65, 139, 737, 1779, 7109, 14263, 28117, 15705, 35687}},
    {6203, 17, 4073, {1, 3, 3, 3, 19, 25, 71, 5, 433, 225, 1035, 1041, 1423, 12005, 9589, 38181, 58583}},
    {6204, 17, 4082, {1, 1, 1, 5, 17, 35, 19, 55, 355, 645, 1205, 2047, 7691, 16369, 29197, 29513, 82729}},
    {6205, 17, 4091, {1, 1, 1, 1, 31, 31, 105, 25, 123, 213, 795, 3749, 1653, 7211, 25189, 46563, 97043}},
    {6206, 17, 4093, {1, 3, 7, 3, 19, 17, 47, 103, 189, 733, 1631, 2201, 4837, 7911, 23145, 23003, 32561}},
    {6207, 17, 4101, {1, 3, 5, 7, 5, 3, 1, 153, 205, 829, 155, 815, 1821, 2305, 28403, 5495, 114981}},
    {6208, 17, 4113, {1, 3, 1, 5, 25, 31, 11, 107, 293, 105, 1971, 433, 4743, 6379, 25273, 33845, 101525}},
    {6209, 17, 4120, {1, 1, 5, 13, 19, 47, 113, 123, 357, 825, 719, 1067, 2215, 10663, 25799, 13113, 79815}},
    {6210, 17, 4125, {1, 1, 7, 7, 11, 3, 45, 167, 147, 439, 669, 3745, 1919, 11083, 123, 18255, 98529}},
    {6211, 17, 4126, {1, 3, 1, 15, 27, 43, 59, 237, 175, 85, 1363, 1971, 6375, 12593, 7297, 37067, 64963}},
    {6212, 17, 4139, {1, 3, 1, 7, 3, 15, 63, 91, 505, 579, 483, 3919, 1087, 7109, 9449, 30545, 111703}},
    {6213, 17, 4142, {1, 3, 7, 15, 15, 13, 59, 41, 41, 775, 1041, 2941, 2455, 6021, 11989, 55727, 62193}},
    {6214, 17, 4144, {1, 3, 1, 1, 7, 63, 105, 139, 167, 375, 1065, 2109, 1241, 8745, 11137, 19945, 82233}},
    {6215, 17, 4147, {1, 1, 5, 1, 21, 35, 113, 91, 1, 575, 737, 939, 4995, 10575, 26033, 28237, 101007}},
    {6216, 17, 4153, {1, 3, 5, 5, 29, 59, 79, 163, 173, 525, 781, 3397, 4623, 15833, 9259, 43607, 17609}},
    {6217, 17, 4154, {1, 1, 7, 7, 29, 41, 17, 73, 155, 621, 1443, 3501, 3003, 1127, 30373, 1307, 379}},
    {6218, 17, 4164, {1, 3, 1, 5, 17, 29, 27, 57, 285, 257, 1675, 1405, 7175, 10003, 1445, 41049, 14355}},
    {6219, 17, 4174, {1, 3, 5, 3, 25, 23, 57, 207, 157, 1007, 39, 1327, 7505, 10359, 15601, 13357, 10237}},
    {6220, 17, 4182, {1, 3, 5, 9, 31, 61, 61, 77, 309, 607, 865, 1117, 2417, 4505, 22687, 55765, 123771}},
    {6221, 17, 4185, {1, 1, 7, 5, 15, 19, 29, 245, 465, 855, 1777, 3189, 1547, 3167, 3539, 48871, 39905}},
    {6222, 17, 4188, {1, 1, 1, 15, 27, 51, 69, 31, 27, 437, 1663, 3029, 1587, 9791, 1353, 21725, 19555}},
    {6223, 17, 4191, {1, 3, 1, 11, 23, 17, 17, 219, 389, 721, 1851, 2053, 331, 12057, 8633, 22015, 75043}},
    {6224, 17, 4195, {1, 3, 1, 5, 27, 3, 85, 113, 331, 145, 69, 667, 1315, 2143, 12701, 64515, 42059}},
    {6225, 17, 4219, {1, 1, 1, 5, 7, 41, 121, 227, 313, 163, 1561, 2819, 7203, 10311, 14725, 13029, 38637}},
    {6226, 17, 4225, {1, 3, 7, 3, 23, 41, 71, 215, 113, 97, 489, 203, 5241, 6819, 29535, 64457, 25263}},
    {6227, 17, 4228, {1, 1, 3, 11, 29, 33, 121, 151, 125, 61, 945, 2837, 8139, 12303, 32457, 40303, 67299}},
    {6228, 17, 4232, {1, 1, 5, 7, 13, 57, 13, 51, 489, 1009, 1777, 599, 6969, 11511, 7661, 56831, 68433}},
    {6229, 17, 4246, {1, 1, 5, 13, 1, 27, 115, 155, 35, 997, 1347, 4001, 8051, 7567, 4221, 63915, 88615}},
    {6230, 17, 4255, {1, 1, 5, 11, 21, 33, 125, 113, 321, 279, 149, 2621, 8133, 3935, 30149, 42863, 15513}},
    {6231, 17, 4274, {1, 3, 5, 15, 9, 47, 71, 177, 175, 173, 413, 2431, 6335, 11623, 30355, 25131, 59351}},
    {6232, 17, 4283, {1, 1, 7, 13, 3, 19, 17, 105, 425, 375, 1121, 2101, 2031, 6397, 3011, 20375, 80135}},
    {6233, 17, 4286, {1, 1, 5, 11, 27, 53, 113, 207, 87, 915, 41, 3, 3853, 11303, 27759, 64279, 64273}},
    {6234, 17, 4306, {1, 3, 5, 9, 15, 3, 99, 179, 33, 951, 1183, 1587, 5723, 6911, 6887, 1475, 116289}},
    {6235, 17, 4311, {1, 1, 7, 3, 15, 35, 81, 95, 343, 233, 1631, 235, 2451, 9479, 28885, 49825, 7755}},
    {6236, 17, 4317, {1, 1, 1, 9, 1, 7, 41, 133, 267, 653, 59, 2765, 1685, 16073, 27461, 36243, 100221}},
    {6237, 17, 4321, {1, 3, 3, 1, 17, 9, 107, 157, 23, 649, 1087, 2499, 5979, 5719, 17951, 49577, 91523}},
    {6238, 17, 4324, {1, 1, 3, 13, 9, 37, 29, 69, 91, 777, 319, 1041, 4861, 10801, 8417, 14781, 34401}},
    {6239, 17, 4331, {1, 1, 7, 5, 11, 33, 67, 171, 301, 469, 435, 1591, 3801, 1955, 919, 35725, 52391}},
    {6240, 17, 4333, {1, 1, 7, 5, 11, 39, 55, 57, 309, 519, 937, 205, 37, 4761, 5625, 33637, 89903}},
    {6241, 17, 4359, {1, 1, 5, 11, 17, 11, 11, 131, 267, 323, 925, 3903, 1531, 4309, 8367, 33409, 48025}},
    {6242, 17, 4360, {1, 1, 1, 7, 31, 63, 53, 149, 483, 445, 195, 2197, 4209, 9423, 27235, 11427, 51531}},
    {6243, 17, 4368, {1, 1, 5, 13, 7, 51, 113, 53, 269, 583, 1451, 541, 4677, 11771, 22381, 17815, 1319}},
    {6244, 17, 4373, {1, 3, 5, 3, 7, 47, 69, 137, 103, 269, 769, 57, 5919, 14059, 13781, 20747, 31083}},
    {6245, 17, 4389, {1, 1, 7, 11, 17, 37, 45, 233, 401, 573, 1319, 2849, 4549, 2085, 25947, 25345, 103317}},
    {6246, 17, 4394, {1, 1, 3, 5, 3, 57, 95, 251, 51, 93, 1819, 3089, 4581, 4525, 14625, 61731, 36965}},
    {6247, 17, 4413, {1, 3, 3, 9, 25, 13, 61, 25, 153, 435, 1929, 2451, 6819, 10813, 907, 38439, 40957}},
    {6248, 17, 4422, {1, 3, 5, 1, 29, 37, 23, 255, 169, 427, 213, 2777, 7055, 3817, 10105, 50653, 16983}},
    {6249, 17, 4431, {1, 3, 7, 9, 11, 11, 65, 59, 395, 687, 1237, 17, 3233, 1567, 31213, 34805, 33949}},
    {6250, 17, 4436, {1, 3, 3, 3, 5, 31, 5, 53, 289, 847, 925, 3817, 5345, 14403, 28743, 35951, 21023}},
    {6251, 17, 4440, {1, 3, 1, 11, 21, 41, 1, 223, 299, 499, 1581, 3327, 2885, 8077, 25339, 58035, 47115}},
    {6252, 17, 4445, {1, 3, 1, 15, 9, 33, 11, 243, 145, 545, 111, 3203, 7063, 10299, 7167, 14361, 18081}},
    {6253, 17, 4452, {1, 1, 3, 3, 31, 23, 111, 221, 507, 735, 159, 267, 3365, 12459, 16905, 45441, 49789}},
    {6254, 17, 4462, {1, 1, 1, 13, 13, 39, 127, 205, 113, 971, 205, 4053, 6175, 13461, 14565, 5645, 42435}},
    {6255, 17, 4469, {1, 1, 3, 11, 17, 35, 63, 191, 411, 403, 545, 1099, 1707, 5097, 7371, 63451, 80821}},
    {6256, 17, 4470, {1, 3, 1, 9, 19, 45, 117, 105, 75, 189, 769, 649, 1041, 9387, 9641, 32265, 99235}},
    {6257, 17, 4473, {1, 1, 1, 13, 11, 13, 83, 99, 369, 283, 873, 1247, 6159, 15495, 21379, 3219, 100645}},
    {6258, 17, 4479, {1, 1, 3, 11, 23, 53, 127, 171, 347, 815, 569, 3433, 6845, 15357, 6169, 61801, 100489}},
    {6259, 17, 4480, {1, 3, 1, 1, 9, 15, 111, 161, 107, 627, 919, 2915, 107, 15389, 2671, 36233, 40725}},
    {6260, 17, 4483, {1, 3, 3, 13, 3, 11, 119, 203, 495, 173, 1943, 3363, 3015, 8513, 2873, 4283, 103527}},
    {6261, 17, 4489, {1, 3, 7, 3, 11, 53, 105, 151, 505, 861, 367, 727, 6389, 8319, 9173, 6257, 115321}},
    {6262, 17, 4503, {1, 3, 5, 1, 23, 55, 127, 1, 321, 515, 817, 3009, 6427, 4937, 4827, 34425, 123063}},
    {6263, 17, 4519, {1, 1, 1, 7, 31, 51, 103, 163, 39, 281, 1885, 2389, 4063, 9829, 2759, 57361, 40515}},
    {6264, 17, 4520, {1, 3, 5, 11, 5, 29, 45, 103, 207, 793, 641, 2111, 2881, 13037, 1103, 7747, 45473}},
    {6265, 17, 4525, {1, 1, 1, 5, 23, 57, 69, 101, 447, 53, 617, 9, 7297, 1149, 18637, 52601, 94385}},
    {6266, 17, 4526, {1, 3, 7, 9, 29, 45, 117, 153, 363, 889, 323, 1725, 4413, 15281, 25779, 35229, 99397}},
    {6267, 17, 4533, {1, 1, 3, 1, 9, 35, 99, 237, 159, 449, 1131, 1047, 7781, 5491, 13369, 60369, 79763}},
    {6268, 17, 4552, {1, 1, 7, 9, 1, 7, 115, 41, 429, 913, 1173, 1613, 6881, 1205, 6387, 28177, 31053}},
    {6269, 17, 4581, {1, 1, 7, 13, 15, 21, 45, 15, 483, 537, 973, 3123, 6769, 5745, 30217, 45061, 91797}},
    {6270, 17, 4585, {1, 3, 7, 9, 3, 29, 77, 79, 3, 725, 291, 3297, 7367, 12729, 11511, 52959, 53745}},
    {6271, 17, 4591, {1, 1, 7, 15, 21, 61, 41, 81, 283, 873, 1617, 2747, 3853, 8535, 9461, 37657, 81241}},
    {6272, 17, 4594, {1, 1, 5, 11, 7, 59, 93, 253, 387, 797, 959, 3073, 3443, 3695, 16211, 64199, 42655}},
    {6273, 17, 4596, {1, 3, 3, 13, 3, 47, 37, 51, 147, 133, 1289, 2973, 1361, 2531, 28313, 3949, 76037}},
    {6274, 17, 4599, {1, 3, 5, 11, 31, 27, 27, 15, 59, 581, 1, 3671, 5601, 3063, 22929, 2881, 100723}},
    {6275, 17, 4612, {1, 1, 7, 7, 7, 61, 77, 37, 373, 981, 215, 3857, 4145, 13307, 16069, 33245, 59903}},
    {6276, 17, 4621, {1, 1, 3, 9, 27, 41, 117, 119, 197, 371, 1741, 579, 951, 1141, 5513, 54035, 23433}},
    {6277, 17, 4630, {1, 3, 7, 15, 9, 39, 19, 25, 377, 239, 903, 2263, 4317, 185, 32465, 12011, 6875}},
    {6278, 17, 4636, {1, 3, 1, 7, 25, 59, 117, 103, 163, 39, 1465, 195, 359, 1727, 28335, 51583, 126433}},
    {6279, 17, 4640, {1, 3, 1, 7, 11, 25, 81, 139, 329, 653, 477, 3787, 429, 6557, 4375, 52661, 70929}},
    {6280, 17, 4649, {1, 1, 3, 9, 9, 1, 1, 205, 439, 909, 1421, 3861, 199, 1565, 13965, 55549, 60765}},
    {6281, 17, 4650, {1, 1, 3, 1, 1, 55, 125, 179, 279, 935, 891, 1083, 7783, 14177, 23953, 61169, 51665}},
    {6282, 17, 4660, {1, 3, 7, 5, 29, 49, 3, 157, 337, 497, 429, 3999, 1237, 13875, 19675, 27533, 93661}},
    {6283, 17, 4677, {1, 3, 5, 3, 31, 59, 1, 139, 243, 237, 139, 2449, 7597, 10733, 21415, 3457, 55167}},
    {6284, 17, 4687, {1, 3, 7, 1, 1, 35, 95, 231, 9, 281, 1341, 2147, 5597, 9931, 23853, 55951, 32153}},
    {6285, 17, 4696, {1, 3, 1, 7, 25, 33, 15, 15, 277, 987, 713, 2569, 157, 14617, 13855, 41499, 86275}},
    {6286, 17, 4701, {1, 1, 7, 3, 11, 15, 45, 93, 289, 369, 535, 3115, 3233, 203, 8547, 36891, 67165}},
    {6287, 17, 4705, {1, 1, 7, 1, 7, 63, 71, 219, 147, 415, 1205, 2089, 4729, 12879, 17645, 30033, 79313}},
    {6288, 17, 4706, {1, 1, 3, 11, 9, 51, 111, 29, 255, 135, 1497, 1165, 2859, 4439, 23169, 28789, 115629}},
    {6289, 17, 4711, {1, 1, 3, 1, 23, 19, 17, 171, 447, 321, 1003, 3231, 3253, 13897, 15147, 62799, 1265}},
    {6290, 17, 4720, {1, 3, 1, 1, 15, 33, 59, 207, 187, 379, 387, 3035, 4257, 11967, 21851, 50839, 80867}},
    {6291, 17, 4723, {1, 3, 1, 5, 17, 13, 31, 57, 83, 425, 1743, 3331, 6019, 10489, 19719, 39315, 119363}},
    {6292, 17, 4732, {1, 1, 3, 1, 3, 15, 67, 175, 183, 869, 849, 169, 5593, 6213, 17485, 16025, 46021}},
    {6293, 17, 4736, {1, 1, 5, 15, 23, 59, 75, 95, 315, 249, 405, 1307, 3195, 9541, 3253, 34131, 82669}},
    {6294, 17, 4742, {1, 1, 7, 11, 7, 7, 39, 15, 347, 783, 261, 2655, 5149, 3147, 17401, 17189, 85891}},
    {6295, 17, 4748, {1, 1, 3, 7, 19, 1, 15, 107, 393, 195, 1849, 2937, 4719, 13019, 21507, 62899, 41585}},
    {6296, 17, 4754, {1, 1, 1, 7, 1, 7, 115, 3, 55, 639, 1857, 2809, 6201, 2817, 9991, 18395, 125645}},
    {6297, 17, 4759, {1, 1, 7, 1, 23, 1, 77, 245, 269, 23, 455, 3163, 2357, 2935, 5499, 49283, 14735}},
    {6298, 17, 4769, {1, 3, 7, 3, 13, 33, 117, 45, 277, 439, 1655, 1539, 3029, 2953, 5049, 63987, 47909}},
    {6299, 17, 4787, {1, 1, 1, 11, 27, 1, 119, 217, 423, 369, 1659, 4013, 2601, 7365, 23971, 20965, 125227}},
    {6300, 17, 4807, {1, 1, 1, 5, 17, 47, 19, 165, 511, 963, 397, 631, 2075, 6197, 5989, 46201, 87999}},
    {6301, 17, 4814, {1, 3, 5, 9, 19, 25, 45, 147, 495, 749, 1505, 3785, 1737, 29, 14239, 8715, 2867}},
    {6302, 17, 4837, {1, 3, 7, 11, 11, 1, 15, 209, 23, 407, 1637, 1851, 3335, 16137, 8383, 24653, 31625}},
    {6303, 17, 4867, {1, 1, 3, 5, 9, 45, 51, 113, 257, 415, 1275, 3757, 217, 975, 25947, 17567, 127871}},
    {6304, 17, 4873, {1, 1, 5, 11, 19, 55, 43, 197, 11, 589, 531, 2845, 683, 5339, 11043, 39067, 23491}},
    {6305, 17, 4879, {1, 3, 7, 1, 11, 27, 59, 139, 125, 731, 991, 939, 7127, 4533, 15295, 33437, 24727}},
    {6306, 17, 4884, {1, 1, 5, 3, 23, 63, 69, 111, 439, 769, 541, 3177, 539, 6095, 15925, 57437, 41273}},
    {6307, 17, 4898, {1, 1, 3, 13, 31, 35, 119, 97, 483, 329, 1219, 2553, 6119, 3243, 12011, 12133, 12325}},
    {6308, 17, 4907, {1, 3, 1, 5, 1, 13, 55, 147, 363, 749, 347, 3185, 515, 12895, 20395, 53963, 115687}},
    {6309, 17, 4910, {1, 3, 1, 1, 23, 33, 121, 83, 313, 367, 1091, 2491, 1721, 6801, 4853, 6447, 48169}},
    {6310, 17, 4918, {1, 3, 5, 3, 31, 13, 55, 71, 373, 191, 1255, 3207, 5291, 5093, 16451, 26757, 73237}},
    {6311, 17, 4924, {1, 3, 1, 5, 23, 57, 97, 169, 429, 883, 789, 2823, 4207, 7545, 12633, 22851, 62119}},
    {6312, 17, 4953, {1, 1, 5, 5, 5, 41, 61, 239, 281, 425, 1987, 3683, 8185, 13893, 20897, 35705, 11621}},
    {6313, 17, 4956, {1, 1, 3, 3, 21, 61, 35, 15, 69, 143, 1771, 1007, 7903, 15669, 22315, 42333, 11691}},
    {6314, 17, 4965, {1, 3, 1, 13, 5, 43, 15, 91, 235, 983, 481, 1391, 6103, 4909, 13563, 60785, 31529}},
    {6315, 17, 4966, {1, 1, 5, 11, 9, 39, 103, 23, 349, 29, 845, 433, 1727, 2601, 2699, 9423, 16963}},
    {6316, 17, 4970, {1, 3, 7, 7, 27, 31, 101, 203, 371, 115, 945, 3927, 6819, 6235, 7483, 5203, 83489}},
    {6317, 17, 4972, {1, 1, 3, 15, 19, 43, 71, 75, 141, 163, 971, 2185, 3497, 4563, 23247, 33259, 125109}},
    {6318, 17, 4983, {1, 1, 7, 11, 19, 51, 91, 111, 81, 35, 41, 2493, 6031, 16185, 965, 58781, 57037}},
    {6319, 17, 4989, {1, 3, 5, 3, 25, 45, 37, 203, 403, 865, 1909, 641, 2341, 7521, 21663, 11317, 52227}},
    {6320, 17, 4994, {1, 3, 1, 15, 21, 61, 85, 175, 463, 887, 1157, 2423, 4959, 2427, 21247, 7699, 20133}},
    {6321, 17, 5000, {1, 3, 7, 1, 13, 55, 85, 135, 281, 111, 1743, 227, 6065, 5055, 8349, 60363, 119843}},
    {6322, 17, 5005, {1, 3, 1, 13, 11, 19, 97, 151, 497, 175, 147, 1419, 2377, 6141, 12771, 23827, 2937}},
    {6323, 17, 5014, {1, 1, 5, 3, 13, 35, 115, 139, 7, 519, 977, 2397, 2765, 2595, 28833, 1491, 24069}},
    {6324, 17, 5018, {1, 3, 7, 13, 23, 5, 13, 97, 169, 539, 1633, 1315, 4689, 3465, 12963, 56651, 80261}},
    {6325, 17, 5023, {1, 3, 5, 11, 11, 59, 119, 117, 25, 327, 1097, 1421, 6151, 8685, 5107, 2935, 77199}},
    {6326, 17, 5039, {1, 1, 5, 9, 19, 29, 3, 239, 249, 403, 1139, 951, 5557, 11697, 6333, 42215, 10151}},
    {6327, 17, 5053, {1, 1, 5, 11, 21, 3, 53, 215, 107, 895, 463, 1669, 787, 11647, 2097, 47115, 7873}},
    {6328, 17, 5054, {1, 1, 7, 11, 9, 61, 21, 237, 265, 673, 117, 3921, 1183, 10517, 24709, 24433, 130861}},
    {6329, 17, 5061, {1, 1, 5, 1, 11, 33, 43, 31, 65, 635, 1133, 517, 859, 15729, 29081, 11113, 54485}},
    {6330, 17, 5065, {1, 3, 7, 5, 31, 45, 21, 195, 127, 495, 1505, 965, 5661, 10355, 24863, 855, 61511}},
    {6331, 17, 5080, {1, 1, 7, 9, 25, 59, 33, 135, 463, 47, 395, 405, 3759, 303, 21723, 28471, 19231}},
    {6332, 17, 5083, {1, 3, 1, 15, 17, 35, 13, 3, 49, 939, 1439, 2379, 7221, 4843, 21337, 35557, 90921}},
    {6333, 17, 5107, {1, 1, 1, 1, 15, 49, 37, 219, 153, 323, 1995, 1841, 683, 10671, 2229, 55533, 59951}},
    {6334, 17, 5119, {1, 1, 3, 5, 5, 31, 71, 227, 189, 155, 617, 1339, 5249, 2547, 14141, 52835, 43125}},
    {6335, 17, 5146, {1, 1, 7, 9, 3, 15, 5, 57, 435, 717, 541, 3523, 1891, 11875, 8053, 55571, 59433}},
    {6336, 17, 5151, {1, 3, 1, 7, 21, 25, 29, 229, 261, 531, 1333, 97, 2327, 783, 18519, 47157, 126603}},
    {6337, 17, 5152, {1, 3, 3, 11, 27, 29, 31, 235, 21, 751, 1947, 1555, 719, 3271, 19743, 40267, 105133}},
    {6338, 17, 5155, {1, 3, 1, 13, 27, 17, 13, 23, 397, 843, 123, 111, 7003, 6099, 12875, 22579, 32129}},
    {6339, 17, 5169, {1, 3, 7, 7, 5, 59, 119, 151, 409, 881, 263, 1849, 3201, 12545, 6069, 15077, 47301}},
    {6340, 17, 5170, {1, 1, 5, 13, 23, 13, 63, 139, 211, 349, 1027, 2989, 4573, 3705, 8209, 36189, 93023}},
    {6341, 17, 5176, {1, 1, 5, 13, 19, 63, 63, 81, 77, 287, 641, 3975, 6455, 8447, 16527, 8767, 88365}},
    {6342, 17, 5179, {1, 1, 5, 15, 21, 21, 99, 31, 55, 699, 591, 563, 7623, 12125, 1155, 49645, 71351}},
    {6343, 17, 5182, {1, 1, 1, 5, 11, 39, 95, 157, 273, 1011, 583, 1327, 3651, 8499, 27157, 17831, 75193}},
    {6344, 17, 5189, {1, 1, 1, 9, 13, 5, 95, 213, 105, 615, 971, 1915, 611, 6761, 24641, 993, 91297}},
    {6345, 17, 5193, {1, 1, 7, 15, 19, 15, 5, 185, 109, 71, 1151, 2543, 5119, 5661, 5489, 55663, 115749}},
    {6346, 17, 5196, {1, 1, 5, 15, 25, 31, 13, 139, 195, 191, 303, 391, 4797, 8683, 31005, 37251, 39435}},
    {6347, 17, 5204, {1, 1, 5, 3, 27, 21, 65, 1, 171, 849, 275, 2051, 1701, 3593, 21717, 50667, 100405}},
    {6348, 17, 5207, {1, 1, 3, 15, 5, 25, 53, 183, 243, 371, 1897, 3431, 2299, 10057, 21437, 11941, 77035}},
    {6349, 17, 5211, {1, 3, 3, 5, 3, 43, 59, 103, 211, 919, 1419, 3067, 6181, 4977, 13247, 59235, 31299}},
    {6350, 17, 5220, {1, 3, 3, 1, 1, 59, 25, 25, 101, 341, 615, 1453, 1557, 16163, 22259, 14919, 16073}},
    {6351, 17, 5258, {1, 1, 7, 13, 13, 17, 77, 245, 263, 903, 363, 793, 6727, 8529, 5135, 3857, 66853}},
    {6352, 17, 5265, {1, 1, 3, 13, 17, 21, 103, 109, 435, 247, 1125, 3195, 1281, 9383, 8127, 27535, 113249}},
    {6353, 17, 5271, {1, 1, 1, 11, 19, 53, 111, 43, 459, 1011, 1085, 1627, 1015, 11943, 29765, 35519, 4009}},
    {6354, 17, 5277, {1, 3, 3, 7, 13, 13, 95, 129, 463, 63, 353, 3353, 7451, 16109, 17721, 22805, 17959}},
    {6355, 17, 5278, {1, 3, 7, 3, 3, 15, 71, 27, 451, 823, 411, 2843, 7207, 12321, 4891, 38593, 86109}},
    {6356, 17, 5282, {1, 1, 1, 7, 23, 21, 23, 109, 461, 519, 2023, 2165, 505, 1673, 16773, 50249, 69291}},
    {6357, 17, 5296, {1, 3, 3, 1, 3, 53, 43, 231, 23, 591, 1947, 1375, 3037, 215, 22355, 35767, 12743}},
    {6358, 17, 5299, {1, 3, 7, 3, 25, 37, 45, 67, 485, 215, 285, 3767, 51, 10647, 8571, 6939, 68107}},
    {6359, 17, 5319, {1, 3, 3, 11, 9, 61, 7, 133, 331, 1021, 57, 2197, 4807, 9809, 20585, 38705, 105801}},
    {6360, 17, 5328, {1, 3, 5, 11, 19, 31, 61, 93, 383, 321, 385, 1969, 6895, 5111, 3881, 35851, 54573}},
    {6361, 17, 5343, {1, 1, 7, 9, 21, 35, 61, 27, 251, 399, 161, 2307, 7479, 11229, 8317, 17535, 59693}},
    {6362, 17, 5353, {1, 1, 5, 13, 19, 55, 31, 77, 347, 569, 1105, 311, 4239, 6289, 407, 32321, 97319}},
    {6363, 17, 5364, {1, 3, 1, 9, 7, 11, 69, 43, 307, 263, 1713, 1963, 6539, 2975, 19595, 26637, 94925}},
    {6364, 17, 5368, {1, 1, 3, 5, 3, 21, 69, 117, 43, 381, 941, 3391, 219, 4267, 12313, 46259, 126889}},
    {6365, 17, 5379, {1, 3, 3, 11, 23, 7, 21, 213, 63, 965, 1855, 1507, 4951, 11967, 9389, 18989, 94435}},
    {6366, 17, 5381, {1, 3, 7, 3, 5, 53, 9, 23, 103, 427, 299, 3301, 6995, 12137, 24391, 51337, 2581}},
    {6367, 17, 5399, {1, 1, 5, 5, 5, 59, 107, 227, 221, 787, 1089, 249, 7241, 15669, 16009, 49687, 49077}},
    {6368, 17, 5415, {1, 1, 5, 11, 13, 9, 27, 49, 253, 547, 797, 1649, 1211, 1025, 3489, 9151, 63589}},
    {6369, 17, 5422, {1, 1, 5, 3, 21, 21, 115, 21, 459, 91, 1597, 2483, 2853, 7709, 8381, 62841, 73403}},
    {6370, 17, 5441, {1, 1, 3, 1, 21, 39, 71, 203, 437, 559, 1765, 3375, 6565, 14261, 18755, 54827, 36931}},
    {6371, 17, 5451, {1, 3, 5, 13, 23, 43, 127, 163, 175, 209, 1213, 2807, 1833, 785, 7529, 701, 31029}},
    {6372, 17, 5456, {1, 3, 7, 15, 27, 59, 57, 7, 285, 483, 1843, 99, 4777, 12953, 15189, 51275, 64701}},
    {6373, 17, 5462, {1, 1, 3, 5, 31, 11, 37, 27, 261, 733, 1749, 3575, 1817, 7083, 20621, 56839, 112293}},
    {6374, 17, 5490, {1, 3, 7, 3, 13, 47, 65, 229, 93, 781, 1555, 3953, 7535, 10853, 6163, 41515, 36813}},
    {6375, 17, 5495, {1, 1, 7, 15, 19, 53, 71, 131, 129, 361, 1833, 3463, 6923, 187, 19441, 32321, 102525}},
    {6376, 17, 5501, {1, 3, 1, 3, 31, 9, 99, 105, 371, 807, 1637, 1341, 2245, 15403, 14911, 31245, 24961}},
    {6377, 17, 5502, {1, 1, 1, 1, 13, 63, 75, 229, 19, 233, 2037, 2389, 4055, 10409, 495, 58639, 100553}},
    {6378, 17, 5505, {1, 3, 3, 7, 17, 25, 21, 151, 133, 815, 21, 3183, 2517, 2891, 28207, 57071, 120025}},
    {6379, 17, 5512, {1, 1, 5, 13, 3, 15, 17, 133, 419, 269, 893, 495, 2705, 1441, 25731, 22201, 19083}},
    {6380, 17, 5523, {1, 1, 1, 7, 29, 45, 13, 77, 369, 629, 647, 3321, 4543, 989, 20001, 65175, 122879}},
    {6381, 17, 5529, {1, 1, 5, 5, 31, 45, 119, 47, 111, 647, 129, 919, 7433, 13159, 22713, 26341, 10591}},
    {6382, 17, 5548, {1, 1, 1, 7, 9, 3, 69, 67, 493, 681, 963, 3951, 193, 10775, 4731, 29863, 71041}},
    {6383, 17, 5551, {1, 3, 3, 15, 19, 25, 75, 233, 85, 913, 261, 797, 7381, 3989, 32577, 13703, 8973}},
    {6384, 17, 5553, {1, 1, 3, 5, 7, 21, 71, 53, 325, 797, 461, 2141, 1373, 14013, 19021, 3701, 116157}},
    {6385, 17, 5565, {1, 3, 3, 1, 25, 19, 123, 141, 411, 769, 521, 3009, 3007, 15601, 11813, 14463, 14551}},
    {6386, 17, 5568, {1, 3, 5, 3, 15, 43, 109, 229, 189, 33, 1941, 2269, 5351, 8315, 9291, 12727, 45575}},
    {6387, 17, 5577, {1, 3, 1, 9, 25, 27, 45, 231, 445, 161, 681, 3351, 6307, 1603, 22679, 21081, 54333}},
    {6388, 17, 5578, {1, 3, 7, 11, 1, 5, 61, 183, 155, 149, 151, 3279, 1213, 15963, 18063, 39067, 47535}},
    {6389, 17, 5583, {1, 3, 5, 7, 19, 63, 73, 189, 265, 909, 2025, 1875, 7171, 10457, 14199, 52973, 40753}},
    {6390, 17, 5585, {1, 3, 3, 3, 1, 57, 31, 41, 415, 629, 1545, 3265, 439, 14265, 19049, 25081, 95825}},
    {6391, 17, 5588, {1, 1, 5, 9, 13, 5, 67, 173, 85, 355, 1001, 3081, 5629, 16265, 8851, 49611, 20005}},
    {6392, 17, 5613, {1, 3, 7, 3, 29, 29, 105, 49, 249, 941, 1859, 3843, 7087, 11657, 13549, 42555, 113019}},
    {6393, 17, 5614, {1, 1, 1, 13, 27, 39, 111, 23, 323, 403, 2021, 1153, 3735, 15443, 25479, 10105, 63507}},
    {6394, 17, 5616, {1, 3, 3, 7, 19, 43, 55, 239, 473, 389, 1007, 3223, 2239, 8617, 32133, 2547, 61113}},
    {6395, 17, 5622, {1, 1, 7, 7, 31, 1, 75, 3, 107, 187, 1887, 2881, 6231, 15501, 20123, 15957, 3149}},
    {6396, 17, 5631, {1, 3, 7, 13, 29, 31, 117, 19, 43, 21, 1877, 3711, 1459, 5283, 21845, 7055, 60715}},
    {6397, 17, 5637, {1, 1, 1, 9, 15, 7, 61, 25, 389, 565, 979, 2025, 4523, 8079, 14935, 46203, 36649}},
    {6398, 17, 5638, {1, 3, 5, 13, 19, 37, 73, 165, 327, 421, 1017, 1673, 2517, 5199, 1849, 33247, 57287}},
    {6399, 17, 5668, {1, 3, 1, 7, 27, 31, 81, 213, 75, 787, 1533, 1937, 1133, 11647, 8067, 8005, 51099}},
    {6400, 17, 5675, {1, 1, 7, 15, 15, 1, 59, 205, 329, 999, 799, 529, 3503, 12671, 3587, 303, 65433}},
    {6401, 17, 5683, {1, 1, 5, 1, 9, 15, 103, 147, 485, 881, 703, 2841, 7751, 4951, 16809, 58635, 13889}},
    {6402, 17, 5695, {1, 3, 1, 13, 5, 7, 101, 237, 419, 183, 1611, 741, 5273, 2043, 22815, 47769, 63645}},
    {6403, 17, 5703, {1, 1, 1, 7, 1, 23, 117, 245, 291, 433, 607, 3629, 3355, 3923, 4273, 56739, 25447}},
    {6404, 17, 5710, {1, 1, 1, 1, 27, 21, 65, 193, 375, 849, 1707, 1159, 2809, 3343, 31837, 33767, 69097}},
    {6405, 17, 5715, {1, 1, 1, 11, 23, 29, 45, 125, 65, 139, 737, 1779, 7109, 14263, 28117, 15705, 35687}},
    {6406, 17, 5727, {1, 1, 1, 5, 17, 35, 19, 55, 355, 645, 1205, 2047, 7691, 16369, 29197, 29513, 82729}},
    {6407, 17, 5738, {1, 3, 1, 11, 5, 15, 27, 93, 85, 467, 1519, 2115, 4941, 12405, 12521, 62169, 12375}},
    {6408, 17, 5752, {1, 3, 3, 13, 23, 11, 127, 85, 193, 517, 1737, 2293, 5647, 8079, 4805, 63325, 29439}},
    {6409, 17, 5767, {1, 3, 5, 7, 21, 1, 87, 231, 405, 3, 409, 2211, 361, 4933, 6215, 35983, 31011}},
    {6410, 17, 5773, {1, 3, 3, 3, 13, 25, 117, 207, 323, 253, 41, 3529, 3781, 9329, 30555, 32221, 61315}},
    {6411, 17, 5776, {1, 3, 1, 11, 21, 47, 5, 51, 221, 747, 97, 321, 6303, 12029, 15179, 24397, 62461}},
    {6412, 17, 5781, {1, 3, 5, 15, 11, 33, 25, 25, 127, 1009, 1721, 119, 2433, 4393, 4999, 11433, 59191}},
    {6413, 17, 5791, {1, 3, 5, 9, 27, 55, 111, 245, 255, 801, 407, 3645, 2961, 5239, 6443, 33505, 99189}},
    {6414, 17, 5792, {1, 3, 7, 5, 27, 19, 49, 191, 75, 585, 411, 1649, 7597, 15795, 31259, 8001, 128495}},
    {6415, 17, 5795, {1, 3, 5, 1, 15, 3, 47, 253, 301, 781, 333, 1771, 1063, 10187, 32245, 50243, 83147}},
    {6416, 17, 5798, {1, 3, 5, 1, 7, 47, 87, 137, 135, 797, 1585, 3871, 1313, 9733, 571, 53243, 38311}},
    {6417, 17, 5801, {1, 1, 5, 3, 9, 57, 89, 55, 491, 605, 107, 1637, 2025, 7207, 10633, 43867, 113495}},
    {6418, 17, 5810, {1, 1, 1, 11, 25, 33, 107, 49, 169, 991, 237, 1125, 3891, 699, 10979, 52199, 48291}},
    {6419, 17, 5812, {1, 1, 7, 3, 17, 35, 65, 23, 141, 205, 743, 3629, 2453, 13563, 31981, 18323, 57461}},
    {6420, 17, 5836, {1, 3, 7, 3, 17, 9, 1, 51, 53, 247, 287, 2701, 2027, 5963, 32581, 2239, 103605}},
    {6421, 17, 5839, {1, 1, 3, 13, 1, 15, 57, 69, 341, 329, 543, 2329, 4889, 6245, 22085, 31537, 58367}},
    {6422, 17, 5841, {1, 1, 3, 11, 15, 27, 1, 57, 409, 1001, 1761, 1075, 5573, 5939, 7577, 2581, 100529}},
    {6423, 17, 5867, {1, 3, 3, 3, 1, 1, 113, 17, 271, 41, 51, 1219, 1651, 1185, 9271, 42667, 90785}},
    {6424, 17, 5870, {1, 1, 1, 5, 7, 63, 107, 133, 289, 877, 2039, 3225, 3559, 14675, 10367, 37077, 86905}},
    {6425, 17, 5877, {1, 3, 1, 3, 13, 7, 117, 181, 169, 473, 837, 2167, 7147, 12701, 16711, 53323, 48751}},
    {6426, 17, 5881, {1, 1, 7, 1, 31, 39, 97, 39, 451, 631, 191, 3531, 6929, 9061, 1877, 653, 106531}},
    {6427, 17, 5899, {1, 3, 7, 1, 5, 15, 91, 123, 21, 213, 267, 4057, 7981, 12253, 389, 56557, 69829}},
    {6428, 17, 5914, {1, 1, 3, 15, 19, 3, 11, 119, 241, 423, 1585, 3759, 2133, 15767, 1853, 17925, 90929}},
    {6429, 17, 5925, {1, 3, 7, 7, 13, 21, 39, 57, 81, 331, 1625, 1123, 4303, 2241, 9653, 22533, 105035}},
    {6430, 17, 5929, {1, 3, 1, 7, 19, 45, 107, 19, 427, 295, 587, 1987, 3757, 11413, 9331, 56339, 62755}},
    {6431, 17, 5943, {1, 3, 5, 3, 21, 13, 87, 171, 137, 645, 1333, 3593, 1735, 371, 9009, 16341, 56361}},
    {6432, 17, 5949, {1, 1, 1, 9, 5, 47, 63, 69, 425, 301, 1551, 3749, 4037, 3871, 8765, 50073, 77587}},
    {6433, 17, 5962, {1, 3, 5, 9, 3, 41, 83, 37, 385, 533, 1885, 3999, 1043, 2329, 24701, 35941, 92409}},
    {6434, 17, 5969, {1, 3, 3, 11, 29, 41, 23, 199, 211, 93, 1705, 79, 6869, 6423, 27429, 62467, 72625}},
    {6435, 17, 5976, {1, 1, 1, 13, 17, 9, 1, 97, 369, 185, 757, 777, 4397, 1273, 12493, 16377, 11935}},
    {6436, 17, 5988, {1, 1, 3, 5, 13, 61, 35, 243, 189, 1007, 1845, 2327, 7525, 7023, 24835, 26343, 30903}},
    {6437, 17, 5997, {1, 1, 5, 13, 17, 27, 109, 165, 149, 465, 655, 1765, 715, 12925, 14903, 22405, 81713}},
    {6438, 17, 6006, {1, 1, 1, 1, 1, 1, 33, 71, 287, 415, 1647, 1505, 6199, 1721, 27073, 22741, 99909}},
    {6439, 17, 6010, {1, 1, 5, 11, 13, 25, 21, 177, 327, 39, 149, 717, 3229, 8633, 16163, 2153, 102341}},
    {6440, 17, 6016, {1, 1, 3, 13, 5, 53, 43, 179, 95, 739, 1947, 3459, 319, 7589, 12581, 2307, 10867}},
    {6441, 17, 6022, {1, 3, 1, 1, 27, 57, 85, 175, 123, 893, 1187, 903, 5155, 10203, 18923, 52379, 83419}},
    {6442, 17, 6026, {1, 1, 7, 5, 13, 63, 33, 57, 321, 87, 11, 769, 1421, 13221, 4789, 19381, 85009}},
    {6443, 17, 6031, {1, 3, 1, 1, 9, 25, 19, 107, 3, 689, 645, 3751, 3543, 1901, 26349, 45189, 71117}},
    {6444, 17, 6040, {1, 1, 3, 15, 27, 63, 127, 169, 141, 519, 1881, 1039, 4307, 12365, 32447, 34599, 129051}},
    {6445, 17, 6043, {1, 3, 1, 1, 31, 5, 83, 189, 165, 831, 1413, 3135, 5505, 7243, 26559, 40389, 25605}},
    {6446, 17, 6050, {1, 1, 3, 11, 7, 31, 79, 149, 181, 409, 1165, 3327, 4103, 4735, 30181, 10953, 90927}},
    {6447, 17, 6059, {1, 1, 7, 13, 5, 63, 79, 195, 487, 915, 1449, 3475, 6443, 14651, 16335, 31529, 57271}},
    {6448, 17, 6079, {1, 3, 3, 13, 1, 55, 3, 239, 171, 923, 933, 3837, 7869, 13937, 13511, 3835, 85363}},
    {6449, 17, 6099, {1, 3, 7, 11, 7, 35, 107, 9, 149, 117, 919, 3455, 33, 9129, 14463, 39405, 21569}},
    {6450, 17, 6101, {1, 3, 3, 11, 11, 57, 31, 121, 287, 885, 441, 4017, 6115, 9713, 16481, 48019, 75229}},
    {6451, 17, 6105, {1, 3, 3, 3, 25, 15, 61, 219, 217, 671, 847, 703, 2305, 3135, 1167, 12055, 42299}},
    {6452, 17, 6108, {1, 3, 5, 7, 21, 15, 121, 101, 159, 161, 1789, 1645, 183, 12785, 28201, 12375, 50169}},
    {6453, 17, 6124, {1, 3, 5, 3, 27, 33, 37, 107, 121, 757, 1817, 1889, 5759, 15219, 17673, 56753, 119181}},
    {6454, 17, 6132, {1, 1, 7, 11, 3, 53, 123, 211, 415, 839, 1295, 2525, 3781, 13375, 31205, 4305, 124501}},
    {6455, 17, 6145, {1, 3, 1, 11, 11, 47, 17, 233, 215, 539, 619, 1625, 1537, 3017, 22085, 20695, 43763}},
    {6456, 17, 6146, {1, 3, 7, 1, 11, 15, 21, 37, 89, 735, 255, 903, 6029, 7299, 6495, 42767, 6227}},
    {6457, 17, 6151, {1, 1, 7, 15, 23, 21, 3, 103, 309, 49, 1451, 805, 7393, 3507, 8411, 54853, 45265}},
    {6458, 17, 6152, {1, 3, 7, 7, 3, 39, 67, 245, 469, 175, 659, 505, 629, 1459, 23373, 7411, 43823}},
    {6459, 17, 6158, {1, 3, 3, 3, 31, 53, 95, 13, 77, 493, 251, 3559, 1463, 3481, 18971, 4203, 21983}},
    {6460, 17, 6160, {1, 3, 3, 15, 23, 9, 111, 201, 377, 427, 135, 1393, 5065, 13957, 26531, 12115, 86101}},
    {6461, 17, 6163, {1, 1, 1, 13, 11, 13, 83, 99, 369, 283, 873, 1247, 6159, 15495, 21379, 3219, 100645}},
    {6462, 17, 6165, {1, 1, 3, 3, 23, 17, 5, 255, 235, 159, 1269, 3437, 235, 1065, 11983, 10331, 127013}},
    {6463, 17, 6170, {1, 1, 3, 11, 23, 53, 127, 171, 347, 815, 569, 3433, 6845, 15357, 6169, 61801, 100489}},
    {6464, 17, 6182, {1, 1, 7, 15, 23, 21, 125, 51, 185, 511, 1519, 165, 6201, 15607, 15581, 34007, 99081}},
    {6465, 17, 6196, {1, 1, 1, 13, 29, 15, 27, 7, 65, 223, 583, 1907, 7555, 10675, 1865, 63707, 117385}},
    {6466, 17, 6199, {1, 1, 7, 15, 23, 13, 121, 105, 35, 245, 1801, 1241, 4735, 15167, 32731, 45051, 11069}},
    {6467, 17, 6200, {1, 3, 3, 7, 25, 61, 83, 7, 205, 939, 273, 533, 6935, 15695, 28329, 33865, 84181}},
    {6468, 17, 6205, {1, 1, 1, 1, 7, 43, 111, 121, 61, 1007, 1425, 385, 5407, 10485, 21613, 59789, 37067}},
    {6469, 17, 6226, {1, 1, 7, 11, 11, 21, 79, 7, 147, 981, 545, 3133, 6659, 2099, 8957, 52731, 3519}},
    {6470, 17, 6228, {1, 1, 5, 1, 17, 19, 73, 5, 303, 187, 829, 1965, 429, 3327, 26157, 8547, 93699}},
    {6471, 17, 6237, {1, 1, 1, 7, 15, 47, 21, 95, 285, 759, 475, 605, 3351, 8117, 24835, 7965, 123159}},
    {6472, 17, 6247, {1, 3, 5, 15, 3, 47, 9, 153, 63, 285, 1299, 321, 567, 597, 24153, 2049, 10453}},
    {6473, 17, 6251, {1, 3, 3, 3, 11, 19, 81, 33, 189, 563, 1431, 1969, 1413, 9347, 11455, 33773, 14205}},
    {6474, 17, 6253, {1, 3, 5, 3, 9, 3, 117, 121, 107, 933, 1901, 1931, 1977, 1131, 8075, 32661, 103867}},
    {6475, 17, 6256, {1, 3, 7, 9, 19, 5, 17, 249, 293, 141, 1417, 113, 2877, 15781, 19981, 48773, 28853}},
    {6476, 17, 6268, {1, 3, 1, 1, 25, 7, 45, 111, 255, 1021, 1433, 3193, 5007, 1437, 28879, 28123, 106487}},
    {6477, 17, 6272, {1, 1, 7, 3, 13, 43, 101, 127, 319, 81, 993, 3003, 1549, 10679, 28333, 25341, 74549}},
    {6478, 17, 6275, {1, 1, 1, 3, 7, 41, 7, 11, 469, 109, 1893, 3663, 5763, 6709, 18493, 9827, 18043}},
    {6479, 17, 6281, {1, 1, 5, 9, 23, 3, 41, 137, 49, 719, 647, 1197, 7743, 4933, 26199, 54597, 35761}},
    {6480, 17, 6289, {1, 3, 7, 7, 25, 23, 93, 189, 177, 493, 971, 2537, 7, 10971, 19983, 37577, 27169}},
    {6481, 17, 6335, {1, 1, 3, 9, 5, 31, 117, 53, 401, 1023, 299, 889, 4013, 15883, 11343, 30571, 9921}},
    {6482, 17, 6338, {1, 1, 3, 11, 5, 37, 85, 241, 265, 891, 511, 2331, 6151, 10531, 18155, 64795, 27199}},
    {6483, 17, 6355, {1, 1, 5, 5, 1, 3, 83, 183, 157, 625, 383, 2421, 249, 5137, 8189, 41345, 85205}},
    {6484, 17, 6362, {1, 1, 7, 5, 11, 43, 123, 117, 201, 639, 1967, 2601, 6477, 6921, 30855, 37353, 113979}},
    {6485, 17, 6373, {1, 3, 1, 5, 7, 3, 63, 97, 303, 341, 2017, 3219, 3611, 789, 5755, 28215, 74663}},
    {6486, 17, 6386, {1, 3, 5, 3, 15, 9, 103, 125, 455, 413, 913, 451, 6601, 9813, 21811, 28201, 19403}},
    {6487, 17, 6388, {1, 3, 1, 13, 29, 63, 57, 19, 237, 215, 1349, 2563, 3011, 10033, 27407, 9977, 99121}},
    {6488, 17, 6391, {1, 3, 5, 5, 11, 21, 13, 145, 315, 361, 833, 1581, 3883, 12605, 29537, 55475, 35}},
    {6489, 17, 6397, {1, 3, 7, 15, 25, 39, 73, 57, 281, 477, 1031, 809, 2063, 5317, 23159, 33909, 24291}},
    {6490, 17, 6405, {1, 3, 3, 5, 19, 7, 125, 35, 213, 835, 649, 1335, 4395, 14591, 14935, 1129, 56537}},
    {6491, 17, 6406, {1, 3, 5, 3, 15, 35, 3, 145, 455, 203, 295, 2679, 1207, 10787, 7577, 707, 57721}},
    {6492, 17, 6410, {1, 3, 1, 9, 13, 9, 31, 193, 253, 917, 503, 2663, 2653, 15555, 31653, 12195, 125143}},
    {6493, 17, 6417, {1, 1, 3, 5, 13, 53, 77, 51, 139, 141, 1603, 1349, 6067, 14173, 1027, 18937, 26307}},
    {6494, 17, 6443, {1, 1, 1, 13, 17, 49, 33, 125, 359, 601, 1421, 3399, 7091, 15315, 18873, 15893, 98073}},
    {6495, 17, 6457, {1, 1, 7, 5, 7, 33, 27, 57, 321, 57, 239, 3007, 7923, 8903, 85, 32931, 21845}},
    {6496, 17, 6468, {1, 3, 5, 1, 17, 57, 21, 169, 499, 165, 949, 1659, 3785, 2307, 24429, 17389, 66957}},
    {6497, 17, 6475, {1, 3, 7, 9, 11, 3, 87, 69, 45, 91, 1899, 2743, 2281, 12819, 31271, 25991, 17149}},
    {6498, 17, 6486, {1, 3, 1, 15, 21, 1, 89, 73, 475, 573, 729, 1735, 6713, 2247, 16929, 4875, 18147}},
    {6499, 17, 6489, {1, 3, 3, 3, 5, 57, 125, 167, 7, 941, 1917, 1995, 2209, 1783, 2819, 52701, 97849}},
    {6500, 17, 6495, {1, 3, 1, 15, 3, 39, 33, 99, 101, 789, 1663, 875, 73, 15371, 23715, 9475, 115989}},
    {6501, 17, 6499, {1, 3, 7, 15, 27, 41, 91, 135, 113, 201, 973, 1143, 4249, 9717, 21161, 46669, 36247}},
    {6502, 17, 6505, {1, 1, 3, 7, 9, 25, 111, 105, 79, 189, 1867, 211, 2617, 5275, 15513, 61483, 51049}},
    {6503, 17, 6511, {1, 1, 3, 15, 15, 13, 13, 29, 125, 61, 1791, 3605, 7583, 9751, 23351, 53629, 1223}},
    {6504, 17, 6520, {1, 1, 1, 3, 17, 17, 127, 31, 341, 863, 87, 3563, 727, 1107, 10617, 20019, 122495}},
    {6505, 17, 6529, {1, 1, 1, 5, 17, 47, 19, 165, 511, 963, 397, 631, 2075, 6197, 5989, 46201, 87999}},
    {6506, 17, 6542, {1, 3, 3, 9, 9, 1, 7, 39, 371, 511, 617, 3841, 4749, 15567, 23279, 10763, 116393}},
    {6507, 17, 6547, {1, 3, 5, 9, 19, 25, 45, 147, 495, 749, 1505, 3785, 1737, 29, 14239, 8715, 2867}},
    {6508, 17, 6550, {1, 3, 5, 9, 29, 25, 23, 159, 111, 931, 573, 1207, 1799, 2049, 11557, 4303, 59525}},
    {6509, 17, 6554, {1, 1, 1, 7, 29, 11, 113, 67, 413, 581, 1189, 1771, 4757, 14573, 2299, 6949, 72043}},
    {6510, 17, 6556, {1, 1, 5, 15, 25, 33, 115, 169, 395, 841, 267, 3613, 2673, 6431, 7499, 26465, 76865}},
    {6511, 17, 6560, {1, 3, 5, 15, 29, 1, 119, 5, 357, 933, 1559, 891, 5115, 3295, 29053, 51447, 129961}},
    {6512, 17, 6569, {1, 1, 3, 11, 17, 57, 85, 169, 205, 579, 1515, 1415, 625, 15675, 4555, 9201, 108267}},
    {6513, 17, 6572, {1, 1, 3, 13, 31, 35, 119, 97, 483, 329, 1219, 2553, 6119, 3243, 12011, 12133, 12325}},
    {6514, 17, 6590, {1, 1, 1, 5, 29, 53, 29, 127, 181, 317, 1497, 1015, 1217, 3071, 10705, 59849, 3643}},
    {6515, 17, 6592, {1, 3, 5, 1, 31, 51, 65, 213, 141, 501, 835, 1823, 8069, 2431, 4065, 44589, 95645}},
    {6516, 17, 6601, {1, 3, 5, 3, 31, 13, 55, 71, 373, 191, 1255, 3207, 5291, 5093, 16451, 26757, 73237}},
    {6517, 17, 6610, {1, 3, 3, 11, 31, 25, 17, 45, 121, 413, 1819, 3459, 2147, 12155, 17571, 41487, 10129}},
    {6518, 17, 6632, {1, 1, 5, 11, 7, 21, 47, 147, 205, 971, 135, 3925, 2369, 3383, 27615, 43597, 30057}},
    {6519, 17, 6635, {1, 3, 5, 9, 23, 57, 97, 143, 401, 895, 959, 2811, 925, 14749, 24875, 2809, 123591}},
    {6520, 17, 6640, {1, 1, 3, 1, 9, 19, 97, 211, 401, 371, 521, 193, 7115, 8653, 4219, 23881, 107699}},
    {6521, 17, 6643, {1, 3, 3, 3, 1, 35, 81, 131, 403, 637, 1723, 2001, 7877, 4705, 24709, 38485, 74745}},
    {6522, 17, 6649, {1, 3, 3, 11, 23, 59, 25, 149, 373, 519, 617, 1613, 6237, 4519, 31337, 34945, 113095}},
    {6523, 17, 6659, {1, 3, 5, 13, 9, 59, 39, 93, 433, 449, 331, 3309, 2999, 8583, 6193, 4449, 96451}},
    {6524, 17, 6662, {1, 3, 5, 3, 25, 41, 17, 183, 443, 547, 1155, 1743, 6105, 11753, 13969, 31503, 48249}},
    {6525, 17, 6666, {1, 3, 3, 1, 19, 55, 97, 129, 293, 41, 137, 2187, 7313, 9481, 4295, 16931, 90763}},
    {6526, 17, 6690, {1, 3, 5, 9, 31, 31, 65, 47, 27, 783, 1401, 1145, 1807, 355, 11225, 52695, 3187}},
    {6527, 17, 6692, {1, 1, 7, 11, 1, 21, 67, 7, 15, 603, 113, 2157, 6599, 11341, 12719, 57955, 42937}},
    {6528, 17, 6704, {1, 1, 3, 7, 9, 59, 13, 157, 403, 569, 1287, 1341, 4263, 5535, 7281, 1025, 110287}},
    {6529, 17, 6713, {1, 1, 5, 15, 29, 35, 97, 207, 5, 581, 219, 497, 2871, 13287, 22075, 31157, 53913}},
    {6530, 17, 6728, {1, 3, 1, 3, 9, 7, 19, 137, 311, 185, 1339, 1321, 4949, 13367, 30059, 15259, 102335}},
    {6531, 17, 6731, {1, 3, 7, 9, 13, 27, 59, 65, 105, 277, 1231, 4057, 3439, 7743, 4741, 47661, 123813}},
    {6532, 17, 6734, {1, 1, 5, 5, 1, 19, 113, 35, 143, 995, 623, 197, 4347, 8643, 29825, 55641, 51989}},
    {6533, 17, 6746, {1, 1, 3, 5, 21, 23, 115, 127, 367, 671, 27, 949, 5101, 11439, 15003, 6835, 122611}},
    {6534, 17, 6755, {1, 1, 7, 9, 15, 17, 35, 155, 459, 161, 817, 867, 513, 10915, 1231, 7369, 84865}},
    {6535, 17, 6757, {1, 1, 7, 9, 3, 15, 5, 57, 435, 717, 541, 3523, 1891, 11875, 8053, 55571, 59433}},
    {6536, 17, 6764, {1, 3, 5, 15, 25, 39, 41, 187, 321, 979, 419, 445, 979, 4543, 13833, 60347, 19925}},
    {6537, 17, 6772, {1, 3, 7, 15, 25, 19, 105, 59, 321, 97, 499, 2557, 4249, 15541, 12821, 77, 108477}},
    {6538, 17, 6792, {1, 1, 3, 5, 3, 33, 57, 153, 375, 35, 1405, 3903, 5337, 3847, 26843, 35825, 2911}},
    {6539, 17, 6797, {1, 1, 7, 13, 27, 1, 93, 245, 389, 211, 285, 1273, 6445, 4293, 53, 22689, 24989}},
    {6540, 17, 6821, {1, 3, 1, 11, 3, 47, 63, 79, 57, 307, 623, 2173, 2053, 13051, 5153, 52205, 94615}},
    {6541, 17, 6822, {1, 1, 3, 1, 17, 25, 61, 177, 393, 505, 559, 1909, 4489, 9697, 4485, 21603, 51155}},
    {6542, 17, 6831, {1, 1, 7, 11, 19, 21, 49, 141, 351, 593, 131, 3431, 5373, 4013, 30243, 34877, 59093}},
    {6543, 17, 6834, {1, 1, 3, 7, 31, 57, 53, 153, 189, 809, 825, 247, 7365, 319, 14327, 29837, 61215}},
    {6544, 17, 6851, {1, 1, 1, 13, 23, 37, 53, 123, 287, 339, 1147, 783, 1507, 7255, 21963, 57705, 85379}},
    {6545, 17, 6858, {1, 3, 5, 1, 29, 21, 65, 227, 357, 363, 461, 2165, 565, 3125, 15231, 20579, 25269}},
    {6546, 17, 6860, {1, 3, 5, 11, 7, 15, 59, 9, 365, 571, 1455, 3995, 2091, 6425, 12891, 53849, 3235}},
    {6547, 17, 6871, {1, 3, 7, 3, 17, 13, 35, 53, 427, 59, 925, 457, 2679, 5917, 32603, 23489, 42463}},
    {6548, 17, 6875, {1, 3, 5, 3, 19, 47, 65, 215, 351, 653, 983, 3807, 963, 12025, 13247, 50127, 28805}},
    {6549, 17, 6884, {1, 1, 1, 15, 29, 27, 113, 241, 109, 649, 1187, 4087, 5025, 10257, 7641, 59245, 102467}},
    {6550, 17, 6888, {1, 3, 1, 5, 31, 27, 109, 241, 105, 337, 259, 2169, 6851, 1817, 4595, 18129, 14169}},
    {6551, 17, 6894, {1, 1, 1, 7, 3, 19, 5, 161, 473, 187, 1419, 1933, 5009, 9317, 14607, 60279, 49113}},
    {6552, 17, 6919, {1, 1, 5, 7, 5, 53, 3, 239, 95, 21, 1057, 2125, 1505, 8427, 16383, 45379, 30745}},
    {6553, 17, 6940, {1, 1, 1, 9, 15, 7, 11, 203, 357, 271, 1945, 3581, 3613, 2381, 16099, 62013, 38223}},
    {6554, 17, 6950, {1, 1, 5, 5, 11, 59, 97, 151, 243, 979, 1097, 1077, 4317, 4517, 20871, 45991, 7299}},
    {6555, 17, 6959, {1, 1, 1, 11, 25, 37, 127, 251, 141, 683, 1647, 3173, 5147, 7143, 30727, 38305, 29175}},
    {6556, 17, 6968, {1, 3, 7, 7, 1, 17, 117, 61, 111, 533, 1973, 1925, 3211, 3081, 707, 12187, 74473}},
    {6557, 17, 6981, {1, 3, 1, 5, 9, 49, 83, 171, 347, 251, 1627, 1035, 6811, 11831, 6269, 21113, 75503}},
    {6558, 17, 6988, {1, 3, 3, 3, 25, 11, 87, 17, 181, 175, 1987, 3983, 7889, 5449, 27083, 45339, 106789}},
    {6559, 17, 6996, {1, 3, 5, 3, 13, 55, 23, 53, 133, 985, 1051, 1891, 3447, 3173, 3849, 10167, 19889}},
    {6560, 17, 6999, {1, 3, 5, 5, 11, 41, 65, 21, 191, 285, 45, 3593, 6531, 1227, 30829, 41845, 60523}},
    {6561, 17, 7015, {1, 3, 3, 15, 19, 23, 5, 21, 255, 273, 1543, 3229, 6329, 6177, 27619, 29089, 25505}},
    {6562, 17, 7019, {1, 3, 7, 7, 9, 27, 97, 117, 185, 167, 353, 3319, 5557, 943, 16929, 37747, 49363}},
    {6563, 17, 7022, {1, 3, 1, 5, 29, 23, 51, 135, 277, 225, 1509, 1715, 3935, 11125, 23069, 22851, 122431}},
    {6564, 17, 7040, {1, 1, 7, 7, 29, 57, 11, 175, 355, 715, 1515, 2509, 6859, 8505, 20969, 65009, 21845}},
    {6565, 17, 7045, {1, 3, 1, 7, 15, 51, 1, 157, 387, 829, 1883, 317, 7529, 97, 4963, 43029, 20741}},
    {6566, 17, 7049, {1, 3, 7, 3, 19, 31, 75, 125, 179, 735, 1977, 2615, 7721, 12613, 5457, 17493, 127781}},
    {6567, 17, 7055, {1, 3, 5, 11, 17, 21, 109, 213, 221, 649, 35, 65, 7251, 9259, 26533, 20773, 11349}},
    {6568, 17, 7073, {1, 1, 1, 15, 17, 33, 47, 253, 11, 313, 1199, 1925, 7063, 4071, 32101, 49543, 91845}},
    {6569, 17, 7076, {1, 1, 1, 9, 7, 33, 87, 79, 485, 503, 839, 4087, 8061, 11041, 13105, 45551, 19777}},
    {6570, 17, 7085, {1, 1, 1, 5, 13, 41, 87, 139, 511, 899, 659, 1923, 4669, 3365, 8455, 48811, 47873}},
    {6571, 17, 7091, {1, 3, 5, 3, 5, 3, 49, 185, 25, 657, 799, 1623, 835, 7595, 22121, 54307, 123411}},
    {6572, 17, 7103, {1, 3, 7, 7, 21, 19, 23, 221, 111, 159, 583, 2757, 3259, 11921, 947, 29559, 109401}},
    {6573, 17, 7112, {1, 1, 7, 9, 11, 45, 103, 15, 329, 367, 843, 1703, 1893, 14835, 18377, 3359, 38657}},
    {6574, 17, 7117, {1, 1, 7, 1, 13, 17, 15, 135, 143, 319, 605, 2509, 1969, 6165, 14139, 19059, 111175}},
    {6575, 17, 7118, {1, 1, 5, 9, 5, 55, 119, 93, 245, 115, 751, 3423, 4745, 12093, 14775, 62573, 24693}},
    {6576, 17, 7123, {1, 1, 1, 5, 27, 49, 87, 95, 257, 861, 1127, 2233, 2595, 10489, 11977, 39713, 103599}},
    {6577, 17, 7126, {1, 3, 5, 3, 15, 45, 53, 245, 69, 797, 197, 2415, 4643, 6495, 29545, 2661, 76787}},
    {6578, 17, 7154, {1, 3, 5, 3, 9, 25, 103, 83, 285, 973, 1021, 33, 5193, 4563, 30443, 1333, 86313}},
    {6579, 17, 7180, {1, 3, 3, 3, 11, 11, 125, 57, 349, 829, 1339, 2321, 1875, 12181, 12571, 28681, 6273}},
    {6580, 17, 7192, {1, 3, 5, 9, 11, 59, 19, 11, 353, 965, 1979, 3473, 4949, 12251, 29147, 61809, 69001}},
    {6581, 17, 7195, {1, 3, 7, 3, 23, 21, 73, 37, 33, 647, 1261, 3813, 2941, 10655, 26813, 27987, 87541}},
    {6582, 17, 7207, {1, 1, 1, 15, 31, 31, 77, 79, 193, 135, 1019, 3503, 2097, 9169, 15495, 41945, 56975}},
    {6583, 17, 7208, {1, 3, 5, 5, 21, 31, 77, 239, 95, 951, 1579, 2511, 2423, 16263, 25351, 8415, 117729}},
    {6584, 17, 7214, {1, 1, 7, 9, 23, 57, 85, 89, 29, 1017, 1207, 745, 5487, 4325, 30723, 48901, 55019}},
    {6585, 17, 7222, {1, 3, 5, 7, 25, 51, 33, 151, 241, 947, 1673, 461, 5235, 8311, 7425, 42811, 1693}},
    {6586, 17, 7234, {1, 3, 3, 7, 23, 45, 81, 7, 129, 155, 1343, 895, 33, 6585, 75, 21679, 118409}},
    {6587, 17, 7254, {1, 3, 7, 1, 21, 55, 61, 109, 129, 601, 557, 1313, 7813, 3023, 4599, 45809, 65885}},
    {6588, 17, 7258, {1, 1, 1, 9, 3, 3, 55, 27, 427, 605, 615, 2855, 6347, 4375, 29293, 39069, 50037}},
    {6589, 17, 7264, {1, 3, 5, 1, 1, 23, 39, 3, 221, 213, 2001, 2867, 1701, 13607, 11239, 64771, 43927}},
    {6590, 17, 7279, {1, 3, 1, 5, 21, 49, 89, 185, 487, 219, 1781, 3971, 5889, 1325, 22501, 12777, 78719}},
    {6591, 17, 7282, {1, 1, 7, 3, 17, 53, 7, 153, 49, 185, 381, 733, 6397, 5923, 16207, 17115, 113101}},
    {6592, 17, 7293, {1, 1, 7, 9, 13, 1, 43, 167, 163, 883, 1597, 3643, 67, 5499, 29925, 41711, 105385}},
    {6593, 17, 7297, {1, 1, 5, 13, 29, 53, 23, 237, 125, 603, 489, 3747, 651, 501, 8297, 45851, 41545}},
    {6594, 17, 7322, {1, 3, 5, 11, 13, 53, 77, 161, 397, 17, 1379, 1287, 1833, 5851, 4475, 1309, 62227}},
    {6595, 17, 7324, {1, 1, 1, 13, 27, 39, 111, 23, 323, 403, 2021, 1153, 3735, 15443, 25479, 10105, 63507}},
    {6596, 17, 7351, {1, 3, 7, 15, 1, 33, 39, 59, 39, 423, 65, 3767, 177, 9107, 23157, 39759, 89451}},
    {6597, 17, 7363, {1, 1, 5, 15, 1, 27, 5, 143, 307, 491, 1663, 1101, 1073, 4057, 13851, 17881, 115913}},
    {6598, 17, 7380, {1, 3, 5, 13, 5, 51, 41, 191, 79, 95, 1309, 391, 2123, 3129, 25601, 4461, 114205}},
    {6599, 17, 7384, {1, 3, 5, 9, 29, 7, 53, 165, 95, 269, 1295, 3555, 6843, 5259, 26917, 48573, 66367}},
    {6600, 17, 7389, {1, 3, 1, 13, 1, 51, 107, 243, 383, 159, 1165, 3005, 1433, 7495, 16263, 15489, 64727}},
    {6601, 17, 7396, {1, 3, 1, 11, 25, 61, 109, 107, 361, 235, 1253, 3031, 7143, 12995, 9019, 46679, 6617}},
    {6602, 17, 7413, {1, 1, 5, 13, 19, 19, 125, 225, 505, 913, 1819, 2505, 161, 13719, 20865, 14085, 13651}},
    {6603, 17, 7417, {1, 1, 5, 15, 9, 17, 25, 127, 223, 569, 1225, 859, 7379, 3901, 25983, 30367, 36669}},
    {6604, 17, 7431, {1, 1, 1, 5, 11, 57, 59, 169, 221, 639, 1515, 2211, 7703, 11173, 10311, 18921, 55185}},
    {6605, 17, 7443, {1, 1, 1, 3, 3, 35, 5, 61, 153, 171, 823, 3047, 1287, 14745, 31929, 19259, 71687}},
    {6606, 17, 7445, {1, 3, 5, 1, 7, 57, 49, 173, 373, 639, 1755, 1069, 7885, 14585, 1713, 28709, 69095}},
    {6607, 17, 7450, {1, 3, 7, 1, 9, 45, 51, 241, 181, 937, 1901, 1201, 7987, 12517, 17811, 25325, 13893}},
    {6608, 17, 7456, {1, 1, 1, 15, 27, 7, 125, 175, 237, 169, 1301, 2779, 691, 4873, 30129, 39839, 114841}},
    {6609, 17, 7466, {1, 3, 1, 11, 5, 15, 27, 93, 85, 467, 1519, 2115, 4941, 12405, 12521, 62169, 12375}},
    {6610, 17, 7468, {1, 3, 1, 11, 3, 51, 59, 21, 43, 391, 1055, 2941, 2029, 7965, 29747, 4037, 125511}},
    {6611, 17, 7474, {1, 3, 7, 5, 29, 31, 85, 109, 447, 519, 1297, 2379, 3147, 13695, 19937, 37783, 125871}},
    {6612, 17, 7479, {1, 3, 1, 1, 23, 35, 13, 151, 237, 1, 443, 2843, 1943, 9921, 5321, 5395, 127969}},
    {6613, 17, 7486, {1, 3, 3, 3, 31, 31, 13, 207, 39, 571, 189, 2447, 1335, 1767, 31805, 60385, 68971}},
    {6614, 17, 7497, {1, 3, 5, 7, 21, 37, 127, 11, 187, 377, 225, 259, 4793, 4411, 18555, 53861, 49531}},
    {6615, 17, 7508, {1, 3, 3, 1, 1, 45, 53, 211, 457, 959, 1343, 1133, 5529, 4395, 21111, 20199, 21309}},
    {6616, 17, 7515, {1, 3, 1, 7, 9, 5, 5, 189, 135, 775, 219, 2907, 8001, 4973, 17273, 43967, 82085}},
    {6617, 17, 7533, {1, 3, 3, 7, 11, 25, 117, 15, 303, 539, 517, 1115, 6179, 3957, 27015, 18285, 44787}},
    {6618, 17, 7542, {1, 3, 5, 1, 3, 1, 17, 9, 365, 631, 1041, 1529, 5367, 3465, 11715, 39107, 87541}},
    {6619, 17, 7546, {1, 3, 5, 15, 9, 11, 89, 151, 313, 663, 605, 105, 6999, 13245, 1871, 22679, 74765}},
    {6620, 17, 7551, {1, 3, 7, 15, 19, 39, 85, 225, 463, 763, 1267, 1967, 3489, 9983, 12159, 16667, 52649}},
    {6621, 17, 7569, {1, 3, 1, 15, 15, 17, 7, 73, 393, 239, 1845, 597, 2581, 10125, 22303, 51201, 115199}},
    {6622, 17, 7572, {1, 1, 5, 9, 7, 21, 123, 247, 491, 261, 617, 907, 4331, 2523, 27139, 23539, 103209}},
    {6623, 17, 7595, {1, 3, 3, 7, 23, 31, 7, 171, 157, 335, 429, 109, 3817, 761, 18037, 32725, 35691}},
    {6624, 17, 7603, {1, 1, 3, 1, 3, 9, 29, 91, 223, 845, 253, 2437, 2119, 11965, 26349, 8417, 41241}},
    {6625, 17, 7605, {1, 3, 7, 15, 7, 29, 45, 51, 245, 987, 1755, 3397, 4251, 2977, 3809, 48671, 51899}},
    {6626, 17, 7629, {1, 3, 1, 1, 25, 41, 101, 109, 117, 805, 2041, 2359, 7275, 7601, 29195, 26185, 36731}},
    {6627, 17, 7632, {1, 1, 5, 7, 29, 49, 87, 33, 21, 897, 1089, 2463, 2671, 2599, 6421, 3981, 48265}},
    {6628, 17, 7638, {1, 3, 1, 5, 29, 53, 43, 1, 431, 67, 605, 181, 2053, 2133, 25229, 9041, 7401}},
    {6629, 17, 7648, {1, 1, 1, 15, 29, 33, 67, 171, 109, 519, 197, 3693, 479, 13655, 17719, 20073, 18425}},
    {6630, 17, 7654, {1, 3, 1, 5, 27, 3, 85, 113, 331, 145, 69, 667, 1315, 2143, 12701, 64515, 42059}},
    {6631, 17, 7663, {1, 1, 5, 13, 17, 15, 99, 231, 41, 875, 1661, 697, 887, 13025, 127, 4949, 91777}},
    {6632, 17, 7675, {1, 3, 1, 3, 1, 15, 23, 221, 89, 605, 323, 3277, 2471, 13383, 9649, 50913, 20203}},
    {6633, 17, 7693, {1, 3, 1, 9, 17, 1, 59, 181, 447, 273, 849, 3623, 4489, 9959, 11499, 34703, 61333}},
    {6634, 17, 7705, {1, 1, 7, 11, 23, 19, 57, 169, 237, 261, 1211, 3087, 4951, 6269, 5419, 16569, 106509}},
    {6635, 17, 7717, {1, 1, 5, 13, 1, 27, 115, 155, 35, 997, 1347, 4001, 8051, 7567, 4221, 63915, 88615}},
    {6636, 17, 7724, {1, 3, 3, 15, 31, 27, 3, 203, 251, 737, 373, 1759, 6537, 15973, 26855, 36963, 70745}},
    {6637, 17, 7727, {1, 3, 7, 5, 3, 41, 19, 83, 75, 39, 1507, 3735, 3027, 4061, 31619, 37999, 21665}},
    {6638, 17, 7735, {1, 1, 3, 7, 11, 19, 39, 163, 469, 365, 261, 2715, 375, 10921, 20289, 5727, 100907}},
    {6639, 17, 7761, {1, 1, 5, 11, 27, 53, 113, 207, 87, 915, 41, 3, 3853, 11303, 27759, 64279, 64273}},
    {6640, 17, 7767, {1, 1, 5, 9, 21, 43, 89, 61, 467, 747, 503, 1283, 4221, 12909, 16623, 39689, 93773}},
    {6641, 17, 7783, {1, 3, 3, 9, 1, 47, 67, 167, 293, 249, 1583, 2073, 4509, 15495, 16787, 3267, 50559}},
    {6642, 17, 7784, {1, 1, 7, 9, 27, 49, 75, 251, 195, 923, 959, 567, 6133, 14057, 20843, 10655, 33689}},
    {6643, 17, 7798, {1, 3, 7, 13, 29, 9, 81, 95, 1, 763, 1117, 2719, 1797, 16129, 26877, 61147, 68183}},
    {6644, 17, 7802, {1, 3, 3, 15, 13, 35, 45, 137, 255, 917, 79, 1309, 2137, 13315, 769, 51695, 101033}},
    {6645, 17, 7811, {1, 1, 3, 3, 1, 15, 99, 79, 399, 285, 1657, 317, 4729, 2723, 31879, 32543, 37981}},
    {6646, 17, 7817, {1, 1, 5, 15, 27, 31, 71, 73, 483, 627, 785, 803, 5347, 1717, 17195, 25801, 56587}},
    {6647, 17, 7823, {1, 1, 3, 11, 5, 33, 17, 85, 461, 47, 1825, 3715, 3639, 2577, 141, 54579, 80421}},
    {6648, 17, 7832, {1, 3, 3, 3, 13, 3, 111, 183, 417, 525, 1311, 3347, 6233, 7049, 15491, 26355, 37063}},
    {6649, 17, 7837, {1, 1, 3, 5, 7, 31, 39, 145, 403, 967, 1511, 2557, 4907, 563, 20725, 52305, 24125}},
    {6650, 17, 7842, {1, 3, 5, 13, 11, 7, 121, 53, 111, 493, 1821, 2637, 7987, 7177, 19529, 25005, 129029}},
    {6651, 17, 7853, {1, 3, 3, 1, 5, 11, 23, 109, 479, 395, 83, 3203, 2161, 7477, 10863, 51359, 72377}},
    {6652, 17, 7854, {1, 1, 5, 13, 9, 27, 125, 103, 365, 427, 271, 3231, 2103, 1747, 9315, 34689, 105899}},
    {6653, 17, 7856, {1, 3, 3, 9, 9, 13, 77, 39, 241, 887, 601, 3861, 5967, 15635, 18679, 52783, 101859}},
    {6654, 17, 7861, {1, 3, 3, 15, 7, 25, 51, 7, 157, 691, 783, 3727, 2553, 1965, 22039, 56169, 121077}},
    {6655, 17, 7862, {1, 3, 3, 9, 25, 13, 61, 25, 153, 435, 1929, 2451, 6819, 10813, 907, 38439, 40957}},
    {6656, 17, 7873, {1, 1, 5, 9, 13, 21, 119, 101, 403, 209, 1747, 1291, 7527, 11597, 3625, 55003, 86357}},
    {6657, 17, 7874, {1, 1, 3, 15, 23, 49, 89, 37, 199, 397, 1421, 2707, 1031, 9381, 2059, 13555, 104779}},
    {6658, 17, 7886, {1, 3, 7, 3, 7, 11, 113, 61, 427, 219, 1007, 285, 973, 15275, 13531, 48529, 26519}},
    {6659, 17, 7914, {1, 1, 7, 13, 19, 15, 17, 177, 143, 779, 621, 867, 427, 13609, 28997, 23521, 52337}},
    {6660, 17, 7927, {1, 3, 7, 1, 11, 15, 21, 37, 89, 735, 255, 903, 6029, 7299, 6495, 42767, 6227}},
    {6661, 17, 7936, {1, 1, 3, 1, 15, 33, 3, 91, 347, 681, 1157, 3353, 2317, 9149, 7105, 46021, 55237}},
    {6662, 17, 7951, {1, 1, 3, 1, 9, 59, 81, 29, 409, 749, 1357, 3241, 8045, 12889, 28231, 63099, 109729}},
    {6663, 17, 7963, {1, 1, 7, 15, 25, 35, 109, 127, 47, 131, 1665, 3871, 6977, 2595, 29867, 58085, 32093}},
    {6664, 17, 7966, {1, 3, 3, 15, 29, 55, 23, 71, 129, 799, 767, 1687, 4345, 9217, 13941, 51363, 72679}},
    {6665, 17, 7976, {1, 3, 5, 11, 21, 9, 21, 13, 53, 403, 1991, 1027, 317, 8147, 20377, 5717, 124039}},
    {6666, 17, 7993, {1, 3, 3, 13, 21, 51, 27, 27, 239, 455, 1697, 677, 6185, 4181, 30789, 47317, 34845}},
    {6667, 17, 8001, {1, 3, 1, 1, 9, 15, 111, 161, 107, 627, 919, 2915, 107, 15389, 2671, 36233, 40725}},
    {6668, 17, 8004, {1, 1, 5, 13, 27, 59, 107, 115, 437, 137, 1317, 2941, 3501, 13921, 9521, 1719, 60087}},
    {6669, 17, 8013, {1, 3, 1, 13, 7, 27, 73, 27, 261, 473, 489, 1027, 6041, 16327, 16083, 2077, 73277}},
    {6670, 17, 8021, {1, 1, 1, 7, 25, 49, 43, 183, 315, 583, 1779, 1781, 2029, 2165, 32745, 38715, 108009}},
    {6671, 17, 8026, {1, 1, 1, 15, 11, 35, 81, 131, 11, 15, 1995, 669, 2851, 13841, 143, 39263, 92313}},
    {6672, 17, 8028, {1, 1, 3, 15, 25, 41, 9, 81, 239, 711, 1959, 2135, 5263, 2775, 717, 935, 82629}},
    {6673, 17, 8031, {1, 3, 1, 5, 19, 19, 11, 157, 181, 753, 639, 1731, 2129, 2979, 13195, 11675, 85493}},
    {6674, 17, 8035, {1, 1, 1, 9, 19, 29, 111, 33, 367, 673, 429, 699, 1681, 5359, 17939, 6535, 123585}},
    {6675, 17, 8042, {1, 3, 3, 9, 19, 61, 47, 185, 143, 567, 221, 299, 3779, 9067, 20109, 2511, 110247}},
    {6676, 17, 8071, {1, 1, 5, 3, 11, 59, 19, 125, 173, 793, 541, 3023, 1573, 3889, 32415, 15523, 15373}},
    {6677, 17, 8085, {1, 1, 5, 3, 27, 25, 115, 153, 295, 691, 1789, 3963, 135, 4891, 27123, 9539, 10743}},
    {6678, 17, 8092, {1, 1, 1, 7, 23, 11, 117, 39, 503, 863, 647, 2409, 2255, 5663, 28747, 23763, 83943}},
    {6679, 17, 8102, {1, 1, 7, 11, 7, 7, 39, 101, 395, 357, 779, 1659, 495, 4571, 13379, 39985, 55501}},
    {6680, 17, 8105, {1, 1, 5, 1, 15, 17, 123, 217, 455, 949, 157, 2457, 2969, 3043, 1239, 5531, 26129}},
    {6681, 17, 8114, {1, 1, 7, 5, 7, 27, 91, 103, 215, 979, 1221, 461, 6255, 5009, 15077, 19201, 90039}},
    {6682, 17, 8123, {1, 1, 5, 9, 31, 57, 77, 193, 37, 763, 1377, 231, 2187, 11763, 4107, 31185, 40861}},
    {6683, 17, 8131, {1, 3, 5, 7, 15, 45, 59, 151, 161, 967, 1071, 463, 5509, 14449, 8843, 26193, 78345}},
    {6684, 17, 8140, {1, 1, 3, 5, 11, 49, 121, 89, 213, 1001, 553, 4005, 385, 6229, 19205, 7633, 87709}},
    {6685, 17, 8145, {1, 3, 3, 13, 9, 47, 1, 183, 161, 619, 885, 2155, 4975, 15985, 10017, 60705, 100157}},
    {6686, 17, 8157, {1, 3, 5, 13, 9, 13, 55, 109, 385, 499, 301, 3875, 7317, 16165, 30795, 29507, 84907}},
    {6687, 17, 8158, {1, 3, 5, 11, 31, 43, 5, 215, 295, 735, 1611, 1221, 1445, 8897, 28649, 57293, 66011}},
    {6688, 17, 8185, {1, 1, 3, 15, 9, 21, 47, 249, 335, 737, 233, 3041, 5099, 10287, 1277, 30343, 11409}},
    {6689, 17, 8186, {1, 1, 3, 1, 21, 63, 71, 173, 45, 751, 971, 2429, 4749, 6337, 21193, 60847, 6873}},
    {6690, 17, 8188, {1, 1, 1, 9, 17, 15, 97, 179, 489, 469, 643, 1799, 1503, 13573, 17427, 63539, 6659}},
    {6691, 17, 8192, {1, 1, 3, 3, 15, 23, 83, 217, 391, 759, 115, 1405, 491, 7089, 15595, 31147, 40787}},
    {6692, 17, 8212, {1, 3, 1, 9, 15, 17, 9, 91, 389, 327, 1841, 3941, 4853, 5353, 8379, 55913, 36651}},
    {6693, 17, 8219, {1, 3, 5, 15, 19, 17, 111, 53, 233, 883, 1143, 2785, 2293, 12433, 22455, 3103, 96481}},
    {6694, 17, 8221, {1, 3, 5, 5, 1, 29, 19, 85, 463, 621, 55, 1583, 7081, 10361, 15985, 15991, 69603}},
    {6695, 17, 8235, {1, 3, 7, 5, 9, 21, 53, 245, 145, 315, 911, 2799, 2421, 5955, 2811, 40617, 68733}},
    {6696, 17, 8237, {1, 3, 5, 5, 15, 37, 119, 215, 27, 831, 511, 3747, 6751, 12411, 26099, 22213, 30451}},
    {6697, 17, 8249, {1, 1, 1, 1, 19, 9, 117, 199, 133, 159, 345, 1989, 3381, 15023, 14015, 51067, 25395}},
    {6698, 17, 8260, {1, 1, 5, 11, 1, 47, 97, 129, 381, 135, 1995, 53, 2027, 2519, 24861, 56637, 128407}},
    {6699, 17, 8264, {1, 1, 5, 3, 5, 43, 93, 141, 79, 915, 317, 1235, 8049, 9453, 3999, 28413, 96071}},
    {6700, 17, 8270, {1, 3, 3, 3, 11, 21, 19, 89, 287, 757, 2001, 1823, 1301, 5173, 2363, 51783, 116603}},
    {6701, 17, 8282, {1, 3, 1, 11, 31, 27, 71, 85, 399, 949, 521, 1161, 7823, 15609, 28197, 13105, 37141}},
    {6702, 17, 8291, {1, 3, 1, 13, 31, 29, 47, 3, 491, 999, 255, 2029, 3071, 479, 27685, 4587, 94973}},
    {6703, 17, 8293, {1, 1, 1, 5, 9, 17, 39, 117, 427, 407, 103, 3467, 5873, 1417, 8881, 36861, 123327}},
    {6704, 17, 8297, {1, 1, 3, 13, 15, 7, 61, 177, 59, 67, 1757, 3563, 835, 14037, 13595, 64671, 105889}},
    {6705, 17, 8298, {1, 3, 3, 13, 15, 25, 107, 41, 281, 613, 1539, 873, 6583, 5479, 2101, 27781, 68803}},
    {6706, 17, 8305, {1, 1, 3, 11, 9, 15, 33, 53, 311, 815, 2041, 1001, 329, 13715, 4081, 44271, 100397}},
    {6707, 17, 8306, {1, 1, 5, 11, 23, 29, 25, 161, 439, 183, 311, 3559, 1357, 363, 30893, 62067, 60197}},
    {6708, 17, 8311, {1, 1, 7, 11, 21, 13, 33, 43, 195, 419, 685, 1675, 2203, 1327, 26743, 65285, 19209}},
    {6709, 17, 8318, {1, 3, 3, 9, 3, 29, 113, 123, 511, 787, 327, 2523, 1191, 75, 7935, 16803, 25661}},
    {6710, 17, 8327, {1, 1, 3, 7, 27, 63, 113, 187, 433, 663, 57, 1329, 3967, 14061, 17075, 38445, 123547}},
    {6711, 17, 8345, {1, 3, 1, 11, 7, 15, 97, 199, 493, 163, 1251, 1007, 5827, 2225, 29771, 36321, 78755}},
    {6712, 17, 8379, {1, 3, 3, 7, 27, 15, 39, 129, 39, 537, 1305, 2041, 1325, 3127, 6781, 14669, 84269}},
    {6713, 17, 8390, {1, 1, 1, 3, 31, 51, 99, 169, 85, 361, 1979, 2227, 5915, 10391, 26049, 44143, 15065}},
    {6714, 17, 8394, {1, 1, 1, 7, 29, 11, 113, 67, 413, 581, 1189, 1771, 4757, 14573, 2299, 6949, 72043}},
    {6715, 17, 8414, {1, 3, 3, 15, 15, 45, 97, 255, 455, 549, 1389, 1181, 3771, 1397, 21821, 49339, 65113}},
    {6716, 17, 8417, {1, 3, 1, 15, 21, 11, 49, 167, 507, 23, 1563, 2197, 4699, 12891, 27741, 49027, 59523}},
    {6717, 17, 8432, {1, 1, 3, 9, 17, 15, 89, 129, 385, 183, 921, 1709, 1663, 12233, 30001, 21953, 36469}},
    {6718, 17, 8437, {1, 3, 7, 13, 7, 15, 47, 53, 157, 915, 307, 2153, 2387, 13581, 13913, 60511, 10961}},
    {6719, 17, 8441, {1, 3, 5, 7, 5, 47, 43, 235, 3, 195, 293, 743, 6445, 2019, 20535, 55477, 112553}},
    {6720, 17, 8449, {1, 3, 7, 15, 3, 45, 95, 47, 277, 493, 1307, 309, 1699, 5875, 7551, 37891, 105663}},
    {6721, 17, 8456, {1, 3, 1, 11, 1, 17, 15, 31, 261, 587, 97, 769, 1147, 3641, 14981, 57913, 114197}},
    {6722, 17, 8473, {1, 1, 3, 15, 17, 53, 41, 61, 315, 633, 489, 3255, 1803, 3321, 19759, 3181, 42447}},
    {6723, 17, 8489, {1, 3, 5, 7, 21, 11, 83, 247, 335, 475, 1969, 1971, 7821, 6305, 2025, 33551, 41187}},
    {6724, 17, 8495, {1, 1, 5, 11, 7, 21, 47, 147, 205, 971, 135, 3925, 2369, 3383, 27615, 43597, 30057}},
    {6725, 17, 8522, {1, 3, 7, 3, 9, 29, 23, 61, 403, 787, 621, 3633, 3477, 1341, 28659, 58633, 64613}},
    {6726, 17, 8524, {1, 3, 5, 1, 5, 49, 123, 131, 305, 425, 659, 131, 5911, 1587, 2141, 50573, 82165}},
    {6727, 17, 8529, {1, 3, 3, 11, 23, 59, 25, 149, 373, 519, 617, 1613, 6237, 4519, 31337, 34945, 113095}},
    {6728, 17, 8545, {1, 3, 5, 5, 1, 53, 91, 163, 3, 649, 261, 3711, 3911, 14107, 1809, 50655, 15795}},
    {6729, 17, 8557, {1, 1, 3, 13, 5, 43, 67, 221, 145, 603, 1467, 2111, 5353, 3081, 26317, 53639, 118025}},
    {6730, 17, 8565, {1, 3, 5, 1, 21, 3, 47, 193, 17, 755, 1339, 2969, 6269, 3951, 7643, 941, 72805}},
    {6731, 17, 8572, {1, 3, 5, 11, 5, 49, 123, 49, 67, 503, 921, 735, 2843, 9839, 27373, 34733, 97435}},
    {6732, 17, 8576, {1, 3, 1, 13, 23, 27, 13, 27, 23, 291, 1849, 169, 907, 9069, 9653, 38689, 443}},
    {6733, 17, 8582, {1, 1, 7, 3, 27, 41, 23, 25, 459, 411, 833, 2589, 7291, 3003, 11971, 34323, 85887}},
    {6734, 17, 8594, {1, 1, 1, 7, 25, 53, 27, 103, 61, 717, 241, 3881, 3883, 9285, 16609, 42621, 43657}},
    {6735, 17, 8629, {1, 1, 7, 13, 5, 27, 29, 149, 25, 743, 1045, 545, 299, 10533, 22547, 25299, 116655}},
    {6736, 17, 8636, {1, 3, 7, 5, 25, 13, 85, 227, 349, 697, 1049, 1767, 2967, 429, 23117, 57553, 67651}},
    {6737, 17, 8668, {1, 1, 5, 5, 13, 17, 115, 81, 435, 617, 125, 2471, 4487, 6135, 20871, 39547, 128281}},
    {6738, 17, 8678, {1, 1, 7, 1, 23, 23, 69, 145, 361, 309, 1311, 3831, 4709, 4221, 30113, 46049, 102539}},
    {6739, 17, 8701, {1, 3, 7, 13, 21, 51, 93, 243, 419, 725, 43, 1851, 1051, 1071, 22949, 50605, 82751}},
    {6740, 17, 8702, {1, 1, 1, 9, 5, 47, 93, 109, 79, 225, 857, 2577, 1235, 3791, 26423, 25157, 80803}},
    {6741, 17, 8708, {1, 1, 7, 9, 5, 41, 7, 247, 457, 269, 1985, 1515, 5069, 8637, 10511, 16069, 21157}},
    {6742, 17, 8712, {1, 1, 7, 11, 9, 57, 7, 175, 285, 399, 1633, 2255, 809, 6637, 15621, 34309, 87597}},
    {6743, 17, 8745, {1, 1, 3, 5, 31, 33, 123, 181, 131, 737, 731, 4045, 4379, 7339, 22837, 25207, 2559}},
    {6744, 17, 8754, {1, 1, 1, 7, 19, 59, 57, 75, 37, 833, 413, 1359, 5289, 15083, 30743, 43051, 126277}},
    {6745, 17, 8759, {1, 1, 5, 1, 11, 53, 97, 233, 13, 743, 1331, 1525, 6251, 5991, 29361, 3601, 55627}},
    {6746, 17, 8763, {1, 1, 3, 11, 21, 17, 45, 63, 77, 497, 439, 4077, 4047, 273, 3233, 54695, 22013}},
    {6747, 17, 8766, {1, 3, 3, 11, 25, 31, 61, 77, 205, 645, 981, 1577, 1981, 14649, 13579, 59837, 77539}},
    {6748, 17, 8780, {1, 3, 1, 5, 11, 17, 115, 27, 201, 731, 1919, 1023, 4525, 11397, 25095, 24005, 24079}},
    {6749, 17, 8783, {1, 1, 1, 15, 29, 27, 113, 241, 109, 649, 1187, 4087, 5025, 10257, 7641, 59245, 102467}},
    {6750, 17, 8786, {1, 3, 1, 5, 31, 27, 109, 241, 105, 337, 259, 2169, 6851, 1817, 4595, 18129, 14169}},
    {6751, 17, 8798, {1, 1, 7, 15, 17, 63, 35, 109, 327, 425, 1561, 2331, 4623, 9171, 31827, 12505, 79549}},
    {6752, 17, 8804, {1, 3, 3, 5, 21, 45, 79, 19, 43, 451, 1025, 781, 3475, 3741, 30451, 52627, 110005}},
    {6753, 17, 8819, {1, 1, 3, 13, 17, 21, 103, 109, 435, 247, 1125, 3195, 1281, 9383, 8127, 27535, 113249}},
    {6754, 17, 8826, {1, 1, 3, 7, 29, 37, 7, 3, 429, 651, 1329, 3739, 5049, 10999, 18407, 6573, 125903}},
    {6755, 17, 8835, {1, 3, 1, 9, 5, 63, 123, 223, 87, 1023, 619, 1769, 5315, 5171, 22981, 34095, 36095}},
    {6756, 17, 8838, {1, 1, 5, 3, 13, 15, 3, 253, 13, 705, 1635, 4057, 2601, 14103, 7089, 54571, 118629}},
    {6757, 17, 8856, {1, 3, 7, 5, 21, 25, 21, 45, 341, 457, 1351, 2345, 5301, 2213, 803, 32205, 115841}},
    {6758, 17, 8862, {1, 3, 1, 11, 17, 55, 23, 109, 57, 669, 663, 1105, 4005, 2915, 16989, 10631, 112395}},
    {6759, 17, 8871, {1, 1, 7, 13, 21, 27, 89, 251, 429, 311, 1395, 3045, 2701, 10687, 14891, 16131, 86155}},
    {6760, 17, 8875, {1, 1, 1, 13, 19, 1, 101, 153, 23, 919, 1535, 3565, 7847, 8369, 25553, 35709, 11733}},
    {6761, 17, 8890, {1, 3, 5, 5, 11, 41, 65, 21, 191, 285, 45, 3593, 6531, 1227, 30829, 41845, 60523}},
    {6762, 17, 8892, {1, 3, 3, 15, 19, 23, 5, 21, 255, 273, 1543, 3229, 6329, 6177, 27619, 29089, 25505}},
    {6763, 17, 8898, {1, 3, 1, 3, 9, 51, 17, 145, 117, 597, 185, 2609, 551, 14243, 32645, 26851, 39473}},
    {6764, 17, 8927, {1, 1, 1, 1, 15, 19, 105, 125, 317, 713, 825, 315, 5955, 691, 3213, 6465, 130373}},
    {6765, 17, 8928, {1, 3, 3, 5, 25, 51, 65, 79, 495, 847, 1071, 207, 5715, 11893, 19947, 50631, 113949}},
    {6766, 17, 8945, {1, 3, 1, 5, 11, 29, 115, 205, 117, 593, 1271, 1369, 4759, 4469, 581, 52911, 126097}},
    {6767, 17, 8952, {1, 3, 1, 3, 31, 5, 7, 37, 499, 793, 1069, 3923, 6819, 6301, 16597, 29621, 61803}},
    {6768, 17, 8955, {1, 1, 7, 9, 9, 51, 61, 17, 119, 181, 1439, 1801, 4135, 12915, 21969, 551, 91397}},
    {6769, 17, 8965, {1, 1, 7, 13, 19, 17, 39, 221, 291, 111, 1459, 1961, 3065, 14893, 29559, 6419, 58621}},
    {6770, 17, 8972, {1, 1, 3, 3, 9, 61, 65, 135, 145, 295, 1825, 2233, 2853, 837, 24929, 28401, 91427}},
    {6771, 17, 8977, {1, 3, 7, 13, 21, 53, 117, 251, 233, 525, 599, 2393, 683, 4279, 1815, 27921, 88923}},
    {6772, 17, 8990, {1, 3, 1, 7, 5, 57, 73, 131, 317, 523, 359, 113, 873, 10737, 18213, 4249, 109745}},
    {6773, 17, 8996, {1, 3, 5, 11, 21, 23, 67, 179, 257, 525, 181, 2181, 5547, 15719, 303, 28783, 65563}},
    {6774, 17, 9025, {1, 3, 1, 1, 5, 51, 1, 75, 169, 735, 1733, 1863, 7897, 11885, 23555, 33159, 76323}},
    {6775, 17, 9037, {1, 3, 1, 1, 19, 37, 121, 67, 71, 407, 793, 3977, 2169, 3987, 17917, 8111, 64869}},
    {6776, 17, 9040, {1, 3, 1, 1, 13, 9, 89, 221, 205, 669, 535, 3235, 2441, 10011, 16847, 50279, 16343}},
    {6777, 17, 9049, {1, 3, 5, 5, 3, 17, 113, 191, 407, 65, 1923, 375, 6347, 9917, 22261, 40417, 111889}},
    {6778, 17, 9062, {1, 3, 7, 11, 13, 45, 43, 233, 157, 137, 999, 2775, 2761, 13441, 22249, 18561, 59223}},
    {6779, 17, 9068, {1, 1, 5, 9, 11, 43, 85, 171, 505, 1013, 305, 3407, 3145, 1399, 12107, 59399, 2447}},
    {6780, 17, 9076, {1, 1, 3, 9, 27, 23, 127, 33, 375, 211, 1279, 2223, 1615, 9495, 12117, 39157, 79429}},
    {6781, 17, 9079, {1, 3, 7, 15, 29, 49, 83, 211, 415, 349, 457, 1623, 2801, 6525, 5593, 44437, 66765}},
    {6782, 17, 9099, {1, 1, 1, 7, 3, 37, 5, 171, 167, 569, 2021, 4085, 7245, 8007, 29253, 33677, 89793}},
    {6783, 17, 9107, {1, 1, 5, 15, 13, 3, 23, 59, 7, 135, 695, 1443, 2747, 14547, 24239, 44903, 108191}},
    {6784, 17, 9114, {1, 3, 5, 7, 7, 21, 5, 149, 85, 91, 1939, 1123, 3349, 12857, 9703, 44435, 31017}},
    {6785, 17, 9123, {1, 3, 7, 11, 25, 53, 51, 61, 489, 155, 935, 3669, 2107, 14613, 6685, 59099, 77553}},
    {6786, 17, 9126, {1, 3, 3, 3, 27, 41, 83, 141, 445, 359, 1269, 3209, 7881, 2491, 31405, 56157, 90835}},
    {6787, 17, 9137, {1, 1, 3, 5, 13, 59, 15, 9, 65, 123, 447, 1377, 4697, 13567, 6061, 61659, 9287}},
    {6788, 17, 9149, {1, 1, 1, 15, 11, 17, 55, 223, 335, 557, 533, 3383, 7231, 4579, 3627, 62911, 56387}},
    {6789, 17, 9150, {1, 3, 1, 7, 13, 61, 39, 41, 139, 1009, 463, 1247, 5623, 8799, 3325, 27715, 110369}},
    {6790, 17, 9155, {1, 3, 1, 7, 29, 51, 113, 39, 61, 827, 1655, 3255, 7593, 1715, 21463, 57171, 113667}},
    {6791, 17, 9161, {1, 1, 7, 3, 27, 1, 99, 183, 279, 247, 719, 1497, 1073, 2417, 16837, 8509, 30727}},
    {6792, 17, 9162, {1, 1, 3, 1, 11, 25, 95, 241, 35, 835, 1511, 3451, 6521, 13913, 30977, 36121, 109887}},
    {6793, 17, 9167, {1, 3, 3, 9, 5, 31, 3, 23, 315, 517, 131, 2539, 4309, 16319, 10523, 29993, 101985}},
    {6794, 17, 9172, {1, 3, 7, 7, 31, 23, 73, 241, 209, 459, 1309, 1081, 2213, 9275, 27917, 30693, 111147}},
    {6795, 17, 9186, {1, 1, 5, 13, 11, 37, 3, 151, 385, 769, 1917, 2007, 5123, 9433, 15381, 47463, 121205}},
    {6796, 17, 9188, {1, 3, 1, 5, 1, 41, 79, 185, 347, 737, 487, 3955, 7799, 11531, 12505, 30395, 86959}},
    {6797, 17, 9191, {1, 1, 3, 5, 7, 13, 21, 89, 449, 101, 1031, 2983, 1139, 10663, 1355, 61757, 4111}},
    {6798, 17, 9198, {1, 1, 1, 3, 27, 11, 73, 91, 117, 211, 1381, 2569, 3129, 7221, 3287, 62115, 40991}},
    {6799, 17, 9200, {1, 1, 3, 9, 27, 39, 87, 153, 347, 645, 1485, 3783, 2303, 12047, 18457, 47789, 105631}},
    {6800, 17, 9205, {1, 3, 1, 9, 31, 27, 11, 99, 61, 509, 1565, 2993, 7191, 9331, 12569, 61145, 15385}},
    {6801, 17, 9206, {1, 1, 1, 9, 15, 7, 61, 25, 389, 565, 979, 2025, 4523, 8079, 14935, 46203, 36649}},
    {6802, 17, 9215, {1, 3, 5, 13, 19, 37, 73, 165, 327, 421, 1017, 1673, 2517, 5199, 1849, 33247, 57287}},
    {6803, 17, 9227, {1, 1, 5, 9, 17, 33, 121, 91, 81, 409, 1651, 2901, 2453, 16147, 23153, 6193, 93877}},
    {6804, 17, 9232, {1, 1, 3, 7, 7, 37, 107, 205, 479, 301, 1579, 1091, 1079, 6635, 24449, 28345, 88387}},
    {6805, 17, 9241, {1, 3, 5, 11, 5, 47, 41, 193, 157, 335, 1179, 1569, 2641, 10239, 16811, 60129, 58669}},
    {6806, 17, 9244, {1, 1, 1, 11, 11, 39, 91, 79, 183, 945, 1507, 3005, 3277, 5195, 1255, 34447, 118693}},
    {6807, 17, 9251, {1, 3, 1, 9, 9, 11, 117, 71, 115, 827, 1205, 2247, 3217, 14317, 29221, 20289, 128195}},
    {6808, 17, 9254, {1, 3, 3, 9, 29, 17, 105, 87, 245, 951, 59, 2993, 179, 715, 27399, 9793, 10127}},
    {6809, 17, 9275, {1, 1, 3, 15, 31, 1, 95, 51, 465, 43, 1709, 519, 4635, 1239, 25023, 22187, 73873}},
    {6810, 17, 9283, {1, 1, 5, 11, 29, 43, 45, 17, 171, 193, 1005, 2151, 5561, 1143, 14601, 43271, 73143}},
    {6811, 17, 9285, {1, 3, 5, 11, 21, 63, 113, 143, 95, 991, 765, 2549, 995, 4069, 16333, 54495, 19}},
    {6812, 17, 9303, {1, 1, 5, 13, 23, 55, 61, 135, 253, 413, 1083, 1739, 4249, 835, 3097, 16797, 19917}},
    {6813, 17, 9304, {1, 3, 1, 1, 29, 23, 41, 53, 189, 403, 735, 3017, 3295, 5365, 11477, 177, 129477}},
    {6814, 17, 9313, {1, 1, 1, 3, 19, 57, 93, 5, 489, 589, 1685, 2117, 235, 15337, 11855, 44749, 30761}},
    {6815, 17, 9314, {1, 1, 3, 15, 21, 15, 81, 187, 163, 661, 147, 3125, 189, 8065, 22167, 33831, 51923}},
    {6816, 17, 9320, {1, 1, 1, 15, 17, 43, 3, 61, 335, 677, 1437, 2673, 4117, 13719, 22833, 31955, 81407}},
    {6817, 17, 9328, {1, 3, 5, 15, 11, 33, 25, 25, 127, 1009, 1721, 119, 2433, 4393, 4999, 11433, 59191}},
    {6818, 17, 9333, {1, 3, 5, 9, 27, 55, 111, 245, 255, 801, 407, 3645, 2961, 5239, 6443, 33505, 99189}},
    {6819, 17, 9337, {1, 1, 1, 1, 1, 35, 33, 87, 435, 973, 1199, 2375, 4429, 5965, 685, 27995, 62811}},
    {6820, 17, 9338, {1, 1, 1, 11, 23, 5, 95, 119, 465, 7, 21, 379, 1361, 12261, 8063, 25185, 8075}},
    {6821, 17, 9340, {1, 1, 7, 9, 13, 33, 1, 189, 199, 229, 911, 1625, 3823, 12169, 12227, 26263, 130845}},
    {6822, 17, 9353, {1, 1, 7, 9, 11, 39, 81, 97, 165, 729, 671, 779, 4669, 8299, 23223, 37397, 124591}},
    {6823, 17, 9356, {1, 3, 5, 5, 21, 31, 21, 215, 101, 91, 1681, 617, 1213, 6571, 26135, 14217, 102163}},
    {6824, 17, 9364, {1, 3, 7, 3, 29, 31, 99, 19, 419, 1023, 1187, 1999, 85, 2735, 7395, 21007, 65373}},
    {6825, 17, 9373, {1, 3, 1, 3, 15, 23, 85, 123, 47, 493, 653, 2425, 5543, 14547, 5973, 48569, 35457}},
    {6826, 17, 9374, {1, 3, 5, 1, 13, 51, 91, 63, 83, 939, 369, 3565, 3123, 2819, 22603, 63447, 100975}},
    {6827, 17, 9378, {1, 1, 5, 15, 23, 9, 79, 95, 111, 469, 1575, 373, 6009, 12303, 14283, 34367, 83405}},
    {6828, 17, 9380, {1, 1, 5, 13, 23, 27, 13, 37, 345, 117, 1505, 2545, 6567, 4223, 21523, 16429, 114115}},
    {6829, 17, 9389, {1, 3, 7, 1, 25, 17, 27, 143, 195, 619, 819, 525, 4741, 14875, 10885, 4779, 29975}},
    {6830, 17, 9395, {1, 1, 5, 5, 7, 53, 101, 35, 391, 943, 1189, 2877, 4981, 10351, 27643, 12525, 83175}},
    {6831, 17, 9412, {1, 3, 5, 3, 27, 41, 41, 143, 171, 33, 445, 2583, 2357, 417, 10217, 63363, 185}},
    {6832, 17, 9422, {1, 1, 7, 3, 13, 3, 87, 169, 131, 785, 219, 3929, 5385, 14529, 27693, 7223, 61845}},
    {6833, 17, 9439, {1, 1, 7, 1, 17, 25, 83, 213, 55, 121, 1439, 705, 3037, 10099, 8573, 4249, 77623}},
    {6834, 17, 9450, {1, 3, 1, 9, 31, 49, 49, 217, 77, 789, 1173, 105, 2973, 6697, 18699, 63331, 29703}},
    {6835, 17, 9452, {1, 1, 3, 9, 31, 17, 21, 197, 193, 435, 1547, 515, 3337, 10945, 21983, 32529, 73963}},
    {6836, 17, 9482, {1, 3, 7, 3, 23, 3, 127, 139, 493, 527, 1709, 3439, 6431, 3103, 22815, 29807, 87863}},
    {6837, 17, 9487, {1, 3, 7, 9, 27, 3, 113, 195, 427, 243, 477, 3299, 6819, 1491, 28317, 41595, 2315}},
    {6838, 17, 9489, {1, 1, 7, 11, 23, 19, 59, 101, 417, 751, 783, 1965, 3943, 11805, 22739, 15899, 78737}},
    {6839, 17, 9499, {1, 3, 7, 11, 1, 47, 57, 179, 227, 7, 1979, 899, 2483, 3365, 7435, 53273, 83521}},
    {6840, 17, 9501, {1, 3, 5, 15, 9, 3, 35, 101, 331, 201, 1047, 931, 5761, 7225, 2007, 55557, 60033}},
    {6841, 17, 9508, {1, 1, 3, 11, 9, 61, 57, 135, 495, 807, 1037, 2091, 7679, 3019, 30775, 61801, 76461}},
    {6842, 17, 9515, {1, 1, 3, 5, 25, 49, 123, 175, 249, 677, 1815, 2727, 6539, 6483, 23385, 27281, 99461}},
    {6843, 17, 9518, {1, 1, 3, 7, 15, 61, 39, 149, 353, 211, 1497, 3049, 4435, 3187, 28863, 34743, 119957}},
    {6844, 17, 9520, {1, 3, 5, 13, 13, 33, 81, 67, 219, 905, 1207, 3073, 1813, 5387, 12369, 24309, 49651}},
    {6845, 17, 9526, {1, 1, 1, 15, 3, 37, 127, 35, 429, 49, 945, 2251, 2305, 8329, 14681, 41711, 68877}},
    {6846, 17, 9537, {1, 3, 3, 13, 7, 17, 31, 65, 25, 141, 1949, 2523, 6425, 12283, 2541, 60415, 44641}},
    {6847, 17, 9552, {1, 1, 3, 11, 31, 25, 77, 81, 333, 343, 1367, 1355, 3929, 14997, 11977, 19857, 15891}},
    {6848, 17, 9571, {1, 1, 7, 7, 23, 63, 99, 57, 259, 523, 1431, 1479, 6751, 12541, 31129, 14525, 103255}},
    {6849, 17, 9588, {1, 3, 1, 13, 11, 45, 51, 249, 283, 515, 31, 3181, 4385, 9575, 1813, 8081, 9527}},
    {6850, 17, 9613, {1, 3, 3, 1, 1, 3, 87, 77, 361, 529, 621, 763, 6949, 15701, 8631, 56821, 53161}},
    {6851, 17, 9619, {1, 3, 7, 5, 15, 35, 91, 27, 485, 937, 1519, 219, 2421, 9979, 27325, 29711, 19089}},
    {6852, 17, 9622, {1, 1, 5, 11, 29, 21, 39, 141, 173, 265, 609, 1493, 7973, 16377, 24523, 38711, 79675}},
    {6853, 17, 9637, {1, 3, 7, 1, 9, 37, 101, 145, 159, 695, 1455, 2695, 3611, 3183, 27229, 51759, 39341}},
    {6854, 17, 9652, {1, 3, 3, 3, 25, 3, 125, 87, 265, 687, 1841, 2663, 7563, 3981, 237, 17811, 110109}},
    {6855, 17, 9655, {1, 3, 7, 7, 9, 33, 125, 151, 465, 447, 781, 893, 1141, 14297, 4565, 8941, 50849}},
    {6856, 17, 9661, {1, 3, 3, 15, 29, 59, 117, 163, 203, 51, 1609, 2999, 593, 14973, 1157, 38037, 51759}},
    {6857, 17, 9664, {1, 3, 7, 11, 7, 35, 107, 9, 149, 117, 919, 3455, 33, 9129, 14463, 39405, 21569}},
    {6858, 17, 9669, {1, 1, 1, 11, 9, 9, 97, 81, 379, 371, 207, 1487, 3669, 6005, 13939, 12281, 47873}},
    {6859, 17, 9681, {1, 1, 7, 3, 21, 43, 17, 211, 113, 73, 469, 2663, 2527, 2945, 28917, 56037, 109237}},
    {6860, 17, 9682, {1, 3, 7, 15, 1, 17, 69, 33, 211, 937, 1625, 327, 2699, 11355, 14949, 65005, 77787}},
    {6861, 17, 9688, {1, 3, 7, 9, 11, 11, 65, 59, 395, 687, 1237, 17, 3233, 1567, 31213, 34805, 33949}},
    {6862, 17, 9697, {1, 3, 7, 3, 7, 11, 113, 61, 427, 219, 1007, 285, 973, 15275, 13531, 48529, 26519}},
    {6863, 17, 9700, {1, 1, 7, 5, 31, 21, 125, 193, 113, 693, 1115, 3205, 7067, 2087, 27805, 27957, 101803}},
    {6864, 17, 9715, {1, 3, 7, 13, 19, 55, 29, 41, 403, 827, 533, 1565, 3655, 4765, 23207, 28621, 25415}},
    {6865, 17, 9722, {1, 3, 3, 5, 9, 19, 95, 99, 243, 767, 1731, 1181, 7115, 2929, 20017, 3637, 40319}},
    {6866, 17, 9727, {1, 1, 3, 5, 31, 55, 13, 115, 441, 199, 1547, 1171, 4011, 8789, 4633, 14747, 131025}},
    {6867, 17, 9734, {1, 3, 5, 3, 13, 43, 23, 113, 475, 679, 139, 2941, 7215, 13049, 28093, 47213, 66983}},
    {6868, 17, 9740, {1, 3, 1, 9, 19, 45, 117, 105, 75, 189, 769, 649, 1041, 9387, 9641, 32265, 99235}},
    {6869, 17, 9743, {1, 3, 3, 7, 13, 41, 3, 15, 163, 919, 1701, 3733, 2607, 1635, 1573, 43811, 78399}},
    {6870, 17, 9745, {1, 3, 1, 7, 7, 35, 33, 189, 103, 37, 1397, 2293, 3679, 13439, 1537, 21311, 10533}},
    {6871, 17, 9757, {1, 3, 3, 1, 31, 21, 7, 115, 51, 385, 899, 3639, 3147, 7869, 3331, 5993, 48677}},
    {6872, 17, 9761, {1, 1, 1, 1, 29, 53, 103, 1, 29, 449, 1641, 1851, 3925, 12983, 11483, 56437, 129277}},
    {6873, 17, 9762, {1, 3, 7, 9, 23, 49, 95, 125, 103, 261, 1151, 667, 2613, 10879, 10387, 23747, 107887}},
    {6874, 17, 9767, {1, 1, 5, 11, 5, 5, 9, 201, 257, 67, 661, 991, 1577, 8101, 19127, 64797, 82323}},
    {6875, 17, 9768, {1, 3, 1, 3, 5, 21, 61, 251, 459, 293, 399, 2065, 7919, 2923, 4623, 54929, 42177}},
    {6876, 17, 9774, {1, 3, 1, 15, 31, 55, 39, 125, 439, 199, 63, 1323, 271, 2749, 6753, 9221, 87949}},
    {6877, 17, 9786, {1, 3, 1, 3, 23, 1, 27, 179, 123, 835, 257, 999, 1635, 8425, 32191, 49077, 14725}},
    {6878, 17, 9796, {1, 1, 1, 15, 27, 15, 47, 29, 319, 539, 1069, 2855, 211, 7385, 18941, 51385, 44633}},
    {6879, 17, 9820, {1, 3, 5, 15, 3, 39, 89, 187, 79, 747, 111, 1515, 7533, 12865, 23869, 14271, 38737}},
    {6880, 17, 9823, {1, 1, 7, 13, 11, 47, 47, 201, 391, 779, 687, 3659, 4163, 9527, 9917, 635, 86699}},
    {6881, 17, 9839, {1, 1, 3, 1, 31, 21, 47, 109, 35, 693, 1619, 3959, 1605, 14091, 25231, 21171, 24261}},
    {6882, 17, 9844, {1, 1, 3, 13, 3, 31, 9, 97, 445, 189, 1509, 777, 2753, 7523, 1385, 28981, 117527}},
    {6883, 17, 9851, {1, 3, 7, 9, 19, 11, 125, 199, 121, 949, 151, 2855, 1495, 10367, 11673, 48121, 116489}},
    {6884, 17, 9853, {1, 1, 7, 9, 21, 35, 95, 171, 55, 233, 1883, 3327, 4733, 733, 31713, 43757, 25083}},
    {6885, 17, 9863, {1, 1, 7, 7, 5, 61, 67, 135, 13, 719, 929, 341, 6647, 9037, 1181, 29229, 2233}},
    {6886, 17, 9864, {1, 3, 1, 1, 27, 29, 125, 215, 231, 897, 1185, 1007, 2941, 3857, 7683, 34509, 18083}},
    {6887, 17, 9877, {1, 3, 1, 9, 1, 27, 5, 117, 163, 399, 1211, 1325, 1697, 11901, 20587, 38615, 42895}},
    {6888, 17, 9884, {1, 3, 1, 7, 23, 41, 55, 167, 17, 957, 915, 991, 2423, 10655, 6357, 38007, 17025}},
    {6889, 17, 9888, {1, 1, 7, 1, 19, 5, 119, 149, 57, 509, 135, 2755, 8145, 9901, 15491, 23183, 127227}},
    {6890, 17, 9897, {1, 3, 5, 3, 19, 17, 73, 121, 207, 903, 1709, 3541, 1371, 9957, 16539, 38877, 13153}},
    {6891, 17, 9915, {1, 3, 3, 9, 23, 1, 123, 221, 353, 65, 613, 1829, 8153, 5999, 22669, 47491, 94249}},
    {6892, 17, 9925, {1, 3, 7, 3, 23, 17, 57, 17, 113, 215, 893, 3881, 275, 10971, 1953, 61835, 104451}},
    {6893, 17, 9949, {1, 1, 5, 5, 1, 3, 83, 183, 157, 625, 383, 2421, 249, 5137, 8189, 41345, 85205}},
    {6894, 17, 9954, {1, 1, 3, 7, 3, 49, 27, 35, 487, 87, 1539, 3611, 8011, 7255, 14523, 19281, 19997}},
    {6895, 17, 9960, {1, 3, 5, 3, 11, 9, 99, 133, 419, 17, 1407, 1485, 7409, 14301, 7101, 11917, 66377}},
    {6896, 17, 9965, {1, 1, 7, 1, 11, 47, 35, 227, 345, 419, 155, 4003, 6431, 10105, 26133, 47123, 102915}},
    {6897, 17, 9978, {1, 3, 7, 3, 9, 55, 23, 221, 139, 769, 1243, 2387, 4101, 3489, 28401, 43311, 94957}},
    {6898, 17, 9986, {1, 1, 5, 3, 3, 43, 75, 161, 105, 139, 961, 3281, 3089, 16103, 6881, 32411, 30567}},
    {6899, 17, 9992, {1, 3, 7, 3, 31, 63, 29, 149, 221, 201, 1523, 1023, 1095, 12327, 14821, 64917, 66265}},
    {6900, 17, 9995, {1, 3, 3, 11, 11, 9, 81, 111, 183, 193, 1163, 1187, 3043, 2261, 16901, 60085, 1847}},
    {6901, 17, 10005, {1, 1, 3, 3, 3, 43, 21, 169, 357, 23, 1489, 3367, 7645, 2787, 2955, 19893, 120473}},
    {6902, 17, 10026, {1, 1, 1, 9, 27, 55, 127, 235, 59, 151, 1301, 4019, 6387, 3111, 14913, 50485, 47603}},
    {6903, 17, 10031, {1, 1, 3, 5, 13, 53, 77, 51, 139, 141, 1603, 1349, 6067, 14173, 1027, 18937, 26307}},
    {6904, 17, 10040, {1, 1, 5, 7, 7, 51, 59, 167, 11, 653, 1935, 3851, 1871, 951, 5003, 31763, 53835}},
    {6905, 17, 10051, {1, 1, 7, 5, 7, 33, 27, 57, 321, 57, 239, 3007, 7923, 8903, 85, 32931, 21845}},
    {6906, 17, 10057, {1, 3, 5, 9, 27, 41, 67, 91, 173, 709, 1609, 1911, 1473, 15515, 19105, 57737, 18277}},
    {6907, 17, 10072, {1, 3, 3, 15, 15, 57, 35, 149, 421, 851, 461, 3425, 7609, 7609, 9323, 47745, 86521}},
    {6908, 17, 10096, {1, 3, 7, 9, 11, 3, 87, 69, 45, 91, 1899, 2743, 2281, 12819, 31271, 25991, 17149}},
    {6909, 17, 10102, {1, 3, 7, 7, 9, 17, 85, 77, 365, 383, 1263, 199, 381, 3155, 31677, 32093, 52405}},
    {6910, 17, 10105, {1, 3, 7, 9, 9, 21, 11, 33, 37, 967, 249, 3171, 6777, 7483, 15371, 31943, 76073}},
    {6911, 17, 10115, {1, 3, 5, 7, 15, 11, 49, 229, 101, 869, 123, 493, 8069, 1047, 7385, 5123, 28255}},
    {6912, 17, 10124, {1, 3, 3, 1, 27, 11, 43, 121, 177, 207, 977, 1379, 1177, 147, 28487, 5915, 71785}},
    {6913, 17, 10139, {1, 3, 1, 11, 25, 61, 29, 105, 467, 417, 1513, 2591, 1339, 5957, 27277, 42089, 28115}},
    {6914, 17, 10145, {1, 3, 5, 15, 15, 53, 63, 29, 259, 577, 1549, 197, 809, 817, 9071, 33985, 26941}},
    {6915, 17, 10148, {1, 1, 3, 5, 21, 21, 41, 101, 59, 869, 869, 3865, 1543, 4803, 22995, 29679, 66549}},
    {6916, 17, 10157, {1, 1, 7, 5, 5, 29, 99, 251, 145, 435, 1965, 2623, 343, 11743, 6543, 44387, 119801}},
    {6917, 17, 10158, {1, 1, 3, 3, 7, 25, 7, 25, 387, 935, 1141, 1393, 7363, 3879, 11933, 10633, 59153}},
    {6918, 17, 10163, {1, 1, 3, 3, 11, 41, 121, 59, 203, 983, 49, 549, 6749, 641, 25473, 53093, 37555}},
    {6919, 17, 10180, {1, 3, 1, 15, 3, 17, 71, 95, 135, 95, 1991, 741, 1107, 5363, 12609, 15031, 89077}},
    {6920, 17, 10187, {1, 3, 7, 1, 17, 27, 39, 127, 95, 361, 191, 2195, 2879, 10489, 21617, 43275, 49689}},
    {6921, 17, 10198, {1, 3, 7, 7, 9, 59, 45, 157, 275, 281, 531, 1673, 5675, 7303, 12301, 42577, 40735}},
    {6922, 17, 10208, {1, 3, 5, 9, 29, 45, 81, 69, 315, 181, 1125, 1739, 3541, 13701, 27373, 51241, 50471}},
    {6923, 17, 10214, {1, 3, 1, 9, 7, 9, 83, 61, 289, 341, 305, 2271, 7001, 111, 29513, 61879, 57101}},
    {6924, 17, 10220, {1, 3, 1, 11, 21, 17, 61, 123, 439, 867, 385, 1171, 2555, 1671, 18039, 9859, 106389}},
    {6925, 17, 10237, {1, 1, 7, 13, 25, 55, 127, 161, 307, 15, 477, 2755, 1797, 12873, 5789, 3509, 8649}},
    {6926, 17, 10238, {1, 1, 1, 11, 19, 13, 91, 121, 305, 331, 1183, 3829, 6643, 6005, 757, 33745, 31389}},
    {6927, 17, 10241, {1, 1, 1, 11, 29, 31, 105, 255, 433, 341, 2025, 3239, 4931, 14617, 6019, 52997, 91469}},
    {6928, 17, 10244, {1, 1, 7, 7, 19, 63, 119, 243, 75, 449, 751, 1673, 7059, 4167, 26041, 26469, 89661}},
    {6929, 17, 10251, {1, 3, 1, 5, 23, 57, 97, 169, 429, 883, 789, 2823, 4207, 7545, 12633, 22851, 62119}},
    {6930, 17, 10253, {1, 3, 1, 11, 29, 9, 69, 105, 7, 459, 1271, 823, 2789, 13927, 8747, 9045, 76151}},
    {6931, 17, 10256, {1, 3, 5, 9, 23, 57, 97, 143, 401, 895, 959, 2811, 925, 14749, 24875, 2809, 123591}},
    {6932, 17, 10259, {1, 1, 3, 9, 19, 21, 125, 109, 511, 531, 1117, 3385, 3747, 15225, 20685, 34111, 15945}},
    {6933, 17, 10266, {1, 1, 5, 7, 29, 53, 123, 59, 345, 471, 479, 1883, 5129, 2369, 8963, 33701, 96177}},
    {6934, 17, 10284, {1, 1, 5, 5, 19, 43, 11, 171, 497, 925, 1939, 2655, 487, 10675, 699, 59753, 17391}},
    {6935, 17, 10290, {1, 1, 5, 7, 19, 5, 113, 91, 61, 431, 289, 1477, 2345, 11307, 11505, 59761, 105185}},
    {6936, 17, 10331, {1, 3, 1, 3, 29, 31, 83, 53, 191, 461, 1671, 2155, 1709, 2495, 10991, 61789, 35067}},
    {6937, 17, 10334, {1, 1, 3, 13, 21, 7, 103, 219, 283, 235, 193, 723, 3909, 15239, 28373, 5961, 59495}},
    {6938, 17, 10350, {1, 1, 7, 9, 9, 11, 77, 227, 187, 465, 229, 3475, 6001, 14195, 14723, 5111, 70817}},
    {6939, 17, 10355, {1, 1, 5, 5, 31, 51, 91, 27, 265, 861, 1443, 467, 3653, 7441, 11407, 39705, 78605}},
    {6940, 17, 10357, {1, 1, 7, 13, 11, 15, 5, 255, 159, 335, 857, 1587, 5545, 13027, 24309, 10711, 89843}},
    {6941, 17, 10367, {1, 3, 7, 15, 17, 15, 1, 189, 13, 531, 1571, 2457, 1253, 13955, 18113, 60799, 40147}},
    {6942, 17, 10368, {1, 1, 7, 11, 9, 57, 7, 175, 285, 399, 1633, 2255, 809, 6637, 15621, 34309, 87597}},
    {6943, 17, 10377, {1, 3, 7, 9, 31, 59, 79, 35, 427, 933, 527, 2505, 3515, 14987, 29541, 64581, 34585}},
    {6944, 17, 10388, {1, 1, 5, 1, 31, 7, 49, 31, 129, 19, 511, 1775, 7823, 12843, 19825, 1455, 73627}},
    {6945, 17, 10407, {1, 1, 1, 5, 23, 7, 77, 183, 401, 139, 255, 231, 5397, 6949, 12075, 2365, 78203}},
    {6946, 17, 10421, {1, 1, 3, 13, 5, 31, 55, 79, 291, 77, 1179, 1165, 2775, 1391, 9933, 26041, 95909}},
    {6947, 17, 10434, {1, 3, 5, 11, 7, 15, 59, 9, 365, 571, 1455, 3995, 2091, 6425, 12891, 53849, 3235}},
    {6948, 17, 10439, {1, 1, 5, 9, 11, 3, 33, 243, 247, 267, 245, 899, 3765, 15047, 7449, 10595, 111259}},
    {6949, 17, 10440, {1, 3, 5, 15, 9, 45, 25, 27, 409, 993, 13, 3475, 7043, 1169, 8533, 53117, 1307}},
    {6950, 17, 10443, {1, 1, 1, 1, 25, 1, 45, 113, 421, 913, 1275, 3773, 1365, 2393, 27373, 33769, 101439}},
    {6951, 17, 10446, {1, 3, 3, 7, 31, 1, 79, 109, 245, 653, 871, 3369, 2061, 6505, 7369, 9929, 85659}},
    {6952, 17, 10457, {1, 3, 1, 13, 23, 9, 19, 77, 113, 19, 1421, 3087, 8121, 12479, 18957, 46549, 56737}},
    {6953, 17, 10469, {1, 3, 5, 1, 23, 57, 105, 27, 143, 359, 1915, 3185, 5379, 12267, 3781, 28473, 19123}},
    {6954, 17, 10476, {1, 1, 3, 7, 29, 37, 7, 3, 429, 651, 1329, 3739, 5049, 10999, 18407, 6573, 125903}},
    {6955, 17, 10479, {1, 1, 7, 1, 9, 27, 25, 241, 351, 101, 591, 1489, 4925, 3379, 12359, 7197, 45257}},
    {6956, 17, 10481, {1, 1, 3, 3, 5, 55, 77, 25, 479, 415, 629, 287, 1483, 10325, 15157, 42825, 5295}},
    {6957, 17, 10494, {1, 3, 7, 1, 27, 25, 3, 227, 395, 463, 1885, 869, 3095, 6323, 6553, 20901, 92889}},
    {6958, 17, 10501, {1, 1, 5, 9, 3, 35, 27, 161, 423, 465, 1045, 517, 6951, 1669, 10483, 25321, 95391}},
    {6959, 17, 10505, {1, 1, 1, 9, 29, 43, 57, 9, 35, 969, 355, 3955, 1307, 15015, 9763, 52759, 68643}},
    {6960, 17, 10516, {1, 1, 3, 3, 9, 31, 113, 217, 53, 623, 965, 1609, 1773, 1743, 22767, 51975, 19051}},
    {6961, 17, 10532, {1, 3, 7, 11, 23, 19, 115, 253, 503, 755, 1139, 845, 2947, 3271, 7277, 21297, 91015}},
    {6962, 17, 10541, {1, 1, 5, 15, 17, 57, 113, 115, 439, 87, 493, 737, 4399, 839, 6691, 22063, 74279}},
    {6963, 17, 10547, {1, 1, 3, 3, 9, 37, 97, 129, 43, 383, 1717, 3629, 3235, 2895, 24589, 5045, 36433}},
    {6964, 17, 10550, {1, 1, 5, 1, 29, 59, 35, 17, 301, 301, 1559, 429, 1969, 9655, 2107, 53035, 10139}},
    {6965, 17, 10591, {1, 3, 5, 5, 13, 19, 63, 195, 419, 43, 861, 1089, 2399, 8349, 3425, 37887, 63945}},
    {6966, 17, 10597, {1, 3, 7, 11, 1, 59, 73, 57, 225, 141, 269, 855, 8147, 14733, 607, 40125, 33513}},
    {6967, 17, 10602, {1, 1, 7, 9, 11, 17, 97, 97, 425, 767, 1203, 131, 5519, 11979, 13731, 28949, 61463}},
    {6968, 17, 10610, {1, 3, 5, 3, 11, 23, 105, 207, 259, 17, 131, 2449, 6699, 1981, 17539, 32399, 16621}},
    {6969, 17, 10619, {1, 3, 7, 7, 11, 35, 69, 215, 119, 715, 1975, 3945, 2025, 12067, 23627, 59613, 98851}},
    {6970, 17, 10631, {1, 1, 1, 1, 9, 55, 73, 89, 301, 561, 1593, 1025, 7403, 5619, 861, 47061, 87931}},
    {6971, 17, 10646, {1, 1, 3, 11, 19, 43, 25, 111, 167, 531, 1303, 4053, 6743, 821, 28805, 4863, 48175}},
    {6972, 17, 10655, {1, 1, 7, 13, 3, 3, 23, 21, 17, 265, 1039, 817, 2657, 15021, 31799, 40387, 82217}},
    {6973, 17, 10665, {1, 1, 5, 13, 19, 31, 109, 151, 31, 47, 1001, 1875, 3067, 10753, 22221, 5559, 115801}},
    {6974, 17, 10673, {1, 3, 7, 1, 29, 35, 81, 77, 507, 303, 815, 3815, 707, 15903, 13783, 49427, 116953}},
    {6975, 17, 10674, {1, 1, 5, 11, 25, 59, 45, 237, 301, 35, 705, 1505, 5311, 1805, 14491, 20205, 46971}},
    {6976, 17, 10680, {1, 1, 5, 11, 21, 45, 1, 19, 399, 703, 363, 2759, 1493, 1407, 211, 11477, 10321}},
    {6977, 17, 10693, {1, 3, 1, 1, 13, 9, 89, 221, 205, 669, 535, 3235, 2441, 10011, 16847, 50279, 16343}},
    {6978, 17, 10700, {1, 1, 1, 11, 3, 47, 13, 75, 19, 583, 1873, 2877, 6203, 4987, 6775, 50805, 50097}},
    {6979, 17, 10721, {1, 3, 5, 5, 19, 7, 107, 169, 15, 769, 1853, 1, 7519, 15481, 22799, 12601, 67557}},
    {6980, 17, 10727, {1, 1, 5, 1, 21, 27, 27, 191, 121, 199, 1231, 1641, 7993, 4609, 11211, 17559, 33905}},
    {6981, 17, 10746, {1, 1, 7, 5, 29, 7, 97, 59, 235, 51, 825, 99, 6159, 3883, 7645, 27323, 25195}},
    {6982, 17, 10748, {1, 1, 1, 1, 19, 43, 123, 177, 401, 45, 183, 2489, 5889, 4219, 4793, 58625, 17195}},
    {6983, 17, 10757, {1, 3, 7, 9, 27, 61, 87, 25, 309, 297, 1267, 3689, 5877, 14407, 17259, 5749, 99507}},
    {6984, 17, 10761, {1, 1, 5, 11, 25, 23, 111, 7, 369, 557, 887, 2077, 5869, 1949, 31247, 47389, 52671}},
    {6985, 17, 10770, {1, 1, 3, 7, 23, 9, 69, 137, 403, 457, 1897, 2033, 3927, 6719, 19931, 13807, 96709}},
    {6986, 17, 10776, {1, 1, 3, 7, 13, 63, 75, 109, 215, 825, 905, 709, 4285, 251, 32071, 19965, 76873}},
    {6987, 17, 10782, {1, 1, 1, 5, 9, 1, 87, 163, 127, 87, 823, 87, 1115, 15739, 7643, 12797, 56495}},
    {6988, 17, 10791, {1, 1, 3, 3, 23, 39, 113, 189, 257, 103, 1857, 4017, 2383, 7845, 30187, 16363, 90011}},
    {6989, 17, 10792, {1, 3, 7, 11, 3, 53, 51, 183, 285, 67, 1897, 2229, 7523, 4115, 30429, 44199, 56829}},
    {6990, 17, 10805, {1, 3, 5, 9, 25, 3, 77, 7, 431, 853, 1607, 1853, 6711, 6099, 4291, 16055, 35465}},
    {6991, 17, 10810, {1, 3, 7, 13, 19, 31, 3, 117, 231, 607, 1445, 3529, 6821, 191, 15297, 63165, 16123}},
    {6992, 17, 10832, {1, 3, 1, 1, 27, 45, 39, 227, 385, 1011, 1129, 3673, 489, 15071, 28793, 61917, 57357}},
    {6993, 17, 10835, {1, 3, 1, 7, 23, 59, 19, 3, 395, 493, 817, 2715, 967, 5437, 4865, 64749, 87553}},
    {6994, 17, 10841, {1, 3, 7, 1, 13, 53, 109, 203, 497, 821, 1091, 2735, 6279, 14607, 2201, 30403, 38051}},
    {6995, 17, 10842, {1, 1, 5, 11, 15, 59, 33, 59, 441, 591, 1997, 2933, 4113, 16039, 19247, 62151, 69639}},
    {6996, 17, 10847, {1, 3, 7, 7, 31, 23, 73, 241, 209, 459, 1309, 1081, 2213, 9275, 27917, 30693, 111147}},
    {6997, 17, 10853, {1, 1, 1, 1, 13, 13, 1, 101, 297, 31, 393, 3917, 2767, 13793, 28953, 8401, 40847}},
    {6998, 17, 10860, {1, 3, 3, 5, 11, 55, 69, 21, 495, 725, 229, 3275, 6909, 9805, 18199, 64317, 128433}},
    {6999, 17, 10871, {1, 3, 5, 1, 9, 43, 63, 225, 427, 389, 309, 3599, 2759, 11337, 31865, 64813, 81193}},
    {7000, 17, 10878, {1, 3, 3, 7, 9, 49, 73, 113, 119, 739, 627, 3481, 7595, 3177, 19309, 43955, 99759}},
    {7001, 17, 10881, {1, 1, 7, 7, 31, 1, 75, 3, 107, 187, 1887, 2881, 6231, 15501, 20123, 15957, 3149}},
    {7002, 17, 10888, {1, 3, 1, 9, 31, 27, 11, 99, 61, 509, 1565, 2993, 7191, 9331, 12569, 61145, 15385}},
    {7003, 17, 10894, {1, 1, 3, 7, 17, 27, 71, 165, 61, 269, 461, 4043, 497, 10801, 5309, 60513, 105997}},
    {7004, 17, 10901, {1, 1, 7, 1, 5, 45, 115, 13, 249, 541, 651, 1157, 5917, 11505, 8501, 36561, 14455}},
    {7005, 17, 10915, {1, 1, 1, 1, 5, 39, 65, 185, 191, 787, 1951, 2395, 6499, 6031, 10877, 29777, 12821}},
    {7006, 17, 10918, {1, 1, 3, 15, 15, 55, 127, 27, 195, 677, 741, 1147, 2947, 12681, 30923, 64303, 84475}},
    {7007, 17, 10922, {1, 1, 5, 15, 9, 17, 25, 127, 223, 569, 1225, 859, 7379, 3901, 25983, 30367, 36669}},
    {7008, 17, 10936, {1, 3, 5, 9, 29, 37, 1, 177, 69, 989, 1481, 1383, 751, 10227, 17117, 2371, 109921}},
    {7009, 17, 10954, {1, 3, 7, 11, 31, 13, 101, 157, 285, 799, 741, 2649, 6697, 8463, 5177, 11119, 117225}},
    {7010, 17, 10968, {1, 3, 5, 11, 11, 35, 79, 113, 423, 595, 1, 3139, 121, 10231, 29785, 22339, 116515}},
    {7011, 17, 10971, {1, 3, 3, 9, 29, 17, 105, 87, 245, 951, 59, 2993, 179, 715, 27399, 9793, 10127}},
    {7012, 17, 10973, {1, 1, 7, 11, 9, 37, 1, 219, 51, 309, 1773, 121, 1311, 15473, 26353, 809, 4057}},
    {7013, 17, 10978, {1, 3, 5, 11, 21, 63, 113, 143, 95, 991, 765, 2549, 995, 4069, 16333, 54495, 19}},
    {7014, 17, 10998, {1, 1, 7, 13, 5, 43, 77, 57, 153, 477, 1843, 1261, 6275, 10417, 4643, 38817, 77447}},
    {7015, 17, 11009, {1, 3, 1, 13, 19, 17, 23, 199, 39, 711, 441, 3053, 7697, 4137, 12283, 7305, 123019}},
    {7016, 17, 11021, {1, 1, 1, 13, 19, 3, 63, 7, 69, 753, 969, 1955, 7375, 7735, 11107, 40489, 105871}},
    {7017, 17, 11029, {1, 1, 3, 15, 21, 15, 81, 187, 163, 661, 147, 3125, 189, 8065, 22167, 33831, 51923}},
    {7018, 17, 11030, {1, 1, 1, 7, 3, 43, 83, 179, 267, 239, 1093, 409, 169, 13863, 5081, 22065, 3161}},
    {7019, 17, 11034, {1, 3, 3, 9, 11, 27, 65, 177, 389, 933, 895, 1597, 6267, 10163, 8551, 52201, 9977}},
    {7020, 17, 11050, {1, 1, 5, 13, 31, 63, 119, 111, 423, 671, 487, 617, 2813, 6379, 973, 18593, 81319}},
    {7021, 17, 11063, {1, 1, 3, 3, 15, 59, 61, 187, 397, 59, 43, 331, 7921, 2031, 2111, 32221, 19933}},
    {7022, 17, 11064, {1, 1, 1, 9, 29, 9, 99, 129, 443, 257, 1099, 2719, 5091, 12313, 7241, 50363, 43345}},
    {7023, 17, 11077, {1, 1, 7, 13, 15, 5, 101, 205, 57, 17, 617, 2363, 6091, 2027, 21713, 55981, 99567}},
    {7024, 17, 11078, {1, 1, 7, 5, 25, 31, 3, 121, 261, 819, 1903, 269, 6585, 4731, 32205, 11005, 72693}},
    {7025, 17, 11105, {1, 3, 7, 9, 15, 43, 75, 25, 469, 601, 1625, 3753, 7209, 5129, 20341, 18051, 37337}},
    {7026, 17, 11106, {1, 3, 3, 3, 27, 5, 67, 183, 379, 921, 631, 1445, 4401, 6169, 23229, 57547, 91707}},
    {7027, 17, 11126, {1, 3, 7, 3, 29, 31, 99, 19, 419, 1023, 1187, 1999, 85, 2735, 7395, 21007, 65373}},
    {7028, 17, 11129, {1, 1, 7, 9, 17, 11, 15, 7, 187, 447, 1491, 601, 1911, 7137, 6975, 59381, 50247}},
    {7029, 17, 11135, {1, 1, 7, 9, 9, 29, 125, 243, 469, 687, 1791, 863, 527, 11047, 16119, 26793, 25401}},
    {7030, 17, 11151, {1, 1, 5, 15, 27, 55, 67, 165, 121, 721, 1485, 3285, 4667, 6831, 20705, 43517, 95581}},
    {7031, 17, 11159, {1, 1, 5, 9, 13, 13, 93, 207, 77, 381, 851, 2429, 3253, 1149, 25953, 34207, 122393}},
    {7032, 17, 11165, {1, 3, 7, 1, 7, 35, 105, 81, 35, 897, 1209, 1077, 4711, 7391, 15735, 33815, 108055}},
    {7033, 17, 11176, {1, 1, 7, 9, 5, 3, 7, 241, 79, 435, 1641, 675, 6923, 10149, 19001, 53343, 66259}},
    {7034, 17, 11179, {1, 1, 3, 3, 21, 51, 85, 151, 239, 965, 511, 3025, 4833, 14743, 6979, 23649, 127515}},
    {7035, 17, 11182, {1, 1, 7, 1, 31, 39, 97, 39, 451, 631, 191, 3531, 6929, 9061, 1877, 653, 106531}},
    {7036, 17, 11189, {1, 1, 7, 1, 17, 25, 83, 213, 55, 121, 1439, 705, 3037, 10099, 8573, 4249, 77623}},
    {7037, 17, 11204, {1, 1, 3, 15, 19, 3, 11, 119, 241, 423, 1585, 3759, 2133, 15767, 1853, 17925, 90929}},
    {7038, 17, 11216, {1, 1, 3, 13, 3, 1, 59, 39, 463, 755, 69, 4019, 4751, 9897, 12003, 54163, 38987}},
    {7039, 17, 11232, {1, 3, 1, 3, 7, 35, 115, 213, 1, 185, 1619, 2893, 7073, 10611, 27355, 57837, 73831}},
    {7040, 17, 11235, {1, 3, 5, 1, 19, 47, 91, 21, 189, 789, 1761, 2707, 6831, 13997, 17493, 6703, 24969}},
    {7041, 17, 11242, {1, 3, 1, 11, 13, 25, 77, 23, 347, 567, 1269, 2695, 7853, 11451, 12099, 44943, 32721}},
    {7042, 17, 11250, {1, 1, 7, 5, 7, 21, 101, 61, 85, 381, 1839, 2607, 7897, 4063, 14155, 57757, 88931}},
    {7043, 17, 11264, {1, 1, 3, 5, 21, 15, 83, 139, 327, 379, 1973, 3899, 2541, 8395, 9547, 24475, 41355}},
    {7044, 17, 11273, {1, 1, 3, 7, 11, 19, 39, 163, 469, 365, 261, 2715, 375, 10921, 20289, 5727, 100907}},
    {7045, 17, 11282, {1, 1, 3, 5, 25, 49, 123, 175, 249, 677, 1815, 2727, 6539, 6483, 23385, 27281, 99461}},
    {7046, 17, 11288, {1, 1, 1, 3, 15, 23, 93, 37, 449, 907, 955, 4019, 597, 7349, 27133, 37331, 119235}},
    {7047, 17, 11291, {1, 3, 7, 7, 25, 43, 93, 211, 197, 449, 1483, 3043, 1327, 14135, 15547, 35161, 94057}},
    {7048, 17, 11293, {1, 3, 7, 3, 25, 41, 13, 151, 327, 539, 1937, 1497, 7391, 15191, 6075, 35811, 98825}},
    {7049, 17, 11318, {1, 3, 1, 15, 15, 25, 69, 117, 285, 321, 93, 2851, 5727, 9809, 7481, 52895, 23883}},
    {7050, 17, 11321, {1, 3, 1, 7, 27, 15, 61, 105, 267, 535, 1295, 2245, 1395, 14137, 9911, 13271, 34895}},
    {7051, 17, 11329, {1, 3, 7, 15, 29, 15, 25, 15, 159, 643, 27, 2819, 6541, 715, 1319, 46961, 72667}},
    {7052, 17, 11336, {1, 1, 7, 11, 29, 61, 9, 167, 65, 285, 1367, 3897, 1059, 13845, 26467, 59103, 76319}},
    {7053, 17, 11339, {1, 1, 5, 15, 27, 31, 71, 73, 483, 627, 785, 803, 5347, 1717, 17195, 25801, 56587}},
    {7054, 17, 11342, {1, 3, 3, 13, 19, 35, 125, 97, 117, 951, 901, 2009, 6001, 13991, 10039, 48493, 22311}},
    {7055, 17, 11356, {1, 1, 7, 11, 19, 45, 37, 89, 427, 697, 505, 3397, 6403, 14637, 20419, 26493, 9351}},
    {7056, 17, 11383, {1, 3, 3, 9, 17, 31, 47, 155, 3, 39, 1515, 503, 4077, 7987, 13363, 64863, 26227}},
    {7057, 17, 11389, {1, 1, 1, 1, 11, 59, 91, 211, 191, 977, 293, 1359, 6963, 4403, 5039, 61553, 24539}},
    {7058, 17, 11405, {1, 3, 7, 15, 25, 27, 123, 155, 283, 801, 1157, 335, 7145, 5011, 14197, 951, 257}},
    {7059, 17, 11411, {1, 3, 7, 7, 9, 33, 125, 151, 465, 447, 781, 893, 1141, 14297, 4565, 8941, 50849}},
    {7060, 17, 11423, {1, 3, 3, 9, 9, 13, 77, 39, 241, 887, 601, 3861, 5967, 15635, 18679, 52783, 101859}},
    {7061, 17, 11424, {1, 1, 3, 5, 3, 57, 95, 251, 51, 93, 1819, 3089, 4581, 4525, 14625, 61731, 36965}},
    {7062, 17, 11430, {1, 1, 7, 13, 31, 41, 43, 53, 495, 233, 209, 485, 3787, 1375, 13753, 33731, 7455}},
    {7063, 17, 11444, {1, 3, 5, 15, 5, 29, 63, 121, 243, 589, 185, 2313, 5641, 5815, 13989, 35125, 9225}},
    {7064, 17, 11447, {1, 1, 3, 9, 15, 33, 5, 63, 79, 697, 1851, 3863, 6065, 5043, 11525, 58335, 61887}},
    {7065, 17, 11459, {1, 1, 5, 5, 15, 51, 33, 65, 387, 345, 543, 469, 175, 9913, 4567, 63441, 67195}},
    {7066, 17, 11465, {1, 3, 5, 13, 13, 39, 73, 131, 347, 781, 933, 3251, 3221, 8167, 6591, 23691, 124447}},
    {7067, 17, 11473, {1, 3, 7, 9, 3, 1, 81, 79, 373, 233, 1397, 2053, 4741, 14613, 23517, 1437, 42723}},
    {7068, 17, 11479, {1, 1, 5, 11, 25, 23, 9, 249, 299, 505, 245, 3143, 1001, 16005, 13789, 31147, 5441}},
    {7069, 17, 11501, {1, 1, 3, 5, 31, 55, 13, 115, 441, 199, 1547, 1171, 4011, 8789, 4633, 14747, 131025}},
    {7070, 17, 11510, {1, 1, 7, 1, 17, 41, 11, 45, 339, 721, 531, 3219, 5751, 11021, 26001, 19411, 8535}},
    {7071, 17, 11514, {1, 3, 1, 9, 9, 51, 39, 121, 51, 413, 129, 2995, 6205, 6291, 28889, 55477, 59447}},
    {7072, 17, 11522, {1, 3, 3, 15, 23, 17, 65, 7, 153, 307, 1031, 2041, 2063, 15239, 7023, 18063, 9093}},
    {7073, 17, 11527, {1, 1, 3, 5, 23, 15, 85, 145, 175, 765, 23, 4051, 6395, 1889, 23091, 32775, 81977}},
    {7074, 17, 11533, {1, 3, 1, 3, 9, 1, 103, 239, 385, 887, 667, 4079, 1309, 5595, 26953, 34485, 85813}},
    {7075, 17, 11536, {1, 3, 7, 3, 25, 55, 67, 133, 291, 531, 1131, 1757, 7577, 1415, 2909, 63333, 75479}},
    {7076, 17, 11548, {1, 3, 3, 9, 1, 43, 7, 47, 511, 703, 1617, 2841, 7111, 2765, 4705, 28357, 75711}},
    {7077, 17, 11551, {1, 1, 5, 3, 25, 57, 105, 11, 37, 803, 1075, 4035, 7337, 7089, 6097, 11703, 39461}},
    {7078, 17, 11552, {1, 3, 1, 5, 19, 7, 75, 115, 459, 247, 533, 727, 8101, 791, 11065, 17169, 54473}},
    {7079, 17, 11555, {1, 1, 7, 13, 17, 39, 77, 235, 427, 733, 1683, 3825, 3129, 13847, 8941, 61499, 39103}},
    {7080, 17, 11572, {1, 3, 5, 11, 7, 43, 83, 227, 203, 439, 341, 2345, 5031, 16227, 2639, 9757, 127887}},
    {7081, 17, 11587, {1, 1, 1, 3, 19, 1, 15, 71, 293, 31, 1415, 3587, 2833, 12183, 29595, 4143, 45569}},
    {7082, 17, 11601, {1, 3, 1, 9, 15, 1, 77, 59, 175, 389, 511, 3129, 2469, 1431, 9819, 43595, 53549}},
    {7083, 17, 11613, {1, 1, 3, 7, 31, 49, 105, 203, 149, 691, 157, 2419, 4413, 12227, 20183, 47999, 36023}},
    {7084, 17, 11614, {1, 1, 3, 1, 23, 49, 49, 45, 341, 453, 5, 2913, 2111, 12191, 2981, 45423, 19391}},
    {7085, 17, 11618, {1, 3, 3, 11, 19, 19, 5, 73, 167, 139, 1991, 311, 7725, 13591, 15877, 59855, 1181}},
    {7086, 17, 11624, {1, 1, 5, 3, 7, 9, 91, 7, 19, 937, 757, 225, 1961, 2109, 24197, 50893, 92621}},
    {7087, 17, 11630, {1, 1, 5, 5, 7, 9, 29, 249, 109, 577, 1733, 2001, 5071, 15701, 24039, 17273, 18213}},
    {7088, 17, 11663, {1, 1, 1, 3, 27, 55, 101, 83, 391, 665, 851, 2131, 1471, 12265, 16787, 26239, 116073}},
    {7089, 17, 11682, {1, 1, 1, 7, 19, 45, 71, 73, 413, 49, 623, 449, 6845, 11953, 5523, 1033, 52265}},
    {7090, 17, 11684, {1, 1, 7, 11, 15, 39, 63, 87, 221, 363, 157, 3723, 6729, 16189, 6141, 63113, 85291}},
    {7091, 17, 11702, {1, 1, 7, 9, 9, 15, 35, 209, 73, 35, 1965, 2691, 571, 14511, 18553, 31917, 19395}},
    {7092, 17, 11705, {1, 1, 3, 9, 29, 49, 117, 55, 71, 159, 1843, 2967, 359, 13143, 20691, 52793, 63901}},
    {7093, 17, 11713, {1, 1, 5, 9, 23, 3, 41, 137, 49, 719, 647, 1197, 7743, 4933, 26199, 54597, 35761}},
    {7094, 17, 11731, {1, 3, 5, 3, 17, 29, 15, 207, 477, 997, 1465, 1569, 1251, 2821, 7597, 25827, 95769}},
    {7095, 17, 11734, {1, 3, 5, 5, 23, 13, 37, 109, 143, 993, 1807, 2149, 3771, 12229, 2097, 56093, 203}},
    {7096, 17, 11740, {1, 1, 7, 1, 19, 63, 5, 21, 111, 329, 587, 3225, 6939, 15093, 11213, 54047, 90375}},
    {7097, 17, 11747, {1, 3, 5, 1, 11, 35, 17, 209, 217, 539, 1159, 491, 5651, 14131, 3779, 23435, 66599}},
    {7098, 17, 11754, {1, 3, 5, 15, 21, 27, 13, 83, 143, 647, 313, 3325, 1059, 7801, 20713, 57905, 3391}},
    {7099, 17, 11761, {1, 1, 3, 9, 9, 1, 1, 205, 439, 909, 1421, 3861, 199, 1565, 13965, 55549, 60765}},
    {7100, 17, 11762, {1, 1, 3, 11, 27, 33, 19, 213, 253, 807, 1817, 3561, 7713, 10589, 23695, 32931, 112491}},
    {7101, 17, 11787, {1, 1, 3, 15, 7, 51, 25, 163, 491, 257, 1963, 3, 3035, 4981, 26659, 40117, 48831}},
    {7102, 17, 11792, {1, 1, 1, 11, 3, 13, 117, 49, 467, 793, 1513, 947, 283, 4019, 27089, 51839, 46067}},
    {7103, 17, 11814, {1, 1, 7, 11, 3, 57, 105, 11, 441, 321, 1965, 2647, 2787, 9507, 20203, 39765, 34893}},
    {7104, 17, 11823, {1, 1, 5, 5, 1, 53, 77, 255, 485, 785, 465, 1523, 7395, 1517, 13247, 15581, 59519}},
    {7105, 17, 11825, {1, 1, 1, 1, 1, 59, 75, 237, 163, 331, 251, 939, 4105, 647, 21249, 23917, 6717}},
    {7106, 17, 11837, {1, 1, 7, 13, 1, 5, 121, 53, 323, 5, 887, 2127, 6719, 11885, 17337, 11081, 123167}},
    {7107, 17, 11838, {1, 1, 5, 3, 21, 31, 25, 83, 341, 769, 1305, 1683, 4701, 13361, 16955, 909, 87553}},
    {7108, 17, 11846, {1, 3, 1, 1, 7, 11, 117, 45, 19, 899, 1251, 1227, 2339, 11823, 7099, 46345, 48903}},
    {7109, 17, 11855, {1, 1, 7, 5, 19, 13, 29, 135, 481, 169, 675, 339, 4057, 9863, 24901, 20551, 121267}},
    {7110, 17, 11864, {1, 3, 5, 3, 21, 7, 79, 1, 211, 585, 1815, 3673, 7677, 13437, 28111, 2771, 79197}},
    {7111, 17, 11876, {1, 1, 7, 11, 25, 5, 37, 57, 301, 475, 1939, 3199, 7199, 3761, 19783, 20149, 119849}},
    {7112, 17, 11885, {1, 1, 3, 7, 19, 45, 75, 7, 269, 39, 1775, 1937, 3915, 5759, 28991, 54745, 7093}},
    {7113, 17, 11904, {1, 3, 7, 9, 11, 3, 87, 69, 45, 91, 1899, 2743, 2281, 12819, 31271, 25991, 17149}},
    {7114, 17, 11909, {1, 3, 3, 1, 1, 9, 121, 77, 55, 945, 473, 3729, 1391, 6009, 21729, 28833, 94561}},
    {7115, 17, 11913, {1, 3, 1, 13, 25, 3, 15, 9, 211, 409, 1137, 1693, 6049, 8281, 10471, 60203, 120019}},
    {7116, 17, 11916, {1, 3, 3, 3, 19, 53, 29, 231, 65, 745, 279, 201, 7523, 13695, 12835, 53595, 83107}},
    {7117, 17, 11940, {1, 1, 1, 3, 29, 31, 87, 223, 469, 635, 715, 1661, 4741, 7527, 5383, 28675, 98331}},
    {7118, 17, 11943, {1, 1, 5, 15, 15, 11, 13, 141, 191, 555, 51, 2751, 2411, 12701, 21985, 42063, 21715}},
    {7119, 17, 11972, {1, 1, 5, 11, 23, 19, 9, 173, 241, 411, 1453, 1507, 7907, 13959, 16075, 3359, 17587}},
    {7120, 17, 11981, {1, 3, 1, 5, 11, 19, 13, 67, 447, 461, 395, 3683, 4157, 4937, 30357, 30167, 37511}},
    {7121, 17, 11990, {1, 1, 3, 13, 13, 3, 47, 139, 419, 905, 1019, 3329, 1165, 13865, 29499, 12219, 49081}},
    {7122, 17, 11993, {1, 1, 1, 11, 5, 13, 125, 191, 285, 341, 1687, 1465, 457, 12939, 13865, 30953, 12207}},
    {7123, 17, 12000, {1, 3, 5, 1, 23, 11, 107, 71, 285, 879, 693, 1477, 2737, 14193, 14171, 20431, 255}},
    {7124, 17, 12005, {1, 1, 3, 11, 21, 23, 29, 199, 19, 197, 1751, 1231, 2229, 10051, 3627, 55651, 106697}},
    {7125, 17, 12015, {1, 3, 3, 11, 15, 61, 7, 201, 111, 963, 1787, 2801, 3285, 13881, 13127, 6597, 29543}},
    {7126, 17, 12020, {1, 1, 1, 9, 21, 15, 71, 237, 359, 1019, 319, 1795, 6561, 3261, 10007, 30463, 9977}},
    {7127, 17, 12038, {1, 1, 5, 7, 17, 33, 117, 155, 9, 535, 1667, 2509, 3239, 7029, 13415, 109, 107601}},
    {7128, 17, 12042, {1, 1, 7, 15, 27, 31, 119, 65, 435, 233, 1329, 2599, 3397, 10713, 10323, 7233, 34251}},
    {7129, 17, 12056, {1, 1, 3, 7, 17, 37, 73, 207, 47, 877, 29, 2431, 4169, 1401, 23145, 3061, 42453}},
    {7130, 17, 12065, {1, 3, 1, 7, 29, 17, 91, 79, 325, 241, 777, 1349, 6405, 6569, 2703, 48381, 31589}},
    {7131, 17, 12066, {1, 3, 1, 11, 17, 49, 45, 129, 465, 551, 67, 423, 1413, 14753, 26537, 39557, 66663}},
    {7132, 17, 12072, {1, 3, 5, 5, 17, 39, 55, 229, 501, 683, 51, 2667, 3711, 6663, 12183, 31231, 52563}},
    {7133, 17, 12080, {1, 3, 7, 11, 7, 51, 53, 1, 381, 77, 1565, 2105, 7071, 13057, 6109, 45349, 13551}},
    {7134, 17, 12083, {1, 1, 3, 7, 27, 11, 75, 145, 169, 251, 1999, 3865, 7805, 12807, 9565, 1049, 120469}},
    {7135, 17, 12090, {1, 1, 1, 15, 27, 17, 61, 227, 95, 149, 1927, 281, 5607, 16347, 10061, 10969, 85795}},
    {7136, 17, 12092, {1, 3, 7, 5, 25, 13, 85, 227, 349, 697, 1049, 1767, 2967, 429, 23117, 57553, 67651}},
    {7137, 17, 12103, {1, 1, 7, 11, 7, 11, 95, 113, 121, 141, 1077, 3653, 5625, 8319, 12583, 11193, 8153}},
    {7138, 17, 12109, {1, 1, 5, 15, 29, 21, 15, 177, 467, 393, 1435, 3913, 4693, 8389, 6425, 51477, 57343}},
    {7139, 17, 12112, {1, 3, 7, 15, 21, 25, 97, 33, 309, 623, 1669, 3699, 2059, 9497, 26267, 36321, 63369}},
    {7140, 17, 12117, {1, 1, 5, 13, 7, 47, 53, 83, 371, 405, 1867, 1281, 885, 4167, 1531, 54125, 24801}},
    {7141, 17, 12121, {1, 3, 5, 15, 27, 53, 37, 3, 447, 761, 1539, 33, 4709, 2673, 11947, 46753, 6307}},
    {7142, 17, 12137, {1, 3, 1, 15, 21, 53, 75, 189, 183, 493, 139, 871, 5007, 15375, 18809, 6833, 66683}},
    {7143, 17, 12143, {1, 3, 5, 5, 13, 27, 17, 133, 469, 487, 847, 711, 3581, 3855, 22291, 16349, 30403}},
    {7144, 17, 12145, {1, 1, 3, 11, 9, 5, 79, 175, 27, 167, 509, 3761, 439, 13835, 967, 44301, 71985}},
    {7145, 17, 12148, {1, 3, 1, 7, 5, 55, 59, 31, 103, 997, 589, 1575, 7541, 6175, 29905, 25341, 85353}},
    {7146, 17, 12168, {1, 3, 3, 15, 7, 49, 29, 41, 57, 335, 233, 2471, 6257, 3751, 25387, 48447, 121081}},
    {7147, 17, 12174, {1, 1, 7, 3, 31, 15, 35, 19, 365, 391, 937, 2479, 7023, 2043, 21961, 6917, 10271}},
    {7148, 17, 12188, {1, 1, 5, 3, 27, 21, 65, 1, 171, 849, 275, 2051, 1701, 3593, 21717, 50667, 100405}},
    {7149, 17, 12191, {1, 1, 5, 13, 13, 5, 91, 191, 353, 315, 1427, 2859, 791, 1587, 24557, 13685, 36401}},
    {7150, 17, 12192, {1, 3, 3, 9, 7, 27, 25, 157, 79, 737, 695, 3163, 3891, 11615, 23721, 46027, 112881}},
    {7151, 17, 12201, {1, 3, 1, 11, 17, 7, 53, 53, 281, 119, 329, 3465, 5085, 8835, 32407, 52865, 113631}},
    {7152, 17, 12224, {1, 3, 7, 11, 5, 7, 43, 181, 265, 671, 811, 1339, 7045, 16271, 22569, 63341, 93541}},
    {7153, 17, 12230, {1, 1, 1, 7, 3, 19, 5, 161, 473, 187, 1419, 1933, 5009, 9317, 14607, 60279, 49113}},
    {7154, 17, 12239, {1, 3, 3, 5, 19, 43, 99, 41, 489, 437, 1341, 3913, 5917, 415, 25133, 41103, 50945}},
    {7155, 17, 12242, {1, 3, 5, 3, 13, 1, 61, 81, 361, 689, 1901, 1425, 5697, 15467, 4417, 23017, 28021}},
    {7156, 17, 12251, {1, 1, 1, 1, 17, 29, 109, 73, 381, 277, 1525, 1115, 3089, 5689, 7317, 26233, 103573}},
    {7157, 17, 12258, {1, 1, 5, 15, 1, 25, 47, 41, 201, 117, 261, 2003, 653, 16053, 15459, 1729, 71123}},
    {7158, 17, 12264, {1, 3, 7, 5, 21, 23, 113, 115, 493, 57, 1057, 29, 4953, 4765, 8941, 41853, 54049}},
    {7159, 17, 12310, {1, 3, 1, 15, 21, 7, 87, 251, 463, 139, 213, 1323, 4181, 11841, 14237, 3865, 79057}},
    {7160, 17, 12319, {1, 1, 3, 7, 25, 37, 19, 113, 373, 1019, 1369, 2925, 7745, 13717, 19883, 11145, 130763}},
    {7161, 17, 12323, {1, 1, 5, 7, 23, 59, 29, 141, 453, 961, 1451, 2665, 6443, 3873, 15037, 55477, 19005}},
    {7162, 17, 12325, {1, 1, 5, 7, 1, 43, 93, 225, 53, 783, 1567, 551, 5871, 5951, 31781, 52529, 39309}},
    {7163, 17, 12332, {1, 1, 3, 15, 1, 29, 93, 61, 5, 213, 919, 625, 1553, 943, 23811, 54175, 78959}},
    {7164, 17, 12343, {1, 3, 3, 1, 3, 47, 63, 47, 389, 5, 315, 2001, 2995, 2181, 1693, 28797, 67837}},
    {7165, 17, 12344, {1, 3, 7, 5, 29, 53, 85, 59, 501, 791, 1245, 2585, 6907, 16381, 8333, 29653, 82701}},
    {7166, 17, 12352, {1, 3, 1, 7, 11, 25, 25, 135, 81, 931, 659, 3807, 3215, 5357, 8883, 32351, 119589}},
    {7167, 17, 12370, {1, 3, 3, 5, 25, 51, 65, 79, 495, 847, 1071, 207, 5715, 11893, 19947, 50631, 113949}},
    {7168, 17, 12388, {1, 3, 7, 5, 31, 61, 127, 247, 69, 315, 639, 2047, 5953, 447, 11351, 21615, 32567}},
    {7169, 17, 12395, {1, 1, 7, 11, 25, 9, 85, 13, 351, 791, 1313, 3365, 6659, 11531, 16981, 40001, 28597}},
    {7170, 17, 12403, {1, 3, 3, 9, 19, 49, 37, 217, 433, 649, 1251, 1147, 4469, 1837, 17591, 34505, 127237}},
    {7171, 17, 12409, {1, 3, 3, 9, 17, 37, 123, 143, 425, 895, 1191, 3531, 4689, 5339, 19103, 21121, 58423}},
    {7172, 17, 12410, {1, 1, 7, 9, 19, 61, 121, 73, 211, 299, 1773, 3473, 57, 9279, 28757, 45871, 7105}},
    {7173, 17, 12415, {1, 3, 7, 13, 21, 53, 117, 251, 233, 525, 599, 2393, 683, 4279, 1815, 27921, 88923}},
    {7174, 17, 12419, {1, 1, 7, 1, 13, 5, 45, 195, 353, 259, 897, 1663, 1759, 12415, 31307, 50159, 96967}},
    {7175, 17, 12426, {1, 1, 7, 3, 3, 33, 123, 103, 51, 333, 1553, 1307, 6653, 4889, 16001, 37511, 37719}},
    {7176, 17, 12439, {1, 1, 7, 11, 13, 33, 99, 63, 223, 43, 1491, 3555, 4569, 13361, 8063, 59745, 8397}},
    {7177, 17, 12445, {1, 1, 5, 1, 31, 47, 83, 237, 141, 659, 1959, 3209, 2449, 7149, 14081, 18571, 91539}},
    {7178, 17, 12459, {1, 3, 1, 1, 9, 11, 27, 161, 11, 691, 593, 3185, 6195, 16221, 20597, 5, 100495}},
    {7179, 17, 12464, {1, 3, 7, 3, 15, 55, 19, 175, 327, 87, 1897, 1915, 715, 8697, 17119, 48295, 39649}},
    {7180, 17, 12474, {1, 1, 3, 7, 15, 51, 119, 243, 113, 537, 835, 963, 5815, 3765, 4361, 16179, 30801}},
    {7181, 17, 12484, {1, 3, 1, 11, 11, 1, 9, 105, 495, 121, 1461, 771, 285, 2047, 1175, 17849, 29349}},
    {7182, 17, 12491, {1, 3, 3, 11, 25, 35, 93, 9, 501, 373, 863, 3071, 7271, 291, 15811, 62561, 23721}},
    {7183, 17, 12501, {1, 3, 5, 1, 9, 53, 115, 197, 205, 703, 803, 1347, 757, 15553, 8149, 37867, 7865}},
    {7184, 17, 12505, {1, 1, 3, 7, 15, 37, 89, 155, 291, 899, 1115, 3965, 1113, 7469, 29663, 57761, 86491}},
    {7185, 17, 12508, {1, 3, 3, 7, 23, 1, 17, 33, 9, 37, 627, 353, 1001, 4231, 31035, 12693, 31587}},
    {7186, 17, 12511, {1, 1, 3, 13, 15, 7, 11, 157, 45, 621, 1789, 2729, 3527, 11795, 5509, 19695, 89265}},
    {7187, 17, 12521, {1, 3, 5, 13, 23, 37, 41, 233, 469, 773, 1221, 479, 8123, 15541, 28105, 58599, 62417}},
    {7188, 17, 12522, {1, 3, 1, 11, 31, 51, 97, 227, 81, 1007, 1061, 1417, 6867, 13133, 23831, 63779, 6553}},
    {7189, 17, 12530, {1, 1, 3, 1, 7, 51, 93, 179, 3, 23, 1587, 1369, 5005, 11643, 9515, 55103, 94069}},
    {7190, 17, 12544, {1, 3, 3, 7, 23, 45, 81, 7, 129, 155, 1343, 895, 33, 6585, 75, 21679, 118409}},
    {7191, 17, 12547, {1, 3, 3, 3, 15, 17, 111, 213, 253, 465, 981, 3881, 5133, 9163, 2101, 10357, 101101}},
    {7192, 17, 12561, {1, 3, 3, 1, 23, 35, 21, 151, 91, 695, 1963, 891, 1719, 6305, 27751, 10755, 31787}},
    {7193, 17, 12571, {1, 3, 1, 13, 31, 59, 13, 95, 115, 841, 965, 2797, 1149, 7465, 7487, 49781, 119491}},
    {7194, 17, 12580, {1, 1, 3, 13, 23, 53, 77, 17, 225, 409, 1321, 2583, 1951, 10385, 26859, 14917, 114733}},
    {7195, 17, 12597, {1, 1, 7, 9, 25, 23, 115, 55, 177, 439, 1415, 1893, 3529, 10489, 18879, 35909, 93553}},
    {7196, 17, 12607, {1, 1, 3, 9, 23, 11, 19, 9, 197, 615, 533, 551, 931, 5827, 4683, 46029, 17203}},
    {7197, 17, 12609, {1, 1, 3, 5, 25, 29, 15, 161, 19, 735, 1887, 343, 4061, 4299, 13309, 36315, 78943}},
    {7198, 17, 12610, {1, 1, 5, 1, 13, 55, 9, 179, 95, 143, 1157, 3675, 6137, 9663, 11035, 21803, 54423}},
    {7199, 17, 12616, {1, 1, 1, 1, 13, 13, 1, 101, 297, 31, 393, 3917, 2767, 13793, 28953, 8401, 40847}},
    {7200, 17, 12621, {1, 3, 1, 9, 21, 43, 93, 193, 85, 361, 1401, 3659, 731, 3595, 18939, 33183, 48673}},
    {7201, 17, 12624, {1, 3, 7, 11, 27, 59, 19, 221, 263, 803, 1593, 1985, 4383, 3075, 17657, 16341, 80649}},
    {7202, 17, 12639, {1, 3, 5, 13, 19, 19, 59, 191, 267, 687, 1919, 389, 7359, 15685, 10849, 18309, 91257}},
    {7203, 17, 12645, {1, 3, 3, 11, 29, 53, 39, 107, 93, 139, 1795, 2617, 5353, 6617, 11821, 22725, 19277}},
    {7204, 17, 12652, {1, 1, 7, 1, 9, 23, 21, 105, 473, 857, 117, 489, 8161, 1831, 5929, 12271, 1459}},
    {7205, 17, 12655, {1, 3, 7, 7, 31, 7, 83, 167, 253, 271, 573, 2543, 1261, 3689, 18191, 8493, 10279}},
    {7206, 17, 12660, {1, 3, 5, 13, 19, 37, 73, 165, 327, 421, 1017, 1673, 2517, 5199, 1849, 33247, 57287}},
    {7207, 17, 12667, {1, 3, 7, 9, 15, 45, 29, 75, 321, 1013, 1357, 2815, 5405, 8463, 11035, 22149, 7297}},
    {7208, 17, 12686, {1, 1, 7, 9, 9, 55, 27, 111, 129, 707, 381, 1223, 4743, 5397, 10079, 44561, 42153}},
    {7209, 17, 12688, {1, 1, 5, 1, 9, 15, 103, 147, 485, 881, 703, 2841, 7751, 4951, 16809, 58635, 13889}},
    {7210, 17, 12697, {1, 1, 5, 11, 23, 37, 105, 205, 225, 11, 47, 1841, 2495, 6257, 8257, 2033, 4523}},
    {7211, 17, 12700, {1, 3, 7, 7, 23, 31, 13, 29, 453, 303, 363, 1851, 7101, 14191, 12895, 25893, 65109}},
    {7212, 17, 12707, {1, 3, 3, 11, 7, 13, 45, 107, 279, 99, 949, 3995, 5001, 7715, 29897, 42145, 2513}},
    {7213, 17, 12710, {1, 1, 3, 15, 31, 1, 95, 51, 465, 43, 1709, 519, 4635, 1239, 25023, 22187, 73873}},
    {7214, 17, 12719, {1, 3, 3, 11, 15, 33, 65, 15, 125, 833, 115, 3953, 845, 15127, 15899, 22847, 44629}},
    {7215, 17, 12739, {1, 1, 1, 11, 11, 43, 103, 203, 447, 569, 131, 3051, 6337, 11819, 21531, 17011, 118109}},
    {7216, 17, 12742, {1, 3, 1, 5, 1, 9, 121, 175, 141, 607, 1175, 3887, 7591, 7485, 25571, 35607, 9341}},
    {7217, 17, 12746, {1, 1, 3, 3, 11, 1, 121, 103, 39, 937, 1225, 43, 3229, 8251, 11517, 26579, 6889}},
    {7218, 17, 12754, {1, 3, 7, 3, 19, 17, 47, 103, 189, 733, 1631, 2201, 4837, 7911, 23145, 23003, 32561}},
    {7219, 17, 12765, {1, 1, 7, 5, 19, 33, 113, 189, 255, 503, 295, 895, 7739, 4717, 21219, 29087, 52863}},
    {7220, 17, 12772, {1, 1, 3, 15, 27, 11, 75, 53, 109, 983, 2033, 123, 4051, 8271, 18761, 60501, 3411}},
    {7221, 17, 12784, {1, 3, 7, 15, 3, 15, 101, 215, 199, 41, 337, 1505, 2257, 12969, 17913, 7017, 82257}},
    {7222, 17, 12789, {1, 3, 1, 3, 17, 37, 61, 103, 163, 541, 1067, 1785, 8107, 9545, 17005, 7359, 70279}},
    {7223, 17, 12800, {1, 3, 3, 3, 1, 23, 35, 225, 439, 43, 277, 2941, 7817, 7329, 21413, 48525, 109921}},
    {7224, 17, 12805, {1, 3, 1, 11, 31, 33, 53, 173, 359, 797, 1829, 2315, 6209, 2569, 20719, 50743, 40211}},
    {7225, 17, 12809, {1, 1, 5, 7, 31, 47, 127, 241, 43, 821, 1811, 3949, 721, 1985, 9977, 44051, 37031}},
    {7226, 17, 12815, {1, 1, 1, 1, 23, 49, 59, 29, 251, 883, 1989, 1789, 245, 12121, 23759, 51473, 51579}},
    {7227, 17, 12827, {1, 3, 1, 7, 31, 27, 113, 195, 7, 897, 677, 803, 1337, 13533, 17237, 31713, 51003}},
    {7228, 17, 12830, {1, 1, 7, 15, 27, 47, 55, 33, 27, 839, 763, 2445, 31, 10219, 25959, 22541, 5451}},
    {7229, 17, 12833, {1, 3, 5, 5, 29, 59, 79, 163, 173, 525, 781, 3397, 4623, 15833, 9259, 43607, 17609}},
    {7230, 17, 12840, {1, 1, 7, 3, 5, 41, 11, 129, 297, 453, 1755, 153, 6295, 5723, 30049, 4763, 110683}},
    {7231, 17, 12851, {1, 1, 1, 13, 29, 9, 107, 33, 415, 133, 1363, 1639, 4999, 6449, 4147, 20097, 30665}},
    {7232, 17, 12868, {1, 1, 3, 11, 19, 49, 109, 229, 379, 269, 1921, 1465, 3301, 10473, 12537, 61707, 101255}},
    {7233, 17, 12871, {1, 1, 5, 1, 23, 41, 41, 37, 487, 469, 1165, 7, 4941, 6289, 301, 64487, 125027}},
    {7234, 17, 12886, {1, 3, 7, 11, 5, 37, 31, 15, 257, 393, 189, 3673, 2307, 12423, 29119, 41327, 75641}},
    {7235, 17, 12899, {1, 3, 7, 15, 27, 35, 107, 41, 163, 921, 1013, 721, 8013, 7367, 8181, 25335, 63459}},
    {7236, 17, 12923, {1, 3, 3, 11, 9, 7, 107, 79, 399, 759, 1899, 3117, 7979, 14969, 28171, 32399, 43589}},
    {7237, 17, 12926, {1, 3, 1, 1, 11, 23, 55, 57, 429, 259, 569, 2195, 3897, 14725, 2519, 32793, 91869}},
    {7238, 17, 12932, {1, 3, 7, 7, 29, 49, 71, 5, 85, 241, 1489, 2205, 6395, 12099, 24067, 53119, 5647}},
    {7239, 17, 12935, {1, 1, 1, 1, 31, 29, 7, 95, 455, 849, 1279, 2339, 4911, 2975, 20041, 803, 92439}},
    {7240, 17, 12939, {1, 1, 5, 13, 17, 15, 99, 231, 41, 875, 1661, 697, 887, 13025, 127, 4949, 91777}},
    {7241, 17, 12942, {1, 3, 1, 3, 1, 15, 23, 221, 89, 605, 323, 3277, 2471, 13383, 9649, 50913, 20203}},
    {7242, 17, 12953, {1, 3, 1, 15, 13, 47, 97, 115, 31, 803, 1975, 567, 1803, 16257, 25981, 59675, 32035}},
    {7243, 17, 12959, {1, 3, 1, 5, 11, 55, 13, 123, 355, 811, 1619, 3933, 6417, 13821, 22777, 9521, 59699}},
    {7244, 17, 12960, {1, 1, 7, 15, 15, 9, 19, 45, 317, 995, 1833, 3953, 6521, 7101, 29363, 62005, 65225}},
    {7245, 17, 13002, {1, 1, 7, 13, 13, 25, 107, 97, 247, 629, 877, 2945, 2847, 10547, 26095, 16149, 28583}},
    {7246, 17, 13004, {1, 3, 3, 7, 7, 61, 97, 189, 109, 771, 359, 3831, 6525, 8339, 24989, 57245, 87685}},
    {7247, 17, 13016, {1, 3, 3, 3, 13, 5, 73, 93, 229, 583, 1439, 1615, 2917, 11677, 24009, 49369, 8057}},
    {7248, 17, 13021, {1, 1, 7, 7, 11, 9, 103, 145, 183, 961, 801, 2127, 4405, 11921, 30219, 19025, 111649}},
    {7249, 17, 13035, {1, 3, 7, 3, 11, 17, 53, 59, 207, 431, 755, 655, 3831, 13271, 30159, 31265, 124761}},
    {7250, 17, 13038, {1, 3, 3, 15, 7, 31, 41, 99, 177, 401, 899, 2989, 4667, 15291, 25721, 37059, 57261}},
    {7251, 17, 13052, {1, 3, 5, 15, 11, 23, 89, 95, 365, 581, 1941, 385, 2855, 7159, 5511, 41867, 105685}},
    {7252, 17, 13058, {1, 1, 3, 9, 11, 43, 79, 45, 261, 119, 1371, 3473, 5111, 15379, 31947, 23441, 41501}},
    {7253, 17, 13069, {1, 3, 5, 11, 17, 41, 107, 21, 87, 721, 1211, 1425, 5551, 6481, 10099, 61175, 54065}},
    {7254, 17, 13082, {1, 1, 7, 7, 17, 35, 21, 111, 11, 205, 1611, 3525, 2031, 6699, 19503, 56413, 72827}},
    {7255, 17, 13093, {1, 3, 5, 15, 5, 3, 9, 63, 497, 567, 1741, 3679, 311, 733, 13017, 33405, 69557}},
    {7256, 17, 13094, {1, 3, 7, 3, 29, 33, 21, 183, 321, 973, 1077, 395, 3175, 11053, 2907, 49819, 36003}},
    {7257, 17, 13100, {1, 3, 3, 1, 13, 21, 11, 161, 451, 441, 37, 2793, 7573, 7957, 7697, 61075, 43517}},
    {7258, 17, 13115, {1, 3, 5, 5, 15, 41, 123, 193, 77, 479, 1453, 2335, 2295, 9293, 23983, 25969, 8355}},
    {7259, 17, 13125, {1, 1, 1, 1, 23, 9, 113, 115, 113, 289, 9, 3937, 7937, 8553, 8841, 62839, 112995}},
    {7260, 17, 13132, {1, 1, 5, 1, 11, 21, 107, 113, 209, 445, 1723, 2225, 3413, 6479, 4983, 35099, 37993}},
    {7261, 17, 13143, {1, 1, 5, 3, 7, 31, 99, 247, 53, 859, 933, 563, 7765, 12205, 31155, 41381, 60415}},
    {7262, 17, 13144, {1, 3, 7, 15, 9, 23, 95, 65, 219, 611, 1297, 3205, 4201, 13009, 14525, 16757, 49061}},
    {7263, 17, 13153, {1, 1, 3, 11, 17, 15, 119, 61, 301, 775, 811, 1469, 6683, 6615, 24257, 9495, 116419}},
    {7264, 17, 13160, {1, 1, 1, 3, 9, 27, 23, 249, 127, 291, 491, 3589, 5961, 7019, 27051, 41701, 85967}},
    {7265, 17, 13165, {1, 1, 1, 11, 21, 37, 77, 247, 425, 241, 1765, 3019, 5355, 10123, 537, 26785, 50369}},
    {7266, 17, 13173, {1, 3, 3, 5, 13, 33, 43, 127, 55, 919, 957, 1259, 2339, 6613, 25985, 27699, 94977}},
    {7267, 17, 13174, {1, 1, 1, 5, 3, 51, 41, 65, 281, 595, 371, 363, 3235, 5585, 18291, 13425, 124435}},
    {7268, 17, 13187, {1, 1, 3, 15, 23, 49, 89, 37, 199, 397, 1421, 2707, 1031, 9381, 2059, 13555, 104779}},
    {7269, 17, 13190, {1, 3, 5, 1, 1, 7, 69, 245, 223, 871, 1859, 2161, 2009, 2237, 1991, 24887, 18243}},
    {7270, 17, 13204, {1, 1, 1, 9, 15, 11, 117, 77, 21, 139, 1961, 517, 3093, 15603, 16923, 53073, 29313}},
    {7271, 17, 13218, {1, 1, 1, 13, 7, 33, 103, 107, 503, 387, 1655, 1477, 3653, 9947, 32271, 59959, 114987}},
    {7272, 17, 13247, {1, 3, 7, 13, 7, 45, 85, 183, 231, 305, 379, 2301, 4919, 2849, 1065, 21169, 7821}},
    {7273, 17, 13250, {1, 1, 7, 1, 1, 51, 39, 135, 287, 205, 1061, 665, 8091, 9069, 27761, 12895, 130869}},
    {7274, 17, 13262, {1, 3, 3, 3, 17, 23, 95, 23, 419, 677, 327, 2983, 1803, 11905, 22003, 31499, 50151}},
    {7275, 17, 13267, {1, 3, 5, 3, 31, 27, 119, 131, 469, 85, 1499, 3001, 6085, 13767, 4867, 12189, 54075}},
    {7276, 17, 13274, {1, 3, 1, 3, 1, 55, 111, 43, 251, 247, 1691, 2157, 1671, 7163, 12989, 41919, 107097}},
    {7277, 17, 13304, {1, 1, 5, 15, 11, 11, 109, 165, 55, 253, 1087, 21, 4443, 4271, 30575, 19243, 60225}},
    {7278, 17, 13309, {1, 3, 7, 9, 11, 15, 127, 235, 69, 851, 1117, 887, 115, 1209, 31343, 65347, 106957}},
    {7279, 17, 13315, {1, 3, 3, 13, 5, 43, 53, 195, 23, 433, 225, 2167, 1117, 14203, 17195, 25259, 23959}},
    {7280, 17, 13317, {1, 1, 5, 7, 7, 1, 75, 203, 487, 177, 1995, 531, 5631, 16299, 20043, 33319, 24961}},
    {7281, 17, 13324, {1, 3, 1, 13, 7, 27, 73, 27, 261, 473, 489, 1027, 6041, 16327, 16083, 2077, 73277}},
    {7282, 17, 13332, {1, 3, 3, 7, 27, 7, 49, 181, 227, 61, 307, 119, 4031, 2607, 21645, 51587, 34731}},
    {7283, 17, 13342, {1, 3, 5, 1, 23, 55, 127, 1, 321, 515, 817, 3009, 6427, 4937, 4827, 34425, 123063}},
    {7284, 17, 13346, {1, 3, 1, 3, 13, 23, 51, 211, 29, 953, 1197, 315, 1691, 7675, 21181, 12411, 85497}},
    {7285, 17, 13355, {1, 1, 5, 11, 19, 47, 115, 73, 213, 87, 1173, 2685, 2001, 12791, 4183, 59715, 86887}},
    {7286, 17, 13358, {1, 1, 7, 7, 5, 15, 91, 187, 475, 391, 223, 617, 625, 9539, 24517, 48343, 84939}},
    {7287, 17, 13360, {1, 3, 7, 1, 13, 27, 1, 167, 325, 625, 941, 1419, 1213, 15959, 18753, 52057, 40835}},
    {7288, 17, 13369, {1, 1, 5, 9, 27, 55, 107, 65, 209, 497, 499, 3549, 3133, 6537, 16665, 43093, 38857}},
    {7289, 17, 13372, {1, 3, 3, 1, 27, 11, 39, 151, 203, 59, 1899, 1583, 7339, 9151, 28313, 59761, 117993}},
    {7290, 17, 13398, {1, 3, 5, 5, 15, 7, 67, 181, 295, 191, 1783, 3691, 4299, 10249, 31031, 43509, 20585}},
    {7291, 17, 13404, {1, 3, 7, 7, 5, 39, 9, 157, 259, 497, 525, 2937, 2513, 15391, 2743, 65397, 56463}},
    {7292, 17, 13407, {1, 3, 3, 1, 3, 31, 115, 129, 273, 25, 1245, 2759, 5055, 12931, 5933, 17273, 103729}},
    {7293, 17, 13414, {1, 3, 5, 5, 27, 11, 59, 37, 157, 649, 1811, 2385, 6799, 12689, 9633, 3167, 8637}},
    {7294, 17, 13426, {1, 1, 1, 5, 15, 29, 57, 57, 21, 715, 215, 3443, 4111, 10693, 9879, 45725, 103023}},
    {7295, 17, 13432, {1, 1, 7, 3, 25, 49, 43, 107, 251, 701, 1131, 3759, 2451, 5393, 16509, 60799, 58185}},
    {7296, 17, 13466, {1, 1, 5, 15, 7, 33, 105, 227, 67, 75, 501, 1623, 637, 6401, 31585, 33543, 76245}},
    {7297, 17, 13481, {1, 1, 7, 3, 1, 1, 109, 65, 185, 941, 925, 1735, 2689, 15525, 18035, 20929, 40821}},
    {7298, 17, 13490, {1, 1, 5, 9, 23, 3, 41, 137, 49, 719, 647, 1197, 7743, 4933, 26199, 54597, 35761}},
    {7299, 17, 13496, {1, 3, 3, 7, 7, 15, 95, 151, 393, 955, 1949, 3421, 4325, 7003, 3057, 57357, 21435}},
    {7300, 17, 13504, {1, 3, 7, 15, 25, 49, 5, 75, 45, 929, 903, 1177, 6545, 10139, 26279, 15351, 10633}},
    {7301, 17, 13516, {1, 1, 7, 1, 3, 27, 27, 19, 71, 971, 149, 3281, 7483, 4579, 7899, 175, 113933}},
    {7302, 17, 13527, {1, 1, 7, 5, 27, 35, 101, 3, 207, 639, 1059, 2455, 6647, 1645, 17229, 2689, 13265}},
    {7303, 17, 13533, {1, 3, 5, 15, 25, 9, 115, 149, 127, 743, 1849, 2785, 6507, 14675, 13383, 40959, 98773}},
    {7304, 17, 13537, {1, 3, 7, 3, 21, 33, 117, 251, 81, 521, 303, 2509, 2445, 7853, 11515, 55073, 97937}},
    {7305, 17, 13552, {1, 1, 3, 1, 1, 55, 125, 179, 279, 935, 891, 1083, 7783, 14177, 23953, 61169, 51665}},
    {7306, 17, 13561, {1, 1, 3, 15, 7, 51, 25, 163, 491, 257, 1963, 3, 3035, 4981, 26659, 40117, 48831}},
    {7307, 17, 13567, {1, 1, 3, 1, 5, 45, 37, 239, 437, 381, 1899, 2505, 2697, 14583, 4557, 7267, 15961}},
    {7308, 17, 13582, {1, 1, 5, 9, 25, 21, 103, 37, 339, 589, 731, 659, 4911, 3131, 1023, 51721, 89801}},
    {7309, 17, 13587, {1, 3, 1, 13, 25, 31, 59, 27, 499, 581, 1071, 3225, 8047, 2355, 25407, 61949, 7243}},
    {7310, 17, 13589, {1, 1, 1, 9, 19, 27, 69, 47, 129, 443, 205, 4041, 7541, 15029, 21915, 56027, 13841}},
    {7311, 17, 13593, {1, 1, 1, 9, 25, 35, 113, 177, 55, 247, 959, 2249, 7043, 2257, 23253, 2377, 8587}},
    {7312, 17, 13596, {1, 1, 7, 1, 7, 63, 71, 219, 147, 415, 1205, 2089, 4729, 12879, 17645, 30033, 79313}},
    {7313, 17, 13615, {1, 3, 7, 5, 5, 33, 57, 3, 433, 169, 503, 3257, 4843, 15487, 26429, 28405, 107711}},
    {7314, 17, 13617, {1, 1, 5, 15, 31, 7, 39, 7, 19, 933, 441, 2003, 2183, 8535, 9955, 54525, 106765}},
    {7315, 17, 13623, {1, 1, 7, 5, 7, 33, 27, 57, 321, 57, 239, 3007, 7923, 8903, 85, 32931, 21845}},
    {7316, 17, 13641, {1, 1, 3, 11, 17, 23, 91, 253, 405, 271, 1469, 2497, 1523, 2175, 20423, 55213, 53111}},
    {7317, 17, 13647, {1, 3, 5, 1, 17, 57, 21, 169, 499, 165, 949, 1659, 3785, 2307, 24429, 17389, 66957}},
    {7318, 17, 13650, {1, 1, 7, 15, 25, 29, 61, 37, 407, 323, 827, 3715, 339, 9289, 17099, 56631, 31421}},
    {7319, 17, 13659, {1, 1, 3, 15, 9, 37, 97, 85, 149, 19, 1305, 845, 3913, 7217, 17725, 31317, 34857}},
    {7320, 17, 13671, {1, 1, 5, 9, 25, 15, 71, 237, 491, 889, 241, 13, 5207, 8847, 16495, 44041, 119267}},
    {7321, 17, 13677, {1, 3, 1, 15, 31, 7, 125, 27, 465, 179, 1869, 1021, 4957, 16229, 26269, 5547, 128897}},
    {7322, 17, 13678, {1, 3, 3, 5, 3, 13, 61, 71, 349, 15, 691, 2807, 5057, 15759, 16069, 50675, 66223}},
    {7323, 17, 13680, {1, 1, 7, 3, 9, 45, 35, 21, 201, 155, 1651, 4027, 2655, 6897, 12217, 45757, 41079}},
    {7324, 17, 13685, {1, 1, 3, 11, 25, 37, 61, 241, 355, 335, 907, 1431, 1277, 127, 22661, 57421, 54793}},
    {7325, 17, 13689, {1, 1, 3, 7, 1, 43, 13, 51, 297, 585, 1159, 3363, 5565, 13407, 29693, 36531, 87245}},
    {7326, 17, 13701, {1, 1, 5, 1, 3, 59, 93, 35, 201, 737, 1687, 3303, 4113, 3451, 15253, 44827, 72041}},
    {7327, 17, 13706, {1, 1, 5, 11, 9, 5, 97, 247, 205, 425, 499, 2787, 855, 12771, 4347, 49623, 59437}},
    {7328, 17, 13720, {1, 1, 7, 1, 31, 23, 95, 91, 459, 805, 1295, 2187, 131, 1789, 22757, 61793, 47641}},
    {7329, 17, 13729, {1, 3, 1, 5, 5, 39, 111, 109, 339, 777, 509, 3391, 4953, 2267, 21623, 46763, 3153}},
    {7330, 17, 13735, {1, 1, 3, 5, 13, 45, 1, 77, 1, 395, 1141, 1543, 5117, 1201, 15871, 24209, 116121}},
    {7331, 17, 13736, {1, 3, 3, 13, 15, 11, 1, 61, 315, 65, 715, 2423, 4969, 9537, 18095, 53775, 65073}},
    {7332, 17, 13756, {1, 3, 1, 7, 3, 7, 37, 255, 119, 211, 115, 3653, 2321, 14509, 11229, 12567, 22187}},
    {7333, 17, 13759, {1, 1, 5, 15, 25, 33, 115, 169, 395, 841, 267, 3613, 2673, 6431, 7499, 26465, 76865}},
    {7334, 17, 13761, {1, 1, 5, 5, 19, 43, 11, 171, 497, 925, 1939, 2655, 487, 10675, 699, 59753, 17391}},
    {7335, 17, 13771, {1, 1, 7, 7, 11, 7, 63, 233, 257, 621, 1013, 3043, 7359, 4135, 17019, 26295, 21991}},
    {7336, 17, 13782, {1, 3, 7, 15, 17, 19, 29, 207, 325, 729, 1263, 349, 3347, 10449, 18885, 36441, 11361}},
    {7337, 17, 13786, {1, 3, 5, 13, 31, 3, 85, 99, 191, 829, 1519, 3261, 5437, 12819, 27209, 2901, 54191}},
    {7338, 17, 13798, {1, 1, 7, 1, 13, 23, 29, 237, 299, 873, 611, 1359, 1857, 5441, 12091, 53655, 83971}},
    {7339, 17, 13810, {1, 1, 7, 13, 27, 1, 93, 245, 389, 211, 285, 1273, 6445, 4293, 53, 22689, 24989}},
    {7340, 17, 13819, {1, 3, 1, 15, 21, 59, 65, 139, 297, 569, 895, 877, 7023, 14705, 22977, 58921, 29879}},
    {7341, 17, 13826, {1, 3, 1, 15, 17, 47, 47, 143, 251, 475, 873, 2757, 1293, 793, 10237, 22919, 58445}},
    {7342, 17, 13831, {1, 1, 1, 13, 17, 41, 27, 101, 331, 605, 1291, 1785, 4353, 2829, 29149, 17533, 95469}},
    {7343, 17, 13837, {1, 1, 3, 1, 7, 9, 41, 229, 279, 611, 501, 1745, 8067, 13761, 14019, 48605, 109063}},
    {7344, 17, 13846, {1, 1, 3, 7, 31, 57, 53, 153, 189, 809, 825, 247, 7365, 319, 14327, 29837, 61215}},
    {7345, 17, 13856, {1, 3, 7, 13, 25, 51, 23, 19, 127, 469, 1341, 1665, 3377, 3197, 2051, 8617, 53683}},
    {7346, 17, 13862, {1, 3, 3, 15, 7, 17, 89, 59, 443, 199, 1519, 1977, 2901, 9809, 5835, 47501, 39905}},
    {7347, 17, 13866, {1, 3, 5, 5, 13, 39, 77, 207, 297, 815, 1529, 2377, 3703, 4345, 3081, 17337, 60887}},
    {7348, 17, 13885, {1, 1, 1, 3, 9, 25, 37, 199, 55, 23, 981, 3099, 677, 137, 11663, 14691, 51257}},
    {7349, 17, 13891, {1, 3, 7, 15, 11, 61, 121, 247, 265, 507, 769, 2025, 1415, 143, 23945, 12459, 89415}},
    {7350, 17, 13893, {1, 1, 7, 1, 17, 35, 85, 201, 55, 263, 127, 315, 4845, 343, 3143, 2273, 33937}},
    {7351, 17, 13905, {1, 1, 1, 9, 11, 29, 39, 53, 385, 637, 519, 491, 6829, 2381, 25095, 25539, 77351}},
    {7352, 17, 13908, {1, 3, 3, 7, 31, 1, 79, 109, 245, 653, 871, 3369, 2061, 6505, 7369, 9929, 85659}},
    {7353, 17, 13912, {1, 3, 1, 1, 1, 57, 73, 113, 47, 205, 277, 1993, 3767, 721, 2257, 42359, 79859}},
    {7354, 17, 13917, {1, 1, 1, 15, 9, 35, 29, 25, 93, 25, 113, 1693, 837, 12265, 11129, 27981, 51169}},
    {7355, 17, 13918, {1, 3, 5, 9, 11, 47, 1, 37, 369, 437, 73, 2815, 5673, 5767, 18979, 6299, 24133}},
    {7356, 17, 13946, {1, 1, 5, 15, 9, 13, 123, 223, 321, 895, 223, 687, 3657, 3337, 9103, 50295, 3015}},
    {7357, 17, 13948, {1, 1, 3, 9, 25, 59, 27, 115, 337, 79, 1253, 141, 1603, 1625, 21531, 61691, 82209}},
    {7358, 17, 13964, {1, 1, 3, 9, 15, 15, 5, 83, 387, 985, 173, 4015, 7331, 15749, 20551, 12963, 68471}},
    {7359, 17, 13970, {1, 3, 5, 1, 23, 29, 3, 137, 145, 245, 1221, 1159, 1381, 4373, 6543, 44921, 53653}},
    {7360, 17, 13975, {1, 3, 1, 7, 15, 39, 1, 187, 343, 297, 1667, 1559, 1535, 6315, 6483, 9335, 38561}},
    {7361, 17, 13979, {1, 1, 7, 15, 9, 15, 97, 237, 25, 925, 1943, 2701, 6421, 2027, 11485, 51445, 71289}},
    {7362, 17, 13997, {1, 3, 5, 3, 13, 55, 23, 53, 133, 985, 1051, 1891, 3447, 3173, 3849, 10167, 19889}},
    {7363, 17, 14000, {1, 1, 1, 9, 11, 29, 7, 217, 399, 399, 577, 4059, 5669, 15763, 651, 65231, 49211}},
    {7364, 17, 14006, {1, 3, 1, 13, 9, 63, 9, 83, 57, 177, 1735, 3627, 6977, 1463, 18655, 22465, 32081}},
    {7365, 17, 14020, {1, 1, 1, 9, 3, 53, 77, 245, 505, 27, 1497, 2577, 8121, 11191, 1283, 55921, 38957}},
    {7366, 17, 14023, {1, 3, 7, 7, 3, 53, 17, 89, 459, 481, 457, 2643, 823, 15087, 20843, 47259, 76825}},
    {7367, 17, 14024, {1, 1, 5, 5, 11, 29, 127, 15, 259, 623, 2007, 1787, 4949, 8189, 20135, 29527, 96637}},
    {7368, 17, 14029, {1, 1, 7, 9, 31, 45, 39, 249, 483, 71, 391, 1043, 5565, 6015, 9155, 8785, 103357}},
    {7369, 17, 14035, {1, 3, 3, 15, 17, 61, 87, 107, 27, 807, 1695, 3489, 2733, 12081, 7001, 49225, 82251}},
    {7370, 17, 14044, {1, 3, 5, 5, 31, 29, 117, 193, 253, 193, 1667, 3051, 4751, 2307, 32761, 52539, 32331}},
    {7371, 17, 14047, {1, 3, 7, 15, 5, 43, 61, 67, 219, 759, 615, 1419, 209, 11531, 21125, 14233, 95117}},
    {7372, 17, 14058, {1, 3, 3, 9, 17, 37, 123, 143, 425, 895, 1191, 3531, 4689, 5339, 19103, 21121, 58423}},
    {7373, 17, 14066, {1, 3, 1, 13, 7, 13, 1, 227, 275, 467, 39, 829, 975, 13035, 13729, 55981, 92209}},
    {7374, 17, 14075, {1, 1, 1, 15, 13, 11, 15, 185, 209, 709, 489, 2269, 6067, 10745, 20649, 6749, 82551}},
    {7375, 17, 14080, {1, 1, 3, 15, 11, 29, 25, 179, 395, 863, 33, 3525, 2797, 2443, 21749, 631, 26881}},
    {7376, 17, 14095, {1, 1, 3, 13, 1, 39, 45, 161, 419, 795, 1639, 2205, 2831, 6517, 5337, 59403, 71361}},
    {7377, 17, 14100, {1, 1, 5, 11, 5, 35, 3, 67, 107, 151, 271, 2899, 6033, 11167, 2521, 58923, 129297}},
    {7378, 17, 14114, {1, 1, 7, 3, 7, 31, 49, 163, 411, 995, 1595, 3133, 3889, 67, 30221, 48139, 29363}},
    {7379, 17, 14116, {1, 1, 7, 13, 7, 31, 105, 51, 511, 303, 1827, 2781, 7507, 11275, 14751, 4095, 117713}},
    {7380, 17, 14123, {1, 1, 3, 15, 1, 9, 123, 109, 29, 475, 1523, 2039, 825, 15241, 14339, 1307, 19025}},
    {7381, 17, 14134, {1, 1, 5, 3, 29, 59, 7, 25, 157, 695, 1159, 4055, 2671, 4277, 12709, 45993, 86187}},
    {7382, 17, 14143, {1, 3, 5, 5, 1, 7, 5, 123, 39, 903, 339, 1187, 1593, 6451, 25681, 19829, 10843}},
    {7383, 17, 14151, {1, 3, 3, 5, 31, 11, 47, 13, 315, 917, 1891, 1085, 6313, 13743, 2461, 55509, 99343}},
    {7384, 17, 14160, {1, 3, 5, 9, 15, 41, 89, 159, 293, 769, 2043, 4075, 5373, 8773, 9937, 14185, 26931}},
    {7385, 17, 14163, {1, 1, 3, 15, 5, 55, 115, 123, 371, 89, 479, 3031, 6213, 15465, 3351, 52457, 4065}},
    {7386, 17, 14179, {1, 1, 7, 9, 3, 17, 57, 189, 55, 631, 1817, 2845, 1845, 25, 32255, 20215, 97999}},
    {7387, 17, 14181, {1, 3, 7, 13, 5, 21, 119, 247, 325, 275, 583, 1749, 161, 11693, 195, 44833, 97591}},
    {7388, 17, 14193, {1, 3, 1, 13, 5, 57, 99, 105, 37, 777, 1861, 337, 291, 4549, 26087, 22229, 24843}},
    {7389, 17, 14209, {1, 3, 7, 1, 23, 37, 83, 233, 49, 701, 1789, 2683, 6935, 369, 4907, 64675, 111605}},
    {7390, 17, 14210, {1, 1, 1, 1, 25, 39, 15, 153, 267, 535, 951, 771, 4183, 1569, 29921, 4335, 89399}},
    {7391, 17, 14224, {1, 3, 3, 15, 19, 25, 75, 233, 85, 913, 261, 797, 7381, 3989, 32577, 13703, 8973}},
    {7392, 17, 14245, {1, 3, 3, 7, 23, 45, 81, 7, 129, 155, 1343, 895, 33, 6585, 75, 21679, 118409}},
    {7393, 17, 14249, {1, 3, 1, 11, 27, 43, 123, 71, 335, 341, 107, 2543, 8069, 4971, 18841, 58203, 55045}},
    {7394, 17, 14255, {1, 1, 1, 1, 3, 21, 79, 123, 481, 261, 695, 2539, 2849, 91, 32665, 23797, 53219}},
    {7395, 17, 14267, {1, 1, 5, 15, 23, 25, 115, 165, 323, 555, 1359, 3859, 121, 11039, 12127, 26021, 40363}},
    {7396, 17, 14270, {1, 1, 1, 5, 3, 29, 53, 41, 41, 333, 347, 2383, 437, 253, 26615, 44115, 125283}},
    {7397, 17, 14277, {1, 1, 1, 15, 11, 21, 59, 85, 327, 493, 131, 1539, 5871, 16129, 22531, 24741, 74069}},
    {7398, 17, 14305, {1, 1, 5, 5, 7, 7, 3, 93, 287, 149, 315, 2937, 7211, 14489, 107, 51761, 120239}},
    {7399, 17, 14308, {1, 1, 5, 11, 15, 59, 33, 59, 441, 591, 1997, 2933, 4113, 16039, 19247, 62151, 69639}},
    {7400, 17, 14312, {1, 1, 5, 13, 29, 53, 23, 237, 125, 603, 489, 3747, 651, 501, 8297, 45851, 41545}},
    {7401, 17, 14325, {1, 1, 7, 1, 27, 17, 49, 43, 305, 949, 1295, 1941, 3743, 4517, 3655, 36131, 32237}},
    {7402, 17, 14332, {1, 1, 7, 5, 3, 29, 119, 219, 337, 315, 935, 2639, 7265, 15603, 4359, 36671, 58305}},
    {7403, 17, 14345, {1, 1, 1, 9, 9, 17, 113, 61, 237, 609, 1419, 67, 5763, 10935, 24627, 36953, 49653}},
    {7404, 17, 14354, {1, 3, 7, 1, 1, 55, 11, 151, 265, 17, 633, 281, 4233, 4769, 2905, 65479, 51669}},
    {7405, 17, 14372, {1, 3, 5, 1, 3, 19, 19, 189, 265, 69, 1173, 2575, 6929, 12317, 23651, 44707, 62311}},
    {7406, 17, 14387, {1, 1, 7, 1, 9, 23, 21, 105, 473, 857, 117, 489, 8161, 1831, 5929, 12271, 1459}},
    {7407, 17, 14390, {1, 1, 5, 9, 5, 17, 25, 233, 55, 781, 1959, 3675, 2579, 2725, 24863, 57553, 74839}},
    {7408, 17, 14402, {1, 1, 1, 11, 17, 25, 107, 85, 167, 249, 2011, 1875, 2769, 8883, 1483, 34895, 82095}},
    {7409, 17, 14408, {1, 3, 3, 5, 13, 35, 91, 29, 23, 897, 131, 1625, 2971, 9727, 27225, 48081, 130437}},
    {7410, 17, 14413, {1, 3, 3, 5, 15, 1, 71, 243, 1, 629, 2015, 3853, 4827, 2783, 7705, 51165, 111151}},
    {7411, 17, 14431, {1, 1, 7, 7, 19, 29, 113, 131, 415, 193, 1051, 165, 7287, 3817, 6917, 47723, 86625}},
    {7412, 17, 14438, {1, 1, 7, 1, 27, 35, 91, 187, 279, 937, 379, 1055, 343, 2437, 18377, 19333, 40767}},
    {7413, 17, 14447, {1, 3, 7, 3, 25, 49, 3, 141, 337, 693, 459, 333, 2215, 15851, 23485, 37463, 45063}},
    {7414, 17, 14455, {1, 3, 5, 11, 19, 63, 49, 145, 97, 351, 507, 1219, 7921, 9411, 23865, 62101, 103415}},
    {7415, 17, 14461, {1, 1, 3, 7, 5, 59, 31, 31, 387, 505, 1157, 3523, 69, 10757, 18991, 29763, 102777}},
    {7416, 17, 14466, {1, 1, 1, 1, 15, 9, 95, 167, 93, 119, 489, 695, 1371, 13725, 305, 14591, 74695}},
    {7417, 17, 14480, {1, 3, 3, 9, 1, 63, 67, 109, 483, 99, 505, 3755, 4045, 7521, 7913, 49523, 59833}},
    {7418, 17, 14490, {1, 1, 5, 15, 31, 33, 39, 153, 397, 1017, 1647, 3235, 843, 9031, 21781, 20125, 29189}},
    {7419, 17, 14492, {1, 3, 7, 5, 27, 1, 111, 173, 357, 475, 1651, 81, 5493, 15773, 16111, 41541, 87787}},
    {7420, 17, 14508, {1, 3, 7, 11, 9, 11, 9, 159, 35, 535, 1245, 1681, 5771, 6601, 20967, 41533, 48433}},
    {7421, 17, 14513, {1, 3, 3, 15, 25, 5, 75, 41, 247, 27, 985, 199, 4207, 4021, 13929, 6977, 45881}},
    {7422, 17, 14516, {1, 1, 1, 13, 1, 63, 83, 111, 471, 183, 1507, 1117, 4053, 6413, 29187, 39991, 8311}},
    {7423, 17, 14519, {1, 3, 1, 5, 25, 31, 11, 107, 293, 105, 1971, 433, 4743, 6379, 25273, 33845, 101525}},
    {7424, 17, 14525, {1, 3, 3, 7, 15, 1, 7, 19, 19, 473, 251, 2625, 8103, 14433, 6221, 41963, 99633}},
    {7425, 17, 14534, {1, 3, 3, 3, 9, 51, 125, 175, 321, 303, 1269, 497, 7809, 15323, 10615, 18073, 60735}},
    {7426, 17, 14537, {1, 3, 3, 1, 29, 21, 67, 129, 451, 411, 1443, 779, 2101, 9275, 10383, 53121, 85299}},
    {7427, 17, 14543, {1, 1, 7, 9, 9, 9, 109, 19, 421, 97, 751, 3889, 3319, 14581, 25195, 13753, 113961}},
    {7428, 17, 14545, {1, 3, 5, 11, 9, 43, 37, 243, 173, 923, 693, 1139, 1461, 9721, 4407, 58067, 80645}},
    {7429, 17, 14552, {1, 1, 5, 13, 27, 31, 113, 135, 443, 165, 2005, 3285, 3599, 9017, 4463, 29803, 46609}},
    {7430, 17, 14562, {1, 1, 5, 3, 9, 57, 89, 55, 491, 605, 107, 1637, 2025, 7207, 10633, 43867, 113495}},
    {7431, 17, 14571, {1, 3, 1, 15, 15, 17, 7, 73, 393, 239, 1845, 597, 2581, 10125, 22303, 51201, 115199}},
    {7432, 17, 14574, {1, 3, 7, 3, 29, 31, 99, 19, 419, 1023, 1187, 1999, 85, 2735, 7395, 21007, 65373}},
    {7433, 17, 14582, {1, 1, 1, 9, 29, 21, 87, 5, 381, 141, 815, 1505, 2557, 16023, 4977, 22483, 52319}},
    {7434, 17, 14611, {1, 1, 1, 13, 29, 9, 107, 33, 415, 133, 1363, 1639, 4999, 6449, 4147, 20097, 30665}},
    {7435, 17, 14614, {1, 3, 7, 3, 25, 13, 77, 107, 25, 487, 1391, 1841, 3765, 9175, 23033, 23171, 29157}},
    {7436, 17, 14620, {1, 1, 3, 11, 15, 27, 1, 57, 409, 1001, 1761, 1075, 5573, 5939, 7577, 2581, 100529}},
    {7437, 17, 14633, {1, 1, 1, 11, 15, 11, 121, 219, 501, 285, 723, 2293, 2559, 8637, 21223, 41897, 1449}},
    {7438, 17, 14641, {1, 1, 5, 9, 29, 61, 13, 21, 271, 489, 179, 511, 7381, 10129, 11129, 30629, 63385}},
    {7439, 17, 14648, {1, 3, 5, 3, 15, 3, 109, 165, 139, 559, 1709, 589, 5951, 2941, 13803, 48723, 80359}},
    {7440, 17, 14671, {1, 3, 1, 11, 23, 17, 17, 219, 389, 721, 1851, 2053, 331, 12057, 8633, 22015, 75043}},
    {7441, 17, 14674, {1, 3, 5, 13, 7, 63, 65, 99, 21, 381, 473, 3441, 3349, 10589, 14167, 21967, 53585}},
    {7442, 17, 14689, {1, 1, 3, 7, 7, 39, 87, 243, 353, 867, 1439, 3745, 1057, 2019, 24079, 63267, 127707}},
    {7443, 17, 14690, {1, 1, 3, 13, 19, 29, 29, 91, 77, 279, 1057, 3027, 163, 12991, 27409, 57577, 90933}},
    {7444, 17, 14692, {1, 3, 1, 11, 7, 59, 115, 105, 439, 651, 283, 2179, 2723, 3923, 9985, 1741, 120215}},
    {7445, 17, 14699, {1, 3, 7, 13, 23, 31, 45, 53, 423, 467, 1111, 3439, 5481, 10225, 25521, 40359, 126407}},
    {7446, 17, 14710, {1, 3, 1, 15, 13, 47, 97, 115, 31, 803, 1975, 567, 1803, 16257, 25981, 59675, 32035}},
    {7447, 17, 14719, {1, 3, 3, 3, 19, 27, 29, 141, 323, 175, 1919, 831, 1831, 15275, 25331, 45991, 9383}},
    {7448, 17, 14730, {1, 3, 5, 13, 1, 49, 101, 15, 191, 689, 235, 3563, 2681, 803, 18997, 37613, 64891}},
    {7449, 17, 14732, {1, 3, 5, 5, 7, 27, 125, 215, 135, 831, 1943, 2039, 3409, 4999, 22577, 42865, 70837}},
    {7450, 17, 14743, {1, 1, 3, 5, 15, 17, 11, 181, 25, 113, 1667, 3895, 3975, 4667, 18665, 4123, 71001}},
    {7451, 17, 14744, {1, 3, 7, 5, 31, 19, 87, 199, 431, 621, 465, 2855, 143, 9439, 24075, 15655, 91145}},
    {7452, 17, 14750, {1, 1, 3, 5, 25, 49, 123, 175, 249, 677, 1815, 2727, 6539, 6483, 23385, 27281, 99461}},
    {7453, 17, 14759, {1, 1, 1, 13, 3, 61, 91, 71, 107, 371, 797, 3795, 4721, 8595, 20107, 17457, 66233}},
    {7454, 17, 14763, {1, 1, 3, 13, 5, 45, 25, 109, 335, 353, 67, 197, 437, 13013, 2475, 2649, 125551}},
    {7455, 17, 14768, {1, 1, 3, 15, 13, 35, 73, 179, 61, 709, 647, 2723, 7571, 1285, 27723, 21339, 86573}},
    {7456, 17, 14773, {1, 3, 5, 11, 27, 51, 41, 173, 509, 881, 463, 3095, 4073, 6571, 27569, 20215, 15379}},
    {7457, 17, 14777, {1, 3, 3, 13, 3, 1, 37, 195, 213, 417, 1295, 2659, 4599, 10203, 11711, 61251, 53727}},
    {7458, 17, 14786, {1, 3, 5, 1, 3, 39, 115, 151, 369, 927, 309, 3553, 7893, 963, 28725, 465, 57851}},
    {7459, 17, 14795, {1, 1, 5, 3, 17, 29, 33, 29, 155, 105, 1589, 149, 3441, 12467, 23359, 49805, 58127}},
    {7460, 17, 14800, {1, 1, 1, 7, 27, 3, 53, 75, 455, 761, 879, 1189, 5271, 8995, 9677, 37961, 120499}},
    {7461, 17, 14812, {1, 3, 7, 5, 15, 35, 91, 27, 485, 937, 1519, 219, 2421, 9979, 27325, 29711, 19089}},
    {7462, 17, 14816, {1, 3, 1, 1, 31, 5, 83, 189, 165, 831, 1413, 3135, 5505, 7243, 26559, 40389, 25605}},
    {7463, 17, 14836, {1, 1, 1, 5, 5, 21, 65, 61, 31, 121, 685, 2939, 657, 12909, 3389, 56639, 10993}},
    {7464, 17, 14840, {1, 3, 3, 1, 29, 49, 113, 169, 435, 225, 1477, 3269, 7893, 12727, 7613, 35873, 7197}},
    {7465, 17, 14856, {1, 3, 7, 15, 25, 27, 123, 155, 283, 801, 1157, 335, 7145, 5011, 14197, 951, 257}},
    {7466, 17, 14859, {1, 3, 1, 5, 23, 3, 89, 133, 367, 179, 1959, 4045, 5001, 14629, 18639, 21545, 102427}},
    {7467, 17, 14870, {1, 1, 3, 3, 1, 9, 125, 111, 103, 401, 1617, 1987, 2169, 14699, 25679, 44951, 69383}},
    {7468, 17, 14873, {1, 1, 1, 3, 9, 27, 23, 249, 127, 291, 491, 3589, 5961, 7019, 27051, 41701, 85967}},
    {7469, 17, 14879, {1, 1, 5, 5, 25, 43, 117, 217, 35, 781, 935, 3841, 7417, 8791, 159, 46383, 76177}},
    {7470, 17, 14880, {1, 3, 7, 3, 27, 59, 15, 169, 449, 487, 1465, 2333, 1507, 15359, 26825, 10387, 67619}},
    {7471, 17, 14889, {1, 1, 7, 5, 13, 27, 85, 143, 103, 877, 2017, 2785, 915, 1471, 15673, 4531, 41935}},
    {7472, 17, 14892, {1, 3, 7, 9, 11, 11, 65, 59, 395, 687, 1237, 17, 3233, 1567, 31213, 34805, 33949}},
    {7473, 17, 14895, {1, 3, 5, 7, 23, 27, 89, 87, 389, 993, 2025, 1759, 2957, 15347, 11015, 28541, 64621}},
    {7474, 17, 14900, {1, 3, 1, 15, 27, 31, 83, 195, 303, 343, 87, 417, 5229, 14635, 29843, 31825, 127369}},
    {7475, 17, 14903, {1, 1, 3, 3, 15, 9, 43, 251, 347, 373, 893, 3851, 1303, 15601, 10861, 62599, 60567}},
    {7476, 17, 14910, {1, 3, 7, 5, 17, 27, 75, 151, 9, 627, 1005, 3605, 1735, 13155, 10893, 47761, 40411}},
    {7477, 17, 14912, {1, 1, 3, 5, 29, 9, 69, 181, 73, 617, 781, 2103, 263, 837, 22647, 18787, 36461}},
    {7478, 17, 14942, {1, 3, 1, 1, 5, 17, 43, 221, 447, 9, 1021, 3541, 4401, 8165, 26279, 9449, 64499}},
    {7479, 17, 14948, {1, 1, 3, 15, 15, 37, 73, 133, 123, 345, 529, 49, 5387, 13039, 3669, 38799, 125491}},
    {7480, 17, 14957, {1, 1, 3, 3, 7, 63, 91, 137, 443, 125, 1949, 557, 101, 3911, 21229, 2909, 121685}},
    {7481, 17, 14963, {1, 1, 5, 15, 11, 11, 109, 165, 55, 253, 1087, 21, 4443, 4271, 30575, 19243, 60225}},
    {7482, 17, 14975, {1, 3, 5, 9, 23, 45, 103, 65, 43, 457, 1237, 921, 6747, 8271, 16193, 52651, 116281}},
    {7483, 17, 14985, {1, 1, 7, 5, 25, 63, 29, 141, 7, 977, 1115, 1059, 2645, 8293, 23959, 7379, 117569}},
    {7484, 17, 14993, {1, 1, 1, 1, 29, 53, 103, 1, 29, 449, 1641, 1851, 3925, 12983, 11483, 56437, 129277}},
    {7485, 17, 15003, {1, 1, 7, 13, 21, 53, 117, 85, 449, 781, 1523, 3417, 2653, 9343, 20105, 12761, 114605}},
    {7486, 17, 15010, {1, 1, 1, 7, 23, 55, 23, 111, 147, 369, 145, 3427, 4943, 9635, 4919, 22331, 71133}},
    {7487, 17, 15022, {1, 3, 7, 11, 5, 21, 45, 39, 201, 309, 125, 2957, 6997, 11349, 1165, 40703, 79885}},
    {7488, 17, 15039, {1, 3, 1, 3, 13, 23, 51, 211, 29, 953, 1197, 315, 1691, 7675, 21181, 12411, 85497}},
    {7489, 17, 15041, {1, 1, 7, 9, 19, 25, 103, 21, 465, 951, 771, 1897, 7415, 5815, 8841, 16267, 106921}},
    {7490, 17, 15047, {1, 3, 5, 9, 13, 1, 101, 179, 143, 675, 215, 1821, 169, 12037, 8517, 15743, 35301}},
    {7491, 17, 15048, {1, 3, 7, 9, 11, 3, 125, 13, 485, 477, 673, 2215, 6073, 3505, 15477, 49989, 86981}},
    {7492, 17, 15056, {1, 3, 3, 9, 29, 63, 35, 77, 349, 453, 967, 657, 7945, 11797, 29921, 64307, 113307}},
    {7493, 17, 15066, {1, 3, 1, 13, 29, 21, 33, 245, 393, 155, 1853, 731, 1323, 15811, 13607, 27331, 3765}},
    {7494, 17, 15068, {1, 1, 3, 5, 13, 51, 19, 239, 355, 815, 1301, 609, 1029, 21, 20185, 33709, 33255}},
    {7495, 17, 15075, {1, 1, 3, 1, 25, 39, 57, 97, 213, 379, 555, 3409, 4769, 10709, 10611, 25411, 90525}},
    {7496, 17, 15077, {1, 1, 1, 3, 5, 49, 45, 61, 501, 39, 575, 1069, 4397, 6737, 5651, 7137, 76461}},
    {7497, 17, 15082, {1, 1, 7, 15, 9, 29, 17, 1, 77, 613, 1339, 2167, 3489, 11661, 9503, 475, 3173}},
    {7498, 17, 15096, {1, 1, 7, 15, 21, 61, 41, 81, 283, 873, 1617, 2747, 3853, 8535, 9461, 37657, 81241}},
    {7499, 17, 15102, {1, 1, 7, 11, 15, 39, 63, 87, 221, 363, 157, 3723, 6729, 16189, 6141, 63113, 85291}},
    {7500, 17, 15116, {1, 3, 5, 7, 1, 39, 67, 83, 251, 823, 1647, 587, 7793, 7715, 24891, 59549, 44271}},
    {7501, 17, 15122, {1, 3, 7, 3, 25, 35, 87, 179, 21, 403, 883, 1849, 249, 3521, 29835, 59333, 5151}},
    {7502, 17, 15127, {1, 3, 5, 15, 3, 11, 87, 213, 1, 467, 333, 1621, 6031, 13061, 16511, 15259, 87679}},
    {7503, 17, 15133, {1, 3, 5, 13, 7, 17, 97, 217, 229, 429, 1789, 2947, 4497, 8337, 13939, 50839, 11}},
    {7504, 17, 15137, {1, 3, 3, 13, 9, 47, 1, 183, 161, 619, 885, 2155, 4975, 15985, 10017, 60705, 100157}},
    {7505, 17, 15138, {1, 3, 7, 5, 19, 59, 29, 187, 73, 3, 765, 4045, 101, 16373, 30363, 2837, 96981}},
    {7506, 17, 15149, {1, 3, 1, 3, 27, 61, 23, 57, 27, 849, 67, 2019, 4665, 5653, 10883, 63499, 10469}},
    {7507, 17, 15152, {1, 1, 1, 1, 19, 9, 73, 197, 299, 81, 387, 2741, 713, 15507, 32463, 27895, 104431}},
    {7508, 17, 15155, {1, 1, 1, 15, 9, 17, 63, 53, 79, 183, 203, 903, 4435, 3115, 14771, 5553, 63503}},
    {7509, 17, 15158, {1, 3, 5, 3, 11, 9, 99, 133, 419, 17, 1407, 1485, 7409, 14301, 7101, 11917, 66377}},
    {7510, 17, 15187, {1, 1, 1, 15, 9, 49, 111, 117, 129, 335, 75, 2183, 3811, 14075, 31873, 31009, 14551}},
    {7511, 17, 15189, {1, 3, 5, 7, 21, 29, 71, 167, 109, 635, 1625, 1819, 5563, 687, 12973, 32803, 34497}},
    {7512, 17, 15190, {1, 1, 5, 3, 3, 43, 75, 161, 105, 139, 961, 3281, 3089, 16103, 6881, 32411, 30567}},
    {7513, 17, 15196, {1, 1, 5, 3, 29, 3, 77, 163, 477, 987, 1985, 2231, 2015, 1499, 1623, 48505, 17245}},
    {7514, 17, 15199, {1, 3, 7, 5, 9, 21, 53, 245, 145, 315, 911, 2799, 2421, 5955, 2811, 40617, 68733}},
    {7515, 17, 15205, {1, 1, 3, 15, 15, 17, 97, 145, 119, 877, 213, 3861, 2115, 2033, 4171, 20597, 128283}},
    {7516, 17, 15212, {1, 1, 1, 7, 1, 5, 3, 81, 295, 1003, 503, 2221, 4431, 8413, 1789, 6805, 115953}},
    {7517, 17, 15236, {1, 1, 1, 5, 15, 11, 93, 133, 135, 357, 1437, 789, 4365, 12479, 25901, 20323, 15631}},
    {7518, 17, 15243, {1, 1, 5, 5, 21, 7, 117, 35, 263, 647, 1597, 3703, 7381, 5385, 25993, 22157, 6495}},
    {7519, 17, 15246, {1, 1, 5, 3, 5, 43, 93, 141, 79, 915, 317, 1235, 8049, 9453, 3999, 28413, 96071}},
    {7520, 17, 15260, {1, 1, 7, 7, 13, 35, 63, 37, 39, 103, 1019, 1691, 1195, 3595, 23735, 47615, 40179}},
    {7521, 17, 15267, {1, 1, 7, 15, 19, 37, 111, 145, 431, 863, 747, 3795, 7313, 3005, 19901, 52315, 95845}},
    {7522, 17, 15274, {1, 3, 3, 9, 7, 23, 51, 237, 411, 591, 1423, 431, 1385, 2809, 16095, 55411, 106305}},
    {7523, 17, 15279, {1, 1, 7, 15, 25, 29, 61, 37, 407, 323, 827, 3715, 339, 9289, 17099, 56631, 31421}},
    {7524, 17, 15281, {1, 3, 3, 1, 1, 9, 121, 77, 55, 945, 473, 3729, 1391, 6009, 21729, 28833, 94561}},
    {7525, 17, 15282, {1, 3, 3, 11, 5, 57, 87, 177, 97, 487, 269, 4045, 2767, 15571, 7387, 28129, 62649}},
    {7526, 17, 15284, {1, 3, 1, 15, 3, 39, 33, 99, 101, 789, 1663, 875, 73, 15371, 23715, 9475, 115989}},
    {7527, 17, 15291, {1, 1, 7, 9, 5, 13, 29, 255, 429, 313, 111, 1231, 1305, 13169, 3131, 22031, 36757}},
    {7528, 17, 15293, {1, 3, 7, 13, 15, 3, 13, 35, 67, 767, 345, 2181, 1609, 12829, 14177, 5789, 109465}},
    {7529, 17, 15302, {1, 1, 3, 15, 7, 11, 77, 9, 255, 1021, 1097, 3069, 7527, 683, 26137, 30389, 121487}},
    {7530, 17, 15319, {1, 1, 5, 11, 23, 19, 9, 173, 241, 411, 1453, 1507, 7907, 13959, 16075, 3359, 17587}},
    {7531, 17, 15329, {1, 3, 7, 3, 13, 33, 117, 45, 277, 439, 1655, 1539, 3029, 2953, 5049, 63987, 47909}},
    {7532, 17, 15336, {1, 1, 1, 3, 29, 9, 7, 13, 147, 201, 575, 1927, 1309, 3019, 16491, 20055, 58889}},
    {7533, 17, 15347, {1, 3, 7, 1, 3, 29, 23, 227, 213, 77, 1483, 845, 1317, 1877, 20475, 56869, 31339}},
    {7534, 17, 15353, {1, 3, 1, 15, 9, 47, 51, 203, 341, 305, 1643, 3071, 3969, 2837, 26175, 33153, 99937}},
    {7535, 17, 15361, {1, 1, 7, 7, 11, 7, 63, 233, 257, 621, 1013, 3043, 7359, 4135, 17019, 26295, 21991}},
    {7536, 17, 15371, {1, 1, 7, 7, 29, 15, 117, 231, 241, 657, 1001, 2605, 7987, 541, 31971, 7627, 79335}},
    {7537, 17, 15397, {1, 3, 7, 7, 27, 45, 21, 141, 317, 443, 923, 2501, 1195, 8995, 28831, 31127, 90031}},
    {7538, 17, 15404, {1, 1, 5, 9, 19, 63, 25, 39, 129, 721, 871, 3329, 2227, 12149, 17303, 4841, 83993}},
    {7539, 17, 15407, {1, 1, 7, 13, 19, 37, 63, 195, 277, 111, 1229, 3637, 2403, 7483, 3587, 46743, 60637}},
    {7540, 17, 15421, {1, 1, 3, 7, 17, 41, 73, 89, 317, 23, 1643, 1885, 5531, 1233, 7041, 14159, 39615}},
    {7541, 17, 15433, {1, 1, 7, 3, 1, 51, 119, 65, 57, 855, 613, 1693, 5589, 10269, 22101, 4077, 8735}},
    {7542, 17, 15441, {1, 1, 7, 15, 29, 21, 89, 183, 415, 615, 249, 1203, 5239, 13077, 18853, 61899, 11619}},
    {7543, 17, 15442, {1, 1, 3, 3, 19, 23, 113, 61, 465, 985, 137, 671, 6173, 2555, 31593, 33289, 112059}},
    {7544, 17, 15463, {1, 1, 1, 11, 21, 61, 43, 195, 287, 841, 177, 409, 7621, 13201, 17719, 49101, 76203}},
    {7545, 17, 15472, {1, 3, 7, 3, 1, 51, 5, 165, 241, 207, 1821, 2305, 5903, 379, 17951, 48363, 95113}},
    {7546, 17, 15478, {1, 1, 1, 5, 15, 1, 77, 87, 307, 915, 297, 2737, 121, 6429, 20095, 51055, 64337}},
    {7547, 17, 15488, {1, 1, 1, 9, 7, 15, 127, 169, 57, 549, 857, 2121, 6991, 15215, 5113, 55299, 92991}},
    {7548, 17, 15493, {1, 1, 5, 15, 25, 31, 13, 139, 195, 191, 303, 391, 4797, 8683, 31005, 37251, 39435}},
    {7549, 17, 15498, {1, 1, 1, 15, 11, 7, 83, 235, 171, 673, 1235, 3331, 5511, 14651, 21183, 54941, 59313}},
    {7550, 17, 15511, {1, 1, 5, 5, 9, 41, 31, 31, 199, 33, 1203, 3891, 231, 449, 25629, 60525, 39587}},
    {7551, 17, 15521, {1, 1, 3, 7, 5, 23, 17, 37, 397, 391, 57, 3899, 7173, 6053, 19531, 45527, 54137}},
    {7552, 17, 15534, {1, 1, 1, 5, 5, 49, 105, 161, 293, 719, 145, 1573, 1097, 6581, 3811, 34433, 68407}},
    {7553, 17, 15539, {1, 1, 3, 3, 23, 45, 119, 195, 31, 671, 1923, 3915, 5847, 11563, 11533, 30877, 51387}},
    {7554, 17, 15541, {1, 3, 3, 5, 31, 9, 91, 17, 47, 755, 991, 763, 7269, 14663, 17387, 43515, 109085}},
    {7555, 17, 15560, {1, 1, 7, 11, 19, 43, 113, 233, 59, 331, 577, 1039, 6443, 3233, 31883, 24861, 5103}},
    {7556, 17, 15563, {1, 3, 5, 3, 13, 1, 61, 81, 361, 689, 1901, 1425, 5697, 15467, 4417, 23017, 28021}},
    {7557, 17, 15574, {1, 3, 5, 3, 3, 17, 5, 21, 37, 971, 53, 471, 5641, 2507, 32367, 46651, 24237}},
    {7558, 17, 15578, {1, 1, 7, 7, 13, 47, 45, 101, 491, 21, 1523, 3921, 4673, 5587, 20761, 581, 78989}},
    {7559, 17, 15584, {1, 1, 1, 5, 7, 43, 125, 41, 185, 53, 457, 2611, 661, 8727, 19873, 43729, 112831}},
    {7560, 17, 15593, {1, 1, 3, 9, 3, 21, 73, 67, 71, 691, 1189, 3251, 2587, 12221, 3375, 31147, 107333}},
    {7561, 17, 15604, {1, 1, 5, 3, 9, 53, 37, 109, 373, 215, 557, 2459, 6071, 14607, 28427, 16225, 104215}},
    {7562, 17, 15614, {1, 3, 7, 3, 13, 49, 77, 99, 347, 1019, 1811, 393, 3689, 5585, 23149, 46693, 81095}},
    {7563, 17, 15619, {1, 3, 5, 13, 13, 11, 127, 77, 257, 515, 707, 2391, 4215, 7337, 28815, 55713, 35731}},
    {7564, 17, 15622, {1, 1, 3, 15, 17, 21, 65, 173, 361, 193, 345, 2867, 485, 31, 32197, 42943, 39839}},
    {7565, 17, 15633, {1, 3, 3, 15, 19, 23, 5, 21, 255, 273, 1543, 3229, 6329, 6177, 27619, 29089, 25505}},
    {7566, 17, 15639, {1, 1, 7, 9, 3, 31, 25, 59, 43, 599, 1835, 2787, 717, 14189, 27097, 15965, 6759}},
    {7567, 17, 15646, {1, 3, 7, 7, 3, 53, 17, 89, 459, 481, 457, 2643, 823, 15087, 20843, 47259, 76825}},
    {7568, 17, 15673, {1, 3, 3, 1, 15, 21, 91, 173, 299, 81, 753, 4047, 4353, 5813, 13421, 4975, 93347}},
    {7569, 17, 15674, {1, 3, 1, 11, 19, 53, 5, 167, 459, 865, 635, 613, 5929, 1893, 6303, 199, 119597}},
    {7570, 17, 15684, {1, 1, 7, 9, 11, 17, 97, 97, 425, 767, 1203, 131, 5519, 11979, 13731, 28949, 61463}},
    {7571, 17, 15691, {1, 3, 5, 5, 31, 29, 117, 193, 253, 193, 1667, 3051, 4751, 2307, 32761, 52539, 32331}},
    {7572, 17, 15694, {1, 1, 1, 9, 25, 39, 3, 69, 341, 755, 1153, 159, 4411, 6849, 10287, 49841, 26849}},
    {7573, 17, 15696, {1, 3, 3, 13, 3, 25, 101, 61, 267, 523, 1355, 1991, 8113, 4467, 2285, 58123, 94261}},
    {7574, 17, 15701, {1, 1, 5, 1, 21, 59, 91, 209, 149, 299, 1359, 433, 1073, 3001, 21149, 30731, 116683}},
    {7575, 17, 15705, {1, 1, 7, 3, 27, 55, 37, 35, 85, 311, 1763, 3805, 3083, 14013, 27943, 7489, 106503}},
    {7576, 17, 15715, {1, 3, 1, 1, 15, 17, 19, 5, 213, 737, 989, 2621, 2337, 3513, 16051, 60427, 107325}},
    {7577, 17, 15729, {1, 1, 5, 13, 27, 1, 59, 85, 387, 679, 1559, 1781, 3731, 1983, 12999, 8105, 50299}},
    {7578, 17, 15730, {1, 1, 1, 15, 3, 29, 13, 99, 457, 563, 1597, 1827, 1927, 13789, 6717, 2079, 48443}},
    {7579, 17, 15741, {1, 3, 5, 5, 11, 3, 93, 193, 207, 191, 1155, 4075, 4835, 12047, 26631, 12267, 17763}},
    {7580, 17, 15745, {1, 1, 5, 11, 21, 45, 1, 19, 399, 703, 363, 2759, 1493, 1407, 211, 11477, 10321}},
    {7581, 17, 15748, {1, 3, 5, 15, 29, 47, 115, 101, 183, 47, 1845, 655, 137, 12049, 3631, 9003, 86803}},
    {7582, 17, 15757, {1, 1, 5, 3, 29, 59, 7, 25, 157, 695, 1159, 4055, 2671, 4277, 12709, 45993, 86187}},
    {7583, 17, 15765, {1, 1, 1, 5, 27, 49, 87, 95, 257, 861, 1127, 2233, 2595, 10489, 11977, 39713, 103599}},
    {7584, 17, 15766, {1, 3, 7, 7, 7, 23, 23, 57, 371, 433, 1987, 2611, 2145, 7085, 24369, 41555, 57325}},
    {7585, 17, 15775, {1, 3, 5, 11, 31, 19, 69, 17, 17, 423, 97, 655, 3225, 6475, 21493, 48505, 95519}},
    {7586, 17, 15776, {1, 1, 1, 7, 27, 55, 63, 125, 27, 657, 1495, 2637, 5483, 13311, 29301, 59851, 72375}},
    {7587, 17, 15779, {1, 3, 3, 15, 17, 43, 33, 235, 115, 769, 1291, 1359, 3303, 7955, 22397, 23403, 50561}},
    {7588, 17, 15786, {1, 3, 1, 3, 1, 49, 55, 11, 97, 259, 1461, 1751, 2011, 6845, 11725, 43363, 37257}},
    {7589, 17, 15788, {1, 1, 3, 3, 21, 9, 23, 37, 275, 747, 161, 3869, 6387, 9191, 22225, 38885, 35459}},
    {7590, 17, 15813, {1, 3, 3, 3, 19, 13, 29, 57, 87, 889, 721, 535, 3635, 1769, 9569, 63171, 130773}},
    {7591, 17, 15814, {1, 1, 7, 1, 17, 43, 11, 211, 457, 209, 543, 3753, 4461, 12321, 13215, 8185, 917}},
    {7592, 17, 15842, {1, 3, 1, 15, 31, 19, 79, 67, 139, 485, 571, 639, 8179, 8389, 21727, 61209, 63523}},
    {7593, 17, 15851, {1, 1, 1, 7, 7, 21, 29, 23, 289, 621, 847, 3831, 3347, 6425, 23691, 14473, 57977}},
    {7594, 17, 15862, {1, 1, 1, 15, 1, 29, 55, 13, 177, 9, 915, 1841, 5835, 449, 31391, 43043, 100549}},
    {7595, 17, 15875, {1, 3, 5, 3, 15, 43, 109, 229, 189, 33, 1941, 2269, 5351, 8315, 9291, 12727, 45575}},
    {7596, 17, 15878, {1, 3, 7, 15, 29, 15, 121, 217, 301, 751, 1403, 687, 4409, 2389, 11969, 42851, 27951}},
    {7597, 17, 15889, {1, 1, 7, 1, 1, 35, 21, 145, 181, 1023, 923, 3689, 5753, 10717, 2511, 31783, 2883}},
    {7598, 17, 15896, {1, 1, 3, 11, 1, 9, 63, 245, 425, 303, 1257, 4007, 1983, 4153, 21295, 36799, 89285}},
    {7599, 17, 15901, {1, 3, 1, 3, 3, 27, 103, 187, 381, 539, 1083, 3855, 2547, 3101, 15881, 29977, 56603}},
    {7600, 17, 15908, {1, 3, 3, 1, 15, 27, 77, 255, 15, 533, 1563, 939, 6199, 15971, 22411, 2075, 47137}},
    {7601, 17, 15911, {1, 1, 7, 13, 31, 37, 11, 81, 55, 399, 1709, 331, 833, 3313, 29417, 24219, 42697}},
    {7602, 17, 15915, {1, 1, 5, 13, 29, 53, 23, 237, 125, 603, 489, 3747, 651, 501, 8297, 45851, 41545}},
    {7603, 17, 15938, {1, 3, 5, 1, 15, 61, 121, 227, 67, 983, 2021, 4071, 6069, 14991, 2485, 1845, 64271}},
    {7604, 17, 15944, {1, 1, 7, 11, 19, 51, 91, 193, 95, 151, 575, 1627, 671, 8433, 14535, 21469, 103269}},
    {7605, 17, 15950, {1, 1, 1, 5, 19, 27, 1, 157, 13, 289, 1467, 3099, 325, 4067, 16035, 31635, 40369}},
    {7606, 17, 15955, {1, 3, 5, 5, 21, 25, 99, 89, 99, 957, 1409, 3965, 3665, 4611, 27583, 49533, 3701}},
    {7607, 17, 15974, {1, 1, 3, 9, 27, 39, 87, 153, 347, 645, 1485, 3783, 2303, 12047, 18457, 47789, 105631}},
    {7608, 17, 15978, {1, 1, 3, 7, 9, 13, 87, 243, 83, 957, 993, 1587, 3833, 3821, 17773, 15513, 101807}},
    {7609, 17, 15980, {1, 1, 3, 3, 5, 61, 13, 181, 347, 409, 547, 983, 4727, 9525, 12465, 16409, 18095}},
    {7610, 17, 15983, {1, 3, 3, 1, 7, 7, 39, 57, 201, 189, 1301, 269, 4061, 1299, 15433, 64891, 55287}},
    {7611, 17, 15991, {1, 3, 3, 1, 27, 5, 15, 147, 211, 927, 703, 4079, 3855, 2779, 12131, 11295, 20051}},
    {7612, 17, 16004, {1, 3, 1, 15, 3, 37, 63, 7, 481, 57, 363, 1447, 4685, 8819, 2579, 64645, 11469}},
    {7613, 17, 16011, {1, 1, 5, 9, 29, 13, 95, 195, 243, 607, 1553, 1751, 2489, 7005, 30385, 50977, 103615}},
    {7614, 17, 16016, {1, 3, 3, 3, 5, 53, 125, 69, 255, 955, 375, 3307, 6383, 10285, 14733, 24067, 26051}},
    {7615, 17, 16019, {1, 3, 3, 1, 13, 25, 7, 189, 91, 949, 1685, 431, 1817, 7737, 21323, 44875, 1561}},
    {7616, 17, 16025, {1, 3, 3, 1, 1, 27, 101, 181, 205, 849, 1175, 1465, 4809, 1459, 24807, 50929, 25049}},
    {7617, 17, 16041, {1, 1, 7, 3, 25, 23, 3, 57, 511, 311, 1551, 103, 6627, 15113, 9169, 40781, 61573}},
    {7618, 17, 16064, {1, 3, 7, 9, 5, 57, 117, 191, 493, 647, 1577, 2343, 2419, 2591, 4337, 52857, 8271}},
    {7619, 17, 16067, {1, 1, 7, 15, 19, 19, 97, 33, 155, 827, 899, 883, 1469, 6899, 6461, 63071, 103185}},
    {7620, 17, 16074, {1, 3, 5, 3, 21, 43, 33, 33, 201, 979, 1219, 65, 6269, 13365, 16667, 50997, 104101}},
    {7621, 17, 16082, {1, 1, 7, 9, 5, 3, 91, 11, 305, 297, 1895, 2851, 7157, 12289, 19543, 48197, 62265}},
    {7622, 17, 16103, {1, 3, 5, 15, 9, 57, 125, 171, 225, 863, 499, 213, 5703, 9409, 10309, 45083, 11275}},
    {7623, 17, 16109, {1, 1, 7, 3, 17, 41, 9, 11, 147, 959, 1201, 2323, 7107, 2855, 14105, 30661, 47}},
    {7624, 17, 16122, {1, 3, 5, 3, 11, 27, 55, 65, 81, 459, 1897, 1641, 4339, 1451, 21383, 51479, 31367}},
    {7625, 17, 16149, {1, 1, 5, 15, 15, 25, 33, 191, 461, 549, 489, 467, 2187, 3759, 26571, 58775, 67897}},
    {7626, 17, 16170, {1, 3, 5, 11, 11, 29, 125, 239, 103, 707, 1431, 1829, 4683, 7729, 4765, 10365, 122853}},
    {7627, 17, 16175, {1, 3, 3, 3, 9, 51, 125, 175, 321, 303, 1269, 497, 7809, 15323, 10615, 18073, 60735}},
    {7628, 17, 16178, {1, 1, 7, 13, 27, 51, 27, 167, 339, 313, 465, 289, 4655, 13251, 15767, 31605, 55671}},
    {7629, 17, 16189, {1, 1, 1, 3, 9, 51, 107, 129, 77, 165, 1729, 3661, 831, 41, 13467, 45411, 113065}},
    {7630, 17, 16202, {1, 1, 7, 9, 9, 9, 109, 19, 421, 97, 751, 3889, 3319, 14581, 25195, 13753, 113961}},
    {7631, 17, 16204, {1, 3, 1, 1, 5, 51, 77, 41, 275, 229, 1847, 3557, 3769, 1439, 24721, 38255, 92605}},
    {7632, 17, 16222, {1, 3, 1, 1, 7, 63, 105, 139, 167, 375, 1065, 2109, 1241, 8745, 11137, 19945, 82233}},
    {7633, 17, 16231, {1, 1, 7, 5, 15, 3, 27, 149, 469, 527, 1167, 3313, 5579, 8533, 26325, 30437, 72849}},
    {7634, 17, 16238, {1, 1, 3, 1, 11, 25, 11, 151, 111, 607, 985, 3505, 1593, 6133, 31859, 55443, 59147}},
    {7635, 17, 16262, {1, 1, 3, 5, 9, 33, 39, 53, 203, 419, 937, 1127, 7139, 14635, 17709, 49421, 78787}},
    {7636, 17, 16265, {1, 3, 7, 1, 17, 11, 67, 81, 59, 925, 1843, 3895, 4457, 8143, 2289, 32683, 114197}},
    {7637, 17, 16276, {1, 1, 5, 7, 21, 27, 99, 217, 31, 125, 1923, 159, 6947, 11413, 7389, 25419, 70281}},
    {7638, 17, 16285, {1, 3, 1, 5, 17, 29, 27, 57, 285, 257, 1675, 1405, 7175, 10003, 1445, 41049, 14355}},
    {7639, 17, 16313, {1, 1, 5, 15, 1, 21, 105, 243, 45, 943, 1851, 4049, 4595, 2493, 13855, 30341, 110635}},
    {7640, 17, 16314, {1, 3, 3, 5, 31, 49, 121, 65, 275, 589, 1139, 573, 4929, 14321, 8307, 42099, 68735}},
    {7641, 17, 16321, {1, 1, 7, 3, 5, 13, 35, 1, 303, 53, 1973, 3351, 3387, 13743, 8573, 38101, 51401}},
    {7642, 17, 16327, {1, 1, 1, 7, 9, 7, 125, 105, 187, 165, 211, 3457, 6489, 7297, 18491, 8729, 2261}},
    {7643, 17, 16333, {1, 1, 1, 11, 23, 35, 49, 243, 353, 789, 1331, 1211, 1961, 2327, 19499, 43291, 74069}},
    {7644, 17, 16334, {1, 3, 5, 5, 23, 25, 87, 15, 273, 1019, 1483, 2713, 3947, 10071, 23581, 13589, 35445}},
    {7645, 17, 16364, {1, 1, 1, 9, 23, 25, 127, 157, 67, 679, 1797, 531, 7479, 4353, 10333, 19339, 7683}},
    {7646, 17, 16369, {1, 3, 3, 9, 31, 63, 93, 133, 269, 203, 461, 667, 1949, 7317, 4591, 19789, 3789}},
    {7647, 17, 16370, {1, 3, 1, 3, 11, 27, 113, 37, 463, 31, 687, 929, 2739, 155, 3187, 18967, 37389}},
    {7648, 17, 16375, {1, 3, 1, 7, 19, 45, 107, 19, 427, 295, 587, 1987, 3757, 11413, 9331, 56339, 62755}},
    {7649, 17, 16376, {1, 1, 7, 11, 23, 19, 57, 169, 237, 261, 1211, 3087, 4951, 6269, 5419, 16569, 106509}},
    {7650, 17, 16379, {1, 1, 5, 5, 29, 59, 87, 217, 51, 921, 1981, 3017, 79, 13917, 26491, 37011, 32859}},
    {7651, 17, 16393, {1, 1, 7, 1, 21, 31, 23, 123, 371, 149, 1977, 3131, 4879, 15241, 26757, 20227, 26089}},
    {7652, 17, 16402, {1, 3, 7, 7, 27, 9, 25, 1, 7, 357, 939, 115, 1753, 6245, 2997, 61855, 25951}},
    {7653, 17, 16408, {1, 1, 1, 11, 19, 53, 1, 53, 241, 411, 819, 1697, 1901, 2409, 31077, 13889, 111557}},
    {7654, 17, 16418, {1, 3, 7, 5, 31, 19, 87, 199, 431, 621, 465, 2855, 143, 9439, 24075, 15655, 91145}},
    {7655, 17, 16438, {1, 1, 7, 13, 9, 59, 87, 223, 99, 147, 745, 1991, 5379, 12967, 9617, 5391, 68759}},
    {7656, 17, 16441, {1, 3, 5, 9, 15, 3, 99, 179, 33, 951, 1183, 1587, 5723, 6911, 6887, 1475, 116289}},
    {7657, 17, 16447, {1, 1, 1, 1, 15, 19, 13, 143, 65, 101, 425, 2651, 635, 13703, 16039, 34425, 75941}},
    {7658, 17, 16450, {1, 1, 3, 1, 25, 23, 3, 187, 75, 777, 679, 4003, 615, 7723, 2661, 52743, 21855}},
    {7659, 17, 16455, {1, 3, 7, 1, 17, 47, 111, 7, 265, 609, 1471, 3055, 5441, 9955, 14917, 13905, 76917}},
    {7660, 17, 16459, {1, 1, 5, 15, 7, 43, 105, 191, 431, 141, 1893, 633, 5063, 8051, 5349, 23773, 122333}},
    {7661, 17, 16483, {1, 1, 7, 3, 25, 49, 97, 125, 261, 789, 1183, 655, 7387, 13101, 9193, 35505, 90733}},
    {7662, 17, 16490, {1, 1, 3, 3, 1, 15, 99, 79, 399, 285, 1657, 317, 4729, 2723, 31879, 32543, 37981}},
    {7663, 17, 16492, {1, 1, 5, 3, 31, 63, 53, 219, 401, 593, 1041, 3159, 3431, 9387, 13979, 23879, 38101}},
    {7664, 17, 16495, {1, 3, 1, 7, 13, 31, 51, 69, 303, 95, 1993, 2713, 2273, 15599, 22335, 49627, 35995}},
    {7665, 17, 16523, {1, 1, 5, 3, 17, 23, 55, 237, 425, 969, 1975, 1381, 7177, 11221, 14545, 2323, 43777}},
    {7666, 17, 16528, {1, 1, 1, 1, 23, 9, 113, 115, 113, 289, 9, 3937, 7937, 8553, 8841, 62839, 112995}},
    {7667, 17, 16543, {1, 3, 3, 15, 31, 3, 11, 51, 97, 707, 1487, 2267, 1979, 12065, 1027, 55323, 114531}},
    {7668, 17, 16553, {1, 3, 3, 7, 21, 33, 51, 29, 461, 11, 1613, 3359, 7643, 9115, 23175, 9335, 91479}},
    {7669, 17, 16562, {1, 3, 7, 7, 9, 41, 115, 165, 275, 811, 1243, 3011, 3723, 1533, 13359, 17655, 90035}},
    {7670, 17, 16564, {1, 3, 1, 1, 17, 55, 29, 9, 63, 355, 1423, 4025, 7685, 7929, 19033, 42075, 66833}},
    {7671, 17, 16576, {1, 1, 7, 9, 9, 55, 91, 165, 99, 669, 1493, 2151, 5279, 6115, 8275, 40999, 80229}},
    {7672, 17, 16588, {1, 1, 1, 3, 31, 25, 89, 209, 75, 251, 1685, 2853, 1291, 15407, 20587, 64703, 107033}},
    {7673, 17, 16612, {1, 1, 3, 7, 15, 53, 55, 81, 47, 935, 205, 1137, 2107, 8279, 18883, 24409, 127157}},
    {7674, 17, 16630, {1, 3, 3, 13, 17, 49, 47, 169, 397, 213, 217, 2249, 4809, 14181, 15489, 35127, 58927}},
    {7675, 17, 16654, {1, 3, 7, 3, 11, 61, 7, 37, 465, 675, 441, 3435, 2231, 1895, 26569, 53555, 95829}},
    {7676, 17, 16656, {1, 3, 1, 7, 31, 15, 79, 13, 203, 451, 1235, 2497, 287, 7857, 7693, 63511, 66921}},
    {7677, 17, 16668, {1, 3, 3, 3, 27, 37, 53, 207, 73, 633, 577, 1333, 5825, 10013, 2585, 47431, 45381}},
    {7678, 17, 16672, {1, 3, 1, 1, 15, 29, 43, 93, 7, 825, 1421, 1803, 721, 15935, 18147, 26191, 29115}},
    {7679, 17, 16675, {1, 1, 1, 13, 13, 19, 7, 169, 365, 429, 1999, 357, 2399, 14083, 29167, 2175, 99905}},
    {7680, 17, 16678, {1, 1, 5, 7, 5, 63, 63, 113, 131, 189, 1499, 3679, 6241, 13769, 26433, 52735, 99993}},
    {7681, 17, 16681, {1, 3, 3, 3, 1, 51, 25, 31, 445, 663, 1333, 3853, 5535, 10243, 15033, 56079, 44687}},
    {7682, 17, 16689, {1, 1, 3, 13, 25, 15, 65, 49, 121, 191, 1167, 2897, 1959, 14899, 8833, 30835, 55505}},
    {7683, 17, 16699, {1, 1, 3, 5, 31, 39, 11, 13, 467, 837, 2007, 1051, 6529, 9723, 24041, 27341, 45095}},
    {7684, 17, 16719, {1, 3, 7, 5, 3, 49, 7, 75, 257, 481, 1659, 3745, 5691, 11879, 26271, 31893, 94257}},
    {7685, 17, 16734, {1, 1, 1, 3, 1, 35, 35, 149, 449, 979, 1957, 255, 7917, 14437, 291, 32507, 118457}},
    {7686, 17, 16737, {1, 3, 1, 7, 7, 35, 33, 189, 103, 37, 1397, 2293, 3679, 13439, 1537, 21311, 10533}},
    {7687, 17, 16750, {1, 1, 5, 1, 5, 49, 107, 111, 277, 917, 283, 2617, 5639, 9507, 28139, 51803, 122105}},
    {7688, 17, 16752, {1, 1, 7, 15, 3, 15, 59, 161, 251, 455, 37, 1479, 5803, 525, 16177, 50977, 114807}},
    {7689, 17, 16757, {1, 3, 3, 3, 11, 53, 51, 215, 461, 743, 871, 2273, 1113, 14593, 6539, 42919, 48355}},
    {7690, 17, 16761, {1, 1, 7, 5, 31, 11, 53, 153, 257, 891, 1049, 1245, 5131, 6355, 30029, 35047, 89077}},
    {7691, 17, 16773, {1, 1, 5, 11, 5, 5, 9, 201, 257, 67, 661, 991, 1577, 8101, 19127, 64797, 82323}},
    {7692, 17, 16774, {1, 1, 1, 13, 1, 17, 31, 117, 97, 659, 89, 1249, 305, 4807, 14505, 29775, 73547}},
    {7693, 17, 16801, {1, 3, 3, 7, 1, 37, 91, 165, 5, 575, 1455, 1721, 4659, 2759, 28701, 45497, 114243}},
    {7694, 17, 16802, {1, 3, 3, 5, 19, 45, 9, 117, 481, 481, 367, 1915, 1721, 29, 6893, 44157, 125941}},
    {7695, 17, 16822, {1, 3, 3, 11, 19, 5, 7, 121, 163, 41, 493, 1767, 273, 13187, 14329, 64139, 122321}},
    {7696, 17, 16831, {1, 1, 7, 11, 15, 3, 1, 83, 493, 657, 1363, 3305, 6679, 13437, 4181, 54057, 59697}},
    {7697, 17, 16840, {1, 1, 3, 9, 15, 27, 57, 123, 227, 311, 869, 2559, 1395, 8371, 26209, 15189, 62877}},
    {7698, 17, 16854, {1, 1, 5, 3, 11, 59, 19, 125, 173, 793, 541, 3023, 1573, 3889, 32415, 15523, 15373}},
    {7699, 17, 16858, {1, 1, 1, 9, 15, 3, 83, 175, 155, 951, 223, 771, 2159, 15627, 20501, 30819, 119775}},
    {7700, 17, 16863, {1, 3, 5, 7, 19, 53, 109, 91, 495, 837, 1995, 2207, 4425, 14927, 13795, 46567, 41407}},
    {7701, 17, 16867, {1, 3, 3, 1, 3, 31, 115, 129, 273, 25, 1245, 2759, 5055, 12931, 5933, 17273, 103729}},
    {7702, 17, 16876, {1, 3, 7, 1, 25, 63, 89, 51, 35, 7, 725, 3975, 5923, 2235, 10007, 36433, 99819}},
    {7703, 17, 16891, {1, 1, 1, 7, 25, 17, 59, 159, 301, 873, 497, 2917, 4235, 2573, 11341, 43107, 12107}},
    {7704, 17, 16894, {1, 1, 3, 7, 3, 29, 51, 31, 153, 3, 1915, 2731, 283, 15873, 28087, 60445, 9399}},
    {7705, 17, 16898, {1, 3, 1, 15, 3, 29, 75, 221, 299, 1003, 1865, 1331, 6187, 5549, 17913, 60257, 19627}},
    {7706, 17, 16907, {1, 3, 5, 15, 3, 11, 87, 213, 1, 467, 333, 1621, 6031, 13061, 16511, 15259, 87679}},
    {7707, 17, 16915, {1, 3, 3, 7, 11, 51, 85, 243, 47, 267, 321, 25, 1629, 7899, 28235, 53399, 104471}},
    {7708, 17, 16917, {1, 3, 5, 11, 9, 5, 61, 7, 421, 861, 1981, 2995, 1419, 3679, 2163, 33005, 79917}},
    {7709, 17, 16922, {1, 3, 3, 7, 7, 15, 95, 151, 393, 955, 1949, 3421, 4325, 7003, 3057, 57357, 21435}},
    {7710, 17, 16924, {1, 1, 1, 1, 9, 47, 59, 157, 317, 1003, 1699, 433, 2935, 15677, 24395, 45021, 11905}},
    {7711, 17, 16933, {1, 1, 5, 13, 31, 31, 7, 11, 251, 611, 2045, 3021, 6745, 12315, 29025, 32359, 3101}},
    {7712, 17, 16938, {1, 1, 7, 5, 17, 29, 63, 173, 153, 877, 1011, 81, 5665, 7077, 2109, 13625, 59033}},
    {7713, 17, 16952, {1, 1, 3, 11, 21, 13, 25, 235, 377, 377, 49, 1835, 359, 2205, 10721, 25191, 109119}},
    {7714, 17, 16960, {1, 1, 1, 1, 13, 43, 5, 113, 95, 835, 1705, 2127, 2383, 11959, 10633, 62829, 110217}},
    {7715, 17, 16963, {1, 3, 3, 7, 23, 35, 43, 215, 467, 141, 1525, 3831, 2827, 845, 31403, 54187, 21137}},
    {7716, 17, 16969, {1, 1, 5, 13, 3, 7, 73, 253, 103, 159, 917, 3515, 3845, 15611, 23227, 41307, 42113}},
    {7717, 17, 16978, {1, 3, 1, 7, 5, 45, 69, 59, 149, 97, 1795, 2263, 2939, 5775, 15437, 60965, 109207}},
    {7718, 17, 17014, {1, 3, 5, 15, 19, 17, 111, 53, 233, 883, 1143, 2785, 2293, 12433, 22455, 3103, 96481}},
    {7719, 17, 17020, {1, 3, 1, 7, 13, 49, 123, 185, 255, 865, 2011, 751, 4457, 1785, 1091, 52771, 111329}},
    {7720, 17, 17034, {1, 1, 1, 1, 1, 59, 75, 237, 163, 331, 251, 939, 4105, 647, 21249, 23917, 6717}},
    {7721, 17, 17036, {1, 1, 3, 11, 5, 11, 1, 165, 297, 483, 1663, 3229, 3965, 3569, 32619, 57801, 85405}},
    {7722, 17, 17042, {1, 3, 7, 11, 7, 19, 113, 189, 369, 629, 1021, 1709, 7081, 5541, 9911, 43947, 57227}},
    {7723, 17, 17047, {1, 3, 1, 3, 17, 53, 39, 43, 165, 313, 829, 2711, 769, 12045, 28925, 65463, 125729}},
    {7724, 17, 17051, {1, 3, 5, 13, 15, 51, 123, 217, 399, 337, 1611, 2017, 699, 12523, 6151, 34559, 116831}},
    {7725, 17, 17054, {1, 1, 3, 13, 15, 37, 49, 135, 65, 759, 1787, 3513, 971, 4225, 731, 23367, 79989}},
    {7726, 17, 17063, {1, 1, 7, 5, 7, 33, 27, 57, 321, 57, 239, 3007, 7923, 8903, 85, 32931, 21845}},
    {7727, 17, 17069, {1, 3, 5, 1, 17, 57, 21, 169, 499, 165, 949, 1659, 3785, 2307, 24429, 17389, 66957}},
    {7728, 17, 17075, {1, 3, 3, 1, 31, 49, 49, 193, 47, 785, 647, 1329, 5263, 5171, 32273, 54747, 120363}},
    {7729, 17, 17077, {1, 3, 7, 7, 23, 37, 79, 153, 89, 959, 1435, 3457, 6359, 10121, 31535, 11051, 102307}},
    {7730, 17, 17089, {1, 3, 3, 3, 29, 51, 123, 219, 285, 841, 1645, 3753, 3259, 9331, 26201, 32631, 69637}},
    {7731, 17, 17090, {1, 3, 7, 9, 9, 21, 11, 33, 37, 967, 249, 3171, 6777, 7483, 15371, 31943, 76073}},
    {7732, 17, 17107, {1, 3, 3, 5, 3, 13, 61, 71, 349, 15, 691, 2807, 5057, 15759, 16069, 50675, 66223}},
    {7733, 17, 17126, {1, 3, 1, 1, 29, 55, 1, 241, 95, 795, 897, 709, 711, 12607, 31289, 38323, 106421}},
    {7734, 17, 17135, {1, 1, 5, 3, 19, 11, 55, 85, 359, 413, 59, 3519, 7257, 387, 23557, 22999, 26027}},
    {7735, 17, 17150, {1, 3, 3, 11, 31, 47, 109, 211, 251, 251, 233, 2491, 2267, 979, 28987, 64743, 22787}},
    {7736, 17, 17162, {1, 1, 3, 3, 3, 49, 39, 85, 351, 125, 1651, 2241, 5389, 6041, 31063, 39735, 2341}},
    {7737, 17, 17169, {1, 3, 3, 11, 27, 29, 31, 235, 21, 751, 1947, 1555, 719, 3271, 19743, 40267, 105133}},
    {7738, 17, 17172, {1, 1, 3, 15, 21, 3, 101, 221, 279, 999, 1563, 121, 3139, 11169, 29693, 64259, 38177}},
    {7739, 17, 17175, {1, 3, 3, 9, 15, 47, 43, 139, 371, 865, 2029, 2013, 679, 10323, 3869, 51439, 3231}},
    {7740, 17, 17176, {1, 3, 5, 15, 27, 53, 37, 3, 447, 761, 1539, 33, 4709, 2673, 11947, 46753, 6307}},
    {7741, 17, 17191, {1, 3, 7, 15, 21, 39, 31, 193, 141, 787, 1371, 1103, 169, 4353, 25235, 43943, 56837}},
    {7742, 17, 17209, {1, 1, 3, 13, 7, 37, 105, 171, 35, 977, 1519, 3415, 5521, 7961, 22829, 21393, 16095}},
    {7743, 17, 17218, {1, 3, 1, 3, 27, 61, 85, 167, 275, 285, 1, 919, 6439, 3331, 9483, 46613, 89019}},
    {7744, 17, 17220, {1, 3, 1, 13, 5, 43, 23, 179, 277, 891, 1165, 1489, 4201, 5573, 31557, 56653, 52003}},
    {7745, 17, 17227, {1, 3, 1, 7, 11, 63, 71, 207, 243, 21, 1655, 3559, 4171, 13407, 10967, 40477, 92253}},
    {7746, 17, 17229, {1, 3, 5, 7, 25, 11, 113, 175, 141, 707, 767, 805, 4533, 12323, 20133, 57451, 60203}},
    {7747, 17, 17238, {1, 3, 7, 15, 17, 51, 87, 213, 321, 849, 11, 2417, 2603, 12065, 23637, 861, 68785}},
    {7748, 17, 17251, {1, 1, 1, 7, 15, 33, 121, 71, 433, 959, 187, 909, 2099, 9899, 2777, 1873, 18635}},
    {7749, 17, 17257, {1, 3, 7, 9, 23, 27, 19, 201, 195, 491, 1667, 3865, 6837, 7363, 32119, 14627, 110175}},
    {7750, 17, 17258, {1, 3, 3, 15, 21, 43, 125, 177, 55, 179, 651, 2727, 3765, 7625, 27111, 35211, 118113}},
    {7751, 17, 17272, {1, 1, 3, 15, 5, 25, 53, 183, 243, 371, 1897, 3431, 2299, 10057, 21437, 11941, 77035}},
    {7752, 17, 17277, {1, 1, 3, 9, 15, 49, 123, 175, 339, 347, 1907, 4075, 7813, 1945, 23203, 50923, 102467}},
    {7753, 17, 17308, {1, 1, 1, 13, 25, 1, 53, 221, 35, 297, 339, 3127, 809, 2411, 19855, 29329, 47427}},
    {7754, 17, 17311, {1, 1, 5, 11, 23, 35, 127, 27, 259, 473, 1935, 913, 3715, 11921, 28599, 8033, 35521}},
    {7755, 17, 17321, {1, 3, 1, 13, 25, 55, 67, 245, 269, 853, 2021, 2453, 4975, 7271, 29321, 25745, 72345}},
    {7756, 17, 17329, {1, 3, 7, 5, 5, 43, 89, 157, 377, 815, 1573, 3875, 5317, 12119, 31427, 21969, 16959}},
    {7757, 17, 17342, {1, 1, 5, 3, 5, 51, 67, 143, 225, 405, 1179, 3111, 529, 16107, 2663, 3651, 123387}},
    {7758, 17, 17344, {1, 1, 3, 9, 25, 59, 27, 115, 337, 79, 1253, 141, 1603, 1625, 21531, 61691, 82209}},
    {7759, 17, 17350, {1, 1, 1, 11, 19, 33, 53, 57, 231, 639, 1061, 4095, 6761, 4625, 25661, 44077, 36583}},
    {7760, 17, 17356, {1, 3, 1, 5, 9, 49, 83, 171, 347, 251, 1627, 1035, 6811, 11831, 6269, 21113, 75503}},
    {7761, 17, 17371, {1, 1, 1, 9, 5, 31, 119, 177, 211, 819, 867, 2859, 6313, 3471, 13581, 21263, 56281}},
    {7762, 17, 17374, {1, 1, 5, 7, 21, 57, 53, 21, 195, 743, 709, 2877, 1651, 4539, 28891, 25699, 91003}},
    {7763, 17, 17392, {1, 3, 5, 3, 13, 55, 23, 53, 133, 985, 1051, 1891, 3447, 3173, 3849, 10167, 19889}},
    {7764, 17, 17402, {1, 3, 1, 7, 15, 61, 101, 131, 13, 87, 1457, 2131, 4267, 13487, 15553, 6283, 118209}},
    {7765, 17, 17410, {1, 3, 3, 13, 27, 61, 113, 1, 449, 449, 1707, 3893, 2861, 11287, 17973, 52101, 37989}},
    {7766, 17, 17421, {1, 1, 3, 9, 1, 7, 75, 95, 267, 743, 1695, 2265, 845, 15755, 17067, 13251, 92735}},
    {7767, 17, 17424, {1, 3, 5, 9, 5, 37, 29, 35, 155, 167, 35, 2315, 2317, 12349, 26599, 18079, 62093}},
    {7768, 17, 17427, {1, 3, 3, 7, 7, 35, 45, 99, 111, 189, 1255, 759, 5977, 7249, 4535, 60993, 31313}},
    {7769, 17, 17434, {1, 3, 3, 13, 19, 1, 55, 91, 211, 543, 1687, 2801, 3473, 4587, 14447, 23227, 21147}},
    {7770, 17, 17449, {1, 1, 5, 7, 25, 1, 11, 255, 317, 461, 689, 1443, 6319, 8763, 4375, 59839, 70951}},
    {7771, 17, 17452, {1, 3, 1, 7, 3, 5, 113, 21, 337, 517, 1377, 3159, 3661, 109, 20671, 51393, 87569}},
    {7772, 17, 17463, {1, 1, 1, 5, 11, 31, 59, 131, 177, 157, 589, 2285, 6111, 15647, 25493, 28023, 96773}},
    {7773, 17, 17470, {1, 1, 5, 5, 5, 59, 107, 227, 221, 787, 1089, 249, 7241, 15669, 16009, 49687, 49077}},
    {7774, 17, 17477, {1, 1, 7, 1, 9, 59, 31, 61, 421, 191, 745, 3229, 7085, 12231, 27237, 58645, 125911}},
    {7775, 17, 17482, {1, 1, 1, 15, 19, 23, 67, 65, 143, 181, 557, 2985, 3, 13809, 14743, 6655, 129823}},
    {7776, 17, 17490, {1, 3, 3, 7, 17, 59, 51, 81, 145, 79, 809, 2423, 6053, 9313, 8615, 40137, 2331}},
    {7777, 17, 17496, {1, 3, 1, 1, 15, 17, 19, 5, 213, 737, 989, 2621, 2337, 3513, 16051, 60427, 107325}},
    {7778, 17, 17508, {1, 3, 7, 1, 29, 35, 81, 77, 507, 303, 815, 3815, 707, 15903, 13783, 49427, 116953}},
    {7779, 17, 17511, {1, 1, 3, 1, 25, 11, 59, 55, 287, 451, 1741, 2143, 2187, 735, 23997, 393, 125219}},
    {7780, 17, 17536, {1, 1, 1, 15, 25, 5, 13, 21, 325, 285, 1427, 3859, 2189, 14009, 7419, 30827, 109137}},
    {7781, 17, 17563, {1, 1, 5, 7, 1, 33, 79, 125, 99, 595, 389, 1473, 4005, 14147, 10625, 18841, 2971}},
    {7782, 17, 17570, {1, 1, 5, 9, 7, 35, 47, 171, 341, 919, 1405, 807, 455, 6275, 31119, 60873, 44229}},
    {7783, 17, 17581, {1, 3, 5, 1, 25, 43, 1, 249, 109, 281, 1959, 1243, 2107, 8967, 12407, 47497, 121801}},
    {7784, 17, 17590, {1, 1, 7, 3, 9, 33, 55, 205, 123, 147, 1267, 3963, 2443, 14385, 1889, 25277, 76453}},
    {7785, 17, 17608, {1, 1, 1, 3, 19, 41, 17, 59, 67, 879, 945, 2867, 1249, 15923, 2473, 1567, 35293}},
    {7786, 17, 17616, {1, 1, 1, 9, 27, 31, 97, 107, 291, 509, 25, 1483, 5511, 6421, 26175, 62663, 56113}},
    {7787, 17, 17621, {1, 1, 5, 7, 15, 63, 101, 207, 485, 899, 29, 229, 5755, 13759, 4423, 43745, 63673}},
    {7788, 17, 17628, {1, 3, 1, 3, 17, 33, 79, 165, 267, 217, 1363, 2075, 6249, 15547, 29633, 42343, 50645}},
    {7789, 17, 17644, {1, 3, 5, 15, 25, 1, 119, 97, 143, 671, 1903, 361, 791, 10437, 26263, 27759, 22739}},
    {7790, 17, 17649, {1, 3, 7, 1, 27, 41, 35, 175, 307, 571, 205, 2001, 3225, 7829, 5513, 57541, 50525}},
    {7791, 17, 17652, {1, 3, 5, 7, 7, 21, 5, 149, 85, 91, 1939, 1123, 3349, 12857, 9703, 44435, 31017}},
    {7792, 17, 17679, {1, 3, 3, 3, 7, 11, 75, 173, 167, 57, 1221, 769, 5045, 14901, 21227, 13263, 62555}},
    {7793, 17, 17691, {1, 1, 1, 15, 11, 23, 11, 213, 49, 109, 1261, 2065, 2233, 12151, 8761, 53477, 120241}},
    {7794, 17, 17693, {1, 3, 1, 7, 13, 45, 31, 233, 439, 981, 1569, 3877, 133, 2199, 12081, 12389, 45361}},
    {7795, 17, 17697, {1, 1, 1, 15, 11, 17, 55, 223, 335, 557, 533, 3383, 7231, 4579, 3627, 62911, 56387}},
    {7796, 17, 17698, {1, 3, 1, 1, 21, 63, 67, 157, 253, 39, 615, 1289, 303, 5663, 8791, 55031, 83871}},
    {7797, 17, 17700, {1, 3, 1, 13, 31, 59, 13, 95, 115, 841, 965, 2797, 1149, 7465, 7487, 49781, 119491}},
    {7798, 17, 17704, {1, 3, 7, 3, 15, 61, 81, 61, 29, 401, 45, 2795, 5445, 12329, 6849, 22029, 88631}},
    {7799, 17, 17707, {1, 1, 7, 3, 27, 1, 99, 183, 279, 247, 719, 1497, 1073, 2417, 16837, 8509, 30727}},
    {7800, 17, 17715, {1, 3, 3, 9, 5, 31, 3, 23, 315, 517, 131, 2539, 4309, 16319, 10523, 29993, 101985}},
    {7801, 17, 17718, {1, 1, 7, 11, 1, 9, 115, 221, 63, 455, 1241, 3379, 429, 12601, 6797, 53977, 61893}},
    {7802, 17, 17721, {1, 1, 3, 5, 31, 51, 11, 231, 247, 615, 71, 3527, 6597, 1311, 31795, 405, 80481}},
    {7803, 17, 17722, {1, 1, 1, 1, 13, 13, 1, 101, 297, 31, 393, 3917, 2767, 13793, 28953, 8401, 40847}},
    {7804, 17, 17727, {1, 1, 3, 5, 1, 45, 63, 219, 259, 549, 1839, 787, 1071, 3607, 21407, 34461, 120481}},
    {7805, 17, 17729, {1, 1, 7, 9, 29, 41, 79, 157, 215, 919, 897, 467, 6211, 13929, 20489, 42525, 108695}},
    {7806, 17, 17747, {1, 1, 3, 7, 23, 59, 81, 35, 407, 853, 1655, 2737, 6943, 4071, 31903, 47757, 118327}},
    {7807, 17, 17754, {1, 1, 3, 11, 7, 31, 105, 255, 35, 153, 1021, 3333, 6609, 9161, 9, 55355, 93109}},
    {7808, 17, 17756, {1, 3, 1, 15, 15, 3, 91, 223, 165, 927, 169, 1663, 2009, 1401, 3505, 34311, 95787}},
    {7809, 17, 17760, {1, 3, 1, 7, 17, 53, 79, 133, 485, 499, 609, 3127, 1059, 14307, 10053, 22349, 118621}},
    {7810, 17, 17765, {1, 3, 7, 1, 27, 3, 35, 189, 29, 637, 1621, 3733, 991, 8993, 27477, 14783, 120807}},
    {7811, 17, 17778, {1, 3, 1, 15, 13, 63, 61, 25, 405, 779, 315, 1799, 5037, 15041, 9309, 54955, 110435}},
    {7812, 17, 17784, {1, 1, 5, 7, 13, 1, 47, 149, 267, 85, 719, 1283, 4717, 14073, 265, 30323, 126331}},
    {7813, 17, 17794, {1, 3, 7, 11, 19, 13, 105, 199, 63, 339, 1231, 111, 6667, 9439, 23875, 20367, 6681}},
    {7814, 17, 17805, {1, 1, 3, 7, 15, 39, 123, 173, 323, 31, 1405, 1843, 1545, 3983, 26587, 29603, 52381}},
    {7815, 17, 17806, {1, 1, 3, 1, 31, 29, 51, 195, 171, 439, 753, 3855, 1457, 867, 1239, 54719, 8041}},
    {7816, 17, 17817, {1, 3, 3, 1, 7, 41, 17, 251, 371, 339, 1059, 1407, 8109, 5573, 12217, 38623, 83423}},
    {7817, 17, 17824, {1, 1, 1, 3, 1, 29, 37, 101, 325, 1013, 1459, 1645, 4651, 5227, 19535, 20693, 8383}},
    {7818, 17, 17839, {1, 1, 3, 7, 29, 57, 121, 245, 379, 879, 1173, 2273, 123, 4725, 21445, 33201, 106967}},
    {7819, 17, 17842, {1, 1, 7, 3, 3, 7, 81, 7, 257, 413, 895, 3063, 961, 12045, 1537, 13769, 128233}},
    {7820, 17, 17844, {1, 3, 5, 1, 5, 35, 79, 77, 41, 713, 1347, 3585, 4377, 8843, 573, 45257, 13445}},
    {7821, 17, 17851, {1, 3, 5, 1, 21, 41, 57, 31, 121, 759, 659, 255, 8161, 4799, 257, 30179, 111983}},
    {7822, 17, 17862, {1, 3, 7, 11, 27, 53, 47, 95, 465, 459, 253, 3577, 4449, 5099, 1635, 27935, 75501}},
    {7823, 17, 17868, {1, 1, 3, 7, 7, 3, 93, 69, 183, 9, 499, 2913, 3655, 6355, 22229, 5427, 128153}},
    {7824, 17, 17871, {1, 1, 5, 3, 31, 35, 51, 81, 365, 163, 1851, 671, 5659, 11863, 23727, 55549, 110975}},
    {7825, 17, 17873, {1, 3, 1, 15, 25, 29, 95, 25, 147, 965, 1055, 1967, 7417, 7427, 21557, 34033, 86077}},
    {7826, 17, 17896, {1, 3, 7, 15, 23, 3, 83, 111, 443, 325, 1383, 769, 1613, 6355, 16707, 32437, 47543}},
    {7827, 17, 17904, {1, 3, 1, 9, 27, 51, 109, 67, 351, 949, 987, 1013, 3979, 16279, 19949, 13129, 22177}},
    {7828, 17, 17909, {1, 1, 7, 3, 21, 51, 19, 143, 47, 429, 1889, 3441, 6157, 5415, 27435, 50299, 99113}},
    {7829, 17, 17920, {1, 3, 7, 15, 19, 31, 1, 127, 429, 845, 57, 1417, 1491, 9137, 11465, 37393, 32207}},
    {7830, 17, 17923, {1, 1, 7, 1, 29, 17, 63, 87, 481, 77, 1343, 1375, 7619, 9977, 15007, 3503, 33195}},
    {7831, 17, 17947, {1, 1, 3, 1, 9, 47, 25, 27, 99, 259, 419, 1633, 7349, 10435, 25669, 64447, 24471}},
    {7832, 17, 17950, {1, 1, 7, 11, 9, 55, 69, 117, 329, 685, 1373, 1427, 5275, 9801, 24091, 22015, 20873}},
    {7833, 17, 17956, {1, 3, 7, 7, 7, 41, 19, 101, 157, 851, 985, 3933, 2109, 3847, 14143, 59155, 67523}},
    {7834, 17, 17959, {1, 3, 1, 1, 7, 63, 105, 139, 167, 375, 1065, 2109, 1241, 8745, 11137, 19945, 82233}},
    {7835, 17, 17966, {1, 3, 5, 1, 21, 11, 33, 19, 33, 459, 1425, 3609, 7221, 13469, 10217, 1397, 102405}},
    {7836, 17, 17971, {1, 3, 5, 5, 29, 59, 79, 163, 173, 525, 781, 3397, 4623, 15833, 9259, 43607, 17609}},
    {7837, 17, 17973, {1, 1, 3, 5, 9, 33, 39, 53, 203, 419, 937, 1127, 7139, 14635, 17709, 49421, 78787}},
    {7838, 17, 17992, {1, 1, 7, 7, 29, 41, 17, 73, 155, 621, 1443, 3501, 3003, 1127, 30373, 1307, 379}},
    {7839, 17, 18006, {1, 1, 3, 15, 5, 41, 23, 69, 373, 801, 1479, 3097, 603, 9107, 25339, 60611, 51967}},
    {7840, 17, 18009, {1, 3, 1, 5, 25, 29, 107, 215, 469, 753, 1495, 1427, 2333, 5493, 283, 1541, 22611}},
    {7841, 17, 18010, {1, 3, 7, 15, 7, 29, 45, 51, 245, 987, 1755, 3397, 4251, 2977, 3809, 48671, 51899}},
    {7842, 17, 18022, {1, 1, 5, 9, 11, 41, 89, 131, 431, 113, 1367, 1087, 3859, 6945, 18743, 63243, 1655}},
    {7843, 17, 18039, {1, 1, 3, 13, 27, 49, 7, 139, 225, 111, 155, 2267, 1521, 8239, 13781, 41845, 53487}},
    {7844, 17, 18046, {1, 3, 3, 11, 9, 7, 107, 79, 399, 759, 1899, 3117, 7979, 14969, 28171, 32399, 43589}},
    {7845, 17, 18069, {1, 3, 7, 11, 13, 43, 63, 93, 309, 705, 583, 2927, 8163, 11089, 8437, 40631, 126709}},
    {7846, 17, 18074, {1, 3, 5, 5, 13, 3, 115, 177, 477, 877, 1103, 4087, 3979, 11303, 31015, 6001, 3939}},
    {7847, 17, 18076, {1, 1, 7, 1, 17, 25, 83, 213, 55, 121, 1439, 705, 3037, 10099, 8573, 4249, 77623}},
    {7848, 17, 18085, {1, 3, 5, 7, 27, 25, 19, 177, 499, 25, 493, 1065, 2245, 6413, 21959, 53825, 127291}},
    {7849, 17, 18086, {1, 1, 5, 7, 7, 35, 45, 31, 43, 823, 317, 2837, 615, 233, 31243, 31345, 44029}},
    {7850, 17, 18095, {1, 1, 7, 11, 23, 59, 51, 223, 185, 553, 831, 2629, 3037, 8909, 17773, 52367, 64181}},
    {7851, 17, 18100, {1, 1, 5, 1, 27, 7, 123, 171, 315, 795, 1547, 2819, 5705, 319, 13905, 43137, 47451}},
    {7852, 17, 18109, {1, 1, 5, 13, 1, 27, 115, 155, 35, 997, 1347, 4001, 8051, 7567, 4221, 63915, 88615}},
    {7853, 17, 18121, {1, 3, 5, 1, 9, 59, 1, 147, 499, 69, 1777, 1541, 1751, 7213, 29101, 41935, 116001}},
    {7854, 17, 18127, {1, 3, 1, 1, 31, 3, 45, 211, 237, 835, 1557, 1259, 3993, 12945, 31631, 42531, 77203}},
    {7855, 17, 18129, {1, 3, 3, 5, 31, 19, 99, 151, 41, 937, 1973, 3183, 7001, 4039, 31723, 12193, 58025}},
    {7856, 17, 18132, {1, 3, 7, 5, 31, 19, 87, 199, 431, 621, 465, 2855, 143, 9439, 24075, 15655, 91145}},
    {7857, 17, 18141, {1, 3, 5, 9, 25, 45, 71, 199, 191, 299, 765, 1801, 925, 12087, 2409, 18067, 89207}},
    {7858, 17, 18146, {1, 1, 1, 3, 15, 23, 93, 37, 449, 907, 955, 4019, 597, 7349, 27133, 37331, 119235}},
    {7859, 17, 18151, {1, 3, 7, 7, 25, 43, 93, 211, 197, 449, 1483, 3043, 1327, 14135, 15547, 35161, 94057}},
    {7860, 17, 18157, {1, 1, 1, 15, 23, 37, 113, 117, 381, 983, 1915, 1229, 167, 1895, 26951, 46857, 105203}},
    {7861, 17, 18160, {1, 3, 7, 1, 17, 47, 111, 7, 265, 609, 1471, 3055, 5441, 9955, 14917, 13905, 76917}},
    {7862, 17, 18183, {1, 1, 7, 1, 1, 51, 83, 117, 143, 463, 1541, 1627, 5611, 9475, 29883, 53387, 117821}},
    {7863, 17, 18204, {1, 3, 7, 3, 31, 55, 3, 131, 79, 415, 383, 3025, 6639, 8335, 31063, 10785, 35791}},
    {7864, 17, 18218, {1, 3, 3, 5, 21, 49, 59, 15, 267, 793, 249, 3615, 7027, 10563, 27911, 21277, 97045}},
    {7865, 17, 18226, {1, 1, 5, 15, 13, 19, 59, 181, 481, 237, 1503, 727, 3805, 7069, 13627, 23745, 31799}},
    {7866, 17, 18238, {1, 1, 7, 9, 17, 27, 11, 181, 377, 363, 269, 3137, 1735, 2945, 16963, 1813, 75417}},
    {7867, 17, 18245, {1, 1, 3, 11, 5, 33, 17, 85, 461, 47, 1825, 3715, 3639, 2577, 141, 54579, 80421}},
    {7868, 17, 18249, {1, 3, 3, 1, 3, 9, 77, 205, 441, 965, 1725, 2161, 7017, 12151, 10017, 41459, 117873}},
    {7869, 17, 18260, {1, 1, 3, 15, 27, 37, 67, 75, 493, 87, 405, 2265, 5709, 7507, 14331, 2803, 110823}},
    {7870, 17, 18267, {1, 3, 7, 5, 7, 37, 95, 159, 495, 367, 1985, 1909, 7305, 4843, 28627, 38981, 49011}},
    {7871, 17, 18270, {1, 1, 7, 9, 15, 47, 99, 233, 469, 525, 329, 1193, 6659, 14861, 7815, 58793, 40477}},
    {7872, 17, 18273, {1, 3, 7, 7, 9, 41, 115, 165, 275, 811, 1243, 3011, 3723, 1533, 13359, 17655, 90035}},
    {7873, 17, 18274, {1, 3, 1, 3, 17, 5, 5, 191, 425, 347, 651, 3901, 613, 9425, 1633, 62545, 16425}},
    {7874, 17, 18276, {1, 1, 1, 1, 11, 57, 109, 239, 411, 215, 1733, 339, 3303, 5095, 5909, 58381, 60313}},
    {7875, 17, 18283, {1, 3, 7, 7, 27, 43, 61, 157, 475, 443, 923, 2503, 1987, 14551, 21423, 1517, 22045}},
    {7876, 17, 18307, {1, 3, 3, 3, 25, 15, 61, 219, 217, 671, 847, 703, 2305, 3135, 1167, 12055, 42299}},
    {7877, 17, 18314, {1, 3, 3, 13, 17, 49, 47, 169, 397, 213, 217, 2249, 4809, 14181, 15489, 35127, 58927}},
    {7878, 17, 18321, {1, 1, 1, 13, 29, 13, 15, 215, 383, 1007, 697, 3063, 5917, 7343, 20841, 50599, 103125}},
    {7879, 17, 18334, {1, 1, 7, 1, 3, 9, 25, 33, 143, 943, 1285, 1145, 7895, 8943, 15969, 20209, 127215}},
    {7880, 17, 18355, {1, 3, 5, 7, 23, 27, 89, 87, 389, 993, 2025, 1759, 2957, 15347, 11015, 28541, 64621}},
    {7881, 17, 18364, {1, 3, 1, 9, 23, 59, 45, 185, 315, 293, 1181, 2109, 161, 9743, 30747, 55665, 120165}},
    {7882, 17, 18372, {1, 1, 7, 5, 19, 23, 13, 103, 89, 895, 1579, 969, 3905, 11085, 26915, 63329, 91215}},
    {7883, 17, 18390, {1, 1, 7, 15, 23, 21, 3, 103, 309, 49, 1451, 805, 7393, 3507, 8411, 54853, 45265}},
    {7884, 17, 18399, {1, 1, 5, 13, 13, 55, 43, 207, 255, 925, 573, 3571, 789, 14621, 16305, 22409, 99299}},
    {7885, 17, 18415, {1, 1, 1, 3, 5, 5, 113, 237, 267, 153, 347, 143, 6877, 4045, 28491, 22475, 108899}},
    {7886, 17, 18420, {1, 1, 7, 7, 29, 63, 69, 169, 41, 695, 311, 661, 2481, 4333, 20235, 13005, 86571}},
    {7887, 17, 18434, {1, 3, 7, 5, 3, 49, 7, 75, 257, 481, 1659, 3745, 5691, 11879, 26271, 31893, 94257}},
    {7888, 17, 18443, {1, 1, 5, 3, 17, 29, 23, 253, 377, 733, 1097, 2341, 1823, 3625, 12117, 17029, 93031}},
    {7889, 17, 18446, {1, 1, 7, 5, 21, 41, 7, 161, 17, 169, 1121, 2903, 6329, 799, 15951, 56997, 57549}},
    {7890, 17, 18460, {1, 3, 1, 3, 9, 1, 103, 239, 385, 887, 667, 4079, 1309, 5595, 26953, 34485, 85813}},
    {7891, 17, 18467, {1, 3, 7, 7, 5, 33, 1, 21, 13, 523, 1837, 945, 4091, 9319, 31181, 58905, 130621}},
    {7892, 17, 18482, {1, 1, 5, 1, 5, 63, 121, 141, 467, 143, 897, 1433, 1177, 8441, 25899, 223, 85581}},
    {7893, 17, 18484, {1, 1, 1, 13, 29, 15, 27, 7, 65, 223, 583, 1907, 7555, 10675, 1865, 63707, 117385}},
    {7894, 17, 18501, {1, 3, 3, 9, 15, 7, 41, 127, 409, 93, 1519, 827, 1233, 4977, 30335, 26071, 106599}},
    {7895, 17, 18506, {1, 3, 5, 1, 23, 55, 127, 1, 321, 515, 817, 3009, 6427, 4937, 4827, 34425, 123063}},
    {7896, 17, 18516, {1, 3, 5, 11, 7, 43, 83, 227, 203, 439, 341, 2345, 5031, 16227, 2639, 9757, 127887}},
    {7897, 17, 18519, {1, 1, 5, 9, 1, 37, 9, 157, 437, 881, 543, 3163, 127, 10705, 21915, 18687, 68103}},
    {7898, 17, 18547, {1, 3, 1, 9, 19, 55, 75, 253, 431, 753, 237, 1417, 7613, 15141, 6113, 38361, 119543}},
    {7899, 17, 18569, {1, 3, 7, 1, 13, 27, 1, 167, 325, 625, 941, 1419, 1213, 15959, 18753, 52057, 40835}},
    {7900, 17, 18575, {1, 1, 3, 1, 23, 49, 49, 45, 341, 453, 5, 2913, 2111, 12191, 2981, 45423, 19391}},
    {7901, 17, 18589, {1, 3, 3, 1, 31, 55, 61, 97, 139, 45, 1495, 2595, 921, 2123, 6939, 34845, 70709}},
    {7902, 17, 18590, {1, 1, 1, 9, 13, 27, 117, 97, 405, 631, 1537, 945, 69, 5601, 32367, 543, 68261}},
    {7903, 17, 18605, {1, 1, 3, 13, 3, 31, 9, 97, 445, 189, 1509, 777, 2753, 7523, 1385, 28981, 117527}},
    {7904, 17, 18611, {1, 3, 7, 5, 23, 37, 75, 243, 279, 49, 1557, 987, 1413, 1243, 13349, 51519, 108931}},
    {7905, 17, 18625, {1, 3, 3, 1, 3, 31, 115, 129, 273, 25, 1245, 2759, 5055, 12931, 5933, 17273, 103729}},
    {7906, 17, 18652, {1, 1, 7, 7, 5, 61, 67, 135, 13, 719, 929, 341, 6647, 9037, 1181, 29229, 2233}},
    {7907, 17, 18665, {1, 3, 3, 1, 15, 3, 43, 57, 23, 227, 1599, 379, 4595, 16239, 13919, 49225, 16095}},
    {7908, 17, 18673, {1, 3, 7, 15, 5, 23, 43, 183, 29, 277, 1341, 1903, 283, 4197, 24653, 33473, 90003}},
    {7909, 17, 18674, {1, 1, 7, 13, 9, 7, 63, 69, 163, 533, 373, 775, 3323, 13749, 4355, 46431, 65281}},
    {7910, 17, 18683, {1, 3, 5, 15, 3, 11, 87, 213, 1, 467, 333, 1621, 6031, 13061, 16511, 15259, 87679}},
    {7911, 17, 18688, {1, 1, 3, 11, 3, 3, 53, 43, 59, 627, 1407, 3887, 1803, 903, 29093, 6233, 60615}},
    {7912, 17, 18691, {1, 3, 5, 5, 27, 9, 17, 99, 449, 525, 925, 1499, 639, 2277, 3953, 28269, 103985}},
    {7913, 17, 18698, {1, 1, 5, 7, 7, 3, 69, 87, 201, 361, 329, 3715, 6283, 8431, 4987, 49279, 73327}},
    {7914, 17, 18717, {1, 1, 1, 3, 9, 55, 17, 27, 355, 809, 751, 957, 3125, 1145, 18175, 7861, 50879}},
    {7915, 17, 18733, {1, 1, 3, 15, 9, 21, 47, 249, 335, 737, 233, 3041, 5099, 10287, 1277, 30343, 11409}},
    {7916, 17, 18754, {1, 3, 3, 3, 25, 25, 105, 197, 473, 813, 277, 2819, 1451, 13217, 23551, 33653, 109659}},
    {7917, 17, 18759, {1, 3, 3, 11, 27, 41, 51, 167, 471, 941, 1877, 1971, 4365, 3207, 29703, 10481, 46087}},
    {7918, 17, 18760, {1, 3, 3, 5, 5, 37, 117, 183, 55, 209, 69, 3749, 2357, 1477, 16967, 59771, 92301}},
    {7919, 17, 18771, {1, 3, 3, 15, 7, 39, 55, 243, 175, 589, 635, 2369, 6243, 12503, 32301, 59877, 74591}},
    {7920, 17, 18777, {1, 3, 5, 15, 27, 9, 59, 39, 239, 995, 387, 3457, 5553, 7591, 17513, 33981, 23189}},
    {7921, 17, 18796, {1, 3, 5, 5, 11, 21, 13, 145, 315, 361, 833, 1581, 3883, 12605, 29537, 55475, 35}},
    {7922, 17, 18799, {1, 1, 7, 13, 13, 17, 35, 179, 125, 859, 623, 3185, 965, 5783, 4595, 34589, 84263}},
    {7923, 17, 18807, {1, 3, 3, 9, 11, 49, 75, 5, 409, 483, 1609, 2119, 5117, 8143, 29593, 21039, 117667}},
    {7924, 17, 18813, {1, 1, 1, 1, 13, 55, 107, 107, 45, 979, 845, 3927, 2245, 4389, 14327, 47303, 50977}},
    {7925, 17, 18817, {1, 3, 3, 11, 23, 23, 95, 39, 73, 911, 239, 3339, 2425, 8123, 16495, 16013, 1641}},
    {7926, 17, 18820, {1, 1, 7, 1, 21, 17, 23, 73, 487, 237, 1395, 4063, 5523, 4247, 15191, 4787, 126463}},
    {7927, 17, 18827, {1, 1, 5, 11, 1, 47, 97, 129, 381, 135, 1995, 53, 2027, 2519, 24861, 56637, 128407}},
    {7928, 17, 18829, {1, 3, 1, 5, 5, 35, 103, 247, 275, 89, 2021, 979, 7115, 15845, 5747, 12225, 9331}},
    {7929, 17, 18838, {1, 1, 3, 5, 3, 7, 39, 211, 331, 513, 1095, 3459, 1603, 10193, 1321, 56773, 92953}},
    {7930, 17, 18842, {1, 1, 7, 7, 31, 9, 101, 181, 319, 659, 721, 1669, 591, 13791, 22779, 8225, 106539}},
    {7931, 17, 18848, {1, 1, 7, 15, 17, 37, 23, 1, 133, 903, 777, 3781, 7811, 5177, 2995, 45533, 80103}},
    {7932, 17, 18853, {1, 3, 1, 13, 31, 29, 47, 3, 491, 999, 255, 2029, 3071, 479, 27685, 4587, 94973}},
    {7933, 17, 18885, {1, 1, 7, 9, 15, 17, 35, 155, 459, 161, 817, 867, 513, 10915, 1231, 7369, 84865}},
    {7934, 17, 18890, {1, 1, 5, 7, 19, 5, 113, 91, 61, 431, 289, 1477, 2345, 11307, 11505, 59761, 105185}},
    {7935, 17, 18898, {1, 1, 3, 5, 5, 45, 49, 73, 167, 773, 1579, 3151, 3483, 3829, 22539, 33733, 72041}},
    {7936, 17, 18903, {1, 1, 3, 13, 21, 7, 103, 219, 283, 235, 193, 723, 3909, 15239, 28373, 5961, 59495}},
    {7937, 17, 18910, {1, 1, 5, 11, 29, 7, 37, 205, 7, 585, 715, 3449, 1031, 11067, 5955, 17639, 51161}},
    {7938, 17, 18913, {1, 1, 3, 3, 1, 19, 93, 231, 69, 459, 1759, 2821, 4771, 15721, 22751, 65137, 114107}},
    {7939, 17, 18931, {1, 1, 1, 5, 7, 5, 121, 193, 11, 145, 1275, 835, 4141, 15449, 25275, 31347, 127381}},
    {7940, 17, 18934, {1, 3, 5, 13, 3, 57, 93, 93, 291, 207, 253, 1981, 5023, 6201, 7661, 20591, 112797}},
    {7941, 17, 18956, {1, 1, 1, 5, 31, 45, 89, 231, 393, 149, 1499, 239, 3817, 12399, 19459, 51059, 43861}},
    {7942, 17, 18961, {1, 3, 5, 13, 11, 27, 87, 211, 457, 631, 1315, 3063, 3549, 7091, 31347, 28627, 8597}},
    {7943, 17, 18968, {1, 1, 3, 3, 15, 45, 127, 251, 457, 891, 1747, 1269, 2227, 6817, 19957, 56951, 127665}},
    {7944, 17, 18978, {1, 3, 5, 15, 17, 15, 77, 111, 167, 559, 1393, 2369, 7081, 12575, 29697, 25551, 30931}},
    {7945, 17, 18983, {1, 3, 7, 13, 29, 39, 69, 109, 215, 629, 803, 287, 29, 16081, 22979, 10339, 74137}},
    {7946, 17, 18987, {1, 3, 7, 1, 31, 31, 47, 63, 227, 41, 913, 2033, 5515, 15649, 3665, 1355, 84437}},
    {7947, 17, 18992, {1, 1, 3, 1, 15, 31, 65, 49, 179, 7, 1415, 2677, 7179, 14055, 17945, 28433, 120981}},
    {7948, 17, 18997, {1, 3, 7, 3, 17, 13, 35, 53, 427, 59, 925, 457, 2679, 5917, 32603, 23489, 42463}},
    {7949, 17, 19002, {1, 1, 5, 3, 27, 21, 65, 1, 171, 849, 275, 2051, 1701, 3593, 21717, 50667, 100405}},
    {7950, 17, 19004, {1, 3, 1, 3, 5, 21, 3, 179, 407, 343, 1819, 2195, 4585, 3043, 26723, 23081, 54607}},
    {7951, 17, 19010, {1, 3, 5, 3, 19, 47, 65, 215, 351, 653, 983, 3807, 963, 12025, 13247, 50127, 28805}},
    {7952, 17, 19012, {1, 3, 3, 7, 31, 1, 79, 109, 245, 653, 871, 3369, 2061, 6505, 7369, 9929, 85659}},
    {7953, 17, 19030, {1, 3, 3, 3, 11, 49, 99, 223, 371, 45, 57, 689, 3889, 11071, 26587, 8467, 46049}},
    {7954, 17, 19043, {1, 3, 1, 11, 21, 57, 101, 169, 425, 747, 1707, 2155, 7027, 2603, 3659, 16903, 126437}},
    {7955, 17, 19049, {1, 3, 3, 15, 3, 13, 79, 57, 137, 707, 15, 3069, 3489, 4975, 27279, 50121, 128193}},
    {7956, 17, 19079, {1, 1, 3, 13, 3, 5, 105, 153, 249, 97, 623, 2515, 121, 12263, 11249, 5743, 32209}},
    {7957, 17, 19086, {1, 3, 1, 3, 3, 39, 51, 65, 189, 949, 1247, 4069, 885, 4165, 25855, 61525, 42409}},
    {7958, 17, 19100, {1, 3, 7, 7, 23, 17, 13, 233, 289, 235, 1717, 603, 3479, 1797, 23437, 25493, 97649}},
    {7959, 17, 19103, {1, 1, 3, 13, 19, 37, 71, 15, 193, 79, 1503, 3111, 1623, 6865, 28305, 16029, 96035}},
    {7960, 17, 19107, {1, 3, 7, 13, 3, 27, 87, 247, 41, 187, 473, 1727, 6887, 7093, 19083, 8243, 63253}},
    {7961, 17, 19109, {1, 3, 5, 5, 9, 33, 119, 119, 43, 69, 359, 3427, 1537, 9029, 24639, 12595, 18079}},
    {7962, 17, 19113, {1, 1, 5, 7, 21, 57, 53, 21, 195, 743, 709, 2877, 1651, 4539, 28891, 25699, 91003}},
    {7963, 17, 19116, {1, 1, 5, 7, 23, 59, 29, 141, 453, 961, 1451, 2665, 6443, 3873, 15037, 55477, 19005}},
    {7964, 17, 19127, {1, 3, 3, 13, 15, 51, 9, 95, 133, 185, 135, 2001, 233, 14901, 16855, 29069, 91165}},
    {7965, 17, 19134, {1, 3, 3, 15, 19, 23, 5, 21, 255, 273, 1543, 3229, 6329, 6177, 27619, 29089, 25505}},
    {7966, 17, 19141, {1, 3, 3, 15, 13, 49, 27, 65, 95, 103, 783, 2689, 6777, 5445, 24181, 4127, 89271}},
    {7967, 17, 19179, {1, 3, 3, 7, 29, 1, 105, 119, 23, 877, 259, 3667, 3021, 7365, 12437, 49961, 85531}},
    {7968, 17, 19193, {1, 1, 5, 3, 3, 7, 53, 215, 223, 27, 743, 3489, 1509, 12983, 1885, 46845, 28119}},
    {7969, 17, 19194, {1, 1, 1, 15, 29, 51, 107, 143, 239, 769, 2023, 1063, 7639, 8219, 15213, 36851, 11589}},
    {7970, 17, 19201, {1, 3, 3, 15, 23, 39, 47, 183, 411, 383, 1537, 3301, 4235, 14489, 23583, 15919, 98339}},
    {7971, 17, 19208, {1, 3, 3, 15, 17, 61, 87, 107, 27, 807, 1695, 3489, 2733, 12081, 7001, 49225, 82251}},
    {7972, 17, 19214, {1, 1, 3, 3, 29, 55, 19, 81, 301, 285, 1971, 1551, 743, 767, 8215, 14011, 36331}},
    {7973, 17, 19225, {1, 1, 5, 1, 29, 43, 45, 237, 415, 973, 1513, 1271, 6473, 11867, 21627, 22477, 26999}},
    {7974, 17, 19226, {1, 3, 3, 11, 7, 55, 103, 81, 231, 503, 1579, 1643, 6421, 10511, 9019, 57853, 2841}},
    {7975, 17, 19235, {1, 1, 5, 15, 7, 53, 73, 233, 479, 357, 911, 3423, 3781, 7345, 16345, 52329, 51607}},
    {7976, 17, 19242, {1, 1, 7, 9, 19, 61, 121, 73, 211, 299, 1773, 3473, 57, 9279, 28757, 45871, 7105}},
    {7977, 17, 19264, {1, 3, 5, 3, 7, 27, 15, 19, 327, 501, 1227, 2623, 135, 14141, 9597, 39107, 25319}},
    {7978, 17, 19267, {1, 3, 5, 13, 7, 59, 93, 241, 395, 23, 1285, 2053, 5163, 8153, 17503, 28275, 71349}},
    {7979, 17, 19293, {1, 3, 5, 13, 31, 17, 11, 177, 397, 163, 5, 2775, 1919, 13153, 10159, 57243, 74725}},
    {7980, 17, 19309, {1, 3, 5, 15, 31, 27, 95, 87, 145, 555, 1615, 3951, 2601, 15371, 27917, 947, 87111}},
    {7981, 17, 19318, {1, 3, 7, 15, 27, 59, 57, 7, 285, 483, 1843, 99, 4777, 12953, 15189, 51275, 64701}},
    {7982, 17, 19324, {1, 3, 5, 15, 29, 47, 115, 101, 183, 47, 1845, 655, 137, 12049, 3631, 9003, 86803}},
    {7983, 17, 19337, {1, 3, 5, 5, 3, 17, 113, 191, 407, 65, 1923, 375, 6347, 9917, 22261, 40417, 111889}},
    {7984, 17, 19340, {1, 1, 7, 9, 19, 17, 51, 67, 141, 765, 255, 1885, 4819, 14053, 23433, 37833, 23155}},
    {7985, 17, 19345, {1, 1, 5, 3, 23, 35, 23, 69, 353, 47, 1643, 623, 449, 1265, 10483, 55355, 38041}},
    {7986, 17, 19346, {1, 1, 5, 15, 23, 13, 41, 25, 217, 49, 1071, 1753, 2707, 11675, 7157, 43857, 23889}},
    {7987, 17, 19352, {1, 1, 7, 3, 9, 47, 125, 113, 113, 785, 1367, 1975, 5797, 14791, 795, 35947, 87693}},
    {7988, 17, 19364, {1, 1, 1, 1, 19, 43, 123, 177, 401, 45, 183, 2489, 5889, 4219, 4793, 58625, 17195}},
    {7989, 17, 19382, {1, 3, 7, 11, 27, 13, 99, 23, 277, 1001, 1617, 1391, 4845, 2241, 9705, 10861, 73063}},
    {7990, 17, 19391, {1, 1, 3, 3, 21, 9, 23, 37, 275, 747, 161, 3869, 6387, 9191, 22225, 38885, 35459}},
    {7991, 17, 19405, {1, 1, 5, 15, 25, 19, 11, 219, 177, 271, 1859, 3915, 3679, 823, 13203, 21195, 62875}},
    {7992, 17, 19411, {1, 1, 1, 3, 29, 55, 53, 229, 383, 941, 765, 2081, 4333, 13957, 201, 13083, 129815}},
    {7993, 17, 19439, {1, 1, 3, 7, 29, 31, 65, 165, 209, 441, 1373, 4025, 4163, 3073, 5905, 59463, 78163}},
    {7994, 17, 19442, {1, 1, 3, 1, 7, 51, 93, 179, 3, 23, 1587, 1369, 5005, 11643, 9515, 55103, 94069}},
    {7995, 17, 19444, {1, 1, 7, 3, 19, 43, 21, 19, 137, 521, 1875, 2079, 5333, 8073, 2117, 51809, 27675}},
    {7996, 17, 19451, {1, 3, 1, 5, 23, 37, 91, 129, 241, 405, 549, 611, 2511, 7297, 10465, 32145, 120371}},
    {7997, 17, 19465, {1, 1, 5, 13, 17, 59, 125, 129, 419, 813, 101, 2319, 4939, 5543, 18105, 49413, 89455}},
    {7998, 17, 19471, {1, 3, 7, 9, 9, 37, 11, 11, 367, 277, 1881, 4005, 6371, 9461, 399, 43193, 32241}},
    {7999, 17, 19474, {1, 3, 5, 15, 1, 11, 27, 159, 217, 955, 91, 2111, 1217, 10219, 23417, 34957, 63741}},
    {8000, 17, 19476, {1, 1, 7, 3, 27, 1, 99, 183, 279, 247, 719, 1497, 1073, 2417, 16837, 8509, 30727}},
    {8001, 17, 19479, {1, 1, 3, 5, 5, 63, 91, 177, 301, 753, 459, 1511, 1523, 685, 21031, 8157, 39031}},
    {8002, 17, 19485, {1, 1, 5, 5, 19, 13, 113, 201, 469, 401, 915, 463, 1909, 5945, 24349, 16825, 125363}},
    {8003, 17, 19489, {1, 3, 3, 3, 1, 61, 53, 149, 295, 793, 1423, 2333, 153, 2293, 10891, 421, 86789}},
    {8004, 17, 19496, {1, 3, 3, 1, 3, 5, 17, 25, 165, 787, 1741, 2203, 3309, 15153, 15229, 34157, 37929}},
    {8005, 17, 19507, {1, 3, 3, 13, 1, 53, 45, 155, 195, 417, 211, 3681, 279, 15987, 4425, 63339, 83875}},
    {8006, 17, 19513, {1, 3, 5, 11, 13, 53, 77, 161, 397, 17, 1379, 1287, 1833, 5851, 4475, 1309, 62227}},
    {8007, 17, 19514, {1, 1, 3, 5, 7, 13, 21, 89, 449, 101, 1031, 2983, 1139, 10663, 1355, 61757, 4111}},
    {8008, 17, 19521, {1, 1, 1, 13, 27, 39, 111, 23, 323, 403, 2021, 1153, 3735, 15443, 25479, 10105, 63507}},
    {8009, 17, 19524, {1, 3, 5, 13, 19, 19, 59, 191, 267, 687, 1919, 389, 7359, 15685, 10849, 18309, 91257}},
    {8010, 17, 19546, {1, 1, 7, 11, 5, 59, 65, 119, 341, 157, 75, 879, 5451, 3983, 32227, 48667, 45495}},
    {8011, 17, 19552, {1, 1, 5, 7, 15, 37, 3, 87, 91, 551, 171, 3069, 2409, 3769, 9619, 18765, 57773}},
    {8012, 17, 19555, {1, 3, 7, 15, 3, 11, 51, 15, 421, 213, 729, 1129, 5785, 4231, 11665, 35835, 91481}},
    {8013, 17, 19557, {1, 1, 7, 13, 17, 53, 7, 121, 167, 89, 899, 3449, 7241, 14211, 10111, 25423, 115047}},
    {8014, 17, 19575, {1, 3, 7, 11, 9, 21, 53, 93, 373, 261, 163, 1531, 8015, 4647, 23159, 3699, 117009}},
    {8015, 17, 19579, {1, 3, 3, 9, 7, 41, 39, 125, 253, 87, 49, 3563, 6465, 11699, 25321, 53469, 42947}},
    {8016, 17, 19591, {1, 1, 3, 7, 15, 39, 123, 173, 323, 31, 1405, 1843, 1545, 3983, 26587, 29603, 52381}},
    {8017, 17, 19595, {1, 3, 3, 13, 17, 53, 73, 223, 371, 735, 5, 987, 2865, 4471, 6487, 30119, 48239}},
    {8018, 17, 19605, {1, 1, 1, 1, 25, 61, 53, 209, 311, 677, 895, 3885, 7133, 10327, 1945, 10783, 106425}},
    {8019, 17, 19615, {1, 3, 7, 11, 31, 13, 101, 157, 285, 799, 741, 2649, 6697, 8463, 5177, 11119, 117225}},
    {8020, 17, 19616, {1, 1, 5, 5, 21, 39, 47, 149, 57, 785, 1075, 1287, 6435, 8189, 23145, 2741, 17745}},
    {8021, 17, 19626, {1, 3, 7, 11, 15, 61, 85, 231, 473, 785, 1201, 4083, 511, 12249, 2477, 60041, 30603}},
    {8022, 17, 19631, {1, 3, 3, 9, 15, 13, 113, 61, 409, 927, 1757, 3855, 7243, 9099, 26203, 44583, 83249}},
    {8023, 17, 19634, {1, 3, 5, 11, 21, 63, 113, 143, 95, 991, 765, 2549, 995, 4069, 16333, 54495, 19}},
    {8024, 17, 19640, {1, 1, 3, 15, 9, 15, 7, 159, 117, 55, 2031, 1349, 6755, 5763, 5601, 55051, 19085}},
    {8025, 17, 19645, {1, 3, 1, 15, 21, 13, 99, 21, 109, 391, 27, 1739, 5873, 2041, 25797, 9595, 119719}},
    {8026, 17, 19678, {1, 1, 7, 7, 19, 49, 35, 87, 263, 969, 1337, 2347, 6921, 6147, 7761, 32219, 76211}},
    {8027, 17, 19681, {1, 1, 7, 1, 13, 55, 89, 173, 219, 473, 227, 3317, 1193, 13283, 6801, 19615, 20449}},
    {8028, 17, 19682, {1, 1, 3, 11, 23, 21, 83, 247, 353, 885, 857, 1935, 7843, 12919, 683, 39571, 46885}},
    {8029, 17, 19706, {1, 3, 3, 3, 31, 31, 13, 207, 39, 571, 189, 2447, 1335, 1767, 31805, 60385, 68971}},
    {8030, 17, 19708, {1, 1, 3, 13, 5, 15, 89, 1, 235, 37, 1873, 1891, 755, 8881, 13037, 1609, 88099}},
    {8031, 17, 19713, {1, 1, 7, 15, 27, 33, 61, 185, 419, 547, 61, 471, 901, 3863, 21271, 6527, 113217}},
    {8032, 17, 19714, {1, 3, 1, 15, 29, 31, 115, 143, 147, 69, 423, 3339, 977, 11125, 29091, 9571, 69879}},
    {8033, 17, 19720, {1, 3, 5, 9, 25, 9, 1, 235, 83, 121, 1785, 2109, 7695, 709, 1851, 40537, 39267}},
    {8034, 17, 19725, {1, 3, 5, 11, 9, 43, 37, 243, 173, 923, 693, 1139, 1461, 9721, 4407, 58067, 80645}},
    {8035, 17, 19743, {1, 3, 3, 13, 31, 43, 57, 225, 453, 653, 1361, 2183, 7819, 13221, 21489, 29629, 73517}},
    {8036, 17, 19753, {1, 3, 5, 1, 1, 31, 47, 237, 501, 259, 481, 685, 4365, 10415, 21637, 61553, 128551}},
    {8037, 17, 19756, {1, 1, 5, 3, 9, 57, 89, 55, 491, 605, 107, 1637, 2025, 7207, 10633, 43867, 113495}},
    {8038, 17, 19759, {1, 1, 1, 11, 25, 33, 107, 49, 169, 991, 237, 1125, 3891, 699, 10979, 52199, 48291}},
    {8039, 17, 19762, {1, 1, 7, 15, 17, 37, 107, 235, 475, 445, 901, 3157, 4673, 14801, 18793, 36159, 80569}},
    {8040, 17, 19776, {1, 1, 1, 13, 27, 53, 37, 53, 19, 649, 1355, 2055, 5107, 3255, 31833, 26829, 32727}},
    {8041, 17, 19786, {1, 1, 1, 5, 9, 17, 91, 109, 391, 91, 91, 3495, 5791, 1483, 24985, 3477, 56273}},
    {8042, 17, 19799, {1, 3, 3, 11, 9, 7, 81, 3, 469, 325, 99, 821, 6101, 15953, 27629, 60573, 16859}},
    {8043, 17, 19800, {1, 1, 5, 3, 25, 15, 83, 149, 83, 645, 1231, 503, 1341, 15635, 1623, 11563, 45127}},
    {8044, 17, 19803, {1, 1, 5, 9, 13, 13, 93, 207, 77, 381, 851, 2429, 3253, 1149, 25953, 34207, 122393}},
    {8045, 17, 19806, {1, 3, 1, 7, 9, 15, 3, 1, 199, 847, 345, 3569, 3023, 4109, 7429, 49085, 130071}},
    {8046, 17, 19815, {1, 1, 5, 9, 29, 61, 13, 21, 271, 489, 179, 511, 7381, 10129, 11129, 30629, 63385}},
    {8047, 17, 19816, {1, 3, 7, 13, 23, 59, 119, 119, 13, 965, 29, 2021, 4133, 8483, 9685, 8009, 54731}},
    {8048, 17, 19857, {1, 3, 1, 7, 25, 7, 97, 45, 85, 939, 727, 2893, 3505, 10621, 14647, 39885, 53527}},
    {8049, 17, 19860, {1, 3, 3, 3, 15, 17, 97, 175, 17, 613, 953, 4033, 7151, 9071, 11991, 7429, 2195}},
    {8050, 17, 19874, {1, 1, 1, 5, 17, 57, 15, 247, 411, 301, 1171, 129, 289, 2429, 22029, 21315, 253}},
    {8051, 17, 19883, {1, 3, 3, 5, 11, 29, 99, 193, 79, 647, 949, 4071, 1331, 11003, 21777, 48397, 1713}},
    {8052, 17, 19885, {1, 3, 7, 3, 23, 41, 71, 215, 113, 97, 489, 203, 5241, 6819, 29535, 64457, 25263}},
    {8053, 17, 19886, {1, 3, 3, 13, 17, 41, 89, 65, 465, 899, 841, 3915, 5061, 16193, 31515, 1153, 50959}},
    {8054, 17, 19893, {1, 1, 7, 7, 23, 61, 17, 35, 317, 887, 551, 4041, 5277, 14089, 13411, 28469, 111031}},
    {8055, 17, 19932, {1, 3, 5, 9, 27, 37, 117, 183, 95, 371, 991, 183, 7109, 9265, 30587, 51827, 17903}},
    {8056, 17, 19960, {1, 3, 5, 13, 1, 49, 101, 15, 191, 689, 235, 3563, 2681, 803, 18997, 37613, 64891}},
    {8057, 17, 19972, {1, 3, 5, 9, 3, 41, 83, 37, 385, 533, 1885, 3999, 1043, 2329, 24701, 35941, 92409}},
    {8058, 17, 19975, {1, 3, 7, 5, 3, 41, 19, 83, 75, 39, 1507, 3735, 3027, 4061, 31619, 37999, 21665}},
    {8059, 17, 20005, {1, 3, 3, 5, 15, 39, 37, 155, 263, 847, 743, 3241, 2077, 9035, 4613, 11685, 47737}},
    {8060, 17, 20009, {1, 1, 3, 9, 23, 51, 101, 191, 417, 217, 321, 3513, 8159, 6885, 2257, 21259, 123079}},
    {8061, 17, 20010, {1, 1, 7, 1, 11, 39, 113, 199, 333, 617, 709, 1263, 2239, 4421, 2073, 65137, 5827}},
    {8062, 17, 20012, {1, 3, 5, 9, 15, 3, 99, 179, 33, 951, 1183, 1587, 5723, 6911, 6887, 1475, 116289}},
    {8063, 17, 20023, {1, 3, 3, 15, 25, 41, 21, 201, 323, 373, 1279, 2323, 1613, 15933, 723, 56973, 20435}},
    {8064, 17, 20024, {1, 1, 3, 13, 11, 31, 1, 107, 317, 479, 1281, 797, 2869, 15013, 32025, 2339, 51659}},
    {8065, 17, 20030, {1, 1, 7, 9, 27, 49, 75, 251, 195, 923, 959, 567, 6133, 14057, 20843, 10655, 33689}},
    {8066, 17, 20038, {1, 3, 1, 1, 11, 11, 49, 17, 117, 327, 35, 3951, 5737, 7733, 14091, 11307, 68267}},
    {8067, 17, 20041, {1, 3, 1, 5, 9, 45, 115, 175, 459, 189, 1663, 1393, 5797, 9421, 15557, 12873, 8835}},
    {8068, 17, 20055, {1, 3, 1, 13, 11, 45, 51, 249, 283, 515, 31, 3181, 4385, 9575, 1813, 8081, 9527}},
    {8069, 17, 20059, {1, 1, 1, 9, 11, 19, 81, 75, 49, 945, 699, 3171, 3523, 2709, 27251, 16301, 118759}},
    {8070, 17, 20061, {1, 3, 1, 11, 3, 47, 95, 45, 75, 977, 1311, 683, 2541, 2861, 5529, 57335, 75349}},
    {8071, 17, 20080, {1, 1, 3, 15, 27, 63, 127, 169, 141, 519, 1881, 1039, 4307, 12365, 32447, 34599, 129051}},
    {8072, 17, 20086, {1, 1, 7, 13, 29, 41, 1, 5, 505, 727, 1885, 2323, 1689, 14093, 21247, 41901, 12315}},
    {8073, 17, 20089, {1, 1, 7, 5, 13, 29, 89, 241, 15, 27, 1031, 299, 1907, 2631, 32653, 10117, 32705}},
    {8074, 17, 20095, {1, 1, 5, 9, 1, 3, 75, 83, 75, 59, 1329, 3943, 757, 5861, 24643, 28865, 105657}},
    {8075, 17, 20111, {1, 1, 7, 9, 7, 33, 21, 239, 443, 447, 629, 3705, 7673, 2559, 16775, 41499, 10947}},
    {8076, 17, 20116, {1, 1, 3, 7, 25, 41, 57, 179, 207, 721, 1337, 1443, 395, 2963, 8005, 14505, 87483}},
    {8077, 17, 20130, {1, 3, 3, 15, 29, 59, 117, 163, 203, 51, 1609, 2999, 593, 14973, 1157, 38037, 51759}},
    {8078, 17, 20136, {1, 1, 1, 3, 9, 27, 23, 249, 127, 291, 491, 3589, 5961, 7019, 27051, 41701, 85967}},
    {8079, 17, 20147, {1, 3, 3, 3, 19, 57, 93, 205, 187, 27, 1563, 341, 6957, 7919, 31849, 57657, 127205}},
    {8080, 17, 20153, {1, 1, 5, 5, 25, 43, 117, 217, 35, 781, 935, 3841, 7417, 8791, 159, 46383, 76177}},
    {8081, 17, 20156, {1, 3, 5, 9, 29, 15, 45, 209, 203, 923, 1933, 1479, 3673, 5545, 14681, 54209, 83267}},
    {8082, 17, 20167, {1, 1, 1, 7, 7, 29, 99, 85, 159, 61, 533, 3133, 6935, 3835, 5855, 38503, 33945}},
    {8083, 17, 20173, {1, 1, 5, 1, 7, 5, 87, 175, 211, 187, 1977, 2133, 6117, 141, 6209, 40787, 29735}},
    {8084, 17, 20182, {1, 1, 3, 9, 5, 23, 91, 255, 201, 169, 351, 2453, 7423, 8461, 20451, 35975, 125863}},
    {8085, 17, 20185, {1, 3, 1, 9, 7, 57, 115, 19, 115, 475, 1411, 885, 5215, 9971, 12355, 42743, 37025}},
    {8086, 17, 20202, {1, 3, 5, 15, 13, 35, 55, 73, 271, 839, 1427, 1045, 401, 7509, 5209, 63457, 110023}},
    {8087, 17, 20209, {1, 1, 5, 11, 7, 47, 29, 209, 355, 239, 937, 3359, 2393, 14071, 21429, 45387, 72319}},
    {8088, 17, 20229, {1, 1, 3, 1, 15, 33, 3, 91, 347, 681, 1157, 3353, 2317, 9149, 7105, 46021, 55237}},
    {8089, 17, 20233, {1, 3, 1, 11, 19, 59, 35, 159, 391, 787, 1197, 1969, 6649, 1441, 23219, 11809, 94963}},
    {8090, 17, 20236, {1, 3, 5, 3, 13, 43, 23, 113, 475, 679, 139, 2941, 7215, 13049, 28093, 47213, 66983}},
    {8091, 17, 20241, {1, 3, 7, 11, 7, 21, 63, 143, 137, 541, 1455, 209, 6355, 6505, 30545, 25363, 95565}},
    {8092, 17, 20242, {1, 3, 7, 9, 27, 63, 81, 195, 237, 689, 831, 2443, 3053, 5031, 3027, 3223, 39237}},
    {8093, 17, 20248, {1, 3, 7, 9, 11, 15, 127, 235, 69, 851, 1117, 887, 115, 1209, 31343, 65347, 106957}},
    {8094, 17, 20278, {1, 1, 5, 3, 7, 45, 89, 163, 291, 965, 1001, 981, 7129, 14869, 6739, 9243, 47951}},
    {8095, 17, 20282, {1, 1, 5, 7, 13, 11, 13, 13, 443, 581, 391, 401, 4329, 2171, 10547, 27001, 87739}},
    {8096, 17, 20299, {1, 3, 1, 15, 7, 3, 41, 181, 473, 401, 191, 1207, 177, 13025, 12283, 45879, 129407}},
    {8097, 17, 20307, {1, 3, 1, 13, 7, 27, 73, 27, 261, 473, 489, 1027, 6041, 16327, 16083, 2077, 73277}},
    {8098, 17, 20313, {1, 3, 3, 9, 27, 23, 101, 223, 455, 189, 689, 1963, 813, 3059, 7047, 55095, 2541}},
    {8099, 17, 20314, {1, 3, 3, 7, 25, 61, 83, 7, 205, 939, 273, 533, 6935, 15695, 28329, 33865, 84181}},
    {8100, 17, 20320, {1, 1, 7, 1, 19, 7, 49, 243, 437, 789, 1293, 2951, 7627, 12945, 21499, 62425, 102367}},
    {8101, 17, 20326, {1, 1, 1, 7, 29, 47, 1, 47, 497, 449, 5, 2419, 1465, 10795, 28863, 40399, 116193}},
    {8102, 17, 20332, {1, 1, 5, 3, 17, 21, 57, 77, 69, 53, 259, 371, 6575, 11931, 24279, 14239, 64653}},
    {8103, 17, 20350, {1, 3, 3, 13, 17, 13, 57, 253, 247, 713, 1395, 1841, 1221, 3449, 18841, 61647, 1447}},
    {8104, 17, 20360, {1, 1, 5, 7, 1, 5, 103, 109, 57, 689, 317, 389, 7493, 1765, 11937, 3979, 127241}},
    {8105, 17, 20371, {1, 3, 5, 13, 13, 45, 55, 89, 51, 421, 751, 157, 817, 16153, 28873, 9385, 70397}},
    {8106, 17, 20373, {1, 1, 7, 15, 21, 27, 87, 185, 473, 35, 699, 3865, 2617, 15951, 17785, 20813, 18713}},
    {8107, 17, 20377, {1, 1, 3, 15, 17, 59, 53, 69, 47, 945, 435, 3495, 1879, 5459, 30105, 48149, 33527}},
    {8108, 17, 20390, {1, 1, 1, 13, 23, 13, 99, 201, 375, 587, 879, 1537, 61, 10209, 963, 57005, 44535}},
    {8109, 17, 20396, {1, 3, 7, 1, 27, 33, 65, 93, 215, 267, 423, 1015, 1387, 7775, 22533, 47535, 64533}},
    {8110, 17, 20404, {1, 1, 5, 9, 15, 19, 51, 121, 289, 725, 607, 4081, 7709, 8981, 30301, 1291, 64395}},
    {8111, 17, 20413, {1, 1, 7, 5, 7, 27, 91, 103, 215, 979, 1221, 461, 6255, 5009, 15077, 19201, 90039}},
    {8112, 17, 20434, {1, 1, 1, 1, 31, 61, 77, 73, 215, 191, 1693, 1891, 2555, 13875, 29689, 18093, 93571}},
    {8113, 17, 20436, {1, 1, 1, 7, 9, 49, 63, 73, 401, 893, 547, 2475, 8027, 9955, 24469, 58997, 22769}},
    {8114, 17, 20440, {1, 1, 1, 9, 17, 49, 27, 205, 329, 891, 1779, 2033, 603, 1427, 21169, 739, 57173}},
    {8115, 17, 20443, {1, 1, 7, 1, 23, 7, 127, 85, 397, 771, 1175, 2891, 6599, 6843, 4179, 42653, 39015}},
    {8116, 17, 20445, {1, 3, 3, 9, 1, 25, 57, 85, 425, 533, 245, 2703, 7085, 11411, 20719, 28633, 48837}},
    {8117, 17, 20464, {1, 3, 5, 1, 1, 45, 39, 21, 221, 559, 1197, 1283, 2961, 595, 10359, 163, 90211}},
    {8118, 17, 20476, {1, 3, 5, 5, 23, 13, 37, 109, 143, 993, 1807, 2149, 3771, 12229, 2097, 56093, 203}},
    {8119, 17, 20494, {1, 3, 1, 13, 7, 47, 11, 249, 433, 637, 137, 697, 6039, 15199, 10985, 48917, 107561}},
    {8120, 17, 20496, {1, 1, 5, 3, 15, 25, 83, 243, 381, 165, 1245, 1115, 2481, 1365, 27155, 21477, 21193}},
    {8121, 17, 20501, {1, 3, 3, 3, 3, 61, 55, 155, 81, 631, 55, 3245, 2533, 11123, 5843, 46909, 8147}},
    {8122, 17, 20518, {1, 1, 3, 1, 21, 63, 71, 173, 45, 751, 971, 2429, 4749, 6337, 21193, 60847, 6873}},
    {8123, 17, 20527, {1, 1, 5, 5, 17, 45, 77, 101, 317, 125, 1885, 267, 4233, 15145, 18999, 33503, 17011}},
    {8124, 17, 20529, {1, 3, 5, 13, 23, 31, 19, 75, 113, 215, 1885, 4027, 3927, 1065, 12255, 1129, 102145}},
    {8125, 17, 20535, {1, 3, 3, 15, 23, 33, 5, 125, 457, 153, 1105, 3893, 7555, 6083, 32267, 1287, 43789}},
    {8126, 17, 20544, {1, 1, 7, 9, 9, 27, 61, 57, 213, 527, 109, 1983, 4873, 9077, 19603, 55163, 130515}},
    {8127, 17, 20568, {1, 3, 5, 1, 3, 3, 15, 131, 29, 89, 1521, 329, 3995, 4407, 14535, 21723, 128833}},
    {8128, 17, 20589, {1, 3, 7, 15, 5, 21, 123, 229, 323, 571, 327, 1537, 1137, 10183, 20971, 54575, 84583}},
    {8129, 17, 20592, {1, 3, 3, 3, 31, 43, 77, 219, 303, 647, 551, 3259, 4771, 14341, 18177, 32169, 107039}},
    {8130, 17, 20601, {1, 3, 7, 3, 23, 39, 59, 171, 295, 497, 955, 1465, 207, 1761, 1945, 517, 112867}},
    {8131, 17, 20617, {1, 1, 7, 1, 21, 17, 23, 73, 487, 237, 1395, 4063, 5523, 4247, 15191, 4787, 126463}},
    {8132, 17, 20625, {1, 3, 3, 7, 19, 9, 93, 117, 465, 465, 893, 949, 3241, 4167, 18951, 7493, 126681}},
    {8133, 17, 20626, {1, 1, 5, 13, 7, 5, 15, 7, 173, 621, 1687, 55, 6543, 11049, 20297, 55091, 47829}},
    {8134, 17, 20632, {1, 3, 3, 13, 21, 53, 37, 199, 293, 831, 707, 597, 3653, 10769, 11819, 39337, 82749}},
    {8135, 17, 20638, {1, 1, 7, 1, 7, 3, 101, 95, 415, 43, 531, 1365, 6031, 11513, 32749, 18829, 45195}},
    {8136, 17, 20644, {1, 1, 7, 11, 7, 11, 95, 113, 121, 141, 1077, 3653, 5625, 8319, 12583, 11193, 8153}},
    {8137, 17, 20647, {1, 3, 5, 11, 11, 1, 111, 21, 235, 887, 1051, 2361, 4977, 12665, 20409, 3981, 81141}},
    {8138, 17, 20662, {1, 1, 1, 13, 1, 45, 63, 95, 359, 851, 595, 681, 5177, 7901, 3669, 52063, 106373}},
    {8139, 17, 20671, {1, 1, 5, 9, 7, 49, 41, 149, 465, 479, 517, 3359, 3591, 597, 4361, 50471, 125875}},
    {8140, 17, 20674, {1, 1, 3, 7, 17, 41, 73, 89, 317, 23, 1643, 1885, 5531, 1233, 7041, 14159, 39615}},
    {8141, 17, 20683, {1, 1, 3, 13, 25, 33, 113, 199, 297, 883, 1521, 3293, 161, 1845, 13657, 28431, 5633}},
    {8142, 17, 20704, {1, 1, 1, 3, 23, 47, 13, 241, 145, 883, 571, 3839, 8045, 713, 18451, 53435, 67591}},
    {8143, 17, 20724, {1, 3, 5, 1, 13, 23, 111, 77, 347, 61, 145, 755, 697, 14565, 9981, 39029, 113315}},
    {8144, 17, 20742, {1, 1, 3, 5, 23, 43, 45, 41, 261, 681, 1177, 2007, 5441, 1507, 11579, 54001, 69625}},
    {8145, 17, 20748, {1, 3, 1, 13, 5, 25, 113, 75, 259, 505, 1837, 947, 779, 13153, 15069, 23045, 72173}},
    {8146, 17, 20765, {1, 1, 5, 11, 29, 19, 63, 243, 3, 493, 1073, 2905, 3267, 6325, 19115, 38373, 21683}},
    {8147, 17, 20776, {1, 1, 3, 3, 3, 37, 29, 255, 313, 843, 1707, 149, 1227, 3643, 24939, 22191, 34061}},
    {8148, 17, 20789, {1, 3, 1, 5, 29, 41, 125, 21, 163, 659, 1911, 1243, 2961, 4151, 15963, 30593, 75687}},
    {8149, 17, 20796, {1, 1, 5, 5, 29, 3, 29, 117, 345, 149, 229, 2693, 3613, 9857, 19911, 44547, 67785}},
    {8150, 17, 20802, {1, 3, 7, 13, 5, 49, 61, 123, 443, 769, 1669, 2741, 6881, 5965, 9365, 43051, 2979}},
    {8151, 17, 20807, {1, 1, 7, 5, 27, 9, 103, 153, 345, 935, 103, 945, 6991, 7043, 11281, 21453, 85831}},
    {8152, 17, 20814, {1, 1, 3, 7, 27, 39, 27, 247, 493, 857, 1947, 1233, 2495, 2923, 3701, 23113, 122179}},
    {8153, 17, 20821, {1, 3, 3, 1, 9, 53, 39, 45, 495, 493, 1599, 3097, 933, 6395, 3279, 58463, 104451}},
    {8154, 17, 20832, {1, 1, 1, 3, 31, 33, 7, 61, 473, 259, 365, 3467, 4613, 12095, 4641, 1099, 105805}},
    {8155, 17, 20835, {1, 3, 3, 5, 21, 45, 79, 19, 43, 451, 1025, 781, 3475, 3741, 30451, 52627, 110005}},
    {8156, 17, 20847, {1, 3, 5, 15, 23, 7, 27, 131, 127, 219, 1069, 4083, 2261, 2629, 17167, 4741, 9421}},
    {8157, 17, 20859, {1, 3, 7, 15, 23, 63, 3, 11, 181, 713, 1001, 3249, 2869, 983, 27821, 25391, 82597}},
    {8158, 17, 20871, {1, 3, 7, 7, 19, 57, 103, 195, 211, 131, 1659, 2201, 3287, 9235, 22105, 22679, 101059}},
    {8159, 17, 20883, {1, 1, 3, 9, 25, 59, 27, 115, 337, 79, 1253, 141, 1603, 1625, 21531, 61691, 82209}},
    {8160, 17, 20886, {1, 1, 3, 13, 19, 37, 71, 15, 193, 79, 1503, 3111, 1623, 6865, 28305, 16029, 96035}},
    {8161, 17, 20892, {1, 3, 7, 7, 1, 17, 117, 61, 111, 533, 1973, 1925, 3211, 3081, 707, 12187, 74473}},
    {8162, 17, 20906, {1, 1, 5, 3, 9, 53, 37, 109, 373, 215, 557, 2459, 6071, 14607, 28427, 16225, 104215}},
    {8163, 17, 20908, {1, 1, 7, 13, 21, 27, 89, 251, 429, 311, 1395, 3045, 2701, 10687, 14891, 16131, 86155}},
    {8164, 17, 20957, {1, 1, 3, 1, 25, 25, 7, 199, 167, 355, 553, 3735, 7121, 13187, 20893, 38969, 14347}},
    {8165, 17, 20962, {1, 1, 5, 7, 1, 43, 93, 225, 53, 783, 1567, 551, 5871, 5951, 31781, 52529, 39309}},
    {8166, 17, 20968, {1, 1, 3, 15, 1, 29, 93, 61, 5, 213, 919, 625, 1553, 943, 23811, 54175, 78959}},
    {8167, 17, 20979, {1, 3, 7, 15, 31, 61, 71, 201, 17, 503, 1831, 2715, 4395, 16211, 15181, 28107, 55555}},
    {8168, 17, 20991, {1, 3, 7, 5, 29, 53, 85, 59, 501, 791, 1245, 2585, 6907, 16381, 8333, 29653, 82701}},
    {8169, 17, 20998, {1, 1, 5, 5, 11, 29, 127, 15, 259, 623, 2007, 1787, 4949, 8189, 20135, 29527, 96637}},
    {8170, 17, 21007, {1, 3, 3, 5, 25, 35, 39, 41, 481, 329, 1535, 2601, 2629, 6717, 6927, 37537, 95737}},
    {8171, 17, 21010, {1, 1, 5, 5, 21, 53, 79, 223, 495, 483, 533, 2983, 7593, 117, 12063, 46425, 110361}},
    {8172, 17, 21026, {1, 3, 5, 11, 29, 51, 105, 87, 63, 705, 1813, 2011, 6889, 773, 25499, 32151, 95813}},
    {8173, 17, 21037, {1, 3, 7, 3, 21, 31, 1, 27, 249, 907, 529, 1361, 7657, 3699, 31351, 37301, 78605}},
    {8174, 17, 21038, {1, 1, 3, 13, 21, 29, 3, 75, 107, 971, 1929, 1663, 4919, 9645, 23453, 59255, 21777}},
    {8175, 17, 21045, {1, 1, 7, 3, 21, 23, 55, 203, 139, 603, 1451, 1529, 6227, 5183, 31017, 18553, 126175}},
    {8176, 17, 21057, {1, 1, 5, 9, 5, 27, 97, 33, 443, 133, 703, 2069, 4605, 13147, 22371, 47101, 112165}},
    {8177, 17, 21082, {1, 1, 3, 11, 23, 37, 53, 37, 213, 595, 713, 647, 443, 287, 31425, 23511, 69719}},
    {8178, 17, 21093, {1, 1, 3, 3, 15, 7, 89, 81, 83, 297, 1725, 2885, 8017, 5369, 29403, 40587, 25947}},
    {8179, 17, 21094, {1, 1, 7, 1, 13, 5, 45, 195, 353, 259, 897, 1663, 1759, 12415, 31307, 50159, 96967}},
    {8180, 17, 21105, {1, 3, 3, 9, 5, 3, 27, 241, 1, 983, 1279, 561, 5853, 11955, 5047, 8253, 47501}},
    {8181, 17, 21117, {1, 1, 1, 7, 27, 43, 13, 77, 51, 739, 1695, 3043, 7183, 4689, 3243, 993, 48005}},
    {8182, 17, 21121, {1, 1, 7, 9, 11, 45, 103, 15, 329, 367, 843, 1703, 1893, 14835, 18377, 3359, 38657}},
    {8183, 17, 21124, {1, 3, 7, 13, 19, 49, 39, 131, 201, 167, 703, 441, 4797, 8971, 21649, 16387, 79815}},
    {8184, 17, 21136, {1, 3, 3, 13, 5, 1, 51, 185, 27, 387, 1597, 2887, 7939, 3419, 19307, 32747, 90159}},
    {8185, 17, 21139, {1, 3, 5, 13, 29, 55, 125, 211, 329, 893, 1347, 2001, 5073, 8327, 15663, 55527, 73063}},
    {8186, 17, 21142, {1, 3, 1, 1, 15, 35, 69, 211, 219, 655, 1209, 1461, 1897, 12995, 553, 28723, 40365}},
    {8187, 17, 21145, {1, 1, 1, 7, 15, 13, 93, 209, 181, 765, 2031, 3889, 6071, 9055, 10775, 2807, 115655}},
    {8188, 17, 21167, {1, 3, 5, 5, 21, 13, 15, 63, 137, 967, 671, 97, 4111, 12689, 4079, 14583, 124379}},
    {8189, 17, 21170, {1, 3, 1, 7, 9, 53, 69, 45, 481, 809, 1233, 2713, 2113, 11855, 4477, 29411, 30371}},
    {8190, 17, 21175, {1, 3, 1, 3, 31, 7, 15, 211, 15, 767, 625, 41, 2439, 2845, 25693, 50757, 111939}},
    {8191, 17, 21179, {1, 1, 5, 11, 17, 29, 57, 189, 141, 79, 1405, 3045, 3049, 3159, 29945, 10517, 52227}},
    {8192, 17, 21182, {1, 1, 1, 15, 23, 1, 87, 139, 401, 603, 387, 1375, 5403, 1381, 31485, 48911, 124817}},
    {8193, 17, 21193, {1, 3, 1, 15, 19, 37, 7, 33, 153, 63, 1349, 629, 4843, 3761, 1537, 45677, 107297}},
    {8194, 17, 21194, {1, 1, 3, 11, 13, 45, 31, 57, 115, 919, 1743, 2403, 5149, 5073, 673, 23993, 3961}},
    {8195, 17, 21207, {1, 3, 1, 15, 27, 3, 49, 187, 209, 921, 1565, 1467, 2425, 777, 5673, 9533, 123567}},
    {8196, 17, 21217, {1, 3, 1, 11, 13, 3, 27, 57, 207, 399, 1423, 2483, 2067, 12157, 11957, 15271, 91815}},
    {8197, 17, 21224, {1, 3, 7, 15, 29, 7, 7, 45, 453, 383, 755, 949, 4585, 2141, 29765, 6789, 31053}},
    {8198, 17, 21244, {1, 1, 5, 13, 27, 51, 111, 173, 471, 113, 565, 1003, 3327, 4749, 4799, 9981, 118537}},
    {8199, 17, 21247, {1, 1, 7, 5, 29, 53, 111, 171, 121, 703, 2023, 2751, 3527, 987, 1043, 52973, 60943}},
    {8200, 17, 21252, {1, 1, 5, 3, 15, 57, 123, 149, 321, 539, 169, 173, 4831, 279, 8575, 49017, 117731}},
    {8201, 17, 21264, {1, 3, 3, 1, 25, 43, 47, 47, 491, 125, 1315, 2857, 2667, 12895, 26545, 51361, 9733}},
    {8202, 17, 21273, {1, 1, 1, 9, 31, 61, 93, 73, 377, 795, 997, 1963, 1437, 121, 18815, 54743, 69459}},
    {8203, 17, 21289, {1, 3, 5, 3, 15, 29, 21, 121, 299, 803, 1967, 449, 5469, 1831, 32209, 49499, 44033}},
    {8204, 17, 21290, {1, 3, 5, 15, 9, 53, 113, 103, 275, 323, 1417, 1129, 363, 3381, 467, 49095, 65667}},
    {8205, 17, 21295, {1, 3, 7, 7, 31, 23, 73, 241, 209, 459, 1309, 1081, 2213, 9275, 27917, 30693, 111147}},
    {8206, 17, 21297, {1, 3, 3, 3, 5, 7, 39, 175, 369, 789, 117, 2465, 5377, 1173, 28425, 39601, 119007}},
    {8207, 17, 21309, {1, 1, 5, 7, 7, 53, 97, 179, 293, 505, 1031, 2733, 3361, 3777, 14535, 37587, 78477}},
    {8208, 17, 21318, {1, 3, 1, 5, 9, 55, 1, 165, 289, 971, 1235, 1439, 5719, 8717, 32129, 60203, 44033}},
    {8209, 17, 21322, {1, 3, 1, 9, 21, 43, 93, 193, 85, 361, 1401, 3659, 731, 3595, 18939, 33183, 48673}},
    {8210, 17, 21324, {1, 1, 1, 7, 27, 53, 99, 91, 41, 403, 1297, 47, 2415, 8851, 6345, 52397, 17833}},
    {8211, 17, 21329, {1, 1, 3, 9, 27, 63, 69, 121, 205, 569, 167, 3013, 2877, 9355, 6545, 9373, 63611}},
    {8212, 17, 21332, {1, 1, 5, 5, 17, 41, 7, 69, 43, 883, 1649, 4025, 2755, 7343, 22043, 11071, 11939}},
    {8213, 17, 21336, {1, 1, 7, 3, 11, 11, 67, 61, 131, 805, 1355, 2591, 7193, 4743, 11287, 30251, 100173}},
    {8214, 17, 21342, {1, 1, 5, 9, 5, 17, 25, 233, 55, 781, 1959, 3675, 2579, 2725, 24863, 57553, 74839}},
    {8215, 17, 21351, {1, 1, 1, 11, 27, 51, 59, 49, 385, 785, 1883, 817, 7823, 6353, 28983, 42363, 105233}},
    {8216, 17, 21355, {1, 1, 5, 9, 17, 33, 121, 91, 81, 409, 1651, 2901, 2453, 16147, 23153, 6193, 93877}},
    {8217, 17, 21363, {1, 1, 3, 7, 7, 37, 107, 205, 479, 301, 1579, 1091, 1079, 6635, 24449, 28345, 88387}},
    {8218, 17, 21372, {1, 3, 3, 9, 7, 41, 39, 125, 253, 87, 49, 3563, 6465, 11699, 25321, 53469, 42947}},
    {8219, 17, 21382, {1, 1, 7, 7, 19, 7, 33, 123, 25, 125, 1885, 85, 1353, 12899, 22485, 15167, 97031}},
    {8220, 17, 21388, {1, 1, 7, 5, 9, 9, 119, 43, 481, 313, 1449, 1881, 3743, 12927, 5459, 7331, 29917}},
    {8221, 17, 21394, {1, 1, 3, 15, 15, 23, 13, 137, 425, 251, 701, 791, 2949, 14559, 11011, 12249, 103251}},
    {8222, 17, 21403, {1, 1, 7, 11, 13, 39, 21, 173, 77, 13, 1529, 545, 4019, 3419, 1359, 48429, 89801}},
    {8223, 17, 21409, {1, 1, 1, 5, 15, 43, 35, 17, 217, 57, 1751, 1667, 293, 1411, 30751, 23351, 101379}},
    {8224, 17, 21416, {1, 1, 5, 5, 23, 41, 95, 7, 213, 803, 1655, 3903, 3405, 10001, 5303, 5065, 107303}},
    {8225, 17, 21421, {1, 3, 3, 3, 27, 1, 111, 127, 317, 567, 987, 3851, 6059, 15793, 28831, 45897, 79875}},
    {8226, 17, 21424, {1, 3, 7, 5, 5, 61, 55, 143, 443, 829, 1667, 1995, 4079, 7005, 23059, 23889, 4981}},
    {8227, 17, 21444, {1, 3, 1, 3, 5, 63, 121, 245, 29, 797, 243, 2367, 1733, 475, 18655, 20931, 82947}},
    {8228, 17, 21453, {1, 1, 3, 5, 23, 21, 115, 199, 235, 965, 1437, 1059, 5203, 3871, 5463, 40353, 23575}},
    {8229, 17, 21466, {1, 1, 7, 1, 13, 55, 89, 173, 219, 473, 227, 3317, 1193, 13283, 6801, 19615, 20449}},
    {8230, 17, 21471, {1, 1, 1, 3, 19, 55, 77, 169, 45, 493, 183, 3475, 3941, 4825, 31765, 41179, 40119}},
    {8231, 17, 21495, {1, 3, 1, 7, 31, 39, 65, 141, 29, 257, 979, 1037, 1425, 12097, 1711, 14997, 57499}},
    {8232, 17, 21499, {1, 1, 5, 5, 7, 55, 117, 161, 365, 421, 325, 833, 55, 14605, 15821, 40665, 14129}},
    {8233, 17, 21504, {1, 3, 5, 11, 5, 59, 7, 55, 471, 79, 727, 3069, 2487, 10651, 3963, 22497, 68519}},
    {8234, 17, 21507, {1, 3, 7, 5, 29, 19, 65, 241, 417, 275, 1061, 2213, 5887, 10199, 12795, 50415, 35527}},
    {8235, 17, 21521, {1, 3, 7, 13, 13, 31, 5, 235, 349, 867, 353, 1473, 2707, 16151, 473, 55031, 122453}},
    {8236, 17, 21527, {1, 3, 3, 7, 11, 25, 117, 15, 303, 539, 517, 1115, 6179, 3957, 27015, 18285, 44787}},
    {8237, 17, 21555, {1, 3, 1, 7, 3, 15, 63, 91, 505, 579, 483, 3919, 1087, 7109, 9449, 30545, 111703}},
    {8238, 17, 21558, {1, 3, 1, 1, 5, 51, 77, 41, 275, 229, 1847, 3557, 3769, 1439, 24721, 38255, 92605}},
    {8239, 17, 21562, {1, 3, 7, 15, 15, 13, 59, 41, 41, 775, 1041, 2941, 2455, 6021, 11989, 55727, 62193}},
    {8240, 17, 21570, {1, 3, 7, 3, 3, 43, 121, 233, 291, 257, 339, 2409, 8171, 9577, 16535, 34233, 81827}},
    {8241, 17, 21576, {1, 1, 1, 11, 25, 33, 107, 49, 169, 991, 237, 1125, 3891, 699, 10979, 52199, 48291}},
    {8242, 17, 21579, {1, 1, 5, 13, 9, 41, 95, 163, 405, 567, 1539, 2333, 1227, 13943, 31667, 38495, 8003}},
    {8243, 17, 21581, {1, 3, 3, 11, 23, 35, 71, 43, 151, 195, 1229, 3137, 917, 8123, 9881, 59041, 57497}},
    {8244, 17, 21587, {1, 1, 5, 15, 19, 53, 97, 69, 349, 283, 1691, 1403, 3653, 9751, 11133, 51937, 82497}},
    {8245, 17, 21590, {1, 3, 7, 3, 13, 9, 7, 101, 327, 945, 591, 1991, 1829, 11907, 1817, 34043, 95337}},
    {8246, 17, 21599, {1, 3, 5, 3, 25, 23, 57, 207, 157, 1007, 39, 1327, 7505, 10359, 15601, 13357, 10237}},
    {8247, 17, 21605, {1, 1, 3, 11, 5, 49, 25, 43, 379, 751, 821, 835, 1627, 9033, 20357, 64797, 125101}},
    {8248, 17, 21612, {1, 3, 3, 13, 15, 57, 121, 237, 257, 197, 1461, 3285, 7121, 1067, 16273, 11831, 35343}},
    {8249, 17, 21618, {1, 3, 5, 9, 23, 9, 81, 201, 197, 745, 1831, 2791, 7935, 9299, 177, 36505, 77213}},
    {8250, 17, 21630, {1, 1, 3, 3, 21, 51, 85, 151, 239, 965, 511, 3025, 4833, 14743, 6979, 23649, 127515}},
    {8251, 17, 21639, {1, 1, 1, 11, 23, 35, 49, 243, 353, 789, 1331, 1211, 1961, 2327, 19499, 43291, 74069}},
    {8252, 17, 21640, {1, 3, 5, 5, 23, 25, 87, 15, 273, 1019, 1483, 2713, 3947, 10071, 23581, 13589, 35445}},
    {8253, 17, 21643, {1, 3, 5, 3, 29, 9, 121, 137, 301, 213, 1355, 2947, 4561, 14251, 11113, 15911, 87837}},
    {8254, 17, 21648, {1, 1, 3, 13, 19, 29, 29, 91, 77, 279, 1057, 3027, 163, 12991, 27409, 57577, 90933}},
    {8255, 17, 21669, {1, 1, 5, 9, 1, 59, 81, 211, 459, 99, 1919, 2987, 7319, 9111, 29719, 59551, 54207}},
    {8256, 17, 21679, {1, 1, 7, 1, 21, 33, 67, 73, 199, 769, 1453, 3401, 5469, 693, 9509, 22203, 36613}},
    {8257, 17, 21681, {1, 1, 1, 7, 3, 51, 9, 139, 253, 851, 1537, 3433, 545, 1583, 22599, 23253, 123401}},
    {8258, 17, 21687, {1, 1, 7, 11, 5, 19, 3, 109, 129, 747, 1, 253, 59, 3059, 3553, 38975, 88401}},
    {8259, 17, 21688, {1, 1, 1, 11, 1, 25, 75, 153, 221, 927, 107, 4037, 1245, 6263, 5365, 18549, 47083}},
    {8260, 17, 21706, {1, 3, 5, 9, 3, 41, 83, 37, 385, 533, 1885, 3999, 1043, 2329, 24701, 35941, 92409}},
    {8261, 17, 21713, {1, 1, 3, 7, 17, 7, 97, 237, 445, 261, 655, 3005, 2529, 1035, 9943, 22379, 56323}},
    {8262, 17, 21714, {1, 3, 7, 5, 31, 19, 87, 199, 431, 621, 465, 2855, 143, 9439, 24075, 15655, 91145}},
    {8263, 17, 21716, {1, 3, 3, 7, 27, 63, 27, 181, 183, 701, 1623, 1079, 1693, 9825, 16199, 56917, 78789}},
    {8264, 17, 21730, {1, 1, 3, 11, 19, 43, 31, 207, 77, 611, 273, 485, 2095, 6523, 22443, 58905, 97489}},
    {8265, 17, 21732, {1, 1, 5, 7, 31, 61, 1, 37, 421, 231, 755, 271, 293, 4491, 6701, 15025, 74755}},
    {8266, 17, 21749, {1, 1, 5, 13, 29, 45, 53, 229, 507, 739, 347, 1479, 3001, 7689, 21739, 21389, 92541}},
    {8267, 17, 21756, {1, 1, 1, 7, 31, 5, 107, 85, 117, 247, 1185, 2305, 1645, 11723, 10681, 31489, 84659}},
    {8268, 17, 21774, {1, 1, 3, 9, 13, 23, 39, 81, 385, 921, 1091, 1123, 115, 12465, 5287, 63923, 30283}},
    {8269, 17, 21779, {1, 1, 3, 13, 29, 5, 9, 157, 397, 621, 1353, 3581, 8157, 4841, 5281, 39853, 67557}},
    {8270, 17, 21781, {1, 1, 3, 13, 29, 57, 21, 71, 167, 823, 1607, 3549, 5449, 3537, 11421, 61811, 19819}},
    {8271, 17, 21786, {1, 1, 1, 13, 21, 41, 13, 189, 343, 841, 155, 711, 3381, 14875, 17685, 6181, 44711}},
    {8272, 17, 21792, {1, 1, 1, 15, 19, 35, 95, 223, 463, 387, 517, 3493, 717, 1631, 14761, 3481, 65305}},
    {8273, 17, 21810, {1, 3, 3, 13, 25, 37, 19, 201, 257, 653, 1079, 2787, 4595, 11135, 25741, 6015, 57091}},
    {8274, 17, 21819, {1, 3, 1, 11, 31, 11, 81, 243, 417, 731, 597, 2937, 3727, 5977, 12313, 49061, 46963}},
    {8275, 17, 21829, {1, 1, 7, 1, 17, 23, 31, 235, 495, 147, 359, 991, 8055, 13939, 25419, 47257, 37137}},
    {8276, 17, 21830, {1, 1, 7, 13, 29, 41, 1, 5, 505, 727, 1885, 2323, 1689, 14093, 21247, 41901, 12315}},
    {8277, 17, 21844, {1, 1, 5, 1, 11, 21, 107, 113, 209, 445, 1723, 2225, 3413, 6479, 4983, 35099, 37993}},
    {8278, 17, 21853, {1, 3, 7, 15, 1, 7, 119, 79, 255, 819, 457, 2755, 7173, 13011, 28071, 7089, 121839}},
    {8279, 17, 21867, {1, 1, 3, 9, 11, 21, 77, 231, 189, 817, 531, 3181, 843, 4489, 15171, 64219, 126253}},
    {8280, 17, 21869, {1, 3, 7, 7, 9, 33, 125, 151, 465, 447, 781, 893, 1141, 14297, 4565, 8941, 50849}},
    {8281, 17, 21882, {1, 1, 3, 9, 13, 9, 65, 221, 49, 459, 249, 2651, 1715, 16005, 19621, 59809, 104057}},
    {8282, 17, 21891, {1, 1, 3, 5, 3, 57, 95, 251, 51, 93, 1819, 3089, 4581, 4525, 14625, 61731, 36965}},
    {8283, 17, 21898, {1, 3, 3, 5, 27, 33, 113, 33, 331, 197, 1819, 311, 7329, 12391, 19187, 6675, 7359}},
    {8284, 17, 21917, {1, 3, 7, 13, 19, 9, 87, 247, 273, 11, 1419, 755, 2693, 10717, 17949, 42707, 44891}},
    {8285, 17, 21934, {1, 3, 1, 15, 31, 23, 85, 63, 439, 157, 1069, 1857, 6017, 2603, 22697, 4007, 130037}},
    {8286, 17, 21946, {1, 1, 5, 9, 27, 19, 77, 175, 391, 325, 5, 1455, 6657, 10785, 13599, 29605, 8609}},
    {8287, 17, 21948, {1, 3, 5, 7, 23, 27, 89, 87, 389, 993, 2025, 1759, 2957, 15347, 11015, 28541, 64621}},
    {8288, 17, 21963, {1, 1, 1, 1, 27, 63, 13, 23, 309, 883, 1403, 1607, 8005, 7057, 13243, 54977, 10427}},
    {8289, 17, 21966, {1, 3, 1, 9, 7, 57, 115, 19, 115, 475, 1411, 885, 5215, 9971, 12355, 42743, 37025}},
    {8290, 17, 21968, {1, 1, 1, 3, 15, 49, 17, 31, 151, 651, 1453, 1893, 7429, 7061, 7261, 61481, 34677}},
    {8291, 17, 21973, {1, 3, 1, 5, 9, 35, 27, 37, 343, 287, 1763, 3499, 6121, 2101, 26677, 41949, 97573}},
    {8292, 17, 21977, {1, 3, 1, 13, 11, 9, 127, 149, 489, 181, 359, 1921, 2259, 1525, 20005, 7831, 58935}},
    {8293, 17, 21980, {1, 1, 3, 9, 19, 7, 47, 31, 237, 323, 1119, 2561, 5177, 8875, 6917, 7027, 2529}},
    {8294, 17, 21984, {1, 1, 5, 5, 7, 57, 73, 95, 11, 13, 1469, 3223, 6017, 10243, 21223, 45847, 46921}},
    {8295, 17, 21994, {1, 3, 7, 9, 19, 59, 113, 235, 197, 483, 177, 1629, 4335, 1055, 32547, 15461, 64201}},
    {8296, 17, 21999, {1, 1, 3, 1, 31, 43, 79, 121, 313, 973, 979, 3805, 31, 5343, 24311, 11549, 37005}},
    {8297, 17, 22018, {1, 3, 5, 7, 3, 45, 109, 89, 131, 573, 1517, 1917, 6301, 5259, 27615, 32493, 17919}},
    {8298, 17, 22020, {1, 3, 5, 3, 29, 59, 39, 145, 477, 227, 519, 271, 3247, 2019, 6875, 19617, 73895}},
    {8299, 17, 22029, {1, 1, 7, 5, 25, 63, 29, 141, 7, 977, 1115, 1059, 2645, 8293, 23959, 7379, 117569}},
    {8300, 17, 22032, {1, 1, 5, 1, 5, 63, 121, 141, 467, 143, 897, 1433, 1177, 8441, 25899, 223, 85581}},
    {8301, 17, 22041, {1, 1, 7, 11, 7, 35, 59, 227, 35, 229, 463, 415, 3565, 15761, 16047, 46329, 57201}},
    {8302, 17, 22047, {1, 3, 3, 9, 13, 51, 47, 127, 21, 565, 1041, 2211, 4549, 12863, 19825, 24109, 26047}},
    {8303, 17, 22048, {1, 1, 3, 3, 23, 25, 55, 213, 505, 425, 295, 1253, 7851, 8397, 5475, 62607, 37415}},
    {8304, 17, 22071, {1, 1, 5, 5, 25, 43, 73, 9, 431, 377, 851, 1227, 4801, 4893, 32429, 9693, 56897}},
    {8305, 17, 22075, {1, 3, 5, 5, 15, 39, 31, 179, 407, 813, 1025, 105, 8081, 9133, 17665, 36547, 64513}},
    {8306, 17, 22078, {1, 3, 5, 11, 17, 33, 73, 173, 267, 759, 1641, 587, 1659, 1543, 11583, 22881, 13213}},
    {8307, 17, 22083, {1, 1, 7, 3, 21, 1, 5, 3, 317, 73, 881, 3491, 6781, 2183, 921, 39805, 25165}},
    {8308, 17, 22089, {1, 3, 3, 11, 23, 37, 1, 147, 207, 407, 1519, 1991, 1279, 3817, 29839, 30017, 113067}},
    {8309, 17, 22097, {1, 1, 1, 11, 21, 55, 125, 73, 235, 601, 803, 1705, 4461, 7139, 31591, 63699, 16433}},
    {8310, 17, 22110, {1, 3, 7, 5, 21, 13, 125, 155, 497, 311, 1607, 217, 4873, 12759, 30479, 41597, 38865}},
    {8311, 17, 22113, {1, 3, 5, 7, 1, 5, 115, 167, 89, 477, 1979, 1641, 1881, 9409, 2401, 23459, 92927}},
    {8312, 17, 22119, {1, 3, 7, 7, 5, 39, 9, 157, 259, 497, 525, 2937, 2513, 15391, 2743, 65397, 56463}},
    {8313, 17, 22120, {1, 3, 7, 5, 23, 37, 75, 243, 279, 49, 1557, 987, 1413, 1243, 13349, 51519, 108931}},
    {8314, 17, 22126, {1, 1, 7, 9, 21, 35, 95, 171, 55, 233, 1883, 3327, 4733, 733, 31713, 43757, 25083}},
    {8315, 17, 22133, {1, 1, 1, 7, 19, 45, 71, 73, 413, 49, 623, 449, 6845, 11953, 5523, 1033, 52265}},
    {8316, 17, 22134, {1, 3, 7, 7, 9, 5, 125, 79, 277, 997, 1241, 2795, 5653, 13835, 7327, 34069, 78839}},
    {8317, 17, 22140, {1, 1, 7, 1, 13, 3, 115, 167, 401, 567, 1021, 2583, 7843, 4293, 30207, 17535, 97955}},
    {8318, 17, 22147, {1, 3, 3, 13, 3, 47, 37, 51, 147, 133, 1289, 2973, 1361, 2531, 28313, 3949, 76037}},
    {8319, 17, 22161, {1, 3, 1, 11, 29, 33, 63, 107, 113, 263, 1931, 1149, 6887, 7635, 25759, 52933, 107357}},
    {8320, 17, 22164, {1, 3, 1, 13, 5, 17, 105, 53, 329, 385, 1671, 1311, 7109, 3795, 17453, 23655, 11827}},
    {8321, 17, 22173, {1, 3, 5, 13, 7, 17, 97, 217, 229, 429, 1789, 2947, 4497, 8337, 13939, 50839, 11}},
    {8322, 17, 22197, {1, 3, 5, 3, 19, 17, 73, 121, 207, 903, 1709, 3541, 1371, 9957, 16539, 38877, 13153}},
    {8323, 17, 22207, {1, 3, 5, 5, 5, 59, 89, 87, 345, 707, 627, 3681, 6373, 12585, 9331, 25163, 91619}},
    {8324, 17, 22210, {1, 1, 5, 13, 31, 31, 7, 11, 251, 611, 2045, 3021, 6745, 12315, 29025, 32359, 3101}},
    {8325, 17, 22216, {1, 3, 1, 7, 11, 39, 115, 247, 123, 289, 2019, 2641, 5245, 6061, 10075, 42707, 65147}},
    {8326, 17, 22234, {1, 3, 3, 1, 19, 63, 119, 91, 79, 609, 1573, 4021, 393, 12633, 31527, 2559, 2647}},
    {8327, 17, 22257, {1, 3, 3, 5, 5, 37, 117, 183, 55, 209, 69, 3749, 2357, 1477, 16967, 59771, 92301}},
    {8328, 17, 22264, {1, 1, 1, 3, 1, 13, 47, 91, 349, 203, 965, 2843, 4509, 6399, 10119, 25607, 3393}},
    {8329, 17, 22278, {1, 3, 1, 13, 1, 57, 127, 17, 453, 795, 1317, 3671, 7033, 355, 1001, 58143, 95377}},
    {8330, 17, 22284, {1, 3, 7, 3, 9, 55, 23, 221, 139, 769, 1243, 2387, 4101, 3489, 28401, 43311, 94957}},
    {8331, 17, 22287, {1, 3, 7, 3, 9, 53, 65, 101, 109, 121, 233, 3581, 6783, 15313, 6339, 39679, 119279}},
    {8332, 17, 22299, {1, 3, 1, 15, 25, 29, 49, 247, 201, 237, 1537, 3837, 6913, 1363, 3497, 30265, 55921}},
    {8333, 17, 22301, {1, 3, 1, 15, 31, 31, 13, 5, 351, 425, 461, 2879, 3285, 4923, 28227, 11023, 121983}},
    {8334, 17, 22308, {1, 3, 3, 15, 25, 19, 115, 73, 163, 557, 1365, 1205, 7845, 2977, 6293, 4039, 100505}},
    {8335, 17, 22337, {1, 3, 5, 13, 13, 9, 37, 209, 117, 49, 973, 2547, 2035, 7595, 15029, 9035, 83281}},
    {8336, 17, 22349, {1, 3, 1, 15, 5, 3, 27, 85, 425, 835, 187, 419, 1133, 5503, 6321, 62805, 128591}},
    {8337, 17, 22350, {1, 1, 3, 13, 21, 7, 103, 219, 283, 235, 193, 723, 3909, 15239, 28373, 5961, 59495}},
    {8338, 17, 22357, {1, 3, 5, 1, 7, 47, 101, 167, 333, 587, 171, 4089, 7375, 7817, 17181, 31765, 60007}},
    {8339, 17, 22364, {1, 1, 5, 1, 1, 53, 49, 81, 385, 311, 1571, 2977, 6553, 13629, 14203, 52835, 70309}},
    {8340, 17, 22373, {1, 3, 5, 11, 17, 59, 29, 65, 453, 579, 1735, 1375, 4697, 6829, 9701, 19163, 44603}},
    {8341, 17, 22377, {1, 1, 1, 13, 25, 13, 15, 61, 387, 147, 127, 491, 4495, 15677, 3045, 35481, 51303}},
    {8342, 17, 22380, {1, 1, 5, 3, 3, 17, 19, 47, 499, 397, 667, 3373, 1771, 4453, 9519, 48939, 121915}},
    {8343, 17, 22386, {1, 1, 7, 7, 23, 11, 63, 199, 301, 991, 1731, 3197, 6045, 15807, 20519, 6513, 39499}},
    {8344, 17, 22391, {1, 1, 3, 7, 7, 55, 3, 221, 193, 837, 647, 3977, 3931, 659, 22703, 44437, 79309}},
    {8345, 17, 22392, {1, 3, 1, 13, 5, 43, 23, 179, 277, 891, 1165, 1489, 4201, 5573, 31557, 56653, 52003}},
    {8346, 17, 22411, {1, 1, 7, 7, 19, 17, 39, 121, 181, 103, 967, 253, 4241, 3747, 5305, 19943, 57867}},
    {8347, 17, 22422, {1, 1, 5, 11, 31, 19, 79, 47, 321, 115, 969, 3025, 2977, 2033, 675, 35547, 49069}},
    {8348, 17, 22425, {1, 1, 3, 3, 31, 3, 77, 113, 361, 487, 1187, 1405, 3789, 11917, 965, 21983, 2045}},
    {8349, 17, 22431, {1, 3, 5, 11, 7, 15, 59, 9, 365, 571, 1455, 3995, 2091, 6425, 12891, 53849, 3235}},
    {8350, 17, 22438, {1, 3, 5, 5, 27, 3, 111, 121, 113, 625, 2005, 2271, 7469, 10727, 3221, 33393, 117489}},
    {8351, 17, 22441, {1, 3, 1, 13, 17, 29, 91, 71, 301, 51, 2009, 2581, 377, 6311, 29217, 49049, 48085}},
    {8352, 17, 22442, {1, 1, 5, 9, 15, 51, 37, 135, 301, 389, 1195, 127, 5045, 553, 3437, 37005, 90425}},
    {8353, 17, 22449, {1, 1, 5, 13, 31, 17, 73, 247, 115, 345, 1943, 2315, 7671, 5017, 3815, 45501, 125823}},
    {8354, 17, 22452, {1, 1, 1, 3, 31, 33, 7, 61, 473, 259, 365, 3467, 4613, 12095, 4641, 1099, 105805}},
    {8355, 17, 22461, {1, 3, 3, 5, 21, 45, 79, 19, 43, 451, 1025, 781, 3475, 3741, 30451, 52627, 110005}},
    {8356, 17, 22467, {1, 1, 1, 15, 9, 35, 29, 25, 93, 25, 113, 1693, 837, 12265, 11129, 27981, 51169}},
    {8357, 17, 22479, {1, 3, 1, 13, 25, 55, 67, 245, 269, 853, 2021, 2453, 4975, 7271, 29321, 25745, 72345}},
    {8358, 17, 22484, {1, 3, 7, 5, 5, 43, 89, 157, 377, 815, 1573, 3875, 5317, 12119, 31427, 21969, 16959}},
    {8359, 17, 22487, {1, 1, 3, 9, 25, 59, 27, 115, 337, 79, 1253, 141, 1603, 1625, 21531, 61691, 82209}},
    {8360, 17, 22493, {1, 3, 7, 15, 23, 45, 61, 163, 17, 757, 585, 101, 5251, 2529, 5917, 44263, 129943}},
    {8361, 17, 22510, {1, 3, 7, 1, 3, 47, 103, 25, 473, 575, 1429, 3471, 3605, 15407, 2817, 8221, 12675}},
    {8362, 17, 22521, {1, 3, 5, 5, 9, 33, 119, 119, 43, 69, 359, 3427, 1537, 9029, 24639, 12595, 18079}},
    {8363, 17, 22533, {1, 1, 5, 5, 31, 41, 49, 85, 259, 957, 1469, 2097, 5035, 1673, 3795, 51393, 128091}},
    {8364, 17, 22534, {1, 1, 7, 11, 27, 31, 25, 239, 177, 345, 699, 1747, 6339, 9765, 28703, 65139, 125521}},
    {8365, 17, 22543, {1, 3, 5, 15, 3, 47, 75, 117, 185, 767, 1905, 1143, 5217, 4353, 1627, 3023, 35273}},
    {8366, 17, 22548, {1, 3, 3, 13, 13, 51, 63, 129, 385, 751, 1243, 2039, 4251, 1001, 18795, 1117, 50905}},
    {8367, 17, 22552, {1, 3, 5, 3, 19, 25, 53, 201, 239, 637, 1843, 4065, 5643, 4831, 26967, 30193, 46313}},
    {8368, 17, 22558, {1, 1, 3, 3, 1, 23, 91, 255, 181, 163, 125, 959, 6715, 6711, 19451, 64469, 2195}},
    {8369, 17, 22561, {1, 3, 7, 1, 5, 49, 109, 139, 37, 693, 1131, 3945, 2835, 319, 21437, 34929, 57191}},
    {8370, 17, 22562, {1, 3, 3, 1, 15, 21, 91, 173, 299, 81, 753, 4047, 4353, 5813, 13421, 4975, 93347}},
    {8371, 17, 22568, {1, 1, 7, 7, 15, 35, 3, 193, 189, 63, 1705, 3095, 2213, 13059, 23083, 6595, 130811}},
    {8372, 17, 22571, {1, 1, 3, 9, 3, 19, 113, 217, 225, 601, 1385, 3953, 4593, 14223, 13415, 39245, 121985}},
    {8373, 17, 22574, {1, 3, 7, 5, 31, 61, 127, 247, 69, 315, 639, 2047, 5953, 447, 11351, 21615, 32567}},
    {8374, 17, 22581, {1, 3, 5, 15, 17, 33, 91, 43, 15, 21, 1261, 1681, 5157, 10073, 2491, 9535, 74229}},
    {8375, 17, 22594, {1, 3, 1, 9, 5, 33, 75, 181, 227, 877, 807, 3037, 2419, 9941, 20725, 60669, 54263}},
    {8376, 17, 22603, {1, 3, 7, 5, 25, 47, 39, 151, 457, 121, 1663, 3969, 877, 14585, 14045, 62427, 130833}},
    {8377, 17, 22605, {1, 1, 5, 9, 5, 27, 97, 33, 443, 133, 703, 2069, 4605, 13147, 22371, 47101, 112165}},
    {8378, 17, 22606, {1, 1, 7, 9, 19, 61, 121, 73, 211, 299, 1773, 3473, 57, 9279, 28757, 45871, 7105}},
    {8379, 17, 22623, {1, 1, 3, 15, 11, 29, 25, 179, 395, 863, 33, 3525, 2797, 2443, 21749, 631, 26881}},
    {8380, 17, 22630, {1, 1, 3, 11, 11, 29, 41, 133, 387, 553, 499, 2611, 6089, 3191, 17067, 19353, 127481}},
    {8381, 17, 22651, {1, 3, 1, 11, 7, 57, 87, 31, 395, 685, 55, 2981, 4701, 11947, 8103, 23363, 99581}},
    {8382, 17, 22657, {1, 3, 1, 5, 15, 33, 89, 53, 33, 227, 367, 3127, 5393, 8823, 14227, 37159, 42719}},
    {8383, 17, 22669, {1, 1, 3, 7, 27, 39, 57, 221, 469, 497, 1407, 1187, 665, 3777, 14265, 61319, 43209}},
    {8384, 17, 22670, {1, 1, 3, 15, 17, 61, 93, 195, 191, 369, 1001, 4015, 4507, 12493, 4327, 50179, 63931}},
    {8385, 17, 22677, {1, 3, 1, 1, 13, 9, 89, 221, 205, 669, 535, 3235, 2441, 10011, 16847, 50279, 16343}},
    {8386, 17, 22682, {1, 1, 1, 1, 29, 53, 47, 133, 363, 445, 1885, 3171, 629, 16027, 26731, 25065, 45735}},
    {8387, 17, 22698, {1, 1, 7, 13, 11, 63, 65, 121, 5, 871, 139, 1559, 3163, 12239, 12659, 60497, 43757}},
    {8388, 17, 22712, {1, 3, 3, 1, 21, 41, 99, 37, 291, 57, 1597, 3009, 1767, 6459, 6903, 45627, 52339}},
    {8389, 17, 22715, {1, 3, 3, 5, 31, 11, 47, 13, 315, 917, 1891, 1085, 6313, 13743, 2461, 55509, 99343}},
    {8390, 17, 22729, {1, 3, 5, 1, 9, 53, 115, 197, 205, 703, 803, 1347, 757, 15553, 8149, 37867, 7865}},
    {8391, 17, 22732, {1, 1, 1, 1, 19, 43, 123, 177, 401, 45, 183, 2489, 5889, 4219, 4793, 58625, 17195}},
    {8392, 17, 22735, {1, 1, 1, 15, 25, 15, 63, 127, 481, 751, 41, 3661, 677, 11631, 28763, 58143, 3703}},
    {8393, 17, 22738, {1, 3, 7, 15, 1, 51, 123, 15, 241, 525, 705, 3165, 2861, 16351, 23743, 26419, 15897}},
    {8394, 17, 22740, {1, 3, 5, 9, 21, 45, 25, 15, 363, 107, 673, 3615, 1697, 15853, 6269, 37501, 48159}},
    {8395, 17, 22750, {1, 3, 5, 7, 7, 21, 5, 149, 85, 91, 1939, 1123, 3349, 12857, 9703, 44435, 31017}},
    {8396, 17, 22753, {1, 1, 5, 11, 5, 9, 21, 23, 67, 265, 997, 1967, 721, 14523, 6081, 46641, 46539}},
    {8397, 17, 22760, {1, 1, 3, 1, 7, 51, 93, 179, 3, 23, 1587, 1369, 5005, 11643, 9515, 55103, 94069}},
    {8398, 17, 22765, {1, 1, 7, 3, 19, 43, 21, 19, 137, 521, 1875, 2079, 5333, 8073, 2117, 51809, 27675}},
    {8399, 17, 22768, {1, 1, 7, 1, 19, 25, 23, 189, 115, 131, 895, 1323, 4821, 8163, 3507, 52227, 83713}},
    {8400, 17, 22778, {1, 3, 7, 7, 7, 53, 99, 157, 331, 747, 585, 3383, 8015, 12201, 3249, 18599, 52185}},
    {8401, 17, 22785, {1, 3, 7, 1, 21, 55, 61, 109, 129, 601, 557, 1313, 7813, 3023, 4599, 45809, 65885}},
    {8402, 17, 22809, {1, 3, 1, 9, 25, 27, 45, 231, 445, 161, 681, 3351, 6307, 1603, 22679, 21081, 54333}},
    {8403, 17, 22810, {1, 1, 1, 5, 3, 29, 53, 41, 41, 333, 347, 2383, 437, 253, 26615, 44115, 125283}},
    {8404, 17, 22812, {1, 3, 3, 7, 29, 3, 9, 237, 273, 699, 2013, 2427, 1163, 11121, 16321, 59207, 48129}},
    {8405, 17, 22828, {1, 3, 1, 11, 13, 23, 23, 127, 421, 401, 1253, 1169, 171, 5377, 15035, 22929, 101379}},
    {8406, 17, 22840, {1, 1, 3, 7, 9, 15, 99, 253, 33, 795, 337, 1745, 5961, 11367, 16951, 20247, 16781}},
    {8407, 17, 22845, {1, 3, 5, 3, 27, 61, 111, 67, 437, 13, 1601, 3033, 2239, 12095, 26731, 26605, 32749}},
    {8408, 17, 22848, {1, 3, 1, 5, 25, 5, 65, 133, 487, 599, 1317, 163, 3685, 5485, 7361, 6333, 49085}},
    {8409, 17, 22857, {1, 3, 3, 5, 29, 25, 127, 107, 135, 769, 65, 2763, 2599, 15103, 10951, 36941, 102507}},
    {8410, 17, 22877, {1, 3, 5, 13, 1, 45, 23, 247, 485, 449, 1291, 763, 1921, 1143, 31693, 5565, 110077}},
    {8411, 17, 22882, {1, 3, 7, 13, 21, 27, 9, 79, 139, 657, 1071, 3111, 3911, 2349, 2055, 9311, 4933}},
    {8412, 17, 22887, {1, 3, 1, 15, 7, 61, 113, 85, 327, 63, 1841, 3433, 6375, 2257, 18483, 32773, 66415}},
    {8413, 17, 22894, {1, 3, 7, 15, 1, 33, 39, 59, 39, 423, 65, 3767, 177, 9107, 23157, 39759, 89451}},
    {8414, 17, 22912, {1, 3, 5, 1, 3, 19, 19, 189, 265, 69, 1173, 2575, 6929, 12317, 23651, 44707, 62311}},
    {8415, 17, 22930, {1, 3, 3, 3, 25, 13, 113, 55, 349, 219, 1737, 3533, 7573, 1431, 30593, 37155, 61351}},
    {8416, 17, 22936, {1, 3, 7, 7, 31, 7, 83, 167, 253, 271, 573, 2543, 1261, 3689, 18191, 8493, 10279}},
    {8417, 17, 22939, {1, 3, 3, 13, 11, 13, 11, 103, 285, 191, 967, 3567, 7575, 1917, 22929, 53333, 73473}},
    {8418, 17, 22957, {1, 3, 3, 9, 25, 57, 73, 217, 281, 353, 595, 555, 673, 2805, 27697, 40259, 98525}},
    {8419, 17, 22970, {1, 3, 5, 5, 15, 11, 113, 29, 183, 381, 101, 2247, 7681, 3063, 7885, 18775, 9899}},
    {8420, 17, 22980, {1, 1, 3, 7, 7, 37, 107, 205, 479, 301, 1579, 1091, 1079, 6635, 24449, 28345, 88387}},
    {8421, 17, 22984, {1, 3, 7, 1, 29, 57, 41, 93, 127, 167, 1479, 3245, 3053, 5635, 24515, 40753, 53345}},
    {8422, 17, 22992, {1, 1, 7, 5, 9, 9, 119, 43, 481, 313, 1449, 1881, 3743, 12927, 5459, 7331, 29917}},
    {8423, 17, 22998, {1, 3, 5, 1, 19, 25, 21, 149, 89, 653, 5, 3593, 4525, 715, 8093, 53115, 10739}},
    {8424, 17, 23001, {1, 3, 7, 11, 31, 13, 101, 157, 285, 799, 741, 2649, 6697, 8463, 5177, 11119, 117225}},
    {8425, 17, 23044, {1, 3, 1, 1, 15, 35, 57, 83, 281, 87, 835, 1561, 1735, 5257, 10417, 33019, 17895}},
    {8426, 17, 23061, {1, 1, 3, 9, 17, 47, 125, 105, 269, 707, 9, 3091, 2037, 5051, 18037, 22425, 90915}},
    {8427, 17, 23062, {1, 3, 3, 11, 21, 1, 117, 75, 317, 195, 891, 1331, 103, 1367, 10329, 23023, 6389}},
    {8428, 17, 23071, {1, 1, 1, 3, 23, 51, 17, 211, 459, 653, 1209, 1175, 4329, 6327, 1157, 41229, 86245}},
    {8429, 17, 23075, {1, 1, 3, 5, 13, 63, 75, 165, 155, 825, 1479, 3755, 6073, 11081, 18741, 46341, 55325}},
    {8430, 17, 23089, {1, 1, 3, 7, 7, 3, 93, 69, 183, 9, 499, 2913, 3655, 6355, 22229, 5427, 128153}},
    {8431, 17, 23090, {1, 1, 1, 15, 21, 55, 71, 23, 11, 917, 973, 1355, 3935, 203, 8321, 47747, 7753}},
    {8432, 17, 23096, {1, 3, 3, 1, 15, 35, 69, 35, 99, 17, 1453, 2515, 3543, 7423, 10103, 48693, 52365}},
    {8433, 17, 23101, {1, 1, 3, 15, 21, 15, 81, 187, 163, 661, 147, 3125, 189, 8065, 22167, 33831, 51923}},
    {8434, 17, 23114, {1, 3, 1, 5, 7, 3, 121, 71, 303, 843, 209, 1599, 5071, 5791, 21317, 10269, 8135}},
    {8435, 17, 23121, {1, 3, 5, 11, 11, 29, 125, 239, 103, 707, 1431, 1829, 4683, 7729, 4765, 10365, 122853}},
    {8436, 17, 23124, {1, 1, 1, 5, 29, 41, 125, 239, 395, 589, 1149, 2727, 2367, 10149, 23383, 46385, 43451}},
    {8437, 17, 23127, {1, 3, 3, 5, 1, 53, 109, 223, 505, 685, 167, 1361, 3651, 14067, 5921, 44623, 18011}},
    {8438, 17, 23128, {1, 3, 3, 3, 1, 23, 35, 225, 439, 43, 277, 2941, 7817, 7329, 21413, 48525, 109921}},
    {8439, 17, 23137, {1, 1, 1, 9, 29, 9, 99, 129, 443, 257, 1099, 2719, 5091, 12313, 7241, 50363, 43345}},
    {8440, 17, 23138, {1, 3, 5, 11, 21, 63, 57, 85, 343, 193, 1891, 1999, 3767, 4907, 24223, 34875, 101965}},
    {8441, 17, 23150, {1, 1, 7, 13, 3, 23, 43, 155, 295, 897, 465, 3565, 1743, 6449, 29343, 45537, 10803}},
    {8442, 17, 23155, {1, 3, 5, 5, 1, 21, 113, 121, 485, 541, 689, 3291, 7499, 12439, 5551, 29841, 94371}},
    {8443, 17, 23168, {1, 1, 1, 7, 19, 1, 101, 127, 331, 851, 221, 1045, 4181, 8867, 3029, 65249, 42003}},
    {8444, 17, 23173, {1, 3, 7, 1, 3, 1, 17, 117, 109, 201, 1335, 1583, 3385, 2599, 9675, 1887, 87181}},
    {8445, 17, 23174, {1, 1, 5, 15, 3, 57, 67, 41, 217, 393, 491, 2349, 519, 9985, 18999, 34543, 57189}},
    {8446, 17, 23195, {1, 3, 3, 13, 25, 33, 63, 233, 213, 325, 47, 2257, 3967, 11233, 26645, 48071, 3077}},
    {8447, 17, 23202, {1, 1, 7, 9, 29, 25, 111, 89, 441, 363, 1287, 2633, 5635, 4859, 28749, 6729, 90311}},
    {8448, 17, 23225, {1, 3, 7, 1, 5, 61, 65, 251, 411, 543, 1569, 2733, 4781, 15723, 7389, 44047, 42627}},
    {8449, 17, 23226, {1, 1, 5, 9, 25, 1, 11, 169, 257, 433, 935, 2875, 3035, 2881, 14445, 14657, 34441}},
    {8450, 17, 23239, {1, 1, 1, 11, 15, 11, 121, 219, 501, 285, 723, 2293, 2559, 8637, 21223, 41897, 1449}},
    {8451, 17, 23253, {1, 1, 5, 1, 5, 19, 11, 121, 49, 325, 1533, 3391, 2175, 10851, 17183, 5869, 21131}},
    {8452, 17, 23263, {1, 1, 3, 11, 3, 47, 19, 25, 395, 949, 551, 1231, 3791, 9211, 32717, 53417, 16215}},
    {8453, 17, 23264, {1, 1, 1, 15, 27, 51, 69, 31, 27, 437, 1663, 3029, 1587, 9791, 1353, 21725, 19555}},
    {8454, 17, 23281, {1, 1, 7, 9, 9, 3, 121, 227, 293, 99, 1397, 4061, 1185, 391, 25487, 22531, 42389}},
    {8455, 17, 23282, {1, 3, 3, 3, 15, 17, 97, 175, 17, 613, 953, 4033, 7151, 9071, 11991, 7429, 2195}},
    {8456, 17, 23288, {1, 1, 5, 13, 17, 15, 99, 231, 41, 875, 1661, 697, 887, 13025, 127, 4949, 91777}},
    {8457, 17, 23294, {1, 1, 3, 5, 19, 41, 15, 235, 455, 905, 1865, 1533, 199, 13443, 6057, 32023, 101779}},
    {8458, 17, 23302, {1, 3, 1, 15, 15, 21, 1, 139, 25, 333, 1769, 1717, 1081, 11099, 20807, 60605, 92651}},
    {8459, 17, 23311, {1, 3, 1, 9, 17, 1, 59, 181, 447, 273, 849, 3623, 4489, 9959, 11499, 34703, 61333}},
    {8460, 17, 23320, {1, 1, 5, 1, 27, 7, 123, 171, 315, 795, 1547, 2819, 5705, 319, 13905, 43137, 47451}},
    {8461, 17, 23325, {1, 3, 5, 1, 21, 21, 63, 19, 55, 513, 1913, 3583, 811, 5861, 1223, 57655, 83607}},
    {8462, 17, 23356, {1, 1, 5, 9, 19, 25, 95, 3, 47, 67, 1773, 29, 7505, 15253, 6257, 5583, 72747}},
    {8463, 17, 23374, {1, 3, 3, 5, 9, 23, 87, 109, 69, 231, 1363, 1761, 7459, 14361, 17713, 10833, 28269}},
    {8464, 17, 23388, {1, 3, 7, 9, 1, 29, 57, 11, 369, 829, 1417, 2607, 6419, 4563, 29451, 25477, 18687}},
    {8465, 17, 23402, {1, 1, 5, 5, 5, 51, 127, 111, 59, 615, 1411, 973, 1543, 5477, 26585, 20653, 24287}},
    {8466, 17, 23415, {1, 3, 7, 5, 31, 19, 87, 199, 431, 621, 465, 2855, 143, 9439, 24075, 15655, 91145}},
    {8467, 17, 23421, {1, 3, 5, 7, 21, 17, 9, 185, 187, 721, 1375, 2231, 4373, 183, 22283, 50917, 37425}},
    {8468, 17, 23426, {1, 1, 5, 7, 21, 33, 85, 39, 39, 1007, 203, 1909, 6469, 12961, 22165, 31631, 18505}},
    {8469, 17, 23443, {1, 3, 5, 9, 15, 3, 99, 179, 33, 951, 1183, 1587, 5723, 6911, 6887, 1475, 116289}},
    {8470, 17, 23446, {1, 1, 5, 7, 27, 1, 5, 199, 335, 437, 639, 743, 2107, 10759, 12099, 5825, 79563}},
    {8471, 17, 23455, {1, 1, 3, 7, 9, 31, 31, 235, 81, 683, 1391, 1509, 2531, 6571, 23071, 40051, 100559}},
    {8472, 17, 23461, {1, 1, 1, 13, 5, 51, 89, 47, 325, 187, 31, 3353, 7883, 12681, 11293, 22451, 13181}},
    {8473, 17, 23468, {1, 1, 5, 15, 17, 23, 59, 143, 181, 511, 1731, 3511, 3365, 3273, 27961, 32413, 30371}},
    {8474, 17, 23471, {1, 3, 5, 7, 23, 61, 89, 175, 243, 71, 749, 299, 5465, 12977, 7599, 30975, 80553}},
    {8475, 17, 23485, {1, 3, 3, 3, 11, 57, 39, 63, 239, 757, 1447, 3715, 4005, 1107, 24903, 47883, 98181}},
    {8476, 17, 23486, {1, 3, 7, 15, 15, 39, 11, 125, 383, 277, 687, 3273, 105, 8741, 6057, 19709, 65241}},
    {8477, 17, 23488, {1, 3, 5, 7, 11, 9, 23, 241, 77, 773, 953, 1575, 7921, 1601, 24157, 47971, 90707}},
    {8478, 17, 23498, {1, 1, 3, 15, 5, 7, 21, 97, 31, 481, 1557, 3777, 3597, 7047, 4321, 31993, 86355}},
    {8479, 17, 23500, {1, 1, 1, 13, 7, 5, 93, 71, 235, 787, 329, 2369, 5069, 10913, 3171, 43961, 98853}},
    {8480, 17, 23515, {1, 1, 3, 5, 7, 31, 39, 145, 403, 967, 1511, 2557, 4907, 563, 20725, 52305, 24125}},
    {8481, 17, 23521, {1, 3, 3, 1, 29, 49, 113, 169, 435, 225, 1477, 3269, 7893, 12727, 7613, 35873, 7197}},
    {8482, 17, 23527, {1, 3, 3, 5, 13, 41, 3, 189, 81, 47, 97, 3671, 6855, 15847, 8491, 9509, 3503}},
    {8483, 17, 23534, {1, 3, 7, 3, 1, 31, 111, 167, 387, 147, 29, 2255, 1349, 5323, 10853, 50067, 77409}},
    {8484, 17, 23546, {1, 1, 1, 3, 1, 15, 117, 171, 259, 185, 1315, 1549, 2131, 6775, 9353, 37545, 70071}},
    {8485, 17, 23559, {1, 3, 3, 3, 21, 43, 45, 65, 103, 141, 1261, 2865, 5621, 5131, 7143, 63383, 46489}},
    {8486, 17, 23560, {1, 3, 5, 9, 13, 43, 21, 157, 13, 479, 631, 4069, 7759, 10553, 31833, 47393, 45537}},
    {8487, 17, 23566, {1, 1, 5, 3, 15, 19, 63, 167, 5, 91, 209, 3339, 4645, 11381, 8505, 60443, 69157}},
    {8488, 17, 23584, {1, 3, 3, 5, 15, 31, 27, 63, 339, 621, 1781, 427, 7355, 2371, 20523, 52607, 43905}},
    {8489, 17, 23587, {1, 3, 1, 5, 31, 37, 83, 143, 177, 317, 1363, 3283, 5537, 9705, 29863, 40973, 8257}},
    {8490, 17, 23594, {1, 3, 3, 15, 19, 1, 101, 37, 461, 197, 493, 437, 6963, 5479, 23927, 37817, 79365}},
    {8491, 17, 23602, {1, 3, 3, 3, 31, 25, 7, 29, 133, 905, 1979, 2427, 5211, 7629, 7483, 7151, 92525}},
    {8492, 17, 23607, {1, 3, 5, 13, 9, 49, 77, 27, 265, 47, 1607, 3787, 5159, 8905, 9235, 23851, 105585}},
    {8493, 17, 23616, {1, 1, 1, 3, 11, 57, 17, 89, 161, 761, 1379, 111, 5875, 9391, 13761, 45307, 33607}},
    {8494, 17, 23621, {1, 3, 1, 13, 27, 55, 27, 31, 43, 881, 1625, 2507, 3955, 977, 15185, 62115, 21899}},
    {8495, 17, 23631, {1, 1, 7, 11, 21, 11, 79, 229, 95, 401, 1137, 2087, 1367, 11035, 25443, 49651, 100951}},
    {8496, 17, 23634, {1, 1, 3, 7, 29, 1, 91, 107, 45, 223, 397, 2867, 705, 4303, 26389, 24591, 3961}},
    {8497, 17, 23636, {1, 1, 1, 3, 5, 61, 47, 181, 163, 519, 235, 3549, 7249, 7143, 26823, 14399, 113199}},
    {8498, 17, 23649, {1, 1, 7, 7, 29, 63, 69, 169, 41, 695, 311, 661, 2481, 4333, 20235, 13005, 86571}},
    {8499, 17, 23652, {1, 3, 7, 11, 7, 21, 63, 143, 137, 541, 1455, 209, 6355, 6505, 30545, 25363, 95565}},
    {8500, 17, 23679, {1, 1, 1, 3, 1, 35, 35, 149, 449, 979, 1957, 255, 7917, 14437, 291, 32507, 118457}},
    {8501, 17, 23686, {1, 1, 7, 11, 31, 1, 35, 151, 257, 595, 529, 1183, 2679, 6001, 12117, 57201, 31603}},
    {8502, 17, 23697, {1, 1, 1, 11, 3, 33, 87, 209, 257, 251, 1031, 3727, 3363, 8465, 17421, 36759, 94395}},
    {8503, 17, 23703, {1, 3, 5, 15, 13, 55, 61, 119, 295, 237, 75, 3159, 4091, 16079, 23417, 14201, 16411}},
    {8504, 17, 23714, {1, 3, 5, 7, 7, 13, 25, 49, 77, 599, 399, 2271, 3499, 14203, 2823, 22573, 63737}},
    {8505, 17, 23719, {1, 3, 7, 1, 3, 5, 47, 183, 403, 191, 1633, 2869, 6807, 6613, 25225, 19199, 28409}},
    {8506, 17, 23723, {1, 1, 5, 13, 17, 57, 7, 179, 327, 993, 1391, 3321, 2225, 15061, 11423, 54207, 70781}},
    {8507, 17, 23726, {1, 3, 7, 11, 7, 19, 29, 243, 167, 429, 1811, 2855, 1683, 4267, 9503, 24419, 100213}},
    {8508, 17, 23728, {1, 1, 5, 3, 31, 59, 43, 129, 207, 761, 83, 615, 7331, 14453, 31135, 2743, 85321}},
    {8509, 17, 23733, {1, 3, 3, 7, 1, 9, 69, 59, 161, 201, 659, 1679, 5541, 10171, 25881, 54425, 55897}},
    {8510, 17, 23740, {1, 1, 3, 11, 17, 51, 13, 143, 417, 997, 657, 1737, 7633, 13953, 25619, 53389, 93303}},
    {8511, 17, 23751, {1, 3, 3, 9, 9, 53, 53, 151, 161, 365, 69, 3679, 4795, 10271, 32517, 15047, 104583}},
    {8512, 17, 23755, {1, 1, 7, 9, 7, 9, 67, 85, 441, 463, 483, 2495, 1179, 5759, 25509, 46651, 5863}},
    {8513, 17, 23765, {1, 1, 5, 5, 27, 57, 119, 129, 495, 345, 1203, 21, 1373, 13857, 11599, 49681, 122021}},
    {8514, 17, 23766, {1, 1, 3, 1, 9, 35, 99, 237, 159, 449, 1131, 1047, 7781, 5491, 13369, 60369, 79763}},
    {8515, 17, 23769, {1, 1, 3, 13, 21, 11, 3, 5, 253, 919, 535, 997, 5507, 5755, 15443, 53215, 58331}},
    {8516, 17, 23779, {1, 3, 3, 15, 7, 13, 15, 205, 503, 229, 961, 1291, 71, 2119, 9529, 26267, 67997}},
    {8517, 17, 23794, {1, 1, 3, 3, 7, 15, 27, 187, 127, 209, 1147, 2863, 5311, 6489, 7371, 25707, 21501}},
    {8518, 17, 23796, {1, 3, 7, 1, 27, 33, 65, 93, 215, 267, 423, 1015, 1387, 7775, 22533, 47535, 64533}},
    {8519, 17, 23803, {1, 1, 1, 7, 19, 45, 71, 73, 413, 49, 623, 449, 6845, 11953, 5523, 1033, 52265}},
    {8520, 17, 23813, {1, 1, 5, 11, 7, 21, 107, 105, 39, 455, 1615, 3075, 2903, 2923, 9505, 891, 59905}},
    {8521, 17, 23820, {1, 1, 1, 9, 29, 41, 79, 251, 81, 259, 987, 55, 5345, 12215, 22669, 17809, 40405}},
    {8522, 17, 23841, {1, 3, 5, 9, 9, 61, 75, 99, 473, 549, 571, 3577, 1503, 5109, 8689, 4953, 55015}},
    {8523, 17, 23853, {1, 1, 5, 15, 21, 31, 29, 205, 155, 77, 2023, 1853, 6717, 6745, 27851, 5133, 114691}},
    {8524, 17, 23861, {1, 3, 1, 11, 23, 55, 57, 57, 283, 449, 1395, 875, 6245, 14757, 13797, 23703, 67653}},
    {8525, 17, 23862, {1, 1, 3, 11, 3, 3, 53, 43, 59, 627, 1407, 3887, 1803, 903, 29093, 6233, 60615}},
    {8526, 17, 23873, {1, 1, 1, 3, 1, 17, 71, 255, 69, 953, 1457, 4095, 7541, 9503, 3393, 19469, 17847}},
    {8527, 17, 23876, {1, 3, 5, 13, 9, 15, 31, 127, 413, 255, 763, 721, 2165, 14575, 563, 12255, 44431}},
    {8528, 17, 23897, {1, 3, 3, 3, 1, 15, 59, 29, 431, 331, 75, 3395, 1675, 12271, 2331, 29515, 22723}},
    {8529, 17, 23898, {1, 3, 7, 3, 23, 17, 57, 17, 113, 215, 893, 3881, 275, 10971, 1953, 61835, 104451}},
    {8530, 17, 23903, {1, 3, 5, 1, 21, 15, 61, 247, 63, 873, 719, 1657, 4435, 14297, 7141, 56845, 92979}},
    {8531, 17, 23904, {1, 3, 5, 7, 31, 15, 31, 3, 71, 467, 337, 3243, 53, 5065, 12203, 50497, 52459}},
    {8532, 17, 23910, {1, 3, 7, 3, 21, 33, 117, 251, 81, 521, 303, 2509, 2445, 7853, 11515, 55073, 97937}},
    {8533, 17, 23931, {1, 3, 5, 5, 31, 11, 77, 179, 71, 253, 825, 3393, 1423, 937, 22149, 52265, 93279}},
    {8534, 17, 23933, {1, 1, 1, 15, 27, 17, 61, 227, 95, 149, 1927, 281, 5607, 16347, 10061, 10969, 85795}},
    {8535, 17, 23934, {1, 1, 5, 3, 19, 11, 55, 85, 359, 413, 59, 3519, 7257, 387, 23557, 22999, 26027}},
    {8536, 17, 23943, {1, 1, 7, 7, 3, 39, 69, 181, 13, 957, 111, 957, 5745, 10489, 1987, 31163, 107115}},
    {8537, 17, 23952, {1, 3, 7, 11, 3, 35, 19, 163, 83, 211, 721, 3043, 6761, 14599, 23771, 34853, 69401}},
    {8538, 17, 23955, {1, 3, 5, 15, 21, 21, 49, 169, 289, 785, 151, 2309, 7475, 4065, 17553, 35213, 63947}},
    {8539, 17, 23962, {1, 1, 3, 13, 13, 23, 29, 197, 155, 837, 851, 3455, 5733, 1753, 7605, 58247, 110047}},
    {8540, 17, 23971, {1, 1, 1, 3, 9, 3, 25, 99, 173, 113, 89, 3917, 7367, 377, 49, 61419, 26249}},
    {8541, 17, 23978, {1, 1, 1, 13, 29, 29, 35, 141, 115, 993, 575, 1259, 3809, 11757, 22607, 33035, 99941}},
    {8542, 17, 23998, {1, 3, 1, 13, 19, 63, 45, 47, 455, 443, 2027, 2457, 1633, 2931, 1563, 7935, 21301}},
    {8543, 17, 24003, {1, 1, 1, 3, 31, 55, 107, 225, 397, 643, 237, 1387, 407, 4619, 1119, 27965, 91827}},
    {8544, 17, 24009, {1, 3, 3, 3, 19, 57, 21, 13, 133, 283, 479, 3631, 8161, 9125, 12635, 58637, 89069}},
    {8545, 17, 24017, {1, 3, 5, 15, 17, 15, 77, 111, 167, 559, 1393, 2369, 7081, 12575, 29697, 25551, 30931}},
    {8546, 17, 24045, {1, 1, 5, 1, 7, 33, 79, 189, 177, 247, 1879, 3115, 2521, 12631, 1207, 4197, 103363}},
    {8547, 17, 24046, {1, 1, 3, 1, 9, 39, 117, 127, 285, 415, 5, 1553, 1125, 9641, 22383, 27775, 129769}},
    {8548, 17, 24060, {1, 3, 7, 5, 5, 13, 7, 105, 149, 351, 1105, 985, 851, 1341, 11837, 15671, 108213}},
    {8549, 17, 24064, {1, 1, 1, 3, 13, 47, 35, 189, 379, 115, 1513, 2777, 5831, 7135, 25335, 47483, 108407}},
    {8550, 17, 24076, {1, 3, 3, 5, 13, 55, 5, 25, 243, 741, 1131, 367, 2881, 7641, 6443, 54989, 29425}},
    {8551, 17, 24079, {1, 1, 7, 15, 17, 13, 67, 25, 377, 479, 1371, 2915, 7167, 3107, 13119, 34061, 62747}},
    {8552, 17, 24087, {1, 3, 1, 13, 9, 5, 71, 119, 5, 729, 171, 2399, 5299, 8823, 10337, 39149, 26075}},
    {8553, 17, 24094, {1, 1, 5, 9, 31, 53, 23, 23, 85, 939, 1185, 527, 7769, 15191, 29909, 36053, 129915}},
    {8554, 17, 24100, {1, 1, 3, 15, 11, 61, 71, 217, 59, 115, 1289, 2219, 1311, 8597, 7689, 63439, 5147}},
    {8555, 17, 24118, {1, 1, 1, 11, 19, 35, 93, 209, 103, 815, 871, 3623, 709, 12447, 26547, 34863, 67407}},
    {8556, 17, 24121, {1, 1, 5, 1, 9, 15, 119, 75, 451, 893, 1213, 157, 4515, 11393, 16107, 36099, 33523}},
    {8557, 17, 24132, {1, 1, 5, 7, 5, 53, 3, 239, 95, 21, 1057, 2125, 1505, 8427, 16383, 45379, 30745}},
    {8558, 17, 24147, {1, 3, 7, 5, 5, 43, 89, 157, 377, 815, 1573, 3875, 5317, 12119, 31427, 21969, 16959}},
    {8559, 17, 24165, {1, 3, 3, 7, 15, 5, 11, 25, 91, 1023, 373, 3475, 839, 8323, 30353, 22111, 66675}},
    {8560, 17, 24172, {1, 1, 7, 9, 29, 1, 53, 201, 1, 309, 895, 889, 5457, 5655, 5503, 46165, 9057}},
    {8561, 17, 24177, {1, 1, 7, 1, 5, 21, 57, 237, 451, 563, 2015, 187, 6383, 10193, 32381, 26669, 78135}},
    {8562, 17, 24184, {1, 3, 7, 13, 7, 47, 9, 47, 107, 671, 495, 1275, 7599, 15817, 17503, 29483, 50009}},
    {8563, 17, 24187, {1, 1, 5, 3, 9, 53, 37, 109, 373, 215, 557, 2459, 6071, 14607, 28427, 16225, 104215}},
    {8564, 17, 24213, {1, 3, 7, 3, 7, 31, 51, 173, 449, 287, 941, 3191, 3155, 5259, 6553, 31317, 103553}},
    {8565, 17, 24217, {1, 3, 7, 7, 17, 53, 57, 131, 471, 745, 1797, 785, 6625, 15343, 5149, 11303, 121525}},
    {8566, 17, 24223, {1, 1, 3, 7, 3, 11, 121, 115, 271, 171, 557, 2749, 2659, 9471, 17243, 54063, 52117}},
    {8567, 17, 24230, {1, 1, 1, 5, 25, 11, 79, 231, 283, 449, 551, 3643, 3785, 6171, 9315, 51067, 81263}},
    {8568, 17, 24234, {1, 1, 3, 3, 21, 55, 119, 119, 31, 555, 1175, 673, 4627, 3989, 21901, 6745, 35951}},
    {8569, 17, 24241, {1, 1, 7, 9, 13, 13, 91, 153, 403, 39, 1657, 1125, 7859, 5063, 7347, 57347, 49031}},
    {8570, 17, 24248, {1, 3, 1, 15, 31, 63, 121, 241, 165, 345, 1989, 3301, 1871, 7005, 18869, 43349, 47071}},
    {8571, 17, 24259, {1, 1, 7, 5, 17, 45, 21, 173, 83, 327, 1619, 2273, 1287, 7733, 31347, 31527, 9361}},
    {8572, 17, 24262, {1, 1, 7, 7, 15, 35, 3, 193, 189, 63, 1705, 3095, 2213, 13059, 23083, 6595, 130811}},
    {8573, 17, 24271, {1, 1, 5, 5, 21, 53, 79, 223, 495, 483, 533, 2983, 7593, 117, 12063, 46425, 110361}},
    {8574, 17, 24279, {1, 3, 7, 5, 23, 5, 55, 173, 219, 617, 603, 667, 2889, 3121, 31851, 26113, 20913}},
    {8575, 17, 24286, {1, 3, 1, 11, 13, 15, 71, 65, 71, 71, 379, 3107, 1899, 13109, 15347, 28233, 25977}},
    {8576, 17, 24289, {1, 1, 5, 7, 25, 25, 43, 171, 469, 167, 397, 2803, 2105, 10519, 25391, 27019, 122745}},
    {8577, 17, 24295, {1, 1, 5, 1, 29, 43, 45, 237, 415, 973, 1513, 1271, 6473, 11867, 21627, 22477, 26999}},
    {8578, 17, 24296, {1, 3, 3, 11, 19, 49, 49, 29, 309, 521, 1479, 247, 5695, 14529, 12771, 19533, 68257}},
    {8579, 17, 24299, {1, 3, 1, 9, 15, 23, 73, 143, 491, 213, 357, 1961, 735, 747, 29495, 35343, 36695}},
    {8580, 17, 24314, {1, 3, 5, 15, 11, 5, 95, 15, 95, 735, 1957, 1661, 1913, 7757, 4739, 22697, 18899}},
    {8581, 17, 24336, {1, 3, 3, 7, 3, 57, 69, 51, 79, 973, 569, 1887, 6799, 883, 1155, 48717, 123173}},
    {8582, 17, 24342, {1, 1, 3, 11, 17, 59, 127, 181, 149, 113, 183, 3761, 7579, 6583, 15811, 31391, 79039}},
    {8583, 17, 24346, {1, 1, 5, 9, 23, 3, 11, 111, 265, 33, 585, 2759, 3031, 11979, 2117, 34799, 42723}},
    {8584, 17, 24357, {1, 1, 5, 11, 25, 59, 45, 237, 301, 35, 705, 1505, 5311, 1805, 14491, 20205, 46971}},
    {8585, 17, 24367, {1, 1, 7, 3, 7, 31, 49, 163, 411, 995, 1595, 3133, 3889, 67, 30221, 48139, 29363}},
    {8586, 17, 24370, {1, 3, 1, 5, 21, 25, 17, 171, 231, 457, 77, 1473, 3519, 11703, 18959, 36627, 124725}},
    {8587, 17, 24372, {1, 1, 5, 7, 1, 33, 79, 125, 99, 595, 389, 1473, 4005, 14147, 10625, 18841, 2971}},
    {8588, 17, 24387, {1, 1, 5, 9, 7, 35, 47, 171, 341, 919, 1405, 807, 455, 6275, 31119, 60873, 44229}},
    {8589, 17, 24389, {1, 3, 7, 11, 19, 57, 11, 239, 177, 239, 11, 497, 5609, 10979, 12679, 1675, 42921}},
    {8590, 17, 24402, {1, 1, 3, 1, 13, 47, 23, 107, 175, 995, 1955, 3613, 2047, 13125, 31853, 32855, 109689}},
    {8591, 17, 24414, {1, 1, 7, 1, 11, 39, 27, 59, 61, 587, 1295, 1969, 2035, 11059, 22209, 2227, 89995}},
    {8592, 17, 24420, {1, 1, 1, 9, 27, 31, 97, 107, 291, 509, 25, 1483, 5511, 6421, 26175, 62663, 56113}},
    {8593, 17, 24435, {1, 3, 5, 7, 3, 17, 93, 225, 129, 55, 1857, 3897, 6045, 14451, 19743, 62991, 39123}},
    {8594, 17, 24437, {1, 3, 5, 9, 11, 59, 19, 11, 353, 965, 1979, 3473, 4949, 12251, 29147, 61809, 69001}},
    {8595, 17, 24442, {1, 1, 1, 15, 31, 31, 77, 79, 193, 135, 1019, 3503, 2097, 9169, 15495, 41945, 56975}},
    {8596, 17, 24444, {1, 3, 5, 15, 13, 3, 51, 107, 361, 753, 1979, 935, 3455, 12341, 11465, 60523, 31791}},
    {8597, 17, 24447, {1, 1, 7, 5, 21, 25, 77, 213, 477, 887, 1397, 3177, 5129, 645, 30421, 41101, 77319}},
    {8598, 17, 24468, {1, 3, 1, 3, 3, 39, 53, 137, 147, 3, 933, 3455, 6057, 10651, 10183, 51305, 95869}},
    {8599, 17, 24475, {1, 3, 1, 15, 31, 19, 79, 67, 139, 485, 571, 639, 8179, 8389, 21727, 61209, 63523}},
    {8600, 17, 24484, {1, 1, 3, 5, 7, 21, 71, 53, 325, 797, 461, 2141, 1373, 14013, 19021, 3701, 116157}},
    {8601, 17, 24493, {1, 1, 7, 1, 3, 33, 69, 57, 221, 475, 91, 67, 5483, 12555, 10093, 19649, 52415}},
    {8602, 17, 24494, {1, 3, 1, 1, 5, 45, 11, 61, 41, 917, 547, 1369, 133, 4155, 16849, 3205, 89511}},
    {8603, 17, 24496, {1, 3, 7, 13, 19, 31, 3, 117, 231, 607, 1445, 3529, 6821, 191, 15297, 63165, 16123}},
    {8604, 17, 24514, {1, 3, 1, 9, 25, 27, 45, 231, 445, 161, 681, 3351, 6307, 1603, 22679, 21081, 54333}},
    {8605, 17, 24519, {1, 1, 3, 13, 25, 3, 3, 23, 511, 501, 1621, 4063, 3427, 835, 431, 14437, 2781}},
    {8606, 17, 24533, {1, 3, 5, 1, 27, 17, 71, 97, 413, 733, 1067, 3403, 3423, 9433, 22955, 27757, 29811}},
    {8607, 17, 24538, {1, 3, 1, 3, 3, 27, 103, 187, 381, 539, 1083, 3855, 2547, 3101, 15881, 29977, 56603}},
    {8608, 17, 24559, {1, 3, 7, 13, 29, 33, 13, 13, 25, 311, 29, 203, 257, 11391, 7481, 19053, 3717}},
    {8609, 17, 24568, {1, 3, 5, 7, 5, 29, 47, 83, 27, 587, 315, 1737, 4633, 4669, 1243, 42687, 15745}},
    {8610, 17, 24573, {1, 3, 5, 5, 1, 49, 19, 61, 121, 1007, 1979, 3113, 7853, 3667, 13487, 35035, 76687}},
    {8611, 17, 24577, {1, 3, 3, 13, 29, 19, 61, 75, 125, 377, 1265, 913, 3655, 11669, 8669, 60305, 49305}},
    {8612, 17, 24587, {1, 1, 7, 5, 3, 29, 119, 219, 337, 315, 935, 2639, 7265, 15603, 4359, 36671, 58305}},
    {8613, 17, 24592, {1, 3, 7, 11, 27, 59, 19, 221, 263, 803, 1593, 1985, 4383, 3075, 17657, 16341, 80649}},
    {8614, 17, 24601, {1, 1, 3, 7, 23, 59, 81, 35, 407, 853, 1655, 2737, 6943, 4071, 31903, 47757, 118327}},
    {8615, 17, 24602, {1, 1, 1, 1, 11, 23, 21, 211, 49, 185, 1703, 2651, 5597, 5597, 11705, 10131, 41865}},
    {8616, 17, 24608, {1, 1, 5, 5, 25, 49, 109, 241, 337, 445, 957, 4095, 7285, 11953, 6627, 22385, 125139}},
    {8617, 17, 24645, {1, 3, 5, 15, 21, 43, 49, 181, 511, 187, 263, 2135, 5533, 4329, 17273, 56027, 44813}},
    {8618, 17, 24650, {1, 3, 5, 7, 21, 31, 53, 47, 111, 255, 783, 3965, 1173, 7301, 23317, 29161, 37587}},
    {8619, 17, 24657, {1, 1, 1, 9, 15, 7, 61, 25, 389, 565, 979, 2025, 4523, 8079, 14935, 46203, 36649}},
    {8620, 17, 24664, {1, 3, 7, 5, 13, 3, 115, 211, 357, 755, 1419, 2155, 8149, 9709, 27103, 47679, 16055}},
    {8621, 17, 24670, {1, 1, 5, 7, 29, 3, 85, 199, 373, 189, 1477, 955, 715, 15945, 27541, 29447, 66251}},
    {8622, 17, 24673, {1, 3, 5, 1, 9, 29, 87, 179, 329, 897, 1615, 2171, 7607, 11147, 27091, 14047, 93557}},
    {8623, 17, 24676, {1, 3, 1, 1, 25, 11, 103, 163, 409, 1007, 253, 1985, 5217, 4035, 2835, 40875, 24245}},
    {8624, 17, 24680, {1, 1, 1, 11, 11, 39, 91, 79, 183, 945, 1507, 3005, 3277, 5195, 1255, 34447, 118693}},
    {8625, 17, 24686, {1, 1, 1, 5, 11, 57, 59, 169, 221, 639, 1515, 2211, 7703, 11173, 10311, 18921, 55185}},
    {8626, 17, 24700, {1, 3, 7, 11, 31, 13, 101, 157, 285, 799, 741, 2649, 6697, 8463, 5177, 11119, 117225}},
    {8627, 17, 24704, {1, 3, 1, 5, 9, 13, 11, 125, 279, 149, 475, 3833, 3877, 3103, 18047, 7085, 22901}},
    {8628, 17, 24714, {1, 1, 1, 13, 5, 63, 97, 1, 65, 451, 1709, 1297, 4893, 14157, 20875, 3379, 96897}},
    {8629, 17, 24728, {1, 1, 5, 13, 19, 55, 47, 31, 119, 221, 623, 3443, 7589, 12333, 8843, 46989, 49195}},
    {8630, 17, 24731, {1, 1, 7, 9, 17, 51, 37, 199, 165, 845, 1703, 2921, 6323, 7001, 4481, 60033, 42327}},
    {8631, 17, 24733, {1, 1, 5, 3, 15, 57, 101, 157, 61, 159, 1125, 2957, 215, 1889, 4031, 43251, 59823}},
    {8632, 17, 24747, {1, 1, 3, 5, 13, 63, 75, 165, 155, 825, 1479, 3755, 6073, 11081, 18741, 46341, 55325}},
    {8633, 17, 24749, {1, 1, 3, 13, 23, 3, 21, 167, 205, 671, 1443, 3131, 521, 7101, 14133, 11477, 28533}},
    {8634, 17, 24750, {1, 3, 5, 7, 21, 1, 87, 231, 405, 3, 409, 2211, 361, 4933, 6215, 35983, 31011}},
    {8635, 17, 24764, {1, 3, 7, 9, 13, 21, 95, 107, 341, 117, 823, 2995, 6373, 15, 29617, 32147, 50721}},
    {8636, 17, 24782, {1, 1, 5, 5, 3, 51, 83, 135, 339, 693, 797, 1629, 2889, 7891, 3859, 28325, 36091}},
    {8637, 17, 24784, {1, 3, 1, 3, 7, 29, 87, 249, 75, 43, 477, 519, 2777, 13213, 153, 36705, 101509}},
    {8638, 17, 24793, {1, 3, 5, 7, 31, 43, 87, 111, 275, 153, 339, 3383, 3567, 13245, 2495, 57853, 55995}},
    {8639, 17, 24794, {1, 3, 5, 15, 5, 7, 27, 175, 423, 165, 1299, 2767, 5813, 12181, 27497, 63295, 69299}},
    {8640, 17, 24810, {1, 1, 7, 1, 11, 59, 55, 143, 43, 261, 2025, 3925, 4691, 3383, 17615, 49067, 59833}},
    {8641, 17, 24817, {1, 3, 7, 9, 11, 57, 111, 239, 407, 359, 1489, 805, 1823, 11961, 17373, 48635, 121741}},
    {8642, 17, 24820, {1, 3, 5, 11, 13, 37, 105, 119, 181, 279, 195, 2443, 141, 12875, 25315, 13777, 104621}},
    {8643, 17, 24823, {1, 1, 1, 11, 23, 5, 95, 119, 465, 7, 21, 379, 1361, 12261, 8063, 25185, 8075}},
    {8644, 17, 24832, {1, 3, 5, 13, 9, 9, 79, 209, 91, 569, 43, 1583, 659, 11109, 20395, 5525, 42511}},
    {8645, 17, 24855, {1, 3, 3, 15, 1, 15, 51, 121, 93, 13, 1065, 2791, 7865, 14521, 1405, 27035, 20399}},
    {8646, 17, 24859, {1, 1, 3, 9, 17, 61, 3, 133, 5, 21, 2021, 1137, 7015, 9389, 23985, 55025, 20237}},
    {8647, 17, 24862, {1, 1, 5, 11, 15, 19, 117, 57, 323, 917, 1553, 1927, 1743, 9531, 23367, 50317, 28871}},
    {8648, 17, 24877, {1, 3, 7, 1, 15, 53, 55, 135, 315, 275, 271, 3033, 543, 12955, 1313, 57519, 123917}},
    {8649, 17, 24890, {1, 3, 7, 3, 17, 9, 1, 51, 53, 247, 287, 2701, 2027, 5963, 32581, 2239, 103605}},
    {8650, 17, 24900, {1, 1, 7, 9, 9, 29, 125, 243, 469, 687, 1791, 863, 527, 11047, 16119, 26793, 25401}},
    {8651, 17, 24904, {1, 1, 5, 15, 27, 55, 67, 165, 121, 721, 1485, 3285, 4667, 6831, 20705, 43517, 95581}},
    {8652, 17, 24909, {1, 3, 3, 9, 27, 31, 37, 57, 19, 661, 439, 4019, 6961, 15491, 6475, 22261, 3383}},
    {8653, 17, 24910, {1, 3, 1, 1, 25, 41, 101, 109, 117, 805, 2041, 2359, 7275, 7601, 29195, 26185, 36731}},
    {8654, 17, 24915, {1, 1, 5, 7, 29, 19, 109, 51, 433, 875, 1563, 2683, 7155, 3915, 17127, 56985, 10439}},
    {8655, 17, 24922, {1, 1, 7, 9, 5, 3, 7, 241, 79, 435, 1641, 675, 6923, 10149, 19001, 53343, 66259}},
    {8656, 17, 24937, {1, 3, 1, 1, 11, 23, 55, 57, 429, 259, 569, 2195, 3897, 14725, 2519, 32793, 91869}},
    {8657, 17, 24945, {1, 1, 5, 5, 3, 25, 105, 207, 21, 887, 927, 449, 7313, 11283, 18975, 35263, 111981}},
    {8658, 17, 24962, {1, 3, 5, 13, 7, 63, 65, 99, 21, 381, 473, 3441, 3349, 10589, 14167, 21967, 53585}},
    {8659, 17, 24964, {1, 1, 5, 13, 17, 15, 99, 231, 41, 875, 1661, 697, 887, 13025, 127, 4949, 91777}},
    {8660, 17, 24991, {1, 3, 5, 15, 7, 57, 31, 51, 287, 495, 1031, 517, 4967, 5967, 14685, 46853, 112057}},
    {8661, 17, 24992, {1, 3, 7, 3, 23, 41, 71, 215, 113, 97, 489, 203, 5241, 6819, 29535, 64457, 25263}},
    {8662, 17, 24995, {1, 3, 3, 11, 9, 1, 73, 201, 333, 823, 941, 763, 7309, 3315, 20335, 28277, 25825}},
    {8663, 17, 25001, {1, 1, 3, 13, 15, 7, 55, 89, 487, 515, 45, 749, 3299, 8785, 21159, 51743, 124857}},
    {8664, 17, 25009, {1, 1, 1, 15, 23, 49, 77, 51, 3, 981, 1359, 1165, 6837, 6441, 11221, 35505, 62855}},
    {8665, 17, 25019, {1, 3, 7, 3, 15, 47, 107, 165, 137, 295, 1129, 3659, 3035, 9373, 11681, 18367, 15745}},
    {8666, 17, 25021, {1, 3, 3, 5, 9, 23, 87, 109, 69, 231, 1363, 1761, 7459, 14361, 17713, 10833, 28269}},
    {8667, 17, 25029, {1, 1, 3, 15, 23, 13, 77, 195, 461, 377, 1591, 3037, 4497, 15959, 12911, 45043, 55885}},
    {8668, 17, 25034, {1, 3, 5, 5, 21, 17, 55, 117, 505, 637, 441, 329, 7021, 1499, 10079, 18809, 102769}},
    {8669, 17, 25036, {1, 3, 1, 11, 29, 59, 35, 229, 463, 633, 1663, 3855, 4547, 8323, 19639, 10005, 8345}},
    {8670, 17, 25039, {1, 3, 1, 3, 3, 31, 103, 65, 395, 45, 1113, 2809, 1229, 3595, 10655, 30963, 66145}},
    {8671, 17, 25057, {1, 1, 1, 1, 27, 35, 67, 9, 395, 757, 63, 1931, 6055, 14193, 3095, 23139, 102921}},
    {8672, 17, 25063, {1, 3, 3, 7, 25, 27, 91, 43, 407, 999, 265, 3785, 2517, 11609, 8439, 31617, 125489}},
    {8673, 17, 25064, {1, 3, 1, 11, 25, 55, 39, 251, 51, 727, 1617, 3037, 5941, 4483, 9835, 6597, 95343}},
    {8674, 17, 25075, {1, 1, 1, 5, 9, 49, 109, 183, 443, 377, 181, 1027, 1109, 11605, 105, 17549, 73487}},
    {8675, 17, 25077, {1, 3, 7, 7, 19, 17, 97, 181, 419, 15, 1971, 1295, 5675, 10475, 25429, 4917, 21907}},
    {8676, 17, 25084, {1, 1, 5, 11, 13, 15, 91, 165, 511, 955, 1889, 613, 1833, 9697, 5985, 24969, 63947}},
    {8677, 17, 25088, {1, 3, 3, 15, 13, 35, 45, 137, 255, 917, 79, 1309, 2137, 13315, 769, 51695, 101033}},
    {8678, 17, 25091, {1, 3, 3, 5, 21, 49, 59, 15, 267, 793, 249, 3615, 7027, 10563, 27911, 21277, 97045}},
    {8679, 17, 25105, {1, 1, 7, 5, 13, 63, 33, 57, 321, 87, 11, 769, 1421, 13221, 4789, 19381, 85009}},
    {8680, 17, 25134, {1, 1, 7, 9, 17, 27, 11, 181, 377, 363, 269, 3137, 1735, 2945, 16963, 1813, 75417}},
    {8681, 17, 25165, {1, 3, 1, 13, 27, 61, 47, 123, 283, 263, 1647, 3937, 923, 2555, 21979, 46345, 63759}},
    {8682, 17, 25183, {1, 1, 7, 3, 13, 21, 9, 201, 143, 765, 685, 3243, 3737, 285, 12093, 56687, 59097}},
    {8683, 17, 25184, {1, 3, 1, 3, 13, 39, 39, 215, 369, 379, 311, 67, 367, 14671, 14161, 5513, 106103}},
    {8684, 17, 25202, {1, 1, 7, 3, 29, 21, 13, 107, 185, 945, 2011, 2781, 4313, 3721, 8777, 16599, 71245}},
    {8685, 17, 25204, {1, 3, 7, 1, 19, 39, 97, 239, 217, 297, 1427, 3203, 1295, 16013, 21599, 45321, 40525}},
    {8686, 17, 25211, {1, 3, 7, 15, 1, 7, 119, 79, 255, 819, 457, 2755, 7173, 13011, 28071, 7089, 121839}},
    {8687, 17, 25223, {1, 1, 3, 7, 3, 53, 61, 251, 493, 567, 1171, 1715, 7833, 7535, 14495, 29065, 2603}},
    {8688, 17, 25224, {1, 1, 7, 9, 9, 55, 91, 165, 99, 669, 1493, 2151, 5279, 6115, 8275, 40999, 80229}},
    {8689, 17, 25235, {1, 3, 5, 13, 19, 43, 95, 167, 447, 687, 691, 3511, 6635, 10727, 8071, 30709, 23447}},
    {8690, 17, 25241, {1, 3, 3, 11, 11, 57, 31, 121, 287, 885, 441, 4017, 6115, 9713, 16481, 48019, 75229}},
    {8691, 17, 25253, {1, 1, 3, 7, 15, 53, 55, 81, 47, 935, 205, 1137, 2107, 8279, 18883, 24409, 127157}},
    {8692, 17, 25258, {1, 3, 7, 11, 25, 9, 5, 163, 347, 643, 1955, 1435, 2105, 13461, 9839, 39435, 47871}},
    {8693, 17, 25277, {1, 1, 1, 5, 11, 25, 105, 251, 151, 1011, 1647, 3161, 1857, 4875, 4559, 11853, 34139}},
    {8694, 17, 25278, {1, 1, 7, 1, 3, 9, 25, 33, 143, 943, 1285, 1145, 7895, 8943, 15969, 20209, 127215}},
    {8695, 17, 25280, {1, 3, 5, 3, 15, 3, 75, 249, 487, 559, 1279, 2223, 5189, 14189, 11635, 61663, 6569}},
    {8696, 17, 25290, {1, 3, 1, 11, 11, 47, 17, 233, 215, 539, 619, 1625, 1537, 3017, 22085, 20695, 43763}},
    {8697, 17, 25295, {1, 3, 1, 1, 15, 29, 43, 93, 7, 825, 1421, 1803, 721, 15935, 18147, 26191, 29115}},
    {8698, 17, 25300, {1, 1, 5, 1, 13, 21, 35, 205, 5, 875, 1233, 925, 7699, 4799, 25667, 25345, 63959}},
    {8699, 17, 25307, {1, 1, 5, 9, 31, 41, 105, 73, 455, 727, 1207, 1239, 1381, 1143, 31083, 61961, 91095}},
    {8700, 17, 25319, {1, 3, 5, 5, 7, 17, 71, 203, 265, 547, 1385, 3079, 5367, 10331, 31013, 3641, 73625}},
    {8701, 17, 25323, {1, 1, 1, 11, 9, 51, 81, 175, 45, 493, 649, 1601, 1617, 6769, 21441, 12273, 109241}},
    {8702, 17, 25326, {1, 3, 1, 3, 17, 25, 97, 227, 363, 41, 1991, 2685, 7945, 13929, 24265, 50101, 72843}},
    {8703, 17, 25333, {1, 1, 7, 3, 7, 29, 65, 159, 487, 555, 469, 2827, 7027, 599, 13643, 56473, 79375}},
    {8704, 17, 25334, {1, 3, 3, 15, 19, 19, 13, 237, 83, 149, 1645, 3515, 2529, 7753, 24949, 40763, 81059}},
    {8705, 17, 25337, {1, 3, 3, 7, 13, 41, 3, 15, 163, 919, 1701, 3733, 2607, 1635, 1573, 43811, 78399}},
    {8706, 17, 25348, {1, 3, 5, 9, 9, 47, 87, 57, 241, 997, 711, 2679, 7689, 15241, 9145, 47707, 85039}},
    {8707, 17, 25351, {1, 3, 1, 1, 9, 15, 111, 161, 107, 627, 919, 2915, 107, 15389, 2671, 36233, 40725}},
    {8708, 17, 25372, {1, 3, 3, 3, 11, 53, 51, 215, 461, 743, 871, 2273, 1113, 14593, 6539, 42919, 48355}},
    {8709, 17, 25381, {1, 1, 1, 15, 3, 37, 41, 211, 45, 871, 1781, 1337, 6855, 11317, 5869, 33129, 2725}},
    {8710, 17, 25403, {1, 3, 1, 5, 21, 11, 23, 45, 193, 853, 1549, 901, 4185, 14249, 18597, 53241, 117611}},
    {8711, 17, 25406, {1, 3, 5, 1, 23, 55, 127, 1, 321, 515, 817, 3009, 6427, 4937, 4827, 34425, 123063}},
    {8712, 17, 25431, {1, 3, 3, 5, 29, 3, 49, 65, 329, 75, 1505, 1239, 7321, 9305, 31585, 62367, 84701}},
    {8713, 17, 25437, {1, 3, 1, 5, 19, 5, 51, 57, 347, 721, 1117, 1159, 4585, 14417, 2533, 39795, 109261}},
    {8714, 17, 25453, {1, 1, 1, 7, 17, 37, 83, 245, 211, 111, 853, 2185, 1809, 5291, 29565, 49975, 22941}},
    {8715, 17, 25459, {1, 3, 3, 7, 15, 23, 93, 53, 257, 639, 787, 2527, 3553, 15675, 30725, 15147, 116261}},
    {8716, 17, 25462, {1, 1, 3, 1, 13, 39, 111, 53, 119, 293, 565, 2671, 6105, 1053, 4273, 28179, 20293}},
    {8717, 17, 25466, {1, 1, 7, 11, 15, 3, 1, 83, 493, 657, 1363, 3305, 6679, 13437, 4181, 54057, 59697}},
    {8718, 17, 25477, {1, 3, 5, 5, 29, 47, 21, 75, 7, 211, 1269, 3401, 1695, 2817, 5687, 37613, 27625}},
    {8719, 17, 25484, {1, 3, 5, 1, 11, 23, 75, 179, 315, 277, 1019, 3279, 5225, 11333, 29671, 8769, 84277}},
    {8720, 17, 25495, {1, 3, 1, 15, 27, 5, 29, 179, 495, 171, 1405, 1961, 543, 8573, 19223, 16165, 73693}},
    {8721, 17, 25501, {1, 1, 5, 1, 15, 63, 93, 117, 443, 229, 1955, 715, 8083, 2277, 23859, 20053, 115741}},
    {8722, 17, 25506, {1, 1, 5, 7, 9, 1, 59, 245, 207, 429, 759, 3521, 7869, 4521, 29239, 11049, 112157}},
    {8723, 17, 25511, {1, 3, 1, 1, 3, 39, 3, 13, 375, 753, 843, 3179, 7023, 3099, 15949, 6211, 128407}},
    {8724, 17, 25515, {1, 1, 1, 5, 15, 29, 57, 57, 21, 715, 215, 3443, 4111, 10693, 9879, 45725, 103023}},
    {8725, 17, 25525, {1, 3, 7, 3, 15, 29, 19, 245, 475, 487, 1429, 2459, 5649, 7111, 18207, 16385, 99785}},
    {8726, 17, 25529, {1, 1, 7, 1, 13, 3, 115, 167, 401, 567, 1021, 2583, 7843, 4293, 30207, 17535, 97955}},
    {8727, 17, 25532, {1, 1, 5, 15, 7, 33, 105, 227, 67, 75, 501, 1623, 637, 6401, 31585, 33543, 76245}},
    {8728, 17, 25538, {1, 3, 5, 15, 3, 11, 87, 213, 1, 467, 333, 1621, 6031, 13061, 16511, 15259, 87679}},
    {8729, 17, 25549, {1, 1, 5, 9, 23, 3, 41, 137, 49, 719, 647, 1197, 7743, 4933, 26199, 54597, 35761}},
    {8730, 17, 25552, {1, 1, 1, 9, 29, 13, 59, 241, 65, 425, 1093, 441, 3275, 10655, 887, 5045, 9043}},
    {8731, 17, 25564, {1, 1, 3, 13, 23, 25, 17, 227, 471, 599, 1971, 3045, 4647, 1115, 30953, 3571, 67899}},
    {8732, 17, 25567, {1, 3, 1, 3, 19, 11, 117, 117, 331, 259, 251, 1409, 7019, 15353, 15153, 35911, 18385}},
    {8733, 17, 25574, {1, 3, 5, 15, 25, 39, 41, 187, 321, 979, 419, 445, 979, 4543, 13833, 60347, 19925}},
    {8734, 17, 25577, {1, 1, 7, 9, 15, 9, 123, 161, 187, 759, 1227, 3629, 6417, 2583, 1961, 27433, 31387}},
    {8735, 17, 25583, {1, 1, 3, 13, 13, 11, 35, 75, 101, 741, 1451, 3647, 4033, 5239, 9865, 22571, 80761}},
    {8736, 17, 25588, {1, 3, 3, 9, 15, 21, 67, 25, 125, 129, 1817, 2317, 3313, 3503, 30659, 6263, 18553}},
    {8737, 17, 25603, {1, 3, 5, 13, 27, 27, 37, 217, 225, 271, 9, 2547, 3381, 1599, 459, 19337, 125349}},
    {8738, 17, 25610, {1, 1, 7, 11, 1, 9, 81, 39, 435, 677, 949, 1023, 5221, 12951, 10103, 39291, 84439}},
    {8739, 17, 25615, {1, 1, 3, 13, 25, 33, 113, 199, 297, 883, 1521, 3293, 161, 1845, 13657, 28431, 5633}},
    {8740, 17, 25624, {1, 1, 7, 11, 9, 57, 7, 175, 285, 399, 1633, 2255, 809, 6637, 15621, 34309, 87597}},
    {8741, 17, 25636, {1, 3, 5, 7, 31, 9, 89, 63, 249, 321, 1, 653, 293, 13263, 15727, 20781, 53073}},
    {8742, 17, 25639, {1, 1, 3, 1, 15, 21, 125, 3, 121, 437, 247, 2483, 1041, 8981, 28449, 56657, 7223}},
    {8743, 17, 25643, {1, 1, 1, 5, 11, 39, 95, 157, 273, 1011, 583, 1327, 3651, 8499, 27157, 17831, 75193}},
    {8744, 17, 25645, {1, 3, 5, 15, 21, 61, 83, 179, 461, 943, 597, 1303, 6217, 7299, 32759, 46133, 108055}},
    {8745, 17, 25648, {1, 1, 7, 3, 31, 15, 35, 19, 365, 391, 937, 2479, 7023, 2043, 21961, 6917, 10271}},
    {8746, 17, 25671, {1, 1, 5, 5, 19, 35, 11, 149, 303, 287, 51, 827, 5089, 4461, 15835, 35209, 66235}},
    {8747, 17, 25678, {1, 1, 1, 3, 13, 47, 35, 189, 379, 115, 1513, 2777, 5831, 7135, 25335, 47483, 108407}},
    {8748, 17, 25689, {1, 1, 5, 3, 27, 21, 65, 1, 171, 849, 275, 2051, 1701, 3593, 21717, 50667, 100405}},
    {8749, 17, 25708, {1, 3, 1, 15, 3, 33, 75, 131, 471, 143, 1411, 2279, 2249, 5673, 29111, 41007, 77621}},
    {8750, 17, 25716, {1, 1, 7, 9, 13, 31, 27, 39, 201, 569, 1175, 2159, 4053, 521, 15041, 10697, 107881}},
    {8751, 17, 25725, {1, 3, 7, 1, 31, 35, 113, 191, 465, 569, 851, 4063, 3721, 9567, 18691, 34189, 123957}},
    {8752, 17, 25730, {1, 3, 3, 15, 13, 49, 11, 85, 285, 117, 1765, 171, 7677, 13891, 23753, 12373, 76471}},
    {8753, 17, 25739, {1, 3, 5, 5, 21, 51, 101, 47, 177, 21, 705, 2673, 5017, 8507, 31701, 14141, 111139}},
    {8754, 17, 25747, {1, 1, 7, 13, 31, 37, 77, 51, 169, 389, 1047, 3841, 3123, 15979, 71, 30931, 5791}},
    {8755, 17, 25753, {1, 1, 3, 1, 13, 7, 7, 43, 483, 853, 1883, 1365, 6335, 2403, 2507, 29267, 113753}},
    {8756, 17, 25790, {1, 3, 7, 13, 11, 19, 61, 145, 401, 587, 177, 1571, 3985, 3151, 19455, 34737, 107339}},
    {8757, 17, 25797, {1, 1, 1, 1, 17, 29, 109, 73, 381, 277, 1525, 1115, 3089, 5689, 7317, 26233, 103573}},
    {8758, 17, 25804, {1, 1, 7, 11, 31, 15, 97, 163, 341, 309, 275, 2371, 5643, 10085, 32649, 38935, 54391}},
    {8759, 17, 25809, {1, 1, 7, 9, 17, 19, 19, 205, 21, 279, 457, 1675, 4115, 1473, 31369, 1741, 118771}},
    {8760, 17, 25816, {1, 3, 7, 3, 23, 11, 95, 139, 183, 275, 1613, 2483, 243, 4801, 17479, 44261, 37867}},
    {8761, 17, 25825, {1, 3, 1, 13, 27, 5, 121, 205, 419, 419, 353, 1291, 3301, 7093, 917, 34597, 33721}},
    {8762, 17, 25831, {1, 1, 7, 3, 29, 29, 11, 107, 177, 21, 977, 2615, 4253, 8553, 6367, 38621, 75671}},
    {8763, 17, 25845, {1, 1, 1, 1, 5, 13, 69, 17, 91, 25, 1137, 2737, 5483, 2737, 30539, 36069, 30253}},
    {8764, 17, 25846, {1, 3, 3, 11, 9, 61, 7, 133, 331, 1021, 57, 2197, 4807, 9809, 20585, 38705, 105801}},
    {8765, 17, 25867, {1, 3, 3, 13, 21, 9, 27, 171, 71, 999, 821, 691, 1811, 4597, 20173, 29271, 26039}},
    {8766, 17, 25870, {1, 1, 1, 7, 5, 53, 45, 33, 175, 101, 495, 301, 4253, 11961, 25325, 45953, 8607}},
    {8767, 17, 25897, {1, 3, 1, 13, 1, 31, 75, 195, 331, 679, 1837, 3355, 857, 11809, 11897, 53903, 42473}},
    {8768, 17, 25908, {1, 1, 7, 13, 31, 41, 97, 93, 179, 389, 185, 3049, 5449, 15921, 13913, 4883, 17483}},
    {8769, 17, 25937, {1, 3, 3, 1, 15, 21, 91, 173, 299, 81, 753, 4047, 4353, 5813, 13421, 4975, 93347}},
    {8770, 17, 25940, {1, 1, 7, 7, 29, 57, 11, 175, 355, 715, 1515, 2509, 6859, 8505, 20969, 65009, 21845}},
    {8771, 17, 25944, {1, 3, 5, 13, 3, 43, 107, 223, 89, 445, 1069, 2069, 1805, 4637, 16565, 3727, 93065}},
    {8772, 17, 25949, {1, 3, 3, 15, 17, 61, 87, 107, 27, 807, 1695, 3489, 2733, 12081, 7001, 49225, 82251}},
    {8773, 17, 25954, {1, 1, 3, 7, 21, 59, 83, 247, 205, 477, 1043, 2973, 717, 9051, 8649, 6365, 22103}},
    {8774, 17, 25960, {1, 1, 7, 9, 9, 51, 61, 17, 119, 181, 1439, 1801, 4135, 12915, 21969, 551, 91397}},
    {8775, 17, 25963, {1, 1, 7, 11, 19, 3, 93, 1, 213, 79, 1197, 1999, 221, 14931, 10323, 32429, 61645}},
    {8776, 17, 25966, {1, 1, 7, 9, 1, 23, 95, 107, 449, 369, 15, 2269, 4969, 8765, 7605, 10807, 16197}},
    {8777, 17, 25978, {1, 3, 5, 1, 13, 29, 127, 133, 309, 683, 1871, 3239, 1173, 1029, 11477, 61777, 40735}},
    {8778, 17, 25996, {1, 1, 1, 11, 17, 13, 61, 83, 275, 511, 1493, 3621, 1235, 9715, 14503, 15349, 34285}},
    {8779, 17, 26007, {1, 1, 1, 1, 9, 59, 85, 203, 475, 331, 833, 1327, 3013, 10841, 4271, 45161, 114699}},
    {8780, 17, 26011, {1, 3, 7, 15, 3, 33, 99, 227, 249, 117, 649, 2893, 3021, 571, 899, 38955, 85739}},
    {8781, 17, 26027, {1, 3, 7, 9, 27, 37, 23, 153, 367, 41, 1097, 1275, 6247, 14103, 7571, 34127, 9169}},
    {8782, 17, 26032, {1, 3, 1, 11, 9, 21, 103, 239, 353, 67, 79, 1759, 5359, 11291, 31951, 54815, 18777}},
    {8783, 17, 26038, {1, 3, 3, 7, 19, 61, 101, 41, 299, 35, 1419, 3539, 2273, 7703, 15349, 64203, 16495}},
    {8784, 17, 26049, {1, 3, 1, 11, 17, 25, 107, 233, 43, 751, 1179, 2945, 4433, 7951, 13031, 54123, 119431}},
    {8785, 17, 26052, {1, 3, 7, 3, 15, 55, 19, 175, 327, 87, 1897, 1915, 715, 8697, 17119, 48295, 39649}},
    {8786, 17, 26055, {1, 3, 5, 7, 29, 37, 37, 87, 43, 293, 905, 2413, 7507, 2377, 1531, 44735, 23037}},
    {8787, 17, 26085, {1, 3, 5, 13, 5, 47, 125, 65, 351, 819, 1363, 2787, 3979, 1043, 32441, 31765, 118991}},
    {8788, 17, 26089, {1, 1, 1, 7, 15, 13, 93, 209, 181, 765, 2031, 3889, 6071, 9055, 10775, 2807, 115655}},
    {8789, 17, 26090, {1, 3, 7, 11, 9, 25, 39, 239, 235, 389, 1019, 2621, 6553, 14075, 18207, 24829, 71853}},
    {8790, 17, 26098, {1, 3, 5, 5, 17, 25, 83, 101, 213, 511, 597, 2107, 4683, 11955, 7199, 57067, 76099}},
    {8791, 17, 26104, {1, 1, 1, 1, 19, 43, 123, 177, 401, 45, 183, 2489, 5889, 4219, 4793, 58625, 17195}},
    {8792, 17, 26110, {1, 3, 3, 15, 17, 43, 33, 235, 115, 769, 1291, 1359, 3303, 7955, 22397, 23403, 50561}},
    {8793, 17, 26113, {1, 1, 7, 7, 25, 51, 25, 123, 493, 375, 1381, 693, 829, 15777, 20431, 50437, 87629}},
    {8794, 17, 26126, {1, 1, 7, 7, 7, 49, 105, 127, 43, 787, 401, 229, 7689, 10765, 26855, 13749, 122023}},
    {8795, 17, 26133, {1, 3, 7, 1, 27, 41, 35, 175, 307, 571, 205, 2001, 3225, 7829, 5513, 57541, 50525}},
    {8796, 17, 26138, {1, 3, 1, 11, 1, 39, 117, 227, 93, 247, 879, 2237, 3779, 9223, 8595, 63141, 81583}},
    {8797, 17, 26140, {1, 1, 3, 1, 7, 51, 93, 179, 3, 23, 1587, 1369, 5005, 11643, 9515, 55103, 94069}},
    {8798, 17, 26156, {1, 3, 1, 7, 7, 35, 25, 237, 61, 339, 393, 1281, 7291, 15249, 31679, 34323, 65561}},
    {8799, 17, 26159, {1, 1, 3, 7, 7, 17, 29, 5, 507, 883, 1861, 1843, 5577, 3685, 5637, 40793, 79639}},
    {8800, 17, 26176, {1, 1, 7, 9, 31, 49, 39, 23, 489, 21, 1599, 1939, 1247, 13967, 21751, 36137, 63811}},
    {8801, 17, 26186, {1, 1, 1, 7, 25, 53, 15, 199, 177, 999, 1593, 1995, 4005, 12285, 28519, 64695, 82339}},
    {8802, 17, 26203, {1, 3, 5, 1, 7, 61, 75, 179, 79, 577, 1019, 653, 1935, 1239, 16813, 925, 60259}},
    {8803, 17, 26210, {1, 1, 3, 13, 23, 53, 77, 17, 225, 409, 1321, 2583, 1951, 10385, 26859, 14917, 114733}},
    {8804, 17, 26222, {1, 3, 1, 7, 23, 59, 19, 3, 395, 493, 817, 2715, 967, 5437, 4865, 64749, 87553}},
    {8805, 17, 26224, {1, 1, 3, 3, 31, 55, 53, 59, 107, 917, 1347, 3951, 1817, 6631, 19515, 15143, 91529}},
    {8806, 17, 26229, {1, 3, 1, 11, 3, 45, 33, 225, 373, 617, 885, 833, 2589, 16273, 32377, 35391, 52601}},
    {8807, 17, 26233, {1, 3, 7, 15, 7, 31, 113, 77, 47, 137, 1999, 3713, 3225, 13255, 30045, 54537, 109167}},
    {8808, 17, 26236, {1, 3, 3, 11, 21, 47, 123, 19, 477, 741, 1623, 2317, 3543, 5447, 16859, 44925, 43901}},
    {8809, 17, 26239, {1, 3, 3, 13, 29, 19, 61, 75, 125, 377, 1265, 913, 3655, 11669, 8669, 60305, 49305}},
    {8810, 17, 26267, {1, 1, 1, 7, 11, 53, 91, 235, 437, 783, 265, 487, 2307, 14837, 22831, 21639, 38603}},
    {8811, 17, 26291, {1, 1, 3, 3, 17, 9, 39, 79, 223, 443, 875, 3753, 139, 13257, 24633, 11841, 10967}},
    {8812, 17, 26293, {1, 3, 5, 11, 5, 31, 57, 213, 109, 797, 761, 661, 6795, 7937, 17037, 6287, 71025}},
    {8813, 17, 26298, {1, 1, 5, 9, 21, 61, 9, 177, 31, 179, 1989, 1987, 8067, 12161, 15825, 10373, 17561}},
    {8814, 17, 26303, {1, 1, 1, 7, 5, 11, 117, 253, 305, 213, 229, 1527, 8021, 13789, 2819, 58021, 3085}},
    {8815, 17, 26308, {1, 1, 7, 11, 5, 57, 37, 243, 9, 627, 281, 3255, 4823, 7219, 3895, 13911, 111501}},
    {8816, 17, 26312, {1, 3, 3, 1, 19, 53, 113, 165, 265, 851, 1251, 3621, 5185, 1269, 9393, 20247, 111583}},
    {8817, 17, 26315, {1, 1, 3, 13, 31, 61, 63, 101, 97, 587, 1289, 2513, 7581, 14917, 31739, 511, 94251}},
    {8818, 17, 26342, {1, 1, 1, 9, 15, 7, 61, 25, 389, 565, 979, 2025, 4523, 8079, 14935, 46203, 36649}},
    {8819, 17, 26354, {1, 3, 1, 13, 1, 51, 107, 243, 383, 159, 1165, 3005, 1433, 7495, 16263, 15489, 64727}},
    {8820, 17, 26363, {1, 1, 7, 15, 25, 61, 103, 253, 197, 377, 759, 75, 391, 3255, 7853, 14625, 13237}},
    {8821, 17, 26365, {1, 1, 3, 7, 7, 37, 107, 205, 479, 301, 1579, 1091, 1079, 6635, 24449, 28345, 88387}},
    {8822, 17, 26383, {1, 3, 3, 15, 17, 5, 109, 219, 97, 283, 1827, 1877, 7973, 13647, 7581, 22743, 34443}},
    {8823, 17, 26391, {1, 1, 5, 11, 23, 37, 105, 205, 225, 11, 47, 1841, 2495, 6257, 8257, 2033, 4523}},
    {8824, 17, 26398, {1, 3, 7, 7, 13, 35, 115, 149, 445, 715, 1779, 2845, 643, 13451, 14757, 48467, 122137}},
    {8825, 17, 26416, {1, 1, 1, 11, 15, 9, 119, 99, 493, 149, 479, 1601, 6857, 6031, 14669, 54369, 22421}},
    {8826, 17, 26421, {1, 3, 3, 9, 1, 57, 23, 233, 55, 943, 899, 387, 2673, 3367, 21657, 61157, 50785}},
    {8827, 17, 26425, {1, 3, 3, 13, 23, 59, 65, 197, 395, 531, 1773, 2801, 1237, 4273, 23833, 16539, 11977}},
    {8828, 17, 26434, {1, 1, 7, 15, 19, 19, 97, 33, 155, 827, 899, 883, 1469, 6899, 6461, 63071, 103185}},
    {8829, 17, 26439, {1, 1, 1, 9, 3, 5, 23, 137, 413, 289, 527, 2145, 6845, 1983, 829, 36563, 123641}},
    {8830, 17, 26453, {1, 3, 7, 7, 5, 9, 7, 31, 229, 895, 1147, 105, 6415, 4417, 16637, 51855, 116969}},
    {8831, 17, 26454, {1, 1, 5, 5, 19, 17, 5, 201, 51, 937, 947, 1407, 5083, 16253, 31591, 8703, 37045}},
    {8832, 17, 26470, {1, 3, 3, 13, 23, 11, 127, 85, 193, 517, 1737, 2293, 5647, 8079, 4805, 63325, 29439}},
    {8833, 17, 26491, {1, 1, 7, 1, 19, 31, 99, 183, 75, 365, 919, 1345, 6665, 10275, 7699, 53351, 42493}},
    {8834, 17, 26493, {1, 3, 5, 7, 5, 3, 1, 153, 205, 829, 155, 815, 1821, 2305, 28403, 5495, 114981}},
    {8835, 17, 26500, {1, 1, 1, 13, 25, 1, 63, 41, 217, 359, 1259, 2443, 7983, 12861, 14217, 59075, 76407}},
    {8836, 17, 26509, {1, 3, 7, 13, 25, 63, 13, 243, 327, 361, 109, 3959, 6035, 13881, 21643, 60381, 85717}},
    {8837, 17, 26518, {1, 3, 5, 11, 11, 29, 125, 239, 103, 707, 1431, 1829, 4683, 7729, 4765, 10365, 122853}},
    {8838, 17, 26531, {1, 1, 3, 7, 11, 57, 125, 59, 309, 21, 867, 3251, 6587, 8203, 26909, 27991, 123545}},
    {8839, 17, 26533, {1, 3, 3, 5, 1, 53, 109, 223, 505, 685, 167, 1361, 3651, 14067, 5921, 44623, 18011}},
    {8840, 17, 26540, {1, 1, 3, 1, 9, 47, 25, 27, 99, 259, 419, 1633, 7349, 10435, 25669, 64447, 24471}},
    {8841, 17, 26552, {1, 3, 1, 15, 7, 45, 55, 183, 181, 601, 657, 3361, 5927, 8223, 5787, 49191, 84403}},
    {8842, 17, 26566, {1, 3, 1, 7, 3, 15, 63, 91, 505, 579, 483, 3919, 1087, 7109, 9449, 30545, 111703}},
    {8843, 17, 26569, {1, 3, 5, 13, 9, 9, 79, 209, 91, 569, 43, 1583, 659, 11109, 20395, 5525, 42511}},
    {8844, 17, 26583, {1, 3, 1, 1, 7, 63, 105, 139, 167, 375, 1065, 2109, 1241, 8745, 11137, 19945, 82233}},
    {8845, 17, 26590, {1, 1, 1, 3, 1, 3, 35, 41, 83, 425, 595, 4059, 3307, 1701, 18081, 61491, 31291}},
    {8846, 17, 26596, {1, 3, 3, 3, 27, 5, 67, 183, 379, 921, 631, 1445, 4401, 6169, 23229, 57547, 91707}},
    {8847, 17, 26624, {1, 3, 1, 7, 7, 61, 33, 195, 395, 853, 1683, 1283, 4773, 12931, 9761, 23517, 121609}},
    {8848, 17, 26636, {1, 1, 5, 1, 1, 47, 55, 115, 463, 767, 2011, 1265, 7493, 7693, 4003, 7165, 63805}},
    {8849, 17, 26667, {1, 1, 5, 3, 5, 9, 69, 43, 469, 941, 3, 3781, 215, 4619, 29119, 25715, 124831}},
    {8850, 17, 26669, {1, 1, 3, 13, 1, 15, 57, 69, 341, 329, 543, 2329, 4889, 6245, 22085, 31537, 58367}},
    {8851, 17, 26672, {1, 3, 5, 13, 9, 39, 63, 209, 397, 341, 1385, 4083, 6205, 1405, 19385, 13813, 129175}},
    {8852, 17, 26675, {1, 3, 7, 9, 23, 41, 73, 235, 167, 227, 1041, 1259, 8051, 3985, 17221, 59741, 52417}},
    {8853, 17, 26687, {1, 3, 1, 5, 9, 29, 5, 215, 5, 39, 1331, 1709, 6129, 14787, 32233, 37463, 39795}},
    {8854, 17, 26689, {1, 1, 3, 11, 3, 47, 19, 25, 395, 949, 551, 1231, 3791, 9211, 32717, 53417, 16215}},
    {8855, 17, 26696, {1, 1, 1, 11, 25, 3, 81, 75, 325, 107, 1691, 3813, 7401, 11457, 10939, 47363, 75977}},
    {8856, 17, 26702, {1, 1, 1, 15, 27, 51, 69, 31, 27, 437, 1663, 3029, 1587, 9791, 1353, 21725, 19555}},
    {8857, 17, 26714, {1, 1, 5, 11, 25, 21, 81, 221, 471, 561, 1291, 3783, 1495, 8115, 12547, 36957, 50899}},
    {8858, 17, 26716, {1, 1, 5, 9, 25, 39, 31, 123, 79, 139, 815, 3505, 4879, 13909, 21131, 20087, 43921}},
    {8859, 17, 26729, {1, 3, 7, 1, 5, 15, 91, 123, 21, 213, 267, 4057, 7981, 12253, 389, 56557, 69829}},
    {8860, 17, 26732, {1, 1, 3, 13, 19, 29, 29, 91, 77, 279, 1057, 3027, 163, 12991, 27409, 57577, 90933}},
    {8861, 17, 26737, {1, 3, 3, 9, 25, 25, 125, 65, 111, 103, 1223, 2413, 4117, 14037, 427, 14423, 27357}},
    {8862, 17, 26747, {1, 1, 7, 7, 15, 25, 63, 109, 145, 579, 311, 2191, 6445, 7319, 12791, 9835, 91749}},
    {8863, 17, 26773, {1, 1, 5, 11, 17, 41, 39, 139, 381, 463, 713, 675, 6123, 9909, 8813, 49657, 8305}},
    {8864, 17, 26780, {1, 3, 5, 1, 21, 21, 63, 19, 55, 513, 1913, 3583, 811, 5861, 1223, 57655, 83607}},
    {8865, 17, 26801, {1, 1, 3, 7, 15, 17, 121, 157, 245, 97, 561, 505, 5725, 2357, 17725, 61597, 127601}},
    {8866, 17, 26811, {1, 1, 1, 7, 23, 49, 1, 187, 429, 127, 1469, 45, 5415, 15345, 6695, 30703, 1761}},
    {8867, 17, 26813, {1, 3, 3, 5, 9, 23, 87, 109, 69, 231, 1363, 1761, 7459, 14361, 17713, 10833, 28269}},
    {8868, 17, 26831, {1, 1, 1, 1, 19, 7, 79, 245, 449, 455, 499, 2075, 609, 4623, 457, 27137, 15411}},
    {8869, 17, 26836, {1, 3, 7, 3, 15, 17, 109, 169, 241, 281, 1583, 2289, 5953, 1077, 22213, 63147, 42025}},
    {8870, 17, 26839, {1, 3, 5, 9, 25, 45, 71, 199, 191, 299, 765, 1801, 925, 12087, 2409, 18067, 89207}},
    {8871, 17, 26849, {1, 1, 7, 3, 13, 5, 53, 61, 253, 795, 1997, 7, 2441, 827, 20291, 64173, 77195}},
    {8872, 17, 26862, {1, 3, 7, 11, 5, 17, 37, 83, 55, 1009, 241, 2963, 3019, 5093, 32727, 19765, 112035}},
    {8873, 17, 26869, {1, 3, 5, 3, 23, 11, 123, 65, 1, 745, 1505, 2929, 765, 11731, 27487, 49603, 1607}},
    {8874, 17, 26873, {1, 1, 7, 3, 15, 35, 81, 95, 343, 233, 1631, 235, 2451, 9479, 28885, 49825, 7755}},
    {8875, 17, 26874, {1, 3, 1, 15, 15, 25, 69, 117, 285, 321, 93, 2851, 5727, 9809, 7481, 52895, 23883}},
    {8876, 17, 26888, {1, 3, 1, 1, 31, 35, 67, 177, 345, 873, 337, 3809, 6787, 6961, 4253, 4285, 15165}},
    {8877, 17, 26891, {1, 3, 7, 3, 31, 55, 3, 131, 79, 415, 383, 3025, 6639, 8335, 31063, 10785, 35791}},
    {8878, 17, 26896, {1, 1, 7, 7, 23, 63, 99, 57, 259, 523, 1431, 1479, 6751, 12541, 31129, 14525, 103255}},
    {8879, 17, 26899, {1, 1, 5, 1, 29, 53, 63, 101, 427, 927, 1989, 2253, 7177, 2817, 31485, 45509, 79827}},
    {8880, 17, 26912, {1, 1, 5, 15, 27, 31, 71, 73, 483, 627, 785, 803, 5347, 1717, 17195, 25801, 56587}},
    {8881, 17, 26921, {1, 1, 7, 9, 17, 27, 11, 181, 377, 363, 269, 3137, 1735, 2945, 16963, 1813, 75417}},
    {8882, 17, 26935, {1, 3, 1, 5, 19, 59, 53, 203, 63, 29, 649, 655, 7555, 12691, 30531, 6783, 111203}},
    {8883, 17, 26941, {1, 1, 7, 3, 3, 61, 7, 9, 495, 567, 1433, 1177, 7593, 11367, 17747, 62271, 52273}},
    {8884, 17, 26949, {1, 3, 5, 5, 15, 7, 67, 29, 277, 869, 705, 1561, 5883, 7447, 23185, 30815, 125667}},
    {8885, 17, 26954, {1, 1, 7, 3, 3, 3, 89, 127, 209, 907, 529, 1327, 4747, 13695, 18449, 34613, 38761}},
    {8886, 17, 26967, {1, 1, 7, 13, 7, 31, 127, 233, 339, 291, 307, 2001, 7973, 7605, 19567, 49091, 115195}},
    {8887, 17, 26977, {1, 3, 1, 15, 11, 11, 43, 193, 227, 465, 1989, 2129, 6051, 8943, 29333, 51355, 124881}},
    {8888, 17, 27011, {1, 3, 1, 9, 15, 39, 69, 193, 381, 761, 1815, 467, 1283, 7579, 27743, 5819, 9587}},
    {8889, 17, 27018, {1, 3, 3, 9, 9, 13, 77, 39, 241, 887, 601, 3861, 5967, 15635, 18679, 52783, 101859}},
    {8890, 17, 27026, {1, 1, 3, 1, 3, 27, 101, 73, 189, 167, 395, 3807, 2917, 329, 29577, 18019, 37653}},
    {8891, 17, 27028, {1, 3, 5, 9, 13, 43, 21, 157, 13, 479, 631, 4069, 7759, 10553, 31833, 47393, 45537}},
    {8892, 17, 27032, {1, 3, 3, 13, 17, 49, 47, 169, 397, 213, 217, 2249, 4809, 14181, 15489, 35127, 58927}},
    {8893, 17, 27044, {1, 3, 3, 13, 13, 43, 45, 35, 391, 833, 1351, 2199, 1651, 12805, 3357, 43699, 23251}},
    {8894, 17, 27053, {1, 1, 1, 7, 7, 29, 99, 85, 159, 61, 533, 3133, 6935, 3835, 5855, 38503, 33945}},
    {8895, 17, 27062, {1, 1, 5, 1, 7, 5, 87, 175, 211, 187, 1977, 2133, 6117, 141, 6209, 40787, 29735}},
    {8896, 17, 27065, {1, 3, 1, 11, 11, 47, 17, 233, 215, 539, 619, 1625, 1537, 3017, 22085, 20695, 43763}},
    {8897, 17, 27068, {1, 1, 3, 7, 31, 29, 87, 97, 293, 721, 1401, 1433, 8143, 11089, 26361, 10813, 117119}},
    {8898, 17, 27080, {1, 1, 1, 9, 11, 3, 125, 229, 259, 375, 289, 2421, 3385, 13527, 11631, 61505, 64179}},
    {8899, 17, 27083, {1, 1, 5, 9, 15, 55, 87, 125, 75, 333, 1051, 2573, 6967, 8885, 5015, 47399, 121113}},
    {8900, 17, 27093, {1, 1, 3, 1, 15, 33, 3, 91, 347, 681, 1157, 3353, 2317, 9149, 7105, 46021, 55237}},
    {8901, 17, 27098, {1, 3, 7, 5, 15, 55, 123, 21, 215, 887, 411, 3143, 6885, 8159, 30345, 4671, 15351}},
    {8902, 17, 27107, {1, 1, 5, 13, 31, 35, 55, 37, 417, 115, 1603, 2497, 3263, 4197, 2941, 31655, 53831}},
    {8903, 17, 27110, {1, 1, 7, 15, 25, 35, 109, 127, 47, 131, 1665, 3871, 6977, 2595, 29867, 58085, 32093}},
    {8904, 17, 27114, {1, 3, 1, 11, 15, 59, 35, 7, 465, 255, 1899, 1835, 5509, 5813, 13629, 52379, 94599}},
    {8905, 17, 27121, {1, 3, 3, 11, 5, 19, 93, 117, 101, 173, 1567, 2517, 3615, 3267, 22381, 28739, 105461}},
    {8906, 17, 27127, {1, 3, 5, 11, 21, 9, 21, 13, 53, 403, 1991, 1027, 317, 8147, 20377, 5717, 124039}},
    {8907, 17, 27137, {1, 3, 3, 7, 19, 37, 71, 115, 321, 1013, 2005, 621, 7941, 12997, 31841, 54137, 81243}},
    {8908, 17, 27144, {1, 1, 1, 7, 17, 11, 85, 73, 27, 787, 335, 4067, 667, 10893, 11903, 47399, 114393}},
    {8909, 17, 27155, {1, 3, 7, 13, 25, 5, 55, 17, 421, 823, 1245, 671, 1621, 12091, 16079, 30703, 126933}},
    {8910, 17, 27171, {1, 1, 7, 9, 17, 27, 121, 103, 373, 861, 863, 973, 5179, 13879, 4457, 53697, 44217}},
    {8911, 17, 27178, {1, 3, 1, 5, 21, 11, 23, 45, 193, 853, 1549, 901, 4185, 14249, 18597, 53241, 117611}},
    {8912, 17, 27180, {1, 3, 1, 5, 19, 7, 75, 115, 459, 247, 533, 727, 8101, 791, 11065, 17169, 54473}},
    {8913, 17, 27185, {1, 1, 3, 9, 23, 23, 19, 203, 315, 225, 1383, 2847, 4531, 14767, 28035, 35545, 124359}},
    {8914, 17, 27191, {1, 3, 1, 5, 19, 5, 51, 57, 347, 721, 1117, 1159, 4585, 14417, 2533, 39795, 109261}},
    {8915, 17, 27192, {1, 3, 3, 7, 1, 9, 69, 59, 161, 201, 659, 1679, 5541, 10171, 25881, 54425, 55897}},
    {8916, 17, 27195, {1, 3, 1, 1, 13, 21, 5, 93, 223, 569, 31, 3165, 3067, 1787, 30561, 17837, 81915}},
    {8917, 17, 27212, {1, 1, 1, 5, 7, 11, 9, 211, 293, 349, 1757, 93, 6275, 8613, 10821, 51061, 56623}},
    {8918, 17, 27215, {1, 3, 5, 3, 11, 23, 65, 101, 353, 161, 185, 1427, 2829, 1207, 23403, 51011, 47789}},
    {8919, 17, 27218, {1, 1, 5, 11, 13, 51, 97, 3, 229, 175, 1977, 2473, 5737, 12801, 18547, 64045, 50797}},
    {8920, 17, 27230, {1, 1, 3, 1, 27, 51, 37, 145, 377, 947, 669, 4003, 4769, 9175, 15865, 16237, 39295}},
    {8921, 17, 27234, {1, 3, 1, 9, 27, 43, 45, 117, 67, 115, 503, 541, 1473, 1513, 8571, 34971, 129441}},
    {8922, 17, 27245, {1, 3, 7, 7, 5, 39, 9, 157, 259, 497, 525, 2937, 2513, 15391, 2743, 65397, 56463}},
    {8923, 17, 27248, {1, 3, 3, 13, 31, 1, 53, 241, 89, 621, 1537, 843, 3365, 5905, 16389, 21449, 71591}},
    {8924, 17, 27263, {1, 1, 1, 5, 13, 47, 107, 195, 43, 405, 313, 149, 4117, 4577, 7693, 50669, 81537}},
    {8925, 17, 27279, {1, 3, 5, 1, 19, 27, 19, 255, 185, 295, 113, 2927, 243, 3737, 4893, 42779, 435}},
    {8926, 17, 27288, {1, 1, 3, 7, 3, 51, 33, 27, 509, 771, 835, 1107, 715, 11037, 6129, 25341, 44851}},
    {8927, 17, 27294, {1, 3, 7, 15, 29, 11, 77, 29, 341, 37, 231, 1753, 2703, 12249, 30929, 21523, 62713}},
    {8928, 17, 27303, {1, 1, 1, 11, 11, 21, 33, 205, 89, 951, 647, 3645, 4893, 14603, 32213, 58531, 114727}},
    {8929, 17, 27304, {1, 1, 3, 7, 21, 5, 41, 27, 331, 977, 495, 4011, 6689, 7931, 24115, 28861, 51985}},
    {8930, 17, 27312, {1, 1, 3, 7, 29, 43, 33, 65, 391, 425, 1981, 3615, 6729, 1815, 21987, 23023, 123597}},
    {8931, 17, 27330, {1, 1, 1, 9, 19, 9, 85, 249, 245, 439, 359, 1703, 1859, 4201, 7045, 3227, 8651}},
    {8932, 17, 27341, {1, 1, 1, 15, 7, 7, 45, 11, 377, 963, 669, 917, 5677, 6191, 23923, 28691, 20467}},
    {8933, 17, 27342, {1, 1, 3, 13, 21, 7, 103, 219, 283, 235, 193, 723, 3909, 15239, 28373, 5961, 59495}},
    {8934, 17, 27344, {1, 3, 3, 5, 31, 11, 13, 171, 453, 507, 1521, 803, 4495, 11325, 7379, 36687, 120551}},
    {8935, 17, 27353, {1, 3, 3, 9, 15, 21, 67, 25, 125, 129, 1817, 2317, 3313, 3503, 30659, 6263, 18553}},
    {8936, 17, 27356, {1, 3, 7, 13, 21, 51, 93, 243, 419, 725, 43, 1851, 1051, 1071, 22949, 50605, 82751}},
    {8937, 17, 27366, {1, 3, 5, 7, 17, 21, 73, 147, 421, 599, 291, 3889, 2133, 8693, 21075, 651, 58251}},
    {8938, 17, 27369, {1, 1, 1, 3, 9, 31, 83, 153, 7, 799, 1081, 2711, 7785, 10493, 14863, 28523, 116705}},
    {8939, 17, 27377, {1, 3, 5, 15, 11, 51, 1, 55, 445, 313, 1199, 2175, 313, 69, 9421, 41809, 36947}},
    {8940, 17, 27387, {1, 3, 3, 3, 29, 27, 95, 177, 455, 633, 869, 1487, 7617, 15151, 23779, 41563, 118097}},
    {8941, 17, 27409, {1, 3, 3, 5, 1, 53, 63, 19, 345, 401, 711, 3257, 4279, 6943, 13425, 3867, 52931}},
    {8942, 17, 27437, {1, 1, 3, 9, 31, 43, 103, 209, 171, 877, 1029, 1053, 1849, 11541, 20811, 39701, 77347}},
    {8943, 17, 27443, {1, 3, 3, 7, 3, 53, 87, 111, 447, 441, 319, 2063, 6227, 3097, 5403, 46047, 124011}},
    {8944, 17, 27446, {1, 3, 3, 13, 1, 47, 75, 153, 395, 703, 2025, 1465, 7, 15387, 25607, 58063, 54285}},
    {8945, 17, 27450, {1, 1, 3, 3, 31, 3, 77, 113, 361, 487, 1187, 1405, 3789, 11917, 965, 21983, 2045}},
    {8946, 17, 27452, {1, 1, 7, 7, 5, 47, 119, 217, 87, 915, 1575, 667, 7789, 8247, 11469, 8959, 62307}},
    {8947, 17, 27457, {1, 1, 3, 11, 25, 11, 117, 57, 415, 379, 1627, 2357, 3449, 2323, 7497, 64365, 19131}},
    {8948, 17, 27472, {1, 3, 7, 13, 13, 45, 9, 59, 27, 655, 1711, 565, 7755, 12067, 14257, 1047, 108755}},
    {8949, 17, 27475, {1, 3, 7, 1, 15, 41, 11, 135, 71, 363, 99, 679, 2661, 4055, 12859, 23595, 90245}},
    {8950, 17, 27487, {1, 1, 3, 9, 1, 25, 119, 31, 417, 105, 1181, 2603, 17, 6545, 3265, 32493, 122981}},
    {8951, 17, 27488, {1, 3, 3, 11, 3, 7, 123, 39, 259, 847, 419, 3059, 1865, 8751, 27399, 63633, 35683}},
    {8952, 17, 27493, {1, 3, 7, 11, 5, 7, 43, 181, 265, 671, 811, 1339, 7045, 16271, 22569, 63341, 93541}},
    {8953, 17, 27506, {1, 3, 1, 11, 21, 57, 101, 169, 425, 747, 1707, 2155, 7027, 2603, 3659, 16903, 126437}},
    {8954, 17, 27508, {1, 3, 7, 15, 31, 43, 105, 17, 425, 435, 1465, 3779, 7425, 12837, 17281, 19053, 91827}},
    {8955, 17, 27521, {1, 1, 7, 11, 9, 23, 1, 231, 423, 669, 513, 1393, 1401, 4975, 6759, 27303, 5425}},
    {8956, 17, 27522, {1, 3, 1, 3, 17, 39, 39, 39, 457, 187, 1085, 3217, 161, 3631, 8443, 801, 129667}},
    {8957, 17, 27527, {1, 3, 1, 7, 19, 11, 53, 133, 243, 991, 661, 1755, 4055, 8583, 7659, 32971, 120675}},
    {8958, 17, 27536, {1, 1, 1, 7, 17, 3, 5, 227, 109, 791, 1939, 2085, 6793, 8233, 5557, 37237, 21521}},
    {8959, 17, 27539, {1, 3, 5, 5, 11, 5, 117, 113, 111, 73, 531, 3071, 7439, 7639, 15419, 58033, 6857}},
    {8960, 17, 27541, {1, 3, 5, 13, 19, 53, 31, 61, 411, 819, 355, 1393, 3855, 4227, 32033, 60473, 116449}},
    {8961, 17, 27546, {1, 3, 3, 11, 15, 1, 123, 181, 443, 565, 633, 1211, 7733, 11613, 7235, 60773, 41807}},
    {8962, 17, 27557, {1, 3, 5, 3, 9, 15, 65, 75, 227, 711, 1347, 4089, 373, 4613, 17277, 27585, 98859}},
    {8963, 17, 27564, {1, 3, 7, 11, 13, 59, 11, 7, 449, 45, 1041, 325, 7237, 205, 11133, 23983, 70099}},
    {8964, 17, 27572, {1, 3, 3, 11, 9, 61, 7, 133, 331, 1021, 57, 2197, 4807, 9809, 20585, 38705, 105801}},
    {8965, 17, 27576, {1, 1, 5, 5, 31, 13, 33, 69, 145, 601, 1137, 3627, 3411, 6735, 23403, 46859, 57767}},
    {8966, 17, 27584, {1, 1, 1, 9, 31, 59, 1, 37, 193, 1007, 483, 2369, 2369, 6795, 16493, 62523, 60927}},
    {8967, 17, 27608, {1, 3, 1, 3, 9, 51, 17, 145, 117, 597, 185, 2609, 551, 14243, 32645, 26851, 39473}},
    {8968, 17, 27611, {1, 1, 1, 3, 1, 9, 121, 175, 185, 151, 385, 1405, 3283, 10111, 11487, 32629, 31017}},
    {8969, 17, 27618, {1, 3, 5, 7, 7, 45, 101, 219, 87, 703, 1163, 2881, 4333, 11029, 10199, 8605, 2333}},
    {8970, 17, 27620, {1, 3, 5, 15, 27, 57, 123, 21, 485, 749, 1041, 1627, 683, 10371, 13485, 16163, 13355}},
    {8971, 17, 27627, {1, 1, 5, 11, 31, 3, 45, 155, 145, 797, 975, 1471, 2463, 3791, 1233, 36137, 130311}},
    {8972, 17, 27630, {1, 1, 1, 11, 19, 37, 103, 15, 171, 721, 21, 3367, 683, 11191, 3117, 8807, 37327}},
    {8973, 17, 27637, {1, 3, 3, 7, 15, 59, 3, 139, 285, 473, 1091, 345, 2413, 15351, 19611, 605, 42355}},
    {8974, 17, 27638, {1, 3, 3, 11, 23, 7, 21, 213, 63, 965, 1855, 1507, 4951, 11967, 9389, 18989, 94435}},
    {8975, 17, 27641, {1, 1, 7, 13, 13, 37, 113, 103, 251, 731, 575, 99, 4319, 4955, 11111, 60187, 35035}},
    {8976, 17, 27647, {1, 3, 3, 1, 1, 11, 59, 81, 489, 849, 441, 1479, 5699, 15449, 23011, 2741, 120377}},
    {8977, 17, 27650, {1, 1, 7, 9, 19, 61, 121, 73, 211, 299, 1773, 3473, 57, 9279, 28757, 45871, 7105}},
    {8978, 17, 27676, {1, 3, 3, 13, 11, 59, 7, 49, 421, 107, 1069, 1397, 1725, 10421, 25337, 56321, 99233}},
    {8979, 17, 27683, {1, 1, 1, 11, 5, 21, 17, 41, 225, 329, 1801, 2337, 2345, 10573, 20945, 55589, 87047}},
    {8980, 17, 27690, {1, 3, 1, 11, 7, 61, 29, 113, 257, 727, 63, 1175, 8137, 8979, 27629, 25645, 31233}},
    {8981, 17, 27695, {1, 3, 3, 13, 13, 19, 31, 7, 275, 201, 1975, 1241, 1921, 8383, 18273, 32705, 120329}},
    {8982, 17, 27700, {1, 3, 7, 1, 7, 43, 13, 9, 479, 197, 1923, 3549, 6909, 12629, 26597, 9545, 55285}},
    {8983, 17, 27704, {1, 1, 3, 13, 5, 25, 119, 83, 119, 789, 2047, 505, 277, 4531, 22107, 13557, 40083}},
    {8984, 17, 27709, {1, 1, 1, 13, 9, 43, 123, 5, 143, 101, 991, 2653, 5519, 5791, 32639, 55909, 86867}},
    {8985, 17, 27715, {1, 1, 5, 9, 5, 55, 119, 93, 245, 115, 751, 3423, 4745, 12093, 14775, 62573, 24693}},
    {8986, 17, 27727, {1, 1, 1, 11, 3, 47, 13, 75, 19, 583, 1873, 2877, 6203, 4987, 6775, 50805, 50097}},
    {8987, 17, 27745, {1, 1, 3, 15, 1, 5, 67, 111, 357, 415, 193, 3619, 7941, 1987, 4923, 26597, 17503}},
    {8988, 17, 27763, {1, 1, 3, 9, 1, 13, 75, 65, 499, 725, 1803, 2245, 1673, 13275, 23165, 44097, 40901}},
    {8989, 17, 27769, {1, 1, 3, 15, 25, 35, 119, 179, 321, 33, 1161, 2717, 5559, 823, 6479, 19113, 49165}},
    {8990, 17, 27770, {1, 1, 3, 9, 27, 23, 127, 33, 375, 211, 1279, 2223, 1615, 9495, 12117, 39157, 79429}},
    {8991, 17, 27796, {1, 1, 3, 9, 17, 51, 51, 147, 223, 589, 673, 1127, 6503, 6909, 9095, 47719, 14521}},
    {8992, 17, 27810, {1, 3, 1, 3, 31, 7, 15, 211, 15, 767, 625, 41, 2439, 2845, 25693, 50757, 111939}},
    {8993, 17, 27812, {1, 3, 7, 3, 23, 21, 73, 37, 33, 647, 1261, 3813, 2941, 10655, 26813, 27987, 87541}},
    {8994, 17, 27834, {1, 1, 7, 7, 7, 49, 105, 127, 43, 787, 401, 229, 7689, 10765, 26855, 13749, 122023}},
    {8995, 17, 27847, {1, 1, 3, 7, 23, 9, 69, 137, 403, 457, 1897, 2033, 3927, 6719, 19931, 13807, 96709}},
    {8996, 17, 27848, {1, 1, 7, 3, 29, 61, 67, 231, 3, 15, 507, 3607, 5823, 12673, 26409, 17107, 32315}},
    {8997, 17, 27862, {1, 3, 5, 3, 25, 13, 81, 245, 311, 109, 655, 4053, 2493, 14113, 1503, 27883, 127709}},
    {8998, 17, 27868, {1, 1, 1, 5, 9, 1, 87, 163, 127, 87, 823, 87, 1115, 15739, 7643, 12797, 56495}},
    {8999, 17, 27881, {1, 3, 5, 7, 25, 51, 33, 151, 241, 947, 1673, 461, 5235, 8311, 7425, 42811, 1693}},
    {9000, 17, 27884, {1, 3, 7, 3, 25, 9, 115, 63, 201, 125, 391, 1355, 3791, 13891, 13137, 5121, 211}},
    {9001, 17, 27890, {1, 1, 1, 9, 1, 57, 41, 27, 445, 243, 1135, 1385, 5755, 7297, 11833, 28733, 65911}},
    {9002, 17, 27895, {1, 1, 5, 15, 7, 17, 41, 51, 381, 217, 707, 1007, 3859, 8335, 18209, 25249, 72811}},
    {9003, 17, 27904, {1, 1, 7, 13, 15, 13, 9, 125, 413, 97, 1723, 3955, 1699, 6237, 10129, 14083, 73345}},
    {9004, 17, 27914, {1, 3, 5, 1, 3, 47, 109, 239, 493, 881, 775, 793, 873, 3301, 16313, 6637, 128817}},
    {9005, 17, 27919, {1, 3, 5, 9, 29, 21, 33, 109, 33, 899, 1811, 1553, 7353, 8585, 28845, 49127, 111471}},
    {9006, 17, 27921, {1, 1, 3, 3, 31, 55, 53, 59, 107, 917, 1347, 3951, 1817, 6631, 19515, 15143, 91529}},
    {9007, 17, 27931, {1, 3, 5, 11, 21, 63, 113, 117, 325, 813, 1671, 2317, 3191, 1551, 18099, 64109, 15503}},
    {9008, 17, 27933, {1, 1, 1, 3, 19, 11, 121, 199, 297, 567, 415, 887, 4163, 2543, 17357, 57203, 40669}},
    {9009, 17, 27938, {1, 3, 1, 5, 25, 5, 65, 133, 487, 599, 1317, 163, 3685, 5485, 7361, 6333, 49085}},
    {9010, 17, 27943, {1, 1, 5, 3, 27, 45, 125, 59, 471, 733, 1647, 165, 5903, 10129, 19685, 10847, 106851}},
    {9011, 17, 27949, {1, 3, 7, 7, 7, 49, 65, 29, 53, 667, 1799, 2309, 5605, 10079, 25893, 37517, 49353}},
    {9012, 17, 28005, {1, 1, 7, 9, 29, 41, 79, 157, 215, 919, 897, 467, 6211, 13929, 20489, 42525, 108695}},
    {9013, 17, 28012, {1, 3, 7, 11, 27, 59, 19, 221, 263, 803, 1593, 1985, 4383, 3075, 17657, 16341, 80649}},
    {9014, 17, 28017, {1, 1, 1, 7, 27, 53, 99, 91, 41, 403, 1297, 47, 2415, 8851, 6345, 52397, 17833}},
    {9015, 17, 28024, {1, 1, 5, 15, 1, 27, 5, 143, 307, 491, 1663, 1101, 1073, 4057, 13851, 17881, 115913}},
    {9016, 17, 28030, {1, 3, 1, 9, 31, 27, 11, 99, 61, 509, 1565, 2993, 7191, 9331, 12569, 61145, 15385}},
    {9017, 17, 28034, {1, 3, 7, 3, 13, 19, 63, 223, 47, 247, 1461, 1821, 7345, 7953, 12681, 24359, 73769}},
    {9018, 17, 28045, {1, 1, 3, 9, 23, 53, 51, 69, 15, 757, 1207, 2733, 1153, 5647, 809, 23609, 131063}},
    {9019, 17, 28048, {1, 1, 7, 7, 7, 21, 7, 207, 151, 101, 285, 835, 4015, 4707, 19201, 9445, 37427}},
    {9020, 17, 28054, {1, 3, 3, 9, 25, 57, 73, 217, 281, 353, 595, 555, 673, 2805, 27697, 40259, 98525}},
    {9021, 17, 28063, {1, 3, 5, 11, 31, 49, 45, 139, 301, 997, 1285, 169, 2167, 2779, 29793, 48549, 114531}},
    {9022, 17, 28069, {1, 3, 1, 3, 27, 11, 49, 155, 365, 3, 1625, 919, 5095, 8235, 327, 15467, 49077}},
    {9023, 17, 28070, {1, 1, 7, 5, 23, 39, 39, 25, 455, 729, 1649, 3721, 5199, 13157, 18383, 10483, 33193}},
    {9024, 17, 28073, {1, 1, 5, 1, 9, 15, 103, 147, 485, 881, 703, 2841, 7751, 4951, 16809, 58635, 13889}},
    {9025, 17, 28084, {1, 3, 5, 7, 9, 19, 51, 87, 243, 77, 237, 1761, 1317, 14497, 6465, 56043, 56627}},
    {9026, 17, 28096, {1, 1, 3, 11, 19, 33, 85, 21, 483, 683, 1199, 689, 891, 10617, 27667, 36415, 82031}},
    {9027, 17, 28114, {1, 3, 5, 7, 23, 51, 91, 169, 163, 591, 1507, 2365, 8055, 12949, 4921, 17069, 22087}},
    {9028, 17, 28126, {1, 3, 1, 5, 9, 13, 11, 125, 279, 149, 475, 3833, 3877, 3103, 18047, 7085, 22901}},
    {9029, 17, 28141, {1, 3, 3, 11, 15, 33, 65, 15, 125, 833, 115, 3953, 845, 15127, 15899, 22847, 44629}},
    {9030, 17, 28149, {1, 1, 5, 13, 19, 55, 47, 31, 119, 221, 623, 3443, 7589, 12333, 8843, 46989, 49195}},
    {9031, 17, 28165, {1, 1, 5, 9, 17, 23, 63, 247, 477, 251, 603, 4021, 1247, 9645, 9913, 8139, 43669}},
    {9032, 17, 28177, {1, 1, 5, 15, 27, 43, 105, 21, 427, 415, 525, 2947, 3061, 883, 2117, 1921, 17163}},
    {9033, 17, 28189, {1, 1, 1, 3, 3, 45, 79, 81, 219, 175, 1209, 1629, 845, 15733, 4543, 4011, 87929}},
    {9034, 17, 28190, {1, 1, 1, 3, 19, 41, 27, 39, 477, 917, 1117, 3667, 5713, 7735, 9623, 6767, 124397}},
    {9035, 17, 28203, {1, 3, 3, 5, 1, 13, 3, 179, 57, 619, 1115, 1941, 1197, 3513, 25343, 4239, 62845}},
    {9036, 17, 28206, {1, 3, 5, 11, 17, 55, 71, 85, 429, 445, 843, 775, 111, 8543, 1433, 30253, 86313}},
    {9037, 17, 28208, {1, 1, 7, 1, 11, 45, 121, 135, 339, 177, 1703, 521, 3531, 1363, 3707, 62345, 98957}},
    {9038, 17, 28220, {1, 3, 7, 13, 23, 7, 123, 17, 303, 511, 553, 3163, 5169, 7797, 32363, 37233, 80575}},
    {9039, 17, 28226, {1, 1, 3, 9, 11, 15, 45, 9, 415, 295, 801, 2139, 3973, 2467, 15075, 42063, 11571}},
    {9040, 17, 28231, {1, 3, 7, 13, 17, 41, 25, 139, 399, 865, 1625, 1721, 2111, 8175, 14727, 301, 59381}},
    {9041, 17, 28249, {1, 1, 1, 1, 19, 55, 127, 53, 103, 985, 2039, 1275, 5879, 449, 25521, 40279, 81619}},
    {9042, 17, 28256, {1, 3, 3, 3, 11, 35, 49, 41, 315, 137, 457, 3795, 8077, 16133, 20359, 40935, 93283}},
    {9043, 17, 28259, {1, 1, 1, 3, 31, 53, 55, 113, 217, 179, 1263, 3029, 1101, 3367, 32091, 17877, 41927}},
    {9044, 17, 28265, {1, 1, 3, 1, 13, 19, 13, 181, 75, 815, 1141, 3777, 587, 15063, 13619, 11717, 1663}},
    {9045, 17, 28266, {1, 3, 5, 5, 7, 17, 27, 255, 423, 847, 295, 1469, 2645, 11601, 18583, 20119, 28809}},
    {9046, 17, 28271, {1, 1, 5, 5, 17, 23, 39, 105, 487, 953, 1925, 821, 6041, 14781, 24679, 39059, 116561}},
    {9047, 17, 28274, {1, 1, 7, 15, 27, 47, 55, 33, 27, 839, 763, 2445, 31, 10219, 25959, 22541, 5451}},
    {9048, 17, 28280, {1, 1, 7, 13, 29, 59, 59, 251, 489, 819, 193, 383, 447, 2175, 12107, 46723, 120249}},
    {9049, 17, 28296, {1, 1, 7, 15, 17, 37, 107, 235, 475, 445, 901, 3157, 4673, 14801, 18793, 36159, 80569}},
    {9050, 17, 28316, {1, 1, 1, 13, 29, 9, 107, 33, 415, 133, 1363, 1639, 4999, 6449, 4147, 20097, 30665}},
    {9051, 17, 28319, {1, 1, 7, 9, 17, 11, 15, 7, 187, 447, 1491, 601, 1911, 7137, 6975, 59381, 50247}},
    {9052, 17, 28343, {1, 3, 5, 3, 11, 43, 5, 211, 35, 23, 999, 1333, 7649, 14461, 3735, 56615, 65925}},
    {9053, 17, 28344, {1, 1, 1, 3, 29, 63, 123, 85, 325, 785, 1917, 1967, 4827, 10071, 16485, 23293, 33191}},
    {9054, 17, 28357, {1, 1, 3, 5, 19, 45, 45, 63, 153, 677, 941, 361, 6765, 3451, 431, 60533, 7261}},
    {9055, 17, 28358, {1, 3, 5, 9, 31, 61, 61, 77, 309, 607, 865, 1117, 2417, 4505, 22687, 55765, 123771}},
    {9056, 17, 28364, {1, 1, 7, 13, 23, 51, 93, 211, 133, 689, 643, 1919, 4171, 1945, 26133, 40461, 27105}},
    {9057, 17, 28370, {1, 1, 7, 9, 5, 3, 7, 241, 79, 435, 1641, 675, 6923, 10149, 19001, 53343, 66259}},
    {9058, 17, 28372, {1, 3, 1, 11, 23, 17, 17, 219, 389, 721, 1851, 2053, 331, 12057, 8633, 22015, 75043}},
    {9059, 17, 28379, {1, 1, 3, 1, 15, 35, 109, 229, 445, 497, 1413, 3851, 7695, 13887, 4979, 22851, 23419}},
    {9060, 17, 28388, {1, 3, 1, 5, 27, 3, 85, 113, 331, 145, 69, 667, 1315, 2143, 12701, 64515, 42059}},
    {9061, 17, 28392, {1, 3, 3, 15, 23, 19, 39, 85, 199, 761, 285, 1201, 955, 1597, 2785, 25559, 7225}},
    {9062, 17, 28395, {1, 3, 1, 3, 23, 45, 23, 127, 69, 381, 1343, 2669, 3197, 4499, 6273, 65337, 51507}},
    {9063, 17, 28406, {1, 3, 1, 3, 11, 27, 113, 37, 463, 31, 687, 929, 2739, 155, 3187, 18967, 37389}},
    {9064, 17, 28418, {1, 1, 3, 7, 15, 1, 71, 199, 69, 1005, 1741, 2429, 6171, 10377, 32265, 43001, 114839}},
    {9065, 17, 28423, {1, 1, 1, 3, 17, 59, 29, 139, 161, 29, 1861, 1607, 4993, 6011, 28507, 36923, 83993}},
    {9066, 17, 28435, {1, 1, 5, 13, 19, 57, 65, 141, 37, 11, 565, 1453, 543, 7369, 8663, 17129, 32963}},
    {9067, 17, 28444, {1, 1, 3, 7, 15, 17, 121, 157, 245, 97, 561, 505, 5725, 2357, 17725, 61597, 127601}},
    {9068, 17, 28454, {1, 1, 7, 5, 7, 21, 101, 61, 85, 381, 1839, 2607, 7897, 4063, 14155, 57757, 88931}},
    {9069, 17, 28468, {1, 3, 3, 7, 7, 61, 97, 189, 109, 771, 359, 3831, 6525, 8339, 24989, 57245, 87685}},
    {9070, 17, 28477, {1, 1, 3, 11, 17, 57, 119, 153, 309, 379, 793, 3343, 1415, 5503, 14549, 65095, 117481}},
    {9071, 17, 28478, {1, 1, 3, 1, 17, 61, 69, 65, 345, 209, 1593, 421, 4427, 509, 30117, 9021, 84839}},
    {9072, 17, 28480, {1, 3, 5, 1, 11, 3, 121, 117, 333, 559, 1051, 2917, 1563, 14473, 22177, 32543, 90861}},
    {9073, 17, 28486, {1, 3, 5, 7, 21, 17, 9, 185, 187, 721, 1375, 2231, 4373, 183, 22283, 50917, 37425}},
    {9074, 17, 28489, {1, 3, 1, 3, 21, 25, 71, 177, 167, 289, 2005, 2231, 2727, 4215, 20327, 42253, 94979}},
    {9075, 17, 28500, {1, 3, 3, 15, 3, 51, 15, 27, 375, 617, 1821, 2131, 2273, 11607, 21035, 40245, 123923}},
    {9076, 17, 28507, {1, 1, 3, 15, 13, 35, 73, 179, 61, 709, 647, 2723, 7571, 1285, 27723, 21339, 86573}},
    {9077, 17, 28519, {1, 3, 5, 11, 23, 39, 79, 15, 459, 647, 407, 2581, 4435, 10195, 23011, 3393, 99363}},
    {9078, 17, 28523, {1, 3, 7, 13, 29, 9, 81, 95, 1, 763, 1117, 2719, 1797, 16129, 26877, 61147, 68183}},
    {9079, 17, 28534, {1, 3, 7, 15, 21, 59, 115, 207, 401, 433, 791, 1239, 5179, 6957, 12605, 30995, 23081}},
    {9080, 17, 28547, {1, 3, 3, 11, 25, 59, 91, 51, 223, 329, 569, 287, 6829, 6005, 25591, 36141, 108875}},
    {9081, 17, 28549, {1, 1, 1, 7, 13, 35, 123, 33, 493, 617, 35, 1257, 3585, 9667, 2537, 49307, 53057}},
    {9082, 17, 28562, {1, 1, 5, 3, 31, 63, 53, 219, 401, 593, 1041, 3159, 3431, 9387, 13979, 23879, 38101}},
    {9083, 17, 28571, {1, 1, 5, 1, 17, 47, 109, 199, 405, 93, 293, 713, 4353, 5355, 12631, 23563, 108757}},
    {9084, 17, 28583, {1, 1, 3, 15, 19, 57, 35, 57, 349, 419, 569, 3181, 4935, 3035, 16593, 1163, 125211}},
    {9085, 17, 28584, {1, 3, 5, 13, 9, 27, 23, 119, 459, 701, 801, 321, 737, 14087, 12287, 10371, 65129}},
    {9086, 17, 28595, {1, 3, 7, 5, 31, 51, 121, 95, 121, 263, 229, 1003, 3513, 2243, 285, 15425, 4421}},
    {9087, 17, 28597, {1, 1, 7, 15, 21, 37, 29, 161, 261, 403, 1003, 1455, 7635, 1301, 8335, 59113, 6753}},
    {9088, 17, 28604, {1, 1, 7, 11, 25, 21, 33, 131, 57, 513, 37, 31, 155, 4527, 3841, 10651, 84473}},
    {9089, 17, 28607, {1, 3, 1, 11, 31, 25, 67, 161, 153, 573, 15, 905, 7187, 10069, 29753, 9199, 49463}},
    {9090, 17, 28609, {1, 1, 5, 3, 7, 53, 39, 63, 333, 373, 751, 1183, 2837, 13513, 9527, 52893, 113085}},
    {9091, 17, 28612, {1, 3, 1, 3, 17, 5, 5, 191, 425, 347, 651, 3901, 613, 9425, 1633, 62545, 16425}},
    {9092, 17, 28630, {1, 1, 1, 3, 9, 27, 23, 249, 127, 291, 491, 3589, 5961, 7019, 27051, 41701, 85967}},
    {9093, 17, 28640, {1, 3, 5, 11, 25, 39, 103, 231, 161, 341, 1553, 3279, 3271, 10355, 26865, 63233, 97531}},
    {9094, 17, 28669, {1, 3, 1, 13, 19, 5, 95, 63, 37, 39, 13, 1379, 6467, 1903, 31555, 33653, 52699}},
    {9095, 17, 28677, {1, 3, 7, 1, 11, 51, 3, 181, 77, 159, 585, 1923, 7547, 1373, 27269, 42149, 113325}},
    {9096, 17, 28682, {1, 1, 7, 7, 27, 9, 87, 67, 37, 987, 1357, 3437, 879, 2819, 9373, 62783, 40817}},
    {9097, 17, 28690, {1, 1, 7, 15, 13, 23, 29, 201, 195, 45, 295, 529, 6403, 12733, 31955, 17661, 63523}},
    {9098, 17, 28695, {1, 3, 1, 13, 9, 51, 87, 191, 167, 959, 825, 1477, 7953, 7677, 26967, 5685, 96987}},
    {9099, 17, 28696, {1, 1, 3, 5, 7, 61, 25, 161, 333, 605, 967, 949, 3751, 5957, 6329, 22215, 29593}},
    {9100, 17, 28717, {1, 1, 5, 13, 17, 13, 57, 219, 487, 819, 1705, 2031, 6625, 13699, 21225, 20043, 114849}},
    {9101, 17, 28730, {1, 3, 3, 11, 21, 37, 51, 69, 135, 53, 505, 1759, 13, 4391, 3797, 31669, 75371}},
    {9102, 17, 28737, {1, 1, 1, 9, 5, 11, 43, 101, 31, 669, 305, 789, 2973, 15373, 10327, 60239, 6309}},
    {9103, 17, 28752, {1, 1, 5, 9, 31, 41, 105, 73, 455, 727, 1207, 1239, 1381, 1143, 31083, 61961, 91095}},
    {9104, 17, 28761, {1, 1, 7, 5, 11, 43, 21, 117, 429, 411, 921, 539, 43, 6217, 4669, 33065, 111385}},
    {9105, 17, 28774, {1, 3, 1, 7, 7, 19, 15, 63, 319, 1015, 1705, 2037, 2271, 731, 9257, 50207, 16977}},
    {9106, 17, 28783, {1, 3, 1, 1, 7, 27, 5, 217, 145, 757, 1307, 611, 6255, 15011, 17001, 31095, 129311}},
    {9107, 17, 28791, {1, 1, 5, 13, 21, 39, 81, 145, 267, 491, 701, 3197, 1157, 6509, 19671, 56239, 1023}},
    {9108, 17, 28801, {1, 3, 7, 5, 9, 13, 31, 145, 71, 887, 503, 1941, 4091, 1379, 20393, 56427, 74019}},
    {9109, 17, 28802, {1, 1, 7, 15, 3, 55, 3, 211, 323, 927, 675, 3615, 2761, 12385, 15849, 13517, 92475}},
    {9110, 17, 28814, {1, 1, 5, 9, 17, 7, 5, 221, 403, 527, 753, 1105, 3349, 10265, 11617, 35953, 91835}},
    {9111, 17, 28837, {1, 1, 3, 11, 23, 53, 127, 171, 347, 815, 569, 3433, 6845, 15357, 6169, 61801, 100489}},
    {9112, 17, 28838, {1, 3, 7, 13, 1, 9, 125, 245, 271, 781, 921, 443, 6509, 9767, 14113, 43969, 124471}},
    {9113, 17, 28842, {1, 3, 1, 3, 19, 13, 75, 3, 389, 647, 1301, 3971, 331, 7795, 9103, 21643, 110393}},
    {9114, 17, 28844, {1, 3, 3, 3, 17, 47, 31, 75, 419, 1001, 687, 3755, 2689, 9105, 3869, 6321, 71419}},
    {9115, 17, 28849, {1, 3, 3, 3, 17, 29, 81, 151, 377, 479, 2017, 1983, 6817, 10531, 11245, 63139, 8121}},
    {9116, 17, 28864, {1, 3, 1, 3, 5, 21, 61, 251, 459, 293, 399, 2065, 7919, 2923, 4623, 54929, 42177}},
    {9117, 17, 28867, {1, 3, 1, 15, 31, 55, 39, 125, 439, 199, 63, 1323, 271, 2749, 6753, 9221, 87949}},
    {9118, 17, 28881, {1, 3, 1, 3, 23, 1, 27, 179, 123, 835, 257, 999, 1635, 8425, 32191, 49077, 14725}},
    {9119, 17, 28882, {1, 3, 1, 1, 25, 49, 87, 131, 343, 561, 1149, 281, 5353, 5941, 4027, 59837, 62519}},
    {9120, 17, 28893, {1, 1, 1, 1, 27, 19, 107, 131, 339, 737, 979, 1007, 7367, 15973, 14599, 24347, 5875}},
    {9121, 17, 28903, {1, 3, 5, 15, 3, 39, 89, 187, 79, 747, 111, 1515, 7533, 12865, 23869, 14271, 38737}},
    {9122, 17, 28907, {1, 3, 5, 3, 11, 51, 89, 99, 115, 967, 1213, 3433, 6635, 8673, 30883, 3665, 29133}},
    {9123, 17, 28909, {1, 3, 1, 9, 31, 7, 113, 165, 57, 757, 671, 1153, 1437, 3257, 6891, 20103, 121707}},
    {9124, 17, 28921, {1, 3, 5, 15, 3, 47, 9, 153, 63, 285, 1299, 321, 567, 597, 24153, 2049, 10453}},
    {9125, 17, 28927, {1, 3, 7, 7, 5, 39, 9, 157, 259, 497, 525, 2937, 2513, 15391, 2743, 65397, 56463}},
    {9126, 17, 28929, {1, 1, 5, 11, 7, 43, 33, 213, 325, 543, 1221, 2445, 3223, 14275, 19051, 14909, 73967}},
    {9127, 17, 28935, {1, 3, 3, 1, 3, 31, 115, 129, 273, 25, 1245, 2759, 5055, 12931, 5933, 17273, 103729}},
    {9128, 17, 28941, {1, 1, 5, 5, 13, 39, 15, 83, 117, 971, 1729, 2469, 7145, 6313, 14617, 7627, 107057}},
    {9129, 17, 28942, {1, 1, 3, 7, 27, 11, 75, 145, 169, 251, 1999, 3865, 7805, 12807, 9565, 1049, 120469}},
    {9130, 17, 28954, {1, 1, 5, 7, 19, 5, 113, 91, 61, 431, 289, 1477, 2345, 11307, 11505, 59761, 105185}},
    {9131, 17, 28959, {1, 1, 1, 5, 31, 43, 109, 231, 431, 337, 1469, 447, 7393, 3551, 19665, 50215, 65585}},
    {9132, 17, 28960, {1, 1, 1, 11, 7, 13, 69, 1, 213, 921, 621, 3289, 2485, 3101, 13095, 16805, 112487}},
    {9133, 17, 28990, {1, 1, 5, 3, 5, 29, 37, 223, 147, 651, 1123, 2775, 6389, 11811, 9899, 19233, 57671}},
    {9134, 17, 28992, {1, 1, 3, 5, 3, 33, 57, 153, 375, 35, 1405, 3903, 5337, 3847, 26843, 35825, 2911}},
    {9135, 17, 29004, {1, 1, 5, 11, 21, 49, 119, 91, 127, 221, 1923, 1485, 6629, 13351, 1135, 27645, 117635}},
    {9136, 17, 29010, {1, 3, 5, 13, 27, 27, 37, 217, 225, 271, 9, 2547, 3381, 1599, 459, 19337, 125349}},
    {9137, 17, 29012, {1, 1, 1, 9, 5, 47, 93, 109, 79, 225, 857, 2577, 1235, 3791, 26423, 25157, 80803}},
    {9138, 17, 29021, {1, 1, 1, 5, 31, 45, 89, 231, 393, 149, 1499, 239, 3817, 12399, 19459, 51059, 43861}},
    {9139, 17, 29035, {1, 1, 1, 13, 17, 41, 27, 101, 331, 605, 1291, 1785, 4353, 2829, 29149, 17533, 95469}},
    {9140, 17, 29040, {1, 1, 7, 11, 9, 57, 7, 175, 285, 399, 1633, 2255, 809, 6637, 15621, 34309, 87597}},
    {9141, 17, 29059, {1, 1, 7, 11, 19, 21, 49, 141, 351, 593, 131, 3431, 5373, 4013, 30243, 34877, 59093}},
    {9142, 17, 29068, {1, 1, 1, 7, 11, 39, 127, 155, 275, 419, 477, 621, 2163, 13083, 17367, 54783, 102969}},
    {9143, 17, 29080, {1, 1, 1, 13, 23, 37, 53, 123, 287, 339, 1147, 783, 1507, 7255, 21963, 57705, 85379}},
    {9144, 17, 29086, {1, 3, 5, 15, 21, 61, 83, 179, 461, 943, 597, 1303, 6217, 7299, 32759, 46133, 108055}},
    {9145, 17, 29089, {1, 3, 7, 15, 17, 49, 15, 139, 143, 213, 665, 1537, 3517, 5659, 6299, 65115, 117093}},
    {9146, 17, 29090, {1, 3, 7, 3, 15, 13, 81, 239, 231, 899, 1297, 3247, 5835, 7673, 20065, 46633, 20857}},
    {9147, 17, 29095, {1, 1, 7, 1, 17, 57, 19, 51, 321, 811, 1033, 3463, 6037, 10281, 7143, 35739, 119175}},
    {9148, 17, 29113, {1, 3, 3, 1, 1, 9, 125, 159, 453, 969, 197, 279, 483, 6083, 15753, 38911, 122895}},
    {9149, 17, 29127, {1, 1, 1, 9, 11, 31, 81, 155, 83, 813, 1205, 307, 6603, 9323, 3361, 22935, 38635}},
    {9150, 17, 29131, {1, 1, 5, 7, 27, 45, 59, 109, 505, 371, 1527, 887, 6983, 8587, 691, 22417, 6273}},
    {9151, 17, 29148, {1, 1, 3, 3, 25, 47, 25, 99, 457, 785, 905, 2627, 7805, 5865, 24567, 51587, 65721}},
    {9152, 17, 29161, {1, 1, 7, 3, 7, 25, 45, 161, 159, 933, 1977, 3011, 7645, 805, 25031, 25751, 78081}},
    {9153, 17, 29172, {1, 1, 7, 5, 3, 41, 75, 181, 333, 727, 1015, 939, 5461, 12297, 30319, 15955, 67613}},
    {9154, 17, 29179, {1, 1, 5, 15, 29, 47, 35, 205, 47, 465, 373, 1051, 6889, 5607, 7891, 13227, 99769}},
    {9155, 17, 29188, {1, 1, 3, 11, 27, 39, 13, 115, 155, 909, 1971, 3475, 4139, 2245, 4933, 17735, 98301}},
    {9156, 17, 29192, {1, 1, 5, 9, 31, 43, 91, 195, 361, 531, 353, 2841, 3501, 4441, 6857, 40217, 42111}},
    {9157, 17, 29195, {1, 1, 3, 7, 5, 57, 33, 129, 55, 763, 1917, 2139, 3135, 13471, 25441, 47137, 14499}},
    {9158, 17, 29206, {1, 1, 5, 13, 5, 39, 1, 215, 365, 135, 1891, 3605, 1247, 13191, 14395, 23877, 26543}},
    {9159, 17, 29210, {1, 1, 5, 3, 13, 15, 3, 253, 13, 705, 1635, 4057, 2601, 14103, 7089, 54571, 118629}},
    {9160, 17, 29215, {1, 3, 3, 13, 5, 49, 23, 183, 365, 227, 1281, 3709, 7123, 9297, 24413, 19029, 55305}},
    {9161, 17, 29221, {1, 1, 7, 15, 15, 27, 87, 55, 25, 81, 1387, 2067, 2295, 7617, 2717, 18335, 73267}},
    {9162, 17, 29222, {1, 3, 7, 3, 7, 31, 51, 173, 449, 287, 941, 3191, 3155, 5259, 6553, 31317, 103553}},
    {9163, 17, 29236, {1, 1, 7, 13, 21, 27, 89, 251, 429, 311, 1395, 3045, 2701, 10687, 14891, 16131, 86155}},
    {9164, 17, 29246, {1, 1, 3, 3, 9, 31, 113, 217, 53, 623, 965, 1609, 1773, 1743, 22767, 51975, 19051}},
    {9165, 17, 29248, {1, 3, 3, 11, 9, 61, 7, 133, 331, 1021, 57, 2197, 4807, 9809, 20585, 38705, 105801}},
    {9166, 17, 29253, {1, 1, 5, 5, 11, 27, 43, 255, 439, 787, 1617, 2217, 1609, 6511, 27347, 6549, 59271}},
    {9167, 17, 29272, {1, 3, 5, 15, 25, 61, 63, 149, 263, 969, 237, 1959, 2469, 5795, 16193, 28779, 69137}},
    {9168, 17, 29288, {1, 3, 7, 5, 29, 53, 85, 59, 501, 791, 1245, 2585, 6907, 16381, 8333, 29653, 82701}},
    {9169, 17, 29293, {1, 1, 3, 3, 9, 53, 57, 53, 35, 671, 2017, 1481, 6809, 7073, 8455, 21947, 70975}},
    {9170, 17, 29294, {1, 3, 3, 5, 25, 35, 39, 41, 481, 329, 1535, 2601, 2629, 6717, 6927, 37537, 95737}},
    {9171, 17, 29308, {1, 3, 5, 7, 9, 45, 97, 213, 259, 627, 1635, 2959, 67, 2919, 371, 21277, 17565}},
    {9172, 17, 29318, {1, 1, 5, 1, 25, 41, 109, 225, 93, 519, 1067, 3343, 5573, 12861, 27939, 48541, 44523}},
    {9173, 17, 29321, {1, 1, 3, 3, 21, 29, 115, 233, 229, 399, 1267, 3447, 4897, 261, 20367, 56333, 98041}},
    {9174, 17, 29322, {1, 1, 7, 3, 17, 41, 125, 167, 357, 181, 1895, 3565, 291, 15519, 8907, 13819, 120153}},
    {9175, 17, 29339, {1, 1, 7, 13, 19, 21, 95, 53, 491, 885, 237, 3591, 813, 11425, 11953, 42881, 120127}},
    {9176, 17, 29365, {1, 3, 3, 13, 3, 25, 101, 61, 267, 523, 1355, 1991, 8113, 4467, 2285, 58123, 94261}},
    {9177, 17, 29369, {1, 3, 3, 1, 1, 11, 59, 81, 489, 849, 441, 1479, 5699, 15449, 23011, 2741, 120377}},
    {9178, 17, 29372, {1, 1, 3, 7, 11, 7, 99, 61, 179, 805, 1279, 1181, 535, 8093, 10575, 24651, 46481}},
    {9179, 17, 29377, {1, 3, 5, 13, 15, 55, 43, 105, 223, 847, 1863, 973, 385, 4137, 16363, 22287, 106811}},
    {9180, 17, 29392, {1, 1, 3, 3, 15, 7, 89, 81, 83, 297, 1725, 2885, 8017, 5369, 29403, 40587, 25947}},
    {9181, 17, 29401, {1, 1, 3, 11, 1, 19, 123, 203, 21, 137, 1151, 3909, 2725, 6069, 17, 15879, 45401}},
    {9182, 17, 29402, {1, 3, 7, 9, 27, 37, 23, 153, 367, 41, 1097, 1275, 6247, 14103, 7571, 34127, 9169}},
    {9183, 17, 29418, {1, 3, 5, 3, 5, 27, 5, 135, 397, 389, 1395, 2665, 2829, 7579, 23589, 23431, 78321}},
    {9184, 17, 29437, {1, 1, 3, 13, 5, 25, 119, 83, 119, 789, 2047, 505, 277, 4531, 22107, 13557, 40083}},
    {9185, 17, 29445, {1, 1, 3, 9, 13, 49, 65, 73, 199, 793, 1831, 2481, 4029, 4677, 11609, 23585, 109907}},
    {9186, 17, 29446, {1, 3, 7, 11, 19, 37, 49, 171, 499, 163, 963, 4069, 6117, 5049, 30491, 34989, 32569}},
    {9187, 17, 29460, {1, 3, 7, 3, 17, 27, 113, 217, 231, 405, 755, 3561, 5683, 7195, 14233, 45865, 120479}},
    {9188, 17, 29467, {1, 3, 3, 7, 31, 7, 27, 37, 227, 513, 1207, 549, 7773, 7385, 17533, 61241, 113131}},
    {9189, 17, 29473, {1, 3, 1, 1, 15, 35, 69, 211, 219, 655, 1209, 1461, 1897, 12995, 553, 28723, 40365}},
    {9190, 17, 29476, {1, 3, 1, 5, 17, 23, 3, 251, 131, 801, 3, 1611, 2007, 15367, 24211, 45235, 71735}},
    {9191, 17, 29488, {1, 3, 1, 13, 27, 5, 113, 111, 503, 365, 2047, 3313, 2455, 5985, 19955, 3579, 119625}},
    {9192, 17, 29511, {1, 1, 1, 1, 15, 9, 77, 89, 15, 555, 1797, 231, 655, 9115, 11577, 18465, 64155}},
    {9193, 17, 29512, {1, 1, 1, 7, 7, 61, 51, 33, 161, 187, 59, 3779, 3421, 4731, 885, 47307, 58767}},
    {9194, 17, 29517, {1, 3, 3, 7, 11, 51, 103, 159, 153, 455, 995, 1613, 1867, 4045, 15957, 35393, 35739}},
    {9195, 17, 29523, {1, 1, 1, 1, 5, 31, 127, 211, 429, 43, 1837, 819, 2811, 6249, 11135, 57275, 119609}},
    {9196, 17, 29526, {1, 1, 3, 7, 23, 9, 69, 137, 403, 457, 1897, 2033, 3927, 6719, 19931, 13807, 96709}},
    {9197, 17, 29535, {1, 1, 5, 3, 3, 55, 65, 43, 383, 45, 3, 2097, 6711, 10695, 9415, 28841, 4299}},
    {9198, 17, 29539, {1, 3, 5, 3, 25, 13, 81, 245, 311, 109, 655, 4053, 2493, 14113, 1503, 27883, 127709}},
    {9199, 17, 29545, {1, 1, 3, 15, 17, 37, 23, 109, 405, 963, 2047, 2451, 2105, 11163, 14663, 54425, 25457}},
    {9200, 17, 29559, {1, 1, 5, 1, 7, 55, 87, 119, 195, 793, 273, 1331, 4167, 567, 23987, 55249, 649}},
    {9201, 17, 29560, {1, 3, 3, 15, 5, 3, 11, 51, 261, 325, 1093, 3143, 5649, 14659, 12323, 29857, 112215}},
    {9202, 17, 29589, {1, 1, 5, 11, 11, 59, 77, 141, 123, 187, 989, 1799, 201, 11589, 21127, 39311, 117959}},
    {9203, 17, 29593, {1, 3, 1, 15, 23, 19, 1, 53, 483, 67, 343, 3879, 6369, 445, 21569, 43403, 31277}},
    {9204, 17, 29599, {1, 1, 3, 7, 23, 45, 87, 33, 249, 193, 647, 2701, 7, 11673, 16453, 20195, 31465}},
    {9205, 17, 29603, {1, 1, 1, 9, 3, 3, 55, 27, 427, 605, 615, 2855, 6347, 4375, 29293, 39069, 50037}},
    {9206, 17, 29610, {1, 1, 3, 13, 23, 53, 77, 17, 225, 409, 1321, 2583, 1951, 10385, 26859, 14917, 114733}},
    {9207, 17, 29629, {1, 3, 1, 5, 21, 49, 89, 185, 487, 219, 1781, 3971, 5889, 1325, 22501, 12777, 78719}},
    {9208, 17, 29644, {1, 3, 1, 3, 3, 27, 103, 187, 381, 539, 1083, 3855, 2547, 3101, 15881, 29977, 56603}},
    {9209, 17, 29656, {1, 3, 5, 11, 21, 63, 113, 117, 325, 813, 1671, 2317, 3191, 1551, 18099, 64109, 15503}},
    {9210, 17, 29662, {1, 1, 7, 11, 1, 9, 115, 221, 63, 455, 1241, 3379, 429, 12601, 6797, 53977, 61893}},
    {9211, 17, 29675, {1, 1, 5, 1, 13, 55, 9, 179, 95, 143, 1157, 3675, 6137, 9663, 11035, 21803, 54423}},
    {9212, 17, 29692, {1, 3, 7, 1, 9, 23, 53, 143, 291, 55, 621, 125, 2495, 9749, 25451, 3075, 18831}},
    {9213, 17, 29704, {1, 3, 1, 15, 9, 47, 51, 203, 341, 305, 1643, 3071, 3969, 2837, 26175, 33153, 99937}},
    {9214, 17, 29707, {1, 3, 5, 15, 7, 49, 93, 89, 371, 393, 1441, 977, 849, 3387, 2433, 49751, 22369}},
    {9215, 17, 29715, {1, 1, 7, 13, 5, 27, 29, 149, 25, 743, 1045, 545, 299, 10533, 22547, 25299, 116655}},
    {9216, 17, 29717, {1, 3, 5, 15, 25, 39, 41, 187, 321, 979, 419, 445, 979, 4543, 13833, 60347, 19925}},
    {9217, 17, 29722, {1, 3, 7, 1, 1, 53, 77, 213, 137, 321, 2031, 3373, 4457, 15395, 3301, 11631, 30925}},
    {9218, 17, 29731, {1, 3, 5, 15, 21, 21, 49, 169, 289, 785, 151, 2309, 7475, 4065, 17553, 35213, 63947}},
    {9219, 17, 29740, {1, 1, 5, 15, 29, 21, 15, 177, 467, 393, 1435, 3913, 4693, 8389, 6425, 51477, 57343}},
    {9220, 17, 29743, {1, 3, 7, 9, 1, 31, 63, 149, 137, 999, 1521, 371, 3541, 5587, 29963, 22217, 92813}},
    {9221, 17, 29752, {1, 3, 5, 13, 27, 27, 37, 217, 225, 271, 9, 2547, 3381, 1599, 459, 19337, 125349}},
    {9222, 17, 29760, {1, 1, 7, 7, 29, 27, 101, 203, 377, 473, 1911, 67, 4363, 7317, 19313, 50305, 86897}},
    {9223, 17, 29766, {1, 1, 5, 3, 3, 17, 19, 47, 499, 397, 667, 3373, 1771, 4453, 9519, 48939, 121915}},
    {9224, 17, 29770, {1, 3, 5, 15, 31, 39, 115, 53, 77, 349, 191, 4093, 659, 3471, 13099, 21771, 13017}},
    {9225, 17, 29794, {1, 3, 3, 3, 31, 23, 63, 43, 147, 241, 1249, 563, 3967, 10767, 14059, 12987, 81755}},
    {9226, 17, 29796, {1, 1, 7, 1, 21, 7, 3, 99, 137, 689, 1739, 2171, 3009, 7927, 20005, 32331, 31715}},
    {9227, 17, 29814, {1, 3, 7, 13, 25, 51, 23, 19, 127, 469, 1341, 1665, 3377, 3197, 2051, 8617, 53683}},
    {9228, 17, 29817, {1, 3, 5, 13, 23, 31, 75, 93, 421, 439, 2033, 2677, 593, 2729, 17641, 61789, 41253}},
    {9229, 17, 29829, {1, 1, 3, 3, 15, 15, 85, 31, 457, 797, 849, 1775, 8135, 2943, 15093, 17921, 104801}},
    {9230, 17, 29841, {1, 3, 3, 15, 23, 13, 17, 247, 379, 615, 631, 2385, 6733, 5477, 17, 12607, 88249}},
    {9231, 17, 29851, {1, 3, 5, 15, 7, 19, 83, 129, 233, 277, 239, 1119, 8021, 12649, 28513, 46891, 78133}},
    {9232, 17, 29860, {1, 3, 7, 9, 23, 27, 19, 201, 195, 491, 1667, 3865, 6837, 7363, 32119, 14627, 110175}},
    {9233, 17, 29864, {1, 3, 7, 13, 5, 49, 61, 123, 443, 769, 1669, 2741, 6881, 5965, 9365, 43051, 2979}},
    {9234, 17, 29869, {1, 3, 3, 15, 21, 43, 125, 177, 55, 179, 651, 2727, 3765, 7625, 27111, 35211, 118113}},
    {9235, 17, 29870, {1, 3, 1, 15, 25, 33, 61, 207, 135, 393, 359, 169, 2497, 1527, 2523, 26407, 22661}},
    {9236, 17, 29889, {1, 1, 1, 1, 23, 19, 97, 35, 59, 45, 1577, 3659, 2473, 4225, 8033, 9541, 110033}},
    {9237, 17, 29896, {1, 3, 1, 1, 1, 57, 73, 113, 47, 205, 277, 1993, 3767, 721, 2257, 42359, 79859}},
    {9238, 17, 29901, {1, 1, 5, 11, 13, 39, 37, 225, 165, 355, 933, 913, 1735, 1965, 28895, 21143, 118885}},
    {9239, 17, 29913, {1, 1, 7, 11, 19, 43, 113, 233, 59, 331, 577, 1039, 6443, 3233, 31883, 24861, 5103}},
    {9240, 17, 29919, {1, 1, 3, 13, 17, 21, 103, 109, 435, 247, 1125, 3195, 1281, 9383, 8127, 27535, 113249}},
    {9241, 17, 29920, {1, 3, 7, 7, 23, 59, 99, 199, 493, 195, 1601, 1483, 905, 3615, 11835, 61293, 58341}},
    {9242, 17, 29947, {1, 1, 7, 11, 31, 15, 97, 163, 341, 309, 275, 2371, 5643, 10085, 32649, 38935, 54391}},
    {9243, 17, 29958, {1, 3, 5, 3, 11, 43, 37, 25, 113, 305, 65, 4083, 321, 15615, 17865, 21507, 96835}},
    {9244, 17, 29975, {1, 3, 7, 9, 23, 23, 15, 153, 111, 1017, 203, 969, 5567, 2455, 23393, 47137, 13099}},
    {9245, 17, 29981, {1, 3, 3, 7, 3, 23, 69, 35, 389, 747, 1509, 2933, 4189, 5451, 8347, 60929, 1341}},
    {9246, 17, 29985, {1, 1, 3, 11, 31, 13, 65, 87, 115, 321, 711, 3587, 2225, 9479, 6151, 33225, 41433}},
    {9247, 17, 29998, {1, 3, 1, 7, 7, 35, 9, 207, 307, 429, 1551, 467, 7085, 559, 3355, 30379, 95765}},
    {9248, 17, 30010, {1, 3, 3, 3, 27, 17, 73, 187, 143, 661, 173, 1721, 5369, 2849, 24007, 14331, 36893}},
    {9249, 17, 30012, {1, 3, 3, 5, 15, 5, 101, 183, 239, 7, 697, 1651, 1609, 91, 16919, 55035, 1887}},
    {9250, 17, 30044, {1, 1, 5, 5, 31, 13, 33, 69, 145, 601, 1137, 3627, 3411, 6735, 23403, 46859, 57767}},
    {9251, 17, 30048, {1, 3, 5, 15, 25, 61, 63, 149, 263, 969, 237, 1959, 2469, 5795, 16193, 28779, 69137}},
    {9252, 17, 30051, {1, 3, 7, 15, 31, 61, 71, 201, 17, 503, 1831, 2715, 4395, 16211, 15181, 28107, 55555}},
    {9253, 17, 30063, {1, 3, 5, 15, 29, 47, 7, 251, 419, 279, 1221, 1051, 7875, 9169, 473, 57149, 63103}},
    {9254, 17, 30065, {1, 3, 1, 5, 29, 23, 51, 135, 277, 225, 1509, 1715, 3935, 11125, 23069, 22851, 122431}},
    {9255, 17, 30072, {1, 3, 3, 5, 25, 35, 39, 41, 481, 329, 1535, 2601, 2629, 6717, 6927, 37537, 95737}},
    {9256, 17, 30077, {1, 3, 3, 13, 19, 1, 55, 91, 211, 543, 1687, 2801, 3473, 4587, 14447, 23227, 21147}},
    {9257, 17, 30087, {1, 3, 1, 3, 29, 61, 81, 133, 473, 65, 7, 3351, 4835, 11651, 13643, 62733, 114565}},
    {9258, 17, 30088, {1, 1, 3, 9, 29, 1, 125, 159, 37, 513, 585, 3317, 1861, 7961, 23669, 52399, 33371}},
    {9259, 17, 30101, {1, 1, 1, 7, 13, 23, 3, 45, 35, 781, 1307, 607, 5517, 3859, 32593, 5053, 4987}},
    {9260, 17, 30112, {1, 3, 5, 3, 5, 59, 107, 181, 217, 633, 291, 979, 3055, 10101, 7775, 38379, 97773}},
    {9261, 17, 30121, {1, 1, 3, 13, 29, 21, 105, 87, 133, 209, 1315, 1251, 3895, 14549, 10571, 54585, 7679}},
    {9262, 17, 30122, {1, 1, 5, 1, 21, 59, 91, 209, 149, 299, 1359, 433, 1073, 3001, 21149, 30731, 116683}},
    {9263, 17, 30130, {1, 1, 7, 15, 1, 41, 5, 165, 481, 779, 423, 2609, 2435, 1343, 16407, 475, 223}},
    {9264, 17, 30135, {1, 3, 5, 15, 21, 63, 47, 179, 377, 985, 1199, 373, 5877, 15509, 4449, 3679, 114785}},
    {9265, 17, 30139, {1, 1, 1, 13, 11, 17, 59, 39, 265, 189, 1569, 1193, 2935, 7531, 9739, 6525, 13125}},
    {9266, 17, 30142, {1, 3, 1, 5, 15, 21, 47, 133, 379, 61, 255, 2985, 4697, 5153, 20907, 103, 97297}},
    {9267, 17, 30164, {1, 1, 1, 5, 1, 59, 87, 43, 229, 569, 203, 3887, 745, 15795, 19287, 44155, 28043}},
    {9268, 17, 30167, {1, 3, 7, 3, 29, 33, 23, 195, 277, 867, 1945, 831, 6201, 16149, 5319, 22895, 88157}},
    {9269, 17, 30180, {1, 3, 7, 13, 19, 49, 39, 131, 201, 167, 703, 441, 4797, 8971, 21649, 16387, 79815}},
    {9270, 17, 30202, {1, 1, 7, 11, 31, 61, 1, 181, 449, 599, 1433, 2691, 4879, 9361, 7241, 27791, 105737}},
    {9271, 17, 30211, {1, 3, 7, 3, 17, 27, 113, 217, 231, 405, 755, 3561, 5683, 7195, 14233, 45865, 120479}},
    {9272, 17, 30214, {1, 1, 3, 11, 9, 15, 15, 205, 127, 845, 353, 2203, 5299, 7639, 8967, 43399, 95049}},
    {9273, 17, 30217, {1, 1, 7, 15, 19, 53, 71, 131, 129, 361, 1833, 3463, 6923, 187, 19441, 32321, 102525}},
    {9274, 17, 30223, {1, 3, 1, 1, 15, 35, 69, 211, 219, 655, 1209, 1461, 1897, 12995, 553, 28723, 40365}},
    {9275, 17, 30228, {1, 3, 7, 11, 9, 25, 39, 239, 235, 389, 1019, 2621, 6553, 14075, 18207, 24829, 71853}},
    {9276, 17, 30235, {1, 3, 5, 1, 9, 53, 115, 197, 205, 703, 803, 1347, 757, 15553, 8149, 37867, 7865}},
    {9277, 17, 30256, {1, 1, 3, 7, 1, 47, 125, 125, 7, 295, 401, 2593, 7259, 10475, 20977, 28529, 76791}},
    {9278, 17, 30265, {1, 1, 3, 5, 11, 33, 1, 79, 363, 825, 405, 357, 3107, 13977, 29135, 63813, 118515}},
    {9279, 17, 30286, {1, 3, 3, 7, 23, 1, 17, 33, 9, 37, 627, 353, 1001, 4231, 31035, 12693, 31587}},
    {9280, 17, 30293, {1, 3, 5, 13, 1, 37, 65, 93, 499, 521, 1757, 2361, 733, 14069, 19781, 62273, 98203}},
    {9281, 17, 30298, {1, 3, 5, 13, 23, 37, 41, 233, 469, 773, 1221, 479, 8123, 15541, 28105, 58599, 62417}},
    {9282, 17, 30310, {1, 3, 3, 13, 29, 35, 41, 229, 49, 893, 1685, 1105, 1373, 3133, 10055, 44801, 121673}},
    {9283, 17, 30314, {1, 1, 1, 13, 3, 21, 11, 237, 487, 159, 977, 3817, 8161, 13703, 29733, 5337, 51995}},
    {9284, 17, 30327, {1, 3, 7, 9, 5, 51, 41, 3, 509, 527, 401, 2419, 1511, 8167, 9459, 16867, 80585}},
    {9285, 17, 30333, {1, 3, 3, 15, 5, 3, 11, 51, 261, 325, 1093, 3143, 5649, 14659, 12323, 29857, 112215}},
    {9286, 17, 30334, {1, 1, 3, 1, 1, 33, 71, 63, 237, 287, 39, 2425, 5551, 65, 6835, 20229, 103569}},
    {9287, 17, 30337, {1, 3, 3, 5, 27, 9, 59, 9, 441, 463, 505, 3553, 2551, 5429, 22993, 35951, 47443}},
    {9288, 17, 30338, {1, 1, 5, 13, 27, 25, 53, 129, 21, 367, 1711, 717, 4767, 2729, 18937, 21341, 104131}},
    {9289, 17, 30344, {1, 3, 1, 13, 31, 59, 13, 95, 115, 841, 965, 2797, 1149, 7465, 7487, 49781, 119491}},
    {9290, 17, 30349, {1, 1, 3, 7, 11, 27, 53, 239, 347, 631, 329, 2039, 5791, 2697, 10767, 5875, 97625}},
    {9291, 17, 30352, {1, 3, 7, 1, 5, 47, 33, 1, 501, 791, 1389, 4077, 2059, 13763, 25719, 55145, 98587}},
    {9292, 17, 30362, {1, 3, 1, 15, 29, 13, 61, 69, 497, 709, 1753, 1541, 8143, 14257, 5985, 17931, 35275}},
    {9293, 17, 30374, {1, 1, 5, 3, 25, 9, 89, 51, 21, 947, 249, 2945, 1313, 2271, 25471, 58685, 16745}},
    {9294, 17, 30380, {1, 3, 5, 15, 9, 53, 113, 103, 275, 323, 1417, 1129, 363, 3381, 467, 49095, 65667}},
    {9295, 17, 30388, {1, 3, 7, 5, 27, 55, 39, 149, 241, 391, 807, 3769, 5561, 3859, 10373, 2403, 77421}},
    {9296, 17, 30391, {1, 1, 3, 11, 17, 21, 49, 101, 31, 761, 183, 289, 585, 14001, 8691, 17963, 975}},
    {9297, 17, 30395, {1, 3, 1, 9, 5, 59, 1, 167, 309, 629, 1143, 367, 6149, 6207, 28577, 60405, 59823}},
    {9298, 17, 30403, {1, 3, 7, 7, 7, 49, 65, 29, 53, 667, 1799, 2309, 5605, 10079, 25893, 37517, 49353}},
    {9299, 17, 30409, {1, 3, 5, 13, 21, 57, 93, 169, 365, 745, 641, 467, 7411, 13343, 19435, 53667, 19335}},
    {9300, 17, 30424, {1, 3, 1, 7, 5, 1, 55, 95, 199, 863, 885, 2717, 3005, 13319, 28221, 48131, 93161}},
    {9301, 17, 30427, {1, 1, 1, 11, 23, 5, 99, 137, 199, 647, 1355, 1843, 2877, 3007, 25819, 15095, 69939}},
    {9302, 17, 30430, {1, 3, 7, 1, 9, 35, 113, 81, 401, 1007, 679, 247, 3939, 13079, 13489, 24897, 43521}},
    {9303, 17, 30451, {1, 1, 1, 5, 15, 11, 25, 135, 469, 305, 767, 3669, 3689, 2973, 5963, 40191, 8243}},
    {9304, 17, 30460, {1, 3, 3, 13, 25, 1, 69, 163, 223, 93, 1869, 3689, 2875, 13689, 11927, 30497, 91581}},
    {9305, 17, 30475, {1, 1, 5, 1, 27, 19, 127, 181, 383, 93, 197, 2239, 669, 6639, 1091, 49421, 58331}},
    {9306, 17, 30480, {1, 1, 3, 13, 23, 47, 107, 239, 147, 163, 985, 1491, 7855, 12821, 7031, 33939, 84105}},
    {9307, 17, 30485, {1, 3, 7, 11, 9, 21, 53, 93, 373, 261, 163, 1531, 8015, 4647, 23159, 3699, 117009}},
    {9308, 17, 30486, {1, 1, 3, 3, 31, 31, 73, 103, 9, 957, 1521, 4089, 3729, 11967, 14953, 10527, 9017}},
    {9309, 17, 30489, {1, 1, 1, 15, 19, 43, 23, 43, 9, 971, 1051, 3325, 6691, 1387, 14463, 55767, 52885}},
    {9310, 17, 30492, {1, 1, 1, 1, 21, 19, 27, 229, 53, 463, 253, 3953, 2343, 14569, 10167, 62729, 23829}},
    {9311, 17, 30499, {1, 1, 5, 15, 9, 17, 25, 127, 223, 569, 1225, 859, 7379, 3901, 25983, 30367, 36669}},
    {9312, 17, 30511, {1, 3, 3, 1, 7, 41, 17, 251, 371, 339, 1059, 1407, 8109, 5573, 12217, 38623, 83423}},
    {9313, 17, 30533, {1, 1, 7, 1, 7, 49, 115, 139, 323, 387, 913, 1355, 1013, 3519, 12205, 48631, 124439}},
    {9314, 17, 30534, {1, 3, 5, 9, 15, 47, 117, 217, 357, 191, 2017, 2669, 709, 361, 21307, 48781, 120829}},
    {9315, 17, 30540, {1, 1, 5, 13, 1, 35, 83, 217, 511, 615, 1609, 2325, 2675, 9935, 6949, 44213, 3449}},
    {9316, 17, 30545, {1, 3, 5, 13, 17, 39, 125, 15, 367, 321, 1483, 2011, 5873, 14435, 1671, 34859, 40925}},
    {9317, 17, 30552, {1, 3, 3, 11, 5, 19, 127, 165, 473, 637, 1677, 1433, 8085, 8781, 18157, 11663, 2763}},
    {9318, 17, 30557, {1, 1, 1, 15, 27, 7, 125, 175, 237, 169, 1301, 2779, 691, 4873, 30129, 39839, 114841}},
    {9319, 17, 30558, {1, 1, 1, 5, 17, 35, 19, 55, 355, 645, 1205, 2047, 7691, 16369, 29197, 29513, 82729}},
    {9320, 17, 30567, {1, 1, 5, 13, 23, 55, 61, 135, 253, 413, 1083, 1739, 4249, 835, 3097, 16797, 19917}},
    {9321, 17, 30568, {1, 3, 1, 1, 29, 23, 41, 53, 189, 403, 735, 3017, 3295, 5365, 11477, 177, 129477}},
    {9322, 17, 30581, {1, 1, 1, 15, 21, 55, 71, 23, 11, 917, 973, 1355, 3935, 203, 8321, 47747, 7753}},
    {9323, 17, 30597, {1, 3, 5, 3, 11, 27, 55, 65, 81, 459, 1897, 1641, 4339, 1451, 21383, 51479, 31367}},
    {9324, 17, 30607, {1, 1, 1, 13, 1, 63, 83, 111, 471, 183, 1507, 1117, 4053, 6413, 29187, 39991, 8311}},
    {9325, 17, 30621, {1, 3, 7, 13, 25, 63, 13, 243, 327, 361, 109, 3959, 6035, 13881, 21643, 60381, 85717}},
    {9326, 17, 30632, {1, 1, 7, 9, 29, 33, 17, 203, 91, 391, 107, 733, 4809, 14149, 20505, 59439, 126155}},
    {9327, 17, 30650, {1, 3, 1, 13, 27, 23, 21, 135, 213, 483, 1163, 3787, 693, 6525, 18899, 25995, 70333}},
    {9328, 17, 30655, {1, 3, 7, 13, 17, 41, 25, 139, 399, 865, 1625, 1721, 2111, 8175, 14727, 301, 59381}},
    {9329, 17, 30657, {1, 3, 7, 15, 31, 53, 57, 141, 251, 163, 1987, 3821, 8075, 12875, 3039, 52973, 72549}},
    {9330, 17, 30660, {1, 3, 3, 15, 5, 37, 117, 207, 145, 89, 205, 3065, 6723, 12881, 16127, 58813, 16419}},
    {9331, 17, 30669, {1, 3, 3, 1, 27, 3, 47, 227, 29, 931, 1609, 1633, 1329, 3455, 3133, 40765, 16937}},
    {9332, 17, 30675, {1, 3, 1, 1, 5, 51, 77, 41, 275, 229, 1847, 3557, 3769, 1439, 24721, 38255, 92605}},
    {9333, 17, 30678, {1, 3, 7, 7, 7, 41, 19, 101, 157, 851, 985, 3933, 2109, 3847, 14143, 59155, 67523}},
    {9334, 17, 30682, {1, 1, 5, 5, 17, 23, 39, 105, 487, 953, 1925, 821, 6041, 14781, 24679, 39059, 116561}},
    {9335, 17, 30687, {1, 1, 3, 9, 17, 61, 3, 133, 5, 21, 2021, 1137, 7015, 9389, 23985, 55025, 20237}},
    {9336, 17, 30688, {1, 3, 3, 11, 17, 21, 33, 11, 93, 105, 677, 2005, 4667, 12471, 19991, 21107, 21615}},
    {9337, 17, 30698, {1, 1, 5, 11, 29, 51, 37, 167, 155, 883, 7, 2793, 3889, 10959, 25721, 65129, 120531}},
    {9338, 17, 30711, {1, 3, 1, 13, 31, 21, 21, 35, 249, 349, 631, 1055, 4909, 14869, 22661, 1601, 7115}},
    {9339, 17, 30728, {1, 1, 3, 1, 21, 17, 9, 101, 363, 473, 1477, 3177, 5865, 4287, 12133, 26875, 30091}},
    {9340, 17, 30733, {1, 1, 1, 7, 13, 9, 123, 97, 21, 171, 921, 2747, 1263, 6527, 6573, 65171, 31153}},
    {9341, 17, 30741, {1, 1, 3, 7, 31, 21, 35, 19, 487, 331, 1961, 2839, 1305, 15945, 29363, 32435, 129247}},
    {9342, 17, 30746, {1, 3, 1, 1, 25, 41, 101, 109, 117, 805, 2041, 2359, 7275, 7601, 29195, 26185, 36731}},
    {9343, 17, 30752, {1, 1, 7, 1, 21, 1, 17, 187, 161, 891, 1973, 1709, 231, 11559, 20147, 32519, 48247}},
    {9344, 17, 30764, {1, 1, 5, 1, 13, 33, 81, 11, 121, 737, 1323, 2631, 7159, 10149, 10023, 19969, 97783}},
    {9345, 17, 30769, {1, 1, 5, 1, 13, 39, 105, 107, 399, 917, 1737, 3197, 1413, 4229, 11855, 3695, 113885}},
    {9346, 17, 30784, {1, 3, 7, 7, 7, 49, 123, 57, 483, 407, 1789, 1585, 421, 1515, 26811, 4687, 44897}},
    {9347, 17, 30796, {1, 3, 1, 5, 21, 43, 33, 193, 337, 29, 775, 1005, 2295, 4303, 13603, 36725, 49587}},
    {9348, 17, 30799, {1, 1, 5, 9, 23, 47, 89, 197, 333, 415, 809, 2957, 1243, 9219, 15517, 29969, 2403}},
    {9349, 17, 30804, {1, 3, 7, 13, 31, 7, 27, 231, 129, 201, 1145, 75, 5033, 14711, 21391, 57603, 70277}},
    {9350, 17, 30811, {1, 1, 1, 5, 27, 59, 19, 57, 499, 569, 1379, 413, 3849, 12841, 8443, 19879, 46093}},
    {9351, 17, 30814, {1, 1, 5, 15, 11, 37, 11, 229, 363, 541, 319, 3221, 4863, 16019, 6701, 16805, 71465}},
    {9352, 17, 30818, {1, 1, 3, 5, 5, 29, 111, 101, 161, 771, 171, 1811, 4257, 15509, 5383, 9665, 57631}},
    {9353, 17, 30827, {1, 3, 1, 15, 13, 47, 97, 115, 31, 803, 1975, 567, 1803, 16257, 25981, 59675, 32035}},
    {9354, 17, 30838, {1, 1, 5, 11, 17, 41, 39, 139, 381, 463, 713, 675, 6123, 9909, 8813, 49657, 8305}},
    {9355, 17, 30842, {1, 1, 7, 11, 5, 19, 3, 109, 129, 747, 1, 253, 59, 3059, 3553, 38975, 88401}},
    {9356, 17, 30854, {1, 3, 5, 13, 29, 23, 99, 203, 279, 533, 451, 3631, 6459, 2167, 23801, 32667, 96371}},
    {9357, 17, 30863, {1, 3, 7, 11, 19, 63, 97, 47, 343, 11, 939, 37, 6801, 14865, 6867, 25811, 27395}},
    {9358, 17, 30865, {1, 3, 5, 5, 7, 27, 125, 215, 135, 831, 1943, 2039, 3409, 4999, 22577, 42865, 70837}},
    {9359, 17, 30877, {1, 3, 5, 15, 9, 47, 71, 177, 175, 173, 413, 2431, 6335, 11623, 30355, 25131, 59351}},
    {9360, 17, 30881, {1, 1, 7, 5, 17, 35, 43, 7, 161, 977, 649, 2219, 3207, 11527, 16271, 49411, 118799}},
    {9361, 17, 30887, {1, 1, 5, 5, 15, 41, 49, 191, 247, 739, 1507, 3135, 5751, 15527, 21383, 47389, 31701}},
    {9362, 17, 30908, {1, 1, 7, 1, 11, 39, 113, 199, 333, 617, 709, 1263, 2239, 4421, 2073, 65137, 5827}},
    {9363, 17, 30916, {1, 1, 5, 5, 1, 1, 107, 93, 349, 665, 1513, 2169, 8145, 1689, 15715, 8199, 33419}},
    {9364, 17, 30919, {1, 3, 5, 1, 3, 33, 53, 103, 433, 549, 1533, 3255, 2205, 16011, 4215, 48411, 1925}},
    {9365, 17, 30925, {1, 1, 1, 7, 31, 5, 107, 85, 117, 247, 1185, 2305, 1645, 11723, 10681, 31489, 84659}},
    {9366, 17, 30928, {1, 1, 3, 7, 9, 31, 31, 235, 81, 683, 1391, 1509, 2531, 6571, 23071, 40051, 100559}},
    {9367, 17, 30944, {1, 1, 1, 11, 15, 51, 125, 219, 63, 1, 655, 1687, 2431, 5935, 26363, 31113, 124059}},
    {9368, 17, 30947, {1, 3, 3, 1, 17, 9, 107, 157, 23, 649, 1087, 2499, 5979, 5719, 17951, 49577, 91523}},
    {9369, 17, 30950, {1, 3, 7, 13, 1, 7, 117, 139, 101, 109, 1489, 1259, 5097, 7509, 29719, 12037, 31879}},
    {9370, 17, 30968, {1, 3, 5, 15, 5, 3, 9, 63, 497, 567, 1741, 3679, 311, 733, 13017, 33405, 69557}},
    {9371, 17, 30971, {1, 1, 1, 9, 11, 19, 81, 75, 49, 945, 699, 3171, 3523, 2709, 27251, 16301, 118759}},
    {9372, 17, 30973, {1, 3, 7, 3, 25, 53, 107, 213, 35, 643, 1505, 2567, 7987, 6079, 3235, 44769, 116333}},
    {9373, 17, 30976, {1, 1, 1, 13, 3, 27, 33, 169, 377, 359, 1461, 1687, 6359, 3211, 26891, 63901, 129385}},
    {9374, 17, 30986, {1, 3, 7, 7, 23, 25, 21, 217, 41, 417, 1457, 2353, 3025, 12653, 16783, 63745, 59615}},
    {9375, 17, 30993, {1, 1, 1, 13, 7, 5, 93, 71, 235, 787, 329, 2369, 5069, 10913, 3171, 43961, 98853}},
    {9376, 17, 30994, {1, 3, 5, 5, 15, 7, 67, 29, 277, 869, 705, 1561, 5883, 7447, 23185, 30815, 125667}},
    {9377, 17, 31012, {1, 1, 5, 1, 11, 21, 107, 113, 209, 445, 1723, 2225, 3413, 6479, 4983, 35099, 37993}},
    {9378, 17, 31016, {1, 1, 7, 9, 15, 47, 99, 233, 469, 525, 329, 1193, 6659, 14861, 7815, 58793, 40477}},
    {9379, 17, 31029, {1, 3, 7, 3, 1, 31, 111, 167, 387, 147, 29, 2255, 1349, 5323, 10853, 50067, 77409}},
    {9380, 17, 31039, {1, 1, 1, 3, 1, 15, 117, 171, 259, 185, 1315, 1549, 2131, 6775, 9353, 37545, 70071}},
    {9381, 17, 31041, {1, 3, 3, 9, 9, 13, 77, 39, 241, 887, 601, 3861, 5967, 15635, 18679, 52783, 101859}},
    {9382, 17, 31042, {1, 1, 5, 9, 13, 27, 69, 111, 311, 25, 799, 2385, 5341, 8277, 26857, 13933, 59193}},
    {9383, 17, 31044, {1, 1, 7, 1, 1, 31, 117, 109, 7, 951, 219, 747, 5979, 10997, 12241, 64647, 61799}},
    {9384, 17, 31053, {1, 1, 7, 13, 31, 41, 43, 53, 495, 233, 209, 485, 3787, 1375, 13753, 33731, 7455}},
    {9385, 17, 31059, {1, 3, 3, 13, 9, 11, 41, 71, 413, 671, 1475, 875, 4299, 1725, 15875, 991, 94937}},
    {9386, 17, 31062, {1, 3, 3, 11, 25, 13, 45, 211, 485, 235, 1387, 727, 2975, 13081, 11081, 53515, 47577}},
    {9387, 17, 31077, {1, 3, 3, 13, 21, 23, 1, 29, 381, 197, 1797, 1761, 6493, 6183, 19485, 9575, 51243}},
    {9388, 17, 31095, {1, 1, 3, 3, 13, 59, 77, 241, 331, 723, 1577, 2295, 3155, 7215, 4999, 53841, 2531}},
    {9389, 17, 31101, {1, 1, 1, 13, 9, 27, 33, 253, 359, 173, 1675, 3409, 1803, 4281, 25069, 32649, 50579}},
    {9390, 17, 31105, {1, 3, 7, 9, 3, 1, 81, 79, 373, 233, 1397, 2053, 4741, 14613, 23517, 1437, 42723}},
    {9391, 17, 31118, {1, 1, 1, 11, 7, 63, 61, 33, 33, 855, 1483, 1955, 7655, 11753, 7175, 16259, 116909}},
    {9392, 17, 31129, {1, 3, 7, 9, 11, 31, 29, 161, 207, 825, 693, 1339, 4969, 5321, 26095, 6117, 71293}},
    {9393, 17, 31132, {1, 3, 1, 9, 31, 23, 7, 7, 377, 957, 2037, 1895, 4471, 899, 10133, 6525, 109849}},
    {9394, 17, 31141, {1, 3, 3, 7, 17, 59, 51, 47, 353, 395, 1783, 4033, 4775, 623, 16777, 5509, 34349}},
    {9395, 17, 31159, {1, 1, 3, 11, 19, 15, 97, 181, 283, 417, 2029, 3995, 6405, 16045, 22835, 37967, 127237}},
    {9396, 17, 31183, {1, 3, 7, 11, 7, 21, 63, 143, 137, 541, 1455, 209, 6355, 6505, 30545, 25363, 95565}},
    {9397, 17, 31185, {1, 1, 5, 13, 21, 39, 81, 145, 267, 491, 701, 3197, 1157, 6509, 19671, 56239, 1023}},
    {9398, 17, 31195, {1, 1, 1, 3, 1, 35, 35, 149, 449, 979, 1957, 255, 7917, 14437, 291, 32507, 118457}},
    {9399, 17, 31202, {1, 1, 3, 7, 7, 57, 45, 235, 249, 389, 1421, 3283, 4191, 8745, 7581, 10197, 14659}},
    {9400, 17, 31213, {1, 3, 1, 5, 15, 41, 127, 141, 357, 77, 1321, 701, 815, 9837, 27109, 3999, 88715}},
    {9401, 17, 31238, {1, 1, 5, 7, 13, 11, 13, 13, 443, 581, 391, 401, 4329, 2171, 10547, 27001, 87739}},
    {9402, 17, 31241, {1, 3, 3, 9, 31, 23, 65, 111, 161, 11, 325, 1863, 6599, 9145, 10191, 43399, 58637}},
    {9403, 17, 31252, {1, 3, 1, 15, 7, 3, 41, 181, 473, 401, 191, 1207, 177, 13025, 12283, 45879, 129407}},
    {9404, 17, 31262, {1, 3, 7, 9, 23, 49, 95, 125, 103, 261, 1151, 667, 2613, 10879, 10387, 23747, 107887}},
    {9405, 17, 31265, {1, 1, 5, 13, 21, 25, 21, 105, 295, 403, 1009, 3225, 5613, 14781, 15523, 39201, 10897}},
    {9406, 17, 31295, {1, 3, 1, 3, 5, 21, 61, 251, 459, 293, 399, 2065, 7919, 2923, 4623, 54929, 42177}},
    {9407, 17, 31300, {1, 3, 3, 9, 3, 19, 87, 163, 485, 861, 1503, 1521, 7489, 4725, 5721, 36739, 76275}},
    {9408, 17, 31303, {1, 1, 5, 11, 19, 47, 115, 73, 213, 87, 1173, 2685, 2001, 12791, 4183, 59715, 86887}},
    {9409, 17, 31317, {1, 3, 5, 11, 17, 33, 73, 173, 267, 759, 1641, 587, 1659, 1543, 11583, 22881, 13213}},
    {9410, 17, 31318, {1, 1, 1, 1, 27, 19, 107, 131, 339, 737, 979, 1007, 7367, 15973, 14599, 24347, 5875}},
    {9411, 17, 31324, {1, 3, 5, 7, 25, 45, 119, 243, 91, 769, 1857, 4053, 7057, 5909, 10915, 48093, 7995}},
    {9412, 17, 31338, {1, 3, 3, 11, 23, 37, 1, 147, 207, 407, 1519, 1991, 1279, 3817, 29839, 30017, 113067}},
    {9413, 17, 31340, {1, 1, 1, 9, 29, 13, 59, 241, 65, 425, 1093, 441, 3275, 10655, 887, 5045, 9043}},
    {9414, 17, 31345, {1, 1, 7, 9, 15, 17, 35, 155, 459, 161, 817, 867, 513, 10915, 1231, 7369, 84865}},
    {9415, 17, 31355, {1, 3, 5, 13, 13, 9, 37, 209, 117, 49, 973, 2547, 2035, 7595, 15029, 9035, 83281}},
    {9416, 17, 31362, {1, 3, 5, 15, 25, 39, 41, 187, 321, 979, 419, 445, 979, 4543, 13833, 60347, 19925}},
    {9417, 17, 31371, {1, 3, 7, 15, 25, 21, 59, 27, 251, 747, 1471, 265, 5783, 9823, 1515, 32409, 95999}},
    {9418, 17, 31373, {1, 1, 1, 3, 19, 31, 31, 61, 193, 497, 23, 2473, 9, 14459, 28335, 45725, 67051}},
    {9419, 17, 31381, {1, 1, 3, 3, 1, 19, 93, 231, 69, 459, 1759, 2821, 4771, 15721, 22751, 65137, 114107}},
    {9420, 17, 31391, {1, 3, 7, 9, 1, 31, 63, 149, 137, 999, 1521, 371, 3541, 5587, 29963, 22217, 92813}},
    {9421, 17, 31409, {1, 3, 1, 15, 21, 59, 65, 139, 297, 569, 895, 877, 7023, 14705, 22977, 58921, 29879}},
    {9422, 17, 31410, {1, 3, 1, 9, 21, 5, 77, 171, 197, 677, 1571, 3925, 4917, 14415, 20137, 39871, 125939}},
    {9423, 17, 31412, {1, 3, 7, 15, 17, 15, 1, 189, 13, 531, 1571, 2457, 1253, 13955, 18113, 60799, 40147}},
    {9424, 17, 31434, {1, 3, 5, 7, 15, 9, 71, 19, 79, 613, 107, 149, 5417, 3379, 15677, 41013, 90867}},
    {9425, 17, 31458, {1, 1, 1, 13, 29, 61, 15, 21, 1, 829, 1427, 3741, 4595, 12027, 25303, 64589, 101855}},
    {9426, 17, 31467, {1, 1, 1, 7, 11, 39, 127, 155, 275, 419, 477, 621, 2163, 13083, 17367, 54783, 102969}},
    {9427, 17, 31470, {1, 3, 7, 13, 25, 51, 23, 19, 127, 469, 1341, 1665, 3377, 3197, 2051, 8617, 53683}},
    {9428, 17, 31475, {1, 3, 5, 15, 21, 61, 83, 179, 461, 943, 597, 1303, 6217, 7299, 32759, 46133, 108055}},
    {9429, 17, 31481, {1, 1, 1, 7, 13, 27, 3, 149, 491, 95, 1977, 1657, 6621, 7919, 20605, 32627, 11515}},
    {9430, 17, 31482, {1, 3, 5, 1, 3, 19, 115, 117, 103, 207, 663, 2161, 6327, 7507, 15025, 63281, 53153}},
    {9431, 17, 31484, {1, 1, 7, 1, 9, 47, 1, 131, 295, 223, 1721, 1657, 6647, 995, 11509, 56949, 69567}},
    {9432, 17, 31492, {1, 3, 7, 15, 11, 61, 121, 247, 265, 507, 769, 2025, 1415, 143, 23945, 12459, 89415}},
    {9433, 17, 31507, {1, 3, 7, 13, 5, 49, 61, 123, 443, 769, 1669, 2741, 6881, 5965, 9365, 43051, 2979}},
    {9434, 17, 31514, {1, 1, 7, 7, 1, 25, 83, 241, 295, 869, 1371, 623, 5757, 14505, 27291, 23807, 95819}},
    {9435, 17, 31538, {1, 1, 5, 7, 27, 45, 59, 109, 505, 371, 1527, 887, 6983, 8587, 691, 22417, 6273}},
    {9436, 17, 31547, {1, 3, 3, 1, 9, 53, 39, 45, 495, 493, 1599, 3097, 933, 6395, 3279, 58463, 104451}},
    {9437, 17, 31549, {1, 1, 1, 1, 1, 13, 19, 143, 141, 709, 1515, 561, 3817, 6085, 19331, 11649, 127487}},
    {9438, 17, 31555, {1, 3, 3, 5, 21, 45, 79, 19, 43, 451, 1025, 781, 3475, 3741, 30451, 52627, 110005}},
    {9439, 17, 31557, {1, 3, 7, 11, 23, 47, 103, 3, 397, 833, 1355, 1635, 967, 4657, 19821, 31137, 124359}},
    {9440, 17, 31597, {1, 1, 3, 1, 13, 7, 7, 43, 483, 853, 1883, 1365, 6335, 2403, 2507, 29267, 113753}},
    {9441, 17, 31598, {1, 1, 1, 9, 15, 7, 11, 203, 357, 271, 1945, 3581, 3613, 2381, 16099, 62013, 38223}},
    {9442, 17, 31610, {1, 1, 7, 3, 19, 59, 77, 49, 359, 513, 1889, 2125, 4973, 9845, 25133, 42429, 82207}},
    {9443, 17, 31625, {1, 3, 5, 3, 11, 43, 37, 25, 113, 305, 65, 4083, 321, 15615, 17865, 21507, 96835}},
    {9444, 17, 31634, {1, 1, 1, 11, 19, 45, 83, 5, 303, 253, 1935, 535, 193, 6631, 26993, 31727, 109397}},
    {9445, 17, 31643, {1, 1, 7, 3, 19, 27, 51, 37, 185, 485, 123, 73, 5089, 15243, 28725, 64785, 127317}},
    {9446, 17, 31645, {1, 3, 1, 13, 27, 5, 121, 205, 419, 419, 353, 1291, 3301, 7093, 917, 34597, 33721}},
    {9447, 17, 31659, {1, 3, 5, 15, 31, 5, 71, 21, 217, 817, 1973, 4025, 7795, 12247, 5517, 19457, 129867}},
    {9448, 17, 31669, {1, 3, 7, 3, 13, 49, 77, 99, 347, 1019, 1811, 393, 3689, 5585, 23149, 46693, 81095}},
    {9449, 17, 31670, {1, 1, 1, 13, 19, 1, 101, 153, 23, 919, 1535, 3565, 7847, 8369, 25553, 35709, 11733}},
    {9450, 17, 31682, {1, 3, 5, 3, 13, 55, 23, 53, 133, 985, 1051, 1891, 3447, 3173, 3849, 10167, 19889}},
    {9451, 17, 31694, {1, 1, 3, 1, 5, 17, 61, 109, 473, 747, 355, 2251, 6529, 3039, 16285, 57781, 102625}},
    {9452, 17, 31717, {1, 3, 7, 5, 15, 47, 117, 205, 209, 217, 1911, 3023, 1109, 13131, 20109, 25685, 129131}},
    {9453, 17, 31718, {1, 1, 1, 9, 3, 53, 77, 245, 505, 27, 1497, 2577, 8121, 11191, 1283, 55921, 38957}},
    {9454, 17, 31729, {1, 3, 7, 11, 27, 37, 9, 21, 229, 697, 119, 2029, 6165, 9913, 15943, 27019, 90243}},
    {9455, 17, 31736, {1, 1, 1, 15, 23, 55, 83, 223, 301, 403, 977, 3553, 3319, 351, 14793, 52989, 75427}},
    {9456, 17, 31742, {1, 1, 1, 13, 11, 39, 125, 91, 241, 279, 77, 3833, 4211, 8793, 22303, 59947, 114821}},
    {9457, 17, 31749, {1, 3, 3, 13, 19, 1, 55, 91, 211, 543, 1687, 2801, 3473, 4587, 14447, 23227, 21147}},
    {9458, 17, 31773, {1, 3, 1, 7, 15, 51, 1, 157, 387, 829, 1883, 317, 7529, 97, 4963, 43029, 20741}},
    {9459, 17, 31777, {1, 3, 5, 5, 31, 29, 117, 193, 253, 193, 1667, 3051, 4751, 2307, 32761, 52539, 32331}},
    {9460, 17, 31778, {1, 1, 5, 3, 31, 33, 117, 115, 311, 41, 863, 1211, 4661, 7569, 2107, 56899, 40411}},
    {9461, 17, 31784, {1, 3, 3, 13, 3, 25, 101, 61, 267, 523, 1355, 1991, 8113, 4467, 2285, 58123, 94261}},
    {9462, 17, 31801, {1, 3, 3, 11, 7, 55, 103, 81, 231, 503, 1579, 1643, 6421, 10511, 9019, 57853, 2841}},
    {9463, 17, 31812, {1, 1, 1, 5, 5, 51, 119, 1, 481, 283, 649, 2847, 5645, 747, 27481, 7123, 26321}},
    {9464, 17, 31821, {1, 1, 5, 15, 27, 9, 113, 141, 503, 215, 1299, 2591, 3101, 13713, 13627, 57557, 50149}},
    {9465, 17, 31822, {1, 1, 7, 13, 27, 19, 21, 59, 123, 549, 1769, 431, 7773, 5273, 2761, 9013, 58483}},
    {9466, 17, 31836, {1, 1, 5, 3, 21, 21, 115, 21, 459, 91, 1597, 2483, 2853, 7709, 8381, 62841, 73403}},
    {9467, 17, 31850, {1, 1, 3, 13, 31, 37, 37, 63, 187, 493, 861, 1691, 1265, 4145, 20875, 56517, 46147}},
    {9468, 17, 31855, {1, 1, 5, 9, 23, 3, 11, 111, 265, 33, 585, 2759, 3031, 11979, 2117, 34799, 42723}},
    {9469, 17, 31858, {1, 3, 7, 1, 7, 43, 13, 9, 479, 197, 1923, 3549, 6909, 12629, 26597, 9545, 55285}},
    {9470, 17, 31860, {1, 1, 3, 5, 7, 13, 11, 237, 149, 957, 869, 3697, 7, 1161, 12105, 62641, 122841}},
    {9471, 17, 31886, {1, 1, 7, 1, 13, 17, 15, 135, 143, 319, 605, 2509, 1969, 6165, 14139, 19059, 111175}},
    {9472, 17, 31891, {1, 3, 3, 9, 13, 39, 5, 53, 427, 631, 1027, 3065, 6005, 7075, 20815, 15231, 84959}},
    {9473, 17, 31909, {1, 1, 1, 1, 29, 53, 47, 133, 363, 445, 1885, 3171, 629, 16027, 26731, 25065, 45735}},
    {9474, 17, 31928, {1, 3, 3, 7, 31, 7, 27, 37, 227, 513, 1207, 549, 7773, 7385, 17533, 61241, 113131}},
    {9475, 17, 31931, {1, 1, 5, 3, 23, 35, 23, 69, 353, 47, 1643, 623, 449, 1265, 10483, 55355, 38041}},
    {9476, 17, 31934, {1, 3, 5, 1, 21, 15, 1, 83, 485, 761, 2037, 2473, 7157, 10743, 24253, 10795, 34791}},
    {9477, 17, 31941, {1, 1, 7, 7, 3, 17, 79, 167, 263, 199, 335, 967, 229, 15309, 22869, 46797, 92191}},
    {9478, 17, 31942, {1, 1, 3, 7, 13, 43, 13, 25, 187, 265, 513, 1667, 6641, 9135, 20213, 30327, 16529}},
    {9479, 17, 31945, {1, 1, 1, 11, 21, 13, 49, 155, 89, 349, 729, 1025, 205, 3641, 31201, 53799, 94331}},
    {9480, 17, 31951, {1, 3, 3, 15, 17, 43, 33, 235, 115, 769, 1291, 1359, 3303, 7955, 22397, 23403, 50561}},
    {9481, 17, 31959, {1, 3, 1, 9, 25, 57, 67, 205, 119, 245, 463, 3503, 2211, 3471, 21049, 65533, 74645}},
    {9482, 17, 31963, {1, 1, 5, 1, 15, 47, 69, 73, 111, 605, 1289, 871, 5047, 1223, 117, 9443, 114399}},
    {9483, 17, 31970, {1, 3, 3, 3, 19, 17, 105, 39, 275, 469, 371, 687, 2303, 5089, 2423, 15105, 106031}},
    {9484, 17, 31984, {1, 1, 1, 3, 15, 49, 31, 73, 177, 425, 1423, 83, 4487, 11299, 995, 39927, 15383}},
    {9485, 17, 31987, {1, 3, 5, 9, 9, 47, 59, 103, 319, 751, 1063, 2373, 7209, 7521, 21249, 4347, 11969}},
    {9486, 17, 31990, {1, 3, 3, 15, 19, 25, 75, 233, 85, 913, 261, 797, 7381, 3989, 32577, 13703, 8973}},
    {9487, 17, 32001, {1, 3, 3, 15, 27, 45, 109, 151, 363, 723, 847, 777, 5883, 11147, 7803, 28485, 5845}},
    {9488, 17, 32007, {1, 3, 1, 7, 27, 63, 113, 141, 239, 201, 1171, 1447, 6371, 6491, 29481, 11109, 119539}},
    {9489, 17, 32008, {1, 1, 1, 9, 1, 57, 41, 27, 445, 243, 1135, 1385, 5755, 7297, 11833, 28733, 65911}},
    {9490, 17, 32025, {1, 3, 7, 1, 21, 55, 61, 109, 129, 601, 557, 1313, 7813, 3023, 4599, 45809, 65885}},
    {9491, 17, 32035, {1, 3, 1, 9, 5, 41, 25, 223, 221, 635, 1613, 2985, 2251, 12095, 10275, 14349, 1943}},
    {9492, 17, 32038, {1, 1, 5, 9, 3, 57, 41, 143, 293, 697, 1217, 689, 1515, 7325, 22899, 50807, 89707}},
    {9493, 17, 32047, {1, 1, 3, 11, 1, 9, 63, 245, 425, 303, 1257, 4007, 1983, 4153, 21295, 36799, 89285}},
    {9494, 17, 32049, {1, 3, 5, 1, 27, 17, 71, 97, 413, 733, 1067, 3403, 3423, 9433, 22955, 27757, 29811}},
    {9495, 17, 32062, {1, 3, 3, 9, 5, 31, 3, 23, 315, 517, 131, 2539, 4309, 16319, 10523, 29993, 101985}},
    {9496, 17, 32067, {1, 1, 3, 5, 25, 29, 15, 161, 19, 735, 1887, 343, 4061, 4299, 13309, 36315, 78943}},
    {9497, 17, 32070, {1, 1, 1, 1, 7, 25, 121, 201, 77, 521, 253, 465, 4773, 1235, 7445, 32263, 94221}},
    {9498, 17, 32073, {1, 3, 5, 5, 1, 49, 19, 61, 121, 1007, 1979, 3113, 7853, 3667, 13487, 35035, 76687}},
    {9499, 17, 32074, {1, 3, 3, 13, 29, 19, 61, 75, 125, 377, 1265, 913, 3655, 11669, 8669, 60305, 49305}},
    {9500, 17, 32079, {1, 1, 7, 9, 29, 41, 79, 157, 215, 919, 897, 467, 6211, 13929, 20489, 42525, 108695}},
    {9501, 17, 32081, {1, 3, 1, 1, 23, 41, 89, 83, 431, 865, 1059, 3777, 2809, 9267, 25285, 46249, 17681}},
    {9502, 17, 32082, {1, 3, 1, 15, 1, 21, 5, 87, 29, 1023, 345, 375, 117, 8723, 31905, 251, 38555}},
    {9503, 17, 32107, {1, 1, 3, 9, 27, 63, 69, 121, 205, 569, 167, 3013, 2877, 9355, 6545, 9373, 63611}},
    {9504, 17, 32127, {1, 3, 1, 5, 17, 1, 125, 183, 421, 993, 307, 2903, 4019, 12713, 19477, 747, 70605}},
    {9505, 17, 32145, {1, 3, 1, 1, 9, 7, 33, 119, 175, 583, 681, 2623, 5821, 197, 12873, 39223, 53969}},
    {9506, 17, 32151, {1, 3, 1, 11, 25, 47, 53, 155, 125, 7, 1299, 453, 6351, 6697, 23849, 64517, 79913}},
    {9507, 17, 32152, {1, 3, 7, 3, 27, 51, 123, 1, 429, 121, 769, 3503, 807, 15817, 9581, 41497, 96829}},
    {9508, 17, 32173, {1, 1, 3, 3, 29, 9, 39, 25, 149, 291, 1623, 3749, 2619, 1215, 14829, 35777, 50397}},
    {9509, 17, 32174, {1, 3, 3, 9, 25, 57, 73, 217, 281, 353, 595, 555, 673, 2805, 27697, 40259, 98525}},
    {9510, 17, 32186, {1, 3, 5, 3, 27, 19, 97, 163, 413, 223, 741, 2287, 5871, 521, 21879, 39271, 9479}},
    {9511, 17, 32194, {1, 3, 7, 11, 21, 57, 101, 159, 423, 7, 991, 111, 3359, 3689, 11537, 56637, 27075}},
    {9512, 17, 32196, {1, 3, 7, 9, 27, 7, 105, 189, 289, 569, 557, 1503, 8073, 7289, 8405, 17919, 85319}},
    {9513, 17, 32200, {1, 3, 1, 3, 13, 3, 19, 225, 299, 163, 1693, 1585, 5547, 9565, 26835, 55329, 6377}},
    {9514, 17, 32208, {1, 1, 7, 13, 11, 25, 27, 85, 159, 65, 557, 3915, 7431, 8185, 31683, 32947, 59005}},
    {9515, 17, 32218, {1, 1, 3, 15, 15, 23, 13, 137, 425, 251, 701, 791, 2949, 14559, 11011, 12249, 103251}},
    {9516, 17, 32236, {1, 3, 1, 15, 9, 63, 51, 251, 59, 41, 737, 4047, 1439, 15717, 26107, 18435, 9625}},
    {9517, 17, 32260, {1, 3, 1, 9, 23, 39, 73, 137, 317, 149, 1311, 2451, 4615, 9491, 13843, 54249, 67283}},
    {9518, 17, 32263, {1, 3, 3, 11, 15, 33, 65, 15, 125, 833, 115, 3953, 845, 15127, 15899, 22847, 44629}},
    {9519, 17, 32288, {1, 1, 5, 11, 29, 43, 45, 17, 171, 193, 1005, 2151, 5561, 1143, 14601, 43271, 73143}},
    {9520, 17, 32298, {1, 3, 5, 11, 21, 63, 113, 143, 95, 991, 765, 2549, 995, 4069, 16333, 54495, 19}},
    {9521, 17, 32315, {1, 1, 1, 5, 17, 35, 19, 55, 355, 645, 1205, 2047, 7691, 16369, 29197, 29513, 82729}},
    {9522, 17, 32332, {1, 1, 5, 11, 17, 63, 47, 219, 243, 799, 95, 2463, 1091, 15059, 21015, 39755, 39985}},
    {9523, 17, 32340, {1, 3, 3, 13, 23, 11, 127, 85, 193, 517, 1737, 2293, 5647, 8079, 4805, 63325, 29439}},
    {9524, 17, 32354, {1, 1, 1, 15, 21, 55, 71, 23, 11, 917, 973, 1355, 3935, 203, 8321, 47747, 7753}},
    {9525, 17, 32359, {1, 3, 1, 5, 1, 55, 71, 117, 221, 619, 229, 2925, 4775, 7315, 22367, 30951, 45247}},
    {9526, 17, 32366, {1, 3, 5, 3, 5, 33, 57, 25, 209, 777, 365, 2271, 4029, 5499, 15179, 14305, 74783}},
    {9527, 17, 32368, {1, 3, 7, 7, 21, 51, 73, 177, 349, 515, 1731, 883, 7891, 13841, 25075, 32001, 122725}},
    {9528, 17, 32377, {1, 1, 1, 15, 17, 43, 3, 61, 335, 677, 1437, 2673, 4117, 13719, 22833, 31955, 81407}},
    {9529, 17, 32384, {1, 1, 3, 15, 15, 33, 99, 81, 123, 887, 477, 1771, 1669, 12409, 10009, 17223, 5651}},
    {9530, 17, 32399, {1, 3, 7, 11, 1, 3, 49, 205, 269, 805, 1625, 1253, 1549, 511, 24185, 15063, 96271}},
    {9531, 17, 32417, {1, 3, 7, 1, 3, 63, 117, 85, 271, 49, 2017, 1311, 201, 10607, 29139, 16799, 83325}},
    {9532, 17, 32424, {1, 3, 7, 11, 3, 63, 113, 225, 453, 199, 793, 135, 2841, 167, 12835, 36273, 22321}},
    {9533, 17, 32427, {1, 1, 1, 9, 29, 9, 99, 129, 443, 257, 1099, 2719, 5091, 12313, 7241, 50363, 43345}},
    {9534, 17, 32429, {1, 1, 5, 7, 31, 47, 127, 241, 43, 821, 1811, 3949, 721, 1985, 9977, 44051, 37031}},
    {9535, 17, 32438, {1, 3, 1, 13, 13, 25, 17, 9, 413, 521, 675, 515, 1523, 5127, 7561, 27843, 106183}},
    {9536, 17, 32442, {1, 3, 5, 5, 1, 21, 113, 121, 485, 541, 689, 3291, 7499, 12439, 5551, 29841, 94371}},
    {9537, 17, 32447, {1, 1, 1, 3, 11, 45, 57, 87, 383, 65, 1191, 4003, 2967, 9819, 20785, 20961, 46383}},
    {9538, 17, 32469, {1, 1, 3, 1, 11, 25, 11, 151, 111, 607, 985, 3505, 1593, 6133, 31859, 55443, 59147}},
    {9539, 17, 32479, {1, 1, 5, 9, 7, 21, 123, 247, 491, 261, 617, 907, 4331, 2523, 27139, 23539, 103209}},
    {9540, 17, 32483, {1, 1, 7, 3, 5, 41, 11, 129, 297, 453, 1755, 153, 6295, 5723, 30049, 4763, 110683}},
    {9541, 17, 32498, {1, 1, 3, 13, 23, 23, 93, 1, 461, 631, 1509, 2991, 1947, 2723, 4909, 38221, 74565}},
    {9542, 17, 32503, {1, 1, 5, 11, 7, 21, 59, 51, 347, 977, 1975, 3593, 4217, 907, 8355, 59881, 72479}},
    {9543, 17, 32507, {1, 3, 5, 1, 7, 13, 51, 203, 59, 283, 1317, 1431, 363, 9587, 26305, 5393, 2497}},
    {9544, 17, 32521, {1, 1, 7, 15, 17, 47, 59, 157, 455, 531, 1991, 2823, 4731, 3149, 22705, 60993, 70547}},
    {9545, 17, 32532, {1, 3, 1, 3, 31, 5, 63, 35, 221, 653, 631, 2339, 4031, 11693, 29595, 24713, 121787}},
    {9546, 17, 32539, {1, 1, 5, 9, 11, 41, 89, 131, 431, 113, 1367, 1087, 3859, 6945, 18743, 63243, 1655}},
    {9547, 17, 32551, {1, 3, 3, 7, 27, 17, 25, 161, 57, 697, 1263, 327, 3665, 3463, 1175, 19311, 78097}},
    {9548, 17, 32572, {1, 1, 5, 5, 7, 53, 101, 35, 391, 943, 1189, 2877, 4981, 10351, 27643, 12525, 83175}},
    {9549, 17, 32577, {1, 1, 1, 11, 23, 35, 49, 243, 353, 789, 1331, 1211, 1961, 2327, 19499, 43291, 74069}},
    {9550, 17, 32578, {1, 1, 1, 15, 29, 33, 67, 171, 109, 519, 197, 3693, 479, 13655, 17719, 20073, 18425}},
    {9551, 17, 32587, {1, 3, 7, 5, 15, 49, 79, 101, 443, 665, 1699, 2053, 3819, 11485, 5667, 40051, 23197}},
    {9552, 17, 32592, {1, 3, 3, 1, 13, 3, 15, 173, 89, 901, 677, 3375, 7799, 3575, 28787, 10029, 103049}},
    {9553, 17, 32602, {1, 3, 1, 3, 23, 53, 55, 9, 415, 927, 1161, 3379, 1343, 14803, 3561, 11095, 24013}},
    {9554, 17, 32604, {1, 3, 3, 9, 25, 25, 125, 65, 111, 103, 1223, 2413, 4117, 14037, 427, 14423, 27357}},
    {9555, 17, 32613, {1, 1, 1, 1, 9, 21, 87, 235, 103, 59, 1721, 491, 7409, 9613, 4293, 54763, 12163}},
    {9556, 17, 32625, {1, 1, 3, 15, 17, 25, 43, 21, 5, 1005, 793, 1261, 4235, 6583, 8049, 27029, 1709}},
    {9557, 17, 32631, {1, 3, 5, 5, 9, 39, 47, 123, 467, 603, 1209, 3389, 359, 2513, 11269, 56759, 49481}},
    {9558, 17, 32641, {1, 3, 3, 5, 19, 35, 95, 123, 63, 841, 923, 1513, 2583, 6017, 4767, 751, 39967}},
    {9559, 17, 32642, {1, 1, 1, 7, 23, 49, 1, 187, 429, 127, 1469, 45, 5415, 15345, 6695, 30703, 1761}},
    {9560, 17, 32644, {1, 1, 3, 1, 13, 53, 93, 9, 451, 809, 1101, 4017, 3031, 681, 15487, 53789, 81289}},
    {9561, 17, 32656, {1, 1, 7, 11, 23, 55, 67, 93, 175, 411, 757, 3281, 2307, 3755, 27335, 19883, 68055}},
    {9562, 17, 32678, {1, 3, 3, 5, 15, 39, 37, 155, 263, 847, 743, 3241, 2077, 9035, 4613, 11685, 47737}},
    {9563, 17, 32681, {1, 1, 3, 7, 11, 19, 39, 163, 469, 365, 261, 2715, 375, 10921, 20289, 5727, 100907}},
    {9564, 17, 32701, {1, 3, 5, 7, 29, 55, 7, 199, 179, 485, 519, 3861, 7179, 6605, 7897, 46009, 95027}},
    {9565, 17, 32713, {1, 1, 3, 5, 13, 61, 35, 243, 189, 1007, 1845, 2327, 7525, 7023, 24835, 26343, 30903}},
    {9566, 17, 32721, {1, 1, 5, 7, 31, 61, 1, 37, 421, 231, 755, 271, 293, 4491, 6701, 15025, 74755}},
    {9567, 17, 32727, {1, 1, 5, 3, 5, 41, 59, 81, 245, 531, 2039, 3077, 2401, 9881, 4749, 12219, 72287}},
    {9568, 17, 32731, {1, 1, 3, 9, 11, 43, 79, 45, 261, 119, 1371, 3473, 5111, 15379, 31947, 23441, 41501}},
    {9569, 17, 32734, {1, 3, 5, 11, 23, 39, 79, 15, 459, 647, 407, 2581, 4435, 10195, 23011, 3393, 99363}},
    {9570, 17, 32740, {1, 1, 3, 9, 13, 23, 39, 81, 385, 921, 1091, 1123, 115, 12465, 5287, 63923, 30283}},
    {9571, 17, 32773, {1, 1, 5, 15, 17, 27, 57, 135, 509, 383, 1637, 1423, 371, 14961, 14053, 18793, 58641}},
    {9572, 17, 32774, {1, 3, 5, 15, 11, 25, 121, 127, 411, 251, 1903, 2609, 2571, 14829, 25731, 30237, 46857}},
    {9573, 17, 32785, {1, 1, 7, 7, 23, 63, 99, 57, 259, 523, 1431, 1479, 6751, 12541, 31129, 14525, 103255}},
    {9574, 17, 32788, {1, 1, 7, 1, 3, 19, 13, 153, 229, 79, 871, 4053, 7847, 313, 19541, 55727, 111737}},
    {9575, 17, 32792, {1, 3, 7, 15, 15, 39, 11, 125, 383, 277, 687, 3273, 105, 8741, 6057, 19709, 65241}},
    {9576, 17, 32797, {1, 3, 3, 1, 1, 3, 87, 77, 361, 529, 621, 763, 6949, 15701, 8631, 56821, 53161}},
    {9577, 17, 32801, {1, 1, 7, 3, 31, 45, 61, 177, 259, 991, 1811, 991, 8151, 15763, 8193, 61665, 59641}},
    {9578, 17, 32811, {1, 3, 1, 1, 25, 41, 23, 165, 411, 941, 2045, 3321, 3307, 10095, 2807, 30331, 91141}},
    {9579, 17, 32821, {1, 1, 3, 5, 7, 31, 39, 145, 403, 967, 1511, 2557, 4907, 563, 20725, 52305, 24125}},
    {9580, 17, 32828, {1, 1, 3, 9, 13, 29, 55, 189, 161, 335, 1539, 3459, 1507, 15249, 16277, 25673, 83707}},
    {9581, 17, 32839, {1, 3, 7, 15, 1, 7, 119, 79, 255, 819, 457, 2755, 7173, 13011, 28071, 7089, 121839}},
    {9582, 17, 32854, {1, 1, 7, 9, 15, 47, 99, 233, 469, 525, 329, 1193, 6659, 14861, 7815, 58793, 40477}},
    {9583, 17, 32867, {1, 3, 5, 15, 19, 49, 7, 153, 235, 955, 1943, 3773, 2795, 1153, 13595, 26063, 115229}},
    {9584, 17, 32870, {1, 1, 7, 3, 17, 39, 5, 235, 389, 535, 1671, 3283, 4165, 4207, 21387, 3275, 5737}},
    {9585, 17, 32873, {1, 1, 1, 3, 9, 27, 23, 249, 127, 291, 491, 3589, 5961, 7019, 27051, 41701, 85967}},
    {9586, 17, 32881, {1, 3, 1, 7, 29, 13, 21, 73, 453, 537, 1583, 4081, 4195, 305, 27361, 669, 112041}},
    {9587, 17, 32891, {1, 1, 5, 5, 25, 43, 117, 217, 35, 781, 935, 3841, 7417, 8791, 159, 46383, 76177}},
    {9588, 17, 32900, {1, 1, 3, 1, 3, 61, 7, 5, 367, 413, 1393, 3841, 3771, 10127, 28005, 5353, 33949}},
    {9589, 17, 32903, {1, 1, 7, 3, 21, 43, 17, 211, 113, 73, 469, 2663, 2527, 2945, 28917, 56037, 109237}},
    {9590, 17, 32910, {1, 1, 7, 13, 27, 17, 9, 169, 175, 341, 491, 619, 7337, 5801, 21489, 56301, 16155}},
    {9591, 17, 32917, {1, 3, 1, 7, 31, 15, 79, 13, 203, 451, 1235, 2497, 287, 7857, 7693, 63511, 66921}},
    {9592, 17, 32922, {1, 1, 7, 1, 31, 11, 79, 215, 39, 549, 1893, 1213, 4063, 16181, 31971, 25773, 103259}},
    {9593, 17, 32928, {1, 1, 1, 9, 15, 11, 117, 77, 21, 139, 1961, 517, 3093, 15603, 16923, 53073, 29313}},
    {9594, 17, 32945, {1, 3, 1, 11, 21, 23, 51, 11, 191, 155, 607, 225, 917, 11329, 11039, 44621, 72219}},
    {9595, 17, 32946, {1, 3, 7, 1, 11, 15, 21, 37, 89, 735, 255, 903, 6029, 7299, 6495, 42767, 6227}},
    {9596, 17, 32951, {1, 3, 5, 15, 1, 17, 81, 71, 373, 431, 107, 2849, 2799, 5665, 1359, 59129, 8945}},
    {9597, 17, 32958, {1, 1, 5, 13, 13, 55, 43, 207, 255, 925, 573, 3571, 789, 14621, 16305, 22409, 99299}},
    {9598, 17, 32965, {1, 3, 7, 1, 27, 59, 23, 157, 205, 985, 75, 1353, 2873, 4709, 21135, 55043, 120273}},
    {9599, 17, 32978, {1, 1, 1, 1, 3, 53, 109, 225, 265, 727, 395, 1425, 3371, 3997, 9389, 61403, 93541}},
    {9600, 17, 32980, {1, 1, 3, 11, 25, 23, 91, 169, 57, 893, 1701, 219, 2753, 4445, 30905, 51417, 6139}},
    {9601, 17, 32983, {1, 1, 5, 3, 19, 5, 83, 159, 159, 81, 1071, 663, 2857, 1949, 4777, 38211, 8423}},
    {9602, 17, 32987, {1, 1, 1, 13, 11, 13, 83, 99, 369, 283, 873, 1247, 6159, 15495, 21379, 3219, 100645}},
    {9603, 17, 33023, {1, 1, 7, 11, 31, 1, 35, 151, 257, 595, 529, 1183, 2679, 6001, 12117, 57201, 31603}},
    {9604, 17, 33031, {1, 1, 3, 13, 27, 23, 5, 43, 121, 961, 1883, 1119, 4359, 233, 3715, 34339, 102319}},
    {9605, 17, 33032, {1, 1, 7, 15, 3, 15, 59, 161, 251, 455, 37, 1479, 5803, 525, 16177, 50977, 114807}},
    {9606, 17, 33035, {1, 3, 5, 5, 23, 19, 3, 17, 283, 695, 623, 1719, 4651, 6351, 5343, 41733, 41479}},
    {9607, 17, 33038, {1, 3, 7, 1, 3, 5, 47, 183, 403, 191, 1633, 2869, 6807, 6613, 25225, 19199, 28409}},
    {9608, 17, 33040, {1, 3, 7, 9, 23, 49, 95, 125, 103, 261, 1151, 667, 2613, 10879, 10387, 23747, 107887}},
    {9609, 17, 33043, {1, 3, 3, 3, 17, 29, 81, 151, 377, 479, 2017, 1983, 6817, 10531, 11245, 63139, 8121}},
    {9610, 17, 33050, {1, 1, 1, 1, 27, 5, 97, 165, 41, 463, 155, 1175, 5813, 8883, 7927, 38841, 23599}},
    {9611, 17, 33059, {1, 1, 1, 13, 1, 17, 31, 117, 97, 659, 89, 1249, 305, 4807, 14505, 29775, 73547}},
    {9612, 17, 33080, {1, 3, 1, 7, 17, 19, 71, 167, 173, 221, 1281, 3939, 607, 8657, 16393, 36997, 83087}},
    {9613, 17, 33098, {1, 1, 7, 13, 7, 31, 107, 37, 243, 753, 1397, 3387, 851, 13789, 9179, 44921, 58333}},
    {9614, 17, 33108, {1, 1, 3, 11, 1, 25, 35, 239, 465, 425, 161, 2625, 8103, 967, 11267, 40289, 60373}},
    {9615, 17, 33115, {1, 1, 1, 15, 31, 25, 89, 215, 81, 1021, 1623, 221, 3531, 2125, 16581, 32807, 18349}},
    {9616, 17, 33117, {1, 3, 3, 11, 5, 37, 59, 247, 37, 1023, 435, 2589, 2029, 10189, 4997, 19781, 104055}},
    {9617, 17, 33133, {1, 1, 3, 3, 5, 45, 113, 155, 239, 823, 1193, 3401, 1589, 3025, 19083, 54921, 58205}},
    {9618, 17, 33134, {1, 3, 5, 7, 7, 59, 3, 13, 429, 443, 1667, 3373, 6999, 11645, 9449, 59209, 79359}},
    {9619, 17, 33157, {1, 1, 5, 13, 11, 63, 47, 175, 301, 7, 37, 2267, 7609, 7911, 28373, 7243, 126509}},
    {9620, 17, 33169, {1, 3, 3, 7, 9, 7, 39, 23, 67, 613, 1837, 1955, 2199, 5571, 14031, 44107, 37661}},
    {9621, 17, 33170, {1, 1, 3, 3, 7, 15, 27, 187, 127, 209, 1147, 2863, 5311, 6489, 7371, 25707, 21501}},
    {9622, 17, 33176, {1, 3, 1, 15, 5, 61, 49, 255, 487, 289, 447, 595, 1235, 10973, 28877, 8165, 6937}},
    {9623, 17, 33182, {1, 3, 3, 9, 1, 27, 63, 199, 145, 107, 1095, 2207, 4167, 1895, 11583, 26007, 12091}},
    {9624, 17, 33192, {1, 1, 1, 7, 19, 45, 71, 73, 413, 49, 623, 449, 6845, 11953, 5523, 1033, 52265}},
    {9625, 17, 33205, {1, 1, 7, 5, 7, 27, 91, 103, 215, 979, 1221, 461, 6255, 5009, 15077, 19201, 90039}},
    {9626, 17, 33212, {1, 1, 1, 9, 29, 35, 103, 233, 461, 471, 1065, 2393, 4873, 10103, 30245, 13085, 18653}},
    {9627, 17, 33215, {1, 3, 5, 5, 27, 11, 75, 77, 17, 925, 795, 2769, 1811, 13609, 28185, 3559, 25169}},
    {9628, 17, 33217, {1, 1, 3, 9, 29, 49, 117, 55, 71, 159, 1843, 2967, 359, 13143, 20691, 52793, 63901}},
    {9629, 17, 33227, {1, 1, 3, 11, 13, 49, 17, 73, 321, 785, 331, 1375, 2451, 12931, 20295, 43963, 78195}},
    {9630, 17, 33229, {1, 3, 7, 15, 17, 63, 11, 161, 21, 223, 607, 1901, 5049, 6465, 15675, 40049, 36411}},
    {9631, 17, 33238, {1, 3, 3, 15, 29, 43, 57, 11, 9, 355, 85, 459, 2271, 3081, 5509, 35891, 110513}},
    {9632, 17, 33241, {1, 3, 5, 13, 9, 15, 31, 127, 413, 255, 763, 721, 2165, 14575, 563, 12255, 44431}},
    {9633, 17, 33260, {1, 3, 3, 1, 1, 57, 19, 3, 303, 333, 285, 2543, 5977, 11091, 16797, 60499, 80563}},
    {9634, 17, 33271, {1, 1, 5, 5, 25, 57, 29, 125, 235, 175, 1185, 1423, 6851, 9149, 15979, 20601, 97393}},
    {9635, 17, 33278, {1, 3, 3, 11, 23, 3, 121, 81, 185, 65, 693, 1941, 671, 9551, 16681, 43811, 38373}},
    {9636, 17, 33293, {1, 1, 5, 5, 5, 25, 103, 33, 27, 415, 697, 3105, 5355, 11449, 14405, 9387, 1943}},
    {9637, 17, 33294, {1, 3, 3, 9, 19, 15, 27, 63, 423, 409, 957, 4073, 5771, 13023, 21043, 11635, 79863}},
    {9638, 17, 33296, {1, 1, 5, 5, 15, 13, 117, 195, 135, 993, 653, 2703, 2259, 997, 31661, 35531, 94763}},
    {9639, 17, 33302, {1, 1, 7, 11, 5, 47, 67, 239, 53, 661, 2039, 2125, 6483, 10741, 22639, 60729, 10121}},
    {9640, 17, 33305, {1, 1, 3, 3, 15, 23, 83, 217, 391, 759, 115, 1405, 491, 7089, 15595, 31147, 40787}},
    {9641, 17, 33329, {1, 1, 1, 11, 3, 13, 117, 49, 467, 793, 1513, 947, 283, 4019, 27089, 51839, 46067}},
    {9642, 17, 33330, {1, 1, 5, 3, 3, 43, 75, 161, 105, 139, 961, 3281, 3089, 16103, 6881, 32411, 30567}},
    {9643, 17, 33332, {1, 3, 3, 3, 23, 13, 89, 121, 419, 179, 1065, 171, 3703, 10651, 16525, 9209, 27053}},
    {9644, 17, 33354, {1, 3, 5, 7, 25, 41, 91, 113, 107, 845, 1337, 3055, 7947, 2563, 5447, 58277, 77869}},
    {9645, 17, 33383, {1, 1, 1, 1, 27, 39, 103, 179, 173, 137, 1417, 2073, 2101, 3611, 14751, 25247, 107829}},
    {9646, 17, 33387, {1, 3, 5, 11, 27, 1, 15, 39, 229, 353, 361, 3965, 1445, 10385, 20063, 18791, 77497}},
    {9647, 17, 33397, {1, 1, 3, 5, 31, 35, 121, 55, 21, 171, 1779, 2549, 4533, 13715, 4251, 52133, 28261}},
    {9648, 17, 33408, {1, 1, 7, 15, 11, 9, 11, 129, 391, 769, 1427, 2047, 1905, 2677, 28869, 26173, 41045}},
    {9649, 17, 33417, {1, 1, 7, 1, 21, 17, 23, 73, 487, 237, 1395, 4063, 5523, 4247, 15191, 4787, 126463}},
    {9650, 17, 33420, {1, 3, 7, 1, 7, 5, 45, 199, 509, 175, 1599, 3651, 6775, 6055, 18609, 35639, 123235}},
    {9651, 17, 33423, {1, 1, 3, 5, 3, 7, 39, 211, 331, 513, 1095, 3459, 1603, 10193, 1321, 56773, 92953}},
    {9652, 17, 33431, {1, 3, 3, 3, 11, 21, 19, 89, 287, 757, 2001, 1823, 1301, 5173, 2363, 51783, 116603}},
    {9653, 17, 33438, {1, 1, 7, 7, 31, 9, 101, 181, 319, 659, 721, 1669, 591, 13791, 22779, 8225, 106539}},
    {9654, 17, 33442, {1, 1, 3, 7, 1, 43, 25, 215, 65, 533, 1899, 3845, 6343, 15309, 391, 49793, 87165}},
    {9655, 17, 33444, {1, 1, 3, 11, 9, 19, 61, 125, 509, 935, 617, 1937, 3487, 2621, 16607, 60733, 41473}},
    {9656, 17, 33448, {1, 1, 3, 9, 19, 51, 107, 71, 467, 855, 9, 3833, 5325, 13361, 21753, 44573, 41601}},
    {9657, 17, 33456, {1, 1, 3, 1, 25, 53, 59, 133, 221, 717, 649, 945, 6251, 7963, 14025, 3573, 37481}},
    {9658, 17, 33459, {1, 1, 7, 9, 7, 45, 113, 179, 57, 581, 1419, 2057, 6655, 2955, 28519, 44939, 93351}},
    {9659, 17, 33466, {1, 1, 5, 9, 25, 15, 71, 237, 491, 889, 241, 13, 5207, 8847, 16495, 44041, 119267}},
    {9660, 17, 33473, {1, 3, 1, 1, 29, 39, 111, 73, 163, 963, 967, 297, 3651, 15683, 10945, 37019, 120523}},
    {9661, 17, 33476, {1, 3, 3, 5, 17, 17, 119, 105, 235, 895, 1429, 3375, 2503, 15563, 26701, 30687, 118009}},
    {9662, 17, 33491, {1, 3, 3, 3, 21, 55, 77, 117, 27, 655, 1367, 2489, 1463, 2091, 15669, 61259, 27765}},
    {9663, 17, 33494, {1, 3, 7, 13, 15, 3, 13, 35, 67, 767, 345, 2181, 1609, 12829, 14177, 5789, 109465}},
    {9664, 17, 33507, {1, 3, 1, 7, 17, 19, 59, 117, 63, 991, 1291, 579, 5487, 10967, 29071, 37179, 125223}},
    {9665, 17, 33514, {1, 1, 3, 1, 17, 63, 33, 145, 135, 627, 691, 1603, 4309, 10939, 939, 16823, 41703}},
    {9666, 17, 33521, {1, 1, 3, 9, 25, 35, 31, 45, 135, 681, 1213, 2235, 907, 6589, 18011, 5485, 451}},
    {9667, 17, 33528, {1, 1, 3, 11, 7, 61, 93, 39, 127, 531, 381, 527, 1821, 10137, 25641, 19127, 8873}},
    {9668, 17, 33534, {1, 3, 7, 1, 3, 29, 23, 227, 213, 77, 1483, 845, 1317, 1877, 20475, 56869, 31339}},
    {9669, 17, 33536, {1, 1, 5, 5, 1, 1, 3, 135, 481, 1003, 117, 507, 443, 13325, 31267, 46271, 69921}},
    {9670, 17, 33551, {1, 3, 7, 7, 25, 23, 41, 57, 415, 1011, 2003, 2721, 4225, 12735, 3975, 64505, 68799}},
    {9671, 17, 33554, {1, 3, 5, 7, 9, 61, 101, 135, 427, 447, 1833, 1883, 4163, 8077, 21767, 64659, 128017}},
    {9672, 17, 33563, {1, 1, 7, 1, 27, 9, 123, 217, 287, 667, 1059, 2049, 1613, 2461, 21329, 52531, 78383}},
    {9673, 17, 33575, {1, 1, 3, 5, 9, 45, 51, 113, 257, 415, 1275, 3757, 217, 975, 25947, 17567, 127871}},
    {9674, 17, 33579, {1, 3, 1, 7, 3, 7, 37, 255, 119, 211, 115, 3653, 2321, 14509, 11229, 12567, 22187}},
    {9675, 17, 33582, {1, 3, 1, 11, 25, 7, 53, 13, 429, 255, 305, 2587, 6579, 11743, 16079, 2381, 86415}},
    {9676, 17, 33601, {1, 1, 7, 7, 11, 27, 85, 139, 309, 167, 873, 2745, 4735, 13577, 19319, 26985, 120149}},
    {9677, 17, 33602, {1, 3, 3, 3, 3, 63, 11, 253, 285, 117, 1361, 1271, 7187, 2609, 16649, 65193, 83205}},
    {9678, 17, 33614, {1, 1, 3, 5, 27, 29, 49, 205, 137, 233, 461, 3483, 2393, 15057, 17163, 15201, 22129}},
    {9679, 17, 33625, {1, 3, 5, 13, 25, 21, 35, 137, 87, 47, 1045, 2547, 995, 5969, 3487, 47139, 47663}},
    {9680, 17, 33628, {1, 3, 3, 11, 29, 19, 63, 201, 423, 345, 1411, 3473, 7373, 13039, 11747, 61053, 7875}},
    {9681, 17, 33637, {1, 3, 7, 11, 11, 41, 111, 139, 499, 7, 1001, 901, 2193, 5787, 9189, 16767, 16509}},
    {9682, 17, 33656, {1, 3, 7, 7, 9, 53, 71, 187, 417, 245, 1615, 723, 5237, 1977, 8495, 48255, 47599}},
    {9683, 17, 33665, {1, 3, 7, 7, 9, 9, 41, 95, 133, 233, 1483, 1751, 4497, 5627, 23791, 32045, 59159}},
    {9684, 17, 33683, {1, 1, 3, 11, 21, 37, 5, 119, 47, 647, 1267, 2595, 7643, 1787, 15625, 5013, 107807}},
    {9685, 17, 33695, {1, 3, 3, 11, 5, 1, 45, 81, 233, 511, 507, 4095, 2379, 5463, 6915, 19573, 94331}},
    {9686, 17, 33696, {1, 3, 3, 3, 9, 23, 45, 135, 343, 275, 959, 3595, 6189, 4619, 853, 18923, 104099}},
    {9687, 17, 33702, {1, 1, 3, 13, 11, 23, 61, 125, 339, 375, 461, 2303, 7053, 15293, 23809, 45463, 33849}},
    {9688, 17, 33708, {1, 3, 1, 3, 15, 19, 91, 221, 167, 901, 1275, 773, 7609, 14279, 2641, 22069, 17393}},
    {9689, 17, 33711, {1, 1, 5, 9, 9, 15, 55, 255, 319, 165, 819, 1409, 1277, 1891, 28123, 38695, 13615}},
    {9690, 17, 33716, {1, 3, 3, 5, 27, 5, 99, 59, 259, 377, 1287, 2261, 5763, 10125, 3929, 27971, 95857}},
    {9691, 17, 33728, {1, 3, 5, 7, 7, 63, 93, 11, 3, 629, 669, 2819, 7139, 6681, 24097, 5909, 5723}},
    {9692, 17, 33737, {1, 3, 3, 13, 11, 33, 95, 179, 159, 369, 557, 3497, 105, 4151, 757, 22981, 22287}},
    {9693, 17, 33761, {1, 1, 5, 13, 17, 1, 49, 185, 347, 383, 853, 2395, 4023, 2001, 16425, 53925, 97103}},
    {9694, 17, 33774, {1, 3, 3, 15, 1, 5, 71, 211, 325, 19, 153, 225, 6475, 10399, 24405, 35181, 8223}},
    {9695, 17, 33782, {1, 3, 5, 7, 21, 47, 119, 133, 201, 1021, 531, 2211, 5245, 11343, 1847, 44653, 77695}},
    {9696, 17, 33788, {1, 3, 3, 3, 19, 57, 75, 33, 411, 751, 141, 2617, 7481, 1005, 14205, 63745, 44405}},
    {9697, 17, 33791, {1, 3, 1, 3, 31, 19, 125, 51, 297, 915, 1285, 787, 1643, 6703, 15503, 8811, 119627}},
    {9698, 17, 33793, {1, 1, 5, 9, 1, 13, 109, 63, 57, 49, 1625, 2345, 5957, 5371, 15421, 53693, 126619}},
    {9699, 17, 33811, {1, 3, 3, 9, 19, 1, 31, 121, 373, 59, 943, 3639, 5727, 229, 8645, 50851, 11459}},
    {9700, 17, 33813, {1, 3, 1, 1, 5, 27, 3, 35, 73, 843, 721, 2215, 8093, 14827, 18097, 34959, 127921}},
    {9701, 17, 33818, {1, 1, 5, 13, 11, 25, 99, 55, 329, 873, 1685, 1187, 2969, 8775, 30677, 25003, 116419}},
    {9702, 17, 33829, {1, 1, 3, 5, 1, 13, 61, 181, 463, 317, 639, 3731, 3415, 15367, 11963, 6421, 19307}},
    {9703, 17, 33842, {1, 1, 5, 15, 29, 35, 97, 207, 5, 581, 219, 497, 2871, 13287, 22075, 31157, 53913}},
    {9704, 17, 33854, {1, 1, 1, 5, 9, 39, 49, 39, 305, 795, 1003, 997, 3201, 2161, 1071, 61625, 13785}},
    {9705, 17, 33856, {1, 3, 7, 7, 9, 53, 9, 207, 477, 933, 199, 283, 2603, 3961, 2715, 5441, 38555}},
    {9706, 17, 33868, {1, 3, 5, 5, 3, 9, 51, 163, 429, 725, 1629, 2639, 1387, 16145, 15021, 6065, 96885}},
    {9707, 17, 33879, {1, 3, 1, 7, 25, 5, 67, 185, 407, 717, 323, 3969, 851, 10157, 9337, 32715, 83121}},
    {9708, 17, 33885, {1, 3, 5, 11, 11, 41, 29, 69, 105, 697, 163, 2009, 7083, 14817, 20773, 15665, 89493}},
    {9709, 17, 33886, {1, 1, 7, 11, 7, 11, 121, 129, 21, 855, 743, 273, 2517, 681, 6217, 14451, 78587}},
    {9710, 17, 33892, {1, 3, 1, 13, 11, 35, 79, 57, 177, 859, 1989, 1145, 7523, 4437, 26989, 28605, 25045}},
    {9711, 17, 33907, {1, 1, 7, 7, 31, 41, 23, 15, 235, 993, 1451, 2363, 4949, 11359, 22343, 16089, 82121}},
    {9712, 17, 33913, {1, 3, 1, 5, 31, 15, 121, 179, 21, 637, 389, 1113, 5357, 12487, 9819, 59251, 116669}},
    {9713, 17, 33923, {1, 3, 5, 7, 19, 31, 59, 59, 283, 327, 975, 367, 5409, 5897, 32079, 60991, 97109}},
    {9714, 17, 33925, {1, 1, 1, 5, 25, 19, 5, 9, 249, 37, 351, 3701, 553, 13629, 30887, 54237, 22755}},
    {9715, 17, 33935, {1, 1, 7, 7, 13, 29, 5, 101, 167, 267, 1299, 2311, 4487, 12119, 23091, 32045, 118633}},
    {9716, 17, 33937, {1, 1, 5, 15, 15, 9, 79, 167, 347, 325, 467, 589, 3065, 15551, 10373, 38537, 52445}},
    {9717, 17, 33954, {1, 3, 5, 5, 29, 3, 125, 189, 433, 323, 475, 4033, 4969, 11955, 7201, 52393, 49925}},
    {9718, 17, 33963, {1, 3, 3, 9, 5, 49, 65, 141, 1, 347, 177, 2273, 4587, 5885, 16507, 20349, 60403}},
    {9719, 17, 33966, {1, 1, 5, 7, 11, 57, 47, 155, 95, 859, 205, 3845, 1155, 5731, 12159, 19071, 22843}},
    {9720, 17, 33977, {1, 3, 5, 13, 5, 17, 115, 111, 261, 403, 1633, 2567, 119, 7739, 1849, 3593, 94515}},
    {9721, 17, 33978, {1, 1, 3, 5, 31, 23, 127, 105, 311, 973, 297, 103, 6233, 14633, 18319, 45441, 14485}},
    {9722, 17, 33991, {1, 3, 3, 3, 17, 19, 69, 51, 327, 361, 313, 1069, 7827, 15345, 7167, 32959, 92479}},
    {9723, 17, 33998, {1, 1, 1, 9, 11, 53, 25, 105, 95, 177, 1753, 3641, 7905, 1195, 21605, 785, 17039}},
    {9724, 17, 34012, {1, 3, 7, 9, 1, 53, 5, 13, 359, 835, 2041, 3171, 7585, 6979, 11761, 55101, 21343}},
    {9725, 17, 34016, {1, 1, 1, 3, 1, 57, 17, 85, 371, 491, 775, 2093, 5615, 4977, 30995, 34901, 119751}},
    {9726, 17, 34025, {1, 3, 5, 11, 9, 25, 69, 65, 371, 1021, 1121, 1593, 1491, 13677, 8519, 16305, 66929}},
    {9727, 17, 34033, {1, 1, 7, 5, 31, 61, 33, 31, 141, 809, 261, 2911, 2815, 14799, 5711, 15595, 67095}},
    {9728, 17, 34036, {1, 3, 1, 7, 1, 5, 61, 197, 273, 151, 493, 2809, 2327, 9773, 3959, 24231, 46737}},
    {9729, 17, 34045, {1, 1, 1, 5, 15, 11, 31, 33, 255, 575, 1115, 1687, 5749, 4579, 585, 21079, 9619}},
    {9730, 17, 34065, {1, 1, 7, 13, 1, 49, 121, 145, 215, 799, 785, 631, 65, 3597, 9331, 65421, 12943}},
    {9731, 17, 34078, {1, 1, 5, 5, 23, 43, 123, 241, 417, 807, 989, 463, 677, 12867, 32753, 59207, 6293}},
    {9732, 17, 34093, {1, 3, 3, 15, 1, 15, 33, 65, 503, 761, 975, 1125, 607, 797, 14535, 17563, 36073}},
    {9733, 17, 34101, {1, 3, 5, 1, 25, 29, 1, 35, 465, 635, 891, 309, 1413, 2293, 3685, 37749, 25147}},
    {9734, 17, 34108, {1, 1, 7, 7, 31, 15, 13, 125, 93, 977, 1583, 1561, 3537, 11955, 14745, 22617, 49279}},
    {9735, 17, 34111, {1, 3, 7, 13, 19, 57, 71, 167, 343, 811, 53, 3863, 2491, 15063, 2469, 13281, 18293}},
    {9736, 17, 34120, {1, 3, 3, 15, 17, 29, 9, 159, 391, 843, 365, 1197, 4163, 16125, 29965, 52139, 55281}},
    {9737, 17, 34123, {1, 1, 3, 11, 27, 45, 7, 83, 271, 611, 1067, 3321, 5523, 9685, 23047, 16115, 71141}},
    {9738, 17, 34125, {1, 1, 5, 11, 21, 21, 37, 149, 83, 723, 1747, 1545, 1937, 10785, 7193, 13871, 126709}},
    {9739, 17, 34153, {1, 3, 1, 5, 5, 23, 71, 221, 261, 889, 1479, 3045, 797, 13845, 16173, 25319, 54743}},
    {9740, 17, 34171, {1, 3, 1, 7, 25, 31, 9, 171, 477, 737, 93, 2925, 6433, 13731, 1961, 46981, 38567}},
    {9741, 17, 34174, {1, 3, 5, 9, 25, 13, 103, 111, 493, 391, 535, 2767, 4495, 11067, 12869, 25409, 11079}},
    {9742, 17, 34178, {1, 3, 7, 7, 1, 33, 71, 217, 307, 947, 197, 361, 7359, 13761, 19357, 52655, 34051}},
    {9743, 17, 34183, {1, 3, 3, 9, 17, 59, 53, 89, 289, 223, 1655, 2241, 2969, 5935, 9739, 20597, 55365}},
    {9744, 17, 34190, {1, 1, 5, 3, 21, 29, 105, 227, 341, 969, 1203, 2797, 7967, 5967, 30683, 21085, 93347}},
    {9745, 17, 34201, {1, 3, 7, 15, 9, 3, 95, 115, 425, 357, 717, 3661, 2239, 8601, 1905, 63411, 32229}},
    {9746, 17, 34211, {1, 1, 1, 1, 13, 17, 11, 237, 291, 723, 1065, 3365, 1721, 14923, 32585, 47601, 59105}},
    {9747, 17, 34220, {1, 1, 3, 5, 29, 41, 81, 1, 367, 891, 193, 2551, 1023, 9687, 6329, 49635, 94209}},
    {9748, 17, 34225, {1, 1, 3, 3, 25, 63, 73, 53, 101, 645, 1877, 1401, 5515, 13969, 19279, 16587, 107513}},
    {9749, 17, 34237, {1, 3, 1, 9, 25, 25, 97, 103, 383, 183, 881, 283, 3341, 1381, 15599, 13897, 13569}},
    {9750, 17, 34249, {1, 1, 7, 1, 27, 55, 59, 217, 345, 195, 555, 3105, 4741, 11981, 14809, 18535, 12439}},
    {9751, 17, 34250, {1, 3, 1, 3, 25, 57, 71, 185, 43, 929, 1993, 1217, 6519, 5033, 18255, 62343, 127169}},
    {9752, 17, 34264, {1, 1, 1, 1, 13, 17, 113, 87, 265, 479, 997, 3227, 5619, 5649, 17773, 40637, 26081}},
    {9753, 17, 34269, {1, 3, 1, 11, 17, 31, 43, 187, 331, 725, 1619, 2303, 1229, 14245, 17833, 17675, 24475}},
    {9754, 17, 34276, {1, 1, 7, 11, 29, 5, 29, 89, 133, 173, 1129, 1133, 593, 10807, 14227, 44415, 891}},
    {9755, 17, 34279, {1, 1, 5, 15, 25, 19, 25, 149, 355, 325, 125, 3877, 1071, 13193, 18261, 12129, 31169}},
    {9756, 17, 34293, {1, 3, 1, 5, 17, 51, 115, 111, 303, 629, 623, 2133, 4507, 5431, 25583, 7629, 126139}},
    {9757, 17, 34303, {1, 3, 7, 15, 21, 43, 63, 69, 183, 149, 107, 1787, 3769, 12897, 32653, 63553, 70787}},
    {9758, 17, 34310, {1, 1, 1, 15, 5, 59, 87, 211, 89, 789, 639, 561, 1259, 4409, 23201, 11397, 87535}},
    {9759, 17, 34340, {1, 3, 5, 1, 5, 47, 81, 143, 265, 827, 219, 3155, 4649, 2413, 7369, 20269, 20013}},
    {9760, 17, 34349, {1, 3, 1, 9, 1, 63, 21, 167, 79, 75, 1009, 2115, 4167, 7017, 10143, 31315, 87709}},
    {9761, 17, 34352, {1, 1, 3, 15, 19, 33, 115, 249, 47, 703, 1545, 3235, 5383, 6059, 1293, 1197, 54271}},
    {9762, 17, 34355, {1, 1, 1, 1, 1, 21, 11, 93, 481, 1005, 929, 3851, 407, 12137, 19281, 58791, 11071}},
    {9763, 17, 34358, {1, 3, 3, 5, 19, 31, 83, 91, 265, 905, 1813, 1135, 2251, 7765, 20997, 27133, 80297}},
    {9764, 17, 34362, {1, 1, 7, 13, 23, 43, 7, 157, 321, 543, 1085, 2759, 339, 8949, 17553, 52271, 82401}},
    {9765, 17, 34376, {1, 3, 3, 5, 21, 53, 125, 71, 371, 587, 1495, 665, 571, 11043, 6347, 44285, 108769}},
    {9766, 17, 34381, {1, 3, 7, 3, 7, 45, 113, 51, 393, 51, 1809, 1745, 2423, 9931, 24283, 38515, 102631}},
    {9767, 17, 34387, {1, 1, 7, 3, 3, 3, 81, 161, 167, 499, 1719, 2879, 6563, 15897, 28931, 39211, 110617}},
    {9768, 17, 34389, {1, 3, 1, 5, 27, 13, 5, 185, 467, 571, 1937, 1057, 4859, 10401, 18023, 8603, 58401}},
    {9769, 17, 34394, {1, 1, 5, 7, 5, 47, 57, 223, 221, 163, 1207, 2361, 2709, 13733, 19111, 57665, 84417}},
    {9770, 17, 34410, {1, 1, 1, 11, 31, 55, 65, 67, 95, 493, 637, 3013, 2825, 4985, 18097, 57929, 105519}},
    {9771, 17, 34423, {1, 1, 5, 1, 31, 19, 29, 139, 407, 437, 205, 1665, 49, 9913, 16653, 37259, 120589}},
    {9772, 17, 34434, {1, 3, 7, 3, 15, 43, 73, 13, 477, 369, 1143, 2069, 3605, 6521, 19471, 31779, 52607}},
    {9773, 17, 34436, {1, 1, 5, 13, 7, 45, 41, 147, 397, 71, 1553, 1183, 4929, 5109, 2441, 20667, 4343}},
    {9774, 17, 34448, {1, 3, 3, 7, 5, 29, 119, 133, 137, 1015, 1587, 2389, 4571, 6207, 5653, 11227, 130047}},
    {9775, 17, 34453, {1, 1, 1, 11, 3, 31, 55, 159, 233, 865, 923, 4061, 4377, 5283, 7855, 47905, 34879}},
    {9776, 17, 34454, {1, 3, 5, 11, 27, 59, 109, 41, 335, 343, 683, 1943, 2627, 10315, 26389, 37675, 54037}},
    {9777, 17, 34460, {1, 1, 7, 11, 25, 55, 33, 57, 427, 381, 463, 501, 3793, 12239, 32721, 63667, 44209}},
    {9778, 17, 34464, {1, 3, 5, 13, 9, 49, 1, 11, 129, 35, 963, 617, 757, 7137, 32599, 42211, 57137}},
    {9779, 17, 34479, {1, 1, 7, 15, 13, 11, 53, 25, 135, 719, 1125, 3845, 1751, 3683, 17377, 44643, 103141}},
    {9780, 17, 34491, {1, 1, 7, 9, 13, 17, 33, 109, 87, 467, 1369, 1727, 1239, 6537, 27003, 23865, 26109}},
    {9781, 17, 34501, {1, 3, 5, 3, 31, 43, 103, 67, 73, 307, 407, 71, 475, 5867, 32631, 15465, 76267}},
    {9782, 17, 34508, {1, 1, 7, 5, 31, 21, 77, 141, 435, 929, 1107, 2865, 3957, 983, 30625, 2397, 129043}},
    {9783, 17, 34516, {1, 1, 5, 15, 5, 49, 47, 245, 477, 687, 741, 3507, 5829, 10031, 31425, 64217, 119249}},
    {9784, 17, 34529, {1, 3, 1, 3, 31, 5, 15, 27, 289, 5, 1235, 317, 5503, 8497, 8739, 44387, 11043}},
    {9785, 17, 34530, {1, 3, 3, 3, 25, 43, 117, 205, 345, 389, 1467, 3299, 231, 9147, 27863, 2459, 9819}},
    {9786, 17, 34553, {1, 3, 5, 11, 11, 33, 101, 15, 437, 967, 219, 1669, 4331, 12775, 10197, 43619, 53117}},
    {9787, 17, 34564, {1, 3, 1, 9, 21, 37, 13, 13, 51, 971, 53, 597, 161, 4413, 13617, 8735, 130769}},
    {9788, 17, 34568, {1, 1, 5, 1, 27, 25, 77, 151, 15, 753, 455, 2527, 4891, 10791, 16699, 5247, 74443}},
    {9789, 17, 34571, {1, 1, 1, 13, 27, 57, 1, 23, 457, 365, 61, 553, 1739, 671, 30923, 55601, 15431}},
    {9790, 17, 34582, {1, 3, 7, 3, 11, 39, 65, 99, 213, 613, 819, 3893, 3089, 6001, 31773, 49589, 21857}},
    {9791, 17, 34586, {1, 3, 1, 3, 27, 51, 101, 113, 123, 21, 1159, 289, 63, 5809, 28721, 59671, 127669}},
    {9792, 17, 34598, {1, 3, 5, 9, 21, 11, 53, 223, 187, 545, 135, 1913, 6831, 2839, 29713, 41309, 46677}},
    {9793, 17, 34604, {1, 1, 3, 11, 29, 23, 79, 91, 161, 517, 1841, 3997, 6021, 14447, 1853, 20135, 119683}},
    {9794, 17, 34610, {1, 1, 5, 15, 13, 45, 113, 191, 213, 711, 1793, 1221, 5013, 1867, 3053, 25299, 112467}},
    {9795, 17, 34619, {1, 3, 7, 3, 19, 1, 51, 187, 151, 357, 1203, 767, 1969, 311, 12925, 44137, 28703}},
    {9796, 17, 34621, {1, 3, 7, 13, 21, 25, 11, 197, 257, 715, 1043, 1481, 11, 8589, 18075, 27023, 36441}},
    {9797, 17, 34633, {1, 1, 5, 9, 11, 15, 51, 91, 335, 841, 655, 2971, 4393, 14989, 18967, 64755, 127581}},
    {9798, 17, 34634, {1, 3, 3, 11, 27, 47, 117, 49, 125, 115, 1373, 2385, 3039, 3509, 11633, 59833, 95093}},
    {9799, 17, 34657, {1, 3, 3, 9, 31, 51, 77, 171, 9, 63, 511, 2759, 3239, 14319, 10497, 25511, 17635}},
    {9800, 17, 34682, {1, 3, 5, 9, 11, 41, 113, 93, 355, 439, 1657, 2739, 7687, 14671, 15473, 17671, 82973}},
    {9801, 17, 34688, {1, 1, 1, 3, 31, 3, 57, 47, 447, 755, 1717, 4051, 6243, 13107, 6337, 11463, 102083}},
    {9802, 17, 34691, {1, 3, 7, 5, 11, 5, 11, 23, 41, 911, 2001, 719, 7759, 6205, 31729, 20033, 99733}},
    {9803, 17, 34694, {1, 1, 3, 3, 7, 29, 111, 51, 143, 619, 87, 615, 7535, 10577, 10393, 39863, 65021}},
    {9804, 17, 34706, {1, 3, 1, 5, 25, 55, 93, 3, 111, 173, 291, 475, 4691, 6693, 23755, 44513, 23999}},
    {9805, 17, 34708, {1, 1, 5, 15, 23, 25, 31, 107, 197, 193, 191, 2327, 6929, 2727, 3317, 27015, 100205}},
    {9806, 17, 34724, {1, 3, 1, 11, 11, 57, 75, 181, 363, 617, 783, 2863, 137, 8093, 19327, 10073, 14923}},
    {9807, 17, 34727, {1, 3, 1, 9, 13, 35, 13, 49, 413, 679, 295, 2953, 2409, 13569, 30727, 37519, 122045}},
    {9808, 17, 34751, {1, 3, 7, 13, 31, 7, 111, 169, 507, 277, 1417, 243, 3005, 14427, 10499, 20669, 35749}},
    {9809, 17, 34753, {1, 3, 5, 7, 13, 5, 45, 25, 145, 431, 1445, 1911, 6109, 6901, 5303, 25807, 85901}},
    {9810, 17, 34759, {1, 3, 5, 3, 1, 25, 13, 27, 85, 243, 283, 711, 899, 15583, 17577, 12585, 119785}},
    {9811, 17, 34763, {1, 3, 7, 1, 11, 59, 81, 127, 25, 977, 1563, 1669, 7355, 5067, 18271, 16639, 82673}},
    {9812, 17, 34777, {1, 1, 5, 11, 9, 43, 53, 119, 99, 469, 1751, 1169, 6625, 10695, 27553, 1305, 112583}},
    {9813, 17, 34778, {1, 1, 5, 9, 9, 63, 89, 193, 189, 989, 847, 911, 6273, 12901, 7907, 47605, 5281}},
    {9814, 17, 34780, {1, 3, 3, 7, 11, 53, 67, 247, 179, 629, 1705, 723, 4443, 5457, 2801, 28899, 116557}},
    {9815, 17, 34796, {1, 1, 7, 1, 19, 47, 5, 79, 111, 737, 395, 597, 5059, 5407, 493, 10275, 103737}},
    {9816, 17, 34799, {1, 1, 5, 7, 29, 13, 75, 47, 447, 153, 179, 1061, 1563, 1667, 3165, 63631, 59065}},
    {9817, 17, 34801, {1, 3, 3, 13, 19, 15, 119, 37, 283, 957, 399, 29, 6641, 3715, 30653, 34781, 104081}},
    {9818, 17, 34817, {1, 1, 5, 9, 13, 45, 23, 181, 127, 271, 555, 487, 5373, 3257, 27971, 51535, 105351}},
    {9819, 17, 34824, {1, 3, 1, 15, 13, 15, 73, 241, 187, 1011, 305, 1367, 1381, 2131, 22919, 55299, 33205}},
    {9820, 17, 34827, {1, 1, 3, 13, 19, 17, 5, 69, 23, 931, 873, 945, 717, 5693, 11481, 51445, 130267}},
    {9821, 17, 34837, {1, 1, 1, 9, 21, 31, 79, 145, 507, 517, 889, 1139, 3107, 11181, 15143, 29379, 117485}},
    {9822, 17, 34841, {1, 3, 3, 9, 7, 27, 87, 51, 153, 101, 1447, 493, 3935, 2369, 27007, 28067, 47011}},
    {9823, 17, 34853, {1, 3, 5, 7, 29, 53, 71, 191, 265, 937, 787, 3053, 4633, 13491, 16317, 37467, 119977}},
    {9824, 17, 34858, {1, 3, 7, 9, 27, 31, 73, 45, 301, 903, 669, 3439, 4699, 12787, 30537, 51621, 63177}},
    {9825, 17, 34877, {1, 1, 7, 13, 11, 11, 17, 75, 347, 929, 107, 2675, 893, 10717, 30903, 7153, 93989}},
    {9826, 17, 34886, {1, 3, 3, 7, 25, 31, 77, 187, 427, 661, 1047, 719, 6009, 7959, 23869, 37755, 93375}},
    {9827, 17, 34895, {1, 3, 1, 11, 23, 63, 101, 253, 421, 799, 503, 3321, 3423, 14071, 24719, 4235, 97411}},
    {9828, 17, 34897, {1, 1, 1, 13, 13, 45, 77, 101, 107, 417, 1705, 2561, 7259, 9855, 2105, 37851, 111215}},
    {9829, 17, 34898, {1, 3, 3, 1, 27, 27, 123, 175, 335, 263, 1835, 523, 5811, 14863, 23891, 3733, 24955}},
    {9830, 17, 34916, {1, 3, 3, 7, 9, 53, 1, 41, 115, 779, 823, 1195, 8113, 14515, 12035, 58675, 49275}},
    {9831, 17, 34923, {1, 1, 3, 3, 5, 51, 63, 43, 245, 85, 1979, 1199, 1077, 9213, 2325, 62601, 49431}},
    {9832, 17, 34928, {1, 3, 5, 3, 27, 59, 81, 199, 403, 719, 1157, 1769, 1747, 7909, 7985, 42521, 50751}},
    {9833, 17, 34934, {1, 3, 1, 13, 13, 63, 127, 255, 439, 125, 2029, 2179, 1765, 2995, 12867, 30161, 79233}},
    {9834, 17, 34940, {1, 3, 3, 15, 29, 41, 125, 103, 255, 911, 1733, 2245, 1053, 14831, 2049, 20705, 85381}},
    {9835, 17, 34944, {1, 3, 3, 11, 15, 57, 77, 55, 233, 637, 513, 1233, 373, 11175, 3735, 50313, 82839}},
    {9836, 17, 34947, {1, 3, 3, 3, 29, 25, 81, 37, 81, 383, 1519, 2795, 3697, 2767, 7739, 31807, 63895}},
    {9837, 17, 34953, {1, 3, 1, 3, 29, 63, 63, 227, 195, 229, 1729, 3099, 6859, 4003, 26913, 41275, 91741}},
    {9838, 17, 34956, {1, 1, 7, 5, 21, 47, 69, 111, 461, 141, 671, 1051, 5383, 16211, 14915, 14051, 23937}},
    {9839, 17, 34967, {1, 1, 7, 11, 23, 41, 55, 155, 303, 561, 1791, 3657, 5099, 11115, 21173, 8031, 81149}},
    {9840, 17, 34968, {1, 3, 1, 5, 29, 39, 109, 111, 161, 297, 1879, 355, 8083, 11675, 8325, 25557, 44027}},
    {9841, 17, 34971, {1, 1, 7, 11, 29, 35, 45, 3, 291, 599, 269, 2085, 1195, 5035, 5851, 22163, 49191}},
    {9842, 17, 34974, {1, 1, 7, 11, 29, 59, 9, 39, 293, 423, 1921, 3053, 4751, 10721, 28789, 44239, 43561}},
    {9843, 17, 34977, {1, 1, 5, 3, 21, 9, 7, 41, 181, 725, 1687, 2747, 723, 7091, 30461, 53027, 107699}},
    {9844, 17, 34980, {1, 3, 3, 3, 19, 19, 81, 187, 303, 185, 723, 51, 3467, 6807, 529, 47001, 1963}},
    {9845, 17, 34983, {1, 1, 7, 3, 21, 21, 45, 179, 319, 377, 453, 777, 4841, 6583, 7741, 42977, 112003}},
    {9846, 17, 34998, {1, 1, 1, 5, 7, 17, 7, 73, 275, 621, 825, 7, 3501, 4269, 423, 48525, 67737}},
    {9847, 17, 35004, {1, 3, 7, 11, 25, 39, 5, 169, 269, 147, 961, 1503, 3837, 9477, 16499, 13903, 65937}},
    {9848, 17, 35010, {1, 1, 1, 7, 1, 31, 81, 153, 69, 699, 193, 307, 409, 15967, 4679, 38529, 107717}},
    {9849, 17, 35012, {1, 1, 3, 13, 9, 7, 127, 171, 49, 537, 411, 1245, 407, 13589, 29263, 56615, 73131}},
    {9850, 17, 35030, {1, 3, 5, 13, 5, 25, 63, 217, 393, 891, 315, 35, 5715, 10467, 133, 27553, 74771}},
    {9851, 17, 35039, {1, 3, 3, 15, 31, 63, 81, 163, 367, 299, 955, 223, 4437, 12993, 8895, 46845, 124381}},
    {9852, 17, 35058, {1, 1, 3, 11, 23, 53, 11, 29, 43, 571, 1771, 2085, 2589, 1525, 29753, 3383, 44107}},
    {9853, 17, 35063, {1, 3, 3, 11, 1, 59, 45, 221, 127, 815, 31, 2289, 7571, 10815, 14195, 17471, 63183}},
    {9854, 17, 35082, {1, 1, 1, 7, 21, 61, 117, 131, 65, 809, 741, 2155, 5305, 14667, 27415, 48593, 39585}},
    {9855, 17, 35095, {1, 3, 7, 9, 13, 57, 97, 197, 339, 189, 947, 1661, 1497, 4377, 23767, 29123, 71345}},
    {9856, 17, 35096, {1, 3, 1, 15, 23, 61, 13, 131, 307, 881, 1431, 2439, 6325, 15013, 26677, 2311, 41319}},
    {9857, 17, 35101, {1, 1, 1, 7, 23, 51, 79, 217, 317, 981, 811, 3701, 4535, 11481, 10463, 6497, 17353}},
    {9858, 17, 35102, {1, 3, 1, 11, 9, 33, 9, 23, 247, 61, 1573, 3517, 4343, 7593, 7237, 41379, 63705}},
    {9859, 17, 35105, {1, 1, 3, 13, 15, 43, 59, 121, 425, 419, 1371, 729, 4155, 1701, 12103, 63935, 79167}},
    {9860, 17, 35112, {1, 1, 5, 3, 31, 19, 123, 153, 199, 311, 739, 3187, 6889, 15707, 7963, 14059, 127299}},
    {9861, 17, 35118, {1, 3, 3, 15, 31, 21, 45, 147, 213, 771, 1511, 1817, 2323, 731, 6975, 18191, 116769}},
    {9862, 17, 35120, {1, 3, 7, 3, 19, 59, 51, 177, 37, 127, 1995, 2781, 1123, 7351, 21701, 24321, 49637}},
    {9863, 17, 35130, {1, 1, 7, 11, 1, 37, 117, 217, 347, 651, 805, 197, 5593, 15259, 14275, 51685, 102197}},
    {9864, 17, 35143, {1, 3, 1, 13, 25, 21, 99, 117, 103, 481, 1533, 2119, 7873, 9403, 571, 52193, 118681}},
    {9865, 17, 35147, {1, 3, 3, 13, 25, 5, 47, 223, 487, 575, 1735, 2425, 6043, 9967, 21643, 14689, 68383}},
    {9866, 17, 35152, {1, 3, 3, 7, 31, 33, 3, 143, 223, 947, 221, 431, 2275, 16279, 17079, 9287, 120613}},
    {9867, 17, 35157, {1, 3, 7, 5, 5, 13, 77, 203, 225, 455, 1207, 2727, 6691, 4129, 23439, 31901, 35237}},
    {9868, 17, 35164, {1, 1, 3, 13, 9, 43, 83, 87, 443, 979, 985, 3355, 1183, 13915, 20973, 13029, 59225}},
    {9869, 17, 35178, {1, 3, 5, 1, 1, 57, 73, 155, 33, 395, 693, 623, 5807, 2777, 16309, 44837, 64887}},
    {9870, 17, 35195, {1, 1, 3, 5, 9, 25, 41, 101, 259, 1009, 21, 1351, 3087, 12777, 26051, 14939, 12341}},
    {9871, 17, 35197, {1, 3, 1, 9, 3, 23, 15, 181, 215, 133, 341, 1211, 2609, 3479, 7505, 8889, 103285}},
    {9872, 17, 35201, {1, 3, 1, 1, 5, 61, 39, 187, 91, 171, 271, 3925, 5325, 15037, 5521, 5735, 102015}},
    {9873, 17, 35207, {1, 3, 3, 9, 21, 11, 117, 65, 473, 743, 861, 3025, 1053, 4023, 27093, 16603, 125667}},
    {9874, 17, 35231, {1, 3, 3, 11, 13, 13, 79, 169, 353, 245, 617, 1969, 3185, 2497, 10015, 60237, 72267}},
    {9875, 17, 35249, {1, 1, 3, 5, 5, 55, 99, 189, 417, 787, 353, 657, 3137, 11223, 19327, 19799, 116525}},
    {9876, 17, 35250, {1, 1, 7, 9, 13, 17, 73, 17, 401, 961, 723, 3011, 6047, 303, 8277, 51415, 32465}},
    {9877, 17, 35256, {1, 1, 3, 1, 23, 3, 59, 79, 309, 923, 389, 1179, 8037, 2815, 17307, 20121, 118873}},
    {9878, 17, 35259, {1, 3, 3, 13, 25, 7, 23, 113, 115, 899, 633, 689, 861, 6065, 11741, 26853, 1073}},
    {9879, 17, 35262, {1, 3, 7, 3, 27, 25, 33, 171, 145, 67, 265, 2175, 8013, 15333, 24961, 47813, 66227}},
    {9880, 17, 35273, {1, 1, 7, 5, 11, 15, 81, 63, 415, 979, 507, 2767, 949, 14893, 12863, 24867, 126259}},
    {9881, 17, 35282, {1, 1, 5, 9, 9, 15, 125, 53, 213, 31, 1589, 3365, 1225, 6065, 26443, 10257, 12931}},
    {9882, 17, 35298, {1, 3, 3, 1, 1, 25, 67, 159, 119, 295, 285, 3995, 5843, 12637, 20513, 47083, 14395}},
    {9883, 17, 35307, {1, 1, 7, 15, 13, 17, 19, 91, 181, 903, 1343, 1225, 8103, 2465, 27381, 33895, 11335}},
    {9884, 17, 35328, {1, 3, 7, 3, 21, 21, 127, 11, 93, 103, 315, 2855, 1321, 12469, 18937, 5919, 83587}},
    {9885, 17, 35334, {1, 3, 1, 13, 3, 21, 57, 19, 37, 937, 1503, 2025, 313, 12369, 32391, 48959, 109055}},
    {9886, 17, 35343, {1, 3, 7, 13, 19, 31, 53, 157, 27, 227, 1627, 2869, 4035, 12279, 6935, 52375, 24625}},
    {9887, 17, 35345, {1, 3, 5, 11, 11, 5, 125, 43, 157, 1007, 1597, 817, 2785, 8055, 30177, 9419, 43167}},
    {9888, 17, 35355, {1, 1, 1, 3, 15, 3, 89, 251, 163, 499, 1845, 503, 6299, 16347, 32281, 41071, 57567}},
    {9889, 17, 35388, {1, 3, 7, 5, 25, 63, 119, 75, 471, 993, 1745, 4033, 6401, 9839, 173, 25411, 1997}},
    {9890, 17, 35399, {1, 3, 3, 11, 31, 49, 23, 205, 307, 353, 751, 1609, 4743, 3683, 4411, 49711, 24215}},
    {9891, 17, 35403, {1, 1, 1, 5, 19, 15, 93, 201, 469, 233, 1325, 2783, 7313, 1371, 13527, 3321, 128639}},
    {9892, 17, 35408, {1, 3, 5, 9, 7, 27, 1, 181, 135, 109, 1921, 2525, 41, 16297, 10153, 25533, 307}},
    {9893, 17, 35413, {1, 1, 5, 7, 1, 39, 117, 57, 97, 909, 387, 471, 4519, 643, 25979, 21645, 12909}},
    {9894, 17, 35418, {1, 1, 7, 13, 25, 33, 109, 181, 171, 739, 237, 825, 5059, 5461, 29709, 48641, 5885}},
    {9895, 17, 35434, {1, 3, 7, 13, 7, 51, 109, 149, 405, 649, 265, 569, 5503, 6009, 32093, 46055, 102721}},
    {9896, 17, 35436, {1, 3, 5, 15, 9, 7, 77, 231, 331, 227, 1881, 13, 5657, 9185, 11111, 43247, 122463}},
    {9897, 17, 35448, {1, 1, 5, 7, 19, 61, 107, 23, 23, 697, 599, 1707, 4165, 10715, 24847, 32849, 12709}},
    {9898, 17, 35460, {1, 3, 1, 1, 19, 11, 11, 113, 351, 753, 1173, 1677, 5435, 8833, 26921, 16281, 117563}},
    {9899, 17, 35475, {1, 3, 7, 7, 21, 1, 89, 27, 387, 665, 1085, 3249, 5785, 2083, 28087, 28511, 107071}},
    {9900, 17, 35494, {1, 1, 5, 9, 27, 19, 51, 177, 223, 175, 1127, 1613, 743, 7901, 19655, 41599, 50357}},
    {9901, 17, 35497, {1, 1, 3, 3, 23, 19, 43, 105, 57, 51, 1277, 2533, 381, 1417, 5189, 9697, 6603}},
    {9902, 17, 35503, {1, 3, 5, 9, 31, 61, 85, 229, 13, 557, 1001, 2947, 1173, 4511, 26319, 8963, 128611}},
    {9903, 17, 35508, {1, 1, 3, 1, 19, 43, 1, 175, 93, 847, 1947, 937, 2825, 9875, 28225, 48817, 21029}},
    {9904, 17, 35511, {1, 3, 7, 15, 27, 21, 23, 113, 493, 255, 1211, 3093, 5953, 2875, 21455, 3561, 87667}},
    {9905, 17, 35518, {1, 3, 3, 5, 1, 1, 97, 45, 447, 233, 267, 267, 1879, 10529, 10013, 44891, 24105}},
    {9906, 17, 35520, {1, 1, 1, 5, 29, 21, 27, 117, 327, 879, 1809, 3135, 7771, 5449, 32019, 2181, 84787}},
    {9907, 17, 35530, {1, 1, 1, 11, 9, 17, 43, 65, 127, 107, 1463, 2331, 1595, 8591, 4223, 54695, 97501}},
    {9908, 17, 35537, {1, 3, 1, 9, 25, 53, 111, 251, 507, 359, 671, 1675, 5179, 9907, 16149, 30681, 33985}},
    {9909, 17, 35543, {1, 3, 5, 3, 15, 45, 67, 153, 227, 963, 2031, 3771, 6259, 7941, 13723, 39253, 61519}},
    {9910, 17, 35560, {1, 3, 3, 15, 21, 39, 39, 63, 9, 177, 331, 701, 3931, 13217, 20165, 27481, 37839}},
    {9911, 17, 35566, {1, 3, 7, 3, 17, 47, 37, 145, 25, 911, 1357, 1613, 793, 10847, 26817, 17439, 99875}},
    {9912, 17, 35571, {1, 1, 3, 9, 11, 63, 23, 181, 209, 711, 1955, 2255, 1863, 2157, 27317, 14047, 67983}},
    {9913, 17, 35598, {1, 3, 5, 7, 9, 31, 51, 73, 459, 173, 1515, 3323, 215, 4713, 17495, 42399, 20425}},
    {9914, 17, 35609, {1, 3, 1, 1, 31, 9, 35, 135, 479, 233, 1105, 1861, 6491, 8677, 6713, 59695, 56657}},
    {9915, 17, 35612, {1, 1, 5, 13, 17, 17, 37, 129, 25, 903, 245, 143, 8175, 261, 2197, 38839, 44503}},
    {9916, 17, 35615, {1, 1, 5, 15, 29, 19, 57, 243, 151, 353, 1543, 1141, 5291, 8027, 8169, 52907, 39469}},
    {9917, 17, 35616, {1, 1, 1, 7, 9, 27, 29, 181, 365, 37, 1391, 1275, 4417, 2007, 30301, 21787, 7999}},
    {9918, 17, 35622, {1, 3, 1, 15, 23, 9, 73, 171, 343, 227, 1387, 3515, 593, 12467, 1171, 45047, 91465}},
    {9919, 17, 35626, {1, 1, 7, 7, 11, 55, 119, 219, 261, 933, 1239, 3835, 3055, 7113, 32515, 19459, 55081}},
    {9920, 17, 35633, {1, 3, 3, 7, 9, 3, 27, 121, 369, 345, 813, 2053, 7421, 11519, 31063, 21199, 27113}},
    {9921, 17, 35636, {1, 1, 5, 13, 27, 63, 97, 147, 263, 1019, 677, 1349, 3995, 3845, 27059, 64881, 120789}},
    {9922, 17, 35645, {1, 1, 1, 3, 19, 55, 47, 199, 467, 47, 1245, 1473, 3089, 125, 13151, 64769, 30245}},
    {9923, 17, 35653, {1, 3, 5, 9, 17, 15, 121, 151, 445, 547, 935, 3757, 7469, 7841, 23909, 23653, 31417}},
    {9924, 17, 35663, {1, 3, 3, 11, 23, 9, 69, 177, 371, 33, 759, 2001, 3311, 14005, 18517, 60129, 35993}},
    {9925, 17, 35665, {1, 3, 5, 9, 5, 57, 1, 25, 461, 145, 509, 3093, 475, 2769, 11711, 64041, 51275}},
    {9926, 17, 35682, {1, 3, 5, 3, 13, 47, 43, 183, 283, 885, 195, 3989, 6573, 11933, 12173, 29401, 64491}},
    {9927, 17, 35687, {1, 3, 1, 7, 23, 5, 127, 15, 409, 891, 1203, 849, 3439, 2227, 28145, 38363, 54103}},
    {9928, 17, 35688, {1, 1, 1, 1, 1, 47, 15, 139, 1, 661, 1007, 2021, 5557, 8211, 21005, 64479, 12077}},
    {9929, 17, 35691, {1, 3, 3, 3, 23, 61, 85, 67, 173, 527, 1739, 3143, 4949, 7153, 30037, 63817, 126789}},
    {9930, 17, 35696, {1, 3, 3, 3, 7, 61, 19, 135, 15, 389, 2045, 2867, 811, 2223, 24397, 38163, 36703}},
    {9931, 17, 35727, {1, 3, 5, 13, 29, 35, 11, 139, 271, 95, 1861, 2065, 433, 2559, 5281, 62563, 114149}},
    {9932, 17, 35741, {1, 1, 7, 1, 27, 37, 103, 3, 63, 501, 1855, 3541, 943, 2483, 28715, 11607, 100905}},
    {9933, 17, 35742, {1, 3, 3, 1, 17, 27, 81, 177, 75, 559, 627, 1701, 51, 1363, 20713, 39547, 57577}},
    {9934, 17, 35746, {1, 1, 7, 7, 21, 3, 119, 25, 239, 525, 221, 2123, 7171, 7647, 17083, 61117, 3701}},
    {9935, 17, 35748, {1, 1, 7, 11, 11, 31, 93, 175, 287, 259, 159, 1011, 141, 10893, 13299, 31793, 95339}},
    {9936, 17, 35752, {1, 3, 1, 3, 29, 33, 103, 113, 257, 203, 1961, 2251, 1941, 1479, 12889, 58965, 53871}},
    {9937, 17, 35770, {1, 3, 5, 7, 1, 5, 113, 105, 363, 355, 969, 1585, 769, 13523, 3275, 1019, 129843}},
    {9938, 17, 35811, {1, 1, 1, 11, 27, 11, 63, 167, 87, 755, 1465, 3191, 349, 1111, 5217, 24279, 31055}},
    {9939, 17, 35817, {1, 3, 7, 1, 9, 55, 17, 35, 153, 781, 569, 3589, 7331, 4053, 20265, 52813, 63371}},
    {9940, 17, 35832, {1, 3, 3, 15, 31, 51, 31, 139, 125, 757, 1163, 1251, 5113, 12181, 867, 30257, 120107}},
    {9941, 17, 35838, {1, 3, 5, 15, 19, 19, 59, 1, 377, 991, 1725, 1845, 6429, 7915, 1885, 18429, 53051}},
    {9942, 17, 35850, {1, 3, 7, 13, 19, 5, 25, 219, 449, 603, 611, 3711, 6357, 4805, 6057, 23767, 51143}},
    {9943, 17, 35863, {1, 1, 7, 1, 27, 13, 35, 173, 285, 909, 281, 1293, 3735, 2133, 18943, 8663, 111733}},
    {9944, 17, 35870, {1, 1, 3, 13, 31, 39, 103, 205, 487, 591, 1399, 4083, 423, 5469, 4417, 5005, 99025}},
    {9945, 17, 35879, {1, 3, 1, 9, 3, 29, 65, 205, 285, 655, 1603, 2263, 2905, 15811, 19351, 57767, 91289}},
    {9946, 17, 35880, {1, 1, 7, 15, 7, 11, 73, 39, 455, 603, 735, 2951, 2635, 11485, 8547, 61383, 68047}},
    {9947, 17, 35891, {1, 3, 5, 15, 19, 19, 15, 191, 191, 471, 191, 541, 1591, 12723, 3007, 56559, 30707}},
    {9948, 17, 35893, {1, 1, 1, 7, 7, 23, 29, 247, 419, 53, 895, 3679, 101, 11207, 22867, 27089, 97975}},
    {9949, 17, 35903, {1, 3, 7, 1, 1, 37, 3, 19, 425, 291, 1383, 3979, 2415, 8891, 26751, 27999, 70327}},
    {9950, 17, 35905, {1, 3, 7, 15, 7, 21, 27, 19, 425, 803, 1415, 3771, 3119, 14381, 1401, 22013, 26403}},
    {9951, 17, 35926, {1, 1, 3, 5, 7, 49, 27, 159, 111, 743, 1385, 2089, 4375, 2009, 20629, 34179, 63883}},
    {9952, 17, 35930, {1, 3, 3, 3, 21, 57, 57, 23, 503, 409, 867, 1989, 347, 2475, 7173, 41319, 5993}},
    {9953, 17, 35941, {1, 3, 7, 7, 29, 43, 71, 127, 15, 605, 93, 567, 1313, 13017, 12877, 58933, 72675}},
    {9954, 17, 35956, {1, 3, 5, 3, 27, 21, 107, 107, 325, 687, 587, 1557, 4913, 11869, 25131, 18879, 70075}},
    {9955, 17, 35963, {1, 3, 3, 1, 23, 15, 77, 19, 479, 847, 1697, 185, 1061, 5893, 14753, 12219, 51637}},
    {9956, 17, 35970, {1, 3, 3, 13, 5, 41, 123, 177, 429, 1017, 1797, 2001, 2841, 8721, 801, 28153, 122887}},
    {9957, 17, 35984, {1, 1, 7, 9, 17, 41, 51, 9, 51, 379, 1941, 1823, 4731, 5143, 28733, 3749, 109361}},
    {9958, 17, 35996, {1, 3, 1, 1, 5, 39, 71, 237, 459, 235, 1881, 9, 3951, 14293, 25441, 27505, 128047}},
    {9959, 17, 36005, {1, 3, 1, 15, 25, 47, 95, 169, 105, 531, 365, 647, 2983, 8905, 26727, 37695, 119619}},
    {9960, 17, 36012, {1, 1, 1, 9, 29, 9, 111, 73, 311, 461, 1763, 3203, 7121, 14897, 1885, 31243, 77033}},
    {9961, 17, 36015, {1, 1, 7, 1, 17, 13, 63, 159, 389, 959, 1279, 1543, 7317, 5313, 25009, 12099, 80063}},
    {9962, 17, 36030, {1, 3, 1, 9, 15, 13, 53, 127, 357, 681, 1017, 3131, 2453, 13955, 2841, 32607, 85051}},
    {9963, 17, 36035, {1, 1, 1, 5, 5, 5, 5, 95, 355, 685, 955, 1293, 43, 12261, 23029, 25779, 34693}},
    {9964, 17, 36042, {1, 3, 5, 5, 21, 61, 23, 47, 297, 517, 1973, 3265, 3087, 15087, 23989, 57285, 116915}},
    {9965, 17, 36047, {1, 1, 3, 5, 5, 59, 39, 149, 387, 3, 949, 199, 5335, 6039, 12571, 20083, 59841}},
    {9966, 17, 36049, {1, 1, 1, 9, 3, 15, 29, 99, 499, 493, 53, 2371, 3429, 2701, 9825, 39271, 3529}},
    {9967, 17, 36059, {1, 3, 5, 1, 17, 59, 1, 91, 385, 561, 1161, 2317, 1855, 9907, 13695, 15857, 4437}},
    {9968, 17, 36071, {1, 3, 7, 1, 21, 7, 105, 43, 69, 811, 713, 4021, 3169, 9187, 24387, 27351, 11697}},
    {9969, 17, 36080, {1, 3, 1, 13, 23, 3, 121, 41, 81, 353, 1003, 875, 3785, 8353, 25749, 54153, 28335}},
    {9970, 17, 36085, {1, 1, 7, 7, 25, 27, 105, 135, 109, 969, 1813, 799, 8117, 7227, 25745, 56661, 43071}},
    {9971, 17, 36097, {1, 3, 3, 9, 17, 45, 75, 231, 307, 831, 1311, 2675, 5519, 11789, 16955, 58757, 124875}},
    {9972, 17, 36110, {1, 3, 3, 1, 7, 43, 59, 51, 349, 361, 1303, 2947, 2811, 823, 27089, 60225, 65621}},
    {9973, 17, 36115, {1, 3, 1, 1, 5, 11, 107, 177, 97, 919, 861, 3587, 461, 3449, 30299, 56873, 88073}},
    {9974, 17, 36118, {1, 1, 5, 1, 15, 43, 87, 117, 347, 535, 1195, 4007, 3855, 10617, 181, 36127, 53067}},
    {9975, 17, 36124, {1, 1, 7, 1, 9, 53, 121, 147, 339, 479, 1103, 3405, 6293, 13913, 22753, 63219, 114581}},
    {9976, 17, 36137, {1, 1, 3, 11, 7, 21, 117, 11, 9, 971, 1367, 421, 1089, 6023, 30743, 55887, 8709}},
    {9977, 17, 36138, {1, 3, 5, 3, 3, 17, 53, 59, 357, 725, 1141, 1131, 2559, 14931, 8385, 21185, 17611}},
    {9978, 17, 36155, {1, 3, 1, 1, 25, 29, 63, 31, 47, 501, 237, 1659, 1573, 7203, 27885, 929, 16193}},
    {9979, 17, 36160, {1, 3, 7, 11, 15, 17, 111, 35, 389, 789, 957, 3071, 3683, 15373, 20489, 19473, 113397}},
    {9980, 17, 36189, {1, 1, 5, 7, 19, 55, 35, 87, 29, 305, 1467, 3991, 229, 11059, 4453, 48733, 43587}},
    {9981, 17, 36190, {1, 1, 3, 9, 15, 13, 49, 95, 145, 461, 1009, 1365, 2035, 1565, 27477, 34083, 112001}},
    {9982, 17, 36203, {1, 3, 3, 9, 1, 35, 89, 237, 95, 1021, 1845, 2465, 51, 11345, 15243, 50477, 106335}},
    {9983, 17, 36211, {1, 1, 1, 13, 21, 37, 37, 147, 433, 835, 651, 401, 7323, 13809, 27045, 63155, 28537}},
    {9984, 17, 36218, {1, 1, 7, 7, 17, 27, 37, 157, 505, 485, 897, 4063, 2627, 6857, 23823, 27659, 68481}},
    {9985, 17, 36230, {1, 3, 3, 9, 17, 5, 1, 205, 411, 445, 5, 2989, 247, 4117, 24353, 57983, 45263}},
    {9986, 17, 36241, {1, 3, 3, 11, 23, 45, 31, 99, 335, 937, 349, 2189, 6535, 13591, 14395, 58535, 113411}},
    {9987, 17, 36244, {1, 1, 7, 7, 15, 3, 113, 189, 333, 83, 1793, 1901, 473, 7973, 31689, 6883, 114677}},
    {9988, 17, 36253, {1, 3, 7, 1, 29, 9, 57, 29, 195, 301, 131, 3783, 4041, 11845, 8879, 39859, 75915}},
    {9989, 17, 36257, {1, 1, 7, 5, 21, 25, 85, 51, 501, 147, 1643, 765, 329, 15437, 25545, 48523, 114089}},
    {9990, 17, 36264, {1, 1, 1, 15, 21, 3, 123, 169, 393, 39, 1583, 3973, 4243, 10811, 15029, 19707, 41651}},
    {9991, 17, 36272, {1, 3, 7, 11, 19, 49, 23, 45, 399, 285, 1609, 371, 7297, 289, 23247, 30655, 11101}},
    {9992, 17, 36290, {1, 1, 7, 1, 25, 47, 73, 73, 347, 203, 155, 1133, 7087, 5, 25233, 33297, 50269}},
    {9993, 17, 36292, {1, 3, 1, 3, 13, 57, 125, 41, 467, 73, 1097, 3533, 3221, 12227, 20019, 27319, 29725}},
    {9994, 17, 36301, {1, 3, 3, 7, 21, 19, 101, 149, 79, 821, 1881, 2023, 1323, 12943, 32733, 2371, 125757}},
    {9995, 17, 36309, {1, 3, 1, 9, 11, 17, 25, 89, 507, 455, 875, 2139, 4359, 3385, 23459, 25129, 2757}},
    {9996, 17, 36313, {1, 3, 3, 9, 25, 33, 15, 79, 269, 97, 1913, 2433, 4515, 3677, 16789, 24675, 57983}},
    {9997, 17, 36316, {1, 1, 7, 13, 21, 21, 51, 71, 401, 883, 1185, 3625, 6657, 12195, 16509, 60269, 67187}},
    {9998, 17, 36319, {1, 1, 3, 9, 15, 23, 21, 173, 387, 889, 1261, 3375, 2957, 6467, 31111, 17207, 107807}},
    {9999, 17, 36330, {1, 3, 5, 13, 7, 35, 87, 43, 439, 809, 1027, 3681, 7861, 10835, 11057, 9943, 10777}},
    {10000, 17, 36335, {1, 1, 5, 7, 29, 37, 97, 235, 43, 557, 1133, 2827, 8057, 2229, 2357, 435, 109501}},
    {10001, 17, 36347, {1, 3, 3, 9, 5, 19, 43, 165, 385, 243, 1985, 3413, 4683, 149, 13877, 35527, 77321}},
    {10002, 17, 36353, {1, 3, 3, 13, 17, 5, 111, 101, 189, 401, 1609, 1757, 2435, 10719, 14007, 51101, 82737}},
    {10003, 17, 36356, {1, 3, 3, 11, 21, 55, 73, 27, 3, 223, 1461, 87, 6437, 10073, 20041, 49531, 82791}},
    {10004, 17, 36368, {1, 3, 3, 7, 3, 57, 29, 223, 205, 83, 1797, 3009, 661, 7713, 26925, 45159, 23887}},
    {10005, 17, 36374, {1, 3, 3, 15, 15, 3, 1, 221, 121, 881, 929, 2179, 2997, 15873, 1677, 23247, 25315}},
    {10006, 17, 36377, {1, 3, 5, 13, 21, 51, 19, 227, 21, 263, 503, 117, 7303, 14993, 26441, 26305, 4273}},
    {10007, 17, 36384, {1, 1, 5, 13, 27, 43, 39, 115, 365, 209, 1845, 2045, 777, 16085, 13245, 27067, 61461}},
    {10008, 17, 36407, {1, 1, 7, 5, 23, 61, 47, 211, 295, 639, 1879, 3303, 7141, 9149, 1717, 61057, 58593}},
    {10009, 17, 36413, {1, 1, 3, 9, 29, 23, 105, 83, 305, 963, 1651, 3723, 4009, 2293, 29635, 4535, 51541}},
    {10010, 17, 36419, {1, 3, 3, 1, 25, 43, 69, 63, 239, 353, 1481, 1055, 4759, 6467, 29589, 11883, 4985}},
    {10011, 17, 36425, {1, 1, 3, 13, 13, 51, 23, 135, 75, 379, 1671, 301, 545, 5, 18595, 55871, 13739}},
    {10012, 17, 36426, {1, 3, 7, 7, 17, 17, 53, 101, 211, 753, 1473, 2827, 3771, 2533, 5555, 1407, 4531}},
    {10013, 17, 36446, {1, 3, 7, 13, 29, 29, 63, 19, 301, 391, 1247, 2687, 7619, 15141, 13043, 45775, 112277}},
    {10014, 17, 36461, {1, 3, 3, 3, 11, 53, 109, 111, 361, 57, 217, 2585, 6671, 3811, 9007, 20331, 49647}},
    {10015, 17, 36467, {1, 1, 1, 7, 1, 23, 117, 91, 35, 185, 2003, 3449, 1369, 10019, 25605, 19665, 89875}},
    {10016, 17, 36474, {1, 1, 1, 13, 11, 51, 25, 199, 327, 635, 1813, 3803, 263, 11079, 5491, 36351, 107311}},
    {10017, 17, 36480, {1, 1, 7, 11, 11, 11, 41, 69, 449, 1013, 333, 2989, 1177, 129, 25473, 63021, 31849}},
    {10018, 17, 36486, {1, 3, 1, 1, 5, 39, 1, 209, 387, 787, 233, 2201, 4325, 14445, 24113, 44945, 113383}},
    {10019, 17, 36489, {1, 1, 5, 1, 27, 13, 17, 157, 487, 773, 383, 957, 3195, 5793, 23335, 35011, 55289}},
    {10020, 17, 36495, {1, 3, 5, 7, 3, 13, 45, 19, 49, 821, 811, 3633, 7611, 10035, 77, 34677, 107709}},
    {10021, 17, 36525, {1, 1, 5, 9, 27, 47, 41, 109, 19, 629, 1445, 1303, 3117, 4455, 22815, 27033, 65465}},
    {10022, 17, 36526, {1, 1, 7, 7, 25, 35, 29, 125, 83, 529, 95, 1567, 5835, 9157, 17533, 24367, 52783}},
    {10023, 17, 36533, {1, 1, 1, 7, 25, 1, 121, 83, 479, 305, 1941, 2173, 1097, 7675, 23393, 19261, 33673}},
    {10024, 17, 36534, {1, 3, 7, 9, 13, 57, 127, 37, 137, 885, 973, 3353, 6789, 5113, 11741, 4389, 93357}},
    {10025, 17, 36540, {1, 3, 7, 11, 11, 41, 111, 79, 77, 573, 1553, 1157, 6881, 4365, 17155, 9275, 16693}},
    {10026, 17, 36555, {1, 1, 7, 7, 31, 51, 71, 29, 113, 749, 147, 1219, 7061, 15205, 4605, 41479, 86627}},
    {10027, 17, 36563, {1, 3, 3, 9, 3, 57, 55, 127, 387, 479, 195, 2019, 6257, 3427, 26131, 26077, 31265}},
    {10028, 17, 36565, {1, 3, 7, 7, 23, 53, 35, 3, 425, 831, 1829, 177, 2447, 2847, 11861, 187, 36941}},
    {10029, 17, 36588, {1, 3, 5, 11, 3, 13, 89, 51, 63, 373, 1009, 2633, 1341, 11369, 7829, 58229, 114597}},
    {10030, 17, 36593, {1, 3, 7, 5, 23, 51, 87, 245, 301, 875, 1759, 1853, 1423, 2681, 767, 25311, 11827}},
    {10031, 17, 36596, {1, 3, 7, 5, 25, 9, 119, 49, 63, 475, 1019, 3759, 5249, 9275, 15849, 19935, 74515}},
    {10032, 17, 36606, {1, 3, 5, 15, 9, 3, 41, 67, 467, 609, 203, 1971, 4541, 4801, 27347, 60783, 9681}},
    {10033, 17, 36614, {1, 1, 3, 15, 29, 43, 93, 61, 449, 389, 1253, 2093, 6847, 13663, 27851, 26163, 60755}},
    {10034, 17, 36626, {1, 3, 3, 13, 11, 47, 47, 87, 101, 515, 441, 2645, 7123, 11787, 9107, 57777, 36063}},
    {10035, 17, 36628, {1, 1, 1, 3, 27, 35, 79, 229, 293, 619, 1943, 3765, 5439, 16093, 9447, 57335, 32555}},
    {10036, 17, 36641, {1, 1, 5, 13, 31, 59, 47, 229, 399, 623, 1787, 2157, 7135, 14251, 21417, 27929, 28441}},
    {10037, 17, 36642, {1, 1, 5, 7, 11, 49, 89, 243, 93, 967, 1351, 1323, 7427, 2655, 15335, 50717, 48895}},
    {10038, 17, 36651, {1, 1, 5, 13, 15, 37, 105, 61, 71, 471, 1005, 3781, 4261, 1083, 3469, 54321, 50023}},
    {10039, 17, 36653, {1, 1, 7, 9, 19, 61, 45, 217, 465, 765, 1027, 2743, 653, 6523, 5889, 60619, 62139}},
    {10040, 17, 36673, {1, 3, 7, 11, 21, 15, 17, 73, 53, 539, 1153, 3231, 5343, 6485, 28591, 19359, 61213}},
    {10041, 17, 36676, {1, 1, 5, 13, 23, 15, 95, 155, 25, 549, 9, 2445, 847, 3075, 24169, 44887, 115699}},
    {10042, 17, 36679, {1, 1, 5, 1, 7, 61, 19, 133, 229, 341, 1417, 2359, 343, 2973, 11429, 32367, 27849}},
    {10043, 17, 36694, {1, 1, 1, 9, 15, 55, 73, 183, 17, 11, 1775, 3807, 605, 13637, 2553, 3381, 121563}},
    {10044, 17, 36698, {1, 3, 7, 7, 7, 63, 53, 237, 91, 279, 539, 539, 7841, 11085, 12527, 41639, 49797}},
    {10045, 17, 36704, {1, 3, 1, 15, 21, 17, 71, 39, 227, 165, 2029, 1135, 7195, 3599, 27061, 64841, 98267}},
    {10046, 17, 36714, {1, 3, 1, 15, 15, 29, 67, 131, 387, 975, 2015, 2095, 3817, 12147, 701, 6795, 11225}},
    {10047, 17, 36721, {1, 1, 1, 1, 11, 3, 55, 101, 275, 457, 1279, 1383, 7933, 4093, 3287, 36933, 16325}},
    {10048, 17, 36722, {1, 1, 5, 9, 19, 49, 83, 113, 499, 367, 567, 2525, 5497, 2965, 4317, 45797, 83149}},
    {10049, 17, 36727, {1, 1, 5, 11, 7, 59, 99, 173, 297, 225, 1957, 867, 969, 5211, 4897, 275, 30171}},
    {10050, 17, 36749, {1, 1, 1, 11, 1, 57, 95, 83, 335, 255, 657, 2461, 4631, 14799, 22089, 46137, 36449}},
    {10051, 17, 36758, {1, 1, 1, 13, 3, 1, 49, 19, 137, 719, 949, 1537, 2253, 13191, 19551, 41293, 3333}},
    {10052, 17, 36761, {1, 3, 3, 7, 23, 37, 19, 1, 387, 499, 847, 293, 1891, 15765, 23195, 49749, 85995}},
    {10053, 17, 36771, {1, 3, 7, 11, 15, 53, 23, 143, 87, 257, 1113, 1419, 1735, 13023, 17723, 35, 66515}},
    {10054, 17, 36788, {1, 3, 5, 9, 9, 61, 97, 245, 443, 503, 1897, 1957, 59, 15341, 20311, 57947, 60213}},
    {10055, 17, 36797, {1, 1, 5, 15, 23, 11, 1, 115, 195, 37, 573, 373, 6187, 63, 20985, 32899, 125135}},
    {10056, 17, 36805, {1, 1, 7, 13, 1, 59, 81, 1, 121, 167, 1839, 1051, 5873, 13241, 31423, 4465, 103873}},
    {10057, 17, 36830, {1, 3, 1, 15, 3, 37, 53, 211, 325, 915, 305, 2031, 5227, 15041, 5309, 2335, 28475}},
    {10058, 17, 36833, {1, 3, 7, 5, 3, 43, 109, 169, 511, 947, 963, 1265, 1867, 8439, 12763, 17209, 62959}},
    {10059, 17, 36839, {1, 1, 3, 9, 3, 25, 3, 55, 269, 87, 251, 3005, 3539, 2397, 16187, 61041, 120715}},
    {10060, 17, 36843, {1, 3, 1, 1, 23, 23, 13, 231, 477, 19, 1313, 1065, 6755, 10711, 21115, 63893, 52939}},
    {10061, 17, 36860, {1, 1, 7, 1, 25, 27, 127, 37, 489, 677, 1857, 2853, 6691, 14447, 25243, 61797, 109587}},
    {10062, 17, 36866, {1, 3, 5, 9, 13, 7, 85, 231, 281, 1015, 829, 1659, 2259, 10725, 22391, 55987, 58811}},
    {10063, 17, 36871, {1, 1, 7, 9, 13, 33, 51, 101, 107, 195, 255, 3893, 3939, 14219, 25995, 63501, 96483}},
    {10064, 17, 36875, {1, 3, 5, 15, 13, 17, 115, 195, 341, 97, 995, 641, 2373, 10921, 30971, 57463, 16657}},
    {10065, 17, 36877, {1, 3, 7, 3, 17, 57, 121, 147, 423, 925, 961, 3837, 7551, 12065, 13783, 35679, 51365}},
    {10066, 17, 36880, {1, 3, 5, 11, 19, 27, 35, 179, 441, 397, 603, 2935, 7741, 2041, 30259, 9589, 113541}},
    {10067, 17, 36892, {1, 3, 5, 3, 27, 13, 79, 91, 83, 579, 203, 683, 3163, 8391, 4849, 64795, 26011}},
    {10068, 17, 36911, {1, 3, 7, 7, 31, 33, 31, 121, 17, 871, 1563, 1673, 2587, 11209, 1633, 27517, 76227}},
    {10069, 17, 36914, {1, 1, 7, 1, 15, 31, 79, 37, 217, 829, 1439, 1885, 2517, 3375, 3521, 44845, 119393}},
    {10070, 17, 36916, {1, 3, 5, 13, 25, 25, 77, 89, 331, 471, 1323, 353, 3409, 6953, 17551, 36643, 100673}},
    {10071, 17, 36923, {1, 1, 3, 5, 25, 11, 65, 57, 301, 695, 221, 2313, 7423, 5879, 32453, 14197, 89303}},
    {10072, 17, 36940, {1, 3, 1, 7, 11, 61, 59, 219, 273, 931, 1311, 1203, 6965, 3479, 26721, 40719, 62397}},
    {10073, 17, 36943, {1, 1, 5, 13, 23, 9, 101, 173, 261, 433, 1375, 2721, 1587, 12531, 20877, 17275, 68839}},
    {10074, 17, 36948, {1, 3, 7, 5, 15, 45, 89, 157, 129, 623, 1307, 3493, 3383, 11561, 28771, 50823, 50099}},
    {10075, 17, 36957, {1, 3, 7, 5, 3, 41, 103, 55, 193, 361, 1421, 2239, 6049, 2245, 26757, 64233, 3933}},
    {10076, 17, 36958, {1, 1, 5, 9, 11, 15, 115, 195, 17, 743, 2005, 3345, 5753, 14603, 29229, 11199, 58937}},
    {10077, 17, 36967, {1, 3, 7, 3, 31, 61, 43, 177, 485, 711, 79, 3387, 8065, 5135, 5421, 35607, 32783}},
    {10078, 17, 36974, {1, 3, 1, 11, 29, 61, 73, 93, 157, 405, 1843, 1125, 7071, 4009, 16643, 21253, 117935}},
    {10079, 17, 36981, {1, 1, 3, 1, 15, 21, 83, 105, 123, 297, 309, 2275, 763, 9069, 28451, 32729, 124591}},
    {10080, 17, 37001, {1, 1, 7, 11, 13, 51, 35, 7, 485, 905, 465, 163, 1007, 5923, 13559, 5575, 102755}},
    {10081, 17, 37012, {1, 3, 7, 7, 3, 57, 69, 217, 209, 341, 1591, 3151, 3575, 1787, 30335, 44377, 82517}},
    {10082, 17, 37015, {1, 1, 3, 15, 7, 37, 121, 77, 97, 99, 1499, 349, 4205, 16229, 31279, 32539, 18057}},
    {10083, 17, 37019, {1, 1, 7, 11, 23, 59, 83, 77, 11, 413, 1379, 3875, 851, 10949, 24169, 24495, 27945}},
    {10084, 17, 37035, {1, 1, 3, 9, 23, 1, 9, 239, 343, 37, 229, 751, 7525, 7333, 11653, 10529, 122991}},
    {10085, 17, 37040, {1, 3, 3, 9, 23, 3, 69, 129, 179, 519, 1949, 2933, 439, 9925, 12635, 18005, 3009}},
    {10086, 17, 37063, {1, 3, 1, 13, 17, 1, 109, 43, 313, 865, 1713, 3329, 167, 6203, 14915, 40173, 83181}},
    {10087, 17, 37064, {1, 1, 1, 9, 3, 29, 43, 101, 445, 295, 269, 3637, 7333, 10677, 14777, 44203, 36491}},
    {10088, 17, 37069, {1, 1, 3, 1, 29, 47, 49, 157, 99, 1015, 525, 2265, 4217, 1493, 21367, 28015, 115923}},
    {10089, 17, 37077, {1, 1, 3, 11, 31, 15, 19, 85, 491, 23, 283, 139, 3715, 2197, 7563, 50881, 29255}},
    {10090, 17, 37093, {1, 3, 3, 9, 27, 29, 123, 193, 417, 509, 531, 1969, 2627, 15557, 30429, 61599, 91847}},
    {10091, 17, 37097, {1, 3, 5, 11, 1, 21, 109, 177, 427, 303, 303, 1215, 3, 2745, 17931, 49221, 92711}},
    {10092, 17, 37106, {1, 1, 3, 1, 27, 5, 103, 183, 453, 811, 1051, 769, 8121, 10643, 1633, 30395, 4625}},
    {10093, 17, 37115, {1, 1, 3, 15, 11, 3, 127, 57, 501, 849, 1355, 19, 1083, 2143, 10763, 32603, 79497}},
    {10094, 17, 37118, {1, 1, 7, 9, 21, 51, 61, 87, 29, 281, 1159, 469, 6935, 1587, 21883, 16245, 126065}},
    {10095, 17, 37123, {1, 1, 1, 13, 27, 15, 31, 47, 325, 125, 1275, 2417, 1633, 12669, 4149, 23085, 99825}},
    {10096, 17, 37129, {1, 3, 5, 13, 31, 25, 93, 235, 453, 61, 1051, 1121, 1241, 11843, 25947, 7881, 119051}},
    {10097, 17, 37130, {1, 3, 7, 13, 13, 17, 19, 175, 175, 407, 1119, 781, 7891, 10293, 30503, 45905, 111399}},
    {10098, 17, 37135, {1, 1, 1, 11, 19, 39, 59, 17, 475, 669, 323, 3627, 8087, 1057, 25691, 26351, 128137}},
    {10099, 17, 37137, {1, 3, 5, 9, 5, 61, 79, 241, 85, 543, 215, 887, 4977, 3797, 8469, 35043, 79153}},
    {10100, 17, 37138, {1, 3, 7, 13, 11, 45, 45, 75, 177, 537, 1197, 1721, 8013, 13659, 19085, 17365, 83679}},
    {10101, 17, 37140, {1, 3, 5, 15, 17, 15, 107, 33, 57, 1009, 577, 3755, 8055, 15965, 5447, 979, 7737}},
    {10102, 17, 37144, {1, 3, 7, 7, 15, 19, 61, 225, 75, 195, 457, 1881, 6865, 9037, 12353, 24127, 50881}},
    {10103, 17, 37149, {1, 1, 1, 9, 11, 39, 3, 173, 67, 403, 55, 2227, 1407, 1003, 1725, 33271, 128721}},
    {10104, 17, 37156, {1, 3, 5, 3, 21, 17, 31, 99, 275, 327, 879, 2939, 1529, 9589, 803, 30549, 118977}},
    {10105, 17, 37159, {1, 3, 3, 1, 17, 43, 1, 195, 205, 979, 679, 699, 6903, 5637, 9411, 22843, 8879}},
    {10106, 17, 37163, {1, 3, 1, 5, 27, 29, 25, 145, 433, 723, 1185, 1283, 197, 3389, 3761, 24925, 60855}},
    {10107, 17, 37165, {1, 1, 3, 1, 15, 35, 127, 151, 327, 903, 641, 1507, 5, 1269, 29599, 10273, 38277}},
    {10108, 17, 37183, {1, 1, 5, 5, 3, 21, 111, 167, 41, 467, 803, 773, 2149, 12889, 10659, 50465, 94233}},
    {10109, 17, 37185, {1, 1, 7, 1, 17, 33, 99, 209, 351, 65, 1857, 2367, 1775, 7727, 15059, 37541, 125893}},
    {10110, 17, 37195, {1, 3, 5, 3, 11, 17, 47, 91, 115, 229, 1047, 3613, 1339, 13261, 1613, 21971, 47863}},
    {10111, 17, 37198, {1, 1, 1, 1, 11, 13, 47, 25, 229, 653, 873, 3335, 6773, 3889, 11975, 51977, 118725}},
    {10112, 17, 37203, {1, 1, 7, 5, 13, 57, 103, 101, 465, 291, 467, 2379, 7633, 14915, 2743, 32483, 71265}},
    {10113, 17, 37212, {1, 3, 3, 7, 19, 31, 125, 225, 73, 907, 1351, 3213, 6281, 1257, 20769, 45375, 8631}},
    {10114, 17, 37233, {1, 1, 1, 3, 19, 51, 117, 83, 495, 269, 939, 453, 7927, 6321, 12261, 20355, 40737}},
    {10115, 17, 37236, {1, 1, 7, 15, 5, 11, 107, 209, 503, 333, 1317, 2419, 2291, 1835, 17773, 54467, 54355}},
    {10116, 17, 37240, {1, 1, 7, 13, 7, 55, 49, 193, 271, 821, 103, 2551, 4089, 7225, 17055, 37139, 114215}},
    {10117, 17, 37256, {1, 1, 3, 15, 13, 21, 109, 75, 159, 711, 645, 3363, 2595, 6665, 411, 21815, 121545}},
    {10118, 17, 37264, {1, 3, 1, 3, 11, 31, 31, 175, 277, 537, 2035, 2649, 4629, 4765, 17291, 58759, 10223}},
    {10119, 17, 37267, {1, 1, 7, 3, 9, 21, 57, 181, 285, 667, 109, 3247, 6881, 3713, 3667, 33743, 105161}},
    {10120, 17, 37273, {1, 3, 5, 5, 1, 63, 51, 69, 293, 519, 1297, 3073, 7659, 829, 25307, 2187, 32613}},
    {10121, 17, 37295, {1, 1, 5, 9, 11, 57, 29, 193, 427, 709, 1429, 1185, 4341, 5917, 2441, 53145, 32039}},
    {10122, 17, 37315, {1, 1, 1, 7, 29, 55, 11, 71, 283, 223, 1999, 2597, 5887, 5097, 29055, 21741, 65855}},
    {10123, 17, 37330, {1, 3, 3, 7, 13, 31, 101, 211, 323, 85, 961, 2833, 4357, 1745, 14945, 7077, 104591}},
    {10124, 17, 37336, {1, 1, 3, 11, 17, 39, 125, 27, 327, 281, 87, 2341, 433, 15277, 20541, 44881, 107773}},
    {10125, 17, 37339, {1, 3, 1, 15, 31, 7, 91, 63, 349, 103, 1101, 1049, 6527, 15471, 9253, 58841, 95553}},
    {10126, 17, 37342, {1, 3, 1, 11, 9, 33, 15, 215, 141, 317, 1405, 1811, 7617, 3311, 24845, 7629, 445}},
    {10127, 17, 37357, {1, 3, 3, 3, 13, 27, 27, 123, 7, 101, 1509, 2789, 3833, 16205, 24905, 29453, 106435}},
    {10128, 17, 37365, {1, 3, 1, 13, 5, 51, 47, 87, 483, 791, 921, 4079, 6607, 14077, 1297, 41961, 86579}},
    {10129, 17, 37372, {1, 3, 7, 3, 9, 23, 83, 227, 321, 397, 1483, 1857, 7191, 9211, 4511, 7547, 82415}},
    {10130, 17, 37381, {1, 1, 7, 13, 15, 43, 47, 135, 211, 497, 1827, 2493, 2475, 2011, 25013, 44627, 13675}},
    {10131, 17, 37399, {1, 3, 3, 11, 23, 47, 73, 199, 467, 111, 27, 209, 6941, 8929, 6413, 3329, 97825}},
    {10132, 17, 37416, {1, 1, 1, 13, 31, 49, 67, 199, 229, 935, 791, 141, 2829, 11861, 9791, 15445, 17437}},
    {10133, 17, 37429, {1, 1, 5, 7, 17, 25, 47, 23, 313, 59, 371, 3865, 5767, 6461, 2973, 10165, 48247}},
    {10134, 17, 37436, {1, 3, 7, 3, 25, 47, 37, 51, 371, 101, 249, 91, 3985, 10239, 10423, 33433, 109067}},
    {10135, 17, 37442, {1, 3, 1, 3, 27, 33, 67, 75, 167, 961, 493, 1875, 4005, 13019, 27085, 17967, 107771}},
    {10136, 17, 37451, {1, 1, 1, 3, 17, 23, 37, 179, 459, 907, 55, 2049, 5273, 4059, 30429, 10273, 70159}},
    {10137, 17, 37453, {1, 1, 5, 9, 13, 33, 71, 143, 325, 767, 1871, 3989, 7991, 3555, 28937, 48259, 60243}},
    {10138, 17, 37475, {1, 1, 1, 9, 25, 27, 111, 43, 265, 11, 1443, 3161, 3473, 1451, 3789, 42431, 117069}},
    {10139, 17, 37482, {1, 1, 1, 1, 29, 1, 121, 25, 501, 781, 1429, 1495, 6125, 11293, 30063, 1713, 7071}},
    {10140, 17, 37489, {1, 1, 3, 15, 23, 27, 15, 145, 255, 207, 1977, 567, 469, 11589, 1535, 61637, 89569}},
    {10141, 17, 37490, {1, 3, 5, 5, 13, 45, 113, 215, 65, 531, 335, 1275, 53, 447, 24887, 29829, 33391}},
    {10142, 17, 37523, {1, 1, 1, 3, 5, 55, 89, 97, 197, 467, 95, 2603, 7789, 13289, 29911, 21935, 122947}},
    {10143, 17, 37525, {1, 1, 3, 11, 21, 3, 61, 9, 363, 417, 1027, 2457, 3169, 11207, 27551, 41991, 71381}},
    {10144, 17, 37530, {1, 3, 5, 11, 19, 57, 107, 29, 249, 93, 1235, 1239, 6491, 14695, 2407, 41513, 25779}},
    {10145, 17, 37535, {1, 1, 3, 13, 5, 43, 3, 247, 309, 553, 1349, 2693, 7609, 10099, 13021, 32371, 27705}},
    {10146, 17, 37539, {1, 1, 3, 11, 7, 3, 37, 209, 153, 945, 459, 3281, 6749, 12267, 17103, 58285, 115593}},
    {10147, 17, 37548, {1, 3, 1, 3, 19, 19, 113, 23, 363, 147, 203, 1673, 4005, 4983, 31463, 12695, 95089}},
    {10148, 17, 37559, {1, 3, 5, 9, 3, 31, 77, 129, 217, 395, 1701, 15, 8181, 2327, 12441, 52889, 114339}},
    {10149, 17, 37560, {1, 1, 1, 15, 5, 7, 81, 191, 45, 45, 903, 2561, 1303, 13435, 321, 41897, 79013}},
    {10150, 17, 37566, {1, 3, 3, 13, 19, 33, 11, 67, 9, 649, 217, 2181, 2237, 2851, 7423, 37003, 119205}},
    {10151, 17, 37597, {1, 3, 7, 11, 29, 5, 87, 117, 487, 693, 155, 3653, 1497, 10249, 31567, 5987, 59435}},
    {10152, 17, 37601, {1, 3, 7, 5, 11, 5, 77, 251, 399, 257, 1429, 3487, 8097, 1919, 11635, 3833, 43577}},
    {10153, 17, 37602, {1, 1, 7, 11, 21, 63, 83, 17, 83, 807, 1849, 639, 7453, 15427, 2617, 21403, 4131}},
    {10154, 17, 37604, {1, 1, 7, 15, 19, 1, 43, 245, 89, 271, 635, 227, 5977, 6985, 3239, 44639, 50959}},
    {10155, 17, 37616, {1, 3, 7, 1, 19, 25, 35, 41, 455, 919, 101, 1953, 6119, 15299, 16315, 58857, 107557}},
    {10156, 17, 37622, {1, 1, 5, 5, 3, 27, 123, 81, 355, 327, 1645, 1439, 3497, 3133, 17, 7225, 83255}},
    {10157, 17, 37658, {1, 1, 1, 15, 29, 31, 61, 15, 157, 161, 1751, 2687, 3539, 5695, 149, 8841, 23405}},
    {10158, 17, 37660, {1, 1, 1, 15, 1, 27, 79, 231, 157, 275, 1687, 3083, 4547, 9929, 6181, 32653, 30727}},
    {10159, 17, 37667, {1, 1, 1, 1, 29, 51, 95, 133, 311, 675, 1829, 2089, 7681, 13119, 32157, 10651, 9023}},
    {10160, 17, 37684, {1, 3, 5, 11, 7, 11, 41, 137, 147, 623, 81, 253, 3159, 4501, 22465, 41047, 14253}},
    {10161, 17, 37693, {1, 1, 5, 15, 9, 29, 35, 63, 265, 691, 1371, 4061, 6327, 10671, 9303, 58831, 122423}},
    {10162, 17, 37694, {1, 3, 3, 13, 17, 43, 9, 173, 435, 805, 1679, 3261, 6681, 13295, 23511, 4575, 100573}},
    {10163, 17, 37696, {1, 1, 3, 15, 7, 11, 93, 227, 285, 795, 1089, 927, 2187, 927, 4283, 29241, 75241}},
    {10164, 17, 37706, {1, 1, 1, 7, 13, 7, 71, 167, 239, 411, 235, 1543, 5259, 9749, 4257, 30517, 18167}},
    {10165, 17, 37711, {1, 1, 7, 7, 29, 37, 67, 245, 151, 627, 1245, 2967, 7821, 1113, 3243, 59403, 80303}},
    {10166, 17, 37730, {1, 1, 5, 13, 31, 15, 9, 49, 81, 257, 31, 227, 201, 2127, 30581, 38487, 96959}},
    {10167, 17, 37735, {1, 1, 5, 5, 21, 39, 61, 155, 47, 235, 355, 3397, 2973, 1029, 23497, 21007, 35183}},
    {10168, 17, 37742, {1, 1, 3, 5, 7, 27, 87, 45, 89, 211, 519, 2621, 6299, 2049, 21225, 4975, 8799}},
    {10169, 17, 37744, {1, 3, 5, 11, 7, 51, 19, 33, 153, 925, 1067, 3789, 7463, 8403, 1495, 37549, 20661}},
    {10170, 17, 37759, {1, 1, 5, 1, 21, 53, 97, 147, 435, 329, 1635, 3069, 3353, 3969, 15555, 7171, 58141}},
    {10171, 17, 37777, {1, 1, 1, 5, 31, 29, 103, 87, 89, 673, 1505, 2921, 3019, 3081, 7723, 11105, 7477}},
    {10172, 17, 37783, {1, 1, 7, 5, 17, 15, 111, 15, 59, 851, 1351, 2365, 2427, 5035, 22341, 38511, 61813}},
    {10173, 17, 37784, {1, 3, 5, 9, 21, 15, 35, 11, 149, 991, 981, 3855, 2783, 10405, 21113, 64173, 75199}},
    {10174, 17, 37793, {1, 3, 5, 7, 19, 25, 99, 11, 101, 71, 1913, 1017, 4241, 15635, 15571, 33541, 79103}},
    {10175, 17, 37800, {1, 3, 7, 9, 13, 19, 67, 75, 57, 257, 1623, 3641, 1745, 12747, 7171, 20861, 106387}},
    {10176, 17, 37818, {1, 3, 1, 3, 9, 43, 29, 125, 453, 525, 1789, 2281, 1037, 14799, 27183, 7235, 97467}},
    {10177, 17, 37823, {1, 3, 3, 15, 25, 19, 115, 73, 163, 557, 1365, 1205, 7845, 2977, 6293, 4039, 100505}},
    {10178, 17, 37825, {1, 3, 7, 15, 11, 43, 109, 181, 153, 809, 25, 773, 3265, 6919, 23835, 63627, 79707}},
    {10179, 17, 37828, {1, 3, 5, 13, 13, 9, 37, 209, 117, 49, 973, 2547, 2035, 7595, 15029, 9035, 83281}},
    {10180, 17, 37832, {1, 3, 7, 1, 1, 53, 77, 213, 137, 321, 2031, 3373, 4457, 15395, 3301, 11631, 30925}},
    {10181, 17, 37849, {1, 3, 5, 9, 21, 1, 39, 227, 1, 395, 1191, 1029, 6467, 11219, 32063, 1347, 98889}},
    {10182, 17, 37856, {1, 3, 5, 15, 21, 21, 49, 169, 289, 785, 151, 2309, 7475, 4065, 17553, 35213, 63947}},
    {10183, 17, 37861, {1, 1, 7, 13, 27, 1, 93, 245, 389, 211, 285, 1273, 6445, 4293, 53, 22689, 24989}},
    {10184, 17, 37862, {1, 3, 5, 13, 27, 27, 37, 217, 225, 271, 9, 2547, 3381, 1599, 459, 19337, 125349}},
    {10185, 17, 37886, {1, 3, 3, 5, 29, 45, 93, 239, 403, 985, 901, 3501, 1889, 15647, 25031, 6073, 14101}},
    {10186, 17, 37893, {1, 3, 1, 9, 21, 5, 77, 171, 197, 677, 1571, 3925, 4917, 14415, 20137, 39871, 125939}},
    {10187, 17, 37915, {1, 1, 5, 3, 3, 17, 19, 47, 499, 397, 667, 3373, 1771, 4453, 9519, 48939, 121915}},
    {10188, 17, 37922, {1, 3, 3, 5, 29, 25, 121, 133, 367, 281, 131, 1115, 6359, 9621, 31137, 58021, 27117}},
    {10189, 17, 37936, {1, 1, 3, 5, 23, 43, 45, 41, 261, 681, 1177, 2007, 5441, 1507, 11579, 54001, 69625}},
    {10190, 17, 37939, {1, 3, 1, 3, 27, 61, 85, 167, 275, 285, 1, 919, 6439, 3331, 9483, 46613, 89019}},
    {10191, 17, 37945, {1, 1, 7, 9, 25, 33, 37, 33, 211, 221, 273, 2257, 6565, 15801, 4911, 1781, 60147}},
    {10192, 17, 37956, {1, 3, 5, 7, 7, 17, 81, 215, 511, 565, 327, 3327, 1439, 1573, 8959, 30037, 95635}},
    {10193, 17, 37960, {1, 3, 5, 13, 23, 31, 75, 93, 421, 439, 2033, 2677, 593, 2729, 17641, 61789, 41253}},
    {10194, 17, 37971, {1, 1, 3, 11, 21, 17, 45, 63, 77, 497, 439, 4077, 4047, 273, 3233, 54695, 22013}},
    {10195, 17, 37980, {1, 3, 1, 7, 5, 17, 125, 29, 365, 887, 1915, 3455, 391, 9435, 14723, 34807, 52475}},
    {10196, 17, 38002, {1, 1, 7, 11, 29, 49, 71, 165, 491, 721, 627, 3777, 7295, 2549, 7521, 35637, 14447}},
    {10197, 17, 38007, {1, 3, 7, 13, 3, 3, 121, 193, 273, 241, 889, 13, 3445, 3313, 20381, 39921, 16609}},
    {10198, 17, 38018, {1, 3, 7, 13, 5, 49, 61, 123, 443, 769, 1669, 2741, 6881, 5965, 9365, 43051, 2979}},
    {10199, 17, 38020, {1, 1, 1, 7, 7, 25, 41, 179, 419, 225, 1827, 613, 4711, 1671, 14459, 33951, 56751}},
    {10200, 17, 38038, {1, 3, 5, 7, 9, 61, 35, 205, 243, 49, 803, 2653, 4101, 4435, 29697, 45441, 124841}}
    /* Extending this table?
       Ensure that the max_m defined in sobol_primitives.h is sufficient for all the m values */
};
