//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2020 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// Generated by src/tools/convbdf on Sun Mar 15 08:41:32 2020.
//============================================================================

#ifndef STELLA16X32T_FONT_DATA_HXX
#define STELLA16X32T_FONT_DATA_HXX

#include "Font.hxx"

/* Font information:
   name: ter-u32b
   facename: -xos4-Terminus-Bold-R-Normal--32-320-72-72-C-160-ISO10646-1
   w x h: 16x32
   bbx: 16 32 0 -6
   size: 95
   ascent: 26
   descent: 6
   first char: 32 (0x20)
   last char: 126 (0x7e)
   default char: 32 (0x20)
   proportional: no
   Copyright (C) 2014 Dimitar Toshkov Zhekov
*/

namespace GUI {

// Font character bitmap data.
static const uInt16 stella16x32t_font_bits[] = {  // NOLINT : too complicated to convert

/* Character 28 (0x1c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0000111110000000,
0b0001111111000000,
0b0011110111100000,
0b0011100011100000,
0b0011100011100000,
0b0011110111100000,
0b0001111111000000,
0b0000111110000000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 29 (0x1d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  ***  ***  *** |
   |  ***  ***  *** |
   |  ***  ***  *** |
   |  ***  ***  *** |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0011100111001110,
0b0011100111001110,
0b0011100111001110,
0b0011100111001110,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 30 (0x1e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 31 (0x1f):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |     *****      |
   |   *********    |
   |  ***********   |
   |  ***********   |
   | *************  |
   | *************  |
   | *************  |
   | *************  |
   | *************  |
   | *************  |
   |  ***********   |
   |  ***********   |
   |   *********    |
   |     *****      |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0000011111000000,
0b0001111111110000,
0b0011111111111000,
0b0011111111111000,
0b0111111111111100,
0b0111111111111100,
0b0111111111111100,
0b0111111111111100,
0b0111111111111100,
0b0111111111111100,
0b0011111111111000,
0b0011111111111000,
0b0001111111110000,
0b0000011111000000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 32 (0x20):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 33 (0x21):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 34 (0x22):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 35 (0x23):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   | *************  |
   | *************  |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   | *************  |
   | *************  |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x7ffc,
0x7ffc,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x7ffc,
0x7ffc,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 36 (0x24):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |   *********    |
   |  ***********   |
   | **** *** ****  |
   | ***  ***  ***  |
   | ***  ***       |
   | ***  ***       |
   | ***  ***       |
   | **** ***       |
   |  **********    |
   |   **********   |
   |      *** ****  |
   |      ***  ***  |
   |      ***  ***  |
   |      ***  ***  |
   | ***  ***  ***  |
   | **** *** ****  |
   |  ***********   |
   |   *********    |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x1ff0,
0x3ff8,
0x7bbc,
0x739c,
0x7380,
0x7380,
0x7380,
0x7b80,
0x3ff0,
0x1ff8,
0x03bc,
0x039c,
0x039c,
0x039c,
0x739c,
0x7bbc,
0x3ff8,
0x1ff0,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 37 (0x25):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *****   ***  |
   |  *******  ***  |
   |  *** *** ***   |
   |  *** *** ***   |
   |  **********    |
   |   ***** ***    |
   |        ***     |
   |        ***     |
   |       ***      |
   |       ***      |
   |      ***       |
   |      ***       |
   |     ***        |
   |     ***        |
   |    *** *****   |
   |    **********  |
   |   *** *** ***  |
   |   *** *** ***  |
   |  ***  *******  |
   |  ***   *****   |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1f1c,
0x3f9c,
0x3bb8,
0x3bb8,
0x3ff0,
0x1f70,
0x00e0,
0x00e0,
0x01c0,
0x01c0,
0x0380,
0x0380,
0x0700,
0x0700,
0x0ef8,
0x0ffc,
0x1ddc,
0x1ddc,
0x39fc,
0x38f8,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 38 (0x26):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |    ******      |
   |   ********     |
   |  ***    ***    |
   |  ***    ***    |
   |  ***    ***    |
   |  ***    ***    |
   |  ***    ***    |
   |   ***  ***     |
   |    ******      |
   |    *****       |
   |   *******  *** |
   |  ***   *** *** |
   | ***     *****  |
   | ***      ***   |
   | ***      ***   |
   | ***      ***   |
   | ***      ***   |
   | ****    *****  |
   |  ********* *** |
   |   *******  *** |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0fc0,
0x1fe0,
0x3870,
0x3870,
0x3870,
0x3870,
0x3870,
0x1ce0,
0x0fc0,
0x0f80,
0x1fce,
0x38ee,
0x707c,
0x7038,
0x7038,
0x7038,
0x7038,
0x787c,
0x3fee,
0x1fce,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 39 (0x27):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 40 (0x28):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |        ***     |
   |       ***      |
   |      ***       |
   |     ***        |
   |     ***        |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |     ***        |
   |     ***        |
   |      ***       |
   |       ***      |
   |        ***     |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0700,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0700,
0x0700,
0x0380,
0x01c0,
0x00e0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 41 (0x29):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |    ***         |
   |     ***        |
   |      ***       |
   |       ***      |
   |       ***      |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |        ***     |
   |       ***      |
   |       ***      |
   |      ***       |
   |     ***        |
   |    ***         |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0700,
0x0380,
0x01c0,
0x01c0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x00e0,
0x01c0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 42 (0x2a):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  ***     ***   |
   |   ***   ***    |
   |    *** ***     |
   |     *****      |
   |      ***       |
   | *************  |
   | *************  |
   |      ***       |
   |     *****      |
   |    *** ***     |
   |   ***   ***    |
   |  ***     ***   |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3838,
0x1c70,
0x0ee0,
0x07c0,
0x0380,
0x7ffc,
0x7ffc,
0x0380,
0x07c0,
0x0ee0,
0x1c70,
0x3838,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 43 (0x2b):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   | *************  |
   | *************  |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x7ffc,
0x7ffc,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 44 (0x2c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |     ***        |
   |    ***         |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0700,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 45 (0x2d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 46 (0x2e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 47 (0x2f):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |           ***  |
   |           ***  |
   |          ***   |
   |          ***   |
   |         ***    |
   |         ***    |
   |        ***     |
   |        ***     |
   |       ***      |
   |       ***      |
   |      ***       |
   |      ***       |
   |     ***        |
   |     ***        |
   |    ***         |
   |    ***         |
   |   ***          |
   |   ***          |
   |  ***           |
   |  ***           |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x001c,
0x001c,
0x0038,
0x0038,
0x0070,
0x0070,
0x00e0,
0x00e0,
0x01c0,
0x01c0,
0x0380,
0x0380,
0x0700,
0x0700,
0x0e00,
0x0e00,
0x1c00,
0x1c00,
0x3800,
0x3800,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 48 (0x30):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***      ****  |
   | ***     *****  |
   | ***    ******  |
   | ***   *** ***  |
   | ***  ***  ***  |
   | *** ***   ***  |
   | ******    ***  |
   | *****     ***  |
   | ****      ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x703c,
0x707c,
0x70fc,
0x71dc,
0x739c,
0x771c,
0x7e1c,
0x7c1c,
0x781c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 49 (0x31):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |     ****       |
   |    *****       |
   |   ******       |
   |   ******       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |   *********    |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0780,
0x0f80,
0x1f80,
0x1f80,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x1ff0,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 50 (0x32):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |           ***  |
   |          ***   |
   |         ***    |
   |        ***     |
   |       ***      |
   |      ***       |
   |     ***        |
   |    ***         |
   |   ***          |
   |  ***           |
   | ***            |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x001c,
0x0038,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 51 (0x33):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |          ****  |
   |    *********   |
   |    *********   |
   |          ****  |
   |           ***  |
   |           ***  |
   |           ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x001c,
0x001c,
0x001c,
0x003c,
0x0ff8,
0x0ff8,
0x003c,
0x001c,
0x001c,
0x001c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 52 (0x34):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |           ***  |
   |          ****  |
   |         *****  |
   |        ******  |
   |       *** ***  |
   |      ***  ***  |
   |     ***   ***  |
   |    ***    ***  |
   |   ***     ***  |
   |  ***      ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | *************  |
   | *************  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x001c,
0x003c,
0x007c,
0x00fc,
0x01dc,
0x039c,
0x071c,
0x0e1c,
0x1c1c,
0x381c,
0x701c,
0x701c,
0x701c,
0x7ffc,
0x7ffc,
0x001c,
0x001c,
0x001c,
0x001c,
0x001c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 53 (0x35):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***********    |
   | ************   |
   |          ****  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   | ***       ***  |
   | ****      ***  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ff0,
0x7ff8,
0x003c,
0x001c,
0x001c,
0x001c,
0x001c,
0x001c,
0x701c,
0x781c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 54 (0x36):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   **********   |
   |  ***********   |
   | ****           |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff8,
0x3ff8,
0x7800,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 55 (0x37):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ***   |
   |          ***   |
   |         ***    |
   |         ***    |
   |        ***     |
   |        ***     |
   |       ***      |
   |       ***      |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x701c,
0x701c,
0x701c,
0x7038,
0x0038,
0x0070,
0x0070,
0x00e0,
0x00e0,
0x01c0,
0x01c0,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 56 (0x38):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 57 (0x39):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |          ****  |
   |  ***********   |
   |  **********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x001c,
0x001c,
0x001c,
0x001c,
0x001c,
0x003c,
0x3ff8,
0x3ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 58 (0x3a):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 59 (0x3b):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |     ***        |
   |    ***         |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0700,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 60 (0x3c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |           ***  |
   |          ***   |
   |         ***    |
   |        ***     |
   |       ***      |
   |      ***       |
   |     ***        |
   |    ***         |
   |   ***          |
   |  ***           |
   |  ***           |
   |   ***          |
   |    ***         |
   |     ***        |
   |      ***       |
   |       ***      |
   |        ***     |
   |         ***    |
   |          ***   |
   |           ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x001c,
0x0038,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x3800,
0x1c00,
0x0e00,
0x0700,
0x0380,
0x01c0,
0x00e0,
0x0070,
0x0038,
0x001c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 61 (0x3d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 62 (0x3e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  ***           |
   |   ***          |
   |    ***         |
   |     ***        |
   |      ***       |
   |       ***      |
   |        ***     |
   |         ***    |
   |          ***   |
   |           ***  |
   |           ***  |
   |          ***   |
   |         ***    |
   |        ***     |
   |       ***      |
   |      ***       |
   |     ***        |
   |    ***         |
   |   ***          |
   |  ***           |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3800,
0x1c00,
0x0e00,
0x0700,
0x0380,
0x01c0,
0x00e0,
0x0070,
0x0038,
0x001c,
0x001c,
0x0038,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 63 (0x3f):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |          ***   |
   |         ***    |
   |        ***     |
   |       ***      |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x0038,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 64 (0x40):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   **********   |
   |  ************  |
   | ****       *** |
   | ***         ** |
   | ***   ******** |
   | ***  ********* |
   | *** ****   *** |
   | *** ***    *** |
   | *** ***    *** |
   | *** ***    *** |
   | *** ***    *** |
   | *** ***    *** |
   | *** ***    *** |
   | *** ****  **** |
   | ***  ********* |
   | ***   ***** ** |
   | ***            |
   | ****           |
   |  ************* |
   |   ************ |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff8,
0x3ffc,
0x780e,
0x7006,
0x71fe,
0x73fe,
0x778e,
0x770e,
0x770e,
0x770e,
0x770e,
0x770e,
0x770e,
0x779e,
0x73fe,
0x71f6,
0x7000,
0x7800,
0x3ffe,
0x1ffe,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 65 (0x41):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | *************  |
   | *************  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x7ffc,
0x7ffc,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 66 (0x42):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ***   |
   | ***********    |
   | ***********    |
   | ***      ***   |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ****  |
   | ************   |
   | ***********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x7038,
0x7ff0,
0x7ff0,
0x7038,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x703c,
0x7ff8,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 67 (0x43):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 68 (0x44):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *********      |
   | ***********    |
   | ***     ****   |
   | ***      ***   |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ***   |
   | ***     ****   |
   | ***********    |
   | *********      |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x7ff0,
0x7078,
0x7038,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x7038,
0x7078,
0x7ff0,
0x7fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 69 (0x45):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | **********     |
   | **********     |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7fe0,
0x7fe0,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 70 (0x46):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | **********     |
   | **********     |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7fe0,
0x7fe0,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 71 (0x47):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***   *******  |
   | ***   *******  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x7000,
0x7000,
0x7000,
0x7000,
0x71fc,
0x71fc,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 72 (0x48):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | *************  |
   | *************  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x7ffc,
0x7ffc,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 73 (0x49):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |    *******     |
   |    *******     |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |    *******     |
   |    *******     |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0fe0,
0x0fe0,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0fe0,
0x0fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 74 (0x4a):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |        ******* |
   |        ******* |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   | ***      ***   |
   | ***      ***   |
   | ***      ***   |
   | ****    ****   |
   |  **********    |
   |   ********     |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x00fe,
0x00fe,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x7038,
0x7038,
0x7038,
0x7878,
0x3ff0,
0x1fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 75 (0x4b):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***        **  |
   | ***       ***  |
   | ***      ***   |
   | ***     ***    |
   | ***    ***     |
   | ***   ***      |
   | ***  ***       |
   | *** ***        |
   | ******         |
   | *****          |
   | *****          |
   | ******         |
   | *** ***        |
   | ***  ***       |
   | ***   ***      |
   | ***    ***     |
   | ***     ***    |
   | ***      ***   |
   | ***       ***  |
   | ***        **  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x700c,
0x701c,
0x7038,
0x7070,
0x70e0,
0x71c0,
0x7380,
0x7700,
0x7e00,
0x7c00,
0x7c00,
0x7e00,
0x7700,
0x7380,
0x71c0,
0x70e0,
0x7070,
0x7038,
0x701c,
0x700c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 76 (0x4c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 77 (0x4d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***        *** |
   | ***        *** |
   | ****      **** |
   | *****    ***** |
   | ******  ****** |
   | ******  ****** |
   | *** ****** *** |
   | ***  ****  *** |
   | ***  ****  *** |
   | ***   **   *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x700e,
0x700e,
0x781e,
0x7c3e,
0x7e7e,
0x7e7e,
0x77ee,
0x73ce,
0x73ce,
0x718e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 78 (0x4e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   | *****     ***  |
   | ******    ***  |
   | *** ***   ***  |
   | ***  ***  ***  |
   | ***   *** ***  |
   | ***    ******  |
   | ***     *****  |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x7c1c,
0x7e1c,
0x771c,
0x739c,
0x71dc,
0x70fc,
0x707c,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 79 (0x4f):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 80 (0x50):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ****  |
   | ************   |
   | ***********    |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x703c,
0x7ff8,
0x7ff0,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 81 (0x51):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***  ***  ***  |
   | ****  *******  |
   |  ***********   |
   |   *********    |
   |          ***   |
   |           ***  |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x739c,
0x79fc,
0x3ff8,
0x1ff0,
0x0038,
0x001c,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 82 (0x52):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ****  |
   | ************   |
   | ***********    |
   | ******         |
   | *** ***        |
   | ***  ***       |
   | ***   ***      |
   | ***    ***     |
   | ***     ***    |
   | ***      ***   |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x703c,
0x7ff8,
0x7ff0,
0x7e00,
0x7700,
0x7380,
0x71c0,
0x70e0,
0x7070,
0x7038,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 83 (0x53):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***            |
   | ***            |
   | ***            |
   | ****           |
   |  **********    |
   |   **********   |
   |          ****  |
   |           ***  |
   |           ***  |
   |           ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x7000,
0x7000,
0x7000,
0x7800,
0x3ff0,
0x1ff8,
0x003c,
0x001c,
0x001c,
0x001c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 84 (0x54):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 85 (0x55):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 86 (0x56):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |  ***     ***   |
   |  ***     ***   |
   |  ***     ***   |
   |  ***     ***   |
   |  ***     ***   |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |    *** ***     |
   |    *** ***     |
   |    *** ***     |
   |     *****      |
   |     *****      |
   |     *****      |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x3838,
0x3838,
0x3838,
0x3838,
0x3838,
0x1c70,
0x1c70,
0x1c70,
0x1c70,
0x0ee0,
0x0ee0,
0x0ee0,
0x07c0,
0x07c0,
0x07c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 87 (0x57):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***        *** |
   | ***   **   *** |
   | ***  ****  *** |
   | ***  ****  *** |
   | *** ****** *** |
   | ******  ****** |
   | ******  ****** |
   | *****    ***** |
   | ****      **** |
   | ***        *** |
   | ***        *** |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x700e,
0x718e,
0x73ce,
0x73ce,
0x77ee,
0x7e7e,
0x7e7e,
0x7c3e,
0x781e,
0x700e,
0x700e,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 88 (0x58):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   |  ***     ***   |
   |  ***     ***   |
   |   ***   ***    |
   |   ***   ***    |
   |    *** ***     |
   |    *** ***     |
   |     *****      |
   |     *****      |
   |     *****      |
   |     *****      |
   |    *** ***     |
   |    *** ***     |
   |   ***   ***    |
   |   ***   ***    |
   |  ***     ***   |
   |  ***     ***   |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x3838,
0x3838,
0x1c70,
0x1c70,
0x0ee0,
0x0ee0,
0x07c0,
0x07c0,
0x07c0,
0x07c0,
0x0ee0,
0x0ee0,
0x1c70,
0x1c70,
0x3838,
0x3838,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 89 (0x59):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |  ***     ***   |
   |  ***     ***   |
   |   ***   ***    |
   |   ***   ***    |
   |    *** ***     |
   |    *** ***     |
   |     *****      |
   |     *****      |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x3838,
0x3838,
0x1c70,
0x1c70,
0x0ee0,
0x0ee0,
0x07c0,
0x07c0,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 90 (0x5a):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |           ***  |
   |           ***  |
   |           ***  |
   |          ***   |
   |         ***    |
   |        ***     |
   |       ***      |
   |      ***       |
   |     ***        |
   |    ***         |
   |   ***          |
   |  ***           |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x001c,
0x001c,
0x001c,
0x0038,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 91 (0x5b):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |    ********    |
   |    ********    |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ***         |
   |    ********    |
   |    ********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0ff0,
0x0ff0,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0e00,
0x0ff0,
0x0ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 92 (0x5c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  ***           |
   |  ***           |
   |   ***          |
   |   ***          |
   |    ***         |
   |    ***         |
   |     ***        |
   |     ***        |
   |      ***       |
   |      ***       |
   |       ***      |
   |       ***      |
   |        ***     |
   |        ***     |
   |         ***    |
   |         ***    |
   |          ***   |
   |          ***   |
   |           ***  |
   |           ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3800,
0x3800,
0x1c00,
0x1c00,
0x0e00,
0x0e00,
0x0700,
0x0700,
0x0380,
0x0380,
0x01c0,
0x01c0,
0x00e0,
0x00e0,
0x0070,
0x0070,
0x0038,
0x0038,
0x001c,
0x001c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 93 (0x5d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |    ********    |
   |    ********    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |         ***    |
   |    ********    |
   |    ********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0ff0,
0x0ff0,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0070,
0x0ff0,
0x0ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 94 (0x5e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |     *****      |
   |    *** ***     |
   |   ***   ***    |
   |  ***     ***   |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x07c0,
0x0ee0,
0x1c70,
0x3838,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 95 (0x5f):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,

/* Character 96 (0x60):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |   ***          |
   |    ***         |
   |     ***        |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x1c00,
0x0e00,
0x0700,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 97 (0x61):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  **********    |
   |  ***********   |
   |          ****  |
   |           ***  |
   |           ***  |
   |   ***********  |
   |  ************  |
   | ****      ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3ff0,
0x3ff8,
0x003c,
0x001c,
0x001c,
0x1ffc,
0x3ffc,
0x781c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 98 (0x62):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ****  |
   | ************   |
   | ***********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x703c,
0x7ff8,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 99 (0x63):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 100 (0x64):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |   ***********  |
   |  ************  |
   | ****      ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x001c,
0x001c,
0x001c,
0x001c,
0x001c,
0x001c,
0x1ffc,
0x3ffc,
0x781c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 101 (0x65):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | *************  |
   | *************  |
   | ***            |
   | ***            |
   | ***            |
   | ****      ***  |
   |  ************  |
   |   **********   |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x7ffc,
0x7ffc,
0x7000,
0x7000,
0x7000,
0x781c,
0x3ffc,
0x1ff8,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 102 (0x66):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |        ******* |
   |       ******** |
   |      ****      |
   |      ***       |
   |      ***       |
   |      ***       |
   |  ***********   |
   |  ***********   |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x00fe,
0x01fe,
0x03c0,
0x0380,
0x0380,
0x0380,
0x3ff8,
0x3ff8,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 103 (0x67):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   ***********  |
   |  ************  |
   | ****      ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |           ***  |
   |           ***  |
   |           ***  |
   |  ***********   |
   |  **********    |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ffc,
0x3ffc,
0x781c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x001c,
0x001c,
0x001c,
0x3ff8,
0x3ff0,
0x0000,

/* Character 104 (0x68):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 105 (0x69):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |    *****       |
   |    *****       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |    *******     |
   |    *******     |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0f80,
0x0f80,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0fe0,
0x0fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 106 (0x6a):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |                |
   |                |
   |        *****   |
   |        *****   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |          ***   |
   |  ***     ***   |
   |  ***     ***   |
   |  ****   ****   |
   |   *********    |
   |    *******     |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0038,
0x0038,
0x0038,
0x0038,
0x0000,
0x0000,
0x00f8,
0x00f8,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x0038,
0x3838,
0x3838,
0x3c78,
0x1ff0,
0x0fe0,
0x0000,

/* Character 107 (0x6b):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  ***           |
   |  ***           |
   |  ***           |
   |  ***           |
   |  ***           |
   |  ***           |
   |  ***      ***  |
   |  ***     ***   |
   |  ***    ***    |
   |  ***   ***     |
   |  ***  ***      |
   |  *** ***       |
   |  ******        |
   |  ******        |
   |  *** ***       |
   |  ***  ***      |
   |  ***   ***     |
   |  ***    ***    |
   |  ***     ***   |
   |  ***      ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3800,
0x3800,
0x3800,
0x3800,
0x3800,
0x3800,
0x381c,
0x3838,
0x3870,
0x38e0,
0x39c0,
0x3b80,
0x3f00,
0x3f00,
0x3b80,
0x39c0,
0x38e0,
0x3870,
0x3838,
0x381c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 108 (0x6c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |    *****       |
   |    *****       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |    *******     |
   |    *******     |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0f80,
0x0f80,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0fe0,
0x0fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 109 (0x6d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***********    |
   | ************   |
   | ***  *** ****  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff8,
0x73bc,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 110 (0x6e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 111 (0x6f):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 112 (0x70):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***********    |
   | ************   |
   | ***      ****  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***      ****  |
   | ************   |
   | ***********    |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff8,
0x703c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x703c,
0x7ff8,
0x7ff0,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x0000,

/* Character 113 (0x71):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   ***********  |
   |  ************  |
   | ****      ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |           ***  |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ffc,
0x3ffc,
0x781c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x001c,
0x001c,
0x001c,
0x001c,
0x001c,
0x0000,

/* Character 114 (0x72):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***  ********  |
   | *** *********  |
   | ******         |
   | *****          |
   | ****           |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   | ***            |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x73fc,
0x77fc,
0x7e00,
0x7c00,
0x7800,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x7000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 115 (0x73):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |   *********    |
   |  ***********   |
   | ****     ****  |
   | ***            |
   | ***            |
   | ****           |
   |  **********    |
   |   **********   |
   |          ****  |
   |           ***  |
   |           ***  |
   | ****     ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff8,
0x783c,
0x7000,
0x7000,
0x7800,
0x3ff0,
0x1ff8,
0x003c,
0x001c,
0x001c,
0x783c,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 116 (0x74):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   | ***********    |
   | ***********    |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ****       |
   |      ********  |
   |       *******  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x7ff0,
0x7ff0,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0780,
0x03fc,
0x01fc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 117 (0x75):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 118 (0x76):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |  ***     ***   |
   |  ***     ***   |
   |  ***     ***   |
   |   ***   ***    |
   |   ***   ***    |
   |   ***   ***    |
   |    *** ***     |
   |    *** ***     |
   |     *****      |
   |     *****      |
   |     *****      |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x3838,
0x3838,
0x3838,
0x1c70,
0x1c70,
0x1c70,
0x0ee0,
0x0ee0,
0x07c0,
0x07c0,
0x07c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 119 (0x77):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | ***  ***  ***  |
   | **** *** ****  |
   |  ***********   |
   |   *********    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x739c,
0x7bbc,
0x3ff8,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 120 (0x78):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |  ***     ***   |
   |   ***   ***    |
   |    *** ***     |
   |     *****      |
   |     *****      |
   |    *** ***     |
   |   ***   ***    |
   |  ***     ***   |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x3838,
0x1c70,
0x0ee0,
0x07c0,
0x07c0,
0x0ee0,
0x1c70,
0x3838,
0x701c,
0x701c,
0x701c,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 121 (0x79):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ***       ***  |
   | ****      ***  |
   |  ************  |
   |   ***********  |
   |           ***  |
   |           ***  |
   |          ****  |
   |  ***********   |
   |  **********    |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x701c,
0x781c,
0x3ffc,
0x1ffc,
0x001c,
0x001c,
0x003c,
0x3ff8,
0x3ff0,
0x0000,

/* Character 122 (0x7a):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   | *************  |
   | *************  |
   |          ***   |
   |         ***    |
   |        ***     |
   |       ***      |
   |      ***       |
   |     ***        |
   |    ***         |
   |   ***          |
   |  ***           |
   | ***            |
   | *************  |
   | *************  |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ffc,
0x7ffc,
0x0038,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x7ffc,
0x7ffc,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 123 (0x7b):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |       *****    |
   |      ******    |
   |     ****       |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |  *****         |
   |  *****         |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ***        |
   |     ****       |
   |      ******    |
   |       *****    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x01f0,
0x03f0,
0x0780,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x3e00,
0x3e00,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0700,
0x0780,
0x03f0,
0x01f0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 124 (0x7c):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 125 (0x7d):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |  *****         |
   |  ******        |
   |     ****       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |       *****    |
   |       *****    |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |      ***       |
   |     ****       |
   |  ******        |
   |  *****         |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3e00,
0x3f00,
0x0780,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x01f0,
0x01f0,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0380,
0x0780,
0x3f00,
0x3e00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 126 (0x7e):
   width 16
   bbx ( 16, 32, 0, -6 )

   +----------------+
   |                |
   |                |
   |                |
   |                |
   |   ****    ***  |
   |  ******   ***  |
   | *** ****  ***  |
   | ***  **** ***  |
   | ***   ******   |
   | ***    ****    |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   |                |
   +----------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1e1c,
0x3f1c,
0x779c,
0x73dc,
0x71f8,
0x70f0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
};

/* Exported structure definition. */
static const FontDesc stella16x32tDesc = {
  "ter-u32b",
  16,
  32,
  16, 32, 0, -6,
  26,
  28,
  99,
  stella16x32t_font_bits,
  nullptr,  /* no encode table*/
  nullptr,  /* fixed width*/
  nullptr,  /* fixed bbox*/
  32,
  sizeof(stella16x32t_font_bits)/sizeof(uInt16)
};

} // End of namespace GUI

#endif
