/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* alice@strongswan.org */
  3, X'616c696365407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Sales, CN=alice@strongswan.org' */
  11, X'05da04208c02f428470acf6c772d066613da863c'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* %any */
  0, '%any'
);

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b53082029da003020102020100300d06092a864886f70d01010405003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303131303134355a170d3134303930383131303134355a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d010104050003820101009ad74e3e60592dfb9b21c78628bd76b63090c1720c74bf94753cad6fddadc9c776eb39d3bfaa52136bf528840078386308fcf79503bd3d1ad6c15ac38e10c846bff7888a03cfe7fa0e644b522b2af5aedf0bbc508dc48330a180757772771095059b2be148f58dc0c753b59e9d6bfb02e9b685a928a284531b187313fd2b835bc9ea27d0020739a8d485e88bdede9a45cde6d28ed553b0e8e92dabf877bed59abf9d151f15e4f2d00b5e6e49fcb665293d2296697926c2954dae367542ef6e98053e76d2728732f6ce69f284f0b856aa6c2823a9ee29b280a66f50828f9b5cf27f84feca3c31c24897db156c7a833768ab306f51286457a51f09dd53bbb4190f'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales, CN=alice@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, OU=Sales, CN=alice@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_ALICE', 'PH_IP_SUN'
);

INSERT INTO ike_configs (
  local, remote
) VALUES (
  '%any', '%any'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, virtual
) VALUES (
  'nat-t', 1, 4, 5, '0.0.0.0'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, auth_method
) VALUES (
  'shunts', 2, 7, 7, 0
);

INSERT INTO child_configs (
  name
) VALUES (
  'nat-t'
);

INSERT INTO child_configs (
  name, mode, start_action
) VALUES (
  'local-net', 4, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  2, 2
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 0.0.0.0/0 */
  7, X'00000000', X'ffffffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 3, 2
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 1
);
