/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* venus.strongswan.org */
  2, X'76656e75732e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=venus.strongswan.org' */
  11, X'8f5c0a6cb147fc1b51708046e0636c7a54012d67'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* %any */
  0, '%any'
);

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b53082029da003020102020100300d06092a864886f70d01010405003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303131303134355a170d3134303930383131303134355a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d010104050003820101009ad74e3e60592dfb9b21c78628bd76b63090c1720c74bf94753cad6fddadc9c776eb39d3bfaa52136bf528840078386308fcf79503bd3d1ad6c15ac38e10c846bff7888a03cfe7fa0e644b522b2af5aedf0bbc508dc48330a180757772771095059b2be148f58dc0c753b59e9d6bfb02e9b685a928a284531b187313fd2b835bc9ea27d0020739a8d485e88bdede9a45cde6d28ed553b0e8e92dabf877bed59abf9d151f15e4f2d00b5e6e49fcb665293d2296697926c2954dae367542ef6e98053e76d2728732f6ce69f284f0b856aa6c2823a9ee29b280a66f50828f9b5cf27f84feca3c31c24897db156c7a833768ab306f51286457a51f09dd53bbb4190f'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=venus.strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=venus.strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_VENUS', 'PH_IP_SUN'
);

INSERT INTO ike_configs (
  local, remote
) VALUES (
  '%any', '%any'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, virtual
) VALUES (
  'nat-t', 1, 4, 5, '0.0.0.0'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, auth_method
) VALUES (
  'shunts', 2, 7, 7, 0
);

INSERT INTO child_configs (
  name
) VALUES (
  'nat-t'
);

INSERT INTO child_configs (
  name, mode, start_action
) VALUES (
  'local-net', 4, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  2, 2
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 0.0.0.0/0 */
  7, X'00000000', X'ffffffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 3, 2
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 1, 1
);
