/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "CommitItemLvi.h"
#include "svn/CommitItem.h"

// qt


// this must match with the columns added to the QTreeWidget in CommitDialog
enum Columns
{
  cKind,
  cFlags,
  cItem
/*
  cProps,
  cCopyUrl,
  cCopyRev
*/
};


CommitItemLvi::CommitItemLvi( const svn::CommitItemPtr item,
  const QString& itemStr ) : super(), _item(item), _itemStr(itemStr)
{
  char* kinds[] =
  {
    _n("none"),
    _n("file"),
    _n("folder"),
    _n("unknown")
  };

  setText( 0, _q(kinds[_item->getKind()]) );
  setTextAlignment( 0, Qt::AlignLeft );    

  QString flags;
  if( _item->getFlags() & svn::CommitItem::Flag_Add )
    flags += _q("A");
  if( _item->getFlags() & svn::CommitItem::Flag_Delete )
    flags += _q("D");
  if( _item->getFlags() & svn::CommitItem::Flag_TextMod )
    flags += _q("M");
  if( _item->getFlags() & svn::CommitItem::Flag_PropMod )
    flags += _q("P");
  if( _item->getFlags() & svn::CommitItem::Flag_IsCopy )
    flags += _q("C");

  setText( 1, flags );
  setTextAlignment( 1, Qt::AlignCenter );  

  setText( 2, _itemStr );
  setTextAlignment( 2, Qt::AlignLeft );  
}

CommitItemLvi::~CommitItemLvi()
{
}

const svn::CommitItemPtr CommitItemLvi::getItem() const
{
  return _item;
}
