//------------------------------------------------------------------------------
// GB_mex_test32: test GrB_get and GrB_set (semirings)
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2025, All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

#include "GB_mex.h"
#include "GB_mex_errors.h"

#define FREE_ALL ;
#define GET_DEEP_COPY ;
#define FREE_DEEP_COPY ;

#define GETOP(op,opname)                                                \
{                                                                       \
    size_t siz1, siz2, siz3 ;                                           \
    OK (GrB_Semiring_get_String (op, name, GrB_NAME)) ;                 \
    CHECK (MATCH (name, opname)) ;                                      \
    printf ("\nname: %s\n", name) ;                                     \
    OK (GxB_Semiring_fprint (op, "semiring", 3, NULL)) ;                \
    OK (GrB_Semiring_get_SIZE (op, &size, GrB_NAME)) ;                  \
    CHECK (size == strlen (name) + 1) ;                                 \
    GrB_Info info2, info3 ;                                             \
    info2 = GrB_Semiring_get_SIZE (op, &siz1, GrB_INP0_TYPE_STRING) ;   \
    info3 = GrB_Semiring_get_String (op, name, GrB_INP0_TYPE_STRING) ;  \
    CHECK (info2 == info3) ;                                            \
    CHECK (siz1 == strlen (name) + 1) ;                                 \
    if (info2 == GrB_NO_VALUE) { CHECK (siz1 == 1) ; }                  \
    info2 = GrB_Semiring_get_SIZE (op, &siz2, GrB_INP1_TYPE_STRING) ;   \
    info3 = GrB_Semiring_get_String (op, name, GrB_INP1_TYPE_STRING) ;  \
    CHECK (info2 == info3) ;                                            \
    CHECK (siz2 == strlen (name) + 1) ;                                 \
    if (info2 == GrB_NO_VALUE) { CHECK (siz1 == 1) ; }                  \
    info2 = GrB_Semiring_get_SIZE (op, &siz3, GrB_OUTP_TYPE_STRING) ;   \
    info3 = GrB_Semiring_get_String (op, name, GrB_OUTP_TYPE_STRING) ;  \
    CHECK (info2 == info3) ;                                            \
    CHECK (siz3 == strlen (name) + 1) ;                                 \
    if (info2 == GrB_NO_VALUE) { CHECK (siz1 == 1) ; }                  \
}

#define GETNAME(op)                                         \
{                                                           \
    GETOP (op, #op) ;                                       \
}

#define GETNAM2(op,alias)                                   \
{                                                           \
    GETOP (op,alias) ;                                      \
}

void mytimes (float *z, const float *x, const float *y) ;
void mytimes (float *z, const float *x, const float *y) { (*z) = (*x)*(*y) ; }
#define MYTIMES_DEFN \
"void mytimes (float *z, const float *x, const float *y) { (*z) = (*x)*(*y) ; }"

void myadd (float *z, const float *x, const float *y) ;
void myadd (float *z, const float *x, const float *y) { (*z) = (*x)+(*y) ; }
#define MYADD_DEFN \
"void myadd (float *z, const float *x, const float *y) { (*z) = (*x)+(*y) ; }"

void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{

    //--------------------------------------------------------------------------
    // startup GraphBLAS
    //--------------------------------------------------------------------------

    GrB_Info info, expected ;
    bool malloc_debug = GB_mx_get_global (true) ;
    GrB_Scalar s = NULL, s_fp64 = NULL, s_int32 = NULL, s_fp32 = NULL ;
    GrB_BinaryOp times = NULL, add = NULL, op = NULL ;
    GrB_Monoid monoid = NULL, mon = NULL ;
    GrB_Semiring semiring = NULL ;
    uint8_t stuff [256] ;
    void *nothing = stuff ;
    size_t size ;
    char name [1024] ;
    char defn [2048] ;
    int32_t code, i ;
    float fvalue ;
    double dvalue ;
    uint64_t nvals = 999 ;

    OK (GrB_Scalar_new (&s_fp64, GrB_FP64)) ;
    OK (GrB_Scalar_new (&s_fp32, GrB_FP32)) ;
    OK (GrB_Scalar_new (&s_int32, GrB_INT32)) ;

    //--------------------------------------------------------------------------
    // GrB_Semiring get name
    //--------------------------------------------------------------------------

    //--------------------------------------------------------------------------
    // *_FIRST
    //--------------------------------------------------------------------------

    GETNAME (GrB_MIN_FIRST_SEMIRING_INT8) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_INT16) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_INT32) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_INT64) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_UINT8) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_UINT16) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_UINT32) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_UINT64) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_FP32) ;
    GETNAME (GrB_MIN_FIRST_SEMIRING_FP64) ;

    GETNAM2 (GxB_MIN_FIRST_INT8,    "GrB_MIN_FIRST_SEMIRING_INT8") ;
    GETNAM2 (GxB_MIN_FIRST_INT16,   "GrB_MIN_FIRST_SEMIRING_INT16") ;
    GETNAM2 (GxB_MIN_FIRST_INT32,   "GrB_MIN_FIRST_SEMIRING_INT32") ;
    GETNAM2 (GxB_MIN_FIRST_INT64,   "GrB_MIN_FIRST_SEMIRING_INT64") ;
    GETNAM2 (GxB_MIN_FIRST_UINT8,   "GrB_MIN_FIRST_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MIN_FIRST_UINT16,  "GrB_MIN_FIRST_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MIN_FIRST_UINT32,  "GrB_MIN_FIRST_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MIN_FIRST_UINT64,  "GrB_MIN_FIRST_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MIN_FIRST_FP32,    "GrB_MIN_FIRST_SEMIRING_FP32") ;
    GETNAM2 (GxB_MIN_FIRST_FP64,    "GrB_MIN_FIRST_SEMIRING_FP64") ;

    GETNAME (GrB_MAX_FIRST_SEMIRING_INT8) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_INT16) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_INT32) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_INT64) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_UINT8) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_UINT16) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_UINT32) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_UINT64) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_FP32) ;
    GETNAME (GrB_MAX_FIRST_SEMIRING_FP64) ;

    GETNAM2 (GxB_MAX_FIRST_INT8,    "GrB_MAX_FIRST_SEMIRING_INT8") ;
    GETNAM2 (GxB_MAX_FIRST_INT16,   "GrB_MAX_FIRST_SEMIRING_INT16") ;
    GETNAM2 (GxB_MAX_FIRST_INT32,   "GrB_MAX_FIRST_SEMIRING_INT32") ;
    GETNAM2 (GxB_MAX_FIRST_INT64,   "GrB_MAX_FIRST_SEMIRING_INT64") ;
    GETNAM2 (GxB_MAX_FIRST_UINT8,   "GrB_MAX_FIRST_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MAX_FIRST_UINT16,  "GrB_MAX_FIRST_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MAX_FIRST_UINT32,  "GrB_MAX_FIRST_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MAX_FIRST_UINT64,  "GrB_MAX_FIRST_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MAX_FIRST_FP32,    "GrB_MAX_FIRST_SEMIRING_FP32") ;
    GETNAM2 (GxB_MAX_FIRST_FP64,    "GrB_MAX_FIRST_SEMIRING_FP64") ;

    GETNAME (GxB_PLUS_FIRST_INT8) ;
    GETNAME (GxB_PLUS_FIRST_INT16) ;
    GETNAME (GxB_PLUS_FIRST_INT32) ;
    GETNAME (GxB_PLUS_FIRST_INT64) ;
    GETNAME (GxB_PLUS_FIRST_UINT8) ;
    GETNAME (GxB_PLUS_FIRST_UINT16) ;
    GETNAME (GxB_PLUS_FIRST_UINT32) ;
    GETNAME (GxB_PLUS_FIRST_UINT64) ;
    GETNAME (GxB_PLUS_FIRST_FP32) ;
    GETNAME (GxB_PLUS_FIRST_FP64) ;
    GETNAME (GxB_PLUS_FIRST_FC32) ;
    GETNAME (GxB_PLUS_FIRST_FC64) ;

    GETNAME (GxB_TIMES_FIRST_INT8) ;
    GETNAME (GxB_TIMES_FIRST_INT16) ;
    GETNAME (GxB_TIMES_FIRST_INT32) ;
    GETNAME (GxB_TIMES_FIRST_INT64) ;
    GETNAME (GxB_TIMES_FIRST_UINT8) ;
    GETNAME (GxB_TIMES_FIRST_UINT16) ;
    GETNAME (GxB_TIMES_FIRST_UINT32) ;
    GETNAME (GxB_TIMES_FIRST_UINT64) ;
    GETNAME (GxB_TIMES_FIRST_FP32) ;
    GETNAME (GxB_TIMES_FIRST_FP64) ;
    GETNAME (GxB_TIMES_FIRST_FC32) ;
    GETNAME (GxB_TIMES_FIRST_FC64) ;

    GETNAME (GxB_ANY_FIRST_INT8) ;
    GETNAME (GxB_ANY_FIRST_INT16) ;
    GETNAME (GxB_ANY_FIRST_INT32) ;
    GETNAME (GxB_ANY_FIRST_INT64) ;
    GETNAME (GxB_ANY_FIRST_UINT8) ;
    GETNAME (GxB_ANY_FIRST_UINT16) ;
    GETNAME (GxB_ANY_FIRST_UINT32) ;
    GETNAME (GxB_ANY_FIRST_UINT64) ;
    GETNAME (GxB_ANY_FIRST_FP32) ;
    GETNAME (GxB_ANY_FIRST_FP64) ;
    GETNAME (GxB_ANY_FIRST_FC32) ;
    GETNAME (GxB_ANY_FIRST_FC64) ;

    GETNAME (GxB_LOR_FIRST_BOOL) ;
    GETNAME (GxB_LAND_FIRST_BOOL) ;
    GETNAME (GxB_LXOR_FIRST_BOOL) ;
    GETNAME (GxB_EQ_FIRST_BOOL) ;
    GETNAME (GxB_ANY_FIRST_BOOL) ;

    //--------------------------------------------------------------------------
    // *_SECOND
    //--------------------------------------------------------------------------

    GETNAME (GrB_MIN_SECOND_SEMIRING_INT8) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_INT16) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_INT32) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_INT64) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_UINT8) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_UINT16) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_UINT32) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_UINT64) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_FP32) ;
    GETNAME (GrB_MIN_SECOND_SEMIRING_FP64) ;

    GETNAM2 (GxB_MIN_SECOND_INT8,    "GrB_MIN_SECOND_SEMIRING_INT8") ;
    GETNAM2 (GxB_MIN_SECOND_INT16,   "GrB_MIN_SECOND_SEMIRING_INT16") ;
    GETNAM2 (GxB_MIN_SECOND_INT32,   "GrB_MIN_SECOND_SEMIRING_INT32") ;
    GETNAM2 (GxB_MIN_SECOND_INT64,   "GrB_MIN_SECOND_SEMIRING_INT64") ;
    GETNAM2 (GxB_MIN_SECOND_UINT8,   "GrB_MIN_SECOND_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MIN_SECOND_UINT16,  "GrB_MIN_SECOND_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MIN_SECOND_UINT32,  "GrB_MIN_SECOND_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MIN_SECOND_UINT64,  "GrB_MIN_SECOND_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MIN_SECOND_FP32,    "GrB_MIN_SECOND_SEMIRING_FP32") ;
    GETNAM2 (GxB_MIN_SECOND_FP64,    "GrB_MIN_SECOND_SEMIRING_FP64") ;

    GETNAME (GrB_MAX_SECOND_SEMIRING_INT8) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_INT16) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_INT32) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_INT64) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_UINT8) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_UINT16) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_UINT32) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_UINT64) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_FP32) ;
    GETNAME (GrB_MAX_SECOND_SEMIRING_FP64) ;

    GETNAM2 (GxB_MAX_SECOND_INT8,    "GrB_MAX_SECOND_SEMIRING_INT8") ;
    GETNAM2 (GxB_MAX_SECOND_INT16,   "GrB_MAX_SECOND_SEMIRING_INT16") ;
    GETNAM2 (GxB_MAX_SECOND_INT32,   "GrB_MAX_SECOND_SEMIRING_INT32") ;
    GETNAM2 (GxB_MAX_SECOND_INT64,   "GrB_MAX_SECOND_SEMIRING_INT64") ;
    GETNAM2 (GxB_MAX_SECOND_UINT8,   "GrB_MAX_SECOND_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MAX_SECOND_UINT16,  "GrB_MAX_SECOND_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MAX_SECOND_UINT32,  "GrB_MAX_SECOND_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MAX_SECOND_UINT64,  "GrB_MAX_SECOND_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MAX_SECOND_FP32,    "GrB_MAX_SECOND_SEMIRING_FP32") ;
    GETNAM2 (GxB_MAX_SECOND_FP64,    "GrB_MAX_SECOND_SEMIRING_FP64") ;

    GETNAME (GxB_PLUS_SECOND_INT8) ;
    GETNAME (GxB_PLUS_SECOND_INT16) ;
    GETNAME (GxB_PLUS_SECOND_INT32) ;
    GETNAME (GxB_PLUS_SECOND_INT64) ;
    GETNAME (GxB_PLUS_SECOND_UINT8) ;
    GETNAME (GxB_PLUS_SECOND_UINT16) ;
    GETNAME (GxB_PLUS_SECOND_UINT32) ;
    GETNAME (GxB_PLUS_SECOND_UINT64) ;
    GETNAME (GxB_PLUS_SECOND_FP32) ;
    GETNAME (GxB_PLUS_SECOND_FP64) ;
    GETNAME (GxB_PLUS_SECOND_FC32) ;
    GETNAME (GxB_PLUS_SECOND_FC64) ;

    GETNAME (GxB_TIMES_SECOND_INT8) ;
    GETNAME (GxB_TIMES_SECOND_INT16) ;
    GETNAME (GxB_TIMES_SECOND_INT32) ;
    GETNAME (GxB_TIMES_SECOND_INT64) ;
    GETNAME (GxB_TIMES_SECOND_UINT8) ;
    GETNAME (GxB_TIMES_SECOND_UINT16) ;
    GETNAME (GxB_TIMES_SECOND_UINT32) ;
    GETNAME (GxB_TIMES_SECOND_UINT64) ;
    GETNAME (GxB_TIMES_SECOND_FP32) ;
    GETNAME (GxB_TIMES_SECOND_FP64) ;
    GETNAME (GxB_TIMES_SECOND_FC32) ;
    GETNAME (GxB_TIMES_SECOND_FC64) ;

    GETNAME (GxB_ANY_SECOND_INT8) ;
    GETNAME (GxB_ANY_SECOND_INT16) ;
    GETNAME (GxB_ANY_SECOND_INT32) ;
    GETNAME (GxB_ANY_SECOND_INT64) ;
    GETNAME (GxB_ANY_SECOND_UINT8) ;
    GETNAME (GxB_ANY_SECOND_UINT16) ;
    GETNAME (GxB_ANY_SECOND_UINT32) ;
    GETNAME (GxB_ANY_SECOND_UINT64) ;
    GETNAME (GxB_ANY_SECOND_FP32) ;
    GETNAME (GxB_ANY_SECOND_FP64) ;
    GETNAME (GxB_ANY_SECOND_FC32) ;
    GETNAME (GxB_ANY_SECOND_FC64) ;

    GETNAME (GxB_LOR_SECOND_BOOL) ;
    GETNAME (GxB_LAND_SECOND_BOOL) ;
    GETNAME (GxB_LXOR_SECOND_BOOL) ;
    GETNAME (GxB_EQ_SECOND_BOOL) ;
    GETNAME (GxB_ANY_SECOND_BOOL) ;

    //--------------------------------------------------------------------------
    // *_PAIR
    //--------------------------------------------------------------------------

    GETNAM2 (GxB_MIN_PAIR_INT8,         "GxB_ANY_PAIR_INT8") ;
    GETNAM2 (GxB_MIN_PAIR_INT16,        "GxB_ANY_PAIR_INT16") ;
    GETNAM2 (GxB_MIN_PAIR_INT32,        "GxB_ANY_PAIR_INT32") ;
    GETNAM2 (GxB_MIN_PAIR_INT64,        "GxB_ANY_PAIR_INT64") ;
    GETNAM2 (GxB_MIN_PAIR_UINT8,        "GxB_ANY_PAIR_UINT8") ;
    GETNAM2 (GxB_MIN_PAIR_UINT16,       "GxB_ANY_PAIR_UINT16") ;
    GETNAM2 (GxB_MIN_PAIR_UINT32,       "GxB_ANY_PAIR_UINT32") ;
    GETNAM2 (GxB_MIN_PAIR_UINT64,       "GxB_ANY_PAIR_UINT64") ;
    GETNAM2 (GxB_MIN_PAIR_FP32,         "GxB_ANY_PAIR_FP32") ;
    GETNAM2 (GxB_MIN_PAIR_FP64,         "GxB_ANY_PAIR_FP64") ;

    GETNAM2 (GxB_MAX_PAIR_INT8,         "GxB_ANY_PAIR_INT8") ;
    GETNAM2 (GxB_MAX_PAIR_INT16,        "GxB_ANY_PAIR_INT16") ;
    GETNAM2 (GxB_MAX_PAIR_INT32,        "GxB_ANY_PAIR_INT32") ;
    GETNAM2 (GxB_MAX_PAIR_INT64,        "GxB_ANY_PAIR_INT64") ;
    GETNAM2 (GxB_MAX_PAIR_UINT8,        "GxB_ANY_PAIR_UINT8") ;
    GETNAM2 (GxB_MAX_PAIR_UINT16,       "GxB_ANY_PAIR_UINT16") ;
    GETNAM2 (GxB_MAX_PAIR_UINT32,       "GxB_ANY_PAIR_UINT32") ;
    GETNAM2 (GxB_MAX_PAIR_UINT64,       "GxB_ANY_PAIR_UINT64") ;
    GETNAM2 (GxB_MAX_PAIR_FP32,         "GxB_ANY_PAIR_FP32") ;
    GETNAM2 (GxB_MAX_PAIR_FP64,         "GxB_ANY_PAIR_FP64") ;

    GETNAME (GxB_PLUS_PAIR_INT8) ;
    GETNAME (GxB_PLUS_PAIR_INT16) ;
    GETNAME (GxB_PLUS_PAIR_INT32) ;
    GETNAME (GxB_PLUS_PAIR_INT64) ;
    GETNAME (GxB_PLUS_PAIR_UINT8) ;
    GETNAME (GxB_PLUS_PAIR_UINT16) ;
    GETNAME (GxB_PLUS_PAIR_UINT32) ;
    GETNAME (GxB_PLUS_PAIR_UINT64) ;
    GETNAME (GxB_PLUS_PAIR_FP32) ;
    GETNAME (GxB_PLUS_PAIR_FP64) ;
    GETNAME (GxB_PLUS_PAIR_FC32) ;
    GETNAME (GxB_PLUS_PAIR_FC64) ;

    GETNAM2 (GxB_TIMES_PAIR_INT8,       "GxB_ANY_PAIR_INT8") ;
    GETNAM2 (GxB_TIMES_PAIR_INT16,      "GxB_ANY_PAIR_INT16") ;
    GETNAM2 (GxB_TIMES_PAIR_INT32,      "GxB_ANY_PAIR_INT32") ;
    GETNAM2 (GxB_TIMES_PAIR_INT64,      "GxB_ANY_PAIR_INT64") ;
    GETNAM2 (GxB_TIMES_PAIR_UINT8,      "GxB_ANY_PAIR_UINT8") ;
    GETNAM2 (GxB_TIMES_PAIR_UINT16,     "GxB_ANY_PAIR_UINT16") ;
    GETNAM2 (GxB_TIMES_PAIR_UINT32,     "GxB_ANY_PAIR_UINT32") ;
    GETNAM2 (GxB_TIMES_PAIR_UINT64,     "GxB_ANY_PAIR_UINT64") ;
    GETNAM2 (GxB_TIMES_PAIR_FP32,       "GxB_ANY_PAIR_FP32") ;
    GETNAM2 (GxB_TIMES_PAIR_FP64,       "GxB_ANY_PAIR_FP64") ;
    GETNAM2 (GxB_TIMES_PAIR_FC32,       "GxB_ANY_PAIR_FC32") ;
    GETNAM2 (GxB_TIMES_PAIR_FC64,       "GxB_ANY_PAIR_FC64") ;

    GETNAME (GxB_ANY_PAIR_INT8) ;
    GETNAME (GxB_ANY_PAIR_INT16) ;
    GETNAME (GxB_ANY_PAIR_INT32) ;
    GETNAME (GxB_ANY_PAIR_INT64) ;
    GETNAME (GxB_ANY_PAIR_UINT8) ;
    GETNAME (GxB_ANY_PAIR_UINT16) ;
    GETNAME (GxB_ANY_PAIR_UINT32) ;
    GETNAME (GxB_ANY_PAIR_UINT64) ;
    GETNAME (GxB_ANY_PAIR_FP32) ;
    GETNAME (GxB_ANY_PAIR_FP64) ;
    GETNAME (GxB_ANY_PAIR_FC32) ;
    GETNAME (GxB_ANY_PAIR_FC64) ;

    GETNAM2 (GxB_LOR_PAIR_BOOL,         "GxB_ANY_PAIR_BOOL") ;
    GETNAM2 (GxB_LAND_PAIR_BOOL,        "GxB_ANY_PAIR_BOOL") ;
    GETNAME (GxB_LXOR_PAIR_BOOL) ;
    GETNAM2 (GxB_EQ_PAIR_BOOL,          "GxB_ANY_PAIR_BOOL") ;
    GETNAME (GxB_ANY_PAIR_BOOL) ;

    //--------------------------------------------------------------------------
    // *_MIN
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_MIN_INT8) ;
    GETNAME (GxB_MIN_MIN_INT16) ;
    GETNAME (GxB_MIN_MIN_INT32) ;
    GETNAME (GxB_MIN_MIN_INT64) ;
    GETNAME (GxB_MIN_MIN_UINT8) ;
    GETNAME (GxB_MIN_MIN_UINT16) ;
    GETNAME (GxB_MIN_MIN_UINT32) ;
    GETNAME (GxB_MIN_MIN_UINT64) ;
    GETNAME (GxB_MIN_MIN_FP32) ;
    GETNAME (GxB_MIN_MIN_FP64) ;

    GETNAME (GrB_MAX_MIN_SEMIRING_INT8) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_INT16) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_INT32) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_INT64) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_UINT8) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_UINT16) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_UINT32) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_UINT64) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_FP32) ;
    GETNAME (GrB_MAX_MIN_SEMIRING_FP64) ;

    GETNAM2 (GxB_MAX_MIN_INT8,    "GrB_MAX_MIN_SEMIRING_INT8") ;
    GETNAM2 (GxB_MAX_MIN_INT16,   "GrB_MAX_MIN_SEMIRING_INT16") ;
    GETNAM2 (GxB_MAX_MIN_INT32,   "GrB_MAX_MIN_SEMIRING_INT32") ;
    GETNAM2 (GxB_MAX_MIN_INT64,   "GrB_MAX_MIN_SEMIRING_INT64") ;
    GETNAM2 (GxB_MAX_MIN_UINT8,   "GrB_MAX_MIN_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MAX_MIN_UINT16,  "GrB_MAX_MIN_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MAX_MIN_UINT32,  "GrB_MAX_MIN_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MAX_MIN_UINT64,  "GrB_MAX_MIN_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MAX_MIN_FP32,    "GrB_MAX_MIN_SEMIRING_FP32") ;
    GETNAM2 (GxB_MAX_MIN_FP64,    "GrB_MAX_MIN_SEMIRING_FP64") ;

    GETNAME (GrB_PLUS_MIN_SEMIRING_INT8) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_INT16) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_INT32) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_INT64) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_UINT8) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_UINT16) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_UINT32) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_UINT64) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_FP32) ;
    GETNAME (GrB_PLUS_MIN_SEMIRING_FP64) ;

    GETNAM2 (GxB_PLUS_MIN_INT8,    "GrB_PLUS_MIN_SEMIRING_INT8") ;
    GETNAM2 (GxB_PLUS_MIN_INT16,   "GrB_PLUS_MIN_SEMIRING_INT16") ;
    GETNAM2 (GxB_PLUS_MIN_INT32,   "GrB_PLUS_MIN_SEMIRING_INT32") ;
    GETNAM2 (GxB_PLUS_MIN_INT64,   "GrB_PLUS_MIN_SEMIRING_INT64") ;
    GETNAM2 (GxB_PLUS_MIN_UINT8,   "GrB_PLUS_MIN_SEMIRING_UINT8") ;
    GETNAM2 (GxB_PLUS_MIN_UINT16,  "GrB_PLUS_MIN_SEMIRING_UINT16") ;
    GETNAM2 (GxB_PLUS_MIN_UINT32,  "GrB_PLUS_MIN_SEMIRING_UINT32") ;
    GETNAM2 (GxB_PLUS_MIN_UINT64,  "GrB_PLUS_MIN_SEMIRING_UINT64") ;
    GETNAM2 (GxB_PLUS_MIN_FP32,    "GrB_PLUS_MIN_SEMIRING_FP32") ;
    GETNAM2 (GxB_PLUS_MIN_FP64,    "GrB_PLUS_MIN_SEMIRING_FP64") ;

    GETNAME (GxB_TIMES_MIN_INT8) ;
    GETNAME (GxB_TIMES_MIN_INT16) ;
    GETNAME (GxB_TIMES_MIN_INT32) ;
    GETNAME (GxB_TIMES_MIN_INT64) ;
    GETNAME (GxB_TIMES_MIN_UINT8) ;
    GETNAME (GxB_TIMES_MIN_UINT16) ;
    GETNAME (GxB_TIMES_MIN_UINT32) ;
    GETNAME (GxB_TIMES_MIN_UINT64) ;
    GETNAME (GxB_TIMES_MIN_FP32) ;
    GETNAME (GxB_TIMES_MIN_FP64) ;

    GETNAME (GxB_ANY_MIN_INT8) ;
    GETNAME (GxB_ANY_MIN_INT16) ;
    GETNAME (GxB_ANY_MIN_INT32) ;
    GETNAME (GxB_ANY_MIN_INT64) ;
    GETNAME (GxB_ANY_MIN_UINT8) ;
    GETNAME (GxB_ANY_MIN_UINT16) ;
    GETNAME (GxB_ANY_MIN_UINT32) ;
    GETNAME (GxB_ANY_MIN_UINT64) ;
    GETNAME (GxB_ANY_MIN_FP32) ;
    GETNAME (GxB_ANY_MIN_FP64) ;

    //--------------------------------------------------------------------------
    // *_MAX
    //--------------------------------------------------------------------------

    GETNAME (GxB_MAX_MAX_INT8) ;
    GETNAME (GxB_MAX_MAX_INT16) ;
    GETNAME (GxB_MAX_MAX_INT32) ;
    GETNAME (GxB_MAX_MAX_INT64) ;
    GETNAME (GxB_MAX_MAX_UINT8) ;
    GETNAME (GxB_MAX_MAX_UINT16) ;
    GETNAME (GxB_MAX_MAX_UINT32) ;
    GETNAME (GxB_MAX_MAX_UINT64) ;
    GETNAME (GxB_MAX_MAX_FP32) ;
    GETNAME (GxB_MAX_MAX_FP64) ;

    GETNAME (GrB_MIN_MAX_SEMIRING_INT8) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_INT16) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_INT32) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_INT64) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_UINT8) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_UINT16) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_UINT32) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_UINT64) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_FP32) ;
    GETNAME (GrB_MIN_MAX_SEMIRING_FP64) ;

    GETNAM2 (GxB_MIN_MAX_INT8,    "GrB_MIN_MAX_SEMIRING_INT8") ;
    GETNAM2 (GxB_MIN_MAX_INT16,   "GrB_MIN_MAX_SEMIRING_INT16") ;
    GETNAM2 (GxB_MIN_MAX_INT32,   "GrB_MIN_MAX_SEMIRING_INT32") ;
    GETNAM2 (GxB_MIN_MAX_INT64,   "GrB_MIN_MAX_SEMIRING_INT64") ;
    GETNAM2 (GxB_MIN_MAX_UINT8,   "GrB_MIN_MAX_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MIN_MAX_UINT16,  "GrB_MIN_MAX_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MIN_MAX_UINT32,  "GrB_MIN_MAX_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MIN_MAX_UINT64,  "GrB_MIN_MAX_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MIN_MAX_FP32,    "GrB_MIN_MAX_SEMIRING_FP32") ;
    GETNAM2 (GxB_MIN_MAX_FP64,    "GrB_MIN_MAX_SEMIRING_FP64") ;

    GETNAME (GxB_PLUS_MAX_INT8) ;
    GETNAME (GxB_PLUS_MAX_INT16) ;
    GETNAME (GxB_PLUS_MAX_INT32) ;
    GETNAME (GxB_PLUS_MAX_INT64) ;
    GETNAME (GxB_PLUS_MAX_UINT8) ;
    GETNAME (GxB_PLUS_MAX_UINT16) ;
    GETNAME (GxB_PLUS_MAX_UINT32) ;
    GETNAME (GxB_PLUS_MAX_UINT64) ;
    GETNAME (GxB_PLUS_MAX_FP32) ;
    GETNAME (GxB_PLUS_MAX_FP64) ;

    GETNAME (GxB_TIMES_MAX_INT8) ;
    GETNAME (GxB_TIMES_MAX_INT16) ;
    GETNAME (GxB_TIMES_MAX_INT32) ;
    GETNAME (GxB_TIMES_MAX_INT64) ;
    GETNAME (GxB_TIMES_MAX_UINT8) ;
    GETNAME (GxB_TIMES_MAX_UINT16) ;
    GETNAME (GxB_TIMES_MAX_UINT32) ;
    GETNAME (GxB_TIMES_MAX_UINT64) ;
    GETNAME (GxB_TIMES_MAX_FP32) ;
    GETNAME (GxB_TIMES_MAX_FP64) ;

    GETNAME (GxB_ANY_MAX_INT8) ;
    GETNAME (GxB_ANY_MAX_INT16) ;
    GETNAME (GxB_ANY_MAX_INT32) ;
    GETNAME (GxB_ANY_MAX_INT64) ;
    GETNAME (GxB_ANY_MAX_UINT8) ;
    GETNAME (GxB_ANY_MAX_UINT16) ;
    GETNAME (GxB_ANY_MAX_UINT32) ;
    GETNAME (GxB_ANY_MAX_UINT64) ;
    GETNAME (GxB_ANY_MAX_FP32) ;
    GETNAME (GxB_ANY_MAX_FP64) ;

    //--------------------------------------------------------------------------
    // *_PLUS
    //--------------------------------------------------------------------------

    GETNAME (GrB_MIN_PLUS_SEMIRING_INT8) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_INT16) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_INT32) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_INT64) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_UINT8) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_UINT16) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_UINT32) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_UINT64) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_FP32) ;
    GETNAME (GrB_MIN_PLUS_SEMIRING_FP64) ;

    GETNAM2 (GxB_MIN_PLUS_INT8,    "GrB_MIN_PLUS_SEMIRING_INT8") ;
    GETNAM2 (GxB_MIN_PLUS_INT16,   "GrB_MIN_PLUS_SEMIRING_INT16") ;
    GETNAM2 (GxB_MIN_PLUS_INT32,   "GrB_MIN_PLUS_SEMIRING_INT32") ;
    GETNAM2 (GxB_MIN_PLUS_INT64,   "GrB_MIN_PLUS_SEMIRING_INT64") ;
    GETNAM2 (GxB_MIN_PLUS_UINT8,   "GrB_MIN_PLUS_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MIN_PLUS_UINT16,  "GrB_MIN_PLUS_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MIN_PLUS_UINT32,  "GrB_MIN_PLUS_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MIN_PLUS_UINT64,  "GrB_MIN_PLUS_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MIN_PLUS_FP32,    "GrB_MIN_PLUS_SEMIRING_FP32") ;
    GETNAM2 (GxB_MIN_PLUS_FP64,    "GrB_MIN_PLUS_SEMIRING_FP64") ;

    GETNAME (GrB_MAX_PLUS_SEMIRING_INT8) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_INT16) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_INT32) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_INT64) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_UINT8) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_UINT16) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_UINT32) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_UINT64) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_FP32) ;
    GETNAME (GrB_MAX_PLUS_SEMIRING_FP64) ;

    GETNAM2 (GxB_MAX_PLUS_INT8,    "GrB_MAX_PLUS_SEMIRING_INT8") ;
    GETNAM2 (GxB_MAX_PLUS_INT16,   "GrB_MAX_PLUS_SEMIRING_INT16") ;
    GETNAM2 (GxB_MAX_PLUS_INT32,   "GrB_MAX_PLUS_SEMIRING_INT32") ;
    GETNAM2 (GxB_MAX_PLUS_INT64,   "GrB_MAX_PLUS_SEMIRING_INT64") ;
    GETNAM2 (GxB_MAX_PLUS_UINT8,   "GrB_MAX_PLUS_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MAX_PLUS_UINT16,  "GrB_MAX_PLUS_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MAX_PLUS_UINT32,  "GrB_MAX_PLUS_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MAX_PLUS_UINT64,  "GrB_MAX_PLUS_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MAX_PLUS_FP32,    "GrB_MAX_PLUS_SEMIRING_FP32") ;
    GETNAM2 (GxB_MAX_PLUS_FP64,    "GrB_MAX_PLUS_SEMIRING_FP64") ;

    GETNAME (GxB_PLUS_PLUS_INT8) ;
    GETNAME (GxB_PLUS_PLUS_INT16) ;
    GETNAME (GxB_PLUS_PLUS_INT32) ;
    GETNAME (GxB_PLUS_PLUS_INT64) ;
    GETNAME (GxB_PLUS_PLUS_UINT8) ;
    GETNAME (GxB_PLUS_PLUS_UINT16) ;
    GETNAME (GxB_PLUS_PLUS_UINT32) ;
    GETNAME (GxB_PLUS_PLUS_UINT64) ;
    GETNAME (GxB_PLUS_PLUS_FP32) ;
    GETNAME (GxB_PLUS_PLUS_FP64) ;
    GETNAME (GxB_PLUS_PLUS_FC32) ;
    GETNAME (GxB_PLUS_PLUS_FC64) ;

    GETNAME (GxB_TIMES_PLUS_INT8) ;
    GETNAME (GxB_TIMES_PLUS_INT16) ;
    GETNAME (GxB_TIMES_PLUS_INT32) ;
    GETNAME (GxB_TIMES_PLUS_INT64) ;
    GETNAME (GxB_TIMES_PLUS_UINT8) ;
    GETNAME (GxB_TIMES_PLUS_UINT16) ;
    GETNAME (GxB_TIMES_PLUS_UINT32) ;
    GETNAME (GxB_TIMES_PLUS_UINT64) ;
    GETNAME (GxB_TIMES_PLUS_FP32) ;
    GETNAME (GxB_TIMES_PLUS_FP64) ;
    GETNAME (GxB_TIMES_PLUS_FC32) ;
    GETNAME (GxB_TIMES_PLUS_FC64) ;

    GETNAME (GxB_ANY_PLUS_INT8) ;
    GETNAME (GxB_ANY_PLUS_INT16) ;
    GETNAME (GxB_ANY_PLUS_INT32) ;
    GETNAME (GxB_ANY_PLUS_INT64) ;
    GETNAME (GxB_ANY_PLUS_UINT8) ;
    GETNAME (GxB_ANY_PLUS_UINT16) ;
    GETNAME (GxB_ANY_PLUS_UINT32) ;
    GETNAME (GxB_ANY_PLUS_UINT64) ;
    GETNAME (GxB_ANY_PLUS_FP32) ;
    GETNAME (GxB_ANY_PLUS_FP64) ;
    GETNAME (GxB_ANY_PLUS_FC32) ;
    GETNAME (GxB_ANY_PLUS_FC64) ;

    //--------------------------------------------------------------------------
    // *_MINUS
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_MINUS_INT8) ;
    GETNAME (GxB_MIN_MINUS_INT16) ;
    GETNAME (GxB_MIN_MINUS_INT32) ;
    GETNAME (GxB_MIN_MINUS_INT64) ;
    GETNAME (GxB_MIN_MINUS_UINT8) ;
    GETNAME (GxB_MIN_MINUS_UINT16) ;
    GETNAME (GxB_MIN_MINUS_UINT32) ;
    GETNAME (GxB_MIN_MINUS_UINT64) ;
    GETNAME (GxB_MIN_MINUS_FP32) ;
    GETNAME (GxB_MIN_MINUS_FP64) ;

    GETNAME (GxB_MAX_MINUS_INT8) ;
    GETNAME (GxB_MAX_MINUS_INT16) ;
    GETNAME (GxB_MAX_MINUS_INT32) ;
    GETNAME (GxB_MAX_MINUS_INT64) ;
    GETNAME (GxB_MAX_MINUS_UINT8) ;
    GETNAME (GxB_MAX_MINUS_UINT16) ;
    GETNAME (GxB_MAX_MINUS_UINT32) ;
    GETNAME (GxB_MAX_MINUS_UINT64) ;
    GETNAME (GxB_MAX_MINUS_FP32) ;
    GETNAME (GxB_MAX_MINUS_FP64) ;

    GETNAME (GxB_PLUS_MINUS_INT8) ;
    GETNAME (GxB_PLUS_MINUS_INT16) ;
    GETNAME (GxB_PLUS_MINUS_INT32) ;
    GETNAME (GxB_PLUS_MINUS_INT64) ;
    GETNAME (GxB_PLUS_MINUS_UINT8) ;
    GETNAME (GxB_PLUS_MINUS_UINT16) ;
    GETNAME (GxB_PLUS_MINUS_UINT32) ;
    GETNAME (GxB_PLUS_MINUS_UINT64) ;
    GETNAME (GxB_PLUS_MINUS_FP32) ;
    GETNAME (GxB_PLUS_MINUS_FP64) ;
    GETNAME (GxB_PLUS_MINUS_FC32) ;
    GETNAME (GxB_PLUS_MINUS_FC64) ;

    GETNAME (GxB_TIMES_MINUS_INT8) ;
    GETNAME (GxB_TIMES_MINUS_INT16) ;
    GETNAME (GxB_TIMES_MINUS_INT32) ;
    GETNAME (GxB_TIMES_MINUS_INT64) ;
    GETNAME (GxB_TIMES_MINUS_UINT8) ;
    GETNAME (GxB_TIMES_MINUS_UINT16) ;
    GETNAME (GxB_TIMES_MINUS_UINT32) ;
    GETNAME (GxB_TIMES_MINUS_UINT64) ;
    GETNAME (GxB_TIMES_MINUS_FP32) ;
    GETNAME (GxB_TIMES_MINUS_FP64) ;
    GETNAME (GxB_TIMES_MINUS_FC32) ;
    GETNAME (GxB_TIMES_MINUS_FC64) ;

    GETNAME (GxB_ANY_MINUS_INT8) ;
    GETNAME (GxB_ANY_MINUS_INT16) ;
    GETNAME (GxB_ANY_MINUS_INT32) ;
    GETNAME (GxB_ANY_MINUS_INT64) ;
    GETNAME (GxB_ANY_MINUS_UINT8) ;
    GETNAME (GxB_ANY_MINUS_UINT16) ;
    GETNAME (GxB_ANY_MINUS_UINT32) ;
    GETNAME (GxB_ANY_MINUS_UINT64) ;
    GETNAME (GxB_ANY_MINUS_FP32) ;
    GETNAME (GxB_ANY_MINUS_FP64) ;
    GETNAME (GxB_ANY_MINUS_FC32) ;
    GETNAME (GxB_ANY_MINUS_FC64) ;

    //--------------------------------------------------------------------------
    // *_TIMES
    //--------------------------------------------------------------------------

    GETNAME (GrB_MIN_TIMES_SEMIRING_INT8) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_INT16) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_INT32) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_INT64) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_UINT8) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_UINT16) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_UINT32) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_UINT64) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_FP32) ;
    GETNAME (GrB_MIN_TIMES_SEMIRING_FP64) ;

    GETNAM2 (GxB_MIN_TIMES_INT8,    "GrB_MIN_TIMES_SEMIRING_INT8") ;
    GETNAM2 (GxB_MIN_TIMES_INT16,   "GrB_MIN_TIMES_SEMIRING_INT16") ;
    GETNAM2 (GxB_MIN_TIMES_INT32,   "GrB_MIN_TIMES_SEMIRING_INT32") ;
    GETNAM2 (GxB_MIN_TIMES_INT64,   "GrB_MIN_TIMES_SEMIRING_INT64") ;
    GETNAM2 (GxB_MIN_TIMES_UINT8,   "GrB_MIN_TIMES_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MIN_TIMES_UINT16,  "GrB_MIN_TIMES_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MIN_TIMES_UINT32,  "GrB_MIN_TIMES_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MIN_TIMES_UINT64,  "GrB_MIN_TIMES_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MIN_TIMES_FP32,    "GrB_MIN_TIMES_SEMIRING_FP32") ;
    GETNAM2 (GxB_MIN_TIMES_FP64,    "GrB_MIN_TIMES_SEMIRING_FP64") ;

    GETNAME (GrB_MAX_TIMES_SEMIRING_INT8) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_INT16) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_INT32) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_INT64) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_UINT8) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_UINT16) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_UINT32) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_UINT64) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_FP32) ;
    GETNAME (GrB_MAX_TIMES_SEMIRING_FP64) ;

    GETNAM2 (GxB_MAX_TIMES_INT8,    "GrB_MAX_TIMES_SEMIRING_INT8") ;
    GETNAM2 (GxB_MAX_TIMES_INT16,   "GrB_MAX_TIMES_SEMIRING_INT16") ;
    GETNAM2 (GxB_MAX_TIMES_INT32,   "GrB_MAX_TIMES_SEMIRING_INT32") ;
    GETNAM2 (GxB_MAX_TIMES_INT64,   "GrB_MAX_TIMES_SEMIRING_INT64") ;
    GETNAM2 (GxB_MAX_TIMES_UINT8,   "GrB_MAX_TIMES_SEMIRING_UINT8") ;
    GETNAM2 (GxB_MAX_TIMES_UINT16,  "GrB_MAX_TIMES_SEMIRING_UINT16") ;
    GETNAM2 (GxB_MAX_TIMES_UINT32,  "GrB_MAX_TIMES_SEMIRING_UINT32") ;
    GETNAM2 (GxB_MAX_TIMES_UINT64,  "GrB_MAX_TIMES_SEMIRING_UINT64") ;
    GETNAM2 (GxB_MAX_TIMES_FP32,    "GrB_MAX_TIMES_SEMIRING_FP32") ;
    GETNAM2 (GxB_MAX_TIMES_FP64,    "GrB_MAX_TIMES_SEMIRING_FP64") ;

    GETNAME (GrB_PLUS_TIMES_SEMIRING_INT8) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_INT16) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_INT32) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_INT64) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_UINT8) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_UINT16) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_UINT32) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_UINT64) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_FP32) ;
    GETNAME (GrB_PLUS_TIMES_SEMIRING_FP64) ;

    GETNAM2 (GxB_PLUS_TIMES_INT8,    "GrB_PLUS_TIMES_SEMIRING_INT8") ;
    GETNAM2 (GxB_PLUS_TIMES_INT16,   "GrB_PLUS_TIMES_SEMIRING_INT16") ;
    GETNAM2 (GxB_PLUS_TIMES_INT32,   "GrB_PLUS_TIMES_SEMIRING_INT32") ;
    GETNAM2 (GxB_PLUS_TIMES_INT64,   "GrB_PLUS_TIMES_SEMIRING_INT64") ;
    GETNAM2 (GxB_PLUS_TIMES_UINT8,   "GrB_PLUS_TIMES_SEMIRING_UINT8") ;
    GETNAM2 (GxB_PLUS_TIMES_UINT16,  "GrB_PLUS_TIMES_SEMIRING_UINT16") ;
    GETNAM2 (GxB_PLUS_TIMES_UINT32,  "GrB_PLUS_TIMES_SEMIRING_UINT32") ;
    GETNAM2 (GxB_PLUS_TIMES_UINT64,  "GrB_PLUS_TIMES_SEMIRING_UINT64") ;
    GETNAM2 (GxB_PLUS_TIMES_FP32,    "GrB_PLUS_TIMES_SEMIRING_FP32") ;
    GETNAM2 (GxB_PLUS_TIMES_FP64,    "GrB_PLUS_TIMES_SEMIRING_FP64") ;
    GETNAME (GxB_PLUS_TIMES_FC32) ;
    GETNAME (GxB_PLUS_TIMES_FC64) ;

    GETNAME (GxB_TIMES_TIMES_INT8) ;
    GETNAME (GxB_TIMES_TIMES_INT16) ;
    GETNAME (GxB_TIMES_TIMES_INT32) ;
    GETNAME (GxB_TIMES_TIMES_INT64) ;
    GETNAME (GxB_TIMES_TIMES_UINT8) ;
    GETNAME (GxB_TIMES_TIMES_UINT16) ;
    GETNAME (GxB_TIMES_TIMES_UINT32) ;
    GETNAME (GxB_TIMES_TIMES_UINT64) ;
    GETNAME (GxB_TIMES_TIMES_FP32) ;
    GETNAME (GxB_TIMES_TIMES_FP64) ;
    GETNAME (GxB_TIMES_TIMES_FC32) ;
    GETNAME (GxB_TIMES_TIMES_FC64) ;

    GETNAME (GxB_ANY_TIMES_INT8) ;
    GETNAME (GxB_ANY_TIMES_INT16) ;
    GETNAME (GxB_ANY_TIMES_INT32) ;
    GETNAME (GxB_ANY_TIMES_INT64) ;
    GETNAME (GxB_ANY_TIMES_UINT8) ;
    GETNAME (GxB_ANY_TIMES_UINT16) ;
    GETNAME (GxB_ANY_TIMES_UINT32) ;
    GETNAME (GxB_ANY_TIMES_UINT64) ;
    GETNAME (GxB_ANY_TIMES_FP32) ;
    GETNAME (GxB_ANY_TIMES_FP64) ;
    GETNAME (GxB_ANY_TIMES_FC32) ;
    GETNAME (GxB_ANY_TIMES_FC64) ;

    //--------------------------------------------------------------------------
    // *_DIV
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_DIV_INT8) ;
    GETNAME (GxB_MIN_DIV_INT16) ;
    GETNAME (GxB_MIN_DIV_INT32) ;
    GETNAME (GxB_MIN_DIV_INT64) ;
    GETNAME (GxB_MIN_DIV_UINT8) ;
    GETNAME (GxB_MIN_DIV_UINT16) ;
    GETNAME (GxB_MIN_DIV_UINT32) ;
    GETNAME (GxB_MIN_DIV_UINT64) ;
    GETNAME (GxB_MIN_DIV_FP32) ;
    GETNAME (GxB_MIN_DIV_FP64) ;

    GETNAME (GxB_MAX_DIV_INT8) ;
    GETNAME (GxB_MAX_DIV_INT16) ;
    GETNAME (GxB_MAX_DIV_INT32) ;
    GETNAME (GxB_MAX_DIV_INT64) ;
    GETNAME (GxB_MAX_DIV_UINT8) ;
    GETNAME (GxB_MAX_DIV_UINT16) ;
    GETNAME (GxB_MAX_DIV_UINT32) ;
    GETNAME (GxB_MAX_DIV_UINT64) ;
    GETNAME (GxB_MAX_DIV_FP32) ;
    GETNAME (GxB_MAX_DIV_FP64) ;

    GETNAME (GxB_PLUS_DIV_INT8) ;
    GETNAME (GxB_PLUS_DIV_INT16) ;
    GETNAME (GxB_PLUS_DIV_INT32) ;
    GETNAME (GxB_PLUS_DIV_INT64) ;
    GETNAME (GxB_PLUS_DIV_UINT8) ;
    GETNAME (GxB_PLUS_DIV_UINT16) ;
    GETNAME (GxB_PLUS_DIV_UINT32) ;
    GETNAME (GxB_PLUS_DIV_UINT64) ;
    GETNAME (GxB_PLUS_DIV_FP32) ;
    GETNAME (GxB_PLUS_DIV_FP64) ;
    GETNAME (GxB_PLUS_DIV_FC32) ;
    GETNAME (GxB_PLUS_DIV_FC64) ;

    GETNAME (GxB_TIMES_DIV_INT8) ;
    GETNAME (GxB_TIMES_DIV_INT16) ;
    GETNAME (GxB_TIMES_DIV_INT32) ;
    GETNAME (GxB_TIMES_DIV_INT64) ;
    GETNAME (GxB_TIMES_DIV_UINT8) ;
    GETNAME (GxB_TIMES_DIV_UINT16) ;
    GETNAME (GxB_TIMES_DIV_UINT32) ;
    GETNAME (GxB_TIMES_DIV_UINT64) ;
    GETNAME (GxB_TIMES_DIV_FP32) ;
    GETNAME (GxB_TIMES_DIV_FP64) ;
    GETNAME (GxB_TIMES_DIV_FC32) ;
    GETNAME (GxB_TIMES_DIV_FC64) ;

    GETNAME (GxB_ANY_DIV_INT8) ;
    GETNAME (GxB_ANY_DIV_INT16) ;
    GETNAME (GxB_ANY_DIV_INT32) ;
    GETNAME (GxB_ANY_DIV_INT64) ;
    GETNAME (GxB_ANY_DIV_UINT8) ;
    GETNAME (GxB_ANY_DIV_UINT16) ;
    GETNAME (GxB_ANY_DIV_UINT32) ;
    GETNAME (GxB_ANY_DIV_UINT64) ;
    GETNAME (GxB_ANY_DIV_FP32) ;
    GETNAME (GxB_ANY_DIV_FP64) ;
    GETNAME (GxB_ANY_DIV_FC32) ;
    GETNAME (GxB_ANY_DIV_FC64) ;

    //--------------------------------------------------------------------------
    // *_RDIV
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_RDIV_INT8) ;
    GETNAME (GxB_MIN_RDIV_INT16) ;
    GETNAME (GxB_MIN_RDIV_INT32) ;
    GETNAME (GxB_MIN_RDIV_INT64) ;
    GETNAME (GxB_MIN_RDIV_UINT8) ;
    GETNAME (GxB_MIN_RDIV_UINT16) ;
    GETNAME (GxB_MIN_RDIV_UINT32) ;
    GETNAME (GxB_MIN_RDIV_UINT64) ;
    GETNAME (GxB_MIN_RDIV_FP32) ;
    GETNAME (GxB_MIN_RDIV_FP64) ;

    GETNAME (GxB_MAX_RDIV_INT8) ;
    GETNAME (GxB_MAX_RDIV_INT16) ;
    GETNAME (GxB_MAX_RDIV_INT32) ;
    GETNAME (GxB_MAX_RDIV_INT64) ;
    GETNAME (GxB_MAX_RDIV_UINT8) ;
    GETNAME (GxB_MAX_RDIV_UINT16) ;
    GETNAME (GxB_MAX_RDIV_UINT32) ;
    GETNAME (GxB_MAX_RDIV_UINT64) ;
    GETNAME (GxB_MAX_RDIV_FP32) ;
    GETNAME (GxB_MAX_RDIV_FP64) ;

    GETNAME (GxB_PLUS_RDIV_INT8) ;
    GETNAME (GxB_PLUS_RDIV_INT16) ;
    GETNAME (GxB_PLUS_RDIV_INT32) ;
    GETNAME (GxB_PLUS_RDIV_INT64) ;
    GETNAME (GxB_PLUS_RDIV_UINT8) ;
    GETNAME (GxB_PLUS_RDIV_UINT16) ;
    GETNAME (GxB_PLUS_RDIV_UINT32) ;
    GETNAME (GxB_PLUS_RDIV_UINT64) ;
    GETNAME (GxB_PLUS_RDIV_FP32) ;
    GETNAME (GxB_PLUS_RDIV_FP64) ;
    GETNAME (GxB_PLUS_RDIV_FC32) ;
    GETNAME (GxB_PLUS_RDIV_FC64) ;

    GETNAME (GxB_TIMES_RDIV_INT8) ;
    GETNAME (GxB_TIMES_RDIV_INT16) ;
    GETNAME (GxB_TIMES_RDIV_INT32) ;
    GETNAME (GxB_TIMES_RDIV_INT64) ;
    GETNAME (GxB_TIMES_RDIV_UINT8) ;
    GETNAME (GxB_TIMES_RDIV_UINT16) ;
    GETNAME (GxB_TIMES_RDIV_UINT32) ;
    GETNAME (GxB_TIMES_RDIV_UINT64) ;
    GETNAME (GxB_TIMES_RDIV_FP32) ;
    GETNAME (GxB_TIMES_RDIV_FP64) ;
    GETNAME (GxB_TIMES_RDIV_FC32) ;
    GETNAME (GxB_TIMES_RDIV_FC64) ;

    GETNAME (GxB_ANY_RDIV_INT8) ;
    GETNAME (GxB_ANY_RDIV_INT16) ;
    GETNAME (GxB_ANY_RDIV_INT32) ;
    GETNAME (GxB_ANY_RDIV_INT64) ;
    GETNAME (GxB_ANY_RDIV_UINT8) ;
    GETNAME (GxB_ANY_RDIV_UINT16) ;
    GETNAME (GxB_ANY_RDIV_UINT32) ;
    GETNAME (GxB_ANY_RDIV_UINT64) ;
    GETNAME (GxB_ANY_RDIV_FP32) ;
    GETNAME (GxB_ANY_RDIV_FP64) ;
    GETNAME (GxB_ANY_RDIV_FC32) ;
    GETNAME (GxB_ANY_RDIV_FC64) ;

    //--------------------------------------------------------------------------
    // *_RMINUS
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_RMINUS_INT8) ;
    GETNAME (GxB_MIN_RMINUS_INT16) ;
    GETNAME (GxB_MIN_RMINUS_INT32) ;
    GETNAME (GxB_MIN_RMINUS_INT64) ;
    GETNAME (GxB_MIN_RMINUS_UINT8) ;
    GETNAME (GxB_MIN_RMINUS_UINT16) ;
    GETNAME (GxB_MIN_RMINUS_UINT32) ;
    GETNAME (GxB_MIN_RMINUS_UINT64) ;
    GETNAME (GxB_MIN_RMINUS_FP32) ;
    GETNAME (GxB_MIN_RMINUS_FP64) ;

    GETNAME (GxB_MAX_RMINUS_INT8) ;
    GETNAME (GxB_MAX_RMINUS_INT16) ;
    GETNAME (GxB_MAX_RMINUS_INT32) ;
    GETNAME (GxB_MAX_RMINUS_INT64) ;
    GETNAME (GxB_MAX_RMINUS_UINT8) ;
    GETNAME (GxB_MAX_RMINUS_UINT16) ;
    GETNAME (GxB_MAX_RMINUS_UINT32) ;
    GETNAME (GxB_MAX_RMINUS_UINT64) ;
    GETNAME (GxB_MAX_RMINUS_FP32) ;
    GETNAME (GxB_MAX_RMINUS_FP64) ;

    GETNAME (GxB_PLUS_RMINUS_INT8) ;
    GETNAME (GxB_PLUS_RMINUS_INT16) ;
    GETNAME (GxB_PLUS_RMINUS_INT32) ;
    GETNAME (GxB_PLUS_RMINUS_INT64) ;
    GETNAME (GxB_PLUS_RMINUS_UINT8) ;
    GETNAME (GxB_PLUS_RMINUS_UINT16) ;
    GETNAME (GxB_PLUS_RMINUS_UINT32) ;
    GETNAME (GxB_PLUS_RMINUS_UINT64) ;
    GETNAME (GxB_PLUS_RMINUS_FP32) ;
    GETNAME (GxB_PLUS_RMINUS_FP64) ;
    GETNAME (GxB_PLUS_RMINUS_FC32) ;
    GETNAME (GxB_PLUS_RMINUS_FC64) ;

    GETNAME (GxB_TIMES_RMINUS_INT8) ;
    GETNAME (GxB_TIMES_RMINUS_INT16) ;
    GETNAME (GxB_TIMES_RMINUS_INT32) ;
    GETNAME (GxB_TIMES_RMINUS_INT64) ;
    GETNAME (GxB_TIMES_RMINUS_UINT8) ;
    GETNAME (GxB_TIMES_RMINUS_UINT16) ;
    GETNAME (GxB_TIMES_RMINUS_UINT32) ;
    GETNAME (GxB_TIMES_RMINUS_UINT64) ;
    GETNAME (GxB_TIMES_RMINUS_FP32) ;
    GETNAME (GxB_TIMES_RMINUS_FP64) ;
    GETNAME (GxB_TIMES_RMINUS_FC32) ;
    GETNAME (GxB_TIMES_RMINUS_FC64) ;

    GETNAME (GxB_ANY_RMINUS_INT8) ;
    GETNAME (GxB_ANY_RMINUS_INT16) ;
    GETNAME (GxB_ANY_RMINUS_INT32) ;
    GETNAME (GxB_ANY_RMINUS_INT64) ;
    GETNAME (GxB_ANY_RMINUS_UINT8) ;
    GETNAME (GxB_ANY_RMINUS_UINT16) ;
    GETNAME (GxB_ANY_RMINUS_UINT32) ;
    GETNAME (GxB_ANY_RMINUS_UINT64) ;
    GETNAME (GxB_ANY_RMINUS_FP32) ;
    GETNAME (GxB_ANY_RMINUS_FP64) ;
    GETNAME (GxB_ANY_RMINUS_FC32) ;
    GETNAME (GxB_ANY_RMINUS_FC64) ;

    //--------------------------------------------------------------------------
    // *_ISEQ
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_ISEQ_INT8) ;
    GETNAME (GxB_MIN_ISEQ_INT16) ;
    GETNAME (GxB_MIN_ISEQ_INT32) ;
    GETNAME (GxB_MIN_ISEQ_INT64) ;
    GETNAME (GxB_MIN_ISEQ_UINT8) ;
    GETNAME (GxB_MIN_ISEQ_UINT16) ;
    GETNAME (GxB_MIN_ISEQ_UINT32) ;
    GETNAME (GxB_MIN_ISEQ_UINT64) ;
    GETNAME (GxB_MIN_ISEQ_FP32) ;
    GETNAME (GxB_MIN_ISEQ_FP64) ;

    GETNAME (GxB_MAX_ISEQ_INT8) ;
    GETNAME (GxB_MAX_ISEQ_INT16) ;
    GETNAME (GxB_MAX_ISEQ_INT32) ;
    GETNAME (GxB_MAX_ISEQ_INT64) ;
    GETNAME (GxB_MAX_ISEQ_UINT8) ;
    GETNAME (GxB_MAX_ISEQ_UINT16) ;
    GETNAME (GxB_MAX_ISEQ_UINT32) ;
    GETNAME (GxB_MAX_ISEQ_UINT64) ;
    GETNAME (GxB_MAX_ISEQ_FP32) ;
    GETNAME (GxB_MAX_ISEQ_FP64) ;

    GETNAME (GxB_PLUS_ISEQ_INT8) ;
    GETNAME (GxB_PLUS_ISEQ_INT16) ;
    GETNAME (GxB_PLUS_ISEQ_INT32) ;
    GETNAME (GxB_PLUS_ISEQ_INT64) ;
    GETNAME (GxB_PLUS_ISEQ_UINT8) ;
    GETNAME (GxB_PLUS_ISEQ_UINT16) ;
    GETNAME (GxB_PLUS_ISEQ_UINT32) ;
    GETNAME (GxB_PLUS_ISEQ_UINT64) ;
    GETNAME (GxB_PLUS_ISEQ_FP32) ;
    GETNAME (GxB_PLUS_ISEQ_FP64) ;

    GETNAME (GxB_TIMES_ISEQ_INT8) ;
    GETNAME (GxB_TIMES_ISEQ_INT16) ;
    GETNAME (GxB_TIMES_ISEQ_INT32) ;
    GETNAME (GxB_TIMES_ISEQ_INT64) ;
    GETNAME (GxB_TIMES_ISEQ_UINT8) ;
    GETNAME (GxB_TIMES_ISEQ_UINT16) ;
    GETNAME (GxB_TIMES_ISEQ_UINT32) ;
    GETNAME (GxB_TIMES_ISEQ_UINT64) ;
    GETNAME (GxB_TIMES_ISEQ_FP32) ;
    GETNAME (GxB_TIMES_ISEQ_FP64) ;

    GETNAME (GxB_ANY_ISEQ_INT8) ;
    GETNAME (GxB_ANY_ISEQ_INT16) ;
    GETNAME (GxB_ANY_ISEQ_INT32) ;
    GETNAME (GxB_ANY_ISEQ_INT64) ;
    GETNAME (GxB_ANY_ISEQ_UINT8) ;
    GETNAME (GxB_ANY_ISEQ_UINT16) ;
    GETNAME (GxB_ANY_ISEQ_UINT32) ;
    GETNAME (GxB_ANY_ISEQ_UINT64) ;
    GETNAME (GxB_ANY_ISEQ_FP32) ;
    GETNAME (GxB_ANY_ISEQ_FP64) ;

    //--------------------------------------------------------------------------
    // *_ISNE
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_ISNE_INT8) ;
    GETNAME (GxB_MIN_ISNE_INT16) ;
    GETNAME (GxB_MIN_ISNE_INT32) ;
    GETNAME (GxB_MIN_ISNE_INT64) ;
    GETNAME (GxB_MIN_ISNE_UINT8) ;
    GETNAME (GxB_MIN_ISNE_UINT16) ;
    GETNAME (GxB_MIN_ISNE_UINT32) ;
    GETNAME (GxB_MIN_ISNE_UINT64) ;
    GETNAME (GxB_MIN_ISNE_FP32) ;
    GETNAME (GxB_MIN_ISNE_FP64) ;

    GETNAME (GxB_MAX_ISNE_INT8) ;
    GETNAME (GxB_MAX_ISNE_INT16) ;
    GETNAME (GxB_MAX_ISNE_INT32) ;
    GETNAME (GxB_MAX_ISNE_INT64) ;
    GETNAME (GxB_MAX_ISNE_UINT8) ;
    GETNAME (GxB_MAX_ISNE_UINT16) ;
    GETNAME (GxB_MAX_ISNE_UINT32) ;
    GETNAME (GxB_MAX_ISNE_UINT64) ;
    GETNAME (GxB_MAX_ISNE_FP32) ;
    GETNAME (GxB_MAX_ISNE_FP64) ;

    GETNAME (GxB_PLUS_ISNE_INT8) ;
    GETNAME (GxB_PLUS_ISNE_INT16) ;
    GETNAME (GxB_PLUS_ISNE_INT32) ;
    GETNAME (GxB_PLUS_ISNE_INT64) ;
    GETNAME (GxB_PLUS_ISNE_UINT8) ;
    GETNAME (GxB_PLUS_ISNE_UINT16) ;
    GETNAME (GxB_PLUS_ISNE_UINT32) ;
    GETNAME (GxB_PLUS_ISNE_UINT64) ;
    GETNAME (GxB_PLUS_ISNE_FP32) ;
    GETNAME (GxB_PLUS_ISNE_FP64) ;

    GETNAME (GxB_TIMES_ISNE_INT8) ;
    GETNAME (GxB_TIMES_ISNE_INT16) ;
    GETNAME (GxB_TIMES_ISNE_INT32) ;
    GETNAME (GxB_TIMES_ISNE_INT64) ;
    GETNAME (GxB_TIMES_ISNE_UINT8) ;
    GETNAME (GxB_TIMES_ISNE_UINT16) ;
    GETNAME (GxB_TIMES_ISNE_UINT32) ;
    GETNAME (GxB_TIMES_ISNE_UINT64) ;
    GETNAME (GxB_TIMES_ISNE_FP32) ;
    GETNAME (GxB_TIMES_ISNE_FP64) ;

    GETNAME (GxB_ANY_ISNE_INT8) ;
    GETNAME (GxB_ANY_ISNE_INT16) ;
    GETNAME (GxB_ANY_ISNE_INT32) ;
    GETNAME (GxB_ANY_ISNE_INT64) ;
    GETNAME (GxB_ANY_ISNE_UINT8) ;
    GETNAME (GxB_ANY_ISNE_UINT16) ;
    GETNAME (GxB_ANY_ISNE_UINT32) ;
    GETNAME (GxB_ANY_ISNE_UINT64) ;
    GETNAME (GxB_ANY_ISNE_FP32) ;
    GETNAME (GxB_ANY_ISNE_FP64) ;

    //--------------------------------------------------------------------------
    // *_ISGT
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_ISGT_INT8) ;
    GETNAME (GxB_MIN_ISGT_INT16) ;
    GETNAME (GxB_MIN_ISGT_INT32) ;
    GETNAME (GxB_MIN_ISGT_INT64) ;
    GETNAME (GxB_MIN_ISGT_UINT8) ;
    GETNAME (GxB_MIN_ISGT_UINT16) ;
    GETNAME (GxB_MIN_ISGT_UINT32) ;
    GETNAME (GxB_MIN_ISGT_UINT64) ;
    GETNAME (GxB_MIN_ISGT_FP32) ;
    GETNAME (GxB_MIN_ISGT_FP64) ;

    GETNAME (GxB_MAX_ISGT_INT8) ;
    GETNAME (GxB_MAX_ISGT_INT16) ;
    GETNAME (GxB_MAX_ISGT_INT32) ;
    GETNAME (GxB_MAX_ISGT_INT64) ;
    GETNAME (GxB_MAX_ISGT_UINT8) ;
    GETNAME (GxB_MAX_ISGT_UINT16) ;
    GETNAME (GxB_MAX_ISGT_UINT32) ;
    GETNAME (GxB_MAX_ISGT_UINT64) ;
    GETNAME (GxB_MAX_ISGT_FP32) ;
    GETNAME (GxB_MAX_ISGT_FP64) ;

    GETNAME (GxB_PLUS_ISGT_INT8) ;
    GETNAME (GxB_PLUS_ISGT_INT16) ;
    GETNAME (GxB_PLUS_ISGT_INT32) ;
    GETNAME (GxB_PLUS_ISGT_INT64) ;
    GETNAME (GxB_PLUS_ISGT_UINT8) ;
    GETNAME (GxB_PLUS_ISGT_UINT16) ;
    GETNAME (GxB_PLUS_ISGT_UINT32) ;
    GETNAME (GxB_PLUS_ISGT_UINT64) ;
    GETNAME (GxB_PLUS_ISGT_FP32) ;
    GETNAME (GxB_PLUS_ISGT_FP64) ;

    GETNAME (GxB_TIMES_ISGT_INT8) ;
    GETNAME (GxB_TIMES_ISGT_INT16) ;
    GETNAME (GxB_TIMES_ISGT_INT32) ;
    GETNAME (GxB_TIMES_ISGT_INT64) ;
    GETNAME (GxB_TIMES_ISGT_UINT8) ;
    GETNAME (GxB_TIMES_ISGT_UINT16) ;
    GETNAME (GxB_TIMES_ISGT_UINT32) ;
    GETNAME (GxB_TIMES_ISGT_UINT64) ;
    GETNAME (GxB_TIMES_ISGT_FP32) ;
    GETNAME (GxB_TIMES_ISGT_FP64) ;

    GETNAME (GxB_ANY_ISGT_INT8) ;
    GETNAME (GxB_ANY_ISGT_INT16) ;
    GETNAME (GxB_ANY_ISGT_INT32) ;
    GETNAME (GxB_ANY_ISGT_INT64) ;
    GETNAME (GxB_ANY_ISGT_UINT8) ;
    GETNAME (GxB_ANY_ISGT_UINT16) ;
    GETNAME (GxB_ANY_ISGT_UINT32) ;
    GETNAME (GxB_ANY_ISGT_UINT64) ;
    GETNAME (GxB_ANY_ISGT_FP32) ;
    GETNAME (GxB_ANY_ISGT_FP64) ;

    //--------------------------------------------------------------------------
    // *_ISLT
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_ISLT_INT8) ;
    GETNAME (GxB_MIN_ISLT_INT16) ;
    GETNAME (GxB_MIN_ISLT_INT32) ;
    GETNAME (GxB_MIN_ISLT_INT64) ;
    GETNAME (GxB_MIN_ISLT_UINT8) ;
    GETNAME (GxB_MIN_ISLT_UINT16) ;
    GETNAME (GxB_MIN_ISLT_UINT32) ;
    GETNAME (GxB_MIN_ISLT_UINT64) ;
    GETNAME (GxB_MIN_ISLT_FP32) ;
    GETNAME (GxB_MIN_ISLT_FP64) ;

    GETNAME (GxB_MAX_ISLT_INT8) ;
    GETNAME (GxB_MAX_ISLT_INT16) ;
    GETNAME (GxB_MAX_ISLT_INT32) ;
    GETNAME (GxB_MAX_ISLT_INT64) ;
    GETNAME (GxB_MAX_ISLT_UINT8) ;
    GETNAME (GxB_MAX_ISLT_UINT16) ;
    GETNAME (GxB_MAX_ISLT_UINT32) ;
    GETNAME (GxB_MAX_ISLT_UINT64) ;
    GETNAME (GxB_MAX_ISLT_FP32) ;
    GETNAME (GxB_MAX_ISLT_FP64) ;

    GETNAME (GxB_PLUS_ISLT_INT8) ;
    GETNAME (GxB_PLUS_ISLT_INT16) ;
    GETNAME (GxB_PLUS_ISLT_INT32) ;
    GETNAME (GxB_PLUS_ISLT_INT64) ;
    GETNAME (GxB_PLUS_ISLT_UINT8) ;
    GETNAME (GxB_PLUS_ISLT_UINT16) ;
    GETNAME (GxB_PLUS_ISLT_UINT32) ;
    GETNAME (GxB_PLUS_ISLT_UINT64) ;
    GETNAME (GxB_PLUS_ISLT_FP32) ;
    GETNAME (GxB_PLUS_ISLT_FP64) ;

    GETNAME (GxB_TIMES_ISLT_INT8) ;
    GETNAME (GxB_TIMES_ISLT_INT16) ;
    GETNAME (GxB_TIMES_ISLT_INT32) ;
    GETNAME (GxB_TIMES_ISLT_INT64) ;
    GETNAME (GxB_TIMES_ISLT_UINT8) ;
    GETNAME (GxB_TIMES_ISLT_UINT16) ;
    GETNAME (GxB_TIMES_ISLT_UINT32) ;
    GETNAME (GxB_TIMES_ISLT_UINT64) ;
    GETNAME (GxB_TIMES_ISLT_FP32) ;
    GETNAME (GxB_TIMES_ISLT_FP64) ;

    GETNAME (GxB_ANY_ISLT_INT8) ;
    GETNAME (GxB_ANY_ISLT_INT16) ;
    GETNAME (GxB_ANY_ISLT_INT32) ;
    GETNAME (GxB_ANY_ISLT_INT64) ;
    GETNAME (GxB_ANY_ISLT_UINT8) ;
    GETNAME (GxB_ANY_ISLT_UINT16) ;
    GETNAME (GxB_ANY_ISLT_UINT32) ;
    GETNAME (GxB_ANY_ISLT_UINT64) ;
    GETNAME (GxB_ANY_ISLT_FP32) ;
    GETNAME (GxB_ANY_ISLT_FP64) ;

    //--------------------------------------------------------------------------
    // *_ISGE
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_ISGE_INT8) ;
    GETNAME (GxB_MIN_ISGE_INT16) ;
    GETNAME (GxB_MIN_ISGE_INT32) ;
    GETNAME (GxB_MIN_ISGE_INT64) ;
    GETNAME (GxB_MIN_ISGE_UINT8) ;
    GETNAME (GxB_MIN_ISGE_UINT16) ;
    GETNAME (GxB_MIN_ISGE_UINT32) ;
    GETNAME (GxB_MIN_ISGE_UINT64) ;
    GETNAME (GxB_MIN_ISGE_FP32) ;
    GETNAME (GxB_MIN_ISGE_FP64) ;

    GETNAME (GxB_MAX_ISGE_INT8) ;
    GETNAME (GxB_MAX_ISGE_INT16) ;
    GETNAME (GxB_MAX_ISGE_INT32) ;
    GETNAME (GxB_MAX_ISGE_INT64) ;
    GETNAME (GxB_MAX_ISGE_UINT8) ;
    GETNAME (GxB_MAX_ISGE_UINT16) ;
    GETNAME (GxB_MAX_ISGE_UINT32) ;
    GETNAME (GxB_MAX_ISGE_UINT64) ;
    GETNAME (GxB_MAX_ISGE_FP32) ;
    GETNAME (GxB_MAX_ISGE_FP64) ;

    GETNAME (GxB_PLUS_ISGE_INT8) ;
    GETNAME (GxB_PLUS_ISGE_INT16) ;
    GETNAME (GxB_PLUS_ISGE_INT32) ;
    GETNAME (GxB_PLUS_ISGE_INT64) ;
    GETNAME (GxB_PLUS_ISGE_UINT8) ;
    GETNAME (GxB_PLUS_ISGE_UINT16) ;
    GETNAME (GxB_PLUS_ISGE_UINT32) ;
    GETNAME (GxB_PLUS_ISGE_UINT64) ;
    GETNAME (GxB_PLUS_ISGE_FP32) ;
    GETNAME (GxB_PLUS_ISGE_FP64) ;

    GETNAME (GxB_TIMES_ISGE_INT8) ;
    GETNAME (GxB_TIMES_ISGE_INT16) ;
    GETNAME (GxB_TIMES_ISGE_INT32) ;
    GETNAME (GxB_TIMES_ISGE_INT64) ;
    GETNAME (GxB_TIMES_ISGE_UINT8) ;
    GETNAME (GxB_TIMES_ISGE_UINT16) ;
    GETNAME (GxB_TIMES_ISGE_UINT32) ;
    GETNAME (GxB_TIMES_ISGE_UINT64) ;
    GETNAME (GxB_TIMES_ISGE_FP32) ;
    GETNAME (GxB_TIMES_ISGE_FP64) ;

    GETNAME (GxB_ANY_ISGE_INT8) ;
    GETNAME (GxB_ANY_ISGE_INT16) ;
    GETNAME (GxB_ANY_ISGE_INT32) ;
    GETNAME (GxB_ANY_ISGE_INT64) ;
    GETNAME (GxB_ANY_ISGE_UINT8) ;
    GETNAME (GxB_ANY_ISGE_UINT16) ;
    GETNAME (GxB_ANY_ISGE_UINT32) ;
    GETNAME (GxB_ANY_ISGE_UINT64) ;
    GETNAME (GxB_ANY_ISGE_FP32) ;
    GETNAME (GxB_ANY_ISGE_FP64) ;

    //--------------------------------------------------------------------------
    // *_ISLE
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_ISLE_INT8) ;
    GETNAME (GxB_MIN_ISLE_INT16) ;
    GETNAME (GxB_MIN_ISLE_INT32) ;
    GETNAME (GxB_MIN_ISLE_INT64) ;
    GETNAME (GxB_MIN_ISLE_UINT8) ;
    GETNAME (GxB_MIN_ISLE_UINT16) ;
    GETNAME (GxB_MIN_ISLE_UINT32) ;
    GETNAME (GxB_MIN_ISLE_UINT64) ;
    GETNAME (GxB_MIN_ISLE_FP32) ;
    GETNAME (GxB_MIN_ISLE_FP64) ;

    GETNAME (GxB_MAX_ISLE_INT8) ;
    GETNAME (GxB_MAX_ISLE_INT16) ;
    GETNAME (GxB_MAX_ISLE_INT32) ;
    GETNAME (GxB_MAX_ISLE_INT64) ;
    GETNAME (GxB_MAX_ISLE_UINT8) ;
    GETNAME (GxB_MAX_ISLE_UINT16) ;
    GETNAME (GxB_MAX_ISLE_UINT32) ;
    GETNAME (GxB_MAX_ISLE_UINT64) ;
    GETNAME (GxB_MAX_ISLE_FP32) ;
    GETNAME (GxB_MAX_ISLE_FP64) ;

    GETNAME (GxB_PLUS_ISLE_INT8) ;
    GETNAME (GxB_PLUS_ISLE_INT16) ;
    GETNAME (GxB_PLUS_ISLE_INT32) ;
    GETNAME (GxB_PLUS_ISLE_INT64) ;
    GETNAME (GxB_PLUS_ISLE_UINT8) ;
    GETNAME (GxB_PLUS_ISLE_UINT16) ;
    GETNAME (GxB_PLUS_ISLE_UINT32) ;
    GETNAME (GxB_PLUS_ISLE_UINT64) ;
    GETNAME (GxB_PLUS_ISLE_FP32) ;
    GETNAME (GxB_PLUS_ISLE_FP64) ;

    GETNAME (GxB_TIMES_ISLE_INT8) ;
    GETNAME (GxB_TIMES_ISLE_INT16) ;
    GETNAME (GxB_TIMES_ISLE_INT32) ;
    GETNAME (GxB_TIMES_ISLE_INT64) ;
    GETNAME (GxB_TIMES_ISLE_UINT8) ;
    GETNAME (GxB_TIMES_ISLE_UINT16) ;
    GETNAME (GxB_TIMES_ISLE_UINT32) ;
    GETNAME (GxB_TIMES_ISLE_UINT64) ;
    GETNAME (GxB_TIMES_ISLE_FP32) ;
    GETNAME (GxB_TIMES_ISLE_FP64) ;

    GETNAME (GxB_ANY_ISLE_INT8) ;
    GETNAME (GxB_ANY_ISLE_INT16) ;
    GETNAME (GxB_ANY_ISLE_INT32) ;
    GETNAME (GxB_ANY_ISLE_INT64) ;
    GETNAME (GxB_ANY_ISLE_UINT8) ;
    GETNAME (GxB_ANY_ISLE_UINT16) ;
    GETNAME (GxB_ANY_ISLE_UINT32) ;
    GETNAME (GxB_ANY_ISLE_UINT64) ;
    GETNAME (GxB_ANY_ISLE_FP32) ;
    GETNAME (GxB_ANY_ISLE_FP64) ;

    //--------------------------------------------------------------------------
    // *_LOR
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_LOR_INT8) ;
    GETNAME (GxB_MIN_LOR_INT16) ;
    GETNAME (GxB_MIN_LOR_INT32) ;
    GETNAME (GxB_MIN_LOR_INT64) ;
    GETNAME (GxB_MIN_LOR_UINT8) ;
    GETNAME (GxB_MIN_LOR_UINT16) ;
    GETNAME (GxB_MIN_LOR_UINT32) ;
    GETNAME (GxB_MIN_LOR_UINT64) ;
    GETNAME (GxB_MIN_LOR_FP32) ;
    GETNAME (GxB_MIN_LOR_FP64) ;

    GETNAME (GxB_MAX_LOR_INT8) ;
    GETNAME (GxB_MAX_LOR_INT16) ;
    GETNAME (GxB_MAX_LOR_INT32) ;
    GETNAME (GxB_MAX_LOR_INT64) ;
    GETNAME (GxB_MAX_LOR_UINT8) ;
    GETNAME (GxB_MAX_LOR_UINT16) ;
    GETNAME (GxB_MAX_LOR_UINT32) ;
    GETNAME (GxB_MAX_LOR_UINT64) ;
    GETNAME (GxB_MAX_LOR_FP32) ;
    GETNAME (GxB_MAX_LOR_FP64) ;

    GETNAME (GxB_PLUS_LOR_INT8) ;
    GETNAME (GxB_PLUS_LOR_INT16) ;
    GETNAME (GxB_PLUS_LOR_INT32) ;
    GETNAME (GxB_PLUS_LOR_INT64) ;
    GETNAME (GxB_PLUS_LOR_UINT8) ;
    GETNAME (GxB_PLUS_LOR_UINT16) ;
    GETNAME (GxB_PLUS_LOR_UINT32) ;
    GETNAME (GxB_PLUS_LOR_UINT64) ;
    GETNAME (GxB_PLUS_LOR_FP32) ;
    GETNAME (GxB_PLUS_LOR_FP64) ;

    GETNAME (GxB_TIMES_LOR_INT8) ;
    GETNAME (GxB_TIMES_LOR_INT16) ;
    GETNAME (GxB_TIMES_LOR_INT32) ;
    GETNAME (GxB_TIMES_LOR_INT64) ;
    GETNAME (GxB_TIMES_LOR_UINT8) ;
    GETNAME (GxB_TIMES_LOR_UINT16) ;
    GETNAME (GxB_TIMES_LOR_UINT32) ;
    GETNAME (GxB_TIMES_LOR_UINT64) ;
    GETNAME (GxB_TIMES_LOR_FP32) ;
    GETNAME (GxB_TIMES_LOR_FP64) ;

    GETNAME (GxB_ANY_LOR_INT8) ;
    GETNAME (GxB_ANY_LOR_INT16) ;
    GETNAME (GxB_ANY_LOR_INT32) ;
    GETNAME (GxB_ANY_LOR_INT64) ;
    GETNAME (GxB_ANY_LOR_UINT8) ;
    GETNAME (GxB_ANY_LOR_UINT16) ;
    GETNAME (GxB_ANY_LOR_UINT32) ;
    GETNAME (GxB_ANY_LOR_UINT64) ;
    GETNAME (GxB_ANY_LOR_FP32) ;
    GETNAME (GxB_ANY_LOR_FP64) ;

    GETNAME (GxB_LOR_LOR_BOOL) ;
    GETNAME (GxB_LXOR_LOR_BOOL) ;
    GETNAME (GxB_ANY_LOR_BOOL) ;

    GETNAM2 (GxB_LAND_LOR_BOOL, "GrB_LAND_LOR_SEMIRING_BOOL") ;
    GETNAME (GrB_LAND_LOR_SEMIRING_BOOL) ;

    GETNAM2 (GxB_EQ_LOR_BOOL, "GrB_LXNOR_LOR_SEMIRING_BOOL") ;
    GETNAME (GrB_LXNOR_LOR_SEMIRING_BOOL) ;

    //--------------------------------------------------------------------------
    // *_LAND
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_LAND_INT8) ;
    GETNAME (GxB_MIN_LAND_INT16) ;
    GETNAME (GxB_MIN_LAND_INT32) ;
    GETNAME (GxB_MIN_LAND_INT64) ;
    GETNAME (GxB_MIN_LAND_UINT8) ;
    GETNAME (GxB_MIN_LAND_UINT16) ;
    GETNAME (GxB_MIN_LAND_UINT32) ;
    GETNAME (GxB_MIN_LAND_UINT64) ;
    GETNAME (GxB_MIN_LAND_FP32) ;
    GETNAME (GxB_MIN_LAND_FP64) ;

    GETNAME (GxB_MAX_LAND_INT8) ;
    GETNAME (GxB_MAX_LAND_INT16) ;
    GETNAME (GxB_MAX_LAND_INT32) ;
    GETNAME (GxB_MAX_LAND_INT64) ;
    GETNAME (GxB_MAX_LAND_UINT8) ;
    GETNAME (GxB_MAX_LAND_UINT16) ;
    GETNAME (GxB_MAX_LAND_UINT32) ;
    GETNAME (GxB_MAX_LAND_UINT64) ;
    GETNAME (GxB_MAX_LAND_FP32) ;
    GETNAME (GxB_MAX_LAND_FP64) ;

    GETNAME (GxB_PLUS_LAND_INT8) ;
    GETNAME (GxB_PLUS_LAND_INT16) ;
    GETNAME (GxB_PLUS_LAND_INT32) ;
    GETNAME (GxB_PLUS_LAND_INT64) ;
    GETNAME (GxB_PLUS_LAND_UINT8) ;
    GETNAME (GxB_PLUS_LAND_UINT16) ;
    GETNAME (GxB_PLUS_LAND_UINT32) ;
    GETNAME (GxB_PLUS_LAND_UINT64) ;
    GETNAME (GxB_PLUS_LAND_FP32) ;
    GETNAME (GxB_PLUS_LAND_FP64) ;

    GETNAME (GxB_TIMES_LAND_INT8) ;
    GETNAME (GxB_TIMES_LAND_INT16) ;
    GETNAME (GxB_TIMES_LAND_INT32) ;
    GETNAME (GxB_TIMES_LAND_INT64) ;
    GETNAME (GxB_TIMES_LAND_UINT8) ;
    GETNAME (GxB_TIMES_LAND_UINT16) ;
    GETNAME (GxB_TIMES_LAND_UINT32) ;
    GETNAME (GxB_TIMES_LAND_UINT64) ;
    GETNAME (GxB_TIMES_LAND_FP32) ;
    GETNAME (GxB_TIMES_LAND_FP64) ;

    GETNAME (GxB_ANY_LAND_INT8) ;
    GETNAME (GxB_ANY_LAND_INT16) ;
    GETNAME (GxB_ANY_LAND_INT32) ;
    GETNAME (GxB_ANY_LAND_INT64) ;
    GETNAME (GxB_ANY_LAND_UINT8) ;
    GETNAME (GxB_ANY_LAND_UINT16) ;
    GETNAME (GxB_ANY_LAND_UINT32) ;
    GETNAME (GxB_ANY_LAND_UINT64) ;
    GETNAME (GxB_ANY_LAND_FP32) ;
    GETNAME (GxB_ANY_LAND_FP64) ;

    GETNAME (GxB_LAND_LAND_BOOL) ;
    GETNAME (GxB_ANY_LAND_BOOL) ;
    GETNAME (GxB_EQ_LAND_BOOL) ;

    GETNAM2 (GxB_LOR_LAND_BOOL, "GrB_LOR_LAND_SEMIRING_BOOL") ;
    GETNAME (GrB_LOR_LAND_SEMIRING_BOOL) ;

    GETNAM2 (GxB_LXOR_LAND_BOOL, "GrB_LXOR_LAND_SEMIRING_BOOL") ;
    GETNAME (GrB_LXOR_LAND_SEMIRING_BOOL) ;

    //--------------------------------------------------------------------------
    // *_LXOR
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_LXOR_INT8) ;
    GETNAME (GxB_MIN_LXOR_INT16) ;
    GETNAME (GxB_MIN_LXOR_INT32) ;
    GETNAME (GxB_MIN_LXOR_INT64) ;
    GETNAME (GxB_MIN_LXOR_UINT8) ;
    GETNAME (GxB_MIN_LXOR_UINT16) ;
    GETNAME (GxB_MIN_LXOR_UINT32) ;
    GETNAME (GxB_MIN_LXOR_UINT64) ;
    GETNAME (GxB_MIN_LXOR_FP32) ;
    GETNAME (GxB_MIN_LXOR_FP64) ;

    GETNAME (GxB_MAX_LXOR_INT8) ;
    GETNAME (GxB_MAX_LXOR_INT16) ;
    GETNAME (GxB_MAX_LXOR_INT32) ;
    GETNAME (GxB_MAX_LXOR_INT64) ;
    GETNAME (GxB_MAX_LXOR_UINT8) ;
    GETNAME (GxB_MAX_LXOR_UINT16) ;
    GETNAME (GxB_MAX_LXOR_UINT32) ;
    GETNAME (GxB_MAX_LXOR_UINT64) ;
    GETNAME (GxB_MAX_LXOR_FP32) ;
    GETNAME (GxB_MAX_LXOR_FP64) ;

    GETNAME (GxB_PLUS_LXOR_INT8) ;
    GETNAME (GxB_PLUS_LXOR_INT16) ;
    GETNAME (GxB_PLUS_LXOR_INT32) ;
    GETNAME (GxB_PLUS_LXOR_INT64) ;
    GETNAME (GxB_PLUS_LXOR_UINT8) ;
    GETNAME (GxB_PLUS_LXOR_UINT16) ;
    GETNAME (GxB_PLUS_LXOR_UINT32) ;
    GETNAME (GxB_PLUS_LXOR_UINT64) ;
    GETNAME (GxB_PLUS_LXOR_FP32) ;
    GETNAME (GxB_PLUS_LXOR_FP64) ;

    GETNAME (GxB_TIMES_LXOR_INT8) ;
    GETNAME (GxB_TIMES_LXOR_INT16) ;
    GETNAME (GxB_TIMES_LXOR_INT32) ;
    GETNAME (GxB_TIMES_LXOR_INT64) ;
    GETNAME (GxB_TIMES_LXOR_UINT8) ;
    GETNAME (GxB_TIMES_LXOR_UINT16) ;
    GETNAME (GxB_TIMES_LXOR_UINT32) ;
    GETNAME (GxB_TIMES_LXOR_UINT64) ;
    GETNAME (GxB_TIMES_LXOR_FP32) ;
    GETNAME (GxB_TIMES_LXOR_FP64) ;

    GETNAME (GxB_ANY_LXOR_INT8) ;
    GETNAME (GxB_ANY_LXOR_INT16) ;
    GETNAME (GxB_ANY_LXOR_INT32) ;
    GETNAME (GxB_ANY_LXOR_INT64) ;
    GETNAME (GxB_ANY_LXOR_UINT8) ;
    GETNAME (GxB_ANY_LXOR_UINT16) ;
    GETNAME (GxB_ANY_LXOR_UINT32) ;
    GETNAME (GxB_ANY_LXOR_UINT64) ;
    GETNAME (GxB_ANY_LXOR_FP32) ;
    GETNAME (GxB_ANY_LXOR_FP64) ;

    GETNAME (GxB_LOR_LXOR_BOOL) ;
    GETNAME (GxB_LAND_LXOR_BOOL) ;
    GETNAME (GxB_LXOR_LXOR_BOOL) ;
    GETNAME (GxB_EQ_LXOR_BOOL) ;
    GETNAME (GxB_ANY_LXOR_BOOL) ;

    //--------------------------------------------------------------------------
    // *_EQ
    //--------------------------------------------------------------------------

    GETNAME (GxB_LOR_EQ_INT8) ;
    GETNAME (GxB_LOR_EQ_INT16) ;
    GETNAME (GxB_LOR_EQ_INT32) ;
    GETNAME (GxB_LOR_EQ_INT64) ;
    GETNAME (GxB_LOR_EQ_UINT8) ;
    GETNAME (GxB_LOR_EQ_UINT16) ;
    GETNAME (GxB_LOR_EQ_UINT32) ;
    GETNAME (GxB_LOR_EQ_UINT64) ;
    GETNAME (GxB_LOR_EQ_FP32) ;
    GETNAME (GxB_LOR_EQ_FP64) ;

    GETNAME (GxB_LAND_EQ_INT8) ;
    GETNAME (GxB_LAND_EQ_INT16) ;
    GETNAME (GxB_LAND_EQ_INT32) ;
    GETNAME (GxB_LAND_EQ_INT64) ;
    GETNAME (GxB_LAND_EQ_UINT8) ;
    GETNAME (GxB_LAND_EQ_UINT16) ;
    GETNAME (GxB_LAND_EQ_UINT32) ;
    GETNAME (GxB_LAND_EQ_UINT64) ;
    GETNAME (GxB_LAND_EQ_FP32) ;
    GETNAME (GxB_LAND_EQ_FP64) ;

    GETNAME (GxB_LXOR_EQ_INT8) ;
    GETNAME (GxB_LXOR_EQ_INT16) ;
    GETNAME (GxB_LXOR_EQ_INT32) ;
    GETNAME (GxB_LXOR_EQ_INT64) ;
    GETNAME (GxB_LXOR_EQ_UINT8) ;
    GETNAME (GxB_LXOR_EQ_UINT16) ;
    GETNAME (GxB_LXOR_EQ_UINT32) ;
    GETNAME (GxB_LXOR_EQ_UINT64) ;
    GETNAME (GxB_LXOR_EQ_FP32) ;
    GETNAME (GxB_LXOR_EQ_FP64) ;

    GETNAME (GxB_EQ_EQ_INT8) ;
    GETNAME (GxB_EQ_EQ_INT16) ;
    GETNAME (GxB_EQ_EQ_INT32) ;
    GETNAME (GxB_EQ_EQ_INT64) ;
    GETNAME (GxB_EQ_EQ_UINT8) ;
    GETNAME (GxB_EQ_EQ_UINT16) ;
    GETNAME (GxB_EQ_EQ_UINT32) ;
    GETNAME (GxB_EQ_EQ_UINT64) ;
    GETNAME (GxB_EQ_EQ_FP32) ;
    GETNAME (GxB_EQ_EQ_FP64) ;

    GETNAME (GxB_ANY_EQ_INT8) ;
    GETNAME (GxB_ANY_EQ_INT16) ;
    GETNAME (GxB_ANY_EQ_INT32) ;
    GETNAME (GxB_ANY_EQ_INT64) ;
    GETNAME (GxB_ANY_EQ_UINT8) ;
    GETNAME (GxB_ANY_EQ_UINT16) ;
    GETNAME (GxB_ANY_EQ_UINT32) ;
    GETNAME (GxB_ANY_EQ_UINT64) ;
    GETNAME (GxB_ANY_EQ_FP32) ;
    GETNAME (GxB_ANY_EQ_FP64) ;

    GETNAME (GxB_LOR_EQ_BOOL) ;
    GETNAME (GxB_LAND_EQ_BOOL) ;
    GETNAME (GxB_LXOR_EQ_BOOL) ;
    GETNAME (GxB_EQ_EQ_BOOL) ;
    GETNAME (GxB_ANY_EQ_BOOL) ;

    //--------------------------------------------------------------------------
    // *_NE
    //--------------------------------------------------------------------------

    GETNAME (GxB_LOR_NE_INT8) ;
    GETNAME (GxB_LOR_NE_INT16) ;
    GETNAME (GxB_LOR_NE_INT32) ;
    GETNAME (GxB_LOR_NE_INT64) ;
    GETNAME (GxB_LOR_NE_UINT8) ;
    GETNAME (GxB_LOR_NE_UINT16) ;
    GETNAME (GxB_LOR_NE_UINT32) ;
    GETNAME (GxB_LOR_NE_UINT64) ;
    GETNAME (GxB_LOR_NE_FP32) ;
    GETNAME (GxB_LOR_NE_FP64) ;

    GETNAME (GxB_LAND_NE_INT8) ;
    GETNAME (GxB_LAND_NE_INT16) ;
    GETNAME (GxB_LAND_NE_INT32) ;
    GETNAME (GxB_LAND_NE_INT64) ;
    GETNAME (GxB_LAND_NE_UINT8) ;
    GETNAME (GxB_LAND_NE_UINT16) ;
    GETNAME (GxB_LAND_NE_UINT32) ;
    GETNAME (GxB_LAND_NE_UINT64) ;
    GETNAME (GxB_LAND_NE_FP32) ;
    GETNAME (GxB_LAND_NE_FP64) ;

    GETNAME (GxB_LXOR_NE_INT8) ;
    GETNAME (GxB_LXOR_NE_INT16) ;
    GETNAME (GxB_LXOR_NE_INT32) ;
    GETNAME (GxB_LXOR_NE_INT64) ;
    GETNAME (GxB_LXOR_NE_UINT8) ;
    GETNAME (GxB_LXOR_NE_UINT16) ;
    GETNAME (GxB_LXOR_NE_UINT32) ;
    GETNAME (GxB_LXOR_NE_UINT64) ;
    GETNAME (GxB_LXOR_NE_FP32) ;
    GETNAME (GxB_LXOR_NE_FP64) ;

    GETNAME (GxB_EQ_NE_INT8) ;
    GETNAME (GxB_EQ_NE_INT16) ;
    GETNAME (GxB_EQ_NE_INT32) ;
    GETNAME (GxB_EQ_NE_INT64) ;
    GETNAME (GxB_EQ_NE_UINT8) ;
    GETNAME (GxB_EQ_NE_UINT16) ;
    GETNAME (GxB_EQ_NE_UINT32) ;
    GETNAME (GxB_EQ_NE_UINT64) ;
    GETNAME (GxB_EQ_NE_FP32) ;
    GETNAME (GxB_EQ_NE_FP64) ;

    GETNAME (GxB_ANY_NE_INT8) ;
    GETNAME (GxB_ANY_NE_INT16) ;
    GETNAME (GxB_ANY_NE_INT32) ;
    GETNAME (GxB_ANY_NE_INT64) ;
    GETNAME (GxB_ANY_NE_UINT8) ;
    GETNAME (GxB_ANY_NE_UINT16) ;
    GETNAME (GxB_ANY_NE_UINT32) ;
    GETNAME (GxB_ANY_NE_UINT64) ;
    GETNAME (GxB_ANY_NE_FP32) ;
    GETNAME (GxB_ANY_NE_FP64) ;

    //--------------------------------------------------------------------------
    // *_GT
    //--------------------------------------------------------------------------

    GETNAME (GxB_LOR_GT_INT8) ;
    GETNAME (GxB_LOR_GT_INT16) ;
    GETNAME (GxB_LOR_GT_INT32) ;
    GETNAME (GxB_LOR_GT_INT64) ;
    GETNAME (GxB_LOR_GT_UINT8) ;
    GETNAME (GxB_LOR_GT_UINT16) ;
    GETNAME (GxB_LOR_GT_UINT32) ;
    GETNAME (GxB_LOR_GT_UINT64) ;
    GETNAME (GxB_LOR_GT_FP32) ;
    GETNAME (GxB_LOR_GT_FP64) ;

    GETNAME (GxB_LAND_GT_INT8) ;
    GETNAME (GxB_LAND_GT_INT16) ;
    GETNAME (GxB_LAND_GT_INT32) ;
    GETNAME (GxB_LAND_GT_INT64) ;
    GETNAME (GxB_LAND_GT_UINT8) ;
    GETNAME (GxB_LAND_GT_UINT16) ;
    GETNAME (GxB_LAND_GT_UINT32) ;
    GETNAME (GxB_LAND_GT_UINT64) ;
    GETNAME (GxB_LAND_GT_FP32) ;
    GETNAME (GxB_LAND_GT_FP64) ;

    GETNAME (GxB_LXOR_GT_INT8) ;
    GETNAME (GxB_LXOR_GT_INT16) ;
    GETNAME (GxB_LXOR_GT_INT32) ;
    GETNAME (GxB_LXOR_GT_INT64) ;
    GETNAME (GxB_LXOR_GT_UINT8) ;
    GETNAME (GxB_LXOR_GT_UINT16) ;
    GETNAME (GxB_LXOR_GT_UINT32) ;
    GETNAME (GxB_LXOR_GT_UINT64) ;
    GETNAME (GxB_LXOR_GT_FP32) ;
    GETNAME (GxB_LXOR_GT_FP64) ;

    GETNAME (GxB_EQ_GT_INT8) ;
    GETNAME (GxB_EQ_GT_INT16) ;
    GETNAME (GxB_EQ_GT_INT32) ;
    GETNAME (GxB_EQ_GT_INT64) ;
    GETNAME (GxB_EQ_GT_UINT8) ;
    GETNAME (GxB_EQ_GT_UINT16) ;
    GETNAME (GxB_EQ_GT_UINT32) ;
    GETNAME (GxB_EQ_GT_UINT64) ;
    GETNAME (GxB_EQ_GT_FP32) ;
    GETNAME (GxB_EQ_GT_FP64) ;

    GETNAME (GxB_ANY_GT_INT8) ;
    GETNAME (GxB_ANY_GT_INT16) ;
    GETNAME (GxB_ANY_GT_INT32) ;
    GETNAME (GxB_ANY_GT_INT64) ;
    GETNAME (GxB_ANY_GT_UINT8) ;
    GETNAME (GxB_ANY_GT_UINT16) ;
    GETNAME (GxB_ANY_GT_UINT32) ;
    GETNAME (GxB_ANY_GT_UINT64) ;
    GETNAME (GxB_ANY_GT_FP32) ;
    GETNAME (GxB_ANY_GT_FP64) ;

    GETNAME (GxB_LOR_GT_BOOL) ;
    GETNAME (GxB_LAND_GT_BOOL) ;
    GETNAME (GxB_LXOR_GT_BOOL) ;
    GETNAME (GxB_EQ_GT_BOOL) ;
    GETNAME (GxB_ANY_GT_BOOL) ;

    //--------------------------------------------------------------------------
    // *_LT
    //--------------------------------------------------------------------------

    GETNAME (GxB_LOR_LT_INT8) ;
    GETNAME (GxB_LOR_LT_INT16) ;
    GETNAME (GxB_LOR_LT_INT32) ;
    GETNAME (GxB_LOR_LT_INT64) ;
    GETNAME (GxB_LOR_LT_UINT8) ;
    GETNAME (GxB_LOR_LT_UINT16) ;
    GETNAME (GxB_LOR_LT_UINT32) ;
    GETNAME (GxB_LOR_LT_UINT64) ;
    GETNAME (GxB_LOR_LT_FP32) ;
    GETNAME (GxB_LOR_LT_FP64) ;

    GETNAME (GxB_LAND_LT_INT8) ;
    GETNAME (GxB_LAND_LT_INT16) ;
    GETNAME (GxB_LAND_LT_INT32) ;
    GETNAME (GxB_LAND_LT_INT64) ;
    GETNAME (GxB_LAND_LT_UINT8) ;
    GETNAME (GxB_LAND_LT_UINT16) ;
    GETNAME (GxB_LAND_LT_UINT32) ;
    GETNAME (GxB_LAND_LT_UINT64) ;
    GETNAME (GxB_LAND_LT_FP32) ;
    GETNAME (GxB_LAND_LT_FP64) ;

    GETNAME (GxB_LXOR_LT_INT8) ;
    GETNAME (GxB_LXOR_LT_INT16) ;
    GETNAME (GxB_LXOR_LT_INT32) ;
    GETNAME (GxB_LXOR_LT_INT64) ;
    GETNAME (GxB_LXOR_LT_UINT8) ;
    GETNAME (GxB_LXOR_LT_UINT16) ;
    GETNAME (GxB_LXOR_LT_UINT32) ;
    GETNAME (GxB_LXOR_LT_UINT64) ;
    GETNAME (GxB_LXOR_LT_FP32) ;
    GETNAME (GxB_LXOR_LT_FP64) ;

    GETNAME (GxB_EQ_LT_INT8) ;
    GETNAME (GxB_EQ_LT_INT16) ;
    GETNAME (GxB_EQ_LT_INT32) ;
    GETNAME (GxB_EQ_LT_INT64) ;
    GETNAME (GxB_EQ_LT_UINT8) ;
    GETNAME (GxB_EQ_LT_UINT16) ;
    GETNAME (GxB_EQ_LT_UINT32) ;
    GETNAME (GxB_EQ_LT_UINT64) ;
    GETNAME (GxB_EQ_LT_FP32) ;
    GETNAME (GxB_EQ_LT_FP64) ;

    GETNAME (GxB_ANY_LT_INT8) ;
    GETNAME (GxB_ANY_LT_INT16) ;
    GETNAME (GxB_ANY_LT_INT32) ;
    GETNAME (GxB_ANY_LT_INT64) ;
    GETNAME (GxB_ANY_LT_UINT8) ;
    GETNAME (GxB_ANY_LT_UINT16) ;
    GETNAME (GxB_ANY_LT_UINT32) ;
    GETNAME (GxB_ANY_LT_UINT64) ;
    GETNAME (GxB_ANY_LT_FP32) ;
    GETNAME (GxB_ANY_LT_FP64) ;

    GETNAME (GxB_LOR_LT_BOOL) ;
    GETNAME (GxB_LAND_LT_BOOL) ;
    GETNAME (GxB_LXOR_LT_BOOL) ;
    GETNAME (GxB_EQ_LT_BOOL) ;
    GETNAME (GxB_ANY_LT_BOOL) ;

    //--------------------------------------------------------------------------
    // *_GE
    //--------------------------------------------------------------------------

    GETNAME (GxB_LOR_GE_INT8) ;
    GETNAME (GxB_LOR_GE_INT16) ;
    GETNAME (GxB_LOR_GE_INT32) ;
    GETNAME (GxB_LOR_GE_INT64) ;
    GETNAME (GxB_LOR_GE_UINT8) ;
    GETNAME (GxB_LOR_GE_UINT16) ;
    GETNAME (GxB_LOR_GE_UINT32) ;
    GETNAME (GxB_LOR_GE_UINT64) ;
    GETNAME (GxB_LOR_GE_FP32) ;
    GETNAME (GxB_LOR_GE_FP64) ;

    GETNAME (GxB_LAND_GE_INT8) ;
    GETNAME (GxB_LAND_GE_INT16) ;
    GETNAME (GxB_LAND_GE_INT32) ;
    GETNAME (GxB_LAND_GE_INT64) ;
    GETNAME (GxB_LAND_GE_UINT8) ;
    GETNAME (GxB_LAND_GE_UINT16) ;
    GETNAME (GxB_LAND_GE_UINT32) ;
    GETNAME (GxB_LAND_GE_UINT64) ;
    GETNAME (GxB_LAND_GE_FP32) ;
    GETNAME (GxB_LAND_GE_FP64) ;

    GETNAME (GxB_LXOR_GE_INT8) ;
    GETNAME (GxB_LXOR_GE_INT16) ;
    GETNAME (GxB_LXOR_GE_INT32) ;
    GETNAME (GxB_LXOR_GE_INT64) ;
    GETNAME (GxB_LXOR_GE_UINT8) ;
    GETNAME (GxB_LXOR_GE_UINT16) ;
    GETNAME (GxB_LXOR_GE_UINT32) ;
    GETNAME (GxB_LXOR_GE_UINT64) ;
    GETNAME (GxB_LXOR_GE_FP32) ;
    GETNAME (GxB_LXOR_GE_FP64) ;

    GETNAME (GxB_EQ_GE_INT8) ;
    GETNAME (GxB_EQ_GE_INT16) ;
    GETNAME (GxB_EQ_GE_INT32) ;
    GETNAME (GxB_EQ_GE_INT64) ;
    GETNAME (GxB_EQ_GE_UINT8) ;
    GETNAME (GxB_EQ_GE_UINT16) ;
    GETNAME (GxB_EQ_GE_UINT32) ;
    GETNAME (GxB_EQ_GE_UINT64) ;
    GETNAME (GxB_EQ_GE_FP32) ;
    GETNAME (GxB_EQ_GE_FP64) ;

    GETNAME (GxB_ANY_GE_INT8) ;
    GETNAME (GxB_ANY_GE_INT16) ;
    GETNAME (GxB_ANY_GE_INT32) ;
    GETNAME (GxB_ANY_GE_INT64) ;
    GETNAME (GxB_ANY_GE_UINT8) ;
    GETNAME (GxB_ANY_GE_UINT16) ;
    GETNAME (GxB_ANY_GE_UINT32) ;
    GETNAME (GxB_ANY_GE_UINT64) ;
    GETNAME (GxB_ANY_GE_FP32) ;
    GETNAME (GxB_ANY_GE_FP64) ;

    GETNAME (GxB_LOR_GE_BOOL) ;
    GETNAME (GxB_LAND_GE_BOOL) ;
    GETNAME (GxB_LXOR_GE_BOOL) ;
    GETNAME (GxB_EQ_GE_BOOL) ;
    GETNAME (GxB_ANY_GE_BOOL) ;

    //--------------------------------------------------------------------------
    // *_LE
    //--------------------------------------------------------------------------

    GETNAME (GxB_LOR_LE_INT8) ;
    GETNAME (GxB_LOR_LE_INT16) ;
    GETNAME (GxB_LOR_LE_INT32) ;
    GETNAME (GxB_LOR_LE_INT64) ;
    GETNAME (GxB_LOR_LE_UINT8) ;
    GETNAME (GxB_LOR_LE_UINT16) ;
    GETNAME (GxB_LOR_LE_UINT32) ;
    GETNAME (GxB_LOR_LE_UINT64) ;
    GETNAME (GxB_LOR_LE_FP32) ;
    GETNAME (GxB_LOR_LE_FP64) ;

    GETNAME (GxB_LAND_LE_INT8) ;
    GETNAME (GxB_LAND_LE_INT16) ;
    GETNAME (GxB_LAND_LE_INT32) ;
    GETNAME (GxB_LAND_LE_INT64) ;
    GETNAME (GxB_LAND_LE_UINT8) ;
    GETNAME (GxB_LAND_LE_UINT16) ;
    GETNAME (GxB_LAND_LE_UINT32) ;
    GETNAME (GxB_LAND_LE_UINT64) ;
    GETNAME (GxB_LAND_LE_FP32) ;
    GETNAME (GxB_LAND_LE_FP64) ;

    GETNAME (GxB_LXOR_LE_INT8) ;
    GETNAME (GxB_LXOR_LE_INT16) ;
    GETNAME (GxB_LXOR_LE_INT32) ;
    GETNAME (GxB_LXOR_LE_INT64) ;
    GETNAME (GxB_LXOR_LE_UINT8) ;
    GETNAME (GxB_LXOR_LE_UINT16) ;
    GETNAME (GxB_LXOR_LE_UINT32) ;
    GETNAME (GxB_LXOR_LE_UINT64) ;
    GETNAME (GxB_LXOR_LE_FP32) ;
    GETNAME (GxB_LXOR_LE_FP64) ;

    GETNAME (GxB_EQ_LE_INT8) ;
    GETNAME (GxB_EQ_LE_INT16) ;
    GETNAME (GxB_EQ_LE_INT32) ;
    GETNAME (GxB_EQ_LE_INT64) ;
    GETNAME (GxB_EQ_LE_UINT8) ;
    GETNAME (GxB_EQ_LE_UINT16) ;
    GETNAME (GxB_EQ_LE_UINT32) ;
    GETNAME (GxB_EQ_LE_UINT64) ;
    GETNAME (GxB_EQ_LE_FP32) ;
    GETNAME (GxB_EQ_LE_FP64) ;

    GETNAME (GxB_ANY_LE_INT8) ;
    GETNAME (GxB_ANY_LE_INT16) ;
    GETNAME (GxB_ANY_LE_INT32) ;
    GETNAME (GxB_ANY_LE_INT64) ;
    GETNAME (GxB_ANY_LE_UINT8) ;
    GETNAME (GxB_ANY_LE_UINT16) ;
    GETNAME (GxB_ANY_LE_UINT32) ;
    GETNAME (GxB_ANY_LE_UINT64) ;
    GETNAME (GxB_ANY_LE_FP32) ;
    GETNAME (GxB_ANY_LE_FP64) ;

    GETNAME (GxB_LOR_LE_BOOL) ;
    GETNAME (GxB_LAND_LE_BOOL) ;
    GETNAME (GxB_LXOR_LE_BOOL) ;
    GETNAME (GxB_EQ_LE_BOOL) ;
    GETNAME (GxB_ANY_LE_BOOL) ;


    //--------------------------------------------------------------------------
    // bitwise
    //--------------------------------------------------------------------------

    GETNAME (GxB_BOR_BOR_UINT8) ;
    GETNAME (GxB_BOR_BOR_UINT16) ;
    GETNAME (GxB_BOR_BOR_UINT32) ;
    GETNAME (GxB_BOR_BOR_UINT64) ;

    GETNAME (GxB_BOR_BAND_UINT8) ;
    GETNAME (GxB_BOR_BAND_UINT16) ;
    GETNAME (GxB_BOR_BAND_UINT32) ;
    GETNAME (GxB_BOR_BAND_UINT64) ;

    GETNAME (GxB_BOR_BXOR_UINT8) ;
    GETNAME (GxB_BOR_BXOR_UINT16) ;
    GETNAME (GxB_BOR_BXOR_UINT32) ;
    GETNAME (GxB_BOR_BXOR_UINT64) ;

    GETNAME (GxB_BOR_BXNOR_UINT8) ;
    GETNAME (GxB_BOR_BXNOR_UINT16) ;
    GETNAME (GxB_BOR_BXNOR_UINT32) ;
    GETNAME (GxB_BOR_BXNOR_UINT64) ;

    GETNAME (GxB_BAND_BOR_UINT8) ;
    GETNAME (GxB_BAND_BOR_UINT16) ;
    GETNAME (GxB_BAND_BOR_UINT32) ;
    GETNAME (GxB_BAND_BOR_UINT64) ;

    GETNAME (GxB_BAND_BAND_UINT8) ;
    GETNAME (GxB_BAND_BAND_UINT16) ;
    GETNAME (GxB_BAND_BAND_UINT32) ;
    GETNAME (GxB_BAND_BAND_UINT64) ;

    GETNAME (GxB_BAND_BXOR_UINT8) ;
    GETNAME (GxB_BAND_BXOR_UINT16) ;
    GETNAME (GxB_BAND_BXOR_UINT32) ;
    GETNAME (GxB_BAND_BXOR_UINT64) ;

    GETNAME (GxB_BAND_BXNOR_UINT8) ;
    GETNAME (GxB_BAND_BXNOR_UINT16) ;
    GETNAME (GxB_BAND_BXNOR_UINT32) ;
    GETNAME (GxB_BAND_BXNOR_UINT64) ;

    GETNAME (GxB_BXOR_BOR_UINT8) ;
    GETNAME (GxB_BXOR_BOR_UINT16) ;
    GETNAME (GxB_BXOR_BOR_UINT32) ;
    GETNAME (GxB_BXOR_BOR_UINT64) ;

    GETNAME (GxB_BXOR_BAND_UINT8) ;
    GETNAME (GxB_BXOR_BAND_UINT16) ;
    GETNAME (GxB_BXOR_BAND_UINT32) ;
    GETNAME (GxB_BXOR_BAND_UINT64) ;

    GETNAME (GxB_BXOR_BXOR_UINT8) ;
    GETNAME (GxB_BXOR_BXOR_UINT16) ;
    GETNAME (GxB_BXOR_BXOR_UINT32) ;
    GETNAME (GxB_BXOR_BXOR_UINT64) ;

    GETNAME (GxB_BXOR_BXNOR_UINT8) ;
    GETNAME (GxB_BXOR_BXNOR_UINT16) ;
    GETNAME (GxB_BXOR_BXNOR_UINT32) ;
    GETNAME (GxB_BXOR_BXNOR_UINT64) ;


    GETNAME (GxB_BXNOR_BOR_UINT8) ;
    GETNAME (GxB_BXNOR_BOR_UINT16) ;
    GETNAME (GxB_BXNOR_BOR_UINT32) ;
    GETNAME (GxB_BXNOR_BOR_UINT64) ;

    GETNAME (GxB_BXNOR_BAND_UINT8) ;
    GETNAME (GxB_BXNOR_BAND_UINT16) ;
    GETNAME (GxB_BXNOR_BAND_UINT32) ;
    GETNAME (GxB_BXNOR_BAND_UINT64) ;

    GETNAME (GxB_BXNOR_BXOR_UINT8) ;
    GETNAME (GxB_BXNOR_BXOR_UINT16) ;
    GETNAME (GxB_BXNOR_BXOR_UINT32) ;
    GETNAME (GxB_BXNOR_BXOR_UINT64) ;

    GETNAME (GxB_BXNOR_BXNOR_UINT8) ;
    GETNAME (GxB_BXNOR_BXNOR_UINT16) ;
    GETNAME (GxB_BXNOR_BXNOR_UINT32) ;
    GETNAME (GxB_BXNOR_BXNOR_UINT64) ;

    //--------------------------------------------------------------------------
    // positional semirings
    //--------------------------------------------------------------------------

    GETNAME (GxB_MIN_FIRSTI_INT32) ;
    GETNAME (GxB_MIN_FIRSTI_INT64) ;

    GETNAME (GxB_MAX_FIRSTI_INT32) ;
    GETNAME (GxB_MAX_FIRSTI_INT64) ;

    GETNAME (GxB_ANY_FIRSTI_INT32) ;
    GETNAME (GxB_ANY_FIRSTI_INT64) ;

    GETNAME (GxB_PLUS_FIRSTI_INT32) ;
    GETNAME (GxB_PLUS_FIRSTI_INT64) ;

    GETNAME (GxB_TIMES_FIRSTI_INT32) ;
    GETNAME (GxB_TIMES_FIRSTI_INT64) ;

    GETNAME (GxB_MIN_FIRSTI1_INT32) ;
    GETNAME (GxB_MIN_FIRSTI1_INT64) ;

    GETNAME (GxB_MAX_FIRSTI1_INT32) ;
    GETNAME (GxB_MAX_FIRSTI1_INT64) ;

    GETNAME (GxB_ANY_FIRSTI1_INT32) ;
    GETNAME (GxB_ANY_FIRSTI1_INT64) ;

    GETNAME (GxB_PLUS_FIRSTI1_INT32) ;
    GETNAME (GxB_PLUS_FIRSTI1_INT64) ;

    GETNAME (GxB_TIMES_FIRSTI1_INT32) ;
    GETNAME (GxB_TIMES_FIRSTI1_INT64) ;

    GETNAM2 (GxB_MIN_FIRSTJ_INT32,      "GxB_MIN_SECONDI_INT32") ;
    GETNAM2 (GxB_MIN_FIRSTJ_INT64,      "GxB_MIN_SECONDI_INT64") ;

    GETNAM2 (GxB_MAX_FIRSTJ_INT32,      "GxB_MAX_SECONDI_INT32") ;
    GETNAM2 (GxB_MAX_FIRSTJ_INT64,      "GxB_MAX_SECONDI_INT64") ;

    GETNAM2 (GxB_ANY_FIRSTJ_INT32,      "GxB_ANY_SECONDI_INT32") ;
    GETNAM2 (GxB_ANY_FIRSTJ_INT64,      "GxB_ANY_SECONDI_INT64") ;

    GETNAM2 (GxB_PLUS_FIRSTJ_INT32,     "GxB_PLUS_SECONDI_INT32") ;
    GETNAM2 (GxB_PLUS_FIRSTJ_INT64,     "GxB_PLUS_SECONDI_INT64") ;

    GETNAM2 (GxB_TIMES_FIRSTJ_INT32,    "GxB_TIMES_SECONDI_INT32") ;
    GETNAM2 (GxB_TIMES_FIRSTJ_INT64,    "GxB_TIMES_SECONDI_INT64") ;

    GETNAM2 (GxB_MIN_FIRSTJ1_INT32,      "GxB_MIN_SECONDI1_INT32") ;
    GETNAM2 (GxB_MIN_FIRSTJ1_INT64,      "GxB_MIN_SECONDI1_INT64") ;

    GETNAM2 (GxB_MAX_FIRSTJ1_INT32,      "GxB_MAX_SECONDI1_INT32") ;
    GETNAM2 (GxB_MAX_FIRSTJ1_INT64,      "GxB_MAX_SECONDI1_INT64") ;

    GETNAM2 (GxB_ANY_FIRSTJ1_INT32,      "GxB_ANY_SECONDI1_INT32") ;
    GETNAM2 (GxB_ANY_FIRSTJ1_INT64,      "GxB_ANY_SECONDI1_INT64") ;

    GETNAM2 (GxB_PLUS_FIRSTJ1_INT32,     "GxB_PLUS_SECONDI1_INT32") ;
    GETNAM2 (GxB_PLUS_FIRSTJ1_INT64,     "GxB_PLUS_SECONDI1_INT64") ;

    GETNAM2 (GxB_TIMES_FIRSTJ1_INT32,    "GxB_TIMES_SECONDI1_INT32") ;
    GETNAM2 (GxB_TIMES_FIRSTJ1_INT64,    "GxB_TIMES_SECONDI1_INT64") ;

    GETNAME (GxB_MIN_SECONDI_INT32) ;
    GETNAME (GxB_MIN_SECONDI_INT64) ;

    GETNAME (GxB_MAX_SECONDI_INT32) ;
    GETNAME (GxB_MAX_SECONDI_INT64) ;

    GETNAME (GxB_ANY_SECONDI_INT32) ;
    GETNAME (GxB_ANY_SECONDI_INT64) ;

    GETNAME (GxB_PLUS_SECONDI_INT32) ;
    GETNAME (GxB_PLUS_SECONDI_INT64) ;

    GETNAME (GxB_TIMES_SECONDI_INT32) ;
    GETNAME (GxB_TIMES_SECONDI_INT64) ;

    GETNAME (GxB_MIN_SECONDI1_INT32) ;
    GETNAME (GxB_MIN_SECONDI1_INT64) ;

    GETNAME (GxB_MAX_SECONDI1_INT32) ;
    GETNAME (GxB_MAX_SECONDI1_INT64) ;

    GETNAME (GxB_ANY_SECONDI1_INT32) ;
    GETNAME (GxB_ANY_SECONDI1_INT64) ;

    GETNAME (GxB_PLUS_SECONDI1_INT32) ;
    GETNAME (GxB_PLUS_SECONDI1_INT64) ;

    GETNAME (GxB_TIMES_SECONDI1_INT32) ;
    GETNAME (GxB_TIMES_SECONDI1_INT64) ;

    GETNAME (GxB_MIN_SECONDJ_INT32) ;
    GETNAME (GxB_MIN_SECONDJ_INT64) ;

    GETNAME (GxB_MAX_SECONDJ_INT32) ;
    GETNAME (GxB_MAX_SECONDJ_INT64) ;

    GETNAME (GxB_ANY_SECONDJ_INT32) ;
    GETNAME (GxB_ANY_SECONDJ_INT64) ;

    GETNAME (GxB_PLUS_SECONDJ_INT32) ;
    GETNAME (GxB_PLUS_SECONDJ_INT64) ;

    GETNAME (GxB_TIMES_SECONDJ_INT32) ;
    GETNAME (GxB_TIMES_SECONDJ_INT64) ;

    GETNAME (GxB_MIN_SECONDJ1_INT32) ;
    GETNAME (GxB_MIN_SECONDJ1_INT64) ;

    GETNAME (GxB_MAX_SECONDJ1_INT32) ;
    GETNAME (GxB_MAX_SECONDJ1_INT64) ;

    GETNAME (GxB_ANY_SECONDJ1_INT32) ;
    GETNAME (GxB_ANY_SECONDJ1_INT64) ;

    GETNAME (GxB_PLUS_SECONDJ1_INT32) ;
    GETNAME (GxB_PLUS_SECONDJ1_INT64) ;

    GETNAME (GxB_TIMES_SECONDJ1_INT32) ;
    GETNAME (GxB_TIMES_SECONDJ1_INT64) ;

    //--------------------------------------------------------------------------
    // other methods
    //--------------------------------------------------------------------------

    OK (GrB_Semiring_get_INT32_(GrB_PLUS_TIMES_SEMIRING_FP32, &code,
        GrB_INP0_TYPE_CODE)) ;
    CHECK (code == GrB_FP32_CODE) ;

    OK (GrB_Semiring_get_SIZE_(GrB_PLUS_TIMES_SEMIRING_FP32, &size,
        GrB_INP0_TYPE_STRING)) ;
    CHECK (size == strlen ("GrB_FP32") + 1) ;

    OK (GrB_Semiring_get_String_(GrB_PLUS_TIMES_SEMIRING_FP32, name,
        GrB_INP0_TYPE_STRING)) ;
    CHECK (MATCH (name, "GrB_FP32")) ;

    OK (GrB_Semiring_get_SIZE_(GrB_MAX_PLUS_SEMIRING_INT32, &size,
        GrB_INP1_TYPE_STRING)) ;
    CHECK (size == strlen ("GrB_INT32") + 1) ;

    OK (GrB_Semiring_get_String_(GrB_MAX_PLUS_SEMIRING_INT32, name,
        GrB_INP1_TYPE_STRING)) ;
    CHECK (MATCH (name, "GrB_INT32")) ;

    OK (GrB_Semiring_get_INT32_(GrB_PLUS_TIMES_SEMIRING_FP64, &code,
        GrB_OUTP_TYPE_CODE)) ;
    CHECK (code == GrB_FP64_CODE) ;

    OK (GrB_Semiring_get_SIZE_(GrB_PLUS_TIMES_SEMIRING_FP64, &size,
        GrB_OUTP_TYPE_STRING)) ;
    CHECK (size == strlen ("GrB_FP64") + 1) ;

    OK (GrB_Semiring_get_String_(GrB_PLUS_TIMES_SEMIRING_FP64, name,
        GrB_OUTP_TYPE_STRING)) ;
    CHECK (MATCH (name, "GrB_FP64")) ;

    OK (GrB_Semiring_get_Scalar_(GrB_PLUS_TIMES_SEMIRING_FP32, s_int32,
        GrB_INP0_TYPE_CODE)) ;
    OK (GrB_Scalar_extractElement_INT32_(&code, s_int32)) ;
    CHECK (code == GrB_FP32_CODE) ;

    OK (GrB_Semiring_get_Scalar_(GrB_LOR_LAND_SEMIRING_BOOL, s_int32,
        GrB_OUTP_TYPE_CODE)) ;
    OK (GrB_Scalar_extractElement_INT32_(&code, s_int32)) ;
    CHECK (code == GrB_BOOL_CODE) ;

    OK (GrB_Semiring_get_INT32_(GrB_PLUS_TIMES_SEMIRING_FP64, &code,
        GrB_INP1_TYPE_CODE)) ;
    CHECK (code == GrB_FP64_CODE) ;

    OK (GrB_Semiring_get_Scalar_(GrB_LOR_LAND_SEMIRING_BOOL, s_int32,
        GrB_INP1_TYPE_CODE)) ;
    OK (GrB_Scalar_extractElement_INT32_(&code, s_int32)) ;
    CHECK (code == GrB_BOOL_CODE) ;

    expected = GrB_INVALID_VALUE ;
    ERR (GrB_Semiring_get_INT32_(GrB_LOR_LAND_SEMIRING_BOOL, &code,
        GrB_NAME)) ;
    ERR (GrB_Semiring_get_String_(GrB_PLUS_TIMES_SEMIRING_INT32, name,
        999)) ;

    ERR (GrB_Semiring_get_VOID_(GrB_LOR_LAND_SEMIRING_BOOL, nothing, 0)) ;

    OK (GrB_BinaryOp_new (&times,
        (GxB_binary_function) mytimes, GrB_FP32, GrB_FP32, GrB_FP32)) ;
    OK (GrB_BinaryOp_set_String_(times, "mytimes", GrB_NAME)) ;
    METHOD (GrB_BinaryOp_set_String (times, MYTIMES_DEFN,
        GxB_JIT_C_DEFINITION)) ;

    OK (GrB_BinaryOp_new (&add,
        (GxB_binary_function) myadd, GrB_FP32, GrB_FP32, GrB_FP32)) ;
    OK (GrB_BinaryOp_set_String_(add, "myadd", GrB_NAME)) ;
    METHOD (GrB_BinaryOp_set_String (add, MYADD_DEFN, GxB_JIT_C_DEFINITION)) ;

    OK (GrB_Monoid_new_FP32 (&monoid, add, (float) 0.0)) ;
    OK (GrB_Monoid_get_SIZE_(monoid, &size, GrB_NAME)) ;
    OK (GrB_Monoid_get_String_(monoid, name, GrB_NAME)) ;
    printf ("\nuser monoid: [%s]:%d\n", name, size) ;
    CHECK (MATCH (name, "")) ;
    CHECK (size == 1) ;
    OK (GxB_print (monoid, 3)) ;

    OK (GrB_Semiring_new (&semiring, monoid, times)) ;

    OK (GrB_Semiring_get_SIZE_(semiring, &size, GrB_INP0_TYPE_STRING)) ;
    CHECK (size == strlen ("GrB_FP32") + 1) ;
    OK (GrB_Semiring_get_String(semiring, name, GrB_INP0_TYPE_STRING)) ;
    CHECK (MATCH (name, "GrB_FP32")) ;

    expected = GrB_INVALID_VALUE ;
    ERR (GrB_Semiring_get_SIZE_(semiring, &size, GrB_INP0_TYPE_CODE)) ;
    ERR (GrB_Semiring_set_String_(GrB_MAX_TIMES_SEMIRING_INT32, "stuff",
        GrB_NAME)) ;

    expected = GrB_INVALID_VALUE ;
    ERR (GrB_Semiring_set_Scalar_(semiring, s_int32, 0)) ;
    ERR (GrB_Semiring_set_INT32_(semiring, 0, 0)) ;
    ERR (GrB_Semiring_set_VOID_(semiring, nothing, 0, 0)) ;

    OK (GrB_Semiring_get_String_(semiring, name, GrB_NAME)) ;
    CHECK (MATCH (name, "")) ;
    OK (GrB_Semiring_set_String_(semiring, "stuff", GrB_NAME)) ;
    OK (GrB_Semiring_get_String_(semiring, name, GrB_NAME)) ;
    CHECK (MATCH (name, "stuff")) ;
    OK (GrB_Semiring_get_SIZE_(semiring, &size, GrB_NAME)) ;
    CHECK (size == strlen (name) + 1) ;
    OK (GxB_print (semiring, 3)) ;

    expected = GrB_ALREADY_SET ;
    ERR (GrB_Semiring_set_String_(semiring, "another user name", GrB_NAME)) ;
    printf ("    test GrB_ALREADY_SET: ok\n") ;

    printf ("\nsemiring with terminal monoid:\n") ;
    int32_t id_int32 ;
    OK (GrB_Semiring_get_String_(GrB_MAX_TIMES_SEMIRING_INT32,
        name, GrB_NAME)) ;
    OK (GxB_Semiring_fprint (GrB_MAX_TIMES_SEMIRING_INT32, name, 3, NULL)) ;
    OK (GrB_Monoid_get_Scalar_ (GrB_MAX_TIMES_SEMIRING_INT32, s_int32,
        GxB_MONOID_IDENTITY)) ;
    OK (GrB_Scalar_nvals (&nvals, s_int32)) ;
    CHECK (nvals == 1) ;
    OK (GrB_Scalar_extractElement_INT32_(&id_int32, s_int32)) ;
    CHECK (id_int32 == INT32_MIN) ;

    int32_t term_int32 ;
    OK (GrB_Monoid_get_Scalar_ (GrB_MAX_TIMES_SEMIRING_INT32, s_int32,
        GxB_MONOID_TERMINAL)) ;
    OK (GrB_Scalar_extractElement_INT32_(&term_int32, s_int32)) ;
    CHECK (term_int32 == INT32_MAX) ;

    op = NULL ;
    OK (GrB_Semiring_get_SIZE_ (semiring, &size, GxB_MONOID_OPERATOR)) ;
    CHECK (size == sizeof (GrB_BinaryOp)) ;
    OK (GrB_Semiring_get_VOID (semiring, (void *) (&op), GxB_MONOID_OPERATOR)) ;
    CHECK (op == add) ;
    OK (GrB_Semiring_get_VOID_ (GrB_PLUS_TIMES_SEMIRING_INT32, (void *) &op,
        GxB_MONOID_OPERATOR)) ;
    CHECK (op == GrB_PLUS_INT32) ;

    OK (GrB_Semiring_get_SIZE_ (semiring, &size, GxB_SEMIRING_MONOID)) ;
    CHECK (size == sizeof (GrB_Monoid)) ;

    OK (GrB_Semiring_get_SIZE_ (semiring, &size, GxB_SEMIRING_MULTIPLY)) ;
    CHECK (size == sizeof (GrB_BinaryOp)) ;

    OK (GrB_Semiring_get_VOID_ (semiring, (void *) (&mon),
        GxB_SEMIRING_MONOID)) ;
    CHECK (mon == monoid) ;

    OK (GrB_Semiring_get_VOID_ (semiring, (void *) (&op),
        GxB_SEMIRING_MULTIPLY)) ;
    CHECK (op == times) ;

    //--------------------------------------------------------------------------
    // finalize GraphBLAS
    //--------------------------------------------------------------------------

    GrB_free (&s_fp64) ;
    GrB_free (&s_fp32) ;
    GrB_free (&s_int32) ;
    GrB_free (&add) ;
    GrB_free (&times) ;
    GrB_free (&monoid) ;
    GrB_free (&semiring) ;
    GB_mx_put_global (true) ;
    printf ("\nGB_mex_test32:  all tests passed\n\n") ;
}

