/* Copyright (C) 2017 Open Information Security Foundation
 *
 * You can copy, redistribute or modify this Program under the terms of
 * the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/*
 * DO NOT EDIT. This file is automatically generated.
 */

#ifndef __RUST_NTP_NTP_GEN_H__
#define __RUST_NTP_NTP_GEN_H__

int8_t rs_ntp_probe(const uint8_t * input, uint32_t len);
void * rs_ntp_state_new(void);
void rs_ntp_state_free(void * state);
int8_t rs_ntp_parse_request(const Flow * _flow, NTPState * state, const void * _pstate, const uint8_t * input, uint32_t input_len, const void * _data);
int8_t rs_ntp_parse_response(const Flow * _flow, NTPState * state, const void * _pstate, const uint8_t * input, uint32_t input_len, const void * _data);
NTPTransaction * rs_ntp_state_get_tx(NTPState * state, uint64_t tx_id);
uint64_t rs_ntp_state_get_tx_count(NTPState * state);
void rs_ntp_state_tx_free(NTPState * state, uint64_t tx_id);
int rs_ntp_state_progress_completion_status(uint8_t _direction);
uint8_t rs_ntp_tx_get_alstate_progress(NTPTransaction * _tx, uint8_t _direction);
void rs_ntp_tx_set_logged(NTPState * _state, NTPTransaction * tx, uint32_t logger);
int8_t rs_ntp_tx_get_logged(NTPState * _state, NTPTransaction * tx, uint32_t logger);
void rs_ntp_state_set_tx_detect_state(NTPState * state, NTPTransaction * tx, DetectEngineState * de_state);
DetectEngineState * rs_ntp_state_get_tx_detect_state(NTPTransaction * tx);
uint8_t rs_ntp_state_has_events(NTPState * state);
AppLayerDecoderEvents * rs_ntp_state_get_events(NTPState * state, uint64_t tx_id);
int8_t rs_ntp_state_get_event_info(const char * event_name, int * event_id, AppLayerEventType * event_type);

#endif /* ! __RUST_NTP_NTP_GEN_H__ */
