/* Copyright (C) 2017 Open Information Security Foundation
 *
 * You can copy, redistribute or modify this Program under the terms of
 * the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/*
 * DO NOT EDIT. This file is automatically generated.
 */

#ifndef __RUST_SMB_SMB_GEN_H__
#define __RUST_SMB_SMB_GEN_H__

void rs_smb_init(SuricataFileContext * context);
void * rs_smb_state_new(void);
void rs_smb_state_free(void * state);
int8_t rs_smb_parse_request_tcp(Flow * flow, SMBState * state, void * _pstate, const uint8_t * input, uint32_t input_len, void * _data, uint8_t flags);
int8_t rs_smb_parse_request_tcp_gap(SMBState * state, uint32_t input_len);
int8_t rs_smb_parse_response_tcp(Flow * flow, SMBState * state, void * _pstate, const uint8_t * input, uint32_t input_len, void * _data, uint8_t flags);
int8_t rs_smb_parse_response_tcp_gap(SMBState * state, uint32_t input_len);
int8_t rs_smb_probe_tcp(uint8_t direction, const uint8_t * input, uint32_t len, uint8_t * rdir);
uint64_t rs_smb_state_get_tx_count(SMBState * state);
SMBTransaction * rs_smb_state_get_tx(SMBState * state, uint64_t tx_id);
AppLayerGetTxIterTuple rs_smb_state_get_tx_iterator(SMBState * state, uint64_t min_tx_id, uint64_t * istate);
void rs_smb_state_tx_free(SMBState * state, uint64_t tx_id);
int rs_smb_state_progress_completion_status(uint8_t _direction);
uint8_t rs_smb_tx_get_alstate_progress(SMBTransaction * tx, uint8_t direction);
void rs_smb_tx_set_logged(SMBState * _state, SMBTransaction * tx, uint32_t bits);
uint32_t rs_smb_tx_get_logged(SMBState * _state, SMBTransaction * tx);
void rs_smb_tx_set_detect_flags(SMBTransaction * tx, uint8_t direction, uint64_t flags);
uint64_t rs_smb_tx_get_detect_flags(SMBTransaction * tx, uint8_t direction);
void rs_smb_state_set_tx_detect_state(SMBTransaction * tx, DetectEngineState * de_state);
DetectEngineState * rs_smb_state_get_tx_detect_state(SMBTransaction * tx);
void rs_smb_state_truncate(SMBState * state, uint8_t direction);
AppLayerDecoderEvents * rs_smb_state_get_events(void * tx);
int8_t rs_smb_state_get_event_info_by_id(int event_id, const char ** event_name, AppLayerEventType * event_type);
int8_t rs_smb_state_get_event_info(const char * event_name, int * event_id, AppLayerEventType * event_type);

#endif /* ! __RUST_SMB_SMB_GEN_H__ */
