// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -O0 -triple amdgcn -emit-llvm %s -o - | FileCheck %s

class A {
public:
  int x;
  A():x(0) {}
  ~A() {}
};

class B {
int x[100];
};

A g_a;
B g_b;

void func_with_ref_arg(A &a);
void func_with_ref_arg(B &b);

// CHECK-LABEL: @_Z22func_with_indirect_arg1A(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[P:%.*]] = alloca %class.A*, align 8, addrspace(5)
// CHECK-NEXT:    [[P_ASCAST:%.*]] = addrspacecast %class.A* addrspace(5)* [[P]] to %class.A**
// CHECK-NEXT:    [[A_ASCAST:%.*]] = addrspacecast [[CLASS_A:%.*]] addrspace(5)* [[A:%.*]] to %class.A*
// CHECK-NEXT:    store %class.A* [[A_ASCAST]], %class.A** [[P_ASCAST]], align 8
// CHECK-NEXT:    ret void
//
void func_with_indirect_arg(A a) {
  A *p = &a;
}

// CHECK-LABEL: @_Z22test_indirect_arg_autov(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[A:%.*]] = alloca [[CLASS_A:%.*]], align 4, addrspace(5)
// CHECK-NEXT:    [[A_ASCAST:%.*]] = addrspacecast [[CLASS_A]] addrspace(5)* [[A]] to %class.A*
// CHECK-NEXT:    [[AGG_TMP:%.*]] = alloca [[CLASS_A]], align 4, addrspace(5)
// CHECK-NEXT:    [[AGG_TMP_ASCAST:%.*]] = addrspacecast [[CLASS_A]] addrspace(5)* [[AGG_TMP]] to %class.A*
// CHECK-NEXT:    call void @_ZN1AC1Ev(%class.A* nonnull align 4 dereferenceable(4) [[A_ASCAST]])
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast %class.A* [[AGG_TMP_ASCAST]] to i8*
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast %class.A* [[A_ASCAST]] to i8*
// CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 [[TMP1]], i64 4, i1 false)
// CHECK-NEXT:    [[AGG_TMP_ASCAST_ASCAST:%.*]] = addrspacecast %class.A* [[AGG_TMP_ASCAST]] to [[CLASS_A]] addrspace(5)*
// CHECK-NEXT:    call void @_Z22func_with_indirect_arg1A([[CLASS_A]] addrspace(5)* [[AGG_TMP_ASCAST_ASCAST]])
// CHECK-NEXT:    call void @_ZN1AD1Ev(%class.A* nonnull align 4 dereferenceable(4) [[AGG_TMP_ASCAST]])
// CHECK-NEXT:    call void @_Z17func_with_ref_argR1A(%class.A* nonnull align 4 dereferenceable(4) [[A_ASCAST]])
// CHECK-NEXT:    call void @_ZN1AD1Ev(%class.A* nonnull align 4 dereferenceable(4) [[A_ASCAST]])
// CHECK-NEXT:    ret void
//
void test_indirect_arg_auto() {
  A a;
  func_with_indirect_arg(a);
  func_with_ref_arg(a);
}

// CHECK-LABEL: @_Z24test_indirect_arg_globalv(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[AGG_TMP:%.*]] = alloca [[CLASS_A:%.*]], align 4, addrspace(5)
// CHECK-NEXT:    [[AGG_TMP_ASCAST:%.*]] = addrspacecast [[CLASS_A]] addrspace(5)* [[AGG_TMP]] to %class.A*
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast %class.A* [[AGG_TMP_ASCAST]] to i8*
// CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 addrspacecast (i8 addrspace(1)* bitcast ([[CLASS_A]] addrspace(1)* @g_a to i8 addrspace(1)*) to i8*), i64 4, i1 false)
// CHECK-NEXT:    [[AGG_TMP_ASCAST_ASCAST:%.*]] = addrspacecast %class.A* [[AGG_TMP_ASCAST]] to [[CLASS_A]] addrspace(5)*
// CHECK-NEXT:    call void @_Z22func_with_indirect_arg1A([[CLASS_A]] addrspace(5)* [[AGG_TMP_ASCAST_ASCAST]])
// CHECK-NEXT:    call void @_ZN1AD1Ev(%class.A* nonnull align 4 dereferenceable(4) [[AGG_TMP_ASCAST]])
// CHECK-NEXT:    call void @_Z17func_with_ref_argR1A(%class.A* nonnull align 4 dereferenceable(4) addrspacecast ([[CLASS_A]] addrspace(1)* @g_a to %class.A*))
// CHECK-NEXT:    ret void
//
void test_indirect_arg_global() {
  func_with_indirect_arg(g_a);
  func_with_ref_arg(g_a);
}

// CHECK-LABEL: @_Z19func_with_byval_arg1B(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[P:%.*]] = alloca %class.B*, align 8, addrspace(5)
// CHECK-NEXT:    [[P_ASCAST:%.*]] = addrspacecast %class.B* addrspace(5)* [[P]] to %class.B**
// CHECK-NEXT:    [[B_ASCAST:%.*]] = addrspacecast [[CLASS_B:%.*]] addrspace(5)* [[B:%.*]] to %class.B*
// CHECK-NEXT:    store %class.B* [[B_ASCAST]], %class.B** [[P_ASCAST]], align 8
// CHECK-NEXT:    ret void
//
void func_with_byval_arg(B b) {
  B *p = &b;
}

// CHECK-LABEL: @_Z19test_byval_arg_autov(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[B:%.*]] = alloca [[CLASS_B:%.*]], align 4, addrspace(5)
// CHECK-NEXT:    [[B_ASCAST:%.*]] = addrspacecast [[CLASS_B]] addrspace(5)* [[B]] to %class.B*
// CHECK-NEXT:    [[AGG_TMP:%.*]] = alloca [[CLASS_B]], align 4, addrspace(5)
// CHECK-NEXT:    [[AGG_TMP_ASCAST:%.*]] = addrspacecast [[CLASS_B]] addrspace(5)* [[AGG_TMP]] to %class.B*
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast %class.B* [[AGG_TMP_ASCAST]] to i8*
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast %class.B* [[B_ASCAST]] to i8*
// CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 [[TMP1]], i64 400, i1 false)
// CHECK-NEXT:    [[AGG_TMP_ASCAST_ASCAST:%.*]] = addrspacecast %class.B* [[AGG_TMP_ASCAST]] to [[CLASS_B]] addrspace(5)*
// CHECK-NEXT:    call void @_Z19func_with_byval_arg1B([[CLASS_B]] addrspace(5)* byval([[CLASS_B]]) align 4 [[AGG_TMP_ASCAST_ASCAST]])
// CHECK-NEXT:    call void @_Z17func_with_ref_argR1B(%class.B* nonnull align 4 dereferenceable(400) [[B_ASCAST]])
// CHECK-NEXT:    ret void
//
void test_byval_arg_auto() {
  B b;
  func_with_byval_arg(b);
  func_with_ref_arg(b);
}

// CHECK-LABEL: @_Z21test_byval_arg_globalv(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[AGG_TMP:%.*]] = alloca [[CLASS_B:%.*]], align 4, addrspace(5)
// CHECK-NEXT:    [[AGG_TMP_ASCAST:%.*]] = addrspacecast [[CLASS_B]] addrspace(5)* [[AGG_TMP]] to %class.B*
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast %class.B* [[AGG_TMP_ASCAST]] to i8*
// CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 addrspacecast (i8 addrspace(1)* bitcast ([[CLASS_B]] addrspace(1)* @g_b to i8 addrspace(1)*) to i8*), i64 400, i1 false)
// CHECK-NEXT:    [[AGG_TMP_ASCAST_ASCAST:%.*]] = addrspacecast %class.B* [[AGG_TMP_ASCAST]] to [[CLASS_B]] addrspace(5)*
// CHECK-NEXT:    call void @_Z19func_with_byval_arg1B([[CLASS_B]] addrspace(5)* byval([[CLASS_B]]) align 4 [[AGG_TMP_ASCAST_ASCAST]])
// CHECK-NEXT:    call void @_Z17func_with_ref_argR1B(%class.B* nonnull align 4 dereferenceable(400) addrspacecast ([[CLASS_B]] addrspace(1)* @g_b to %class.B*))
// CHECK-NEXT:    ret void
//
void test_byval_arg_global() {
  func_with_byval_arg(g_b);
  func_with_ref_arg(g_b);
}
