<!--===- docs/GettingInvolved.md

   Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
   See https://llvm.org/LICENSE.txt for license information.
   SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

-->
# Getting Involved

```eval_rst
.. contents::
   :local:
```

The Flang Project welcomes contributions of all kinds.
Please feel free to join the mailing list or the slack channel for discussions related to development of Flang.
To understand the status of various developments in Flang please join the respective call.

## Mailing Lists

[Developer's List (flang-dev)](http://lists.llvm.org/mailman/listinfo/flang-dev)

  This list is for people who want to be included in technical discussions related to Flang. People post to this list when they have questions about writing code
  for or using the Flang tools. It is relatively low volume.


[Commits Archive (flang-commits)](http://lists.llvm.org/pipermail/flang-commits)

  This list contains all commit messages that are made when Flang developers
  commit code changes to the repository. It also serves as a forum for
  patch review (i.e. send patches here). It is useful for those who want to
  stay on the bleeding edge of Flang development. This list is high
  volume.

## Chat

### Flang Slack Workspace

-   There is a Slack workspace dedicated to Flang.
-   There are a number of topic-oriented channels available (e.g., #driver, #f18-semantics, #fir).
-   Add yourself via the *[invitation link](https://join.slack.com/t/flang-compiler/shared_invite/zt-2pcn51lh-VrRQL_YUOkxA_1CEfMGQhw "title")*

## Calls

### Flang Community Biweekly Call

-   General updates on the Flang Project, both LLVM Flang and current Flang.
-   Join [Flang Community Biweekly Call](https://lanl-us.webex.com/lanl-us/j.php?MTID=mdce13c9bd55202e8071d8128fb953614)
-   Time: On Wednesdays 8:30 Pacific Time, on the weeks alternating with regular Flang Community Technical Biweekly Call.
-   Meeting minutes are available in this [Google Doc](https://docs.google.com/document/d/10T-S2J3GrahpG4Ooif93NSTz2zBW0MQc_RlwHi0-afY/edit?usp=sharing).
    If you can not access the Google Doc, please send an email to Alexis Perry-Holby at aperry@lanl.gov requesting to be added to the access list.
-   Minutes from older meetings were sent to [flang-dev](http://lists.llvm.org/mailman/listinfo/flang-dev). Search for `Flang Biweekly Sync - Notes`.

### Flang Community Technical Biweekly Call

-   Technical topics call.
-   Join [Flang Community Technical Biweekly Call](https://bluejeans.com/284530575)
-   Time: On Mondays 8:30 Pacific Time, on the weeks alternating with regular Flang Community Biweekly Call.
-   The agenda is in this [Google Doc](https://docs.google.com/document/d/1Z2U5UAtJ-Dag5wlMaLaW1KRmNgENNAYynJqLW2j2AZQ/).

### LLVM Alias Analysis Technical Call

-   For people working on improvements to LLVM alias analysis.
-   Join [LLVM Alias Analysis Technical Call](https://bluejeans.com/316886064)
-   Time: Tuesdays 10:00 AM Pacific Time, every 4 weeks.
-   The agenda is in this [Google Doc](https://docs.google.com/document/d/1ybwEKDVtIbhIhK50qYtwKsL50K-NvB6LfuBsfepBZ9Y/).

### OpenMP in Flang Technical Call

-   Development updates on OpenMP and OpenACC in the Flang Project.
-   Join [OpenMP in Flang Technical Call](https://bit.ly/39eQW3o)
-   Time: Weekly call on every Thursdays 8:00 AM Pacific time.
-   Meeting minutes are [here](https://docs.google.com/document/d/1yA-MeJf6RYY-ZXpdol0t7YoDoqtwAyBhFLr5thu5pFI).
-   Status tracking [page](https://docs.google.com/spreadsheets/d/1FvHPuSkGbl4mQZRAwCIndvQx9dQboffiD-xD0oqxgU0/edit#gid=0).

### OpenMP in LLVM Technical Call

-   Development updates on OpenMP (and OpenACC) in the LLVM Project, including Clang, optimization, and runtime work.
-   Join [OpenMP in LLVM Technical Call](https://bluejeans.com/544112769//webrtc)
-   Time: Weekly call on every Wednesday 7:00 AM Pacific time.
-   Meeting minutes are [here](https://docs.google.com/document/d/1Tz8WFN13n7yJ-SCE0Qjqf9LmjGUw0dWO9Ts1ss4YOdg/edit).
-   Status tracking [page](https://openmp.llvm.org/docs).

### Classic Flang Biweekly Technical Call

-   For people working on Classic Flang, the original Flang Fortran 2003/2008 compiler.
-   Join [Classic Flang Biweekly Technical Call](https://teams.microsoft.com/l/meetup-join/19%3ameeting_YjM5YjlmNGEtMjA0MS00MTRlLTg5ZjUtOTM1ZGIxOTU2NWQy%40thread.v2)
-   The call is held every other Wednesday in the same week as the LLVM Flang Technical call (alternate week with the Flang Community Biweekly call).
-   The agenda is available [here](https://docs.google.com/document/d/1-OuiKx4d7O6eLEJDBDKSRnSiUO2rgRR-c2Ga4AkrzOI)
