; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -cost-model -analyze -mtriple=amdgcn-unknown-amdhsa %s | FileCheck -check-prefixes=ALL,CI %s
; RUN: opt -cost-model -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=fiji %s | FileCheck -check-prefixes=ALL,GFX89 %s
; RUN: opt -cost-model -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=gfx900 %s | FileCheck -check-prefixes=ALL,GFX89 %s
; RUN: opt -cost-model -cost-kind=code-size -analyze -mtriple=amdgcn-unknown-amdhsa %s | FileCheck -check-prefixes=ALL-SIZE,CI-SIZE %s
; RUN: opt -cost-model -cost-kind=code-size -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=fiji %s | FileCheck -check-prefixes=ALL-SIZE,GFX89-SIZE %s
; RUN: opt -cost-model -cost-kind=code-size -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=gfx900 %s | FileCheck -check-prefixes=ALL-SIZE,GFX89-SIZE %s
; END.

define amdgpu_kernel void @insertelement_i8(i32 %arg) {
; ALL-LABEL: 'insertelement_i8'
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_0 = insertelement <3 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_0 = insertelement <5 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_1 = insertelement <3 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_1 = insertelement <5 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_a = insertelement <2 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_a = insertelement <3 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_a = insertelement <4 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_a = insertelement <5 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; ALL-SIZE-LABEL: 'insertelement_i8'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_0 = insertelement <3 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_0 = insertelement <5 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_1 = insertelement <3 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_1 = insertelement <5 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_a = insertelement <2 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_a = insertelement <3 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_a = insertelement <4 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_a = insertelement <5 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i8_0 = insertelement <2 x i8> undef, i8 42, i32 0
  %v3i8_0 = insertelement <3 x i8> undef, i8 42, i32 0
  %v4i8_0 = insertelement <4 x i8> undef, i8 42, i32 0
  %v5i8_0 = insertelement <5 x i8> undef, i8 42, i32 0
  %v2i8_1 = insertelement <2 x i8> undef, i8 42, i32 1
  %v3i8_1 = insertelement <3 x i8> undef, i8 42, i32 1
  %v4i8_1 = insertelement <4 x i8> undef, i8 42, i32 1
  %v5i8_1 = insertelement <5 x i8> undef, i8 42, i32 1
  %v2i8_a = insertelement <2 x i8> undef, i8 42, i32 %arg
  %v3i8_a = insertelement <3 x i8> undef, i8 42, i32 %arg
  %v4i8_a = insertelement <4 x i8> undef, i8 42, i32 %arg
  %v5i8_a = insertelement <5 x i8> undef, i8 42, i32 %arg
  ret void
}

define amdgpu_kernel void @insertelement_i16(i32 %arg) {
; CI-LABEL: 'insertelement_i16'
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; GFX89-LABEL: 'insertelement_i16'
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; CI-SIZE-LABEL: 'insertelement_i16'
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; GFX89-SIZE-LABEL: 'insertelement_i16'
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
  %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
  %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
  %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
  %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
  %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
  %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
  %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
  %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
  %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
  %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
  %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
  ret void
}

define amdgpu_kernel void @insertelement_i32(i32 %arg) {
; ALL-LABEL: 'insertelement_i32'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_0 = insertelement <5 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_1 = insertelement <3 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_1 = insertelement <5 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_a = insertelement <2 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i32_a = insertelement <3 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_a = insertelement <4 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i32_a = insertelement <5 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; ALL-SIZE-LABEL: 'insertelement_i32'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_0 = insertelement <5 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_1 = insertelement <3 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_1 = insertelement <5 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_a = insertelement <2 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i32_a = insertelement <3 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_a = insertelement <4 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i32_a = insertelement <5 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i32_0 = insertelement <2 x i32> undef, i32 42, i32 0
  %v3i32_0 = insertelement <3 x i32> undef, i32 42, i32 0
  %v4i32_0 = insertelement <4 x i32> undef, i32 42, i32 0
  %v5i32_0 = insertelement <5 x i32> undef, i32 42, i32 0
  %v2i32_1 = insertelement <2 x i32> undef, i32 42, i32 1
  %v3i32_1 = insertelement <3 x i32> undef, i32 42, i32 1
  %v4i32_1 = insertelement <4 x i32> undef, i32 42, i32 1
  %v5i32_1 = insertelement <5 x i32> undef, i32 42, i32 1
  %v2i32_a = insertelement <2 x i32> undef, i32 42, i32 %arg
  %v3i32_a = insertelement <3 x i32> undef, i32 42, i32 %arg
  %v4i32_a = insertelement <4 x i32> undef, i32 42, i32 %arg
  %v5i32_a = insertelement <5 x i32> undef, i32 42, i32 %arg
  ret void
}

define amdgpu_kernel void @insertelement_i64(i32 %arg) {
; ALL-LABEL: 'insertelement_i64'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_0 = insertelement <3 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_0 = insertelement <5 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_1 = insertelement <3 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_1 = insertelement <5 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_a = insertelement <2 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i64_a = insertelement <3 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_a = insertelement <4 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i64_a = insertelement <5 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; ALL-SIZE-LABEL: 'insertelement_i64'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_0 = insertelement <3 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_0 = insertelement <5 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_1 = insertelement <3 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_1 = insertelement <5 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_a = insertelement <2 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i64_a = insertelement <3 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_a = insertelement <4 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i64_a = insertelement <5 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i64_0 = insertelement <2 x i64> undef, i64 42, i32 0
  %v3i64_0 = insertelement <3 x i64> undef, i64 42, i32 0
  %v4i64_0 = insertelement <4 x i64> undef, i64 42, i32 0
  %v5i64_0 = insertelement <5 x i64> undef, i64 42, i32 0
  %v2i64_1 = insertelement <2 x i64> undef, i64 42, i32 1
  %v3i64_1 = insertelement <3 x i64> undef, i64 42, i32 1
  %v4i64_1 = insertelement <4 x i64> undef, i64 42, i32 1
  %v5i64_1 = insertelement <5 x i64> undef, i64 42, i32 1
  %v2i64_a = insertelement <2 x i64> undef, i64 42, i32 %arg
  %v3i64_a = insertelement <3 x i64> undef, i64 42, i32 %arg
  %v4i64_a = insertelement <4 x i64> undef, i64 42, i32 %arg
  %v5i64_a = insertelement <5 x i64> undef, i64 42, i32 %arg
  ret void
}
