; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -attributor -enable-new-pm=0 -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=3 -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_CGSCC_NPM,NOT_CGSCC_OPM,NOT_TUNIT_NPM,IS__TUNIT____,IS________OPM,IS__TUNIT_OPM
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=3 -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_CGSCC_OPM,NOT_CGSCC_NPM,NOT_TUNIT_OPM,IS__TUNIT____,IS________NPM,IS__TUNIT_NPM
; RUN: opt -attributor-cgscc -enable-new-pm=0 -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_TUNIT_NPM,NOT_TUNIT_OPM,NOT_CGSCC_NPM,IS__CGSCC____,IS________OPM,IS__CGSCC_OPM
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_TUNIT_NPM,NOT_TUNIT_OPM,NOT_CGSCC_OPM,IS__CGSCC____,IS________NPM,IS__CGSCC_NPM
;
; Test cases specifically designed for the "returned" argument attribute.
; We use FIXME's to indicate problems and missing attributes.
;

; TEST SCC test returning an integer value argument
;
; int scc_r1(int a, int b, int r);
; int scc_r2(int a, int b, int r);
;
; __attribute__((noinline)) int sink_r0(int r) {
;   return r;
; }
;
; __attribute__((noinline)) int scc_r1(int a, int r, int b) {
;   return scc_r2(r, a, sink_r0(r));
; }
;
; __attribute__((noinline)) int scc_r2(int a, int b, int r) {
;   if (a > b)
;     return scc_r2(b, a, sink_r0(r));
;   if (a < b)
;     return scc_r1(sink_r0(b), scc_r2(scc_r1(a, b, r), scc_r1(a, scc_r2(r, r, r), r), scc_r2(a, b, r)), scc_r1(a, b, r));
;   return a == b ? r : scc_r2(a, b, r);
; }
; __attribute__((noinline)) int scc_rX(int a, int b, int r) {
;   if (a > b)
;     return scc_r2(b, a, sink_r0(r));
;   if (a < b)                                                                         // V Diff to scc_r2
;     return scc_r1(sink_r0(b), scc_r2(scc_r1(a, b, r), scc_r1(a, scc_r2(r, r, r), r), scc_r1(a, b, r)), scc_r1(a, b, r));
;   return a == b ? r : scc_r2(a, b, r);
; }
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

;.
; CHECK: @[[G:[a-zA-Z0-9_$"\\.-]+]] = external global i8
; CHECK: @[[_ZTI1X:[a-zA-Z0-9_$"\\.-]+]] = external dso_local constant { i8*, i8* }, align 8
; CHECK: @[[_ZTI1Y:[a-zA-Z0-9_$"\\.-]+]] = external dso_local constant { i8*, i8*, i8* }, align 8
;.
define i32 @sink_r0(i32 %r) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@sink_r0
; CHECK-SAME: (i32 returned [[R:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  ret i32 %r
}

define i32 @scc_r1(i32 %a, i32 %r, i32 %b) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@scc_r1
; IS__TUNIT____-SAME: (i32 [[A:%.*]], i32 returned [[R:%.*]], i32 [[B:%.*]]) #[[ATTR1:[0-9]+]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[A]], i32 [[R]]) #[[ATTR10:[0-9]+]]
; IS__TUNIT____-NEXT:    ret i32 [[R]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@scc_r1
; IS__CGSCC____-SAME: (i32 [[A:%.*]], i32 returned [[R:%.*]], i32 [[B:%.*]]) #[[ATTR1:[0-9]+]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[A]], i32 [[R]]) #[[ATTR7:[0-9]+]]
; IS__CGSCC____-NEXT:    ret i32 [[R]]
;
entry:
  %call = call i32 @sink_r0(i32 %r)
  %call1 = call i32 @scc_r2(i32 %r, i32 %a, i32 %call)
  ret i32 %call1
}

define i32 @scc_r2(i32 %a, i32 %b, i32 %r) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@scc_r2
; IS__TUNIT____-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 returned [[R:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__TUNIT____:       if.then:
; IS__TUNIT____-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[RETURN:%.*]]
; IS__TUNIT____:       if.end:
; IS__TUNIT____-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; IS__TUNIT____:       if.then3:
; IS__TUNIT____-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL8:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[R]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[RETURN]]
; IS__TUNIT____:       if.end12:
; IS__TUNIT____-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; IS__TUNIT____:       cond.true:
; IS__TUNIT____-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT____:       cond.false:
; IS__TUNIT____-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[COND_END]]
; IS__TUNIT____:       cond.end:
; IS__TUNIT____-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; IS__TUNIT____-NEXT:    br label [[RETURN]]
; IS__TUNIT____:       return:
; IS__TUNIT____-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[COND]], [[COND_END]] ]
; IS__TUNIT____-NEXT:    ret i32 [[R]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@scc_r2
; IS__CGSCC____-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 returned [[R:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__CGSCC____:       if.then:
; IS__CGSCC____-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[RETURN:%.*]]
; IS__CGSCC____:       if.end:
; IS__CGSCC____-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; IS__CGSCC____:       if.then3:
; IS__CGSCC____-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 undef) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL8:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[R]], i32 undef) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[RETURN]]
; IS__CGSCC____:       if.end12:
; IS__CGSCC____-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; IS__CGSCC____:       cond.true:
; IS__CGSCC____-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC____:       cond.false:
; IS__CGSCC____-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[COND_END]]
; IS__CGSCC____:       cond.end:
; IS__CGSCC____-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; IS__CGSCC____-NEXT:    br label [[RETURN]]
; IS__CGSCC____:       return:
; IS__CGSCC____-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[COND]], [[COND_END]] ]
; IS__CGSCC____-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp sgt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call i32 @sink_r0(i32 %r)
  %call1 = call i32 @scc_r2(i32 %b, i32 %a, i32 %call)
  br label %return

if.end:                                           ; preds = %entry
  %cmp2 = icmp slt i32 %a, %b
  br i1 %cmp2, label %if.then3, label %if.end12

if.then3:                                         ; preds = %if.end
  %call4 = call i32 @sink_r0(i32 %b)
  %call5 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call6 = call i32 @scc_r2(i32 %r, i32 %r, i32 %r)
  %call7 = call i32 @scc_r1(i32 %a, i32 %call6, i32 %r)
  %call8 = call i32 @scc_r2(i32 %a, i32 %b, i32 %r)
  %call9 = call i32 @scc_r2(i32 %call5, i32 %call7, i32 %call8)
  %call10 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call11 = call i32 @scc_r1(i32 %call4, i32 %call9, i32 %call10)
  br label %return

if.end12:                                         ; preds = %if.end
  %cmp13 = icmp eq i32 %a, %b
  br i1 %cmp13, label %cond.true, label %cond.false

cond.true:                                        ; preds = %if.end12
  br label %cond.end

cond.false:                                       ; preds = %if.end12
  %call14 = call i32 @scc_r2(i32 %a, i32 %b, i32 %r)
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi i32 [ %r, %cond.true ], [ %call14, %cond.false ]
  br label %return

return:                                           ; preds = %cond.end, %if.then3, %if.then
  %retval.0 = phi i32 [ %call1, %if.then ], [ %call11, %if.then3 ], [ %cond, %cond.end ]
  ret i32 %retval.0
}

define i32 @scc_rX(i32 %a, i32 %b, i32 %r) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline norecurse nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@scc_rX
; IS__TUNIT____-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[R:%.*]]) #[[ATTR2:[0-9]+]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__TUNIT____:       if.then:
; IS__TUNIT____-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[RETURN:%.*]]
; IS__TUNIT____:       if.end:
; IS__TUNIT____-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; IS__TUNIT____:       if.then3:
; IS__TUNIT____-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL8:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[B]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[B]], i32 undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[RETURN]]
; IS__TUNIT____:       if.end12:
; IS__TUNIT____-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; IS__TUNIT____:       cond.true:
; IS__TUNIT____-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT____:       cond.false:
; IS__TUNIT____-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[COND_END]]
; IS__TUNIT____:       cond.end:
; IS__TUNIT____-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; IS__TUNIT____-NEXT:    br label [[RETURN]]
; IS__TUNIT____:       return:
; IS__TUNIT____-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[B]], [[IF_THEN3]] ], [ [[COND]], [[COND_END]] ]
; IS__TUNIT____-NEXT:    ret i32 [[RETVAL_0]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@scc_rX
; IS__CGSCC____-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[R:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__CGSCC____:       if.then:
; IS__CGSCC____-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR8:[0-9]+]]
; IS__CGSCC____-NEXT:    br label [[RETURN:%.*]]
; IS__CGSCC____:       if.end:
; IS__CGSCC____-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; IS__CGSCC____:       if.then3:
; IS__CGSCC____-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 [[R]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    [[CALL8:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[B]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    [[CALL10:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[B]], i32 [[B]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    br label [[RETURN]]
; IS__CGSCC____:       if.end12:
; IS__CGSCC____-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; IS__CGSCC____:       cond.true:
; IS__CGSCC____-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC____:       cond.false:
; IS__CGSCC____-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; IS__CGSCC____-NEXT:    br label [[COND_END]]
; IS__CGSCC____:       cond.end:
; IS__CGSCC____-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; IS__CGSCC____-NEXT:    br label [[RETURN]]
; IS__CGSCC____:       return:
; IS__CGSCC____-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[B]], [[IF_THEN3]] ], [ [[COND]], [[COND_END]] ]
; IS__CGSCC____-NEXT:    ret i32 [[RETVAL_0]]
;
entry:
  %cmp = icmp sgt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call i32 @sink_r0(i32 %r)
  %call1 = call i32 @scc_r2(i32 %b, i32 %a, i32 %call)
  br label %return

if.end:                                           ; preds = %entry
  %cmp2 = icmp slt i32 %a, %b
  br i1 %cmp2, label %if.then3, label %if.end12

if.then3:                                         ; preds = %if.end
  %call4 = call i32 @sink_r0(i32 %b)
  %call5 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call6 = call i32 @scc_r2(i32 %r, i32 %r, i32 %r)
  %call7 = call i32 @scc_r1(i32 %a, i32 %call6, i32 %r)
  %call8 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call9 = call i32 @scc_r2(i32 %call5, i32 %call7, i32 %call8)
  %call10 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call11 = call i32 @scc_r1(i32 %call4, i32 %call9, i32 %call10)
  br label %return

if.end12:                                         ; preds = %if.end
  %cmp13 = icmp eq i32 %a, %b
  br i1 %cmp13, label %cond.true, label %cond.false

cond.true:                                        ; preds = %if.end12
  br label %cond.end

cond.false:                                       ; preds = %if.end12
  %call14 = call i32 @scc_r2(i32 %a, i32 %b, i32 %r)
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi i32 [ %r, %cond.true ], [ %call14, %cond.false ]
  br label %return

return:                                           ; preds = %cond.end, %if.then3, %if.then
  %retval.0 = phi i32 [ %call1, %if.then ], [ %call11, %if.then3 ], [ %cond, %cond.end ]
  ret i32 %retval.0
}


; TEST SCC test returning a pointer value argument
;
; double* ptr_scc_r1(double* a, double* b, double* r);
; double* ptr_scc_r2(double* a, double* b, double* r);
;
; __attribute__((noinline)) double* ptr_sink_r0(double* r) {
;   return r;
; }
;
; __attribute__((noinline)) double* ptr_scc_r1(double* a, double* r, double* b) {
;   return ptr_scc_r2(r, a, ptr_sink_r0(r));
; }
;
; __attribute__((noinline)) double* ptr_scc_r2(double* a, double* b, double* r) {
;   if (a > b)
;     return ptr_scc_r2(b, a, ptr_sink_r0(r));
;   if (a < b)
;     return ptr_scc_r1(ptr_sink_r0(b), ptr_scc_r2(ptr_scc_r1(a, b, r), ptr_scc_r1(a, ptr_scc_r2(r, r, r), r), ptr_scc_r2(a, b, r)), ptr_scc_r1(a, b, r));
;   return a == b ? r : ptr_scc_r2(a, b, r);
; }
define double* @ptr_sink_r0(double* %r) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@ptr_sink_r0
; CHECK-SAME: (double* nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret double* [[R]]
;
entry:
  ret double* %r
}

define double* @ptr_scc_r1(double* %a, double* %r, double* %b) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@ptr_scc_r1
; IS__TUNIT____-SAME: (double* nocapture nofree readnone [[A:%.*]], double* nofree readnone returned "no-capture-maybe-returned" [[R:%.*]], double* nocapture nofree readnone [[B:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL1:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[R]], double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    ret double* [[R]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@ptr_scc_r1
; IS__CGSCC____-SAME: (double* nocapture nofree readnone [[A:%.*]], double* nofree readnone returned [[R:%.*]], double* nocapture nofree readnone [[B:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL1:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[R]], double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    ret double* [[R]]
;
entry:
  %call = call double* @ptr_sink_r0(double* %r)
  %call1 = call double* @ptr_scc_r2(double* %r, double* %a, double* %call)
  ret double* %call1
}

define double* @ptr_scc_r2(double* %a, double* %b, double* %r) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@ptr_scc_r2
; IS__TUNIT____-SAME: (double* nocapture nofree readnone [[A:%.*]], double* nocapture nofree readnone [[B:%.*]], double* nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp ugt double* [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__TUNIT____:       if.then:
; IS__TUNIT____-NEXT:    [[CALL1:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[B]], double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[RETURN:%.*]]
; IS__TUNIT____:       if.end:
; IS__TUNIT____-NEXT:    [[CMP2:%.*]] = icmp ult double* [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; IS__TUNIT____:       if.then3:
; IS__TUNIT____-NEXT:    [[CALL5:%.*]] = call double* @ptr_scc_r1(double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone "no-capture-maybe-returned" [[B]], double* noalias nocapture nofree readnone undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL6:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[R]], double* noalias nocapture nofree readnone [[R]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL7:%.*]] = call double* @ptr_scc_r1(double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]], double* noalias nocapture nofree readnone undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL8:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[A]], double* noalias nocapture nofree readnone [[B]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL9:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[B]], double* noalias nocapture nofree readnone [[R]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    [[CALL11:%.*]] = call double* @ptr_scc_r1(double* noalias nocapture nofree readnone [[B]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]], double* noalias nocapture nofree readnone undef) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[RETURN]]
; IS__TUNIT____:       if.end12:
; IS__TUNIT____-NEXT:    [[CMP13:%.*]] = icmp eq double* [[A]], [[B]]
; IS__TUNIT____-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; IS__TUNIT____:       cond.true:
; IS__TUNIT____-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT____:       cond.false:
; IS__TUNIT____-NEXT:    [[CALL14:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[A]], double* noalias nocapture nofree readnone [[B]], double* noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[COND_END]]
; IS__TUNIT____:       cond.end:
; IS__TUNIT____-NEXT:    [[COND:%.*]] = phi double* [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; IS__TUNIT____-NEXT:    br label [[RETURN]]
; IS__TUNIT____:       return:
; IS__TUNIT____-NEXT:    [[RETVAL_0:%.*]] = phi double* [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[COND]], [[COND_END]] ]
; IS__TUNIT____-NEXT:    ret double* [[R]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@ptr_scc_r2
; IS__CGSCC____-SAME: (double* nocapture nofree readnone [[A:%.*]], double* nocapture nofree readnone [[B:%.*]], double* nofree readnone returned [[R:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp ugt double* [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__CGSCC____:       if.then:
; IS__CGSCC____-NEXT:    [[CALL1:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[B]], double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[RETURN:%.*]]
; IS__CGSCC____:       if.end:
; IS__CGSCC____-NEXT:    [[CMP2:%.*]] = icmp ult double* [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; IS__CGSCC____:       if.then3:
; IS__CGSCC____-NEXT:    [[CALL5:%.*]] = call double* @ptr_scc_r1(double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone [[B]], double* noalias nocapture nofree readnone undef) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL6:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[R]], double* noalias nocapture nofree readnone [[R]], double* noalias nofree readnone [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL7:%.*]] = call double* @ptr_scc_r1(double* noalias nocapture nofree readnone [[A]], double* noalias nofree readnone [[R]], double* noalias nocapture nofree readnone undef) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL8:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[A]], double* noalias nocapture nofree readnone [[B]], double* noalias nofree readnone [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL9:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[B]], double* noalias nocapture nofree readnone [[R]], double* noalias nofree readnone [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    [[CALL11:%.*]] = call double* @ptr_scc_r1(double* noalias nocapture nofree readnone [[B]], double* noalias nofree readnone [[R]], double* noalias nocapture nofree readnone undef) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[RETURN]]
; IS__CGSCC____:       if.end12:
; IS__CGSCC____-NEXT:    [[CMP13:%.*]] = icmp eq double* [[A]], [[B]]
; IS__CGSCC____-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; IS__CGSCC____:       cond.true:
; IS__CGSCC____-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC____:       cond.false:
; IS__CGSCC____-NEXT:    [[CALL14:%.*]] = call double* @ptr_scc_r2(double* noalias nocapture nofree readnone [[A]], double* noalias nocapture nofree readnone [[B]], double* noalias nofree readnone [[R]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[COND_END]]
; IS__CGSCC____:       cond.end:
; IS__CGSCC____-NEXT:    [[COND:%.*]] = phi double* [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; IS__CGSCC____-NEXT:    br label [[RETURN]]
; IS__CGSCC____:       return:
; IS__CGSCC____-NEXT:    [[RETVAL_0:%.*]] = phi double* [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[COND]], [[COND_END]] ]
; IS__CGSCC____-NEXT:    ret double* [[R]]
;
entry:
  %cmp = icmp ugt double* %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call double* @ptr_sink_r0(double* %r)
  %call1 = call double* @ptr_scc_r2(double* %b, double* %a, double* %call)
  br label %return

if.end:                                           ; preds = %entry
  %cmp2 = icmp ult double* %a, %b
  br i1 %cmp2, label %if.then3, label %if.end12

if.then3:                                         ; preds = %if.end
  %call4 = call double* @ptr_sink_r0(double* %b)
  %call5 = call double* @ptr_scc_r1(double* %a, double* %b, double* %r)
  %call6 = call double* @ptr_scc_r2(double* %r, double* %r, double* %r)
  %call7 = call double* @ptr_scc_r1(double* %a, double* %call6, double* %r)
  %call8 = call double* @ptr_scc_r2(double* %a, double* %b, double* %r)
  %call9 = call double* @ptr_scc_r2(double* %call5, double* %call7, double* %call8)
  %call10 = call double* @ptr_scc_r1(double* %a, double* %b, double* %r)
  %call11 = call double* @ptr_scc_r1(double* %call4, double* %call9, double* %call10)
  br label %return

if.end12:                                         ; preds = %if.end
  %cmp13 = icmp eq double* %a, %b
  br i1 %cmp13, label %cond.true, label %cond.false

cond.true:                                        ; preds = %if.end12
  br label %cond.end

cond.false:                                       ; preds = %if.end12
  %call14 = call double* @ptr_scc_r2(double* %a, double* %b, double* %r)
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi double* [ %r, %cond.true ], [ %call14, %cond.false ]
  br label %return

return:                                           ; preds = %cond.end, %if.then3, %if.then
  %retval.0 = phi double* [ %call1, %if.then ], [ %call11, %if.then3 ], [ %cond, %cond.end ]
  ret double* %retval.0
}


; TEST a no-return singleton SCC
;
; int* rt0(int *a) {
;   return *a ? a : rt0(a);
; }
;
define i32* @rt0(i32* %a) #0 {
; IS__TUNIT____: Function Attrs: argmemonly nofree noinline nosync nounwind readonly uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@rt0
; IS__TUNIT____-SAME: (i32* nofree noundef nonnull readonly returned align 4 dereferenceable(4) "no-capture-maybe-returned" [[A:%.*]]) #[[ATTR3:[0-9]+]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @rt0(i32* nofree noundef nonnull readonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[A]]) #[[ATTR11:[0-9]+]]
; IS__TUNIT____-NEXT:    ret i32* [[A]]
;
; IS__CGSCC____: Function Attrs: argmemonly nofree noinline nosync nounwind readonly uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@rt0
; IS__CGSCC____-SAME: (i32* nofree noundef nonnull readonly returned align 4 dereferenceable(4) "no-capture-maybe-returned" [[A:%.*]]) #[[ATTR2:[0-9]+]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @rt0(i32* nofree noundef nonnull readonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[A]]) #[[ATTR9:[0-9]+]]
; IS__CGSCC____-NEXT:    ret i32* [[A]]
;
entry:
  %v = load i32, i32* %a, align 4
  %tobool = icmp ne i32 %v, 0
  %call = call i32* @rt0(i32* %a)
  %sel = select i1 %tobool, i32* %a, i32* %call
  ret i32* %sel
}

; TEST a no-return singleton SCC
;
; int* rt1(int *a) {
;   return *a ? undef : rt1(a);
; }
;
define i32* @rt1(i32* %a) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@rt1
; IS__TUNIT____-SAME: (i32* nocapture nofree nonnull readnone align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR4:[0-9]+]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    ret i32* undef
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@rt1
; IS__CGSCC____-SAME: (i32* nocapture nofree nonnull readnone align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR3:[0-9]+]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    ret i32* undef
;
entry:
  %v = load i32, i32* %a, align 4
  %tobool = icmp ne i32 %v, 0
  %call = call i32* @rt1(i32* %a)
  %sel = select i1 %tobool, i32* undef, i32* %call
  ret i32* %sel
}

; TEST another SCC test
;
define i32* @rt2_helper(i32* %a) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@rt2_helper
; IS__TUNIT____-SAME: (i32* nofree readnone returned [[A:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @rt2(i32* noalias nofree readnone [[A]], i32* noalias nofree readnone "no-capture-maybe-returned" [[A]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    ret i32* [[A]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@rt2_helper
; IS__CGSCC____-SAME: (i32* nofree readnone returned [[A:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @rt2(i32* noalias nofree readnone [[A]], i32* noalias nofree readnone "no-capture-maybe-returned" [[A]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    ret i32* [[A]]
;
entry:
  %call = call i32* @rt2(i32* %a, i32* %a)
  ret i32* %call
}

define i32* @rt2(i32* %a, i32 *%b) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@rt2
; IS__TUNIT____-SAME: (i32* nofree readnone [[A:%.*]], i32* nofree readnone "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[A]], null
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__TUNIT____:       if.then:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @rt2_helper(i32* noalias nofree readnone [[A]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[IF_END]]
; IS__TUNIT____:       if.end:
; IS__TUNIT____-NEXT:    [[SEL:%.*]] = phi i32* [ [[B]], [[ENTRY:%.*]] ], [ [[A]], [[IF_THEN]] ]
; IS__TUNIT____-NEXT:    ret i32* [[SEL]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@rt2
; IS__CGSCC____-SAME: (i32* nofree readnone [[A:%.*]], i32* nofree readnone "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[A]], null
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__CGSCC____:       if.then:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @rt2_helper(i32* noalias nofree readnone [[A]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[IF_END]]
; IS__CGSCC____:       if.end:
; IS__CGSCC____-NEXT:    [[SEL:%.*]] = phi i32* [ [[B]], [[ENTRY:%.*]] ], [ [[A]], [[IF_THEN]] ]
; IS__CGSCC____-NEXT:    ret i32* [[SEL]]
;
entry:
  %cmp = icmp eq i32* %a, null
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %call = call i32* @rt2_helper(i32* %a)
  br label %if.end

if.end:
  %sel = phi i32* [ %b, %entry], [%call, %if.then]
  ret i32* %sel
}

; TEST another SCC test
;
define i32* @rt3_helper(i32* %a, i32* %b) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@rt3_helper
; IS__TUNIT____-SAME: (i32* nocapture nofree readnone [[A:%.*]], i32* nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @rt3(i32* noalias nocapture nofree readnone [[A]], i32* noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    ret i32* [[B]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@rt3_helper
; IS__CGSCC____-SAME: (i32* nocapture nofree readnone [[A:%.*]], i32* nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @rt3(i32* noalias nocapture nofree readnone [[A]], i32* noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    ret i32* [[B]]
;
entry:
  %call = call i32* @rt3(i32* %a, i32* %b)
  ret i32* %call
}

define i32* @rt3(i32* %a, i32 *%b) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@rt3
; IS__TUNIT____-SAME: (i32* nocapture nofree readnone [[A:%.*]], i32* nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[A]], null
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__TUNIT____:       if.then:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @rt3_helper(i32* noalias nocapture nofree readnone [[A]], i32* noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[IF_END]]
; IS__TUNIT____:       if.end:
; IS__TUNIT____-NEXT:    [[SEL:%.*]] = phi i32* [ [[B]], [[ENTRY:%.*]] ], [ [[B]], [[IF_THEN]] ]
; IS__TUNIT____-NEXT:    ret i32* [[B]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@rt3
; IS__CGSCC____-SAME: (i32* nocapture nofree readnone [[A:%.*]], i32* nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[A]], null
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__CGSCC____:       if.then:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @rt3_helper(i32* noalias nocapture nofree readnone [[A]], i32* noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[IF_END]]
; IS__CGSCC____:       if.end:
; IS__CGSCC____-NEXT:    [[SEL:%.*]] = phi i32* [ [[B]], [[ENTRY:%.*]] ], [ [[B]], [[IF_THEN]] ]
; IS__CGSCC____-NEXT:    ret i32* [[B]]
;
entry:
  %cmp = icmp eq i32* %a, null
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %call = call i32* @rt3_helper(i32* %a, i32* %b)
  br label %if.end

if.end:
  %sel = phi i32* [ %b, %entry], [%call, %if.then]
  ret i32* %sel
}

; TEST address taken function with call to an external functions
;
;  void unknown_fn(void *);
;
;  int* calls_unknown_fn(int *r) {
;    unknown_fn(&calls_unknown_fn);
;    return r;
;  }
;
declare void @unknown_fn(i32* (i32*)*) #0

define i32* @calls_unknown_fn(i32* %r) #0 {
; IS__TUNIT____: Function Attrs: noinline nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@calls_unknown_fn
; IS__TUNIT____-SAME: (i32* nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR5:[0-9]+]] {
; IS__TUNIT____-NEXT:    tail call void @unknown_fn(i32* (i32*)* noundef nonnull @calls_unknown_fn) #[[ATTR12:[0-9]+]]
; IS__TUNIT____-NEXT:    ret i32* [[R]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@calls_unknown_fn
; IS__CGSCC____-SAME: (i32* nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR4:[0-9]+]] {
; IS__CGSCC____-NEXT:    tail call void @unknown_fn(i32* (i32*)* noundef nonnull @calls_unknown_fn) #[[ATTR10:[0-9]+]]
; IS__CGSCC____-NEXT:    ret i32* [[R]]
;
  tail call void @unknown_fn(i32* (i32*)* nonnull @calls_unknown_fn)
  ret i32* %r
}


; TEST call to a function that might be redifined at link time
;
;  int *maybe_redefined_fn(int *r) {
;    return r;
;  }
;
;  int *calls_maybe_redefined_fn(int *r) {
;    maybe_redefined_fn(r);
;    return r;
;  }
;
; Verify the maybe-redefined function is not annotated:
;
define linkonce_odr i32* @maybe_redefined_fn(i32* %r) #0 {
; IS__TUNIT____: Function Attrs: noinline nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@maybe_redefined_fn
; IS__TUNIT____-SAME: (i32* [[R:%.*]]) #[[ATTR5]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    ret i32* [[R]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@maybe_redefined_fn
; IS__CGSCC____-SAME: (i32* [[R:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    ret i32* [[R]]
;
entry:
  ret i32* %r
}

define i32* @calls_maybe_redefined_fn(i32* %r) #0 {
; IS__TUNIT____: Function Attrs: noinline norecurse nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn
; IS__TUNIT____-SAME: (i32* returned [[R:%.*]]) #[[ATTR6:[0-9]+]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @maybe_redefined_fn(i32* [[R]]) #[[ATTR12]]
; IS__TUNIT____-NEXT:    ret i32* [[R]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn
; IS__CGSCC____-SAME: (i32* returned [[R:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @maybe_redefined_fn(i32* [[R]]) #[[ATTR10]]
; IS__CGSCC____-NEXT:    ret i32* [[R]]
;
entry:
  %call = call i32* @maybe_redefined_fn(i32* %r)
  ret i32* %r
}

; TEST return call to a function that might be redifined at link time
;
;  int *maybe_redefined_fn2(int *r) {
;    return r;
;  }
;
;  int *calls_maybe_redefined_fn2(int *r) {
;    return maybe_redefined_fn2(r);
;  }
;
; Verify the maybe-redefined function is not annotated:
;
define linkonce_odr i32* @maybe_redefined_fn2(i32* %r) #0 {
; IS__TUNIT____: Function Attrs: noinline nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@maybe_redefined_fn2
; IS__TUNIT____-SAME: (i32* [[R:%.*]]) #[[ATTR5]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    ret i32* [[R]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@maybe_redefined_fn2
; IS__CGSCC____-SAME: (i32* [[R:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    ret i32* [[R]]
;
entry:
  ret i32* %r
}

define i32* @calls_maybe_redefined_fn2(i32* %r) #0 {
; IS__TUNIT____: Function Attrs: noinline norecurse nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn2
; IS__TUNIT____-SAME: (i32* [[R:%.*]]) #[[ATTR6]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @maybe_redefined_fn2(i32* [[R]]) #[[ATTR12]]
; IS__TUNIT____-NEXT:    ret i32* [[CALL]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn2
; IS__CGSCC____-SAME: (i32* [[R:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @maybe_redefined_fn2(i32* [[R]]) #[[ATTR10]]
; IS__CGSCC____-NEXT:    ret i32* [[CALL]]
;
entry:
  %call = call i32* @maybe_redefined_fn2(i32* %r)
  ret i32* %call
}


; TEST returned argument goes through select and phi
;
; double select_and_phi(double b) {
;   double x = b;
;   if (b > 0)
;     x = b;
;   return b == 0? b : x;
; }
;
define double @select_and_phi(double %b) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@select_and_phi
; CHECK-SAME: (double returned [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt double [[B]], 0.000000e+00
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret double [[B]]
;
entry:
  %cmp = fcmp ogt double %b, 0.000000e+00
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %phi = phi double [ %b, %if.then ], [ %b, %entry ]
  %cmp1 = fcmp oeq double %b, 0.000000e+00
  %sel = select i1 %cmp1, double %b, double %phi
  ret double %sel
}


; TEST returned argument goes through recursion, select, and phi
;
; double recursion_select_and_phi(int a, double b) {
;   double x = b;
;   if (a-- > 0)
;     x = recursion_select_and_phi(a, b);
;   return b == 0? b : x;
; }
;
define double @recursion_select_and_phi(i32 %a, double %b) #0 {
; IS__TUNIT____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@recursion_select_and_phi
; IS__TUNIT____-SAME: (i32 [[A:%.*]], double returned [[B:%.*]]) #[[ATTR1]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[DEC:%.*]] = add nsw i32 [[A]], -1
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], 0
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__TUNIT____:       if.then:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call double @recursion_select_and_phi(i32 [[DEC]], double [[B]]) #[[ATTR10]]
; IS__TUNIT____-NEXT:    br label [[IF_END]]
; IS__TUNIT____:       if.end:
; IS__TUNIT____-NEXT:    ret double [[B]]
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@recursion_select_and_phi
; IS__CGSCC____-SAME: (i32 [[A:%.*]], double returned [[B:%.*]]) #[[ATTR1]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[DEC:%.*]] = add nsw i32 [[A]], -1
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], 0
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; IS__CGSCC____:       if.then:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call double @recursion_select_and_phi(i32 [[DEC]], double [[B]]) #[[ATTR7]]
; IS__CGSCC____-NEXT:    br label [[IF_END]]
; IS__CGSCC____:       if.end:
; IS__CGSCC____-NEXT:    ret double [[B]]
;
entry:
  %dec = add nsw i32 %a, -1
  %cmp = icmp sgt i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call double @recursion_select_and_phi(i32 %dec, double %b)
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %phi = phi double [ %call, %if.then ], [ %b, %entry ]
  %cmp1 = fcmp oeq double %b, 0.000000e+00
  %sel = select i1 %cmp1, double %b, double %phi
  ret double %sel
}


; TEST returned argument goes through bitcasts
;
; double* bitcast(int* b) {
;   return (double*)b;
; }
;
define double* @bitcast(i32* %b) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@bitcast
; CHECK-SAME: (i32* nofree readnone "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC0:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    ret double* [[BC0]]
;
entry:
  %bc0 = bitcast i32* %b to double*
  ret double* %bc0
}


; TEST returned argument goes through select and phi interleaved with bitcasts
;
; double* bitcasts_select_and_phi(int* b) {
;   double* x = b;
;   if (b == 0)
;     x = b;
;   return b != 0 ? b : x;
; }
;
define double* @bitcasts_select_and_phi(i32* %b) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@bitcasts_select_and_phi
; CHECK-SAME: (i32* nofree readnone [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC0:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq double* [[BC0]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[BC1:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi double* [ [[BC1]], [[IF_THEN]] ], [ [[BC0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[BC2:%.*]] = bitcast double* [[PHI]] to i8*
; CHECK-NEXT:    [[BC3:%.*]] = bitcast i32* [[B]] to i8*
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ne double* [[BC0]], null
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP2]], i8* [[BC2]], i8* [[BC3]]
; CHECK-NEXT:    [[BC4:%.*]] = bitcast i8* [[SEL]] to double*
; CHECK-NEXT:    ret double* [[BC4]]
;
entry:
  %bc0 = bitcast i32* %b to double*
  %cmp = icmp eq double* %bc0, null
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %bc1 = bitcast i32* %b to double*
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %phi = phi double* [ %bc1, %if.then ], [ %bc0, %entry ]
  %bc2 = bitcast double* %phi to i8*
  %bc3 = bitcast i32* %b to i8*
  %cmp2 = icmp ne double* %bc0, null
  %sel = select i1 %cmp2, i8* %bc2, i8* %bc3
  %bc4 = bitcast i8* %sel to double*
  ret double* %bc4
}


; TEST return argument or argument or undef
;
; double* ret_arg_arg_undef(int* b) {
;   if (b == 0)
;     return (double*)b;
;   if (b == 0)
;     return (double*)b;
;   /* return undef */
; }
;
define double* @ret_arg_arg_undef(i32* %b) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_arg_arg_undef
; CHECK-SAME: (i32* nofree readnone [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC0:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq double* [[BC0]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG0:%.*]], label [[IF_END:%.*]]
; CHECK:       ret_arg0:
; CHECK-NEXT:    [[BC1:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    ret double* [[BC1]]
; CHECK:       if.end:
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG1:%.*]], label [[RET_UNDEF:%.*]]
; CHECK:       ret_arg1:
; CHECK-NEXT:    ret double* [[BC0]]
; CHECK:       ret_undef:
; CHECK-NEXT:    ret double* undef
;
entry:
  %bc0 = bitcast i32* %b to double*
  %cmp = icmp eq double* %bc0, null
  br i1 %cmp, label %ret_arg0, label %if.end

ret_arg0:
  %bc1 = bitcast i32* %b to double*
  ret double* %bc1

if.end:
  br i1 %cmp, label %ret_arg1, label %ret_undef

ret_arg1:
  ret double* %bc0

ret_undef:
  ret double *undef
}


; TEST return undef or argument or argument
;
; double* ret_undef_arg_arg(int* b) {
;   if (b == 0)
;     return (double*)b;
;   if (b == 0)
;     return (double*)b;
;   /* return undef */
; }
;
define double* @ret_undef_arg_arg(i32* %b) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_undef_arg_arg
; CHECK-SAME: (i32* nofree readnone [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC0:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq double* [[BC0]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_UNDEF:%.*]], label [[IF_END:%.*]]
; CHECK:       ret_undef:
; CHECK-NEXT:    ret double* undef
; CHECK:       if.end:
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG0:%.*]], label [[RET_ARG1:%.*]]
; CHECK:       ret_arg0:
; CHECK-NEXT:    ret double* [[BC0]]
; CHECK:       ret_arg1:
; CHECK-NEXT:    [[BC1:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    ret double* [[BC1]]
;
entry:
  %bc0 = bitcast i32* %b to double*
  %cmp = icmp eq double* %bc0, null
  br i1 %cmp, label %ret_undef, label %if.end

ret_undef:
  ret double *undef

if.end:
  br i1 %cmp, label %ret_arg0, label %ret_arg1

ret_arg0:
  ret double* %bc0

ret_arg1:
  %bc1 = bitcast i32* %b to double*
  ret double* %bc1
}


; TEST return undef or argument or undef
;
; double* ret_undef_arg_undef(int* b) {
;   if (b == 0)
;     /* return undef */
;   if (b == 0)
;     return (double*)b;
;   /* return undef */
; }
;
define double* @ret_undef_arg_undef(i32* %b) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_undef_arg_undef
; CHECK-SAME: (i32* nofree readnone [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BC0:%.*]] = bitcast i32* [[B]] to double*
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq double* [[BC0]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_UNDEF0:%.*]], label [[IF_END:%.*]]
; CHECK:       ret_undef0:
; CHECK-NEXT:    ret double* undef
; CHECK:       if.end:
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNDEF1:%.*]]
; CHECK:       ret_arg:
; CHECK-NEXT:    ret double* [[BC0]]
; CHECK:       ret_undef1:
; CHECK-NEXT:    ret double* undef
;
entry:
  %bc0 = bitcast i32* %b to double*
  %cmp = icmp eq double* %bc0, null
  br i1 %cmp, label %ret_undef0, label %if.end

ret_undef0:
  ret double *undef

if.end:
  br i1 %cmp, label %ret_arg, label %ret_undef1

ret_arg:
  ret double* %bc0

ret_undef1:
  ret double *undef
}

; TEST return argument or unknown call result
;
; int* ret_arg_or_unknown(int* b) {
;   if (b == 0)
;     return b;
;   return unknown();
; }
;
; Verify we do not assume b is returned
;
declare i32* @unknown(i32*)

define i32* @ret_arg_or_unknown(i32* %b) #0 {
; IS__TUNIT____: Function Attrs: noinline nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@ret_arg_or_unknown
; IS__TUNIT____-SAME: (i32* [[B:%.*]]) #[[ATTR5]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[B]], null
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; IS__TUNIT____:       ret_arg:
; IS__TUNIT____-NEXT:    ret i32* [[B]]
; IS__TUNIT____:       ret_unknown:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @unknown(i32* [[B]])
; IS__TUNIT____-NEXT:    ret i32* [[CALL]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@ret_arg_or_unknown
; IS__CGSCC____-SAME: (i32* [[B:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[B]], null
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; IS__CGSCC____:       ret_arg:
; IS__CGSCC____-NEXT:    ret i32* [[B]]
; IS__CGSCC____:       ret_unknown:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @unknown(i32* [[B]])
; IS__CGSCC____-NEXT:    ret i32* [[CALL]]
;
entry:
  %cmp = icmp eq i32* %b, null
  br i1 %cmp, label %ret_arg, label %ret_unknown

ret_arg:
  ret i32* %b

ret_unknown:
  %call = call i32* @unknown(i32* %b)
  ret i32* %call
}

define i32* @ret_arg_or_unknown_through_phi(i32* %b) #0 {
; IS__TUNIT____: Function Attrs: noinline nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@ret_arg_or_unknown_through_phi
; IS__TUNIT____-SAME: (i32* [[B:%.*]]) #[[ATTR5]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[B]], null
; IS__TUNIT____-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; IS__TUNIT____:       ret_arg:
; IS__TUNIT____-NEXT:    br label [[R:%.*]]
; IS__TUNIT____:       ret_unknown:
; IS__TUNIT____-NEXT:    [[CALL:%.*]] = call i32* @unknown(i32* [[B]])
; IS__TUNIT____-NEXT:    br label [[R]]
; IS__TUNIT____:       r:
; IS__TUNIT____-NEXT:    [[PHI:%.*]] = phi i32* [ [[B]], [[RET_ARG]] ], [ [[CALL]], [[RET_UNKNOWN]] ]
; IS__TUNIT____-NEXT:    ret i32* [[PHI]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@ret_arg_or_unknown_through_phi
; IS__CGSCC____-SAME: (i32* [[B:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[CMP:%.*]] = icmp eq i32* [[B]], null
; IS__CGSCC____-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; IS__CGSCC____:       ret_arg:
; IS__CGSCC____-NEXT:    br label [[R:%.*]]
; IS__CGSCC____:       ret_unknown:
; IS__CGSCC____-NEXT:    [[CALL:%.*]] = call i32* @unknown(i32* [[B]])
; IS__CGSCC____-NEXT:    br label [[R]]
; IS__CGSCC____:       r:
; IS__CGSCC____-NEXT:    [[PHI:%.*]] = phi i32* [ [[B]], [[RET_ARG]] ], [ [[CALL]], [[RET_UNKNOWN]] ]
; IS__CGSCC____-NEXT:    ret i32* [[PHI]]
;
entry:
  %cmp = icmp eq i32* %b, null
  br i1 %cmp, label %ret_arg, label %ret_unknown

ret_arg:
  br label %r

ret_unknown:
  %call = call i32* @unknown(i32* %b)
  br label %r

r:
  %phi = phi i32* [ %b, %ret_arg ], [ %call, %ret_unknown ]
  ret i32* %phi
}

; TEST inconsistent IR in dead code.
;
define i32 @deadblockcall1(i32 %A) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockcall1
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[A]]
; CHECK:       unreachableblock:
; CHECK-NEXT:    unreachable
;
entry:
  ret i32 %A
unreachableblock:
  %B = call i32 @deadblockcall1(i32 %B)
  ret i32 %B
}

declare i32 @deadblockcall_helper(i32 returned %A);

define i32 @deadblockcall2(i32 %A) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockcall2
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[A]]
; CHECK:       unreachableblock1:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock2:
; CHECK-NEXT:    unreachable
;
entry:
  ret i32 %A
unreachableblock1:
  %B = call i32 @deadblockcall_helper(i32 %B)
  ret i32 %B
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  ret i32 %C
}

define i32 @deadblockphi1(i32 %A) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockphi1
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[R:%.*]]
; CHECK:       unreachableblock1:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock2:
; CHECK-NEXT:    unreachable
; CHECK:       r:
; CHECK-NEXT:    ret i32 [[A]]
;
entry:
  br label %r
unreachableblock1:
  %B = call i32 @deadblockcall_helper(i32 %B)
  ret i32 %B
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  br label %r
r:
  %PHI = phi i32 [%A, %entry], [%C, %unreachableblock2]
  ret i32 %PHI
}

define i32 @deadblockphi2(i32 %A) #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockphi2
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[R:%.*]]
; CHECK:       unreachableblock1:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock2:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock3:
; CHECK-NEXT:    unreachable
; CHECK:       r:
; CHECK-NEXT:    ret i32 [[A]]
;
entry:
  br label %r
unreachableblock1:
  %B = call i32 @deadblockcall_helper(i32 %B)
  br label %unreachableblock3
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  br label %unreachableblock3
unreachableblock3:
  %PHI1 = phi i32 [%B, %unreachableblock1], [%C, %unreachableblock2]
  br label %r
r:
  %PHI2 = phi i32 [%A, %entry], [%PHI1, %unreachableblock3]
  ret i32 %PHI2
}

declare void @noreturn() noreturn;

define i32 @deadblockphi3(i32 %A, i1 %c) #0 {
; IS__TUNIT____: Function Attrs: noinline nounwind uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@deadblockphi3
; IS__TUNIT____-SAME: (i32 returned [[A:%.*]], i1 [[C:%.*]]) #[[ATTR5]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    br i1 [[C]], label [[R:%.*]], label [[UNREACHABLECALL:%.*]]
; IS__TUNIT____:       unreachablecall:
; IS__TUNIT____-NEXT:    call void @noreturn() #[[ATTR7:[0-9]+]]
; IS__TUNIT____-NEXT:    unreachable
; IS__TUNIT____:       unreachableblock2:
; IS__TUNIT____-NEXT:    unreachable
; IS__TUNIT____:       unreachableblock3:
; IS__TUNIT____-NEXT:    unreachable
; IS__TUNIT____:       r:
; IS__TUNIT____-NEXT:    ret i32 [[A]]
;
; IS__CGSCC____: Function Attrs: noinline nounwind uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@deadblockphi3
; IS__CGSCC____-SAME: (i32 returned [[A:%.*]], i1 [[C:%.*]]) #[[ATTR4]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    br i1 [[C]], label [[R:%.*]], label [[UNREACHABLECALL:%.*]]
; IS__CGSCC____:       unreachablecall:
; IS__CGSCC____-NEXT:    call void @noreturn() #[[ATTR5:[0-9]+]]
; IS__CGSCC____-NEXT:    unreachable
; IS__CGSCC____:       unreachableblock2:
; IS__CGSCC____-NEXT:    unreachable
; IS__CGSCC____:       unreachableblock3:
; IS__CGSCC____-NEXT:    unreachable
; IS__CGSCC____:       r:
; IS__CGSCC____-NEXT:    ret i32 [[A]]
;
entry:
  br i1 %c, label %r, label %unreachablecall
unreachablecall:
  call void @noreturn();
  %B = call i32 @deadblockcall_helper(i32 0)
  br label %unreachableblock3
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  br label %unreachableblock3
unreachableblock3:
  %PHI1 = phi i32 [%B, %unreachablecall], [%C, %unreachableblock2]
  br label %r
r:
  %PHI2 = phi i32 [%A, %entry], [%PHI1, %unreachableblock3]
  ret i32 %PHI2
}

define weak_odr i32 @non_exact_0() {
; CHECK-LABEL: define {{[^@]+}}@non_exact_0() {
; CHECK-NEXT:    ret i32 0
;
  ret i32 0
}
define weak_odr i32 @non_exact_1(i32 %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_1
; CHECK-SAME: (i32 [[A:%.*]]) {
; CHECK-NEXT:    ret i32 [[A]]
;
  ret i32 %a
}
define weak_odr i32 @non_exact_2(i32 returned %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_2
; CHECK-SAME: (i32 returned [[A:%.*]]) {
; CHECK-NEXT:    ret i32 [[A]]
;
  ret i32 %a
}
define weak_odr align 16 i32* @non_exact_3(i32* align 32 returned %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_3
; CHECK-SAME: (i32* returned align 32 [[A:%.*]]) {
; CHECK-NEXT:    ret i32* [[A]]
;
  ret i32* %a
}
define weak_odr align 16 i32* @non_exact_4(i32* align 32 %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_4
; CHECK-SAME: (i32* align 32 [[A:%.*]]) {
; CHECK-NEXT:    ret i32* [[A]]
;
  ret i32* %a
}
; We can use the alignment information of the weak function non_exact_3 argument
; because it was given to us and not derived.
; We can use the return information of the weak function non_exact_4.
; FIXME: %c2 and %c3 should be replaced but not %c0 or %c1!
define i32 @exact(i32* align 8 %a, i32* align 8 %b) {
; IS__TUNIT____: Function Attrs: norecurse
; IS__TUNIT____-LABEL: define {{[^@]+}}@exact
; IS__TUNIT____-SAME: (i32* align 8 [[A:%.*]], i32* align 8 [[B:%.*]]) #[[ATTR8:[0-9]+]] {
; IS__TUNIT____-NEXT:    [[C0:%.*]] = call i32 @non_exact_0()
; IS__TUNIT____-NEXT:    [[C1:%.*]] = call i32 @non_exact_1(i32 noundef 1)
; IS__TUNIT____-NEXT:    [[C2:%.*]] = call i32 @non_exact_2(i32 noundef 2)
; IS__TUNIT____-NEXT:    [[C3:%.*]] = call align 32 i32* @non_exact_3(i32* align 32 [[A]])
; IS__TUNIT____-NEXT:    [[C4:%.*]] = call align 16 i32* @non_exact_4(i32* align 32 [[B]])
; IS__TUNIT____-NEXT:    [[C3L:%.*]] = load i32, i32* [[A]], align 32
; IS__TUNIT____-NEXT:    [[C4L:%.*]] = load i32, i32* [[C4]], align 16
; IS__TUNIT____-NEXT:    [[ADD1:%.*]] = add i32 [[C0]], [[C1]]
; IS__TUNIT____-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], 2
; IS__TUNIT____-NEXT:    [[ADD3:%.*]] = add i32 [[ADD2]], [[C3L]]
; IS__TUNIT____-NEXT:    [[ADD4:%.*]] = add i32 [[ADD3]], [[C4L]]
; IS__TUNIT____-NEXT:    ret i32 [[ADD4]]
;
; IS__CGSCC____-LABEL: define {{[^@]+}}@exact
; IS__CGSCC____-SAME: (i32* align 8 [[A:%.*]], i32* align 8 [[B:%.*]]) {
; IS__CGSCC____-NEXT:    [[C0:%.*]] = call i32 @non_exact_0()
; IS__CGSCC____-NEXT:    [[C1:%.*]] = call i32 @non_exact_1(i32 noundef 1)
; IS__CGSCC____-NEXT:    [[C2:%.*]] = call i32 @non_exact_2(i32 noundef 2)
; IS__CGSCC____-NEXT:    [[C3:%.*]] = call align 32 i32* @non_exact_3(i32* align 32 [[A]])
; IS__CGSCC____-NEXT:    [[C4:%.*]] = call align 16 i32* @non_exact_4(i32* align 32 [[B]])
; IS__CGSCC____-NEXT:    [[C3L:%.*]] = load i32, i32* [[A]], align 32
; IS__CGSCC____-NEXT:    [[C4L:%.*]] = load i32, i32* [[C4]], align 16
; IS__CGSCC____-NEXT:    [[ADD1:%.*]] = add i32 [[C0]], [[C1]]
; IS__CGSCC____-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], 2
; IS__CGSCC____-NEXT:    [[ADD3:%.*]] = add i32 [[ADD2]], [[C3L]]
; IS__CGSCC____-NEXT:    [[ADD4:%.*]] = add i32 [[ADD3]], [[C4L]]
; IS__CGSCC____-NEXT:    ret i32 [[ADD4]]
;
  %c0 = call i32 @non_exact_0()
  %c1 = call i32 @non_exact_1(i32 1)
  %c2 = call i32 @non_exact_2(i32 2)
  %c3 = call i32* @non_exact_3(i32* %a)
  %c4 = call i32* @non_exact_4(i32* %b)
  %c3l = load i32, i32* %c3
  %c4l = load i32, i32* %c4
  %add1 = add i32 %c0, %c1
  %add2 = add i32 %add1, %c2
  %add3 = add i32 %add2, %c3l
  %add4 = add i32 %add3, %c4l
  ret i32 %add4
}

@G = external global i8
define i32* @ret_const() #0 {
; CHECK: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_const
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    ret i32* bitcast (i8* @G to i32*)
;
  %bc = bitcast i8* @G to i32*
  ret i32* %bc
}
define i32* @use_const() #0 {
; IS__TUNIT____: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@use_const
; IS__TUNIT____-SAME: () #[[ATTR0]] {
; IS__TUNIT____-NEXT:    ret i32* bitcast (i8* @G to i32*)
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@use_const
; IS__CGSCC____-SAME: () #[[ATTR3]] {
; IS__CGSCC____-NEXT:    [[C:%.*]] = call noundef nonnull dereferenceable(1) i32* @ret_const() #[[ATTR11:[0-9]+]]
; IS__CGSCC____-NEXT:    ret i32* [[C]]
;
  %c = call i32* @ret_const()
  ret i32* %c
}
define i32* @dont_use_const() #0 {
; IS__TUNIT____: Function Attrs: nofree noinline norecurse nosync nounwind readnone willreturn uwtable
; IS__TUNIT____-LABEL: define {{[^@]+}}@dont_use_const
; IS__TUNIT____-SAME: () #[[ATTR0]] {
; IS__TUNIT____-NEXT:    ret i32* bitcast (i8* @G to i32*)
;
; IS__CGSCC____: Function Attrs: nofree noinline nosync nounwind readnone willreturn uwtable
; IS__CGSCC____-LABEL: define {{[^@]+}}@dont_use_const
; IS__CGSCC____-SAME: () #[[ATTR3]] {
; IS__CGSCC____-NEXT:    [[C:%.*]] = musttail call noundef nonnull dereferenceable(1) i32* @ret_const() #[[ATTR11]]
; IS__CGSCC____-NEXT:    ret i32* [[C]]
;
  %c = musttail call i32* @ret_const()
  ret i32* %c
}

; UTC_ARGS: --disable
;
; Verify we do not derive constraints for @_Z3fooP1X as if it was returning `null`.
;
; CHEKC-NOT: noalias
; CHECK-NOT: align 536870912

%struct.Y = type { %struct.X }
%struct.X = type { i32 (...)** }

@_ZTI1X = external dso_local constant { i8*, i8* }, align 8
@_ZTI1Y = external dso_local constant { i8*, i8*, i8* }, align 8

define internal i8* @_ZN1Y3barEv(%struct.Y* %this) align 2 {
entry:
  %0 = bitcast %struct.Y* %this to i8*
  ret i8* %0
}

define dso_local i8* @_Z3fooP1X(%struct.X* %x) {
entry:
  %0 = icmp eq %struct.X* %x, null
  br i1 %0, label %dynamic_cast.null, label %dynamic_cast.notnull

dynamic_cast.notnull:                             ; preds = %entry
  %1 = bitcast %struct.X* %x to i8*
  %2 = call i8* @__dynamic_cast(i8* %1, i8* bitcast ({ i8*, i8* }* @_ZTI1X to i8*), i8* bitcast ({ i8*, i8*, i8* }* @_ZTI1Y to i8*), i64 0) #2
  %3 = bitcast i8* %2 to %struct.Y*
  br label %dynamic_cast.end

dynamic_cast.null:                                ; preds = %entry
  br label %dynamic_cast.end

dynamic_cast.end:                                 ; preds = %dynamic_cast.null, %dynamic_cast.notnull
  %QQ5 = phi %struct.Y* [ %3, %dynamic_cast.notnull ], [ null, %dynamic_cast.null ]
  %call = call i8* @_ZN1Y3barEv(%struct.Y* %QQ5)
  ret i8* %call
}

declare dso_local i8* @__dynamic_cast(i8*, i8*, i8*, i64)

; UTC_ARGS: --enable

attributes #0 = { noinline nounwind uwtable }
;.
; IS__TUNIT____: attributes #[[ATTR0]] = { nofree noinline norecurse nosync nounwind readnone willreturn uwtable }
; IS__TUNIT____: attributes #[[ATTR1]] = { nofree noinline nosync nounwind readnone uwtable }
; IS__TUNIT____: attributes #[[ATTR2]] = { nofree noinline norecurse nosync nounwind readnone uwtable }
; IS__TUNIT____: attributes #[[ATTR3]] = { argmemonly nofree noinline nosync nounwind readonly uwtable }
; IS__TUNIT____: attributes #[[ATTR4]] = { nofree noinline nosync nounwind readnone willreturn uwtable }
; IS__TUNIT____: attributes #[[ATTR5]] = { noinline nounwind uwtable }
; IS__TUNIT____: attributes #[[ATTR6]] = { noinline norecurse nounwind uwtable }
; IS__TUNIT____: attributes #[[ATTR7]] = { noreturn }
; IS__TUNIT____: attributes #[[ATTR8]] = { norecurse }
; IS__TUNIT____: attributes #[[ATTR9:[0-9]+]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__TUNIT____: attributes #[[ATTR10]] = { nofree nosync nounwind readnone }
; IS__TUNIT____: attributes #[[ATTR11]] = { nofree nosync nounwind readonly }
; IS__TUNIT____: attributes #[[ATTR12]] = { nounwind }
; IS__TUNIT____: attributes #[[ATTR13:[0-9]+]] = { nounwind readnone }
;.
; IS__CGSCC____: attributes #[[ATTR0]] = { nofree noinline norecurse nosync nounwind readnone willreturn uwtable }
; IS__CGSCC____: attributes #[[ATTR1]] = { nofree noinline nosync nounwind readnone uwtable }
; IS__CGSCC____: attributes #[[ATTR2]] = { argmemonly nofree noinline nosync nounwind readonly uwtable }
; IS__CGSCC____: attributes #[[ATTR3]] = { nofree noinline nosync nounwind readnone willreturn uwtable }
; IS__CGSCC____: attributes #[[ATTR4]] = { noinline nounwind uwtable }
; IS__CGSCC____: attributes #[[ATTR5]] = { noreturn }
; IS__CGSCC____: attributes #[[ATTR6:[0-9]+]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__CGSCC____: attributes #[[ATTR7]] = { nofree nosync nounwind readnone }
; IS__CGSCC____: attributes #[[ATTR8]] = { nounwind readnone }
; IS__CGSCC____: attributes #[[ATTR9]] = { nofree nosync nounwind readonly }
; IS__CGSCC____: attributes #[[ATTR10]] = { nounwind }
; IS__CGSCC____: attributes #[[ATTR11]] = { readnone willreturn }
;.
