; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -S -passes=deadargelim -opaque-pointers < %s | FileCheck %s

define void @callee(i32 %unused) {
; CHECK-LABEL: define {{[^@]+}}@callee
; CHECK-SAME: (i32 [[UNUSED:%.*]]) {
; CHECK-NEXT:    ret void
;
  ret void
}

define void @caller() {
; CHECK-LABEL: define {{[^@]+}}@caller() {
; CHECK-NEXT:    call void @callee(i32 undef)
; CHECK-NEXT:    call void @callee()
; CHECK-NEXT:    call void @callee(i32 42, i32 24)
; CHECK-NEXT:    ret void
;
  call void @callee(i32 42)
  call void @callee()
  call void @callee(i32 42, i32 24)
  ret void
}

define internal i16 @callee2(i16 %p1, i16 %p2) {
; CHECK-LABEL: define {{[^@]+}}@callee2
; CHECK-SAME: (i16 [[P1:%.*]], i16 [[P2:%.*]]) {
; CHECK-NEXT:    ret i16 [[P2]]
;
  ret i16 %p2
}

define i16 @caller2(i16 %a) {
; CHECK-LABEL: define {{[^@]+}}@caller2
; CHECK-SAME: (i16 [[A:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call i16 @callee2(i16 [[A]], i32 42)
; CHECK-NEXT:    ret i16 [[CALL]]
;
  %call = call i16 @callee2(i16 %a, i32 42)
  ret i16 %call
}
