; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; This test makes sure that these instructions are properly eliminated.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i32 @shl_C1_add_A_C2_i32(i16 %A) {
; CHECK-LABEL: @shl_C1_add_A_C2_i32(
; CHECK-NEXT:    [[B:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[D:%.*]] = shl i32 192, [[B]]
; CHECK-NEXT:    ret i32 [[D]]
;
  %B = zext i16 %A to i32
  %C = add i32 %B, 5
  %D = shl i32 6, %C
  ret i32 %D
}

define i32 @ashr_C1_add_A_C2_i32(i32 %A) {
; CHECK-LABEL: @ashr_C1_add_A_C2_i32(
; CHECK-NEXT:    ret i32 0
;
  %B = and i32 %A, 65535
  %C = add i32 %B, 5
  %D = ashr i32 6, %C
  ret i32 %D
}

define i32 @lshr_C1_add_A_C2_i32(i32 %A) {
; CHECK-LABEL: @lshr_C1_add_A_C2_i32(
; CHECK-NEXT:    [[B:%.*]] = and i32 [[A:%.*]], 65535
; CHECK-NEXT:    [[D:%.*]] = shl i32 192, [[B]]
; CHECK-NEXT:    ret i32 [[D]]
;
  %B = and i32 %A, 65535
  %C = add i32 %B, 5
  %D = shl i32 6, %C
  ret i32 %D
}

define <4 x i32> @shl_C1_add_A_C2_v4i32(<4 x i16> %A) {
; CHECK-LABEL: @shl_C1_add_A_C2_v4i32(
; CHECK-NEXT:    [[B:%.*]] = zext <4 x i16> [[A:%.*]] to <4 x i32>
; CHECK-NEXT:    [[D:%.*]] = shl <4 x i32> <i32 6, i32 4, i32 poison, i32 -458752>, [[B]]
; CHECK-NEXT:    ret <4 x i32> [[D]]
;
  %B = zext <4 x i16> %A to <4 x i32>
  %C = add <4 x i32> %B, <i32 0, i32 1, i32 50, i32 16>
  %D = shl <4 x i32> <i32 6, i32 2, i32 1, i32 -7>, %C
  ret <4 x i32> %D
}

define <4 x i32> @ashr_C1_add_A_C2_v4i32(<4 x i32> %A) {
; CHECK-LABEL: @ashr_C1_add_A_C2_v4i32(
; CHECK-NEXT:    [[B:%.*]] = and <4 x i32> [[A:%.*]], <i32 0, i32 15, i32 255, i32 65535>
; CHECK-NEXT:    [[D:%.*]] = ashr <4 x i32> <i32 6, i32 1, i32 poison, i32 -1>, [[B]]
; CHECK-NEXT:    ret <4 x i32> [[D]]
;
  %B = and <4 x i32> %A, <i32 0, i32 15, i32 255, i32 65535>
  %C = add <4 x i32> %B, <i32 0, i32 1, i32 50, i32 16>
  %D = ashr <4 x i32> <i32 6, i32 2, i32 1, i32 -7>, %C
  ret <4 x i32> %D
}

define <4 x i32> @lshr_C1_add_A_C2_v4i32(<4 x i32> %A) {
; CHECK-LABEL: @lshr_C1_add_A_C2_v4i32(
; CHECK-NEXT:    [[B:%.*]] = and <4 x i32> [[A:%.*]], <i32 0, i32 15, i32 255, i32 65535>
; CHECK-NEXT:    [[D:%.*]] = lshr <4 x i32> <i32 6, i32 1, i32 poison, i32 65535>, [[B]]
; CHECK-NEXT:    ret <4 x i32> [[D]]
;
  %B = and <4 x i32> %A, <i32 0, i32 15, i32 255, i32 65535>
  %C = add <4 x i32> %B, <i32 0, i32 1, i32 50, i32 16>
  %D = lshr <4 x i32> <i32 6, i32 2, i32 1, i32 -7>, %C
  ret <4 x i32> %D
}

define <4 x i32> @shl_C1_add_A_C2_v4i32_splat(i16 %I) {
; CHECK-LABEL: @shl_C1_add_A_C2_v4i32_splat(
; CHECK-NEXT:    [[A:%.*]] = zext i16 [[I:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = insertelement <4 x i32> undef, i32 [[A]], i64 0
; CHECK-NEXT:    [[C:%.*]] = shufflevector <4 x i32> [[B]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[E:%.*]] = shl <4 x i32> <i32 6, i32 4, i32 poison, i32 -458752>, [[C]]
; CHECK-NEXT:    ret <4 x i32> [[E]]
;
  %A = zext i16 %I to i32
  %B = insertelement <4 x i32> undef, i32 %A, i32 0
  %C = shufflevector <4 x i32> %B, <4 x i32> undef, <4 x i32> zeroinitializer
  %D = add <4 x i32> %C, <i32 0, i32 1, i32 50, i32 16>
  %E = shl <4 x i32> <i32 6, i32 2, i32 1, i32 -7>, %D
  ret <4 x i32> %E
}

define <4 x i32> @ashr_C1_add_A_C2_v4i32_splat(i16 %I) {
; CHECK-LABEL: @ashr_C1_add_A_C2_v4i32_splat(
; CHECK-NEXT:    [[A:%.*]] = zext i16 [[I:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = insertelement <4 x i32> undef, i32 [[A]], i64 0
; CHECK-NEXT:    [[C:%.*]] = shufflevector <4 x i32> [[B]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[E:%.*]] = ashr <4 x i32> <i32 6, i32 1, i32 poison, i32 -1>, [[C]]
; CHECK-NEXT:    ret <4 x i32> [[E]]
;
  %A = zext i16 %I to i32
  %B = insertelement <4 x i32> undef, i32 %A, i32 0
  %C = shufflevector <4 x i32> %B, <4 x i32> undef, <4 x i32> zeroinitializer
  %D = add <4 x i32> %C, <i32 0, i32 1, i32 50, i32 16>
  %E = ashr <4 x i32> <i32 6, i32 2, i32 1, i32 -7>, %D
  ret <4 x i32> %E
}

define <4 x i32> @lshr_C1_add_A_C2_v4i32_splat(i16 %I) {
; CHECK-LABEL: @lshr_C1_add_A_C2_v4i32_splat(
; CHECK-NEXT:    [[A:%.*]] = zext i16 [[I:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = insertelement <4 x i32> undef, i32 [[A]], i64 0
; CHECK-NEXT:    [[C:%.*]] = shufflevector <4 x i32> [[B]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[E:%.*]] = lshr <4 x i32> <i32 6, i32 1, i32 poison, i32 65535>, [[C]]
; CHECK-NEXT:    ret <4 x i32> [[E]]
;
  %A = zext i16 %I to i32
  %B = insertelement <4 x i32> undef, i32 %A, i32 0
  %C = shufflevector <4 x i32> %B, <4 x i32> undef, <4 x i32> zeroinitializer
  %D = add <4 x i32> %C, <i32 0, i32 1, i32 50, i32 16>
  %E = lshr <4 x i32> <i32 6, i32 2, i32 1, i32 -7>, %D
  ret <4 x i32> %E
}

define i32 @shl_add_nuw(i32 %x) {
; CHECK-LABEL: @shl_add_nuw(
; CHECK-NEXT:    [[R:%.*]] = shl i32 192, [[X:%.*]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = add nuw i32 %x, 5
  %r = shl i32 6, %a
  ret i32 %r
}

; vectors with arbitrary constants work too

define <2 x i12> @lshr_add_nuw(<2 x i12> %x) {
; CHECK-LABEL: @lshr_add_nuw(
; CHECK-NEXT:    [[R:%.*]] = lshr <2 x i12> <i12 0, i12 21>, [[X:%.*]]
; CHECK-NEXT:    ret <2 x i12> [[R]]
;
  %a = add nuw <2 x i12> %x, <i12 5, i12 1>
  %r = lshr <2 x i12> <i12 6, i12 42>, %a
  ret <2 x i12> %r
}

; extra use is ok and in this case the result can be simplified to a constant

define i32 @ashr_add_nuw(i32 %x, i32* %p) {
; CHECK-LABEL: @ashr_add_nuw(
; CHECK-NEXT:    [[A:%.*]] = add nuw i32 [[X:%.*]], 5
; CHECK-NEXT:    store i32 [[A]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 -1
;
  %a = add nuw i32 %x, 5
  store i32 %a, i32* %p
  %r = ashr i32 -6, %a
  ret i32 %r
}

; negative test - must have 'nuw'

define i32 @shl_add_nsw(i32 %x) {
; CHECK-LABEL: @shl_add_nsw(
; CHECK-NEXT:    [[A:%.*]] = add nsw i32 [[X:%.*]], 5
; CHECK-NEXT:    [[R:%.*]] = shl i32 6, [[A]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = add nsw i32 %x, 5
  %r = shl i32 6, %a
  ret i32 %r
}

; PR54890

define i32 @shl_nsw_add_negative(i32 %x) {
; CHECK-LABEL: @shl_nsw_add_negative(
; CHECK-NEXT:    [[A:%.*]] = add i32 [[X:%.*]], -1
; CHECK-NEXT:    [[R:%.*]] = shl nsw i32 2, [[A]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = add i32 %x, -1
  %r = shl nsw i32 2, %a
  ret i32 %r
}

define <2 x i8> @shl_nuw_add_negative_splat_uses(<2 x i8> %x, <2 x i8>* %p) {
; CHECK-LABEL: @shl_nuw_add_negative_splat_uses(
; CHECK-NEXT:    [[A:%.*]] = add <2 x i8> [[X:%.*]], <i8 -2, i8 -2>
; CHECK-NEXT:    store <2 x i8> [[A]], <2 x i8>* [[P:%.*]], align 2
; CHECK-NEXT:    [[R:%.*]] = shl nuw <2 x i8> <i8 12, i8 12>, [[A]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %a = add <2 x i8> %x, <i8 -2, i8 -2>
  store <2 x i8> %a, <2 x i8>* %p
  %r = shl nuw <2 x i8> <i8 12, i8 12>, %a
  ret <2 x i8> %r
}

define i32 @shl_nsw_add_negative_invalid_constant(i32 %x) {
; CHECK-LABEL: @shl_nsw_add_negative_invalid_constant(
; CHECK-NEXT:    [[A:%.*]] = add i32 [[X:%.*]], -2
; CHECK-NEXT:    [[R:%.*]] = shl nsw i32 2, [[A]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = add i32 %x, -2
  %r = shl nsw i32 2, %a
  ret i32 %r
}

define i32 @shl_nsw_add_positive_invalid_constant(i32 %x) {
; CHECK-LABEL: @shl_nsw_add_positive_invalid_constant(
; CHECK-NEXT:    [[A:%.*]] = add i32 [[X:%.*]], 2
; CHECK-NEXT:    [[R:%.*]] = shl nsw i32 4, [[A]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = add i32 %x, 2
  %r = shl nsw i32 4, %a
  ret i32 %r
}
