; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Verify that strnlen calls with constant string arguments and offsets
; and constant bounds are folded correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i64 @strnlen(i8*, i64)

@s5 = constant [6 x i8] c"12345\00"
@s5_3 = constant [9 x i8] c"12345\00xyz"


; Fold strnlen(s5, 0) to 0.

define i64 @fold_strnlen_s5_0() {
; CHECK-LABEL: @fold_strnlen_s5_0(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s5, i64 0, i64 0), i64 0)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [6 x i8], [6 x i8]* @s5, i32 0, i32 0
  %len = call i64 @strnlen(i8* %ptr, i64 0)
  ret i64 %len
}


; Fold strnlen(s5, 4) to 4.

define i64 @fold_strnlen_s5_4() {
; CHECK-LABEL: @fold_strnlen_s5_4(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s5, i64 0, i64 0), i64 4)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [6 x i8], [6 x i8]* @s5, i32 0, i32 0
  %len = call i64 @strnlen(i8* %ptr, i64 4)
  ret i64 %len
}


; Fold strnlen(s5, 5) to 5.

define i64 @fold_strnlen_s5_5() {
; CHECK-LABEL: @fold_strnlen_s5_5(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s5, i64 0, i64 0), i64 5)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [6 x i8], [6 x i8]* @s5, i32 0, i32 0
  %len = call i64 @strnlen(i8* %ptr, i64 5)
  ret i64 %len
}


; Fold strnlen(s5, (size_t)-1) to 5.

define i64 @fold_strnlen_s5_m1() {
; CHECK-LABEL: @fold_strnlen_s5_m1(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s5, i64 0, i64 0), i64 -1)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [6 x i8], [6 x i8]* @s5, i32 0, i32 0
  %len = call i64 @strnlen(i8* %ptr, i64 -1)
  ret i64 %len
}


; Fold strnlen(s5_3 + 4, 5) to 1.

define i64 @fold_strnlen_s5_3_p4_5() {
; CHECK-LABEL: @fold_strnlen_s5_3_p4_5(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([9 x i8], [9 x i8]* @s5_3, i64 0, i64 4), i64 5)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [9 x i8], [9 x i8]* @s5_3, i32 0, i32 4
  %len = call i64 @strnlen(i8* %ptr, i64 5)
  ret i64 %len
}


; Fold strnlen(s5_3 + 5, 5) to 1.

define i64 @fold_strnlen_s5_3_p5_5() {
; CHECK-LABEL: @fold_strnlen_s5_3_p5_5(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([9 x i8], [9 x i8]* @s5_3, i64 0, i64 5), i64 5)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [9 x i8], [9 x i8]* @s5_3, i32 0, i32 5
  %len = call i64 @strnlen(i8* %ptr, i64 5)
  ret i64 %len
}


; Fold strnlen(s5_3 + 6, 5) to 3.

define i64 @fold_strnlen_s5_3_p6_5() {
; CHECK-LABEL: @fold_strnlen_s5_3_p6_5(
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strnlen(i8* getelementptr inbounds ([9 x i8], [9 x i8]* @s5_3, i64 0, i64 6), i64 5)
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [9 x i8], [9 x i8]* @s5_3, i32 0, i32 6
  %len = call i64 @strnlen(i8* %ptr, i64 5)
  ret i64 %len
}
