; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

declare half @llvm.amdgcn.fract.f16(half)
declare float @llvm.amdgcn.fract.f32(float)
declare double @llvm.amdgcn.fract.f64(double)

define void @test_f16(half* %p) {
; CHECK-LABEL: @test_f16(
; CHECK-NEXT:    store volatile half 0xH0000, half* [[P:%.*]]
; CHECK-NEXT:    store volatile half 0xH0000, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH0000, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH0000, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH3400, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH3B00, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH0400, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH3BFF, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH7E00, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH7E00, half* [[P]]
; CHECK-NEXT:    store volatile half 0xH7E00, half* [[P]]
; CHECK-NEXT:    ret void
;
  %p0 = call half @llvm.amdgcn.fract.f16(half +0.0)
  store volatile half %p0, half* %p
  %n0 = call half @llvm.amdgcn.fract.f16(half -0.0)
  store volatile half %n0, half* %p
  %p1 = call half @llvm.amdgcn.fract.f16(half +1.0)
  store volatile half %p1, half* %p
  %n1 = call half @llvm.amdgcn.fract.f16(half -1.0)
  store volatile half %n1, half* %p
  %p225 = call half @llvm.amdgcn.fract.f16(half +2.25)
  store volatile half %p225, half* %p
  %n6125 = call half @llvm.amdgcn.fract.f16(half -6.125)
  store volatile half %n6125, half* %p
  %ptiny = call half @llvm.amdgcn.fract.f16(half 0xH0400) ; +min normal
  store volatile half %ptiny, half* %p
  %ntiny = call half @llvm.amdgcn.fract.f16(half 0xH8400) ; -min normal
  store volatile half %ntiny, half* %p
  %pinf = call half @llvm.amdgcn.fract.f16(half 0xH7C00) ; +inf
  store volatile half %pinf, half* %p
  %ninf = call half @llvm.amdgcn.fract.f16(half 0xHFC00) ; -inf
  store volatile half %ninf, half* %p
  %nan = call half @llvm.amdgcn.fract.f16(half 0xH7E00) ; nan
  store volatile half %nan, half* %p
  ret void
}

define void @test_f32(float* %p) {
; CHECK-LABEL: @test_f32(
; CHECK-NEXT:    store volatile float 0.000000e+00, float* [[P:%.*]]
; CHECK-NEXT:    store volatile float 0.000000e+00, float* [[P]]
; CHECK-NEXT:    store volatile float 0.000000e+00, float* [[P]]
; CHECK-NEXT:    store volatile float 0.000000e+00, float* [[P]]
; CHECK-NEXT:    store volatile float 2.500000e-01, float* [[P]]
; CHECK-NEXT:    store volatile float 8.750000e-01, float* [[P]]
; CHECK-NEXT:    store volatile float 0x3810000000000000, float* [[P]]
; CHECK-NEXT:    store volatile float 0x3FEFFFFFE0000000, float* [[P]]
; CHECK-NEXT:    store volatile float 0x7FF8000000000000, float* [[P]]
; CHECK-NEXT:    store volatile float 0x7FF8000000000000, float* [[P]]
; CHECK-NEXT:    store volatile float 0x7FF8000000000000, float* [[P]]
; CHECK-NEXT:    ret void
;
  %p0 = call float @llvm.amdgcn.fract.f32(float +0.0)
  store volatile float %p0, float* %p
  %n0 = call float @llvm.amdgcn.fract.f32(float -0.0)
  store volatile float %n0, float* %p
  %p1 = call float @llvm.amdgcn.fract.f32(float +1.0)
  store volatile float %p1, float* %p
  %n1 = call float @llvm.amdgcn.fract.f32(float -1.0)
  store volatile float %n1, float* %p
  %p225 = call float @llvm.amdgcn.fract.f32(float +2.25)
  store volatile float %p225, float* %p
  %n6125 = call float @llvm.amdgcn.fract.f32(float -6.125)
  store volatile float %n6125, float* %p
  %ptiny = call float @llvm.amdgcn.fract.f32(float 0x3810000000000000) ; +min normal
  store volatile float %ptiny, float* %p
  %ntiny = call float @llvm.amdgcn.fract.f32(float 0xB810000000000000) ; -min normal
  store volatile float %ntiny, float* %p
  %pinf = call float @llvm.amdgcn.fract.f32(float 0x7FF0000000000000) ; +inf
  store volatile float %pinf, float* %p
  %ninf = call float @llvm.amdgcn.fract.f32(float 0xFFF0000000000000) ; -inf
  store volatile float %ninf, float* %p
  %nan = call float @llvm.amdgcn.fract.f32(float 0x7FF8000000000000) ; nan
  store volatile float %nan, float* %p
  ret void
}

define void @test_f64(double* %p) {
; CHECK-LABEL: @test_f64(
; CHECK-NEXT:    store volatile double 0.000000e+00, double* [[P:%.*]]
; CHECK-NEXT:    store volatile double 0.000000e+00, double* [[P]]
; CHECK-NEXT:    store volatile double 0.000000e+00, double* [[P]]
; CHECK-NEXT:    store volatile double 0.000000e+00, double* [[P]]
; CHECK-NEXT:    store volatile double 2.500000e-01, double* [[P]]
; CHECK-NEXT:    store volatile double 8.750000e-01, double* [[P]]
; CHECK-NEXT:    store volatile double 2.000000e-308, double* [[P]]
; CHECK-NEXT:    store volatile double 0x3FEFFFFFFFFFFFFF, double* [[P]]
; CHECK-NEXT:    store volatile double 0x7FF8000000000000, double* [[P]]
; CHECK-NEXT:    store volatile double 0x7FF8000000000000, double* [[P]]
; CHECK-NEXT:    store volatile double 0x7FF8000000000000, double* [[P]]
; CHECK-NEXT:    ret void
;
  %p0 = call double @llvm.amdgcn.fract.f64(double +0.0)
  store volatile double %p0, double* %p
  %n0 = call double @llvm.amdgcn.fract.f64(double -0.0)
  store volatile double %n0, double* %p
  %p1 = call double @llvm.amdgcn.fract.f64(double +1.0)
  store volatile double %p1, double* %p
  %n1 = call double @llvm.amdgcn.fract.f64(double -1.0)
  store volatile double %n1, double* %p
  %p225 = call double @llvm.amdgcn.fract.f64(double +2.25)
  store volatile double %p225, double* %p
  %n6125 = call double @llvm.amdgcn.fract.f64(double -6.125)
  store volatile double %n6125, double* %p
  %ptiny = call double @llvm.amdgcn.fract.f64(double +2.0e-308) ; +min normal
  store volatile double %ptiny, double* %p
  %ntiny = call double @llvm.amdgcn.fract.f64(double -2.0e-308) ; -min normal
  store volatile double %ntiny, double* %p
  %pinf = call double @llvm.amdgcn.fract.f64(double 0x7FF0000000000000) ; +inf
  store volatile double %pinf, double* %p
  %ninf = call double @llvm.amdgcn.fract.f64(double 0xFFF0000000000000) ; -inf
  store volatile double %ninf, double* %p
  %nan = call double @llvm.amdgcn.fract.f64(double 0x7FF8000000000000) ; nan
  store volatile double %nan, double* %p
  ret void
}
