; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S -o - | FileCheck %s

; Testcase that verify that we don't get a faulty bitcast that cast between
; different sizes.

%rec8 = type { i16 }
@a = global [1 x %rec8] zeroinitializer

define <2 x i16*> @test_gep() {
; CHECK-LABEL: @test_gep(
; CHECK-NEXT:    ret <2 x i16*> <i16* getelementptr inbounds ([1 x %rec8], [1 x %rec8]* @a, i32 0, i32 0, i32 0), i16* getelementptr inbounds ([1 x %rec8], [1 x %rec8]* @a, i32 0, i32 0, i32 0)>
;
  %A = getelementptr [1 x %rec8], [1 x %rec8]* @a, <2 x i16> zeroinitializer, <2 x i64> zeroinitializer
  %B = bitcast <2 x %rec8*> %A to <2 x i16*>
  ret <2 x i16*> %B
}

; Testcase that verify the cast-of-cast when the outer/second cast is to a
; vector type.

define <4 x i16> @test_mmx_const() {
; CHECK-LABEL: @test_mmx_const(
; CHECK-NEXT:    ret <4 x i16> zeroinitializer
;
  %A = bitcast <2 x i32> zeroinitializer to x86_mmx
  %B = bitcast x86_mmx %A to <4 x i16>
  ret <4 x i16> %B
}
