; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define float @fdiv_constant_fold() {
; CHECK-LABEL: @fdiv_constant_fold(
; CHECK-NEXT:    ret float 1.500000e+00
;
  %f = fdiv float 3.0, 2.0
  ret float %f
}

define float @frem_constant_fold() {
; CHECK-LABEL: @frem_constant_fold(
; CHECK-NEXT:    ret float 1.000000e+00
;
  %f = frem float 3.0, 2.0
  ret float %f
}

define double @fmul_fdiv_common_operand(double %x, double %y) {
; CHECK-LABEL: @fmul_fdiv_common_operand(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %m = fmul double %x, %y
  %d = fdiv reassoc nnan double %m, %y
  ret double %d
}

; Negative test - the fdiv must be reassociative and not allow NaNs.

define double @fmul_fdiv_common_operand_too_strict(double %x, double %y) {
; CHECK-LABEL: @fmul_fdiv_common_operand_too_strict(
; CHECK-NEXT:    [[M:%.*]] = fmul fast double [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = fdiv reassoc double [[M]], [[Y]]
; CHECK-NEXT:    ret double [[D]]
;
  %m = fmul fast double %x, %y
  %d = fdiv reassoc double %m, %y
  ret double %d
}

; Commute the fmul operands. Use a vector type to verify that works too.

define <2 x float> @fmul_fdiv_common_operand_commute_vec(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: @fmul_fdiv_common_operand_commute_vec(
; CHECK-NEXT:    ret <2 x float> [[X:%.*]]
;
  %m = fmul <2 x float> %y, %x
  %d = fdiv fast <2 x float> %m, %y
  ret <2 x float> %d
}

