; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

; The first comparison (a != b) should not be dropped
define i1 @test1(i8* %a, i8* %b) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[COND1:%.*]] = icmp ne i8* [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[A2:%.*]] = getelementptr inbounds i8, i8* [[A]], i64 -1
; CHECK-NEXT:    [[COND2:%.*]] = icmp ugt i8* [[A2]], [[B]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[COND1]], i1 [[COND2]], i1 false
; CHECK-NEXT:    ret i1 [[RES]]
;
  %cond1 = icmp ne i8* %a, %b
  %a2 = getelementptr inbounds i8, i8* %a, i64 -1
  %cond2 = icmp ugt i8* %a2, %b
  %res = select i1 %cond1, i1 %cond2, i1 false
  ret i1 %res
}

; The first comparison (a != b) should not be dropped
define i1 @test2(i32 %a, i32 %b) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[COND1:%.*]] = icmp ne i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[A2:%.*]] = add nuw i32 [[A]], 1
; CHECK-NEXT:    [[COND2:%.*]] = icmp ult i32 [[A2]], [[B]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[COND1]], i1 [[COND2]], i1 false
; CHECK-NEXT:    ret i1 [[RES]]
;
  %cond1 = icmp ne i32 %a, %b
  %a2 = add nuw i32 %a, 1
  %cond2 = icmp ult i32 %a2, %b
  %res = select i1 %cond1, i1 %cond2, i1 false
  ret i1 %res
}
