; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -basic-aa -loop-interchange -pass-remarks-missed='loop-interchange' -verify-loop-lcssa -S | FileCheck %s
; RUN: opt < %s -basic-aa -loop-interchange -da-disable-delinearization-checks -pass-remarks-missed='loop-interchange' -verify-loop-lcssa -S | FileCheck -check-prefix=CHECK-DELIN %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

; void foo(int n, int m) {
;   int temp[16][16];
;   int res[16][16];
;   for(int i = 0; i < n; i++) {
;     for(int j = 0; j < m; j++)
;       res[j][i] = temp[j][i];
;   }
; }

;; This loop can be interchanged with -da-disable-delinearization-checks, otherwise it cannot
;; be interchanged due to dependence.
define void @lcssa_08(i32 %n, i32 %m) {;
; CHECK-DELIN-LABEL: @lcssa_08(
; CHECK-DELIN-NEXT:  entry:
; CHECK-DELIN-NEXT:    [[TEMP:%.*]] = alloca [16 x [16 x i32]], align 4
; CHECK-DELIN-NEXT:    [[RES:%.*]] = alloca [16 x [16 x i32]], align 4
; CHECK-DELIN-NEXT:    [[CMP24:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-DELIN-NEXT:    br i1 [[CMP24]], label [[INNER_PREHEADER:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; CHECK-DELIN:       outer.preheader:
; CHECK-DELIN-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK-DELIN:       outer.header:
; CHECK-DELIN-NEXT:    [[INDVARS_IV27:%.*]] = phi i64 [ 0, [[OUTER_PREHEADER:%.*]] ], [ [[INDVARS_IV_NEXT28:%.*]], [[OUTER_LATCH:%.*]] ]
; CHECK-DELIN-NEXT:    [[CMP222:%.*]] = icmp sgt i32 [[M:%.*]], 0
; CHECK-DELIN-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[M]] to i64
; CHECK-DELIN-NEXT:    br i1 [[CMP222]], label [[INNER_FOR_BODY_SPLIT1:%.*]], label [[INNER_FOR_BODY_SPLIT:%.*]]
; CHECK-DELIN:       inner.preheader:
; CHECK-DELIN-NEXT:    [[WIDE_TRIP_COUNT29:%.*]] = zext i32 [[N]] to i64
; CHECK-DELIN-NEXT:    br label [[INNER_FOR_BODY:%.*]]
; CHECK-DELIN:       inner.for.body:
; CHECK-DELIN-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[INNER_PREHEADER]] ], [ [[TMP1:%.*]], [[INNER_FOR_BODY_SPLIT]] ]
; CHECK-DELIN-NEXT:    br label [[OUTER_PREHEADER]]
; CHECK-DELIN:       inner.for.body.split1:
; CHECK-DELIN-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds [16 x [16 x i32]], [16 x [16 x i32]]* [[TEMP]], i64 0, i64 [[INDVARS_IV]], i64 [[INDVARS_IV27]]
; CHECK-DELIN-NEXT:    [[TMP0:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4
; CHECK-DELIN-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [16 x [16 x i32]], [16 x [16 x i32]]* [[RES]], i64 0, i64 [[INDVARS_IV]], i64 [[INDVARS_IV27]]
; CHECK-DELIN-NEXT:    store i32 [[TMP0]], i32* [[ARRAYIDX8]], align 4
; CHECK-DELIN-NEXT:    [[INDVARS_IV_NEXT:%.*]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-DELIN-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT]], [[WIDE_TRIP_COUNT]]
; CHECK-DELIN-NEXT:    br label [[INNER_CRIT_EDGE:%.*]]
; CHECK-DELIN:       inner.for.body.split:
; CHECK-DELIN-NEXT:    [[WIDE_TRIP_COUNT_LCSSA:%.*]] = phi i64 [ [[WIDE_TRIP_COUNT]], [[OUTER_LATCH]] ], [ [[WIDE_TRIP_COUNT]], [[OUTER_HEADER]] ]
; CHECK-DELIN-NEXT:    [[TMP1]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-DELIN-NEXT:    [[TMP2:%.*]] = icmp ne i64 [[TMP1]], [[WIDE_TRIP_COUNT_LCSSA]]
; CHECK-DELIN-NEXT:    br i1 [[TMP2]], label [[INNER_FOR_BODY]], label [[OUTER_CRIT_EDGE:%.*]]
; CHECK-DELIN:       inner.crit_edge:
; CHECK-DELIN-NEXT:    br label [[OUTER_LATCH]]
; CHECK-DELIN:       outer.latch:
; CHECK-DELIN-NEXT:    [[INDVARS_IV_NEXT28]] = add nuw nsw i64 [[INDVARS_IV27]], 1
; CHECK-DELIN-NEXT:    [[EXITCOND30:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT28]], [[WIDE_TRIP_COUNT29]]
; CHECK-DELIN-NEXT:    br i1 [[EXITCOND30]], label [[OUTER_HEADER]], label [[INNER_FOR_BODY_SPLIT]]
; CHECK-DELIN:       outer.crit_edge:
; CHECK-DELIN-NEXT:    br label [[FOR_COND_CLEANUP]]
; CHECK-DELIN:       for.cond.cleanup:
; CHECK-DELIN-NEXT:    ret void
;
entry:
  %temp = alloca [16 x [16 x i32]], align 4
  %res = alloca [16 x [16 x i32]], align 4
  %cmp24 = icmp sgt i32 %n, 0
  br i1 %cmp24, label %outer.preheader, label %for.cond.cleanup

outer.preheader:                        ; preds = %entry
  %wide.trip.count29 = zext i32 %n to i64
  br label %outer.header

outer.header:                              ; preds = %outer.preheader, %outer.latch
  %indvars.iv27 = phi i64 [ 0, %outer.preheader ], [ %indvars.iv.next28, %outer.latch ]
  %cmp222 = icmp sgt i32 %m, 0
  br i1 %cmp222, label %inner.preheader, label %outer.latch

inner.preheader:                                  ; preds = %outer.header
  ; When inner.preheader becomes the outer preheader, do not move
  ; %wide.trip.count into the inner loop header lest LCSSA break
  ; (if %wide.trip.count gets moved, its use is now outside the inner loop).
  %wide.trip.count = zext i32 %m to i64
  br label %inner.for.body

inner.for.body:                                        ; preds = %inner.preheader, %inner.for.body
  %indvars.iv = phi i64 [ 0, %inner.preheader ], [ %indvars.iv.next, %inner.for.body ]
  %arrayidx6 = getelementptr inbounds [16 x [16 x i32]], [16 x [16 x i32]]* %temp, i64 0, i64 %indvars.iv, i64 %indvars.iv27
  %0 = load i32, i32* %arrayidx6, align 4
  %arrayidx8 = getelementptr inbounds [16 x [16 x i32]], [16 x [16 x i32]]* %res, i64 0, i64 %indvars.iv, i64 %indvars.iv27
  store i32 %0, i32* %arrayidx8, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp ne i64 %indvars.iv.next, %wide.trip.count
  br i1 %exitcond, label %inner.for.body, label %inner.crit_edge

inner.crit_edge:            ; preds = %inner.for.body
  br label %outer.latch

outer.latch:                                ; preds = %inner.crit_edge, %outer.header
  %indvars.iv.next28 = add nuw nsw i64 %indvars.iv27, 1
  %exitcond30 = icmp ne i64 %indvars.iv.next28, %wide.trip.count29
  br i1 %exitcond30, label %outer.header, label %outer.crit_edge

outer.crit_edge:              ; preds = %outer.latch
  br label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %outer.crit_edge, %entry
  ret void
}

@global = external local_unnamed_addr global [4 x [4 x [2 x i16]]] align 16

; %N.ext is defined in the outer loop header and used in the inner loop. After
; interchanging, it will be defined in the new inner loop and used in the new;
; outer latch, so we need to create a new LCSSA phi node for it.

define void @test2(i32 %N) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[INNER_PREHEADER:%.*]]
; CHECK:       outer.header.preheader:
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    [[OUTER_IV:%.*]] = phi i64 [ [[OUTER_IV_NEXT:%.*]], [[OUTER_LATCH:%.*]] ], [ 0, [[OUTER_HEADER_PREHEADER:%.*]] ]
; CHECK-NEXT:    [[N_EXT:%.*]] = sext i32 [[N:%.*]] to i64
; CHECK-NEXT:    br label [[INNER_SPLIT1:%.*]]
; CHECK:       inner.preheader:
; CHECK-NEXT:    br label [[INNER:%.*]]
; CHECK:       inner:
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i64 [ [[TMP0:%.*]], [[INNER_SPLIT:%.*]] ], [ 0, [[INNER_PREHEADER]] ]
; CHECK-NEXT:    br label [[OUTER_HEADER_PREHEADER]]
; CHECK:       inner.split1:
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x [4 x [2 x i16]]], [4 x [4 x [2 x i16]]]* @global, i64 0, i64 [[INNER_IV]], i64 [[OUTER_IV]], i64 0
; CHECK-NEXT:    [[INNER_IV_NEXT:%.*]] = add nsw i64 [[INNER_IV]], 1
; CHECK-NEXT:    [[C_1:%.*]] = icmp ne i64 [[INNER_IV_NEXT]], [[N_EXT]]
; CHECK-NEXT:    br label [[OUTER_LATCH]]
; CHECK:       inner.split:
; CHECK-NEXT:    [[N_EXT_LCSSA:%.*]] = phi i64 [ [[N_EXT]], [[OUTER_LATCH]] ]
; CHECK-NEXT:    [[TMP0]] = add nsw i64 [[INNER_IV]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i64 [[TMP0]], [[N_EXT_LCSSA]]
; CHECK-NEXT:    br i1 [[TMP1]], label [[INNER]], label [[EXIT:%.*]]
; CHECK:       outer.latch:
; CHECK-NEXT:    [[OUTER_IV_NEXT]] = add nsw i64 [[OUTER_IV]], 1
; CHECK-NEXT:    [[C_2:%.*]] = icmp ne i64 [[OUTER_IV]], [[N_EXT]]
; CHECK-NEXT:    br i1 [[C_2]], label [[OUTER_HEADER]], label [[INNER_SPLIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
bb:
  br label %outer.header

outer.header:                                              ; preds = %bb11, %bb2
  %outer.iv = phi i64 [ 0, %bb ], [ %outer.iv.next, %outer.latch ]
  %N.ext = sext i32 %N to i64
  br label %inner

inner:                                              ; preds = %bb6, %bb4
  %inner.iv = phi i64 [ 0, %outer.header ], [ %inner.iv.next, %inner ]
  %tmp8 = getelementptr inbounds [4 x [4 x [2 x i16]]], [4 x [4 x [2 x i16]]]* @global, i64 0, i64 %inner.iv, i64 %outer.iv, i64 0
  %inner.iv.next = add nsw i64 %inner.iv, 1
  %c.1 = icmp ne i64 %inner.iv.next, %N.ext
  br i1 %c.1, label %inner, label %outer.latch

outer.latch:                                             ; preds = %bb6
  %outer.iv.next = add nsw i64 %outer.iv, 1
  %c.2 = icmp ne i64 %outer.iv, %N.ext
  br i1 %c.2 , label %outer.header, label %exit

exit:                                             ; preds = %bb11
  ret void
}
