; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -rewrite-statepoints-for-gc -S | FileCheck %s
; RUN: opt < %s -passes=rewrite-statepoints-for-gc -S | FileCheck %s

;; This test is to verify that gc_result from a call statepoint
;; can have preceding phis in its parent basic block. Unlike
;; invoke statepoint, call statepoint does not terminate the
;; block, and thus its gc_result is in the same block with the
;; call statepoint.

declare i32 @foo()

define i32 @test1(i1 %cond, i32 %a) gc "statepoint-example" {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BRANCH1:%.*]], label [[BRANCH2:%.*]]
; CHECK:       branch1:
; CHECK-NEXT:    [[B:%.*]] = add i32 [[A:%.*]], 1
; CHECK-NEXT:    br label [[MERGE:%.*]]
; CHECK:       branch2:
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ [[A]], [[BRANCH2]] ], [ [[B]], [[BRANCH1]] ]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, i32 ()*, i32, i32, ...) @llvm.experimental.gc.statepoint.p0f_i32f(i64 2882400000, i32 0, i32 ()* elementtype(i32 ()) @foo, i32 0, i32 0, i32 0, i32 0)
; CHECK-NEXT:    [[RET1:%.*]] = call i32 @llvm.experimental.gc.result.i32(token [[STATEPOINT_TOKEN]])
; CHECK-NEXT:    ret i32 [[RET1]]
;
entry:
  br i1 %cond, label %branch1, label %branch2

branch1:
  %b = add i32 %a, 1
  br label %merge

branch2:
  br label %merge

merge:
  %phi = phi i32 [ %a, %branch2 ], [ %b, %branch1 ]
  %ret = call i32 @foo()
  ret i32 %ret
}

; This function is inlined when inserting a poll.
declare void @do_safepoint()
define void @gc.safepoint_poll() {
; CHECK-LABEL: @gc.safepoint_poll(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @do_safepoint()
; CHECK-NEXT:    ret void
;
entry:
  call void @do_safepoint()
  ret void
}
