//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2022 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

import LanguageServerProtocol
import SourceKitLSP

public extension SourceKitServer {
  func workspaceForDocumentOnQueue(uri: DocumentURI) -> Workspace? {
    self.queue.sync {
      return self.workspaceForDocument(uri: uri)
    }
  }
}
