/*
 This source file is part of the Swift.org open source project

 Copyright (c) 2021 Apple Inc. and the Swift project authors
 Licensed under Apache License v2.0 with Runtime Library Exception

 See https://swift.org/LICENSE.txt for license information
 See https://swift.org/CONTRIBUTORS.txt for Swift project authors
*/

import Foundation

extension CharacterSet {
    /// Returns the character set for characters **not** allowed in a path URL component.
    static let urlPathNotAllowed = CharacterSet.urlPathAllowed.inverted
    
    /// Returns the union of the `whitespaces` and `punctuationCharacters` character sets.
    static let whitespacesAndPunctuation = CharacterSet.whitespaces.union(.punctuationCharacters)
}
