CHANGELOG for 3.3.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 3.3 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v3.3.0...v3.3.1

* 3.3.15 (2018-01-05)

 * bug #25532 [HttpKernel] Disable CSP header on exception pages (ostrolucky)
 * bug #25491 [Routing] Use the default host even if context is empty (sroze)
 * bug #25672 [WebServerBundle] use interface_exists instead of class_exists (kbond)
 * bug #25662 Dumper shouldn't use html format for phpdbg / cli-server (jhoff)
 * bug #25529 [Validator] Fix access to root object when using composite constraint (ostrolucky)
 * bug #25430 Fixes for Oracle in PdoSessionHandler (elislenio)
 * bug #25599 Add application/ld+json format associated to json (vincentchalamon)
 * bug #25623 [HttpFoundation] Fix false-positive ConflictingHeadersException (nicolas-grekas)
 * bug #25624 [WebServerBundle] Fix escaping of php binary with arguments (nicolas-grekas)
 * bug #25567 [Process] Fix setting empty env vars (nicolas-grekas)
 * bug #25407 [Console] Commands with an alias should not be recognized as ambiguous (Simperfit)
 * bug #25523 [WebServerBundle] fix a bug where require would not require the good file because of env (Simperfit)
 * bug #25559 [Process] Dont use getenv(), it returns arrays and can introduce subtle breaks accros PHP versions (nicolas-grekas)
 * bug #25552 [WebProfilerBundle] Let fetch() cast URL to string (ro0NL)
 * bug #25521 [Console] fix a bug when you are passing a default value and passing -n would output the index (Simperfit)
 * bug #25489 [FrameworkBundle] remove esi/ssi renderers if inactive (dmaicher)
 * bug #25427 Preserve percent-encoding in URLs when performing redirects in the UrlMatcher (mpdude)
 * bug #25480 [FrameworkBundle] add missing validation options to XSD file (xabbuh)
 * bug #25487 [Console] Fix a bug when passing a letter that could be an alias (Simperfit)
 * bug #25425 When available use AnnotationRegistry::registerUniqueLoader (jrjohnson)
 * bug #24594 [Translation] Fix InvalidArgumentException when using untranslated plural forms from .po files (BjornTwachtmann)
 * bug #25233 [TwigBridge][Form] Fix hidden currency element with Bootstrap 3 theme (julienfalque)
 * bug #25413 [HttpKernel] detect deprecations thrown by container initialization during tests (nicolas-grekas)
 * bug #25408 [Debug] Fix catching fatal errors in case of nested error handlers (nicolas-grekas)
 * bug #25330 [HttpFoundation] Support 0 bit netmask in IPv6 (`::/0`) (stephank)
 * bug #25378 [VarDumper] Fixed file links leave blank pages when ide is configured (antalaron)
 * bug #25410 [HttpKernel] Fix logging of post-terminate errors/exceptions (nicolas-grekas)
 * bug #25417 [Process] Dont rely on putenv(), it fails on ZTS PHP (nicolas-grekas)
 * bug #25333 [DI] Impossible to set an environment variable and then an array as container parameter (Phantas0s)
 * bug #25438 [Yaml] empty lines don't count for indent detection (xabbuh)
 * bug #25389 [Yaml] fix some edge cases with indented blocks (xabbuh)
 * bug #25340 [Serializer] Unset attributes when creating child context (dunglas)
 * bug #25323 [ExpressionLanguage] throw an SyntaxError instead of an undefined index notice (Simperfit)
 * bug #25364 [DependencyInjection] Prevent a loop in aliases within the `findDefinition` method (sroze)

* 3.3.14 (2017-12-04)

 * bug #25304 [Bridge/PhpUnit] Prefer $_SERVER['argv'] over $argv (ricknox)
 * bug #25308 [FrameworkBundle] Fix a bug where a color tag will be shown when passing an antislash (Simperfit)
 * bug #25278 Fix for missing whitespace control modifier in form layout (kubawerlos)
 * bug #25305 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25236 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25312 [DI] Fix deep-inlining of non-shared refs (nicolas-grekas)
 * bug #25309 [Yaml] parse newlines in quoted multiline strings (xabbuh)
 * bug #25241 [Yaml] do not eagerly filter comment lines (xabbuh)
 * bug #25258 [link] Prevent warnings when running link with 2.7 (dunglas)
 * bug #24750 [Validator] ExpressionValidator should use OBJECT_TO_STRING  (Simperfit)
 * bug #25232 [WebProfilerBundle] [TwigBundle] Fix Profiler breaking XHTML pages (tistre)
 * bug #25209 [VarDumper] Dont use empty(), it chokes on eg GMP objects (nicolas-grekas)
 * bug #25200 [HttpKernel] Arrays with scalar values passed to ESI fragment renderer throw deprecation notice (Simperfit)
 * bug #25217 [Dotenv] Changed preg_match flags from null to 0 (deekthesqueak)
 * bug #25203 [DI] Fix infinite loop in InlineServiceDefinitionsPass (nicolas-grekas)
 * bug #25185 [Serializer] Do not cache attributes if `attributes` in context (sroze)
 * bug #25182 [HttpFoundation] AutExpireFlashBag should not clear new flashes (Simperfit, sroze)
 * bug #25179 [FrameworkBundle][Serializer] Remove YamlEncoder definition if Yaml component isn't installed (ogizanagi)
 * bug #25163 [DI] Fix tracking of env vars in exceptions (nicolas-grekas)
 * bug #25152 [Form] Don't rely on `Symfony\Component\HttpFoundation\File\File` if http-foundation isn't in FileType (issei-m)
 * bug #24987 [Console] Fix global console flag when used in chain (Simperfit)
 * bug #25146 [DI] Dont resolve envs in service ids (nicolas-grekas)
 * bug #25113 [Routing] Fix "config-file-relative" annotation loader resources (nicolas-grekas, sroze)
 * bug #25109 Make debug:container search command case-insensitive (jzawadzki)
 * bug #25043 [Yaml] added ability for substitute aliases when mapping is on single line (Michał Strzelecki, xabbuh)
 * bug #25102 [Form] Fixed ContextErrorException in FileType (chihiro-adachi)
 * bug #25130 [DI] Fix handling of inlined definitions by ContainerBuilder (nicolas-grekas)
 * bug #25094 [FrameworkBundle][DX] Display a nice error message if an enabled component is missing (derrabus)
 * bug #25097 [Bridge\PhpUnit] Turn "preserveGlobalState" to false by default, revert "Blacklist" removal (nicolas-grekas)
 * bug #25072 [Bridge/PhpUnit] Remove trailing "\n" from ClockMock::microtime(false) (joky)
 * bug #25032 [Bridge\PhpUnit] Disable broken auto-require mechanism of phpunit (nicolas-grekas)
 * bug #24956 Fix ambiguous pattern (weltling)

* 3.3.13 (2017-11-16)

 * security #24995 Validate redirect targets using the session cookie domain (nicolas-grekas)
 * security #24994 Prevent bundle readers from breaking out of paths (xabbuh)
 * security #24993 Ensure that submitted data are uploaded files (xabbuh)
 * security #24992 Namespace generated CSRF tokens depending of the current scheme (dunglas)

* 3.3.12 (2017-11-13)

 * bug #24954 [DI] Fix dumping with custom base class (nicolas-grekas)
 * bug #24952 [HttpFoundation] Fix session-related BC break (nicolas-grekas, sroze)
 * bug #24929 [Console] Fix traversable autocomplete values (ro0NL)

* 3.3.11 (2017-11-10)

 * bug #24888 [FrameworkBundle] Specifically inject the debug dispatcher in the collector (ogizanagi)
 * bug #24909 [Intl] Update ICU data to 60.1 (jakzal)
 * bug #24870 [YAML] Allow to parse custom tags when linting yaml files (pierredup)
 * bug #24910 [HttpKernel][Debug] Remove noise from stack frames of deprecations (nicolas-grekas)
 * bug #24906 [Bridge/ProxyManager] Remove direct reference to value holder property (nicolas-grekas)
 * bug #24900 [Validator] Fix Costa Rica IBAN format (Bozhidar Hristov)
 * bug #24904 [Validator] Add Belarus IBAN format (Bozhidar Hristov)
 * bug #24881 [WebserverBundle] fixed the bug that caused that the webserver would … (Serkan Yildiz)
 * bug #24531 [HttpFoundation] Fix forward-compat of NativeSessionStorage with PHP 7.2 (sroze)
 * bug #24665 Fix dump panel hidden when closing a dump (julienfalque)
 * bug #24816 [Serializer] Fix extra attributes when no group specified (ogizanagi)
 * bug #24814 [Intl] Make intl-data tests pass and save language aliases again (jakzal)
 * bug #24810 [Serializer] readd default argument value (xabbuh)
 * bug #24735 [VarDumper] fix trailling comma when dumping an exception (Simperfit)
 * bug #24764 [HttpFoundation] add Early Hints to Reponse to fix test (Simperfit)
 * bug #24759 Removes \n or space when $context/$extra are empty (kirkmadera)
 * bug #24758 Throwing exception if redis and predis unavailable (aequasi)
 * bug #24744 debug:container --types: Fix bug with non-existent classes (weaverryan)
 * bug #24605 [FrameworkBundle] Do not load property_access.xml if the component isn't installed (ogizanagi)
 * bug #24706 [DependencyInjection] Add the possibility to disable assets via xml (renatomefi)
 * bug #24696 Ensure DeprecationErrorHandler::collectDeprecations() is triggered (alexpott)
 * bug #24686 Fix $_ENV/$_SERVER precedence in test framework (fabpot)
 * bug #24606 [HttpFoundation] Fix FileBag issue with associative arrays (enumag)
 * bug #24673 [DI] Throw when a service name or an alias contains dynamic values (prevent an infinite loop) (dunglas)
 * bug #24681 Fix isolated error handling (alexpott)
 * bug #24575 Ensure that PHPUnit's error handler is still working in isolated tests (alexpott)
 * bug #24597 [PhpUnitBridge] fix deprecation triggering test detection (xabbuh)
 * bug #24660 Escape trailing \ in QuestionHelper autocompletion (kamazee)
 * bug #24598 Prefer line formatter on missing cli dumper (greg0ire)
 * bug #24644 [Security] Fixed auth provider authenticate() cannot return void (glye)
 * bug #24642 [Routing] Fix resource miss (dunglas)
 * bug #24608 Adding the Form default theme files to be warmed up in Twig's cache (weaverryan)
 * bug #24626 streamed response should return $this (DQNEO)
 * bug #24589 Username and password in basic auth are allowed to contain '.' (Richard Quadling)
 * bug #24566 Fixed unsetting from loosely equal keys OrderedHashMap (maryo)
 * bug #24570 [Debug] Fix same vendor detection in class loader (Jean-Beru)
 * bug #24573  Fixed pathinfo calculation for requests starting with a question mark. (syzygymsu)
 * bug #24565 [Serializer] YamlEncoder: throw if the Yaml component isn't installed (dunglas)
 * bug #24563 [Serializer] ObjectNormalizer: throw if PropertyAccess isn't installed (dunglas)
 * bug #24571 [PropertyInfo] Add support for the iterable type (dunglas)
 * bug #24579 pdo session fix (mxp100)
 * bug #24536 [Security] Reject remember-me token if UserCheckerInterface::checkPostAuth() fails (kbond)
 * bug #24548 [Bridge\PhpUnit] Handle deprecations triggered in separate processes (paul-m)
 * bug #24519 [Validator] [Twig] added magic method __isset()  to File Constraint class (loru88)
 * bug #24532 [DI] Fix possible incorrect php-code when dumped strings contains newlines (Strate)
 * bug #24502 [HttpFoundation] never match invalid IP addresses (xabbuh)
 * bug #24460 [Form] fix parsing invalid floating point numbers (xabbuh)
 * bug #24490 [HttpFoundation] Combine Cache-Control headers (c960657)
 * bug #23711 Fix support for PHP 7.2 (Simperfit, nicolas-grekas)
 * bug #24494 [HttpFoundation] Add missing session.lazy_write config option (nicolas-grekas)
 * bug #24498 [Bridge\PhpUnit] Fix infinite loop when running isolated method (nicolas-grekas)
 * bug #24434 [Form] Use for=ID on radio/checkbox label. (Nyholm)
 * bug #24455 [Console] Escape command usage (sroze)
 * bug #24462 [Yaml] parse references on merge keys with objects (xabbuh)

* 3.3.10 (2017-10-05)

 * bug #23906 Added support for guards when advancing workflow from a command (GDIBass)
 * bug #24448 [Session] fix MongoDb session handler to gc all expired sessions (Tobion)
 * bug #24431 [FrameworkBundle] Fix bad interface hint in AbstractController (nicolas-grekas)
 * bug #24419 [Cache] Fix race condition in TagAwareAdapter (nicolas-grekas)
 * bug #24417 [Yaml] parse references on merge keys (xabbuh)
 * bug #24416 [Yaml] treat trailing backslashes in multi-line strings (xabbuh)
 * bug #24421 [Config] Fix dumped files invalidation by OPCache (nicolas-grekas)
 * bug #24418 [DI] Allow setting any public non-initialized services (nicolas-grekas)
 * bug #23980 Tests and fix for issue in array model data in EntityType field with multiple=true (stoccc)
 * bug #22586 [Form] Fixed PercentToLocalizedStringTransformer to accept both comma and dot as decimal separator, if possible (aaa2000)
 * bug #24157 [Intl] Fixed support of Locale::getFallback (lyrixx)
 * bug #24198 [HttpFoundation] Fix file upload multiple with no files (enumag)
 * bug #24379 [PHPUnitBridge] don't remove when set to  empty string (Simperfit)
 * bug #24036 [Form] Fix precision of MoneyToLocalizedStringTransformer's divisions and multiplications (Rubinum)
 * bug #24191 [DependencyInjection] include file and line number in deprecation (xabbuh)
 * bug #24367 PdoSessionHandler: fix advisory lock for pgsql (Tobion)
 * bug #24189 [Yaml] parse merge keys with PARSE_OBJECT_FOR_MAP flag (xabbuh)
 * bug #24243 HttpCache does not consider ESI resources in HEAD requests (mpdude)
 * bug #24237 [WebProfilerBundle] Added missing link to profile token (vtsykun)
 * bug #24244 TwigBundle exception/deprecation tweaks (ro0NL)
 * bug #24281 [TwigBundle] Remove profiler related scripting (ro0NL, javiereguiluz)
 * bug #24251 [PropertyAccess] Set a NullLogger in ApcuAdapter when Apcu is disabled in CLI (iamluc)
 * bug #24304 [FrameworkBundle] Fix Routing\DelegatingLoader (nicolas-grekas)
 * bug #24305 [HttpKernel] Make array vs "::" controller definitions consistent (nicolas-grekas)
 * bug #24255 [TwigBundle] Break long lines in exceptions (kevin-verschaeve)
 * bug #24219 [Console] Preserving line breaks between sentences according to the exception message (yceruto)
 * bug #24192 [PhpUnitBridge] do not require an error context (xabbuh)
 * bug #23722 [Form] Fixed GroupSequence with "constraints" option (HeahDude)
 * bug #22321 [Filesystem] Fixed makePathRelative (ausi)
 * bug #24234 [DI] Fix decorated service merge in ResolveInstanceofConditionalsPass (dunglas)
 * bug #24203 [Security] Preserve URI fragment in HttpUtils::generateUri() (chalasr)
 * bug #24199 [DI] Fix non-instantiables auto-discovery (nicolas-grekas)
 * bug #23473 [Filesystem] mirror - fix copying content with same name as source/target. (gitlost)
 * bug #24177 [FrameworkBundle] Add support to environment variables APP_ENV/DEBUG in KernelTestCase (yceruto)
 * bug #24162 [WebProfilerBundle] fixed TemplateManager when using Twig 2 without compat interfaces (fabpot)

* 3.3.9 (2017-09-11)

 * bug #24141 [DomCrawler] Fix conversion to int on GetPhpFiles (MaraBlaga)
 * bug #23853 Filtering empty uuids in ORMQueryBuilderLoader. (mlazovla)
 * bug #24101 [Security] Fix exception when use_referer option is true and referer is not set or empty (linniksa)
 * bug #24105 [Filesystem] check permissions if dump target dir is missing (xabbuh)
 * bug #24126 [HttpKernel] "controller.service_arguments" services should be public (nicolas-grekas)
 * bug #24113 [FrameworkBundle] Get KERNEL_CLASS through $_ENV too for KernelTestCase (yceruto)
 * bug #24115 [FrameworkBundle] Get KERNEL_DIR through $_ENV too for KernelTestCase (yceruto)
 * bug #24041 [ExpressionLanguage] throws an exception on calling uncallable method (fmata)
 * bug #24096 Fix ArrayInput::toString() for VALUE_IS_ARRAY options/args (chalasr)
 * bug #24082 [DI] Minor fix in dumped code (nicolas-grekas)
 * bug #23969 [Cache] Use namespace versioning for backends that dont support clearing by keys (nicolas-grekas)
 * bug #24021 [DI] Don't track merged configs when the extension doesn't expose it (nicolas-grekas)
 * bug #24011 [Cache] Always require symfony/polyfill-apcu to provide APCuIterator everywhere (guillaumelecerf)
 * bug #23730 Fixed the escaping of back slashes and << in console output (javiereguiluz)

* 3.3.8 (2017-08-28)

 * bug #24016 [DI] Fix tracking env var placeholders nested in object graphs (nicolas-grekas)

* 3.3.7 (2017-08-28)

 * bug #24009 [DI] Fix tracking env vars when merging configs (bis) (nicolas-grekas)
 * bug #23952 [PhpUnitBridge] install PHPUnit 6 on PHP 7.2 (xabbuh)
 * bug #23985 [Cache] Workaround zend.detect_unicode + zend.multibyte (nicolas-grekas)
 * bug #23989 [Debug] Remove false-positive check in DebugClassLoader (nicolas-grekas)
 * bug #23983 [VarDumper] Strengthen dumped JS (nicolas-grekas)
 * bug #23982 [VarDumper] Strengthen dumped JS (nicolas-grekas)
 * bug #23925 [Validator] Fix use of GroupSequenceProvider in child classes (linniksa)
 * bug #23971 [Cache] Fix lazy Memcached connections (nicolas-grekas)
 * bug #23970 [Cache] Fix >30 days expirations with Memcached (nicolas-grekas)
 * bug #23949 [Dotenv] Get env using $_SERVER to work with fastcgi_param and workaround thread safety issues (nicolas-grekas)
 * bug #23799 [Dotenv][WebServerBundle] Override previously loaded variables (voronkovich)
 * bug #23676 [WebProfilerBundle] Re add missing link to the controller (lyrixx)
 * bug #23870 [DI] Use GlobResource for non-tracked directories (vudaltsov)
 * bug #23945 [Validator] Fix Greek translation (azhurb)
 * bug #23940 [DI] Fix resolving env vars when compiling a ContainerBuilder (nicolas-grekas)
 * bug #23903 [DI] Fix merging of env vars in configs (nicolas-grekas)
 * bug #23825 Revert "feature #21038 [FrameworkBundle] deprecated cache:clear with warmup (fabpot)" (nicolas-grekas)
 * bug #23899 [DI] Fix reading env vars from fastcgi params (nicolas-grekas)
 * bug #23909 [Console] Initialize lazily to render exceptions properly (nicolas-grekas)
 * bug #23878 [VarDumper] play nice with open_basedir when looking for composer.json (nicolas-grekas)
 * bug #23897 Allow phpdocumentor/reflection-docblock 4 (derrabus)
 * bug #23865 [Workflow] fixed InvalidDefinitionException message for StateMachineValidator (fmata)
 * bug #23856 [DI] Fix dumping abstract with YamlDumper (nicolas-grekas)
 * bug #23848 restrict reflection doc block (ElectricMaxxx)
 * bug #23854 [DI] Fix YamlDumper not dumping abstract and autoconfigure (nicolas-grekas)
 * bug #23752 Ignore memcached missing key error on session destroy (jderusse)
 * bug #23829 Fixed the exception page design in responsive mode (javiereguiluz)
 * bug #23828 [Console] Log exit codes as debug messages instead of errors (haroldiedema)
 * bug #23763 [Cache] Hash cache key on save (lstrojny)
 * bug #23806 [Profiler] Fix request_collector check in main layout (ogizanagi)
 * bug #23658 [HttpFoundation] Generate safe fallback filename for wrongly encoded filename (xelaris)
 * bug #23776 [FrameworkBundle] Warmup annotations for bundle-less controllers and entities (nicolas-grekas)
 * bug #23783 Avoid infinite loops when profiler data is malformed (javiereguiluz)
 * bug #23638 [FrameworkBundle][Workflow] better errors when security deps are missing (xabbuh)
 * bug #23729 [Bridge\ProxyManager] Dont call __destruct() on non-instantiated services (nicolas-grekas)
 * bug #23703 Bump minimal PHP version to ^5.5.9|>=7.0.8 (nicolas-grekas)
 * bug #23755 [Config] Fix checking class existence freshness (nicolas-grekas)

* 3.3.6 (2017-08-01)

 * bug #22244 [Console] Fix passing options with defaultCommand (Jakub Sacha)
 * bug #23705 [Form] Add notice to upgrade to PHP v7.0.8+ (nicolas-grekas)
 * bug #23683 [VarDumper] Keep and reuse array stubs in memory (nicolas-grekas)
 * bug #23686 [Console][WebServerBundle] Use "exec" when possible (nicolas-grekas)
 * bug #23684 [Debug] Missing escape in debug output (c960657)
 * bug #23644 [VarDumper] Dont use Stub objects for arrays - lower GC pressure (nicolas-grekas)
 * bug #23615 [Cache] Handle serialization failures for Memcached (nicolas-grekas)
 * bug #23654 [DI] Fix using private services in expressions (nicolas-grekas)
 * bug #23662 [VarDumper] Adapt to php 7.2 changes (nicolas-grekas)
 * bug #23649 [Form][TwigBridge] Don't render _method in form_rest() for a child form (fmarchalemisys)
 * bug #23588 [WebProfilerBundle] Display trace and context in the logger profiler (lyrixx)
 * bug #23023 [DoctrineBridge][PropertyInfo] Added support for Doctrine Embeddables (vudaltsov)
 * bug #23618 [Routing] allow HEAD method to be defined first (DavidBadura)
 * bug #23619 [Validator] Fix IbanValidator for ukrainian IBANs (paroe)
 * bug #23605 [DI][Bug] Autowiring thinks optional args on core classes are required (weaverryan)
 * bug #23586 Fix case sensitive sameSite cookie (mikefrancis)
 * bug #23584 Fix the design of the profiler exceptions when there is no message (javiereguiluz)
 * bug #23238 [Security] ensure the 'route' index is set before attempting to use it (gsdevme)
 * bug #23330 [WebProfilerBundle] Fix full sized dump hovering in toolbar (ogizanagi)
 * bug #23581 [Config] Minor fix (nicolas-grekas)
 * bug #23580 Fix login redirect when referer contains a query string (fabpot)
 * bug #23577 [WebProfilerBundle][TwigBundle] Fix infinite js loop on exception pages (ogizanagi)
 * bug #23558 [FrameworkBundle] fix ValidatorCacheWarmer: use serializing ArrayAdapter (dmaicher)
 * bug #23573 [Config] Make ClassExistenceResource throw on invalid parents (nicolas-grekas)
 * bug #23574 [VarDumper] Move locale sniffing to dump() time (nicolas-grekas)
 * bug #23575 [VarDumper] Use "C" locale when using "comma" flags (nicolas-grekas)

* 3.3.5 (2017-07-17)

 * bug #23549 [PropertyInfo] conflict for phpdocumentor/reflection-docblock 3.2 (xabbuh)
 * bug #23513 [FrameworkBundle] Set default public directory on install assets (yceruto)
 * security #23507 [Security] validate empty passwords again (xabbuh)
 * bug #23526 [HttpFoundation] Set meta refresh time to 0 in RedirectResponse content (jnvsor)
 * bug #23535 Make server:* commands work out of the box with the public/ root dir (fabpot)
 * bug #23540 Disable inlining deprecated services (alekitto)
 * bug #23498 [Process] Fixed issue between process builder and exec (lyrixx)
 * bug #23490 [DependencyInjection] non-conflicting anonymous service ids across files (xabbuh)
 * bug #23468 [DI] Handle root namespace in service definitions (ro0NL)
 * bug #23477 [Process] Fix parsing args on Windows (nicolas-grekas)
 * bug #23256 [Security] Fix authentication.failure event not dispatched on AccountStatusException (chalasr)
 * bug #23461 Use rawurlencode() to transform the Cookie into a string (javiereguiluz)
 * bug #23465 [HttpKernel][VarDumper] Truncate profiler data & optim perf (nicolas-grekas)
 * bug #23457 [FrameworkBundle] check _controller attribute is a string before parsing it (alekitto)
 * bug #23459 [TwigBundle] allow to configure custom formats in XML configs (xabbuh)
 * bug #23460 Don't display the Symfony debug toolbar when printing the page (javiereguiluz)
 * bug #23469 [FrameworkBundle] do not wire namespaces for the ArrayAdapter (xabbuh)
 * bug #23434 [DotEnv] Fix variable substitution (brieucthomas)
 * bug #23426 Fixed HttpOnly flag when using Cookie::fromString() (Toflar)
 * bug #22439 [DX] [TwigBundle] Enhance the new exception page design (sustmi)
 * bug #23417 [DI][Security] Prevent unwanted deprecation notices when using Expression Languages (dunglas)
 * bug #23261 Fixed absolute url generation for query strings and hash urls (alexander-schranz)
 * bug #23398 [Filesystem] Dont copy perms when origin is remote (nicolas-grekas)

* 3.3.4 (2017-07-05)

 * bug #23413 [VarDumper] Reduce size of serialized Data objects (nicolas-grekas)
 * bug #23385 [DoctrineBridge] Fix resetting entity managers with case sensitive id (chalasr)
 * bug #23390 [Cache] Handle APCu failures gracefully (nicolas-grekas)
 * bug #23371 [FrameworkBundle] 3.3: Don't get() private services from debug:router (ogizanagi)
 * bug #23378 [FrameworkBundle] Do not remove files from assets dir (1ed)

* 3.3.3 (2017-07-04)

 * bug #23366 [FrameworkBundle] Don't get() private services from debug:router (chalasr)
 * bug #23239 [FrameworkBundle] call setContainer() for autowired controllers (xabbuh)
 * bug #23351 [Dotenv] parse concatenated variable values (xabbuh)
 * bug #23341 [DoctrineBridge][Security][Validator] do not validate empty values (xabbuh)
 * bug #23274 Display a better error design when the toolbar cannot be displayed (yceruto)
 * bug #23342 [Dotenv] parse escaped quotes in unquoted env var values (xabbuh)
 * bug #23291 [Security] Fix Firewall ExceptionListener priority (chalasr)
 * bug #23296 [WebProfilerBundle] Fix css trick used for offsetting html anchor from fixed header (ogizanagi)
 * bug #23333 [PropertyAccess] Fix TypeError discard (dunglas)
 * bug #23326 [Cache] fix cleanup of expired items for PdoAdapter (dmaicher)
 * bug #23345 [Console] fix description of INF default values (xabbuh)
 * bug #23328 [FrameworkBundle] Display a proper warning on cache:clear without the --no-warmup option (ogizanagi)
 * bug #23299 [Workflow] Added more events to the announce function (Nyholm)
 * bug #23279 Don't call count on non countable object (pierredup)
 * bug #23283 [TwigBundle] add back exception check (xabbuh)
 * bug #23268 Show exception is checked twice in ExceptionController of twig (gmponos)
 * bug #23266 Display a better error message when the toolbar cannot be displayed (javiereguiluz)
 * bug #23271 [FrameworkBundle] allow SSI fragments configuration in XML files (xabbuh)
 * bug #23254 [Form][TwigBridge] render hidden _method field in form_rest() (xabbuh)
 * bug #23250 [Translation] return fallback locales whenever possible (xabbuh)
 * bug #23237 [Cache] Fix Predis client cluster with pipeline (flolivaud)
 * bug #23240 [Console] Fix catching exception type in QuestionHelper (voronkovich)
 * bug #23218 [DI] Dedup tags when using instanceof/autoconfigure (ogizanagi)
 * bug #23231 Improved the exception page when there is no message (javiereguiluz)
 * bug #23229 [WebProfilerBundle] Eliminate line wrap on count column (routing) (e-moe)
 * bug #22732 [Security] fix switch user _exit without having current token (dmaicher)
 * bug #23226 [Validator] replace hardcoded service id (xabbuh)
 * bug #22730 [FrameworkBundle] Sessions: configurable "use_strict_mode" option for NativeSessionStorage (MacDada)
 * bug #23195 [FrameworkBundle] [Command] Clean bundle directory, fixes #23177 (NicolasPion)
 * bug #23213 Fixed composer resources between web/cli (iltar)
 * bug #23160 [WebProfilerBundle] Fix the icon for the Cache panel (javiereguiluz)
 * bug #23052 [TwigBundle] Add Content-Type header for exception response (rchoquet)
 * bug #23173 [WebServerBundle] Fix router script option BC (1ed)
 * bug #23199 Reset redirectCount when throwing exception (hvanoch)
 * bug #23180 [FrameworkBundle] Expose the AbstractController's container to its subclasses (BPScott)
 * bug #23186 [TwigBundle] Move template.xml loading to a compiler pass (ogizanagi)
 * bug #23130 Keep s-maxage when expiry and validation are used in combination (mpdude)
 * bug #23129 Fix two edge cases in ResponseCacheStrategy (mpdude)
 * feature #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #22943 [SecurityBundle] Move cache of the firewall context into the request parameters (GromNaN)
 * bug #23088 [FrameworkBundle] Dont set pre-defined esi/ssi services (ro0NL)
 * bug #23057 [Translation][FrameworkBundle] Fix resource loading order inconsistency reported in #23034 (mpdude)
 * bug #23092 [Filesystem] added workaround in Filesystem::rename for PHP bug (VolCh)
 * bug #23074 [HttpFoundation] add back support for legacy constant values (xabbuh)
 * bug #23128 [HttpFoundation] fix for Support for new 7.1 session options (vincentaubert)
 * bug #23176 [VarDumper] fixes (nicolas-grekas)
 * bug #23100 [PropertyAccess] Do not silence TypeErrors from client code. (tsufeki)
 * bug #23156 [PropertyAccess] Fix Usage with anonymous classes (mablae)
 * bug #23168 [Config] Fix ** GlobResource on Windows (nicolas-grekas)
 * bug #23171 [Yaml] Fix linting yaml with constants as keys (chalasr)
 * bug #23121 [Routing] Revert the change in [#b42018] with respect to Routing/Route.php (Dan Wilga)
 * bug #23141 [DI] Fix keys resolution in ResolveParameterPlaceHoldersPass (nicolas-grekas)
 * bug #23145 Fix the conditional definition of the SymfonyTestsListener (stof)
 * bug #23091 [Cache] ApcuAdapter::isSupported() should return true when apc.enable_cli=Off (nicolas-grekas)
 * bug #22953 #22839 - changed debug toolbar dump section to relative and use full window width (mkurzeja)
 * bug #23086 [FrameworkBundle] Fix perf issue in CacheClearCommand::warmup() (nicolas-grekas)
 * bug #23090 [SecurityBundle] Made 2 service aliases private (nicolas-grekas)
 * bug #23108 [Yaml] Remove line number in deprecation notices (nicolas-grekas)
 * bug #23098 Cache ipCheck (2.7) (gonzalovilaseca)
 * bug #23082 [MonologBridge] Do not silence errors in ServerLogHandler::formatRecord (lyrixx)
 * bug #23007 [HttpKernel][Debug] Fix missing trace on deprecations collected during bootstrapping & silenced errors (ogizanagi)
 * bug #23069 [SecurityBundle] Show unique Inherited roles in profile panel (yceruto)

* 3.3.2 (2017-06-06)

 * bug #23073 [TwigBridge] Fix namespaced classes (ogizanagi)
 * bug #23063 [Cache] Fix extensibility of TagAwareAdapter::TAGS_PREFIX (wucdbm)
 * bug #22936 [Form] Mix attr option between guessed options and user options (yceruto)
 * bug #22976 [DependencyInjection] Use more clear message when unused environment variables detected (voronkovich)

* 3.3.1 (2017-06-05)

 * bug #23067 [HttpFoundation][FrameworkBundle] Revert "trusted proxies" BC break (nicolas-grekas)
 * bug #23065 [Cache] Fallback to positional when keyed results are broken (nicolas-grekas)
 * bug #22981 [DependencyInjection] Fix named args support in ChildDefinition (dunglas)
 * bug #23050 [Form][Profiler] Fixes form collector triggering deprecations (ogizanagi)
 * bug #22971 [Profiler] Fix code excerpt wrapping (ogizanagi)
 * bug #23049 [FrameworkBundle] mitigate BC break with empty trusted_proxies (xabbuh)
 * bug #23045 [Cache] fix Redis scheme detection (xabbuh)
 * bug #23013 Parse the _controller format in sub-requests (weaverryan)
 * bug #23015 [PhpUnitBridge] Fix detection of PHPUnit 5 (enumag)
 * bug #23041 [Config] Always protected ClassExistenceResource against bad parents (nicolas-grekas)
 * bug #22988 [PropertyInfo][DoctrineBridge] The bigint Doctrine's type must be converted to string (dunglas)
 * bug #23014 Fix optional cache warmers are always instantiated whereas they should be lazy-loaded (romainneutron)
 * feature #23022 [Di] Remove closure-proxy arguments (nicolas-grekas)
 * bug #23024 [EventDispatcher] Fix ContainerAwareEventDispatcher::hasListeners(null) (nicolas-grekas)
 * bug #23008 [EventDispatcher] Handle laziness internally instead of relying on ClosureProxyArgument (nicolas-grekas)
 * bug #23018 [FrameworkBundle] Fix CacheCollectorPass priority (chalasr)
 * bug #23009 [Routing] Allow GET requests to be redirected. Fixes #23004 (frankdejonge)
 * bug #22996 [Form] Fix \IntlDateFormatter timezone parameter usage to bypass PHP bug #66323 (romainneutron)
 * bug #22965 [Cache] Ignore missing annotations.php (ro0NL)
 * bug #22993 [DI] Autowiring exception thrown when inlined service is removed (weaverryan)
 * bug #22999 Better DI type deprecation message (weaverryan)
 * bug #22985 [Config] Allow empty globs (nicolas-grekas)
 * bug #22961 [HttpKernel] Support unknown format in LoggerDataCollector (iltar)
 * bug #22991 [DI] Don't throw Autowire exception for removed service with private __construct (weaverryan)
 * bug #22968 [Profiler] Fix text selection & click on file links on exception pages (ogizanagi)
 * bug #22994 Harden the debugging of Twig filters and functions (stof)
 * bug #22960 [Cache] Fix decoration of TagAware adapters in dev (chalasr)

* 3.3.0 (2017-05-29)

 * bug #22940 [Config] Fallback to regular import when glob fails (nicolas-grekas)
 * bug #22847 [Console] ChoiceQuestion must have choices (ro0NL)
 * bug #22900 [FrameworkBundle][Console] Fix the override of a command registered by the kernel (aaa2000)
 * bug #22930 Revert "bug #22925 [PhpUnitBridge] Adjust PHPUnit class_alias check (nicolas-grekas)
 * bug #22910 [Filesystem] improve error handling in lock() (xabbuh)
 * bug #22924 [Cache] Dont use pipelining with RedisCluster (nicolas-grekas)
 * bug #22928 [WebProfilerBundle] Fixed options stub values display in form profiler (HeahDude)
 * feature #22838 Make the simple exception pages match the new style (javiereguiluz)
 * bug #22925 [PhpUnitBridge] Adjust PHPUnit class_alias check to also check for namespaced class (GawainLynch)
 * bug #22718 [Console] Fixed different behaviour of key and value user inputs in multiple choice question (borNfreee)
 * bug #22921 [FrameworkBundle] Only override getProjectDir if it exists in the kernel (aschempp)
 * feature #22905 [FrameworkBundle][Validator] Move the PSR-11 factory to the component (ogizanagi)
 * bug #22728 [HttpKernel] Fix kernel.project_dir extensibility (chalasr)
 * bug #22829 [Yaml] fix colon without space deprecation (xabbuh)
 * bug #22901 Fix missing abstract key in XmlDumper (weaverryan)
 * bug #22912 [DI] Avoid private call to Container::has() (ro0NL)
 * feature #22904 [HttpFoundation] Add Request::HEADER_X_FORWARDED_AWS_ELB const (nicolas-grekas)
 * bug #22878 [Yaml] parse PHP constants in mapping keys (xabbuh)
 * bug #22873 [HttpKernel] don't call getTrustedHeaderName() if possible (xabbuh)
 * feature #22892 [ProxyManager] Add FC layer (nicolas-grekas)
 * bug #22866 [DI] Check for privates before shared services (ro0NL)
 * feature #22884 [DI] Add missing deprecation on Extension::getClassesToCompile (nicolas-grekas)
 * bug #22874 [WebProfilerBundle] Fix sub-requests display in time profiler panel (nicolas-grekas)
 * bug #22853 [Yaml] fix multiline block handling (xabbuh)
 * bug #22872 [FrameworkBundle] Handle project dir in cache:clear command (nicolas-grekas)
 * feature #22808 [FrameworkBundle][Validator] Deprecate passing validator instances/aliases over using the service locator (ogizanagi)
 * bug #22857 [DI] Fix autowire error for inlined services (weaverryan)
 * bug #22858 [SecurityBundle] Prevent auto-registration of UserPasswordEncoderCommand (chalasr)
 * bug #22859 [Profiler][VarDumper] Fix searchbar css when in toolbar (ogizanagi)
 * bug #22614 [Process]  Fixed escaping arguments on Windows when inheritEnvironmentVariables is set to false (maryo)
 * bug #22817 [PhpUnitBridge] optional error handler arguments (xabbuh)
 * bug #22781 [DI][Serializer] Fix missing de(normalizer|coder) autoconfig (ogizanagi)
 * bug #22790 [DependencyInjection] Fix dumping of RewindableGenerator with empty IteratorArgument (meyerbaptiste)
 * bug #22787 [MonologBridge] Fix the Monlog ServerLogHandler from Hanging on Windows (ChadSikorra)
 * bug #22768 Use 0.0.0.0 as the server log command host default. (ChadSikorra)
 * bug #22752 Improved how profiler errors are displayed on small screens (javiereguiluz)

* 3.3.0-RC1 (2017-05-17)

 * bug #22715 [FrameworkBundle] remove Security deps from the require section (xabbuh)
 * bug #22613 [Process] Fix incorrectly calling PHP process when path contains space (maryo)
 * feature #22680 [DI] Fixing missing "exclude" functionality from PSR4 loader (weaverryan)
 * bug #22699 [TwigBundle] service workflow.twig_extension should stay public (ogizanagi)
 * feature #22708 Adding autowire alias for AuthenticationUtils (weaverryan)
 * bug #22695 [WebServerBundle] fix dependencies (xabbuh)
 * bug #22647 [VarDumper] Fix dumping of non-nested stubs (nicolas-grekas)
 * bug #22409 [Yaml] respect inline level when dumping objects as maps (goetas, xabbuh)
 * bug #22584 [Security] Avoid unnecessary route lookup for empty logout path (ro0NL)
 * bug #22642 [DX] Making the RegisterControllerArgumentLocatorsPass throw exception on bad types (weaverryan)
 * bug #22664 [Security] Fix TraceableAccessDecisionManager / DebugAccessDecisionManager BC layer (ogizanagi)
 * bug #22690 [Console] Fix errors not rethrown even if not handled by console.error listeners (chalasr)
 * bug #22681 Fixing a bug where abstract classes were wired with the prototype loader (weaverryan)
 * feature #22665 [DI] Do not throw autowiring exceptions for a service that will be removed (weaverryan)
 * bug #22669 [FrameworkBundle] AbstractConfigCommand: do not try registering bundles twice (ogizanagi)
 * bug #22676 [FrameworkBundle] Adding the extension XML (flug)
 * bug #22611 [FrameworkBundle] Fix "Locale class not found" in AboutCommand (rubenrua)
 * bug #22677 [DI] Fixed index args bug with ResolveNamedArgumentsPass (weaverryan)
 * bug #22652 [Workflow] Move twig extension registration to twig bundle (ogizanagi)
 * feature #22668 [FrameworkBundle] KernelTestCase: allow to provide the kernel class with a var (ogizanagi)
 * bug #22639 [WebLink][TwigBundle] Fix registration of the twig extension (ogizanagi)
 * bug #22658 Make the exception pages work when the WebProfilerBundle is not installed (javiereguiluz)
 * bug #22657 [DI] Fix Cannot declare class ...\DefinitionDecorator, because the name is already in use (ogizanagi)
 * feature #22624 debug:container --types (classes/interfaces) (weaverryan)
 * bug #22626 Fix missing parenthesis (yceruto)
 * bug #22621 [Config] Fix resource tracking with new GlobResource (nicolas-grekas)
 * feature #22385 [DX][FrameworkBundle] Show private aliases in debug:container (chalasr)
 * bug #22615 [DI] Defaults to public=false in all service config files (nicolas-grekas)

* 3.3.0-BETA1 (2017-05-01)

 * feature #22530 Making tags under _defaults always apply (weaverryan)
 * feature #22590 [Lock] remove the component from 3.3 (fabpot)
 * feature #22527 [DI] Throw useful exception on bad XML argument tags (nicolas-grekas)
 * feature #22537 [Serializer] Allow to pass csv encoder options in context (ogizanagi)
 * feature #22563 Not allowing autoconfigure, instanceofConditionals or defaults for ChildDefinition (weaverryan)
 * feature #22441 [Console] Review console.ERROR related behavior (nicolas-grekas)
 * feature #22234 [DI] Introducing autoconfigure: automatic _instanceof configuration (weaverryan)
 * feature #21502 Persist app bootstrapping logs for logger datacollector (ScullWM, nicolas-grekas)
 * feature #22459 [HttpKernel] Fix deprecation of Extension::addClassesToCompile() / AddClassesToCachePass (nicolas-grekas)
 * feature #22416 [FrameworkBundle][Workflow] Deprecate the default type of a workflow (lyrixx)
 * feature #22313 [Workflow] Move ValidateWorkflowsPass to the Workflow component (chalasr)
 * feature #22420 [DI] Make tagged abstract services throw earlier (nicolas-grekas)
 * feature #22384 [DI] Replace autowiring BC break by regular deprecation (nicolas-grekas)
 * feature #22383 added a more specialized exception for a better error message (fabpot)
 * feature #22356 [DI] Rework config hierarchy: defaults > instanceof > service config (weaverryan, nicolas-grekas)
 * feature #22362 [DI] Populate class of ChildDefinition when its id matches an existing FQCN (nicolas-grekas)
 * feature #22239 [Finder] Glob wildcard while using double-star without ending slash (sroze)
 * feature #22273 Add a new Link component (dunglas)
 * feature #22315 Add Kernel::getProjectDir() (fabpot)
 * feature #22314 [HttpKernel][FrameworkBundle] Dump container logs in Kernel, to have them also on errors (nicolas-grekas)
 * feature #22316 [WebServerBundle] added a way to dump current status host/port/address when getting the status (fabpot)
 * feature #22323 [DI] Report cascades of autowiring error messages (nicolas-grekas)
 * feature #22306 [DI] Restrict autowired registration to "same-vendor" namespaces (nicolas-grekas)
 * feature #22295 [BC BREAK][DI] Always autowire "by id" instead of using reflection against all existing services (nicolas-grekas)
 * feature #20951 Redesigned the exception pages (javiereguiluz)
 * feature #21919 [Form] Deprecated usage of "choices" option in sub types (HeahDude)
 * feature #22274 [Yaml] report deprecations when linting YAML files (xabbuh)
 * feature #22286 [DI/Yaml] Remove `@experimental` flag from "instanceof" and "prototype" (nicolas-grekas)
 * feature #22181 [Console] Allow to catch CommandNotFoundException (chalasr)
 * feature #22296 Bump monolog to 1.19 and use the agent regex const from parent (redthor)
 * feature #21437 [Security] Use IteratorArgument for voters (jvasseur)
 * feature #22277 [DI] Add "factory" support to named args and autowiring (nicolas-grekas)
 * feature #22276 [FrameworkBundle] Returns the kernel instance in KernelTestCase::bootKernel (lyrixx)
 * feature #22256 [DI] Reduce complexity of autowiring (nicolas-grekas)
 * feature #22238 [BC BREAK][HttpFoundation] Request::setTrustedProxies() takes a new required $trustedHeaderSet argument (nicolas-grekas)
 * feature #22175 [DI] add ServiceLocatorTagPass::register() to share service locators (nicolas-grekas)
 * feature #22180 [Workflow] Added 'workflow_marked_places' twig function (lyrixx)
 * feature #22185 [DI] Enhance DX by throwing instead of triggering a deprecation notice (nicolas-grekas)
 * feature #22060 [DI] Add "by-id" autowiring: a side-effect free variant of it based on the class<>id convention (nicolas-grekas)
 * feature #22158 Revert "feature #20973 [DI] Add getter injection (nicolas-grekas)" (nicolas-grekas)
 * feature #22157 [FrameworkBundle] Introduce AbstractController, replacing ControllerTrait (nicolas-grekas)
 * feature #22046 [Asset] Adding a new version strategy that reads from a manifest JSON file (weaverryan)
 * feature #22129 [WebProfilerBundle] Improve cache panel (ro0NL)
 * feature #21819 [Twig Bridge] A simpler way to retrieve flash messages (javiereguiluz)
 * feature #19026 [Security] Strengthen comparison of target_url vs login_path (mrzard)
 * feature #19496 [DX][Form][Validator] Add ability check if cocrete constraint fails. (Koc)
 * feature #18140 [Console] Add console.ERROR event and deprecate console.EXCEPTION (wouterj)
 * feature #22120 [FrameworkBundle] Multiple services on one Command class (SenseException)
 * feature #21771 [FrameworkBundle] Add new "controller.service_arguments" tag to inject services into actions (nicolas-grekas)
 * feature #22114 [lock] Rename Quorum into Strategy (jderusse)
 * feature #20516 [Security][SecurityBundle] Enhance automatic logout url generation (ogizanagi)
 * feature #22081 [FrameworkBundle][Validator] Move Validator passes to the component (chalasr)
 * feature #20567 [WebProfilerBundle] Improved cookie traffic (ro0NL)
 * feature #19887 Sort alternatives alphabetically when a command is not found (javiereguiluz)
 * feature #20851 [Cache] Add CacheItem::getPreviousTags() (nicolas-grekas)
 * feature #21830 [HttpFoundation] Add $trustedHeaderSet arg to Request::setTrustedProxies() - deprecate not setting it (nicolas-grekas)
 * feature #21924 [FrameworkBundle] Allow to configure Serializer mapping paths (chalasr)
 * feature #19278 [FrameworkBundle] Added about command (ro0NL)
 * feature #21708 [DI] Add and wire ServiceSubscriberInterface - aka explicit service locators (nicolas-grekas)
 * feature #22011 [FrameworkBundle][Serializer] Add option to register a circular_reference_handler (lyrixx)
 * feature #19673 [DI] Deprecate Container::isFrozen and introduce isCompiled (ro0NL)
 * feature #19954 [Console] Exclude empty namespaces in text descriptor (ro0NL)
 * feature #21093 [Lock] Create a lock component (jderusse)
 * feature #21007 [WebProfilerBundle] Improve AJAX toolbar panel (ro0NL)
 * feature #20642 [FrameworkBundle] Add project directory default for installing assets (Noah Heck)
 * feature #20365 [TwigBridge] Handle form label attributes like others (ro0NL)
 * feature #22010 [FrameworkBundle][Translator] Make the Translator works with any PSR-11 container (chalasr)
 * feature #21038 [FrameworkBundle] deprecated cache:clear with warmup (fabpot)
 * feature #22098 [*Bundle] Add autowiring aliases for common services (nicolas-grekas)
 * feature #22095 [DI] Add logging and better failure recovery to AutowirePass (nicolas-grekas)
 * feature #21889 Deprecate the special SYMFONY__ environment variables (javiereguiluz)
 * feature #22059 [Yaml] deprecate "? " starting unquoted strings (xabbuh)
 * feature #22030 [DI] Remove skipping magic for autowired methods (nicolas-grekas)
 * feature #22024 [DI] Introduce "container.service_locator" tag, replaces ServiceLocatorArgument (nicolas-grekas)
 * feature #21837 [FrameworkBundle] Lazy configuration of annotations' loader and `@required` (nicolas-grekas)
 * feature #21970 [DependencyInjection] Support anonymous services in Yaml (GuilhemN)
 * feature #21979 [FrameworkBundle][TwigBundle] Require PSR-11 container instead of Symfony container (enumag)
 * feature #21935 [FrameworkBundle][Workflow] Add a way to register a guard expression in the configuration (lyrixx)
 * feature #21080 [FrameworkBundle][Monolog] Added a new way to follow logs (lyrixx)
 * feature #21978 [DoctrineBridge][Routing] Require PSR-11 container instead of Symfony container (enumag)
 * feature #21950 [Workflow] Added fluent interface to the DefinitionBuilder (lyrixx)
 * feature #21933 [FrameworkBundle][Workflow] Add a way to enable the AuditTrail Logger (lyrixx)
 * feature #21925 [Workflow] Added the workflow name to all events dispatched (lyrixx)
 * feature #21774 [Yaml] deprecate implicit string casting of mapping keys (xabbuh)
 * feature #21780 [DX] [Form] Add helper method to register form extensions during unit testing (pierredup)
 * feature #21842 [HttpKernel] Allow signing URIs with a custom query string parameter (thewilkybarkid)
 * feature #21705 [Bridge/Monolog] Enhance the Console Handler (lyrixx)
 * feature #21893 Added a castToArray() config helper (javiereguiluz)
 * feature #21421 Use proper error message when session write fails #20807 (digilist)
 * feature #21770 [DI] Allow extensions to create ServiceLocator as services (nicolas-grekas)
 * feature #21767 [DI][Router][DX] Invalidate routing cache when container parameters changed (ogizanagi)
 * feature #21835 [FrameworkBundle][Routing] Move RoutingResolverPass to the Routing component (chalasr)
 * feature #21815 [FrameworkBundle][HttpKernel] Move ControllerArgumentValueResolverPass to the HttpKernel component (chalasr)
 * feature #21824 Add deprecation note on routing class parameters (lepiaf)
 * feature #21854 [Router] Follow symlinks and skip dots in the annotation directory loader (jakzal)
 * feature #18193 [FrameworkBundle] Introduce autowirable ControllerTrait (dunglas)
 * feature #20680 DoctrineDataCollector: taught sanitizeParam to support classes with __toString implemented. (FractalizeR)
 * feature #21828 [PhpUnitBridge] include expected deprecations in assertion counter (xabbuh)
 * feature #21763 [DI] Replace wildcard-based methods autowiring by `@required` annotation (nicolas-grekas)
 * feature #21730 [DependencyInjection] Use a service locator in AddConstraintValidatorsPass (GuilhemN)
 * feature #21118 [Yaml] parse omitted inlined mapping values as null (xabbuh)
 * feature #21806 [FrameworkBundle][PropertyInfo] Move PropertyInfoPass to the PropertyInfo component (chalasr)
 * feature #19822 [HttpKernel] Deprecate X-Status-Code for better alternative (jameshalsall)
 * feature #21228 [Console] Explicitly passed options without value (or empty) should remain empty (chalasr)
 * feature #21723 [Routing][DX] Add full route definition for invokable controller/class (yceruto)
 * feature #21768 [HttpKernel] Add a ContainerControllerResolver (psr-11) (ogizanagi)
 * feature #21690 [Form] allow form types + form type extensions + form type guessers to be private services (hhamon)
 * feature #21755 [Routing] Optimised dumped router matcher, prevent unneeded function calls. (frankdejonge)
 * feature #21375 [FrameworkBundle][Config] Move ConfigCachePass from FrameworkBundle to Config (Deamon)
 * feature #21786 [PhpUnitBridge] testing for deprecations is not risky (xabbuh)
 * feature #21792 [Security] deprecate multiple providers in context listener (xabbuh)
 * feature #21625 Remove some container injections in favor of service locators (nicolas-grekas, chalasr)
 * feature #21539 Introduce weak vendors mode (greg0ire)
 * feature #21638 [VarDumper] Allow seamless use of Data clones (nicolas-grekas)
 * feature #21164 [HttpKernel] Added the SessionValueResolver (iltar)
 * feature #21718 [SecurityBundle] Don't normalize username of in-memory users (chalasr)
 * feature #20107 Added a build method to the kernel to replace Bundle::build() (iltar)
 * feature #21694 [Bridge/PhpUnit] Add PHPUnit 6 support (nicolas-grekas)
 * feature #21122 [ExpressionLanguage] Create an ExpressionFunction from a PHP function name (maidmaid)
 * feature #21653 [VarDumper] Added a way to print or not comma separator and/or trailing comma (lyrixx)
 * feature #21471 [Yaml] Allow dumping empty array as YAML sequence (c960657)
 * feature #21478 [Asset] Add support for preloading with links and HTTP/2 push (dunglas)
 * feature #20632 [FrameworkBundle] Make use of stderr for non reliable output (chalasr, ogizanagi)
 * feature #21664 [Console] simplify the implementation of SymfonyStyle::comment() (fabpot)
 * feature #21578 [Translation] Added a lint:xliff command for XLIFF files (javiereguiluz)
 * feature #21635 added support for glob loaders in Config (fabpot)
 * feature #21654 [PropertyInfo] Use iterators for PropertyInfoExtractor (GuilhemN)
 * feature #21655 [PropertyInfo] Make classes final (GuilhemN)
 * feature #21530 [DependencyInjection] Add "instanceof" section for local interface-defined configs (nicolas-grekas, dunglas)
 * feature #21643 [Yaml] deprecate parsing mappings without keys (xabbuh)
 * feature #20677 [DX][SecurityBundle] UserPasswordEncoderCommand: ask user class choice question (ogizanagi)
 * feature #21283 [Form][FrameworkBundle] Move FormPass to the Form component (chalasr)
 * feature #21293 [FrameworkBundle][Serializer] Move SerializerPass to the Serializer (chalasr)
 * feature #21450 [Security] Lazy load guard authenticators and authentication providers (chalasr)
 * feature #21484 [DI] Deprecate underscore-services in YamlFileLoader (nicolas-grekas)
 * feature #21270 [DependencyInjection] Use glob pattern to load config files (pierredup)
 * feature #19815 [WebProfilerBundle] Make the IP address in the profiler header clickable (jameshalsall)
 * feature #21383 [DependencyInjection] Add support for named arguments (dunglas, nicolas-grekas)
 * feature #19371 [Serializer] Give access to the context to support* methods (dunglas)
 * feature #21553 [DI] Replace container injection by explicit service locators (chalasr)
 * feature #18834 [Serializer] Add the possibility to filter attributes (dunglas)
 * feature #20787 [Workflow] Added an entered event (Padam87)
 * feature #21289 [DI] Add prototype services for PSR4-based discovery and registration (nicolas-grekas)
 * feature #21465 [Debug] Support `@final` on methods (GuilhemN)
 * feature #21505 [Config][DI] Add ComposerResource to track the runtime engine + deps (nicolas-grekas)
 * feature #21533 [DI] Deprecate (un)setting pre-defined services (ro0NL)
 * feature #21194 [Yaml] Add tags support (GuilhemN)
 * feature #21460 [DI] ContainerBuilder::compile() can optionally resolve env vars in parameter bag (nicolas-grekas)
 * feature #21572 [Finder] Add double-star matching to Glob::toRegex() (nicolas-grekas)
 * feature #21265 [DI] Implement PSR-11 (greg0ire)
 * feature #21474 [Process] Accept command line arrays and per-run env vars, fixing signaling and escaping (nicolas-grekas)
 * feature #21517 [FrameworkBundle] Add missing autowiring aliases for common interfaces (chalasr)
 * feature #21516 [HttpKernel][FrameworkBundle] Lazy load argument value resolvers (chalasr)
 * feature #21031 [DI] Getter autowiring (dunglas)
 * feature #21419 [DI][Config] Add & use ReflectionClassResource (nicolas-grekas)
 * feature #21455 [DI] Allow to count on lazy collection arguments (ogizanagi)
 * feature #21408 [DI] Add ContainerBuilder::fileExists() for checking/tracking resource existence (chalasr)
 * feature #21470 [Process] Deprecate not inheriting env vars + compat related settings (nicolas-grekas)
 * feature #21494 [DI] Deprecate autowiring-types in favor of aliases (nicolas-grekas)
 * feature #21451 [SecurityBundle] Lazy load request matchers in FirewallMap (chalasr)
 * feature #20973 [DI] Add getter injection (nicolas-grekas)
 * feature #21396 [DI] Enhance logging in compiler passes (nicolas-grekas)
 * feature #21402 [Security] make LdapBindAuthenticationProvider capable of searching for the DN (lsmith77, nietonfir)
 * feature #21404 [DI] Generalize constructor autowiring to partial method calls (nicolas-grekas)
 * feature #21388 [Debug] Deprecate ContextErrorException (nicolas-grekas)
 * feature #20943 [DependencyInjection] Use current class as default class for factory declarations (ogizanagi)
 * feature #21003 [Console][FrameworkBundle] Log console exceptions (jameshalsall, chalasr)
 * feature #21313 [DI] Add Yaml syntax for short services definition (ogizanagi)
 * feature #20694 [Cache] Implement PSR-16 SimpleCache v1.0 (nicolas-grekas)
 * feature #21327 [DI] Factorize compiler passes around new AbstractRecursivePass (nicolas-grekas)
 * feature #19086 [FrameworkBundle] add "mapping" configuration key at validation secti… (davewwww)
 * feature #21350 [Yaml] Remove internal arguments from the api (GuilhemN)
 * feature #21353 [ClassLoader] Deprecated the component (nicolas-grekas)
 * feature #21334  [Workflow] Introduce concept of SupportStrategyInterface (andesk, lyrixx)
 * feature #20390 [Ldap] added Ldap entry rename for ExtLdap adapter (fruitwasp)
 * feature #21065 Added cache data collector and profiler page (Nyholm)
 * feature #21306 [DependencyInjection] Always autowire the constructor (dunglas)
 * feature #20493 [Debug] Trigger deprecation on `@final` annotation in DebugClassLoader - prepare making some classes final (GuilhemN)
 * feature #21244 [DI] Remove synthetic services from methodMap + generated methods (nicolas-grekas)
 * feature #21238 [VarDumper] Add search keyboard shortcuts (ogizanagi)
 * feature #21290 [FrameworkBundle] Fix debug:container --show-arguments missing cases (chalasr)
 * feature #21263 [DI] Mark generated containers as final (nicolas-grekas)
 * feature #21253 [TwigBridge][Worklow] Added a new workflow_has_place function (Padam87, lyrixx)
 * feature #21234 Add a new Dotenv component (fabpot)
 * feature #20861 Add a --show-arguments flag to the debug:container command (Cydonia7)
 * feature #21223 [DI] Deprecate case insentivity of service identifiers (nicolas-grekas)
 * feature #20887 [Form] DateIntervalType: Allow to configure labels & enhance form theme (ogizanagi)
 * feature #19443 [Console] Move AddConsoleCommandPass from FrameworkBundle to Console. (bcremer)
 * feature #21231 [FrameworkBundle] allow to reference files directly from kernel.root_dir (fabpot)
 * feature #20611 [DI] FileLoaders: Allow to explicit type to load (ogizanagi)
 * feature #20689 [Config][FrameworkBundle] Allow to dump extension config reference sub-path (ogizanagi)
 * feature #21188 [HttpFoundation] Add File\Stream for size-unknown BinaryFileResponse (nicolas-grekas)
 * feature #21214 [DI] Allow ~ instead of {} for services in Yaml (wouterj)
 * feature #20612 [Filesystem] Add appendToFile() (chalasr)
 * feature #20612 [Filesystem] Add appendToFile() (chalasr)
 * feature #21114 [Yaml] parse multi-line strings (xabbuh)
 * feature #21196 [FrameworkBundle] changed some default configs from canBeEnabled to canBeDisabled (fabpot)
 * feature #20937 [EventDispatcher] Deprecate ContainerAwareEventDispatcher (nicolas-grekas)
 * feature #21190 [WebServerBundle] Decouple server commands from the container (chalasr)
 * feature #21071 [DI] Add "inherit-tags" with configurable defaults + same for "public", "tags" & "autowire" (nicolas-grekas, ogizanagi)
 * feature #21133 [DI] Optional class for named services (hason, nicolas-grekas)
 * feature #20953 [DI][EventDispatcher] Add & wire closure-proxy argument type (nicolas-grekas)
 * feature #20586 [Console] Ease writing to stderr using SymfonyStyle (chalasr)
 * feature #20547 [FrameworkBundle] Allowed symlinks when searching for translation, searialization and validation files (tifabien)
 * feature #20735 Deprecate ClassCollectionLoader and Kernel::loadClassCache (dbrumann)
 * feature #21140 [PhpUnitBridge] deprecate the testLegacy test name prefix (xabbuh)
 * feature #21109 [Profiler][VarDumper] Add a search feature to the HtmlDumper (ogizanagi)
 * feature #21039 Web server bundle (fabpot)
 * feature #20907 [DependencyInjection] Implement lazy collection type using generators (tgalopin, nicolas-grekas)
 * feature #21075 [Console] Show hidden commands in json & xml descriptors (ogizanagi)
 * feature #21129 [FrameworkBundle] Display original definition for aliases in debug:container (chalasr)
 * feature #21108 [Cache] Add DSN, createClient & better error reporting to MemcachedAdapter (nicolas-grekas, robfrawley)
 * feature #21147 [PhpUnitBridger] Bump simple-phpunit to PHPUnit 5.7 by default (nicolas-grekas)
 * feature #21112 [PhpUnitBridge] run PHPUnit in the same process (xabbuh)
 * feature #21106 [Validator] support DateTimeInterface instances for times (xabbuh)
 * feature #20809 [FrameworkBundle] Display the controller class name in 'debug:router' (lyrixx)
 * feature #21082 [Cache] TraceableAdapter (Nyholm)
 * feature #20938 [DI] Prepare dropping "strict" handling in loaders (nicolas-grekas)
 * feature #20971 [WebProfilerBundle] Split PHP version if needed (ro0NL)
 * feature #20634 [DI] Deprecate dumping an uncompiled container (ro0NL)
 * feature #20923 #20921 [Config] Provide shorthand methods for ArrayNodeDefinition::pr… (skafandri)
 * feature #20569 [HttpFoundation] Create cookie from string + synchronize response cookies (ro0NL)
 * feature #20618 [DI] Make ContainerBuilder::resolveEnvPlaceholders() able to inline the values of referenced env vars. (nicolas-grekas)
 * feature #20962 Request exceptions (thewilkybarkid, fabpot)
 * feature #20928 [FrameworkBundle] don't load translator services if not required (xabbuh)
 * feature #20644 [HttpFoundation] Compute cookie max-age attribute (ro0NL)
 * feature #20167 [DependencyInjection] Make method (setter) autowiring configurable (dunglas)
 * feature #20663 [DependencyInjection] replace DefinitionDecorator by ChildDefinition (xabbuh)
 * feature #20197 [WebProfilerBundle] Improve Ajax Profiling Performance (javascript) (patrick-mcdougle)
 * feature #20487 [Console] Disallow inheritance from ProgressBar (a-ast)
 * feature #20651 [DependencyInjection] Added Yaml syntax shortcut for name-only tags (wouterj)
 * feature #20648 [DependencyInjection] Added a shortcut method for autowired definitions (wouterj)
 * feature #20697 Updated the "PHP config" panel in the profiler (javiereguiluz)
 * feature #20773 [FrameworkBundle] Added GlobalVariables::getToken() (HeahDude)
 * feature #20866 [Console] Improve markdown format (ro0NL)
 * feature #20867 [Console] Include application name/version in JSON descriptions (ro0NL)
 * feature #20869 [Console] Improve UX on not found namespace/command (Seldaek)
 * feature #20858 [Cache] Simple Memcached Adapter (robfrawley)
 * feature #20881 [VarDumper] Add SymfonyCaster::castRequest() (nicolas-grekas)
 * feature #20810 [FrameworkBundle] Allow clearing private cache pools in cache:pool:clear (chalasr)
 * feature #20417 [SecurityBundle] Rename FirewallContext#getContext() (chalasr)
 * feature #20801 [Security] deprecate the RoleInterface (xabbuh)
 * feature #20260 [DependencyInjection] Support autowiring for EventDispatcher/EventDispatcherInterface (chalasr)
 * feature #20777 [ClassLoader] Deprecate Apc/WinCache/Xcache class loaders (nicolas-grekas)
 * feature #20524 [Serializer][XmlEncoder] Allow removing empty tags in generated XML (amoiraud)
 * feature #19958 [Serializer] Throw exception when extra attributes are used during an object denor… (juliendidier)
 * feature #20310 [Ldap] Allow search scoping (xunto)
 * feature #18952 [Security] Add a JSON authentication listener (dunglas)
 * feature #20161 add toolbar & profiler SVG style classes (havvg)
 * feature #20467 [DomCrawler] Add support for formaction and formmethod attributes (stof)
 * feature #20509 [Serializer] Allow to specify a single value in @Groups (dunglas)
 * feature #20722 Updated the "Symfony Config" panel in the profiler (javiereguiluz)

