# -*- coding: utf-8 -*-

import os

from configobj import ConfigObj

config_files = [ os.path.join('/', 'etc', 'tails-installer', f )
                 for f in [ 'defaults.ini', 'vendor.ini', 'site.ini' ] ]

# XXX: move defaults to a proper defaults.ini file?
default_config = {
    'min_system_partition_size': 2500, # MiB
    'min_persistence_partition_size': 1000, # MiB
    'main_liveos_dir': 'live',
    'running_liveos_mountpoint': '/lib/live/mount/medium',
    'tails_vendor_path': '/etc/dpkg/origins/Tails',
    'liveos_toplevel_files': [ 'autorun.bat', 'autorun.inf', 'boot', '.disk',
                               'doc', 'EFI', 'live', 'isolinux', 'syslinux',
                               'tmp', 'utils' ],
    'download': { 'enabled': False,
                },
    'persistence': { 'enabled': False,
                },
    'branding': { 'distribution': 'Tails',
                  'header': 'tails-liveusb-header.png',
                  'color': '#56347c',
                  'partition_label': 'Tails',
                },
}

config = ConfigObj(default_config)

for f in config_files:
    config.merge(ConfigObj(f))
