
# This file is automatically generated by ucm2tests.tcl.
# Edits will be overwritten on next generation.
#
# Tests comparing Tcl encodings to ICU.
# This file is NOT standalone. It should be sourced into a test script.

proc ucmConvertfromMismatches {enc map} {
    set mismatches {}
    foreach {unihex hex} $map {
        set unihex [string range 00000000$unihex end-7 end]; # Make 8 digits
        set unich [subst "\\U$unihex"]
        if {[encoding convertfrom -profile strict $enc [binary decode hex $hex]] ne $unich} {
            lappend mismatches "<[printable $unich],$hex>"
        }
    }
    return $mismatches
}
proc ucmConverttoMismatches {enc map} {
    set mismatches {}
    foreach {unihex hex} $map {
        set unihex [string range 00000000$unihex end-7 end]; # Make 8 digits
        set unich [subst "\\U$unihex"]
        if {[encoding convertto -profile strict $enc $unich] ne [binary decode hex $hex]} {
            lappend mismatches "<[printable $unich],$hex>"
        }
    }
    return $mismatches
}
if {[info commands printable] eq ""} {
    proc printable {s} {
        set print ""
        foreach c [split $s ""] {
            set i [scan $c %c]
            if {[string is print $c] && ($i <= 127)} {
                append print $c
            } elseif {$i <= 0xff} {
                append print \\x[format %02X $i]
            } elseif {$i <= 0xffff} {
                append print \\u[format %04X $i]
            } else {
                append print \\U[format %08X $i]
            }
        }
        return $print
    }
}


#
# cp1250 (generated from glibc-CP1250-2.1.2)

test encoding-convertfrom-ucmCompare-cp1250 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1250 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A4 A4 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00BB BB 00C1 C1 00C2 C2 00C4 C4 00C7 C7 00C9 C9 00CB CB 00CD CD 00CE CE 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00DA DA 00DC DC 00DD DD 00DF DF 00E1 E1 00E2 E2 00E4 E4 00E7 E7 00E9 E9 00EB EB 00ED ED 00EE EE 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00FA FA 00FC FC 00FD FD 0102 C3 0103 E3 0104 A5 0105 B9 0106 C6 0107 E6 010C C8 010D E8 010E CF 010F EF 0110 D0 0111 F0 0118 CA 0119 EA 011A CC 011B EC 0139 C5 013A E5 013D BC 013E BE 0141 A3 0142 B3 0143 D1 0144 F1 0147 D2 0148 F2 0150 D5 0151 F5 0154 C0 0155 E0 0158 D8 0159 F8 015A 8C 015B 9C 015E AA 015F BA 0160 8A 0161 9A 0162 DE 0163 FE 0164 8D 0165 9D 016E D9 016F F9 0170 DB 0171 FB 0179 8F 017A 9F 017B AF 017C BF 017D 8E 017E 9E 02C7 A1 02D8 A2 02D9 FF 02DB B2 02DD BD 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1250 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1250 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A4 A4 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00BB BB 00C1 C1 00C2 C2 00C4 C4 00C7 C7 00C9 C9 00CB CB 00CD CD 00CE CE 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00DA DA 00DC DC 00DD DD 00DF DF 00E1 E1 00E2 E2 00E4 E4 00E7 E7 00E9 E9 00EB EB 00ED ED 00EE EE 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00FA FA 00FC FC 00FD FD 0102 C3 0103 E3 0104 A5 0105 B9 0106 C6 0107 E6 010C C8 010D E8 010E CF 010F EF 0110 D0 0111 F0 0118 CA 0119 EA 011A CC 011B EC 0139 C5 013A E5 013D BC 013E BE 0141 A3 0142 B3 0143 D1 0144 F1 0147 D2 0148 F2 0150 D5 0151 F5 0154 C0 0155 E0 0158 D8 0159 F8 015A 8C 015B 9C 015E AA 015F BA 0160 8A 0161 9A 0162 DE 0163 FE 0164 8D 0165 9D 016E D9 016F F9 0170 DB 0171 FB 0179 8F 017A 9F 017B AF 017C BF 017D 8E 017E 9E 02C7 A1 02D8 A2 02D9 FF 02DB B2 02DD BD 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

# cp1250 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1250 81 tcl8    \U00000081 -1 {} {}
    cp1250 81 replace \uFFFD -1 {} {}
    cp1250 81 strict  {}       0 {} {}
    cp1250 83 tcl8    \U00000083 -1 {} {}
    cp1250 83 replace \uFFFD -1 {} {}
    cp1250 83 strict  {}       0 {} {}
    cp1250 88 tcl8    \U00000088 -1 {} {}
    cp1250 88 replace \uFFFD -1 {} {}
    cp1250 88 strict  {}       0 {} {}
    cp1250 90 tcl8    \U00000090 -1 {} {}
    cp1250 90 replace \uFFFD -1 {} {}
    cp1250 90 strict  {}       0 {} {}
    cp1250 98 tcl8    \U00000098 -1 {} {}
    cp1250 98 replace \uFFFD -1 {} {}
    cp1250 98 strict  {}       0 {} {}
}; # cp1250

# cp1250 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1250 \U00000080 tcl8    1A -1 {} {}
    cp1250 \U00000080 replace 1A -1 {} {}
    cp1250 \U00000080 strict  {}                      0 {} {}
    cp1250 \U00000400 tcl8    1A -1 {} {}
    cp1250 \U00000400 replace 1A -1 {} {}
    cp1250 \U00000400 strict  {}                      0 {} {}
    cp1250 \U0000D800 tcl8    1A -1 {} {}
    cp1250 \U0000D800 replace 1A -1 {} {}
    cp1250 \U0000D800 strict  {}                      0 {} {}
    cp1250 \U0000DC00 tcl8    1A -1 {} {}
    cp1250 \U0000DC00 replace 1A -1 {} {}
    cp1250 \U0000DC00 strict  {}                      0 {} {}
    cp1250 \U00010000 tcl8    1A -1 {} {}
    cp1250 \U00010000 replace 1A -1 {} {}
    cp1250 \U00010000 strict  {}                      0 {} {}
    cp1250 \U0010FFFF tcl8    1A -1 {} {}
    cp1250 \U0010FFFF replace 1A -1 {} {}
    cp1250 \U0010FFFF strict  {}                      0 {} {}
}; # cp1250

#
# cp1251 (generated from glibc-CP1251-2.1.2)

test encoding-convertfrom-ucmCompare-cp1251 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1251 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A4 A4 00A6 A6 00A7 A7 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B5 B5 00B6 B6 00B7 B7 00BB BB 0401 A8 0402 80 0403 81 0404 AA 0405 BD 0406 B2 0407 AF 0408 A3 0409 8A 040A 8C 040B 8E 040C 8D 040E A1 040F 8F 0410 C0 0411 C1 0412 C2 0413 C3 0414 C4 0415 C5 0416 C6 0417 C7 0418 C8 0419 C9 041A CA 041B CB 041C CC 041D CD 041E CE 041F CF 0420 D0 0421 D1 0422 D2 0423 D3 0424 D4 0425 D5 0426 D6 0427 D7 0428 D8 0429 D9 042A DA 042B DB 042C DC 042D DD 042E DE 042F DF 0430 E0 0431 E1 0432 E2 0433 E3 0434 E4 0435 E5 0436 E6 0437 E7 0438 E8 0439 E9 043A EA 043B EB 043C EC 043D ED 043E EE 043F EF 0440 F0 0441 F1 0442 F2 0443 F3 0444 F4 0445 F5 0446 F6 0447 F7 0448 F8 0449 F9 044A FA 044B FB 044C FC 044D FD 044E FE 044F FF 0451 B8 0452 90 0453 83 0454 BA 0455 BE 0456 B3 0457 BF 0458 BC 0459 9A 045A 9C 045B 9E 045C 9D 045E A2 045F 9F 0490 A5 0491 B4 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 88 2116 B9 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1251 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1251 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A4 A4 00A6 A6 00A7 A7 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B5 B5 00B6 B6 00B7 B7 00BB BB 0401 A8 0402 80 0403 81 0404 AA 0405 BD 0406 B2 0407 AF 0408 A3 0409 8A 040A 8C 040B 8E 040C 8D 040E A1 040F 8F 0410 C0 0411 C1 0412 C2 0413 C3 0414 C4 0415 C5 0416 C6 0417 C7 0418 C8 0419 C9 041A CA 041B CB 041C CC 041D CD 041E CE 041F CF 0420 D0 0421 D1 0422 D2 0423 D3 0424 D4 0425 D5 0426 D6 0427 D7 0428 D8 0429 D9 042A DA 042B DB 042C DC 042D DD 042E DE 042F DF 0430 E0 0431 E1 0432 E2 0433 E3 0434 E4 0435 E5 0436 E6 0437 E7 0438 E8 0439 E9 043A EA 043B EB 043C EC 043D ED 043E EE 043F EF 0440 F0 0441 F1 0442 F2 0443 F3 0444 F4 0445 F5 0446 F6 0447 F7 0448 F8 0449 F9 044A FA 044B FB 044C FC 044D FD 044E FE 044F FF 0451 B8 0452 90 0453 83 0454 BA 0455 BE 0456 B3 0457 BF 0458 BC 0459 9A 045A 9C 045B 9E 045C 9D 045E A2 045F 9F 0490 A5 0491 B4 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 88 2116 B9 2122 99}
} -result {}

# cp1251 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1251 98 tcl8    \U00000098 -1 {} {}
    cp1251 98 replace \uFFFD -1 {} {}
    cp1251 98 strict  {}       0 {} {}
}; # cp1251

# cp1251 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1251 \U00000080 tcl8    1A -1 {} {}
    cp1251 \U00000080 replace 1A -1 {} {}
    cp1251 \U00000080 strict  {}                      0 {} {}
    cp1251 \U00000400 tcl8    1A -1 {} {}
    cp1251 \U00000400 replace 1A -1 {} {}
    cp1251 \U00000400 strict  {}                      0 {} {}
    cp1251 \U0000D800 tcl8    1A -1 {} {}
    cp1251 \U0000D800 replace 1A -1 {} {}
    cp1251 \U0000D800 strict  {}                      0 {} {}
    cp1251 \U0000DC00 tcl8    1A -1 {} {}
    cp1251 \U0000DC00 replace 1A -1 {} {}
    cp1251 \U0000DC00 strict  {}                      0 {} {}
    cp1251 \U00010000 tcl8    1A -1 {} {}
    cp1251 \U00010000 replace 1A -1 {} {}
    cp1251 \U00010000 strict  {}                      0 {} {}
    cp1251 \U0010FFFF tcl8    1A -1 {} {}
    cp1251 \U0010FFFF replace 1A -1 {} {}
    cp1251 \U0010FFFF strict  {}                      0 {} {}
}; # cp1251

#
# cp1252 (generated from glibc-CP1252-2.1.2)

test encoding-convertfrom-ucmCompare-cp1252 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1252 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D0 D0 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F0 F0 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 00FF FF 0152 8C 0153 9C 0160 8A 0161 9A 0178 9F 017D 8E 017E 9E 0192 83 02C6 88 02DC 98 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1252 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1252 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D0 D0 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F0 F0 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 00FF FF 0152 8C 0153 9C 0160 8A 0161 9A 0178 9F 017D 8E 017E 9E 0192 83 02C6 88 02DC 98 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

# cp1252 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1252 81 tcl8    \U00000081 -1 {} {}
    cp1252 81 replace \uFFFD -1 {} {}
    cp1252 81 strict  {}       0 {} {}
    cp1252 8D tcl8    \U0000008D -1 {} {}
    cp1252 8D replace \uFFFD -1 {} {}
    cp1252 8D strict  {}       0 {} {}
    cp1252 8F tcl8    \U0000008F -1 {} {}
    cp1252 8F replace \uFFFD -1 {} {}
    cp1252 8F strict  {}       0 {} {}
    cp1252 90 tcl8    \U00000090 -1 {} {}
    cp1252 90 replace \uFFFD -1 {} {}
    cp1252 90 strict  {}       0 {} {}
    cp1252 9D tcl8    \U0000009D -1 {} {}
    cp1252 9D replace \uFFFD -1 {} {}
    cp1252 9D strict  {}       0 {} {}
}; # cp1252

# cp1252 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1252 \U00000080 tcl8    1A -1 {} {}
    cp1252 \U00000080 replace 1A -1 {} {}
    cp1252 \U00000080 strict  {}                      0 {} {}
    cp1252 \U00000400 tcl8    1A -1 {} {}
    cp1252 \U00000400 replace 1A -1 {} {}
    cp1252 \U00000400 strict  {}                      0 {} {}
    cp1252 \U0000D800 tcl8    1A -1 {} {}
    cp1252 \U0000D800 replace 1A -1 {} {}
    cp1252 \U0000D800 strict  {}                      0 {} {}
    cp1252 \U0000DC00 tcl8    1A -1 {} {}
    cp1252 \U0000DC00 replace 1A -1 {} {}
    cp1252 \U0000DC00 strict  {}                      0 {} {}
    cp1252 \U00010000 tcl8    1A -1 {} {}
    cp1252 \U00010000 replace 1A -1 {} {}
    cp1252 \U00010000 strict  {}                      0 {} {}
    cp1252 \U0010FFFF tcl8    1A -1 {} {}
    cp1252 \U0010FFFF replace 1A -1 {} {}
    cp1252 \U0010FFFF strict  {}                      0 {} {}
}; # cp1252

#
# cp1253 (generated from glibc-CP1253-2.1.2)

test encoding-convertfrom-ucmCompare-cp1253 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1253 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B5 B5 00B6 B6 00B7 B7 00BB BB 00BD BD 0192 83 0384 B4 0385 A1 0386 A2 0388 B8 0389 B9 038A BA 038C BC 038E BE 038F BF 0390 C0 0391 C1 0392 C2 0393 C3 0394 C4 0395 C5 0396 C6 0397 C7 0398 C8 0399 C9 039A CA 039B CB 039C CC 039D CD 039E CE 039F CF 03A0 D0 03A1 D1 03A3 D3 03A4 D4 03A5 D5 03A6 D6 03A7 D7 03A8 D8 03A9 D9 03AA DA 03AB DB 03AC DC 03AD DD 03AE DE 03AF DF 03B0 E0 03B1 E1 03B2 E2 03B3 E3 03B4 E4 03B5 E5 03B6 E6 03B7 E7 03B8 E8 03B9 E9 03BA EA 03BB EB 03BC EC 03BD ED 03BE EE 03BF EF 03C0 F0 03C1 F1 03C2 F2 03C3 F3 03C4 F4 03C5 F5 03C6 F6 03C7 F7 03C8 F8 03C9 F9 03CA FA 03CB FB 03CC FC 03CD FD 03CE FE 2013 96 2014 97 2015 AF 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1253 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1253 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B5 B5 00B6 B6 00B7 B7 00BB BB 00BD BD 0192 83 0384 B4 0385 A1 0386 A2 0388 B8 0389 B9 038A BA 038C BC 038E BE 038F BF 0390 C0 0391 C1 0392 C2 0393 C3 0394 C4 0395 C5 0396 C6 0397 C7 0398 C8 0399 C9 039A CA 039B CB 039C CC 039D CD 039E CE 039F CF 03A0 D0 03A1 D1 03A3 D3 03A4 D4 03A5 D5 03A6 D6 03A7 D7 03A8 D8 03A9 D9 03AA DA 03AB DB 03AC DC 03AD DD 03AE DE 03AF DF 03B0 E0 03B1 E1 03B2 E2 03B3 E3 03B4 E4 03B5 E5 03B6 E6 03B7 E7 03B8 E8 03B9 E9 03BA EA 03BB EB 03BC EC 03BD ED 03BE EE 03BF EF 03C0 F0 03C1 F1 03C2 F2 03C3 F3 03C4 F4 03C5 F5 03C6 F6 03C7 F7 03C8 F8 03C9 F9 03CA FA 03CB FB 03CC FC 03CD FD 03CE FE 2013 96 2014 97 2015 AF 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

# cp1253 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1253 81 tcl8    \U00000081 -1 {} {}
    cp1253 81 replace \uFFFD -1 {} {}
    cp1253 81 strict  {}       0 {} {}
    cp1253 88 tcl8    \U00000088 -1 {} {}
    cp1253 88 replace \uFFFD -1 {} {}
    cp1253 88 strict  {}       0 {} {}
    cp1253 8A tcl8    \U0000008A -1 {} {}
    cp1253 8A replace \uFFFD -1 {} {}
    cp1253 8A strict  {}       0 {} {}
    cp1253 8C tcl8    \U0000008C -1 {} {}
    cp1253 8C replace \uFFFD -1 {} {}
    cp1253 8C strict  {}       0 {} {}
    cp1253 8D tcl8    \U0000008D -1 {} {}
    cp1253 8D replace \uFFFD -1 {} {}
    cp1253 8D strict  {}       0 {} {}
    cp1253 8E tcl8    \U0000008E -1 {} {}
    cp1253 8E replace \uFFFD -1 {} {}
    cp1253 8E strict  {}       0 {} {}
    cp1253 8F tcl8    \U0000008F -1 {} {}
    cp1253 8F replace \uFFFD -1 {} {}
    cp1253 8F strict  {}       0 {} {}
    cp1253 90 tcl8    \U00000090 -1 {} {}
    cp1253 90 replace \uFFFD -1 {} {}
    cp1253 90 strict  {}       0 {} {}
    cp1253 98 tcl8    \U00000098 -1 {} {}
    cp1253 98 replace \uFFFD -1 {} {}
    cp1253 98 strict  {}       0 {} {}
    cp1253 9A tcl8    \U0000009A -1 {} {}
    cp1253 9A replace \uFFFD -1 {} {}
    cp1253 9A strict  {}       0 {} {}
    cp1253 9C tcl8    \U0000009C -1 {} {}
    cp1253 9C replace \uFFFD -1 {} {}
    cp1253 9C strict  {}       0 {} {}
    cp1253 9D tcl8    \U0000009D -1 {} {}
    cp1253 9D replace \uFFFD -1 {} {}
    cp1253 9D strict  {}       0 {} {}
    cp1253 9E tcl8    \U0000009E -1 {} {}
    cp1253 9E replace \uFFFD -1 {} {}
    cp1253 9E strict  {}       0 {} {}
    cp1253 9F tcl8    \U0000009F -1 {} {}
    cp1253 9F replace \uFFFD -1 {} {}
    cp1253 9F strict  {}       0 {} {}
    cp1253 AA tcl8    \U000000AA -1 {} {}
    cp1253 AA replace \uFFFD -1 {} {}
    cp1253 AA strict  {}       0 {} {}
    cp1253 D2 tcl8    \U000000D2 -1 {} {}
    cp1253 D2 replace \uFFFD -1 {} {}
    cp1253 D2 strict  {}       0 {} {}
    cp1253 FF tcl8    \U000000FF -1 {} {}
    cp1253 FF replace \uFFFD -1 {} {}
    cp1253 FF strict  {}       0 {} {}
}; # cp1253

# cp1253 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1253 \U00000080 tcl8    1A -1 {} {}
    cp1253 \U00000080 replace 1A -1 {} {}
    cp1253 \U00000080 strict  {}                      0 {} {}
    cp1253 \U00000400 tcl8    1A -1 {} {}
    cp1253 \U00000400 replace 1A -1 {} {}
    cp1253 \U00000400 strict  {}                      0 {} {}
    cp1253 \U0000D800 tcl8    1A -1 {} {}
    cp1253 \U0000D800 replace 1A -1 {} {}
    cp1253 \U0000D800 strict  {}                      0 {} {}
    cp1253 \U0000DC00 tcl8    1A -1 {} {}
    cp1253 \U0000DC00 replace 1A -1 {} {}
    cp1253 \U0000DC00 strict  {}                      0 {} {}
    cp1253 \U00010000 tcl8    1A -1 {} {}
    cp1253 \U00010000 replace 1A -1 {} {}
    cp1253 \U00010000 strict  {}                      0 {} {}
    cp1253 \U0010FFFF tcl8    1A -1 {} {}
    cp1253 \U0010FFFF replace 1A -1 {} {}
    cp1253 \U0010FFFF strict  {}                      0 {} {}
}; # cp1253

#
# cp1254 (generated from glibc-CP1254-2.1.2)

test encoding-convertfrom-ucmCompare-cp1254 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1254 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 011E D0 011F F0 0130 DD 0131 FD 0152 8C 0153 9C 015E DE 015F FE 0160 8A 0161 9A 0178 9F 0192 83 02C6 88 02DC 98 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1254 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1254 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 011E D0 011F F0 0130 DD 0131 FD 0152 8C 0153 9C 015E DE 015F FE 0160 8A 0161 9A 0178 9F 0192 83 02C6 88 02DC 98 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

# cp1254 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1254 81 tcl8    \U00000081 -1 {} {}
    cp1254 81 replace \uFFFD -1 {} {}
    cp1254 81 strict  {}       0 {} {}
    cp1254 8D tcl8    \U0000008D -1 {} {}
    cp1254 8D replace \uFFFD -1 {} {}
    cp1254 8D strict  {}       0 {} {}
    cp1254 8E tcl8    \U0000008E -1 {} {}
    cp1254 8E replace \uFFFD -1 {} {}
    cp1254 8E strict  {}       0 {} {}
    cp1254 8F tcl8    \U0000008F -1 {} {}
    cp1254 8F replace \uFFFD -1 {} {}
    cp1254 8F strict  {}       0 {} {}
    cp1254 90 tcl8    \U00000090 -1 {} {}
    cp1254 90 replace \uFFFD -1 {} {}
    cp1254 90 strict  {}       0 {} {}
    cp1254 9D tcl8    \U0000009D -1 {} {}
    cp1254 9D replace \uFFFD -1 {} {}
    cp1254 9D strict  {}       0 {} {}
    cp1254 9E tcl8    \U0000009E -1 {} {}
    cp1254 9E replace \uFFFD -1 {} {}
    cp1254 9E strict  {}       0 {} {}
}; # cp1254

# cp1254 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1254 \U00000080 tcl8    1A -1 {} {}
    cp1254 \U00000080 replace 1A -1 {} {}
    cp1254 \U00000080 strict  {}                      0 {} {}
    cp1254 \U00000400 tcl8    1A -1 {} {}
    cp1254 \U00000400 replace 1A -1 {} {}
    cp1254 \U00000400 strict  {}                      0 {} {}
    cp1254 \U0000D800 tcl8    1A -1 {} {}
    cp1254 \U0000D800 replace 1A -1 {} {}
    cp1254 \U0000D800 strict  {}                      0 {} {}
    cp1254 \U0000DC00 tcl8    1A -1 {} {}
    cp1254 \U0000DC00 replace 1A -1 {} {}
    cp1254 \U0000DC00 strict  {}                      0 {} {}
    cp1254 \U00010000 tcl8    1A -1 {} {}
    cp1254 \U00010000 replace 1A -1 {} {}
    cp1254 \U00010000 strict  {}                      0 {} {}
    cp1254 \U0010FFFF tcl8    1A -1 {} {}
    cp1254 \U0010FFFF replace 1A -1 {} {}
    cp1254 \U0010FFFF strict  {}                      0 {} {}
}; # cp1254

#
# cp1255 (generated from glibc-CP1255-2.1.2)

test encoding-convertfrom-ucmCompare-cp1255 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1255 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00D7 AA 00F7 BA 0192 83 02C6 88 02DC 98 05B0 C0 05B1 C1 05B2 C2 05B3 C3 05B4 C4 05B5 C5 05B6 C6 05B7 C7 05B8 C8 05B9 C9 05BB CB 05BC CC 05BD CD 05BE CE 05BF CF 05C0 D0 05C1 D1 05C2 D2 05C3 D3 05D0 E0 05D1 E1 05D2 E2 05D3 E3 05D4 E4 05D5 E5 05D6 E6 05D7 E7 05D8 E8 05D9 E9 05DA EA 05DB EB 05DC EC 05DD ED 05DE EE 05DF EF 05E0 F0 05E1 F1 05E2 F2 05E3 F3 05E4 F4 05E5 F5 05E6 F6 05E7 F7 05E8 F8 05E9 F9 05EA FA 05F0 D4 05F1 D5 05F2 D6 05F3 D7 05F4 D8 200E FD 200F FE 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AA A4 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1255 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1255 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00D7 AA 00F7 BA 0192 83 02C6 88 02DC 98 05B0 C0 05B1 C1 05B2 C2 05B3 C3 05B4 C4 05B5 C5 05B6 C6 05B7 C7 05B8 C8 05B9 C9 05BB CB 05BC CC 05BD CD 05BE CE 05BF CF 05C0 D0 05C1 D1 05C2 D2 05C3 D3 05D0 E0 05D1 E1 05D2 E2 05D3 E3 05D4 E4 05D5 E5 05D6 E6 05D7 E7 05D8 E8 05D9 E9 05DA EA 05DB EB 05DC EC 05DD ED 05DE EE 05DF EF 05E0 F0 05E1 F1 05E2 F2 05E3 F3 05E4 F4 05E5 F5 05E6 F6 05E7 F7 05E8 F8 05E9 F9 05EA FA 05F0 D4 05F1 D5 05F2 D6 05F3 D7 05F4 D8 200E FD 200F FE 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AA A4 20AC 80 2122 99}
} -result {}

# cp1255 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1255 81 tcl8    \U00000081 -1 {} {}
    cp1255 81 replace \uFFFD -1 {} {}
    cp1255 81 strict  {}       0 {} {}
    cp1255 8A tcl8    \U0000008A -1 {} {}
    cp1255 8A replace \uFFFD -1 {} {}
    cp1255 8A strict  {}       0 {} {}
    cp1255 8C tcl8    \U0000008C -1 {} {}
    cp1255 8C replace \uFFFD -1 {} {}
    cp1255 8C strict  {}       0 {} {}
    cp1255 8D tcl8    \U0000008D -1 {} {}
    cp1255 8D replace \uFFFD -1 {} {}
    cp1255 8D strict  {}       0 {} {}
    cp1255 8E tcl8    \U0000008E -1 {} {}
    cp1255 8E replace \uFFFD -1 {} {}
    cp1255 8E strict  {}       0 {} {}
    cp1255 8F tcl8    \U0000008F -1 {} {}
    cp1255 8F replace \uFFFD -1 {} {}
    cp1255 8F strict  {}       0 {} {}
    cp1255 90 tcl8    \U00000090 -1 {} {}
    cp1255 90 replace \uFFFD -1 {} {}
    cp1255 90 strict  {}       0 {} {}
    cp1255 9A tcl8    \U0000009A -1 {} {}
    cp1255 9A replace \uFFFD -1 {} {}
    cp1255 9A strict  {}       0 {} {}
    cp1255 9C tcl8    \U0000009C -1 {} {}
    cp1255 9C replace \uFFFD -1 {} {}
    cp1255 9C strict  {}       0 {} {}
    cp1255 9D tcl8    \U0000009D -1 {} {}
    cp1255 9D replace \uFFFD -1 {} {}
    cp1255 9D strict  {}       0 {} {}
    cp1255 9E tcl8    \U0000009E -1 {} {}
    cp1255 9E replace \uFFFD -1 {} {}
    cp1255 9E strict  {}       0 {} {}
    cp1255 9F tcl8    \U0000009F -1 {} {}
    cp1255 9F replace \uFFFD -1 {} {}
    cp1255 9F strict  {}       0 {} {}
    cp1255 CA tcl8    \U000000CA -1 {} {}
    cp1255 CA replace \uFFFD -1 {} {}
    cp1255 CA strict  {}       0 {} {}
    cp1255 D9 tcl8    \U000000D9 -1 {} {}
    cp1255 D9 replace \uFFFD -1 {} {}
    cp1255 D9 strict  {}       0 {} {}
    cp1255 DA tcl8    \U000000DA -1 {} {}
    cp1255 DA replace \uFFFD -1 {} {}
    cp1255 DA strict  {}       0 {} {}
    cp1255 DB tcl8    \U000000DB -1 {} {}
    cp1255 DB replace \uFFFD -1 {} {}
    cp1255 DB strict  {}       0 {} {}
    cp1255 DC tcl8    \U000000DC -1 {} {}
    cp1255 DC replace \uFFFD -1 {} {}
    cp1255 DC strict  {}       0 {} {}
    cp1255 DD tcl8    \U000000DD -1 {} {}
    cp1255 DD replace \uFFFD -1 {} {}
    cp1255 DD strict  {}       0 {} {}
    cp1255 DE tcl8    \U000000DE -1 {} {}
    cp1255 DE replace \uFFFD -1 {} {}
    cp1255 DE strict  {}       0 {} {}
    cp1255 DF tcl8    \U000000DF -1 {} {}
    cp1255 DF replace \uFFFD -1 {} {}
    cp1255 DF strict  {}       0 {} {}
    cp1255 FB tcl8    \U000000FB -1 {} {}
    cp1255 FB replace \uFFFD -1 {} {}
    cp1255 FB strict  {}       0 {} {}
    cp1255 FC tcl8    \U000000FC -1 {} {}
    cp1255 FC replace \uFFFD -1 {} {}
    cp1255 FC strict  {}       0 {} {}
    cp1255 FF tcl8    \U000000FF -1 {} {}
    cp1255 FF replace \uFFFD -1 {} {}
    cp1255 FF strict  {}       0 {} {}
}; # cp1255

# cp1255 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1255 \U00000080 tcl8    1A -1 {} {}
    cp1255 \U00000080 replace 1A -1 {} {}
    cp1255 \U00000080 strict  {}                      0 {} {}
    cp1255 \U00000400 tcl8    1A -1 {} {}
    cp1255 \U00000400 replace 1A -1 {} {}
    cp1255 \U00000400 strict  {}                      0 {} {}
    cp1255 \U0000D800 tcl8    1A -1 {} {}
    cp1255 \U0000D800 replace 1A -1 {} {}
    cp1255 \U0000D800 strict  {}                      0 {} {}
    cp1255 \U0000DC00 tcl8    1A -1 {} {}
    cp1255 \U0000DC00 replace 1A -1 {} {}
    cp1255 \U0000DC00 strict  {}                      0 {} {}
    cp1255 \U00010000 tcl8    1A -1 {} {}
    cp1255 \U00010000 replace 1A -1 {} {}
    cp1255 \U00010000 strict  {}                      0 {} {}
    cp1255 \U0010FFFF tcl8    1A -1 {} {}
    cp1255 \U0010FFFF replace 1A -1 {} {}
    cp1255 \U0010FFFF strict  {}                      0 {} {}
}; # cp1255

#
# cp1256 (generated from glibc-CP1256-2.1.2)

test encoding-convertfrom-ucmCompare-cp1256 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1256 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00D7 D7 00E0 E0 00E2 E2 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EE EE 00EF EF 00F4 F4 00F7 F7 00F9 F9 00FB FB 00FC FC 0152 8C 0153 9C 0192 83 02C6 88 060C A1 061B BA 061F BF 0621 C1 0622 C2 0623 C3 0624 C4 0625 C5 0626 C6 0627 C7 0628 C8 0629 C9 062A CA 062B CB 062C CC 062D CD 062E CE 062F CF 0630 D0 0631 D1 0632 D2 0633 D3 0634 D4 0635 D5 0636 D6 0637 D8 0638 D9 0639 DA 063A DB 0640 DC 0641 DD 0642 DE 0643 DF 0644 E1 0645 E3 0646 E4 0647 E5 0648 E6 0649 EC 064A ED 064B F0 064C F1 064D F2 064E F3 064F F5 0650 F6 0651 F8 0652 FA 0679 8A 067E 81 0686 8D 0688 8F 0691 9A 0698 8E 06A9 98 06AF 90 06BA 9F 06BE AA 06C1 C0 06D2 FF 200C 9D 200D 9E 200E FD 200F FE 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1256 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1256 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00D7 D7 00E0 E0 00E2 E2 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EE EE 00EF EF 00F4 F4 00F7 F7 00F9 F9 00FB FB 00FC FC 0152 8C 0153 9C 0192 83 02C6 88 060C A1 061B BA 061F BF 0621 C1 0622 C2 0623 C3 0624 C4 0625 C5 0626 C6 0627 C7 0628 C8 0629 C9 062A CA 062B CB 062C CC 062D CD 062E CE 062F CF 0630 D0 0631 D1 0632 D2 0633 D3 0634 D4 0635 D5 0636 D6 0637 D8 0638 D9 0639 DA 063A DB 0640 DC 0641 DD 0642 DE 0643 DF 0644 E1 0645 E3 0646 E4 0647 E5 0648 E6 0649 EC 064A ED 064B F0 064C F1 064D F2 064E F3 064F F5 0650 F6 0651 F8 0652 FA 0679 8A 067E 81 0686 8D 0688 8F 0691 9A 0698 8E 06A9 98 06AF 90 06BA 9F 06BE AA 06C1 C0 06D2 FF 200C 9D 200D 9E 200E FD 200F FE 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

# cp1256 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # cp1256

# cp1256 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1256 \U00000080 tcl8    1A -1 {} {}
    cp1256 \U00000080 replace 1A -1 {} {}
    cp1256 \U00000080 strict  {}                      0 {} {}
    cp1256 \U00000400 tcl8    1A -1 {} {}
    cp1256 \U00000400 replace 1A -1 {} {}
    cp1256 \U00000400 strict  {}                      0 {} {}
    cp1256 \U0000D800 tcl8    1A -1 {} {}
    cp1256 \U0000D800 replace 1A -1 {} {}
    cp1256 \U0000D800 strict  {}                      0 {} {}
    cp1256 \U0000DC00 tcl8    1A -1 {} {}
    cp1256 \U0000DC00 replace 1A -1 {} {}
    cp1256 \U0000DC00 strict  {}                      0 {} {}
    cp1256 \U00010000 tcl8    1A -1 {} {}
    cp1256 \U00010000 replace 1A -1 {} {}
    cp1256 \U00010000 strict  {}                      0 {} {}
    cp1256 \U0010FFFF tcl8    1A -1 {} {}
    cp1256 \U0010FFFF replace 1A -1 {} {}
    cp1256 \U0010FFFF strict  {}                      0 {} {}
}; # cp1256

#
# cp1257 (generated from glibc-CP1257-2.1.2)

test encoding-convertfrom-ucmCompare-cp1257 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1257 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A6 A6 00A7 A7 00A8 8D 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF 9D 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 8F 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00C4 C4 00C5 C5 00C6 AF 00C9 C9 00D3 D3 00D5 D5 00D6 D6 00D7 D7 00D8 A8 00DC DC 00DF DF 00E4 E4 00E5 E5 00E6 BF 00E9 E9 00F3 F3 00F5 F5 00F6 F6 00F7 F7 00F8 B8 00FC FC 0100 C2 0101 E2 0104 C0 0105 E0 0106 C3 0107 E3 010C C8 010D E8 0112 C7 0113 E7 0116 CB 0117 EB 0118 C6 0119 E6 0122 CC 0123 EC 012A CE 012B EE 012E C1 012F E1 0136 CD 0137 ED 013B CF 013C EF 0141 D9 0142 F9 0143 D1 0144 F1 0145 D2 0146 F2 014C D4 014D F4 0156 AA 0157 BA 015A DA 015B FA 0160 D0 0161 F0 016A DB 016B FB 0172 D8 0173 F8 0179 CA 017A EA 017B DD 017C FD 017D DE 017E FE 02C7 8E 02D9 FF 02DB 9E 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1257 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1257 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A6 A6 00A7 A7 00A8 8D 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF 9D 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 8F 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00C4 C4 00C5 C5 00C6 AF 00C9 C9 00D3 D3 00D5 D5 00D6 D6 00D7 D7 00D8 A8 00DC DC 00DF DF 00E4 E4 00E5 E5 00E6 BF 00E9 E9 00F3 F3 00F5 F5 00F6 F6 00F7 F7 00F8 B8 00FC FC 0100 C2 0101 E2 0104 C0 0105 E0 0106 C3 0107 E3 010C C8 010D E8 0112 C7 0113 E7 0116 CB 0117 EB 0118 C6 0119 E6 0122 CC 0123 EC 012A CE 012B EE 012E C1 012F E1 0136 CD 0137 ED 013B CF 013C EF 0141 D9 0142 F9 0143 D1 0144 F1 0145 D2 0146 F2 014C D4 014D F4 0156 AA 0157 BA 015A DA 015B FA 0160 D0 0161 F0 016A DB 016B FB 0172 D8 0173 F8 0179 CA 017A EA 017B DD 017C FD 017D DE 017E FE 02C7 8E 02D9 FF 02DB 9E 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AC 80 2122 99}
} -result {}

# cp1257 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1257 81 tcl8    \U00000081 -1 {} {}
    cp1257 81 replace \uFFFD -1 {} {}
    cp1257 81 strict  {}       0 {} {}
    cp1257 83 tcl8    \U00000083 -1 {} {}
    cp1257 83 replace \uFFFD -1 {} {}
    cp1257 83 strict  {}       0 {} {}
    cp1257 88 tcl8    \U00000088 -1 {} {}
    cp1257 88 replace \uFFFD -1 {} {}
    cp1257 88 strict  {}       0 {} {}
    cp1257 8A tcl8    \U0000008A -1 {} {}
    cp1257 8A replace \uFFFD -1 {} {}
    cp1257 8A strict  {}       0 {} {}
    cp1257 8C tcl8    \U0000008C -1 {} {}
    cp1257 8C replace \uFFFD -1 {} {}
    cp1257 8C strict  {}       0 {} {}
    cp1257 90 tcl8    \U00000090 -1 {} {}
    cp1257 90 replace \uFFFD -1 {} {}
    cp1257 90 strict  {}       0 {} {}
    cp1257 98 tcl8    \U00000098 -1 {} {}
    cp1257 98 replace \uFFFD -1 {} {}
    cp1257 98 strict  {}       0 {} {}
    cp1257 9A tcl8    \U0000009A -1 {} {}
    cp1257 9A replace \uFFFD -1 {} {}
    cp1257 9A strict  {}       0 {} {}
    cp1257 9C tcl8    \U0000009C -1 {} {}
    cp1257 9C replace \uFFFD -1 {} {}
    cp1257 9C strict  {}       0 {} {}
    cp1257 9F tcl8    \U0000009F -1 {} {}
    cp1257 9F replace \uFFFD -1 {} {}
    cp1257 9F strict  {}       0 {} {}
    cp1257 A1 tcl8    \U000000A1 -1 {} {}
    cp1257 A1 replace \uFFFD -1 {} {}
    cp1257 A1 strict  {}       0 {} {}
    cp1257 A5 tcl8    \U000000A5 -1 {} {}
    cp1257 A5 replace \uFFFD -1 {} {}
    cp1257 A5 strict  {}       0 {} {}
}; # cp1257

# cp1257 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1257 \U00000080 tcl8    1A -1 {} {}
    cp1257 \U00000080 replace 1A -1 {} {}
    cp1257 \U00000080 strict  {}                      0 {} {}
    cp1257 \U00000400 tcl8    1A -1 {} {}
    cp1257 \U00000400 replace 1A -1 {} {}
    cp1257 \U00000400 strict  {}                      0 {} {}
    cp1257 \U0000D800 tcl8    1A -1 {} {}
    cp1257 \U0000D800 replace 1A -1 {} {}
    cp1257 \U0000D800 strict  {}                      0 {} {}
    cp1257 \U0000DC00 tcl8    1A -1 {} {}
    cp1257 \U0000DC00 replace 1A -1 {} {}
    cp1257 \U0000DC00 strict  {}                      0 {} {}
    cp1257 \U00010000 tcl8    1A -1 {} {}
    cp1257 \U00010000 replace 1A -1 {} {}
    cp1257 \U00010000 strict  {}                      0 {} {}
    cp1257 \U0010FFFF tcl8    1A -1 {} {}
    cp1257 \U0010FFFF replace 1A -1 {} {}
    cp1257 \U0010FFFF strict  {}                      0 {} {}
}; # cp1257

#
# cp1258 (generated from glibc-CP1258-2.1.2)

test encoding-convertfrom-ucmCompare-cp1258 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches cp1258 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CD CD 00CE CE 00CF CF 00D1 D1 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00ED ED 00EE EE 00EF EF 00F1 F1 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 0102 C3 0103 E3 0110 D0 0111 F0 0152 8C 0153 9C 0178 9F 0192 83 01A0 D5 01A1 F5 01AF DD 01B0 FD 02C6 88 02DC 98 0300 CC 0303 DE 0309 D2 0323 F2 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AB FE 20AC 80 2122 99}
} -result {}

test encoding-convertto-ucmCompare-cp1258 {Compare against ICU UCM} -body {
    ucmConverttoMismatches cp1258 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CD CD 00CE CE 00CF CF 00D1 D1 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00ED ED 00EE EE 00EF EF 00F1 F1 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 0102 C3 0103 E3 0110 D0 0111 F0 0152 8C 0153 9C 0178 9F 0192 83 01A0 D5 01A1 F5 01AF DD 01B0 FD 02C6 88 02DC 98 0300 CC 0303 DE 0309 D2 0323 F2 2013 96 2014 97 2018 91 2019 92 201A 82 201C 93 201D 94 201E 84 2020 86 2021 87 2022 95 2026 85 2030 89 2039 8B 203A 9B 20AB FE 20AC 80 2122 99}
} -result {}

# cp1258 - invalid byte sequences
lappend encInvalidBytes {*}{
    cp1258 81 tcl8    \U00000081 -1 {} {}
    cp1258 81 replace \uFFFD -1 {} {}
    cp1258 81 strict  {}       0 {} {}
    cp1258 8A tcl8    \U0000008A -1 {} {}
    cp1258 8A replace \uFFFD -1 {} {}
    cp1258 8A strict  {}       0 {} {}
    cp1258 8D tcl8    \U0000008D -1 {} {}
    cp1258 8D replace \uFFFD -1 {} {}
    cp1258 8D strict  {}       0 {} {}
    cp1258 8E tcl8    \U0000008E -1 {} {}
    cp1258 8E replace \uFFFD -1 {} {}
    cp1258 8E strict  {}       0 {} {}
    cp1258 8F tcl8    \U0000008F -1 {} {}
    cp1258 8F replace \uFFFD -1 {} {}
    cp1258 8F strict  {}       0 {} {}
    cp1258 90 tcl8    \U00000090 -1 {} {}
    cp1258 90 replace \uFFFD -1 {} {}
    cp1258 90 strict  {}       0 {} {}
    cp1258 9A tcl8    \U0000009A -1 {} {}
    cp1258 9A replace \uFFFD -1 {} {}
    cp1258 9A strict  {}       0 {} {}
    cp1258 9D tcl8    \U0000009D -1 {} {}
    cp1258 9D replace \uFFFD -1 {} {}
    cp1258 9D strict  {}       0 {} {}
    cp1258 9E tcl8    \U0000009E -1 {} {}
    cp1258 9E replace \uFFFD -1 {} {}
    cp1258 9E strict  {}       0 {} {}
    cp1258 EC tcl8    \U000000EC -1 {} {}
    cp1258 EC replace \uFFFD -1 {} {}
    cp1258 EC strict  {}       0 {} {}
}; # cp1258

# cp1258 - invalid byte sequences
lappend encUnencodableStrings {*}{
    cp1258 \U00000080 tcl8    1A -1 {} {}
    cp1258 \U00000080 replace 1A -1 {} {}
    cp1258 \U00000080 strict  {}                      0 {} {}
    cp1258 \U00000400 tcl8    1A -1 {} {}
    cp1258 \U00000400 replace 1A -1 {} {}
    cp1258 \U00000400 strict  {}                      0 {} {}
    cp1258 \U0000D800 tcl8    1A -1 {} {}
    cp1258 \U0000D800 replace 1A -1 {} {}
    cp1258 \U0000D800 strict  {}                      0 {} {}
    cp1258 \U0000DC00 tcl8    1A -1 {} {}
    cp1258 \U0000DC00 replace 1A -1 {} {}
    cp1258 \U0000DC00 strict  {}                      0 {} {}
    cp1258 \U00010000 tcl8    1A -1 {} {}
    cp1258 \U00010000 replace 1A -1 {} {}
    cp1258 \U00010000 strict  {}                      0 {} {}
    cp1258 \U0010FFFF tcl8    1A -1 {} {}
    cp1258 \U0010FFFF replace 1A -1 {} {}
    cp1258 \U0010FFFF strict  {}                      0 {} {}
}; # cp1258

#
# gb1988 (generated from glibc-GB_1988_80-2.3.3)

test encoding-convertfrom-ucmCompare-gb1988 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches gb1988 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007F 7F 00A5 24 203E 7E}
} -result {}

test encoding-convertto-ucmCompare-gb1988 {Compare against ICU UCM} -body {
    ucmConverttoMismatches gb1988 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007F 7F 00A5 24 203E 7E}
} -result {}

# gb1988 - invalid byte sequences
lappend encInvalidBytes {*}{
    gb1988 80 tcl8    \U00000080 -1 {} {}
    gb1988 80 replace \uFFFD -1 {} {}
    gb1988 80 strict  {}       0 {} {}
    gb1988 81 tcl8    \U00000081 -1 {} {}
    gb1988 81 replace \uFFFD -1 {} {}
    gb1988 81 strict  {}       0 {} {}
    gb1988 82 tcl8    \U00000082 -1 {} {}
    gb1988 82 replace \uFFFD -1 {} {}
    gb1988 82 strict  {}       0 {} {}
    gb1988 83 tcl8    \U00000083 -1 {} {}
    gb1988 83 replace \uFFFD -1 {} {}
    gb1988 83 strict  {}       0 {} {}
    gb1988 84 tcl8    \U00000084 -1 {} {}
    gb1988 84 replace \uFFFD -1 {} {}
    gb1988 84 strict  {}       0 {} {}
    gb1988 85 tcl8    \U00000085 -1 {} {}
    gb1988 85 replace \uFFFD -1 {} {}
    gb1988 85 strict  {}       0 {} {}
    gb1988 86 tcl8    \U00000086 -1 {} {}
    gb1988 86 replace \uFFFD -1 {} {}
    gb1988 86 strict  {}       0 {} {}
    gb1988 87 tcl8    \U00000087 -1 {} {}
    gb1988 87 replace \uFFFD -1 {} {}
    gb1988 87 strict  {}       0 {} {}
    gb1988 88 tcl8    \U00000088 -1 {} {}
    gb1988 88 replace \uFFFD -1 {} {}
    gb1988 88 strict  {}       0 {} {}
    gb1988 89 tcl8    \U00000089 -1 {} {}
    gb1988 89 replace \uFFFD -1 {} {}
    gb1988 89 strict  {}       0 {} {}
    gb1988 8A tcl8    \U0000008A -1 {} {}
    gb1988 8A replace \uFFFD -1 {} {}
    gb1988 8A strict  {}       0 {} {}
    gb1988 8B tcl8    \U0000008B -1 {} {}
    gb1988 8B replace \uFFFD -1 {} {}
    gb1988 8B strict  {}       0 {} {}
    gb1988 8C tcl8    \U0000008C -1 {} {}
    gb1988 8C replace \uFFFD -1 {} {}
    gb1988 8C strict  {}       0 {} {}
    gb1988 8D tcl8    \U0000008D -1 {} {}
    gb1988 8D replace \uFFFD -1 {} {}
    gb1988 8D strict  {}       0 {} {}
    gb1988 8E tcl8    \U0000008E -1 {} {}
    gb1988 8E replace \uFFFD -1 {} {}
    gb1988 8E strict  {}       0 {} {}
    gb1988 8F tcl8    \U0000008F -1 {} {}
    gb1988 8F replace \uFFFD -1 {} {}
    gb1988 8F strict  {}       0 {} {}
    gb1988 90 tcl8    \U00000090 -1 {} {}
    gb1988 90 replace \uFFFD -1 {} {}
    gb1988 90 strict  {}       0 {} {}
    gb1988 91 tcl8    \U00000091 -1 {} {}
    gb1988 91 replace \uFFFD -1 {} {}
    gb1988 91 strict  {}       0 {} {}
    gb1988 92 tcl8    \U00000092 -1 {} {}
    gb1988 92 replace \uFFFD -1 {} {}
    gb1988 92 strict  {}       0 {} {}
    gb1988 93 tcl8    \U00000093 -1 {} {}
    gb1988 93 replace \uFFFD -1 {} {}
    gb1988 93 strict  {}       0 {} {}
    gb1988 94 tcl8    \U00000094 -1 {} {}
    gb1988 94 replace \uFFFD -1 {} {}
    gb1988 94 strict  {}       0 {} {}
    gb1988 95 tcl8    \U00000095 -1 {} {}
    gb1988 95 replace \uFFFD -1 {} {}
    gb1988 95 strict  {}       0 {} {}
    gb1988 96 tcl8    \U00000096 -1 {} {}
    gb1988 96 replace \uFFFD -1 {} {}
    gb1988 96 strict  {}       0 {} {}
    gb1988 97 tcl8    \U00000097 -1 {} {}
    gb1988 97 replace \uFFFD -1 {} {}
    gb1988 97 strict  {}       0 {} {}
    gb1988 98 tcl8    \U00000098 -1 {} {}
    gb1988 98 replace \uFFFD -1 {} {}
    gb1988 98 strict  {}       0 {} {}
    gb1988 99 tcl8    \U00000099 -1 {} {}
    gb1988 99 replace \uFFFD -1 {} {}
    gb1988 99 strict  {}       0 {} {}
    gb1988 9A tcl8    \U0000009A -1 {} {}
    gb1988 9A replace \uFFFD -1 {} {}
    gb1988 9A strict  {}       0 {} {}
    gb1988 9B tcl8    \U0000009B -1 {} {}
    gb1988 9B replace \uFFFD -1 {} {}
    gb1988 9B strict  {}       0 {} {}
    gb1988 9C tcl8    \U0000009C -1 {} {}
    gb1988 9C replace \uFFFD -1 {} {}
    gb1988 9C strict  {}       0 {} {}
    gb1988 9D tcl8    \U0000009D -1 {} {}
    gb1988 9D replace \uFFFD -1 {} {}
    gb1988 9D strict  {}       0 {} {}
    gb1988 9E tcl8    \U0000009E -1 {} {}
    gb1988 9E replace \uFFFD -1 {} {}
    gb1988 9E strict  {}       0 {} {}
    gb1988 9F tcl8    \U0000009F -1 {} {}
    gb1988 9F replace \uFFFD -1 {} {}
    gb1988 9F strict  {}       0 {} {}
    gb1988 A0 tcl8    \U000000A0 -1 {} {}
    gb1988 A0 replace \uFFFD -1 {} {}
    gb1988 A0 strict  {}       0 {} {}
    gb1988 A1 tcl8    \U000000A1 -1 {} {}
    gb1988 A1 replace \uFFFD -1 {} {}
    gb1988 A1 strict  {}       0 {} {}
    gb1988 A2 tcl8    \U000000A2 -1 {} {}
    gb1988 A2 replace \uFFFD -1 {} {}
    gb1988 A2 strict  {}       0 {} {}
    gb1988 A3 tcl8    \U000000A3 -1 {} {}
    gb1988 A3 replace \uFFFD -1 {} {}
    gb1988 A3 strict  {}       0 {} {}
    gb1988 A4 tcl8    \U000000A4 -1 {} {}
    gb1988 A4 replace \uFFFD -1 {} {}
    gb1988 A4 strict  {}       0 {} {}
    gb1988 A5 tcl8    \U000000A5 -1 {} {}
    gb1988 A5 replace \uFFFD -1 {} {}
    gb1988 A5 strict  {}       0 {} {}
    gb1988 A6 tcl8    \U000000A6 -1 {} {}
    gb1988 A6 replace \uFFFD -1 {} {}
    gb1988 A6 strict  {}       0 {} {}
    gb1988 A7 tcl8    \U000000A7 -1 {} {}
    gb1988 A7 replace \uFFFD -1 {} {}
    gb1988 A7 strict  {}       0 {} {}
    gb1988 A8 tcl8    \U000000A8 -1 {} {}
    gb1988 A8 replace \uFFFD -1 {} {}
    gb1988 A8 strict  {}       0 {} {}
    gb1988 A9 tcl8    \U000000A9 -1 {} {}
    gb1988 A9 replace \uFFFD -1 {} {}
    gb1988 A9 strict  {}       0 {} {}
    gb1988 AA tcl8    \U000000AA -1 {} {}
    gb1988 AA replace \uFFFD -1 {} {}
    gb1988 AA strict  {}       0 {} {}
    gb1988 AB tcl8    \U000000AB -1 {} {}
    gb1988 AB replace \uFFFD -1 {} {}
    gb1988 AB strict  {}       0 {} {}
    gb1988 AC tcl8    \U000000AC -1 {} {}
    gb1988 AC replace \uFFFD -1 {} {}
    gb1988 AC strict  {}       0 {} {}
    gb1988 AD tcl8    \U000000AD -1 {} {}
    gb1988 AD replace \uFFFD -1 {} {}
    gb1988 AD strict  {}       0 {} {}
    gb1988 AE tcl8    \U000000AE -1 {} {}
    gb1988 AE replace \uFFFD -1 {} {}
    gb1988 AE strict  {}       0 {} {}
    gb1988 AF tcl8    \U000000AF -1 {} {}
    gb1988 AF replace \uFFFD -1 {} {}
    gb1988 AF strict  {}       0 {} {}
    gb1988 B0 tcl8    \U000000B0 -1 {} {}
    gb1988 B0 replace \uFFFD -1 {} {}
    gb1988 B0 strict  {}       0 {} {}
    gb1988 B1 tcl8    \U000000B1 -1 {} {}
    gb1988 B1 replace \uFFFD -1 {} {}
    gb1988 B1 strict  {}       0 {} {}
    gb1988 B2 tcl8    \U000000B2 -1 {} {}
    gb1988 B2 replace \uFFFD -1 {} {}
    gb1988 B2 strict  {}       0 {} {}
    gb1988 B3 tcl8    \U000000B3 -1 {} {}
    gb1988 B3 replace \uFFFD -1 {} {}
    gb1988 B3 strict  {}       0 {} {}
    gb1988 B4 tcl8    \U000000B4 -1 {} {}
    gb1988 B4 replace \uFFFD -1 {} {}
    gb1988 B4 strict  {}       0 {} {}
    gb1988 B5 tcl8    \U000000B5 -1 {} {}
    gb1988 B5 replace \uFFFD -1 {} {}
    gb1988 B5 strict  {}       0 {} {}
    gb1988 B6 tcl8    \U000000B6 -1 {} {}
    gb1988 B6 replace \uFFFD -1 {} {}
    gb1988 B6 strict  {}       0 {} {}
    gb1988 B7 tcl8    \U000000B7 -1 {} {}
    gb1988 B7 replace \uFFFD -1 {} {}
    gb1988 B7 strict  {}       0 {} {}
    gb1988 B8 tcl8    \U000000B8 -1 {} {}
    gb1988 B8 replace \uFFFD -1 {} {}
    gb1988 B8 strict  {}       0 {} {}
    gb1988 B9 tcl8    \U000000B9 -1 {} {}
    gb1988 B9 replace \uFFFD -1 {} {}
    gb1988 B9 strict  {}       0 {} {}
    gb1988 BA tcl8    \U000000BA -1 {} {}
    gb1988 BA replace \uFFFD -1 {} {}
    gb1988 BA strict  {}       0 {} {}
    gb1988 BB tcl8    \U000000BB -1 {} {}
    gb1988 BB replace \uFFFD -1 {} {}
    gb1988 BB strict  {}       0 {} {}
    gb1988 BC tcl8    \U000000BC -1 {} {}
    gb1988 BC replace \uFFFD -1 {} {}
    gb1988 BC strict  {}       0 {} {}
    gb1988 BD tcl8    \U000000BD -1 {} {}
    gb1988 BD replace \uFFFD -1 {} {}
    gb1988 BD strict  {}       0 {} {}
    gb1988 BE tcl8    \U000000BE -1 {} {}
    gb1988 BE replace \uFFFD -1 {} {}
    gb1988 BE strict  {}       0 {} {}
    gb1988 BF tcl8    \U000000BF -1 {} {}
    gb1988 BF replace \uFFFD -1 {} {}
    gb1988 BF strict  {}       0 {} {}
    gb1988 C0 tcl8    \U000000C0 -1 {} {}
    gb1988 C0 replace \uFFFD -1 {} {}
    gb1988 C0 strict  {}       0 {} {}
    gb1988 C1 tcl8    \U000000C1 -1 {} {}
    gb1988 C1 replace \uFFFD -1 {} {}
    gb1988 C1 strict  {}       0 {} {}
    gb1988 C2 tcl8    \U000000C2 -1 {} {}
    gb1988 C2 replace \uFFFD -1 {} {}
    gb1988 C2 strict  {}       0 {} {}
    gb1988 C3 tcl8    \U000000C3 -1 {} {}
    gb1988 C3 replace \uFFFD -1 {} {}
    gb1988 C3 strict  {}       0 {} {}
    gb1988 C4 tcl8    \U000000C4 -1 {} {}
    gb1988 C4 replace \uFFFD -1 {} {}
    gb1988 C4 strict  {}       0 {} {}
    gb1988 C5 tcl8    \U000000C5 -1 {} {}
    gb1988 C5 replace \uFFFD -1 {} {}
    gb1988 C5 strict  {}       0 {} {}
    gb1988 C6 tcl8    \U000000C6 -1 {} {}
    gb1988 C6 replace \uFFFD -1 {} {}
    gb1988 C6 strict  {}       0 {} {}
    gb1988 C7 tcl8    \U000000C7 -1 {} {}
    gb1988 C7 replace \uFFFD -1 {} {}
    gb1988 C7 strict  {}       0 {} {}
    gb1988 C8 tcl8    \U000000C8 -1 {} {}
    gb1988 C8 replace \uFFFD -1 {} {}
    gb1988 C8 strict  {}       0 {} {}
    gb1988 C9 tcl8    \U000000C9 -1 {} {}
    gb1988 C9 replace \uFFFD -1 {} {}
    gb1988 C9 strict  {}       0 {} {}
    gb1988 CA tcl8    \U000000CA -1 {} {}
    gb1988 CA replace \uFFFD -1 {} {}
    gb1988 CA strict  {}       0 {} {}
    gb1988 CB tcl8    \U000000CB -1 {} {}
    gb1988 CB replace \uFFFD -1 {} {}
    gb1988 CB strict  {}       0 {} {}
    gb1988 CC tcl8    \U000000CC -1 {} {}
    gb1988 CC replace \uFFFD -1 {} {}
    gb1988 CC strict  {}       0 {} {}
    gb1988 CD tcl8    \U000000CD -1 {} {}
    gb1988 CD replace \uFFFD -1 {} {}
    gb1988 CD strict  {}       0 {} {}
    gb1988 CE tcl8    \U000000CE -1 {} {}
    gb1988 CE replace \uFFFD -1 {} {}
    gb1988 CE strict  {}       0 {} {}
    gb1988 CF tcl8    \U000000CF -1 {} {}
    gb1988 CF replace \uFFFD -1 {} {}
    gb1988 CF strict  {}       0 {} {}
    gb1988 D0 tcl8    \U000000D0 -1 {} {}
    gb1988 D0 replace \uFFFD -1 {} {}
    gb1988 D0 strict  {}       0 {} {}
    gb1988 D1 tcl8    \U000000D1 -1 {} {}
    gb1988 D1 replace \uFFFD -1 {} {}
    gb1988 D1 strict  {}       0 {} {}
    gb1988 D2 tcl8    \U000000D2 -1 {} {}
    gb1988 D2 replace \uFFFD -1 {} {}
    gb1988 D2 strict  {}       0 {} {}
    gb1988 D3 tcl8    \U000000D3 -1 {} {}
    gb1988 D3 replace \uFFFD -1 {} {}
    gb1988 D3 strict  {}       0 {} {}
    gb1988 D4 tcl8    \U000000D4 -1 {} {}
    gb1988 D4 replace \uFFFD -1 {} {}
    gb1988 D4 strict  {}       0 {} {}
    gb1988 D5 tcl8    \U000000D5 -1 {} {}
    gb1988 D5 replace \uFFFD -1 {} {}
    gb1988 D5 strict  {}       0 {} {}
    gb1988 D6 tcl8    \U000000D6 -1 {} {}
    gb1988 D6 replace \uFFFD -1 {} {}
    gb1988 D6 strict  {}       0 {} {}
    gb1988 D7 tcl8    \U000000D7 -1 {} {}
    gb1988 D7 replace \uFFFD -1 {} {}
    gb1988 D7 strict  {}       0 {} {}
    gb1988 D8 tcl8    \U000000D8 -1 {} {}
    gb1988 D8 replace \uFFFD -1 {} {}
    gb1988 D8 strict  {}       0 {} {}
    gb1988 D9 tcl8    \U000000D9 -1 {} {}
    gb1988 D9 replace \uFFFD -1 {} {}
    gb1988 D9 strict  {}       0 {} {}
    gb1988 DA tcl8    \U000000DA -1 {} {}
    gb1988 DA replace \uFFFD -1 {} {}
    gb1988 DA strict  {}       0 {} {}
    gb1988 DB tcl8    \U000000DB -1 {} {}
    gb1988 DB replace \uFFFD -1 {} {}
    gb1988 DB strict  {}       0 {} {}
    gb1988 DC tcl8    \U000000DC -1 {} {}
    gb1988 DC replace \uFFFD -1 {} {}
    gb1988 DC strict  {}       0 {} {}
    gb1988 DD tcl8    \U000000DD -1 {} {}
    gb1988 DD replace \uFFFD -1 {} {}
    gb1988 DD strict  {}       0 {} {}
    gb1988 DE tcl8    \U000000DE -1 {} {}
    gb1988 DE replace \uFFFD -1 {} {}
    gb1988 DE strict  {}       0 {} {}
    gb1988 DF tcl8    \U000000DF -1 {} {}
    gb1988 DF replace \uFFFD -1 {} {}
    gb1988 DF strict  {}       0 {} {}
    gb1988 E0 tcl8    \U000000E0 -1 {} {}
    gb1988 E0 replace \uFFFD -1 {} {}
    gb1988 E0 strict  {}       0 {} {}
    gb1988 E1 tcl8    \U000000E1 -1 {} {}
    gb1988 E1 replace \uFFFD -1 {} {}
    gb1988 E1 strict  {}       0 {} {}
    gb1988 E2 tcl8    \U000000E2 -1 {} {}
    gb1988 E2 replace \uFFFD -1 {} {}
    gb1988 E2 strict  {}       0 {} {}
    gb1988 E3 tcl8    \U000000E3 -1 {} {}
    gb1988 E3 replace \uFFFD -1 {} {}
    gb1988 E3 strict  {}       0 {} {}
    gb1988 E4 tcl8    \U000000E4 -1 {} {}
    gb1988 E4 replace \uFFFD -1 {} {}
    gb1988 E4 strict  {}       0 {} {}
    gb1988 E5 tcl8    \U000000E5 -1 {} {}
    gb1988 E5 replace \uFFFD -1 {} {}
    gb1988 E5 strict  {}       0 {} {}
    gb1988 E6 tcl8    \U000000E6 -1 {} {}
    gb1988 E6 replace \uFFFD -1 {} {}
    gb1988 E6 strict  {}       0 {} {}
    gb1988 E7 tcl8    \U000000E7 -1 {} {}
    gb1988 E7 replace \uFFFD -1 {} {}
    gb1988 E7 strict  {}       0 {} {}
    gb1988 E8 tcl8    \U000000E8 -1 {} {}
    gb1988 E8 replace \uFFFD -1 {} {}
    gb1988 E8 strict  {}       0 {} {}
    gb1988 E9 tcl8    \U000000E9 -1 {} {}
    gb1988 E9 replace \uFFFD -1 {} {}
    gb1988 E9 strict  {}       0 {} {}
    gb1988 EA tcl8    \U000000EA -1 {} {}
    gb1988 EA replace \uFFFD -1 {} {}
    gb1988 EA strict  {}       0 {} {}
    gb1988 EB tcl8    \U000000EB -1 {} {}
    gb1988 EB replace \uFFFD -1 {} {}
    gb1988 EB strict  {}       0 {} {}
    gb1988 EC tcl8    \U000000EC -1 {} {}
    gb1988 EC replace \uFFFD -1 {} {}
    gb1988 EC strict  {}       0 {} {}
    gb1988 ED tcl8    \U000000ED -1 {} {}
    gb1988 ED replace \uFFFD -1 {} {}
    gb1988 ED strict  {}       0 {} {}
    gb1988 EE tcl8    \U000000EE -1 {} {}
    gb1988 EE replace \uFFFD -1 {} {}
    gb1988 EE strict  {}       0 {} {}
    gb1988 EF tcl8    \U000000EF -1 {} {}
    gb1988 EF replace \uFFFD -1 {} {}
    gb1988 EF strict  {}       0 {} {}
    gb1988 F0 tcl8    \U000000F0 -1 {} {}
    gb1988 F0 replace \uFFFD -1 {} {}
    gb1988 F0 strict  {}       0 {} {}
    gb1988 F1 tcl8    \U000000F1 -1 {} {}
    gb1988 F1 replace \uFFFD -1 {} {}
    gb1988 F1 strict  {}       0 {} {}
    gb1988 F2 tcl8    \U000000F2 -1 {} {}
    gb1988 F2 replace \uFFFD -1 {} {}
    gb1988 F2 strict  {}       0 {} {}
    gb1988 F3 tcl8    \U000000F3 -1 {} {}
    gb1988 F3 replace \uFFFD -1 {} {}
    gb1988 F3 strict  {}       0 {} {}
    gb1988 F4 tcl8    \U000000F4 -1 {} {}
    gb1988 F4 replace \uFFFD -1 {} {}
    gb1988 F4 strict  {}       0 {} {}
    gb1988 F5 tcl8    \U000000F5 -1 {} {}
    gb1988 F5 replace \uFFFD -1 {} {}
    gb1988 F5 strict  {}       0 {} {}
    gb1988 F6 tcl8    \U000000F6 -1 {} {}
    gb1988 F6 replace \uFFFD -1 {} {}
    gb1988 F6 strict  {}       0 {} {}
    gb1988 F7 tcl8    \U000000F7 -1 {} {}
    gb1988 F7 replace \uFFFD -1 {} {}
    gb1988 F7 strict  {}       0 {} {}
    gb1988 F8 tcl8    \U000000F8 -1 {} {}
    gb1988 F8 replace \uFFFD -1 {} {}
    gb1988 F8 strict  {}       0 {} {}
    gb1988 F9 tcl8    \U000000F9 -1 {} {}
    gb1988 F9 replace \uFFFD -1 {} {}
    gb1988 F9 strict  {}       0 {} {}
    gb1988 FA tcl8    \U000000FA -1 {} {}
    gb1988 FA replace \uFFFD -1 {} {}
    gb1988 FA strict  {}       0 {} {}
    gb1988 FB tcl8    \U000000FB -1 {} {}
    gb1988 FB replace \uFFFD -1 {} {}
    gb1988 FB strict  {}       0 {} {}
    gb1988 FC tcl8    \U000000FC -1 {} {}
    gb1988 FC replace \uFFFD -1 {} {}
    gb1988 FC strict  {}       0 {} {}
    gb1988 FD tcl8    \U000000FD -1 {} {}
    gb1988 FD replace \uFFFD -1 {} {}
    gb1988 FD strict  {}       0 {} {}
    gb1988 FE tcl8    \U000000FE -1 {} {}
    gb1988 FE replace \uFFFD -1 {} {}
    gb1988 FE strict  {}       0 {} {}
    gb1988 FF tcl8    \U000000FF -1 {} {}
    gb1988 FF replace \uFFFD -1 {} {}
    gb1988 FF strict  {}       0 {} {}
}; # gb1988

# gb1988 - invalid byte sequences
lappend encUnencodableStrings {*}{
    gb1988 \U00000024 tcl8    1A -1 {} {}
    gb1988 \U00000024 replace 1A -1 {} {}
    gb1988 \U00000024 strict  {}                      0 {} {}
    gb1988 \U00000400 tcl8    1A -1 {} {}
    gb1988 \U00000400 replace 1A -1 {} {}
    gb1988 \U00000400 strict  {}                      0 {} {}
    gb1988 \U0000D800 tcl8    1A -1 {} {}
    gb1988 \U0000D800 replace 1A -1 {} {}
    gb1988 \U0000D800 strict  {}                      0 {} {}
    gb1988 \U0000DC00 tcl8    1A -1 {} {}
    gb1988 \U0000DC00 replace 1A -1 {} {}
    gb1988 \U0000DC00 strict  {}                      0 {} {}
    gb1988 \U00010000 tcl8    1A -1 {} {}
    gb1988 \U00010000 replace 1A -1 {} {}
    gb1988 \U00010000 strict  {}                      0 {} {}
    gb1988 \U0010FFFF tcl8    1A -1 {} {}
    gb1988 \U0010FFFF replace 1A -1 {} {}
    gb1988 \U0010FFFF strict  {}                      0 {} {}
}; # gb1988

#
# iso8859-1 (generated from glibc-ISO_8859_1-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-1 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-1 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D0 D0 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F0 F0 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 00FF FF}
} -result {}

test encoding-convertto-ucmCompare-iso8859-1 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-1 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D0 D0 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F0 F0 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 00FF FF}
} -result {}

# iso8859-1 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-1

# iso8859-1 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-1 \U00000400 tcl8    1A -1 {} {}
    iso8859-1 \U00000400 replace 1A -1 {} {}
    iso8859-1 \U00000400 strict  {}                      0 {} {}
    iso8859-1 \U0000D800 tcl8    1A -1 {} {}
    iso8859-1 \U0000D800 replace 1A -1 {} {}
    iso8859-1 \U0000D800 strict  {}                      0 {} {}
    iso8859-1 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-1 \U0000DC00 replace 1A -1 {} {}
    iso8859-1 \U0000DC00 strict  {}                      0 {} {}
    iso8859-1 \U00010000 tcl8    1A -1 {} {}
    iso8859-1 \U00010000 replace 1A -1 {} {}
    iso8859-1 \U00010000 strict  {}                      0 {} {}
    iso8859-1 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-1 \U0010FFFF replace 1A -1 {} {}
    iso8859-1 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-1

#
# iso8859-2 (generated from glibc-ISO_8859_2-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-2 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-2 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A4 A4 00A7 A7 00A8 A8 00AD AD 00B0 B0 00B4 B4 00B8 B8 00C1 C1 00C2 C2 00C4 C4 00C7 C7 00C9 C9 00CB CB 00CD CD 00CE CE 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00DA DA 00DC DC 00DD DD 00DF DF 00E1 E1 00E2 E2 00E4 E4 00E7 E7 00E9 E9 00EB EB 00ED ED 00EE EE 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00FA FA 00FC FC 00FD FD 0102 C3 0103 E3 0104 A1 0105 B1 0106 C6 0107 E6 010C C8 010D E8 010E CF 010F EF 0110 D0 0111 F0 0118 CA 0119 EA 011A CC 011B EC 0139 C5 013A E5 013D A5 013E B5 0141 A3 0142 B3 0143 D1 0144 F1 0147 D2 0148 F2 0150 D5 0151 F5 0154 C0 0155 E0 0158 D8 0159 F8 015A A6 015B B6 015E AA 015F BA 0160 A9 0161 B9 0162 DE 0163 FE 0164 AB 0165 BB 016E D9 016F F9 0170 DB 0171 FB 0179 AC 017A BC 017B AF 017C BF 017D AE 017E BE 02C7 B7 02D8 A2 02D9 FF 02DB B2 02DD BD}
} -result {}

test encoding-convertto-ucmCompare-iso8859-2 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-2 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A4 A4 00A7 A7 00A8 A8 00AD AD 00B0 B0 00B4 B4 00B8 B8 00C1 C1 00C2 C2 00C4 C4 00C7 C7 00C9 C9 00CB CB 00CD CD 00CE CE 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00DA DA 00DC DC 00DD DD 00DF DF 00E1 E1 00E2 E2 00E4 E4 00E7 E7 00E9 E9 00EB EB 00ED ED 00EE EE 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00FA FA 00FC FC 00FD FD 0102 C3 0103 E3 0104 A1 0105 B1 0106 C6 0107 E6 010C C8 010D E8 010E CF 010F EF 0110 D0 0111 F0 0118 CA 0119 EA 011A CC 011B EC 0139 C5 013A E5 013D A5 013E B5 0141 A3 0142 B3 0143 D1 0144 F1 0147 D2 0148 F2 0150 D5 0151 F5 0154 C0 0155 E0 0158 D8 0159 F8 015A A6 015B B6 015E AA 015F BA 0160 A9 0161 B9 0162 DE 0163 FE 0164 AB 0165 BB 016E D9 016F F9 0170 DB 0171 FB 0179 AC 017A BC 017B AF 017C BF 017D AE 017E BE 02C7 B7 02D8 A2 02D9 FF 02DB B2 02DD BD}
} -result {}

# iso8859-2 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-2

# iso8859-2 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-2 \U000000A1 tcl8    1A -1 {} {}
    iso8859-2 \U000000A1 replace 1A -1 {} {}
    iso8859-2 \U000000A1 strict  {}                      0 {} {}
    iso8859-2 \U00000400 tcl8    1A -1 {} {}
    iso8859-2 \U00000400 replace 1A -1 {} {}
    iso8859-2 \U00000400 strict  {}                      0 {} {}
    iso8859-2 \U0000D800 tcl8    1A -1 {} {}
    iso8859-2 \U0000D800 replace 1A -1 {} {}
    iso8859-2 \U0000D800 strict  {}                      0 {} {}
    iso8859-2 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-2 \U0000DC00 replace 1A -1 {} {}
    iso8859-2 \U0000DC00 strict  {}                      0 {} {}
    iso8859-2 \U00010000 tcl8    1A -1 {} {}
    iso8859-2 \U00010000 replace 1A -1 {} {}
    iso8859-2 \U00010000 strict  {}                      0 {} {}
    iso8859-2 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-2 \U0010FFFF replace 1A -1 {} {}
    iso8859-2 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-2

#
# iso8859-3 (generated from glibc-ISO_8859_3-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-3 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-3 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A3 A3 00A4 A4 00A7 A7 00A8 A8 00AD AD 00B0 B0 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B7 B7 00B8 B8 00BD BD 00C0 C0 00C1 C1 00C2 C2 00C4 C4 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E4 E4 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00F9 F9 00FA FA 00FB FB 00FC FC 0108 C6 0109 E6 010A C5 010B E5 011C D8 011D F8 011E AB 011F BB 0120 D5 0121 F5 0124 A6 0125 B6 0126 A1 0127 B1 0130 A9 0131 B9 0134 AC 0135 BC 015C DE 015D FE 015E AA 015F BA 016C DD 016D FD 017B AF 017C BF 02D8 A2 02D9 FF}
} -result {}

test encoding-convertto-ucmCompare-iso8859-3 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-3 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A3 A3 00A4 A4 00A7 A7 00A8 A8 00AD AD 00B0 B0 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B7 B7 00B8 B8 00BD BD 00C0 C0 00C1 C1 00C2 C2 00C4 C4 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D6 D6 00D7 D7 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E4 E4 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F6 F6 00F7 F7 00F9 F9 00FA FA 00FB FB 00FC FC 0108 C6 0109 E6 010A C5 010B E5 011C D8 011D F8 011E AB 011F BB 0120 D5 0121 F5 0124 A6 0125 B6 0126 A1 0127 B1 0130 A9 0131 B9 0134 AC 0135 BC 015C DE 015D FE 015E AA 015F BA 016C DD 016D FD 017B AF 017C BF 02D8 A2 02D9 FF}
} -result {}

# iso8859-3 - invalid byte sequences
lappend encInvalidBytes {*}{
    iso8859-3 A5 tcl8    \U000000A5 -1 {} {}
    iso8859-3 A5 replace \uFFFD -1 {} {}
    iso8859-3 A5 strict  {}       0 {} {}
    iso8859-3 AE tcl8    \U000000AE -1 {} {}
    iso8859-3 AE replace \uFFFD -1 {} {}
    iso8859-3 AE strict  {}       0 {} {}
    iso8859-3 BE tcl8    \U000000BE -1 {} {}
    iso8859-3 BE replace \uFFFD -1 {} {}
    iso8859-3 BE strict  {}       0 {} {}
    iso8859-3 C3 tcl8    \U000000C3 -1 {} {}
    iso8859-3 C3 replace \uFFFD -1 {} {}
    iso8859-3 C3 strict  {}       0 {} {}
    iso8859-3 D0 tcl8    \U000000D0 -1 {} {}
    iso8859-3 D0 replace \uFFFD -1 {} {}
    iso8859-3 D0 strict  {}       0 {} {}
    iso8859-3 E3 tcl8    \U000000E3 -1 {} {}
    iso8859-3 E3 replace \uFFFD -1 {} {}
    iso8859-3 E3 strict  {}       0 {} {}
    iso8859-3 F0 tcl8    \U000000F0 -1 {} {}
    iso8859-3 F0 replace \uFFFD -1 {} {}
    iso8859-3 F0 strict  {}       0 {} {}
}; # iso8859-3

# iso8859-3 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-3 \U000000A1 tcl8    1A -1 {} {}
    iso8859-3 \U000000A1 replace 1A -1 {} {}
    iso8859-3 \U000000A1 strict  {}                      0 {} {}
    iso8859-3 \U00000400 tcl8    1A -1 {} {}
    iso8859-3 \U00000400 replace 1A -1 {} {}
    iso8859-3 \U00000400 strict  {}                      0 {} {}
    iso8859-3 \U0000D800 tcl8    1A -1 {} {}
    iso8859-3 \U0000D800 replace 1A -1 {} {}
    iso8859-3 \U0000D800 strict  {}                      0 {} {}
    iso8859-3 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-3 \U0000DC00 replace 1A -1 {} {}
    iso8859-3 \U0000DC00 strict  {}                      0 {} {}
    iso8859-3 \U00010000 tcl8    1A -1 {} {}
    iso8859-3 \U00010000 replace 1A -1 {} {}
    iso8859-3 \U00010000 strict  {}                      0 {} {}
    iso8859-3 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-3 \U0010FFFF replace 1A -1 {} {}
    iso8859-3 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-3

#
# iso8859-4 (generated from glibc-ISO_8859_4-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-4 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-4 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A4 A4 00A7 A7 00A8 A8 00AD AD 00AF AF 00B0 B0 00B4 B4 00B8 B8 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C9 C9 00CB CB 00CD CD 00CE CE 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00DA DA 00DB DB 00DC DC 00DF DF 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E9 E9 00EB EB 00ED ED 00EE EE 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00FA FA 00FB FB 00FC FC 0100 C0 0101 E0 0104 A1 0105 B1 010C C8 010D E8 0110 D0 0111 F0 0112 AA 0113 BA 0116 CC 0117 EC 0118 CA 0119 EA 0122 AB 0123 BB 0128 A5 0129 B5 012A CF 012B EF 012E C7 012F E7 0136 D3 0137 F3 0138 A2 013B A6 013C B6 0145 D1 0146 F1 014A BD 014B BF 014C D2 014D F2 0156 A3 0157 B3 0160 A9 0161 B9 0166 AC 0167 BC 0168 DD 0169 FD 016A DE 016B FE 0172 D9 0173 F9 017D AE 017E BE 02C7 B7 02D9 FF 02DB B2}
} -result {}

test encoding-convertto-ucmCompare-iso8859-4 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-4 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A4 A4 00A7 A7 00A8 A8 00AD AD 00AF AF 00B0 B0 00B4 B4 00B8 B8 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C9 C9 00CB CB 00CD CD 00CE CE 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00DA DA 00DB DB 00DC DC 00DF DF 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E9 E9 00EB EB 00ED ED 00EE EE 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00FA FA 00FB FB 00FC FC 0100 C0 0101 E0 0104 A1 0105 B1 010C C8 010D E8 0110 D0 0111 F0 0112 AA 0113 BA 0116 CC 0117 EC 0118 CA 0119 EA 0122 AB 0123 BB 0128 A5 0129 B5 012A CF 012B EF 012E C7 012F E7 0136 D3 0137 F3 0138 A2 013B A6 013C B6 0145 D1 0146 F1 014A BD 014B BF 014C D2 014D F2 0156 A3 0157 B3 0160 A9 0161 B9 0166 AC 0167 BC 0168 DD 0169 FD 016A DE 016B FE 0172 D9 0173 F9 017D AE 017E BE 02C7 B7 02D9 FF 02DB B2}
} -result {}

# iso8859-4 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-4

# iso8859-4 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-4 \U000000A1 tcl8    1A -1 {} {}
    iso8859-4 \U000000A1 replace 1A -1 {} {}
    iso8859-4 \U000000A1 strict  {}                      0 {} {}
    iso8859-4 \U00000400 tcl8    1A -1 {} {}
    iso8859-4 \U00000400 replace 1A -1 {} {}
    iso8859-4 \U00000400 strict  {}                      0 {} {}
    iso8859-4 \U0000D800 tcl8    1A -1 {} {}
    iso8859-4 \U0000D800 replace 1A -1 {} {}
    iso8859-4 \U0000D800 strict  {}                      0 {} {}
    iso8859-4 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-4 \U0000DC00 replace 1A -1 {} {}
    iso8859-4 \U0000DC00 strict  {}                      0 {} {}
    iso8859-4 \U00010000 tcl8    1A -1 {} {}
    iso8859-4 \U00010000 replace 1A -1 {} {}
    iso8859-4 \U00010000 strict  {}                      0 {} {}
    iso8859-4 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-4 \U0010FFFF replace 1A -1 {} {}
    iso8859-4 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-4

#
# iso8859-5 (generated from glibc-ISO_8859_5-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-5 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-5 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A7 FD 00AD AD 0401 A1 0402 A2 0403 A3 0404 A4 0405 A5 0406 A6 0407 A7 0408 A8 0409 A9 040A AA 040B AB 040C AC 040E AE 040F AF 0410 B0 0411 B1 0412 B2 0413 B3 0414 B4 0415 B5 0416 B6 0417 B7 0418 B8 0419 B9 041A BA 041B BB 041C BC 041D BD 041E BE 041F BF 0420 C0 0421 C1 0422 C2 0423 C3 0424 C4 0425 C5 0426 C6 0427 C7 0428 C8 0429 C9 042A CA 042B CB 042C CC 042D CD 042E CE 042F CF 0430 D0 0431 D1 0432 D2 0433 D3 0434 D4 0435 D5 0436 D6 0437 D7 0438 D8 0439 D9 043A DA 043B DB 043C DC 043D DD 043E DE 043F DF 0440 E0 0441 E1 0442 E2 0443 E3 0444 E4 0445 E5 0446 E6 0447 E7 0448 E8 0449 E9 044A EA 044B EB 044C EC 044D ED 044E EE 044F EF 0451 F1 0452 F2 0453 F3 0454 F4 0455 F5 0456 F6 0457 F7 0458 F8 0459 F9 045A FA 045B FB 045C FC 045E FE 045F FF 2116 F0}
} -result {}

test encoding-convertto-ucmCompare-iso8859-5 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-5 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A7 FD 00AD AD 0401 A1 0402 A2 0403 A3 0404 A4 0405 A5 0406 A6 0407 A7 0408 A8 0409 A9 040A AA 040B AB 040C AC 040E AE 040F AF 0410 B0 0411 B1 0412 B2 0413 B3 0414 B4 0415 B5 0416 B6 0417 B7 0418 B8 0419 B9 041A BA 041B BB 041C BC 041D BD 041E BE 041F BF 0420 C0 0421 C1 0422 C2 0423 C3 0424 C4 0425 C5 0426 C6 0427 C7 0428 C8 0429 C9 042A CA 042B CB 042C CC 042D CD 042E CE 042F CF 0430 D0 0431 D1 0432 D2 0433 D3 0434 D4 0435 D5 0436 D6 0437 D7 0438 D8 0439 D9 043A DA 043B DB 043C DC 043D DD 043E DE 043F DF 0440 E0 0441 E1 0442 E2 0443 E3 0444 E4 0445 E5 0446 E6 0447 E7 0448 E8 0449 E9 044A EA 044B EB 044C EC 044D ED 044E EE 044F EF 0451 F1 0452 F2 0453 F3 0454 F4 0455 F5 0456 F6 0457 F7 0458 F8 0459 F9 045A FA 045B FB 045C FC 045E FE 045F FF 2116 F0}
} -result {}

# iso8859-5 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-5

# iso8859-5 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-5 \U000000A1 tcl8    1A -1 {} {}
    iso8859-5 \U000000A1 replace 1A -1 {} {}
    iso8859-5 \U000000A1 strict  {}                      0 {} {}
    iso8859-5 \U00000400 tcl8    1A -1 {} {}
    iso8859-5 \U00000400 replace 1A -1 {} {}
    iso8859-5 \U00000400 strict  {}                      0 {} {}
    iso8859-5 \U0000D800 tcl8    1A -1 {} {}
    iso8859-5 \U0000D800 replace 1A -1 {} {}
    iso8859-5 \U0000D800 strict  {}                      0 {} {}
    iso8859-5 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-5 \U0000DC00 replace 1A -1 {} {}
    iso8859-5 \U0000DC00 strict  {}                      0 {} {}
    iso8859-5 \U00010000 tcl8    1A -1 {} {}
    iso8859-5 \U00010000 replace 1A -1 {} {}
    iso8859-5 \U00010000 strict  {}                      0 {} {}
    iso8859-5 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-5 \U0010FFFF replace 1A -1 {} {}
    iso8859-5 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-5

#
# iso8859-6 (generated from glibc-ISO_8859_6-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-6 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-6 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A4 A4 00AD AD 060C AC 061B BB 061F BF 0621 C1 0622 C2 0623 C3 0624 C4 0625 C5 0626 C6 0627 C7 0628 C8 0629 C9 062A CA 062B CB 062C CC 062D CD 062E CE 062F CF 0630 D0 0631 D1 0632 D2 0633 D3 0634 D4 0635 D5 0636 D6 0637 D7 0638 D8 0639 D9 063A DA 0640 E0 0641 E1 0642 E2 0643 E3 0644 E4 0645 E5 0646 E6 0647 E7 0648 E8 0649 E9 064A EA 064B EB 064C EC 064D ED 064E EE 064F EF 0650 F0 0651 F1 0652 F2}
} -result {}

test encoding-convertto-ucmCompare-iso8859-6 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-6 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A4 A4 00AD AD 060C AC 061B BB 061F BF 0621 C1 0622 C2 0623 C3 0624 C4 0625 C5 0626 C6 0627 C7 0628 C8 0629 C9 062A CA 062B CB 062C CC 062D CD 062E CE 062F CF 0630 D0 0631 D1 0632 D2 0633 D3 0634 D4 0635 D5 0636 D6 0637 D7 0638 D8 0639 D9 063A DA 0640 E0 0641 E1 0642 E2 0643 E3 0644 E4 0645 E5 0646 E6 0647 E7 0648 E8 0649 E9 064A EA 064B EB 064C EC 064D ED 064E EE 064F EF 0650 F0 0651 F1 0652 F2}
} -result {}

# iso8859-6 - invalid byte sequences
lappend encInvalidBytes {*}{
    iso8859-6 A1 tcl8    \U000000A1 -1 {} {}
    iso8859-6 A1 replace \uFFFD -1 {} {}
    iso8859-6 A1 strict  {}       0 {} {}
    iso8859-6 A2 tcl8    \U000000A2 -1 {} {}
    iso8859-6 A2 replace \uFFFD -1 {} {}
    iso8859-6 A2 strict  {}       0 {} {}
    iso8859-6 A3 tcl8    \U000000A3 -1 {} {}
    iso8859-6 A3 replace \uFFFD -1 {} {}
    iso8859-6 A3 strict  {}       0 {} {}
    iso8859-6 A5 tcl8    \U000000A5 -1 {} {}
    iso8859-6 A5 replace \uFFFD -1 {} {}
    iso8859-6 A5 strict  {}       0 {} {}
    iso8859-6 A6 tcl8    \U000000A6 -1 {} {}
    iso8859-6 A6 replace \uFFFD -1 {} {}
    iso8859-6 A6 strict  {}       0 {} {}
    iso8859-6 A7 tcl8    \U000000A7 -1 {} {}
    iso8859-6 A7 replace \uFFFD -1 {} {}
    iso8859-6 A7 strict  {}       0 {} {}
    iso8859-6 A8 tcl8    \U000000A8 -1 {} {}
    iso8859-6 A8 replace \uFFFD -1 {} {}
    iso8859-6 A8 strict  {}       0 {} {}
    iso8859-6 A9 tcl8    \U000000A9 -1 {} {}
    iso8859-6 A9 replace \uFFFD -1 {} {}
    iso8859-6 A9 strict  {}       0 {} {}
    iso8859-6 AA tcl8    \U000000AA -1 {} {}
    iso8859-6 AA replace \uFFFD -1 {} {}
    iso8859-6 AA strict  {}       0 {} {}
    iso8859-6 AB tcl8    \U000000AB -1 {} {}
    iso8859-6 AB replace \uFFFD -1 {} {}
    iso8859-6 AB strict  {}       0 {} {}
    iso8859-6 AE tcl8    \U000000AE -1 {} {}
    iso8859-6 AE replace \uFFFD -1 {} {}
    iso8859-6 AE strict  {}       0 {} {}
    iso8859-6 AF tcl8    \U000000AF -1 {} {}
    iso8859-6 AF replace \uFFFD -1 {} {}
    iso8859-6 AF strict  {}       0 {} {}
    iso8859-6 B0 tcl8    \U000000B0 -1 {} {}
    iso8859-6 B0 replace \uFFFD -1 {} {}
    iso8859-6 B0 strict  {}       0 {} {}
    iso8859-6 B1 tcl8    \U000000B1 -1 {} {}
    iso8859-6 B1 replace \uFFFD -1 {} {}
    iso8859-6 B1 strict  {}       0 {} {}
    iso8859-6 B2 tcl8    \U000000B2 -1 {} {}
    iso8859-6 B2 replace \uFFFD -1 {} {}
    iso8859-6 B2 strict  {}       0 {} {}
    iso8859-6 B3 tcl8    \U000000B3 -1 {} {}
    iso8859-6 B3 replace \uFFFD -1 {} {}
    iso8859-6 B3 strict  {}       0 {} {}
    iso8859-6 B4 tcl8    \U000000B4 -1 {} {}
    iso8859-6 B4 replace \uFFFD -1 {} {}
    iso8859-6 B4 strict  {}       0 {} {}
    iso8859-6 B5 tcl8    \U000000B5 -1 {} {}
    iso8859-6 B5 replace \uFFFD -1 {} {}
    iso8859-6 B5 strict  {}       0 {} {}
    iso8859-6 B6 tcl8    \U000000B6 -1 {} {}
    iso8859-6 B6 replace \uFFFD -1 {} {}
    iso8859-6 B6 strict  {}       0 {} {}
    iso8859-6 B7 tcl8    \U000000B7 -1 {} {}
    iso8859-6 B7 replace \uFFFD -1 {} {}
    iso8859-6 B7 strict  {}       0 {} {}
    iso8859-6 B8 tcl8    \U000000B8 -1 {} {}
    iso8859-6 B8 replace \uFFFD -1 {} {}
    iso8859-6 B8 strict  {}       0 {} {}
    iso8859-6 B9 tcl8    \U000000B9 -1 {} {}
    iso8859-6 B9 replace \uFFFD -1 {} {}
    iso8859-6 B9 strict  {}       0 {} {}
    iso8859-6 BA tcl8    \U000000BA -1 {} {}
    iso8859-6 BA replace \uFFFD -1 {} {}
    iso8859-6 BA strict  {}       0 {} {}
    iso8859-6 BC tcl8    \U000000BC -1 {} {}
    iso8859-6 BC replace \uFFFD -1 {} {}
    iso8859-6 BC strict  {}       0 {} {}
    iso8859-6 BD tcl8    \U000000BD -1 {} {}
    iso8859-6 BD replace \uFFFD -1 {} {}
    iso8859-6 BD strict  {}       0 {} {}
    iso8859-6 BE tcl8    \U000000BE -1 {} {}
    iso8859-6 BE replace \uFFFD -1 {} {}
    iso8859-6 BE strict  {}       0 {} {}
    iso8859-6 C0 tcl8    \U000000C0 -1 {} {}
    iso8859-6 C0 replace \uFFFD -1 {} {}
    iso8859-6 C0 strict  {}       0 {} {}
    iso8859-6 DB tcl8    \U000000DB -1 {} {}
    iso8859-6 DB replace \uFFFD -1 {} {}
    iso8859-6 DB strict  {}       0 {} {}
    iso8859-6 DC tcl8    \U000000DC -1 {} {}
    iso8859-6 DC replace \uFFFD -1 {} {}
    iso8859-6 DC strict  {}       0 {} {}
    iso8859-6 DD tcl8    \U000000DD -1 {} {}
    iso8859-6 DD replace \uFFFD -1 {} {}
    iso8859-6 DD strict  {}       0 {} {}
    iso8859-6 DE tcl8    \U000000DE -1 {} {}
    iso8859-6 DE replace \uFFFD -1 {} {}
    iso8859-6 DE strict  {}       0 {} {}
    iso8859-6 DF tcl8    \U000000DF -1 {} {}
    iso8859-6 DF replace \uFFFD -1 {} {}
    iso8859-6 DF strict  {}       0 {} {}
    iso8859-6 F3 tcl8    \U000000F3 -1 {} {}
    iso8859-6 F3 replace \uFFFD -1 {} {}
    iso8859-6 F3 strict  {}       0 {} {}
    iso8859-6 F4 tcl8    \U000000F4 -1 {} {}
    iso8859-6 F4 replace \uFFFD -1 {} {}
    iso8859-6 F4 strict  {}       0 {} {}
    iso8859-6 F5 tcl8    \U000000F5 -1 {} {}
    iso8859-6 F5 replace \uFFFD -1 {} {}
    iso8859-6 F5 strict  {}       0 {} {}
    iso8859-6 F6 tcl8    \U000000F6 -1 {} {}
    iso8859-6 F6 replace \uFFFD -1 {} {}
    iso8859-6 F6 strict  {}       0 {} {}
    iso8859-6 F7 tcl8    \U000000F7 -1 {} {}
    iso8859-6 F7 replace \uFFFD -1 {} {}
    iso8859-6 F7 strict  {}       0 {} {}
    iso8859-6 F8 tcl8    \U000000F8 -1 {} {}
    iso8859-6 F8 replace \uFFFD -1 {} {}
    iso8859-6 F8 strict  {}       0 {} {}
    iso8859-6 F9 tcl8    \U000000F9 -1 {} {}
    iso8859-6 F9 replace \uFFFD -1 {} {}
    iso8859-6 F9 strict  {}       0 {} {}
    iso8859-6 FA tcl8    \U000000FA -1 {} {}
    iso8859-6 FA replace \uFFFD -1 {} {}
    iso8859-6 FA strict  {}       0 {} {}
    iso8859-6 FB tcl8    \U000000FB -1 {} {}
    iso8859-6 FB replace \uFFFD -1 {} {}
    iso8859-6 FB strict  {}       0 {} {}
    iso8859-6 FC tcl8    \U000000FC -1 {} {}
    iso8859-6 FC replace \uFFFD -1 {} {}
    iso8859-6 FC strict  {}       0 {} {}
    iso8859-6 FD tcl8    \U000000FD -1 {} {}
    iso8859-6 FD replace \uFFFD -1 {} {}
    iso8859-6 FD strict  {}       0 {} {}
    iso8859-6 FE tcl8    \U000000FE -1 {} {}
    iso8859-6 FE replace \uFFFD -1 {} {}
    iso8859-6 FE strict  {}       0 {} {}
    iso8859-6 FF tcl8    \U000000FF -1 {} {}
    iso8859-6 FF replace \uFFFD -1 {} {}
    iso8859-6 FF strict  {}       0 {} {}
}; # iso8859-6

# iso8859-6 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-6 \U000000A1 tcl8    1A -1 {} {}
    iso8859-6 \U000000A1 replace 1A -1 {} {}
    iso8859-6 \U000000A1 strict  {}                      0 {} {}
    iso8859-6 \U00000400 tcl8    1A -1 {} {}
    iso8859-6 \U00000400 replace 1A -1 {} {}
    iso8859-6 \U00000400 strict  {}                      0 {} {}
    iso8859-6 \U0000D800 tcl8    1A -1 {} {}
    iso8859-6 \U0000D800 replace 1A -1 {} {}
    iso8859-6 \U0000D800 strict  {}                      0 {} {}
    iso8859-6 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-6 \U0000DC00 replace 1A -1 {} {}
    iso8859-6 \U0000DC00 strict  {}                      0 {} {}
    iso8859-6 \U00010000 tcl8    1A -1 {} {}
    iso8859-6 \U00010000 replace 1A -1 {} {}
    iso8859-6 \U00010000 strict  {}                      0 {} {}
    iso8859-6 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-6 \U0010FFFF replace 1A -1 {} {}
    iso8859-6 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-6

#
# iso8859-7 (generated from glibc-ISO_8859_7-2.3.3)

test encoding-convertfrom-ucmCompare-iso8859-7 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-7 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A3 A3 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B7 B7 00BB BB 00BD BD 037A AA 0384 B4 0385 B5 0386 B6 0388 B8 0389 B9 038A BA 038C BC 038E BE 038F BF 0390 C0 0391 C1 0392 C2 0393 C3 0394 C4 0395 C5 0396 C6 0397 C7 0398 C8 0399 C9 039A CA 039B CB 039C CC 039D CD 039E CE 039F CF 03A0 D0 03A1 D1 03A3 D3 03A4 D4 03A5 D5 03A6 D6 03A7 D7 03A8 D8 03A9 D9 03AA DA 03AB DB 03AC DC 03AD DD 03AE DE 03AF DF 03B0 E0 03B1 E1 03B2 E2 03B3 E3 03B4 E4 03B5 E5 03B6 E6 03B7 E7 03B8 E8 03B9 E9 03BA EA 03BB EB 03BC EC 03BD ED 03BE EE 03BF EF 03C0 F0 03C1 F1 03C2 F2 03C3 F3 03C4 F4 03C5 F5 03C6 F6 03C7 F7 03C8 F8 03C9 F9 03CA FA 03CB FB 03CC FC 03CD FD 03CE FE 2015 AF 2018 A1 2019 A2 20AC A4 20AF A5}
} -result {}

test encoding-convertto-ucmCompare-iso8859-7 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-7 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A3 A3 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B7 B7 00BB BB 00BD BD 037A AA 0384 B4 0385 B5 0386 B6 0388 B8 0389 B9 038A BA 038C BC 038E BE 038F BF 0390 C0 0391 C1 0392 C2 0393 C3 0394 C4 0395 C5 0396 C6 0397 C7 0398 C8 0399 C9 039A CA 039B CB 039C CC 039D CD 039E CE 039F CF 03A0 D0 03A1 D1 03A3 D3 03A4 D4 03A5 D5 03A6 D6 03A7 D7 03A8 D8 03A9 D9 03AA DA 03AB DB 03AC DC 03AD DD 03AE DE 03AF DF 03B0 E0 03B1 E1 03B2 E2 03B3 E3 03B4 E4 03B5 E5 03B6 E6 03B7 E7 03B8 E8 03B9 E9 03BA EA 03BB EB 03BC EC 03BD ED 03BE EE 03BF EF 03C0 F0 03C1 F1 03C2 F2 03C3 F3 03C4 F4 03C5 F5 03C6 F6 03C7 F7 03C8 F8 03C9 F9 03CA FA 03CB FB 03CC FC 03CD FD 03CE FE 2015 AF 2018 A1 2019 A2 20AC A4 20AF A5}
} -result {}

# iso8859-7 - invalid byte sequences
lappend encInvalidBytes {*}{
    iso8859-7 AE tcl8    \U000000AE -1 {} {}
    iso8859-7 AE replace \uFFFD -1 {} {}
    iso8859-7 AE strict  {}       0 {} {}
    iso8859-7 D2 tcl8    \U000000D2 -1 {} {}
    iso8859-7 D2 replace \uFFFD -1 {} {}
    iso8859-7 D2 strict  {}       0 {} {}
    iso8859-7 FF tcl8    \U000000FF -1 {} {}
    iso8859-7 FF replace \uFFFD -1 {} {}
    iso8859-7 FF strict  {}       0 {} {}
}; # iso8859-7

# iso8859-7 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-7 \U000000A1 tcl8    1A -1 {} {}
    iso8859-7 \U000000A1 replace 1A -1 {} {}
    iso8859-7 \U000000A1 strict  {}                      0 {} {}
    iso8859-7 \U00000400 tcl8    1A -1 {} {}
    iso8859-7 \U00000400 replace 1A -1 {} {}
    iso8859-7 \U00000400 strict  {}                      0 {} {}
    iso8859-7 \U0000D800 tcl8    1A -1 {} {}
    iso8859-7 \U0000D800 replace 1A -1 {} {}
    iso8859-7 \U0000D800 strict  {}                      0 {} {}
    iso8859-7 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-7 \U0000DC00 replace 1A -1 {} {}
    iso8859-7 \U0000DC00 strict  {}                      0 {} {}
    iso8859-7 \U00010000 tcl8    1A -1 {} {}
    iso8859-7 \U00010000 replace 1A -1 {} {}
    iso8859-7 \U00010000 strict  {}                      0 {} {}
    iso8859-7 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-7 \U0010FFFF replace 1A -1 {} {}
    iso8859-7 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-7

#
# iso8859-8 (generated from glibc-ISO_8859_8-2.3.3)

test encoding-convertfrom-ucmCompare-iso8859-8 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-8 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00D7 AA 00F7 BA 05D0 E0 05D1 E1 05D2 E2 05D3 E3 05D4 E4 05D5 E5 05D6 E6 05D7 E7 05D8 E8 05D9 E9 05DA EA 05DB EB 05DC EC 05DD ED 05DE EE 05DF EF 05E0 F0 05E1 F1 05E2 F2 05E3 F3 05E4 F4 05E5 F5 05E6 F6 05E7 F7 05E8 F8 05E9 F9 05EA FA 200E FD 200F FE 2017 DF}
} -result {}

test encoding-convertto-ucmCompare-iso8859-8 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-8 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00D7 AA 00F7 BA 05D0 E0 05D1 E1 05D2 E2 05D3 E3 05D4 E4 05D5 E5 05D6 E6 05D7 E7 05D8 E8 05D9 E9 05DA EA 05DB EB 05DC EC 05DD ED 05DE EE 05DF EF 05E0 F0 05E1 F1 05E2 F2 05E3 F3 05E4 F4 05E5 F5 05E6 F6 05E7 F7 05E8 F8 05E9 F9 05EA FA 200E FD 200F FE 2017 DF}
} -result {}

# iso8859-8 - invalid byte sequences
lappend encInvalidBytes {*}{
    iso8859-8 A1 tcl8    \U000000A1 -1 {} {}
    iso8859-8 A1 replace \uFFFD -1 {} {}
    iso8859-8 A1 strict  {}       0 {} {}
    iso8859-8 BF tcl8    \U000000BF -1 {} {}
    iso8859-8 BF replace \uFFFD -1 {} {}
    iso8859-8 BF strict  {}       0 {} {}
    iso8859-8 C0 tcl8    \U000000C0 -1 {} {}
    iso8859-8 C0 replace \uFFFD -1 {} {}
    iso8859-8 C0 strict  {}       0 {} {}
    iso8859-8 C1 tcl8    \U000000C1 -1 {} {}
    iso8859-8 C1 replace \uFFFD -1 {} {}
    iso8859-8 C1 strict  {}       0 {} {}
    iso8859-8 C2 tcl8    \U000000C2 -1 {} {}
    iso8859-8 C2 replace \uFFFD -1 {} {}
    iso8859-8 C2 strict  {}       0 {} {}
    iso8859-8 C3 tcl8    \U000000C3 -1 {} {}
    iso8859-8 C3 replace \uFFFD -1 {} {}
    iso8859-8 C3 strict  {}       0 {} {}
    iso8859-8 C4 tcl8    \U000000C4 -1 {} {}
    iso8859-8 C4 replace \uFFFD -1 {} {}
    iso8859-8 C4 strict  {}       0 {} {}
    iso8859-8 C5 tcl8    \U000000C5 -1 {} {}
    iso8859-8 C5 replace \uFFFD -1 {} {}
    iso8859-8 C5 strict  {}       0 {} {}
    iso8859-8 C6 tcl8    \U000000C6 -1 {} {}
    iso8859-8 C6 replace \uFFFD -1 {} {}
    iso8859-8 C6 strict  {}       0 {} {}
    iso8859-8 C7 tcl8    \U000000C7 -1 {} {}
    iso8859-8 C7 replace \uFFFD -1 {} {}
    iso8859-8 C7 strict  {}       0 {} {}
    iso8859-8 C8 tcl8    \U000000C8 -1 {} {}
    iso8859-8 C8 replace \uFFFD -1 {} {}
    iso8859-8 C8 strict  {}       0 {} {}
    iso8859-8 C9 tcl8    \U000000C9 -1 {} {}
    iso8859-8 C9 replace \uFFFD -1 {} {}
    iso8859-8 C9 strict  {}       0 {} {}
    iso8859-8 CA tcl8    \U000000CA -1 {} {}
    iso8859-8 CA replace \uFFFD -1 {} {}
    iso8859-8 CA strict  {}       0 {} {}
    iso8859-8 CB tcl8    \U000000CB -1 {} {}
    iso8859-8 CB replace \uFFFD -1 {} {}
    iso8859-8 CB strict  {}       0 {} {}
    iso8859-8 CC tcl8    \U000000CC -1 {} {}
    iso8859-8 CC replace \uFFFD -1 {} {}
    iso8859-8 CC strict  {}       0 {} {}
    iso8859-8 CD tcl8    \U000000CD -1 {} {}
    iso8859-8 CD replace \uFFFD -1 {} {}
    iso8859-8 CD strict  {}       0 {} {}
    iso8859-8 CE tcl8    \U000000CE -1 {} {}
    iso8859-8 CE replace \uFFFD -1 {} {}
    iso8859-8 CE strict  {}       0 {} {}
    iso8859-8 CF tcl8    \U000000CF -1 {} {}
    iso8859-8 CF replace \uFFFD -1 {} {}
    iso8859-8 CF strict  {}       0 {} {}
    iso8859-8 D0 tcl8    \U000000D0 -1 {} {}
    iso8859-8 D0 replace \uFFFD -1 {} {}
    iso8859-8 D0 strict  {}       0 {} {}
    iso8859-8 D1 tcl8    \U000000D1 -1 {} {}
    iso8859-8 D1 replace \uFFFD -1 {} {}
    iso8859-8 D1 strict  {}       0 {} {}
    iso8859-8 D2 tcl8    \U000000D2 -1 {} {}
    iso8859-8 D2 replace \uFFFD -1 {} {}
    iso8859-8 D2 strict  {}       0 {} {}
    iso8859-8 D3 tcl8    \U000000D3 -1 {} {}
    iso8859-8 D3 replace \uFFFD -1 {} {}
    iso8859-8 D3 strict  {}       0 {} {}
    iso8859-8 D4 tcl8    \U000000D4 -1 {} {}
    iso8859-8 D4 replace \uFFFD -1 {} {}
    iso8859-8 D4 strict  {}       0 {} {}
    iso8859-8 D5 tcl8    \U000000D5 -1 {} {}
    iso8859-8 D5 replace \uFFFD -1 {} {}
    iso8859-8 D5 strict  {}       0 {} {}
    iso8859-8 D6 tcl8    \U000000D6 -1 {} {}
    iso8859-8 D6 replace \uFFFD -1 {} {}
    iso8859-8 D6 strict  {}       0 {} {}
    iso8859-8 D7 tcl8    \U000000D7 -1 {} {}
    iso8859-8 D7 replace \uFFFD -1 {} {}
    iso8859-8 D7 strict  {}       0 {} {}
    iso8859-8 D8 tcl8    \U000000D8 -1 {} {}
    iso8859-8 D8 replace \uFFFD -1 {} {}
    iso8859-8 D8 strict  {}       0 {} {}
    iso8859-8 D9 tcl8    \U000000D9 -1 {} {}
    iso8859-8 D9 replace \uFFFD -1 {} {}
    iso8859-8 D9 strict  {}       0 {} {}
    iso8859-8 DA tcl8    \U000000DA -1 {} {}
    iso8859-8 DA replace \uFFFD -1 {} {}
    iso8859-8 DA strict  {}       0 {} {}
    iso8859-8 DB tcl8    \U000000DB -1 {} {}
    iso8859-8 DB replace \uFFFD -1 {} {}
    iso8859-8 DB strict  {}       0 {} {}
    iso8859-8 DC tcl8    \U000000DC -1 {} {}
    iso8859-8 DC replace \uFFFD -1 {} {}
    iso8859-8 DC strict  {}       0 {} {}
    iso8859-8 DD tcl8    \U000000DD -1 {} {}
    iso8859-8 DD replace \uFFFD -1 {} {}
    iso8859-8 DD strict  {}       0 {} {}
    iso8859-8 DE tcl8    \U000000DE -1 {} {}
    iso8859-8 DE replace \uFFFD -1 {} {}
    iso8859-8 DE strict  {}       0 {} {}
    iso8859-8 FB tcl8    \U000000FB -1 {} {}
    iso8859-8 FB replace \uFFFD -1 {} {}
    iso8859-8 FB strict  {}       0 {} {}
    iso8859-8 FC tcl8    \U000000FC -1 {} {}
    iso8859-8 FC replace \uFFFD -1 {} {}
    iso8859-8 FC strict  {}       0 {} {}
    iso8859-8 FF tcl8    \U000000FF -1 {} {}
    iso8859-8 FF replace \uFFFD -1 {} {}
    iso8859-8 FF strict  {}       0 {} {}
}; # iso8859-8

# iso8859-8 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-8 \U000000A1 tcl8    1A -1 {} {}
    iso8859-8 \U000000A1 replace 1A -1 {} {}
    iso8859-8 \U000000A1 strict  {}                      0 {} {}
    iso8859-8 \U00000400 tcl8    1A -1 {} {}
    iso8859-8 \U00000400 replace 1A -1 {} {}
    iso8859-8 \U00000400 strict  {}                      0 {} {}
    iso8859-8 \U0000D800 tcl8    1A -1 {} {}
    iso8859-8 \U0000D800 replace 1A -1 {} {}
    iso8859-8 \U0000D800 strict  {}                      0 {} {}
    iso8859-8 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-8 \U0000DC00 replace 1A -1 {} {}
    iso8859-8 \U0000DC00 strict  {}                      0 {} {}
    iso8859-8 \U00010000 tcl8    1A -1 {} {}
    iso8859-8 \U00010000 replace 1A -1 {} {}
    iso8859-8 \U00010000 strict  {}                      0 {} {}
    iso8859-8 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-8 \U0010FFFF replace 1A -1 {} {}
    iso8859-8 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-8

#
# iso8859-9 (generated from glibc-ISO_8859_9-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-9 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-9 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 011E D0 011F F0 0130 DD 0131 FD 015E DE 015F FE}
} -result {}

test encoding-convertto-ucmCompare-iso8859-9 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-9 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A4 A4 00A5 A5 00A6 A6 00A7 A7 00A8 A8 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B4 B4 00B5 B5 00B6 B6 00B7 B7 00B8 B8 00B9 B9 00BA BA 00BB BB 00BC BC 00BD BD 00BE BE 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 011E D0 011F F0 0130 DD 0131 FD 015E DE 015F FE}
} -result {}

# iso8859-9 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-9

# iso8859-9 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-9 \U000000D0 tcl8    1A -1 {} {}
    iso8859-9 \U000000D0 replace 1A -1 {} {}
    iso8859-9 \U000000D0 strict  {}                      0 {} {}
    iso8859-9 \U00000400 tcl8    1A -1 {} {}
    iso8859-9 \U00000400 replace 1A -1 {} {}
    iso8859-9 \U00000400 strict  {}                      0 {} {}
    iso8859-9 \U0000D800 tcl8    1A -1 {} {}
    iso8859-9 \U0000D800 replace 1A -1 {} {}
    iso8859-9 \U0000D800 strict  {}                      0 {} {}
    iso8859-9 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-9 \U0000DC00 replace 1A -1 {} {}
    iso8859-9 \U0000DC00 strict  {}                      0 {} {}
    iso8859-9 \U00010000 tcl8    1A -1 {} {}
    iso8859-9 \U00010000 replace 1A -1 {} {}
    iso8859-9 \U00010000 strict  {}                      0 {} {}
    iso8859-9 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-9 \U0010FFFF replace 1A -1 {} {}
    iso8859-9 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-9

#
# iso8859-10 (generated from glibc-ISO_8859_10-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-10 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-10 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A7 A7 00AD AD 00B0 B0 00B7 B7 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C9 C9 00CB CB 00CD CD 00CE CE 00CF CF 00D0 D0 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D8 D8 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E9 E9 00EB EB 00ED ED 00EE EE 00EF EF 00F0 F0 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F8 F8 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 0100 C0 0101 E0 0104 A1 0105 B1 010C C8 010D E8 0110 A9 0111 B9 0112 A2 0113 B2 0116 CC 0117 EC 0118 CA 0119 EA 0122 A3 0123 B3 0128 A5 0129 B5 012A A4 012B B4 012E C7 012F E7 0136 A6 0137 B6 0138 FF 013B A8 013C B8 0145 D1 0146 F1 014A AF 014B BF 014C D2 014D F2 0160 AA 0161 BA 0166 AB 0167 BB 0168 D7 0169 F7 016A AE 016B BE 0172 D9 0173 F9 017D AC 017E BC 2015 BD}
} -result {}

test encoding-convertto-ucmCompare-iso8859-10 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-10 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A7 A7 00AD AD 00B0 B0 00B7 B7 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C9 C9 00CB CB 00CD CD 00CE CE 00CF CF 00D0 D0 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D8 D8 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E9 E9 00EB EB 00ED ED 00EE EE 00EF EF 00F0 F0 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F8 F8 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 0100 C0 0101 E0 0104 A1 0105 B1 010C C8 010D E8 0110 A9 0111 B9 0112 A2 0113 B2 0116 CC 0117 EC 0118 CA 0119 EA 0122 A3 0123 B3 0128 A5 0129 B5 012A A4 012B B4 012E C7 012F E7 0136 A6 0137 B6 0138 FF 013B A8 013C B8 0145 D1 0146 F1 014A AF 014B BF 014C D2 014D F2 0160 AA 0161 BA 0166 AB 0167 BB 0168 D7 0169 F7 016A AE 016B BE 0172 D9 0173 F9 017D AC 017E BC 2015 BD}
} -result {}

# iso8859-10 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-10

# iso8859-10 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-10 \U000000A1 tcl8    1A -1 {} {}
    iso8859-10 \U000000A1 replace 1A -1 {} {}
    iso8859-10 \U000000A1 strict  {}                      0 {} {}
    iso8859-10 \U00000400 tcl8    1A -1 {} {}
    iso8859-10 \U00000400 replace 1A -1 {} {}
    iso8859-10 \U00000400 strict  {}                      0 {} {}
    iso8859-10 \U0000D800 tcl8    1A -1 {} {}
    iso8859-10 \U0000D800 replace 1A -1 {} {}
    iso8859-10 \U0000D800 strict  {}                      0 {} {}
    iso8859-10 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-10 \U0000DC00 replace 1A -1 {} {}
    iso8859-10 \U0000DC00 strict  {}                      0 {} {}
    iso8859-10 \U00010000 tcl8    1A -1 {} {}
    iso8859-10 \U00010000 replace 1A -1 {} {}
    iso8859-10 \U00010000 strict  {}                      0 {} {}
    iso8859-10 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-10 \U0010FFFF replace 1A -1 {} {}
    iso8859-10 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-10

#
# iso8859-11 (generated from glibc-ISO_8859_11-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-11 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-11 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 0E01 A1 0E02 A2 0E03 A3 0E04 A4 0E05 A5 0E06 A6 0E07 A7 0E08 A8 0E09 A9 0E0A AA 0E0B AB 0E0C AC 0E0D AD 0E0E AE 0E0F AF 0E10 B0 0E11 B1 0E12 B2 0E13 B3 0E14 B4 0E15 B5 0E16 B6 0E17 B7 0E18 B8 0E19 B9 0E1A BA 0E1B BB 0E1C BC 0E1D BD 0E1E BE 0E1F BF 0E20 C0 0E21 C1 0E22 C2 0E23 C3 0E24 C4 0E25 C5 0E26 C6 0E27 C7 0E28 C8 0E29 C9 0E2A CA 0E2B CB 0E2C CC 0E2D CD 0E2E CE 0E2F CF 0E30 D0 0E31 D1 0E32 D2 0E33 D3 0E34 D4 0E35 D5 0E36 D6 0E37 D7 0E38 D8 0E39 D9 0E3A DA 0E3F DF 0E40 E0 0E41 E1 0E42 E2 0E43 E3 0E44 E4 0E45 E5 0E46 E6 0E47 E7 0E48 E8 0E49 E9 0E4A EA 0E4B EB 0E4C EC 0E4D ED 0E4E EE 0E4F EF 0E50 F0 0E51 F1 0E52 F2 0E53 F3 0E54 F4 0E55 F5 0E56 F6 0E57 F7 0E58 F8 0E59 F9 0E5A FA 0E5B FB}
} -result {}

test encoding-convertto-ucmCompare-iso8859-11 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-11 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 0E01 A1 0E02 A2 0E03 A3 0E04 A4 0E05 A5 0E06 A6 0E07 A7 0E08 A8 0E09 A9 0E0A AA 0E0B AB 0E0C AC 0E0D AD 0E0E AE 0E0F AF 0E10 B0 0E11 B1 0E12 B2 0E13 B3 0E14 B4 0E15 B5 0E16 B6 0E17 B7 0E18 B8 0E19 B9 0E1A BA 0E1B BB 0E1C BC 0E1D BD 0E1E BE 0E1F BF 0E20 C0 0E21 C1 0E22 C2 0E23 C3 0E24 C4 0E25 C5 0E26 C6 0E27 C7 0E28 C8 0E29 C9 0E2A CA 0E2B CB 0E2C CC 0E2D CD 0E2E CE 0E2F CF 0E30 D0 0E31 D1 0E32 D2 0E33 D3 0E34 D4 0E35 D5 0E36 D6 0E37 D7 0E38 D8 0E39 D9 0E3A DA 0E3F DF 0E40 E0 0E41 E1 0E42 E2 0E43 E3 0E44 E4 0E45 E5 0E46 E6 0E47 E7 0E48 E8 0E49 E9 0E4A EA 0E4B EB 0E4C EC 0E4D ED 0E4E EE 0E4F EF 0E50 F0 0E51 F1 0E52 F2 0E53 F3 0E54 F4 0E55 F5 0E56 F6 0E57 F7 0E58 F8 0E59 F9 0E5A FA 0E5B FB}
} -result {}

# iso8859-11 - invalid byte sequences
lappend encInvalidBytes {*}{
    iso8859-11 DB tcl8    \U000000DB -1 {} {}
    iso8859-11 DB replace \uFFFD -1 {} {}
    iso8859-11 DB strict  {}       0 {} {}
    iso8859-11 DC tcl8    \U000000DC -1 {} {}
    iso8859-11 DC replace \uFFFD -1 {} {}
    iso8859-11 DC strict  {}       0 {} {}
    iso8859-11 DD tcl8    \U000000DD -1 {} {}
    iso8859-11 DD replace \uFFFD -1 {} {}
    iso8859-11 DD strict  {}       0 {} {}
    iso8859-11 DE tcl8    \U000000DE -1 {} {}
    iso8859-11 DE replace \uFFFD -1 {} {}
    iso8859-11 DE strict  {}       0 {} {}
    iso8859-11 FC tcl8    \U000000FC -1 {} {}
    iso8859-11 FC replace \uFFFD -1 {} {}
    iso8859-11 FC strict  {}       0 {} {}
    iso8859-11 FD tcl8    \U000000FD -1 {} {}
    iso8859-11 FD replace \uFFFD -1 {} {}
    iso8859-11 FD strict  {}       0 {} {}
    iso8859-11 FE tcl8    \U000000FE -1 {} {}
    iso8859-11 FE replace \uFFFD -1 {} {}
    iso8859-11 FE strict  {}       0 {} {}
    iso8859-11 FF tcl8    \U000000FF -1 {} {}
    iso8859-11 FF replace \uFFFD -1 {} {}
    iso8859-11 FF strict  {}       0 {} {}
}; # iso8859-11

# iso8859-11 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-11 \U000000A1 tcl8    1A -1 {} {}
    iso8859-11 \U000000A1 replace 1A -1 {} {}
    iso8859-11 \U000000A1 strict  {}                      0 {} {}
    iso8859-11 \U00000400 tcl8    1A -1 {} {}
    iso8859-11 \U00000400 replace 1A -1 {} {}
    iso8859-11 \U00000400 strict  {}                      0 {} {}
    iso8859-11 \U0000D800 tcl8    1A -1 {} {}
    iso8859-11 \U0000D800 replace 1A -1 {} {}
    iso8859-11 \U0000D800 strict  {}                      0 {} {}
    iso8859-11 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-11 \U0000DC00 replace 1A -1 {} {}
    iso8859-11 \U0000DC00 strict  {}                      0 {} {}
    iso8859-11 \U00010000 tcl8    1A -1 {} {}
    iso8859-11 \U00010000 replace 1A -1 {} {}
    iso8859-11 \U00010000 strict  {}                      0 {} {}
    iso8859-11 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-11 \U0010FFFF replace 1A -1 {} {}
    iso8859-11 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-11

#
# iso8859-13 (generated from glibc-ISO_8859_13-2.3.3)

test encoding-convertfrom-ucmCompare-iso8859-13 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-13 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A6 A6 00A7 A7 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B5 B5 00B6 B6 00B7 B7 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00C4 C4 00C5 C5 00C6 AF 00C9 C9 00D3 D3 00D5 D5 00D6 D6 00D7 D7 00D8 A8 00DC DC 00DF DF 00E4 E4 00E5 E5 00E6 BF 00E9 E9 00F3 F3 00F5 F5 00F6 F6 00F7 F7 00F8 B8 00FC FC 0100 C2 0101 E2 0104 C0 0105 E0 0106 C3 0107 E3 010C C8 010D E8 0112 C7 0113 E7 0116 CB 0117 EB 0118 C6 0119 E6 0122 CC 0123 EC 012A CE 012B EE 012E C1 012F E1 0136 CD 0137 ED 013B CF 013C EF 0141 D9 0142 F9 0143 D1 0144 F1 0145 D2 0146 F2 014C D4 014D F4 0156 AA 0157 BA 015A DA 015B FA 0160 D0 0161 F0 016A DB 016B FB 0172 D8 0173 F8 0179 CA 017A EA 017B DD 017C FD 017D DE 017E FE 2019 FF 201C B4 201D A1 201E A5}
} -result {}

test encoding-convertto-ucmCompare-iso8859-13 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-13 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A2 A2 00A3 A3 00A4 A4 00A6 A6 00A7 A7 00A9 A9 00AB AB 00AC AC 00AD AD 00AE AE 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B5 B5 00B6 B6 00B7 B7 00B9 B9 00BB BB 00BC BC 00BD BD 00BE BE 00C4 C4 00C5 C5 00C6 AF 00C9 C9 00D3 D3 00D5 D5 00D6 D6 00D7 D7 00D8 A8 00DC DC 00DF DF 00E4 E4 00E5 E5 00E6 BF 00E9 E9 00F3 F3 00F5 F5 00F6 F6 00F7 F7 00F8 B8 00FC FC 0100 C2 0101 E2 0104 C0 0105 E0 0106 C3 0107 E3 010C C8 010D E8 0112 C7 0113 E7 0116 CB 0117 EB 0118 C6 0119 E6 0122 CC 0123 EC 012A CE 012B EE 012E C1 012F E1 0136 CD 0137 ED 013B CF 013C EF 0141 D9 0142 F9 0143 D1 0144 F1 0145 D2 0146 F2 014C D4 014D F4 0156 AA 0157 BA 015A DA 015B FA 0160 D0 0161 F0 016A DB 016B FB 0172 D8 0173 F8 0179 CA 017A EA 017B DD 017C FD 017D DE 017E FE 2019 FF 201C B4 201D A1 201E A5}
} -result {}

# iso8859-13 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-13

# iso8859-13 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-13 \U000000A1 tcl8    1A -1 {} {}
    iso8859-13 \U000000A1 replace 1A -1 {} {}
    iso8859-13 \U000000A1 strict  {}                      0 {} {}
    iso8859-13 \U00000400 tcl8    1A -1 {} {}
    iso8859-13 \U00000400 replace 1A -1 {} {}
    iso8859-13 \U00000400 strict  {}                      0 {} {}
    iso8859-13 \U0000D800 tcl8    1A -1 {} {}
    iso8859-13 \U0000D800 replace 1A -1 {} {}
    iso8859-13 \U0000D800 strict  {}                      0 {} {}
    iso8859-13 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-13 \U0000DC00 replace 1A -1 {} {}
    iso8859-13 \U0000DC00 strict  {}                      0 {} {}
    iso8859-13 \U00010000 tcl8    1A -1 {} {}
    iso8859-13 \U00010000 replace 1A -1 {} {}
    iso8859-13 \U00010000 strict  {}                      0 {} {}
    iso8859-13 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-13 \U0010FFFF replace 1A -1 {} {}
    iso8859-13 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-13

#
# iso8859-14 (generated from glibc-ISO_8859_14-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-14 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-14 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A3 A3 00A7 A7 00A9 A9 00AD AD 00AE AE 00B6 B6 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FF FF 010A A4 010B A5 0120 B2 0121 B3 0174 D0 0175 F0 0176 DE 0177 FE 0178 AF 1E02 A1 1E03 A2 1E0A A6 1E0B AB 1E1E B0 1E1F B1 1E40 B4 1E41 B5 1E56 B7 1E57 B9 1E60 BB 1E61 BF 1E6A D7 1E6B F7 1E80 A8 1E81 B8 1E82 AA 1E83 BA 1E84 BD 1E85 BE 1EF2 AC 1EF3 BC}
} -result {}

test encoding-convertto-ucmCompare-iso8859-14 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-14 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A3 A3 00A7 A7 00A9 A9 00AD AD 00AE AE 00B6 B6 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FF FF 010A A4 010B A5 0120 B2 0121 B3 0174 D0 0175 F0 0176 DE 0177 FE 0178 AF 1E02 A1 1E03 A2 1E0A A6 1E0B AB 1E1E B0 1E1F B1 1E40 B4 1E41 B5 1E56 B7 1E57 B9 1E60 BB 1E61 BF 1E6A D7 1E6B F7 1E80 A8 1E81 B8 1E82 AA 1E83 BA 1E84 BD 1E85 BE 1EF2 AC 1EF3 BC}
} -result {}

# iso8859-14 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-14

# iso8859-14 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-14 \U000000A1 tcl8    1A -1 {} {}
    iso8859-14 \U000000A1 replace 1A -1 {} {}
    iso8859-14 \U000000A1 strict  {}                      0 {} {}
    iso8859-14 \U00000400 tcl8    1A -1 {} {}
    iso8859-14 \U00000400 replace 1A -1 {} {}
    iso8859-14 \U00000400 strict  {}                      0 {} {}
    iso8859-14 \U0000D800 tcl8    1A -1 {} {}
    iso8859-14 \U0000D800 replace 1A -1 {} {}
    iso8859-14 \U0000D800 strict  {}                      0 {} {}
    iso8859-14 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-14 \U0000DC00 replace 1A -1 {} {}
    iso8859-14 \U0000DC00 strict  {}                      0 {} {}
    iso8859-14 \U00010000 tcl8    1A -1 {} {}
    iso8859-14 \U00010000 replace 1A -1 {} {}
    iso8859-14 \U00010000 strict  {}                      0 {} {}
    iso8859-14 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-14 \U0010FFFF replace 1A -1 {} {}
    iso8859-14 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-14

#
# iso8859-15 (generated from glibc-ISO_8859_15-2.1.2)

test encoding-convertfrom-ucmCompare-iso8859-15 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-15 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A5 A5 00A7 A7 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B5 B5 00B6 B6 00B7 B7 00B9 B9 00BA BA 00BB BB 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D0 D0 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F0 F0 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 00FF FF 0152 BC 0153 BD 0160 A6 0161 A8 0178 BE 017D B4 017E B8 20AC A4}
} -result {}

test encoding-convertto-ucmCompare-iso8859-15 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-15 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A1 A1 00A2 A2 00A3 A3 00A5 A5 00A7 A7 00A9 A9 00AA AA 00AB AB 00AC AC 00AD AD 00AE AE 00AF AF 00B0 B0 00B1 B1 00B2 B2 00B3 B3 00B5 B5 00B6 B6 00B7 B7 00B9 B9 00BA BA 00BB BB 00BF BF 00C0 C0 00C1 C1 00C2 C2 00C3 C3 00C4 C4 00C5 C5 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D0 D0 00D1 D1 00D2 D2 00D3 D3 00D4 D4 00D5 D5 00D6 D6 00D7 D7 00D8 D8 00D9 D9 00DA DA 00DB DB 00DC DC 00DD DD 00DE DE 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E3 E3 00E4 E4 00E5 E5 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F0 F0 00F1 F1 00F2 F2 00F3 F3 00F4 F4 00F5 F5 00F6 F6 00F7 F7 00F8 F8 00F9 F9 00FA FA 00FB FB 00FC FC 00FD FD 00FE FE 00FF FF 0152 BC 0153 BD 0160 A6 0161 A8 0178 BE 017D B4 017E B8 20AC A4}
} -result {}

# iso8859-15 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-15

# iso8859-15 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-15 \U000000A4 tcl8    1A -1 {} {}
    iso8859-15 \U000000A4 replace 1A -1 {} {}
    iso8859-15 \U000000A4 strict  {}                      0 {} {}
    iso8859-15 \U00000400 tcl8    1A -1 {} {}
    iso8859-15 \U00000400 replace 1A -1 {} {}
    iso8859-15 \U00000400 strict  {}                      0 {} {}
    iso8859-15 \U0000D800 tcl8    1A -1 {} {}
    iso8859-15 \U0000D800 replace 1A -1 {} {}
    iso8859-15 \U0000D800 strict  {}                      0 {} {}
    iso8859-15 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-15 \U0000DC00 replace 1A -1 {} {}
    iso8859-15 \U0000DC00 strict  {}                      0 {} {}
    iso8859-15 \U00010000 tcl8    1A -1 {} {}
    iso8859-15 \U00010000 replace 1A -1 {} {}
    iso8859-15 \U00010000 strict  {}                      0 {} {}
    iso8859-15 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-15 \U0010FFFF replace 1A -1 {} {}
    iso8859-15 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-15

#
# iso8859-16 (generated from glibc-ISO_8859_16-2.3.3)

test encoding-convertfrom-ucmCompare-iso8859-16 {Compare against ICU UCM} -body {
    ucmConvertfromMismatches iso8859-16 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A7 A7 00A9 A9 00AB AB 00AD AD 00B0 B0 00B1 B1 00B6 B6 00B7 B7 00BB BB 00C0 C0 00C1 C1 00C2 C2 00C4 C4 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D2 D2 00D3 D3 00D4 D4 00D6 D6 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E4 E4 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F2 F2 00F3 F3 00F4 F4 00F6 F6 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 0102 C3 0103 E3 0104 A1 0105 A2 0106 C5 0107 E5 010C B2 010D B9 0110 D0 0111 F0 0118 DD 0119 FD 0141 A3 0142 B3 0143 D1 0144 F1 0150 D5 0151 F5 0152 BC 0153 BD 015A D7 015B F7 0160 A6 0161 A8 0170 D8 0171 F8 0178 BE 0179 AC 017A AE 017B AF 017C BF 017D B4 017E B8 0218 AA 0219 BA 021A DE 021B FE 201D B5 201E A5 20AC A4}
} -result {}

test encoding-convertto-ucmCompare-iso8859-16 {Compare against ICU UCM} -body {
    ucmConverttoMismatches iso8859-16 {0000 00 0001 01 0002 02 0003 03 0004 04 0005 05 0006 06 0007 07 0008 08 0009 09 000A 0A 000B 0B 000C 0C 000D 0D 000E 0E 000F 0F 0010 10 0011 11 0012 12 0013 13 0014 14 0015 15 0016 16 0017 17 0018 18 0019 19 001A 1A 001B 1B 001C 1C 001D 1D 001E 1E 001F 1F 0020 20 0021 21 0022 22 0023 23 0024 24 0025 25 0026 26 0027 27 0028 28 0029 29 002A 2A 002B 2B 002C 2C 002D 2D 002E 2E 002F 2F 0030 30 0031 31 0032 32 0033 33 0034 34 0035 35 0036 36 0037 37 0038 38 0039 39 003A 3A 003B 3B 003C 3C 003D 3D 003E 3E 003F 3F 0040 40 0041 41 0042 42 0043 43 0044 44 0045 45 0046 46 0047 47 0048 48 0049 49 004A 4A 004B 4B 004C 4C 004D 4D 004E 4E 004F 4F 0050 50 0051 51 0052 52 0053 53 0054 54 0055 55 0056 56 0057 57 0058 58 0059 59 005A 5A 005B 5B 005C 5C 005D 5D 005E 5E 005F 5F 0060 60 0061 61 0062 62 0063 63 0064 64 0065 65 0066 66 0067 67 0068 68 0069 69 006A 6A 006B 6B 006C 6C 006D 6D 006E 6E 006F 6F 0070 70 0071 71 0072 72 0073 73 0074 74 0075 75 0076 76 0077 77 0078 78 0079 79 007A 7A 007B 7B 007C 7C 007D 7D 007E 7E 007F 7F 0080 80 0081 81 0082 82 0083 83 0084 84 0085 85 0086 86 0087 87 0088 88 0089 89 008A 8A 008B 8B 008C 8C 008D 8D 008E 8E 008F 8F 0090 90 0091 91 0092 92 0093 93 0094 94 0095 95 0096 96 0097 97 0098 98 0099 99 009A 9A 009B 9B 009C 9C 009D 9D 009E 9E 009F 9F 00A0 A0 00A7 A7 00A9 A9 00AB AB 00AD AD 00B0 B0 00B1 B1 00B6 B6 00B7 B7 00BB BB 00C0 C0 00C1 C1 00C2 C2 00C4 C4 00C6 C6 00C7 C7 00C8 C8 00C9 C9 00CA CA 00CB CB 00CC CC 00CD CD 00CE CE 00CF CF 00D2 D2 00D3 D3 00D4 D4 00D6 D6 00D9 D9 00DA DA 00DB DB 00DC DC 00DF DF 00E0 E0 00E1 E1 00E2 E2 00E4 E4 00E6 E6 00E7 E7 00E8 E8 00E9 E9 00EA EA 00EB EB 00EC EC 00ED ED 00EE EE 00EF EF 00F2 F2 00F3 F3 00F4 F4 00F6 F6 00F9 F9 00FA FA 00FB FB 00FC FC 00FF FF 0102 C3 0103 E3 0104 A1 0105 A2 0106 C5 0107 E5 010C B2 010D B9 0110 D0 0111 F0 0118 DD 0119 FD 0141 A3 0142 B3 0143 D1 0144 F1 0150 D5 0151 F5 0152 BC 0153 BD 015A D7 015B F7 0160 A6 0161 A8 0170 D8 0171 F8 0178 BE 0179 AC 017A AE 017B AF 017C BF 017D B4 017E B8 0218 AA 0219 BA 021A DE 021B FE 201D B5 201E A5 20AC A4}
} -result {}

# iso8859-16 - invalid byte sequences
lappend encInvalidBytes {*}{
}; # iso8859-16

# iso8859-16 - invalid byte sequences
lappend encUnencodableStrings {*}{
    iso8859-16 \U000000A1 tcl8    1A -1 {} {}
    iso8859-16 \U000000A1 replace 1A -1 {} {}
    iso8859-16 \U000000A1 strict  {}                      0 {} {}
    iso8859-16 \U00000400 tcl8    1A -1 {} {}
    iso8859-16 \U00000400 replace 1A -1 {} {}
    iso8859-16 \U00000400 strict  {}                      0 {} {}
    iso8859-16 \U0000D800 tcl8    1A -1 {} {}
    iso8859-16 \U0000D800 replace 1A -1 {} {}
    iso8859-16 \U0000D800 strict  {}                      0 {} {}
    iso8859-16 \U0000DC00 tcl8    1A -1 {} {}
    iso8859-16 \U0000DC00 replace 1A -1 {} {}
    iso8859-16 \U0000DC00 strict  {}                      0 {} {}
    iso8859-16 \U00010000 tcl8    1A -1 {} {}
    iso8859-16 \U00010000 replace 1A -1 {} {}
    iso8859-16 \U00010000 strict  {}                      0 {} {}
    iso8859-16 \U0010FFFF tcl8    1A -1 {} {}
    iso8859-16 \U0010FFFF replace 1A -1 {} {}
    iso8859-16 \U0010FFFF strict  {}                      0 {} {}
}; # iso8859-16
