[comment {-*- tcl -*- doctools manpage}]
[manpage_begin javascript n 1.0.3]
[see_also html]
[see_also ncgi]
[keywords checkbox]
[keywords html]
[keywords javascript]
[keywords selectionbox]
[keywords submitbutton]
[moddesc   {HTML and Java Script Generation}]
[titledesc {Procedures to generate HTML and Java Script structures.}]
[category  {CGI programming}]
[require Tcl "8.5 9"]
[require javascript [opt 1.0.3]]
[description]
[para]

The [package ::javascript] package provides commands that generate
HTML and Java Script code.  These commands typically return an HTML
string as their result.  In particular, they do not output their
result to [const stdout].

[para]

[list_begin definitions]

[call [cmd ::javascript::makeSelectorWidget] [arg {id leftLabel leftValueList rightLabel rightValueList rightNameList}] [opt [arg length]] [opt [arg minWidth]]]

Construct HTML code to create a dual-multi-selection megawidget.  This
megawidget consists of two side-by-side multi-selection boxes
separated by a left arrow and a right arrow button.  The right arrow
button moves all items selected in the left box to the right box.  The
left arrow button moves all items selected in the right box to the
left box.  The [arg id] argument is the suffix of all HTML objects in
this megawidget.  The [arg leftLabel] argument is the text that
appears above the left selection box.  The [arg leftValueList]
argument is the values of items in the left selection box.  The

[arg leftNameList] argument is the names to appear in the left
selection box.  The [arg rightLabel] argument is the text that appears
above the right selection box.  The [arg rightValueList] argument is
the values of items in the right selection box.  The

[arg rightNameList] argument is the names to appear in the right
selection box.  The [arg length] argument (optional) determines the
number of elts to show before adding a vertical scrollbar; it defaults
to 8.  The [arg minWidth] argument (optional) is the number of spaces
to determine the minimum box width; it defaults to 32.

[call [cmd ::javascript::makeSubmitButton] [arg {name value}]]

Create an HTML submit button that resets a hidden field for each
registered multi-selection box.  The [arg name] argument is the name
of the HTML button object to create.  The [arg value] argument is the
label of the HTML button object to create.

[call [cmd ::javascript::makeProtectedSubmitButton] [arg {name value msg}]]

Create an HTML submit button that prompts the user with a
continue/cancel shutdown warning before the form is submitted.  The
[arg name] argument is the name of the HTML button object to create.
The [arg value] argument is the label of the HTML button object to
create. The [arg msg] argument is the message to display when the
button is pressed.

[call [cmd ::javascript::makeMasterButton] [arg {master value slavePattern boolean}]]

Create an HTML button that sets its slave checkboxs to the boolean
value.  The [arg master] argument is the name of the child's parent
html checkbox object.  The [arg value] argument is the value of the
master.  The [arg slaves] argument is the name of child html checkbox
object to create.  The [arg boolean] argument is the java script
boolean value that will be given to all the slaves; it must be "true"
or "false".

[call [cmd ::javascript::makeParentCheckbox] [arg {parentName childName}]]

Create an HTML checkbox and tie its value to that of its child
checkbox.  If the parent is unchecked, the child is automatically
unchecked.  The [arg parentName] argument is the name of parent html
checkbox object to create. The [arg childName] argument is the name of
the parent's child html checkbox object.

[call [cmd ::javascript::makeChildCheckbox] [arg {parentName childName}]]

Create an HTML checkbox and tie its value to that of its parent
checkbox.  If the child is checked, the parent is automatically
checked.  The [arg parentName] argument is the name of the child's
parent html checkbox object.  The [arg childName] argument is the name
of child html checkbox object to create.

[list_end]

[vset CATEGORY javascript]
[include ../common-text/feedback.inc]
[manpage_end]
