local ProvidesLuaModule = { 
    name          = "luaotfload-glyphlist",
    version       = "2.94",       --TAGVERSION
    date          = "2018-12-19", --TAGDATE
    description   = "luaotfload submodule / autogenerated glyphlist",
    copyright   = "derived from https://raw.githubusercontent.com/adobe-type-tools/agl-aglfn/master/glyphlist.txt",
    original    = "Adobe Glyph List, version 2.0, September 20, 2002",
    dataonly    = true
}

if context then
  logs.report("fatal error","this module is not for context")
  os.exit(-1)
end

--[[doc--
Everything below has been autogenerated. Run mkglyphlist to rebuild
luaotfload-glyphlist.lua.
--doc]]--

return {
 ["A"]=65,
 ["AE"]=198,
 ["AEacute"]=508,
 ["AEmacron"]=482,
 ["AEsmall"]=63462,
 ["Aacute"]=193,
 ["Aacutesmall"]=63457,
 ["Abreve"]=258,
 ["Abreveacute"]=7854,
 ["Abrevecyrillic"]=1232,
 ["Abrevedotbelow"]=7862,
 ["Abrevegrave"]=7856,
 ["Abrevehookabove"]=7858,
 ["Abrevetilde"]=7860,
 ["Acaron"]=461,
 ["Acircle"]=9398,
 ["Acircumflex"]=194,
 ["Acircumflexacute"]=7844,
 ["Acircumflexdotbelow"]=7852,
 ["Acircumflexgrave"]=7846,
 ["Acircumflexhookabove"]=7848,
 ["Acircumflexsmall"]=63458,
 ["Acircumflextilde"]=7850,
 ["Acute"]=63177,
 ["Acutesmall"]=63412,
 ["Acyrillic"]=1040,
 ["Adblgrave"]=512,
 ["Adieresis"]=196,
 ["Adieresiscyrillic"]=1234,
 ["Adieresismacron"]=478,
 ["Adieresissmall"]=63460,
 ["Adotbelow"]=7840,
 ["Adotmacron"]=480,
 ["Agrave"]=192,
 ["Agravesmall"]=63456,
 ["Ahookabove"]=7842,
 ["Aiecyrillic"]=1236,
 ["Ainvertedbreve"]=514,
 ["Alpha"]=913,
 ["Alphatonos"]=902,
 ["Amacron"]=256,
 ["Amonospace"]=65313,
 ["Aogonek"]=260,
 ["Aring"]=197,
 ["Aringacute"]=506,
 ["Aringbelow"]=7680,
 ["Aringsmall"]=63461,
 ["Asmall"]=63329,
 ["Atilde"]=195,
 ["Atildesmall"]=63459,
 ["Aybarmenian"]=1329,
 ["B"]=66,
 ["Bcircle"]=9399,
 ["Bdotaccent"]=7682,
 ["Bdotbelow"]=7684,
 ["Becyrillic"]=1041,
 ["Benarmenian"]=1330,
 ["Beta"]=914,
 ["Bhook"]=385,
 ["Blinebelow"]=7686,
 ["Bmonospace"]=65314,
 ["Brevesmall"]=63220,
 ["Bsmall"]=63330,
 ["Btopbar"]=386,
 ["C"]=67,
 ["Caarmenian"]=1342,
 ["Cacute"]=262,
 ["Caron"]=63178,
 ["Caronsmall"]=63221,
 ["Ccaron"]=268,
 ["Ccedilla"]=199,
 ["Ccedillaacute"]=7688,
 ["Ccedillasmall"]=63463,
 ["Ccircle"]=9400,
 ["Ccircumflex"]=264,
 ["Cdot"]=266,
 ["Cdotaccent"]=266,
 ["Cedillasmall"]=63416,
 ["Chaarmenian"]=1353,
 ["Cheabkhasiancyrillic"]=1212,
 ["Checyrillic"]=1063,
 ["Chedescenderabkhasiancyrillic"]=1214,
 ["Chedescendercyrillic"]=1206,
 ["Chedieresiscyrillic"]=1268,
 ["Cheharmenian"]=1347,
 ["Chekhakassiancyrillic"]=1227,
 ["Cheverticalstrokecyrillic"]=1208,
 ["Chi"]=935,
 ["Chook"]=391,
 ["Circumflexsmall"]=63222,
 ["Cmonospace"]=65315,
 ["Coarmenian"]=1361,
 ["Csmall"]=63331,
 ["D"]=68,
 ["DZ"]=497,
 ["DZcaron"]=452,
 ["Daarmenian"]=1332,
 ["Dafrican"]=393,
 ["Dcaron"]=270,
 ["Dcedilla"]=7696,
 ["Dcircle"]=9401,
 ["Dcircumflexbelow"]=7698,
 ["Dcroat"]=272,
 ["Ddotaccent"]=7690,
 ["Ddotbelow"]=7692,
 ["Decyrillic"]=1044,
 ["Deicoptic"]=1006,
 ["Delta"]=8710,
 ["Deltagreek"]=916,
 ["Dhook"]=394,
 ["Dieresis"]=63179,
 ["DieresisAcute"]=63180,
 ["DieresisGrave"]=63181,
 ["Dieresissmall"]=63400,
 ["Digammagreek"]=988,
 ["Djecyrillic"]=1026,
 ["Dlinebelow"]=7694,
 ["Dmonospace"]=65316,
 ["Dotaccentsmall"]=63223,
 ["Dslash"]=272,
 ["Dsmall"]=63332,
 ["Dtopbar"]=395,
 ["Dz"]=498,
 ["Dzcaron"]=453,
 ["Dzeabkhasiancyrillic"]=1248,
 ["Dzecyrillic"]=1029,
 ["Dzhecyrillic"]=1039,
 ["E"]=69,
 ["Eacute"]=201,
 ["Eacutesmall"]=63465,
 ["Ebreve"]=276,
 ["Ecaron"]=282,
 ["Ecedillabreve"]=7708,
 ["Echarmenian"]=1333,
 ["Ecircle"]=9402,
 ["Ecircumflex"]=202,
 ["Ecircumflexacute"]=7870,
 ["Ecircumflexbelow"]=7704,
 ["Ecircumflexdotbelow"]=7878,
 ["Ecircumflexgrave"]=7872,
 ["Ecircumflexhookabove"]=7874,
 ["Ecircumflexsmall"]=63466,
 ["Ecircumflextilde"]=7876,
 ["Ecyrillic"]=1028,
 ["Edblgrave"]=516,
 ["Edieresis"]=203,
 ["Edieresissmall"]=63467,
 ["Edot"]=278,
 ["Edotaccent"]=278,
 ["Edotbelow"]=7864,
 ["Efcyrillic"]=1060,
 ["Egrave"]=200,
 ["Egravesmall"]=63464,
 ["Eharmenian"]=1335,
 ["Ehookabove"]=7866,
 ["Eightroman"]=8551,
 ["Einvertedbreve"]=518,
 ["Eiotifiedcyrillic"]=1124,
 ["Elcyrillic"]=1051,
 ["Elevenroman"]=8554,
 ["Emacron"]=274,
 ["Emacronacute"]=7702,
 ["Emacrongrave"]=7700,
 ["Emcyrillic"]=1052,
 ["Emonospace"]=65317,
 ["Encyrillic"]=1053,
 ["Endescendercyrillic"]=1186,
 ["Eng"]=330,
 ["Enghecyrillic"]=1188,
 ["Enhookcyrillic"]=1223,
 ["Eogonek"]=280,
 ["Eopen"]=400,
 ["Epsilon"]=917,
 ["Epsilontonos"]=904,
 ["Ercyrillic"]=1056,
 ["Ereversed"]=398,
 ["Ereversedcyrillic"]=1069,
 ["Escyrillic"]=1057,
 ["Esdescendercyrillic"]=1194,
 ["Esh"]=425,
 ["Esmall"]=63333,
 ["Eta"]=919,
 ["Etarmenian"]=1336,
 ["Etatonos"]=905,
 ["Eth"]=208,
 ["Ethsmall"]=63472,
 ["Etilde"]=7868,
 ["Etildebelow"]=7706,
 ["Euro"]=8364,
 ["Ezh"]=439,
 ["Ezhcaron"]=494,
 ["Ezhreversed"]=440,
 ["F"]=70,
 ["Fcircle"]=9403,
 ["Fdotaccent"]=7710,
 ["Feharmenian"]=1366,
 ["Feicoptic"]=996,
 ["Fhook"]=401,
 ["Fitacyrillic"]=1138,
 ["Fiveroman"]=8548,
 ["Fmonospace"]=65318,
 ["Fourroman"]=8547,
 ["Fsmall"]=63334,
 ["G"]=71,
 ["GBsquare"]=13191,
 ["Gacute"]=500,
 ["Gamma"]=915,
 ["Gammaafrican"]=404,
 ["Gangiacoptic"]=1002,
 ["Gbreve"]=286,
 ["Gcaron"]=486,
 ["Gcedilla"]=290,
 ["Gcircle"]=9404,
 ["Gcircumflex"]=284,
 ["Gcommaaccent"]=290,
 ["Gdot"]=288,
 ["Gdotaccent"]=288,
 ["Gecyrillic"]=1043,
 ["Ghadarmenian"]=1346,
 ["Ghemiddlehookcyrillic"]=1172,
 ["Ghestrokecyrillic"]=1170,
 ["Gheupturncyrillic"]=1168,
 ["Ghook"]=403,
 ["Gimarmenian"]=1331,
 ["Gjecyrillic"]=1027,
 ["Gmacron"]=7712,
 ["Gmonospace"]=65319,
 ["Grave"]=63182,
 ["Gravesmall"]=63328,
 ["Gsmall"]=63335,
 ["Gsmallhook"]=667,
 ["Gstroke"]=484,
 ["H"]=72,
 ["H18533"]=9679,
 ["H18543"]=9642,
 ["H18551"]=9643,
 ["H22073"]=9633,
 ["HPsquare"]=13259,
 ["Haabkhasiancyrillic"]=1192,
 ["Hadescendercyrillic"]=1202,
 ["Hardsigncyrillic"]=1066,
 ["Hbar"]=294,
 ["Hbrevebelow"]=7722,
 ["Hcedilla"]=7720,
 ["Hcircle"]=9405,
 ["Hcircumflex"]=292,
 ["Hdieresis"]=7718,
 ["Hdotaccent"]=7714,
 ["Hdotbelow"]=7716,
 ["Hmonospace"]=65320,
 ["Hoarmenian"]=1344,
 ["Horicoptic"]=1000,
 ["Hsmall"]=63336,
 ["Hungarumlaut"]=63183,
 ["Hungarumlautsmall"]=63224,
 ["Hzsquare"]=13200,
 ["I"]=73,
 ["IAcyrillic"]=1071,
 ["IJ"]=306,
 ["IUcyrillic"]=1070,
 ["Iacute"]=205,
 ["Iacutesmall"]=63469,
 ["Ibreve"]=300,
 ["Icaron"]=463,
 ["Icircle"]=9406,
 ["Icircumflex"]=206,
 ["Icircumflexsmall"]=63470,
 ["Icyrillic"]=1030,
 ["Idblgrave"]=520,
 ["Idieresis"]=207,
 ["Idieresisacute"]=7726,
 ["Idieresiscyrillic"]=1252,
 ["Idieresissmall"]=63471,
 ["Idot"]=304,
 ["Idotaccent"]=304,
 ["Idotbelow"]=7882,
 ["Iebrevecyrillic"]=1238,
 ["Iecyrillic"]=1045,
 ["Ifraktur"]=8465,
 ["Igrave"]=204,
 ["Igravesmall"]=63468,
 ["Ihookabove"]=7880,
 ["Iicyrillic"]=1048,
 ["Iinvertedbreve"]=522,
 ["Iishortcyrillic"]=1049,
 ["Imacron"]=298,
 ["Imacroncyrillic"]=1250,
 ["Imonospace"]=65321,
 ["Iniarmenian"]=1339,
 ["Iocyrillic"]=1025,
 ["Iogonek"]=302,
 ["Iota"]=921,
 ["Iotaafrican"]=406,
 ["Iotadieresis"]=938,
 ["Iotatonos"]=906,
 ["Ismall"]=63337,
 ["Istroke"]=407,
 ["Itilde"]=296,
 ["Itildebelow"]=7724,
 ["Izhitsacyrillic"]=1140,
 ["Izhitsadblgravecyrillic"]=1142,
 ["J"]=74,
 ["Jaarmenian"]=1345,
 ["Jcircle"]=9407,
 ["Jcircumflex"]=308,
 ["Jecyrillic"]=1032,
 ["Jheharmenian"]=1355,
 ["Jmonospace"]=65322,
 ["Jsmall"]=63338,
 ["K"]=75,
 ["KBsquare"]=13189,
 ["KKsquare"]=13261,
 ["Kabashkircyrillic"]=1184,
 ["Kacute"]=7728,
 ["Kacyrillic"]=1050,
 ["Kadescendercyrillic"]=1178,
 ["Kahookcyrillic"]=1219,
 ["Kappa"]=922,
 ["Kastrokecyrillic"]=1182,
 ["Kaverticalstrokecyrillic"]=1180,
 ["Kcaron"]=488,
 ["Kcedilla"]=310,
 ["Kcircle"]=9408,
 ["Kcommaaccent"]=310,
 ["Kdotbelow"]=7730,
 ["Keharmenian"]=1364,
 ["Kenarmenian"]=1343,
 ["Khacyrillic"]=1061,
 ["Kheicoptic"]=998,
 ["Khook"]=408,
 ["Kjecyrillic"]=1036,
 ["Klinebelow"]=7732,
 ["Kmonospace"]=65323,
 ["Koppacyrillic"]=1152,
 ["Koppagreek"]=990,
 ["Ksicyrillic"]=1134,
 ["Ksmall"]=63339,
 ["L"]=76,
 ["LJ"]=455,
 ["LL"]=63167,
 ["Lacute"]=313,
 ["Lambda"]=923,
 ["Lcaron"]=317,
 ["Lcedilla"]=315,
 ["Lcircle"]=9409,
 ["Lcircumflexbelow"]=7740,
 ["Lcommaaccent"]=315,
 ["Ldot"]=319,
 ["Ldotaccent"]=319,
 ["Ldotbelow"]=7734,
 ["Ldotbelowmacron"]=7736,
 ["Liwnarmenian"]=1340,
 ["Lj"]=456,
 ["Ljecyrillic"]=1033,
 ["Llinebelow"]=7738,
 ["Lmonospace"]=65324,
 ["Lslash"]=321,
 ["Lslashsmall"]=63225,
 ["Lsmall"]=63340,
 ["M"]=77,
 ["MBsquare"]=13190,
 ["Macron"]=63184,
 ["Macronsmall"]=63407,
 ["Macute"]=7742,
 ["Mcircle"]=9410,
 ["Mdotaccent"]=7744,
 ["Mdotbelow"]=7746,
 ["Menarmenian"]=1348,
 ["Mmonospace"]=65325,
 ["Msmall"]=63341,
 ["Mturned"]=412,
 ["Mu"]=924,
 ["N"]=78,
 ["NJ"]=458,
 ["Nacute"]=323,
 ["Ncaron"]=327,
 ["Ncedilla"]=325,
 ["Ncircle"]=9411,
 ["Ncircumflexbelow"]=7754,
 ["Ncommaaccent"]=325,
 ["Ndotaccent"]=7748,
 ["Ndotbelow"]=7750,
 ["Nhookleft"]=413,
 ["Nineroman"]=8552,
 ["Nj"]=459,
 ["Njecyrillic"]=1034,
 ["Nlinebelow"]=7752,
 ["Nmonospace"]=65326,
 ["Nowarmenian"]=1350,
 ["Nsmall"]=63342,
 ["Ntilde"]=209,
 ["Ntildesmall"]=63473,
 ["Nu"]=925,
 ["O"]=79,
 ["OE"]=338,
 ["OEsmall"]=63226,
 ["Oacute"]=211,
 ["Oacutesmall"]=63475,
 ["Obarredcyrillic"]=1256,
 ["Obarreddieresiscyrillic"]=1258,
 ["Obreve"]=334,
 ["Ocaron"]=465,
 ["Ocenteredtilde"]=415,
 ["Ocircle"]=9412,
 ["Ocircumflex"]=212,
 ["Ocircumflexacute"]=7888,
 ["Ocircumflexdotbelow"]=7896,
 ["Ocircumflexgrave"]=7890,
 ["Ocircumflexhookabove"]=7892,
 ["Ocircumflexsmall"]=63476,
 ["Ocircumflextilde"]=7894,
 ["Ocyrillic"]=1054,
 ["Odblacute"]=336,
 ["Odblgrave"]=524,
 ["Odieresis"]=214,
 ["Odieresiscyrillic"]=1254,
 ["Odieresissmall"]=63478,
 ["Odotbelow"]=7884,
 ["Ogoneksmall"]=63227,
 ["Ograve"]=210,
 ["Ogravesmall"]=63474,
 ["Oharmenian"]=1365,
 ["Ohm"]=8486,
 ["Ohookabove"]=7886,
 ["Ohorn"]=416,
 ["Ohornacute"]=7898,
 ["Ohorndotbelow"]=7906,
 ["Ohorngrave"]=7900,
 ["Ohornhookabove"]=7902,
 ["Ohorntilde"]=7904,
 ["Ohungarumlaut"]=336,
 ["Oi"]=418,
 ["Oinvertedbreve"]=526,
 ["Omacron"]=332,
 ["Omacronacute"]=7762,
 ["Omacrongrave"]=7760,
 ["Omega"]=8486,
 ["Omegacyrillic"]=1120,
 ["Omegagreek"]=937,
 ["Omegaroundcyrillic"]=1146,
 ["Omegatitlocyrillic"]=1148,
 ["Omegatonos"]=911,
 ["Omicron"]=927,
 ["Omicrontonos"]=908,
 ["Omonospace"]=65327,
 ["Oneroman"]=8544,
 ["Oogonek"]=490,
 ["Oogonekmacron"]=492,
 ["Oopen"]=390,
 ["Oslash"]=216,
 ["Oslashacute"]=510,
 ["Oslashsmall"]=63480,
 ["Osmall"]=63343,
 ["Ostrokeacute"]=510,
 ["Otcyrillic"]=1150,
 ["Otilde"]=213,
 ["Otildeacute"]=7756,
 ["Otildedieresis"]=7758,
 ["Otildesmall"]=63477,
 ["P"]=80,
 ["Pacute"]=7764,
 ["Pcircle"]=9413,
 ["Pdotaccent"]=7766,
 ["Pecyrillic"]=1055,
 ["Peharmenian"]=1354,
 ["Pemiddlehookcyrillic"]=1190,
 ["Phi"]=934,
 ["Phook"]=420,
 ["Pi"]=928,
 ["Piwrarmenian"]=1363,
 ["Pmonospace"]=65328,
 ["Psi"]=936,
 ["Psicyrillic"]=1136,
 ["Psmall"]=63344,
 ["Q"]=81,
 ["Qcircle"]=9414,
 ["Qmonospace"]=65329,
 ["Qsmall"]=63345,
 ["R"]=82,
 ["Raarmenian"]=1356,
 ["Racute"]=340,
 ["Rcaron"]=344,
 ["Rcedilla"]=342,
 ["Rcircle"]=9415,
 ["Rcommaaccent"]=342,
 ["Rdblgrave"]=528,
 ["Rdotaccent"]=7768,
 ["Rdotbelow"]=7770,
 ["Rdotbelowmacron"]=7772,
 ["Reharmenian"]=1360,
 ["Rfraktur"]=8476,
 ["Rho"]=929,
 ["Ringsmall"]=63228,
 ["Rinvertedbreve"]=530,
 ["Rlinebelow"]=7774,
 ["Rmonospace"]=65330,
 ["Rsmall"]=63346,
 ["Rsmallinverted"]=641,
 ["Rsmallinvertedsuperior"]=694,
 ["S"]=83,
 ["SF010000"]=9484,
 ["SF020000"]=9492,
 ["SF030000"]=9488,
 ["SF040000"]=9496,
 ["SF050000"]=9532,
 ["SF060000"]=9516,
 ["SF070000"]=9524,
 ["SF080000"]=9500,
 ["SF090000"]=9508,
 ["SF10000"]=9484,
 ["SF100000"]=9472,
 ["SF110000"]=9474,
 ["SF190000"]=9569,
 ["SF20000"]=9492,
 ["SF200000"]=9570,
 ["SF210000"]=9558,
 ["SF220000"]=9557,
 ["SF230000"]=9571,
 ["SF240000"]=9553,
 ["SF250000"]=9559,
 ["SF260000"]=9565,
 ["SF270000"]=9564,
 ["SF280000"]=9563,
 ["SF30000"]=9488,
 ["SF360000"]=9566,
 ["SF370000"]=9567,
 ["SF380000"]=9562,
 ["SF390000"]=9556,
 ["SF40000"]=9496,
 ["SF400000"]=9577,
 ["SF410000"]=9574,
 ["SF420000"]=9568,
 ["SF430000"]=9552,
 ["SF440000"]=9580,
 ["SF450000"]=9575,
 ["SF460000"]=9576,
 ["SF470000"]=9572,
 ["SF480000"]=9573,
 ["SF490000"]=9561,
 ["SF50000"]=9532,
 ["SF500000"]=9560,
 ["SF510000"]=9554,
 ["SF520000"]=9555,
 ["SF530000"]=9579,
 ["SF540000"]=9578,
 ["SF60000"]=9516,
 ["SF70000"]=9524,
 ["SF80000"]=9500,
 ["SF90000"]=9508,
 ["Sacute"]=346,
 ["Sacutedotaccent"]=7780,
 ["Sampigreek"]=992,
 ["Scaron"]=352,
 ["Scarondotaccent"]=7782,
 ["Scaronsmall"]=63229,
 ["Scedilla"]=350,
 ["Schwa"]=399,
 ["Schwacyrillic"]=1240,
 ["Schwadieresiscyrillic"]=1242,
 ["Scircle"]=9416,
 ["Scircumflex"]=348,
 ["Scommaaccent"]=536,
 ["Sdotaccent"]=7776,
 ["Sdotbelow"]=7778,
 ["Sdotbelowdotaccent"]=7784,
 ["Seharmenian"]=1357,
 ["Sevenroman"]=8550,
 ["Shaarmenian"]=1351,
 ["Shacyrillic"]=1064,
 ["Shchacyrillic"]=1065,
 ["Sheicoptic"]=994,
 ["Shhacyrillic"]=1210,
 ["Shimacoptic"]=1004,
 ["Sigma"]=931,
 ["Sixroman"]=8549,
 ["Smonospace"]=65331,
 ["Softsigncyrillic"]=1068,
 ["Ssmall"]=63347,
 ["Stigmagreek"]=986,
 ["T"]=84,
 ["Tau"]=932,
 ["Tbar"]=358,
 ["Tcaron"]=356,
 ["Tcedilla"]=354,
 ["Tcircle"]=9417,
 ["Tcircumflexbelow"]=7792,
 ["Tcommaaccent"]=354,
 ["Tdotaccent"]=7786,
 ["Tdotbelow"]=7788,
 ["Tecyrillic"]=1058,
 ["Tedescendercyrillic"]=1196,
 ["Tenroman"]=8553,
 ["Tetsecyrillic"]=1204,
 ["Theta"]=920,
 ["Thook"]=428,
 ["Thorn"]=222,
 ["Thornsmall"]=63486,
 ["Threeroman"]=8546,
 ["Tildesmall"]=63230,
 ["Tiwnarmenian"]=1359,
 ["Tlinebelow"]=7790,
 ["Tmonospace"]=65332,
 ["Toarmenian"]=1337,
 ["Tonefive"]=444,
 ["Tonesix"]=388,
 ["Tonetwo"]=423,
 ["Tretroflexhook"]=430,
 ["Tsecyrillic"]=1062,
 ["Tshecyrillic"]=1035,
 ["Tsmall"]=63348,
 ["Twelveroman"]=8555,
 ["Tworoman"]=8545,
 ["U"]=85,
 ["Uacute"]=218,
 ["Uacutesmall"]=63482,
 ["Ubreve"]=364,
 ["Ucaron"]=467,
 ["Ucircle"]=9418,
 ["Ucircumflex"]=219,
 ["Ucircumflexbelow"]=7798,
 ["Ucircumflexsmall"]=63483,
 ["Ucyrillic"]=1059,
 ["Udblacute"]=368,
 ["Udblgrave"]=532,
 ["Udieresis"]=220,
 ["Udieresisacute"]=471,
 ["Udieresisbelow"]=7794,
 ["Udieresiscaron"]=473,
 ["Udieresiscyrillic"]=1264,
 ["Udieresisgrave"]=475,
 ["Udieresismacron"]=469,
 ["Udieresissmall"]=63484,
 ["Udotbelow"]=7908,
 ["Ugrave"]=217,
 ["Ugravesmall"]=63481,
 ["Uhookabove"]=7910,
 ["Uhorn"]=431,
 ["Uhornacute"]=7912,
 ["Uhorndotbelow"]=7920,
 ["Uhorngrave"]=7914,
 ["Uhornhookabove"]=7916,
 ["Uhorntilde"]=7918,
 ["Uhungarumlaut"]=368,
 ["Uhungarumlautcyrillic"]=1266,
 ["Uinvertedbreve"]=534,
 ["Ukcyrillic"]=1144,
 ["Umacron"]=362,
 ["Umacroncyrillic"]=1262,
 ["Umacrondieresis"]=7802,
 ["Umonospace"]=65333,
 ["Uogonek"]=370,
 ["Upsilon"]=933,
 ["Upsilon1"]=978,
 ["Upsilonacutehooksymbolgreek"]=979,
 ["Upsilonafrican"]=433,
 ["Upsilondieresis"]=939,
 ["Upsilondieresishooksymbolgreek"]=980,
 ["Upsilonhooksymbol"]=978,
 ["Upsilontonos"]=910,
 ["Uring"]=366,
 ["Ushortcyrillic"]=1038,
 ["Usmall"]=63349,
 ["Ustraightcyrillic"]=1198,
 ["Ustraightstrokecyrillic"]=1200,
 ["Utilde"]=360,
 ["Utildeacute"]=7800,
 ["Utildebelow"]=7796,
 ["V"]=86,
 ["Vcircle"]=9419,
 ["Vdotbelow"]=7806,
 ["Vecyrillic"]=1042,
 ["Vewarmenian"]=1358,
 ["Vhook"]=434,
 ["Vmonospace"]=65334,
 ["Voarmenian"]=1352,
 ["Vsmall"]=63350,
 ["Vtilde"]=7804,
 ["W"]=87,
 ["Wacute"]=7810,
 ["Wcircle"]=9420,
 ["Wcircumflex"]=372,
 ["Wdieresis"]=7812,
 ["Wdotaccent"]=7814,
 ["Wdotbelow"]=7816,
 ["Wgrave"]=7808,
 ["Wmonospace"]=65335,
 ["Wsmall"]=63351,
 ["X"]=88,
 ["Xcircle"]=9421,
 ["Xdieresis"]=7820,
 ["Xdotaccent"]=7818,
 ["Xeharmenian"]=1341,
 ["Xi"]=926,
 ["Xmonospace"]=65336,
 ["Xsmall"]=63352,
 ["Y"]=89,
 ["Yacute"]=221,
 ["Yacutesmall"]=63485,
 ["Yatcyrillic"]=1122,
 ["Ycircle"]=9422,
 ["Ycircumflex"]=374,
 ["Ydieresis"]=376,
 ["Ydieresissmall"]=63487,
 ["Ydotaccent"]=7822,
 ["Ydotbelow"]=7924,
 ["Yericyrillic"]=1067,
 ["Yerudieresiscyrillic"]=1272,
 ["Ygrave"]=7922,
 ["Yhook"]=435,
 ["Yhookabove"]=7926,
 ["Yiarmenian"]=1349,
 ["Yicyrillic"]=1031,
 ["Yiwnarmenian"]=1362,
 ["Ymonospace"]=65337,
 ["Ysmall"]=63353,
 ["Ytilde"]=7928,
 ["Yusbigcyrillic"]=1130,
 ["Yusbigiotifiedcyrillic"]=1132,
 ["Yuslittlecyrillic"]=1126,
 ["Yuslittleiotifiedcyrillic"]=1128,
 ["Z"]=90,
 ["Zaarmenian"]=1334,
 ["Zacute"]=377,
 ["Zcaron"]=381,
 ["Zcaronsmall"]=63231,
 ["Zcircle"]=9423,
 ["Zcircumflex"]=7824,
 ["Zdot"]=379,
 ["Zdotaccent"]=379,
 ["Zdotbelow"]=7826,
 ["Zecyrillic"]=1047,
 ["Zedescendercyrillic"]=1176,
 ["Zedieresiscyrillic"]=1246,
 ["Zeta"]=918,
 ["Zhearmenian"]=1338,
 ["Zhebrevecyrillic"]=1217,
 ["Zhecyrillic"]=1046,
 ["Zhedescendercyrillic"]=1174,
 ["Zhedieresiscyrillic"]=1244,
 ["Zlinebelow"]=7828,
 ["Zmonospace"]=65338,
 ["Zsmall"]=63354,
 ["Zstroke"]=437,
 ["a"]=97,
 ["aabengali"]=2438,
 ["aacute"]=225,
 ["aadeva"]=2310,
 ["aagujarati"]=2694,
 ["aagurmukhi"]=2566,
 ["aamatragurmukhi"]=2622,
 ["aarusquare"]=13059,
 ["aavowelsignbengali"]=2494,
 ["aavowelsigndeva"]=2366,
 ["aavowelsigngujarati"]=2750,
 ["abbreviationmarkarmenian"]=1375,
 ["abbreviationsigndeva"]=2416,
 ["abengali"]=2437,
 ["abopomofo"]=12570,
 ["abreve"]=259,
 ["abreveacute"]=7855,
 ["abrevecyrillic"]=1233,
 ["abrevedotbelow"]=7863,
 ["abrevegrave"]=7857,
 ["abrevehookabove"]=7859,
 ["abrevetilde"]=7861,
 ["acaron"]=462,
 ["acircle"]=9424,
 ["acircumflex"]=226,
 ["acircumflexacute"]=7845,
 ["acircumflexdotbelow"]=7853,
 ["acircumflexgrave"]=7847,
 ["acircumflexhookabove"]=7849,
 ["acircumflextilde"]=7851,
 ["acute"]=180,
 ["acutebelowcmb"]=791,
 ["acutecmb"]=769,
 ["acutecomb"]=769,
 ["acutedeva"]=2388,
 ["acutelowmod"]=719,
 ["acutetonecmb"]=833,
 ["acyrillic"]=1072,
 ["adblgrave"]=513,
 ["addakgurmukhi"]=2673,
 ["adeva"]=2309,
 ["adieresis"]=228,
 ["adieresiscyrillic"]=1235,
 ["adieresismacron"]=479,
 ["adotbelow"]=7841,
 ["adotmacron"]=481,
 ["ae"]=230,
 ["aeacute"]=509,
 ["aekorean"]=12624,
 ["aemacron"]=483,
 ["afii00208"]=8213,
 ["afii08941"]=8356,
 ["afii10017"]=1040,
 ["afii10018"]=1041,
 ["afii10019"]=1042,
 ["afii10020"]=1043,
 ["afii10021"]=1044,
 ["afii10022"]=1045,
 ["afii10023"]=1025,
 ["afii10024"]=1046,
 ["afii10025"]=1047,
 ["afii10026"]=1048,
 ["afii10027"]=1049,
 ["afii10028"]=1050,
 ["afii10029"]=1051,
 ["afii10030"]=1052,
 ["afii10031"]=1053,
 ["afii10032"]=1054,
 ["afii10033"]=1055,
 ["afii10034"]=1056,
 ["afii10035"]=1057,
 ["afii10036"]=1058,
 ["afii10037"]=1059,
 ["afii10038"]=1060,
 ["afii10039"]=1061,
 ["afii10040"]=1062,
 ["afii10041"]=1063,
 ["afii10042"]=1064,
 ["afii10043"]=1065,
 ["afii10044"]=1066,
 ["afii10045"]=1067,
 ["afii10046"]=1068,
 ["afii10047"]=1069,
 ["afii10048"]=1070,
 ["afii10049"]=1071,
 ["afii10050"]=1168,
 ["afii10051"]=1026,
 ["afii10052"]=1027,
 ["afii10053"]=1028,
 ["afii10054"]=1029,
 ["afii10055"]=1030,
 ["afii10056"]=1031,
 ["afii10057"]=1032,
 ["afii10058"]=1033,
 ["afii10059"]=1034,
 ["afii10060"]=1035,
 ["afii10061"]=1036,
 ["afii10062"]=1038,
 ["afii10063"]=63172,
 ["afii10064"]=63173,
 ["afii10065"]=1072,
 ["afii10066"]=1073,
 ["afii10067"]=1074,
 ["afii10068"]=1075,
 ["afii10069"]=1076,
 ["afii10070"]=1077,
 ["afii10071"]=1105,
 ["afii10072"]=1078,
 ["afii10073"]=1079,
 ["afii10074"]=1080,
 ["afii10075"]=1081,
 ["afii10076"]=1082,
 ["afii10077"]=1083,
 ["afii10078"]=1084,
 ["afii10079"]=1085,
 ["afii10080"]=1086,
 ["afii10081"]=1087,
 ["afii10082"]=1088,
 ["afii10083"]=1089,
 ["afii10084"]=1090,
 ["afii10085"]=1091,
 ["afii10086"]=1092,
 ["afii10087"]=1093,
 ["afii10088"]=1094,
 ["afii10089"]=1095,
 ["afii10090"]=1096,
 ["afii10091"]=1097,
 ["afii10092"]=1098,
 ["afii10093"]=1099,
 ["afii10094"]=1100,
 ["afii10095"]=1101,
 ["afii10096"]=1102,
 ["afii10097"]=1103,
 ["afii10098"]=1169,
 ["afii10099"]=1106,
 ["afii10100"]=1107,
 ["afii10101"]=1108,
 ["afii10102"]=1109,
 ["afii10103"]=1110,
 ["afii10104"]=1111,
 ["afii10105"]=1112,
 ["afii10106"]=1113,
 ["afii10107"]=1114,
 ["afii10108"]=1115,
 ["afii10109"]=1116,
 ["afii10110"]=1118,
 ["afii10145"]=1039,
 ["afii10146"]=1122,
 ["afii10147"]=1138,
 ["afii10148"]=1140,
 ["afii10192"]=63174,
 ["afii10193"]=1119,
 ["afii10194"]=1123,
 ["afii10195"]=1139,
 ["afii10196"]=1141,
 ["afii10831"]=63175,
 ["afii10832"]=63176,
 ["afii10846"]=1241,
 ["afii208"]=8213,
 ["afii299"]=8206,
 ["afii300"]=8207,
 ["afii301"]=8205,
 ["afii57381"]=1642,
 ["afii57388"]=1548,
 ["afii57392"]=1632,
 ["afii57393"]=1633,
 ["afii57394"]=1634,
 ["afii57395"]=1635,
 ["afii57396"]=1636,
 ["afii57397"]=1637,
 ["afii57398"]=1638,
 ["afii57399"]=1639,
 ["afii57400"]=1640,
 ["afii57401"]=1641,
 ["afii57403"]=1563,
 ["afii57407"]=1567,
 ["afii57409"]=1569,
 ["afii57410"]=1570,
 ["afii57411"]=1571,
 ["afii57412"]=1572,
 ["afii57413"]=1573,
 ["afii57414"]=1574,
 ["afii57415"]=1575,
 ["afii57416"]=1576,
 ["afii57417"]=1577,
 ["afii57418"]=1578,
 ["afii57419"]=1579,
 ["afii57420"]=1580,
 ["afii57421"]=1581,
 ["afii57422"]=1582,
 ["afii57423"]=1583,
 ["afii57424"]=1584,
 ["afii57425"]=1585,
 ["afii57426"]=1586,
 ["afii57427"]=1587,
 ["afii57428"]=1588,
 ["afii57429"]=1589,
 ["afii57430"]=1590,
 ["afii57431"]=1591,
 ["afii57432"]=1592,
 ["afii57433"]=1593,
 ["afii57434"]=1594,
 ["afii57440"]=1600,
 ["afii57441"]=1601,
 ["afii57442"]=1602,
 ["afii57443"]=1603,
 ["afii57444"]=1604,
 ["afii57445"]=1605,
 ["afii57446"]=1606,
 ["afii57448"]=1608,
 ["afii57449"]=1609,
 ["afii57450"]=1610,
 ["afii57451"]=1611,
 ["afii57452"]=1612,
 ["afii57453"]=1613,
 ["afii57454"]=1614,
 ["afii57455"]=1615,
 ["afii57456"]=1616,
 ["afii57457"]=1617,
 ["afii57458"]=1618,
 ["afii57470"]=1607,
 ["afii57505"]=1700,
 ["afii57506"]=1662,
 ["afii57507"]=1670,
 ["afii57508"]=1688,
 ["afii57509"]=1711,
 ["afii57511"]=1657,
 ["afii57512"]=1672,
 ["afii57513"]=1681,
 ["afii57514"]=1722,
 ["afii57519"]=1746,
 ["afii57534"]=1749,
 ["afii57636"]=8362,
 ["afii57645"]=1470,
 ["afii57658"]=1475,
 ["afii57664"]=1488,
 ["afii57665"]=1489,
 ["afii57666"]=1490,
 ["afii57667"]=1491,
 ["afii57668"]=1492,
 ["afii57669"]=1493,
 ["afii57670"]=1494,
 ["afii57671"]=1495,
 ["afii57672"]=1496,
 ["afii57673"]=1497,
 ["afii57674"]=1498,
 ["afii57675"]=1499,
 ["afii57676"]=1500,
 ["afii57677"]=1501,
 ["afii57678"]=1502,
 ["afii57679"]=1503,
 ["afii57680"]=1504,
 ["afii57681"]=1505,
 ["afii57682"]=1506,
 ["afii57683"]=1507,
 ["afii57684"]=1508,
 ["afii57685"]=1509,
 ["afii57686"]=1510,
 ["afii57687"]=1511,
 ["afii57688"]=1512,
 ["afii57689"]=1513,
 ["afii57690"]=1514,
 ["afii57694"]=64298,
 ["afii57695"]=64299,
 ["afii57700"]=64331,
 ["afii57705"]=64287,
 ["afii57716"]=1520,
 ["afii57717"]=1521,
 ["afii57718"]=1522,
 ["afii57723"]=64309,
 ["afii57793"]=1460,
 ["afii57794"]=1461,
 ["afii57795"]=1462,
 ["afii57796"]=1467,
 ["afii57797"]=1464,
 ["afii57798"]=1463,
 ["afii57799"]=1456,
 ["afii57800"]=1458,
 ["afii57801"]=1457,
 ["afii57802"]=1459,
 ["afii57803"]=1474,
 ["afii57804"]=1473,
 ["afii57806"]=1465,
 ["afii57807"]=1468,
 ["afii57839"]=1469,
 ["afii57841"]=1471,
 ["afii57842"]=1472,
 ["afii57929"]=700,
 ["afii61248"]=8453,
 ["afii61289"]=8467,
 ["afii61352"]=8470,
 ["afii61573"]=8236,
 ["afii61574"]=8237,
 ["afii61575"]=8238,
 ["afii61664"]=8204,
 ["afii63167"]=1645,
 ["afii64937"]=701,
 ["agrave"]=224,
 ["agujarati"]=2693,
 ["agurmukhi"]=2565,
 ["ahiragana"]=12354,
 ["ahookabove"]=7843,
 ["aibengali"]=2448,
 ["aibopomofo"]=12574,
 ["aideva"]=2320,
 ["aiecyrillic"]=1237,
 ["aigujarati"]=2704,
 ["aigurmukhi"]=2576,
 ["aimatragurmukhi"]=2632,
 ["ainarabic"]=1593,
 ["ainfinalarabic"]=65226,
 ["aininitialarabic"]=65227,
 ["ainmedialarabic"]=65228,
 ["ainvertedbreve"]=515,
 ["aivowelsignbengali"]=2504,
 ["aivowelsigndeva"]=2376,
 ["aivowelsigngujarati"]=2760,
 ["akatakana"]=12450,
 ["akatakanahalfwidth"]=65393,
 ["akorean"]=12623,
 ["alef"]=1488,
 ["alefarabic"]=1575,
 ["alefdageshhebrew"]=64304,
 ["aleffinalarabic"]=65166,
 ["alefhamzaabovearabic"]=1571,
 ["alefhamzaabovefinalarabic"]=65156,
 ["alefhamzabelowarabic"]=1573,
 ["alefhamzabelowfinalarabic"]=65160,
 ["alefhebrew"]=1488,
 ["aleflamedhebrew"]=64335,
 ["alefmaddaabovearabic"]=1570,
 ["alefmaddaabovefinalarabic"]=65154,
 ["alefmaksuraarabic"]=1609,
 ["alefmaksurafinalarabic"]=65264,
 ["alefmaksurainitialarabic"]=65267,
 ["alefmaksuramedialarabic"]=65268,
 ["alefpatahhebrew"]=64302,
 ["alefqamatshebrew"]=64303,
 ["aleph"]=8501,
 ["allequal"]=8780,
 ["alpha"]=945,
 ["alphatonos"]=940,
 ["amacron"]=257,
 ["amonospace"]=65345,
 ["ampersand"]=38,
 ["ampersandmonospace"]=65286,
 ["ampersandsmall"]=63270,
 ["amsquare"]=13250,
 ["anbopomofo"]=12578,
 ["angbopomofo"]=12580,
 ["angkhankhuthai"]=3674,
 ["angle"]=8736,
 ["anglebracketleft"]=12296,
 ["anglebracketleftvertical"]=65087,
 ["anglebracketright"]=12297,
 ["anglebracketrightvertical"]=65088,
 ["angleleft"]=9001,
 ["angleright"]=9002,
 ["angstrom"]=8491,
 ["anoteleia"]=903,
 ["anudattadeva"]=2386,
 ["anusvarabengali"]=2434,
 ["anusvaradeva"]=2306,
 ["anusvaragujarati"]=2690,
 ["aogonek"]=261,
 ["apaatosquare"]=13056,
 ["aparen"]=9372,
 ["apostrophearmenian"]=1370,
 ["apostrophemod"]=700,
 ["apple"]=63743,
 ["approaches"]=8784,
 ["approxequal"]=8776,
 ["approxequalorimage"]=8786,
 ["approximatelyequal"]=8773,
 ["araeaekorean"]=12686,
 ["araeakorean"]=12685,
 ["arc"]=8978,
 ["arighthalfring"]=7834,
 ["aring"]=229,
 ["aringacute"]=507,
 ["aringbelow"]=7681,
 ["arrowboth"]=8596,
 ["arrowdashdown"]=8675,
 ["arrowdashleft"]=8672,
 ["arrowdashright"]=8674,
 ["arrowdashup"]=8673,
 ["arrowdblboth"]=8660,
 ["arrowdbldown"]=8659,
 ["arrowdblleft"]=8656,
 ["arrowdblright"]=8658,
 ["arrowdblup"]=8657,
 ["arrowdown"]=8595,
 ["arrowdownleft"]=8601,
 ["arrowdownright"]=8600,
 ["arrowdownwhite"]=8681,
 ["arrowheaddownmod"]=709,
 ["arrowheadleftmod"]=706,
 ["arrowheadrightmod"]=707,
 ["arrowheadupmod"]=708,
 ["arrowhorizex"]=63719,
 ["arrowleft"]=8592,
 ["arrowleftdbl"]=8656,
 ["arrowleftdblstroke"]=8653,
 ["arrowleftoverright"]=8646,
 ["arrowleftwhite"]=8678,
 ["arrowright"]=8594,
 ["arrowrightdblstroke"]=8655,
 ["arrowrightheavy"]=10142,
 ["arrowrightoverleft"]=8644,
 ["arrowrightwhite"]=8680,
 ["arrowtableft"]=8676,
 ["arrowtabright"]=8677,
 ["arrowup"]=8593,
 ["arrowupdn"]=8597,
 ["arrowupdnbse"]=8616,
 ["arrowupdownbase"]=8616,
 ["arrowupleft"]=8598,
 ["arrowupleftofdown"]=8645,
 ["arrowupright"]=8599,
 ["arrowupwhite"]=8679,
 ["arrowvertex"]=63718,
 ["asciicircum"]=94,
 ["asciicircummonospace"]=65342,
 ["asciitilde"]=126,
 ["asciitildemonospace"]=65374,
 ["ascript"]=593,
 ["ascriptturned"]=594,
 ["asmallhiragana"]=12353,
 ["asmallkatakana"]=12449,
 ["asmallkatakanahalfwidth"]=65383,
 ["asterisk"]=42,
 ["asteriskaltonearabic"]=1645,
 ["asteriskarabic"]=1645,
 ["asteriskmath"]=8727,
 ["asteriskmonospace"]=65290,
 ["asterisksmall"]=65121,
 ["asterism"]=8258,
 ["asuperior"]=63209,
 ["asymptoticallyequal"]=8771,
 ["at"]=64,
 ["atilde"]=227,
 ["atmonospace"]=65312,
 ["atsmall"]=65131,
 ["aturned"]=592,
 ["aubengali"]=2452,
 ["aubopomofo"]=12576,
 ["audeva"]=2324,
 ["augujarati"]=2708,
 ["augurmukhi"]=2580,
 ["aulengthmarkbengali"]=2519,
 ["aumatragurmukhi"]=2636,
 ["auvowelsignbengali"]=2508,
 ["auvowelsigndeva"]=2380,
 ["auvowelsigngujarati"]=2764,
 ["avagrahadeva"]=2365,
 ["aybarmenian"]=1377,
 ["ayin"]=1506,
 ["ayinaltonehebrew"]=64288,
 ["ayinhebrew"]=1506,
 ["b"]=98,
 ["babengali"]=2476,
 ["backslash"]=92,
 ["backslashmonospace"]=65340,
 ["badeva"]=2348,
 ["bagujarati"]=2732,
 ["bagurmukhi"]=2604,
 ["bahiragana"]=12400,
 ["bahtthai"]=3647,
 ["bakatakana"]=12496,
 ["bar"]=124,
 ["barmonospace"]=65372,
 ["bbopomofo"]=12549,
 ["bcircle"]=9425,
 ["bdotaccent"]=7683,
 ["bdotbelow"]=7685,
 ["beamedsixteenthnotes"]=9836,
 ["because"]=8757,
 ["becyrillic"]=1073,
 ["beharabic"]=1576,
 ["behfinalarabic"]=65168,
 ["behinitialarabic"]=65169,
 ["behiragana"]=12409,
 ["behmedialarabic"]=65170,
 ["behmeeminitialarabic"]=64671,
 ["behmeemisolatedarabic"]=64520,
 ["behnoonfinalarabic"]=64621,
 ["bekatakana"]=12505,
 ["benarmenian"]=1378,
 ["bet"]=1489,
 ["beta"]=946,
 ["betasymbolgreek"]=976,
 ["betdagesh"]=64305,
 ["betdageshhebrew"]=64305,
 ["bethebrew"]=1489,
 ["betrafehebrew"]=64332,
 ["bhabengali"]=2477,
 ["bhadeva"]=2349,
 ["bhagujarati"]=2733,
 ["bhagurmukhi"]=2605,
 ["bhook"]=595,
 ["bihiragana"]=12403,
 ["bikatakana"]=12499,
 ["bilabialclick"]=664,
 ["bindigurmukhi"]=2562,
 ["birusquare"]=13105,
 ["blackcircle"]=9679,
 ["blackdiamond"]=9670,
 ["blackdownpointingtriangle"]=9660,
 ["blackleftpointingpointer"]=9668,
 ["blackleftpointingtriangle"]=9664,
 ["blacklenticularbracketleft"]=12304,
 ["blacklenticularbracketleftvertical"]=65083,
 ["blacklenticularbracketright"]=12305,
 ["blacklenticularbracketrightvertical"]=65084,
 ["blacklowerlefttriangle"]=9699,
 ["blacklowerrighttriangle"]=9698,
 ["blackrectangle"]=9644,
 ["blackrightpointingpointer"]=9658,
 ["blackrightpointingtriangle"]=9654,
 ["blacksmallsquare"]=9642,
 ["blacksmilingface"]=9787,
 ["blacksquare"]=9632,
 ["blackstar"]=9733,
 ["blackupperlefttriangle"]=9700,
 ["blackupperrighttriangle"]=9701,
 ["blackuppointingsmalltriangle"]=9652,
 ["blackuppointingtriangle"]=9650,
 ["blank"]=9251,
 ["blinebelow"]=7687,
 ["block"]=9608,
 ["bmonospace"]=65346,
 ["bobaimaithai"]=3610,
 ["bohiragana"]=12412,
 ["bokatakana"]=12508,
 ["bparen"]=9373,
 ["bqsquare"]=13251,
 ["braceex"]=63732,
 ["braceleft"]=123,
 ["braceleftbt"]=63731,
 ["braceleftmid"]=63730,
 ["braceleftmonospace"]=65371,
 ["braceleftsmall"]=65115,
 ["bracelefttp"]=63729,
 ["braceleftvertical"]=65079,
 ["braceright"]=125,
 ["bracerightbt"]=63742,
 ["bracerightmid"]=63741,
 ["bracerightmonospace"]=65373,
 ["bracerightsmall"]=65116,
 ["bracerighttp"]=63740,
 ["bracerightvertical"]=65080,
 ["bracketleft"]=91,
 ["bracketleftbt"]=63728,
 ["bracketleftex"]=63727,
 ["bracketleftmonospace"]=65339,
 ["bracketlefttp"]=63726,
 ["bracketright"]=93,
 ["bracketrightbt"]=63739,
 ["bracketrightex"]=63738,
 ["bracketrightmonospace"]=65341,
 ["bracketrighttp"]=63737,
 ["breve"]=728,
 ["brevebelowcmb"]=814,
 ["brevecmb"]=774,
 ["breveinvertedbelowcmb"]=815,
 ["breveinvertedcmb"]=785,
 ["breveinverteddoublecmb"]=865,
 ["bridgebelowcmb"]=810,
 ["bridgeinvertedbelowcmb"]=826,
 ["brokenbar"]=166,
 ["bstroke"]=384,
 ["bsuperior"]=63210,
 ["btopbar"]=387,
 ["buhiragana"]=12406,
 ["bukatakana"]=12502,
 ["bullet"]=8226,
 ["bulletinverse"]=9688,
 ["bulletoperator"]=8729,
 ["bullseye"]=9678,
 ["c"]=99,
 ["caarmenian"]=1390,
 ["cabengali"]=2458,
 ["cacute"]=263,
 ["cadeva"]=2330,
 ["cagujarati"]=2714,
 ["cagurmukhi"]=2586,
 ["calsquare"]=13192,
 ["candrabindubengali"]=2433,
 ["candrabinducmb"]=784,
 ["candrabindudeva"]=2305,
 ["candrabindugujarati"]=2689,
 ["capslock"]=8682,
 ["careof"]=8453,
 ["caron"]=711,
 ["caronbelowcmb"]=812,
 ["caroncmb"]=780,
 ["carriagereturn"]=8629,
 ["cbopomofo"]=12568,
 ["ccaron"]=269,
 ["ccedilla"]=231,
 ["ccedillaacute"]=7689,
 ["ccircle"]=9426,
 ["ccircumflex"]=265,
 ["ccurl"]=597,
 ["cdot"]=267,
 ["cdotaccent"]=267,
 ["cdsquare"]=13253,
 ["cedilla"]=184,
 ["cedillacmb"]=807,
 ["cent"]=162,
 ["centigrade"]=8451,
 ["centinferior"]=63199,
 ["centmonospace"]=65504,
 ["centoldstyle"]=63394,
 ["centsuperior"]=63200,
 ["chaarmenian"]=1401,
 ["chabengali"]=2459,
 ["chadeva"]=2331,
 ["chagujarati"]=2715,
 ["chagurmukhi"]=2587,
 ["chbopomofo"]=12564,
 ["cheabkhasiancyrillic"]=1213,
 ["checkmark"]=10003,
 ["checyrillic"]=1095,
 ["chedescenderabkhasiancyrillic"]=1215,
 ["chedescendercyrillic"]=1207,
 ["chedieresiscyrillic"]=1269,
 ["cheharmenian"]=1395,
 ["chekhakassiancyrillic"]=1228,
 ["cheverticalstrokecyrillic"]=1209,
 ["chi"]=967,
 ["chieuchacirclekorean"]=12919,
 ["chieuchaparenkorean"]=12823,
 ["chieuchcirclekorean"]=12905,
 ["chieuchkorean"]=12618,
 ["chieuchparenkorean"]=12809,
 ["chochangthai"]=3594,
 ["chochanthai"]=3592,
 ["chochingthai"]=3593,
 ["chochoethai"]=3596,
 ["chook"]=392,
 ["cieucacirclekorean"]=12918,
 ["cieucaparenkorean"]=12822,
 ["cieuccirclekorean"]=12904,
 ["cieuckorean"]=12616,
 ["cieucparenkorean"]=12808,
 ["cieucuparenkorean"]=12828,
 ["circle"]=9675,
 ["circlemultiply"]=8855,
 ["circleot"]=8857,
 ["circleplus"]=8853,
 ["circlepostalmark"]=12342,
 ["circlewithlefthalfblack"]=9680,
 ["circlewithrighthalfblack"]=9681,
 ["circumflex"]=710,
 ["circumflexbelowcmb"]=813,
 ["circumflexcmb"]=770,
 ["clear"]=8999,
 ["clickalveolar"]=450,
 ["clickdental"]=448,
 ["clicklateral"]=449,
 ["clickretroflex"]=451,
 ["club"]=9827,
 ["clubsuitblack"]=9827,
 ["clubsuitwhite"]=9831,
 ["cmcubedsquare"]=13220,
 ["cmonospace"]=65347,
 ["cmsquaredsquare"]=13216,
 ["coarmenian"]=1409,
 ["colon"]=58,
 ["colonmonetary"]=8353,
 ["colonmonospace"]=65306,
 ["colonsign"]=8353,
 ["colonsmall"]=65109,
 ["colontriangularhalfmod"]=721,
 ["colontriangularmod"]=720,
 ["comma"]=44,
 ["commaabovecmb"]=787,
 ["commaaboverightcmb"]=789,
 ["commaaccent"]=63171,
 ["commaarabic"]=1548,
 ["commaarmenian"]=1373,
 ["commainferior"]=63201,
 ["commamonospace"]=65292,
 ["commareversedabovecmb"]=788,
 ["commareversedmod"]=701,
 ["commasmall"]=65104,
 ["commasuperior"]=63202,
 ["commaturnedabovecmb"]=786,
 ["commaturnedmod"]=699,
 ["compass"]=9788,
 ["congruent"]=8773,
 ["contourintegral"]=8750,
 ["control"]=8963,
 ["controlACK"]=6,
 ["controlBEL"]=7,
 ["controlBS"]=8,
 ["controlCAN"]=24,
 ["controlCR"]=13,
 ["controlDC1"]=17,
 ["controlDC2"]=18,
 ["controlDC3"]=19,
 ["controlDC4"]=20,
 ["controlDEL"]=127,
 ["controlDLE"]=16,
 ["controlEM"]=25,
 ["controlENQ"]=5,
 ["controlEOT"]=4,
 ["controlESC"]=27,
 ["controlETB"]=23,
 ["controlETX"]=3,
 ["controlFF"]=12,
 ["controlFS"]=28,
 ["controlGS"]=29,
 ["controlHT"]=9,
 ["controlLF"]=10,
 ["controlNAK"]=21,
 ["controlRS"]=30,
 ["controlSI"]=15,
 ["controlSO"]=14,
 ["controlSOT"]=2,
 ["controlSTX"]=1,
 ["controlSUB"]=26,
 ["controlSYN"]=22,
 ["controlUS"]=31,
 ["controlVT"]=11,
 ["copyright"]=169,
 ["copyrightsans"]=63721,
 ["copyrightserif"]=63193,
 ["cornerbracketleft"]=12300,
 ["cornerbracketlefthalfwidth"]=65378,
 ["cornerbracketleftvertical"]=65089,
 ["cornerbracketright"]=12301,
 ["cornerbracketrighthalfwidth"]=65379,
 ["cornerbracketrightvertical"]=65090,
 ["corporationsquare"]=13183,
 ["cosquare"]=13255,
 ["coverkgsquare"]=13254,
 ["cparen"]=9374,
 ["cruzeiro"]=8354,
 ["cstretched"]=663,
 ["curlyand"]=8911,
 ["curlyor"]=8910,
 ["currency"]=164,
 ["cyrBreve"]=63185,
 ["cyrFlex"]=63186,
 ["cyrbreve"]=63188,
 ["cyrflex"]=63189,
 ["d"]=100,
 ["daarmenian"]=1380,
 ["dabengali"]=2470,
 ["dadarabic"]=1590,
 ["dadeva"]=2342,
 ["dadfinalarabic"]=65214,
 ["dadinitialarabic"]=65215,
 ["dadmedialarabic"]=65216,
 ["dagesh"]=1468,
 ["dageshhebrew"]=1468,
 ["dagger"]=8224,
 ["daggerdbl"]=8225,
 ["dagujarati"]=2726,
 ["dagurmukhi"]=2598,
 ["dahiragana"]=12384,
 ["dakatakana"]=12480,
 ["dalarabic"]=1583,
 ["dalet"]=1491,
 ["daletdagesh"]=64307,
 ["daletdageshhebrew"]=64307,
 ["dalethatafpatah"]=1491,
 ["dalethatafpatahhebrew"]=1491,
 ["dalethatafsegol"]=1491,
 ["dalethatafsegolhebrew"]=1491,
 ["dalethebrew"]=1491,
 ["dalethiriq"]=1491,
 ["dalethiriqhebrew"]=1491,
 ["daletholam"]=1491,
 ["daletholamhebrew"]=1491,
 ["daletpatah"]=1491,
 ["daletpatahhebrew"]=1491,
 ["daletqamats"]=1491,
 ["daletqamatshebrew"]=1491,
 ["daletqubuts"]=1491,
 ["daletqubutshebrew"]=1491,
 ["daletsegol"]=1491,
 ["daletsegolhebrew"]=1491,
 ["daletsheva"]=1491,
 ["daletshevahebrew"]=1491,
 ["dalettsere"]=1491,
 ["dalettserehebrew"]=1491,
 ["dalfinalarabic"]=65194,
 ["dammaarabic"]=1615,
 ["dammalowarabic"]=1615,
 ["dammatanaltonearabic"]=1612,
 ["dammatanarabic"]=1612,
 ["danda"]=2404,
 ["dargahebrew"]=1447,
 ["dargalefthebrew"]=1447,
 ["dasiapneumatacyrilliccmb"]=1157,
 ["dblGrave"]=63187,
 ["dblanglebracketleft"]=12298,
 ["dblanglebracketleftvertical"]=65085,
 ["dblanglebracketright"]=12299,
 ["dblanglebracketrightvertical"]=65086,
 ["dblarchinvertedbelowcmb"]=811,
 ["dblarrowleft"]=8660,
 ["dblarrowright"]=8658,
 ["dbldanda"]=2405,
 ["dblgrave"]=63190,
 ["dblgravecmb"]=783,
 ["dblintegral"]=8748,
 ["dbllowline"]=8215,
 ["dbllowlinecmb"]=819,
 ["dbloverlinecmb"]=831,
 ["dblprimemod"]=698,
 ["dblverticalbar"]=8214,
 ["dblverticallineabovecmb"]=782,
 ["dbopomofo"]=12553,
 ["dbsquare"]=13256,
 ["dcaron"]=271,
 ["dcedilla"]=7697,
 ["dcircle"]=9427,
 ["dcircumflexbelow"]=7699,
 ["dcroat"]=273,
 ["ddabengali"]=2465,
 ["ddadeva"]=2337,
 ["ddagujarati"]=2721,
 ["ddagurmukhi"]=2593,
 ["ddalarabic"]=1672,
 ["ddalfinalarabic"]=64393,
 ["dddhadeva"]=2396,
 ["ddhabengali"]=2466,
 ["ddhadeva"]=2338,
 ["ddhagujarati"]=2722,
 ["ddhagurmukhi"]=2594,
 ["ddotaccent"]=7691,
 ["ddotbelow"]=7693,
 ["decimalseparatorarabic"]=1643,
 ["decimalseparatorpersian"]=1643,
 ["decyrillic"]=1076,
 ["degree"]=176,
 ["dehihebrew"]=1453,
 ["dehiragana"]=12391,
 ["deicoptic"]=1007,
 ["dekatakana"]=12487,
 ["deleteleft"]=9003,
 ["deleteright"]=8998,
 ["delta"]=948,
 ["deltaturned"]=397,
 ["denominatorminusonenumeratorbengali"]=2552,
 ["dezh"]=676,
 ["dhabengali"]=2471,
 ["dhadeva"]=2343,
 ["dhagujarati"]=2727,
 ["dhagurmukhi"]=2599,
 ["dhook"]=599,
 ["dialytikatonos"]=901,
 ["dialytikatonoscmb"]=836,
 ["diamond"]=9830,
 ["diamondsuitwhite"]=9826,
 ["dieresis"]=168,
 ["dieresisacute"]=63191,
 ["dieresisbelowcmb"]=804,
 ["dieresiscmb"]=776,
 ["dieresisgrave"]=63192,
 ["dieresistonos"]=901,
 ["dihiragana"]=12386,
 ["dikatakana"]=12482,
 ["dittomark"]=12291,
 ["divide"]=247,
 ["divides"]=8739,
 ["divisionslash"]=8725,
 ["djecyrillic"]=1106,
 ["dkshade"]=9619,
 ["dlinebelow"]=7695,
 ["dlsquare"]=13207,
 ["dmacron"]=273,
 ["dmonospace"]=65348,
 ["dnblock"]=9604,
 ["dochadathai"]=3598,
 ["dodekthai"]=3604,
 ["dohiragana"]=12393,
 ["dokatakana"]=12489,
 ["dollar"]=36,
 ["dollarinferior"]=63203,
 ["dollarmonospace"]=65284,
 ["dollaroldstyle"]=63268,
 ["dollarsmall"]=65129,
 ["dollarsuperior"]=63204,
 ["dong"]=8363,
 ["dorusquare"]=13094,
 ["dotaccent"]=729,
 ["dotaccentcmb"]=775,
 ["dotbelowcmb"]=803,
 ["dotbelowcomb"]=803,
 ["dotkatakana"]=12539,
 ["dotlessi"]=305,
 ["dotlessj"]=63166,
 ["dotlessjstrokehook"]=644,
 ["dotmath"]=8901,
 ["dottedcircle"]=9676,
 ["doubleyodpatah"]=64287,
 ["doubleyodpatahhebrew"]=64287,
 ["downtackbelowcmb"]=798,
 ["downtackmod"]=725,
 ["dparen"]=9375,
 ["dsuperior"]=63211,
 ["dtail"]=598,
 ["dtopbar"]=396,
 ["duhiragana"]=12389,
 ["dukatakana"]=12485,
 ["dz"]=499,
 ["dzaltone"]=675,
 ["dzcaron"]=454,
 ["dzcurl"]=677,
 ["dzeabkhasiancyrillic"]=1249,
 ["dzecyrillic"]=1109,
 ["dzhecyrillic"]=1119,
 ["e"]=101,
 ["eacute"]=233,
 ["earth"]=9793,
 ["ebengali"]=2447,
 ["ebopomofo"]=12572,
 ["ebreve"]=277,
 ["ecandradeva"]=2317,
 ["ecandragujarati"]=2701,
 ["ecandravowelsigndeva"]=2373,
 ["ecandravowelsigngujarati"]=2757,
 ["ecaron"]=283,
 ["ecedillabreve"]=7709,
 ["echarmenian"]=1381,
 ["echyiwnarmenian"]=1415,
 ["ecircle"]=9428,
 ["ecircumflex"]=234,
 ["ecircumflexacute"]=7871,
 ["ecircumflexbelow"]=7705,
 ["ecircumflexdotbelow"]=7879,
 ["ecircumflexgrave"]=7873,
 ["ecircumflexhookabove"]=7875,
 ["ecircumflextilde"]=7877,
 ["ecyrillic"]=1108,
 ["edblgrave"]=517,
 ["edeva"]=2319,
 ["edieresis"]=235,
 ["edot"]=279,
 ["edotaccent"]=279,
 ["edotbelow"]=7865,
 ["eegurmukhi"]=2575,
 ["eematragurmukhi"]=2631,
 ["efcyrillic"]=1092,
 ["egrave"]=232,
 ["egujarati"]=2703,
 ["eharmenian"]=1383,
 ["ehbopomofo"]=12573,
 ["ehiragana"]=12360,
 ["ehookabove"]=7867,
 ["eibopomofo"]=12575,
 ["eight"]=56,
 ["eightarabic"]=1640,
 ["eightbengali"]=2542,
 ["eightcircle"]=9319,
 ["eightcircleinversesansserif"]=10129,
 ["eightdeva"]=2414,
 ["eighteencircle"]=9329,
 ["eighteenparen"]=9349,
 ["eighteenperiod"]=9369,
 ["eightgujarati"]=2798,
 ["eightgurmukhi"]=2670,
 ["eighthackarabic"]=1640,
 ["eighthangzhou"]=12328,
 ["eighthnotebeamed"]=9835,
 ["eightideographicparen"]=12839,
 ["eightinferior"]=8328,
 ["eightmonospace"]=65304,
 ["eightoldstyle"]=63288,
 ["eightparen"]=9339,
 ["eightperiod"]=9359,
 ["eightpersian"]=1784,
 ["eightroman"]=8567,
 ["eightsuperior"]=8312,
 ["eightthai"]=3672,
 ["einvertedbreve"]=519,
 ["eiotifiedcyrillic"]=1125,
 ["ekatakana"]=12456,
 ["ekatakanahalfwidth"]=65396,
 ["ekonkargurmukhi"]=2676,
 ["ekorean"]=12628,
 ["elcyrillic"]=1083,
 ["element"]=8712,
 ["elevencircle"]=9322,
 ["elevenparen"]=9342,
 ["elevenperiod"]=9362,
 ["elevenroman"]=8570,
 ["ellipsis"]=8230,
 ["ellipsisvertical"]=8942,
 ["emacron"]=275,
 ["emacronacute"]=7703,
 ["emacrongrave"]=7701,
 ["emcyrillic"]=1084,
 ["emdash"]=8212,
 ["emdashvertical"]=65073,
 ["emonospace"]=65349,
 ["emphasismarkarmenian"]=1371,
 ["emptyset"]=8709,
 ["enbopomofo"]=12579,
 ["encyrillic"]=1085,
 ["endash"]=8211,
 ["endashvertical"]=65074,
 ["endescendercyrillic"]=1187,
 ["eng"]=331,
 ["engbopomofo"]=12581,
 ["enghecyrillic"]=1189,
 ["enhookcyrillic"]=1224,
 ["enspace"]=8194,
 ["eogonek"]=281,
 ["eokorean"]=12627,
 ["eopen"]=603,
 ["eopenclosed"]=666,
 ["eopenreversed"]=604,
 ["eopenreversedclosed"]=606,
 ["eopenreversedhook"]=605,
 ["eparen"]=9376,
 ["epsilon"]=949,
 ["epsilontonos"]=941,
 ["equal"]=61,
 ["equalmonospace"]=65309,
 ["equalsmall"]=65126,
 ["equalsuperior"]=8316,
 ["equivalence"]=8801,
 ["erbopomofo"]=12582,
 ["ercyrillic"]=1088,
 ["ereversed"]=600,
 ["ereversedcyrillic"]=1101,
 ["escyrillic"]=1089,
 ["esdescendercyrillic"]=1195,
 ["esh"]=643,
 ["eshcurl"]=646,
 ["eshortdeva"]=2318,
 ["eshortvowelsigndeva"]=2374,
 ["eshreversedloop"]=426,
 ["eshsquatreversed"]=645,
 ["esmallhiragana"]=12359,
 ["esmallkatakana"]=12455,
 ["esmallkatakanahalfwidth"]=65386,
 ["estimated"]=8494,
 ["esuperior"]=63212,
 ["eta"]=951,
 ["etarmenian"]=1384,
 ["etatonos"]=942,
 ["eth"]=240,
 ["etilde"]=7869,
 ["etildebelow"]=7707,
 ["etnahtafoukhhebrew"]=1425,
 ["etnahtafoukhlefthebrew"]=1425,
 ["etnahtahebrew"]=1425,
 ["etnahtalefthebrew"]=1425,
 ["eturned"]=477,
 ["eukorean"]=12641,
 ["euro"]=8364,
 ["evowelsignbengali"]=2503,
 ["evowelsigndeva"]=2375,
 ["evowelsigngujarati"]=2759,
 ["exclam"]=33,
 ["exclamarmenian"]=1372,
 ["exclamdbl"]=8252,
 ["exclamdown"]=161,
 ["exclamdownsmall"]=63393,
 ["exclammonospace"]=65281,
 ["exclamsmall"]=63265,
 ["existential"]=8707,
 ["ezh"]=658,
 ["ezhcaron"]=495,
 ["ezhcurl"]=659,
 ["ezhreversed"]=441,
 ["ezhtail"]=442,
 ["f"]=102,
 ["fadeva"]=2398,
 ["fagurmukhi"]=2654,
 ["fahrenheit"]=8457,
 ["fathaarabic"]=1614,
 ["fathalowarabic"]=1614,
 ["fathatanarabic"]=1611,
 ["fbopomofo"]=12552,
 ["fcircle"]=9429,
 ["fdotaccent"]=7711,
 ["feharabic"]=1601,
 ["feharmenian"]=1414,
 ["fehfinalarabic"]=65234,
 ["fehinitialarabic"]=65235,
 ["fehmedialarabic"]=65236,
 ["feicoptic"]=997,
 ["female"]=9792,
 ["ff"]=64256,
 ["ffi"]=64259,
 ["ffl"]=64260,
 ["fi"]=64257,
 ["fifteencircle"]=9326,
 ["fifteenparen"]=9346,
 ["fifteenperiod"]=9366,
 ["figuredash"]=8210,
 ["filledbox"]=9632,
 ["filledrect"]=9644,
 ["finalkaf"]=1498,
 ["finalkafdagesh"]=64314,
 ["finalkafdageshhebrew"]=64314,
 ["finalkafhebrew"]=1498,
 ["finalkafqamats"]=1498,
 ["finalkafqamatshebrew"]=1498,
 ["finalkafsheva"]=1498,
 ["finalkafshevahebrew"]=1498,
 ["finalmem"]=1501,
 ["finalmemhebrew"]=1501,
 ["finalnun"]=1503,
 ["finalnunhebrew"]=1503,
 ["finalpe"]=1507,
 ["finalpehebrew"]=1507,
 ["finaltsadi"]=1509,
 ["finaltsadihebrew"]=1509,
 ["firsttonechinese"]=713,
 ["fisheye"]=9673,
 ["fitacyrillic"]=1139,
 ["five"]=53,
 ["fivearabic"]=1637,
 ["fivebengali"]=2539,
 ["fivecircle"]=9316,
 ["fivecircleinversesansserif"]=10126,
 ["fivedeva"]=2411,
 ["fiveeighths"]=8541,
 ["fivegujarati"]=2795,
 ["fivegurmukhi"]=2667,
 ["fivehackarabic"]=1637,
 ["fivehangzhou"]=12325,
 ["fiveideographicparen"]=12836,
 ["fiveinferior"]=8325,
 ["fivemonospace"]=65301,
 ["fiveoldstyle"]=63285,
 ["fiveparen"]=9336,
 ["fiveperiod"]=9356,
 ["fivepersian"]=1781,
 ["fiveroman"]=8564,
 ["fivesuperior"]=8309,
 ["fivethai"]=3669,
 ["fl"]=64258,
 ["florin"]=402,
 ["fmonospace"]=65350,
 ["fmsquare"]=13209,
 ["fofanthai"]=3615,
 ["fofathai"]=3613,
 ["fongmanthai"]=3663,
 ["forall"]=8704,
 ["four"]=52,
 ["fourarabic"]=1636,
 ["fourbengali"]=2538,
 ["fourcircle"]=9315,
 ["fourcircleinversesansserif"]=10125,
 ["fourdeva"]=2410,
 ["fourgujarati"]=2794,
 ["fourgurmukhi"]=2666,
 ["fourhackarabic"]=1636,
 ["fourhangzhou"]=12324,
 ["fourideographicparen"]=12835,
 ["fourinferior"]=8324,
 ["fourmonospace"]=65300,
 ["fournumeratorbengali"]=2551,
 ["fouroldstyle"]=63284,
 ["fourparen"]=9335,
 ["fourperiod"]=9355,
 ["fourpersian"]=1780,
 ["fourroman"]=8563,
 ["foursuperior"]=8308,
 ["fourteencircle"]=9325,
 ["fourteenparen"]=9345,
 ["fourteenperiod"]=9365,
 ["fourthai"]=3668,
 ["fourthtonechinese"]=715,
 ["fparen"]=9377,
 ["fraction"]=8260,
 ["franc"]=8355,
 ["g"]=103,
 ["gabengali"]=2455,
 ["gacute"]=501,
 ["gadeva"]=2327,
 ["gafarabic"]=1711,
 ["gaffinalarabic"]=64403,
 ["gafinitialarabic"]=64404,
 ["gafmedialarabic"]=64405,
 ["gagujarati"]=2711,
 ["gagurmukhi"]=2583,
 ["gahiragana"]=12364,
 ["gakatakana"]=12460,
 ["gamma"]=947,
 ["gammalatinsmall"]=611,
 ["gammasuperior"]=736,
 ["gangiacoptic"]=1003,
 ["gbopomofo"]=12557,
 ["gbreve"]=287,
 ["gcaron"]=487,
 ["gcedilla"]=291,
 ["gcircle"]=9430,
 ["gcircumflex"]=285,
 ["gcommaaccent"]=291,
 ["gdot"]=289,
 ["gdotaccent"]=289,
 ["gecyrillic"]=1075,
 ["gehiragana"]=12370,
 ["gekatakana"]=12466,
 ["geometricallyequal"]=8785,
 ["gereshaccenthebrew"]=1436,
 ["gereshhebrew"]=1523,
 ["gereshmuqdamhebrew"]=1437,
 ["germandbls"]=223,
 ["gershayimaccenthebrew"]=1438,
 ["gershayimhebrew"]=1524,
 ["getamark"]=12307,
 ["ghabengali"]=2456,
 ["ghadarmenian"]=1394,
 ["ghadeva"]=2328,
 ["ghagujarati"]=2712,
 ["ghagurmukhi"]=2584,
 ["ghainarabic"]=1594,
 ["ghainfinalarabic"]=65230,
 ["ghaininitialarabic"]=65231,
 ["ghainmedialarabic"]=65232,
 ["ghemiddlehookcyrillic"]=1173,
 ["ghestrokecyrillic"]=1171,
 ["gheupturncyrillic"]=1169,
 ["ghhadeva"]=2394,
 ["ghhagurmukhi"]=2650,
 ["ghook"]=608,
 ["ghzsquare"]=13203,
 ["gihiragana"]=12366,
 ["gikatakana"]=12462,
 ["gimarmenian"]=1379,
 ["gimel"]=1490,
 ["gimeldagesh"]=64306,
 ["gimeldageshhebrew"]=64306,
 ["gimelhebrew"]=1490,
 ["gjecyrillic"]=1107,
 ["glottalinvertedstroke"]=446,
 ["glottalstop"]=660,
 ["glottalstopinverted"]=662,
 ["glottalstopmod"]=704,
 ["glottalstopreversed"]=661,
 ["glottalstopreversedmod"]=705,
 ["glottalstopreversedsuperior"]=740,
 ["glottalstopstroke"]=673,
 ["glottalstopstrokereversed"]=674,
 ["gmacron"]=7713,
 ["gmonospace"]=65351,
 ["gohiragana"]=12372,
 ["gokatakana"]=12468,
 ["gparen"]=9378,
 ["gpasquare"]=13228,
 ["gradient"]=8711,
 ["grave"]=96,
 ["gravebelowcmb"]=790,
 ["gravecmb"]=768,
 ["gravecomb"]=768,
 ["gravedeva"]=2387,
 ["gravelowmod"]=718,
 ["gravemonospace"]=65344,
 ["gravetonecmb"]=832,
 ["greater"]=62,
 ["greaterequal"]=8805,
 ["greaterequalorless"]=8923,
 ["greatermonospace"]=65310,
 ["greaterorequivalent"]=8819,
 ["greaterorless"]=8823,
 ["greateroverequal"]=8807,
 ["greatersmall"]=65125,
 ["gscript"]=609,
 ["gstroke"]=485,
 ["guhiragana"]=12368,
 ["guillemotleft"]=171,
 ["guillemotright"]=187,
 ["guilsinglleft"]=8249,
 ["guilsinglright"]=8250,
 ["gukatakana"]=12464,
 ["guramusquare"]=13080,
 ["gysquare"]=13257,
 ["h"]=104,
 ["haabkhasiancyrillic"]=1193,
 ["haaltonearabic"]=1729,
 ["habengali"]=2489,
 ["hadescendercyrillic"]=1203,
 ["hadeva"]=2361,
 ["hagujarati"]=2745,
 ["hagurmukhi"]=2617,
 ["haharabic"]=1581,
 ["hahfinalarabic"]=65186,
 ["hahinitialarabic"]=65187,
 ["hahiragana"]=12399,
 ["hahmedialarabic"]=65188,
 ["haitusquare"]=13098,
 ["hakatakana"]=12495,
 ["hakatakanahalfwidth"]=65418,
 ["halantgurmukhi"]=2637,
 ["hamzaarabic"]=1569,
 ["hamzadammaarabic"]=1569,
 ["hamzadammatanarabic"]=1569,
 ["hamzafathaarabic"]=1569,
 ["hamzafathatanarabic"]=1569,
 ["hamzalowarabic"]=1569,
 ["hamzalowkasraarabic"]=1569,
 ["hamzalowkasratanarabic"]=1569,
 ["hamzasukunarabic"]=1569,
 ["hangulfiller"]=12644,
 ["hardsigncyrillic"]=1098,
 ["harpoonleftbarbup"]=8636,
 ["harpoonrightbarbup"]=8640,
 ["hasquare"]=13258,
 ["hatafpatah"]=1458,
 ["hatafpatah16"]=1458,
 ["hatafpatah23"]=1458,
 ["hatafpatah2f"]=1458,
 ["hatafpatahhebrew"]=1458,
 ["hatafpatahnarrowhebrew"]=1458,
 ["hatafpatahquarterhebrew"]=1458,
 ["hatafpatahwidehebrew"]=1458,
 ["hatafqamats"]=1459,
 ["hatafqamats1b"]=1459,
 ["hatafqamats28"]=1459,
 ["hatafqamats34"]=1459,
 ["hatafqamatshebrew"]=1459,
 ["hatafqamatsnarrowhebrew"]=1459,
 ["hatafqamatsquarterhebrew"]=1459,
 ["hatafqamatswidehebrew"]=1459,
 ["hatafsegol"]=1457,
 ["hatafsegol17"]=1457,
 ["hatafsegol24"]=1457,
 ["hatafsegol30"]=1457,
 ["hatafsegolhebrew"]=1457,
 ["hatafsegolnarrowhebrew"]=1457,
 ["hatafsegolquarterhebrew"]=1457,
 ["hatafsegolwidehebrew"]=1457,
 ["hbar"]=295,
 ["hbopomofo"]=12559,
 ["hbrevebelow"]=7723,
 ["hcedilla"]=7721,
 ["hcircle"]=9431,
 ["hcircumflex"]=293,
 ["hdieresis"]=7719,
 ["hdotaccent"]=7715,
 ["hdotbelow"]=7717,
 ["he"]=1492,
 ["heart"]=9829,
 ["heartsuitblack"]=9829,
 ["heartsuitwhite"]=9825,
 ["hedagesh"]=64308,
 ["hedageshhebrew"]=64308,
 ["hehaltonearabic"]=1729,
 ["heharabic"]=1607,
 ["hehebrew"]=1492,
 ["hehfinalaltonearabic"]=64423,
 ["hehfinalalttwoarabic"]=65258,
 ["hehfinalarabic"]=65258,
 ["hehhamzaabovefinalarabic"]=64421,
 ["hehhamzaaboveisolatedarabic"]=64420,
 ["hehinitialaltonearabic"]=64424,
 ["hehinitialarabic"]=65259,
 ["hehiragana"]=12408,
 ["hehmedialaltonearabic"]=64425,
 ["hehmedialarabic"]=65260,
 ["heiseierasquare"]=13179,
 ["hekatakana"]=12504,
 ["hekatakanahalfwidth"]=65421,
 ["hekutaarusquare"]=13110,
 ["henghook"]=615,
 ["herutusquare"]=13113,
 ["het"]=1495,
 ["hethebrew"]=1495,
 ["hhook"]=614,
 ["hhooksuperior"]=689,
 ["hieuhacirclekorean"]=12923,
 ["hieuhaparenkorean"]=12827,
 ["hieuhcirclekorean"]=12909,
 ["hieuhkorean"]=12622,
 ["hieuhparenkorean"]=12813,
 ["hihiragana"]=12402,
 ["hikatakana"]=12498,
 ["hikatakanahalfwidth"]=65419,
 ["hiriq"]=1460,
 ["hiriq14"]=1460,
 ["hiriq21"]=1460,
 ["hiriq2d"]=1460,
 ["hiriqhebrew"]=1460,
 ["hiriqnarrowhebrew"]=1460,
 ["hiriqquarterhebrew"]=1460,
 ["hiriqwidehebrew"]=1460,
 ["hlinebelow"]=7830,
 ["hmonospace"]=65352,
 ["hoarmenian"]=1392,
 ["hohipthai"]=3627,
 ["hohiragana"]=12411,
 ["hokatakana"]=12507,
 ["hokatakanahalfwidth"]=65422,
 ["holam"]=1465,
 ["holam19"]=1465,
 ["holam26"]=1465,
 ["holam32"]=1465,
 ["holamhebrew"]=1465,
 ["holamnarrowhebrew"]=1465,
 ["holamquarterhebrew"]=1465,
 ["holamwidehebrew"]=1465,
 ["honokhukthai"]=3630,
 ["hookabovecomb"]=777,
 ["hookcmb"]=777,
 ["hookpalatalizedbelowcmb"]=801,
 ["hookretroflexbelowcmb"]=802,
 ["hoonsquare"]=13122,
 ["horicoptic"]=1001,
 ["horizontalbar"]=8213,
 ["horncmb"]=795,
 ["hotsprings"]=9832,
 ["house"]=8962,
 ["hparen"]=9379,
 ["hsuperior"]=688,
 ["hturned"]=613,
 ["huhiragana"]=12405,
 ["huiitosquare"]=13107,
 ["hukatakana"]=12501,
 ["hukatakanahalfwidth"]=65420,
 ["hungarumlaut"]=733,
 ["hungarumlautcmb"]=779,
 ["hv"]=405,
 ["hyphen"]=45,
 ["hypheninferior"]=63205,
 ["hyphenmonospace"]=65293,
 ["hyphensmall"]=65123,
 ["hyphensuperior"]=63206,
 ["hyphentwo"]=8208,
 ["i"]=105,
 ["iacute"]=237,
 ["iacyrillic"]=1103,
 ["ibengali"]=2439,
 ["ibopomofo"]=12583,
 ["ibreve"]=301,
 ["icaron"]=464,
 ["icircle"]=9432,
 ["icircumflex"]=238,
 ["icyrillic"]=1110,
 ["idblgrave"]=521,
 ["ideographearthcircle"]=12943,
 ["ideographfirecircle"]=12939,
 ["ideographicallianceparen"]=12863,
 ["ideographiccallparen"]=12858,
 ["ideographiccentrecircle"]=12965,
 ["ideographicclose"]=12294,
 ["ideographiccomma"]=12289,
 ["ideographiccommaleft"]=65380,
 ["ideographiccongratulationparen"]=12855,
 ["ideographiccorrectcircle"]=12963,
 ["ideographicearthparen"]=12847,
 ["ideographicenterpriseparen"]=12861,
 ["ideographicexcellentcircle"]=12957,
 ["ideographicfestivalparen"]=12864,
 ["ideographicfinancialcircle"]=12950,
 ["ideographicfinancialparen"]=12854,
 ["ideographicfireparen"]=12843,
 ["ideographichaveparen"]=12850,
 ["ideographichighcircle"]=12964,
 ["ideographiciterationmark"]=12293,
 ["ideographiclaborcircle"]=12952,
 ["ideographiclaborparen"]=12856,
 ["ideographicleftcircle"]=12967,
 ["ideographiclowcircle"]=12966,
 ["ideographicmedicinecircle"]=12969,
 ["ideographicmetalparen"]=12846,
 ["ideographicmoonparen"]=12842,
 ["ideographicnameparen"]=12852,
 ["ideographicperiod"]=12290,
 ["ideographicprintcircle"]=12958,
 ["ideographicreachparen"]=12867,
 ["ideographicrepresentparen"]=12857,
 ["ideographicresourceparen"]=12862,
 ["ideographicrightcircle"]=12968,
 ["ideographicsecretcircle"]=12953,
 ["ideographicselfparen"]=12866,
 ["ideographicsocietyparen"]=12851,
 ["ideographicspace"]=12288,
 ["ideographicspecialparen"]=12853,
 ["ideographicstockparen"]=12849,
 ["ideographicstudyparen"]=12859,
 ["ideographicsunparen"]=12848,
 ["ideographicsuperviseparen"]=12860,
 ["ideographicwaterparen"]=12844,
 ["ideographicwoodparen"]=12845,
 ["ideographiczero"]=12295,
 ["ideographmetalcircle"]=12942,
 ["ideographmooncircle"]=12938,
 ["ideographnamecircle"]=12948,
 ["ideographsuncircle"]=12944,
 ["ideographwatercircle"]=12940,
 ["ideographwoodcircle"]=12941,
 ["ideva"]=2311,
 ["idieresis"]=239,
 ["idieresisacute"]=7727,
 ["idieresiscyrillic"]=1253,
 ["idotbelow"]=7883,
 ["iebrevecyrillic"]=1239,
 ["iecyrillic"]=1077,
 ["ieungacirclekorean"]=12917,
 ["ieungaparenkorean"]=12821,
 ["ieungcirclekorean"]=12903,
 ["ieungkorean"]=12615,
 ["ieungparenkorean"]=12807,
 ["igrave"]=236,
 ["igujarati"]=2695,
 ["igurmukhi"]=2567,
 ["ihiragana"]=12356,
 ["ihookabove"]=7881,
 ["iibengali"]=2440,
 ["iicyrillic"]=1080,
 ["iideva"]=2312,
 ["iigujarati"]=2696,
 ["iigurmukhi"]=2568,
 ["iimatragurmukhi"]=2624,
 ["iinvertedbreve"]=523,
 ["iishortcyrillic"]=1081,
 ["iivowelsignbengali"]=2496,
 ["iivowelsigndeva"]=2368,
 ["iivowelsigngujarati"]=2752,
 ["ij"]=307,
 ["ikatakana"]=12452,
 ["ikatakanahalfwidth"]=65394,
 ["ikorean"]=12643,
 ["ilde"]=732,
 ["iluyhebrew"]=1452,
 ["imacron"]=299,
 ["imacroncyrillic"]=1251,
 ["imageorapproximatelyequal"]=8787,
 ["imatragurmukhi"]=2623,
 ["imonospace"]=65353,
 ["increment"]=8710,
 ["infinity"]=8734,
 ["iniarmenian"]=1387,
 ["integral"]=8747,
 ["integralbottom"]=8993,
 ["integralbt"]=8993,
 ["integralex"]=63733,
 ["integraltop"]=8992,
 ["integraltp"]=8992,
 ["intersection"]=8745,
 ["intisquare"]=13061,
 ["invbullet"]=9688,
 ["invcircle"]=9689,
 ["invsmileface"]=9787,
 ["iocyrillic"]=1105,
 ["iogonek"]=303,
 ["iota"]=953,
 ["iotadieresis"]=970,
 ["iotadieresistonos"]=912,
 ["iotalatin"]=617,
 ["iotatonos"]=943,
 ["iparen"]=9380,
 ["irigurmukhi"]=2674,
 ["ismallhiragana"]=12355,
 ["ismallkatakana"]=12451,
 ["ismallkatakanahalfwidth"]=65384,
 ["issharbengali"]=2554,
 ["istroke"]=616,
 ["isuperior"]=63213,
 ["iterationhiragana"]=12445,
 ["iterationkatakana"]=12541,
 ["itilde"]=297,
 ["itildebelow"]=7725,
 ["iubopomofo"]=12585,
 ["iucyrillic"]=1102,
 ["ivowelsignbengali"]=2495,
 ["ivowelsigndeva"]=2367,
 ["ivowelsigngujarati"]=2751,
 ["izhitsacyrillic"]=1141,
 ["izhitsadblgravecyrillic"]=1143,
 ["j"]=106,
 ["jaarmenian"]=1393,
 ["jabengali"]=2460,
 ["jadeva"]=2332,
 ["jagujarati"]=2716,
 ["jagurmukhi"]=2588,
 ["jbopomofo"]=12560,
 ["jcaron"]=496,
 ["jcircle"]=9433,
 ["jcircumflex"]=309,
 ["jcrossedtail"]=669,
 ["jdotlessstroke"]=607,
 ["jecyrillic"]=1112,
 ["jeemarabic"]=1580,
 ["jeemfinalarabic"]=65182,
 ["jeeminitialarabic"]=65183,
 ["jeemmedialarabic"]=65184,
 ["jeharabic"]=1688,
 ["jehfinalarabic"]=64395,
 ["jhabengali"]=2461,
 ["jhadeva"]=2333,
 ["jhagujarati"]=2717,
 ["jhagurmukhi"]=2589,
 ["jheharmenian"]=1403,
 ["jis"]=12292,
 ["jmonospace"]=65354,
 ["jparen"]=9381,
 ["jsuperior"]=690,
 ["k"]=107,
 ["kabashkircyrillic"]=1185,
 ["kabengali"]=2453,
 ["kacute"]=7729,
 ["kacyrillic"]=1082,
 ["kadescendercyrillic"]=1179,
 ["kadeva"]=2325,
 ["kaf"]=1499,
 ["kafarabic"]=1603,
 ["kafdagesh"]=64315,
 ["kafdageshhebrew"]=64315,
 ["kaffinalarabic"]=65242,
 ["kafhebrew"]=1499,
 ["kafinitialarabic"]=65243,
 ["kafmedialarabic"]=65244,
 ["kafrafehebrew"]=64333,
 ["kagujarati"]=2709,
 ["kagurmukhi"]=2581,
 ["kahiragana"]=12363,
 ["kahookcyrillic"]=1220,
 ["kakatakana"]=12459,
 ["kakatakanahalfwidth"]=65398,
 ["kappa"]=954,
 ["kappasymbolgreek"]=1008,
 ["kapyeounmieumkorean"]=12657,
 ["kapyeounphieuphkorean"]=12676,
 ["kapyeounpieupkorean"]=12664,
 ["kapyeounssangpieupkorean"]=12665,
 ["karoriisquare"]=13069,
 ["kashidaautoarabic"]=1600,
 ["kashidaautonosidebearingarabic"]=1600,
 ["kasmallkatakana"]=12533,
 ["kasquare"]=13188,
 ["kasraarabic"]=1616,
 ["kasratanarabic"]=1613,
 ["kastrokecyrillic"]=1183,
 ["katahiraprolongmarkhalfwidth"]=65392,
 ["kaverticalstrokecyrillic"]=1181,
 ["kbopomofo"]=12558,
 ["kcalsquare"]=13193,
 ["kcaron"]=489,
 ["kcedilla"]=311,
 ["kcircle"]=9434,
 ["kcommaaccent"]=311,
 ["kdotbelow"]=7731,
 ["keharmenian"]=1412,
 ["kehiragana"]=12369,
 ["kekatakana"]=12465,
 ["kekatakanahalfwidth"]=65401,
 ["kenarmenian"]=1391,
 ["kesmallkatakana"]=12534,
 ["kgreenlandic"]=312,
 ["khabengali"]=2454,
 ["khacyrillic"]=1093,
 ["khadeva"]=2326,
 ["khagujarati"]=2710,
 ["khagurmukhi"]=2582,
 ["khaharabic"]=1582,
 ["khahfinalarabic"]=65190,
 ["khahinitialarabic"]=65191,
 ["khahmedialarabic"]=65192,
 ["kheicoptic"]=999,
 ["khhadeva"]=2393,
 ["khhagurmukhi"]=2649,
 ["khieukhacirclekorean"]=12920,
 ["khieukhaparenkorean"]=12824,
 ["khieukhcirclekorean"]=12906,
 ["khieukhkorean"]=12619,
 ["khieukhparenkorean"]=12810,
 ["khokhaithai"]=3586,
 ["khokhonthai"]=3589,
 ["khokhuatthai"]=3587,
 ["khokhwaithai"]=3588,
 ["khomutthai"]=3675,
 ["khook"]=409,
 ["khorakhangthai"]=3590,
 ["khzsquare"]=13201,
 ["kihiragana"]=12365,
 ["kikatakana"]=12461,
 ["kikatakanahalfwidth"]=65399,
 ["kiroguramusquare"]=13077,
 ["kiromeetorusquare"]=13078,
 ["kirosquare"]=13076,
 ["kiyeokacirclekorean"]=12910,
 ["kiyeokaparenkorean"]=12814,
 ["kiyeokcirclekorean"]=12896,
 ["kiyeokkorean"]=12593,
 ["kiyeokparenkorean"]=12800,
 ["kiyeoksioskorean"]=12595,
 ["kjecyrillic"]=1116,
 ["klinebelow"]=7733,
 ["klsquare"]=13208,
 ["kmcubedsquare"]=13222,
 ["kmonospace"]=65355,
 ["kmsquaredsquare"]=13218,
 ["kohiragana"]=12371,
 ["kohmsquare"]=13248,
 ["kokaithai"]=3585,
 ["kokatakana"]=12467,
 ["kokatakanahalfwidth"]=65402,
 ["kooposquare"]=13086,
 ["koppacyrillic"]=1153,
 ["koreanstandardsymbol"]=12927,
 ["koroniscmb"]=835,
 ["kparen"]=9382,
 ["kpasquare"]=13226,
 ["ksicyrillic"]=1135,
 ["ktsquare"]=13263,
 ["kturned"]=670,
 ["kuhiragana"]=12367,
 ["kukatakana"]=12463,
 ["kukatakanahalfwidth"]=65400,
 ["kvsquare"]=13240,
 ["kwsquare"]=13246,
 ["l"]=108,
 ["labengali"]=2482,
 ["lacute"]=314,
 ["ladeva"]=2354,
 ["lagujarati"]=2738,
 ["lagurmukhi"]=2610,
 ["lakkhangyaothai"]=3653,
 ["lamaleffinalarabic"]=65276,
 ["lamalefhamzaabovefinalarabic"]=65272,
 ["lamalefhamzaaboveisolatedarabic"]=65271,
 ["lamalefhamzabelowfinalarabic"]=65274,
 ["lamalefhamzabelowisolatedarabic"]=65273,
 ["lamalefisolatedarabic"]=65275,
 ["lamalefmaddaabovefinalarabic"]=65270,
 ["lamalefmaddaaboveisolatedarabic"]=65269,
 ["lamarabic"]=1604,
 ["lambda"]=955,
 ["lambdastroke"]=411,
 ["lamed"]=1500,
 ["lameddagesh"]=64316,
 ["lameddageshhebrew"]=64316,
 ["lamedhebrew"]=1500,
 ["lamedholam"]=1500,
 ["lamedholamdagesh"]=1500,
 ["lamedholamdageshhebrew"]=1500,
 ["lamedholamhebrew"]=1500,
 ["lamfinalarabic"]=65246,
 ["lamhahinitialarabic"]=64714,
 ["laminitialarabic"]=65247,
 ["lamjeeminitialarabic"]=64713,
 ["lamkhahinitialarabic"]=64715,
 ["lamlamhehisolatedarabic"]=65010,
 ["lammedialarabic"]=65248,
 ["lammeemhahinitialarabic"]=64904,
 ["lammeeminitialarabic"]=64716,
 ["lammeemjeeminitialarabic"]=65247,
 ["lammeemkhahinitialarabic"]=65247,
 ["largecircle"]=9711,
 ["lbar"]=410,
 ["lbelt"]=620,
 ["lbopomofo"]=12556,
 ["lcaron"]=318,
 ["lcedilla"]=316,
 ["lcircle"]=9435,
 ["lcircumflexbelow"]=7741,
 ["lcommaaccent"]=316,
 ["ldot"]=320,
 ["ldotaccent"]=320,
 ["ldotbelow"]=7735,
 ["ldotbelowmacron"]=7737,
 ["leftangleabovecmb"]=794,
 ["lefttackbelowcmb"]=792,
 ["less"]=60,
 ["lessequal"]=8804,
 ["lessequalorgreater"]=8922,
 ["lessmonospace"]=65308,
 ["lessorequivalent"]=8818,
 ["lessorgreater"]=8822,
 ["lessoverequal"]=8806,
 ["lesssmall"]=65124,
 ["lezh"]=622,
 ["lfblock"]=9612,
 ["lhookretroflex"]=621,
 ["lira"]=8356,
 ["liwnarmenian"]=1388,
 ["lj"]=457,
 ["ljecyrillic"]=1113,
 ["ll"]=63168,
 ["lladeva"]=2355,
 ["llagujarati"]=2739,
 ["llinebelow"]=7739,
 ["llladeva"]=2356,
 ["llvocalicbengali"]=2529,
 ["llvocalicdeva"]=2401,
 ["llvocalicvowelsignbengali"]=2531,
 ["llvocalicvowelsigndeva"]=2403,
 ["lmiddletilde"]=619,
 ["lmonospace"]=65356,
 ["lmsquare"]=13264,
 ["lochulathai"]=3628,
 ["logicaland"]=8743,
 ["logicalnot"]=172,
 ["logicalnotreversed"]=8976,
 ["logicalor"]=8744,
 ["lolingthai"]=3621,
 ["longs"]=383,
 ["lowlinecenterline"]=65102,
 ["lowlinecmb"]=818,
 ["lowlinedashed"]=65101,
 ["lozenge"]=9674,
 ["lparen"]=9383,
 ["lslash"]=322,
 ["lsquare"]=8467,
 ["lsuperior"]=63214,
 ["ltshade"]=9617,
 ["luthai"]=3622,
 ["lvocalicbengali"]=2444,
 ["lvocalicdeva"]=2316,
 ["lvocalicvowelsignbengali"]=2530,
 ["lvocalicvowelsigndeva"]=2402,
 ["lxsquare"]=13267,
 ["m"]=109,
 ["mabengali"]=2478,
 ["macron"]=175,
 ["macronbelowcmb"]=817,
 ["macroncmb"]=772,
 ["macronlowmod"]=717,
 ["macronmonospace"]=65507,
 ["macute"]=7743,
 ["madeva"]=2350,
 ["magujarati"]=2734,
 ["magurmukhi"]=2606,
 ["mahapakhhebrew"]=1444,
 ["mahapakhlefthebrew"]=1444,
 ["mahiragana"]=12414,
 ["maichattawalowleftthai"]=63637,
 ["maichattawalowrightthai"]=63636,
 ["maichattawathai"]=3659,
 ["maichattawaupperleftthai"]=63635,
 ["maieklowleftthai"]=63628,
 ["maieklowrightthai"]=63627,
 ["maiekthai"]=3656,
 ["maiekupperleftthai"]=63626,
 ["maihanakatleftthai"]=63620,
 ["maihanakatthai"]=3633,
 ["maitaikhuleftthai"]=63625,
 ["maitaikhuthai"]=3655,
 ["maitholowleftthai"]=63631,
 ["maitholowrightthai"]=63630,
 ["maithothai"]=3657,
 ["maithoupperleftthai"]=63629,
 ["maitrilowleftthai"]=63634,
 ["maitrilowrightthai"]=63633,
 ["maitrithai"]=3658,
 ["maitriupperleftthai"]=63632,
 ["maiyamokthai"]=3654,
 ["makatakana"]=12510,
 ["makatakanahalfwidth"]=65423,
 ["male"]=9794,
 ["mansyonsquare"]=13127,
 ["maqafhebrew"]=1470,
 ["mars"]=9794,
 ["masoracirclehebrew"]=1455,
 ["masquare"]=13187,
 ["mbopomofo"]=12551,
 ["mbsquare"]=13268,
 ["mcircle"]=9436,
 ["mcubedsquare"]=13221,
 ["mdotaccent"]=7745,
 ["mdotbelow"]=7747,
 ["meemarabic"]=1605,
 ["meemfinalarabic"]=65250,
 ["meeminitialarabic"]=65251,
 ["meemmedialarabic"]=65252,
 ["meemmeeminitialarabic"]=64721,
 ["meemmeemisolatedarabic"]=64584,
 ["meetorusquare"]=13133,
 ["mehiragana"]=12417,
 ["meizierasquare"]=13182,
 ["mekatakana"]=12513,
 ["mekatakanahalfwidth"]=65426,
 ["mem"]=1502,
 ["memdagesh"]=64318,
 ["memdageshhebrew"]=64318,
 ["memhebrew"]=1502,
 ["menarmenian"]=1396,
 ["merkhahebrew"]=1445,
 ["merkhakefulahebrew"]=1446,
 ["merkhakefulalefthebrew"]=1446,
 ["merkhalefthebrew"]=1445,
 ["mhook"]=625,
 ["mhzsquare"]=13202,
 ["middledotkatakanahalfwidth"]=65381,
 ["middot"]=183,
 ["mieumacirclekorean"]=12914,
 ["mieumaparenkorean"]=12818,
 ["mieumcirclekorean"]=12900,
 ["mieumkorean"]=12609,
 ["mieumpansioskorean"]=12656,
 ["mieumparenkorean"]=12804,
 ["mieumpieupkorean"]=12654,
 ["mieumsioskorean"]=12655,
 ["mihiragana"]=12415,
 ["mikatakana"]=12511,
 ["mikatakanahalfwidth"]=65424,
 ["minus"]=8722,
 ["minusbelowcmb"]=800,
 ["minuscircle"]=8854,
 ["minusmod"]=727,
 ["minusplus"]=8723,
 ["minute"]=8242,
 ["miribaarusquare"]=13130,
 ["mirisquare"]=13129,
 ["mlonglegturned"]=624,
 ["mlsquare"]=13206,
 ["mmcubedsquare"]=13219,
 ["mmonospace"]=65357,
 ["mmsquaredsquare"]=13215,
 ["mohiragana"]=12418,
 ["mohmsquare"]=13249,
 ["mokatakana"]=12514,
 ["mokatakanahalfwidth"]=65427,
 ["molsquare"]=13270,
 ["momathai"]=3617,
 ["moverssquare"]=13223,
 ["moverssquaredsquare"]=13224,
 ["mparen"]=9384,
 ["mpasquare"]=13227,
 ["mssquare"]=13235,
 ["msuperior"]=63215,
 ["mturned"]=623,
 ["mu"]=181,
 ["mu1"]=181,
 ["muasquare"]=13186,
 ["muchgreater"]=8811,
 ["muchless"]=8810,
 ["mufsquare"]=13196,
 ["mugreek"]=956,
 ["mugsquare"]=13197,
 ["muhiragana"]=12416,
 ["mukatakana"]=12512,
 ["mukatakanahalfwidth"]=65425,
 ["mulsquare"]=13205,
 ["multiply"]=215,
 ["mumsquare"]=13211,
 ["munahhebrew"]=1443,
 ["munahlefthebrew"]=1443,
 ["musicalnote"]=9834,
 ["musicalnotedbl"]=9835,
 ["musicflatsign"]=9837,
 ["musicsharpsign"]=9839,
 ["mussquare"]=13234,
 ["muvsquare"]=13238,
 ["muwsquare"]=13244,
 ["mvmegasquare"]=13241,
 ["mvsquare"]=13239,
 ["mwmegasquare"]=13247,
 ["mwsquare"]=13245,
 ["n"]=110,
 ["nabengali"]=2472,
 ["nabla"]=8711,
 ["nacute"]=324,
 ["nadeva"]=2344,
 ["nagujarati"]=2728,
 ["nagurmukhi"]=2600,
 ["nahiragana"]=12394,
 ["nakatakana"]=12490,
 ["nakatakanahalfwidth"]=65413,
 ["napostrophe"]=329,
 ["nasquare"]=13185,
 ["nbopomofo"]=12555,
 ["nbspace"]=160,
 ["ncaron"]=328,
 ["ncedilla"]=326,
 ["ncircle"]=9437,
 ["ncircumflexbelow"]=7755,
 ["ncommaaccent"]=326,
 ["ndotaccent"]=7749,
 ["ndotbelow"]=7751,
 ["nehiragana"]=12397,
 ["nekatakana"]=12493,
 ["nekatakanahalfwidth"]=65416,
 ["newsheqelsign"]=8362,
 ["nfsquare"]=13195,
 ["ngabengali"]=2457,
 ["ngadeva"]=2329,
 ["ngagujarati"]=2713,
 ["ngagurmukhi"]=2585,
 ["ngonguthai"]=3591,
 ["nhiragana"]=12435,
 ["nhookleft"]=626,
 ["nhookretroflex"]=627,
 ["nieunacirclekorean"]=12911,
 ["nieunaparenkorean"]=12815,
 ["nieuncieuckorean"]=12597,
 ["nieuncirclekorean"]=12897,
 ["nieunhieuhkorean"]=12598,
 ["nieunkorean"]=12596,
 ["nieunpansioskorean"]=12648,
 ["nieunparenkorean"]=12801,
 ["nieunsioskorean"]=12647,
 ["nieuntikeutkorean"]=12646,
 ["nihiragana"]=12395,
 ["nikatakana"]=12491,
 ["nikatakanahalfwidth"]=65414,
 ["nikhahitleftthai"]=63641,
 ["nikhahitthai"]=3661,
 ["nine"]=57,
 ["ninearabic"]=1641,
 ["ninebengali"]=2543,
 ["ninecircle"]=9320,
 ["ninecircleinversesansserif"]=10130,
 ["ninedeva"]=2415,
 ["ninegujarati"]=2799,
 ["ninegurmukhi"]=2671,
 ["ninehackarabic"]=1641,
 ["ninehangzhou"]=12329,
 ["nineideographicparen"]=12840,
 ["nineinferior"]=8329,
 ["ninemonospace"]=65305,
 ["nineoldstyle"]=63289,
 ["nineparen"]=9340,
 ["nineperiod"]=9360,
 ["ninepersian"]=1785,
 ["nineroman"]=8568,
 ["ninesuperior"]=8313,
 ["nineteencircle"]=9330,
 ["nineteenparen"]=9350,
 ["nineteenperiod"]=9370,
 ["ninethai"]=3673,
 ["nj"]=460,
 ["njecyrillic"]=1114,
 ["nkatakana"]=12531,
 ["nkatakanahalfwidth"]=65437,
 ["nlegrightlong"]=414,
 ["nlinebelow"]=7753,
 ["nmonospace"]=65358,
 ["nmsquare"]=13210,
 ["nnabengali"]=2467,
 ["nnadeva"]=2339,
 ["nnagujarati"]=2723,
 ["nnagurmukhi"]=2595,
 ["nnnadeva"]=2345,
 ["nohiragana"]=12398,
 ["nokatakana"]=12494,
 ["nokatakanahalfwidth"]=65417,
 ["nonbreakingspace"]=160,
 ["nonenthai"]=3603,
 ["nonuthai"]=3609,
 ["noonarabic"]=1606,
 ["noonfinalarabic"]=65254,
 ["noonghunnaarabic"]=1722,
 ["noonghunnafinalarabic"]=64415,
 ["noonhehinitialarabic"]=65255,
 ["nooninitialarabic"]=65255,
 ["noonjeeminitialarabic"]=64722,
 ["noonjeemisolatedarabic"]=64587,
 ["noonmedialarabic"]=65256,
 ["noonmeeminitialarabic"]=64725,
 ["noonmeemisolatedarabic"]=64590,
 ["noonnoonfinalarabic"]=64653,
 ["notcontains"]=8716,
 ["notelement"]=8713,
 ["notelementof"]=8713,
 ["notequal"]=8800,
 ["notgreater"]=8815,
 ["notgreaternorequal"]=8817,
 ["notgreaternorless"]=8825,
 ["notidentical"]=8802,
 ["notless"]=8814,
 ["notlessnorequal"]=8816,
 ["notparallel"]=8742,
 ["notprecedes"]=8832,
 ["notsubset"]=8836,
 ["notsucceeds"]=8833,
 ["notsuperset"]=8837,
 ["nowarmenian"]=1398,
 ["nparen"]=9385,
 ["nssquare"]=13233,
 ["nsuperior"]=8319,
 ["ntilde"]=241,
 ["nu"]=957,
 ["nuhiragana"]=12396,
 ["nukatakana"]=12492,
 ["nukatakanahalfwidth"]=65415,
 ["nuktabengali"]=2492,
 ["nuktadeva"]=2364,
 ["nuktagujarati"]=2748,
 ["nuktagurmukhi"]=2620,
 ["numbersign"]=35,
 ["numbersignmonospace"]=65283,
 ["numbersignsmall"]=65119,
 ["numeralsigngreek"]=884,
 ["numeralsignlowergreek"]=885,
 ["numero"]=8470,
 ["nun"]=1504,
 ["nundagesh"]=64320,
 ["nundageshhebrew"]=64320,
 ["nunhebrew"]=1504,
 ["nvsquare"]=13237,
 ["nwsquare"]=13243,
 ["nyabengali"]=2462,
 ["nyadeva"]=2334,
 ["nyagujarati"]=2718,
 ["nyagurmukhi"]=2590,
 ["o"]=111,
 ["oacute"]=243,
 ["oangthai"]=3629,
 ["obarred"]=629,
 ["obarredcyrillic"]=1257,
 ["obarreddieresiscyrillic"]=1259,
 ["obengali"]=2451,
 ["obopomofo"]=12571,
 ["obreve"]=335,
 ["ocandradeva"]=2321,
 ["ocandragujarati"]=2705,
 ["ocandravowelsigndeva"]=2377,
 ["ocandravowelsigngujarati"]=2761,
 ["ocaron"]=466,
 ["ocircle"]=9438,
 ["ocircumflex"]=244,
 ["ocircumflexacute"]=7889,
 ["ocircumflexdotbelow"]=7897,
 ["ocircumflexgrave"]=7891,
 ["ocircumflexhookabove"]=7893,
 ["ocircumflextilde"]=7895,
 ["ocyrillic"]=1086,
 ["odblacute"]=337,
 ["odblgrave"]=525,
 ["odeva"]=2323,
 ["odieresis"]=246,
 ["odieresiscyrillic"]=1255,
 ["odotbelow"]=7885,
 ["oe"]=339,
 ["oekorean"]=12634,
 ["ogonek"]=731,
 ["ogonekcmb"]=808,
 ["ograve"]=242,
 ["ogujarati"]=2707,
 ["oharmenian"]=1413,
 ["ohiragana"]=12362,
 ["ohookabove"]=7887,
 ["ohorn"]=417,
 ["ohornacute"]=7899,
 ["ohorndotbelow"]=7907,
 ["ohorngrave"]=7901,
 ["ohornhookabove"]=7903,
 ["ohorntilde"]=7905,
 ["ohungarumlaut"]=337,
 ["oi"]=419,
 ["oinvertedbreve"]=527,
 ["okatakana"]=12458,
 ["okatakanahalfwidth"]=65397,
 ["okorean"]=12631,
 ["olehebrew"]=1451,
 ["omacron"]=333,
 ["omacronacute"]=7763,
 ["omacrongrave"]=7761,
 ["omdeva"]=2384,
 ["omega"]=969,
 ["omega1"]=982,
 ["omegacyrillic"]=1121,
 ["omegalatinclosed"]=631,
 ["omegaroundcyrillic"]=1147,
 ["omegatitlocyrillic"]=1149,
 ["omegatonos"]=974,
 ["omgujarati"]=2768,
 ["omicron"]=959,
 ["omicrontonos"]=972,
 ["omonospace"]=65359,
 ["one"]=49,
 ["onearabic"]=1633,
 ["onebengali"]=2535,
 ["onecircle"]=9312,
 ["onecircleinversesansserif"]=10122,
 ["onedeva"]=2407,
 ["onedotenleader"]=8228,
 ["oneeighth"]=8539,
 ["onefitted"]=63196,
 ["onegujarati"]=2791,
 ["onegurmukhi"]=2663,
 ["onehackarabic"]=1633,
 ["onehalf"]=189,
 ["onehangzhou"]=12321,
 ["oneideographicparen"]=12832,
 ["oneinferior"]=8321,
 ["onemonospace"]=65297,
 ["onenumeratorbengali"]=2548,
 ["oneoldstyle"]=63281,
 ["oneparen"]=9332,
 ["oneperiod"]=9352,
 ["onepersian"]=1777,
 ["onequarter"]=188,
 ["oneroman"]=8560,
 ["onesuperior"]=185,
 ["onethai"]=3665,
 ["onethird"]=8531,
 ["oogonek"]=491,
 ["oogonekmacron"]=493,
 ["oogurmukhi"]=2579,
 ["oomatragurmukhi"]=2635,
 ["oopen"]=596,
 ["oparen"]=9386,
 ["openbullet"]=9702,
 ["option"]=8997,
 ["ordfeminine"]=170,
 ["ordmasculine"]=186,
 ["orthogonal"]=8735,
 ["oshortdeva"]=2322,
 ["oshortvowelsigndeva"]=2378,
 ["oslash"]=248,
 ["oslashacute"]=511,
 ["osmallhiragana"]=12361,
 ["osmallkatakana"]=12457,
 ["osmallkatakanahalfwidth"]=65387,
 ["ostrokeacute"]=511,
 ["osuperior"]=63216,
 ["otcyrillic"]=1151,
 ["otilde"]=245,
 ["otildeacute"]=7757,
 ["otildedieresis"]=7759,
 ["oubopomofo"]=12577,
 ["overline"]=8254,
 ["overlinecenterline"]=65098,
 ["overlinecmb"]=773,
 ["overlinedashed"]=65097,
 ["overlinedblwavy"]=65100,
 ["overlinewavy"]=65099,
 ["overscore"]=175,
 ["ovowelsignbengali"]=2507,
 ["ovowelsigndeva"]=2379,
 ["ovowelsigngujarati"]=2763,
 ["p"]=112,
 ["paampssquare"]=13184,
 ["paasentosquare"]=13099,
 ["pabengali"]=2474,
 ["pacute"]=7765,
 ["padeva"]=2346,
 ["pagedown"]=8671,
 ["pageup"]=8670,
 ["pagujarati"]=2730,
 ["pagurmukhi"]=2602,
 ["pahiragana"]=12401,
 ["paiyannoithai"]=3631,
 ["pakatakana"]=12497,
 ["palatalizationcyrilliccmb"]=1156,
 ["palochkacyrillic"]=1216,
 ["pansioskorean"]=12671,
 ["paragraph"]=182,
 ["parallel"]=8741,
 ["parenleft"]=40,
 ["parenleftaltonearabic"]=64830,
 ["parenleftbt"]=63725,
 ["parenleftex"]=63724,
 ["parenleftinferior"]=8333,
 ["parenleftmonospace"]=65288,
 ["parenleftsmall"]=65113,
 ["parenleftsuperior"]=8317,
 ["parenlefttp"]=63723,
 ["parenleftvertical"]=65077,
 ["parenright"]=41,
 ["parenrightaltonearabic"]=64831,
 ["parenrightbt"]=63736,
 ["parenrightex"]=63735,
 ["parenrightinferior"]=8334,
 ["parenrightmonospace"]=65289,
 ["parenrightsmall"]=65114,
 ["parenrightsuperior"]=8318,
 ["parenrighttp"]=63734,
 ["parenrightvertical"]=65078,
 ["partialdiff"]=8706,
 ["paseqhebrew"]=1472,
 ["pashtahebrew"]=1433,
 ["pasquare"]=13225,
 ["patah"]=1463,
 ["patah11"]=1463,
 ["patah1d"]=1463,
 ["patah2a"]=1463,
 ["patahhebrew"]=1463,
 ["patahnarrowhebrew"]=1463,
 ["patahquarterhebrew"]=1463,
 ["patahwidehebrew"]=1463,
 ["pazerhebrew"]=1441,
 ["pbopomofo"]=12550,
 ["pcircle"]=9439,
 ["pdotaccent"]=7767,
 ["pe"]=1508,
 ["pecyrillic"]=1087,
 ["pedagesh"]=64324,
 ["pedageshhebrew"]=64324,
 ["peezisquare"]=13115,
 ["pefinaldageshhebrew"]=64323,
 ["peharabic"]=1662,
 ["peharmenian"]=1402,
 ["pehebrew"]=1508,
 ["pehfinalarabic"]=64343,
 ["pehinitialarabic"]=64344,
 ["pehiragana"]=12410,
 ["pehmedialarabic"]=64345,
 ["pekatakana"]=12506,
 ["pemiddlehookcyrillic"]=1191,
 ["perafehebrew"]=64334,
 ["percent"]=37,
 ["percentarabic"]=1642,
 ["percentmonospace"]=65285,
 ["percentsmall"]=65130,
 ["period"]=46,
 ["periodarmenian"]=1417,
 ["periodcentered"]=183,
 ["periodhalfwidth"]=65377,
 ["periodinferior"]=63207,
 ["periodmonospace"]=65294,
 ["periodsmall"]=65106,
 ["periodsuperior"]=63208,
 ["perispomenigreekcmb"]=834,
 ["perpendicular"]=8869,
 ["perthousand"]=8240,
 ["peseta"]=8359,
 ["pfsquare"]=13194,
 ["phabengali"]=2475,
 ["phadeva"]=2347,
 ["phagujarati"]=2731,
 ["phagurmukhi"]=2603,
 ["phi"]=966,
 ["phi1"]=981,
 ["phieuphacirclekorean"]=12922,
 ["phieuphaparenkorean"]=12826,
 ["phieuphcirclekorean"]=12908,
 ["phieuphkorean"]=12621,
 ["phieuphparenkorean"]=12812,
 ["philatin"]=632,
 ["phinthuthai"]=3642,
 ["phisymbolgreek"]=981,
 ["phook"]=421,
 ["phophanthai"]=3614,
 ["phophungthai"]=3612,
 ["phosamphaothai"]=3616,
 ["pi"]=960,
 ["pieupacirclekorean"]=12915,
 ["pieupaparenkorean"]=12819,
 ["pieupcieuckorean"]=12662,
 ["pieupcirclekorean"]=12901,
 ["pieupkiyeokkorean"]=12658,
 ["pieupkorean"]=12610,
 ["pieupparenkorean"]=12805,
 ["pieupsioskiyeokkorean"]=12660,
 ["pieupsioskorean"]=12612,
 ["pieupsiostikeutkorean"]=12661,
 ["pieupthieuthkorean"]=12663,
 ["pieuptikeutkorean"]=12659,
 ["pihiragana"]=12404,
 ["pikatakana"]=12500,
 ["pisymbolgreek"]=982,
 ["piwrarmenian"]=1411,
 ["plus"]=43,
 ["plusbelowcmb"]=799,
 ["pluscircle"]=8853,
 ["plusminus"]=177,
 ["plusmod"]=726,
 ["plusmonospace"]=65291,
 ["plussmall"]=65122,
 ["plussuperior"]=8314,
 ["pmonospace"]=65360,
 ["pmsquare"]=13272,
 ["pohiragana"]=12413,
 ["pointingindexdownwhite"]=9759,
 ["pointingindexleftwhite"]=9756,
 ["pointingindexrightwhite"]=9758,
 ["pointingindexupwhite"]=9757,
 ["pokatakana"]=12509,
 ["poplathai"]=3611,
 ["postalmark"]=12306,
 ["postalmarkface"]=12320,
 ["pparen"]=9387,
 ["precedes"]=8826,
 ["prescription"]=8478,
 ["primemod"]=697,
 ["primereversed"]=8245,
 ["product"]=8719,
 ["projective"]=8965,
 ["prolongedkana"]=12540,
 ["propellor"]=8984,
 ["propersubset"]=8834,
 ["propersuperset"]=8835,
 ["proportion"]=8759,
 ["proportional"]=8733,
 ["psi"]=968,
 ["psicyrillic"]=1137,
 ["psilipneumatacyrilliccmb"]=1158,
 ["pssquare"]=13232,
 ["puhiragana"]=12407,
 ["pukatakana"]=12503,
 ["pvsquare"]=13236,
 ["pwsquare"]=13242,
 ["q"]=113,
 ["qadeva"]=2392,
 ["qadmahebrew"]=1448,
 ["qafarabic"]=1602,
 ["qaffinalarabic"]=65238,
 ["qafinitialarabic"]=65239,
 ["qafmedialarabic"]=65240,
 ["qamats"]=1464,
 ["qamats10"]=1464,
 ["qamats1a"]=1464,
 ["qamats1c"]=1464,
 ["qamats27"]=1464,
 ["qamats29"]=1464,
 ["qamats33"]=1464,
 ["qamatsde"]=1464,
 ["qamatshebrew"]=1464,
 ["qamatsnarrowhebrew"]=1464,
 ["qamatsqatanhebrew"]=1464,
 ["qamatsqatannarrowhebrew"]=1464,
 ["qamatsqatanquarterhebrew"]=1464,
 ["qamatsqatanwidehebrew"]=1464,
 ["qamatsquarterhebrew"]=1464,
 ["qamatswidehebrew"]=1464,
 ["qarneyparahebrew"]=1439,
 ["qbopomofo"]=12561,
 ["qcircle"]=9440,
 ["qhook"]=672,
 ["qmonospace"]=65361,
 ["qof"]=1511,
 ["qofdagesh"]=64327,
 ["qofdageshhebrew"]=64327,
 ["qofhatafpatah"]=1511,
 ["qofhatafpatahhebrew"]=1511,
 ["qofhatafsegol"]=1511,
 ["qofhatafsegolhebrew"]=1511,
 ["qofhebrew"]=1511,
 ["qofhiriq"]=1511,
 ["qofhiriqhebrew"]=1511,
 ["qofholam"]=1511,
 ["qofholamhebrew"]=1511,
 ["qofpatah"]=1511,
 ["qofpatahhebrew"]=1511,
 ["qofqamats"]=1511,
 ["qofqamatshebrew"]=1511,
 ["qofqubuts"]=1511,
 ["qofqubutshebrew"]=1511,
 ["qofsegol"]=1511,
 ["qofsegolhebrew"]=1511,
 ["qofsheva"]=1511,
 ["qofshevahebrew"]=1511,
 ["qoftsere"]=1511,
 ["qoftserehebrew"]=1511,
 ["qparen"]=9388,
 ["quarternote"]=9833,
 ["qubuts"]=1467,
 ["qubuts18"]=1467,
 ["qubuts25"]=1467,
 ["qubuts31"]=1467,
 ["qubutshebrew"]=1467,
 ["qubutsnarrowhebrew"]=1467,
 ["qubutsquarterhebrew"]=1467,
 ["qubutswidehebrew"]=1467,
 ["question"]=63,
 ["questionarabic"]=1567,
 ["questionarmenian"]=1374,
 ["questiondown"]=191,
 ["questiondownsmall"]=63423,
 ["questiongreek"]=894,
 ["questionmonospace"]=65311,
 ["questionsmall"]=63295,
 ["quotedbl"]=34,
 ["quotedblbase"]=8222,
 ["quotedblleft"]=8220,
 ["quotedblmonospace"]=65282,
 ["quotedblprime"]=12318,
 ["quotedblprimereversed"]=12317,
 ["quotedblright"]=8221,
 ["quoteleft"]=8216,
 ["quoteleftreversed"]=8219,
 ["quotereversed"]=8219,
 ["quoteright"]=8217,
 ["quoterightn"]=329,
 ["quotesinglbase"]=8218,
 ["quotesingle"]=39,
 ["quotesinglemonospace"]=65287,
 ["r"]=114,
 ["raarmenian"]=1404,
 ["rabengali"]=2480,
 ["racute"]=341,
 ["radeva"]=2352,
 ["radical"]=8730,
 ["radicalex"]=63717,
 ["radoverssquare"]=13230,
 ["radoverssquaredsquare"]=13231,
 ["radsquare"]=13229,
 ["rafe"]=1471,
 ["rafehebrew"]=1471,
 ["ragujarati"]=2736,
 ["ragurmukhi"]=2608,
 ["rahiragana"]=12425,
 ["rakatakana"]=12521,
 ["rakatakanahalfwidth"]=65431,
 ["ralowerdiagonalbengali"]=2545,
 ["ramiddlediagonalbengali"]=2544,
 ["ramshorn"]=612,
 ["ratio"]=8758,
 ["rbopomofo"]=12566,
 ["rcaron"]=345,
 ["rcedilla"]=343,
 ["rcircle"]=9441,
 ["rcommaaccent"]=343,
 ["rdblgrave"]=529,
 ["rdotaccent"]=7769,
 ["rdotbelow"]=7771,
 ["rdotbelowmacron"]=7773,
 ["referencemark"]=8251,
 ["reflexsubset"]=8838,
 ["reflexsuperset"]=8839,
 ["registered"]=174,
 ["registersans"]=63720,
 ["registerserif"]=63194,
 ["reharabic"]=1585,
 ["reharmenian"]=1408,
 ["rehfinalarabic"]=65198,
 ["rehiragana"]=12428,
 ["rehyehaleflamarabic"]=1585,
 ["rekatakana"]=12524,
 ["rekatakanahalfwidth"]=65434,
 ["resh"]=1512,
 ["reshdageshhebrew"]=64328,
 ["reshhatafpatah"]=1512,
 ["reshhatafpatahhebrew"]=1512,
 ["reshhatafsegol"]=1512,
 ["reshhatafsegolhebrew"]=1512,
 ["reshhebrew"]=1512,
 ["reshhiriq"]=1512,
 ["reshhiriqhebrew"]=1512,
 ["reshholam"]=1512,
 ["reshholamhebrew"]=1512,
 ["reshpatah"]=1512,
 ["reshpatahhebrew"]=1512,
 ["reshqamats"]=1512,
 ["reshqamatshebrew"]=1512,
 ["reshqubuts"]=1512,
 ["reshqubutshebrew"]=1512,
 ["reshsegol"]=1512,
 ["reshsegolhebrew"]=1512,
 ["reshsheva"]=1512,
 ["reshshevahebrew"]=1512,
 ["reshtsere"]=1512,
 ["reshtserehebrew"]=1512,
 ["reversedtilde"]=8765,
 ["reviahebrew"]=1431,
 ["reviamugrashhebrew"]=1431,
 ["revlogicalnot"]=8976,
 ["rfishhook"]=638,
 ["rfishhookreversed"]=639,
 ["rhabengali"]=2525,
 ["rhadeva"]=2397,
 ["rho"]=961,
 ["rhook"]=637,
 ["rhookturned"]=635,
 ["rhookturnedsuperior"]=693,
 ["rhosymbolgreek"]=1009,
 ["rhotichookmod"]=734,
 ["rieulacirclekorean"]=12913,
 ["rieulaparenkorean"]=12817,
 ["rieulcirclekorean"]=12899,
 ["rieulhieuhkorean"]=12608,
 ["rieulkiyeokkorean"]=12602,
 ["rieulkiyeoksioskorean"]=12649,
 ["rieulkorean"]=12601,
 ["rieulmieumkorean"]=12603,
 ["rieulpansioskorean"]=12652,
 ["rieulparenkorean"]=12803,
 ["rieulphieuphkorean"]=12607,
 ["rieulpieupkorean"]=12604,
 ["rieulpieupsioskorean"]=12651,
 ["rieulsioskorean"]=12605,
 ["rieulthieuthkorean"]=12606,
 ["rieultikeutkorean"]=12650,
 ["rieulyeorinhieuhkorean"]=12653,
 ["rightangle"]=8735,
 ["righttackbelowcmb"]=793,
 ["righttriangle"]=8895,
 ["rihiragana"]=12426,
 ["rikatakana"]=12522,
 ["rikatakanahalfwidth"]=65432,
 ["ring"]=730,
 ["ringbelowcmb"]=805,
 ["ringcmb"]=778,
 ["ringhalfleft"]=703,
 ["ringhalfleftarmenian"]=1369,
 ["ringhalfleftbelowcmb"]=796,
 ["ringhalfleftcentered"]=723,
 ["ringhalfright"]=702,
 ["ringhalfrightbelowcmb"]=825,
 ["ringhalfrightcentered"]=722,
 ["rinvertedbreve"]=531,
 ["rittorusquare"]=13137,
 ["rlinebelow"]=7775,
 ["rlongleg"]=636,
 ["rlonglegturned"]=634,
 ["rmonospace"]=65362,
 ["rohiragana"]=12429,
 ["rokatakana"]=12525,
 ["rokatakanahalfwidth"]=65435,
 ["roruathai"]=3619,
 ["rparen"]=9389,
 ["rrabengali"]=2524,
 ["rradeva"]=2353,
 ["rragurmukhi"]=2652,
 ["rreharabic"]=1681,
 ["rrehfinalarabic"]=64397,
 ["rrvocalicbengali"]=2528,
 ["rrvocalicdeva"]=2400,
 ["rrvocalicgujarati"]=2784,
 ["rrvocalicvowelsignbengali"]=2500,
 ["rrvocalicvowelsigndeva"]=2372,
 ["rrvocalicvowelsigngujarati"]=2756,
 ["rsuperior"]=63217,
 ["rtblock"]=9616,
 ["rturned"]=633,
 ["rturnedsuperior"]=692,
 ["ruhiragana"]=12427,
 ["rukatakana"]=12523,
 ["rukatakanahalfwidth"]=65433,
 ["rupeemarkbengali"]=2546,
 ["rupeesignbengali"]=2547,
 ["rupiah"]=63197,
 ["ruthai"]=3620,
 ["rvocalicbengali"]=2443,
 ["rvocalicdeva"]=2315,
 ["rvocalicgujarati"]=2699,
 ["rvocalicvowelsignbengali"]=2499,
 ["rvocalicvowelsigndeva"]=2371,
 ["rvocalicvowelsigngujarati"]=2755,
 ["s"]=115,
 ["sabengali"]=2488,
 ["sacute"]=347,
 ["sacutedotaccent"]=7781,
 ["sadarabic"]=1589,
 ["sadeva"]=2360,
 ["sadfinalarabic"]=65210,
 ["sadinitialarabic"]=65211,
 ["sadmedialarabic"]=65212,
 ["sagujarati"]=2744,
 ["sagurmukhi"]=2616,
 ["sahiragana"]=12373,
 ["sakatakana"]=12469,
 ["sakatakanahalfwidth"]=65403,
 ["sallallahoualayhewasallamarabic"]=65018,
 ["samekh"]=1505,
 ["samekhdagesh"]=64321,
 ["samekhdageshhebrew"]=64321,
 ["samekhhebrew"]=1505,
 ["saraaathai"]=3634,
 ["saraaethai"]=3649,
 ["saraaimaimalaithai"]=3652,
 ["saraaimaimuanthai"]=3651,
 ["saraamthai"]=3635,
 ["saraathai"]=3632,
 ["saraethai"]=3648,
 ["saraiileftthai"]=63622,
 ["saraiithai"]=3637,
 ["saraileftthai"]=63621,
 ["saraithai"]=3636,
 ["saraothai"]=3650,
 ["saraueeleftthai"]=63624,
 ["saraueethai"]=3639,
 ["saraueleftthai"]=63623,
 ["sarauethai"]=3638,
 ["sarauthai"]=3640,
 ["sarauuthai"]=3641,
 ["sbopomofo"]=12569,
 ["scaron"]=353,
 ["scarondotaccent"]=7783,
 ["scedilla"]=351,
 ["schwa"]=601,
 ["schwacyrillic"]=1241,
 ["schwadieresiscyrillic"]=1243,
 ["schwahook"]=602,
 ["scircle"]=9442,
 ["scircumflex"]=349,
 ["scommaaccent"]=537,
 ["sdotaccent"]=7777,
 ["sdotbelow"]=7779,
 ["sdotbelowdotaccent"]=7785,
 ["seagullbelowcmb"]=828,
 ["second"]=8243,
 ["secondtonechinese"]=714,
 ["section"]=167,
 ["seenarabic"]=1587,
 ["seenfinalarabic"]=65202,
 ["seeninitialarabic"]=65203,
 ["seenmedialarabic"]=65204,
 ["segol"]=1462,
 ["segol13"]=1462,
 ["segol1f"]=1462,
 ["segol2c"]=1462,
 ["segolhebrew"]=1462,
 ["segolnarrowhebrew"]=1462,
 ["segolquarterhebrew"]=1462,
 ["segoltahebrew"]=1426,
 ["segolwidehebrew"]=1462,
 ["seharmenian"]=1405,
 ["sehiragana"]=12379,
 ["sekatakana"]=12475,
 ["sekatakanahalfwidth"]=65406,
 ["semicolon"]=59,
 ["semicolonarabic"]=1563,
 ["semicolonmonospace"]=65307,
 ["semicolonsmall"]=65108,
 ["semivoicedmarkkana"]=12444,
 ["semivoicedmarkkanahalfwidth"]=65439,
 ["sentisquare"]=13090,
 ["sentosquare"]=13091,
 ["seven"]=55,
 ["sevenarabic"]=1639,
 ["sevenbengali"]=2541,
 ["sevencircle"]=9318,
 ["sevencircleinversesansserif"]=10128,
 ["sevendeva"]=2413,
 ["seveneighths"]=8542,
 ["sevengujarati"]=2797,
 ["sevengurmukhi"]=2669,
 ["sevenhackarabic"]=1639,
 ["sevenhangzhou"]=12327,
 ["sevenideographicparen"]=12838,
 ["seveninferior"]=8327,
 ["sevenmonospace"]=65303,
 ["sevenoldstyle"]=63287,
 ["sevenparen"]=9338,
 ["sevenperiod"]=9358,
 ["sevenpersian"]=1783,
 ["sevenroman"]=8566,
 ["sevensuperior"]=8311,
 ["seventeencircle"]=9328,
 ["seventeenparen"]=9348,
 ["seventeenperiod"]=9368,
 ["seventhai"]=3671,
 ["sfthyphen"]=173,
 ["shaarmenian"]=1399,
 ["shabengali"]=2486,
 ["shacyrillic"]=1096,
 ["shaddaarabic"]=1617,
 ["shaddadammaarabic"]=64609,
 ["shaddadammatanarabic"]=64606,
 ["shaddafathaarabic"]=64608,
 ["shaddafathatanarabic"]=1617,
 ["shaddakasraarabic"]=64610,
 ["shaddakasratanarabic"]=64607,
 ["shade"]=9618,
 ["shadedark"]=9619,
 ["shadelight"]=9617,
 ["shademedium"]=9618,
 ["shadeva"]=2358,
 ["shagujarati"]=2742,
 ["shagurmukhi"]=2614,
 ["shalshelethebrew"]=1427,
 ["shbopomofo"]=12565,
 ["shchacyrillic"]=1097,
 ["sheenarabic"]=1588,
 ["sheenfinalarabic"]=65206,
 ["sheeninitialarabic"]=65207,
 ["sheenmedialarabic"]=65208,
 ["sheicoptic"]=995,
 ["sheqel"]=8362,
 ["sheqelhebrew"]=8362,
 ["sheva"]=1456,
 ["sheva115"]=1456,
 ["sheva15"]=1456,
 ["sheva22"]=1456,
 ["sheva2e"]=1456,
 ["shevahebrew"]=1456,
 ["shevanarrowhebrew"]=1456,
 ["shevaquarterhebrew"]=1456,
 ["shevawidehebrew"]=1456,
 ["shhacyrillic"]=1211,
 ["shimacoptic"]=1005,
 ["shin"]=1513,
 ["shindagesh"]=64329,
 ["shindageshhebrew"]=64329,
 ["shindageshshindot"]=64300,
 ["shindageshshindothebrew"]=64300,
 ["shindageshsindot"]=64301,
 ["shindageshsindothebrew"]=64301,
 ["shindothebrew"]=1473,
 ["shinhebrew"]=1513,
 ["shinshindot"]=64298,
 ["shinshindothebrew"]=64298,
 ["shinsindot"]=64299,
 ["shinsindothebrew"]=64299,
 ["shook"]=642,
 ["sigma"]=963,
 ["sigma1"]=962,
 ["sigmafinal"]=962,
 ["sigmalunatesymbolgreek"]=1010,
 ["sihiragana"]=12375,
 ["sikatakana"]=12471,
 ["sikatakanahalfwidth"]=65404,
 ["siluqhebrew"]=1469,
 ["siluqlefthebrew"]=1469,
 ["similar"]=8764,
 ["sindothebrew"]=1474,
 ["siosacirclekorean"]=12916,
 ["siosaparenkorean"]=12820,
 ["sioscieuckorean"]=12670,
 ["sioscirclekorean"]=12902,
 ["sioskiyeokkorean"]=12666,
 ["sioskorean"]=12613,
 ["siosnieunkorean"]=12667,
 ["siosparenkorean"]=12806,
 ["siospieupkorean"]=12669,
 ["siostikeutkorean"]=12668,
 ["six"]=54,
 ["sixarabic"]=1638,
 ["sixbengali"]=2540,
 ["sixcircle"]=9317,
 ["sixcircleinversesansserif"]=10127,
 ["sixdeva"]=2412,
 ["sixgujarati"]=2796,
 ["sixgurmukhi"]=2668,
 ["sixhackarabic"]=1638,
 ["sixhangzhou"]=12326,
 ["sixideographicparen"]=12837,
 ["sixinferior"]=8326,
 ["sixmonospace"]=65302,
 ["sixoldstyle"]=63286,
 ["sixparen"]=9337,
 ["sixperiod"]=9357,
 ["sixpersian"]=1782,
 ["sixroman"]=8565,
 ["sixsuperior"]=8310,
 ["sixteencircle"]=9327,
 ["sixteencurrencydenominatorbengali"]=2553,
 ["sixteenparen"]=9347,
 ["sixteenperiod"]=9367,
 ["sixthai"]=3670,
 ["slash"]=47,
 ["slashmonospace"]=65295,
 ["slong"]=383,
 ["slongdotaccent"]=7835,
 ["smileface"]=9786,
 ["smonospace"]=65363,
 ["sofpasuqhebrew"]=1475,
 ["softhyphen"]=173,
 ["softsigncyrillic"]=1100,
 ["sohiragana"]=12381,
 ["sokatakana"]=12477,
 ["sokatakanahalfwidth"]=65407,
 ["soliduslongoverlaycmb"]=824,
 ["solidusshortoverlaycmb"]=823,
 ["sorusithai"]=3625,
 ["sosalathai"]=3624,
 ["sosothai"]=3595,
 ["sosuathai"]=3626,
 ["space"]=32,
 ["spacehackarabic"]=32,
 ["spade"]=9824,
 ["spadesuitblack"]=9824,
 ["spadesuitwhite"]=9828,
 ["sparen"]=9390,
 ["squarebelowcmb"]=827,
 ["squarecc"]=13252,
 ["squarecm"]=13213,
 ["squarediagonalcrosshatchfill"]=9641,
 ["squarehorizontalfill"]=9636,
 ["squarekg"]=13199,
 ["squarekm"]=13214,
 ["squarekmcapital"]=13262,
 ["squareln"]=13265,
 ["squarelog"]=13266,
 ["squaremg"]=13198,
 ["squaremil"]=13269,
 ["squaremm"]=13212,
 ["squaremsquared"]=13217,
 ["squareorthogonalcrosshatchfill"]=9638,
 ["squareupperlefttolowerrightfill"]=9639,
 ["squareupperrighttolowerleftfill"]=9640,
 ["squareverticalfill"]=9637,
 ["squarewhitewithsmallblack"]=9635,
 ["srsquare"]=13275,
 ["ssabengali"]=2487,
 ["ssadeva"]=2359,
 ["ssagujarati"]=2743,
 ["ssangcieuckorean"]=12617,
 ["ssanghieuhkorean"]=12677,
 ["ssangieungkorean"]=12672,
 ["ssangkiyeokkorean"]=12594,
 ["ssangnieunkorean"]=12645,
 ["ssangpieupkorean"]=12611,
 ["ssangsioskorean"]=12614,
 ["ssangtikeutkorean"]=12600,
 ["ssuperior"]=63218,
 ["sterling"]=163,
 ["sterlingmonospace"]=65505,
 ["strokelongoverlaycmb"]=822,
 ["strokeshortoverlaycmb"]=821,
 ["subset"]=8834,
 ["subsetnotequal"]=8842,
 ["subsetorequal"]=8838,
 ["succeeds"]=8827,
 ["suchthat"]=8715,
 ["suhiragana"]=12377,
 ["sukatakana"]=12473,
 ["sukatakanahalfwidth"]=65405,
 ["sukunarabic"]=1618,
 ["summation"]=8721,
 ["sun"]=9788,
 ["superset"]=8835,
 ["supersetnotequal"]=8843,
 ["supersetorequal"]=8839,
 ["svsquare"]=13276,
 ["syouwaerasquare"]=13180,
 ["t"]=116,
 ["tabengali"]=2468,
 ["tackdown"]=8868,
 ["tackleft"]=8867,
 ["tadeva"]=2340,
 ["tagujarati"]=2724,
 ["tagurmukhi"]=2596,
 ["taharabic"]=1591,
 ["tahfinalarabic"]=65218,
 ["tahinitialarabic"]=65219,
 ["tahiragana"]=12383,
 ["tahmedialarabic"]=65220,
 ["taisyouerasquare"]=13181,
 ["takatakana"]=12479,
 ["takatakanahalfwidth"]=65408,
 ["tatweelarabic"]=1600,
 ["tau"]=964,
 ["tav"]=1514,
 ["tavdages"]=64330,
 ["tavdagesh"]=64330,
 ["tavdageshhebrew"]=64330,
 ["tavhebrew"]=1514,
 ["tbar"]=359,
 ["tbopomofo"]=12554,
 ["tcaron"]=357,
 ["tccurl"]=680,
 ["tcedilla"]=355,
 ["tcheharabic"]=1670,
 ["tchehfinalarabic"]=64379,
 ["tchehinitialarabic"]=64380,
 ["tchehmedialarabic"]=64381,
 ["tchehmeeminitialarabic"]=64380,
 ["tcircle"]=9443,
 ["tcircumflexbelow"]=7793,
 ["tcommaaccent"]=355,
 ["tdieresis"]=7831,
 ["tdotaccent"]=7787,
 ["tdotbelow"]=7789,
 ["tecyrillic"]=1090,
 ["tedescendercyrillic"]=1197,
 ["teharabic"]=1578,
 ["tehfinalarabic"]=65174,
 ["tehhahinitialarabic"]=64674,
 ["tehhahisolatedarabic"]=64524,
 ["tehinitialarabic"]=65175,
 ["tehiragana"]=12390,
 ["tehjeeminitialarabic"]=64673,
 ["tehjeemisolatedarabic"]=64523,
 ["tehmarbutaarabic"]=1577,
 ["tehmarbutafinalarabic"]=65172,
 ["tehmedialarabic"]=65176,
 ["tehmeeminitialarabic"]=64676,
 ["tehmeemisolatedarabic"]=64526,
 ["tehnoonfinalarabic"]=64627,
 ["tekatakana"]=12486,
 ["tekatakanahalfwidth"]=65411,
 ["telephone"]=8481,
 ["telephoneblack"]=9742,
 ["telishagedolahebrew"]=1440,
 ["telishaqetanahebrew"]=1449,
 ["tencircle"]=9321,
 ["tenideographicparen"]=12841,
 ["tenparen"]=9341,
 ["tenperiod"]=9361,
 ["tenroman"]=8569,
 ["tesh"]=679,
 ["tet"]=1496,
 ["tetdagesh"]=64312,
 ["tetdageshhebrew"]=64312,
 ["tethebrew"]=1496,
 ["tetsecyrillic"]=1205,
 ["tevirhebrew"]=1435,
 ["tevirlefthebrew"]=1435,
 ["thabengali"]=2469,
 ["thadeva"]=2341,
 ["thagujarati"]=2725,
 ["thagurmukhi"]=2597,
 ["thalarabic"]=1584,
 ["thalfinalarabic"]=65196,
 ["thanthakhatlowleftthai"]=63640,
 ["thanthakhatlowrightthai"]=63639,
 ["thanthakhatthai"]=3660,
 ["thanthakhatupperleftthai"]=63638,
 ["theharabic"]=1579,
 ["thehfinalarabic"]=65178,
 ["thehinitialarabic"]=65179,
 ["thehmedialarabic"]=65180,
 ["thereexists"]=8707,
 ["therefore"]=8756,
 ["theta"]=952,
 ["theta1"]=977,
 ["thetasymbolgreek"]=977,
 ["thieuthacirclekorean"]=12921,
 ["thieuthaparenkorean"]=12825,
 ["thieuthcirclekorean"]=12907,
 ["thieuthkorean"]=12620,
 ["thieuthparenkorean"]=12811,
 ["thirteencircle"]=9324,
 ["thirteenparen"]=9344,
 ["thirteenperiod"]=9364,
 ["thonangmonthothai"]=3601,
 ["thook"]=429,
 ["thophuthaothai"]=3602,
 ["thorn"]=254,
 ["thothahanthai"]=3607,
 ["thothanthai"]=3600,
 ["thothongthai"]=3608,
 ["thothungthai"]=3606,
 ["thousandcyrillic"]=1154,
 ["thousandsseparatorarabic"]=1644,
 ["thousandsseparatorpersian"]=1644,
 ["three"]=51,
 ["threearabic"]=1635,
 ["threebengali"]=2537,
 ["threecircle"]=9314,
 ["threecircleinversesansserif"]=10124,
 ["threedeva"]=2409,
 ["threeeighths"]=8540,
 ["threegujarati"]=2793,
 ["threegurmukhi"]=2665,
 ["threehackarabic"]=1635,
 ["threehangzhou"]=12323,
 ["threeideographicparen"]=12834,
 ["threeinferior"]=8323,
 ["threemonospace"]=65299,
 ["threenumeratorbengali"]=2550,
 ["threeoldstyle"]=63283,
 ["threeparen"]=9334,
 ["threeperiod"]=9354,
 ["threepersian"]=1779,
 ["threequarters"]=190,
 ["threequartersemdash"]=63198,
 ["threeroman"]=8562,
 ["threesuperior"]=179,
 ["threethai"]=3667,
 ["thzsquare"]=13204,
 ["tihiragana"]=12385,
 ["tikatakana"]=12481,
 ["tikatakanahalfwidth"]=65409,
 ["tikeutacirclekorean"]=12912,
 ["tikeutaparenkorean"]=12816,
 ["tikeutcirclekorean"]=12898,
 ["tikeutkorean"]=12599,
 ["tikeutparenkorean"]=12802,
 ["tilde"]=732,
 ["tildebelowcmb"]=816,
 ["tildecmb"]=771,
 ["tildecomb"]=771,
 ["tildedoublecmb"]=864,
 ["tildeoperator"]=8764,
 ["tildeoverlaycmb"]=820,
 ["tildeverticalcmb"]=830,
 ["timescircle"]=8855,
 ["tipehahebrew"]=1430,
 ["tipehalefthebrew"]=1430,
 ["tippigurmukhi"]=2672,
 ["titlocyrilliccmb"]=1155,
 ["tiwnarmenian"]=1407,
 ["tlinebelow"]=7791,
 ["tmonospace"]=65364,
 ["toarmenian"]=1385,
 ["tohiragana"]=12392,
 ["tokatakana"]=12488,
 ["tokatakanahalfwidth"]=65412,
 ["tonebarextrahighmod"]=741,
 ["tonebarextralowmod"]=745,
 ["tonebarhighmod"]=742,
 ["tonebarlowmod"]=744,
 ["tonebarmidmod"]=743,
 ["tonefive"]=445,
 ["tonesix"]=389,
 ["tonetwo"]=424,
 ["tonos"]=900,
 ["tonsquare"]=13095,
 ["topatakthai"]=3599,
 ["tortoiseshellbracketleft"]=12308,
 ["tortoiseshellbracketleftsmall"]=65117,
 ["tortoiseshellbracketleftvertical"]=65081,
 ["tortoiseshellbracketright"]=12309,
 ["tortoiseshellbracketrightsmall"]=65118,
 ["tortoiseshellbracketrightvertical"]=65082,
 ["totaothai"]=3605,
 ["tpalatalhook"]=427,
 ["tparen"]=9391,
 ["trademark"]=8482,
 ["trademarksans"]=63722,
 ["trademarkserif"]=63195,
 ["tretroflexhook"]=648,
 ["triagdn"]=9660,
 ["triaglf"]=9668,
 ["triagrt"]=9658,
 ["triagup"]=9650,
 ["ts"]=678,
 ["tsadi"]=1510,
 ["tsadidagesh"]=64326,
 ["tsadidageshhebrew"]=64326,
 ["tsadihebrew"]=1510,
 ["tsecyrillic"]=1094,
 ["tsere"]=1461,
 ["tsere12"]=1461,
 ["tsere1e"]=1461,
 ["tsere2b"]=1461,
 ["tserehebrew"]=1461,
 ["tserenarrowhebrew"]=1461,
 ["tserequarterhebrew"]=1461,
 ["tserewidehebrew"]=1461,
 ["tshecyrillic"]=1115,
 ["tsuperior"]=63219,
 ["ttabengali"]=2463,
 ["ttadeva"]=2335,
 ["ttagujarati"]=2719,
 ["ttagurmukhi"]=2591,
 ["tteharabic"]=1657,
 ["ttehfinalarabic"]=64359,
 ["ttehinitialarabic"]=64360,
 ["ttehmedialarabic"]=64361,
 ["tthabengali"]=2464,
 ["tthadeva"]=2336,
 ["tthagujarati"]=2720,
 ["tthagurmukhi"]=2592,
 ["tturned"]=647,
 ["tuhiragana"]=12388,
 ["tukatakana"]=12484,
 ["tukatakanahalfwidth"]=65410,
 ["tusmallhiragana"]=12387,
 ["tusmallkatakana"]=12483,
 ["tusmallkatakanahalfwidth"]=65391,
 ["twelvecircle"]=9323,
 ["twelveparen"]=9343,
 ["twelveperiod"]=9363,
 ["twelveroman"]=8571,
 ["twentycircle"]=9331,
 ["twentyhangzhou"]=21316,
 ["twentyparen"]=9351,
 ["twentyperiod"]=9371,
 ["two"]=50,
 ["twoarabic"]=1634,
 ["twobengali"]=2536,
 ["twocircle"]=9313,
 ["twocircleinversesansserif"]=10123,
 ["twodeva"]=2408,
 ["twodotenleader"]=8229,
 ["twodotleader"]=8229,
 ["twodotleadervertical"]=65072,
 ["twogujarati"]=2792,
 ["twogurmukhi"]=2664,
 ["twohackarabic"]=1634,
 ["twohangzhou"]=12322,
 ["twoideographicparen"]=12833,
 ["twoinferior"]=8322,
 ["twomonospace"]=65298,
 ["twonumeratorbengali"]=2549,
 ["twooldstyle"]=63282,
 ["twoparen"]=9333,
 ["twoperiod"]=9353,
 ["twopersian"]=1778,
 ["tworoman"]=8561,
 ["twostroke"]=443,
 ["twosuperior"]=178,
 ["twothai"]=3666,
 ["twothirds"]=8532,
 ["u"]=117,
 ["uacute"]=250,
 ["ubar"]=649,
 ["ubengali"]=2441,
 ["ubopomofo"]=12584,
 ["ubreve"]=365,
 ["ucaron"]=468,
 ["ucircle"]=9444,
 ["ucircumflex"]=251,
 ["ucircumflexbelow"]=7799,
 ["ucyrillic"]=1091,
 ["udattadeva"]=2385,
 ["udblacute"]=369,
 ["udblgrave"]=533,
 ["udeva"]=2313,
 ["udieresis"]=252,
 ["udieresisacute"]=472,
 ["udieresisbelow"]=7795,
 ["udieresiscaron"]=474,
 ["udieresiscyrillic"]=1265,
 ["udieresisgrave"]=476,
 ["udieresismacron"]=470,
 ["udotbelow"]=7909,
 ["ugrave"]=249,
 ["ugujarati"]=2697,
 ["ugurmukhi"]=2569,
 ["uhiragana"]=12358,
 ["uhookabove"]=7911,
 ["uhorn"]=432,
 ["uhornacute"]=7913,
 ["uhorndotbelow"]=7921,
 ["uhorngrave"]=7915,
 ["uhornhookabove"]=7917,
 ["uhorntilde"]=7919,
 ["uhungarumlaut"]=369,
 ["uhungarumlautcyrillic"]=1267,
 ["uinvertedbreve"]=535,
 ["ukatakana"]=12454,
 ["ukatakanahalfwidth"]=65395,
 ["ukcyrillic"]=1145,
 ["ukorean"]=12636,
 ["umacron"]=363,
 ["umacroncyrillic"]=1263,
 ["umacrondieresis"]=7803,
 ["umatragurmukhi"]=2625,
 ["umonospace"]=65365,
 ["underscore"]=95,
 ["underscoredbl"]=8215,
 ["underscoremonospace"]=65343,
 ["underscorevertical"]=65075,
 ["underscorewavy"]=65103,
 ["union"]=8746,
 ["universal"]=8704,
 ["uogonek"]=371,
 ["uparen"]=9392,
 ["upblock"]=9600,
 ["upperdothebrew"]=1476,
 ["upsilon"]=965,
 ["upsilondieresis"]=971,
 ["upsilondieresistonos"]=944,
 ["upsilonlatin"]=650,
 ["upsilontonos"]=973,
 ["uptackbelowcmb"]=797,
 ["uptackmod"]=724,
 ["uragurmukhi"]=2675,
 ["uring"]=367,
 ["ushortcyrillic"]=1118,
 ["usmallhiragana"]=12357,
 ["usmallkatakana"]=12453,
 ["usmallkatakanahalfwidth"]=65385,
 ["ustraightcyrillic"]=1199,
 ["ustraightstrokecyrillic"]=1201,
 ["utilde"]=361,
 ["utildeacute"]=7801,
 ["utildebelow"]=7797,
 ["uubengali"]=2442,
 ["uudeva"]=2314,
 ["uugujarati"]=2698,
 ["uugurmukhi"]=2570,
 ["uumatragurmukhi"]=2626,
 ["uuvowelsignbengali"]=2498,
 ["uuvowelsigndeva"]=2370,
 ["uuvowelsigngujarati"]=2754,
 ["uvowelsignbengali"]=2497,
 ["uvowelsigndeva"]=2369,
 ["uvowelsigngujarati"]=2753,
 ["v"]=118,
 ["vadeva"]=2357,
 ["vagujarati"]=2741,
 ["vagurmukhi"]=2613,
 ["vakatakana"]=12535,
 ["vav"]=1493,
 ["vavdagesh"]=64309,
 ["vavdagesh65"]=64309,
 ["vavdageshhebrew"]=64309,
 ["vavhebrew"]=1493,
 ["vavholam"]=64331,
 ["vavholamhebrew"]=64331,
 ["vavvavhebrew"]=1520,
 ["vavyodhebrew"]=1521,
 ["vcircle"]=9445,
 ["vdotbelow"]=7807,
 ["vecyrillic"]=1074,
 ["veharabic"]=1700,
 ["vehfinalarabic"]=64363,
 ["vehinitialarabic"]=64364,
 ["vehmedialarabic"]=64365,
 ["vekatakana"]=12537,
 ["venus"]=9792,
 ["verticalbar"]=124,
 ["verticallineabovecmb"]=781,
 ["verticallinebelowcmb"]=809,
 ["verticallinelowmod"]=716,
 ["verticallinemod"]=712,
 ["vewarmenian"]=1406,
 ["vhook"]=651,
 ["vikatakana"]=12536,
 ["viramabengali"]=2509,
 ["viramadeva"]=2381,
 ["viramagujarati"]=2765,
 ["visargabengali"]=2435,
 ["visargadeva"]=2307,
 ["visargagujarati"]=2691,
 ["vmonospace"]=65366,
 ["voarmenian"]=1400,
 ["voicediterationhiragana"]=12446,
 ["voicediterationkatakana"]=12542,
 ["voicedmarkkana"]=12443,
 ["voicedmarkkanahalfwidth"]=65438,
 ["vokatakana"]=12538,
 ["vparen"]=9393,
 ["vtilde"]=7805,
 ["vturned"]=652,
 ["vuhiragana"]=12436,
 ["vukatakana"]=12532,
 ["w"]=119,
 ["wacute"]=7811,
 ["waekorean"]=12633,
 ["wahiragana"]=12431,
 ["wakatakana"]=12527,
 ["wakatakanahalfwidth"]=65436,
 ["wakorean"]=12632,
 ["wasmallhiragana"]=12430,
 ["wasmallkatakana"]=12526,
 ["wattosquare"]=13143,
 ["wavedash"]=12316,
 ["wavyunderscorevertical"]=65076,
 ["wawarabic"]=1608,
 ["wawfinalarabic"]=65262,
 ["wawhamzaabovearabic"]=1572,
 ["wawhamzaabovefinalarabic"]=65158,
 ["wbsquare"]=13277,
 ["wcircle"]=9446,
 ["wcircumflex"]=373,
 ["wdieresis"]=7813,
 ["wdotaccent"]=7815,
 ["wdotbelow"]=7817,
 ["wehiragana"]=12433,
 ["weierstrass"]=8472,
 ["wekatakana"]=12529,
 ["wekorean"]=12638,
 ["weokorean"]=12637,
 ["wgrave"]=7809,
 ["whitebullet"]=9702,
 ["whitecircle"]=9675,
 ["whitecircleinverse"]=9689,
 ["whitecornerbracketleft"]=12302,
 ["whitecornerbracketleftvertical"]=65091,
 ["whitecornerbracketright"]=12303,
 ["whitecornerbracketrightvertical"]=65092,
 ["whitediamond"]=9671,
 ["whitediamondcontainingblacksmalldiamond"]=9672,
 ["whitedownpointingsmalltriangle"]=9663,
 ["whitedownpointingtriangle"]=9661,
 ["whiteleftpointingsmalltriangle"]=9667,
 ["whiteleftpointingtriangle"]=9665,
 ["whitelenticularbracketleft"]=12310,
 ["whitelenticularbracketright"]=12311,
 ["whiterightpointingsmalltriangle"]=9657,
 ["whiterightpointingtriangle"]=9655,
 ["whitesmallsquare"]=9643,
 ["whitesmilingface"]=9786,
 ["whitesquare"]=9633,
 ["whitestar"]=9734,
 ["whitetelephone"]=9743,
 ["whitetortoiseshellbracketleft"]=12312,
 ["whitetortoiseshellbracketright"]=12313,
 ["whiteuppointingsmalltriangle"]=9653,
 ["whiteuppointingtriangle"]=9651,
 ["wihiragana"]=12432,
 ["wikatakana"]=12528,
 ["wikorean"]=12639,
 ["wmonospace"]=65367,
 ["wohiragana"]=12434,
 ["wokatakana"]=12530,
 ["wokatakanahalfwidth"]=65382,
 ["won"]=8361,
 ["wonmonospace"]=65510,
 ["wowaenthai"]=3623,
 ["wparen"]=9394,
 ["wring"]=7832,
 ["wsuperior"]=695,
 ["wturned"]=653,
 ["wynn"]=447,
 ["x"]=120,
 ["xabovecmb"]=829,
 ["xbopomofo"]=12562,
 ["xcircle"]=9447,
 ["xdieresis"]=7821,
 ["xdotaccent"]=7819,
 ["xeharmenian"]=1389,
 ["xi"]=958,
 ["xmonospace"]=65368,
 ["xparen"]=9395,
 ["xsuperior"]=739,
 ["y"]=121,
 ["yaadosquare"]=13134,
 ["yabengali"]=2479,
 ["yacute"]=253,
 ["yadeva"]=2351,
 ["yaekorean"]=12626,
 ["yagujarati"]=2735,
 ["yagurmukhi"]=2607,
 ["yahiragana"]=12420,
 ["yakatakana"]=12516,
 ["yakatakanahalfwidth"]=65428,
 ["yakorean"]=12625,
 ["yamakkanthai"]=3662,
 ["yasmallhiragana"]=12419,
 ["yasmallkatakana"]=12515,
 ["yasmallkatakanahalfwidth"]=65388,
 ["yatcyrillic"]=1123,
 ["ycircle"]=9448,
 ["ycircumflex"]=375,
 ["ydieresis"]=255,
 ["ydotaccent"]=7823,
 ["ydotbelow"]=7925,
 ["yeharabic"]=1610,
 ["yehbarreearabic"]=1746,
 ["yehbarreefinalarabic"]=64431,
 ["yehfinalarabic"]=65266,
 ["yehhamzaabovearabic"]=1574,
 ["yehhamzaabovefinalarabic"]=65162,
 ["yehhamzaaboveinitialarabic"]=65163,
 ["yehhamzaabovemedialarabic"]=65164,
 ["yehinitialarabic"]=65267,
 ["yehmedialarabic"]=65268,
 ["yehmeeminitialarabic"]=64733,
 ["yehmeemisolatedarabic"]=64600,
 ["yehnoonfinalarabic"]=64660,
 ["yehthreedotsbelowarabic"]=1745,
 ["yekorean"]=12630,
 ["yen"]=165,
 ["yenmonospace"]=65509,
 ["yeokorean"]=12629,
 ["yeorinhieuhkorean"]=12678,
 ["yerahbenyomohebrew"]=1450,
 ["yerahbenyomolefthebrew"]=1450,
 ["yericyrillic"]=1099,
 ["yerudieresiscyrillic"]=1273,
 ["yesieungkorean"]=12673,
 ["yesieungpansioskorean"]=12675,
 ["yesieungsioskorean"]=12674,
 ["yetivhebrew"]=1434,
 ["ygrave"]=7923,
 ["yhook"]=436,
 ["yhookabove"]=7927,
 ["yiarmenian"]=1397,
 ["yicyrillic"]=1111,
 ["yikorean"]=12642,
 ["yinyang"]=9775,
 ["yiwnarmenian"]=1410,
 ["ymonospace"]=65369,
 ["yod"]=1497,
 ["yoddagesh"]=64313,
 ["yoddageshhebrew"]=64313,
 ["yodhebrew"]=1497,
 ["yodyodhebrew"]=1522,
 ["yodyodpatahhebrew"]=64287,
 ["yohiragana"]=12424,
 ["yoikorean"]=12681,
 ["yokatakana"]=12520,
 ["yokatakanahalfwidth"]=65430,
 ["yokorean"]=12635,
 ["yosmallhiragana"]=12423,
 ["yosmallkatakana"]=12519,
 ["yosmallkatakanahalfwidth"]=65390,
 ["yotgreek"]=1011,
 ["yoyaekorean"]=12680,
 ["yoyakorean"]=12679,
 ["yoyakthai"]=3618,
 ["yoyingthai"]=3597,
 ["yparen"]=9396,
 ["ypogegrammeni"]=890,
 ["ypogegrammenigreekcmb"]=837,
 ["yr"]=422,
 ["yring"]=7833,
 ["ysuperior"]=696,
 ["ytilde"]=7929,
 ["yturned"]=654,
 ["yuhiragana"]=12422,
 ["yuikorean"]=12684,
 ["yukatakana"]=12518,
 ["yukatakanahalfwidth"]=65429,
 ["yukorean"]=12640,
 ["yusbigcyrillic"]=1131,
 ["yusbigiotifiedcyrillic"]=1133,
 ["yuslittlecyrillic"]=1127,
 ["yuslittleiotifiedcyrillic"]=1129,
 ["yusmallhiragana"]=12421,
 ["yusmallkatakana"]=12517,
 ["yusmallkatakanahalfwidth"]=65389,
 ["yuyekorean"]=12683,
 ["yuyeokorean"]=12682,
 ["yyabengali"]=2527,
 ["yyadeva"]=2399,
 ["z"]=122,
 ["zaarmenian"]=1382,
 ["zacute"]=378,
 ["zadeva"]=2395,
 ["zagurmukhi"]=2651,
 ["zaharabic"]=1592,
 ["zahfinalarabic"]=65222,
 ["zahinitialarabic"]=65223,
 ["zahiragana"]=12374,
 ["zahmedialarabic"]=65224,
 ["zainarabic"]=1586,
 ["zainfinalarabic"]=65200,
 ["zakatakana"]=12470,
 ["zaqefgadolhebrew"]=1429,
 ["zaqefqatanhebrew"]=1428,
 ["zarqahebrew"]=1432,
 ["zayin"]=1494,
 ["zayindagesh"]=64310,
 ["zayindageshhebrew"]=64310,
 ["zayinhebrew"]=1494,
 ["zbopomofo"]=12567,
 ["zcaron"]=382,
 ["zcircle"]=9449,
 ["zcircumflex"]=7825,
 ["zcurl"]=657,
 ["zdot"]=380,
 ["zdotaccent"]=380,
 ["zdotbelow"]=7827,
 ["zecyrillic"]=1079,
 ["zedescendercyrillic"]=1177,
 ["zedieresiscyrillic"]=1247,
 ["zehiragana"]=12380,
 ["zekatakana"]=12476,
 ["zero"]=48,
 ["zeroarabic"]=1632,
 ["zerobengali"]=2534,
 ["zerodeva"]=2406,
 ["zerogujarati"]=2790,
 ["zerogurmukhi"]=2662,
 ["zerohackarabic"]=1632,
 ["zeroinferior"]=8320,
 ["zeromonospace"]=65296,
 ["zerooldstyle"]=63280,
 ["zeropersian"]=1776,
 ["zerosuperior"]=8304,
 ["zerothai"]=3664,
 ["zerowidthjoiner"]=65279,
 ["zerowidthnonjoiner"]=8204,
 ["zerowidthspace"]=8203,
 ["zeta"]=950,
 ["zhbopomofo"]=12563,
 ["zhearmenian"]=1386,
 ["zhebrevecyrillic"]=1218,
 ["zhecyrillic"]=1078,
 ["zhedescendercyrillic"]=1175,
 ["zhedieresiscyrillic"]=1245,
 ["zihiragana"]=12376,
 ["zikatakana"]=12472,
 ["zinorhebrew"]=1454,
 ["zlinebelow"]=7829,
 ["zmonospace"]=65370,
 ["zohiragana"]=12382,
 ["zokatakana"]=12478,
 ["zparen"]=9397,
 ["zretroflexhook"]=656,
 ["zstroke"]=438,
 ["zuhiragana"]=12378,
 ["zukatakana"]=12474,
}
