----------------------------------------------------------------

Serbian Cyrillic language module for Babel, v3.0

Released under the LaTeX Project Public License v1.3c or later.
See http://www.latex-project.org/lppl.txt

The package provides support for use of Babel in documents written in Serbian Cyrillic
(in ekavian or ijekavian dialect). The support is adapted for use both
under legacy TeX engines, and under XeTeX and LuaTeX.

The Current Maintainer is Uroš Stefanović.

USAGE

Serbianc language definition file can be used both with legacy 8-bit engines
(such as latex.exe or pdflatex.exe) and Unicode compilers (xelatex.exe or
lualatex.exe). The Unicode engines can be run either in Unicode mode or 8-bit
compatibility mode, which emulates the legacy engines. The two modes differ by
a set of packages loaded in the preamble of a source TeX file. It is important
to keep the recommended order of the packages loaded, especially when running
Unicode engines in a compatibility 8-bit mode.

In the examples below, it is assumed that a source file has utf8 input encoding.

  8-bit mode:

    \usepackage[T1,T2A]{fontenc}
    \usepackage[utf8]{inputenc}
    \usepackage[english,serbanc]{babel}

  Unicode mode, LuaLaTeX or XeLaTeX

    \usepackage{fontspec}
        \defaultfontfeatures{Ligatures={TeX},Language=Serbian,Script=Cyrillic}
        \setmainfont{CMU Serif}
        \setsansfont{CMU Sans Serif}
        \setmonofont{CMU Typewriter Text}
    \usepackage[english,serbianc]{babel}

Typesetting in ijekavian dialect:

    \usepackage[english,serbianc]{babel}
    \languageattribute{serbianc}{ijekav}
or
    \usepackage[english,serbianc.ijekav]{babel}
	
Also, the attributes 'datei' and 'quotes' are defined.

DOCUMENTATION

See serbianc.pdf for more information.

CHANGES

  * Command \todayRoman is added;
  
  * Commands \today* and \todayRoman* print dates without dot after year;
  
  * Ijekavian dialect is now supported (if 'ijekav' attribute is used);
  
  * Shorthand "' prints '' quotes instead of traditional `` quotes (if 'quotes' attribute is used);
  
  * 'јуни' and 'јули' is printed instead of 'јун' and 'јул' (if 'datei' attribute is used);
  
  * Some captions strings are fixeds;
  
  * Cyrillic enumeration is added.
  
  * Encodings T2A, X2, OT2 (8-bit mode) and TU (Unicode mode) are supported.

----------------------------------------------------------------

%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote \"    Hash (number) \#
%%   Dollar        \$     Percent      \%    Ampersand     \&
%%   Acute accent  \'     Left paren   \(    Right paren   \)
%%   Asterisk      \*     Plus         \+    Comma         \,
%%   Minus         \-     Point        \.    Solidus       \/
%%   Colon         \:     Semicolon    \;    Less than     \<
%%   Equals        \=     Greater than \>    Question mark \?
%%   Commercial at \@     Left bracket \[    Backslash     \\
%%   Right bracket \]     Circumflex   \^    Underscore    \_
%%   Grave accent  \`     Left brace   \{    Vertical bar  \|
%%   Right brace   \}     Tilde        \~}
%%
