---
myst:
  html_meta:
    keywords: LaTeX,flottants,espace blanc avant une image,espace blanc dans un flottant,espace blanc avant un tableau
---
# Comment supprimer l'espace en trop autour des flottants ?

Vous vous demandez peut-être pourquoi l'espace vertical supplémentaire est apparu dans vos environnements de flottants (`figure` ou `table`). Peut-être cet espace est-il arrivé là alors que vous cherchiez à *améliorer le rendu de votre document*, et vous ne vous en êtes pas rendu compte immédiatement...

Le problème vient du fait que l'environnement `center` (et ses copains `flushleft` et `flushright`) est implémenté à partir du code qui met en forme les listes de LaTeX (environnement `itemize`), or les listes sont toujours séparées de ce qui les entoure par un peu d'espace.

Si des espaces verticaux injustifiés sont apparus, c'est probablement que vous avez écrit quelque chose comme :

```{noedit}
\begin{figure}
 \begin{center}
   \includegraphics{...}
   \caption{...}
 \end{center}
\end{figure}
```

ou pire encore :

```{noedit}
\begin{figure}
 \begin{center}
   \includegraphics{...}
 \end{center}
 \caption{...}
\end{figure}
```

La solution consiste à laisser le flottant et les objets qu'il contient se positionner eux-mêmes, et à utiliser des commandes de mise en page « génériques » plutôt que leurs versions basées sur des listes :

```{noedit}
\begin{figure}
  \centering
  \includegraphics{...}
  \caption{...}
\end{figure}
```

(ce qui est encore plus rapide à écrire).

Ce dernier code fonctionnera avec toutes les extensions LaTeX, à l'exception de
celles antérieures à LaTeX2e, telles que <ctanpkg:psfig> ou <ctanpkg:epsf> —
voir la question
"[](/3_composition/illustrations/inclure_une_image/inclure_une_image)" pour plus
de détails sur la genèse de la commande `\includegraphics`.

## Et si ça ne suffit pas ?

Une fois que vous aurez retiré les espaces ajoutés par erreur avec `\begin{center}`...`\end{center}`, vous voudrez peut-être jouer sur les nombreux paramètres disponibles :

:::{todo} Lister les principaux paramètres d'espacement autour des flottants :
:::

- [Remove space after figure and before text](https://tex.stackexchange.com/questions/60477/remove-space-after-figure-and-before-text).

:::{sources}
- [Extra vertical space in floats](faquk:FAQ-vertspacefloat),
- [Space between caption and table in TeX](https://tex.stackexchange.com/questions/292859/space-between-caption-and-table-in-tex).
:::
