---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, lignes, mise en page, 
              ajouter les numéros de lignes, mode brouillon, 
              numéros de lignes dans la marge
---

# Comment numéroter les lignes d'un document ?

## Dans du texte classique

### Avec l'extension <ctanpkg:lineno>

L'extension <ctanpkg:lineno> permet d'obtenir cette numérotation en modifiant
la routine de sortie LaTeX. Il suffit d'insérer la commande `\linenumbers` 
là où vous souhaitez activer la numérotation. Cette méthode marche 
raisonnablement bien, y compris quand la taille de caractère et l'interligne
sont modifiés (par exemple pour les titres), mais n'est pas sans faille ; 
l'utilisateur doit donc rester vigilant.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lineno}

  \title{À la recherche\dots}
  \author{M. P.}
  \date{1913}

\begin{document}
\linenumbers
\maketitle
\section{Le coucher}
Longtemps, je me suis couché de bonne heure. Parfois, à peine ma bougie 
éteinte, mes yeux se fermaient si vite que je n'avais pas le temps de me 
dire : \og{}Je m'endors.\fg{} Et, une demi-heure après, la pensée qu'il 
était temps de chercher le sommeil m'éveillait\dots
\end{document}
```

Si vous souhaitez numéroter les lignes d'une partie du document seulement,
vous pouvez utiliser l'environnement `linenumbers` :

```{noedit}
\begin{linenumbers}
Longtemps, je me suis couché
de bonne heure...
\end{linenumbers}
```

Par défaut, la numérotation se poursuit tout le long du document, 
mais il est possible de la faire revenir à `1` à chaque nouvelle page, 
avec l'option `pagewise`. Voici d'ailleurs quelques autres options 
de l'extension :

- `left` pour afficher les numéros dans la marge de gauche (comportement
  par défaut) ;
- `right` pour afficher les numéros dans la marge de droite ;
- `switch` pour afficher les numéros dans la marge extérieure ;
- `modulo` pour numéroter toutes les cinq lignes.

La [documentation](texdoc:lineno) de <ctanpkg:lineno> propose 
de nombreuses autres options de configuration.

Si vous placez une étiquette dans votre document avec `\linelabel{ICI}`, 
vous pourrez faire référence à son **numéro de ligne** avec `\ref{ICI}`.

Il faut noter que cette fonctionnalité peut être étendue aux notes de bas 
de page avec l'extension <ctanpkg:fnlineno> :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lineno,fnlineno}

  \title{À la recherche\dots}
  \author{M. P.}
  \date{1913}

\begin{document}
\linenumbers
\section{Le coucher}
Longtemps, je me suis couché de bonne heure\footnote{Vers 18h ou 19h,
rarement plus tard sauf en cas d'impératif mondain.}.
Parfois, à peine ma bougie éteinte, mes yeux se fermaient
si vite que je n'avais pas le temps de me dire :
\og{}Je m'endors.\fg{} Et, une demi-heure après,
la pensée qu'il était temps de chercher le sommeil m'éveillait\dots
\end{document}
```


### Avec l'extension <ctanpkg:reledmac>

Les éditions critiques de textes font souvent appel à la numérotation 
des lignes de texte. Pour ce type de travaux, l'extension <ctanpkg:reledmac>
offre une solution complète. Cette extension remplace <ctanpkg:edmac> 
et <ctanpkg:ledmac>, devenues 
[obsolètes](/1_generalites/histoire/liste_des_packages_obsoletes).


### Avec l'extension <ctanpkg:vruler>

L'extension <ctanpkg:vruler> évite de nombreux problèmes associés 
à la numérotation des lignes, en permettant de placer sur les pages 
une règle rectangulaire contenant la numérotation. L'effet est tout à fait 
correct lorsqu'il est appliqué à un texte d'apparence uniforme, mais il reste 
médiocre dans les textes qui impliquent des ruptures telles que 
les mathématiques interpolées ou les figures.


### Avec l'extension <ctanpkg:numline>

:::{warning}
L’extension <ctanpkg:numline> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

L'extension <ctanpkg:numline>, à l'image de <ctanpkg:lineno>, retraite 
également la routine de sortie. L'utilisateur doit donc rester prudent.


## Dans du texte en mode verbatim

### Avec les extensions <ctanpkg:moreverb> ou <ctanpkg:fancyvrb>

Dans ce cas particulier, les extensions <ctanpkg:moreverb> 
ou <ctanpkg:fancyvrb>, dédiées au mode 
[verbatim](/4_domaines_specialises/sciences/informatique/verbatim/start), 
peuvent être utilisées. Chacune propose un environnement dédié 
et paramétrable :
- l'environnement `listing` de <ctanpkg:moreverb> demande 
  comme argument obligatoire le numéro de la première ligne numérotée ;
- le riche environnement `Verbatim` de <ctanpkg:fancyvrb> dispose 
  de l'option `numbers=left` pour activer la numérotation à gauche. L'option 
  `numbers=right` place la numérotation à droite.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{moreverb}
  \usepackage{fancyvrb}

\begin{document}
\section*{Le coucher (avec \textsf{moreverb})}
\begin{listing}{1}
Longtemps, je me suis couché de bonne heure. Parfois, à 
peine ma bougie éteinte, mes yeux se fermaient si vite 
que je n'avais pas le temps de me dire : « Je m'endors ». 
Et, une demi-heure après, la pensée qu'il était temps de
chercher le sommeil m'éveillait...  
\end{listing}

\section*{Le coucher (avec \textsf{fancyvrb})}
\begin{Verbatim}[numbers=left]
Longtemps, je me suis couché de bonne heure. Parfois, à 
peine ma bougie éteinte, mes yeux se fermaient si vite 
que je n'avais pas le temps de me dire : « Je m'endors ». 
Et, une demi-heure après, la pensée qu'il était temps de
chercher le sommeil m'éveillait...  
\end{Verbatim}
\end{document}
```

Ces exemples restent ici simples. Les extensions proposent bien 
plus de fonctionnalités.


:::{seealso}
Sur ce sujet, voir aussi 
"[](/4_domaines_specialises/sciences/informatique/verbatim/inclure_un_fichier_en_mode_verbatim)".
:::


### Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> fournit les fonctionnalités nécessaires 
avec l'environnement `boxedverbatim`. Cet environnement est paramétrable. 
L'exemple ci-dessous en illustre deux :
- `\linenumberfrequency{⟨nombre⟩}` qui indique le `⟨nombre⟩` 
  de lignes consécutives nécessaires pour qu'un numéro soit affiché 
  (avec la valeur `1`, chaque ligne est numérotée).
- `\nobvbox` qui indique de ne pas mettre de filet autour de l'environnement.


```
\documentclass[french]{memoir}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \linenumberfrequency{1}     % Numérotation de chaque ligne
      
\begin{document}
\section*{Le coucher}
\begin{boxedverbatim}
Longtemps, je me suis couché de bonne heure. Parfois, à 
peine ma bougie éteinte, mes yeux se fermaient si vite 
que je n'avais pas le temps de me dire : « Je m'endors ». 
\end{boxedverbatim}

\nobvbox % Pour retirer le filet autour de l'environnement
\begin{boxedverbatim}
Et, une demi-heure après, la pensée qu'il était temps de
chercher le sommeil m'éveillait...  
\end{boxedverbatim}
\end{document}
```


:::{sources}
- [Including line numbers in typeset output](faquk:FAQ-linenos)
:::