---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, lignes, soulignement, barrer du texte,
              souligner du texte, mettre du texte sur fond coloré
---

# Comment obtenir un soulignement de plusieurs lignes de texte ?

LaTeX n'a pas été pensé pour gérer par défaut le soulignement du texte. 
En effet, la mise en valeur de texte devrait typographiquement se faire plutôt
par l'usage de l'italique. Toutefois, une solution a été trouvée par certains
pour compenser cette absence de prise en charge : utiliser 
la commande mathématique `\underline`. Cette technique a cependant 
un gros défaut : le texte sera positionné dans une boîte, sans césure possible,
et débordera dans la marge. Qui plus est, la position du souligné 
n'est pas constante, selon que des lettres descendantes sont soulignées ou pas.
Voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  
\begin{document}
Je dois vous le dire : votre comportement typographique \underline{parfaitement
inconvenant} a surpris ! Nombreux sont ceux qui se sont même dit scandalisés
par ce soulignement qui dépasse les bornes.
\end{document}
```

Plusieurs extensions permettent de corriger ce point.


## Avec l'extension <ctanpkg:ulem>

L'extension <ctanpkg:ulem> définit la commande `\uline` pour souligner 
son argument ; le texte souligné ainsi produit se comporte 
comme un texte accentué ordinaire, et se coupera à la fin d'une ligne. Notez 
bien que la césure peut parfois ne pas fonctionner. Dans l'exemple ci-dessous,
elle est indiquée car, sans cela, le mot "inconvenant" n'aurait pas été coupé.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ulem}

\begin{document}
Je dois vous le dire : votre comportement typographique \emph{parfaitement
in\-convenant} a surpris ! Nombreux sont ceux qui se sont même dit scandalisés
par ce soulignement qui dépasse les bornes.
\end{document}
```

Notez ici un point : par défaut, l'extension <ctanpkg:ulem> 
convertit la commande `\emph` en commande de soulignement comme `\uline` ; 
cela peut être évité en chargeant l'extension avec :

```{noedit}
\usepackage[normalem]{ulem}
```

Par ailleurs, les commandes `\normalem` et `\ULforem` 
permettent de passer du mode `\emph` classique au mode `\emph` souligné. 
En mode souligné, la commande devient paramétrable pour changer le style
de soulignement ou biffer des mots.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ulem}

\begin{document}
\normalem Voici le mode \emph{emphasize} usuel.
\ULforem Voici le mode \emph{emphasize} souligné.

D'autres possibilités existent :
\begin{itemize}
   \item vagues : \uwave{texte} ;
   \item barré : \sout{texte} ;
   \item rayé : \xout{texte}.
\end{itemize}
\end{document}
```


## Avec l'extension <ctanpkg:soul>

L'extension <ctanpkg:soul> fournit la commande `\ul`. Ici, l'anomalie de césure
n'est pas ici présente.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{soul}

\begin{document}
Je dois vous le dire : votre comportement
typographique \ul{parfaitement inconvenant} a
surpris ! Nombreux sont ceux qui se sont même dit
scandalisés par ce soulignement qui dépasse les
bornes.
\end{document}
```

Si l'extension <ctanpkg:xcolor> est chargée, vous pouvez modifier la couleur 
du trait par `\setulcolor{⟨nom d'une couleur⟩}`. Bien entendu, la couleur 
ne sera, en général, *pas* visible avec un visualiseur de DVI 
mais elle sera bien dans le PS ou PDF produit. Vous pouvez régler 
d'autres aspects du soulignement à l'aide 
de `\setul{⟨profondeur⟩}{⟨épaisseur du trait⟩}`. La documentation 
de <ctanpkg:soul> fournit de nombreux exemples dont s'inspire celui-ci :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xcolor,soul}

  \definecolor{darkblue}{rgb}{0,0,0.5}
  \setulcolor{darkblue}
  \definecolor{bleuclair}{rgb}{.90,.95,1}
  \sethlcolor{bleuclair}

\begin{document}
Pour le bal des horreurs, voici venir :
\begin{itemize}
\item \ul{des soulignements ;}%
\setuldepth{a}%
\item \ul{des soulignements ;}%
\setuldepth{g}%
\item \ul{des soulignements ;}
\item \setul{}{.75ex}
\ul{des soulignements \emph{un peu trop épais ;}}
\item \setul{1.2ex}{.05ex}
\ul{des soulignements \emph{un peu trop bas.}} \\
\end{itemize}

On peut également surligner \hl{en bleu clair.} \\

On dispose aussi de petites capitales espacées :
\begin{itemize}
\item \textsc{Un exemple assez long} ;
\item \caps{Un exemple assez long}.
\end{itemize}
\end{document}
```

Notez que, jusqu'en février 2023, <ctanpkg:xcolor> et <ctanpkg:soul> 
présentaient une incomptabilité. Ce problème est résolu depuis lors mais, 
au cas où, l'ancienne solution est disponible sur 
[TeX Stack Exchange](https://tex.stackexchange.com/) à la question 
"[soul: broken highlighting with xcolor when using \selectcolormodel](https://tex.stackexchange.com/q/48501)". 


## Avec l'extension <ctanpkg:Lua-UL>

L'extension <ctanpkg:Lua-UL>, de Marcel Krüger, met à profit 
les nouvelles possibilités du moteur LuaTeX pour fournir des soulignements,
biffages, mises en évidence, etc., qui n'empêchent pas les ligatures, 
le crénage des caractères ou la césure.

Les commandes principales sont :

- `\underLine` pour le soulignement ;
- `\highLight` pour la mise en évidence (ne fonctionne que 
  si <ctanpkg:luacolor> est chargé) ;
- `\strikeThrough` pour biffer.

Par exemple :

```
%!TEX engine=lualatex
\documentclass[french]{article}
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lua-ul}

\begin{document}
Cette extension est \strikeThrough{inutile}\underLine{géniale}!
\end{document}
```

Cette extension permet une très grande personnalisation des signes de biffure 
et de soulignement (vous pouvez même souligner avec de petits dessins).

Elle propose un mode de compatibilité avec <ctanpkg:soul> : si la chargez 
avec l'option `soul`, vous pourrez utiliser les commandes `\ul` et `\ul`.

```
%!TEX engine=lualatex
\documentclass[french]{article}
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[soul]{lua-ul}

\begin{document}
Cette extension est \st{inutile}\ul{géniale}!
\end{document}
```


:::{sources}
- [Underlined text won't break](faquk:FAQ-underline)
- [soul: broken highlighting with xcolor when using \selectcolormodel](https://tex.stackexchange.com/q/48501),
  sur [TeX Stack Exchange](https://tex.stackexchange.com/)
:::