---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              notation des vecteurs, notation vectorielle, vecteur, flèches
---

# Comment obtenir la notation vectorielle ?

## Avec les commandes de base

La flèche marquant le vecteur est une des formes d'accentuation mathématique 
(mentionnées à la question 
"[](/4_domaines_specialises/mathematiques/structures/les_accents_en_mode_mathematique)")
connue de LaTeX. Elle s'obtient, comme le montre l'exemple suivant :
- avec la commande `\vec` lorsqu'elle concerne un unique caractère ;
- avec la commande `\overrightarrow` lorsqu'elle concerne plusieurs caractères.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Le vecteur $\vec{u}$ sera nommé $\overrightarrow{AB}$.
\end{document}
```


## Avec l'extension <ctanpkg:mathtools> 

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) permet de définir 
ses propres flèches notamment pour régler leur hauteur par rapport aux lettres
qu'elles surmontent. En voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage[matrix,arrow]{xy}

  \newcommand{\xyflecheverladroite}%
             {\mbox{\xymatrix{%
              *{\hphantom{OM}}\ar[]+L;[]+R%
             }}
  }

  \newcommand{\ra}[1]{%
    \mathchoice%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\displaystyle #1}}
       \ar[]+L;[]+R}}}{\displaystyle #1}%
       }%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\textstyle #1}}
       \ar[]+L;[]+R}}}{\textstyle #1}%
       }%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\scriptstyle #1}}
       \ar[]+L;[]+R}}}{\scriptstyle #1}%
       }%
      {\overset{\mbox{\xymatrix{%
       *{\hphantom{\scriptscriptstyle #1}}
       \ar[]+L;[]+R}}}{\scriptscriptstyle #1}%
       }%
  }

  % Pour changer la distance de la flèche,
  % on peut procéder ainsi :
  % \renewcommand{\ra}[1]
  % {\overset{\raisebox{-1pt}{\mbox{\xymatrix{*{%
  % \hphantom{#1}} \ar[]+L;[]+R}}}}{#1}}

\begin{document}
\[ 
  \ra{OM}  \neq \ra{OM_i}  \neq \ra{OM}_{\ra{OM}_{\ra{OM}}}
\]
\end{document}
```


## Avec l'extension <ctanpkg:vector>

L'extension <ctanpkg:vector>, de Nick Efford, offre notamment un certain nombre
de vecteurs utiles aux physiciens et des commandes automatiques d'énumération
des coordonnées. Par exemple :

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{vector}

\begin{document}
$(\irvec[4]x)$

$\bvec{y} = \left[ \cvec{y}{0}{3} \right]$
\end{document}
```

Notez que cette extension doit être installée manuellement (raison 
pour laquelle son résultat n'est pas affiché ici).


## Avec l'extension <ctanpkg:easyvector>

L'extension <ctanpkg:easyvector> permet de définir des vecteurs 
suivant une syntaxe de type langage C.