---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, styles,
              mode mathématique, mode mathématique hors texte, 
              équation hors texte, mathématiques dans un paragraphe, 
              mathématiques et lignes, limites d'intégrales, grands opérateurs,
              mode en-ligne, mode hors-texte, \mathchoice
---

# Quels sont les huit styles mathématiques ?

## Définition

TeX et LaTeX possède fondamentalement quatre styles mathématiques, nommés :

- `\displaystyle`,
- `\textstyle`,
- `\scriptstyle`
- et `\scriptscriptstyle`,

chacun décliné en deux versions : normale et tassée. 
Il ne faut pas confondre les styles avec les modes (en-ligne ou hors-texte) 
même si ceux-ci sont reliés : le style par défaut du mode hors-texte est 
`\displaystyle`, celui du mode en-ligne étant `\textstyle`.

Ces styles déterminent de nombreux éléments de composition mathématiques, 
comme la taille des symboles, leur espacement, et la place des indices 
et exposants. On peut à tout moment changer de style par les commandes 
ci-dessus, qui agissent jusqu'à la fin du groupe 
ou jusqu'au prochain changement de style.

On contrôle indépendamment le placement des "limites" avec `\limits` 
et `\nolimits`. Comparons ainsi plusieurs formes d'écriture d'une sommation :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}       % Définit la commande \resizebox

\begin{document}
\resizebox{6cm}{!}{
    $\sum_a^b$
    \begin{minipage}[b]{2.5ex}\[\sum_a^b\]\end{minipage}
    $\displaystyle \sum_a^b$
    $\displaystyle \sum\nolimits_a^b$
    $\sum\limits_a^b$
}
\end{document}
```

Pour accéder manuellement à la variante tassée, on utilise la commande 
`\cramped` de <ctanpkg:mathtools>, qui compose son argument en style tassé : 
cela change principalement la hauteur des indices et exposants. 
Il peut être utile de les compresser, par exemple pour préserver l'interlignage
dans un paragraphe. L'effet est assez subtil, mais clair en comparant 
`$2^{2^2}$` à `$\cramped{2^{2^2}}$` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\Huge  $2^{2^2} \cramped{2^{2^2}}$
\end{document}
```


## Création d'une commande mathématique adaptée au style

Lors de la définition d'une commande mathématique, vous pouvez prévoir 
des variantes selon de style mathématique courant avec la commande 
`\mathchoice`, qui prend quatre arguments, chacun correspondant 
à ce que la fonction restitue pour chacun des styles mathématiques : 
`\mathchoice{⟨élément displaystyle⟩}{⟨élément textstyle⟩}{⟨élément scriptstyle⟩}{⟨élément scriptscriptstyle⟩}`. 
Exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand\undemi{\mathchoice{\frac{1}{2}}{1 \div 2}{1/2}{0.5}}

\begin{document}
Notre fonction se comporte bien différemment selon qu'elle est utilisée 
en mode en-ligne le texte ($\undemi$) ou en mode hors texte (avec les 
variantes selon le niveau de mise en mise en indice/exposant):
\[ \left( \undemi \right)^{(\undemi)^{\undemi}}\]
\end{document}
```


:::{sources}
- [Les huit styles mathématiques](https://www.elzevir.fr/imj/latex/tips.html#mathstyles), 
  par Manuel Pégourié-Gonnard
:::