---
hide:
  - navigation
---

# Widgets

Welcome to the Textual widget gallery.

We have many more widgets planned, or you can [build your own](./guide/widgets.md).


!!! info

    Textual is a **TUI** framework. Everything below runs in the *terminal*.


## Button

A simple button with a variety of semantic styles.

[Button reference](./widgets/button.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/button.py"}
```


## Checkbox

A classic checkbox control.

[Checkbox reference](./widgets/checkbox.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/checkbox.py"}
```

## Collapsible

Content that may be toggled on and off by clicking a title.

[Collapsible reference](./widgets/collapsible.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/collapsible.py"}
```


## ContentSwitcher

A widget for containing and switching display between multiple child
widgets.

[ContentSwitcher reference](./widgets/content_switcher.md){ .md-button .md-button--primary }


## DataTable

A powerful data table, with configurable cursors.

[DataTable reference](./widgets/data_table.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/data_table.py"}
```

## Digits

Display numbers in tall characters.

[Digits reference](./widgets/digits.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/digits.py"}
```

## DirectoryTree

A tree view of files and folders.

[DirectoryTree reference](./widgets/directory_tree.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/directory_tree.py"}
```

## Footer

A footer to display and interact with key bindings.

[Footer reference](./widgets/footer.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/footer.py" columns="70" lines="12"}
```


## Header

A header to display the app's title and subtitle.


[Header reference](./widgets/header.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/header.py" columns="70" lines="12"}
```


## Input

A control to enter text.

[Input reference](./widgets/input.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/input.py" press="D,a,r,r,e,n"}
```


## Label

A simple text label.

[Label reference](./widgets/label.md){ .md-button .md-button--primary }


## ListView

Display a list of items (items may be other widgets).

[ListView reference](./widgets/list_view.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/list_view.py"}
```

## LoadingIndicator

Display an animation while data is loading.

[LoadingIndicator reference](./widgets/loading_indicator.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/loading_indicator.py"}
```

## Log

Display and update lines of text (such as from a file).

[Log reference](./widgets/log.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/log.py"}
```

## MarkdownViewer

Display and interact with a Markdown document (adds a table of contents and browser-like navigation to Markdown).

[MarkdownViewer reference](./widgets/markdown_viewer.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/markdown_viewer.py" columns="100" lines="42"}
```

## Markdown

Display a markdown document.

[Markdown reference](./widgets/markdown.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/markdown.py"}
```

## OptionList

Display a vertical list of options (options may be Rich renderables).

[OptionList reference](./widgets/option_list.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/option_list_options.py"}
```

## Placeholder

Display placeholder content while you are designing a UI.

[Placeholder reference](./widgets/placeholder.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/placeholder.py"}
```

## Pretty

Display a pretty-formatted Rich renderable.

[Pretty reference](./widgets/pretty.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/pretty.py"}
```

## ProgressBar

A configurable progress bar with ETA and percentage complete.

[ProgressBar reference](./widgets/progress_bar.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/progress_bar.py" press="5,0,tab,enter"}
```


## RadioButton

A simple radio button.

[RadioButton reference](./widgets/radiobutton.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/radio_button.py"}
```

## RadioSet

A collection of radio buttons, that enforces uniqueness.

[RadioSet reference](./widgets/radioset.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/radio_set.py"}
```

## RichLog

Display and update text in a scrolling panel.

[RichLog reference](./widgets/rich_log.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/rich_log.py" press="H,i"}
```

## Rule

A rule widget to separate content, similar to a `<hr>` HTML tag.

[Rule reference](./widgets/rule.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/horizontal_rules.py"}
```

## Select

Select from a number of possible options.

[Select reference](./widgets/select.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/select_widget.py" press="tab,enter,down,down"}
```

## SelectionList

Select multiple values from a list of options.

[SelectionList reference](./widgets/selection_list.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/selection_list_selections.py" press="down,down,down"}
```

## Sparkline

Display numerical data.

[Sparkline reference](./widgets/sparkline.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/sparkline.py" lines="11"}
```

## Static

Displays simple static content. Typically used as a base class.

[Static reference](./widgets/static.md){ .md-button .md-button--primary }


## Switch

An on / off control, inspired by toggle buttons.

[Switch reference](./widgets/switch.md){ .md-button .md-button--primary }


```{.textual path="docs/examples/widgets/switch.py"}
```

## Tabs

A row of tabs you can select with the mouse or navigate with keys.

[Tabs reference](./widgets/tabs.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/tabs.py" press="a,a,a,a,right,right"}
```

## TabbedContent

A Combination of Tabs and ContentSwitcher to navigate static content.

[TabbedContent reference](./widgets/tabbed_content.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/tabbed_content.py" press="j"}
```

## TextArea

A multi-line text area which supports syntax highlighting various languages.

[TextArea reference](./widgets/text_area.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/text_area_example.py" columns="42" lines="8"}
```

## Tree

A tree control with expandable nodes.

[Tree reference](./widgets/tree.md){ .md-button .md-button--primary }

```{.textual path="docs/examples/widgets/tree.py"}
```
