
COMP_OPTIONS := $(EXTRA_COMP_OPTIONS)
LINK_OPTIONS := $(EXTRA_LINK_OPTIONS)

ifdef PRETTY_PRINT
	COMP_OPTIONS += --pretty-print
	LINK_OPTIONS += --pretty-print
endif

ifdef NO_LINK_OPTIMIZATION
	LINK_OPTIONS += --no-factorization --no-strip
endif

PROGRAMS = hello calc

TARGETS = $(patsubst %,%.go,$(PROGRAMS))

TDC := theme-d-compile
TDL := theme-d-link

.PHONY : all clean

all : $(TARGETS)

clean :
	rm -f $(TARGETS) $(patsubst %,%.tcp,$(PROGRAMS))

$(TARGETS) : %.go : %.tcp
	$(TDL) $(LINK_OPTIONS) -m :.. -o $@ $<

%.tcp : %.thp
	$(TDC) $(COMP_OPTIONS) -m :.. -o $@ $<

# %.tci : %.thi
# 	$(TDC) -o $@ $<

# %.tcb : %.thb %.tci
# 	$(TDC) -o $@ $<
