
.PHONY : all clean

ifdef PRETTY_PRINT
	EXTRA_COMP_OPTIONS += --pretty-print
	EXTRA_LINK_OPTIONS += --pretty-print
endif

ifdef NO_LINK_OPTIMIZATION
	EXTRA_LINK_OPTIONS += --no-factorization --no-strip
endif

ifndef INSTALL_DIR
  INSTALL_DIR := /tmp
endif

MODULES := \
  sequence list-as-sequence vector-as-sequence sequence-sgn \
  sequence-list-impl sequence-vector-impl \
  assoc-sgn assoc-list-impl hash-table

PROGRAMS := hello-world sequence-test sequence-sgn-test \
  assoc-test assoc-test2 creators param-creators

INTERFACE_SRC := $(patsubst %,%.thi,$(MODULES))
BODY_SRC := $(patsubst %,%.thb,$(MODULES))
PROGRAM_SRC := $(patsubst %,%.thp,$(PROGRAMS))
INTERFACE_TARGET := $(patsubst %,%.tci,$(MODULES))
BODY_TARGET := $(patsubst %,%.tcb,$(MODULES))
COMP_PROGRAM_TARGET := $(patsubst %,%.tcp,$(PROGRAMS))
PROGRAM_TARGET := $(patsubst %,%.go,$(PROGRAMS))
PROGRAM_INTERMEDIATE := $(patsubst %,%.tree-il,$(PROGRAMS)) \
  $(patsubst %,%.scm,$(PROGRAMS))

ifndef LOCAL_MODE
	COMPILE := theme-d-compile
	LINK := theme-d-link
	MODULEPATH := -m :..
else
	COMPILE := GUILE_LOAD_PATH=../.. \
          ../../theme-d/translator/theme-d-compile.scm
	LINK := GUILE_LOAD_PATH=../.. \
          ../../theme-d/translator/theme-d-link.scm
	MODULEPATH := -m ..
endif

all : $(PROGRAM_TARGET) $(COMP_PROGRAM_TARGET) \
  $(INTERFACE_TARGET) $(BODY_TARGET)

clean :
	-rm -f $(INTERFACE_TARGET)
	-rm -f $(BODY_TARGET)
	-rm -f $(COMP_PROGRAM_TARGET)
	-rm -f $(PROGRAM_TARGET)
	-rm -f $(PROGRAM_INTERMEDIATE)

%.tcp : %.thp
	$(COMPILE) $(MODULEPATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

%.tci : %.thi
	$(COMPILE) $(MODULEPATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

%.tcb : %.thb
	$(COMPILE) $(MODULEPATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

$(PROGRAM_TARGET): %.go : %.tcp
	$(LINK) $(MODULEPATH) $(EXTRA_LINK_OPTIONS) -o $@ $<

# Compiled body depends on the compiled interface.
%.tcb : %.tci

list-as-sequence.tci : sequence.tci

list-as-sequence.tcb : sequence.tci

vector-as-sequence.tci : sequence.tci

vector-as-sequence.tcb : sequence.tci

sequence-test.tcp : sequence.tci sequence.tcb \
  list-as-sequence.tci list-as-sequence.tcb \
  vector-as-sequence.tci vector-as-sequence.tcb

sequence-sgn-test.tcp : sequence-sgn.tci sequence-sgn.tcb \
  sequence-list-impl.tci sequence-list-impl.tcb \
  sequence-vector-impl.tci sequence-vector-impl.tcb

assoc-test.tcp : assoc-sgn.tci assoc-list-impl.tci hash-table.tci

assoc-test.go : assoc-test.tcp assoc-sgn.tcb assoc-list-impl.tcb \
  hash-table.tcb

assoc-test2.tcp : assoc-sgn.tci hash-table.tci

assoc-test2.go : assoc-test.tcp assoc-sgn.tcb hash-table.tcb
