;; Copyright (C) 2008-2013 Tommi Höynälänmaa
;; Distributed under GNU General Public License version 3,
;; see file doc/GPL-3.


(library (theme-d translator theme-d-compiler)

  (export gl-show-info?
	  gl-show-indented-debug-info?
	  debug-level
	  parse-search-path
	  dw1
	  dwl1
	  theme-compile-unit
	  gl-compiler)
  
  (import (guile)
	  (rnrs exceptions)
	  (srfi srfi-1)
	  (srfi srfi-13)
	  (srfi srfi-43)
	  (th-scheme-utilities stdutils)
	  (th-scheme-utilities hrecord)
	  (theme-d common theme-d-config))


  ;; (add-to-load-path gl-theme-translator-dir)


  ;; forward declaration of a procedure
  (define translate-expr-fwd #f)


  (init-theme-d-config)
  
  (define gl-theme-d-translator-dir
    (get-theme-d-config-var 'translator-dir))

  
  (define (load-theme-file filename)
    (load-compiled (string-append gl-theme-d-translator-dir "/" filename ".go")))
  ;;  (load (string-append gl-theme-d-translator-dir "/" filename ".scm")))


  ;; *** Handling variable names ***

  (load-theme-file "theme-d-var-names")


  ;; *** Debug output ***

  (load-theme-file "theme-d-print-target-object")


  ;; *** Debugging ***

  (load-theme-file "theme-d-debug")


  ;; *** Common ***

  ;; (dwl4 "Common definitions")
  (load-theme-file "theme-d-common")


  ;; *** Support for hash tables ***

  ;; (dwl4 "Hash tables")
  (load-theme-file "theme-d-hash-tables")


  ;; *** Symbol table ***

					;(use-modules (general hrecord))
  ;; (dwl4 "Symbol table")
  (load-theme-file "theme-d-symbol-table")


  ;; *** Core definitions for compiling ***

  ;; (dwl4 "Compiler core def.")
  (load-theme-file "theme-d-compiler-core-def")


  ;; *** Entities ***

  ;; (dwl4 "Entities")
  (load-theme-file "theme-d-entities")


  ;; *** Expressions ***

  ;; (dwl4 "Expressions")
  (load-theme-file "theme-d-expressions")


  ;; *** Keywords ***

  ;; (dwl4 "Keywords")
  (load-theme-file "theme-d-keywords")


  ;; *** File handling ***

  ;; (dwl4 "File handling")
  (load-theme-file "theme-d-file-handling")


  ;; *** Macro system ***

  ;; (dwl4 "Macro system")
  (load-theme-file "theme-d-macro-config")
  (load-theme-file "theme-d-macros")


  ;; *** Common definitions for errors ***

  ;; (dwl4 "Common definitions for errors")
  (load-theme-file "theme-d-errors-common")


  ;; *** Compiler error output ***

  ;; (dwl4 "Compiler error output")
  (load-theme-file "theme-d-compilation-errors")


  ;; *** Representation of target objects ***

  ;; (dwl4 "Representation")
  (load-theme-file "theme-d-representation")


  ;; *** Parametrized instance cache ***

  ;; (dwl4 "Parametrized instance cache")
  (load-theme-file "theme-d-param-cache")


  ;; *** Binder ***

  ;; (dwl4 "Binder")
  (load-theme-file "theme-d-binder")


  ;; *** Address environment ***

  ;; (dwl4 "Address environment")
  (load-theme-file "theme-d-address-environment")


  ;; *** Type system ***

  ;; (dwl4 "Type system")
  (load-theme-file "theme-d-type-system")


  ;; *** Common utilities for procedures ***

  ;; (dwl4 "Common procedure utilities")
  (load-theme-file "theme-d-common-procedure-utilities")


  ;; *** Utilities for procedures ***

  ;; (dwl4 "Procedure utilities")
  (load-theme-file "theme-d-procedure-utilities")


  ;; *** Translation of type expressions ***

  ;; (dwl4 "Translation of type expressions")
  (load-theme-file "theme-d-type-translation")


  ;; *** Finalization of builtin types ***

  ;; (dwl4 "Finalization of builtin types")
  (load-theme-file "theme-d-builtin-type-finalization")


;;; *** Translation common ***

  ;; (dwl4 "Translation common")
  (load-theme-file "theme-d-translation-common")


  ;; *** Constructors ***

  ;; (dwl4 "Constructors")
  (load-theme-file "theme-d-constructors")


  ;; *** Parametrized definitions ***

  ;; (dwl4 "Parametrized definitions")
  (load-theme-file "theme-d-parametrized-definitions")


  ;; *** Parametrized instances ***

  ;; (dwl4 "Parametrized instances")
  (load-theme-file "theme-d-parametrized-instances")


  ;; *** Translation of expressions ***

  ;; (dwl4 "Translation of expressions")
  (load-theme-file "theme-d-expression-translation")


  ;; *** Compilation of letrec expressions ***

  ;; (dwl4 "Compilation of letrec expressions")
  (load-theme-file "theme-d-letrec-compilation")


  ;; *** Fields ***

  ;; (dwl4 "Fields")
  (load-theme-file "theme-d-fields")


  ;; *** Expression cloning ***

  ;; (dwl4 "Expression cloning")
  (load-theme-file "theme-d-expression-cloning")


  ;; *** Special procedures ***

  ;; (dwl4 "Special procedures")
  (load-theme-file "theme-d-special-procedures")


  ;; *** Pseudocode common ***

  ;; (dwl4 "Pseudocode common")
  (load-theme-file "theme-d-pcode-common")


  ;; *** Reading interface pseudocode ***

  ;; (dwl4 "Interface pseudocode reading")
  (load-theme-file "theme-d-interface-pcode-reading")


  ;; *** Translation utility functions***

  ;; (dwl4 "Translation utility functions")
  (load-theme-file "theme-d-translation-utilities")


  ;; *** Call with current continuation ***

  ;; (dwl4 "Call with current continuation")
  (load-theme-file "theme-d-call-cc")


  ;; *** Translation 1 ***

  ;; (dwl4 "Translation 1")
  (load-theme-file "theme-d-translation1")


  ;; *** Translation 2 ***

  ;; (dwl4 "Translation 2")
  (load-theme-file "theme-d-translation2")


  ;; *** Handling cyclic data structures ***

  ;; (dwl4 "Cycles")
  (load-theme-file "theme-d-cycles")


  ;; *** Phase 2 compilation ***

  ;; (dwl4 "Phase 2 comp")
  (load-theme-file "theme-d-phase2-compilation")


  ;; *** Unit compilation main function ***

  ;; (dwl4 "Unit compilation main function")
  (load-theme-file "theme-d-compile-unit")


  ;; *** Builtin definitions ***

  ;; (dwl4 "Builtins")
  (load-theme-file "theme-d-builtins"))
