# Build Metrics

**Build Metrics** is a catch-all term for performance measures that are
generated by the Firefox build system and tracked by Perfherder.

### num_constructors

Number of static constructors found by the compiler in the Firefox C++
codebase. Lower is better. Static constructors are undesirable because
their initialization imposes an unavoidable time penalty every time
Firefox is started.

### installer size

Size in bytes of the Firefox installer. Lower is better here, especially
on space-restricted platforms like Android.

### build times

Amount of time it takes to build Firefox in automation on a specific
platform / configuration. Lower is better.

### compiler warnings

Number of compiler warnings detected during a build. Lower is better.

Due to the way the build system works, compiler warnings are not
consistently detected. So the value may fluctuate from build to build
even if the number of compiler warnings didn\'t actually change. Since
Perfherder alerts are calculated based on the mean value of a range, a
regression may be reported as a fractional value.
