// This file is a part of toml++ and is subject to the the terms of the MIT license.
// Copyright (c) Mark Gillard <mark.gillard@outlook.com.au>
// See https://github.com/marzer/tomlplusplus/blob/master/LICENSE for the full license text.
// SPDX-License-Identifier: MIT
//-----
// this file was generated by generate_conformance_tests.py - do not modify it directly

#include "tests.h"

namespace
{
	static constexpr auto array_double_comma_1				= R"(array = [1,,2])"sv;
	static constexpr auto array_double_comma_2				= R"(array = [1,2,,])"sv;
	static constexpr auto array_extending_table				= R"(a = [{ b = 1 }]

# Cannot extend tables within static arrays
# https://github.com/toml-lang/toml/issues/908
[a.c]
foo = 1)"sv;
	static constexpr auto array_missing_separator			= R"(wrong = [ 1 2 3 ])"sv;
	static constexpr auto array_no_close_2					= R"(x = [42 #)"sv;
	static constexpr auto array_no_close_table_2			= R"(x = [{ key = 42 #)"sv;
	static constexpr auto array_no_close_table				= R"(x = [{ key = 42)"sv;
	static constexpr auto array_no_close					= R"(long_array = [ 1, 2, 3)"sv;
	static constexpr auto array_tables_1					= R"(# INVALID TOML DOC
fruit = []

[[fruit]] # Not allowed)"sv;
	static constexpr auto array_tables_2					= R"(# INVALID TOML DOC
[[fruit]]
  name = "apple"

  [[fruit.variety]]
    name = "red delicious"

  # This table conflicts with the previous table
  [fruit.variety]
    name = "granny smith")"sv;
	static constexpr auto array_text_after_array_entries	= R"(array = [
  "Is there life after an array separator?", No
  "Entry"
])"sv;
	static constexpr auto array_text_before_array_separator = R"(array = [
  "Is there life before an array separator?" No,
  "Entry"
])"sv;
	static constexpr auto array_text_in_array				= R"(array = [
  "Entry 1",
  I don't belong,
  "Entry 2",
])"sv;

	static constexpr auto bool_almost_false_with_extra = R"(a = falsify)"sv;
	static constexpr auto bool_almost_false			   = R"(a = fals)"sv;
	static constexpr auto bool_almost_true_with_extra  = R"(a = truthy)"sv;
	static constexpr auto bool_almost_true			   = R"(a = tru)"sv;
	static constexpr auto bool_just_f				   = R"(a = f)"sv;
	static constexpr auto bool_just_t				   = R"(a = t)"sv;
	static constexpr auto bool_mixed_case			   = R"(valid = False)"sv;
	static constexpr auto bool_starting_same_false	   = R"(a = falsey)"sv;
	static constexpr auto bool_starting_same_true	   = R"(a = truer)"sv;
	static constexpr auto bool_wrong_case_false		   = R"(b = FALSE)"sv;
	static constexpr auto bool_wrong_case_true		   = R"(a = TRUE)"sv;

	static constexpr auto control_bare_cr =
		"# The following line contains a single carriage return control character\r\n"
		"\r"sv;
	static constexpr auto control_bare_formfeed		= "bare-formfeed = \f"sv;
	static constexpr auto control_bare_null			= "bare-null = \"some value\" \x00"sv;
	static constexpr auto control_bare_vertical_tab = "bare-vertical-tab = \v"sv;
	static constexpr auto control_comment_cr		= "comment-cr = \"Carriage return in comment\" # \ra=1"sv;
	static constexpr auto control_comment_del		= "comment-del = \"0x7f\" # \x7F"sv;
	static constexpr auto control_comment_lf		= "comment-lf = \"ctrl-P\" # \x10"sv;
	static constexpr auto control_comment_null		= "comment-null = \"null\" # \x00"sv;
	static constexpr auto control_comment_us		= "comment-us = \"ctrl-_\" # \x1F"sv;
	static constexpr auto control_multi_del			= "multi-del = \"\"\"null\x7F\"\"\""sv;
	static constexpr auto control_multi_lf			= "multi-lf = \"\"\"null\x10\"\"\""sv;
	static constexpr auto control_multi_null		= "multi-null = \"\"\"null\x00\"\"\""sv;
	static constexpr auto control_multi_us			= "multi-us = \"\"\"null\x1F\"\"\""sv;
	static constexpr auto control_rawmulti_del		= "rawmulti-del = '''null\x7F'''"sv;
	static constexpr auto control_rawmulti_lf		= "rawmulti-lf = '''null\x10'''"sv;
	static constexpr auto control_rawmulti_null		= "rawmulti-null = '''null\x00'''"sv;
	static constexpr auto control_rawmulti_us		= "rawmulti-us = '''null\x1F'''"sv;
	static constexpr auto control_rawstring_del		= "rawstring-del = 'null\x7F'"sv;
	static constexpr auto control_rawstring_lf		= "rawstring-lf = 'null\x10'"sv;
	static constexpr auto control_rawstring_null	= "rawstring-null = 'null\x00'"sv;
	static constexpr auto control_rawstring_us		= "rawstring-us = 'null\x1F'"sv;
	static constexpr auto control_string_bs			= "string-bs = \"backspace\x08\""sv;
	static constexpr auto control_string_del		= "string-del = \"null\x7F\""sv;
	static constexpr auto control_string_lf			= "string-lf = \"null\x10\""sv;
	static constexpr auto control_string_null		= "string-null = \"null\x00\""sv;
	static constexpr auto control_string_us			= "string-us = \"null\x1F\""sv;

	static constexpr auto datetime_hour_over   = R"(# time-hour       = 2DIGIT  ; 00-23
d = 2006-01-01T24:00:00-00:00)"sv;
	static constexpr auto datetime_mday_over   = R"(# date-mday       = 2DIGIT  ; 01-28, 01-29, 01-30, 01-31 based on
#                           ; month/year
d = 2006-01-32T00:00:00-00:00)"sv;
	static constexpr auto datetime_mday_under  = R"(# date-mday       = 2DIGIT  ; 01-28, 01-29, 01-30, 01-31 based on
#                           ; month/year
d = 2006-01-00T00:00:00-00:00)"sv;
	static constexpr auto datetime_minute_over = R"(# time-minute     = 2DIGIT  ; 00-59
d = 2006-01-01T00:60:00-00:00)"sv;
	static constexpr auto datetime_month_over  = R"(# date-month      = 2DIGIT  ; 01-12
d = 2006-13-01T00:00:00-00:00)"sv;
	static constexpr auto datetime_month_under = R"(# date-month      = 2DIGIT  ; 01-12
d = 2007-00-01T00:00:00-00:00)"sv;
	static constexpr auto datetime_no_leads_with_milli = R"(# Day "5" instead of "05"; the leading zero is required.
with-milli = 1987-07-5T17:45:00.12Z)"sv;
	static constexpr auto datetime_no_leads			   = R"(# Month "7" instead of "07"; the leading zero is required.
no-leads = 1987-7-05T17:45:00Z)"sv;
	static constexpr auto datetime_no_t				   = R"(# No "t" or "T" between the date and time.
no-t = 1987-07-0517:45:00Z)"sv;
	static constexpr auto datetime_second_over =
		R"(# time-second     = 2DIGIT  ; 00-58, 00-59, 00-60 based on leap second
#                           ; rules
d = 2006-01-01T00:00:61-00:00)"sv;
	static constexpr auto datetime_time_no_leads_2 = R"(# Leading 0 is always required.
d = 01:32:0)"sv;
	static constexpr auto datetime_time_no_leads   = R"(# Leading 0 is always required.
d = 1:32:00)"sv;
	static constexpr auto datetime_trailing_t	   = R"(# Date cannot end with trailing T
d = 2006-01-30T)"sv;

#if !TOML_LANG_UNRELEASED

	static constexpr auto datetime_no_secs = R"(# No seconds in time.
no-secs = 1987-07-05T17:45Z)"sv;

#endif // !TOML_LANG_UNRELEASED

	static constexpr auto encoding_bad_utf8_at_end =
		"\x23\x20\x54\x68\x65\x72\x65\x20\x69\x73\x20\x61\x20\x30\x78\x64\x61\x20\x61\x74\x20\x61\x66\x74\x65"
		"\x72\x20\x74\x68\x65\x20\x71\x75\x6F\x74\x65\x73\x2C\x20\x61\x6E\x64\x20\x6E\x6F\x20\x45\x4F\x4C\x20"
		"\x61\x74\x20\x74\x68\x65\x20\x65\x6E\x64\x20\x6F\x66\x20\x74\x68\x65\x20\x66\x69\x6C\x65\x2E\x0A\x23"
		"\x0A\x23\x20\x54\x68\x69\x73\x20\x69\x73\x20\x61\x20\x62\x69\x74\x20\x6F\x66\x20\x61\x6E\x20\x65\x64"
		"\x67\x65\x20\x63\x61\x73\x65\x3A\x20\x54\x68\x69\x73\x20\x69\x6E\x64\x69\x63\x61\x74\x65\x73\x20\x74"
		"\x68\x65\x72\x65\x20\x73\x68\x6F\x75\x6C\x64\x20\x62\x65\x20\x74\x77\x6F\x20\x62\x79\x74\x65\x73\x0A"
		"\x23\x20\x28\x30\x62\x31\x31\x30\x31\x5F\x31\x30\x31\x30\x29\x20\x62\x75\x74\x20\x74\x68\x65\x72\x65"
		"\x20\x69\x73\x20\x6E\x6F\x20\x62\x79\x74\x65\x20\x74\x6F\x20\x66\x6F\x6C\x6C\x6F\x77\x20\x62\x65\x63"
		"\x61\x75\x73\x65\x20\x69\x74\x27\x73\x20\x74\x68\x65\x20\x65\x6E\x64\x20\x6F\x66\x20\x74\x68\x65\x20"
		"\x66\x69\x6C\x65\x2E\x0A\x78\x20\x3D\x20\x22\x22\x22\x22\x22\x22\xDA"sv;
	static constexpr auto encoding_bad_utf8_in_comment = "\x23\x20\xC3\x0A"sv;
	static constexpr auto encoding_bad_utf8_in_string =
		"\x23\x20\x54\x68\x65\x20\x66\x6F\x6C\x6C\x6F\x77\x69\x6E\x67\x20\x6C\x69\x6E\x65\x20\x63\x6F\x6E\x74"
		"\x61\x69\x6E\x73\x20\x61\x6E\x20\x69\x6E\x76\x61\x6C\x69\x64\x20\x55\x54\x46\x2D\x38\x20\x73\x65\x71"
		"\x75\x65\x6E\x63\x65\x2E\x0A\x62\x61\x64\x20\x3D\x20\x22\xC3\x22\x0A"sv;
	static constexpr auto encoding_bom_not_at_start_1 =
		"\x62\x6F\x6D\x2D\x6E\x6F\x74\x2D\x61\x74\x2D\x73\x74\x61\x72\x74\x20\xFF\xFD\x0A"sv;
	static constexpr auto encoding_bom_not_at_start_2 =
		"\x62\x6F\x6D\x2D\x6E\x6F\x74\x2D\x61\x74\x2D\x73\x74\x61\x72\x74\x3D\x20\xFF\xFD\x0A"sv;
	static constexpr auto encoding_utf16_bom =
		"\xFE\xFF\x00\x23\x00\x20\x00\x55\x00\x54\x00\x46\x00\x2D\x00\x31\x00\x36\x00\x20\x00\x77\x00\x69\x00"
		"\x74\x00\x68\x00\x20\x00\x42\x00\x4F\x00\x4D\x00\x0A"sv;
	static constexpr auto encoding_utf16 =
		"\x00#\x00 \x00U\x00T\x00F\x00-\x001\x006\x00 \x00w\x00i\x00t\x00h\x00o\x00u\x00t\x00 \x00B\x00O\x00M\x00"sv;

	static constexpr auto float_double_point_1		= R"(double-point-1 = 0..1)"sv;
	static constexpr auto float_double_point_2		= R"(double-point-2 = 0.1.2)"sv;
	static constexpr auto float_exp_double_e_1		= R"(exp-double-e-1 = 1ee2)"sv;
	static constexpr auto float_exp_double_e_2		= R"(exp-double-e-2 = 1e2e3)"sv;
	static constexpr auto float_exp_double_us		= R"(exp-double-us = 1e__23)"sv;
	static constexpr auto float_exp_leading_us		= R"(exp-leading-us = 1e_23)"sv;
	static constexpr auto float_exp_point_1			= R"(exp-point-1 = 1e2.3)"sv;
	static constexpr auto float_exp_point_2			= R"(exp-point-2 = 1.e2)"sv;
	static constexpr auto float_exp_trailing_us		= R"(exp-trailing-us = 1e_23_)"sv;
	static constexpr auto float_inf_incomplete_1	= R"(inf-incomplete-1 = in)"sv;
	static constexpr auto float_inf_incomplete_2	= R"(inf-incomplete-2 = +in)"sv;
	static constexpr auto float_inf_incomplete_3	= R"(inf-incomplete-3 = -in)"sv;
	static constexpr auto float_inf_underscore		= R"(inf_underscore = in_f)"sv;
	static constexpr auto float_leading_point_neg	= R"(leading-point-neg = -.12345)"sv;
	static constexpr auto float_leading_point_plus	= R"(leading-point-plus = +.12345)"sv;
	static constexpr auto float_leading_point		= R"(leading-point = .12345)"sv;
	static constexpr auto float_leading_us			= R"(leading-us = _1.2)"sv;
	static constexpr auto float_leading_zero_neg	= R"(leading-zero-neg = -03.14)"sv;
	static constexpr auto float_leading_zero_plus	= R"(leading-zero-plus = +03.14)"sv;
	static constexpr auto float_leading_zero		= R"(leading-zero = 03.14)"sv;
	static constexpr auto float_nan_incomplete_1	= R"(nan-incomplete-1 = na)"sv;
	static constexpr auto float_nan_incomplete_2	= R"(nan-incomplete-2 = +na)"sv;
	static constexpr auto float_nan_incomplete_3	= R"(nan-incomplete-3 = -na)"sv;
	static constexpr auto float_nan_underscore		= R"(nan_underscore = na_n)"sv;
	static constexpr auto float_trailing_point_min	= R"(trailing-point-min = -1.)"sv;
	static constexpr auto float_trailing_point_plus = R"(trailing-point-plus = +1.)"sv;
	static constexpr auto float_trailing_point		= R"(trailing-point = 1.)"sv;
	static constexpr auto float_trailing_us_exp		= R"(# trailing underscore in integer part is not allowed
trailing-us-exp = 1_e2
# trailing underscore in float part is not allowed
trailing-us-exp2 = 1.2_e2)"sv;
	static constexpr auto float_trailing_us			= R"(trailing-us = 1.2_)"sv;
	static constexpr auto float_us_after_point		= R"(us-after-point = 1._2)"sv;
	static constexpr auto float_us_before_point		= R"(us-before-point = 1_.2)"sv;

	static constexpr auto inline_table_add			 = R"(a={}
# Inline tables are immutable and can't be extended
[a.b])"sv;
	static constexpr auto inline_table_double_comma	 = R"(t = {x=3,,y=4})"sv;
	static constexpr auto inline_table_duplicate_key = R"(# Duplicate keys within an inline table are invalid
a={b=1, b=2})"sv;
	static constexpr auto inline_table_empty		 = R"(t = {,})"sv;
	static constexpr auto inline_table_no_comma		 = R"(t = {x = 3 y = 4})"sv;
	static constexpr auto inline_table_overwrite	 = R"(a.b=0
# Since table "a" is already defined, it can't be replaced by an inline table.
a={})"sv;

#if !TOML_LANG_UNRELEASED

	static constexpr auto inline_table_linebreak_1 =
		R"(# No newlines are allowed between the curly braces unless they are valid within
# a value.
simple = { a = 1 
})"sv;
	static constexpr auto inline_table_linebreak_2 = R"(t = {a=1,
b=2})"sv;
	static constexpr auto inline_table_linebreak_3 = R"(t = {a=1
,b=2})"sv;
	static constexpr auto inline_table_linebreak_4 = R"(json_like = {
          first = "Tom",
          last = "Preston-Werner"
})"sv;
	static constexpr auto inline_table_trailing_comma =
		R"(# A terminating comma (also called trailing comma) is not permitted after the
# last key/value pair in an inline table
abc = { abc = 123, })"sv;

#endif // !TOML_LANG_UNRELEASED

	static constexpr auto integer_capital_bin		  = R"(capital-bin = 0B0)"sv;
	static constexpr auto integer_capital_hex		  = R"(capital-hex = 0X1)"sv;
	static constexpr auto integer_capital_oct		  = R"(capital-oct = 0O0)"sv;
	static constexpr auto integer_double_sign_nex	  = R"(double-sign-nex = --99)"sv;
	static constexpr auto integer_double_sign_plus	  = R"(double-sign-plus = ++99)"sv;
	static constexpr auto integer_double_us			  = R"(double-us = 1__23)"sv;
	static constexpr auto integer_incomplete_bin	  = R"(incomplete-bin = 0b)"sv;
	static constexpr auto integer_incomplete_hex	  = R"(incomplete-hex = 0x)"sv;
	static constexpr auto integer_incomplete_oct	  = R"(incomplete-oct = 0o)"sv;
	static constexpr auto integer_invalid_bin		  = R"(invalid-bin = 0b0012)"sv;
	static constexpr auto integer_invalid_hex		  = R"(invalid-hex = 0xaafz)"sv;
	static constexpr auto integer_invalid_oct		  = R"(invalid-oct = 0o778)"sv;
	static constexpr auto integer_leading_us_bin	  = R"(leading-us-bin = _0o1)"sv;
	static constexpr auto integer_leading_us_hex	  = R"(leading-us-hex = _0o1)"sv;
	static constexpr auto integer_leading_us_oct	  = R"(leading-us-oct = _0o1)"sv;
	static constexpr auto integer_leading_us		  = R"(leading-us = _123)"sv;
	static constexpr auto integer_leading_zero_1	  = R"(leading-zero-1 = 01)"sv;
	static constexpr auto integer_leading_zero_2	  = R"(leading-zero-2 = 00)"sv;
	static constexpr auto integer_leading_zero_3	  = R"(leading-zero-3 = 0_0)"sv;
	static constexpr auto integer_leading_zero_sign_1 = R"(leading-zero-sign-1 = -01)"sv;
	static constexpr auto integer_leading_zero_sign_2 = R"(leading-zero-sign-2 = +01)"sv;
	static constexpr auto integer_leading_zero_sign_3 = R"(leading-zero-sign-3 = +0_1)"sv;
	static constexpr auto integer_negative_bin		  = R"(negative-bin = -0b11010110)"sv;
	static constexpr auto integer_negative_hex		  = R"(negative-hex = -0xff)"sv;
	static constexpr auto integer_negative_oct		  = R"(negative-oct = -0o99)"sv;
	static constexpr auto integer_positive_bin		  = R"(positive-bin = +0b11010110)"sv;
	static constexpr auto integer_positive_hex		  = R"(positive-hex = +0xff)"sv;
	static constexpr auto integer_positive_oct		  = R"(positive-oct = +0o99)"sv;
	static constexpr auto integer_text_after_integer  = R"(answer = 42 the ultimate answer?)"sv;
	static constexpr auto integer_trailing_us_bin	  = R"(trailing-us-bin = 0b1_)"sv;
	static constexpr auto integer_trailing_us_hex	  = R"(trailing-us-hex = 0x1_)"sv;
	static constexpr auto integer_trailing_us_oct	  = R"(trailing-us-oct = 0o1_)"sv;
	static constexpr auto integer_trailing_us		  = R"(trailing-us = 123_)"sv;
	static constexpr auto integer_us_after_bin		  = R"(us-after-bin = 0b_1)"sv;
	static constexpr auto integer_us_after_hex		  = R"(us-after-hex = 0x_1)"sv;
	static constexpr auto integer_us_after_oct		  = R"(us-after-oct = 0o_1)"sv;

	static constexpr auto key_after_array			 = R"([[agencies]] owner = "S Cjelli")"sv;
	static constexpr auto key_after_table			 = R"([error] this = "should not be here")"sv;
	static constexpr auto key_after_value			 = R"(first = "Tom" last = "Preston-Werner" # INVALID)"sv;
	static constexpr auto key_bare_invalid_character = R"(bare!key = 123)"sv;
	static constexpr auto key_dotted_redefine_table	 = R"(# Defined a.b as int
a.b = 1
# Tries to access it as table: error
a.b.c = 2)"sv;
	static constexpr auto key_duplicate_keys		 = R"(dupe = false
dupe = true)"sv;
	static constexpr auto key_duplicate				 = R"(# DO NOT DO THIS
name = "Tom"
name = "Pradyun")"sv;
	static constexpr auto key_empty					 = R"( = 1)"sv;
	static constexpr auto key_escape				 = R"(\u00c0 = "latin capital letter A with grave")"sv;
	static constexpr auto key_hash					 = R"(a# = 1)"sv;
	static constexpr auto key_multiline				 = R"("""long
key""" = 1)"sv;
	static constexpr auto key_newline				 = R"(barekey
   = 123)"sv;
	static constexpr auto key_no_eol				 = R"(a = 1 b = 2)"sv;
	static constexpr auto key_open_bracket			 = R"([abc = 1)"sv;
	static constexpr auto key_partial_quoted		 = R"(partial"quoted" = 5)"sv;
	static constexpr auto key_quoted_unclosed_1		 = R"("key = x)"sv;
	static constexpr auto key_quoted_unclosed_2		 = R"("key)"sv;
	static constexpr auto key_single_open_bracket	 = R"([)"sv;
	static constexpr auto key_space					 = R"(a b = 1)"sv;
	static constexpr auto key_start_bracket			 = R"([a]
[xyz = 5
[b])"sv;
	static constexpr auto key_start_dot				 = R"(.key = 1)"sv;
	static constexpr auto key_two_equals			 = R"(key= = 1)"sv;
	static constexpr auto key_two_equals2			 = R"(a==1)"sv;
	static constexpr auto key_two_equals3			 = R"(a=b=1)"sv;
	static constexpr auto key_without_value_1		 = R"(key)"sv;
	static constexpr auto key_without_value_2		 = R"(key = )"sv;
	static constexpr auto key_without_value_3		 = R"("key")"sv;
	static constexpr auto key_without_value_4		 = R"("key" = )"sv;

#if !TOML_LANG_UNRELEASED && UNICODE_LITERALS_OK

	static constexpr auto key_special_character = R"(μ = "greek small letter mu")"sv;

#endif // !TOML_LANG_UNRELEASED && UNICODE_LITERALS_OK

	static constexpr auto string_bad_byte_escape = R"(naughty = "\xAg")"sv;
	static constexpr auto string_bad_codepoint =
		R"(invalid-codepoint = "This string contains a non scalar unicode codepoint \uD801")"sv;
	static constexpr auto string_bad_concat	   = R"(no_concat = "first" "second")"sv;
	static constexpr auto string_bad_escape_1  = R"(invalid-escape = "This string has a bad \a escape character.")"sv;
	static constexpr auto string_bad_escape_2  = R"(invalid-escape = "This string has a bad \  escape character.")"sv;
	static constexpr auto string_bad_multiline = R"(multi = "first line
second line")"sv;
	static constexpr auto string_bad_slash_escape =
		R"(invalid-escape = "This string has a bad \/ escape character.")"sv;
	static constexpr auto string_bad_uni_esc_1								   = R"(str = "val\ue")"sv;
	static constexpr auto string_bad_uni_esc_2								   = R"(str = "val\Ux")"sv;
	static constexpr auto string_bad_uni_esc_3								   = R"(str = "val\U0000000")"sv;
	static constexpr auto string_bad_uni_esc_4								   = R"(str = "val\U0000")"sv;
	static constexpr auto string_bad_uni_esc_5								   = R"(str = "val\Ugggggggg")"sv;
	static constexpr auto string_basic_multiline_out_of_range_unicode_escape_1 = R"(a = """\UFFFFFFFF""")"sv;
	static constexpr auto string_basic_multiline_out_of_range_unicode_escape_2 = R"(a = """\U00D80000""")"sv;
	static constexpr auto string_basic_multiline_quotes = R"(str5 = """Here are three quotation marks: """.""")"sv;
	static constexpr auto string_basic_multiline_unknown_escape		 = R"(a = """\@""")"sv;
	static constexpr auto string_basic_out_of_range_unicode_escape_1 = R"(a = "\UFFFFFFFF")"sv;
	static constexpr auto string_basic_out_of_range_unicode_escape_2 = R"(a = "\U00D80000")"sv;
	static constexpr auto string_basic_unknown_escape				 = R"(a = "\@")"sv;
	static constexpr auto string_literal_multiline_quotes_1			 = R"(a = '''6 apostrophes: '''''')"sv;
	static constexpr auto string_literal_multiline_quotes_2			 = R"(a = '''15 apostrophes: '''''''''''''''''')"sv;
	static constexpr auto string_missing_quotes						 = R"(name = value)"sv;
	static constexpr auto string_multiline_bad_escape_1				 = R"(k = """t\a""")"sv;
	static constexpr auto string_multiline_bad_escape_2				 = R"(# \<Space> is not a valid escape.
k = """t\ t""")"sv;
	static constexpr auto string_multiline_bad_escape_3				 = R"(# \<Space> is not a valid escape.
k = """t\ """)"sv;
	static constexpr auto string_multiline_escape_space				 = R"(a = """
  foo \ \n
  bar""")"sv;
	static constexpr auto string_multiline_no_close_2				 = R"(x=""")"sv;
	static constexpr auto string_multiline_no_close					 = R"(invalid = """
    this will fail)"sv;
	static constexpr auto string_multiline_quotes_1					 = R"(a = """6 quotes: """""")"sv;
	static constexpr auto string_no_close							 = R"(no-ending-quote = "One time, at band camp)"sv;
	static constexpr auto string_text_after_string = R"(string = "Is there life after strings?" No.)"sv;
	static constexpr auto string_wrong_close	   = R"(bad-ending-quote = "double and single')"sv;

#if !TOML_LANG_UNRELEASED

	static constexpr auto string_basic_byte_escapes = R"(answer = "\x33")"sv;

#endif // !TOML_LANG_UNRELEASED

	static constexpr auto table_append_with_dotted_keys_1 = R"(# First a.b.c defines a table: a.b.c = {z=9}
#
# Then we define a.b.c.t = "str" to add a str to the above table, making it:
#
#   a.b.c = {z=9, t="..."}
#
# While this makes sense, logically, it was decided this is not valid TOML as
# it's too confusing/convoluted.
# 
# See: https://github.com/toml-lang/toml/issues/846
#      https://github.com/toml-lang/toml/pull/859

[a.b.c]
  z = 9

[a]
  b.c.t = "Using dotted keys to add to [a.b.c] after explicitly defining it above is not allowed")"sv;
	static constexpr auto table_append_with_dotted_keys_2 =
		R"(# This is the same issue as in injection-1.toml, except that nests one level
# deeper. See that file for a more complete description.

[a.b.c.d]
  z = 9

[a]
  b.c.d.k.t = "Using dotted keys to add to [a.b.c.d] after explicitly defining it above is not allowed")"sv;
	static constexpr auto table_array_empty = R"([[]]
name = "Born to Run")"sv;
	static constexpr auto table_array_implicit =
		R"(# This test is a bit tricky. It should fail because the first use of
# `[[albums.songs]]` without first declaring `albums` implies that `albums`
# must be a table. The alternative would be quite weird. Namely, it wouldn't
# comply with the TOML spec: "Each double-bracketed sub-table will belong to 
# the most *recently* defined table element *above* it."
#
# This is in contrast to the *valid* test, table-array-implicit where
# `[[albums.songs]]` works by itself, so long as `[[albums]]` isn't declared
# later. (Although, `[albums]` could be.)
[[albums.songs]]
name = "Glory Days"

[[albums]]
name = "Born in the USA")"sv;
	static constexpr auto table_array_missing_bracket		= R"([[albums]
name = "Born to Run")"sv;
	static constexpr auto table_duplicate_key_dotted_table	= R"([fruit]
apple.color = "red"

[fruit.apple] # INVALID)"sv;
	static constexpr auto table_duplicate_key_dotted_table2 = R"([fruit]
apple.taste.sweet = true

[fruit.apple.taste] # INVALID)"sv;
	static constexpr auto table_duplicate_key_table			= R"([fruit]
type = "apple"

[fruit.type]
apple = "yes")"sv;
	static constexpr auto table_duplicate_table_array		= R"([tbl]
[[tbl]])"sv;
	static constexpr auto table_duplicate_table_array2		= R"([[tbl]]
[tbl])"sv;
	static constexpr auto table_duplicate					= R"([a]
b = 1

[a]
c = 2)"sv;
	static constexpr auto table_empty_implicit_table		= R"([naughty..naughty])"sv;
	static constexpr auto table_empty						= R"([])"sv;
	static constexpr auto table_equals_sign					= R"([name=bad])"sv;
	static constexpr auto table_llbrace						= R"([ [table]])"sv;
	static constexpr auto table_nested_brackets_close		= R"([a]b]
zyx = 42)"sv;
	static constexpr auto table_nested_brackets_open		= R"([a[b]
zyx = 42)"sv;
	static constexpr auto table_quoted_no_close				= R"(["where will it end]
name = value)"sv;
	static constexpr auto table_redefine					= R"(# Define b as int, and try to use it as a table: error
[a]
b = 1

[a.b]
c = 2)"sv;
	static constexpr auto table_rrbrace						= R"([[table] ])"sv;
	static constexpr auto table_text_after_table			= R"([error] this shouldn't be here)"sv;
	static constexpr auto table_whitespace					= R"([invalid key])"sv;
	static constexpr auto table_with_pound					= R"([key#group]
answer = 42)"sv;
}

TEST_CASE("conformance - burntsushi/invalid")
{
	parsing_should_fail(FILE_LINE_ARGS, array_double_comma_1); // array-double-comma-1

	parsing_should_fail(FILE_LINE_ARGS, array_double_comma_2); // array-double-comma-2

	parsing_should_fail(FILE_LINE_ARGS, array_extending_table); // array-extending-table

	parsing_should_fail(FILE_LINE_ARGS, array_missing_separator); // array-missing-separator

	parsing_should_fail(FILE_LINE_ARGS, array_no_close_2); // array-no-close-2

	parsing_should_fail(FILE_LINE_ARGS, array_no_close_table_2); // array-no-close-table-2

	parsing_should_fail(FILE_LINE_ARGS, array_no_close_table); // array-no-close-table

	parsing_should_fail(FILE_LINE_ARGS, array_no_close); // array-no-close

	parsing_should_fail(FILE_LINE_ARGS, array_tables_1); // array-tables-1

	parsing_should_fail(FILE_LINE_ARGS, array_tables_2); // array-tables-2

	parsing_should_fail(FILE_LINE_ARGS, array_text_after_array_entries); // array-text-after-array-entries

	parsing_should_fail(FILE_LINE_ARGS, array_text_before_array_separator); // array-text-before-array-separator

	parsing_should_fail(FILE_LINE_ARGS, array_text_in_array); // array-text-in-array

	parsing_should_fail(FILE_LINE_ARGS, bool_almost_false_with_extra); // bool-almost-false-with-extra

	parsing_should_fail(FILE_LINE_ARGS, bool_almost_false); // bool-almost-false

	parsing_should_fail(FILE_LINE_ARGS, bool_almost_true_with_extra); // bool-almost-true-with-extra

	parsing_should_fail(FILE_LINE_ARGS, bool_almost_true); // bool-almost-true

	parsing_should_fail(FILE_LINE_ARGS, bool_just_f); // bool-just-f

	parsing_should_fail(FILE_LINE_ARGS, bool_just_t); // bool-just-t

	parsing_should_fail(FILE_LINE_ARGS, bool_mixed_case); // bool-mixed-case

	parsing_should_fail(FILE_LINE_ARGS, bool_starting_same_false); // bool-starting-same-false

	parsing_should_fail(FILE_LINE_ARGS, bool_starting_same_true); // bool-starting-same-true

	parsing_should_fail(FILE_LINE_ARGS, bool_wrong_case_false); // bool-wrong-case-false

	parsing_should_fail(FILE_LINE_ARGS, bool_wrong_case_true); // bool-wrong-case-true

	parsing_should_fail(FILE_LINE_ARGS, control_bare_cr); // control-bare-cr

	parsing_should_fail(FILE_LINE_ARGS, control_bare_formfeed); // control-bare-formfeed

	parsing_should_fail(FILE_LINE_ARGS, control_bare_null); // control-bare-null

	parsing_should_fail(FILE_LINE_ARGS, control_bare_vertical_tab); // control-bare-vertical-tab

	parsing_should_fail(FILE_LINE_ARGS, control_comment_cr); // control-comment-cr

	parsing_should_fail(FILE_LINE_ARGS, control_comment_del); // control-comment-del

	parsing_should_fail(FILE_LINE_ARGS, control_comment_lf); // control-comment-lf

	parsing_should_fail(FILE_LINE_ARGS, control_comment_null); // control-comment-null

	parsing_should_fail(FILE_LINE_ARGS, control_comment_us); // control-comment-us

	parsing_should_fail(FILE_LINE_ARGS, control_multi_del); // control-multi-del

	parsing_should_fail(FILE_LINE_ARGS, control_multi_lf); // control-multi-lf

	parsing_should_fail(FILE_LINE_ARGS, control_multi_null); // control-multi-null

	parsing_should_fail(FILE_LINE_ARGS, control_multi_us); // control-multi-us

	parsing_should_fail(FILE_LINE_ARGS, control_rawmulti_del); // control-rawmulti-del

	parsing_should_fail(FILE_LINE_ARGS, control_rawmulti_lf); // control-rawmulti-lf

	parsing_should_fail(FILE_LINE_ARGS, control_rawmulti_null); // control-rawmulti-null

	parsing_should_fail(FILE_LINE_ARGS, control_rawmulti_us); // control-rawmulti-us

	parsing_should_fail(FILE_LINE_ARGS, control_rawstring_del); // control-rawstring-del

	parsing_should_fail(FILE_LINE_ARGS, control_rawstring_lf); // control-rawstring-lf

	parsing_should_fail(FILE_LINE_ARGS, control_rawstring_null); // control-rawstring-null

	parsing_should_fail(FILE_LINE_ARGS, control_rawstring_us); // control-rawstring-us

	parsing_should_fail(FILE_LINE_ARGS, control_string_bs); // control-string-bs

	parsing_should_fail(FILE_LINE_ARGS, control_string_del); // control-string-del

	parsing_should_fail(FILE_LINE_ARGS, control_string_lf); // control-string-lf

	parsing_should_fail(FILE_LINE_ARGS, control_string_null); // control-string-null

	parsing_should_fail(FILE_LINE_ARGS, control_string_us); // control-string-us

	parsing_should_fail(FILE_LINE_ARGS, datetime_hour_over); // datetime-hour-over

	parsing_should_fail(FILE_LINE_ARGS, datetime_mday_over); // datetime-mday-over

	parsing_should_fail(FILE_LINE_ARGS, datetime_mday_under); // datetime-mday-under

	parsing_should_fail(FILE_LINE_ARGS, datetime_minute_over); // datetime-minute-over

	parsing_should_fail(FILE_LINE_ARGS, datetime_month_over); // datetime-month-over

	parsing_should_fail(FILE_LINE_ARGS, datetime_month_under); // datetime-month-under

	parsing_should_fail(FILE_LINE_ARGS, datetime_no_leads_with_milli); // datetime-no-leads-with-milli

	parsing_should_fail(FILE_LINE_ARGS, datetime_no_leads); // datetime-no-leads

	parsing_should_fail(FILE_LINE_ARGS, datetime_no_t); // datetime-no-t

	parsing_should_fail(FILE_LINE_ARGS, datetime_second_over); // datetime-second-over

	parsing_should_fail(FILE_LINE_ARGS, datetime_time_no_leads_2); // datetime-time-no-leads-2

	parsing_should_fail(FILE_LINE_ARGS, datetime_time_no_leads); // datetime-time-no-leads

	parsing_should_fail(FILE_LINE_ARGS, datetime_trailing_t); // datetime-trailing-t

#if !TOML_LANG_UNRELEASED

	parsing_should_fail(FILE_LINE_ARGS, datetime_no_secs); // datetime-no-secs

#endif // !TOML_LANG_UNRELEASED

	parsing_should_fail(FILE_LINE_ARGS, encoding_bad_utf8_at_end); // encoding-bad-utf8-at-end

	parsing_should_fail(FILE_LINE_ARGS, encoding_bad_utf8_in_comment); // encoding-bad-utf8-in-comment

	parsing_should_fail(FILE_LINE_ARGS, encoding_bad_utf8_in_string); // encoding-bad-utf8-in-string

	parsing_should_fail(FILE_LINE_ARGS, encoding_bom_not_at_start_1); // encoding-bom-not-at-start-1

	parsing_should_fail(FILE_LINE_ARGS, encoding_bom_not_at_start_2); // encoding-bom-not-at-start-2

	parsing_should_fail(FILE_LINE_ARGS, encoding_utf16_bom); // encoding-utf16-bom

	parsing_should_fail(FILE_LINE_ARGS, encoding_utf16); // encoding-utf16

	parsing_should_fail(FILE_LINE_ARGS, float_double_point_1); // float-double-point-1

	parsing_should_fail(FILE_LINE_ARGS, float_double_point_2); // float-double-point-2

	parsing_should_fail(FILE_LINE_ARGS, float_exp_double_e_1); // float-exp-double-e-1

	parsing_should_fail(FILE_LINE_ARGS, float_exp_double_e_2); // float-exp-double-e-2

	parsing_should_fail(FILE_LINE_ARGS, float_exp_double_us); // float-exp-double-us

	parsing_should_fail(FILE_LINE_ARGS, float_exp_leading_us); // float-exp-leading-us

	parsing_should_fail(FILE_LINE_ARGS, float_exp_point_1); // float-exp-point-1

	parsing_should_fail(FILE_LINE_ARGS, float_exp_point_2); // float-exp-point-2

	parsing_should_fail(FILE_LINE_ARGS, float_exp_trailing_us); // float-exp-trailing-us

	parsing_should_fail(FILE_LINE_ARGS, float_inf_incomplete_1); // float-inf-incomplete-1

	parsing_should_fail(FILE_LINE_ARGS, float_inf_incomplete_2); // float-inf-incomplete-2

	parsing_should_fail(FILE_LINE_ARGS, float_inf_incomplete_3); // float-inf-incomplete-3

	parsing_should_fail(FILE_LINE_ARGS, float_inf_underscore); // float-inf_underscore

	parsing_should_fail(FILE_LINE_ARGS, float_leading_point_neg); // float-leading-point-neg

	parsing_should_fail(FILE_LINE_ARGS, float_leading_point_plus); // float-leading-point-plus

	parsing_should_fail(FILE_LINE_ARGS, float_leading_point); // float-leading-point

	parsing_should_fail(FILE_LINE_ARGS, float_leading_us); // float-leading-us

	parsing_should_fail(FILE_LINE_ARGS, float_leading_zero_neg); // float-leading-zero-neg

	parsing_should_fail(FILE_LINE_ARGS, float_leading_zero_plus); // float-leading-zero-plus

	parsing_should_fail(FILE_LINE_ARGS, float_leading_zero); // float-leading-zero

	parsing_should_fail(FILE_LINE_ARGS, float_nan_incomplete_1); // float-nan-incomplete-1

	parsing_should_fail(FILE_LINE_ARGS, float_nan_incomplete_2); // float-nan-incomplete-2

	parsing_should_fail(FILE_LINE_ARGS, float_nan_incomplete_3); // float-nan-incomplete-3

	parsing_should_fail(FILE_LINE_ARGS, float_nan_underscore); // float-nan_underscore

	parsing_should_fail(FILE_LINE_ARGS, float_trailing_point_min); // float-trailing-point-min

	parsing_should_fail(FILE_LINE_ARGS, float_trailing_point_plus); // float-trailing-point-plus

	parsing_should_fail(FILE_LINE_ARGS, float_trailing_point); // float-trailing-point

	parsing_should_fail(FILE_LINE_ARGS, float_trailing_us_exp); // float-trailing-us-exp

	parsing_should_fail(FILE_LINE_ARGS, float_trailing_us); // float-trailing-us

	parsing_should_fail(FILE_LINE_ARGS, float_us_after_point); // float-us-after-point

	parsing_should_fail(FILE_LINE_ARGS, float_us_before_point); // float-us-before-point

	parsing_should_fail(FILE_LINE_ARGS, inline_table_add); // inline-table-add

	parsing_should_fail(FILE_LINE_ARGS, inline_table_double_comma); // inline-table-double-comma

	parsing_should_fail(FILE_LINE_ARGS, inline_table_duplicate_key); // inline-table-duplicate-key

	parsing_should_fail(FILE_LINE_ARGS, inline_table_empty); // inline-table-empty

	parsing_should_fail(FILE_LINE_ARGS, inline_table_no_comma); // inline-table-no-comma

	parsing_should_fail(FILE_LINE_ARGS, inline_table_overwrite); // inline-table-overwrite

#if !TOML_LANG_UNRELEASED

	parsing_should_fail(FILE_LINE_ARGS, inline_table_linebreak_1); // inline-table-linebreak-1

	parsing_should_fail(FILE_LINE_ARGS, inline_table_linebreak_2); // inline-table-linebreak-2

	parsing_should_fail(FILE_LINE_ARGS, inline_table_linebreak_3); // inline-table-linebreak-3

	parsing_should_fail(FILE_LINE_ARGS, inline_table_linebreak_4); // inline-table-linebreak-4

	parsing_should_fail(FILE_LINE_ARGS, inline_table_trailing_comma); // inline-table-trailing-comma

#endif // !TOML_LANG_UNRELEASED

	parsing_should_fail(FILE_LINE_ARGS, integer_capital_bin); // integer-capital-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_capital_hex); // integer-capital-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_capital_oct); // integer-capital-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_double_sign_nex); // integer-double-sign-nex

	parsing_should_fail(FILE_LINE_ARGS, integer_double_sign_plus); // integer-double-sign-plus

	parsing_should_fail(FILE_LINE_ARGS, integer_double_us); // integer-double-us

	parsing_should_fail(FILE_LINE_ARGS, integer_incomplete_bin); // integer-incomplete-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_incomplete_hex); // integer-incomplete-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_incomplete_oct); // integer-incomplete-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_invalid_bin); // integer-invalid-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_invalid_hex); // integer-invalid-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_invalid_oct); // integer-invalid-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_us_bin); // integer-leading-us-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_us_hex); // integer-leading-us-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_us_oct); // integer-leading-us-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_us); // integer-leading-us

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_zero_1); // integer-leading-zero-1

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_zero_2); // integer-leading-zero-2

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_zero_3); // integer-leading-zero-3

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_zero_sign_1); // integer-leading-zero-sign-1

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_zero_sign_2); // integer-leading-zero-sign-2

	parsing_should_fail(FILE_LINE_ARGS, integer_leading_zero_sign_3); // integer-leading-zero-sign-3

	parsing_should_fail(FILE_LINE_ARGS, integer_negative_bin); // integer-negative-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_negative_hex); // integer-negative-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_negative_oct); // integer-negative-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_positive_bin); // integer-positive-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_positive_hex); // integer-positive-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_positive_oct); // integer-positive-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_text_after_integer); // integer-text-after-integer

	parsing_should_fail(FILE_LINE_ARGS, integer_trailing_us_bin); // integer-trailing-us-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_trailing_us_hex); // integer-trailing-us-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_trailing_us_oct); // integer-trailing-us-oct

	parsing_should_fail(FILE_LINE_ARGS, integer_trailing_us); // integer-trailing-us

	parsing_should_fail(FILE_LINE_ARGS, integer_us_after_bin); // integer-us-after-bin

	parsing_should_fail(FILE_LINE_ARGS, integer_us_after_hex); // integer-us-after-hex

	parsing_should_fail(FILE_LINE_ARGS, integer_us_after_oct); // integer-us-after-oct

	parsing_should_fail(FILE_LINE_ARGS, key_after_array); // key-after-array

	parsing_should_fail(FILE_LINE_ARGS, key_after_table); // key-after-table

	parsing_should_fail(FILE_LINE_ARGS, key_after_value); // key-after-value

	parsing_should_fail(FILE_LINE_ARGS, key_bare_invalid_character); // key-bare-invalid-character

	parsing_should_fail(FILE_LINE_ARGS, key_dotted_redefine_table); // key-dotted-redefine-table

	parsing_should_fail(FILE_LINE_ARGS, key_duplicate_keys); // key-duplicate-keys

	parsing_should_fail(FILE_LINE_ARGS, key_duplicate); // key-duplicate

	parsing_should_fail(FILE_LINE_ARGS, key_empty); // key-empty

	parsing_should_fail(FILE_LINE_ARGS, key_escape); // key-escape

	parsing_should_fail(FILE_LINE_ARGS, key_hash); // key-hash

	parsing_should_fail(FILE_LINE_ARGS, key_multiline); // key-multiline

	parsing_should_fail(FILE_LINE_ARGS, key_newline); // key-newline

	parsing_should_fail(FILE_LINE_ARGS, key_no_eol); // key-no-eol

	parsing_should_fail(FILE_LINE_ARGS, key_open_bracket); // key-open-bracket

	parsing_should_fail(FILE_LINE_ARGS, key_partial_quoted); // key-partial-quoted

	parsing_should_fail(FILE_LINE_ARGS, key_quoted_unclosed_1); // key-quoted-unclosed-1

	parsing_should_fail(FILE_LINE_ARGS, key_quoted_unclosed_2); // key-quoted-unclosed-2

	parsing_should_fail(FILE_LINE_ARGS, key_single_open_bracket); // key-single-open-bracket

	parsing_should_fail(FILE_LINE_ARGS, key_space); // key-space

	parsing_should_fail(FILE_LINE_ARGS, key_start_bracket); // key-start-bracket

	parsing_should_fail(FILE_LINE_ARGS, key_start_dot); // key-start-dot

	parsing_should_fail(FILE_LINE_ARGS, key_two_equals); // key-two-equals

	parsing_should_fail(FILE_LINE_ARGS, key_two_equals2); // key-two-equals2

	parsing_should_fail(FILE_LINE_ARGS, key_two_equals3); // key-two-equals3

	parsing_should_fail(FILE_LINE_ARGS, key_without_value_1); // key-without-value-1

	parsing_should_fail(FILE_LINE_ARGS, key_without_value_2); // key-without-value-2

	parsing_should_fail(FILE_LINE_ARGS, key_without_value_3); // key-without-value-3

	parsing_should_fail(FILE_LINE_ARGS, key_without_value_4); // key-without-value-4

#if !TOML_LANG_UNRELEASED && UNICODE_LITERALS_OK

	parsing_should_fail(FILE_LINE_ARGS, key_special_character); // key-special-character

#endif // !TOML_LANG_UNRELEASED && UNICODE_LITERALS_OK

	parsing_should_fail(FILE_LINE_ARGS, string_bad_byte_escape); // string-bad-byte-escape

	parsing_should_fail(FILE_LINE_ARGS, string_bad_codepoint); // string-bad-codepoint

	parsing_should_fail(FILE_LINE_ARGS, string_bad_concat); // string-bad-concat

	parsing_should_fail(FILE_LINE_ARGS, string_bad_escape_1); // string-bad-escape-1

	parsing_should_fail(FILE_LINE_ARGS, string_bad_escape_2); // string-bad-escape-2

	parsing_should_fail(FILE_LINE_ARGS, string_bad_multiline); // string-bad-multiline

	parsing_should_fail(FILE_LINE_ARGS, string_bad_slash_escape); // string-bad-slash-escape

	parsing_should_fail(FILE_LINE_ARGS, string_bad_uni_esc_1); // string-bad-uni-esc-1

	parsing_should_fail(FILE_LINE_ARGS, string_bad_uni_esc_2); // string-bad-uni-esc-2

	parsing_should_fail(FILE_LINE_ARGS, string_bad_uni_esc_3); // string-bad-uni-esc-3

	parsing_should_fail(FILE_LINE_ARGS, string_bad_uni_esc_4); // string-bad-uni-esc-4

	parsing_should_fail(FILE_LINE_ARGS, string_bad_uni_esc_5); // string-bad-uni-esc-5

	parsing_should_fail(
		FILE_LINE_ARGS,
		string_basic_multiline_out_of_range_unicode_escape_1); // string-basic-multiline-out-of-range-unicode-escape-1

	parsing_should_fail(
		FILE_LINE_ARGS,
		string_basic_multiline_out_of_range_unicode_escape_2); // string-basic-multiline-out-of-range-unicode-escape-2

	parsing_should_fail(FILE_LINE_ARGS, string_basic_multiline_quotes); // string-basic-multiline-quotes

	parsing_should_fail(FILE_LINE_ARGS, string_basic_multiline_unknown_escape); // string-basic-multiline-unknown-escape

	parsing_should_fail(FILE_LINE_ARGS,
						string_basic_out_of_range_unicode_escape_1); // string-basic-out-of-range-unicode-escape-1

	parsing_should_fail(FILE_LINE_ARGS,
						string_basic_out_of_range_unicode_escape_2); // string-basic-out-of-range-unicode-escape-2

	parsing_should_fail(FILE_LINE_ARGS, string_basic_unknown_escape); // string-basic-unknown-escape

	parsing_should_fail(FILE_LINE_ARGS, string_literal_multiline_quotes_1); // string-literal-multiline-quotes-1

	parsing_should_fail(FILE_LINE_ARGS, string_literal_multiline_quotes_2); // string-literal-multiline-quotes-2

	parsing_should_fail(FILE_LINE_ARGS, string_missing_quotes); // string-missing-quotes

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_bad_escape_1); // string-multiline-bad-escape-1

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_bad_escape_2); // string-multiline-bad-escape-2

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_bad_escape_3); // string-multiline-bad-escape-3

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_escape_space); // string-multiline-escape-space

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_no_close_2); // string-multiline-no-close-2

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_no_close); // string-multiline-no-close

	parsing_should_fail(FILE_LINE_ARGS, string_multiline_quotes_1); // string-multiline-quotes-1

	parsing_should_fail(FILE_LINE_ARGS, string_no_close); // string-no-close

	parsing_should_fail(FILE_LINE_ARGS, string_text_after_string); // string-text-after-string

	parsing_should_fail(FILE_LINE_ARGS, string_wrong_close); // string-wrong-close

#if !TOML_LANG_UNRELEASED

	parsing_should_fail(FILE_LINE_ARGS, string_basic_byte_escapes); // string-basic-byte-escapes

#endif // !TOML_LANG_UNRELEASED

	parsing_should_fail(FILE_LINE_ARGS, table_append_with_dotted_keys_1); // table-append-with-dotted-keys-1

	parsing_should_fail(FILE_LINE_ARGS, table_append_with_dotted_keys_2); // table-append-with-dotted-keys-2

	parsing_should_fail(FILE_LINE_ARGS, table_array_empty); // table-array-empty

	parsing_should_fail(FILE_LINE_ARGS, table_array_implicit); // table-array-implicit

	parsing_should_fail(FILE_LINE_ARGS, table_array_missing_bracket); // table-array-missing-bracket

	parsing_should_fail(FILE_LINE_ARGS, table_duplicate_key_dotted_table); // table-duplicate-key-dotted-table

	parsing_should_fail(FILE_LINE_ARGS, table_duplicate_key_dotted_table2); // table-duplicate-key-dotted-table2

	parsing_should_fail(FILE_LINE_ARGS, table_duplicate_key_table); // table-duplicate-key-table

	parsing_should_fail(FILE_LINE_ARGS, table_duplicate_table_array); // table-duplicate-table-array

	parsing_should_fail(FILE_LINE_ARGS, table_duplicate_table_array2); // table-duplicate-table-array2

	parsing_should_fail(FILE_LINE_ARGS, table_duplicate); // table-duplicate

	parsing_should_fail(FILE_LINE_ARGS, table_empty_implicit_table); // table-empty-implicit-table

	parsing_should_fail(FILE_LINE_ARGS, table_empty); // table-empty

	parsing_should_fail(FILE_LINE_ARGS, table_equals_sign); // table-equals-sign

	parsing_should_fail(FILE_LINE_ARGS, table_llbrace); // table-llbrace

	parsing_should_fail(FILE_LINE_ARGS, table_nested_brackets_close); // table-nested-brackets-close

	parsing_should_fail(FILE_LINE_ARGS, table_nested_brackets_open); // table-nested-brackets-open

	parsing_should_fail(FILE_LINE_ARGS, table_quoted_no_close); // table-quoted-no-close

	parsing_should_fail(FILE_LINE_ARGS, table_redefine); // table-redefine

	parsing_should_fail(FILE_LINE_ARGS, table_rrbrace); // table-rrbrace

	parsing_should_fail(FILE_LINE_ARGS, table_text_after_table); // table-text-after-table

	parsing_should_fail(FILE_LINE_ARGS, table_whitespace); // table-whitespace

	parsing_should_fail(FILE_LINE_ARGS, table_with_pound); // table-with-pound
}
